<?php
class CronController extends Controller
{

	public function __construct()
	{
		$model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        $this->PointsProgram=new PointsProgram();
        
        $this->InventoryWrapper=new InventoryWrapper();

        $website_timezone=$this->functions->getOptionAdmin('website_timezone');
        if (!empty($website_timezone)){
            date_default_timezone_set($website_timezone);
        }

        $this->CustomerNotification=new CustomerNotification();
        $this->OrderWrapper=new OrderWrapper();
	}
	
	public function index()
	{
    echo 'cron is working';

		
	}


   public function trigger_order()
{
    if (1 == 1):

        $sitename = $this->functions->getOptionAdmin('website_title'); 
        $siteurl = $this->functions->websiteUrl();
        $pattern = array('order_id','customer_name','restaurant_name','total_amount','order_details');

        $stmt = "
        SELECT a.trigger_id, a.trigger_type, a.order_id, a.order_status as template_type,
        a.remarks as trigger_remarks, a.language, a.status as status_trigger,
        b.merchant_id,b.customer_name, b.profile_customer_name, b.restaurant_name,
        FORMAT(b.total_amount,2) as total_amount

        FROM mt_merchantapp_order_trigger a    
        LEFT JOIN mt_view_order b
        ON a.order_id = b.order_id
                
        WHERE a.status='pending'
        AND trigger_type IN ('order','auto_order_update','driver_update_to_merchant')
        LIMIT 0,10
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $trigger_id = $val['trigger_id'];  
                $status_trigger = 'process';
                $template_type = trim($val['template_type']);               

                try {
                    $tpl = $this->CustomerNotification->getNotificationTemplate($template_type, $val['language'], 'push', false); 
                    $push_title = $tpl['push_title']; 
                    $push_content = $tpl['push_content']; 

                    foreach ($pattern as $key_pattern => $pattern_val) {
                        if ($pattern_val == "total_amount") {                           
                            $data[$pattern_val] = isset($val[$pattern_val]) ? $this->functions->normalPrettyPrice($val[$pattern_val]) : '';
                        } else {
                            $data[$pattern_val] = isset($val[$pattern_val]) ? $val[$pattern_val] : '';
                        }
                    }

                    $data['sitename'] = $sitename;                    
                    $data['siteurl'] = $siteurl;

                    $push_title = $this->functions->replaceTags($push_title, $data);
                    $push_content = $this->functions->replaceTags($push_content, $data);  

                    $params = array(
                        'merchant_id'   => (int)$val['merchant_id'],
                        'merchant_name' => $val['restaurant_name'],
                        'order_id'      => $val['order_id'],
                        'push_title'    => $push_title,
                        'push_message'  => $push_content,
                        'topics'        => 'new_order_' . $val['merchant_id'],
                        'date_created'  => $this->functions->dateNow(),
                        'ip_address'    => $_SERVER['REMOTE_ADDR'],
                        'trigger_type'  => $val['trigger_type']
                    );

                    $this->functions->insertData("mt_merchantapp_broadcast", $params);   

                } catch (Exception $e) {
                    $status_trigger = $e->getMessage();
                }

                $params_update = array(
                    'status'        => $status_trigger,
                    'date_process'  => $this->functions->dateNow(),
                    'ip_address'    => $_SERVER['REMOTE_ADDR']
                );

                $this->functions->updateData("mt_merchantapp_order_trigger", $params_update, 'trigger_id', $trigger_id);
            }

            $this->processbroadcast();
        }

    endif;
}


public function trigger_order_booking()
{
    if (1 == 1):

        $sitename = $this->functions->getOptionAdmin('website_title'); 
        $siteurl = $this->functions->websiteUrl();

        $pattern = array(
            'booking_id', 'restaurant_name', 'number_guest', 'date_booking',
            'time', 'customer_name', 'email', 'mobile', 'instruction', 'status'
        );

        $data = array();

        $stmt = "
        SELECT a.trigger_id, a.trigger_type, a.order_id, a.order_status as template_type,
        a.remarks as trigger_remarks, a.language, a.status as status_trigger,
        b.booking_id, b.merchant_id, b.number_guest, b.date_booking , b.booking_time as time,
        b.booking_name as customer_name, b.email , b.mobile, b.booking_notes as instruction,
        b.status,
        c.restaurant_name 
        
        FROM mt_merchantapp_order_trigger a    
        LEFT JOIN mt_bookingtable b ON a.order_id = b.booking_id
        LEFT JOIN mt_merchant c ON b.merchant_id = c.merchant_id
                
        WHERE a.status='pending'
        AND trigger_type='booking'
        LIMIT 0,10
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $trigger_id = $val['trigger_id'];
                $status_trigger = 'process';
                $template_type = trim($val['template_type']);

                try {
                    $tpl = $this->CustomerNotification->getNotificationTemplate(
                        $template_type,
                        $val['language'],
                        'push',
                        false
                    );

                    $push_title = $tpl['push_title'];
                    $push_content = $tpl['push_content'];

                    foreach ($pattern as $pattern_val) {
                        $data[$pattern_val] = isset($val[$pattern_val]) ? $val[$pattern_val] : '';
                    }

                    $data['sitename'] = $sitename;
                    $data['siteurl'] = $siteurl;

                    $push_title = $this->functions->replaceTags($push_title, $data);
                    $push_content = $this->functions->replaceTags($push_content, $data);

                    $params = array(
                        'merchant_id'   => isset($val['merchant_id']) ? (int)$val['merchant_id'] : 0,
                        'merchant_name' => isset($val['restaurant_name']) ? $val['restaurant_name'] : '',
                        'booking_id'    => isset($val['booking_id']) ? (int)$val['booking_id'] : 0,
                        'push_title'    => $push_title,
                        'push_message'  => $push_content,
                        'topics'        => 'new_order_' . $val['merchant_id'],
                        'date_created'  => $this->functions->dateNow(),
                        'ip_address'    => $_SERVER['REMOTE_ADDR'],
                        'trigger_type'  => 'booking'
                    );

                    $this->functions->insertData("mt_merchantapp_broadcast", $params);
                } catch (Exception $e) {
                    $status_trigger = $e->getMessage();
                }

                $params_update = array(
                    'status'        => $status_trigger,
                    'date_process'  => $this->functions->dateNow(),
                    'ip_address'    => $_SERVER['REMOTE_ADDR']
                );

                $this->functions->updateData("mt_merchantapp_order_trigger", $params_update, 'trigger_id', $trigger_id);
            }

            $this->processbroadcast();
        }

    endif;
}


public function processpush()
{
    if (1 == 1):

        $stmt = "
        SELECT a.*,
        (
         SELECT option_value
         FROM mt_option
         WHERE option_name = 'merchantapp_services_account_json'
         LIMIT 0,1
        ) as services_account_json

        FROM mt_merchantapp_push_logs a
        WHERE a.status='pending'        
        ORDER BY id ASC     
        LIMIT 0,10
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $file = $this->functions->uploadPath() . "/" . $res[0]['services_account_json'];
            //$serviceAccount = json_decode(file_get_contents($file), true);
			 $serviceAccount = $this->functions->readJsonFile($file);
			
			
            $projectId = $serviceAccount['project_id'];

            foreach ($res as $val) {
                $process_status = '';
                $json_response = '';
                $process_date = $this->functions->dateNow();
                $device_id = trim($val['device_id']);

                try {
                    $data = [
                        'target'       => $val['device_id'],
                        'title'        => $val['push_title'],
                        'body'         => $val['push_message'],
                        'channel'      => 'merchantapp_channel',
                        'sound'        => 'neworder',
                        'apple_sound'  => 'neworder.mp3',
                        'projectId'    => $projectId
                    ];
                    $json_response = $this->functions->sendFCMNotification($data, $serviceAccount, 'push');
                    $process_status = 'process';
                } catch (Exception $e) {
                    $process_status = 'failed';
                    $json_response = $e->getMessage();
                }

                if (!empty($process_status)) {
                    $process_status = substr(strip_tags($process_status), 0, 255);
                } else {
                    $process_status = 'failed';
                }

                if (is_array($json_response) && count($json_response) >= 1) {
                    $json_response = json_encode($json_response);
                }

                $params = array(
                    'status'        => $process_status,
                    'date_process'  => $process_date,
                    'json_response' => $json_response
                );

                $this->functions->updateData("mt_merchantapp_push_logs", $params, 'id', $val['id']);
            }
        }

    endif;
}



public function processbroadcast()
{
    if (1 == 1):

         $stmt = "
        SELECT a.*,
        (
         SELECT option_value
         FROM mt_option
         WHERE option_name = 'merchantapp_services_account_json'
         LIMIT 0,1
        ) as services_account_json

        FROM mt_merchantapp_broadcast a
        WHERE a.status='pending'        
        ORDER BY broadcast_id ASC       
        LIMIT 0,10
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
             $file = $this->functions->uploadPath() . "/" . $res[0]['services_account_json'];
			 
			 
			   $serviceAccount = $this->functions->readJsonFile($file);
			 
			 

			
             $projectId = $serviceAccount['project_id'];
		
            foreach ($res as $val) {
                $process_status = '';
                $json_response = '';
                $process_date = $this->functions->dateNow();
                $trigger_type = isset($val['trigger_type']) ? $val['trigger_type'] : '';
                $order_id = isset($val['order_id']) ? (integer)$val['order_id'] : '';
          
                try {
                    $data = [
					'target'=>$val['topics'],
                        'title'        =>$val['push_title'],
                        'body'         =>$val['push_message'],
                        'channel'      =>'merchantapp_channel',
                        'sound'        =>'neworder',
                        'apple_sound'  =>'neworder.mp3',
                        'projectId'    =>$projectId,
                        'type' =>$trigger_type,
                        'notification_id'     =>$order_id
                    ];
					
					   

                    $json_response = $this->functions->sendFCMNotification($data, $serviceAccount, "broadcast");
                    $process_status = 'process';
                } catch (Exception $e) {
                    $process_status = 'failed';
                    $json_response = $e->getMessage();
                }

                if (!empty($process_status)) {
                    $process_status = substr(strip_tags($process_status), 0, 255);
                } else {
                    $process_status = 'failed';
                }

                if (is_array($json_response) && count($json_response) >= 1) {
                    $json_response = json_encode($json_response);
                }

                $params = array(
                    'status'         => $process_status,
                    'date_modified'  => $process_date,
                    'fcm_response'   => $json_response
                );

                $this->functions->updateData("mt_merchantapp_broadcast", $params, 'broadcast_id', $val['broadcast_id']);
            }
        }

    endif;
}



public function unattented_order()
{       
    if (1 == 1):

        $and = ''; 
        $lang = "en";
        $pattern = array('order_id','customer_name','restaurant_name','total_amount');

        $order_unattended_minutes = (integer)$this->functions->getOptionAdmin('order_unattended_minutes');
        if ($order_unattended_minutes <= 0) {
            $order_unattended_minutes = 5;
        }

        $number_of_alert = $this->functions->getOptionAdmin('number_of_alert');

        $interval_date = date("Y-m-d H:i:s", strtotime("+$order_unattended_minutes minutes"));
        $todays_date = date("Y-m-d");

        $end = date("Y-m-d H:i:s");
        $start = date("Y-m-d H:i:s", strtotime("-$order_unattended_minutes minutes"));

        $stats = $this->OrderWrapper->getStatusFromSettings('order_incoming_status', array('pending','paid'));

        $and .= " AND a.status IN ($stats)
        AND a.request_cancel='2' ";

        $and .= " AND CAST(a.date_created as DATE) BETWEEN '$todays_date' AND '$todays_date' ";
        $and .= " AND '$interval_date' > a.date_created ";

        $and .= " AND a.order_id NOT IN (
          SELECT order_id FROM
          mt_merchantapp_broadcast
          WHERE order_id = a.order_id
          AND date_created BETWEEN '$start' AND '$end'
        )";

        $tpl = $this->CustomerNotification->getNotificationTemplate('receipt_send_to_merchant', $lang, 'push', false);
        $push_title = isset($tpl['push_title']) ? $tpl['push_title'] : ''; 
        $push_content = isset($tpl['push_content']) ? $tpl['push_content'] : '';

        $stmt = "
        SELECT a.*
        FROM mt_view_order a
        WHERE 1
        $and
        LIMIT 0,50
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $data = array();
                foreach ($pattern as $pattern_val) {
                    $data[$pattern_val] = isset($val[$pattern_val]) ? $val[$pattern_val] : '';
                }

                $push_title_filled = $this->functions->replaceTags($push_title, $data);
                $push_content_filled = $this->functions->replaceTags($push_content, $data);

                $params = array(
                    'merchant_id'   => (integer)$val['merchant_id'],
                    'merchant_name' => $val['restaurant_name'],
                    'order_id'      => (integer)$val['order_id'],
                    'push_title'    => $push_title_filled,
                    'push_message'  => $push_content_filled,
                    'topics'        => 'new_order_' . $val['merchant_id'],
                    'date_created'  => $this->functions->dateNow(),
                    'ip_address'    => $_SERVER['REMOTE_ADDR'],
                );

                if ($number_of_alert > 0) {
                    $stmtc = "SELECT COUNT(*) as total
                    FROM mt_merchantapp_broadcast
                    WHERE order_id = :order_id
                    ";
                    $queryc = $this->db->prepare($stmtc);
                    $queryc->execute([':order_id' => $val['order_id']]);
                    $resc = $queryc->fetch(PDO::FETCH_ASSOC);
                    if ($resc && $resc['total'] > $number_of_alert) {
                        continue;
                    }
                }

                $this->functions->insertData("mt_merchantapp_broadcast", $params);
            }

            $this->processbroadcast();
        }

    endif;
}



public function unattented_booking()
{
    if (1 == 1):

        $and = ''; 
        $lang = "en";
        $pattern = array(
            'booking_id','restaurant_name','number_guest','date_booking',
            'time','customer_name','email','mobile','instruction','status'
        );

        $unattended_minutes = (integer)$this->functions->getOptionAdmin('booking_incoming_unattended_minutes');
        if ($unattended_minutes <= 0) {
            $unattended_minutes = 5;
        }

        $interval_date = date("Y-m-d H:i:s", strtotime("+$unattended_minutes minutes"));
        $todays_date = date("Y-m-d");

        $end = date("Y-m-d H:i:s");
        $start = date("Y-m-d H:i:s", strtotime("-$unattended_minutes minutes"));

        $and .= " AND a.status IN ('pending')
        AND a.request_cancel='0' ";

        $and .= " AND CAST(a.date_created as DATE) BETWEEN '$todays_date' AND '$todays_date' ";
        $and .= " AND '$interval_date' > a.date_created ";

        $and .= " AND a.booking_id NOT IN (
          SELECT booking_id FROM
          mt_merchantapp_broadcast
          WHERE booking_id = a.booking_id
          AND date_created BETWEEN '$start' AND '$end'
        )";

        $tpl = $this->CustomerNotification->getNotificationTemplate('booked_notify_merchant', $lang, 'push', false);
        $push_title = isset($tpl['push_title']) ? $tpl['push_title'] : '';
        $push_content = isset($tpl['push_content']) ? $tpl['push_content'] : '';

        $stmt = "
        SELECT 
        a.booking_id, a.merchant_id, a.client_id, a.number_guest, a.date_booking,
        a.date_booking as date_booking_raw, a.booking_time as booking_time_raw,
        a.booking_time, a.booking_name, a.email, a.mobile, a.booking_notes,
        a.date_created, a.date_created as date_created_raw, a.status, a.status as status_raw,
        c.restaurant_name 
        FROM mt_bookingtable a
        LEFT JOIN mt_merchant c
        ON a.merchant_id = c.merchant_id
        WHERE 1
        $and
        LIMIT 0,50
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $data = array();
                foreach ($pattern as $pattern_val) {
                    $data[$pattern_val] = isset($val[$pattern_val]) ? $val[$pattern_val] : '';
                }

                $push_title_filled = $this->functions->replaceTags($push_title, $data);
                $push_content_filled = $this->functions->replaceTags($push_content, $data);

                $params = array(
                    'merchant_id'   => isset($val['merchant_id']) ? (int)$val['merchant_id'] : 0,
                    'merchant_name' => isset($val['restaurant_name']) ? $val['restaurant_name'] : '',
                    'booking_id'    => isset($val['booking_id']) ? (int)$val['booking_id'] : 0,
                    'push_title'    => $push_title_filled,
                    'push_message'  => $push_content_filled,
                    'topics'        => 'new_order_' . $val['merchant_id'],
                    'date_created'  => $this->functions->dateNow(),
                    'ip_address'    => $_SERVER['REMOTE_ADDR'],
                );

                $this->functions->insertData("mt_merchantapp_broadcast", $params);
            }

            $this->processbroadcast();
        }

    endif;
}


public function clear_logs()
{
    if (1==1):

        $unattended_minutes = 1;
        $interval_date = date("Y-m-d H:i:s", strtotime("+$unattended_minutes minutes"));

        $stmt = "
        DELETE FROM mt_merchantapp_broadcast
        WHERE date_created <= CURRENT_DATE() - INTERVAL 2 MONTH
        ";
        $query = $this->db->prepare($stmt);
        $query->execute();

        $stmt = "
        DELETE FROM mt_merchantapp_push_logs
        WHERE date_created <= CURRENT_DATE() - INTERVAL 2 MONTH
        ";
        $query = $this->db->prepare($stmt);
        $query->execute();

        $stmt = "
        DELETE FROM mt_merchantapp_device_reg
        WHERE last_login <= CURRENT_DATE() - INTERVAL 2 MONTH
        ";
        $query = $this->db->prepare($stmt);
        $query->execute();

    endif;
}

    
   public function Nearexpiration()
{
    if (1 == 1):

        $lang = "en";
        $email_enabled = $this->functions->getOptionAdmin("merchant_near_expiration_email");
        $sms_enabled = $this->functions->getOptionAdmin("merchant_near_expiration_sms");
        $sender = $this->functions->getOptionAdmin("global_admin_sender_email");

        if ($email_enabled != 1 && $sms_enabled != 1) {
            if (isset($_GET['debug'])) {
                echo "disabled";
            }
            return;
        }

        $days = $this->functions->getOptionAdmin('merchant_near_expiration_day');
        if (empty($days)) {
            $days = 5;
        }

        $date = date("Y-m-d", strtotime("+$days day"));
        $stmt = "
        SELECT 
        a.merchant_id, a.restaurant_name, a.membership_expired        
        FROM mt_merchant a
        WHERE membership_expired < :expiry_date
        AND status IN ('active')
        AND is_commission = '1'
        LIMIT 0,1000
        ";

        $tpl = $this->CustomerNotification->getNotificationTemplate('merchant_near_expiration', $lang, 'push', false);
        $push_title = isset($tpl['push_title']) ? $tpl['push_title'] : '';
        $push_content = isset($tpl['push_content']) ? $tpl['push_content'] : '';
        $site_title = $this->functions->getOptionAdmin('website_title');
        $siteurl = $this->functions->websiteUrl();

        $query = $this->db->prepare($stmt);
        $query->execute([':expiry_date' => $date]);

        if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($resp as $val) {
                $data = array(
                    'restaurant_name' => isset($val['restaurant_name']) ? $val['restaurant_name'] : '',
                    'expiration_date' => isset($val['membership_expired']) ? $val['membership_expired'] : '',
                    'sitename' => $site_title,
                    'siteurl' => $siteurl
                );

                $final_push_title = $this->functions->replaceTags($push_title, $data);
                $final_push_content = $this->functions->replaceTags($push_content, $data);

                $params = array(
                    'merchant_id' => $val['merchant_id'],
                    'merchant_name' => isset($val['restaurant_name']) ? $val['restaurant_name'] : '',
                    'push_title' => $final_push_title,
                    'push_message' => $final_push_content,
                    'topics' => 'merchant_alert_'.$val['merchant_id'],
                    'date_created' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                );

                $this->functions->insertData("mt_merchantapp_broadcast", $params);
            }

            $this->processbroadcast();
        }

    endif;
}


public function AutoUpdateStatus()
{
    if (1 == 1):

        $enabled = $this->functions->getOptionAdmin('merchantapp_enabled_auto_status_enabled');
        $time_interval = (integer)$this->functions->getOptionAdmin('merchantapp_enabled_auto_status_time');
        $order_status = $this->functions->getOptionAdmin('merchantapp_enabled_auto_status');

        if ($enabled != 1 || $time_interval <= 0 || empty($order_status)) {
            die();
        }

        $order_action_accepted_status = $this->functions->getOptionAdmin('order_action_accepted_status');
        $accepted_based_time = (integer)$this->functions->getOptionAdmin('accepted_based_time');
        $accepted_based_time = $accepted_based_time > 0 ? $accepted_based_time : 1;
        $time = (integer)$this->functions->getOptionAdmin('merchantapp_enabled_auto_status_readyin');
        if ($time <= 0) {
            $time = 20;
        }

        $order_status = trim($order_status);

        $interval_date = date("Y-m-d H:i:s", strtotime("-$time_interval minutes"));
        $todays_date = date("Y-m-d");

        $and = " AND a.status IN ('pending','paid')
                 AND a.request_cancel='2'
                 AND CAST(a.date_created as DATE) BETWEEN '$todays_date' AND '$todays_date'
                 AND '$interval_date' > a.date_created";

        $stmt = "
        SELECT a.*
        FROM mt_view_order a
        WHERE 1
        $and
        LIMIT 0,10
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {

                $order_id = (integer)$val['order_id'];
                $merchant_id = (integer)$val['merchant_id'];
                $status = $order_status;
                $remarks = 'Auto update order status';
                $estimated_words = '';

                try {
                    if ($order_action_accepted_status == $order_status) {
                        $date_now = date('Y-m-d');
                        $datetime_now = date("Y-m-d g:i:s a");

                        $delivery_date = date("Y-m-d", strtotime($val['delivery_date']));

                        if (!empty($val['delivery_time'])) {
                            $delivery_time = date("H:i:s", strtotime($val['delivery_time']));
                        } else {
                            $delivery_time = date("H:i:s");
                        }

                        $is_late = false;
                        $date_created = "$delivery_date $delivery_time";
                        $time_diff = $this->functions->dateDifference($date_created, $datetime_now);

                        if (is_array($time_diff) && count($time_diff) >= 1) {
                            if ($time_diff['days'] > 0 || $time_diff['hours'] > 0 || $time_diff['minutes'] > 0) {
                                $is_late = true;
                            }
                        }

                        if ($is_late) {
                            $delivery_date = date('Y-m-d');
                            $delivery_time = date("H:i:s");
                        }

                        if ($accepted_based_time == 2) {
                            $date_now = date('Ymd');
                            $delivery_date2 = date("Ymd", strtotime($val['delivery_date']));
                            if (!($delivery_date2 > $date_now)) {
                                $delivery_date = date('Y-m-d');
                                $delivery_time = date("H:i:s");
                            }
                        }

                        $estimated_date_time = date("Y-m-d H:i:s", strtotime($delivery_date . " " . $delivery_time));

                        $params = array(
                            'estimated_time' => $time,
                            'estimated_date_time' => date('Y-m-d H:i:s', strtotime("+$time minutes", strtotime($estimated_date_time))),
                        );

                        $estimated_words = "estimated food ready in [minute] mins";

                        $chk_delivery_date = new DateTime($delivery_date);
                        $current_date = new DateTime();

                        if ($chk_delivery_date > $current_date) {
                            $estimated_words = "Order accepted and will be ready on time.";
                        }

                        $remarks = $estimated_words . " " . $time;

                        $up = $this->functions->updateData("mt_order_delivery_address", $params, 'order_id', $order_id);
                    }

                    $params = array(
                        'order_id' => $order_id,
                        'status' => $status,
                        'remarks' => $remarks,
                        'date_created' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR'],
                        'remarks2' => $estimated_words,
                        'remarks_args' => json_encode(array('[minute]' => $time))
                    );

                    $params2 = array(
                        'status' => $status,
                        'admin_viewed' => 1,
                        'viewed' => 2,
                        'date_modified' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR']
                    );

                    $this->OrderWrapper->updateOrderHistory($order_id, $merchant_id, $params, $params2);

                    $this->functions->notifyCustomerOrderStatusChange($order_id, $status, $remarks);
                    $this->OrderWrapper->InsertOrderTrigger($order_id, 'auto_order_update', '', 'auto_order_update');

                    $this->PointsProgram->updateOrderBasedOnStatus($status, $order_id);
                    $this->PointsProgram->udapteReviews($order_id, $status);

                    if ($this->functions->inventoryEnabled($merchant_id)) {
                        try {
                            $this->InventoryWrapper->insertInventorySale($order_id, $status);
                        } catch (Exception $e) {
                            // Handle silently
                        }
                    }
                } catch (Exception $e) {
                    // Handle silently
                }
            }
        }

    endif;
}










  





	
	
	
	
	
}
/*end class*/