<?php
class BookingWrapper
{

    public function __construct() {
         $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions
       
   
        

    }


public function getAllBooking($order_type = '', $merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    $order_by = 'ORDER BY booking_id ASC';
    $todays_date = date("Y-m-d");
    $next_date = date('Y-m-d', strtotime("+1 day"));

    // Escape values
    $merchant_id = (int)$merchant_id;
    $start = (int)$start;
    $total_rows = (int)$total_rows;
    $search_string_escaped = addslashes($search_string);
    $search_string_like = addslashes($search_string) . '%';
    $todays_date_escaped = addslashes($todays_date);

    // Handle search string
    if (!empty($search_string)) {
        $and .= "
            AND (
              a.booking_id = '{$search_string_escaped}'
              OR
              a.booking_name LIKE '{$search_string_like}'
            )
        ";
    }

    // Handle order type
    if (!empty($order_type)) {
        switch ($order_type) {
            case "incoming":
                $and .= " AND a.status IN ('pending') AND a.request_cancel = '0' ";
                $and .= " AND CAST(a.date_created AS DATE) BETWEEN '{$todays_date_escaped}' AND '{$todays_date_escaped}' ";
                break;

            case "cancel_booking":
                $and .= " AND a.status IN ('request_cancel_booking')";
                break;

            case "all":
                $order_by = 'ORDER BY booking_id DESC';
                break;

            case "done_booking":
                $and .= " AND a.status IN ('approved', 'denied', 'cancel_booking_approved') ";
                $and .= " AND CAST(a.date_created AS DATE) BETWEEN '{$todays_date_escaped}' AND '{$todays_date_escaped}' ";
                break;
        }
    }

    // Final query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS
        a.booking_id, a.merchant_id, a.client_id, a.number_guest, a.date_booking,
        a.date_booking AS date_booking_raw, a.booking_time AS booking_time_raw,
        a.booking_time, a.booking_name, a.email, a.mobile, a.booking_notes,
        a.date_created, a.date_created AS date_created_raw, a.status, a.status AS status_raw
        FROM mt_bookingtable a
        WHERE a.merchant_id = '{$merchant_id}'
        $and
        $order_by
        LIMIT {$start}, {$total_rows}
    ";

    // Execute and fetch
    $query = $this->db->query($stmt);
    if ($query) {
        $resp = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }

    return false;
}



public function updateBooking($booking_id = '', $params = array(), $notes = '')
{
    // Make sure booking_id is an integer
    $booking_id = (int)$booking_id;

    // Direct query with variable (not recommended in general)
    $stmt = "
        SELECT *
        FROM mt_bookingtable 
        WHERE booking_id = {$booking_id}
        LIMIT 0,1
    ";          

    // Execute the query
    $query = $this->db->query($stmt);

    // Fetch the result
    if ($resp = $query->fetch(PDO::FETCH_ASSOC)) {

        // Update the booking record
        $up = $this->functions->updateData("mt_bookingtable", $params, 'booking_id', $booking_id);

        if ($up) {
            // Prepare history record parameters
            $params_history = array(
                'booking_id' => $booking_id,
                'status' => $params['status'],
                'remarks' => $notes,
                'date_created' => $this->functions->dateNow()
            );

            // Insert history record
            $this->functions->insertData('mt_bookingtable_history', $params_history);

            // Update the response with the new status and remarks
            $resp['status'] = $params['status'];
            $resp['remarks'] = $notes;

            // Optional future use
            // FunctionsV3::updateBookingNotify($resp);

            return $resp;
        } else {
            throw new Exception("Failed cannot update record");
        }
    }

    throw new Exception("Booking id not found");
}



public function getBookingDetails($booking_id = '')
{
    // Ensure booking_id is an integer to prevent SQL injection
    $booking_id = (int)$booking_id;

    // Direct query using interpolated value
    $stmt = "
        SELECT *, 
            number_guest AS number_guest_raw, 
            date_created AS date_created_raw, 
            status AS status_raw
        FROM mt_bookingtable
        WHERE booking_id = {$booking_id}
        LIMIT 1
    ";

    // Execute the query
    $query = $this->db->query($stmt);

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    throw new Exception("Booking id not found");
}


    
   public function getHistory($booking_id = '')
{
    // Prepare the query to get booking history
    $stmt = "
        SELECT *
        FROM mt_bookingtable_history
        WHERE booking_id = :booking_id
        ORDER BY id ASC
    ";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch all results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}


  public function getNewestBooking($booking_ids = '')
{
    if (!empty($booking_ids)) {
        // Prepare the query to get the newest booking, excluding given booking IDs
        $stmt = "
            SELECT booking_id
            FROM mt_bookingtable
            WHERE booking_id NOT IN ($booking_ids)
            AND status IN ('pending')
            LIMIT 0,1
        ";

        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return true;
        }
    } else {
        // Get today's date
        $todays_date = date("Y-m-d");

        // Prepare the query to get the newest booking created today
        $stmt = "
            SELECT booking_id
            FROM mt_bookingtable
            WHERE CAST(date_created AS DATE) BETWEEN :todays_date AND :todays_date
            AND status IN ('pending')
            LIMIT 0,1
        ";

        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->bindParam(':todays_date', $todays_date, PDO::PARAM_STR);
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return true;
        }
    }

    return false;
}
  
    
    public function getNewestCancel($booking_ids = '')
{
    if (!empty($booking_ids)) {
        // Prepare the query to get the newest canceled booking, excluding given booking IDs
        $stmt = "
            SELECT booking_id
            FROM mt_bookingtable
            WHERE booking_id NOT IN ($booking_ids)
            AND status IN ('request_cancel_booking')
            LIMIT 0,1
        ";

        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return true;
        }
    } else {
        // Get today's date
        $todays_date = date("Y-m-d");

        // Prepare the query to get the newest canceled booking created today
        $stmt = "
            SELECT booking_id
            FROM mt_bookingtable
            WHERE CAST(date_created AS DATE) BETWEEN :todays_date AND :todays_date
            AND status IN ('request_cancel_booking')
            LIMIT 0,1
        ";

        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->bindParam(':todays_date', $todays_date, PDO::PARAM_STR);
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return true;
        }
    }

    return false;
}





  



    










    
      
}
/*END CLASS*/