<?php








class CronController extends Controller {
     protected $db;
     public $crumbsTitle='';
   public $theme_compression='';
    public $is_rtl=false;
    public $action_name='12';
    public $provider;
     public $map_api;
    public $map_provider;  
    public $mapbox_default_zoom;

    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

         $this->Item_menu=new Item_menu();

  $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
   
      date_default_timezone_set($website_timezone);
   $requested_url=$_SERVER['REQUEST_URI'];
  $url_parts = explode('/', trim($requested_url, '/'));
   if (count($url_parts) >= 2) {
    $action_name = $url_parts[1];
   }
   if($action_name=='')
   {
    $action_name='index';
   }
   $this->action_name=$action_name;
   $this->action_id=$action_name;


   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {
        echo "CONTROLLER INDEX";
        die();
        

        
    }


    public function testing_merchant_email(){
        $enabled=$this->functions->getOptionAdmin("booked_notify_merchant_email");
       if($enabled==1){
          $tpl=$this->functions->getOptionAdmin("booked_notify_merchant_tpl_content_$lang");
          $subject=$this->functions->getOptionAdmin("booked_notify_merchant_tpl_subject_$lang");
          
          $email=$this->functions->getOption('merchant_booking_receiver',3);
          
         
          
          
          //dump($email);dump($subject);dump($tpl);
          
          $email=explode(",",$email);

          print_r($email);die();
    }
}

     
    
       public function processemail()
    {
    
        
        $stmt = $this->db->prepare("SELECT * FROM   mt_email_logs       WHERE       status IN ('pending')       ORDER BY id desc        LIMIT 0,10");   

        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC); 
    
        
        
        if ($res){
            foreach ($res as $val) {
            
            $stmt1 = $this->db->prepare("UPDATE mt_email_logs SET status = 'processing'          WHERE id = :id         ");
       $stmt1->bindParam(':id', $val['id'], PDO::PARAM_INT);
$stmt1->execute();

            // $this->functions->sendEmail($val['email_address'],'',$email_subject, $email_content );   
             
			 // Check if another record exists with same order_id + email_address and status = 'sent'

          if ($val['order_id']>0) {
          $checkStmt = $this->db->prepare("
    SELECT id 
    FROM mt_email_logs 
    WHERE order_id = :order_id 
      AND email_address = :email 
      AND subject = :subject 
      AND status = 'sent' 
    LIMIT 1
");

$checkStmt->bindParam(':order_id', $val['order_id'], PDO::PARAM_INT);
$checkStmt->bindParam(':email', $val['email_address'], PDO::PARAM_STR);
$checkStmt->bindParam(':subject', $val['subject'], PDO::PARAM_STR);
$checkStmt->execute();
$alreadySent = $checkStmt->fetch(PDO::FETCH_ASSOC);
            if ($alreadySent&&$val['order_id']>0) {
                // Mark as duplicate, don’t send again
                $dupStmt = $this->db->prepare("UPDATE mt_email_logs SET status = 'duplicate' WHERE id = :id");
                $dupStmt->bindParam(':id', $val['id'], PDO::PARAM_INT);
                $dupStmt->execute();
            } else {

			 
            $this->functions->sendEmail($val['email_address'],$val['sender'],$val['subject'],$val['content'],$val['id']);
			
			}



			
             }else{
                $this->functions->sendEmail($val['email_address'],$val['sender'],$val['subject'],$val['content'],$val['id']);
             }
			
            }
        }

         else {
            if(isset($_GET['debug'])){
                echo "no records";
            }
        }
    }



   public function ProcessBroacast()
{
    $stmt = "SELECT * FROM mt_sms_broadcast WHERE status IN ('pending') LIMIT 0,1";
    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {

            if ($val['send_to'] == 1) {
                $this->getAllCustomer($val);
            } elseif ($val['send_to'] == 2) {
                if (isset($_GET['debug'])) {
                    echo "Merchant customer";
                }
                $this->getAllCustomerByMerchant($val);
            } else {
                if (isset($_GET['debug'])) {
                    echo "custom mobile";
                }
                $this->customMobile($val);
            }

            $this->functions->updateData(
                "mt_sms_broadcast",
                array(
                    'status' => "process",
                    'date_modified' => $this->functions->dateNow()
                ),
                'broadcast_id',
                $val['broadcast_id']
            );
        }
    } else {
        if (isset($_GET['debug'])) {
            echo "<p>No records to process</p>";
        }
    }
}


 public function ProcessSMS()
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_sms_broadcast_details
        WHERE status = 'pending'
        ORDER BY id ASC
        LIMIT 10
    ");
    
    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            if (isset($_GET['debug'])) {
                var_dump($val);
            }
            $this->functions->sendSMS(trim($val['contact_phone']), $val['sms_message'], $val['id']);
        }
    } else {
        if (isset($_GET['debug'])) {
            echo "no records";
        }
    }
}


public function MerchantExpired()
  {
    
    $this->functions->updateMerchantSponsored();
    $this->functions->updateMerchantExpired();
  }


public function add_branch_to_empty_users()
{
    // Select clients meeting the condition
    $stmt = $this->db->prepare("
        SELECT client_id, merchant_id 
        FROM mt_client
        WHERE (social_strategy = 'webappv2' OR social_strategy = 'SingleMerchant')
        AND (branch IS NULL OR branch = '')
        AND merchant_id > 0
    ");
    $stmt->execute();
    $clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($clients as $client) {
        $merchant_id = (int)$client['merchant_id']; // Cast to integer
        $branch_value = json_encode([$merchant_id]); // Will now be [2], not ["2"]

        $stmtUpdate = $this->db->prepare("
            UPDATE mt_client
            SET branch = ? 
            WHERE client_id = ?
        ");
        $stmtUpdate->execute([$branch_value, $client['client_id']]);
    }

    echo "Branch updated for " . count($clients) . " client(s).";
}


public function booking_cancel_from_email(){

    $booking_id=$_GET['booking_id'];

    $token=$_GET['token'];

     $booking=$this->functions->getBooking_idwise_token($booking_id,$token);

    if($booking){

        $token=$booking['token'];
        $cancel_booking=$this->functions->booking_cancel_via_email($booking['merchant_id'],$booking_id,$token);
        
        echo $cancel_booking;


    }else{
        echo "Booking Link has been expired";
    }


}


public function booking_approve_from_email(){

    $booking_id=$_GET['booking_id'];
    $token=$_GET['token'];
    

    $booking=$this->functions->getBooking_idwise_token($booking_id,$token);

    if($booking){
        $token=$booking['token'];
        $approve_booking=$this->functions->booking_approve_via_email($booking['merchant_id'],$booking_id,$token);
        
        echo $approve_booking;


    }else{
        echo "Booking Link has been expired";
    }


}





public function getAuthToken()
{
    $merchant_api_id  = $this->functions->getOption("place_api_id_admin");  // Google Client ID
    $merchant_api_key = $this->functions->getOption("place_api_key_admin"); // Google Client Secret

    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $urls = $this->functions->websiteUrl();
    $redirectUri = $urls . '/cron/dataRetrungoogle';
     // This URL must match your Google Cloud OAuth redirect URI exactly

    $client = new Google_Client();
    $client->setClientId($merchant_api_id);
    $client->setClientSecret($merchant_api_key);
    $client->setRedirectUri($redirectUri);
    $client->addScope('https://www.googleapis.com/auth/actions.fulfillment');
    $client->setAccessType('offline'); // get refresh token
    $client->setPrompt('consent');

    // If we don't have an auth code yet, send user to Google consent screen
    $authUrl = $client->createAuthUrl();
    header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));
    exit;
}

public function dataRetrungoogle()
{
    $merchant_api_id  = $this->functions->getOption("place_api_id_admin");
    $merchant_api_key = $this->functions->getOption("place_api_key_admin");

    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $urls = $this->functions->websiteUrl();
    $redirectUri = $urls . '/cron/dataRetrungoogle';

    $client = new Google_Client();
    $client->setClientId($merchant_api_id);
    $client->setClientSecret($merchant_api_key);
    $client->setRedirectUri($redirectUri);
    $client->addScope('https://www.googleapis.com/auth/actions.fulfillment');
    $client->setAccessType('offline');

    if (!isset($_GET['code'])) {
        echo "Missing authorization code.";
        exit;
    }

    // Exchange auth code for access/refresh token
    $tokenData = $client->fetchAccessTokenWithAuthCode($_GET['code']);

    if (isset($tokenData['error'])) {
        echo "Error fetching token: " . $tokenData['error_description'];
        exit;
    }

    print_r($tokenData);

    // Store token in DB for later API calls
    //$this->functions->saveOption("google_access_token", json_encode($tokenData));

    //echo "Token saved successfully. You can now use it to call Google Booking APIs.";
}



public function getAuthToken2()
{
    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $serviceAccountPath = __DIR__ . '/../../vendor/service-account.json';

    // Set up Google Client
    $client = new Google_Client();
    $client->setAuthConfig($serviceAccountPath);
    $client->addScope('https://www.googleapis.com/auth/mapsbooking');

    // Get access token from service account
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];

    // API variables
    $baseUrl    = "https://partnerdev-mapsbooking.googleapis.com/"; // Sandbox endpoint
    $partnerId  = '20003268';
    $bookingId  = 'booking_689afe2de23eb';
    $merchantId = 'loveeatery_001_pk';
    $serviceId  = 'reservation';

    // PATCH payload
    $payload = [
        "name"       => "partners/{$partnerId}/bookings/{$bookingId}",
        "merchantId" => $merchantId,
        "serviceId"  => $serviceId,
        "status"     => "CANCELED" // or CONFIRMED, FULFILLED, etc.
    ];

    // Prepare cURL request
    $url = $baseUrl . "v1alpha/notification/partners/{$partnerId}/bookings/{$bookingId}?updateMask=status";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch);
    } else {
        echo "Success:\n";
        echo $result;
    }

    curl_close($ch);
}






 









  public function resendMails_order(){

   

    $stmt = $this->db->prepare("
    SELECT * 
    FROM mt_order
    WHERE resend_email = 0
    AND status != 'initial_order'
    AND DATE(date_created) = CURDATE()
    AND request_from != 'pos'
    ORDER BY order_id DESC
    LIMIT 10
");

$stmt->execute();
$res = $stmt->fetchAll(PDO::FETCH_ASSOC);

 foreach ($res as $order) {

    $merchant_id = $order['merchant_id'];
    $order_id = $order['order_id'];

    // Get the merchant's notify emails
    $merchant_email_ids = $this->functions->getOption('merchant_notify_email', $merchant_id);

    // Split and trim each email
    $email_array = array_map('trim', explode(',', $merchant_email_ids));

    $not_sent = [];

    foreach ($email_array as $email) {
        // Check if the email exists in mt_email_logs for this order
        $stmt = $this->db->prepare("
    SELECT COUNT(*) 
    FROM mt_email_logs 
    WHERE order_id = ? 
    AND TRIM(LOWER(email_address)) = TRIM(LOWER(?))
    
    
");
$stmt->execute([$order_id, $email]);

        $count = $stmt->fetchColumn();

        if ($count == 0) {
            $not_sent[] = $email;
        }
    }

    // Combine unmatched emails into a comma-separated string
    $not_sending_emails = implode(',', $not_sent);

    if($not_sending_emails!=""){

    $this->Item_menu->sendNotifications($order_id,$not_sending_emails);

    }else{
        //update order
    
    $params_order=array('resend_email'=>1);
    $this->functions->updateData("mt_order",$params_order,'order_id',$order_id);
    }

    //echo "Order ID: $order_id - Emails not sent: $not_sending_emails<br>";
}



  }


public function BatchAvailabilityLookup1()
{
    // ✅ Step 0: Basic Auth check with braces
    if (
        $_SERVER['PHP_AUTH_USER'] !== 'loveeatery' ||
        $_SERVER['PHP_AUTH_PW'] !== '12345678'
    ) {
       // header('WWW-Authenticate: Basic realm="Google RwG"');
        //header('HTTP/1.0 401 Unauthorized');
       // exit('Unauthorized');
    }

    // Step 1: Read JSON input
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    

    // Step 2: Prepare response
    $response = ['availability' => []];

    // Step 3: Loop through lookupSpec
    if (isset($data['lookupSpec']) && is_array($data['lookupSpec'])) {
        foreach ($data['lookupSpec'] as $lookup) {
            $merchantId = $lookup['merchantId'] ?? '';
            $serviceId = $lookup['serviceId'] ?? '';



            $startTime = $lookup['startTimeRange']['startSeconds'] ?? time();
            $endTime = $lookup['startTimeRange']['endSeconds'] ?? ($startTime + 86400); // 24 hours

            // Step 4: Create 3 fake slots
            $slots = [];
            for ($i = 0; $i < 3; $i++) {
                $slotStart = $startTime + ($i * 3600); // every hour
                if ($slotStart > $endTime) break;

                $slots[] = [
                    'startSec' => $slotStart,
                    'durationSec' => 3600,
                    'spotsOpen' => 1,
                    'spotsTotal' => 2
                ];
            }

            // Step 5: Append availability block
            $response['availability'][] = [
                'merchantId' => $merchantId,
                'serviceId' => $serviceId,
                'availability' => $slots
            ];
        }
    }

    // Step 6: Output JSON response
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}

public function BatchAvailabilityLookup0001()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Log raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [INPUT] " . $rawInput . "\n", FILE_APPEND);

    // If empty request body
    if (trim($rawInput) === '') {
        file_put_contents($logFile, date('c') . " [WARNING] EMPTY REQUEST BODY\n", FILE_APPEND);
    }

    // Try to decode JSON (if any)
    $data = json_decode($rawInput, true);

    // Fallback sample response if invalid JSON
    if (json_last_error() !== JSON_ERROR_NONE || !isset($data['lookupSpec'])) {
        $slotStart = time();
        $slotStart = $slotStart - ($slotStart % 1800); // Align to 30-min interval

        echo json_encode([
            'availability' => [
                [
                    'merchantId'   => 'loveeatery_001_pk',
                    'serviceId'    => 'reservation',
                    'availability' => [
                        [
                            'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
                            'duration'   => 'PT1H',
                            'spotsOpen'  => 2,
                            'spotsTotal' => 2
                        ]
                    ]
                ]
            ]
        ], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
        return;
    }

    // Build response based on JSON input
    $response = ['availability' => []];
    foreach ($data['lookupSpec'] as $lookup) {
        $merchantId = $lookup['merchantId'] ?? 'unknown';
        $serviceId  = $lookup['serviceId'] ?? 'unknown';

        $startTime = $lookup['startTimeRange']['startSeconds'] ?? time();
        $endTime   = $lookup['startTimeRange']['endSeconds'] ?? ($startTime + 3600);

        // Align start time to nearest 30-minute interval
        $startTime = $startTime - ($startTime % 1800);

        $slots = [];
        if ($endTime < $startTime) $endTime = $startTime + 3600;

        for ($slotStart = $startTime; $slotStart <= $endTime; $slotStart += 1800) {
            $slots[] = [
                'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
                'duration'   => 'PT1H',
                'spotsOpen'  => 2,
                'spotsTotal' => 2
            ];
        }

        $response['availability'][] = [
            'merchantId'   => $merchantId,
            'serviceId'    => $serviceId,
            'availability' => $slots
        ];
    }

    // Log response
    file_put_contents($logFile, date('c') . " [RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}

public function BatchAvailabilityLookup()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    // Extract fields
    $merchantId = $request['merchant_id'] ?? 'loveeatery_001_pk';
    $serviceId  = strtolower($request['service_id'] ?? '');
    $resources  = $request['resources']['party_size'] ?? 2;

    // Validate serviceId
    if ($serviceId !== 'reservation') {
        $error = ['error' => 'Invalid serviceId. Expected "reservation".'];
        file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    // Generate availability slots (for 25 July 2025)
    $startSec = strtotime('2025-07-25 00:00:00 UTC');
    $availability = [];
    for ($i = 0; $i < 5; $i++) {
        $availability[] = [
            "spots_total"       => 5,
            "spots_open"        => 5,
            "duration_sec"      => 3600,
            "service_id"        => "reservation",
            "start_sec"         => $startSec + ($i * 3600),
            "merchant_id"       => $merchantId,
            "resources"         => ["party_size" => $resources],
            "confirmation_mode" => "CONFIRMATION_MODE_SYNCHRONOUS"
        ];
    }

    // Final response
    $response = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number"           => 0,
            "total_shards"           => 1,
            "nonce"                  => uniqid(),
            "generation_timestamp"   => time()
        ],
        "service_availability" => [
            ["availability" => $availability]
        ]
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

public function BatchAvailabilityLookup21()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Log raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    $data = json_decode($rawInput, true);

    // Always return slots for 23rd July 2025
    $date = '2025-07-23';
    $startOfDay = strtotime($date . ' 00:00:00 UTC');
    $endOfDay = strtotime($date . ' 23:30:00 UTC');

    $slots = [];
    for ($slotStart = $startOfDay; $slotStart <= $endOfDay; $slotStart += 1800) {
        $slots[] = [
            'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
            'duration'   => 'PT1H',
            'spotsOpen'  => 2,
            'spotsTotal' => 2
        ];
    }

    $response = [
        'availability' => [
            [
                'merchantId'   => 'loveeatery_001_pk',
                'serviceId'    => 'reservation',
                'availability' => $slots
            ]
        ]
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}
public function CreateBooking()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Log raw request input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [CreateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Extract fields
    $merchantId = $request['merchantId'] ?? '';
    $serviceId  = strtolower($request['serviceId'] ?? '');
    $slot       = $request['slot'] ?? [];
    $userInfo   = $request['user_information'] ?? []; // Adjusted key to match your JSON example

    // Validate service ID
    if ($serviceId !== 'reservation') {
        http_response_code(400);
        $error = ['error' => 'Invalid serviceId. Expected "reservation".'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Get slot data with correct keys
    $startSec    = $slot['start_sec'] ?? 0;
    $durationSec = $slot['duration_sec'] ?? 3600;

    // Validate date (only allow 2025-07-23)
    $slotDate = gmdate('Y-m-d', $startSec);
    if ($slotDate !== '2025-07-23') {
     
    }

    // Generate booking ID
    $bookingId = uniqid('booking_');

    // Build response
    $response = [
        'booking' => [
            'bookingId'        => $bookingId,
            'merchantId'       => $merchantId,
            'serviceId'        => 'reservation',
            'slot'             => [
                'start_sec'    => $startSec,
                'duration_sec' => $durationSec,
                'resources'    => $slot['resources'] ?? ['party_size' => 4]
            ],
            'user_information' => $userInfo,
            'status'           => 'CONFIRMED',
            'confirmationMode' => 'CONFIRMATION_MODE_SYNCHRONOUS'
        ]
    ];

    // Log response
    //file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    // Return response
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);exit;
}

public function UpdateBooking()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [UpdateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Extract fields
    $bookingId    = $request['bookingId'] ?? '';
    $updateMask   = $request['updateMask'] ?? [];
    $updatedFields= $request['updatedBooking'] ?? [];

    if (empty($bookingId)) {
        http_response_code(400);
        $error = ['error' => 'bookingId is required.'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Default booking status
    $status = 'CONFIRMED';

    // Handle cancellation or changes
    if (!empty($updatedFields['status']) && strtoupper($updatedFields['status']) === 'CANCELLED') {
        $status = 'CANCELLED';
    }

    // Handle updates to slot or user info
    $slot = $updatedFields['slot'] ?? [
        'startSec'    => time() + 3600,
        'durationSec' => 3600,
        'resources'   => ['party_size' => 4]
    ];
    $userInfo = $updatedFields['userInformation'] ?? [];

    // Build response
    $response = [
        'booking' => [
            'bookingId'       => $bookingId,
            'merchantId'      => $request['merchantId'] ?? 'loveeatery_001_pk',
            'serviceId'       => $request['serviceId'] ?? 'reservation',
            'slot'            => $slot,
            'userInformation' => $userInfo,
            'status'          => $status,
            'confirmationMode'=> 'CONFIRMATION_MODE_SYNCHRONOUS'
        ]
    ];

    file_put_contents($logFile, date('c') . " [UpdateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    return json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);exit;
}
public function CreateBooking21()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [CreateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    $merchantId = $request['merchantId'] ?? '';
    $serviceId  = $request['serviceId'] ?? '';
    $slot       = $request['slot'] ?? [];
    $userInfo   = $request['userInformation'] ?? [];

    // Validate slot (only allow 23rd July 2025)
    $startSec   = $slot['startSec'] ?? 0;
    $slotDate   = gmdate('Y-m-d', $startSec);
    if ($slotDate !== '2025-07-23') {
        http_response_code(400);
        $error = ['error' => 'Only bookings for 2025-07-23 are allowed'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    $bookingId = uniqid('booking_');

    $response = [
        "booking" => [
            "bookingId"       => $bookingId,
            "merchantId"      => $merchantId,
            "serviceId"       => $serviceId,
            "slot"            => $slot,
            "userInformation" => $userInfo,
            "status"          => "CONFIRMED"
        ]
    ];

    file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}







public function MerchantNearExpiration()
{
    $lang = 'en';
    $email_enabled = $this->functions->getOptionAdmin("merchant_near_expiration_email");
    $sms_enabled = $this->functions->getOptionAdmin("merchant_near_expiration_sms");
    $sender = $this->functions->getOptionAdmin("global_admin_sender_email");

    if ($email_enabled != 1 && $sms_enabled != 1) {
        if (isset($_GET['debug'])) {
            echo "disabled";
        }
        return;
    }

    $days = $this->functions->getOptionAdmin('merchant_near_expiration_day');
    if (empty($days)) {
        $days = 5;
    }

    $date = date("Y-m-d", strtotime("+$days day"));

    $stmt = "
    SELECT * FROM
    mt_merchant
    WHERE
    membership_expired < :date
    AND status IN ('active')
    AND is_commission = '1'
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':date' => $date]);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $tpl_orig = $this->functions->getOptionAdmin("merchant_near_expiration_tpl_content_$lang");
        $subject_orig = $this->functions->getOptionAdmin("merchant_near_expiration_tpl_subject_$lang");
        $tpl_sms_orig = $this->functions->getOptionAdmin("merchant_near_expiration_sms_content_$lang");

        foreach ($res as $val) {
            $merchant_email = $val['contact_email'];

            $pattern = [
                'restaurant_name' => 'restaurant_name',
                'expiration_date' => 'membership_expired',
                'sitename' => $this->functions->getOptionAdmin('website_title'),
                'siteurl' => $this->functions->websiteUrl(),
            ];

            $tpl = $this->functions->replaceTemplateTags($tpl_orig, $pattern, $val);
            $subject = $this->functions->replaceTemplateTags($subject_orig, $pattern, $val);
            $tpl_sms = $this->functions->replaceTemplateTags($tpl_sms_orig, $pattern, $val);

            // Insert Email Log
            $paramsEmail = [
                'email_address' => $merchant_email,
                'sender' => $sender,
                'subject' => $subject,
                'content' => $tpl,
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'module_type' => 'core'
            ];
            $this->functions->insertData("mt_email_logs", $paramsEmail);

            // Insert SMS Broadcast
            $paramsSMS = [
                'contact_phone' => $val['contact_phone'],
                'sms_message' => $tpl_sms,
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR']
            ];
            $this->functions->insertData("{{sms_broadcast_details}}", $paramsSMS);
        }
    } else {
        if (isset($_GET['debug'])) {
            echo "no records";
        }
    }
}


public function IdleOrder()
{
    $datenow = date("Y-m-d");

    $stmt = "
    SELECT 
    a.order_id,
    a.merchant_id,
    a.date_created,
    b.restaurant_name
    
    FROM mt_order a
    LEFT JOIN mt_merchant b
    ON a.merchant_id = b.merchant_id
    
    WHERE
    a.date_created LIKE :datenow
    AND a.status = 'pending'
    AND a.critical = '1'
    ORDER BY a.order_id ASC
    LIMIT 0,10
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':datenow' => $datenow . '%']);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    $idle_minutes = $this->functions->getOptionAdmin('order_idle_admin_minutes');
    if (!is_numeric($idle_minutes)) {
        $idle_minutes = 5;
    }

    if ($res) {
        foreach ($res as $val) {
            if (isset($_GET['debug'])) {
                dump($val);
            }

            $critical = false;
            $time_1 = date('Y-m-d g:i:s a');
            $time_2 = date("Y-m-d g:i:s a", strtotime($val['date_created']));
            $time_diff = $this->functions->dateDifference($time_2, $time_1);

            if (is_array($time_diff) && count($time_diff) >= 1) {
                if ($time_diff['minutes'] > $idle_minutes) {
                    $critical = true;
                }
                if ($time_diff['hours'] >= 1) {
                    $critical = true;
                }
                if ($time_diff['days'] >= 1) {
                    $critical = true;
                }
            }

            if ($critical) {
                $val['time_diff'] = $time_diff;

                // Update the critical status in mt_order
                $updateStmt = "UPDATE mt_order SET critical = 2 WHERE order_id = :order_id";
                $updateQuery = $this->db->prepare($updateStmt);
                $updateQuery->execute([':order_id' => $val['order_id']]);

                // Send notification
                $this->notiIdleAdmin($val);
            }
        }
    }
}


public  function notiIdleAdmin($data='')
  {
    $lang='en'; 
    $sender=$this->functions->getOptionAdmin('global_admin_sender_email');
    
    $enabled=$this->functions->getOptionAdmin('order_idle_to_admin_email');
    $email=$this->functions->getOptionAdmin('order_idle_admin_email');
    if($enabled==true && !empty($email)){
      $tpl=$this->functions->getOptionAdmin("order_idle_to_admin_tpl_content_$lang");
      $subject = $this->functions->getOptionAdmin("order_idle_to_admin_tpl_subject_$lang");
                  
      $data['idle_time']=$data['time_diff']['hours'].":".$data['time_diff']['minutes'].":".$data['time_diff']['seconds'];
      
      $pattern=array(                    
         'order_id'=>'order_id',
           'restaurant_name'=>'restaurant_name',           
           'sitename'=>$this->functions->getOptionAdmin('website_title'),
           'siteurl'=>$this->functions->websiteUrl(),              
           'idle_time'=>'idle_time'
          );
        $tpl=$this->functions->replaceTemplateTags($tpl,$pattern,$data);
        $subject=$this->functions->replaceTemplateTags($subject,$pattern,$data);
                  
      
        $params=array(
         'email_address'=>$email,
         'sender'=>$sender,
         'subject'=>$subject,
         'content'=>$tpl,
         'date_created'=>$this->functions->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR'],
         'module_type'=>'core'
        );     

        

        $this->functions->insertData("mt_email_logs",$params);       
       
      
    }
  }




  












//++++++++cron functions
  public function getAllCustomer($info = '')
{   
    $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE contact_phone != ''");
    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {     
        foreach ($res as $val) {        
            $params = [
                'broadcast_id' => $info['broadcast_id'],
                'client_name' => $val['first_name'] . " " . $val['last_name'],
                'contact_phone' => $val['contact_phone'],
                'sms_message' => $info['sms_alert_message'],
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'client_id' => $val['client_id'],
                'merchant_id' => $info['merchant_id']
            ];

            if (!$this->smsDetailsisExist($info['broadcast_id'], $val['client_id'])) {
                echo "<p>Insert</p>";
                $this->functions->insertData("mt_sms_broadcast_details", $params);
            } else {
                echo "<p>Already Exist</p>";
            }     
        }     
    }
}


public function getAllCustomerByMerchant($info = '')
{   
    $stmt = $this->db->prepare("
        SELECT a.* 
        FROM mt_client a
        WHERE client_id IN (
            SELECT client_id FROM mt_order 
            WHERE client_id = a.client_id AND merchant_id = :merchant_id
        )
    ");
    
    $stmt->execute(['merchant_id' => $info['merchant_id']]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {     
        foreach ($res as $val) {        
            $params = [
                'broadcast_id' => $info['broadcast_id'],
                'client_name' => $val['first_name'] . " " . $val['last_name'],
                'contact_phone' => $val['contact_phone'],
                'sms_message' => $info['sms_alert_message'],
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'client_id' => $val['client_id'],
                'merchant_id' => $info['merchant_id']
            ];

            if (!$this->smsDetailsisExist($info['broadcast_id'], $val['client_id'])) {
                echo "<p>Insert</p>";
                $this->functions->insertData("mt_sms_broadcast_details", $params);
            } else {
                echo "<p>Already Exist</p>";
            }     
        }     
    }
}


public function customMobile($info='')
  {   
    $list_mobile_number=isset($info['list_mobile_number'])?explode(",",$info['list_mobile_number']):0;
    if (is_array($list_mobile_number) && count($list_mobile_number)>=1)
    {
      foreach ($list_mobile_number as $mobile) {
        $params=array(
          'broadcast_id'=>$info['broadcast_id'],
          'client_name'=>$mobile,
          'contact_phone'=>$mobile,
          'sms_message'=>$info['sms_alert_message'],
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'client_id'=>$mobile,
          'merchant_id'=>$info['merchant_id']
        );
        //dump($params);
        if ( !$this->smsDetailsisExist($info['broadcast_id'],$mobile)){
          echo "<p>Insert</p>";
          $this->functions->insertData("mt_sms_broadcast_details",$params);
        } else echo "<p>Already Exist</p>";     
      }
    }
  }   
  
 public function smsDetailsisExist($bid = '', $cid = '')
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_sms_broadcast_details
        WHERE broadcast_id = :broadcast_id
        AND client_id = :client_id
        LIMIT 1
    ");
    
    $stmt->execute([
        'broadcast_id' => $bid,
        'client_id' => $cid
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}

  
 public function getPayoutToProcess()
{
    $date_now = date("Y-m-d");

    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_withdrawal
        WHERE status IN ('approved')
        AND date_to_process = :date_now
        ORDER BY withdrawal_id ASC
        LIMIT 2
    ");
    
    $stmt->execute(['date_now' => $date_now]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}




public function replicateEmailLogsToHistory()
{
    $date_today = date("Y-m-d");

    // Step 1: Get all rows except today's date
    $stmt = $this->db->query("
        SELECT * 
        FROM mt_email_logs 
        WHERE DATE(date_created) != '$date_today'
    ");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $count = count($rows);

    if ($count == 0) {
        echo "No records to replicate.<br/>";
        return false;
    }

    // Step 2: Insert into mt_email_logs_history
    foreach ($rows as $row) {
        $columns = array_keys($row);
        $values = [];

        foreach ($row as $value) {
            $escaped = addslashes($value);
            $values[] = "'$escaped'";
        }

        $insert_sql = "INSERT INTO mt_email_logs_history (" . implode(',', $columns) . ") 
                       VALUES (" . implode(',', $values) . ")";

        $this->db->exec($insert_sql);
    }

    // Step 3: Delete old records from mt_email_logs
    $this->db->exec("
        DELETE FROM mt_email_logs 
        WHERE DATE(date_created) != '$date_today'
    ");

    // Final message
    echo "Successfully replicated and deleted $count record(s).<br/>";

    return true;
}



public function replicateBookingslotstoHistory()
{
    $date_today = date("Y-m-d");

    // Step 1: Get all rows before today
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_booking_slots_child 
        WHERE date < ?
    ");
    $stmt->execute([$date_today]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $count = count($rows);

    if ($count == 0) {
        echo "No old booking slot records to archive.<br/>";
        return false;
    }

    // Step 2: Insert into mt_booking_slots_child_history
    foreach ($rows as $row) {
        $columns = array_keys($row);
        $values = [];

        foreach ($row as $value) {
            $escaped = addslashes($value);
            $values[] = "'$escaped'";
        }

        $insert_sql = "INSERT INTO mt_booking_slots_child_history (" . implode(',', $columns) . ") 
                       VALUES (" . implode(',', $values) . ")";

        $this->db->exec($insert_sql);
    }

    // Step 3: Delete old records from mt_booking_slots_child
    $delete_stmt = $this->db->prepare("
        DELETE FROM mt_booking_slots_child 
        WHERE date < ?
    ");
    $delete_stmt->execute([$date_today]);

    // Final message
    echo "Successfully archived and deleted $count old booking slot record(s).<br/>";

    return true;
}





public function CheckOrderStatusPaymentGateway()
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_order 
        WHERE status = 'initial_order' 
        
        AND (gateway_status IS NULL OR gateway_status != 'cancelled')
         AND DATE(date_created) >= CURDATE() - INTERVAL 1 DAY
        AND payment_type IN ('poli', 'windcave', 'stp', 'paypal_v2') 
        ORDER BY order_id DESC 
        LIMIT 10
    ");
    $stmt->execute();

    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $processed_order_ids = []; 

    foreach ($orders as $order) {
        $payment_type = $order['payment_type']; 
        $order_id = $order['order_id'];
        $client_id = $order['client_id'];

        switch ($payment_type) {
            case 'poli':
                if (!empty($order['payment_gateway_ref'])) {
                    $token = $order['payment_gateway_ref'];
                    $merchant_id = $order['merchant_id'];

                    /*
					$paymode = $this->functions->getOption('merchant_poli_mode', $merchant_id);
                    if ($paymode == 'live') {
                        $mer_code = $this->functions->getOption('merchant_poli_merchant_id', $merchant_id);
                        $authkey = $this->functions->getOption('merchant_auth_poli_code', $merchant_id);
                        $api_url = "https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=" . urlencode($token);
                    } else {
                        $mer_code = $this->functions->getOption('merchant_poli_merchant_id_sandbox', $merchant_id);
                        $authkey = $this->functions->getOption('merchant_auth_poli_code_sandbox', $merchant_id);
                        $api_url = "https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=" . urlencode($token);
                    }
					*/
					 $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);    
                
              if($merchant_type=='1'){  

              $paymode=$this->functions->getOption('merchant_poli_mode',$merchant_id);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$merchant_id);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$merchant_id);
           $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }
              }else{    
               $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          
          }

         


              } 
					
					
					
					
                    $auth = base64_encode($mer_code . ':' . $authkey);
                    $headers = ['Authorization: Basic ' . $auth];

                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $response = curl_exec($ch);
                    curl_close($ch);

                    $json = json_decode($response, true);

                    $this->functions->updateData('mt_order', ['gateway_response' => json_encode($json)], 'order_id', $order_id);

                    $status = $json['TransactionStatusCode'] ?? '';
                    $amount_paid = floatval($json['AmountPaid'] ?? 0);

                    if ($status === 'Completed' && $amount_paid > 0) {
                        $params_logs = [
                            'order_id' => $order_id,
                            'payment_type' => "poli",
                            'payment_reference' => $json['TransactionRefNo'] ?? '',
                            'raw_response' => json_encode($json),
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        ];
                        $this->functions->insertData('mt_payment_order', $params_logs);

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
                        $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

                        $params_update = [
                            'status' => 'paid',
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'order_number' => $order_number,
                        ];
                        $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
                        $this->executeAddons($order_id);
						$this->sendNotification($order_id);

                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>'paid',
                        'remarks'=>'paid',
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log); 
						
						

                        $processed_order_ids[] = $order_id;
                    } elseif (in_array($status, ['Failed', 'Cancelled', 'TimedOut']) || ($amount_paid == 0 && $status !== 'Completed')) {
                        
						
						if(isset($status) && !empty($status)){ 
						$this->functions->updateData('mt_order', ['gateway_status' =>$status], 'order_id', $order_id);

                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>$status,
                        'remarks'=>$status
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log); 

						}
						
						
                    }
                }
                break;

            case 'windcave':
                if (!empty($order['payment_gateway_ref'])) {
                    $session_id = $order['payment_gateway_ref'];
                    $merchant_id = $order['merchant_id'];
                    $response = $this->functions->get_windcave_payment_status($session_id, $merchant_id);

                    $this->functions->updateData('mt_order', ['gateway_response' => json_encode($response)], 'order_id', $order_id);

					   $transaction = isset($response['transactions'][0]) ? $response['transactions'][0] : [];

        $authorised = !empty($transaction['authorised']);
        $responseCode = isset($transaction['reCo']) ? $transaction['reCo'] : '';
        $responseText = isset($transaction['responseText']) ? strtoupper($transaction['responseText']) : '';

                    if (
             isset($response['state']) && strtolower($response['state']) === 'complete' &&
            $authorised === true &&
            $responseText === 'APPROVED'
        ) {
                        $params_logs = [
                            'order_id' => $order_id,
                            'payment_type' => "windcave",
                            'payment_reference' => "",
                            'raw_response' => json_encode($response),
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR']
                        ];
                        $this->functions->insertData('mt_payment_order', $params_logs);

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
                        $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

                        $params_update = [
                            'status' => 'paid',
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'order_number' => $order_number,
							'gateway_status' =>$responseText,
                        ];
                        $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
                        $this->executeAddons($order_id);
						$this->sendNotification($order_id);

                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>'paid',
                        'remarks'=>'paid',
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log);


                        $processed_order_ids[] = $order_id;
                    } elseif ( in_array($state, ['failed', 'cancelled', 'declined']) ||
            $authorised === false ||
            $responseText !== 'APPROVED') {
                        $this->functions->updateData('mt_order', ['gateway_status' => $responseText], 'order_id', $order_id);
                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>$responseText,
                        'remarks'=>$responseText,
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log); 
                    }
                }
                break;

                     case 'stp':
    if (!empty($order['payment_gateway_ref'])) {
        $payment_intent = $order['payment_gateway_ref'];
        $merchant_id = $order['merchant_id'];

        if (strpos($payment_intent, "pi_") === 0) {
            // It's a PaymentIntent
            $response = $this->functions->get_stp_payment_status_stripe_test($payment_intent, $merchant_id);
        } elseif (strpos($payment_intent, "cs_") === 0) {
            // It's a Checkout Session
            $response = $this->functions->get_stp_payment_status($payment_intent, $merchant_id);
        }

        // Log entire response for debugging/audit
        $this->functions->updateData('mt_order', ['gateway_response' => json_encode($response)], 'order_id', $order_id);

        // ----- SUCCESS -----
        if (isset($response->status) && $response->status === 'succeeded') {
            $params_logs = [
                'order_id' => $order_id,
                'payment_type' => "stp",
                'payment_reference' => $payment_intent,
                'raw_response' => json_encode($response),
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
            ];
            $this->functions->insertData('mt_payment_order', $params_logs);

            $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
            $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

            $params_update = [
                'status' => 'paid',
                'gateway_status' => $response->status,
                'date_modified' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'order_number' => $order_number,
            ];
            $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
            $this->executeAddons($order_id);
            $this->sendNotification($order_id);

            $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>'paid',
                        'remarks'=>'paid',
                      
                        ); 

            $this->functions->insertData('mt_order_log', $params_log);



            $processed_order_ids[] = $order_id;

        // ----- FAILURE OR CANCELED -----
        } elseif (isset($response->status)) {
            // Default to Stripe status
            $gateway_status = $response->status;

            // If Stripe charge exists, extract failure message (if any)
            if (isset($response->charges->data[0]->failure_message) && !empty($response->charges->data[0]->failure_message)) {
                $gateway_status = $response->charges->data[0]->failure_message;
            } elseif (isset($response->last_payment_error->message) && !empty($response->last_payment_error->message)) {
                $gateway_status = $response->last_payment_error->message;
            }

            $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>$gateway_status,
                        'remarks'=>$gateway_status,
                      
                        ); 

            $this->functions->insertData('mt_order_log', $params_log); 

            $this->functions->updateData('mt_order', [
                'gateway_status' => $gateway_status,
                'date_modified' => $this->functions->dateNow(),
            ], 'order_id', $order_id);
        }
    }
    break;

            case 'paypal_v2':
                if (!empty($order['payment_gateway_ref'])) {
                    $paypal_order_id = $order['payment_gateway_ref'];
                    $merchant_id = $order['merchant_id'];
                    $response = $this->functions->get_paypal_payment_status($paypal_order_id, $merchant_id);

                    $this->functions->updateData('mt_order', ['gateway_response' => json_encode($response)], 'order_id', $order_id);

                    if (isset($response['status']) && $response['status'] === 'COMPLETED') {
                        $params_logs = [
                            'order_id' => $order_id,
                            'payment_type' => "paypal_v2",
                            'payment_reference' => $paypal_order_id,
                            'raw_response' => json_encode($response),
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        ];
                        $this->functions->insertData('mt_payment_order', $params_logs);

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
                        $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

                        $params_update = [
                            'status' => 'paid',
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'order_number' => $order_number,
                        ];
                        $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
                        $this->executeAddons($order_id);
						$this->sendNotification($order_id);

                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>'paid',
                        'remarks'=>'paid',
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log);


                        $processed_order_ids[] = $order_id;
                    } elseif (isset($response['status']) && in_array($response['status'], ['CANCELLED', 'FAILED'])) {
                        $this->functions->updateData('mt_order', ['gateway_status' => 'cancelled'], 'order_id', $order_id);
                        $params_log=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"cancelled",
                        'remarks'=>"cancelled",
                      
                        ); 

                        $this->functions->insertData('mt_order_log', $params_log); 
                    }
                }
                break;
        }
    }

    if (!empty($processed_order_ids)) {
		
				
  $logFile1 = __DIR__ . '/../../logs/order_restore.log';

// Get raw request input
$rawInput = file_get_contents('php://input');

// Example processed order IDs (replace with your real data)
//$processed_order_ids = [101, 102, 103];

file_put_contents(
    $logFile1,
    date('c') . " Processed Order IDs: " . implode(', ', $processed_order_ids) . "\n",
    FILE_APPEND
);
		
        echo "Processed Order IDs: " . implode(', ', $processed_order_ids);
    } else {
        echo "No orders were processed.";
    }
}


public function CheckOrderStatusPaymentGateway_stp()
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_order 
        WHERE 1
        AND order_id='1984'
        
        ORDER BY order_id DESC 
        LIMIT 10
    ");
    $stmt->execute();

    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $processed_order_ids = []; 

    foreach ($orders as $order) {
        $payment_type = $order['payment_type']; 
        $order_id = $order['order_id'];
        $client_id = $order['client_id'];

        switch ($payment_type) {
            

            case 'stp':
    if (!empty($order['payment_gateway_ref'])) {
        $payment_intent = $order['payment_gateway_ref'];
        $merchant_id = $order['merchant_id'];

        if (strpos($payment_intent, "pi_") === 0) {
            // It's a PaymentIntent
            $response = $this->functions->get_stp_payment_status_stripe_test($payment_intent, $merchant_id);
        } elseif (strpos($payment_intent, "cs_") === 0) {
            // It's a Checkout Session
            $response = $this->functions->get_stp_payment_status($payment_intent, $merchant_id);
        }

	
	print_r($response);die();



        // Log entire response for debugging/audit
        $this->functions->updateData('mt_order', ['gateway_response' => json_encode($response)], 'order_id', $order_id);

        // ----- SUCCESS -----
        if (isset($response->status) && $response->status === 'succeeded') {
            $params_logs = [
                'order_id' => $order_id,
                'payment_type' => "stp",
                'payment_reference' => $payment_intent,
                'raw_response' => json_encode($response),
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
            ];
            $this->functions->insertData('mt_payment_order', $params_logs);

            $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
            $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

            $params_update = [
                'status' => 'paid',
                'gateway_status' => $response->status,
                'date_modified' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'order_number' => $order_number,
            ];
            $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
            $this->executeAddons($order_id);
            $this->sendNotification($order_id);

            $processed_order_ids[] = $order_id;

        // ----- FAILURE OR CANCELED -----
        } elseif (isset($response->status)) {
            // Default to Stripe status
            $gateway_status = $response->status;

            // If Stripe charge exists, extract failure message (if any)
            if (isset($response->charges->data[0]->failure_message) && !empty($response->charges->data[0]->failure_message)) {
                $gateway_status = $response->charges->data[0]->failure_message;
            } elseif (isset($response->last_payment_error->message) && !empty($response->last_payment_error->message)) {
                $gateway_status = $response->last_payment_error->message;
            }

            $this->functions->updateData('mt_order', [
                'gateway_status' => $gateway_status,
                'date_modified' => $this->functions->dateNow(),
            ], 'order_id', $order_id);
        }
    }
    break;


            
        }
    }

    if (!empty($processed_order_ids)) {
        
                
  $logFile1 = __DIR__ . '/../../logs/order_restore.log';

// Get raw request input
$rawInput = file_get_contents('php://input');

// Example processed order IDs (replace with your real data)
//$processed_order_ids = [101, 102, 103];

file_put_contents(
    $logFile1,
    date('c') . " Processed Order IDs: " . implode(', ', $processed_order_ids) . "\n",
    FILE_APPEND
);
        
        echo "Processed Order IDs: " . implode(', ', $processed_order_ids);
    } else {
        echo "No orders were processed.";
    }
}






 public  function executeAddons($order_id='')
    {
        
         if(!$order_info=$this->functions->getOrderInfo($order_id)){
            return false;
         } 

         $this->PointsProgram=new PointsProgram();
         $this->InventoryWrapper=new InventoryWrapper();
                  
         $this->functions->sendFax($order_info['merchant_id'],$order_id);
         
         $client_id = isset($order_info['client_id'])?$order_info['client_id']:'';
         
         /*POINTS PROGRAM*/ 
         
                                       
        $this->PointsProgram->updateOrderBasedOnStatus( $order_info['status'] , $order_id);
            
        
        
          
                 
         /*inventory*/      
         if($this->functions->inventoryEnabled($order_info['merchant_id'])){
            try {                                         
               $this->InventoryWrapper->insertInventorySale($order_id,strtolower($order_info['status']));  
            } catch (Exception $e) {                                            
              // echo $e->getMessage();                       
            }                                        
         }
         
    }
	
	
	
	
	
	
	
	
	public  function sendNotification($order_id='')
    {
        $error='';
        
               
       
        
        try {
            
            $print_resp = $this->prepareReceipt($order_id);
            $print = $print_resp['print'];
            $print_data = $print_resp['data'];
            $print_additional_details = $print_resp['additional_details'];
            $print_raw = $print_resp['raw'];
            
            $to=isset($print_data['email_address'])?$print_data['email_address']:'';
            $receipt=$this->functions->salesReceipt($print, $print_resp['raw'] );    
                                    
            $this->functions->notifyCustomer($print_data,$print_additional_details,$receipt, $to);
           $this->functions->notifyMerchant($print_data,$print_additional_details,$receipt);
             $this->functions->notifyAdmin($print_data,$print_additional_details,$receipt);
            
          
            
            
            $merchant_id = 0;            
            $merchant_id = $print_data['merchant_id'];            
            
           
            
        } catch (Exception $e){
          
        }   
    }


    public  function prepareReceipt($order_id='')
    {
        $_GET['backend']=true; $print = array();        
        if ( $data = $this->functions->getReceiptByID($order_id)){
            
            
            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $this->functions->getCurrencyCode() ;
            
            
            if ( $json_details !=false){
                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               
               /* Custom code 13 starts */
               'promo_id'=>$data['promo_id'],
               /* Custom code 13 ends */
               
               'tax_set'=>isset($data['tax'])?$data['tax']:'',
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
              ),$json_details,true,$order_id);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>$this->functions->translation("default","ABN"),
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>$this->functions->translation("default","Telephone"),'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];
        
            $print[]=array('label'=>$this->functions->translation("default","Address"),'value'=>$full_merchant_address);
            
            $print[]=array('label'=>$this->functions->translation("default","TRN Type"),'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Payment Type"),
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>$this->functions->translation("default","Card#"),'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>$this->functions->translation("default","Paypal Transaction ID"),
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>$this->functions->translation("default","Reference #"),
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            
            if($data['request_from']=="pos" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );
            
            
            
            }
            
            
            
            if($data['request_from']=="webappv2" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );

            
            }
            
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Payment Ref"),
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Card #"),
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>$this->functions->translation("default","TRN Date"),
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>$this->functions->translation("default","Delivery Date"),
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$this->functions->translation("default","Delivery Time"),
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?"Yes":'';
                        $print[]=array(
                         'label'=>$this->functions->translation("default","Deliver ASAP"),
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Deliver to"),
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Delivery Instruction"),
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Location Name"),
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                //  Custom code 12 starts
                    if($data['car_park_enable']== 1 && isset($data['number_plate']) && !empty($data['number_plate'])){
                        $print[]=array('label'=>"Car Park Delivery",'value'=>"Yes");
                        $print[]=array('label'=>"Number Plate",'value'=>$data['number_plate']); 
                     }
                //  Custom code 12 ends
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            return array(
             'merchant_id'=>$merchant_id,
             'print'=>$print,
             'raw'=>$displayOrderHTML['raw'],
             'data'=>$data,
             'additional_details'=>""
            );
            
        } else {}
    }
	
	
	
	
	
	
	


   public function getSlotsforMerchant_x()
{
    $merchant_id = $_GET['merchant_id'];
     
    $days = $_GET['days']; // Example value, can be passed dynamically

    $merchantId =$this->functions->getOption("booking_id",$merchant_id);

    // Calculate date range
    $today = date('Y-m-d');
    $endDate = date('Y-m-d', strtotime("+".($days - 1)." days"));

    // Prepare query
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_booking_slots_child
        WHERE merchant_id = ?
          AND date >= ?
          AND date <= ?
        ORDER BY date ASC, utc_times ASC
    ");
    
    // Execute query
    $stmt->execute([$merchant_id, $today, $endDate]);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => "11203880",
            "generation_timestamp" => time()
        ],
        "service_availability" => [
            [
                "availability" => []
            ]
        ]
    ];


    foreach ($slots as $slot) {
        $data["service_availability"][0]["availability"][] = [
            "spots_total" => $slot['no_of_slots'],
            "spots_open" => $slot['available_slots'],
            "duration_sec" => 1800,
            "service_id" => "reservation",
            "start_sec" => (int)$slot['utc_times'], // from DB
            "merchant_id" => $merchantId,
            "resources" => [
                "party_size" => $slot['person_per_party']
            ],
            "confirmation_mode" => "CONFIRMATION_MODE_SYNCHRONOUS"
        ];
    }

    header('Content-Type: application/json');
echo json_encode($data, JSON_PRETTY_PRINT);
exit;

   

 

}


public function getSlotsforMerchant()
{
    ini_set('memory_limit', '512M');
    $merchant_id = $_GET['merchant_id'];
    $days = $_GET['days']; // Can be passed dynamically
    $download = isset($_GET['download']) ? $_GET['download'] : 0; // default 0

    $merchantId = $this->functions->getOption("booking_id", $merchant_id);
    $duration_sec =$this->functions->getOption("google_merchant_duration", $merchant_id);
    $duration_sec = !empty($duration_sec) ? (int)$duration_sec : 1800;  

    // Calculate date range
    $today = date('Y-m-d');
    $endDate = date('Y-m-d', strtotime("+".($days - 1)." days"));
    $booking_confirmation_mode="CONFIRMATION_MODE_ASYNCHRONOUS";

    // Prepare query
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_booking_slots_child
        WHERE merchant_id = ?
          AND date >= ?
          AND date <= ?
        ORDER BY date ASC, utc_times ASC
    ");
    
    // Execute query
    $stmt->execute([$merchant_id, $today, $endDate]);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => time(),
            "generation_timestamp" => time()
        ],
        "service_availability" => [
            [
                "availability" => []
            ]
        ]
    ];
   

   $disable_google_reservations=$this->functions->getOption("disable_google_reservations",$merchant_id);
   if($disable_google_reservations!=1){
    foreach ($slots as $slot) {

    	if($slot['available_slots']>$slot['no_of_slots'] || $slot['available_slots']<0)			{				 header('Content-Type: application/json');    echo json_encode([        "error"   => true,        "message" => "Invalid slot data for merchant_id {$slot['merchant_id']}. available_slots={$slot['available_slots']} no_of_slots={$slot['no_of_slots']}"    ], JSON_PRETTY_PRINT);    exit;								die("no yiou cant do that");}	


        $data["service_availability"][0]["availability"][] = [
            "spots_total" => $slot['no_of_slots'],
            "spots_open" => $slot['available_slots'],
            "duration_sec" => $duration_sec,
            "service_id" => "reservation",
            "start_sec" => (int)$slot['utc_times'],
            "merchant_id" => $merchantId,
            "resources" => [
                "party_size" => $slot['person_per_party']
            ],
            "confirmation_mode" =>  $booking_confirmation_mode
        ];
    }
}

    // Convert to JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT);

    if ($download == 1) {
        // Force download as availability.json
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="availability.json"');
        header('Content-Length: ' . strlen($jsonOutput));
        echo $jsonOutput;
        exit;
    } else {
        // Just show in browser
        header('Content-Type: application/json');
        echo $jsonOutput;
        exit;
    }
}


public function getSlotsforMultiplemerchants()
{   ini_set('memory_limit', '512M');
    $days = isset($_GET['days']) ? (int)$_GET['days'] : 1;
    $download = isset($_GET['download']) ? $_GET['download'] : 0; // default 0

    // 1) Get all merchant IDs that have booking_id
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN); // only merchant_id values

   

    if (empty($merchants)) {
        print_r([]); 
        return;
    }

    // 2) Date range
    $today   = date('Y-m-d');
    //$today   ="2026-01-15";
    $endDate = date('Y-m-d', strtotime("+".($days - 1)." days"));
    //$endDate = "2026-01-30";

    // 3) Build IN clause
    $placeholders = implode(',', array_fill(0, count($merchants), '?'));

    // 4) Fetch slots for all merchants
    $sql = "
        SELECT *
        FROM mt_booking_slots_child
        WHERE merchant_id IN ($placeholders)
          AND date >= ?
          AND date <= ?
        ORDER BY merchant_id ASC, date ASC, utc_times ASC
    ";

    $stmt = $this->db->prepare($sql);

    // Merge merchant IDs + dates
    $params = array_merge($merchants, [$today, $endDate]);

    $stmt->execute($params);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    

    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" =>time(),
            "generation_timestamp" => time()
        ],
        "service_availability" => [
            [
                "availability" => []
            ]
        ]
    ];

    foreach ($slots as $slot) {

        $merchantId = $this->functions->getOption("booking_id", $slot['merchant_id']);

         $duration_sec =$this->functions->getOption("google_merchant_duration", $slot['merchant_id']);
			$duration_sec = !empty($duration_sec) ? (int)$duration_sec : 1800;	

        $confirmation_mode=$this->functions->getOption("booking_confirmation_mode",$slot['merchant_id']);

        if($confirmation_mode==""||$confirmation_mode=="confirmed"){
         $booking_confirmation_mode="CONFIRMATION_MODE_SYNCHRONOUS";
        }else{  }
		
$booking_confirmation_mode="CONFIRMATION_MODE_ASYNCHRONOUS";

        $disable_google_reservations=$this->functions->getOption("disable_google_reservations",$slot['merchant_id']);
        if($disable_google_reservations!=1){												
		
		if($slot['available_slots']>$slot['no_of_slots'] || $slot['available_slots']<0)			{				 header('Content-Type: application/json');    echo json_encode([        "error"   => true,        "message" => "Invalid slot data for merchant_id {$slot['merchant_id']}. available_slots={$slot['available_slots']} no_of_slots={$slot['no_of_slots']}"    ], JSON_PRETTY_PRINT);    exit;								die("no yiou cant do that");}						
        $data["service_availability"][0]["availability"][] = [

            "spots_total" => $slot['no_of_slots'],
            "spots_open" => $slot['available_slots'],
            "duration_sec" => $duration_sec,
            "service_id" => "reservation",
            "start_sec" => (int)$slot['utc_times'],
            "merchant_id" =>$merchantId,
            "resources" => [
                "party_size" => $slot['person_per_party']
            ],
            "confirmation_mode" => $booking_confirmation_mode
        ];
    }


//"confirmation_mode" => "CONFIRMATION_MODE_SYNCHRONOUS"



    }
    
    $this->functions->updateOptionAdmin('feed_upload', 0);

    // Convert to JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT);

    if ($download == 1) {
        // Force download as availability.json
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="availability.json"');
        header('Content-Length: ' . strlen($jsonOutput));
        echo $jsonOutput;
        exit;
    } else {
        // Just show in browser
        header('Content-Type: application/json');
        echo $jsonOutput;
        exit;
    }



   
}



public function merchant_booking_email_testing(){
	//++++for notification
	$startSec="1761114600";
    $params_notification=array(
        'booking_id'=>317,
        'booking_id_our_system'=>317,
        'merchant_id'=>"loveeatery_001_pk",
        'merchant_id_our_system'=>3,
        'number_guest'=>2,
        'date_booking'=>date('Y-m-d', $startSec),
        'booking_time'=> $this->functions->prettyTime(date('H:i:s', $startSec)), 
        'booking_name'=>"was", 
        'mobile'=>"923219673551",
        'email'=>"waseemhassan629@gmail.com", 
        'client_id'=>0
    );  

    $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id_our_system);
    $params_notification['restaurant_name']=$mt_info['restaurant_name'];

    $new_data=$params_notification;
    $this->functions->notifyBooking($new_data);
}





public function Merchant()
{
    // Step 1: Check if download mode
    $download = isset($_GET['download']) ? (int)$_GET['download'] : 0;

    // Step 2: Get merchant IDs
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        echo json_encode([]);
        return;
    }

    // Step 3: Build JSON structure
    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" =>time(),
            "generation_timestamp" => time()
        ],
        "merchant" => []
    ];

    // Step 4: Loop merchants and get info
    foreach ($merchants as $merchant_id) {
        $merchantInfo = $this->functions->getMerchantInfo_mobileapp($merchant_id);
        $merchantId = $this->functions->getOption("booking_id", $merchant_id);
        
		$phone = trim($merchantInfo['restaurant_phone'] ?? '');

// Remove spaces and dashes
$phone = str_replace([' ', '-'], '', $phone);

$country_list = $this->functions->mobilecountry_code();  
$contrycode=$merchantInfo['country_code'];



$country_code = isset($country_list[$contrycode]['code']) ? $country_list[$contrycode]['code'] : '';


// If it already starts with +64, leave it

if (strpos($phone, '+') === 0) {
    // ✅ Already has + at the start — keep as is
    $formattedPhone = $phone;
}
elseif (strpos($phone, '+' . $country_code) === 0) {
    // ✅ Starts with +country_code — keep as is
    $formattedPhone = $phone;
}
elseif (strpos($phone, $country_code) === 0) {
    // ✅ Starts with country code (no +) — add +
    $formattedPhone = '+' . $phone;
}
elseif (strpos($phone, '0') === 0) {
    // ✅ Starts with 0 — replace 0 with +country_code
    $formattedPhone = '+' . $country_code . substr($phone, 1);
}
else {
    // ✅ Otherwise — just prepend +country_code
    $formattedPhone = '+' . $country_code . $phone;
}


$contacts = $formattedPhone;


	

        // Force exactly 6 decimal places as strings
        $latitude = number_format((float)$merchantInfo['latitude'], 6, '.', '');
        $longitude = number_format((float)$merchantInfo['lontitude'], 6, '.', '');

		$urls=Config::$baseUrl.'/menu/'.trim($merchantInfo['restaurant_slug']);

        $disable_google_reservations=$this->functions->getOption("disable_google_reservations",$merchant_id);

        if($disable_google_reservations!=1){
        $data["merchant"][] = [
            "category" => "RESTAURANT",
            "merchant_id" => $merchantId,
            "name" => $merchantInfo['restaurant_name'],
            "url" =>$urls,
            "telephone" =>$contacts,
            "geo" => [
                "latitude" => $latitude,
                "longitude" => $longitude,
                "address" => [
                    "street_address" => $merchantInfo['street'],
                    "locality" => $merchantInfo['city'],
                    "region" => $merchantInfo['state'],
                    "postal_code" => $merchantInfo['post_code'],
                    "country" => $merchantInfo['country_code']
                ]
            ]
        ];
    }




    }

    // Step 5: Output or download JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    if ($download === 1) {
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="merchant.json"');
        echo $jsonOutput;
    } else {
        header('Content-Type: application/json');
        echo $jsonOutput;
    }
}



public function Merchant_test()
{
    // Step 1: Check if download mode (can be ignored if saving to server)
    //$download = isset($_GET['download']) ? (int)$_GET['download'] : 0;

    // Step 2: Get merchant IDs
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        echo json_encode([]);
        return;
    }

    // Step 3: Build JSON structure
    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => time(),
            "generation_timestamp" => time()
        ],
        "merchant" => []
    ];

    // Step 4: Loop merchants and get info
    foreach ($merchants as $merchant_id) {
        $merchantInfo = $this->functions->getMerchantInfo_mobileapp($merchant_id);
        $merchantId = $this->functions->getOption("booking_id", $merchant_id);
        
        $phone = trim($merchantInfo['restaurant_phone'] ?? '');
        $phone = str_replace([' ', '-'], '', $phone);

        $country_list = $this->functions->mobilecountry_code();  
        $contrycode = $merchantInfo['country_code'];
        $country_code = $country_list[$contrycode]['code'] ?? '';

        if (strpos($phone, '+') === 0) {
            $formattedPhone = $phone;
        } elseif (strpos($phone, '+' . $country_code) === 0) {
            $formattedPhone = $phone;
        } elseif (strpos($phone, $country_code) === 0) {
            $formattedPhone = '+' . $phone;
        } elseif (strpos($phone, '0') === 0) {
            $formattedPhone = '+' . $country_code . substr($phone, 1);
        } else {
            $formattedPhone = '+' . $country_code . $phone;
        }

        $contacts = $formattedPhone;

        $latitude = number_format((float)$merchantInfo['latitude'], 6, '.', '');
        $longitude = number_format((float)$merchantInfo['lontitude'], 6, '.', '');
        $urls = Config::$baseUrl . '/menu/' . trim($merchantInfo['restaurant_slug']);

        $disable_google_reservations = $this->functions->getOption("disable_google_reservations", $merchant_id);

        if ($disable_google_reservations != 1) {
            $data["merchant"][] = [
                "category" => "RESTAURANT",
                "merchant_id" => $merchantId,
                "name" => $merchantInfo['restaurant_name'],
                "url" => $urls,
                "telephone" => $contacts,
                "geo" => [
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "address" => [
                        "street_address" => $merchantInfo['street'],
                        "locality" => $merchantInfo['city'],
                        "region" => $merchantInfo['state'],
                        "postal_code" => $merchantInfo['post_code'],
                        "country" => $merchantInfo['country_code']
                    ]
                ]
            ];
        }
    }

    // Step 5: Convert to JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    // --- Save JSON to server instead of download ---
    $currentDir = __DIR__;                 // current directory of this PHP file
    $feedDir = $currentDir . '/feeds';      // feeds folder
    if (!is_dir($feedDir)) {
        mkdir($feedDir, 0777, true);      // create folder if not exists
    }

    $filePath = $feedDir . '/merchant.json';
    file_put_contents($filePath, $jsonOutput);

    echo "JSON file saved to: $filePath\n";
}





public function Service()
{
    // Step 1: Check if download mode
    $download = isset($_GET['download']) ? (int)$_GET['download'] : 0;

    // Step 2: Get merchant IDs from DB
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        echo json_encode([]);
        return;
    }

    // Step 3: Build services array
    $services = [];



    foreach ($merchants as $merchant_id) {
        // booking_id from mt_option table
        $bookingId = $this->functions->getOption("booking_id", $merchant_id);

        $disable_google_reservations=$this->functions->getOption("disable_google_reservations",$merchant_id);


        if($disable_google_reservations!=1){
        if (!empty($bookingId)) {
            $services[] = [
                "merchant_id" =>$bookingId,
                "localized_service_name" => [
                    "value" => "Reservation",
                    "localized_value" => [
                        [
                            "locale" => "en",
                            "value" => "Reservation"
                        ]
                    ]
                ],
                "service_id" => "reservation",
                "prepayment_type" => "NOT_SUPPORTED"
            ];
        }
    }



    }

    // Step 4: Full JSON structure
    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" =>time(),
            "generation_timestamp" => time()
        ],
        "service" => $services
    ];

    // Step 5: Encode JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    // Step 6: Output or download
    header('Content-Type: application/json');
    if ($download === 1) {
        header('Content-Disposition: attachment; filename="services.json"');
    }
    echo $jsonOutput;
}











 
//--------cron functions



//+++++++++++++++++auto slot cron functionality







public function auto_slot_cron_bkup1()
{
    // --- Step 1: Fetch one merchant that has auto slot cron enabled and data validated ---
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_merchant
        WHERE google_res_enable = 1
          AND auto_slot_cron = 1
          AND data_validation = 1
        ORDER BY merchant_id ASC
        LIMIT 1
    ");
    $stmt->execute();
    $merchant = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$merchant) {
        echo "No merchant found for auto slot cron.\n";
        return;
    }

    $merchant_id = $merchant['merchant_id'];

    // --- Step 2: Validate merchant booking data ---
    if (!$this->functions->isBookingDataValid($merchant_id)) {
        $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id has invalid booking data. Skipping.\n";
        return;
    }

    echo "Merchant $merchant_id validated. Starting slot generation...\n";

    $today = new DateTime('today');
    $days_to_generate = 30; // total calendar days
    $max_days_per_run = 7;  // max days to add per cron run

    // --- Step 3: Determine start date for new slots ---
    $stmt = $this->db->prepare("
        SELECT MAX(date) AS last_date
        FROM mt_booking_slots
        WHERE merchant_id = ?
    ");
    $stmt->execute([$merchant_id]);
    $last_slot = $stmt->fetch(PDO::FETCH_ASSOC);
    $last_date = $last_slot['last_date'] ?? null;

    $startDate = $last_date ? new DateTime($last_date) : clone $today;
    if ($last_date) $startDate->modify('+1 day');

    // --- Step 4: Calculate remaining calendar days ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $days_existing = (int)($stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0);

    $days_remaining = max(0, $days_to_generate - $days_existing);
    if ($days_remaining <= 0) {
        $this->functions->updateData("mt_merchant", ['auto_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id already has 30 calendar days of slots. Cron completed.\n";
        return;
    }

    $days_this_run = min($days_remaining, $max_days_per_run);
    echo "Generating $days_this_run calendar day(s) of slots for merchant $merchant_id...\n";

    // --- Step 5: Fetch merchant settings ---
    $stores_open_starts_raw   = $this->functions->getOption('stores_open_starts', $merchant_id);
    $stores_open_ends_raw     = $this->functions->getOption('stores_open_ends', $merchant_id);
    $stores_open_pm_start_raw = $this->functions->getOption('stores_open_pm_start', $merchant_id);
    $stores_open_pm_ends_raw  = $this->functions->getOption('stores_open_pm_ends', $merchant_id);
    $stores_open_day_raw      = $this->functions->getOption('stores_open_day', $merchant_id);

    $stores_open_starts   = !empty($stores_open_starts_raw)   ? (array)json_decode($stores_open_starts_raw, true)   : [];
    $stores_open_ends     = !empty($stores_open_ends_raw)     ? (array)json_decode($stores_open_ends_raw, true)     : [];
    $stores_open_pm_start = !empty($stores_open_pm_start_raw) ? (array)json_decode($stores_open_pm_start_raw, true) : [];
    $stores_open_pm_ends  = !empty($stores_open_pm_ends_raw)  ? (array)json_decode($stores_open_pm_ends_raw, true)  : [];
    $stores_open_day      = !empty($stores_open_day_raw)      ? (array)json_decode($stores_open_day_raw, true)      : [];

    $party_size = (int)$this->functions->getOption('party_size', $merchant_id) ?: 1;
    $number_of_slots = (int)$this->functions->getOption('number_of_slots', $merchant_id) ?: 3;
    $merchant_holidays = $this->functions->getMerchantHoliday($merchant_id) ?: [];

    // --- Normalize open days correctly ---
    $normalized_days = [];
    if (!empty($stores_open_day)) {
        foreach ($stores_open_day as $day) {
            if (is_string($day) && trim($day) !== '') {
                $normalized_days[] = strtolower(trim($day));
            }
        }
        $normalized_days = array_unique($normalized_days);
    }

    // Convert PM times to 24h format
    foreach ($stores_open_pm_start as $day => $time) if (!empty($time)) $stores_open_pm_start[$day] = date("H:i", strtotime($time));
    foreach ($stores_open_pm_ends as $day => $time) if (!empty($time)) $stores_open_pm_ends[$day] = date("H:i", strtotime($time));

    // --- Step 6: Loop to generate slots ---
    for ($i = 0; $i < $days_this_run; $i++) {
        $currentDate = $startDate->format('Y-m-d');
        $dayName = strtolower($startDate->format('l'));

        // Skip completely if the day is not open
        if (!in_array($dayName, $normalized_days)) {
            $startDate->modify('+1 day');
            $i--; // Do not count this as a generated day
            continue;
        }

        // Get shifts
        $shift1_start = $stores_open_starts[$dayName] ?? '';
        $shift1_end   = $stores_open_ends[$dayName] ?? '';
        $shift2_start = $stores_open_pm_start[$dayName] ?? '';
        $shift2_end   = $stores_open_pm_ends[$dayName] ?? '';

        $hasShift1 = !empty($shift1_start) && !empty($shift1_end) && strtotime($shift1_start) < strtotime($shift1_end);
        $hasShift2 = !empty($shift2_start) && !empty($shift2_end) && strtotime($shift2_start) < strtotime($shift2_end);

        $enabled = ($hasShift1 || $hasShift2) && !in_array($currentDate, $merchant_holidays) ? 1 : 0;
        $available_count = $enabled ? $number_of_slots : 0;

        // Insert parent slot (even if disabled)
        $parent_params = [
            'merchant_id'      => $merchant_id,
            'date_created'     => $this->functions->dateNow(),
            'date'             => $currentDate,
            'enabled'          => $enabled,
            'shift1_start'     => $shift1_start,
            'shift1_end'       => $shift1_end,
            'shift2_start'     => $shift2_start,
            'shift2_end'       => $shift2_end,
            'person_per_party' => $party_size,
            'no_of_slots'      => $number_of_slots,
            'used_slots'       => 0,
        ];
        $parent_id = $this->functions->insertData('mt_booking_slots', $parent_params);

        // Generate child slots only if enabled
        if ($parent_id && $enabled) {
            $all_slots = array_unique(array_merge(
                $this->functions->generateTimeSlots($shift1_start, $shift1_end),
                $this->functions->generateTimeSlots($shift2_start, $shift2_end)
            ), SORT_REGULAR);

            foreach ($all_slots as $slot) {
                for ($ii = 1; $ii <= $party_size; $ii++) {
                    $localDateTimeStr = "$currentDate {$slot[0]}";
                    $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));
                    $localDateTime->setTimezone(new DateTimeZone('UTC'));
                    $utcFormatted = $localDateTime->format('Y-m-d H:i:s');

                    $child_params = [
                        'parent_id'       => $parent_id,
                        'merchant_id'     => $merchant_id,
                        'slot_starts'     => $slot[0],
                        'slot_ends'       => $slot[1],
                        'person_per_party'=> $ii,
                        'date_created'    => $this->functions->dateNow(),
                        'no_of_slots'     => $number_of_slots,
                        'available_slots' => $available_count,
                        'date'            => $currentDate,
                        'utc_times'       => $utcFormatted,
                    ];
                    $this->functions->insertData('mt_booking_slots_child', $child_params);
                }
            }
        }

        $startDate->modify('+1 day'); // next calendar day
    }

    // --- Step 7: Check if 30 calendar days completed ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $total_days = $stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0;

    if ($total_days >= 30) {
        $this->functions->updateData("mt_merchant", ['auto_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "30 calendar days completed. Auto slot cron disabled for merchant $merchant_id.\n";
    } else {
        echo "Partial slots generated. Remaining days will be added in next cron run.\n";
    }
}



public function auto_slot_cron()
{
    // --- Step 1: Fetch one merchant that has auto slot cron enabled and data validated ---
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_merchant
        WHERE google_res_enable = 1
          AND auto_slot_cron = 1
          AND data_validation = 1
        ORDER BY merchant_id ASC
        LIMIT 1
    ");
    $stmt->execute();
    $merchant = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$merchant) {
        echo "No merchant found for auto slot cron.\n";
        return;
    }

    $merchant_id = $merchant['merchant_id'];

    // --- Step 2: Validate merchant booking data ---
    if (!$this->functions->isBookingDataValid($merchant_id)) {
        $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id has invalid booking data. Skipping.\n";
        return;
    }

    echo "Merchant $merchant_id validated. Starting slot generation...\n";

    $today = new DateTime('today');
    $days_to_generate = 37; // total calendar days
    $max_days_per_run = 7;  // max days to add per cron run

    // --- Step 3: Determine start date for new slots ---
    $stmt = $this->db->prepare("
        SELECT MAX(date) AS last_date
        FROM mt_booking_slots
        WHERE merchant_id = ?
    ");
    $stmt->execute([$merchant_id]);
    $last_slot = $stmt->fetch(PDO::FETCH_ASSOC);
    $last_date = $last_slot['last_date'] ?? null;

    $startDate = $last_date ? new DateTime($last_date) : clone $today;
    if ($last_date) $startDate->modify('+1 day');

    // --- Step 4: Calculate remaining calendar days ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $days_existing = (int)($stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0);

    $days_remaining = max(0, $days_to_generate - $days_existing);
    if ($days_remaining <= 0) {
        $this->functions->updateData("mt_merchant", ['auto_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id already has 30 calendar days of slots. Cron completed.\n";
        return;
    }

    $days_this_run = min($days_remaining, $max_days_per_run);
    echo "Generating $days_this_run calendar day(s) of slots for merchant $merchant_id...\n";

    // --- Step 5: Fetch merchant settings ---
    $stores_open_starts_raw   = $this->functions->getOption('stores_open_starts', $merchant_id);
    $stores_open_ends_raw     = $this->functions->getOption('stores_open_ends', $merchant_id);
    $stores_open_pm_start_raw = $this->functions->getOption('stores_open_pm_start', $merchant_id);
    $stores_open_pm_ends_raw  = $this->functions->getOption('stores_open_pm_ends', $merchant_id);
    $stores_open_day_raw      = $this->functions->getOption('stores_open_day', $merchant_id);

    $stores_open_starts   = !empty($stores_open_starts_raw)   ? (array)json_decode($stores_open_starts_raw, true)   : [];
    $stores_open_ends     = !empty($stores_open_ends_raw)     ? (array)json_decode($stores_open_ends_raw, true)     : [];
    $stores_open_pm_start = !empty($stores_open_pm_start_raw) ? (array)json_decode($stores_open_pm_start_raw, true) : [];
    $stores_open_pm_ends  = !empty($stores_open_pm_ends_raw)  ? (array)json_decode($stores_open_pm_ends_raw, true)  : [];
    $stores_open_day      = !empty($stores_open_day_raw)      ? (array)json_decode($stores_open_day_raw, true)      : [];

    $party_size = (int)$this->functions->getOption('party_size', $merchant_id) ?: 1;
    $number_of_slots = (int)$this->functions->getOption('number_of_slots', $merchant_id) ?: 3;
    $merchant_holidays = $this->functions->getMerchantHoliday($merchant_id) ?: [];

    // --- Normalize open days correctly ---
    $normalized_days = [];
    if (!empty($stores_open_day)) {
        foreach ($stores_open_day as $day) {
            if (is_string($day) && trim($day) !== '') {
                $normalized_days[] = strtolower(trim($day));
            }
        }
        $normalized_days = array_unique($normalized_days);
    }

    // Convert PM times to 24h format
    foreach ($stores_open_pm_start as $day => $time) if (!empty($time)) $stores_open_pm_start[$day] = date("H:i", strtotime($time));
    foreach ($stores_open_pm_ends as $day => $time) if (!empty($time)) $stores_open_pm_ends[$day] = date("H:i", strtotime($time));

    // --- Step 6: Loop to generate slots ---
    for ($i = 0; $i < $days_this_run; $i++) {
        $currentDate = $startDate->format('Y-m-d');
        $dayName = strtolower($startDate->format('l'));

        // Skip if day not open
        if (!in_array($dayName, $normalized_days)) {
            $startDate->modify('+1 day');
            $i--;
            continue;
        }

        // --- ❗ FIX: Skip completely if holiday (NO parent, NO child) ---
        if (in_array($currentDate, $merchant_holidays)) {
            $startDate->modify('+1 day');
            $i--;
            continue;
        }

        // Get shifts
        $shift1_start = $stores_open_starts[$dayName] ?? '';
        $shift1_end   = $stores_open_ends[$dayName] ?? '';
        $shift2_start = $stores_open_pm_start[$dayName] ?? '';
        $shift2_end   = $stores_open_pm_ends[$dayName] ?? '';

        $hasShift1 = !empty($shift1_start) && !empty($shift1_end) && strtotime($shift1_start) < strtotime($shift1_end);
        $hasShift2 = !empty($shift2_start) && !empty($shift2_end) && strtotime($shift2_start) < strtotime($shift2_end);

        $enabled = ($hasShift1 || $hasShift2) ? 1 : 0;
        $available_count = $enabled ? $number_of_slots : 0;

        // Insert parent slot (only if not holiday)
        $parent_params = [
            'merchant_id'      => $merchant_id,
            'date_created'     => $this->functions->dateNow(),
            'date'             => $currentDate,
            'enabled'          => $enabled,
            'shift1_start'     => $shift1_start,
            'shift1_end'       => $shift1_end,
            'shift2_start'     => $shift2_start,
            'shift2_end'       => $shift2_end,
            'person_per_party' => $party_size,
            'no_of_slots'      => $number_of_slots,
            'used_slots'       => 0,
        ];
        $parent_id = $this->functions->insertData('mt_booking_slots', $parent_params);

        // Generate child slots only if enabled
        if ($parent_id && $enabled) {
            $all_slots = array_unique(array_merge(
                $this->functions->generateTimeSlots($shift1_start, $shift1_end),
                $this->functions->generateTimeSlots($shift2_start, $shift2_end)
            ), SORT_REGULAR);

            foreach ($all_slots as $slot) {
                for ($ii = 1; $ii <= $party_size; $ii++) {
                    $localDateTimeStr = "$currentDate {$slot[0]}";
                    $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));
                    $localDateTime->setTimezone(new DateTimeZone('UTC'));
                    $utcFormatted = $localDateTime->format('Y-m-d H:i:s');

                    $child_params = [
                        'parent_id'       => $parent_id,
                        'merchant_id'     => $merchant_id,
                        'slot_starts'     => $slot[0],
                        'slot_ends'       => $slot[1],
                        'person_per_party'=> $ii,
                        'date_created'    => $this->functions->dateNow(),
                        'no_of_slots'     => $number_of_slots,
                        'available_slots' => $available_count,
                        'date'            => $currentDate,
                        'utc_times'       => $utcFormatted,
                    ];
                    $this->functions->insertData('mt_booking_slots_child', $child_params);
                }
            }
        }

        $startDate->modify('+1 day');
    }

    // --- Step 7: Check if 30 calendar days completed ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $total_days = $stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0;

    if ($total_days >= 37) {
        $this->functions->updateData("mt_merchant", ['auto_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "37 calendar days completed. Auto slot cron disabled for merchant $merchant_id.\n";
    } else {
        echo "Partial slots generated. Remaining days will be added in next cron run.\n";
    }
}


public function set_google_reservation_enable_field_merchant_table()
{
    // Fetch all merchants
    $stmt = $this->db->prepare("SELECT merchant_id FROM mt_merchant");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$merchants) {
        echo "No merchants found.\n";
        return;
    }

    foreach ($merchants as $row) {
        $mtid = $row['merchant_id'];

        // Get merchant preference: disable_google_reservations
        $disable_google_reservations_chk = (int)$this->functions->getOption("disable_google_reservations", $mtid);

        // If NOT disabled → enable Google Reservations
        if (empty($disable_google_reservations_chk) || $disable_google_reservations_chk == 0) {

            $params_google = [
                'google_res_enable' => 1
            ];

            $this->functions->updateData('mt_merchant', $params_google, 'merchant_id', $mtid);

            echo "Merchant $mtid → Google Reservations ENABLED\n";
        
        } else { 
        // Disabled → set both fields to 0

            $params_google = [
                'google_res_enable' => 0
            ];

            $this->functions->updateData('mt_merchant', $params_google, 'merchant_id', $mtid);

            echo "Merchant $mtid → Google Reservations DISABLED\n";
        }
    }
}





public function auto_slot_cron_weekly()
{
    // --- Step 1: Fetch one merchant that has auto slot cron enabled and data validated ---
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_merchant
        WHERE google_res_enable = 1
          AND weekly_slot_cron = 1
          AND data_validation = 1
        ORDER BY merchant_id ASC
        LIMIT 1
    ");
    $stmt->execute();
    $merchant = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$merchant) {
        echo "No merchant found for auto slot cron.\n";
        return;
    }

    $merchant_id = $merchant['merchant_id'];

    // --- Step 2: Validate merchant booking data ---
    if (!$this->functions->isBookingDataValid($merchant_id)) {
        
        $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id has invalid booking data. Skipping.\n";
        return;
    }

    echo "Merchant $merchant_id validated. Starting slot generation...\n";

    $today = new DateTime('today');
    $days_to_generate = 37; // total calendar days
    $max_days_per_run = 7;  // max days to add per cron run

    // --- Step 3: Determine start date for new slots ---
    $stmt = $this->db->prepare("
        SELECT MAX(date) AS last_date
        FROM mt_booking_slots
        WHERE merchant_id = ?
    ");
    $stmt->execute([$merchant_id]);
    $last_slot = $stmt->fetch(PDO::FETCH_ASSOC);
    $last_date = $last_slot['last_date'] ?? null;

    $startDate = $last_date ? new DateTime($last_date) : clone $today;
    if ($last_date) $startDate->modify('+1 day');

    // --- Step 4: Calculate remaining calendar days ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $days_existing = (int)($stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0);

    $days_remaining = max(0, $days_to_generate - $days_existing);
    if ($days_remaining <= 0) {
        $this->functions->updateData("mt_merchant", ['weekly_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "Merchant $merchant_id already has 30 calendar days of slots. Cron completed.\n";
        return;
    }

    $days_this_run = min($days_remaining, $max_days_per_run);
    echo "Generating $days_this_run calendar day(s) of slots for merchant $merchant_id...\n";

    // --- Step 5: Fetch merchant settings ---
    $stores_open_starts_raw   = $this->functions->getOption('stores_open_starts', $merchant_id);
    $stores_open_ends_raw     = $this->functions->getOption('stores_open_ends', $merchant_id);
    $stores_open_pm_start_raw = $this->functions->getOption('stores_open_pm_start', $merchant_id);
    $stores_open_pm_ends_raw  = $this->functions->getOption('stores_open_pm_ends', $merchant_id);
    $stores_open_day_raw      = $this->functions->getOption('stores_open_day', $merchant_id);

    $stores_open_starts   = !empty($stores_open_starts_raw)   ? (array)json_decode($stores_open_starts_raw, true)   : [];
    $stores_open_ends     = !empty($stores_open_ends_raw)     ? (array)json_decode($stores_open_ends_raw, true)     : [];
    $stores_open_pm_start = !empty($stores_open_pm_start_raw) ? (array)json_decode($stores_open_pm_start_raw, true) : [];
    $stores_open_pm_ends  = !empty($stores_open_pm_ends_raw)  ? (array)json_decode($stores_open_pm_ends_raw, true)  : [];
    $stores_open_day      = !empty($stores_open_day_raw)      ? (array)json_decode($stores_open_day_raw, true)      : [];

    $party_size = (int)$this->functions->getOption('party_size', $merchant_id) ?: 1;
    $number_of_slots = (int)$this->functions->getOption('number_of_slots', $merchant_id) ?: 3;
    $merchant_holidays = $this->functions->getMerchantHoliday($merchant_id) ?: [];

    // --- Normalize open days correctly ---
    $normalized_days = [];
    if (!empty($stores_open_day)) {
        foreach ($stores_open_day as $day) {
            if (is_string($day) && trim($day) !== '') {
                $normalized_days[] = strtolower(trim($day));
            }
        }
        $normalized_days = array_unique($normalized_days);
    }

    // Convert PM times to 24h format
    foreach ($stores_open_pm_start as $day => $time) if (!empty($time)) $stores_open_pm_start[$day] = date("H:i", strtotime($time));
    foreach ($stores_open_pm_ends as $day => $time) if (!empty($time)) $stores_open_pm_ends[$day] = date("H:i", strtotime($time));

    // --- Step 6: Loop to generate slots ---
    for ($i = 0; $i < $days_this_run; $i++) {
        $currentDate = $startDate->format('Y-m-d');
        $dayName = strtolower($startDate->format('l'));

        // Skip if day not open
        if (!in_array($dayName, $normalized_days)) {
            $startDate->modify('+1 day');
            $i--;
            continue;
        }

        // --- ❗ FIX: Skip completely if holiday (NO parent, NO child) ---
        if (in_array($currentDate, $merchant_holidays)) {
            $startDate->modify('+1 day');
            $i--;
            continue;
        }

        // Get shifts
        $shift1_start = $stores_open_starts[$dayName] ?? '';
        $shift1_end   = $stores_open_ends[$dayName] ?? '';
        $shift2_start = $stores_open_pm_start[$dayName] ?? '';
        $shift2_end   = $stores_open_pm_ends[$dayName] ?? '';

        $hasShift1 = !empty($shift1_start) && !empty($shift1_end) && strtotime($shift1_start) < strtotime($shift1_end);
        $hasShift2 = !empty($shift2_start) && !empty($shift2_end) && strtotime($shift2_start) < strtotime($shift2_end);

        $enabled = ($hasShift1 || $hasShift2) ? 1 : 0;
        $available_count = $enabled ? $number_of_slots : 0;

        // Insert parent slot (only if not holiday)
        $parent_params = [
            'merchant_id'      => $merchant_id,
            'date_created'     => $this->functions->dateNow(),
            'date'             => $currentDate,
            'enabled'          => $enabled,
            'shift1_start'     => $shift1_start,
            'shift1_end'       => $shift1_end,
            'shift2_start'     => $shift2_start,
            'shift2_end'       => $shift2_end,
            'person_per_party' => $party_size,
            'no_of_slots'      => $number_of_slots,
            'used_slots'       => 0,
        ];
        $parent_id = $this->functions->insertData('mt_booking_slots', $parent_params);

        // Generate child slots only if enabled
        if ($parent_id && $enabled) {
            $all_slots = array_unique(array_merge(
                $this->functions->generateTimeSlots($shift1_start, $shift1_end),
                $this->functions->generateTimeSlots($shift2_start, $shift2_end)
            ), SORT_REGULAR);

            foreach ($all_slots as $slot) {
                for ($ii = 1; $ii <= $party_size; $ii++) {
                    $localDateTimeStr = "$currentDate {$slot[0]}";
                    $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));
                    $localDateTime->setTimezone(new DateTimeZone('UTC'));
                    $utcFormatted = $localDateTime->format('Y-m-d H:i:s');

                    $child_params = [
                        'parent_id'       => $parent_id,
                        'merchant_id'     => $merchant_id,
                        'slot_starts'     => $slot[0],
                        'slot_ends'       => $slot[1],
                        'person_per_party'=> $ii,
                        'date_created'    => $this->functions->dateNow(),
                        'no_of_slots'     => $number_of_slots,
                        'available_slots' => $available_count,
                        'date'            => $currentDate,
                        'utc_times'       => $utcFormatted,
                    ];
                    $this->functions->insertData('mt_booking_slots_child', $child_params);
                }
            }
        }

        $startDate->modify('+1 day');
    }

    // --- Step 7: Check if 30 calendar days completed ---
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total_days
        FROM mt_booking_slots
        WHERE merchant_id = ?
          AND date >= ?
    ");
    $stmt->execute([$merchant_id, $today->format('Y-m-d')]);
    $total_days = $stmt->fetch(PDO::FETCH_ASSOC)['total_days'] ?? 0;

    if ($total_days >= 37) {
        $this->functions->updateData("mt_merchant", ['weekly_slot_cron' => 0], 'merchant_id', $merchant_id);
        echo "30 calendar days completed. Auto slot cron disabled for merchant $merchant_id.\n";
    } else {
        echo "Partial slots generated. Remaining days will be added in next cron run.\n";
    }
}


public function set_auto_slot_cron_weekly()
{
    // Fetch merchants where google_res_enable = 1
    $stmt = $this->db->prepare("SELECT merchant_id FROM mt_merchant WHERE google_res_enable = 1");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($merchants) {
        foreach ($merchants as $row) {
            $mtid = $row['merchant_id'];

            // Update weekly_slot_cron to 1
            $params = [
                'weekly_slot_cron' => 1
            ];

            $this->functions->updateData('mt_merchant', $params, 'merchant_id', $mtid);
        }
    }
}










//-------------------auto slot cron functionality





public function CheckOrderStatusPaymentGateway_tester()
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_order 
        WHERE 
     
      order_id='121288'
       
        ORDER BY order_id DESC 
        LIMIT 1
    ");
    $stmt->execute();

    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $processed_order_ids = [];

    foreach ($orders as $order) {
        $payment_type = $order['payment_type'];
        $order_id = $order['order_id'];
        $client_id = $order['client_id'];

  
                if (!empty($order['payment_gateway_ref'])) {
                    $session_id = $order['payment_gateway_ref'];
                    $merchant_id = $order['merchant_id'];
                    $response = $this->functions->get_windcave_payment_status($session_id, $merchant_id);
					
					
					   $transaction = isset($response['transactions'][0]) ? $response['transactions'][0] : [];

        echo $authorised = !empty($transaction['authorised']);
        echo $responseCode = isset($transaction['reCo']) ? $transaction['reCo'] : '';
       echo  $responseText = isset($transaction['responseText']) ? strtoupper($transaction['responseText']) : '';
					
print_r($response);
//die();
                    $this->functions->updateData('mt_order', ['gateway_response' => json_encode($response)], 'order_id', $order_id);

                     if (
            isset($response['state']) && strtolower($response['state']) === 'complete' &&
            $authorised === true &&
            $responseText === 'APPROVED'
        ) {
                       echo 'approved';
                    } elseif (  in_array($state, ['failed', 'cancelled', 'declined']) ||
            $authorised === false ||
            $responseText !== 'APPROVED') {
                       
					   
					   echo 'nnnn';
					   
                    }
                }
            
    }

    }





    
public function CheckOrderStatusPaymentGateway_poli()
{
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_order 
        WHERE  order_id='121444'
       
       
    ");
    $stmt->execute();

    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $processed_order_ids = []; 

    foreach ($orders as $order) {
        $payment_type = $order['payment_type']; 
        $order_id = $order['order_id'];
        $client_id = $order['client_id'];
                if (!empty($order['payment_gateway_ref'])) {
                    $token = $order['payment_gateway_ref'];
                    $merchant_id = $order['merchant_id'];

                   
					 $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);    
                
              if($merchant_type=='1'){  

              $paymode=$this->functions->getOption('merchant_poli_mode',$merchant_id);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$merchant_id);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$merchant_id);
           $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }
              }else{    
               $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          
          }

         


              } 
					
					
					
					
                    $auth = base64_encode($mer_code . ':' . $authkey);
                    $headers = ['Authorization: Basic ' . $auth];

                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $response = curl_exec($ch);
                    curl_close($ch);

                    $json = json_decode($response, true);
print_r($json);
                    $this->functions->updateData('mt_order', ['gateway_response' => json_encode($json)], 'order_id', $order_id);

      echo               $status = $json['TransactionStatusCode'] ?? '';
                    $amount_paid = floatval($json['AmountPaid'] ?? 0);

die();

                    if ($status === 'Completed' && $amount_paid > 0) {
                        $params_logs = [
                            'order_id' => $order_id,
                            'payment_type' => "poli",
                            'payment_reference' => $json['TransactionRefNo'] ?? '',
                            'raw_response' => json_encode($json),
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        ];
                        $this->functions->insertData('mt_payment_order', $params_logs);

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);
                        $order_number = ($get_id_orders >= 0) ? $get_id_orders + 1 : 1;

                        $params_update = [
                            'status' => 'paid',
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'order_number' => $order_number,
                        ];
                        $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
                        $this->executeAddons($order_id);
						$this->sendNotification($order_id);
						
						

                        $processed_order_ids[] = $order_id;
                    } elseif (in_array($status, ['Failed', 'Cancelled', 'TimedOut']) || ($amount_paid == 0 && $status !== 'Completed')) {
                        $this->functions->updateData('mt_order', ['gateway_status' => 'cancelled'], 'order_id', $order_id);
                    }
                }
           
    }

  
}



public function payNow_pos_syncing()
    {
        
        
      

        $pdo = $this->db;

        // Define the SQL query
        $stmt = "SELECT * FROM mt_request_offline_orders
                 WHERE process = 0
                 ORDER BY id DESC
                 LIMIT 2";

        $query = $pdo->prepare($stmt);
        $query->execute();

        $requested_orders = $query->fetchAll(PDO::FETCH_ASSOC);

        foreach ($requested_orders as $requested_order) {
            # code...
        
        $request = json_decode($requested_order['request'], true);



        foreach ($request['orders'] as $order_request) {
            # code...
        
        
        
        $transaction_type = isset($order_request['transaction_type'])?$order_request['transaction_type']:'';

       

        $delivery_date = isset($order_request['delivery_date'])?$order_request['delivery_date']:'';
        $delivery_time = isset($order_request['delivery_time'])?$order_request['delivery_time']:'';
        $payment_provider = isset($order_request['payment_provider'])?$order_request['payment_provider']:'';
        
        
        
        
            //die();
        
            
        
        
        
        
         $first_name= isset($order_request['customer_first_name'])?$order_request['customer_first_name']:''; 
         $last_name= isset($order_request['customer_last_name'])?$order_request['customer_last_name']:''; 
         $email_address= isset($order_request['customer_email'])?$order_request['customer_email']:''; 
        
        
        
         $client_id= isset($order_request['client_id'])?$order_request['client_id']:'0'; 
        
        if($client_id>0){}else{
        $phone_order= isset($order_request['phone_order'])?$order_request['phone_order']:0;
                
        
        }
        
        
        if($client_id>0){
            
            $client_info = $this->functions->getClientInfo($client_id);
        
            
        }else{
            
        if(isset($email_address) && !empty($email_address)){    
        if( $client_info = $this->functions->isClientExist_with_merchant($email_address,$this->merchant_id)){

        }else{
            
                        
            $params2=array(
              'first_name'=>($first_name),
              'last_name'=>($last_name),
              'email_address'=>($email_address),
              'password'=>md5('123456'),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
              'device_id'=>'',
              'device_platform'=>'',
              'merchant_id'=>$this->merchant_id,
               'single_app_merchant_id'=>$order_request['pos_user_id'],
              
             
              'enabled_push'=>1,
              'single_app_device_uiid'=>$this->device_uiid,
            );
            
                $token = $this->SingleAppClass_pos->generateUniqueToken(15,$params2['email_address']);
                $params2['token']=$token;
                if ($customer_id = $this->functions->insertData("mt_client",$params2)){
                     
        
                $client_info = $this->functions->getClientInfo($customer_id);
        
        
        
                }
        }
        
        }
        }
        
        $customer_first_name=''; $customer_last_name =''; $customer_email='';       
        
        $client_id = $client_info['client_id'];     
        $email_address = trim($client_info['email_address']);
        $customer_email = trim($client_info['email_address']);
        $customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
        $customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
        
        
        
        
        /*transaction_type*/
        
        
        if($minfouser['pos_cashier_access']==1){
            
                    $transaction_type=$order_request['transaction_type'];
        //$order_request['transaction_type']="pickup"; 
        }
        
        
    
        
        if(empty($delivery_date)){
            //$this->msg = ("Delivery date is required");
            //$this->output();
        }
        
        if(empty($payment_provider)){
            //$this->msg = ("Payment provider is empty. please go back and try again");
            //$this->output();
        }
        
        $full_delivery = "$delivery_date $delivery_time";       
        $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
        $delivery_time_formated = '';
        if(!empty($delivery_time)){
            $delivery_time_formated=date('h:i A',strtotime($delivery_time));
        } else $delivery_time_formated = date('h:i A');
                        
        /*CHECK MERCHANT OPENING HOURS*/
        //dump($delivery_day);dump($delivery_time_formated);        
        if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
            $date_close=date("F,d l Y h:ia",strtotime($full_delivery));
           
        }               
            
        /*CHECK PRE ORDER*/
        $date_today = date("Y-m-d");        
    
        /*END PRE ORDER*/
                
        $delivery_date = isset($order_request['delivery_date'])?$order_request['delivery_date']:date("Y-m-d");
        $delivery_time = isset($order_request['delivery_time'])?$order_request['delivery_time']:date('h:i A');
        //naxxxx          
        
        
        
        
        

       $payload = $order_request['items'];

       //print_r($payload);die();

        // Directly use 'items', but reindex them into the same numeric format
      $cart = [];

        if (!empty($payload)) {
            foreach ($payload as $item) {
                $cart[] = $item; // keep full item structure, no stripping
            }
        }

      
       

                
        if(1==1){
            //$cart=json_decode($res['cart'],true);  
            
           //print_r($cart);die();
            
            $card_fee = 0; $card_percentage=0;
            
            /*Custom code 10 starts */
            
            $n_total = $order_request['sub_total'];   
                    
                       
            $data = array(
              'delivery_type'=>$transaction_type,
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>$card_fee
            );
            
            

            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $raw = $displayOrderHTML['raw'];
                
                /*EURO TAX*/
               $is_apply_tax = 0;
               if($this->functions->isApplyTax($this->merchant_id)){
                   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
                   $raw['total']=$new_total;            
                   $is_apply_tax=1;        
               }
               /*EURO TAX*/             
                
                $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
                if(empty($donot_apply_tax_delivery)){
                    $donot_apply_tax_delivery=1;
                }
                
                if($card_percentage>0){
                    $card_fee = (float) $raw['total']['card_fee'];
                }


            
                  $params = array(
                  'merchant_id'=>$this->merchant_id,                  
                  'client_id'=>isset($client_id)?$client_id:'0',
                  'json_details'=>json_encode($cart),
                  'trans_type'=>$transaction_type,
                  'payment_type'=>$order_request['payment_provider'],
                  'sub_total'=>$order_request['sub_total'],
                  'tax'=>$order_request['tax']/100,
                  'taxable_total'=>$order_request['taxable_total'],
                  'total_w_tax'=>$order_request['grand_total'],
                  'delivery_charge'=>$order_request['delivery_charge'],
                  'delivery_date'=>$delivery_date,
                  'delivery_time'=>$delivery_time,
                  'delivery_asap'=>isset($order_request['delivery_asap'])?$order_request['delivery_asap']:'',
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'delivery_instruction'=>isset($order_request['delivery_instruction'])?$order_request['delivery_instruction']:'',
                  'cc_id'=>isset($order_request['cc_id'])?$order_request['cc_id']:'',
                  'order_change'=>isset($order_request['order_change'])?$order_request['order_change']:0,
                  'pos_user_id'=>isset($minfouser['merchant_user_id'])?$minfouser['merchant_user_id']:0,
                  'table_number'=>$table_number??0,
                  'payment_provider_name'=>'',
                  'card_fee'=>$card_fee,                  
                  'created_by'=>$created_by,
                  'created_name'=>$created_name,                              
                  'packaging'=>$order_request['packaging_charge'],
                  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
                  'order_id_token'=>$this->functions->generateOrderToken(),
                //  'request_from'=>"single_mob",
                  'request_from'=>"pos",
                  'apply_food_tax'=>$is_apply_tax,      
                  'is_phone_order'=>isset($phone_order)?$phone_order:0,
                  'cart_id'=>isset($cart_id)?$cart_id:0,    
                  'is_retail'=>isset($order_request['is_retail'])?$order_request['is_retail']:0,
                  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
                );



                


                
                
                
                
                if($phone_order==1){
                    $params['client_names']=$order_request['customer_name'];
                   $params['email'] = isset($order_request['customer_email']) && !empty($order_request['customer_email']) 
                    ? $order_request['customer_email'] 
                    : "";

                    $params['phones']=$order_request['phone_no'];
                    $params['address'] = isset($order_request['address']) && !empty($order_request['address']) 
                    ? $order_request['address'] 
                    : "";          
                    
                }
                
                
                
                //get-last-order
                
                $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);
                if($get_id_orders>=0){$params['order_number']=$get_id_orders+1;}else{$params['order_number']=1;}
                
                
                
                
                
                $order_id_token = $params['order_id_token'];
                
                       
                                
                switch ($transaction_type) {
                    case "dinein":
                        $params['dinein_number_of_guest'] = isset($order_request['dinein_number_of_guest'])?$order_request['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction'] = isset($order_request['dinein_special_instruction'])?$order_request['dinein_special_instruction']:'';
                        
                        $params['dinein_table_number'] = isset($order_request['dinein_table_number'])?$order_request['dinein_table_number']:'';
                        
                        if(isset($order_request['contact_phone']) && $client_id>0){
                            if(!empty($order_request['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$order_request['contact_phone']
                                ),'client_id',$client_id);
                            }
                        }                       
                        break;
                        
                    case "pickup":   
                          if(isset($order_request['contact_phone']) && $client_id>0){
                            if(!empty($order_request['contact_phone'])){
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$order_request['contact_phone']
                                ),'client_id',$client_id);
                            }
                          }                     
                        break;
                        
                    case "delivery":
                        $delivery_asap = '';
                        if(isset($order_request['delivery_asap'])){
                            $delivery_asap = $order_request['delivery_asap']=="true"?1:'';
                            $params['delivery_asap'] = $delivery_asap;
                        }
                        break;
                
                    default:
                        break;
                }
                    
                /*DEFAULT ORDER STATUS*/                
                
                
                
                        $params['payment_provider_name']=$payment_provider;
                
                         $params['status']='paid';  
                
                

                 

                
                

                
                
                
               
                $params['status']='Complete';
                
            
                
                
                if ($params['request_from']="pos")
                        {
                            $params['percent_commision']=0;
                            $params['total_commission']=0;
                            $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                        }

                if(!is_numeric($params['cc_id'])){
                    unset($params['cc_id']);
                }
                if(!is_numeric($params['order_change'])){
                    unset($params['order_change']);
                }
                                                
                /*BEGIN INSERT ORDER*/              
                if(!is_numeric($params['sub_total'])){
                    $params['sub_total']=0;
                }           
                if(!is_numeric($params['tax'])){
                    $params['tax']=0;
                }           
                if(!is_numeric($params['taxable_total'])){
                    $params['taxable_total']=0;
                }           
                if(!is_numeric($params['total_w_tax'])){
                    $params['total_w_tax']=0;
                }
                
                if(isset($params['order_change'])){
                    if(!is_numeric($params['order_change'])){
                        $params['order_change']=0;
                    }           
                }
                if(!is_numeric($params['card_fee'])){
                    $params['card_fee']=0;
                }           
                if(!is_numeric($params['packaging'])){
                    $params['packaging']=0;
                }           
                if(!is_numeric($params['donot_apply_tax_delivery'])){
                    unset($params['donot_apply_tax_delivery']);
                }           
                if(!is_numeric($params['apply_food_tax'])){
                    unset($params['apply_food_tax']);
                }           
                
                if(isset($params['percent_commision'])){
                    if(!is_numeric($params['percent_commision'])){
                        $params['percent_commision']=0;
                    }           
                }
                
                if(isset($params['total_commission'])){
                    if(!is_numeric($params['total_commission'])){
                        $params['total_commission']=0;
                    }           
                }
                
                if(isset($params['merchant_earnings'])){
                    if(!is_numeric($params['merchant_earnings'])){
                        $params['merchant_earnings']=0;
                    }           
                }               
                
                if($transaction_type=="delivery"){          
                   if($res['distance']>0){
                      

                      $params['distance'] = isset($res['distance']) ? $res['distance'] . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '') : '0' . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '');

                   }
                }


                     /*$points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($order_request['sub_total'],$this->merchant_id);
                     echo $points_earn;die();*/
                
                    
                if( $order_id=$this->functions->insertData("mt_order",$params)){
                    
                    
                    $params_history=array(
                      'order_id'=>$order_id,
                      'status'=>'Complete',     
                      'remarks'=>'',
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );          
                   
                  $this->functions->insertData("mt_order_history",$params_history);
                    
                
            
                    
                    
                    
                    
                    
                    
                    
                    
                    if ($transaction_type=="delivery" && $phone_order==1 && isset($params['address']) && !empty($params['address'])){                       
                        $params_address=array(                        
                          'street'=>isset($res['street'])?$res['street']:'',
                          'city'=>isset($res['city'])?$res['city']:'',
                          'state'=>isset($res['state'])?$res['state']:'',
                          'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                          'location_name'=>$params['address'],
                          'formatted_address'=>$params['address'],
                          'contact_phone'=>$params['phones'],
                          'country'=>isset($res['country_code'])?$res['country_code']:'',
                          'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
                          'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
                          'opt_contact_delivery'=>isset($order_request['opt_contact_delivery'])?(integer)$order_request['opt_contact_delivery']:0
                        );              


                                        
                    $params_address['order_id'] = (integer)$order_id;
                    $params_address['client_id'] = (integer)$client_id;
                    $params_address['first_name'] =$params['client_names'];
                    $params_address['last_name'] ='';
                    $params_address['contact_email'] =$params['email'];
                    $params_address['date_created'] = $this->functions->dateNow();
                    $params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
                                        
                    $this->functions->insertData("mt_order_delivery_address",$params_address);
                    
                    }
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    $next_step = "receipt";
                    
                    /*SAVE ITEM */                  
                 /*SAVE ITEM */  
//print_r($raw['item']);die();                
foreach ($raw['item'] as $val) {                                
    $params_order_details=array(
      'order_id'=>isset($order_id)?$order_id:'',
      'client_id'=>isset($client_id)?$client_id:'0',
      'item_id'=>isset($val['item_id'])?$val['item_id']:'',
      'item_name'=>isset($val['item_name'])?$val['item_name']:'',
      'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
      'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
      'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
      'size'=>isset($val['size_words'])?$val['size_words']:'',
      'qty'=>isset($val['qty'])?$val['qty']:'',                               
      'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
      'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
      'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
      'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
    );

    /* inventory fields */
    $new_fields=array('size_id'=>"size_id");
    if ( $this->functions->checkTableFields('order_details',$new_fields)){
        $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
        $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
    }           
    
    $this->functions->insertData("mt_order_details",$params_order_details);
   
    /*inventory addon insert*/
    if ($this->functions->checkIfTableExist('order_details_addon')){
        if(isset($val['sub_item'])){
            if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                foreach ($val['sub_item'] as $sub_item_data) {
                  
                    $this->functions->insertData("mt_order_details_addon",array(
                      'order_id'=>$order_id,
                      'subcat_id'=>$sub_item_data['subcat_id'],
                      'sub_item_id'=>$sub_item_data['sub_item_id'],
                      'addon_price'=>$sub_item_data['addon_price'],
                      'addon_qty'=>$sub_item_data['addon_qty'],
                    ));

                }
            }                           
        }
    }
}

                    
                    /*SAVE DELIVERY ADDRESS*/
                    $params_address = array();
                    
                    /*SAVE DELIVERY ADDRESS*/
                    if ( $transaction_type=="pickup"){
                        $params_address = array(                          
                          'contact_phone'=>isset($order_request['contact_phone'])?$order_request['contact_phone']:''                        
                        );
                    } elseif ( $transaction_type=="dinein"){
                        $params_address = array(                          
                          'contact_phone'=>isset($order_request['contact_phone'])?$order_request['contact_phone']:'',
                          'dinein_number_of_guest'=>isset($order_request['dinein_number_of_guest'])?$order_request['dinein_number_of_guest']:'',
                          'dinein_special_instruction'=>isset($order_request['dinein_special_instruction'])?$order_request['dinein_special_instruction']:'',
                          'dinein_table_number'=>isset($order_request['dinein_table_number'])?$order_request['dinein_table_number']:''
                        );
                    }
                    
                
                                        
                
                    
                    
                    
                    $this->code = 1;
                    
                    
                        if ($params['payment_type']=="windcave"){
                            
                      
                    
                                        
                            
                        }else{
                    
                    

                    $this->msg = "Your order has been placed. Reference # ".$order_id;
                    
                    $provider_credentials=array();
                    $redirect_url='';
                    
                 

                            
                            $phone_order= isset($order_request['phone_order'])?$order_request['phone_order']:0;
                if($phone_order>0){
                    /*$cart_id= isset($order_request['cart_id'])?$order_request['cart_id']:0;   
                        if(isset($cart_id) && !empty($cart_id) && $cart_id>0){}else{$this->msg = ("Cart ID is missing");$this->output();}*/
        
                        
                        
                        
                        
                        
                            
                                  $this->SingleAppClass_pos->handleAll_cash_phone($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$cart_id);    
                            
                    
                }else{

                            if($minfouser['pos_cashier_access']==1){                                
                                  $this->SingleAppClass_pos->handleAll_cash($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status']); 
                            }else{  
                              $this->SingleAppClass_pos->handleAll($order_id,$this->merchant_id,
                              $client_id,$this->device_uiid,$params['status'],$table_number);   
                            }
                              
                                 
                              
                                   
                                  //$this->SingleAppClass_pos->updatePoints($order_id,$params['status']); commented by was
                              
                              
                              
                }

               //+++was custom code
                $points_earn = $this->SingleAppClass_pos->getCartEarningPoints_offline($order_request['sub_total'],$this->merchant_id);  

                if($client_id>0){
                
                $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$this->merchant_id,$order_id,'',$params['status']);

                     

                  

                }  

                $this->SingleAppClass_pos->updatePoints($order_id,$params['status']);           
                //---was custom code

             }          
                              
                              
                              
                              
                              
                        
                    $client_info = array( 
                      'first_name'=>$client_info['first_name'],
                      'last_name'=>$client_info['last_name'],
                      'email_address'=>$client_info['email_address'],
                      'contact_phone'=>$client_info['contact_phone'],                     
                    );
                    
                   

                    $payment_description = "Payment to merchant ".$this->functions->clearString($this->merchant_name);

                    
                    $total = number_format($params['total_w_tax'],2,'.','');
                    
                    
                    
                    
                    
                    $resp = $this->SingleAppClass_pos->prepareReceipt($order_id);
                    
                    $resp['timezone']=date_default_timezone_get();
            
                    //+++was code      
                    foreach ($resp as $key => $val) {
    if ($key !== 'total_amount' && $key !== 'total_amount_by_100') {
        if (is_array($val)) {
            foreach ($val as $subKey => $subVal) {
                if (is_int($subVal) || is_float($subVal)) {
                    $resp[$key][$subKey] = (string)$subVal;
                }
            }
        } elseif (is_int($val) || is_float($val)) {
            $resp[$key] = (string)$val;
        }
    }
}
//---was code

// Convert all nulls in $resp to empty strings
array_walk_recursive($resp, function (&$v) {
    if (is_null($v)) {
        $v = "";
    }
});

// Ensure merchant_id is string (in main data and nested json_details if string)
if (isset($resp['data']['merchant_id'])) {
    $resp['data']['merchant_id'] = (string)$resp['data']['merchant_id'];
}
if (isset($resp['data']['json_details']) && is_string($resp['data']['json_details'])) {
    // Fix merchant_id in json_details to be quoted
    $resp['data']['json_details'] = preg_replace('/"merchant_id":(\d+)/', '"merchant_id":"$1"', $resp['data']['json_details']);
}

// Ensure sub_total, tax, taxable_total are strings if present
foreach (['sub_total', 'tax', 'taxable_total', 'total_w_tax'] as $key) {
    if (isset($resp['data'][$key])) {
        $resp['data'][$key] = (string)round((float)$resp['data'][$key], 2);
    }
}

// Total amount as formatted string
$total = isset($params['total_w_tax']) ? round((float)$params['total_w_tax'], 2) : 0;


            
                    
                    
                    $this->details=array(
                      'order_id'=>$order_id,
                      'order_detail'=>$resp,
                      'total_amount'=>$params['total_w_tax'],
                      'total_amount_by_100'=>$total*100,
                      'total_amount_formatted'=>$total,
                      'payment_provider'=>$payment_provider,
                      'next_step'=>$next_step,
                      'currency_code'=>$this->functions->getCurrencyCode(),
                      'payment_description'=>$payment_description,
                      'merchant_name'=>$this->functions->clearString($this->merchant_name),
                      'provider_credentials'=>$provider_credentials,
                      'redirect_url'=>$redirect_url,
                      'client_info'=>$client_info
                    );
                    
                } else echo ("Something went wrong cannot insert records. please try again later");
                
            } else echo $msg;           
        } else echo ("Cart is empty");      
        
        //$this->output();

     }//--foreach end

     $id_to_update=$requested_order['id'];
     $this->functions->updateData('mt_request_offline_orders' , array('process'=>1) ,'id',$id_to_update);

    }//--foreach end



    }


   public function correct_sku()
{

    if (!isset($_GET['merchant_id']) || empty($_GET['merchant_id'])) {
        die('Merchant ID is required');
    }

    $merchant_id = (int) $_GET['merchant_id'];
     
    // 1️⃣ Fetch all size records for this merchant
    $stmt = $this->db->prepare("
        SELECT item_size_id
        FROM mt_item_relationship_size
        WHERE merchant_id = ?
        ORDER BY item_size_id ASC
    ");
    $stmt->execute([$merchant_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        echo "No records found";
        return;
    }

    // 2️⃣ Update SKU sequentially
    $counter = 1;

    $updateStmt = $this->db->prepare("
        UPDATE mt_item_relationship_size
        SET sku = ?
        WHERE item_size_id = ?
    ");

    foreach ($rows as $row) {
        $sku = $merchant_id . '-' . $counter;
        $updateStmt->execute([$sku, $row['item_size_id']]);
        $counter++;
    }

    echo "SKU corrected successfully for merchant ID {$merchant_id}";
}







 

    
   
}
