<?php

require_once __DIR__ . '/../../vendor/autoload.php';

use phpseclib3\Net\SFTP;
use phpseclib3\Crypt\PublicKeyLoader;

class FeedsController extends Controller {
     protected $db;
     public $crumbsTitle='';
   public $theme_compression='';
    public $is_rtl=false;
    public $action_name='12';
    public $provider;
     public $map_api;
    public $map_provider;  
    public $mapbox_default_zoom;

    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

         

  $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
   
      date_default_timezone_set($website_timezone);
   $requested_url=$_SERVER['REQUEST_URI'];
  $url_parts = explode('/', trim($requested_url, '/'));
   if (count($url_parts) >= 2) {
    $action_name = $url_parts[1];
   }
   if($action_name=='')
   {
    $action_name='index';
   }
   $this->action_name=$action_name;
   $this->action_id=$action_name;


   //echo date('Y-m-d H:i:s');die();

    }



public function Merchant_auto_feed()
{		
    // Step 1: Get merchant IDs
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        echo json_encode([]);
        return;
    }

    // Step 2: Build JSON structure
    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => time(),
            "generation_timestamp" => time()
        ],
        "merchant" => []
    ];

    // Step 3: Loop merchants
    foreach ($merchants as $merchant_id) {

        $merchantInfo = $this->functions->getMerchantInfo_mobileapp($merchant_id);
        $merchantId = $this->functions->getOption("booking_id", $merchant_id);
        
        $phone = trim($merchantInfo['restaurant_phone'] ?? '');
        $phone = str_replace([' ', '-'], '', $phone);

        $country_list = $this->functions->mobilecountry_code();  
        $contrycode = $merchantInfo['country_code'];
        $country_code = $country_list[$contrycode]['code'] ?? '';

        if (strpos($phone, '+') === 0) {
            $formattedPhone = $phone;
        } elseif (strpos($phone, '+' . $country_code) === 0) {
            $formattedPhone = $phone;
        } elseif (strpos($phone, $country_code) === 0) {
            $formattedPhone = '+' . $phone;
        } elseif (strpos($phone, '0') === 0) {
            $formattedPhone = '+' . $country_code . substr($phone, 1);
        } else {
            $formattedPhone = '+' . $country_code . $phone;
        }

        $contacts = $formattedPhone;

        $latitude  = number_format((float)$merchantInfo['latitude'], 6, '.', '');
        $longitude = number_format((float)$merchantInfo['lontitude'], 6, '.', '');
        $urls = Config::$baseUrl . '/menu/' . trim($merchantInfo['restaurant_slug']);

        $disable_google_reservations = $this->functions->getOption("disable_google_reservations", $merchant_id);

        if ($disable_google_reservations != 1) {
            $data["merchant"][] = [
                "category" => "RESTAURANT",
                "merchant_id" => $merchantId,
                "name" => $merchantInfo['restaurant_name'],
                "url" => $urls,
                "telephone" => $contacts,
                "geo" => [
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "address" => [
                        "street_address" => $merchantInfo['street'],
                        "locality" => $merchantInfo['city'],
                        "region" => $merchantInfo['state'],
                        "postal_code" => $merchantInfo['post_code'],
                        "country" => $merchantInfo['country_code']
                    ]
                ]
            ];
        }
    }

    // Step 4: Convert to JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    // Step 5: Save to feeds folder
    $currentDir = __DIR__;
    $feedDir = $currentDir . '/feeds';

    if (!is_dir($feedDir)) {
        mkdir($feedDir, 0777, true);
    }

    $filePath = $feedDir . '/merchant.json';
    $saveResult = file_put_contents($filePath, $jsonOutput);

    // Step 6: Check if file saved successfully
    if ($saveResult !== false) {
        
        $this->sftpTest();
    } else {
        echo "Error: Failed to save merchant.json file.";
    }
}






    
public function sftpTest()
{
    // ==== SANDBOX SFTP DETAILS ====
    
    $host = 'partnerupload.google.com';
    $port = 19321;
    $username=$this->functions->getOptionAdmin("feed_merchant_user");
    //$username = 'feeds-4p9q50'; // merchants feed sandbox account

    // ==== PATH TO PRIVATE KEY (OpenSSH format) ====
    $pemPath = __DIR__ . '/feeds/merchantx.pem';

    if (!file_exists($pemPath)) {
        exit("❌ Private key file not found: " . $pemPath);
    }

    // Load private key
    try {
        $privateKey = PublicKeyLoader::loadPrivateKey(file_get_contents($pemPath));
    } catch (Exception $e) {
        exit("❌ Failed to load private key: " . $e->getMessage());
    }

    // Connect to SFTP
    $sftp = new SFTP($host, $port, 30);

    if (!$sftp->login($username, $privateKey)) {
        exit("❌ SFTP Login Failed — wrong username, key, or blocked port.");
    }

    echo "✅ Connected & authenticated successfully!<br><br>";

    // ==== UPLOAD MERCHANT FEED ====
    $local_file = __DIR__ . '/feeds/merchant.json';
    $remote_file = 'merchant.json';  // Google always expects root-level filename

    if (!file_exists($local_file)) {
        exit("❌ Feed file not found: " . $local_file);
    }

    $date_to_chk=$this->functions->getOptionAdmin('merchant_auto_feed_uploaded');

    $current_date = date('Y-m-d');

    if ($date_to_chk === $current_date) {
        
    } else {
        
        if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";
        $this->functions->updateOptionAdmin(
        'merchant_auto_feed_uploaded',
        date('Y-m-d')
      );

        } else {
            echo "❌ Upload failed!<br>";
        }


    }
    


    


   /* if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";

    } else {
        echo "❌ Upload failed!<br>";
    }*/

    // ==== LIST ROOT DIRECTORY ====
    echo "<pre>";
    print_r($sftp->nlist('.'));  // '.' works better than '/'
    echo "</pre>";
}


public function Service_auto_feed()
{
    // Step 1: Get merchant IDs from DB
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        echo json_encode([]);
        return;
    }

    // Step 2: Build services array
    $services = [];

    foreach ($merchants as $merchant_id) {

        $bookingId = $this->functions->getOption("booking_id", $merchant_id);
        $disable_google_reservations = $this->functions->getOption("disable_google_reservations", $merchant_id);

        if ($disable_google_reservations != 1) {
            if (!empty($bookingId)) {
                $services[] = [
                    "merchant_id" => $bookingId,
                    "localized_service_name" => [
                        "value" => "Reservation",
                        "localized_value" => [
                            [
                                "locale" => "en",
                                "value" => "Reservation"
                            ]
                        ]
                    ],
                    "service_id" => "reservation",
                    "prepayment_type" => "NOT_SUPPORTED"
                ];
            }
        }
    }

    // Step 3: Full JSON structure
    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => time(),
            "generation_timestamp" => time()
        ],
        "service" => $services
    ];

    // Step 4: Encode JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    // Step 5: Save JSON to server (feeds folder)
    $currentDir = __DIR__;
    $feedDir = $currentDir . '/feeds';

    if (!is_dir($feedDir)) {
        mkdir($feedDir, 0777, true);
    }

    $filePath = $feedDir . '/services.json';
    $saveResult = file_put_contents($filePath, $jsonOutput);

    // Step 6: Confirm file saved
    if ($saveResult !== false) {
        

        // OPTIONAL: Upload file to Google SFTP
        $this->sftpTest_services();  
    } else {
        echo "Error: Unable to save services.json file.";
    }
}

public function sftpTest_services()
{
    // ==== SANDBOX SFTP DETAILS ====
    
    $host = 'partnerupload.google.com';
    $port = 19321;
    $username=$this->functions->getOptionAdmin("feed_services_user");
    //$username = 'feeds-4p9q50'; // merchants feed sandbox account

   

    // ==== PATH TO PRIVATE KEY (OpenSSH format) ====
    $pemPath = __DIR__ . '/feeds/service_pem.pem';

    if (!file_exists($pemPath)) {
        exit("❌ Private key file not found: " . $pemPath);
    }

    // Load private key
    try {
        $privateKey = PublicKeyLoader::loadPrivateKey(file_get_contents($pemPath));
    } catch (Exception $e) {
        exit("❌ Failed to load private key: " . $e->getMessage());
    }

    // Connect to SFTP
    $sftp = new SFTP($host, $port, 30);

    if (!$sftp->login($username, $privateKey)) {
        exit("❌ SFTP Login Failed — wrong username, key, or blocked port.");
    }

    echo "✅ Connected & authenticated successfully!<br><br>";

    // ==== UPLOAD MERCHANT FEED ====
    $local_file = __DIR__ . '/feeds/services.json';
    $remote_file = 'services.json';  // Google always expects root-level filename

    if (!file_exists($local_file)) {
        exit("❌ Feed file not found: " . $local_file);
    }

    $date_to_chk=$this->functions->getOptionAdmin('service_auto_feed_uploaded');
    $current_date = date('Y-m-d');

    if ($date_to_chk === $current_date) {
        
    } else {
        
       if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";
        $this->functions->updateOptionAdmin(
        'service_auto_feed_uploaded',
        date('Y-m-d')
         );
        } else {
            echo "❌ Upload failed!<br>";
        }


    }

    /*if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";
    } else {
        echo "❌ Upload failed!<br>";
    }*/

    // ==== LIST ROOT DIRECTORY ====
    echo "<pre>";
    print_r($sftp->nlist('.'));  // '.' works better than '/'
    echo "</pre>";
}






	
  public function getSlotsforMultiplemerchants_auto_feed()
{   
   // Prevent timeouts
    set_time_limit(0);
    ini_set('max_execution_time', 0);
    ini_set('memory_limit', '512M');

    // Prevent cron/browser abort
    ignore_user_abort(true);

    // Disable output buffering (important for cron)
    if (ob_get_level()) {
        ob_end_flush();
    }
    ob_implicit_flush(true);

    $days = 30;
    

    // 1) Get all merchant IDs that have booking_id
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
    ");
    $stmt->execute();
    $merchants = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($merchants)) {
        print_r([]); 
        return;
    }

    // 2) Date range
    $today   = date('Y-m-d');
    $endDate = date('Y-m-d', strtotime("+".($days - 1)." days"));

    // 3)
    $placeholders = implode(',', array_fill(0, count($merchants), '?'));

    // 4)
    $sql = "
        SELECT *
        FROM mt_booking_slots_child
        WHERE merchant_id IN ($placeholders)
          AND date >= ?
          AND date <= ?
        ORDER BY merchant_id ASC, date ASC, utc_times ASC
    ";

    $stmt = $this->db->prepare($sql);
    $params = array_merge($merchants, [$today, $endDate]);
    $stmt->execute($params);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $data = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number" => 0,
            "total_shards" => 1,
            "nonce" => time(),
            "generation_timestamp" => time()
        ],
        "service_availability" => [
            ["availability" => []]
        ]
    ];

    foreach ($slots as $slot) {

        $merchantId = $this->functions->getOption("booking_id", $slot['merchant_id']);

        $duration_sec = $this->functions->getOption("google_merchant_duration", $slot['merchant_id']);
        $duration_sec = !empty($duration_sec) ? (int)$duration_sec : 1800;

        $confirmation_mode = $this->functions->getOption("booking_confirmation_mode", $slot['merchant_id']);
        if ($confirmation_mode == "" || $confirmation_mode == "confirmed") {
            $booking_confirmation_mode = "CONFIRMATION_MODE_SYNCHRONOUS";
        } else {
            $booking_confirmation_mode = "CONFIRMATION_MODE_ASYNCHRONOUS";
        }

        $disable_google_reservations = $this->functions->getOption("disable_google_reservations", $slot['merchant_id']);

        if ($disable_google_reservations != 1) {

            if ($slot['available_slots'] > $slot['no_of_slots'] || $slot['available_slots'] < 0) {
                header('Content-Type: application/json');
                echo json_encode([
                    "error" => true,
                    "message" =>
                        "Invalid slot data for merchant_id {$slot['merchant_id']}.
                        available_slots={$slot['available_slots']}
                        no_of_slots={$slot['no_of_slots']}"
                ], JSON_PRETTY_PRINT);
                exit;
            }

            $data["service_availability"][0]["availability"][] = [
                "spots_total" => $slot['no_of_slots'],
                "spots_open" => $slot['available_slots'],
                "duration_sec" => $duration_sec,
                "service_id" => "reservation",
                "start_sec" => (int)$slot['utc_times'],
                "merchant_id" => $merchantId,
                "resources" => [
                    "party_size" => $slot['person_per_party']
                ],
                "confirmation_mode" => $booking_confirmation_mode
            ];
        }
    }

    $this->functions->updateOptionAdmin('feed_upload', 0);

    // Convert to JSON
    $jsonOutput = json_encode($data, JSON_PRETTY_PRINT);

    // ============================
    // NEW PART: SAVE ON SERVER
    // ============================
    

        $folder = __DIR__ . "/feeds/";

        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        $filePath = $folder . "availability.json";

        file_put_contents($filePath, $jsonOutput);

        header('Content-Type: application/json');

        $this->sftpTest_available();
       
        
    

    // Default output
    header('Content-Type: application/json');
    echo $jsonOutput;
    exit;
}


public function sftpTest_available()
{
    // ==== SANDBOX SFTP DETAILS ====
    
    $host = 'partnerupload.google.com';
    $port = 19321;
    $username=$this->functions->getOptionAdmin("feed_availability_user");
    //$username = 'feeds-4p9q50'; // merchants feed sandbox account

   

    // ==== PATH TO PRIVATE KEY (OpenSSH format) ====
    $pemPath = __DIR__ . '/feeds/avilability_pem.pem';

    if (!file_exists($pemPath)) {
        exit("❌ Private key file not found: " . $pemPath);
    }

    // Load private key
    try {
        $privateKey = PublicKeyLoader::loadPrivateKey(file_get_contents($pemPath));
    } catch (Exception $e) {
        exit("❌ Failed to load private key: " . $e->getMessage());
    }

    // Connect to SFTP
    $sftp = new SFTP($host, $port, 30);

    if (!$sftp->login($username, $privateKey)) {
        exit("❌ SFTP Login Failed — wrong username, key, or blocked port.");
    }

    echo "✅ Connected & authenticated successfully!<br><br>";

    // ==== UPLOAD MERCHANT FEED ====
    $local_file = __DIR__ . '/feeds/availability.json';
    $remote_file = 'availability.json';  // Google always expects root-level filename

    if (!file_exists($local_file)) {
        exit("❌ Feed file not found: " . $local_file);
    }

    $date_to_chk=$this->functions->getOptionAdmin('availablity_auto_feed_uploaded');

    $current_date = date('Y-m-d');



    if ($date_to_chk === $current_date) {
        
    } else {
        
       if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";
        $this->functions->updateOptionAdmin(
        'availablity_auto_feed_uploaded',
        date('Y-m-d')
        );
        } else {
        echo "❌ Upload failed!<br>";
        }


    }

    /*if ($sftp->put($remote_file, file_get_contents($local_file))) {
        echo "🎉 Feed uploaded successfully!<br>";
    } else {
        echo "❌ Upload failed!<br>";
    }*/

    // ==== LIST ROOT DIRECTORY ====
    echo "<pre>";
    print_r($sftp->nlist('.'));  // '.' works better than '/'
    echo "</pre>";
}




   
   
}
