<?php








class InvoicecronController extends Controller {
    

     protected $db;
     public $crumbsTitle='';
   public $theme_compression='';
    public $is_rtl=false;
    public $action_name='12';
    public $provider;
     public $map_api;
    public $map_provider;  
    public $mapbox_default_zoom;

    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

         

  $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
   
      date_default_timezone_set($website_timezone);

       $requested_url=$_SERVER['REQUEST_URI'];
  $url_parts = explode('/', trim($requested_url, '/'));
   if (count($url_parts) >= 2) {
    $action_name = $url_parts[1];
   }
   if($action_name=='')
   {
    $action_name='index';
   }
   $this->action_name=$action_name;
   $this->action_id=$action_name;
   

   //echo date('Y-m-d H:i:s');die();

    }

public function test() {
    $merchant_id = 3;
    $pdf_filename = "was.pdf"; // include .pdf extension

    $val = [
        'order_id' => 2074,
        'order_number' => 841,
        'status' => 'New Order',
        'table_number' => 0,
        'merchant_id' => 3,
        'client_id' => 2058,
        'created_by' => '',
        'created_name' => '',
        'cash_received_by' => 0,
        'json_details' => '[{"row":"0","category_id":"4","item_id":"355","with_size":"","size_id":"","size_name_trans":"","size_words":"","price":"43.00|aw|7","qty":"2","promo_id":"0","notes":"","cooking_ref":"","sub_item":"","lat":"-36.8705","lng":"174.9117","item_count":"3","item_price_total":"124.7","api_key":"51E4FEE6DC5CC1815E25DDEA2582B","device_id":"BYNgOdb5akUv6H0EzXoCPWZipseTtunI","device_uiid":"user_BYNgOdb5akUv6H0EzXoCPWZipseTtunI","device_platform":"web","code_version":"1.5","lang":"en","merchant_id":"3","discount":"","non_taxable":"1"}]',
        'trans_type' => 'pickup',
        'payment_type' => 'cod',
        'sub_total' => 77.4000,
        'tax' => 0.0500,
        'taxable_total' => 4.0500,
        'total_w_tax' => 84.9500,
        'stats_id' => 0,
        'viewed' => 1,
        'delivery_charge' => 0.0000,
        'delivery_date' => '2025-11-15',
        'delivery_time' => '1:20 PM',
        'delivery_asap' => '',
        'delivery_instruction' => '',
        'voucher_code' => '',
        'voucher_amount' => 0.0000,
        'voucher_type' => '',
        'cc_id' => 0,
        'date_created' => '2025-11-14 21:18:23',
        'date_modified' => '2025-11-14 21:18:23',
        'ip_address' => '205.209.109.142',
        'order_change' => 0.0000,
        'payment_provider_name' => '',
        'discounted_amount' => 8.60000,
        'discount_percentage' => 10.00000,
        'percent_commision' => 5.0000,
        'total_commission' => 4.2475,
        'commision_ontop' => 2,
        'merchant_earnings' => 80.7025,
        'packaging' => 3.5000,
        'cart_tip_percentage' => 0.0000,
        'cart_tip_value' => 0.0000,
        'card_fee' => 0.0000,
        'donot_apply_tax_delivery' => 2,
        'order_locked' => 1,
        'request_from' => 'webappv2',
        'mobile_cart_details' => '',
        'points_discount' => 0.0000,
        'apply_food_tax' => 0,
        'order_id_token' => 'QF9XR3BWQC',
        'admin_viewed' => 1,
        'merchantapp_viewed' => 0,
        'dinein_number_of_guest' => '',
        'dinein_special_instruction' => '',
        'critical' => 1,
        'commision_type' => 'percentage',
        'calculation_method' => 1,
        'request_cancel' => 2,
        'request_cancel_viewed' => 2,
        'request_cancel_status' => 'pending',
        'sofort_trans_id' => '',
        'dinein_table_number' => '',
        'payment_gateway_ref' => '',
        'is_sop' => 0,
        'cancel_reason' => '',
        'distance' => '',
        'auto_print' => 0,
        'car_park_enable' => 0,
        'number_plate' => '',
        'pos_user_id' => 0,
        'is_phone_order' => 0,
        'cart_id' => 0,
        'client_names' => '',
        'email' => '',
        'phones' => '',
        'address' => '',
        'is_retail' => 0,
        'resend_email' => 0,
        'gateway_status' => '',
        'gateway_response' => '',
        'windcave_offline' => 0
    ];

    // Call function
    $this->functions->sendInvoiceNotification($merchant_id, $val, $pdf_filename);
}



   public function GenerateInvoice()
{
    $terms = isset($_GET['terms']) ? $_GET['terms'] : 7;

    $and = '';
    $date_covered_start = '';
    $date_covered_end = '';

    $and_status = '';

    // commission status
    $commission_status = $this->functions->getCommissionStatusBased();
    if ($commission_status) {
        $and_status = " AND status IN ($commission_status) ";
    }

    /** DATE RANGE HANDLING **/
    switch ($terms) {
        case 1:
            $date_covered_start = date("Y-m-d");
            $date_covered_end = date("Y-m-d");
            $and = " AND date_created BETWEEN '$date_covered_start 00:00:00' AND '$date_covered_end 23:59:00' ";
            break;

        case 7:
            $date_covered_start = date("Y-m-d", strtotime("-7 days"));
            $date_covered_end   = date("Y-m-d");
            $and = " AND date_created BETWEEN '$date_covered_start 00:00:00' AND '$date_covered_end 23:59:00' ";
            break;

        case 15:
            $date_covered_start = date("Y-m-d", strtotime("-15 days"));
            $date_covered_end   = date("Y-m-d");
            $and = " AND date_created BETWEEN '$date_covered_start 00:00:00' AND '$date_covered_end 23:59:00' ";
            break;

        case 30:
            $date_covered_start = date("Y-m-d", strtotime("-1 month"));
            $date_covered_end   = date("Y-m-d");
            $and = " AND date_created BETWEEN '$date_covered_start 00:00:00' AND '$date_covered_end 23:59:00' ";
            break;

        default:
            break;
    }

    /** SET MYSQL TIMEZONE **/
    $now = new DateTime();
    $mins = $now->getOffset() / 60;
    $sgn = ($mins < 0 ? -1 : 1);
    $mins = abs($mins);
    $hrs = floor($mins / 60);
    $mins -= $hrs * 60;
    $offset = sprintf('%+d:%02d', $hrs * $sgn, $mins);

    try {
        $stmt = $this->db->prepare("SET time_zone='$offset'");
        $stmt->execute();
    } catch (PDOException $e) {
        // optional error handling
    }

    /** MAIN MERCHANT QUERY **/
    $stmt = "
        SELECT 
            merchant_id,
            restaurant_name,
            contact_email,
            contact_phone
        FROM
            mt_merchant
        WHERE
            merchant_type='3'
            AND invoice_terms = '$terms'
            AND status = 'active'
            AND merchant_id NOT IN (
                SELECT merchant_id
                FROM mt_invoice
                WHERE date_from = '$date_covered_start'
                AND date_to = '$date_covered_end'
            )
        LIMIT 0,5
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        echo $e->getMessage();
        return;
    }



    if ($res) {
        foreach ($res as $val) {

            /** GET TOTAL COMMISSION FOR MERCHANT **/
            $merchant_id = $val['merchant_id'];

            $stmt2 = "
                SELECT SUM(total_commission) AS total_commission
                FROM mt_order
                WHERE merchant_id = '$merchant_id'
                $and
                $and_status
            ";

            if (isset($_GET['debug'])) {
                echo "<pre>"; print_r($stmt2); echo "</pre>";
            }

            try {
                $query2 = $this->db->prepare($stmt2);
                $query2->execute();
                $res2 = $query2->fetch(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                continue;  // skip merchant if error
            }

            $total = ($res2 && $res2['total_commission'] > 0) ? $res2['total_commission'] : 0;

            /** PREPARE INVOICE INSERT PARAMS **/
            $params = array(
                'merchant_id'            => $merchant_id,
                'merchant_name'          => $val['restaurant_name'],
                'merchant_contact_email' => $val['contact_email'],
                'merchant_contact_phone' => $val['contact_phone'],
                'invoice_terms'          => $terms,
                'invoice_total'          => $total,
                'date_from'              => $date_covered_start,
                'date_to'                => $date_covered_end,
                'date_created'           => $this->functions->dateNow(),
                'ip_address'             => $_SERVER['REMOTE_ADDR']
            );

            // Your existing insertData function is untouched
            $this->functions->insertData("mt_invoice", $params);
        }
    } else {
        echo "No results";
    }
}


public function GeneratePdf()
{         
    define('K_TCPDF_EXTERNAL_CONFIG', true);
    $upload_path = $this->functions->uploadPath();   
    $assets_path = Config::$baseUrl . "/assets/images";

    $website_logo = $this->functions->getOptionAdmin('website_logo');
    if (!empty($website_logo)) {
        define('K_PATH_IMAGES', $upload_path . "/");
        $logo = $website_logo;
    } else {
        define('K_PATH_IMAGES', $assets_path . "/");
    }

    $html = '';
    $terms = $this->functions->InvoiceTerms();
    $site_title = $this->functions->getOptionAdmin("website_title");
    
    $bank_account_name = $this->functions->getOptionAdmin('admin_bank_account_name');
    $bank_account_number = $this->functions->getOptionAdmin('admin_bank_account_number');
    $bank_custom_tpl = $this->functions->getOptionAdmin('admin_bank_custom_tpl');
    $bank_deposited_timeframe = $this->functions->getOptionAdmin('admin_bank_deposited_timeframe');
    if (empty($bank_deposited_timeframe)) {
        $bank_deposited_timeframe = 0;
    }

    $and_status = '';
    $commission_status = $this->functions->getCommissionStatusBased();
    if ($commission_status) {
        $and_status = " AND status IN ($commission_status) ";
    }   

    $stmt = "
        SELECT a.*,
        CONCAT(b.street,' ',b.city) AS merchant_address,
        CONCAT(b.state,' ',b.post_code,' ',b.country_code) AS merchant_address2
        FROM mt_invoice a
        LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id
        WHERE a.status = 'pending'
        ORDER BY invoice_number ASC
        LIMIT 0,10
    ";

    $process_msg = '';

    try {
        // Fetch invoices
        $stmtInvoices = $this->db->prepare($stmt);
        $stmtInvoices->execute();
        $res = $stmtInvoices->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {    
                $merchant_id = $val['merchant_id'];
                $invoice_number = $val['invoice_number'];
                $invoice_token = $this->functions->generateInvoiceToken();
                $pdf_filename = "$invoice_number-$invoice_token";

                $bank_deposited_timeframe_date = date("Y-m-d", strtotime($val['date_created'] . " +$bank_deposited_timeframe days"));

                // Build SQL directly with variables
                $stmt2 = "
                    SELECT *
                    FROM mt_order
                    WHERE merchant_id=" . $val['merchant_id'] . "
                    AND date_created BETWEEN '" . $val['date_from'] . " 00:00:00' AND '" . $val['date_to'] . " 23:59:00'
                    $and_status
                ";

                $stmtOrders = $this->db->prepare($stmt2);
                $stmtOrders->execute();
                $res2 = $stmtOrders->fetchAll(PDO::FETCH_ASSOC);

                if ($res2) {

                    $data_html = [
                        'invoice_info' => $val,
                        'data' => $res2,
                        'terms' => $terms,
                        'site_title' => $site_title,
                        'bank_account_name' => $bank_account_name,
                        'bank_account_number' => $bank_account_number,
                        'bank_custom_tpl' => $bank_custom_tpl,
                        'bank_deposited_timeframe_date' => $bank_deposited_timeframe_date
                    ];

                    // Render template into $html
                    $viewPath = __DIR__ . '/../views/admin/invoice-tpl.php';
                    ob_start();
                    extract($data_html);
                    require $viewPath;
                    $html = ob_get_clean();
                    
                    $this->writePDF($html, $pdf_filename);         
                    $process_msg = "process";

                } else {
                    $process_msg = "process";
                    $pdf_filename = '';
                }

                if (!empty($pdf_filename)) {
                    $pdf_filename = $pdf_filename . ".pdf";
                    // Send notification to merchant



                    $this->functions->sendInvoiceNotification($merchant_id, $val, $pdf_filename);
                }

                $params = [
                    'status' => $process_msg,
                    'invoice_token' => $invoice_token,
                    'pdf_filename' => $pdf_filename,
                    'date_process' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                ];

                $this->functions->updateData("mt_invoice", $params, 'invoice_number', $invoice_number);
            }
        } else {
            echo "no results"; 
        }

    } catch (PDOException $e) {
        echo "Database Error: " . $e->getMessage();
    }
}

public function writePDF($data = '', $pdf_filename = '')
{
    require_once __DIR__ . '/../../vendor/TCPDF/tcpdf.php';

    $site_title = $this->functions->getOptionAdmin("website_title");
    
    // Local server path
    $upload_path = $this->functions->uploadPath(); // e.g., /home/foodnexustechco/public_html/upload
    $invoice_dir = $upload_path . '/invoice';

    // Ensure folder exists
    if (!file_exists($invoice_dir)) {
        mkdir($invoice_dir, 0777, true);
    }

    // Default logo
    $assets_path = Config::$baseUrl . "/assets/images";
    $logo = "default-image-merchant.png";

    $site_address = $this->functions->getOptionAdmin("website_address");
    if ($country_details = $this->functions->getCountryByShortCode($this->functions->getOptionAdmin('admin_country_set'))) {
        $site_address .= " " . $country_details['country_name'];
    } else {
        $site_address .= " " . $this->functions->getOptionAdmin('admin_country_set');
    }

    $site_address .= "\n" . $this->functions->getOptionAdmin('website_contact_phone') . " / " . $this->functions->getOptionAdmin('website_contact_email');

    // Initialize TCPDF
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetCreator($site_title);
    $pdf->SetAuthor($site_title);
    $pdf->SetTitle('Invoice');
    $pdf->SetDefaultMonospacedFont("courier");

    $pdf->SetHeaderData($logo, 15, $site_title, $site_address);

    // Header and footer fonts
    $pdf->setHeaderFont([PDF_FONT_NAME_MAIN, '', 9]);
    $pdf->setFooterFont([PDF_FONT_NAME_DATA, '', 9]);

    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    $pdf->SetAutoPageBreak(TRUE, 25);
    $pdf->setImageScale(1.25);

    $pdf->SetFont('helvetica', 'B', 20);
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 8);

    $pdf->writeHTML($data, true, false, false, false, '');

    // Generate full local path

    /*$upload_path = '/home/foodnexustechco/public_html/upload';
    $pdf->Output($upload_path."/invoice/$pdf_filename.pdf", 'F');*/

    $invoice_dir = __DIR__ . '/../../upload/invoice';
    $full_path = $invoice_dir . '/' . $pdf_filename . '.pdf';

// Save PDF
    $pdf->Output($full_path, 'F');

     /*$full_path = Config::$baseUrl."/upload/invoice/". $pdf_filename . '.pdf';
    
    
    // Save PDF to local path
    $pdf->Output($full_path, 'F');*/

    // Generate public URL for the PDF
    
}



public function writePDF_bkup($data='', $pdf_filename='')
  {
     

     require_once __DIR__ . '/../../vendor/TCPDF/tcpdf.php';

      
      $site_title=$this->functions->getOptionAdmin("website_title");
      $upload_path=$this->functions->uploadPath();   
      $assets_path = Config::$baseUrl . "/assets/images";
      $logo="default-image-merchant.png";
      
      /*if (!file_exists($upload_path."/invoice")){
        mkdir($upload_path."/invoice",777);
      }*/
      
      /*$website_logo=getOptionA('website_logo');
      if(!empty($website_logo)){
        if (file_exists($upload_path.$website_logo)){
          define ('K_PATH_IMAGES', $upload_path."/");
          $logo=$website_logo;
        } else define ('K_PATH_IMAGES', $assets_path ."/" );
      } else define ('K_PATH_IMAGES', $assets_path ."/");*/
      
      $site_addres=$this->functions->getOptionAdmin("website_address");
      if ($country_details=$this->functions->getCountryByShortCode($this->functions->getOptionAdmin('admin_country_set'))){
        $site_addres.=" ".$country_details['country_name'];
      } else $site_addres.=" ".$this->functions->getOptionAdmin('admin_country_set');     
      
      $site_addres.="\n".$this->functions->getOptionAdmin('website_contact_phone')." / ".$this->functions->getOptionAdmin('website_contact_email');     
           
          
      $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
      $pdf->SetCreator($site_title);
    $pdf->SetAuthor($site_title);
    $pdf->SetTitle('Invoice');
    $pdf->SetDefaultMonospacedFont("courier");        
        
    //dump($logo);die();
    $pdf->SetHeaderData( $logo , 15, $site_title, $site_addres);
    
    // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', 9));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', 9));

        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, 25); 
        
        // set image scale factor
        $pdf->setImageScale(1.25);
        
        // set font
        $pdf->SetFont('helvetica', 'B', 20);
        
        // add a page
       $pdf->AddPage();
       
       $pdf->SetFont('helvetica', '', 8);
        
       
       //$pdf->writeHTML("<p style=\"color:red;\">test</p>", true, false, false, false, '');
       $a=$pdf->writeHTML($data, true, false, false, false, '');
       
       //$pdf->Output('example_048.pdf', 'I'); 

       //$pdf->Output($upload_path."/invoice/$pdf_filename.pdf", 'F');







  }





    








 

    
   
}
