<?php




class StoreController extends Controller {
    
     public $crumbsTitle='';
   public $theme_compression='';
    public $is_rtl=false;
    public $action_name='12';
    public $provider;
     public $map_api;
    public $map_provider;  
    public $mapbox_default_zoom;

    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        $this->MapsWrapper = new MapsWrapper();
        $this->PaypalWrapper = new PaypalWrapper();

        $this->Item_menu = new Item_menu();

        $this->PointsProgram = new PointsProgram();

        $this->InventoryWrapper=new InventoryWrapper();


        $this->CheckoutWrapper = new CheckoutWrapper();

        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
      $provider = $this->functions->getMapProvider(); 
      $map_api = isset($provider['map_api'])?$provider['map_api']:'';
      $map_provider = isset($provider['provider'])?$provider['provider']:'';  
      $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    //}
      //echo $_REQUEST['url'];die();
/*
   $requested_url=$_SERVER['REQUEST_URI'];
  $url_parts = explode('/', trim($requested_url, '/'));
   if (count($url_parts) >= 2) {
    $action_name = $url_parts[1];
   }
   if($action_name=='')
   {
    $action_name='index';
   }


   $this->action_name=$action_name;
   $this->action_id=$action_name;
   */
   
   
   $requested_url = $_SERVER['REQUEST_URI'];
$url_parts = explode('/', trim($requested_url, '/'));

$action_name = isset($url_parts[0]) ? $url_parts[0] : 'index';

$this->action_name = $action_name;
$this->action_id = $action_name;


   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {

        //echo "store index";die();
        

        $this->Home();
    }


    public function Home() {

        //Cookie::removeCookie('kr_location_search');
    unset($_SESSION['voucher_code']);
        unset($_SESSION['less_voucher']);
        unset($_SESSION['google_http_refferer']); 
        
    if (isset($_GET['token'])){
      if (!empty($_GET['token'])){
          //Yii::app()->functions->paypalSetCancelOrder($_GET['token']);
      }
    }
              
    $seo_title=$this->functions->getOptionAdmin('seo_home');
    $seo_meta=$this->functions->getOptionAdmin('seo_home_meta');
    $seo_key=$this->functions->getOptionAdmin('seo_home_keywords');
          
    if (!empty($seo_title)){
       $seo_title=$this->functions->smarty('website_title',$this->functions->getWebsiteName(),$seo_title);
       $this->pageTitle=$seo_title;
       
    }

    
    $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

    
    /*$this->render('index',array(
       'home_search_mode'=>getOptionA('home_search_mode'),
       'enabled_advance_search'=> getOptionA('enabled_advance_search'),
       'theme_hide_how_works'=>getOptionA('theme_hide_how_works'),
       'theme_hide_cuisine'=>getOptionA('theme_hide_cuisine'),
       'disabled_featured_merchant'=>getOptionA('disabled_featured_merchant'),
       'disabled_subscription'=>getOptionA('disabled_subscription'),
       'theme_show_app'=>getOptionA('theme_show_app'),
       'theme_app_android'=>FunctionsV3::prettyUrl(getOptionA('theme_app_android')),
       'theme_app_ios'=>FunctionsV3::prettyUrl(getOptionA('theme_app_ios')),
       'theme_app_windows'=>FunctionsV3::prettyUrl(getOptionA('theme_app_windows')),
       'map_provider'=>$map
    ));*/

    


    $data = [
            'pageTitle' => $seo_title,
             'map_provider' =>$map_provider,
             'mapbox_default_zoom' =>$mapbox_default_zoom,
             'map_api' =>$map_api,
             'map_type' =>$map_type,
            'provider'=>isset($provider['provider'])?$provider['provider']:'',

            'home_search_mode'=>$this->functions->getOptionAdmin('home_search_mode'),
             'enabled_advance_search'=> $this->functions->getOptionAdmin('enabled_advance_search'),
             'theme_hide_how_works'=>$this->functions->getOptionAdmin('theme_hide_how_works'),
             'theme_hide_cuisine'=>$this->functions->getOptionAdmin('theme_hide_cuisine'),
             'disabled_featured_merchant'=>$this->functions->getOptionAdmin('disabled_featured_merchant'),
             'disabled_subscription'=>$this->functions->getOptionAdmin('disabled_subscription'),
             'theme_show_app'=>$this->functions->getOptionAdmin('theme_show_app'),
             'theme_app_android'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('theme_app_android')),
             'theme_app_ios'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('theme_app_ios')),
             'theme_app_windows'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('theme_app_windows')),
             'map_provider'=>$provider

            ];
        $this->view('store/index', $data, 'layouts/store_tpl');


        
    }


    public function export_feed()
{
    header('Content-Type: application/json');

    $feed = [
        "metadata" => [
            "generation_timestamp" => time(),
            "partner_name" => "Chezious"
        ],
        "restaurants" => [
            [
                "restaurant_id" => "chezious_001_nz_nexto",
                "name" => "Chezious",
                "description" => "Delicious meals served fresh every day.",
                "timezone" => "Pacific/Auckland",
                "phone_number" => "+64 9-123 4567", // Replace with real phone if available
                "website_url" => "https://food.nexustech.co.nz/menu/cheziouss",
                "image_urls" => [
                    "https://food.nexustech.co.nz/upload/1741329191-onboarding-3.png" // Optional: replace with actual image URL
                ],
                "location" => [
                    "lat_lng" => [
                        "latitude" => -36.9550833,
                        "longitude" => 174.8517077
                    ],
                    "address" => [
                        "street_address" => "Sixth Avenue, Tauranga",   // Replace with real street
                        "locality" => "Manurewa",                   // Replace if needed
                        "region" => "Auckland",
                        "postal_code" => "2102",                    // Replace if needed
                        "country" => "NZ"
                    ]
                ],
                "opening_hours" => [
                    "periods" => [
                        [
                            "open_day" => "MONDAY",
                            "open_time" => "11:00",
                            "close_day" => "MONDAY",
                            "close_time" => "22:00"
                        ],
                        [
                            "open_day" => "TUESDAY",
                            "open_time" => "11:00",
                            "close_day" => "TUESDAY",
                            "close_time" => "22:00"
                        ],
                        [
                            "open_day" => "WEDNESDAY",
                            "open_time" => "11:00",
                            "close_day" => "WEDNESDAY",
                            "close_time" => "22:00"
                        ],
                        [
                            "open_day" => "THURSDAY",
                            "open_time" => "11:00",
                            "close_day" => "THURSDAY",
                            "close_time" => "22:00"
                        ],
                        [
                            "open_day" => "FRIDAY",
                            "open_time" => "11:00",
                            "close_day" => "FRIDAY",
                            "close_time" => "22:00"
                        ],
                        [
                            "open_day" => "SATURDAY",
                            "open_time" => "11:00",
                            "close_day" => "SATURDAY",
                            "close_time" => "22:30"
                        ],
                        [
                            "open_day" => "SUNDAY",
                            "open_time" => "11:00",
                            "close_day" => "SUNDAY",
                            "close_time" => "22:00"
                        ]
                    ]
                ],
                "capabilities" => [
                    "supports_reservations" => true
                ],
                "menus" => [
                    [
                        "menu_id" => "chezious_main_menu",
                        "name" => "Main Menu",
                        "description" => "Explore our full selection of dishes.",
                        "url" => "https://food.nexustech.co.nz/menu/cheziouss"
                    ]
                ]
            ]
        ]
    ];

    echo json_encode($feed, JSON_PRETTY_PRINT);
}



public function booking_server()
{
    header('Content-Type: application/json');
    $input = json_decode(file_get_contents("php://input"), true);

    if (!empty($input['booking_request'])) {
        $bookingRequest = $input['booking_request'];

        // Validate required fields
        if (empty($bookingRequest['user_information']) || empty($bookingRequest['slot'])) {
            echo json_encode(["error" => ["message" => "Missing user or slot info"]], JSON_PRETTY_PRINT);
            return;
        }

        $bookingId = uniqid("gbook_");

        $response = [
            "booking" => [
                "booking_id" => $bookingId,
                "status" => "CONFIRMED",
                "user_information" => $bookingRequest['user_information'],
                "slot" => $bookingRequest['slot']
            ]
        ];
    } else {
        $response = [
            "error" => ["message" => "Invalid request"]
        ];
    }

    echo json_encode($response, JSON_PRETTY_PRINT);
}




    



    public function paypal_v2init() {
        // PayPal credentials


      $amount_to_pay = 0; 
    $error = ''; 
    $credentials = '';
    $payment_description = '';
    $merchant_name = ''; 
    $reference_id = ''; 
    $client_info = [];
    $trans_type = 'order';
    $currency_code = $this->functions->getCurrencyCode();

    $back_url = Config::$baseUrl . "/confirmorder";

    // Fetch the order token
    $order_id_token = isset($_GET['order_id_token']) ? $_GET['order_id_token'] : '';

    // Fetch order details
    if ($data = $this->functions->getOrderByToken($order_id_token)) {
        $merchant_id = $data['merchant_id'];
        $client_id = $data['client_id'];
        $order_id = $data['order_id'];
        $reference_id = $data['order_id_token'];

        $merchant_name = $this->functions->clearString($data['merchant_name']);
        $payment_description = $this->functions->translation("default", "Payment to merchant " . $merchant_name . " Order ID# " . $order_id);

        $amount_to_pay = $this->functions->normalPrettyPrice($data['total_w_tax']);
    } else {
        $error = $this->functions->translation("default", "Sorry, but we cannot find what you are looking for.");
    }

    // Fallback for currency code
    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }






        if (empty($error)) {

        if ($credentials = $this->functions->getCredentials_paypal($merchant_id)) {

         
                   
        $success_url = $this->functions->websiteUrl() . "/paypal_success?reference_id=" . urlencode($reference_id) . "&trans_type=$trans_type";
    
        if ($this->functions->isClientLogin()){
        $cancel_url = $this->functions->websiteUrl() . "/paymentoption";
      }else{
        $cancel_url = $this->functions->websiteUrl() . "/checkout";
      }


 
        $clientId =  $credentials['client_id'];
        $clientSecret = $credentials['secret_key'];
        

        $baseUrl = $credentials['mode'] == 'live' 
        ? 'https://api-m.paypal.com' // Live URL
        : 'https://api-m.sandbox.paypal.com';

        // Step 1: Generate Access Token
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v1/oauth2/token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, "$clientId:$clientSecret");
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
        curl_setopt($ch, CURLOPT_POST, true);

        $response = curl_exec($ch);



        curl_close($ch);

        if (!$response) {
            die('Error: Unable to fetch access token');
        }

        $accessToken = json_decode($response)->access_token;

        // Step 2: Create Order
      $orderData = [
    "intent" => "CAPTURE",
    "purchase_units" => [
        [
            "amount" => [
                'currency_code' => $currency_code,
                'value' => $amount_to_pay,
            ]
        ]
    ],
    "application_context" => [
        "return_url" => $success_url,
        "cancel_url" => $cancel_url
    ]
];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v2/checkout/orders");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer $accessToken"
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $order = json_decode($response);

        $this->functions->update_payment_id($order_id,$order->id);




        if (!isset($order->links[1]->href)) {
            die('Error: Unable to create PayPal order');
        }

        $approvalUrl = $order->links[1]->href;
        
        //echo $approvalUrl;die();
        // Pass approval URL to the view

         header("Location: " . $approvalUrl);
         exit();
        
        /*$data = ['approval_url' => $approvalUrl];
        $this->view('store/paypal_iframe', $data,'');*/
         }else {
            $error = $this->functions->translation("default", "Invalid merchant credentials");
          }

        }


         // Handle error
        if (!empty($error)) {
            $error .= '<p style="margin-top:20px;"><a href="' . $back_url . '" />' . $this->functions->translation("default", "back") . '</a></p>';
            $data = ['message' => $error];
            $this->view('store/error', $data, 'layouts/store_tpl');
        }



    }


public function paypal_success()
{
    $get = $_GET;
    $back_url = '';
    $error = '';
    $payment_code = 'paypal_v2';

    $reference_id = isset($get['reference_id']) ? $get['reference_id'] : '';
    $trans_type = isset($get['trans_type']) ? $get['trans_type'] : '';
    $payment_token = isset($get['token']) ? $get['token'] : '';

    if (!empty($reference_id) && !empty($trans_type)) {
        switch ($trans_type) {
            case "reg":
                $back_url = $this->functions->websiteUrl() . "/merchantsignup?Do=step3b&token=$reference_id&gateway=$payment_code";
                if ($data = $this->functions->getMerchantByToken($reference_id)) {
                    if ($credentials = $this->functions->getAdminCredentials_paypalv2()) {
                        try {
                            $resp = $this->capturePayment($credentials, $payment_token);

                            if ($resp['status'] !== 'COMPLETED') {
                                throw new Exception("Payment capture failed: " . json_encode($resp));
                            }

                            $card_fee = $credentials['card_fee'] ?? 0;

                            $params_logs = [
                                'package_id' => $data['package_id'],
                                'merchant_id' => $data['merchant_id'],
                                'price' => $data['package_price'] + $card_fee,
                                'payment_type' => $payment_code,
                                'membership_expired' => $data['membership_expired'],
                                'date_created' => $this->functions->dateNow(),
                                'ip_address' => $_SERVER['REMOTE_ADDR'],
                                'PAYPALFULLRESPONSE' => json_encode($resp),
                                'TRANSACTIONID' => $resp['id'],
                                'merchant_ref' => $reference_id,
                                'status' => $resp['status']
                            ];

                            if (isset($_GET['renew'])) {
                                $package_id = $_GET['package_id'] ?? '';
                                if ($package_id > 0) {
                                    $back_url .= "&renew=1&package_id=$package_id";
                                    $membership_info = $this->functions->upgradeMembership($data['merchant_id'], $package_id);

                                    $params_logs['membership_expired'] = $membership_info['membership_expired'];
                                    $params_logs['package_id'] = $package_id;
                                    $params_logs['price'] = $membership_info['package_price'] + $card_fee;

                                    $this->functions->updateData("mt_merchant", [
                                        'package_id' => $package_id,
                                        'package_price' => $membership_info['package_price'] + $card_fee,
                                        'membership_expired' => $membership_info['membership_expired'],
                                        'status' => 'active'
                                    ], 'merchant_id', $data['merchant_id']);
                                }
                            }

                            $this->functions->insertData("mt_package_trans", $params_logs);

                            $this->functions->updateData("mt_merchant", [
                                'payment_steps' => 3,
                                'membership_purchase_date' => $this->functions->dateNow()
                            ], 'merchant_id', $data['merchant_id']);

                            if (isset($_GET['renew'])) {
                                header('Location: ' . Config::$baseUrl . '/renewsuccesful');
                                exit;
                            } else {
                                $this->functions->sendWelcomeEmailMerchant($data);
                                $this->functions->sendMerchantActivation($data, $data['activation_key']);
                                header('Location: ' . Config::$baseUrl . '/merchantsignup?Do=step4&token=' . urlencode($reference_id));
                                exit;
                            }
                        } catch (Exception $e) {
                            $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
                        }
                    } else {
                        $error = $this->functions->translation("default", "Invalid payment credentials");
                    }
                } else {
                    $error = "Invalid reference id";
                }
                break;

            case "order":
                $back_url = Config::$baseUrl . '/paymentoption';
                if ($data = $this->functions->getOrderInfoByToken($reference_id)) {
                    $merchant_id = $data['merchant_id'] ?? '';
                    $order_id = $data['order_id'];
                    $redirect_link = Config::$baseUrl . "/receipt?id=" . $order_id;

                    if ($credentials = $this->functions->getCredentials_paypal($merchant_id)) {
                        try {
                            $resp = $this->capturePayment($credentials, $payment_token);

                            if ($resp['status'] !== 'COMPLETED') {
                                throw new Exception("Payment capture failed: " . json_encode($resp));
                            }

                            if ($data['status'] === "paid") {
                                header('Location: ' . $redirect_link . "&note=already paid");
                                exit;
                            } else {
                                $this->functions->updateOrderPayment($order_id, $payment_code, $resp['id'], $resp, $reference_id);


                                 $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                                    if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                                      $params_update_order=array( 
                                    
                                     
                                      'order_number'=>$order_number, 
                                    
                                      );    
                                        
                                  
                                    $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id);

                                    if($_SESSION['guest_chkout']==0){
                      $this->PointsProgram->saveEarnPoints(
                                                   isset($_SESSION['pts_earn'])?$_SESSION['pts_earn']:'',
                                                   $this->functions->getClientId(),
                                                   $merchant_id,
                                                   $order_id,
                                                   "paypal_v2",
                                                   "paid",
                                                   $order_id
                                                );
        }

        //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code



                                header('Location: ' . $redirect_link);
                                exit;
                            }
                        } catch (Exception $e) {
                            $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
                        }
                    } else {
                        $error = $this->functions->translation("default", "Invalid payment credentials");
                    }
                } else {
                    $error = $this->functions->translation("default", "Failed getting order information");
                }
                break;

            case "sms":
                $back_url = $this->functions->websiteUrl() . "/merchant/purchasesms";
                if ($data = $this->functions->getSMSTransLog($reference_id)) {
                    if ($credentials = $this->functions->getAdminCredentials_paypalv2()) {
                        try {
                            $resp = $this->capturePayment($credentials, $payment_token);

                            if ($resp['status'] !== 'COMPLETED') {
                                throw new Exception("Payment capture failed: " . json_encode($resp));
                            }

                            $params = [
                                'merchant_id' => $data['merchant_id'],
                                'sms_package_id' => $data['sms_package_id'],
                                'payment_type' => $payment_code,
                                'package_price' => $data['package_price'],
                                'sms_limit' => $data['sms_limit'] ?? '',
                                'date_created' => $this->functions->dateNow(),
                                'ip_address' => $_SERVER['REMOTE_ADDR'],
                                'payment_gateway_response' => json_encode($resp),
                                'payment_reference' => $resp['id'],
                                'status' => 'paid',
                                'merchant_ref' => $reference_id
                            ];

                            $last_insert_id = $this->functions->insertData('mt_sms_package_trans', $params);
                            $redirect_link = Config::$baseUrl . "/merchant/smsReceipt?id=" . $last_insert_id;
                            header("Location: " . $redirect_link);
                            exit;
                        } catch (Exception $e) {
                            $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
                        }
                    } else {
                        $error = $this->functions->translation("default", "Invalid payment credentials");
                    }
                } else {
                    $error = $this->functions->translation("default", "Invalid reference id");
                }
                break;

            default:
                $error = $this->functions->translation("default", "Invalid transaction type " . $trans_type);
                break;
        }
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for");
    }

    if (!empty($error)) {
        $error .= '<p style="margin-top:20px;"><a href="' . $back_url . '" />' . $this->functions->translation("default", "Go back") . '</a></p>';
        $data = ['message' => $error];
        $this->view('store/error', $data, 'layouts/store_tpl');
    }
}


private function capturePayment($credentials, $payment_token)
{
    // Set the base URL for PayPal API based on the environment (live or sandbox)
    $base_url = $credentials['mode'] === 'live' 
                ? 'https://api-m.paypal.com' 
                : 'https://api-m.sandbox.paypal.com';

    // Step 1: Get Access Token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/v1/oauth2/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $credentials['client_id'] . ":" . $credentials['secret_key']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and check if the access token was obtained
    $token_data = json_decode($response, true);
    if (!isset($token_data['access_token'])) {
        throw new Exception("Failed to retrieve access token: " . json_encode($token_data));
    }
    $access_token = $token_data['access_token'];

    // Step 2: Capture the Payment using the provided payment token
    $capture_url = $base_url . "/v2/checkout/orders/$payment_token/capture";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $capture_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer $access_token"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and return it
    $capture_data = json_decode($response, true);
    if (isset($capture_data['status']) && $capture_data['status'] === 'COMPLETED') {
        return $capture_data; // Return the successful payment data
    } else {
        throw new Exception("Payment capture failed: " . json_encode($capture_data));
    }
}























  public function ConfirmOrder()
  {   
        
    if (!isset($_GET['isguest'])){
      if ( !$this->functions->isClientLogin()){

        

        $redirec_link=Config::$baseUrl."/";
         header("Location: " . $redirec_link);
         exit();
      }
    }
    
    $data=isset($_SESSION['confirm_order_data'])?$_SESSION['confirm_order_data']:'';    
    
    if(isset($data['is_search_by_location'])){
       unset($data['is_search_by_location']);
    }
    
    if (is_array($data) && count($data)>=1){


      

       $data = [
        'data'=>$data,
        'merchant_info'=>$this->functions->getMerchant($data['merchant_id']),
        's'=>$_SESSION,
        'paymentlist'=>$this->functions->PaymentOptionList(),
        'guestcheckout'=>isset($data['is_guest_checkout'])?true:false

            ];
        $this->view('store/confirm-order-new', $data, 'layouts/store_tpl');




    } else{

        $data = ['message' => $this->functions->translation("default","Something went wrong during processing your request. Please try again later.")];
        $this->view('store/error', $data, 'layouts/store_tpl');

     }
  }




    public function MerchantSignup()
  {   
    
    $act_menu=$this->functions->getTopMenuActivated();
    if (!in_array('resto_signup',(array)$act_menu)){



      

       $data = [
            'header'=>true

            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');

        exit();
    }




    
    
    
    if(isset($_GET['package_id'])){
      $_GET['id']=$_GET['package_id'];
    } 
    
    if (isset($_GET['Do'])){
      $_GET['do']=$_GET['Do'];
    } 

    
    $exchange_rate = $this->functions->getRates();


    
    if (isset($_GET['do'])){
      switch ($_GET['do']) {
        case 'step2':

        $captchaEnabled=$this->functions->getOptionAdmin('captcha_merchant_signup'); 
        $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 

  
    
           $data = [
            'captchaEnabled'=>$captchaEnabled,
            'captcha_site_key'=>$captcha_site_key,

            'data'=>$this->functions->getPackagesById($_GET['package_id']),
            'limit_post'=>$this->functions->ListlimitedPost(),
            'terms_merchant'=>$this->functions->getOptionAdmin('website_terms_merchant'),
            'terms_merchant_url'=>$this->functions->getOptionAdmin('website_terms_merchant_url'),
            'package_list'=>$this->functions->getPackagesList(),
            'kapcha_enabled'=>$this->functions->getOptionAdmin('captcha_merchant_signup'),
            'exchange_rate'=>$exchange_rate

            ];

           

          
           $this->view('store/merchant-signup-step2', $data, 'layouts/store_tpl');




          break;
        case "step3":
           $renew=false;
           $package_id=isset($_GET['package_id'])?$_GET['package_id']:'';  
           if (isset($_GET['action'])){  
             $renew=true;
           } 
           if (isset($_GET['renew'])){   
             $renew=true;
           } 
           if(isset($_GET['internal-token'])){
            $_GET['token']=$_GET['internal-token'];
           }


           

            $data = [
            'merchant'=>$this->functions->getMerchantByToken($_GET['token']),
            'package_id'=>$package_id,
            'renew'=>$renew,
            'exchange_rate'=>$exchange_rate
            ];
           $this->view('store/merchant-signup-step3', $data, 'layouts/store_tpl');



          break;
        case "step3a":

             

           $this->view('store/merchant-signup-step3a', '', 'layouts/store_tpl');

          break;  
        case "step3b":          
            $currency = $this->functions->getOptionAdmin('admin_currency_set');
                
          if (isset($_GET['gateway'])){
            if ($_GET['gateway']=="mcd"){
              
              
              /* Custom code 2 starts */
            }else if ($_GET['gateway']=="poli1"){

              

              $this->view('store/paypoli-init', '', 'layouts/store_tpl');

              /* Custom code 2 ends */
              
            } elseif ( $_GET['gateway']=="pyl" ){

              
            $this->view('store/payline-init2', '', 'layouts/store_tpl');

            } elseif ( $_GET['gateway']=="ide" ){
              //$this->render('sow-init');
            } elseif ( $_GET['gateway']=="payu" ){              
              //$this->render('pau-init');  
            } elseif ( $_GET['gateway']=="pys" ){             
              //$this->render('paysera-init');  
            } elseif ( $_GET['gateway']=="rzr" ){             
              /*$this->render('rzr-init-merchant',array(
                'exchange_rate'=>$exchange_rate
              )); */  
            } else { 


              

            $data = [
            'exchange_rate'=>$exchange_rate
            ];
           $this->view('store/'.$_GET['gateway'].'init', $data, 'layouts/store_tpl');

           
            }
          } else $this->view('store/merchant-signup-step3b', '', 'layouts/store_tpl');
          break;    
          
        case "step4":   


             $disabled_verification=$this->functions->getOptionAdmin('merchant_email_verification');
             if ( $disabled_verification=="yes"){

             

              $data = [
              'data'=>$this->functions->getMerchantByToken($_GET['token'])
              ];
             $this->view('store/merchant-signup-thankyou2', $data, 'layouts/store_tpl'); 


             } else {     
                            
               $continue=true;
             if ($merchant=$this->functions->getMerchantByToken($_GET['token'])){  
              if ( $merchant['package_price']>=1){
                if ($merchant['payment_steps']!=3){
                  $continue=false;
                }
              }
             } else $continue=false;
                                    
               /*check if payment was offline*/
               $is_offline_paid=false;
                 if ( $package_info=$this->functions->getMerchantPaymentMembership($merchant['merchant_id'],
                 $merchant['package_id'])){                             
                  $offline_payment=$this->functions->getOfflinePaymentList();                  
                  if ( array_key_exists($package_info['payment_type'],(array)$offline_payment)){
                    $is_offline_paid=true;
                  }
                 }      

                 if ($is_offline_paid){

                  

                  $data = [
                  'data'=>$merchant
                  ];
                  $this->view('store/merchant-signup-thankyou2', $data, 'layouts/store_tpl');


                 } else {  

                 
                  $continue=true;
                  $data = [
                  'continue'=>$continue
                  ];
                  $this->view('store/merchant-signup-step4', $data, 'layouts/store_tpl');


                 }   
             }
          break;  
          
        case "thankyou1":
         

         
            

           $data = [
                  'data'=>$this->functions->getMerchantByToken($_GET['token'])
          ];
          $this->view('store/merchant-signup-thankyou1', $data, 'layouts/store_tpl');

          break;    
        case "thankyou2":

         

           $data = [
                  'data'=>$this->functions->getMerchantByToken($_GET['token'])
          ];
          $this->view('store/merchant-signup-thankyou2', $data, 'layouts/store_tpl');  


          break;    
        case "thankyou3":

          


           $data = [
                  'data'=>$this->functions->getMerchantByToken($_GET['token'])
          ];
          $this->view('store/merchant-signup-thankyou3', $data, 'layouts/store_tpl'); 


          break;      
        default: 


          

          $data = [
                  'list'=>$this->functions->getPackagesList(),
                   'limited_post'=>$this->functions->ListlimitedPost(),                   
                   'exchange_rate'=>$exchange_rate
          ];
          $this->view('store/merchant-signup', $data, 'layouts/store_tpl');


          break;
      }
    } else {
      $disabled_membership_signup=$this->functions->getOptionAdmin('admin_disabled_membership_signup');
      if($disabled_membership_signup==1){ 

        

        $data = [
            'header'=>true
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');

      } else {

        
        
         $data = [
            'list'=>$this->functions->getPackagesList(),
            'limited_post'=>$this->functions->ListlimitedPost(),
            'exchange_rate'=>$exchange_rate
            ];
        $this->view('store/merchant-signup', $data, 'layouts/store_tpl');


      }
    }
  }


  public function custom_error(){

     $data = ['message' => $this->functions->translation("default","Something went wrong during processing your request. Please try again later.")];
      $this->view('store/error', $data, 'layouts/store_tpl');

  }


  public function Deactivate() 
  { 
       $data=[];

       $this->view('store/deactivate', $data, 'layouts/store_tpl');

    } 





    public function MerchantSignupSelection()
  {
    
    $act_menu=$this->functions->getTopMenuActivated();
    if (!in_array('resto_signup',(array)$act_menu)){


      

      $data = [
            'header'=>true
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');



      return ;
    } 

    if ( $this->functions->getOptionAdmin("merchant_disabled_registration")=="yes"){
      

      $data = [
            'header'=>true
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');

    } else{

     
      $data = [
       'percent'=>$this->functions->getOptionAdmin('admin_commision_percent'),
      'commision_type'=>$this->functions->getOptionAdmin('admin_commision_type'),
      'currency'=>$this->functions->adminCurrencySymbol(),
      'disabled_membership_signup'=>$this->functions->getOptionAdmin('admin_disabled_membership_signup')
      ];


        $this->view('store/merchant-signup-selection', $data, 'layouts/store_tpl');




     }


  }

  public function MerchantSignupinfo()
  {
    $commission_type=$this->functions->MembershipType();
    unset($commission_type[1]);   

    
    

    $data = [
       'terms_merchant'=>$this->functions->getOptionAdmin('website_terms_merchant'),
      'terms_merchant_url'=>$this->functions->getOptionAdmin('website_terms_merchant_url'),
      'kapcha_enabled'=>$this->functions->getOptionAdmin('captcha_merchant_signup'),
      'commission_type'=>$commission_type
      ];


        $this->view('store/merchant-signup-info', $data, 'layouts/store_tpl');



  }

    


    public function stripeInit()
{
    if (!$this->functions->isClientLogin()) {
        //exit();
    }

    $amount_to_pay = 0;
    $error = '';
    $credentials = '';
    $payment_description = '';
    $merchant_name = '';
    $reference_id = '';
    $client_info = [];
    $trans_type = 'order';
    $currency_code = $this->functions->getCurrencyCode();

    $back_url = Config::$baseUrl . "/confirmorder";
    $orig_amount_to_pay = 0;
    $currency_used = '';
    $order_card_fee = 0;
    $exchange_rate_convertion = 0;
    $client_email = '';

    $exchange_rate = $this->functions->getRates();

    $order_id_token = $_GET['order_id_token'] ?? '';
    if ($data = $this->functions->getOrderByToken($order_id_token)) {

      if($data['status']=='paid'){

        $redirec_link=Config::$baseUrl."/";
         header("Location: " . $redirec_link);
       exit();
      }


        $merchant_id = $data['merchant_id'] ?? '';
        $client_id = $data['client_id'];
        $order_id = $data['order_id'];
        $reference_id = $data['order_id_token'];
        $order_card_fee = isset($data['card_fee']) ? (float)$data['card_fee'] : 0;

       


        $merchant_name = isset($data['merchant_name']) ? $this->functions->clearString($data['merchant_name']) : '';

        $payment_description = $this->functions->translation(
            "default",
            "Payment to merchant " . $merchant_name . " Order ID# " . $order_id
        );

        $description = $this->functions->translation("default", "Purchase Order ID# " . $order_id);

        $amount_to_pay = $this->functions->normalPrettyPrice($data['total_w_tax']);
        $orig_amount_to_pay = $this->functions->convertToRaw($amount_to_pay);

        $client_info = $this->functions->getClientInfo($client_id);
        $client_email = $client_info['email_address'] ?? '';
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
    }

    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }



    if (empty($error)) {
        if ($credentials = $this->functions->getCredentials_stripe($merchant_id)) {
            try {
                $amount_to_pay = $this->functions->convertToRaw($amount_to_pay) * 100;

                require_once(__DIR__ . '/../../vendor/stripe/init.php');


                 \Stripe\Stripe::setApiKey($credentials['secret_key']);

$paymentIntent = \Stripe\PaymentIntent::create([
    'amount' => $amount_to_pay, // already in cents
    'currency' => $currency_code,
    'metadata' => [
        'order_id' => $order_id,
        'reference_id' => $reference_id,
    ],
]);

                $params_update = [
                    'payment_gateway_ref' => $paymentIntent->id
                ];

                //$this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);
                $payment_intent=$paymentIntent->id;

                $this->functions->update_payment_id($order_id,$payment_intent);

                $data = [
                    'publish_key' => $credentials['publish_key'],
                    //'stripe_session' => $stripe_session,
                    'client_secret' => $paymentIntent->client_secret,
                    'reference_id' => $reference_id,
                    'payment_description' => $payment_description,
                    'fee' => (float)$order_card_fee,
                    'amount' => (float)$amount_to_pay / 100
                ];

                 




                $this->view('store/stripe_buy', $data, 'layouts/store_tpl');
            } catch (Exception $e) {
                $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
            }
        } else {
            $error = $this->functions->translation("default", "Invalid payment credentials");
        }
    }

    if (!empty($error)) {
        $error .= '<p style="margin-top:20px;"><a href="' . $back_url . '">' . $this->functions->translation("default", "back") . '</a></p>';
        $data = ['message' => $error];
        $this->view('store/error', $data, 'layouts/store_tpl');
    }
}


public function stripe_success()
  {
    $get = $_GET;$error = '';
    $post = $_POST;
    $back_url = Config::$baseUrl."/confirmorder";


    $reference_id = isset($get['reference_id'])?$get['reference_id']:'';
    $trans_type = isset($get['trans_type'])?$get['trans_type']:'';  

    

    if(!empty($reference_id)){      
            
      switch ($trans_type) {
        case "order":
          if ($data = $this->functions->getOrderInfoByToken($reference_id)){
            $payment_gateway_ref=isset($data['payment_gateway_ref'])?$data['payment_gateway_ref']:'';       
            $merchant_id=isset($data['merchant_id'])?$data['merchant_id']:''; 
                  $client_id = $data['client_id'];
                  $order_id = $data['order_id'];
                  
                  

                  $redirec_link=Config::$baseUrl."/receipt?id=".$order_id;

                         
                  if($credentials = $this->functions->getCredentials_stripe($merchant_id)){               
                    try {                     
                    //  $resp = StripeWrapper::retrievePaymentIntent($credentials['secret_key'],$payment_gateway_ref);
                      //dump($resp); die();
                      if($data['status']=="paid"){
                          

                        $redirec_link = $redirec_link."&note=already paid";
                      header("Location: " . $redirec_link);
                      exit();



                      } else {                        
                        $this->functions->updateOrderPayment($order_id,'stp',
                        $payment_gateway_ref,$resp,$reference_id);

                         $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                                    if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                                      $params_update_order=array( 
                                    
                                     
                                      'order_number'=>$order_number, 
                                    
                                      );    
                                        
                                  
                                    $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id);

                                    if($_SESSION['guest_chkout']==0){
          $this->PointsProgram->saveEarnPoints(
                                       isset($_SESSION['pts_earn'])?$_SESSION['pts_earn']:'',
                                       $this->functions->getClientId(),
                                       $merchant_id,
                                       $order_id,
                                       "stp",
                                       "paid",
                                       $order_id
                                    );
        }

        //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code

               

                      
                                        
                      header("Location: " . $redirec_link);
                    exit();                                             
                      }
                    } catch (Exception $e) {
                

                $error = $this->functions->translation("default","Caught exception: ".$e->getMessage());

              }                 
                  } else $error = $this->functions->translation("default","invalid payment credentials");       
          } else $error = $this->functions->translation("default","Failed getting order information");      
          break;
          
        case "reg":       
          
          $payment_code = 'stp';
          $back_url = $this->functions->websiteUrl()."/merchantsignup?Do=step3b&token=$reference_id&gateway=$payment_code";   
          if($data=$this->functions->getMerchantByToken($reference_id)){
             if ($credentials = $this->functions->getAdminCredentials_stp()){
              try {
                
                $payment_gateway_ref=isset($data['payment_gateway_ref'])?$data['payment_gateway_ref']:'';                             
              //  $resp = StripeWrapper::retrievePaymentIntent($credentials['secret_key'],$payment_gateway_ref);                
                
                $card_fee = 0;
                if($credentials['card_fee']>0.001){
                  $card_fee=$credentials['card_fee'];
                }             
                    
                $params_logs=array(
                    'package_id'=>$data['package_id'],            
                    'merchant_id'=>$data['merchant_id'],
                    'price'=>$data['package_price']+$card_fee,
                    'payment_type'=>$payment_code,
                    'membership_expired'=>$data['membership_expired'],
                    'date_created'=>$this->functions->dateNow(),
                    'ip_address'=>$_SERVER['REMOTE_ADDR'],
                    'PAYPALFULLRESPONSE'=>json_encode($get),
                    'TRANSACTIONID'=>$payment_gateway_ref,
                    'merchant_ref'=>$reference_id,
                    'status'=>"paid"
                  );                  
                  if (isset($_GET['renew'])){
                    $package_id = isset($_GET['package_id'])?$_GET['package_id']:'';
                    if($package_id>0){
                       $membership_info=$this->functions->upgradeMembership($data['merchant_id'],$package_id);
                       
                       $params_logs['membership_expired']=$membership_info['membership_expired'];
                       $params_logs['package_id']=$package_id;
                       $params_logs['price']=$membership_info['package_price']+$card_fee;
                       
                       $params_update=array(
                     'package_id'=>$package_id,
                     'package_price'=>$membership_info['package_price']+$card_fee,
                     'membership_expired'=>$membership_info['membership_expired'],          
                     'status'=>'active'
                   );            
                   $this->functions->updateData("mt_merchant",$params_update,'merchant_id',$data['merchant_id']);                  
                    }
                  }
                                    
                  $this->functions->insertData("mt_package_trans",$params_logs);
                  
                  $this->functions->updateData("mt_merchant",
                array(
                 'payment_steps'=>3,
                 'membership_purchase_date'=>$this->functions->dateNow()
                ),'merchant_id',$data['merchant_id']);
                
                if (isset($_GET['renew'])){
                  $url_rn=Config::$baseUrl."/renewsuccesful";
                  header("Location: " . $url_rn);
                    exit(); 
                } else {

                  $this->functions->sendWelcomeEmailMerchant($data);
                            $this->functions->sendMerchantActivation($data, $data['activation_key']);
                            
                              

                        $url_rn=Config::$baseUrl."/merchantsignup?do=step4&token=".$reference_id;
                  header("Location: " . $url_rn);
                    

                }
                
              } catch (Exception $e) {
              

              $error = $this->functions->translation("default","Caught exception: ".$e->getMessage());

            }                 
             } else $this->functions->translation("default","invalid payment credentials");         
          } else $error = "Invalid reference id";
          break;
          
        case "sms":


        if($data = $this->functions->getSMSTransLog($reference_id)){
            $merchant_id = $data['merchant_id'];
            if ($merchant_info = $this->functions->getMerchantInfo($merchant_id)){
              $payment_gateway_ref = $merchant_info['payment_gateway_ref'];
              if($credentials = $this->functions->getAdminCredentials_stp()){
                
                try {
                //  $resp = StripeWrapper::retrievePaymentIntent($credentials['secret_key'],$payment_gateway_ref);
                  
                  $payment_code = 'stp';
                  $amount_to_pay = $data['package_price'];
                  
                  $params=array(
                    'merchant_id'=>$merchant_id,
                    'sms_package_id'=>$data['sms_package_id'],
                    'payment_type'=>$payment_code,
                    'package_price'=>$amount_to_pay,
                    'sms_limit'=>isset($data['sms_limit'])?$data['sms_limit']:'',
                    'date_created'=>$this->functions->dateNow(),
                    'ip_address'=>$_SERVER['REMOTE_ADDR'],
                    'payment_gateway_response'=>json_encode($_GET),             
                    'payment_reference'=>$payment_gateway_ref,
                    'status'=>'paid',
                    'merchant_ref'=>$reference_id
                   );     


                  

                   $last_insert_id = $this->functions->insertData('mt_sms_package_trans', $params);
                   $id =$last_insert_id;
                  $redirec_link=Config::$baseUrl."/merchant/smsReceipt?id=".$id;
                  header("Location: " . $redirec_link);
                  exit();



                  
                } catch (Exception $e) {

                  

                  $error = $this->functions->translation("default","Caught exception: ".$e->getMessage());

                }                 
                
              } else $this->functions->translation("default","invalid payment credentials");                
            } else $error = $this->functions->translation("default","merchant information not found");
          } else $error = $this->functions->translation("default","Invalid reference id");



          
          break;
      
        default:

          

          $error = $this->functions->translation("default","invalid transaction type: ".$trans_type);

          break;
      }     
    } else $error = $this->functions->translation("default","Sorry but we cannot find what your are looking for.");
    
    if(!empty($error)){
          $error.='<p style="margin-top:20px;"><a href="'.$back_url.'" />'.$this->functions->translation("default","Go back").'</a></p>';


          

      $data = [
          'message'=>$error
                ];



              $this->view('store/error', $data, 'layouts/store_tpl');



        }
  } 









    public function poliinit()  
  {

    $order_id=$_GET['id'];


    $order=$this->functions->getOrder($_GET['id']);



    if($data['status']=='paid'){

        $redirec_link=Config::$baseUrl."/";
         header("Location: " . $redirec_link);
       exit();
      }

    $data=array();
  $this->view('store/poli-init', $data, 'layouts/store_tpl');

  
  } 



  public function polisuccess() 
      { 
          
        $error='';  $data=$_POST;         
              $transaction_id=$_GET['token']; 
                
                
      if(is_null($token)) { 
      $token = $_GET["token"];  
    } 
      
      
     if(isset($token) && !empty($token)){ 
      
      
      
      
        if ( $data1=$this->functions->getOrder($_GET['id'])){ 
          
        } 
        
        
        $merchant_type=$this->functions->getMerchantMembershipType($data1['merchant_id']);  
        
        if($merchant_type=='1'){  

          $paymode=$this->functions->getOption('merchant_poli_mode',$data1['merchant_id']);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$data1['merchant_id']); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$data1['merchant_id']);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$data1['merchant_id']); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$data1['merchant_id']);
           $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }
        }else{  
           $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          
          }

     


        } 
        
    $auths=$mer_code.':'.$authkey;  
      
     $auth = base64_encode($auths); 
     $header = array(); 
     $header[] = 'Authorization: Basic '.$auth; 
      
     $ch = curl_init($api_url); 
     //See the cURL documentation for more information: http://curl.haxx.se/docs/sslcerts.html  
     //We recommend using this bundle: https://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt  
     //curl_setopt( $ch, CURLOPT_CAINFO, "ca-bundle.crt");  
     //curl_setopt( $ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);  
     curl_setopt( $ch, CURLOPT_HTTPHEADER, $header);  
     curl_setopt( $ch, CURLOPT_HEADER, 0);  
     curl_setopt( $ch, CURLOPT_POST, 0);  
     curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 0);  
     curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);  
     $response = curl_exec( $ch );  
     curl_close ($ch);  
      
     $json = json_decode($response, true);  
      
     //print_r($json);  
      
    $transaction_id= $json['TransactionRefNo']; 
                
                  
                
                
          $order_id=isset($_GET['id'])?$_GET['id']:'';  
              
              $params_logs=array( 
                    'order_id'=>$order_id,  
                    'payment_type'=>"poli", 
                    'payment_reference'=>$transaction_id, 
                    'raw_response'=>'', 
                    'date_created'=>$this->functions->dateNow(),  
                    'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                  );                          
                    
                     

                     $this->functions->insertData('mt_payment_order', $params_logs);


                     $get_id_orders = $this->functions->checkalreadyorder($data1['merchant_id']);  
                     if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                    $params_update=array( 
                      'status'=>'paid', 
                      'date_modified'=>$this->functions->dateNow(), 
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'order_number'=>$order_number 
                    );    

                    
                    $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);
                    $merchant_id=$data1['merchant_id'];
                      
                    if($_SESSION['guest_chkout']==0){
          $this->PointsProgram->saveEarnPoints(
                                       isset($_SESSION['pts_earn'])?$_SESSION['pts_earn']:'',
                                       $this->functions->getClientId(),
                                       $merchant_id,
                                       $order_id,
                                       "poli",
                                       "paid",
                                       $order_id
                                    );
         }

         //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code

                    

                                         
                     $redirect_url = Config::$baseUrl ."/receipt?id=".$order_id."&chk=".$_GET['chk'];

                     echo "<script>
                          if (window.top !== window.self) {
                              window.top.location = '" . $redirect_url . "';
                          } else {
                              window.location.href = '" . $redirect_url . "';
                          }
                         </script>";


                         //header("Location: " . $redirect_url);
                         exit();

            
     }  
        $data='';
        $this->view('store/poli-success', $data, 'layouts/store_tpl');  
            
          } 


  public function policancel()  
      { 


            
        

          
        if(is_null($token)) { 
      $token = $_GET["token"];  
    } 
      
      
      
      if ( $data1=$this->functions->getOrder($_GET['id'])){ 
          
        } 
        
        $merchant_type=$this->functions->getMerchantMembershipType($data1['merchant_id']);  
        
        if($merchant_type=='1'){

          $paymode=$this->functions->getOption('merchant_poli_mode',$data1['merchant_id']);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$data1['merchant_id']); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$data1['merchant_id']);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$data1['merchant_id']); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$data1['merchant_id']);
            $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }

      
        }else{  
          $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          } 
        } 
        
    $auths=$mer_code.':'.$authkey;  
      
     $auth = base64_encode($auths); 
     $header = array(); 
     $header[] = 'Authorization: Basic '.$auth; 
      
     $ch = curl_init($api_url); 
     //See the cURL documentation for more information: http://curl.haxx.se/docs/sslcerts.html  
     //We recommend using this bundle: https://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt  
     //curl_setopt( $ch, CURLOPT_CAINFO, "ca-bundle.crt");  
     //curl_setopt( $ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);  
     curl_setopt( $ch, CURLOPT_HTTPHEADER, $header);  
     curl_setopt( $ch, CURLOPT_HEADER, 0);  
     curl_setopt( $ch, CURLOPT_POST, 0);  
     curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 0);  
     curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);  
     $response = curl_exec( $ch );  
     curl_close ($ch);  
      
     $json = json_decode($response, true);  
      
      
        if($_GET['chk']=='1'){  
           

           $redirect_url = Config::$baseUrl ."/mobpolicancelfinal";
          //header("Location: " . $redirect_url);

          echo "<script>
                if (window.top !== window.self) {
                    window.top.location = '" . $redirect_url . "';
                } else {
                    window.location.href = '" . $redirect_url . "';
                }
               </script>";

          exit();

        }   
      
        $data="";


        //$this->view('store/poli-cancel', $data, 'layouts/store_tpl'); 

        $redirect_url = Config::$baseUrl ."/custom_poli_cancel";

         echo "<script>
            if (window.top !== window.self) {
                window.top.location = '" . $redirect_url . "';
            } else {
                window.location.href = '" . $redirect_url . "';
            }
        </script>";

          //header("Location: " . $redirect_url);
          exit();
      }

      public function custom_poli_cancel(){

        /*$data="";

        $this->view('store/poli-cancel', $data, 'layouts/store_tpl'); */

        

      if ($this->functions->isClientLogin()){
        $payment_option_url = $this->functions->websiteUrl() . "/paymentoption";
      }else{
        $payment_option_url = $this->functions->websiteUrl() . "/checkout";
      }


         //$payment_option_url = $payment_option_url;
         header("Location: " . $payment_option_url);
         exit();


      }



      public function mobpolicancelfinal()  
  { 
      

    $data="";

    $this->view('store/poli-nudge', $data, 'layouts/store_tpl');
      
  } 



   public function sendRequest_windcave($url, $method = 'POST', $data = [],$merchant_id) {

        
        $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);  
        if($merchant_type=='1'){
          $paymode=$this->functions->getOption('windcave_mode',$merchant_id);
          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOption('wind_user_id_sandbox', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key_sandbox', $merchant_id);

          }else{
          $apiUsername = $this->functions->getOption('wind_user_id', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key', $merchant_id);
          }


        }else{
          $paymode=$this->functions->getOptionAdmin('windcave_mode');

          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id_sandbox');
          $apiKey = $this->functions->getOptionAdmin('wind_key_sandbox');
          }else{
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id');
          $apiKey = $this->functions->getOptionAdmin('wind_key');
          }
        }



	 if($paymode=='Sandbox'){
		 $url = "https://uat.windcave.com/api/v1/sessions";		 
	 }else{
			$url = "https://sec.windcave.com/api/v1/sessions";
	 }



	

        
        

        $auth = base64_encode("{$apiUsername}:{$apiKey}");
        
        $headers = [
            "Authorization: Basic $auth",
            "Content-Type: application/json",
        ];
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        
        $response = curl_exec($ch);




        curl_close($ch);
        
        return json_decode($response, true);
    }


  public function windcaveinit(){

    

      $merchant_id = $this->functions->getMerchantID();
      $order_id=$_GET['id'];



      $order_token=$_GET['order_id_token'];
      $data = $this->functions->getOrderInfoByToken($order_token);

     

      

      $returnUrl = Config::$baseUrl . "/windcave_success?id=".$order_id;  // The URL for success page
      $notificationUrl = Config::$baseUrl . "/windcave_notification";

      if ($this->functions->isClientLogin()){
        $cancel_url = $this->functions->websiteUrl() . "/paymentoption";
      }else{
        $cancel_url = $this->functions->websiteUrl() . "/checkout";
      }

      


      $currency = $this->functions->getCurrencyCode();
      $apiEndpoint = "https://sec.windcave.com/api/v1/sessions";
      $error = '';

      if ($data = $this->functions->getOrderInfoByToken($order_token)) {

        $merchant_id=$data['merchant_id'];
         
         $price=$data['total_w_tax'];

         $credentials = $this->functions->getCredentials_windcave($merchant_id);
          if ($credentials['card_fee'] >= 0.0001) {
         
          $card_fee = $price*$credentials['card_fee']/100;
          $price=$price;
          }



         $price = number_format((float)$price, 2, '.', '');
         $merchantReference="Order#".$order_id;
         

      $cancelUrl=$cancel_url;

        $data = [
    "type" =>"purchase",
    "amount" =>$price, // This would be dynamic in your case, such as $price
    "currency" =>$currency, // You might want to replace this with your dynamic currency code, such as $currency
    "merchantReference" => $merchantReference, // Replace this with a dynamic reference if needed
    "callbackUrls" => [
        "approved" => $returnUrl, // Replace with your actual success URL
        "declined" => $cancelUrl,   // Replace with your actual failure URL
        "cancelled" => $cancelUrl // Replace with your actual cancel URL
    ],
    "notificationUrl" => $notificationUrl // Replace with your actual notification URL
];


        $sessionResponse = $this->sendRequest_windcave($apiEndpoint, 'POST', $data,$merchant_id);
       
       
       


         if (isset($sessionResponse['links'][1]['href'])) {
            // Redirect to the card entry view (second step)
           $formUrl = $sessionResponse['links'][1]['href'];
            $payment_id = $sessionResponse['id'];
            //$order_id=$data['order_id'];

            //echo $order_id;
            //echo "was".$payment_id;die();

            $this->functions->update_payment_id($order_id,$payment_id);



          header("Location: $formUrl");
    exit();
            /*$data_for_view = [
                    'sessionResponse' => $sessionResponse
                ];


            $this->view('merchant/windcave_buy', $data_for_view, 'layouts/merchant_tpl');*/

        } else {
            // Handle errors if session creation fails

           //$error = "Error: " . $sessionResponse['message'];
           $error =$sessionResponse['errors'][0]['message'];
        }



      }else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
      }



      if (!empty($error)) {

        

         $data = [
            'message' => $this->functions->translation('default', "Payment failed due to ".$error)
            ];
         

         $this->view('store/error', $data, 'layouts/store_tpl');


    }




      }





      

       public function windcave_success() {
        // Logic for processing success response
        // e.g., check status, display success page, etc.
        $transactionId = $_GET['sessionId'] ?? null; // Get the transaction ID from the URL
        $status = $_GET['status'] ?? null; // Get the payment status
        
        
        
         $order_id=isset($_GET['id'])?$_GET['id']:''; 

         $stmt = $this->db->prepare("SELECT * FROM mt_order WHERE order_id = :order_id");
        $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $stmt->execute();

         $result = $stmt->fetch(PDO::FETCH_ASSOC);

         $merchant_id=$result['merchant_id'];

         $params_logs=array( 
                    'order_id'=>$order_id,  
                    'payment_type'=>"windcave", 
                    'payment_reference'=>$transactionId, 
                    'raw_response'=>'', 
                    'date_created'=>$this->functions->dateNow(),  
                    'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                  );                          
                    
                     

         $this->functions->insertData('mt_payment_order', $params_logs);

         $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                                    if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}



         $params_update=array( 
                      'status'=>'paid', 
                      'date_modified'=>$this->functions->dateNow(), 
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'order_number'=>$order_number, 
                    );  


                    
         $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);


          if($_SESSION['guest_chkout']==0){
          $this->PointsProgram->saveEarnPoints(
                                       isset($_SESSION['pts_earn'])?$_SESSION['pts_earn']:'',
                                       $this->functions->getClientId(),
                                       $merchant_id,
                                       $order_id,
                                       "windcave",
                                       "paid",
                                       $order_id
                                    );
        }

            // Payment successful
           
            

       //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code
                                      

            
                                 
                     

                     
                      
                    $redirec_link=Config::$baseUrl."/receipt?id=".$order_id;

                    $_SESSION['payment_process']=1;

                    header("Location: " . $redirec_link);
                    exit();




        
    }



      public function windcave_notification() {
    // Windcave will POST the response data to this URL (e.g., transaction status)
    $response = file_get_contents("php://input");  // Get raw POST data

    // Parse the response (assuming JSON format)
    $responseData = json_decode($response, true);

    // Check if the response indicates a successful transaction
    if ($responseData['status'] == 'APPROVED') {
        // Process the success (e.g., update your database, mark the order as paid)
        // Example: Update database to mark the payment as successful
        $transactionId = $responseData['transactionId'];
        // Your database code here to mark the transaction as successful
        // Example: $this->db->query("UPDATE orders SET status = 'paid' WHERE transaction_id = '$transactionId'");

        // Optionally, send a success response back to Windcave
        echo json_encode(["status" => "success"]);
    } else {
        // Handle the failure (e.g., log the error, send notification to admin)
        // Example: Log failure
        $errorMessage = $responseData['errorMessage'] ?? "Unknown error";
        // Log the error for future reference
        error_log("Payment failure: " . $errorMessage);

        echo json_encode(["status" => "failed", "message" => $errorMessage]);
    }
}







    public function SearchArea()
  {

    //ScriptManager::includeMappLibrary();
    
    $res = '';
    
    unset($_SESSION['confirm_order_data']);
    unset($_SESSION['kr_delivery_options']);
    
    
    /*$seo_title=Yii::app()->functions->getOptionAdmin('seo_search');
    $seo_meta=Yii::app()->functions->getOptionAdmin('seo_search_meta');
    $seo_key=Yii::app()->functions->getOptionAdmin('seo_search_keywords');
    
    if (!empty($seo_title)){
      $seo_title=smarty('website_title',getWebsiteName(),$seo_title);
        $this->pageTitle=$seo_title;
        Yii::app()->functions->setSEO($seo_title,$seo_meta,$seo_key);
    }*/
    
    if(isset($_GET)){
      $_GET = ($_GET);    
    }
    
    $_SESSION['search_type']='';
    if (isset($_GET['s'])){
      $_SESSION['kr_search_address']=$_GET['s'];
      $_SESSION['search_type']='kr_search_address';
      $this->functions->setCookie('kr_search_address',$_GET['s']);
    }
    
    if (isset($_GET['foodname'])){
      $_SESSION['kr_search_foodname']=$_GET['foodname'];
      $_SESSION['search_type']='kr_search_foodname';
    }
    
    if (isset($_GET['category'])){
      $_SESSION['kr_search_category']=$_GET['category'];
      $_SESSION['search_type']='kr_search_category';
    }
    
    if (isset($_GET['restaurant-name'])){
      $_SESSION['kr_search_restaurantname']=$_GET['restaurant-name'];
      $_SESSION['search_type']='kr_search_restaurantname';
    }
    
    if (isset($_GET['street-name'])){
      $_SESSION['kr_search_streetname']=$_GET['street-name'];
      $_SESSION['search_type']='kr_search_streetname';
    }
    
    if (isset($_GET['zipcode'])){
      $_SESSION['search_type']='kr_postcode';
      $_SESSION['kr_postcode']=isset($_GET['zipcode'])?$_GET['zipcode']:'';
    }
    
    if(isset($_GET['location'])){
      $_SESSION['search_type']='kr_search_location';
    }
    
    unset($_SESSION['kr_item']);
    unset($_SESSION['kr_merchant_id']);
    
    $filter_cuisine=isset($_GET['filter_cuisine'])?explode(",",$_GET['filter_cuisine']):false;
    $filter_delivery_type=isset($_GET['filter_delivery_type'])?$_GET['filter_delivery_type']:'';    
    $filter_minimum=isset($_GET['filter_minimum'])?$_GET['filter_minimum']:'';
    $sort_filter=isset($_GET['sort_filter'])?$_GET['sort_filter']:'';   
    $display_type=isset($_GET['display_type'])?$_GET['display_type']:'';
    $restaurant_name=isset($_GET['restaurant_name'])?$_GET['restaurant_name']:'';
            
    $current_page_get=$_GET;
    unset($current_page_get['page']);       
    

    $current_page_link=Config::$baseUrl."/searcharea/".$current_page_get;
    $current_page_url='';
        
    
    /*update merchant if expired and sponsored*/
    $this->functions->updateMerchantSponsored();
    $this->functions->updateMerchantExpired();


    
    /*  switch between search type */           
    switch ($_SESSION['search_type']) {
      case "kr_search_address":
        if (isset($_GET['s'])){

          $res=$this->functions->searchByAddress(
            isset($_GET['s'])?$_GET['s']:'' ,
            isset($_GET['page'])?$_GET['page']:0,
            $this->functions->getPerPage(),
            $_GET       
          );
        }   
            

        $current_page_url = Config::$baseUrl . "/searcharea?s=" . (isset($_GET['s']) ? $_GET['s'] : '');
                
        break;
            
      case "kr_search_restaurantname":        
         $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           isset($_GET['st'])?$_GET['st']:'',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         ); 

        

        $current_page_url = Config::$baseUrl . "/searcharea?st=" . 
                    (isset($_GET['st']) ? urlencode($_GET['st']) : '') . 
                    "&restaurant-name=" . 
                    (isset($_GET['restaurant-name']) ? urlencode($_GET['restaurant-name']) : '');


         break;
         
      case "kr_search_streetname":   
            $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           isset($_GET['st'])?$_GET['st']:'',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         );     

        

         $current_page_url = Config::$baseUrl . "/searcharea?st=" . 
                    (isset($_GET['st']) ? urlencode($_GET['st']) : '') . 
                    "&street-name=" . 
                    (isset($_GET['street-name']) ? urlencode($_GET['street-name']) : '');

               
           break;
           
      case "kr_search_category":    
            
         if ( $cat_res=$this->functions->GetCuisineByName( isset($_GET['category'])?$_GET['category']:'' )){
          $cuisine_id=$cat_res['cuisine_id'];
         } else $cuisine_id="-1";
         $filter_cuisine[]=$cuisine_id;        
         
         if (!isset($_GET['filter_cuisine'])){
          $_GET['filter_cuisine']='';
         }
         
         $_GET['filter_cuisine']=$_GET['filter_cuisine'].",$cuisine_id";
                
           $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           isset($_GET['st'])?$_GET['st']:'',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         );     

         

         $current_page_url = Config::$baseUrl . "/searcharea?st=" . 
                    (isset($_GET['st']) ? urlencode($_GET['st']) : '') . 
                    "&category=" . 
                    (isset($_GET['category']) ? urlencode($_GET['category']) : '');



           break;
        
      case "kr_search_foodname":
        
        $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           isset($_GET['st'])?$_GET['st']:'',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         );

        

          $current_page_url = Config::$baseUrl . "/searcharea?st=" . 
                    (isset($_GET['st']) ? urlencode($_GET['st']) : '') . 
                    "&foodname=" . 
                    (isset($_GET['foodname']) ? urlencode($_GET['foodname']) : '');

           break;
        
      case "kr_postcode":              
          $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           isset($_GET['st'])?$_GET['st']:'',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         );     
        

         $current_page_url = Config::$baseUrl . "/searcharea?zipcode=" . (isset($_GET['zipcode']) ? $_GET['zipcode'] : '');

          break;
          
      case "kr_search_location":    
          $res=$this->functions->searchByMerchant(
           $_SESSION['search_type'],
           '',
           isset($_GET['page'])?$_GET['page']:0,
           $this->functions->getPerPage(),
           $_GET        
         ); 

        

         $current_page_url = Config::$baseUrl . "/searcharea?location=1";

      break;
          
      default:
        break;
    }
                    
    if (empty($display_type)){
      if ( !empty($_SESSION['krms_display_type']) ){        
        $display_type=$_SESSION['krms_display_type'];
      } else {    
        $display_type=$this->functions->getOptionAdmin('theme_list_style');
        if (empty($display_type)){
            $display_type='gridview'; 
        }
      }
    }
    
    $_SESSION['krms_display_type']=$display_type; 
                
    if (is_array($res) && count($res)>=1){      
            
      $_SESSION['client_location']=$res['client'];            
      $this->functions->setCookie('client_location', json_encode($res['client']) );
      
      $exchange_rate = $this->functions->getRates();
      
      
      $_SESSION['kmrs_search_stmt']=$res['sql'];

  $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }



           
       $data = [
        'map_api'=>$map_api,
              'map_type'=>$map_type,
              'data'=>$res,
        'exchange_rate'=>$exchange_rate,
        'filter_delivery_type'=>$filter_delivery_type,
        'filter_cuisine'=>$filter_cuisine,
        'filter_minimum'=>$filter_minimum,
        'sort_filter'=>$sort_filter,
        'display_type'=>$display_type,
        'restaurant_name'=>$restaurant_name,
        'current_page_link'=>$current_page_link,
        'current_page_url'=>$current_page_url,
        'fc'=>$this->functions->getOptionAdmin('theme_filter_colapse'),
        'enabled_search_map'=>$this->functions->getOptionAdmin('enabled_search_map'),
        'search_by_location'=>$this->functions->isSearchByLocation()

            ];
        $this->view('store/search-results', $data, 'layouts/store_tpl');







    } else {
      $has_filter=false;
      if (isset($_GET['filter_minimum'])){$has_filter=true;}    
      if (isset($_GET['filter_delivery_type'])){$has_filter=true;}    
      if (isset($_GET['filter_cuisine'])){$has_filter=true;}
      if ($has_filter){

            $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

        
                

                $data = [

                  'map_api'=>$map_api,
                   'map_type'=>$map_type,

                  'data'=>$res,
          'filter_delivery_type'=>$filter_delivery_type,
          'filter_cuisine'=>$filter_cuisine,
          'filter_minimum'=>$filter_minimum,
          'sort_filter'=>$sort_filter,
          'display_type'=>$display_type,
          'restaurant_name'=>$restaurant_name,
          'current_page_url'=>isset($current_page_url)?$current_page_url:'',
          'fc'=>$this->functions->getOptionAdmin('theme_filter_colapse'),
          'enabled_search_map'=>$this->functions->getOptionAdmin('enabled_search_map'),
          'search_by_location'=>$this->functions->isSearchByLocation()

            ];
            $this->view('store/search-results', $data, 'layouts/store_tpl');




      } else{


             

             $data = [
                  'data'=>""
            ];
            $this->view('store/search-results-nodata', $data, 'layouts/store_tpl');



      }               
    } 
  }

public function mustlogin(){

  


  unset($_SESSION['confirm_order_data']);
    
    /*POINTS PROGRAM*/
    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
       PointsProgram::includeFrontEndFiles(); 
    } */   
    
    
    
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
    
    
        
    $search_by_location = $this->functions->isSearchByLocation();  
    
    $enabled_map_selection_delivery = $this->functions->getOptionAdmin('enabled_map_selection_delivery');
    
    $s=$_SESSION;
    $transaction_type = $s['kr_delivery_options']['delivery_type'];   
    
    /*$cs = Yii::app()->getClientScript();      
    $cs->registerScript(
      'enabled_map_selection_delivery',
     "var enabled_map_selection_delivery='$enabled_map_selection_delivery';",
      CClientScript::POS_HEAD
    );    
    $cs->registerScript(
      'transaction_type',
     "var transaction_type='$transaction_type';",
      CClientScript::POS_HEAD
    );*/
        
    
    if($transaction_type=="delivery"){      
        $temporary_address = isset($_SESSION['kr_search_address'])?$_SESSION['kr_search_address']:$this->functions->getOptionAdmin('admin_country_set');      
        if(empty($temporary_address)){
          $temporary_address= $this->functions->adminCountry();
        }   
              
        $lat = ''; $lng ='';
        if($res= $this->functions->geodecodeAddress($temporary_address)){
          $lat = $res['lat'];
          $lng = $res['long'];
        }     
        /*$cs = Yii::app()->getClientScript();
        $cs->registerScript(
          'temporary_address_lat',
         "var temporary_address_lat='$lat';",
          CClientScript::POS_HEAD
        );
        $cs->registerScript(
          'temporary_address_lng',
         "var temporary_address_lng='$lng';",
          CClientScript::POS_HEAD
        );  */    
    }
    
    $exchange_rate =  $this->functions->getRates();  
    
   $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

    $captchaEnabled=$this->functions->getOptionAdmin('captcha_customer_signup'); 
    $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 


    $data = [
      'captchaEnabled'=>$captchaEnabled,
      'captcha_site_key'=>$captcha_site_key,

      'transaction_type'=>$transaction_type,
      'lat'=>$lat,
      'lng'=>$lng,
      'map_api'=>$map_api,
      'map_type'=>$map_type,
      'exchange_rate'=>$exchange_rate,
         'is_guest_checkout'=>true,
         'website_enabled_map_address'=>$this->functions->getOptionAdmin('website_enabled_map_address'),
         'address_book'=>$this->functions->showAddressBook(),
         'step'=>4,
         'guestcheckout'=>true,
         'search_by_location'=>$search_by_location,
         'enabled_map_selection_delivery'=>$enabled_map_selection_delivery,
         'has_addressbook'=>false

            ];


        $this->view('store/must-login', $data, 'layouts/store_tpl');


}

  





    public function checkout(){

      $baseUrl=Config::$baseUrl;

     if(!isset($_SESSION['kr_item'])){
      

      $store_url = $baseUrl . "/";
      header("Location: " . $store_url);
      exit();

    }

    
    
    if ( $this->functions->isClientLogin()){             
         

          $store_url = $baseUrl . "/paymentoption";
          header("Location: " . $store_url);
          exit();

         
        }else{
      
    $guest_chkout_disable_setting=$this->functions->getOptionAdmin('website_disabled_guest_checkout');
    if($guest_chkout_disable_setting=='yes'){
      $login_url = $baseUrl . "/mustlogin";
          header("Location: " . $login_url);
          exit();
    }

   
    unset($_SESSION['confirm_order_data']);
    
    /*POINTS PROGRAM*/
    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
       PointsProgram::includeFrontEndFiles(); 
    } */   
    
    
    
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
    
    
        
    $search_by_location = $this->functions->isSearchByLocation();  
    
    $enabled_map_selection_delivery = $this->functions->getOptionAdmin('enabled_map_selection_delivery');
    
    $s=$_SESSION;
    $transaction_type = $s['kr_delivery_options']['delivery_type'];   
    
    /*$cs = Yii::app()->getClientScript();      
    $cs->registerScript(
      'enabled_map_selection_delivery',
     "var enabled_map_selection_delivery='$enabled_map_selection_delivery';",
      CClientScript::POS_HEAD
    );    
    $cs->registerScript(
      'transaction_type',
     "var transaction_type='$transaction_type';",
      CClientScript::POS_HEAD
    );*/
        
    
    if($transaction_type=="delivery"){      
        $temporary_address = isset($_SESSION['kr_search_address'])?$_SESSION['kr_search_address']:$this->functions->getOptionAdmin('admin_country_set');      
        if(empty($temporary_address)){
          $temporary_address= $this->functions->adminCountry();
        }   
              
        $lat = ''; $lng ='';
        if($res= $this->functions->geodecodeAddress($temporary_address)){
          $lat = $res['lat'];
          $lng = $res['long'];
        }     
        /*$cs = Yii::app()->getClientScript();
        $cs->registerScript(
          'temporary_address_lat',
         "var temporary_address_lat='$lat';",
          CClientScript::POS_HEAD
        );
        $cs->registerScript(
          'temporary_address_lng',
         "var temporary_address_lng='$lng';",
          CClientScript::POS_HEAD
        );  */    
    }
    
    $exchange_rate =  $this->functions->getRates();  
    
   $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }
    
    $captchaEnabled=$this->functions->getOptionAdmin('captcha_customer_signup'); 
    $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 

    $data = [

      'captchaEnabled'=>$captchaEnabled,
      'captcha_site_key'=>$captcha_site_key,

      'transaction_type'=>$transaction_type,
      'lat'=>$lat,
      'lng'=>$lng,
      'map_api'=>$map_api,
      'map_type'=>$map_type,
      'exchange_rate'=>$exchange_rate,
         'is_guest_checkout'=>true,
         'website_enabled_map_address'=>$this->functions->getOptionAdmin('website_enabled_map_address'),
         'address_book'=>$this->functions->showAddressBook(),
         'step'=>4,
         'guestcheckout'=>true,
         'search_by_location'=>$search_by_location,
         'enabled_map_selection_delivery'=>$enabled_map_selection_delivery,
         'has_addressbook'=>false

            ];


        $this->view('store/payment-option', $data, 'layouts/store_tpl');


    }
        
     

    }



    public function add_review()
  {
    $order_info = array();
    $order_token = isset($_GET['order_token'])?$_GET['order_token']:'';



    if(!empty($order_token)){
      $order_info = $this->functions->getOrderInfoByTokenWithCustomerName($order_token);
    } 


   
    
    if(is_array($order_info) && count($order_info)>=1){

      

      $data = [
      'order_info'=>$order_info
      ];


      $this->view('store/add_review', $data, 'layouts/store_tpl');

    } else {    
       

       $msg="Sorry but we cannot find what you are looking for";

        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');

    }

  }





    public function PaymentOption()
  { 
    
    //ScriptManager::includeMappLibrary();
    

    
    unset($_SESSION['confirm_order_data']);
    
    
    
      
    
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
    
   
    
    $client_id = $this->functions->getClientId();
    $search_by_location = $this->functions->isSearchByLocation();        
    
    $has_addressbook=false;
    
    if($search_by_location){
      if ($this->functions->hasAddressBook($client_id)){
            $has_addressbook=true;
          }
    }
    
        
    $s=$_SESSION;
    $transaction_type = isset($s['kr_delivery_options']['delivery_type'])?$s['kr_delivery_options']['delivery_type']:'';    
    $enabled_map_selection_delivery = $this->functions->getOptionAdmin('enabled_map_selection_delivery');
    
    /*$cs = Yii::app()->getClientScript();      
    $cs->registerScript(
      'enabled_map_selection_delivery',
     "var enabled_map_selection_delivery='".CJavaScript::quote($enabled_map_selection_delivery)."';",
      CClientScript::POS_HEAD
    );    
    $cs->registerScript(
      'transaction_type',
     "var transaction_type='$transaction_type';",
      CClientScript::POS_HEAD
    );*/
    
    if($transaction_type=="delivery"){      
      $temporary_address = isset($_SESSION['kr_search_address'])?$_SESSION['kr_search_address']:$this->functions->getOptionAdmin('admin_country_set');      
      if(empty($temporary_address)){
        $temporary_address=$this->functions->adminCountry();
      }   
          

      $lat = ''; $lng ='';
      if($res=$this->functions->geodecodeAddress($temporary_address)){
        $lat = $res['lat'];
        $lng = $res['long'];
      }     
            
      /*$cs = Yii::app()->getClientScript();
      $cs->registerScript(
        'temporary_address_lat',
       "var temporary_address_lat='$lat';",
        CClientScript::POS_HEAD
      );
      $cs->registerScript(
        'temporary_address_lng',
       "var temporary_address_lng='$lng';",
        CClientScript::POS_HEAD
      ); */     
    }
    
    $exchange_rate = $this->functions->getRates();  

    $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }
        
    $address_list=$this->functions->getAddressBookByClient($this->functions->getClientId());
    if(is_array($address_list) && count($address_list)>=1){
      $new_address = array(); $json_address = array();
              foreach ($address_list as $address_list_val) {
                $new_address[ $address_list_val['id'] ] = $address_list_val['address'];
                $json_address[ $address_list_val['id'] ] = array(
                  'lat'=>$address_list_val['latitude'],
                  'lng'=>$address_list_val['longitude'],
                );
              } 
    }else{
      $address_list="";
      $json_address='';
    }
   
   
    $captchaEnabled=$this->functions->getOptionAdmin('captcha_order'); 
    $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 

        

   

    $data = [
      'json_address'=>$json_address,
    'captchaEnabled'=>$captchaEnabled,
      'captcha_site_key'=>$captcha_site_key,
      'map_api'=>$map_api,
      'map_type'=>$map_type,
      'transaction_type'=>$transaction_type,
      'lat'=>$lat,
      'lng'=>$lng,
      'exchange_rate'=>$exchange_rate,
      'address_book'=>$this->functions->showAddressBook(),
      'search_by_location'=>$search_by_location,  
      'client_id'=>$client_id,
      'has_addressbook'=>$has_addressbook,
      'enabled_map_selection_delivery'=>$enabled_map_selection_delivery

            ];




        $this->view('store/payment-option', $data, 'layouts/store_tpl');



  }


  public function Cuisine($params=[])
  {
    
    //ScriptManager::includeMappLibrary(true);

    $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
   

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }



    
     
     $url=isset($_SERVER['REQUEST_URI'])?explode("/",$_SERVER['REQUEST_URI']):false;
    
    

    
     $slug=$url['2'];


    
    

  

if(isset($slug)){
  $_GET['slug']=$slug;
}

    $baseUrl=Config::$baseUrl;
    $search_by_location = $this->functions->isSearchByLocation();
        
    $slug=isset($_GET['slug'])?$_GET['slug']:'';  
    
    $cuisine_id=0;
    if($resp = $this->functions->getCuisineBySlug($slug)){      
      $cuisine_id = $resp['cuisine_id'];      
    } 


          
    if($search_by_location){
      if(isset($_GET['city_id']) || isset($_GET['postal_code']) ){
        $data = $_GET;
        $this->functions->setCookie('kr_location_search',json_encode($data)); 
        

         $url = $baseUrl . "/cuisine?category=".$cuisine_id;
            header("Location: " . $url);
            exit();

      }
            
      if (!$location_data = $this->functions->getSearchByLocationData()){

        //ScriptManager::includeTypeHead();

                
        

        $data = [
          'form_action'=>$baseUrl . "/cuisine?category=".$cuisine_id,
         'search_type'=>$this->functions->getOptionAdmin('admin_zipcode_searchtype')

                ];


               $this->view('store/enter_location', $data, 'layouts/store_tpl');




        exit();
      }   
    } else {


      
      if(isset($_GET['s'])){
       
        if(!isset($_SESSION['kr_search_address']) || !isset($_SESSION['client_location']['lat']) ){     
          $_SESSION['kr_search_address'] = ($_GET['s']);
          try {
            $resp = $this->functions->geodecodeAddress($_SESSION['kr_search_address']);         
            $_SESSION['client_location']['lat'] = $resp['lat'];
            $_SESSION['client_location']['long'] = $resp['long'];
          } catch (Exception $e) {          
          }       
        }
      }
    
      if(!isset($_SESSION['kr_search_address']) || !isset($_SESSION['client_location']['lat']) ){   
          
        $provider = $this->functions->getMapProvider();

        

        //echo $provider['provider'];die();
        $data = [
          
          'map_api'=>$map_api,
                    'map_type'=>$map_type,
          'map_provider_loc'=>$provider,
           'provider'=>isset($provider['provider'])?$provider['provider']:'',
          'map_provider'=>$provider['provider'],
        'form_action'=>$baseUrl . "/cuisine/slug/".$slug  

                ];
                
                
               $this->view('store/enter_address', $data, 'layouts/store_tpl');



        exit();
      }
    } 
    
    /*update merchant if expired and sponsored*/
    $this->functions->updateMerchantSponsored();
    $this->functions->updateMerchantExpired();            
     
     if (!isset($_GET['filter_cuisine'])){
      $_GET['filter_cuisine']='';
     }

     
    $_GET['filter_cuisine']=$_GET['filter_cuisine']."$cuisine_id";  
        
       
       $test_data = [
      'kr_search_category',
       isset($_GET['st'])?$_GET['st']:'',
       isset($_GET['page'])?$_GET['page']:0,
       $this->functions->getPerPage(),
        

                ];
           //print_r($test_data);die();
      
       
      $res=$this->functions->searchByMerchant(
       'kr_search_category',
       isset($_GET['st'])?$_GET['st']:'',
       isset($_GET['page'])?$_GET['page']:0,
       $this->functions->getPerPage(),
       $_GET        
    );

      
      
     
      
    

    if(empty($slug)){
      $res = false;
      
    } 
    

    

    $data = [
      'map_api'=>$map_api,
            'map_type'=>$map_type,
         'list'=>$res,
      'category'=>isset($category)?$category:'',
       'search_by_location'=>$search_by_location  

                ];

         
                
         
               $this->view('store/merchant-list-cuisine', $data, 'layouts/store_tpl');



  }



  public function Page($params=[])
  {

     $page_slug=$params['slug'];
     

if(isset($page_slug)){
  $_GET['slug']=$page_slug;
}


    $page_slug = isset($_GET['slug'])?trim($_GET['slug']):'';
    

    if(empty($page_slug)){
      $url=isset($_SERVER['REQUEST_URI'])?explode("/",$_SERVER['REQUEST_URI']):false;
      if(is_array($url) && count($url)>=1){
        $page_slug=$url[count($url)-1];
        $page_slug=str_replace('page-','',$page_slug);
        if(isset($_GET)){       
          $c=strpos($page_slug,'?');
          if(is_numeric($c)){
            $page_slug=substr($page_slug,0,$c);
          }
        }       
      }
    } 
        
    if ($data=$this->functions->getCustomPageBySlug($page_slug)){
      
      
          $lang = 'en';
          
          $page_name_trans['page_name_trans'] =  isset($data['page_name_trans'])? json_decode($data['page_name_trans'],true) : '';            
          $page_name = $this->functions->qTranslate($data['page_name'],'page_name',(array)$page_name_trans);            
          
          $content_trans['content_trans'] = isset($data['content_trans']) ? json_decode($data['content_trans'],true) : '';            
          $content = $this->functions->qTranslate($data['content'],'content',(array)$content_trans);            
          
          $seo_title_trans['seo_title_trans'] = isset($data['seo_title_trans']) ?  json_decode($data['seo_title_trans'],true) :'';            
          $seo_title = $this->functions->qTranslate($data['seo_title'],'seo_title',(array)$seo_title_trans);            
          
          $meta_description_trans['meta_description_trans'] = isset($data['meta_description_trans']) ?  json_decode($data['meta_description_trans'],true) :'';        
          $meta_description = $this->functions->qTranslate($data['meta_description'],'meta_description',(array)$meta_description_trans);            
          
          $meta_keywords_trans['meta_keywords_trans'] = isset($data['meta_keywords_trans']) ? json_decode($data['meta_keywords_trans'],true) :'';
          $meta_keywords = $this->functions->qTranslate($data['meta_keywords'],'meta_keywords',(array)$meta_keywords_trans);            
          
            /*SET SEO META*/
      /*if (!empty($data['seo_title'])){
           $this->pageTitle=$seo_title;
           Yii::app()->clientScript->registerMetaTag($seo_title, 'title'); 
      }
      if (!empty($data['meta_description'])){   
           Yii::app()->clientScript->registerMetaTag($meta_description, 'description'); 
      }
      if (!empty($data['meta_keywords'])){   
           Yii::app()->clientScript->registerMetaTag($meta_keywords, 'keywords'); 
      }*/
                  
          

          $data = [
        'page_name'=>$page_name,
          'content'=>$content,
            ];


        $this->view('store/custom-page', $data, 'layouts/store_tpl');



    } else{

      

      $data = [
             'header'=>true,
             'msg'=>"Sorry but we cannot find what you are looking for"
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');
      

    } 
  }



  public function GuestCheckout()
  {
    //ScriptManager::includeMappLibrary();

   
    unset($_SESSION['confirm_order_data']);
    
    /*POINTS PROGRAM*/
    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
       PointsProgram::includeFrontEndFiles(); 
    } */   
    
    
    
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
    
    
        
    $search_by_location = $this->functions->isSearchByLocation();  
    
    $enabled_map_selection_delivery = $this->functions->getOptionAdmin('enabled_map_selection_delivery');
    
    $s=$_SESSION;
    $transaction_type = $s['kr_delivery_options']['delivery_type'];   
    
    /*$cs = Yii::app()->getClientScript();      
    $cs->registerScript(
      'enabled_map_selection_delivery',
     "var enabled_map_selection_delivery='$enabled_map_selection_delivery';",
      CClientScript::POS_HEAD
    );    
    $cs->registerScript(
      'transaction_type',
     "var transaction_type='$transaction_type';",
      CClientScript::POS_HEAD
    );*/
        
    
    if($transaction_type=="delivery"){      
        $temporary_address = isset($_SESSION['kr_search_address'])?$_SESSION['kr_search_address']:$this->functions->getOptionAdmin('admin_country_set');      
        if(empty($temporary_address)){
          $temporary_address= $this->functions->adminCountry();
        }   
              
        $lat = ''; $lng ='';
        if($res= $this->functions->geodecodeAddress($temporary_address)){
          $lat = $res['lat'];
          $lng = $res['long'];
        }     
        /*$cs = Yii::app()->getClientScript();
        $cs->registerScript(
          'temporary_address_lat',
         "var temporary_address_lat='$lat';",
          CClientScript::POS_HEAD
        );
        $cs->registerScript(
          'temporary_address_lng',
         "var temporary_address_lng='$lng';",
          CClientScript::POS_HEAD
        );  */    
    }
    
    $exchange_rate =  $this->functions->getRates();  
    
   $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }


    $data = [
      'transaction_type'=>$transaction_type,
      'lat'=>$lat,
      'lng'=>$lng,
      'map_api'=>$map_api,
      'map_type'=>$map_type,
      'exchange_rate'=>$exchange_rate,
         'is_guest_checkout'=>true,
         'website_enabled_map_address'=>$this->functions->getOptionAdmin('website_enabled_map_address'),
         'address_book'=>$this->functions->showAddressBook(),
         'step'=>4,
         'guestcheckout'=>true,
         'search_by_location'=>$search_by_location,
         'enabled_map_selection_delivery'=>$enabled_map_selection_delivery,
         'has_addressbook'=>false

            ];


        $this->view('store/payment-option', $data, 'layouts/store_tpl');




  }


    public function Item()
  {
    $data=$this->functions->getItemById($_GET['item_id']);
    $merchant_id = $data[0]['merchant_id'];
    
    /*inventory*/
       /* if($inv_enabled = FunctionsV3::inventoryEnabled($merchant_id)){
            Yii::app()->getClientScript()->registerCssFile(Yii::app()->baseUrl."/protected/modules/inventory/assets/css/front.css");                
            Yii::app()->getClientScript()->registerScriptFile(Yii::app()->baseUrl."/protected/modules/inventory/assets/js/inventory.js"
            ,CClientScript::POS_END);                
            InventoryWrapper::registerScript(array(
              "var inv_ajax='".CJavaScript::quote(Yii::app()->request->baseUrl."/inventory/Ajaxfront")."';",
              "var inv_loader='".CJavaScript::quote( t("loading") )."...';",
            ),'inventory_script');
        } */
    
    

    $data = [
       'title'=>"test title",
       'data'=>$data,
       'this_data'=>isset($_GET)?$_GET:'',
       'inv_enabled'=>false

            ];


        $this->view('store/item', $data, 'layouts/mobile_tpl');

  }





    public function Profile()
  {
    
    if ($this->functions->isClientLogin()){  
      $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

      
     $ordersdata=$this->functions->clientHistyOrder( $this->functions->getClientId() );
     

       $data = [
        'map_api'=>$map_api,
      'map_type'=>$map_type,
          'tabs'=>isset($_GET['tab'])?$_GET['tab']:'',
         'disabled_cc'=>$this->functions->getOptionAdmin('disabled_cc_management'),
         'info'=>$this->functions->getClientInfo( $this->functions->getClientId()),
         'avatar'=>$this->functions->getAvatar( $this->functions->getClientId() ),
         'booking_disabled'=>$this->functions->getOptionAdmin('merchant_tbl_book_disabled')

            ];
        $this->view('store/profile', $data, 'layouts/store_tpl');


    } else {
       $baseUrl = Config::$baseUrl;
       $store_url = $baseUrl . "/signup";
       header("Location: " . $store_url);
       exit();
       
    } 
  }


  public function MyPoints()
  {   
    /*POINTS PROGRAM*/
    //PointsProgram::includeFrontEndFiles();

    $points_enabled=$this->functions->getOptionAdmin('points_enabled');
      
    if ( $points_enabled==1){
      if ( $this->functions->isClientLogin()){     
        $points=$this->PointsProgram->getTotalEarnPoints(
           $this->functions->getClientId()
        );      
        
        $points_expirint=$this->PointsProgram->getExpiringPoints(
           $this->functions->getClientId()
        );
        
       

        $ref_data = [
        'earn_points'=>$points,
         'points_expirint'=>$points_expirint
            ];
        $this->view('store/pts-mypoints', $ref_data, 'layouts/store_tpl');



      } else{

       

         $msg="Sorry but you need to login first.";

        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');


      } 


    } else {



     

      $msg="Sorry but we cannot find what you are looking for.";

        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl'); 





    }
  }







    public function Contact()
  {
    
    
    
    $act_menu=$this->functions->getTopMenuActivated();
    if (!in_array('contact',(array)$act_menu)){
      

      $data = [
             'header'=>true
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');
      return ;
    } 
    
    
    $address=$this->functions->getOptionAdmin('website_address'); 
    
      
    


     $data = [
            'address' => $address,
            'website_title'=>$this->functions->getOptionAdmin('website_title'),
      'contact_phone'=>$this->functions->getOptionAdmin('website_contact_phone'),
      'contact_email'=>$this->functions->getOptionAdmin('website_contact_email'),
      'contact_content'=>$this->functions->getOptionAdmin('contact_content'),
      'country'=>$this->functions->CountryList()  

            ];
        $this->view('store/contact', $data, 'layouts/store_tpl');

  }


  public function Signup()
  {
    
    $baseUrl = Config::$baseUrl;

    $captcha_site_key = $this->functions->getOptionAdmin('captcha_site_key');
    
        
    if ($this->functions->isClientLogin()) {
    $store_url = $baseUrl . "/";
    header("Location: " . $store_url);
    exit();
}
    
    $act_menu=$this->functions->getTopMenuActivated();
    if (!in_array('signup',(array)$act_menu)){
      

      $data = [
             'header'=>true
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');


      return ;
    } 
    
    $fb=1;
    $fb_app_id=$this->functions->getOptionAdmin('fb_app_id');
    $fb_flag=$this->functions->getOptionAdmin('fb_flag');
    
    if ( $fb_flag=="" && $fb_app_id<>""){
      $fb=2;
    }
    

    $data = [
            'terms_customer' => $this->functions->getOptionAdmin('website_terms_customer'),
            'terms_customer_url'=>$this->functions->prettyLink($this->functions->getOptionAdmin('website_terms_customer_url')),
       'fb_flag'=>$fb,
       'google_login_enabled'=>$this->functions->getOptionAdmin('google_login_enabled'),
       'captcha_customer_login'=>$this->functions->getOptionAdmin('captcha_customer_login'),
       'captcha_customer_signup'=>$this->functions->getOptionAdmin('captcha_customer_login'),
       'customer_forgot_password_sms'=>$this->functions->getOptionAdmin('customer_forgot_password_sms'),
       'captcha_site_key'=> $captcha_site_key

            ];
        $this->view('store/signup', $data, 'layouts/store_tpl');





  }






  public function Receipt($params=[])
  {  

    

    if(isset($_GET['id'])){
      if(!empty($_GET['id'])){

      }
    }else{
      $_GET['id']=$params['id'];
    }


     $order_id = isset($_GET['id'])?(integer)$_GET['id']:0;


    $data=$this->functions->getReceiptByID($order_id,0);
    $data1=$this->functions->getClientInfo($data['client_id']);
     
         if($data1['is_guest']==1){
       
       
       
       
       $viewed=$data['viewed'];
        $order_id=$data['order_id'];
       
       

       
       if($viewed==1){
         
         
         $params_update=array('viewed'=>2);             
                        
                      $this->functions->updateData("mt_order",$params_update,'order_id',$order_id); 
         
         
          //$_SESSION['order_id_checkout']=0;
         
    
       
       
           $data = [
            'data'=>$data

            ];
        $this->view('store/receipt', $data, 'layouts/store_tpl');
       
       
       
       
       }else{
         
          $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');
         
       }
       
       
       
     }else{
       
       
       
       
       
       
       
         
    if ($this->functions->isClientLogin()){

     $order_id = isset($_GET['id'])?(integer)$_GET['id']:0;
      $client_id = (integer) $this->functions->getClientId();

      if ($data=$this->functions->getReceiptByID($order_id,$client_id)){


     
         
        $data = [
            'data'=>$data

            ];
        $this->view('store/receipt', $data, 'layouts/store_tpl');


      } else{
        $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');
        }

    } else{
        $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');
        } 
       
       
       
       
       
       
       
       
       
       
       
       
       
     }   
       
       
       
       
       
       
       
       
       

      

     
      
  
  }



public function Receipts($params=[])
  {  

    

    if(isset($_GET['id'])){
      if(!empty($_GET['id'])){

      }
    }else{
      $_GET['id']=$params['id'];
    }

      

     
      
    
    if ($this->functions->isClientLogin() || 1==1){

      $order_id = isset($_GET['id'])?(integer)$_GET['id']:0;
      $client_id = (integer) $this->functions->getClientId();

      if ($data=$this->functions->getReceiptByID($order_id,$client_id)){

       
       
        $data = [
            'data'=>$data

            ];
        $this->view('store/receipt', $data, 'layouts/store_tpl');


      } else{
        $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');
        }

    } else{
        $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
        $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');
        } 
  }



  public function EmailVerification()
  {
    $baseUrl = Config::$baseUrl;
   if ( $this->functions->isClientLogin()){
      $store_url = $baseUrl . "/";
    header("Location: " . $store_url);
    exit();
    }
    
    $continue=true; $msg='';
    
    if(!isset($_GET['id'])){
      $_GET['id']='';
    }
    if( $res=$this->functions->getClientInfo($_GET['id'])){  
      if ( $res['status']=="active"){
        $continue=false;
        $msg=$this->functions->translation("default","Your account is already verified");
      }
    } else {
      $continue=false;
      $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
    }
    
    if ($continue){
       

       $data = [
            'data'=>$res

            ];
        $this->view('store/email-verification', $data, 'layouts/store_tpl');

    } else{
      $data = [
            'message'=>$msg

            ];
        $this->view('store/error', $data, 'layouts/store_tpl');

    } 
  }



  public function Verification()
  {
    $continue=true;
    $msg='';
    $id=$this->functions->getClientId();





    if (!empty($id)){
      $continue=false;
      $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
    }
    if ( $continue==true){
      if( $res=$this->functions->getClientInfo($_GET['id'])){                
        if ( $res['status']=="active"){
          $continue=false;
          $msg=$this->functions->translation("default","Your account is already verified");
        }
      } else {
        $continue=false;
        $msg=$this->functions->translation("default","Sorry but we cannot find what you are looking for.");
      }
    }   
    
    if ( $continue==true){

       

        $data = [
            'data'=>''

            ];
        $this->view('store/mobile-verification', $data, 'layouts/store_tpl');



    } else{
           
           
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/store_tpl');
          }
  }


 


public function GoogleLogin($params=[])
{
    require_once __DIR__ . '/../../vendor/autoload.php';
    session_start();

    if (isset($_GET['error'])) {
        header("Location: /store");
        exit;
    }

    $incoming_code=$params[0]['code'];
     
     
  

if(isset($incoming_code)){
  $_GET['code']=$incoming_code;
}

  $google_client_id=$this->functions->getOptionAdmin('google_client_id');
  $google_client_secret=$this->functions->getOptionAdmin('google_client_secret');
  $google_client_redirect_url=$this->functions->getOptionAdmin('google_client_redirect_url');

  if (empty($google_client_redirect_url)){
  $google_client_redirect_url=Config::$baseUrl."/GoogleLogin";
}

  


    $client = new Google_Client();
    $client->setClientId($google_client_id);
    $client->setClientSecret($google_client_secret);
    $client->setRedirectUri($google_client_redirect_url);
    $client->addScope("email");
    $client->addScope("profile");

    $plus = new Google_Service_Oauth2($client);

    try {
        // Handle logout
        if (isset($_REQUEST['logout'])) {
            unset($_SESSION['auth_token']);
            $client->revokeToken();
            header("Location: /store");
            exit;
        }



        // Step 1: Handle callback (GET code)
        if (isset($_GET['code'])) {
            error_log("Received code: " . $_GET['code']);
            $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);

           

            error_log("Fetched token: " . json_encode($token));

            if (!isset($token['error'])) {
                $_SESSION['auth_token'] = $token;
                $client->setAccessToken($token);
                error_log("Access token saved in session.");
            } else {
                throw new Exception("Google auth error: " . $token['error_description']);
            }
        }

       

        // Step 2: Use token from session if available
        if (isset($_SESSION['auth_token']['access_token'])) {
            $client->setAccessToken($_SESSION['auth_token']);
            error_log("Token restored from session: " . $_SESSION['auth_token']['access_token']);

            // Check expiration
            if ($client->isAccessTokenExpired()) {
                error_log("Token expired. Redirecting to auth URL...");
                unset($_SESSION['auth_token']);
                $authUrl = $client->createAuthUrl();
                header("Location: $authUrl");
                exit;
            }
        } else {
            // No token, send to Google
            error_log("No access token found. Sending to Google login.");
            $authUrl = $client->createAuthUrl();
            header("Location: $authUrl");
            exit;
        }

        // Step 3: Fetch Google user info
        if ($client->getAccessToken()) {
            $t = $plus->userinfo->get();
            $t = is_object($t) ? (array) $t : $t;
            error_log("Google user info: " . json_encode($t));



            if (is_array($t) && count($t) >= 1) {
                if ($resp_t = $this->functions->googleRegister($t)) {
                    error_log("Registered user: " . json_encode($resp_t));

                    if (isset($resp_t['verification_type'])) {
                        $redirect_url = isset($_SESSION['google_http_refferer']) ?
                            "/store/emailverification?id={$resp_t['client_id']}&checkout=true" :
                            "/store/emailverification?id={$resp_t['client_id']}";
                        header("Location: $redirect_url");
                        exit;
                    } else {
                        $this->functions->clientAutoLogin(
                            $t['email'],
                            $resp_t['password'],
                            $resp_t['password']
                        );
                        unset($_SESSION['auth_token']);
                        $client->revokeToken();

                        $redirectUrl = $_SESSION['google_http_refferer'] ?? $this->functions->websiteUrl();
                        error_log("Redirecting to final URL: $redirectUrl");
                        header("Location: " . $redirectUrl);
                        exit;
                    }
                } else {
                    error_log("ERROR: googleRegister failed.");
                    echo "ERROR: Something went wrong during registration.";
                }
            } else {
                error_log("ERROR: Invalid user info from Google.");
                echo "ERROR: Unable to get user info.";
            }
        }
    } catch (Exception $e) {
        $_SESSION['auth_token'] = null;
        error_log("Exception: " . $e->getMessage());
        echo "Exception: " . $e->getMessage();
    }
}















  public function forgotPassword()
  {
    if ($res=$this->functions->getLostPassToken($_GET['token']) ){
      

       $data = [
            'data'=>""

            ];
        $this->view('store/forgot-pass', $data, 'layouts/store_tpl');

    } else{
           
           $msg="ERROR: Invalid token.";
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/store_tpl');
          }
  }



public function Logout()
{
    unset($_SESSION['kr_client']);
    $http_referer = $_SERVER['HTTP_REFERER'] ?? '';

    $redirect_urls = [
        "/receipt",
        "/orderHistory",
        "/Profile",
        "/Cards",
        "/PaymentOption",
        "/verification"
    ];

    foreach ($redirect_urls as $url) {
        if (preg_match("~$url~i", $http_referer)) {
            $http_referer = $this->functions->websiteUrl() . "/";
            break;
        }
    }

    if (!empty($http_referer)) {
        header("Location: " . $http_referer);
    } else {
        header("Location: " . Config::$baseUrl . "/");
    }
}


public function Cart()
  {
    
    
$merchant_id=$_SESSION['kr_merchant_id'];

     
    
    
    unset($_SESSION['kr_receipt']);
    unset($_SESSION['confirm_order_data']);
        
    
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
          
    
        
    $res=$this->functions->getMerchantInfo_idwise($merchant_id);
    
    
     
    
    if (is_array($res) && count($res)>=1){
      if ( $current_merchant !=$res['merchant_id']){               
         unset($_SESSION['kr_item']);
      }   
            
      if ( $res['status']=="active" && $res['is_ready']==2){
        
        
        unset($_SESSION['guest_client_id']);
        
        $merchant_id=$res['merchant_id'];       
        
        /*SET TIME*/
        $mt_timezone=$this->functions->getOption("merchant_timezone",$merchant_id);        
          if (!empty($mt_timezone)){          
            
            date_default_timezone_set($mt_timezone);
          }         
                    
          $distance_type='';
          $distance='';
          $merchant_delivery_distance = isset($res['delivery_distance_covered'])?(float)$res['delivery_distance_covered']:0;
          $delivery_fee=0;          
          $unit_pretty='';
          $min_fees=0;
          $distance_pretty='';
          $ratings = array(
                'ratings'=>isset($res['ratings'])?(float)$res['ratings']:0,
                'votes'=>isset($res['ratings_votes'])?(integer)$res['ratings_votes']:0,
               );
               $distance_error = '';
                              
          /*double check if session has value else use cookie*/         
          $this->functions->cookieLocation();
          
          
          /*GET SEARCH LOCATION DATA*/  
          $location_data=$this->functions->getSearchByLocationData();
          $search_by_location=false;
          if ($this->functions->isSearchByLocation()){
            
            $default_min_fees = isset($res['delivery_minimum_order'])?(float)$res['delivery_minimum_order']:0;
            
            $search_by_location=TRUE;
              $delivery_fee_resp=$this->functions->getLocationDeliveryFeeWithMinimum(
                $merchant_id,
                $res['delivery_charges'],
                $default_min_fees,
                $location_data
              );    
                            
              $delivery_fee = isset($delivery_fee_resp['fee'])?$delivery_fee_resp['fee']:0;
              $min_fees = isset($delivery_fee_resp['minimum_order'])?$delivery_fee_resp['minimum_order']:0;
              
          } else {
            if (isset($_SESSION['client_location'])){
               try {                                        
                $provider = $this->functions->getMapProvider(); 

                          $this->MapsWrapper->init($provider);  
                    $resp = $this->CheckoutWrapper->getDeliveryDetails(array(
                      'merchant_id'=>$merchant_id,
                      'provider'=>$provider,
                      'merchant_id'=>$merchant_id,
                      'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
                      'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
                      'to_lat'=>$_SESSION['client_location']['lat'],
                      'to_lng'=>$_SESSION['client_location']['long'],
                      'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
                      'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
                      'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:0,
                      'order_subtotal'=>0,
                      'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
                    ));

                   


                    $distance_error = isset($resp['distance_error'])?$resp['distance_error']:'';
                    $unit_pretty = $resp['pretty_unit'];
                    $distance = $resp['distance'];
                    $distance_pretty = $resp['pretty_distance'];
                    $delivery_fee = $resp['delivery_fee'];
                    $min_fees = $resp['min_order'];
                   } catch (Exception $e) {
                    $distance_pretty = $e->getMessage();                    
                    $delivery_fee = 0;
                   }                            
            }   
          }
    
                          
                      
          /*SESSION REF*/
          $_SESSION['kr_merchant_id']=$merchant_id;
                $_SESSION['kr_merchant_slug']=$page_slug;
          $_SESSION['shipping_fee']=$delivery_fee;    
                              
                    
          /*CHECK IF BOOKING IS ENABLED*/
          $booking_enabled=true;            
          if ($this->functions->getOption('merchant_table_booking',$merchant_id)=="yes"){
            $booking_enabled=false;
          }     
          if ( $this->functions->getOptionAdmin('merchant_tbl_book_disabled')){
            $booking_enabled=false;
          }
          
          $exchange_rate = $this->functions->getRates();
          
          /*CHECK IF MERCHANT HAS PROMO*/
          $promo['enabled']=1;          
          if($offer=$this->functions->getOffersByMerchantNew($merchant_id,$exchange_rate)){
             $promo['offer']=$offer;
             $promo['enabled']=2;
          }             
          if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){        
            $promo['voucher']=$voucher;
            $promo['enabled']=2;
          }
          $free_delivery_above_price=$this->functions->getOption('free_delivery_above_price',$merchant_id);
          if ($free_delivery_above_price>0){
              $promo['free_delivery']=$free_delivery_above_price;
            $promo['enabled']=2;
          }
          
          $photo_enabled=$this->functions->getOption('gallery_disabled',$merchant_id)=="yes"?false:true;
          if ( $this->functions->getOptionAdmin('theme_photos_tab')==2){
            $photo_enabled=false;
          }

          $minimum_order_dinein=$this->functions->getOption('merchant_minimum_order_dinein',$merchant_id);
          $maximum_order_dinein=$this->functions->getOption('merchant_maximum_order_dinein',$merchant_id);
          
              
        $tbl_booking=$this->functions->getOption( 'merchant_master_table_boooking',$merchant_id);
        if($tbl_booking==1){
          $booking_enabled=false;
        }
        
        $food_viewing_private=$this->functions->getOption('food_viewing_private',$merchant_id);       

        /*CHECK DISABLED ORDERING FROM ADMIN AND MERCHANT SETTINGS*/      
        $disabled_addcart = $this->functions->getOption('merchant_disabled_ordering',$merchant_id);
        if(empty($disabled_addcart)){
          $merchant_master_disabled_ordering= $this->functions->getOption('merchant_master_disabled_ordering',$merchant_id);
          if($merchant_master_disabled_ordering==1){
            $disabled_addcart="yes";
          }
        }
        
        $website_use_date_picker = $this->functions->getOptionAdmin('website_use_date_picker');
        $enabled_category_sked = $this->functions->getOption('enabled_category_sked',$merchant_id);
        $enabled_category_sked_time = $this->functions->getOption('enabled_category_sked_time',$merchant_id);
        $website_review_type=$this->functions->getOptionAdmin('website_review_type');       
        
        $merchant_opt_contact_delivery = $this->functions->getOption('merchant_opt_contact_delivery',$merchant_id);
        
        $exchange_rate = $this->functions->getRates();
        
        $minimum_order_dinein = (float)$minimum_order_dinein * $exchange_rate;
        $maximum_order_dinein = (float)$maximum_order_dinein * $exchange_rate;
                
        
     
                
               
                           
               
                                                                                      
        




 $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

         $distance_type=$this->functions->getMerchantDistanceType($merchant_id); 
         $distance_type_orig=$distance_type;
         $distance_type_raw = $distance_type=="M"?"miles":"kilometers";                           
         $distance_type=$distance_type=="M"?"miles":"kilometers";
         $distance_type_orig = $distance_type;


  

        $data = [
           'map_api'=>$map_api,
          'map_type'=>$map_type,
           'data'=>$res,
         'merchant_id'=>$merchant_id,
         'distance_type'=>$distance_type,
         'distance_type_orig'=>$distance_type_orig,
         'distance_type_raw'=>$distance_type_raw,
         'distance'=>$distance,
         'merchant_delivery_distance'=>$merchant_delivery_distance,
         'delivery_fee'=>$delivery_fee,
         'website_use_date_picker'=>$website_use_date_picker,
         'merchant_opt_contact_delivery'=>$merchant_opt_contact_delivery

            ];

       
           

        $this->view('store/mobile-cart', $data, 'layouts/mobile_tpl');



                
      }  else{ 

        

        $msg="Sorry but this merchant is no longer available";
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/mobile_tpl');
         }
      
    } else{
      

       $msg="merchant is not available";
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/mobile_tpl');

       }
  }






public function Menu($params=[])
  {  


    $url=isset($_SERVER['REQUEST_URI'])?explode("/",$_SERVER['REQUEST_URI']):false;
    
    

    
     $slug=$url['2'];

$preview=$params['preview'];
$token=$params['token'];
if(isset($preview)){
  $_GET['preview']=$preview;
}
if(isset($token)){
  $_GET['token']=$token;
}



     //ScriptManager::includeMappLibrary(true);
    $enabled_food_search_menu = $this->functions->getOptionAdmin('enabled_food_search_menu');
    if($enabled_food_search_menu==1){
      //ScriptManager::includeTypeHead();
    } 
    
    
    unset($_SESSION['kr_receipt']);
    unset($_SESSION['confirm_order_data']);
        
     $page_slug='';   
    $current_merchant='';
    if (isset($_SESSION['kr_merchant_id'])){
      $current_merchant=$_SESSION['kr_merchant_id'];
    }
          
    $page_slug = isset($slug)?trim($slug):'';
    

    if(empty($page_slug)){
      $url = $_SERVER['REQUEST_URI']; // Example: /store/menu/slug/cheziouss?sname=iphone16+Single+Size

// Extract the part after "slug/"
      $segments = explode("slug/", $url);
      if (isset($segments[1])) {
          $slugValue = explode("?", $segments[1])[0]; // Get value before "?"
          $page_slug= $slugValue; // Output: cheziouss
      }
    }


    if(empty($page_slug)){
      
          
         

         $data = [
             'header'=>true,
             'msg'=>"Sorry but we cannot find what you are looking for"
            ];
        $this->view('store/404-page', $data, 'layouts/store_tpl');

        return ;
           
         
    } 
        
    $res=$this->functions->getMerchantBySlug($page_slug);
    
    
     $_SESSION['google_http_refferer']=$this->functions->websiteUrl()."menu/slug/$page_slug"; 
    
    if (is_array($res) && count($res)>=1){
      if ( $current_merchant !=$res['merchant_id']){               
         unset($_SESSION['kr_item']);
      }   
            
      if ( $res['status']=="active" && $res['is_ready']==2){
        
        
        unset($_SESSION['guest_client_id']);
        
        $merchant_id=$res['merchant_id'];       
        
        /*SET TIME*/
        $mt_timezone=$this->functions->getOption("merchant_timezone",$merchant_id);        
          if (!empty($mt_timezone)){          
            
            date_default_timezone_set($mt_timezone);
          }         
                    
          $distance_type='';
          $distance='';
          $merchant_delivery_distance = isset($res['delivery_distance_covered'])?(float)$res['delivery_distance_covered']:0;
          $delivery_fee=0;          
          $unit_pretty='';
          $min_fees=0;
          $distance_pretty='';
          $ratings = array(
                'ratings'=>isset($res['ratings'])?(float)$res['ratings']:0,
                'votes'=>isset($res['ratings_votes'])?(integer)$res['ratings_votes']:0,
               );
               $distance_error = '';
                              
          /*double check if session has value else use cookie*/         
          $this->functions->cookieLocation();
          
          
          /*GET SEARCH LOCATION DATA*/  
          $location_data=$this->functions->getSearchByLocationData();
          $search_by_location=false;
          if ($this->functions->isSearchByLocation()){
            
            $default_min_fees = isset($res['delivery_minimum_order'])?(float)$res['delivery_minimum_order']:0;
            
            $search_by_location=TRUE;
              $delivery_fee_resp=$this->functions->getLocationDeliveryFeeWithMinimum(
                $merchant_id,
                $res['delivery_charges'],
                $default_min_fees,
                $location_data
              );    
                            
              $delivery_fee = isset($delivery_fee_resp['fee'])?$delivery_fee_resp['fee']:0;
              $min_fees = isset($delivery_fee_resp['minimum_order'])?$delivery_fee_resp['minimum_order']:0;
              
          } else {
            if (isset($_SESSION['client_location'])){
               try {                                        
                $provider = $this->functions->getMapProvider(); 

                          $this->MapsWrapper->init($provider);  
                    $resp = $this->CheckoutWrapper->getDeliveryDetails(array(
                      'merchant_id'=>$merchant_id,
                      'provider'=>$provider,
                      'merchant_id'=>$merchant_id,
                      'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
                      'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
                      'to_lat'=>$_SESSION['client_location']['lat'],
                      'to_lng'=>$_SESSION['client_location']['long'],
                      'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
                      'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
                      'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:0,
                      'order_subtotal'=>0,
                      'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
                    ));                         
                    $distance_error = isset($resp['distance_error'])?$resp['distance_error']:'';
                    $unit_pretty = $resp['pretty_unit'];
                    $distance = $resp['distance'];
                    $distance_pretty = $resp['pretty_distance'];
                    $delivery_fee = $resp['delivery_fee'];
                    $min_fees = $resp['min_order'];
                   } catch (Exception $e) {
                    $distance_pretty = $e->getMessage();                    
                    $delivery_fee = 0;
                   }                            
            }   
          }
    
                          
                      
          /*SESSION REF*/
          $_SESSION['kr_merchant_id']=$merchant_id;
                $_SESSION['kr_merchant_slug']=$page_slug;
          $_SESSION['shipping_fee']=$delivery_fee;    
                              
                    
          /*CHECK IF BOOKING IS ENABLED*/
          $booking_enabled=true;            
          if ($this->functions->getOption('merchant_table_booking',$merchant_id)=="yes"){
            $booking_enabled=false;
          }     
          if ( $this->functions->getOptionAdmin('merchant_tbl_book_disabled')){
            $booking_enabled=false;
          }
          
          $exchange_rate = $this->functions->getRates();
          
          /*CHECK IF MERCHANT HAS PROMO*/
          $promo['enabled']=1;          
          if($offer=$this->functions->getOffersByMerchantNew($merchant_id,$exchange_rate)){
             $promo['offer']=$offer;
             $promo['enabled']=2;
          }             
          if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){        
            $promo['voucher']=$voucher;
            $promo['enabled']=2;
          }
          $free_delivery_above_price=$this->functions->getOption('free_delivery_above_price',$merchant_id);
          if ($free_delivery_above_price>0){
              $promo['free_delivery']=$free_delivery_above_price;
            $promo['enabled']=2;
          }
          
          $photo_enabled=$this->functions->getOption('gallery_disabled',$merchant_id)=="yes"?false:true;
          if ( $this->functions->getOptionAdmin('theme_photos_tab')==2){
            $photo_enabled=false;
          }

          $minimum_order_dinein=$this->functions->getOption('merchant_minimum_order_dinein',$merchant_id);
          $maximum_order_dinein=$this->functions->getOption('merchant_maximum_order_dinein',$merchant_id);
          
              
        $tbl_booking=$this->functions->getOption( 'merchant_master_table_boooking',$merchant_id);
        if($tbl_booking==1){
          $booking_enabled=false;
        }
        
        $food_viewing_private=$this->functions->getOption('food_viewing_private',$merchant_id);       

        /*CHECK DISABLED ORDERING FROM ADMIN AND MERCHANT SETTINGS*/      
        $disabled_addcart = $this->functions->getOption('merchant_disabled_ordering',$merchant_id);
        if(empty($disabled_addcart)){
          $merchant_master_disabled_ordering= $this->functions->getOption('merchant_master_disabled_ordering',$merchant_id);
          if($merchant_master_disabled_ordering==1){
            $disabled_addcart="yes";
          }
        }
        
        $website_use_date_picker = $this->functions->getOptionAdmin('website_use_date_picker');
        $enabled_category_sked = $this->functions->getOption('enabled_category_sked',$merchant_id);
        $enabled_category_sked_time = $this->functions->getOption('enabled_category_sked_time',$merchant_id);
        $website_review_type=$this->functions->getOptionAdmin('website_review_type');       
        
        $merchant_opt_contact_delivery = $this->functions->getOption('merchant_opt_contact_delivery',$merchant_id);
        
        $exchange_rate = $this->functions->getRates();
        
        $minimum_order_dinein = (float)$minimum_order_dinein * $exchange_rate;
        $maximum_order_dinein = (float)$maximum_order_dinein * $exchange_rate;
                
        
       /* FunctionsV3::registerScript(array(
         "var dinein_minimum='$minimum_order_dinein';",
         "var dinein_max='$maximum_order_dinein';",
         "var website_use_date_picker='$website_use_date_picker';",
         "var enabled_category_sked='$enabled_category_sked';",
         "var enabled_category_sked_time='$enabled_category_sked_time';",
         "var website_review_type='$website_review_type';",
         "var search_by_location='$search_by_location';",
         "var distance_error='$distance_error';",
         "var merchant_opt_contact_delivery='$merchant_opt_contact_delivery';",
        ));   */
        
        /*inventory*/
                /*if($inv_enabled = FunctionsV3::inventoryEnabled($merchant_id)){
                    Yii::app()->getClientScript()->registerCssFile(Yii::app()->baseUrl."/protected/modules/inventory/assets/css/front.css");                
                    Yii::app()->getClientScript()->registerScriptFile(Yii::app()->baseUrl."/protected/modules/inventory/assets/js/inventory.js"
                    ,CClientScript::POS_END);                
                    InventoryWrapper::registerScript(array(
                      "var inv_ajax='".CJavaScript::quote(Yii::app()->request->baseUrl."/inventory/Ajaxfront")."';",
                      "var inv_loader='".CJavaScript::quote( t("loading") )."...';",
                    ),'inventory_script');
                } */
                
                $menu_lazyload = $this->functions->getOptionAdmin('admin_menu_lazyload'); $lazy_use_mobile = false;

                $admin_menu_allowed_merchant = $this->functions->getOptionAdmin('admin_menu_allowed_merchant');
                if($admin_menu_allowed_merchant==2){
                  $menu_lazyload = $this->functions->getOption('merchant_menu_lazyload',$merchant_id);
                } 

                
                           
                if($menu_lazyload==1){
                  /*FunctionsV3::registerJS(array(
                   Yii::app()->baseUrl."/assets/vendor/infinite-scroll.pkgd.min.js",
                   Yii::app()->baseUrl."/assets/js/tpl_menu.js"
                  ));*/
                                    
                  /*$detect = new MobileDetect;
                  if ( $detect->isMobile() ){
                    $lazy_use_mobile = true;
                  }    */            
                  
                  /*FunctionsV3::registerScript(array(
            "var menu_lazyload='".CJavaScript::quote($menu_lazyload)."';",
            "var lazy_use_mobile='".CJavaScript::quote($lazy_use_mobile)."';",
          ),'menu_lazyload');*/
  
                }  


                                                                                      
        
$activated_menu = (integer) $this->functions->getOptionAdmin('admin_activated_menu');

$merchant_info_j=array(   
  'merchant_id'=>$merchant_id ,  
  'minimum_order'=> (float) $min_fees * $exchange_rate ,
  'ratings'=>$ratings,
  'merchant_address'=>$res['merchant_address'],
  'cuisine'=>$res['cuisine'],
  'restaurant_name'=>$res['restaurant_name'],
  'background'=>$merchant_photo_bg,
  'merchant_website'=>$merchant_website,
  'merchant_logo'=>$this->functions->getMerchantLogo($merchant_id),
  'contact_phone'=>$res['contact_phone'],
  'restaurant_phone'=>$res['restaurant_phone'],
  'social_facebook_page'=>$social_facebook_page,
  'social_twitter_page'=>$social_twitter_page,
  'social_google_page'=>$social_google_page  
);

 $provider = $this->functions->getMapProvider(); 
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';  
    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');

    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

 


      

      $remove_words = ['distance', 'unit'];
      $pattern = '/\[' . implode('\]|\[', $remove_words) . '\]/';
      $distance_pretty = preg_replace($pattern, '', $distance_pretty);
      $distance_pretty = trim($distance_pretty);
      

        $data = [
           'map_api'=>$map_api,
          'map_type'=>$map_type,

          'provider'=>isset($provider['provider'])?$provider['provider']:'',

           'merchant_info_j'=>$merchant_info_j,
           'minimum_order_dinein'=>$minimum_order_dinein,
           'activated_menu'=>$activated_menu,
           'maximum_order_dinein'=>$maximum_order_dinein,
           'website_use_date_picker'=>$website_use_date_picker,
           'enabled_category_sked'=>$enabled_category_sked,
           'enabled_category_sked_time'=>$enabled_category_sked_time,
           'website_review_type'=>$website_review_type,
           'search_by_location'=>$search_by_location,
           'distance_error'=>$distance_error,
           'merchant_opt_contact_delivery'=>$merchant_opt_contact_delivery,



           'data'=>$res,

           'exchange_rate'=>$exchange_rate,
           'menu_lazyload'=>$menu_lazyload,
           'lazy_use_mobile'=>$lazy_use_mobile,
           'merchant_id'=>$merchant_id,          
           'distance'=>$distance,
           'distance_pretty'=>$distance_pretty,
           'merchant_delivery_distance'=>(float)$merchant_delivery_distance,
           'unit_pretty'=>$unit_pretty,
           'delivery_fee'=>(float)$delivery_fee,
           'min_fees'=>(float)$min_fees,
           'ratings'=>$ratings,
           'disabled_addcart'=>$disabled_addcart,
           'merchant_website'=>$this->functions->getOption('merchant_extenal',$merchant_id),
           'photo_enabled'=>$photo_enabled,
           'booking_enabled'=>$booking_enabled,
           'promo'=>$promo,
           'tc'=>$this->functions->getOptionAdmin('theme_menu_colapse'),
           'theme_promo_tab'=>$this->functions->getOptionAdmin('theme_promo_tab'),
           'theme_hours_tab'=>$this->functions->getOptionAdmin('theme_hours_tab'),
           'theme_reviews_tab'=>$this->functions->getOptionAdmin('theme_reviews_tab'),
           'theme_map_tab'=>$this->functions->getOptionAdmin('theme_map_tab'),
           'theme_info_tab'=>$this->functions->getOptionAdmin('theme_info_tab'),
           'theme_photos_tab'=>$this->functions->getOptionAdmin('theme_photos_tab'),
           'enabled_food_search_menu'=>$enabled_food_search_menu,
           'location_data'=>$location_data,
           'search_by_location'=>$search_by_location,
           'social_facebook_page'=>$this->functions->getOption('facebook_page',$merchant_id),
           'social_twitter_page'=>$this->functions->getOption('twitter_page',$merchant_id),
           'social_google_page'=>$this->functions->getOption('google_page',$merchant_id),
           'minimum_order_dinein'=>$minimum_order_dinein,
           'maximum_order_dinein'=>$maximum_order_dinein,
           'food_viewing_private'=>$food_viewing_private,
           'website_review_type'=>$website_review_type,
           'website_use_date_picker'=>$website_use_date_picker,
           'merchant_opt_contact_delivery'=>$merchant_opt_contact_delivery

            ];

            
        $this->view('store/menu', $data, 'layouts/store_tpl');



                
      }  else{ 

        

        $msg="Sorry but this merchant is no longer available";
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/store_tpl');
         }
      
    } else{
      

       $msg="merchant is not available";
           $data = [
            'message'=>$msg

            ];
          $this->view('store/error', $data, 'layouts/store_tpl');

       }
     
  }









   


  






  


  








  





    
    
   
}
