<?php
class AjaxitemController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		$this->InventoryWrapper = new InventoryWrapper();
        $this->ItemWrap = new ItemWrap();
        $this->StocksWrapper = new StocksWrapper();

        $this->ItemHtmlWrapper = new ItemHtmlWrapper();
		
		$this->merchant_id =$_SESSION['inventory_merchant'];

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}
	
	
	
	
	
public function List()
{
    $feed_data = array();

    $cols = array('item_id', 'photo', 'item_name', 'categories_name', 'price', 'cost_price', 'available_stocks', 'stocks_status');
    
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND a.merchant_id = " . intval($this->merchant_id) . " ";

    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
   /* if (!empty($search_field)) {
        $and .= " AND (a.item_name LIKE :search_field)";
    }*/

    if (!empty($search_field)) {

    // escape input
    $search_keyword = "%" . addslashes($search_field) . "%";

    // now safe for raw SQL
    $and .= " AND (a.item_name LIKE '$search_keyword')";
}


    $cat_ids = '';    
    if (isset($this->data['cat_id'])) {     
        if (is_array($this->data['cat_id']) && count($this->data['cat_id']) >= 1) {
            if (!in_array('all', $this->data['cat_id'])) {
                foreach ($this->data['cat_id'] as $cat_id_val) {
                    $cat_ids .= ($cat_id_val) . ",";
                }
                $cat_ids = substr($cat_ids, 0, -1);
                $and .= " AND a.item_id IN (
                    select item_id from mt_item_relationship_category
                    where cat_id IN ($cat_ids)
                ) ";
            }   
        }
    }

    $stocks_filter = '';    
    if (isset($this->data['items'])) {
        switch ($this->data['items']) {
            case "out_stock":
                $and .= " AND a.item_id IN (
                    select 
                    item_id from mt_view_item_stocks_status
                    where stock_status  = 'Out of stocks'
                    and item_id = a.item_id
                    and track_stock='1'                 
                )";
                break;

            case "low_stock":
                $and .= " AND a.item_id IN (
                    select 
                    item_id from mt_view_item_stocks_status
                    where stock_status  = 'Low stock'
                    and item_id = a.item_id
                    and track_stock='1'
                )";
                break;

            default:
                break;
        }
    }

    // Main SQL query
$stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.*,
    (
        select 
        count(*) from mt_view_item_stocks_status
        where stock_status  = 'Out of stocks'
        and item_id = a.item_id
        and track_stock='1'
    ) as count_out_of_stock,
    (
        select 
        count(*) from mt_view_item_stocks_status
        where stock_status  = 'Low stock'
        and item_id = a.item_id
        and track_stock='1'
    ) as count_low_stock
    FROM mt_view_item_list a
    WHERE 1   
    $and
    $where
    $order
    $limit
";    

// Execute the main query using PDO
$res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);



if ($res) {
    // Get the total number of records
    $stmtc = "SELECT FOUND_ROWS() as total_records";
    $resc = $this->db->query($stmtc)->fetch(PDO::FETCH_ASSOC);    
    $total_records = $resc['total_records'];

    $feed_data['draw'] = $this->data['draw'];
    $feed_data['recordsTotal'] = $total_records;
    $feed_data['recordsFiltered'] = $total_records;

    $datas = array();

    

    foreach ($res as $val) {
        // Calculate available stocks and low stocks
        $available_stocks = (float) $val['available_stocks'];
        $low_stock = (float) $val['low_stock'];

        // Initialize the $cols_data array
        $cols_data = array();
        $cols_data["DT_RowId"] = Config::$baseUrl . "/inventory/item/item_new/id/" . $val['item_id'];
        //$cols_data["DT_RowId"] ="/inventory/item/item_new/id/" . $val['item_id'];
        // Loop through the $cols array
        foreach ($cols as $key_cols => $cols_val) {
            if ($cols_val == "stocks_status") {
                $count_out_of_stock = ''; 
                $count_low_stock = '';
                $low_stock_message = "Low stock";
                $out_stock_message = "Out of stocks";

                // Adjust messages based on with_size value
                if ($val['with_size'] <= 0) {
                    $low_stock_message = "Low stock";
                    $out_stock_message = "Out of stocks";
                }

                // Handle low stock and out of stock counts
                if ($val['count_low_stock'] >= 1) {
                    $count_low_stock = '<span class="text-warning font-weight-bold">' . $low_stock_message . ' ' . $val['count_low_stock'] . '</span>';
                }
                if ($val['count_out_of_stock'] >= 1) {
                    $count_out_of_stock = '<span class="text-warning font-weight-bold">' . $out_stock_message . ' ' . $val['count_out_of_stock'] . '</span>';
                }

                $cols_data[$cols_val] = "$count_out_of_stock $count_low_stock";

                if ($val['with_size'] <= 0) {
                    if ($val['count_out_of_stock'] >= 1) {
                        $cols_data[$cols_val] = '<span class="text-warning font-weight-bold">Out of stock</span>';
                    }
                }


            } else {
                if ($key_cols == 1) {
                    if ($val['with_size'] == 1) {
                        $cols_data[$cols_val] = '<a class="item_show_sizes" data-id="'.$val['item_id'].'" href="javascript:;"><i class="fas fa-chevron-down"></i></a>';
                    } else {
                        $cols_data[$cols_val] = '';
                    }
                } elseif ($key_cols == 4) {
                    if ($val['with_size'] <= 0) {
                        $attributes = 'class="inline_edit" ';

                        

                            $price = $this->functions->normalPrettyPrice($val['price']);
                            
                            $item_id = $val['item_id'];
                            $action = "inline_price";

                            $inline_form = '
                            <div class="floating_inline">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-secondary close_inline"><i class="fa fa-times"></i></button>
                                                    <button type="button" class="btn btn-secondary check_inline" data-action="' . htmlspecialchars($action) . '"><i class="fa fa-check"></i></button>
                                                </div>
                                            </div> <!-- col -->
                                            <div class="col-md-6">
                                                <input type="text" name="inline_value" id="inline_value" value="' . htmlspecialchars($price) . '" class="form-control inline_value numeric_only">
                                                <input type="hidden" name="inline_id" id="inline_id" value="' . htmlspecialchars($item_id) . '" class="form-control inline_id">
                                            </div> <!-- col -->
                                        </div> <!-- row -->
                                    </div> <!-- card-body -->
                                </div> <!-- card -->
                            </div> <!-- floating_inline -->
                            ';



                        $cols_data[$cols_val] = '<span ' . $attributes . '>' . $this->functions->prettyPrice($val[$cols_val]) . $inline_form . '</span>';
                    } else {

                        $cols_data[$cols_val] = $this->functions->prettyPrice(0);
                    }
                } elseif ($key_cols == 5) {
                    $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                } elseif ($key_cols == 6) {
                    if ($val['track_stock'] == 1) {
                        if ($val['with_size'] <= 0) {
                            

                            $price = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                                $item_id = $val['sku'];
                                $action = "inline_stock";

                                $inline_form = '
                                <div class="floating_inline">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="btn-group" role="group">
                                                        <button type="button" class="btn btn-secondary close_inline"><i class="fa fa-times"></i></button>
                                                        <button type="button" class="btn btn-secondary check_inline" data-action="' . htmlspecialchars($action) . '"><i class="fa fa-check"></i></button>
                                                    </div>
                                                </div> <!-- col -->
                                                <div class="col-md-6">
                                                    <input type="text" name="inline_value" id="inline_value" value="' . htmlspecialchars($price) . '" class="form-control inline_value numeric_only">
                                                    <input type="hidden" name="inline_id" id="inline_id" value="' . htmlspecialchars($item_id) . '" class="form-control inline_id">
                                                </div> <!-- col -->
                                            </div> <!-- row -->
                                        </div> <!-- card-body -->
                                    </div> <!-- card -->
                                </div> <!-- floating_inline -->
                                ';

                            $cols_data[$cols_val] = '<span class="inline_edit">' . $this->InventoryWrapper->prettyQuantity($val[$cols_val]) . $inline_form . '</span>';
                        } else {
                            $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                        }
                    } else {
                        $cols_data[$cols_val] = '-';
                    }
                } else {
                    $cols_data[$cols_val] = $val[$cols_val];
                }
            }
        }
        
        $datas[] = $cols_data;
    }

    $feed_data['data'] = $datas;
    $this->otableOutput($feed_data);
} else {
    $this->otableNodata();
}

}


    public function LoadAddonItem()
    {
       $this->code = 1; $this->msg = "";
        $this->jsonResponse();
    }


    public function Get_item()
    {
        $status = true;
        $query = (!empty($this->data['q'])) ? strtolower($this->data['q']) : null;
        $track_stock = !empty($this->data['track_stock']) ? $this->data['track_stock'] : '';
        $data = array();
                    
        if( !$data = $this->ItemWrap->searchItem($this->merchant_id, $query, $track_stock)){
            $status = false;
        }
        
             
                                        
        header('Content-Type: application/json');
        echo json_encode(array(
            "status" => $status,
            "error"  => null,
            "data"   => array(
                "item" => $data,            
            )
        ));

    }



    public function Inline_price()
    {
        $value = isset($this->data['inline_value'])? (float) $this->data['inline_value'] : 0;
        $id = isset($this->data['inline_id']) ? (integer) $this->data['inline_id'] : 0;
        $params1 = array(
          'price'=>json_encode(array("$value")),
          'date_modified'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        $params2 = array(
          'price'=>$value,
          'updated_at'=>$this->functions->dateNow(),       
        );
        
        try {
            
            $this->ItemWrap->inlineUpdatePrice($this->merchant_id,$id,$params1,$params2);
            $this->code = 1; $this->msg = "OK";
            $this->details = array(
             'next_action'=>"refresh_table",
            );
            
        } catch (Exception $e) {
           $this->msg = ($e->getMessage());
        }
        
        $this->jsonResponse();
    }

    public function Inline_stock()
    {
        $in_stock = isset($this->data['inline_value'])? (float) $this->data['inline_value'] : 0;
        //$sku = isset($this->data['inline_id']) ? (integer) $this->data['inline_id'] : 0;
        $sku = isset($this->data['inline_id'])?$this->data['inline_id']:0;
        if ($item =  $this->ItemWrap->getItemBySku($this->merchant_id,$sku)){           
            $this->StocksWrapper->updateStocksEditItem($sku,$item['cost_price'],$in_stock,$this->merchant_id,$_SESSION['username']);
            $this->code = 1; $this->msg = "OK";
            $this->details = array(
             'next_action'=>"refresh_table",
            );
        } else $this->msg = ("Item not found");
        $this->jsonResponse();
    }


    public function Inline_price_by_sku()
    {               
        $value = isset($this->data['inline_value'])? (float) $this->data['inline_value'] : 0;
        $sku = isset($this->data['inline_id']) ? $this->data['inline_id'] : 0;
        
        try {
            
            $this->ItemWrap->inlineUpdatePriceBySku($this->merchant_id, $sku, $value  );
            
             $this->code = 1; $this->msg = "OK";
            $this->details = array(
             'next_action'=>"refresh_table",
            );
            
        } catch (Exception $e) {
           $this->msg = ($e->getMessage());
        }
        
        $this->jsonResponse();
    }






        public function LoadItemSizeList()
    {
        $item_id = isset($this->data['item_id'])? (integer) $this->data['item_id'] : 0;
        if($item_id>0){
            if ( $res = $this->ItemWrap->getItemSizePricesWithStocks($this->merchant_id,$item_id)){
                    
                
                $html='';
                foreach ($res as $val) {
                       $stock_status = '';
                       $available_stocks = $val['available_stocks'];
                       $low_stock = $val['low_stock'];
                       if($val['track_stock']==1){
                           if ($available_stocks <= 0) {
                                $stock_status = '<span class="text-danger font-weight-bold">Out of stock</span>';
                            } else if ($available_stocks <= $low_stock) {
                                $stock_status = '<span class="text-warning font-weight-bold">Low stock</span>';
                            }

                       }                       
                       
                     /* $inline_form = $this->renderPartial(APP_FOLDER.'.views.item.inline_edit',array(
                        'price'=>normalPrettyPrice($val['price']),
                        'item_id'=>$val['sku'],
                        'action'=>"inline_price_by_sku"
                      ),true);

                      $inline_stocks = $this->renderPartial(APP_FOLDER.'.views.item.inline_edit',array(
                        'price'=>InventoryWrapper::prettyQuantity($val['available_stocks']),
                        'item_id'=>$val['sku'],
                        'action'=>"inline_stock"
                      ),true);*/


                      $price=$this->functions->normalPrettyPrice($val['price']);
                      $item_id=$val['sku'];
                      $action="inline_price_by_sku";
                       $inline_form = '
                            <div class="floating_inline">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-secondary close_inline"><i class="fa fa-times"></i></button>
                                                    <button type="button" class="btn btn-secondary check_inline" data-action="' . htmlspecialchars($action) . '"><i class="fa fa-check"></i></button>
                                                </div>
                                            </div> <!-- col -->
                                            <div class="col-md-6">
                                                <input type="text" name="inline_value" id="inline_value" value="' . htmlspecialchars($price) . '" class="form-control inline_value numeric_only">
                                                <input type="hidden" name="inline_id" id="inline_id" value="' . htmlspecialchars($item_id) . '" class="form-control inline_id">
                                            </div> <!-- col -->
                                        </div> <!-- row -->
                                    </div> <!-- card-body -->
                                </div> <!-- card -->
                            </div> <!-- floating_inline -->
                            ';


                     $price=$this->InventoryWrapper->prettyQuantity($val['available_stocks']);
                      $item_id=$val['sku'];
                      $action="inline_stock";

                            $inline_stocks = '
                            <div class="floating_inline">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-secondary close_inline"><i class="fa fa-times"></i></button>
                                                    <button type="button" class="btn btn-secondary check_inline" data-action="' . htmlspecialchars($action) . '"><i class="fa fa-check"></i></button>
                                                </div>
                                            </div> <!-- col -->
                                            <div class="col-md-6">
                                                <input type="text" name="inline_value" id="inline_value" value="' . htmlspecialchars($price) . '" class="form-control inline_value numeric_only">
                                                <input type="hidden" name="inline_id" id="inline_id" value="' . htmlspecialchars($item_id) . '" class="form-control inline_id">
                                            </div> <!-- col -->
                                        </div> <!-- row -->
                                    </div> <!-- card-body -->
                                </div> <!-- card -->
                            </div> <!-- floating_inline -->
                            ';







                       // $inline_form ='';
                       // $inline_stocks ='';
                       $html.='<tr class="tr_item_size_list">';
                        $html.='<td></td>';
                        $html.='<td></td>';
                        $html.='<td>'. $val['size_name'] .'</td>';
                        $html.='<td></td>';
                        $html.='<td><span class="inline_edit">'. $this->functions->prettyPrice($val['price']) . $inline_form .'</span></td>';
                        $html.='<td>'. $this->functions->prettyPrice($val['cost_price']) .'</td>';
                        $html.='<td><span class="inline_edit">'. $this->InventoryWrapper->prettyQuantity($val['available_stocks']) . $inline_stocks .'</span></td>';
                        $html.='<td>'. $stock_status .'</td>';
                       $html.='</tr>';      
                }
                
                $this->OKresponse();
                $this->msg = "Successful";
                $this->details = array(
                  'next_action'=>"load_item_ist",
                  'data'=>$html
                );
                
            } else $this->msg = "No results";
        } else $this->msg = "invalid item id";
        $this->jsonResponse();
    }






public function LoadSizeForm()
    {
        $html=''; $data=array(); $stocks = 0;
        $with_size=  isset($this->data['with_size'])? (integer) $this->data['with_size']:0;
        $row_id =  isset($this->data['row_id'])? (integer) $this->data['row_id']:0; 
        if($with_size>0){
            if($row_id>0){
                $data = $this->ItemWrap->getItemSizePricesWithStocks($this->merchant_id,$row_id);   

                      
                                 
            }

            //+++was custom code for remove of duplicate size
            $temp = [];
            $clean = [];

            foreach ($data as $row) {
                if (!in_array($row['size_name'], $temp)) {
                    $temp[] = $row['size_name'];
                    $clean[] = $row;
                }
            }

            $data = $clean;   // ← overwrite the original variable
            //---was custom code for remove of duplicate size


            
            
            $html=$this->ItemHtmlWrapper->withSizeForm($this->merchant_id,$data);

            $data=array();
        } else {                        
            if($row_id>0){
                $data = $this->ItemWrap->getItemSizePrice($this->merchant_id,$row_id);         
                                  
                $stocks = $this->StocksWrapper->getStocksSKU( isset($data['sku'])?$data['sku']:'' );               
            }           
            $html=$this->ItemHtmlWrapper->noSizeForm($data);
        }       
        $this->OKresponse();
        $this->details = array(
         'next_action'=>isset($this->data['next_action'])?$this->data['next_action']:'load_size_form',
         'row_id'=>$row_id,
         'with_size'=>$with_size,
         'in_stock'=>$stocks,
         'data'=>$data,
         'html'=>$html
        );                          
        $this->jsonResponse();
    }

    
    public function DeleteItemSize()
    {
        $item_token = isset($this->data['item_token'])?$this->data['item_token']:'';
        if(!empty($item_token)){            
            try {
                
                $this->ItemWrap->deleteItemSizeBySku($this->merchant_id,$item_token);
                $this->OKresponse();
                $this->msg = "Record deleted";
                $this->details = array(
                 'next_action'=> 're_load_size_form',
                 'redirect'=>Config::$baseUrl."/inventory/item/list"
                );
                
            } catch (Exception $e) {
               $this->msg = $e->getMessage();
            }
        } else $this->msg = "invalid size id";
        $this->jsonResponse();
    }



        public function Item_new()
    {               
        $with_size =  isset($this->data['with_size'])?(integer)$this->data['with_size']:0;
        $price=array();
        
        if($with_size==1){
            if (isset($this->data['price']) && count($this->data['price'])>=1){
                foreach ($this->data['price'] as $key=>$val) {
                    if (!empty($val)){
                       $price[$this->data['size'][$key]]=$val;
                    }
                }               
            }                   
        } else {
            $price[] = (float)isset($this->data['single_price'])?$this->data['single_price']:0;
        }
        
        $quantity=array();
            if (isset($this->data['quantity']) && count($this->data['quantity'])>=1){
                foreach ($this->data['quantity'] as $key=>$val) {
                    if (!empty($val)){
                       $quantity[$key]=$val;
                      
                    }
                }               
            }
        
        
        $error_set=0;$error_text='';
        if (isset($this->data['row_id']) && is_numeric($this->data['row_id'])){
            if (isset($this->data['barcode']) && !empty($this->data['barcode'])){
            if($barcodedata=$this->functions->checkifbarcodeexistwithitem($this->data['barcode'],$this->merchant_id,$this->data['row_id'])){
                    $error_text=$this->functions->translation("default","Sorry but this barcode is already used!");
                    $error_set=1;
                  
                }                       
            }
            }else{
                if (isset($this->data['barcode']) && !empty($this->data['barcode'])){
                if($barcodedata=$this->functions->checkifbarcodeexist($this->data['barcode'],$this->merchant_id)){
                    $error_text=$this->functions->translation("default","Sorry but this barcode is already used!");
                    $error_set=1;
                   
                }   
                }
            }
        
        
        
        
        
        
        
        
        $params = array(
          'merchant_id'=>(integer)$this->merchant_id,
          'item_name'=>isset($this->data['item_name'])?trim($this->data['item_name']):'',
          'item_description'=>isset($this->data['item_description'])?trim($this->data['item_description']):'',
          'status'=>isset($this->data['status'])?trim($this->data['status']):'',
          'category'=>isset($this->data['category'])?json_encode($this->data['category']):'',
          'price'=>isset($price)?json_encode($price):'',          
          'addon_item'=>isset($this->data['sub_item_id'])?json_encode($this->data['sub_item_id']):"",
          'cooking_ref'=>isset($this->data['cooking_ref'])?json_encode($this->data['cooking_ref']):"",
          'discount'=>!empty($this->data['discount'])?(float)$this->data['discount']:'',
          'multi_option'=>isset($this->data['multi_option'])?json_encode($this->data['multi_option']):"",
          'multi_option_value'=>isset($this->data['multi_option_value'])?json_encode($this->data['multi_option_value']):"",
          'photo'=>isset($this->data['file_name'])?$this->data['file_name']:"",
          'gallery_photo'=>isset($this->data['file_name_multiple'])?json_encode($this->data['file_name_multiple']):'',
          'ingredients'=>isset($this->data['ingredients'])?json_encode($this->data['ingredients']):"",
          'spicydish'=>isset($this->data['spicydish'])?(integer)$this->data['spicydish']:1,
          'two_flavors'=>isset($this->data['two_flavors'])?(integer)$this->data['two_flavors']:'0',
          'two_flavors_position'=>isset($this->data['two_flavors_position'])?json_encode($this->data['two_flavors_position']):"",
          'require_addon'=>isset($this->data['require_addon'])?json_encode($this->data['require_addon']):"",
          'dish'=>isset($this->data['dish'])?json_encode($this->data['dish']):'',
          'non_taxable'=> isset($this->data['non_taxable'])?(integer)$this->data['non_taxable']:1,        
          'packaging_fee'=>isset($this->data['packaging_fee'])?(float)$this->data['packaging_fee']:0,
          'packaging_incremental'=>isset($this->data['packaging_incremental'])?(integer)$this->data['packaging_incremental']:0,
          'sequence'=>isset($this->data['sequence'])?(integer)$this->data['sequence']:0,
          'points_earned'=>isset($this->data['points_earned'])?(integer)$this->data['points_earned']:0,
          'points_disabled'=>isset($this->data['points_disabled'])?(integer)$this->data['points_disabled']:1,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'with_size'=>$with_size,                 
          'item_token'=>$this->functions->generateFoodToken(),
          'not_available'=>isset($this->data['not_available'])?(integer)$this->data['not_available']:1,
          'track_stock'=>isset($this->data['track_stock'])?(integer)$this->data['track_stock']:0,
          'supplier_id'=>isset($this->data['supplier_id'])?(integer)$this->data['supplier_id']:0,
          
          'quantity'=>isset($quantity)?json_encode($quantity):'',
          'barcode'=>isset($this->data['barcode'])?$this->data['barcode']:'',
          'is_variable_price'=>isset($this->data['is_variable_price'])?$this->data['is_variable_price']:1,
        );

        
        
        
        $id = 0;
        $id = isset($this->data['row_id'])?$this->data['row_id']:0;
        
        if($params['sequence']<=0 || !is_numeric($params['sequence'])){
            $params['sequence']=$this->ItemWrap->getMaxSequence('item', $this->merchant_id);
        }
        if (isset($this->data['item_name_trans'])){
            if ($this->functions->okToDecode()){
                $params['item_name_trans']=json_encode($this->data['item_name_trans'],
                JSON_UNESCAPED_UNICODE);
            } else $params['item_name_trans']=json_encode($this->data['item_name_trans']);
        }       
        if (isset($this->data['item_description_trans'])){
            if ($this->functions->okToDecode()){
               $params['item_description_trans']=json_encode($this->data['item_description_trans'],
               JSON_UNESCAPED_UNICODE);
            } else $params['item_description_trans']=json_encode($this->data['item_description_trans']);
        }           
        
        //print_r($params);
            if($error_set==0){
        try {
                        
                       
            
            $this->ItemWrap->insertFood($this->merchant_id,$params,$id,$this->data);           
            $this->OKresponse();
            $this->msg = "Successful";
            $this->details = array(
              'next_action'=>"redirect",
              'redirect'=>Config::$baseUrl."/inventory/item/list"
            );


            
        } catch (Exception $e) {
            $this->msg = ($e->getMessage());
            $this->details = array(
             'error_type'=>'alert',
             'error_title'=>$id>0?"Error editing item":"Error adding item"
            );
        }
        
        }else{
            $this->msg = ($error_text);
            $this->details = array(
             'error_type'=>'alert',
             'error_title'=>$id>0?"Error editing item":"Error adding item"
            );
            
            
        }
        
        
        $this->jsonResponse();
    }


   public function LoadWithSizeForm()
{
    try {
        // Insert into the mt_item_sku table
        $stmt = $this->db->prepare("INSERT INTO mt_item_sku (item_id) VALUES (:item_id)");
        $stmt->bindValue(':item_id', 1, PDO::PARAM_INT);
        $stmt->execute();

        // Generate the HTML
         $last_sku=  isset($this->data['last_sku'])?  $this->data['last_sku']:"";

         

         if ($last_sku === 'NaN') {
            $last_sku = $this->functions->generateAlphanumeric(8);
        } 
        
        
          
        $html = $this->ItemHtmlWrapper->withSizeFormTR($this->merchant_id,$last_sku);


        // Send OK response
        $this->OKresponse();

        // Set the details for JSON response
        $this->details = array(
            'next_action' => 'load_size_form_append',
            'html' => $html
        );

        // Send JSON response
        $this->jsonResponse();
    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
    }
}











	
	
	
}
/*end class*/