<?php
class AjaxstocksController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		$this->InventoryWrapper = new InventoryWrapper();
        $this->ItemWrap = new ItemWrap();
        $this->StocksWrapper = new StocksWrapper();

        $this->ItemHtmlWrapper = new ItemHtmlWrapper();
		
		$this->merchant_id =$_SESSION['inventory_merchant'];

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}


    public function Purchase_new()
    {       
        $params = array(
          'merchant_id'=>$this->merchant_id,
          'purchase_date'=>isset($this->data['purchase_date'])?$this->data['purchase_date']:date("Y-m-d"),
          'supplier_id'=>isset($this->data['supplier_id'])?$this->data['supplier_id']:'',
          'notes'=>isset($this->data['notes'])?$this->data['notes']:'',
          'expected_on'=>isset($this->data['expected_on'])?$this->data['expected_on']:'',
          'created_at'=>$this->functions->dateNow(),
          'updated_at'=>$this->functions->dateNow(),
          'added_by'=> $_SESSION['username'],                 
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );      
        if(empty($params['expected_on'])){
            unset($params['expected_on']);
        }
        
        $row_id =  isset($this->data['row_id'])? (integer) $this->data['row_id']:0;
        print_r($this->data);die();
        $params_details = array();
        if(isset($this->data['sku'])){
            if(is_array($this->data['sku']) && count($this->data['sku'])>=1){
                foreach ($this->data['sku'] as $key=>$sku) {
                    $qty = isset($this->data['qty'][$key])? (float)$this->data['qty'][$key] : 0;
                    $cost_price = isset($this->data['cost'][$key])? (float)$this->data['cost'][$key] : 0;
                    
                    $po_id = (integer)$this->StocksWrapper->autoGenerateID('inventory_purchase_order');
                    if($row_id>0){
                        $po_id=$row_id;
                    }
                    
                    $po_details_id = 0;
                    if(isset($this->data['po_details_id'][$key])){
                       $po_details_id = (integer) $this->data['po_details_id'][$key];
                    }
                                        
                    $p_details = array(                   
                      'po_id'=>$po_id,
                      'sku'=>$sku,
                      'qty'=>$qty,
                      'cost_price'=>$cost_price,
                      'amount'=>$cost_price*$qty
                    );
                    if($po_details_id>0){
                        $p_details['po_details_id']=$po_details_id;     
                        $receive_qty = $this->StocksWrapper->getReceiveSum($po_id,$po_details_id);
                        $p_details['qty']+= $receive_qty;
                    }
                    $params_details[]=$p_details;
                }
            }
        }
                
        try {
                        
            if($row_id>0){
                unset($params['created_at']);
            } else unset($params['updated_at']);
            
            
            
            $this->StocksWrapper->insertPurchase($params,$params_details,$row_id);
            $this->details = array(
              'next_action'=>"redirect",
              'redirect'=>Config::$baseUrl."/inventory/stocks/order_list"
            );

           

            $this->code = 1; $this->msg = "OK";

            $this->msg = "Successful";
            
        } catch (Exception $e) {
           $this->msg = $e->getMessage();
        }
        
        $this->jsonResponse();
    }


    public function Adjustment_new()
    {
        
        $params_item = array(); $params = array();
        
        $transaction_type = isset($this->data['transaction_type'])?trim($this->data['transaction_type']):'';        
        
        if(isset($this->data['sku'])){
            if(is_array($this->data['sku']) && count($this->data['sku'])>=1 ){
                foreach ($this->data['sku'] as $key=>$val) {
                    $params_item[] = array(
                      'transaction_id'=>(integer)$this->StocksWrapper->autoGenerateTransactionID(),
                      'sku'=>$val,
                      'qty'=>(float)$this->data['qty'][$key],                     
                      'cost_price'=>isset($this->data['cost'][$key])?(float)$this->data['cost'][$key]:0,
                      'created_at'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );                  
                }
                
                $params = array(
                  'merchant_id'=>$this->merchant_id,
                  'transaction_type'=>$transaction_type,
                  'transaction_code'=>$this->StocksWrapper->transactionCode('sa'),
                  'notes'=>trim($this->data['notes']),
                  'created_at'=>$this->functions->dateNow(),
                  'added_by'=>$_SESSION['username'],
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                );
                                
                try {

                    
                    
                    $this->StocksWrapper->insertAdjustment($params,$params_item);
                    $this->details = array(
                      'next_action'=>"redirect",
                      'redirect'=>Config::$baseUrl."/inventory/stocks/adjustment_list"
                    );



                    $this->code = 1; $this->msg = "OK";
                    $this->msg = "Successful";
                    
                } catch (Exception $e) {
                   $this->msg = ($e->getMessage());
                }
                
            } else $this->msg = "Invalid item";
        } else $this->msg = "Invalid item";
        $this->jsonResponse();
    }


  public function History()
{
    $feed_data = array();

    $data_columns[] = array('data' => "created_at");
    $data_columns[] = array('data' => "item_name");
    $data_columns[] = array('data' => "added_by");
    $data_columns[] = array('data' => "transaction_type");
    $data_columns[] = array('data' => "adjustment");
    $data_columns[] = array('data' => "stock_after");

    $cols = array('created_at', 'item_name', 'added_by', 'transaction_type', 'adjustment', 'stock_after');
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';

    $and = "AND merchant_id = :merchant_id ";
    $and .= " AND item_name <> ''";

    if (!empty($range1) && !empty($range2)) {
        $range2 = date('Y-m-d', strtotime($range2 . ' +1 day'));
        $and .= "\nAND created_at BETWEEN :range1 AND :range2 ";
    }

    $in_reason = '';
    if (isset($this->data['reason'])) {
        if (!in_array('all', (array)$this->data['reason'])) {
            $in_reason = implode(',', array_map('intval', $this->data['reason']));
            $and .= "\nAND transaction_type IN ($in_reason)";
        }
    }

    $in_user = '';
    if (isset($this->data['user'])) {
        if (!in_array('all', (array)$this->data['user'])) {
            $in_user = implode(',', array_map('intval', $this->data['user']));
            $and .= "\nAND added_by IN ($in_user)";
        }
    }

    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
    if (!empty($search_field)) {
        $and .= " AND (item_name LIKE :search_field OR sku LIKE :search_field)";
    }

    $order = "ORDER BY stock_id DESC";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS *
        FROM mt_view_inventory_stocks
        WHERE 1
        $and
        $where
        $order
        $limit
    ";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', $this->merchant_id, PDO::PARAM_INT);

    if (!empty($range1) && !empty($range2)) {
        $query->bindValue(':range1', $range1);
        $query->bindValue(':range2', $range2);
    }

    if (!empty($search_field)) {
        $query->bindValue(':search_field', "%$search_field%");
    }

    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $total_records = 0;
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();

        if ($resc = $queryc->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if ($key_cols == 0) {
                    $cols_data[$cols_val] = $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                } elseif ($key_cols == 1) {
                    $cols_data[$cols_val] = $this->InventoryWrapper->prettyItemName($val['item_name'], $val['size_name'], $val['sku']);
                } elseif ($key_cols == 3) {
                    $cols_data[$cols_val] = $this->StocksWrapper->prettyTransactionStatusWithRef(
                        $val[$cols_val],
                        $val['reference'],
                        $val['transaction_code'],
                        $val['transaction_id'],
                        $val['remarks']
                    );
                } elseif ($key_cols == 4 || $key_cols == 5) {
                    $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                } else {
                    $cols_data[$cols_val] = $val[$cols_val];
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function Valuation()
{
    $feed_data = array();
    $cols = array('item_name', 'available_stocks', 'cost_price', 'inventory_value', 'price', 'retail_value', 'potential_profit');
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND merchant_id = :merchant_id ";
    $and .= " AND status IN ('publish') AND track_stock = '1' ";

    $stmt = "SELECT SQL_CALC_FOUND_ROWS 
        *
        FROM mt_view_item_stocks 
        WHERE 1     
        $and
        $where
        $order
        $limit";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();
        $resc = $queryc->fetch(PDO::FETCH_ASSOC);

        $total_records = $resc['total_records'] ?? 0;

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $cols_data = array();
            $inventory_value = 0;
            $retail_value = 0;
            $potential_profit = 0;

            foreach ($cols as $key_cols => $cols_val) {
                if ($cols_val == "inventory_value") {
                    if ($val['available_stocks'] > 0) {
                        $inventory_value = (float)$val['available_stocks'] * (float)$val['cost_price'];
                        $cols_data[$cols_val] = $this->functions->prettyPrice($inventory_value);
                    } else {
                        $cols_data[$cols_val] = 0;
                    }
                } elseif ($cols_val == "retail_value") {
                    if ($val['available_stocks'] > 0) {
                        $retail_value = (float)$val['available_stocks'] * (float)$val['price'];
                        $cols_data[$cols_val] = $this->functions->prettyPrice($retail_value);
                    } else {
                        $cols_data[$cols_val] = 0;
                    }
                } elseif ($cols_val == "potential_profit") {
                    $potential_profit = (float)$retail_value - (float)$inventory_value;
                    $cols_data[$cols_val] = $this->functions->prettyPrice($potential_profit);
                } else {
                    switch ($key_cols) {
                        case 0:
                            $cols_data[$cols_val] = $this->InventoryWrapper->prettyItemName($val['item_name'], $val['size_name'], $val['sku']);
                            break;
                        case 1:
                            $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                            break;
                        case 2:
                        case 4:
                            $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                            break;
                        default:
                            $cols_data[$cols_val] = $val[$cols_val];
                            break;
                    }
                }
            }
            $datas[] = $cols_data;
        }
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}








   public function Adjustment_list()
{
    $feed_data = array(); 
    $transaction_list = $this->StocksWrapper->adjustmentType();

    $cols = array('transaction_id', 'created_at', 'transaction_type', 'quantity');
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND merchant_id = :merchant_id ";   
    $params = [':merchant_id' => $this->merchant_id];
    
    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
    if (!empty($search_field)) {
        $and .= " AND (reference LIKE :search_field)";
        $params[':search_field'] = "%$search_field%";
    }

    $reason = '';   
   if (isset($this->data['reason'])) {     
    if (is_array($this->data['reason']) && count($this->data['reason']) >= 1) {
        if (!in_array('all', $this->data['reason'])) {
            $quoted_reasons = array_map(function($value) {
                return "'$value'"; // Add single quotes around each value
            }, $this->data['reason']);
            
            $reason = implode(',', $quoted_reasons); // Create a comma-separated string
            $and .= " AND transaction_type IN ($reason)";
        }   
    }
}

    $stmt = "SELECT SQL_CALC_FOUND_ROWS 
        transaction_id, created_at, transaction_type, quantity, reference
        FROM mt_view_inventory_transaction 
        WHERE 1
        $and
        $where
        $order
        $limit";

    $query = $this->db->prepare($stmt);
    foreach ($params as $key => $value) {
        $query->bindValue($key, $value);
    }
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $total_records = 0;
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();

        if ($resc = $queryc->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = [];
        foreach ($res as $val) {
            $cols_data = array();

            $cols_data["DT_RowId"] = Config::$baseUrl . "/inventory/stocks/adjustment_details/id/" . $val['transaction_id'];

            foreach ($cols as $key_cols => $cols_val) {
                if ($key_cols == 0) {
                    $cols_data[$cols_val] = $val['reference'];
                } elseif ($key_cols == 1) {
                    $cols_data[$cols_val] = $this->functions->prettyDate($val[$cols_val]);
                } elseif ($key_cols == 2) {
                    $cols_data[$cols_val] = $transaction_list[$val[$cols_val]];
                } elseif ($key_cols == 3) {
                    $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                } else {
                    $cols_data[$cols_val] = $val[$cols_val];
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function AutoFillItem()
  {
    $type = isset($this->data['type']) ? $this->data['type'] :'';
    $supplier_id = isset($this->data['supplier_id']) ? (integer) $this->data['supplier_id'] :'';
    
    try {
        
      $data = $this->ItemWrap->autoFillItem($this->merchant_id, $supplier_id , $type);
      $this->code = 1; $this->msg = "OK";
      $this->details = array(
       'next_action'=>"auto_fill_purchase",
       'data'=>$data
      );
      
    } catch (Exception $e) {
           $this->msg = ($e->getMessage());
           $this->details = array(
         'error_type'=>'silent',         
        );
        }
    $this->jsonResponse();
  }





        public function Delete_purchase()
    {       
        $id = isset($this->data['row_id'])? (integer) $this->data['row_id'][0]:0;
        try {
            
            $params = array(
              'status'=>"closed",
              'updated_at'=>$this->functions->dateNow(),
              'added_by'=>$_SESSION['username'],
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            $this->StocksWrapper->setDeletePurchaseOrder( (integer) $id, $this->merchant_id, $params);
            $this->details = array(
                  'next_action'=>"redirect",
                  'redirect'=>Config::$baseUrl."/inventory/stocks/order_list"
                );

                $this->code = 1; $this->msg = "OK";
                $this->msg = "Successful";
            
        } catch (Exception $e) {
           $this->msg = ($e->getMessage());
        }  
        $this->jsonResponse();
    }


    public function Purchase_receive()
    {       
        $po_id = isset($this->data['row_id'])? (integer)$this->data['row_id'] : '';
        if ( $resp = $this->StocksWrapper->getPurchaseOrder($po_id,$this->merchant_id)){                   
        $params = array();
            if(isset($this->data['po_details_id'])){
                foreach ($this->data['po_details_id'] as $key=>$val) {
                    
                    $po_details_id = $val;
                    
                    $sku = $this->StocksWrapper->getSKUPurchaseDetails2($po_details_id);                   
                    
                    $receive_params = array(
                      'po_id'=>$po_id,
                      'po_details_id'=>$po_details_id,
                      'sku'=>$sku['sku'],
                      'qty'=>isset($this->data['receive_qty'][$key])? (float) $this->data['receive_qty'][$key]:0,
                      'added_by'=>$_SESSION['username'],
                      'created_at'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'cost_price'=>$sku['cost_price'],
                      'track_stock'=>$sku['track_stock']
                    );
                    
                    if($receive_params['qty']>0){                   
                       $params[] = $receive_params;
                    }
                }
                try {                   
                    
                    
                    $this->StocksWrapper->insertPurchaseReceive($params,$this->merchant_id);
                    $this->details = array(
                      'next_action'=>"redirect",
                      'redirect'=>Config::$baseUrl."/inventory/stocks/order_list"
                    );


                    $this->code = 1; $this->msg = "OK"; 
                    $this->msg = "Successful";
                    
                } catch (Exception $e) {
                   $this->msg = ($e->getMessage());
                }    
            } else $this->msg = "Invalid id";
        } else $this->msg = "Purchase information not found";
        $this->jsonResponse();
    }

	
	
	
	
	
public function Supplier_list()
{
    $feed_data = array(); 
    $transaction_list = $this->StocksWrapper->adjustmentType();
    
    $cols = array('supplier_id', 'supplier_name', 'contact_name', 'phone_number', 'email');
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];
    
    $and = "AND merchant_id = " . intval($this->merchant_id) . " ";
    
    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
    if (!empty($search_field)) {
        $search_field = '%' . $search_field . '%';
        $and .= " AND (supplier_name LIKE :search_field
                 OR contact_name LIKE :search_field
                 OR email LIKE :search_field
                 OR phone_number LIKE :search_field)";
    }
    
    $stmt = "SELECT SQL_CALC_FOUND_ROWS 
             * 
             FROM mt_inventory_supplier 
             WHERE 1     
             $and
             $where
             $order
             $limit";
    
    $query = $this->db->prepare($stmt);
    
    if (!empty($search_field)) {
        $query->bindParam(':search_field', $search_field, PDO::PARAM_STR);
    }
    
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();
        $resc = $queryc->fetch(PDO::FETCH_ASSOC);
        
        $total_records = $resc['total_records'] ?? 0;
        
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;
        
        foreach ($res as $val) {
            $cols_data = array();
            $cols_data["DT_RowId"] = Config::$baseUrl . "/inventory/stocks/supplier_new/id/" . $val['supplier_id'];
            
            foreach ($cols as $key_cols => $cols_val) {
                $cols_data[$cols_val] = $val[$cols_val];
            }
            $datas[] = $cols_data;
        }
        
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}



public function Order_list()
{
    $feed_data = array();
    $transaction_list = $this->StocksWrapper->adjustmentType();
    
    $cols = array('po_id', 'purchase_date', 'supplier_name', 'status', 'received', 'expected_on', 'total', 'total_qty');
    $resp = $this->functions->inventory_datatable_format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND merchant_id = " . $this->merchant_id . " ";
    
    $status = '';   
    if (isset($this->data['status'])) {     
    if (is_array($this->data['status']) && count($this->data['status']) >= 1) {
        if (!in_array('all', $this->data['status'])) {
            $quoted_status = array_map(function($value) {
                return "'$value'"; // Add single quotes around each value
            }, $this->data['status']);
            
            $status = implode(',', $quoted_status); // Create a comma-separated string
            $and .= " AND status IN ($status) ";
        }   
    }
}






    
    $supplier_id = '';    
    if (isset($this->data['supplier_id'])) {      
        if (is_array($this->data['supplier_id']) && count($this->data['supplier_id']) >= 1) {
            if (!in_array('all', $this->data['supplier_id'])) {
                foreach ($this->data['supplier_id'] as $supplier_id_val) {
                    $supplier_id .= ($supplier_id_val) . ",";
                }
                $supplier_id = rtrim($supplier_id, ',');
                $and .= " AND supplier_id IN ($supplier_id) ";
            }   
        }
    }

    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
    if (!empty($search_field)) {
        $and .= " AND (po_id LIKE :search_field OR supplier_name LIKE :search_field OR notes LIKE :search_field)";
    }

    $sql = "
        SELECT SQL_CALC_FOUND_ROWS * 
        FROM mt_view_inventory_purchase_order 
        WHERE 1 
        $and 
        $where 
        $order 
        $limit
    ";

    // Prepare the PDO statement
    $stmt = $this->db->prepare($sql);

    // Bind the search field parameter if exists
    if (!empty($search_field)) {
        $search_value = "%$search_field%";
        $stmt->bindParam(':search_field', $search_value, PDO::PARAM_STR);
    }

    // Execute the query
    $stmt->execute();

    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $total_records = 0;
    $stmtc = $this->db->query("SELECT FOUND_ROWS() as total_records");
    $resc = $stmtc->fetch(PDO::FETCH_ASSOC);
    $total_records = $resc['total_records'];

    $feed_data['draw'] = $this->data['draw'];
    $feed_data['recordsTotal'] = $total_records;
    $feed_data['recordsFiltered'] = $total_records;

    $datas = array();




    foreach ($res as $val) {
        $cols_data = array();

        $cols_data["DT_RowId"] = Config::$baseUrl . "/inventory/stocks/purchase_view/id/" . $val['po_id'];

        foreach ($cols as $key_cols => $cols_val) {
            if ($key_cols == 0) {
                $cols_data[$cols_val] = $this->StocksWrapper->transactionCode('po') . $val[$cols_val];
            } elseif ($key_cols == 1) {
                $cols_data[$cols_val] = $this->functions->prettyDate($val[$cols_val]);
            } elseif ($key_cols == 3) {
                $cols_data[$cols_val] = $this->StocksWrapper->prettyPurchaseStatus($val[$cols_val]);
            } elseif ($key_cols == 4) {
                $received = isset($val['received']) ? (float)$val['received'] : 0;
                $total_qty = (float)$val['total_qty'];
                $percent = ($received / $total_qty) * 100;

                $html = '<div class="progress">
                            <div class="progress-bar" role="progressbar" style="width:' . $percent . '%"></div>
                          </div>';

                $html .= '<div class="text-muted">' . "receive of total " . $this->InventoryWrapper->prettyQuantity($received) . " total " . $this->InventoryWrapper->prettyQuantity($total_qty) . '</div>';

                $cols_data[$cols_val] = $html;
            } elseif ($key_cols == 5) {
                $cols_data[$cols_val] = !empty($val[$cols_val]) ? $this->functions->prettyDate($val[$cols_val]) : '';
            } elseif ($key_cols == 6) {
                $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
            } else {
                $cols_data[$cols_val] = $val[$cols_val];
            }
        }

        $datas[] = $cols_data;
    }

    $feed_data['data'] = $datas;
    $this->otableOutput($feed_data);
}








public function Supplier_new()
    {
        $params = array(
          'merchant_id'=>$this->merchant_id,
          'supplier_name'=>isset($this->data['supplier_name'])?$this->data['supplier_name']:'',
          'contact_name'=>isset($this->data['contact_name'])?$this->data['contact_name']:'',
          'email'=>isset($this->data['email'])?$this->data['email']:'',
          'phone_number'=>isset($this->data['phone_number'])?$this->data['phone_number']:'',
          'address_1'=>isset($this->data['address_1'])?$this->data['address_1']:'',
          'address_2'=>isset($this->data['address_2'])?$this->data['address_2']:'',
          'city'=>isset($this->data['city'])?$this->data['city']:'',
          'postal_code'=>isset($this->data['postal_code'])?$this->data['postal_code']:'',
          'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
          'region'=>isset($this->data['region'])?$this->data['region']:'',
          'notes'=>isset($this->data['notes'])?$this->data['notes']:'',
          'created_at'=>$this->functions->dateNow(),
          'updated_at'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        
        try {
            
            $id = 0;
            $id = isset($this->data['row_id'])?$this->data['row_id']:0;
            if($id>0){
                unset($params['created_at']);
            } else unset($params['updated_at']);            
                        
           
            
            $this->StocksWrapper->insertSupplier($params['merchant_id'],$params,(integer)$id);
            $this->details = array(
              'next_action'=>"redirect",
              'redirect'=>Config::$baseUrl.'/inventory/stocks/supplier_list'
            );

            $this->code = 1; $this->msg = "OK";
            $this->msg = "Successful";
            
        } catch (Exception $e) {
            $this->msg = $e->getMessage();
        } 
                   
        $this->jsonResponse();
    }




      public function Delete_supplier()
  {
    if (isset($this->data['row_id'])){
      try {
                
        
        $ids = array();
        foreach ($this->data['row_id'] as $id) {          
          $ids[]= (integer) $id;
        }   
       
        $this->StocksWrapper->deleteSupplier($this->merchant_id,$ids);       
        $this->OKresponse();
        $this->msg = "Record deleted";
        $this->details = array(
         'next_action'=> isset($this->data['next_action'])?$this->data['next_action']:"refresh_table",
         'redirect'=>Config::$baseUrl."/inventory/stocks/supplier_list"
        );

        
      } catch (Exception $e) {
           $this->msg = $e->getMessage();
        }
    } else $this->msg = "invalid row id";
    $this->jsonResponse();
  }














	
	
	
}
/*end class*/