<?php




class IndexController extends Controller {


    protected $functions;

    

    public function __construct() {
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        
        $this->functions->initPriceFormatter($used_currency);
        $this->UserWrapper = new UserWrapper();

       

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
     

      if(!$this->UserWrapper->validToken()){
            
            

            $url =Config::$baseUrl.'/inventory/login'; // Adjust the base path as needed
            
            header('Location: ' . $url);

            exit();       
        }else{
            
        }


    }

    public function index() {

        
         
        if(!$this->UserWrapper->validToken()){
            
            

            $url =Config::$baseUrl.'/inventory/login'; // Adjust the base path as needed
           
            header('Location: ' . $url);

            exit();       
        }else{

            $this->dashboard();
        }




    }


    public function dashboard(){

        

        $user_type = $this->UserWrapper->getUserType();

        


        if($user_type=="admin"):
           /*InventoryWrapper::registerScript(array(       
             "var ajax_charts='/Ajaxadmin/sales_summary_chart';",   
             "var chart_type_series='area';",   
             "var chart_type_options='".CJavaScript::quote($chart_options)."';"
            )); */    
        else :
            $ajax_action='Ajaxuser/dashboard';
            $ajax_charts='/Ajaxreports/sales_summary_chart';
            $chart_type_series='area';
            $chart_type_options='';   
        endif;  

        

        $days =7;       
        $start_date = date("Y-m-d", strtotime("-$days days"));
        $end_end  = date("Y-m-d");

        $status = $this->functions->getOptionAdmin('inventory_reports_default_status');
        if(!empty($status)){
            $status = json_decode($status,true);
        }

        $default_status = (array) $status;

        if($user_type=="admin"){
         
        } else {


          

            $data = [
            'start_date'=>$start_date,
              'end_end'=>$end_end,
              'ajaxurl'=>'/inventory',
              'ajax_action'=>$ajax_action,
              'ajax_charts'=>$ajax_charts,
              'chart_type_series'=>$chart_type_series,
              'chart_type_options'=>$chart_type_options,
              'default_status'=>$default_status
            ];

          
        
        $this->view('inventory/dashboard', $data, 'inventory/layout_reports');

        }





    }


    public function logout()
    {

       
        $lang  = 'en';      
        //$this->UserWrapper->logout();


       

        unset($_SESSION['user_logged_in']);
unset($_SESSION['token']);
unset($_SESSION['user_token']);
unset($_SESSION['username']);
unset($_SESSION['user_email']);
unset($_SESSION['user_type']);
unset($_SESSION['inventory_merchant']);


        $url =Config::$baseUrl.'/inventory/login'; // Adjust the base path as needed
           
        header('Location: ' . $url);

    }


	
	
	
   
}
