<?php




class StocksController extends Controller {


    protected $functions;

    

    public function __construct() {
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        
        
        
        $this->UserWrapper = new UserWrapper();

        $this->InventoryWrapper = new InventoryWrapper();
        
        $this->ItemWrap = new ItemWrap();

        $this->StocksWrapper = new StocksWrapper();

        $this->ItemHtmlWrapper = new ItemHtmlWrapper();


       $this->ajax_controller='Ajaxitem';

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     

      date_default_timezone_set($website_timezone);

      if(!$this->UserWrapper->validToken()){
            
            

            $url =Config::$baseUrl.'/inventory/login'; // Adjust the base path as needed
            
            header('Location: ' . $url);

            exit();       
        }else{
            //$this->dashboard();
        }


    }


    public function Supplier_list()
    {
        $data_columns[] = array('data'=>"supplier_id");     
        $data_columns[] = array('data'=>"supplier_name");       
        $data_columns[] = array('data'=>"contact_name");
        $data_columns[] = array('data'=>"phone_number");
        $data_columns[] = array('data'=>"email");       
        $data_columns = json_encode($data_columns);     
                
       
        
       

         $data = [
           'add_label'=>"ADD SUPPLIER",
           'add_link'=>Config::$baseUrl.'/inventory/stocks/supplier_new'
            ];

           
        
        $this->view('inventory/supplier_list', $data, 'inventory/layout');



    }



    public function Supplier_new($params=[])
	{
		$data = array();
		$merchant_id = $_SESSION['inventory_merchant'];
		$id=$params['id'];
        if(isset($id)){
       $_GET['id']=$id;
       }
		
		try {
								
			if(isset($_GET['id'])){
				$row_id = (integer)$_GET['id'];		
				$data = $this->ItemWrap->getData("inventory_supplier","merchant_id=:merchant_id AND supplier_id=:supplier_id",array(
				 ':merchant_id'=>$merchant_id,
				 ':supplier_id'=>$row_id
				));			
				
				
			}
			
			

			$data = [
            'data'=>($data),	
            'row_id'=>$row_id,	
			  'cancel_link'=>Config::$baseUrl.'/inventory/stocks/supplier_list' 
            ];
       
           

			$this->view('inventory/supplier_new', $data, 'inventory/layout');


		
		} catch (Exception $e) {


		    $back_url = Config::$baseUrl."/inventory/stocks/supplier_list";

		    $error = ($e->getMessage());
		    

		     $data = [
            'message'=>$error,
		     'back_url'=>$back_url
            ];

		   $this->view('inventory/error_item', $data, 'inventory/layout');



		}
	}


  public function Adjustment_list()
  {
    $data_columns[] = array('data'=>"transaction_id");    
    $data_columns[] = array('data'=>"created_at");
    $data_columns[] = array('data'=>"transaction_type");
    $data_columns[] = array('data'=>"quantity");    
    $data_columns = json_encode($data_columns);   
        
   
      
    $reason = $this->StocksWrapper->adjustmentTypeList();

    
    

    $data = [
            'add_label'=>"ADD STOCKS ADJUSTMENT",
             'add_link'=>Config::$baseUrl."/inventory/stocks/adjustment_new",
             'reason'=>$reason
            ];


           $this->view('inventory/adjustment_list', $data, 'inventory/layout');



  }


  public function Adjustment_new()
    {               
       
                
        $table_properties = $this->StocksWrapper->tableProperties();
                
            
        
        $adjustment_type = $this->StocksWrapper->adjustmentType();
        unset($adjustment_type['item_edit']);
        unset($adjustment_type['sale']);        
        
        

         $data = [
            'adjustment_type'=>$adjustment_type,
             'cancel_link'=>Config::$baseUrl."/inventory/stocks/adjustment_list"
            ];


           $this->view('inventory/adjustment_new', $data, 'inventory/layout');

    }


        public function Adjustment_details($params=[])
    {
        try {        
            $id=$params['id'];
        if(isset($id)){
       $_GET['id']=$id;
       }      
            $merchant_id = $_SESSION['inventory_merchant'];
            $transaction_id = isset($_GET['id'])?(integer)$_GET['id']:0;            
            $data = $this->StocksWrapper->getTransactionDetails($transaction_id, $merchant_id);
            
               

          $data = [
           'cancel_link'=>Config::$baseUrl."/inventory/stocks/adjustment_list",
              'data'=>($data),
              'table_prop'=>$this->StocksWrapper->tablePropertiesView()
            ];

           $this->view('inventory/adjustment_details', $data, 'inventory/layout');


        } catch (Exception $e) {


            

            $back_url = Config::$baseUrl."/inventory/stocks/adjustment_list";
            $error = ($e->getMessage());
             $data = [
            'message'=>$error,
             'back_url'=>$back_url
            ];

           $this->view('inventory/error_item', $data, 'inventory/layout');

        }
    }



    public function History()
    {       
        
        
        
        $data_columns[] = array('data'=>"created_at");      
        $data_columns[] = array('data'=>"item_name");
        $data_columns[] = array('data'=>"added_by");
        $data_columns[] = array('data'=>"transaction_type");        
        $data_columns[] = array('data'=>"adjustment");
        $data_columns[] = array('data'=>"stock_after");
        $data_columns = json_encode($data_columns);     
        
        $days = $this->InventoryWrapper->reportsRange();
        $start_date = date("Y-m-d", strtotime("-$days days"));
        $end_end  = date("Y-m-d");      
            
        $merchant_id = $_SESSION['inventory_merchant'];
        
        $date_range_trans = $this->InventoryWrapper->dateRangeTrans();
                
        
        
        

      $data = [
    'start_date' => $start_date,
    'end_date' => $end_end,  // Corrected the key name from 'end_end' to 'end_date'
    'reason' => $this->StocksWrapper->adjustmentTypeList(),
    'user_list' => $this->InventoryWrapper->dropdownFormat(
        $this->UserWrapper->getAllUserByMerchantID($merchant_id), 
        'username', 
        'username', 
        array('all' => "All user") // Corrected the array syntax here
    )
];




           $this->view('inventory/history', $data, 'inventory/layout');




    }




    public function Order_list()
    {
        $data_columns[] = array('data'=>"po_id");       
        $data_columns[] = array('data'=>"purchase_date");
        $data_columns[] = array('data'=>"supplier_name");
        $data_columns[] = array('data'=>"status");      
        $data_columns[] = array('data'=>"received");        
        $data_columns[] = array('data'=>"expected_on");
        $data_columns[] = array('data'=>"total");
        $data_columns = json_encode($data_columns);     
                
        
        
        $merchant_id = $_SESSION['inventory_merchant'];
        
        $supplier = (array)$this->InventoryWrapper->dropdownFormat(
           $this->StocksWrapper->getSupplier((integer)$merchant_id),'supplier_id','supplier_name',
           array(
            'all'=>"All supplier"
           )
        );
        
       


        $data = [
            'x'=>0,
         'supplier'=>$supplier,
         'purchase_status'=>(array)$this->StocksWrapper->purchaseStatus(),
         'add_label'=>"ADD PURCHASE ORDER",
         'add_link'=>Config::$baseUrl."/inventory/stocks/purchase_new"
            ];


           $this->view('inventory/order_list', $data, 'inventory/layout');



    }


      public function Valuation()
  {
    $data_columns[] = array('data'=>"item_name");   
    $data_columns[] = array('data'=>"available_stocks");
    $data_columns[] = array('data'=>"cost_price");    
    $data_columns[] = array('data'=>"inventory_value");
    $data_columns[] = array('data'=>"price");   
    $data_columns[] = array('data'=>"retail_value");
    $data_columns[] = array('data'=>"potential_profit");
    $data_columns = json_encode($data_columns);   
    
    $merchant_id = $_SESSION['inventory_merchant'];
        
    
    
    
    
    

    $data = [
            'data'=>$this->StocksWrapper->getEvaluation($merchant_id)
            ];


    $this->view('inventory/valuation', $data, 'inventory/layout');



  }








        public function Purchase_new($params=[])
    {
        
        
        $merchant_id = $_SESSION['inventory_merchant'];
        $id=$params['id'];
        if(isset($id)){
        $_GET['id']=$id;
        }

        $data=array(); $row_id='';
        
        $table_properties = $this->StocksWrapper->tableProperties();
        $supplier_list = (array) $this->InventoryWrapper->dropdownFormat($this->StocksWrapper->getSupplier($merchant_id),'supplier_id','supplier_name');      
        
        $cancel_link = Config::$baseUrl."/inventory/stocks/order_list";
        
        
        if(isset($_GET['id'])){
                $row_id = (integer)$_GET['id'];     
                
                try {
                
                    $data = $this->StocksWrapper->getPurchaseDetails($row_id, $merchant_id);               
                    
                } catch (Exception $e) {
                    
                    $back_url = Config::$baseUrl."/inventory/stocks/order_list";
                    $error = $e->getMessage();
                     $data = [
                    'message'=>$error,
                     'back_url'=>$back_url
                    ];

                   $this->view('inventory/error_item', $data, 'inventory/layout');


                    return ;
                }
                
              
                
                $cancel_link = Config::$baseUrl."/inventory/stocks/purchase_view/id/".$row_id;
                                        
                
            }
                
        
       
        

         $data = [
            'data'=>$data,
            'row_id'=>$row_id,
         'save_label'=>$row_id>0?"UPDATE":"SAVE",
         'cancel_link'=>$cancel_link,
         'supplier_list'=>$supplier_list
            ];
           
          

           $this->view('inventory/purchase_new', $data, 'inventory/layout');




    }


    public function Purchase_receive($params=[])
    {
        $data = array(); 
        $merchant_id = $_SESSION['inventory_merchant'];
         $id=$params['id'];
        if(isset($id)){
        $_GET['id']=$id;
        }
        
        $row_id = isset($_GET['id'])? (integer)$_GET['id'] : '';    
        
        try {
            
            $data = $this->StocksWrapper->getPurchaseDetails($row_id, $merchant_id);
            
            
            
            

         $data = [
            'data'=>$data,
              'po_id'=>$row_id,
              'row_id'=>$row_id,
              'cancel_link'=>Config::$baseUrl."/inventory/stocks/purchase_view/id/".$row_id
            ];

           $this->view('inventory/purchase_receive', $data, 'inventory/layout');

            
        } catch (Exception $e) {

          


            $back_url = Config::$baseUrl."/inventory/stocks/order_list";
            $error = ($e->getMessage());
             $data = [
            'message'=>$error,
             'back_url'=>$back_url
            ];

           $this->view('inventory/error_item', $data, 'inventory/layout');



        }
    }




    public function Purchase_view($params=[])
    {
        $data = array(); $row_id=''; $data_receive = array();
        $merchant_id = $_SESSION['inventory_merchant'];
        $is_editable = true;

         $id=$params['id'];
        if(isset($id)){
        $_GET['id']=$id;
        }
        
        try {
                                
            if(isset($_GET['id'])){
                $row_id = (integer)$_GET['id'];     
                
                $data = $this->StocksWrapper->getPurchaseDetails($row_id, $merchant_id);                       
                $data_receive = $this->StocksWrapper->getPurchaseOrderView($row_id,$merchant_id);              
                
               
                                
                if($data[0]['status']=="closed"){
                    $is_editable=false;
                }
            }
            
           

            $data = [
              'data'=>($data),  
              'row_id'=>($row_id),    
              'data_receive'=>$data_receive,
              'is_editable'=>$is_editable,
              'cancel_link'=>Config::$baseUrl."/inventory/stocks/order_list",      
              'receive_link'=>Config::$baseUrl."/inventory/stocks/purchase_receive/id/".$row_id,
              'edit_link'=>Config::$baseUrl."/inventory/stocks/purchase_new/id/".$row_id,
            ];

           $this->view('inventory/purchase_view', $data, 'inventory/layout');


        
        } catch (Exception $e) {
            
            $back_url = Config::$baseUrl."/inventory/stocks/order_list";
            $error = ($e->getMessage());

            

             $data = [
            'message'=>$error,
             'back_url'=>$back_url
            ];

           $this->view('inventory/error_item', $data, 'inventory/layout');

        }
    }

		



    


  



   


	
	
	
   
}
