<?php
class CronWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();

        $this->StocksWrapper = new StocksWrapper();
        

    }
	
	public function processInventorySale()
{
    $update_at = $this->functions->dateNow();
    $process_status = 'process';

    try {
        // Fetch inventory sales with pending status
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_inventory_sales
            WHERE process_status = :process_status
            ORDER BY id ASC
            LIMIT 10
        ");
        $stmt->bindValue(':process_status', 'pending', PDO::PARAM_STR);
        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $id = $val['id'];
                $order_id = $val['order_id'];
                $order_status = trim($val['order_status']);
                $transaction_type = $val['transaction_type'];



                // Fetch order details and stock availability
                $stmtDetails = $this->db->prepare("
                    SELECT a.*, SUM(a.qty) as qty,
                    IFNULL((
                        SELECT stock_after
                        FROM mt_inventory_stocks
                        WHERE sku = a.sku
                        ORDER BY stock_id DESC
                        LIMIT 1
                    ), 0) as available_stocks
                    FROM mt_view_inventory_order_details a
                    WHERE order_id = :order_id
                    GROUP BY sku
                ");
                $stmtDetails->bindValue(':order_id', $order_id, PDO::PARAM_INT);
                $stmtDetails->execute();
                $resp = $stmtDetails->fetchAll(PDO::FETCH_ASSOC);

                if ($resp) {
                    foreach ($resp as $data) {
                        $stock_after = 0;
                        $available_stocks = $data['available_stocks'];



                        $user = $this->StocksWrapper->getOwner($data['merchant_id']);

                        $params_stock = array(
                            'created_at' => $this->functions->dateNow(),
                            'sku' => $data['sku'],
                            'merchant_id' => $data['merchant_id'],
                            'transaction_type' => 'sale',
                            'transaction_id' => $data['order_id'],
                            'transaction_code' => $this->StocksWrapper->transactionCode('or'),
                            'cost_price' => $data['cost_price'],
                            'added_by' => isset($user['username']) ? $user['username'] : '',
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        );

                        // Handle transaction type: sale or cancelled
                        if ($transaction_type === "sale") {
                            $stock_after = $available_stocks - $data['qty'];
                            
                            $params_stock['adjustment'] = -$data['qty'];
                        }
                       
                        if ($transaction_type === "cancelled") {
                            $stock_after = $available_stocks + $data['qty'];
                            $params_stock['adjustment'] = $data['qty'];
                            $params_stock['remarks'] = $order_status;
                        }

                        $params_stock['stock_after'] = $stock_after;
                        
                      
                        // Insert stock adjustment record
                        if ($data['track_stock'] >= 1) {
                            if (!$this->functions->insertData("mt_inventory_stocks", $params_stock)) {
                                $process_status = "failed. cannot insert";
                            }
                        }
                    }
                } else {
                    $process_status = 'failed. no records to process';
                }

                // Update inventory sale process status
                $params_update = array(
                    'process_status' => $process_status,
                    'updated_at' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                );
                $this->functions->updateData(
				    "mt_inventory_sales",    // Table name
				    $params_update,          // Associative array of columns to update
				    'id',                     // Column name for WHERE clause
				    $id                       // Value for the WHERE clause
				);

            }
        }
    } catch (PDOException $e) {
        // Handle any exceptions
        error_log("Error in processInventorySale: " . $e->getMessage());
    }
}

	
}
/*end class*/