<?php
class ItemHtmlWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->ItemWrap = new ItemWrap();
       $this->InventoryWrapper = new InventoryWrapper();
        

    }

	
	
	public  function noSizeForm( $data=array() )
	{
		$sku = $this->ItemWrap->autoGenerateSKU();
		ob_start();			
		
		 echo '<input type="hidden" id="item_size_id" name="item_size_id" value="' . (isset($data['item_size_id']) ? $data['item_size_id'] : '') . '" />'; 
				
		if(!isset($data['available'])){
			$data = array();
			$data['available']=1;
		}
		?>
		
		 <DIV class="pb-3">
		 		  
	      <?php 
	      echo $this->formSwitch('available','The item is available for sale',
	        $data['available']==1?true:false,
	        array(
	         'value'=>1
	        )
	      );
	      ?>
	        
	      
	     </DIV>
	      
		  <div class="row">
	           <div class="col-md-6">	           
	             <div class="form-group">
	               <label for=""><?php echo "Price"?></label>
		           <?php 
    echo '<input type="text" id="single_price" name="single_price" value="' . (isset($data['price']) ? $this->functions->normalPrettyPrice($data['price']) : '') . '" class="form-control numeric_only" placeholder="0.00" required />';
?>

		         </div>	            	           
	           </div> <!--col-->
	            <div class="col-md-6">	           
	             <div class="form-group">
	               <label for=""><?php echo "Cost"?></label>
		           <?php 
    echo '<input type="text" id="cost_price" name="cost_price" value="' . (isset($data['cost_price']) ? $this->functions->normalPrettyPrice($data['cost_price']) : '') . '" class="form-control numeric_only" placeholder="0.00" />';
?>

		         </div>	            	           
	           </div> <!--col-->
	        </div> <!--row-->
	        
	        <div class="row">
	         <div class="col-md-6">
	            <div class="form-group">
	               <label for=""><?php echo "SKU" ?></label>
		           <?php 
    echo '<input type="text" id="sku" name="sku" value="' . (isset($data['sku']) ? $data['sku'] : $sku) . '" class="form-control" ' . (isset($data['sku']) ? 'readonly' : '') . ' />';
?>

		         </div>	   
	         </div>
	         
	       
	        </div>
	         
		<?php
		$forms = ob_get_contents();
        ob_end_clean();	
        return $forms;
	}
	
	public  function withSizeForm($merchant_id='', $data=array() )
	{
		//print_r($data);
			
		$itemsdetail=$this->functions->getFoodItem($data[0]['item_id']);
		$quantity=isset($itemsdetail['quantity'])?(array)json_decode($itemsdetail['quantity']):false;	
		//print_r($quantity);
		if($itemsdetail['is_variable_price']=='2'){
			$styles=' style="display:block; "';$styles2=' style="display:none; "';
		}else{$styles=' style="display:none; "';$styles2=' style="display:block; "';}
		
		$sku = $this->ItemWrap->autoGenerateSKU();
		$sizes = (array)$this->ItemWrap->dropdownFormat((array)$this->ItemWrap->getSizes($merchant_id),'size_id','size_name');
		ob_start();					
		?>
		<!--PRICE-->
	      <table class="table size_table">
	       <thead>
	        <tr>
	         <th width="3%"><?php echo "Available" ?></th>
			 
	         <th class="is_variable_prices"  <?= $styles ?>><?php echo "Variable Cost"?></th>
			 <th width="15%"><?php echo "Size"?></th>
	         <th width="12%"><?php echo "Price"?></th>
	         <th width="12%"><?php echo "Cost"?></th>	         	        
	         <th width="12%"><?php echo "In stock"?></th>	
	         <th width="12%"><?php echo "Low stock"?></th>	
	         <th width="12%"><?php echo "SKU"?></th>	        
	         <th width="3%"></th>	         
	        </tr>
	       </thead>
	       <tbody>
	        
	        	        
	        <?php if(is_array($data) && count($data)>=1):?>
	        
	        <?php foreach ($data as $val):?>
	        <tr>
	        <td>
	        
	           <?php 
	           $item_token= '';
	           if(isset($val['item_size_id'])){
	           	  $item_token = $val['sku'];
	           	  
echo '<input type="hidden" name="item_size_id[]" value="' . htmlspecialchars($val['item_size_id'], ENT_QUOTES, 'UTF-8') . '" />';


	           }
	           ?>
	           
	           
		       <?php 
		       echo $this->formRadio('available['.$val['size_id'].']','',
		         $val['available']==1?true:false,
		         array(
		         'value'=>1
		        )
		       );
		       ?> 
		        
		        
	        </td>
	       
	        <td class="is_variable_prices" <?= $styles ?>>
	         <?php echo '<input type="tel" name="quantity[]" 
       value="' . (!empty($quantity[0]) ? $this->functions->normalPrettyPrice($quantity[0]) : '') . '" 
       class="form-control numeric_only" 
       required>'; ?>

	         </td>
			  <td>
	         <?php 
echo '<select name="size[]" class="form-control" required>';
foreach ($sizes as $key => $size) {
    echo '<option value="' . $key . '" ' . (isset($val['size_id']) && $val['size_id'] == $key ? 'selected' : '') . '>' . $size . '</option>';
}
echo '</select>';
?>

	         </td>
			 
	         <td>
	         <?php
echo '<input type="tel" name="price[]"  value="' . (!empty($val['price']) ? $this->functions->normalPrettyPrice($val['price']) : '') . '" class="form-control numeric_only" required>';
?>

	         </td>
	         
	         
	         <td>
	         <?php
echo '<input type="tel" name="cost[]"  value="' . (!empty($val['cost_price']) ? $this->functions->normalPrettyPrice($val['cost_price']) : '') . '" class="form-control numeric_only">';
?>

	         </td>
	         
	         <td>
	         <?php
echo '<input type="tel" name="in_stock[]"  value="' . (isset($val['available_stocks']) ? $this->InventoryWrapper->prettyQuantity($val['available_stocks']) : '') . '" class="form-control">';
?>

	         </td>
	         
	         <td>
	         <?php
echo '<input type="tel" name="low_stock[]"  value="' . (isset($val['low_stock']) ? $this->InventoryWrapper->prettyQuantity($val['low_stock']) : '') . '" class="form-control">';
?>

	         </td>
	         
	         <td>
	         <?php
echo '<input type="tel" name="sku[]"  value="' . (!empty($val['sku']) ? $val['sku'] : $sku) . '" class="form-control" ' . (isset($val['sku']) ? 'readonly' : '') . '>';
?>

	         </td>
	         
	         <td>
	         
	         <a href="javascript:;" data-id="<?php echo $item_token?>" class="size_delete btn btn-link" style="font-size:25px;">
			    <i class="fas fa-trash"></i>
			 </a>   	         
	         </td>	         
	        </tr>
	        <?php endforeach;?>
	        
	        <?php else :?>
	        
	        <tr> 
	        <td>
	        	           
		      <?php 
		      echo $this->formRadio('available[]','',true,
		      array(
		         'value'=>1
		        )
		      );
		      ?>
	        </td>
	        
			
			 <td class="is_variable_prices" <?= $styles ?>>
	         <?php
echo '<input type="tel" name="quantity[]"  value="" class="form-control numeric_only" required>';
?>

	         </td>
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
	         <td>
			 
	         <?php
echo '<select name="size[]"  class="form-control" required>';
foreach ($sizes as $key => $value) {
    echo '<option value="' . htmlspecialchars($key) . '">' . htmlspecialchars($value) . '</option>';
}
echo '</select>';
?>

	         </td>
	         <td>
	         <?php
echo '<input type="tel" name="price[]"  class="form-control numeric_only" required>';
?>

	         </td>
	         
	         
	         <td>
    <input type="tel" name="cost[]"  class="form-control numeric_only">
</td>

<td>
    <input type="tel" name="in_stock[]"  class="form-control">
</td>

	         
	         <td>
    <input type="tel" name="low_stock[]"  class="form-control">
</td>

<td>
    <input type="tel" name="sku[]"  value="<?php echo $sku; ?>" class="form-control">
</td>

	         
	         <td>
	         
	         <a href="javascript:;" class="size_delete btn btn-link" style="font-size:25px;">
			    <i class="fas fa-trash"></i>
			 </a>   	         
	         </td>	         
	         </tr>
	         <?php endif;?>
	         	        
	       </tbody>
	       
	       <tfoot class="showsdatas" <?= $styles2?>>
	        <tr>
	         <td colspan="4">
	         
	         <a href="javascript:;" class="size_add_new_row btn btn-primary">
			    <i class="ion-plus"></i> <?php echo "NEW ROW"?>
			 </a>   
	         
	         </td>
	        </tr>
	       </tfoot>
	      </table>
		<?php
		$forms = ob_get_contents();
        ob_end_clean();	
        return $forms;
	}
	
	public  function withSizeFormTR($merchant_id='')
	{
		$sku = $this->ItemWrap->autoGenerateSKU();		
		//$sku=$merchant_id.'-'.$sku;
		$sizes = (array)$this->ItemWrap->dropdownFormat((array)$this->ItemWrap->getSizes($merchant_id),'size_id','size_name');
		ob_start();		
		//dump($row_count);	
		?>
		 <tr> 
	        <td>
	        	           
		      <?php 
		      echo $this->formRadio('available[]','',true,
		      array(
		         'value'=>1
		        )
		      );
		      ?>
	        </td>
	        
	        <td>
    <select name="size[]"  class="form-control" required>
        <?php foreach ($sizes as $key => $value) : ?>
            <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
        <?php endforeach; ?>
    </select>
</td>
<td>
    <input type="tel" name="price[]"  class="form-control numeric_only" required value="">
</td>

<td>
    <input type="tel" name="cost[]"  class="form-control numeric_only" value="">
</td>

	         
	            <td>
    <input type="tel" name="in_stock[]"  class="form-control" value="">
</td>

<td>
    <input type="tel" name="low_stock[]"  class="form-control" value="">
</td>

	         
	        <td>
    <input type="tel" name="sku[]"  class="form-control" value="<?php echo $sku; ?>">
</td>

	         
	         <td>
	         
	         <a href="javascript:;" class="size_delete btn btn-link" style="font-size:25px;">
			    <i class="fas fa-trash"></i>
			 </a>   	         
	         </td>	         
	         </tr>
		<?php
		$forms = ob_get_contents();
        ob_end_clean();	
        return $forms;
	}
	
	public  function generateFormField($data=array())
	{
		$html='';
		if(is_array($data) && count($data)>=1){
			foreach ($data as $val) {								
				$html.=$this->formTextField($val[0],$val[1],$val[2], isset($val[3])?$val[3]:false );
			}			
		}
		return $html;
	}
	
	public function formTextField($field_name = '', $label = '', $value = '', $required = false, $class = '', $placeholder = '')
{
    ob_start();
    ?>
    <div class="form-group">
        <label for="<?php echo $field_name; ?>"><?php echo $label; ?></label>
        <input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" 
               value="<?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>" 
               class="form-control <?php echo $class; ?>" 
               <?php echo $required ? 'required' : ''; ?> 
               placeholder="<?php echo htmlspecialchars($placeholder, ENT_QUOTES, 'UTF-8'); ?>">
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}

	
	public function formTextField2($field_name = '', $label = '', $value = '', $options = array())
{
    ob_start();
    ?>
    <div class="form-group">
        <label for="<?php echo $field_name; ?>"><?php echo $label; ?></label>
        <input type="text" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>"
               value="<?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>"
               <?php 
               foreach ($options as $key => $val) {
                   echo $key . '="' . htmlspecialchars($val, ENT_QUOTES, 'UTF-8') . '" ';
               }
               ?>>
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}


	public function formRadio($field_name = '', $label = '', $selected = false, $options = array())
{
    ob_start();
    ?>
    <div class="checkbox">
        <label>
            <input type="checkbox" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" 
                   <?php echo $selected ? 'checked' : ''; ?>
                   <?php 
                   foreach ($options as $key => $val) {
                       echo $key . '="' . htmlspecialchars($val, ENT_QUOTES, 'UTF-8') . '" ';
                   }
                   ?>>
            <span class="checkbox-decorator">
                <span class="check"></span>
                <div class="ripple-container"></div>
            </span>
            &nbsp;<?php echo $label; ?>
        </label>
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}

	
	public function checkboxInline($field_name = '', $label = '', $selected = false, $options = array())
{
    ob_start();
    ?>
    <label class="checkbox-inline">
        <input type="checkbox" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>" 
               <?php echo $selected ? 'checked' : ''; ?>
               <?php 
               foreach ($options as $key => $val) {
                   echo $key . '="' . htmlspecialchars($val, ENT_QUOTES, 'UTF-8') . '" ';
               }
               ?>>
        <span class="checkbox-decorator">
            <span class="check"></span>
            <div class="ripple-container"></div>
        </span>
        <?php echo $label; ?>
    </label>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}

	
public function formSwitch($field_name = '', $label = '', $selected = false, $options = array())
{
    ob_start();
    ?>
    <div class="switch">
        <label>
            <input type="checkbox" name="<?php echo $field_name; ?>" id="<?php echo $field_name; ?>"
                   <?php echo $selected ? 'checked' : ''; ?>
                   <?php 
                   foreach ($options as $key => $val) {
                       echo $key . '="' . htmlspecialchars($val, ENT_QUOTES, 'UTF-8') . '" ';
                   }
                   ?>>
            <span class="bmd-switch-track">
                <div class="ripple-container"></div>
            </span>
            &nbsp;<?php echo $label; ?>
        </label>
    </div>
    <?php
    $forms = ob_get_contents();
    ob_end_clean();
    return $forms;
}

	
	public  function cancelBtnClass()
	{
		return 'btn btn-raised';
	}
	
	public  function deleteBtnClass()
	{
		return 'btn btn-raised btn-danger';
	}
	
	public  function saveBtnClass()
	{
		return 'btn btn-raised btn-primary';
	}
	
	public  function newBtnClass()
	{
		return 'btn btn-raised btn-info';
	}
	
	public  function refreshBtnClass()
	{
		return 'btn btn-raised';
	}
	
	public  function filterBtnClass()
	{
		return 'btn btn-raised btn-primary';
	}
	
}
/*end class*/