<?php
class ItemWrap
{

  public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
     //echo 'Before Model::getInstance(): ' . memory_get_usage() . PHP_EOL;
        $model = Model::getInstance();
        

        $this->db = $model->getDb();
        //echo 'After Model::getInstance(): ' . memory_get_usage() . PHP_EOL;

        $this->functions = new Functions();
        

 //echo 'After Functions instantiation: ' . memory_get_usage() . PHP_EOL;die();
       
        

    }


    public function getItemBySku($merchant_id='', $sku='')
{
    // Prepare the SQL query
    $stmt = "SELECT * FROM mt_view_item 
             WHERE merchant_id = :merchant_id AND sku = :sku
             LIMIT 1";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindValue(':merchant_id', $merchant_id);
    $query->bindValue(':sku', $sku);

    // Execute the query
    $query->execute();

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    
    return false;
}


public function searchItem($merchant_id = '', $item_name = '', $track_stock = '')
{
    $query = "SELECT merchant_id, item_id, item_name, sku, size_name, item_size_id, cost_price, available_stocks, incoming_balance 
              FROM mt_view_item_stocks";
    $params = [':merchant_id' => $merchant_id];
    
    // Build WHERE clause
    if (!empty($item_name)) {
        $where = "WHERE merchant_id = :merchant_id AND item_name LIKE :item_name";
        $params[':item_name'] = "%$item_name%";
    } else {
        $where = "WHERE merchant_id = :merchant_id";
    }

    // Add track_stock condition if needed
    if ($track_stock == 1) {
        $where .= " AND track_stock = :track_stock";
        $params[':track_stock'] = 1;
    }

    // Combine query and conditions
    $query .= " $where ORDER BY item_name ASC";

    try {
        $stmt = $this->db->prepare($query);
        $stmt->execute($params);
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $resp ? $resp : false;
    } catch (PDOException $e) {
        // Handle error (e.g., log it)
        return false;
    }
}


public  function inlineUpdatePrice($merchant_id=0, $item_id=0,$params1=array(), $params2=array())
    {
         

         

         $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
$whereValues = array(
    ':item_id' => $item_id,
    ':merchant_id' => $merchant_id,
);

$up=$this->functions->updateData_multiple('mt_item', $params1, $whereConditions, $whereValues);


          if($up){
             
             

             $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
$whereValues = [
    ':item_id' => $item_id,
    ':merchant_id' => $merchant_id,
];

$up=$this->functions->updateData_multiple('mt_item_relationship_size', $params2, $whereConditions, $whereValues);



              if($up){
                return true;
              } else throw new Exception( "Failed cannot update records" );
          
          } else throw new Exception( "Failed cannot update records" );
    }


public function inlineUpdatePriceBySku($merchant_id = '', $sku = '', $new_price = 0)
{
    if ($sku > 0) {
        // Prepare the SELECT query

        $stmt = "
            SELECT 
                a.item_id, 
                a.size_id,
                b.price 
            FROM 
                mt_item_relationship_size a
            LEFT JOIN mt_item b
            ON
                a.item_id = b.item_id
            WHERE
                a.sku = :sku        
            LIMIT 0, 1
        ";

        // Execute the query
        $query = $this->db->prepare($stmt);
        $query->bindValue(':sku', $sku, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            
            $params = [
                'price' => (float)$new_price,
                'updated_at' => $this->functions->dateNow(),
            ];

            $whereConditions = 'sku = :sku AND merchant_id = :merchant_id';
            $whereValues = [
                ':sku' => $sku,
                ':merchant_id' => $merchant_id,
            ];

            // Update the mt_item_relationship_size table
            $up = $this->functions->updateData_multiple('mt_item_relationship_size', $params, $whereConditions, $whereValues);
            
            if ($up) {
                if (is_array($price = json_decode($res['price'], true))) {
                    if (array_key_exists($res['size_id'], (array)$price)) {
                        $price[$res['size_id']] = (float)$new_price;

                        $params2 = [
                            'price' => json_encode($price),
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        ];

                        $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
                        $whereValues = [
                            ':item_id' => $res['item_id'],
                            ':merchant_id' => $merchant_id,
                        ];
                        
                        // Update the mt_item table
                        $up = $this->functions->updateData_multiple('mt_item', $params2, $whereConditions, $whereValues);
                    }
                }
                return true;
            } else {
                throw new Exception("Failed: cannot update records");
            }
        } else {
            throw new Exception("Record not found");
        }
    } else {
        throw new Exception("Invalid SKU number");
    }
}







public function autoGenerateSKU()
{
    // Prepare the SQL statement to show the table status for 'mt_item_sku'
    $stmt = "SHOW TABLE STATUS LIKE 'mt_item_sku'";

    // Prepare and execute the query using PDO
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // If the result is found, return the Auto_increment value
    if ($res) {
        return $res['Auto_increment'];
    }

    return false;
}


public function autoFillItem($merchant_id = '', $supplier_id = 0, $type = '')
{
    $and = '';
    if ($type == "lowstock") {         
        $and .= " AND low_stock >= available_stocks";
    }
    
    $stmt = "
        SELECT merchant_id, item_id, item_name, sku, size_name, item_size_id, cost_price, available_stocks, incoming_balance
        FROM mt_view_item_stocks
        WHERE
        merchant_id = :merchant_id
        AND
        supplier_id = :supplier_id
        $and
    ";
    
    try {
        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindValue(':supplier_id', $supplier_id, PDO::PARAM_INT);
        $query->execute();
        
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        } else {
            throw new Exception("No records found");
        }
    } catch (PDOException $e) {
        throw new Exception("Database error: " . $e->getMessage());
    }
}





public  function dropdownFormat($data=array(),$value='', $label='')
    {
        $list = array();
        $list['']='';
        if(is_array($data) && count($data)>=1){
            foreach ($data as $val) {
                if(isset($val[$value]) && isset($val[$label])){
                   $list[ $val[$value] ] = $val[$label];
                }
            }
        }
        return $list;
    }

    public function deleteItemSizeBySku($merchant_id = '', $item_token = '')
{
    try {
        $stmt = $this->db->prepare("
            DELETE FROM mt_item_relationship_size
            WHERE merchant_id = :merchant_id AND sku = :sku
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
        $stmt->bindParam(':sku', $item_token, PDO::PARAM_STR);

        if ($stmt->execute()) {
            return true;
        } else {
            throw new Exception("Failed, cannot delete records");
        }
    } catch (PDOException $e) {
        throw new Exception("Database error: " . $e->getMessage());
    }
}




    public function getAddonCategory($merchant_id = '', $status = 'publish')
{
    // Prepare the SQL query
    $sql = "SELECT subcat_id, subcategory_name, subcategory_name_trans, status 
            FROM mt_subcategory 
            WHERE merchant_id = :merchant_id AND status = :status 
            ORDER BY sequence ASC";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Execute the statement with bound parameters
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':status' => $status
    ]);

    // Fetch all the results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    
    return false;
}






    public function getData($table = '', $where = '', $where_val = array())
{
    // Prefix the table name
    $table = "mt_" . $table;

    // Construct the SQL query
    $sql = "SELECT * FROM {$table} WHERE {$where} LIMIT 1";

    // Prepare the query
    $stmt = $this->db->prepare($sql);

    // Execute the query with bound parameters (if any)
    if ($stmt->execute($where_val)) {
        // Fetch the result as an associative array
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($resp) {
            return $resp;
        } else {
            throw new Exception("Record not found");
        }
    } else {
        throw new Exception("Error executing query");
    }
}



   public function getSizes($merchant_id='', $status='publish')
{
    // Prepare the SQL query
    $stmt = "SELECT size_id, size_name, size_name_trans, status
             FROM mt_size
             WHERE merchant_id = :merchant_id AND status = :status
             ORDER BY sequence ASC";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':status', $status, PDO::PARAM_STR);

    // Execute the query and fetch all results
    $query->execute();
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    // Return the results or false if no data is found
    if ($resp) {
        return $resp;
    }
    return false;
}


public function getCategory($merchant_id = '', $status = 'publish')
{

    
    $stmt = "
    SELECT cat_id, category_name, category_description, status
    FROM mt_category
    WHERE merchant_id = :merchant_id 
    ORDER BY sequence ASC
    ";

    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
   // $query->bindParam(':status', $status, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}

public function getCookingRef($merchant_id = '', $status = 'publish')
{
    // Prepare the SQL query
    $sql = "SELECT cook_id, cooking_name, cooking_name_trans, status 
            FROM mt_cooking_ref 
            WHERE merchant_id = :merchant_id AND status = :status 
            ORDER BY sequence ASC";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Execute the statement with bound parameters
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':status' => $status
    ]);

    // Fetch all the results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    
    return false;
}

public function check_item_by_name($name = '')
{
    // Prepare the SQL query
    $sql = "SELECT * 
            FROM mt_item 
            WHERE item_name = :item_name";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Execute the statement with the bound parameter
    $stmt->execute([
        ':item_name' => $name
    ]);

    // Fetch all the results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp; // Return the results if found
    }
    
    return false; // Return false if no results are found
}

public function check_item_by_name_and_merchant($name = '', $merchant_id = '')
{
    $sql = "SELECT item_id 
            FROM mt_item 
            WHERE item_name = :item_name 
              AND merchant_id = :merchant_id
            LIMIT 1";

    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':item_name'   => $name,
        ':merchant_id' => $merchant_id
    ]);

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    return $resp ? $resp : false;
}


public function checklskualready($merchant_id='',$params=array(), $item_id='',$raw_data=array())
    {   
                if(isset($raw_data['sku']) && !empty($raw_data['sku'])){
                    
                    
                        if(is_array($raw_data['sku']) && count($raw_data['sku'])>=1){
                            
                        $raw_data['sku'][0]=$merchant_id.'-'.$raw_data['sku'][0];
                    }else{

$raw_data['sku']=$merchant_id.'-'.$raw_data['sku'];                 }
                        
                    }
                        
                
                $skus=$this->prepareCheckSKUexist_bulk_sku(
                  isset($raw_data['sku'])?$raw_data['sku']:''
                );      

                return $skus;
                        
        
    } 


    public  function prepareCheckSKUexist_bulk_sku($data='',$item_id='', $size='')
    {       
        if(is_array($data) && count($data)>=1){
            foreach ($data as $key=>$sku) {                             
                if($datas=$this->checkSKUexist_bulk_sku_sku($sku,$item_id, isset($size[$key])?$size[$key]:'' )){                 
                    return $datas;              
                }else{return true;}
            }
        } else {
            if($datas=$this->checkSKUexist_bulk_sku_sku($data,$item_id)){
                return $datas;      
            }else{return true;}
        }
    }


   public function checkSKUexist_bulk_sku_sku($sku = '', $item_id = '', $size_id = 0)
{
    try {
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_item_relationship_size 
            WHERE sku = :sku
            LIMIT 1
        ");
        $stmt->bindParam(':sku', $sku, PDO::PARAM_STR);
        $stmt->execute();
        
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}


public function bulkinsertFood($merchant_id = '', $params = array(), $item_id = '', $raw_data = array())
{
    try {
        if (isset($raw_data['sku']) && !empty($raw_data['sku'])) {
            if (is_array($raw_data['sku']) && count($raw_data['sku']) >= 1) {
                $raw_data['sku'][0] = $merchant_id . '-' . $raw_data['sku'][0];
            } else {
                $raw_data['sku'] = $merchant_id . '-' . $raw_data['sku'];
            }
        }

        if ($item_id > 0) {
              $rand=rand(0,10);
  //$_SESSION['params'][$rand]=$params;
                 $_SESSION['rawdata3'][$rand]=$raw_data;
                  $_SESSION['itemid'][$rand]=$item_id;
            // Check for existing item name with different item_id
            $stmt1 = $this->db->prepare("
                SELECT item_name 
                FROM mt_item 
                WHERE merchant_id = :merchant_id 
                  AND item_name = :item_name 
                  AND item_id <> :item_id 
                LIMIT 1
            ");
            $stmt1->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
            $stmt1->bindParam(':item_name', $params['item_name'], PDO::PARAM_STR);
            $stmt1->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $stmt1->execute();
            $resp = $stmt1->fetch(PDO::FETCH_ASSOC);

            if (!$resp || 1 == 1) {
                $this->prepareCheckSKUexist_bulk(
                    isset($raw_data['sku']) ? $raw_data['sku'] : '',
                    $item_id,
                    isset($raw_data['size']) ? $raw_data['size'] : ''
                );
                $rand=rand();
                $up = $this->functions->updateData("mt_item", $params, 'item_id', $item_id);
               // $_SESSION['params'][$rand]=$params;
               //  $_SESSION['rawdata'][$rand]=$raw_data;
                //  $_SESSION['itemid'][$rand]=$item_id;

                if ($up) {
                    $this->InsertItemSize($merchant_id, $item_id, $raw_data, true);
                    $this->InsertItemCategoryRelationship($merchant_id, $item_id, $raw_data);
                    $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                    return true;
                } else {
                    throw new Exception("Failed cannot update records");
                }
            } else {
                throw new Exception("Food name already exist");
            }
        } else {
            // Check for existing item name
            $stmt2 = $this->db->prepare("
                SELECT item_name 
                FROM mt_item 
                WHERE merchant_id = :merchant_id 
                  AND item_name = :item_name 
                LIMIT 1
            ");
            $stmt2->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
            $stmt2->bindParam(':item_name', $params['item_name'], PDO::PARAM_STR);
            $stmt2->execute();
            $resp = $stmt2->fetch(PDO::FETCH_ASSOC);

            if (!$resp || 1 == 1) {
                $skus = $this->prepareCheckSKUexist_bulk(
                    isset($raw_data['sku']) ? $raw_data['sku'] : ''
                );

                if ($skus) {
                    $last_insert_id = $this->functions->insertData('mt_item', $params);
                    if ($last_insert_id !== false) {
                        $last_id = $last_insert_id;
                     $rand=rand(0,10);
  //$_SESSION['params'][$rand]=$params;
                 //$_SESSION['rawdata2'][$rand]=$raw_data;
                 // $_SESSION['itemid'][$rand]=$last_id;
                        $this->InsertItemSize($merchant_id, $last_id, $raw_data, true);
                        $this->InsertItemCategoryRelationship($merchant_id, $last_id, $raw_data);
                        $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                        return true;
                    }
                } else {
                    return "SKU Already exists";
                }
            } else {
                return "Food name already exist";
            }
        }
    } catch (Exception $e) {
        // Handle exception if needed
        return false;
    }
}


    public  function prepareCheckSKUexist_bulk($data='',$item_id='', $size='')
    {       
        if(is_array($data) && count($data)>=1){
            foreach ($data as $key=>$sku) {                             
                if($this->checkSKUexist_bulk($sku,$item_id, isset($size[$key])?$size[$key]:'' )){                    
                    return false;               
                }else{return true;}
            }
        } else {
            if($this->checkSKUexist_bulk($data,$item_id)){
                return false;
            }else{return true;}
        }
    }


 public function checkSKUexist_bulk($sku = '', $item_id = '', $size_id = 0)
{
    try {
        $resp = false;

        if ($item_id > 0) {
            // First query to get item_size_id
            $stmt1 = $this->db->prepare("
                SELECT item_size_id 
                FROM mt_item_relationship_size 
                WHERE item_id = :item_id AND size_id = :size_id 
                LIMIT 1
            ");
            $stmt1->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $stmt1->bindParam(':size_id', $size_id, PDO::PARAM_INT);
            $stmt1->execute();

            $res = $stmt1->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                // Second query to check SKU
                $stmt2 = $this->db->prepare("
                    SELECT sku 
                    FROM mt_item_relationship_size 
                    WHERE sku = :sku AND item_size_id <> :item_size_id 
                    LIMIT 1
                ");
                $stmt2->bindParam(':sku', $sku, PDO::PARAM_STR);
                $stmt2->bindParam(':item_size_id', $res['item_size_id'], PDO::PARAM_INT);
                $stmt2->execute();

                $resp = $stmt2->fetch(PDO::FETCH_ASSOC);
            }
        } else {
            // Query when $item_id is not greater than 0
            $stmt3 = $this->db->prepare("
                SELECT sku 
                FROM mt_item_relationship_size 
                WHERE sku = :sku 
                LIMIT 1
            ");
            $stmt3->bindParam(':sku', $sku, PDO::PARAM_STR);
            $stmt3->execute();

            $resp = $stmt3->fetch(PDO::FETCH_ASSOC);
        }

        if ($resp) {
            return true;
        }

        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}










public function getIngredients($merchant_id = '', $status = 'publish')
{
    // Prepare the SQL query
    $sql = "SELECT ingredients_id, ingredients_name, ingredients_name_trans, status
            FROM mt_ingredients
            WHERE merchant_id = :merchant_id AND status = :status
            ORDER BY sequence ASC";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Execute the statement with bound parameters
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':status' => $status
    ]);

    // Fetch all the results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}


public function getDish()
{
    // Prepare the SQL query
    $sql = "SELECT * FROM mt_dishes";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Execute the statement
    $stmt->execute();

    // Fetch all the results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}

public  function setForm($field_label=array(),$field_name=array(),$data=array(),
    $required=array(),$field_type=array(), $field_default_value=array() )
    {
        $multi_lang = false;
        
        if($multi_lang){
                
        } else {
            $fields['default'] = 'default';
        }
        $x=1;       
        ?>
        
        <ul class="nav nav-tabs" id="tab_settings" role="tablist">   
          <?php foreach ($fields as $key=>$val):?>
          <li class="nav-item" <?php echo $multi_lang!=true?'style="display:none;"':'';?> >
            <a class="nav-link <?php echo $x==1?"active":''?>" data-toggle="tab" 
            href="#nav_<?php echo $key?>" role="tab" aria-selected="false">
             <?php echo ($val)?>
            </a>
          </li> 
          <?php $x++;?>
          <?php endforeach;?>   
        </ul>
     
        
        <?php 
        $data_json = array();
        if(is_array($data) && count($data)>=1){
            if($multi_lang){
                foreach ($field_name as $field_key=>$field_id){
                    if(isset($data[$field_id."_trans"])){
                       $data_json[$field_id."_trans"] = json_decode($data[$field_id."_trans"],true);
                    }
                }
            }
        }               
        ?>    
        
        <?php $x=1;?>
       <div class="tab-content" >
         <?php foreach ($fields as $key=>$val):?>
          <div class="tab-pane fade <?php echo $x==1?"active show":''?>" id="nav_<?php echo $key?>" role="tabpanel">
          <?php foreach ($field_name as $field_key=>$field_id):?>
          <?php 
          $selected_value = '';
          if($key!="default"){
             $field_names = $field_id."_trans[$key]";
             if(array_key_exists($field_id."_trans",(array)$data_json)){
                $selected_value = isset($data_json[$field_id."_trans"][$key])?$data_json[$field_id."_trans"][$key]:'';
             }
          } else {
            $field_names = $field_id;
            $selected_value = array_key_exists($field_names,(array)$data)?$data[$field_names]:'';
          }       
          ?>
          <div class="form-group">        
            <label for="<?php echo $field_names;?>" class="bmd-label-static">
              <?php echo isset($field_label[$field_key])? ($field_label[$field_key]) :'';?>
            </label>  
           <?php 
           
           $_field_type =  isset($field_type[$field_key])?$field_type[$field_key]:'text';
           
           switch ($_field_type) {
            case "list":
    $options = isset($field_default_value[$field_key]) ? $field_default_value[$field_key] : array();
    $placeholder = isset($field_label[$field_key]) ? $field_label[$field_key] : '';
    $isRequired = $required[$field_key] == 1 ? 'required' : '';
    
    echo '<select name="' . htmlspecialchars($field_names) . '" id="' . htmlspecialchars($field_names) . '" class="form-control" ' . $isRequired . ' placeholder="' . htmlspecialchars($placeholder) . '">';
    
    foreach ($options as $value => $label) {
        $isSelected = ($value == $selected_value) ? 'selected' : '';
        echo '<option value="' . htmlspecialchars($value) . '" ' . $isSelected . '>' . htmlspecialchars($label) . '</option>';
    }
    
    echo '</select>';
    break;

                
           case "hidden":      
    echo '<input type="hidden" name="' . htmlspecialchars($field_names) . '" id="' . htmlspecialchars($field_names) . '" value="' . htmlspecialchars($selected_value) . '">';
    break;

case "textarea":
    $placeholder = isset($field_label[$field_key]) ? $field_label[$field_key] : '';
    $isRequired = $required[$field_key] == 1 ? 'required' : '';
    
    echo '<textarea name="' . htmlspecialchars($field_names) . '" id="' . htmlspecialchars($field_names) . '" class="form-control" placeholder="' . htmlspecialchars($placeholder) . '" ' . $isRequired . ' readonly>';
echo htmlspecialchars($selected_value);
echo '</textarea>';

    break;

           
            default:
    $placeholder = isset($field_label[$field_key]) ? $field_label[$field_key] : '';
    $isRequired = $required[$field_key] == 1 ? 'required' : '';
    
    echo '<input type="text" name="' . htmlspecialchars($field_names) . '" id="' . htmlspecialchars($field_names) . '" value="' . htmlspecialchars($selected_value) . '" class="form-control" placeholder="' . htmlspecialchars($placeholder) . '" ' . $isRequired . ' readonly>';

    break;

           }            
            ?>
          </div> 
          <?php endforeach;?>
           
          
          </div>            
          <?php $x++;?> 
          <?php endforeach;?> 
       </div>
     
        <?php
                
    }



    public function setStatusList($data = array())
{
    ?>
    <div class="form-group" style="padding-left:7px;padding-right:7px;">
        <select name="status" id="status" class="form-control" required>
            <?php 
            $statusList = $this->functions->statusList();
            $selectedStatus = isset($data['status']) ? $data['status'] : "";

            foreach ($statusList as $key => $value) {
                $isSelected = ($key == $selectedStatus) ? 'selected' : '';
                echo '<option value="' . htmlspecialchars($key) . '" ' . $isSelected . '>' . htmlspecialchars($value) . '</option>';
            }
            ?>
        </select>
    </div>
    <?php
}

public function getItemSizePricesWithStocks($merchant_id='', $item_id='')
{
    // Prepare the SQL query
    $sql = "SELECT * FROM mt_view_item_stocks WHERE merchant_id = :merchant_id AND item_id = :item_id ORDER BY item_size_id ASC";
    
    // Prepare the statement using the db connection
    $stmt = $this->db->prepare($sql);
    
    // Bind the parameters
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch all results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if any results are returned
    if ($resp) {
        return $resp;
    }
    
    return false;
}


public function getItemSizePrice($merchant_id='', $item_id='')
{
    // Prepare the SQL query with a LIMIT of 1
    $sql = "SELECT * FROM mt_item_relationship_size WHERE merchant_id = :merchant_id AND item_id = :item_id LIMIT 1";
    
    // Prepare the statement using the db connection
    $stmt = $this->db->prepare($sql);
    
    // Bind the parameters
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch a single row (since limit 1 is applied)
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if a result was returned
    if ($resp) {
        return $resp;
    }
    
    return false;
}


public function getMaxSequence($table = '', $merchant_id = '', $field = 'sequence')
{
    $where = '';
    if ($merchant_id > 0) {
        $where = " WHERE merchant_id = :merchant_id";
    }
    $table = "mt_" . $table;
    $stmt = "SELECT MAX($field) as max FROM $table $where";

    try {
        $query = $this->db->prepare($stmt);

        // Bind parameters if merchant_id is provided
        if ($merchant_id > 0) {
            $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        }

        $query->execute();

        if ($resp = $query->fetch(PDO::FETCH_ASSOC)) {
            return $resp['max'] > 0 ? $resp['max'] + 1 : 1;
        } else {
            return 1;
        }
    } catch (PDOException $e) {
        // Handle exception if needed
        throw new Exception("Database error: " . $e->getMessage());
    }
}

public function insertFood($merchant_id = '', $params = array(), $item_id = '', $raw_data = array())
{
    $string = $merchant_id . '-';

    // Append merchant_id to SKU if not already present
    $counts = 0;
    if (is_array($raw_data['sku']) && count($raw_data['sku']) >= 1) {
        foreach ($raw_data['sku'] as $skus) {
            $arrays = $skus;
            if (!preg_match("/$string/i", $arrays)) {
                $raw_data['sku'][$counts] = $string . $skus;
            }
            $counts++;
        }
    } else {
        if (!preg_match("/$string/i", $raw_data['sku'])) {
            $raw_data['sku'] = $string . $raw_data['sku'];
        }
    }

    if ($item_id > 0) {
        // Check if food name exists for update
        $stmt = $this->db->prepare("
            SELECT item_name 
            FROM mt_item 
            WHERE merchant_id = :merchant_id 
              AND item_name = :item_name 
              AND item_id <> :item_id 
            LIMIT 1
        ");
        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':item_name'   => $params['item_name'],
            ':item_id'     => $item_id,
        ]);

        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$resp || 1 == 1) {
            $this->prepareCheckSKUexist(
                isset($raw_data['sku']) ? $raw_data['sku'] : '',
                $item_id,
                isset($raw_data['size']) ? $raw_data['size'] : ''
            );

            $up = $this->functions->updateData('mt_item', $params, 'item_id', $item_id);

            if ($up) {
                $this->InsertItemSize($merchant_id, $item_id, $raw_data);
                $this->InsertItemCategoryRelationship($merchant_id, $item_id, $raw_data);
                $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                return true;
            } else {
                throw new Exception("Failed cannot update records");
            }
        } else {
            throw new Exception("Food name already exist");
        }
    } else {
        // Check if food name exists for insert
        $stmt = $this->db->prepare("
            SELECT item_name 
            FROM mt_item 
            WHERE merchant_id = :merchant_id 
              AND item_name = :item_name 
            LIMIT 1
        ");
        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':item_name'   => $params['item_name'],
        ]);

        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            $this->prepareCheckSKUexist(isset($raw_data['sku']) ? $raw_data['sku'] : '');

            $last_insert_id = $this->functions->insertData('mt_item', $params);

            if ($last_insert_id !== false) {
                $last_id = $last_insert_id;

                $this->InsertItemSize($merchant_id, $last_id, $raw_data, true);
                $this->InsertItemCategoryRelationship($merchant_id, $last_id, $raw_data);
                $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                return true;
            } else {
                throw new Exception("Failed cannot insert records");
            }
        } else {
            throw new Exception("Food name already exist");
        }
    }

    throw new Exception("An error has occurred");
}

public  function InsertItemRelationshipSubcategory($merchant_id='', $item_id='', $data=array())
    {
        $this->functions->deleteItemRelationshipSubcategory($merchant_id,$item_id);
        if(isset($data['sub_item_id'])){
            if(is_array($data['sub_item_id']) && count($data['sub_item_id'])>=1){
                foreach ($data['sub_item_id'] as $subcat_id=>$val) {
                    $params=array(
                      'merchant_id'=>$merchant_id,
                      'item_id'=>$item_id,
                      'subcat_id'=>$subcat_id
                    );
                   
                    $i = $this->functions->insertData("mt_item_relationship_subcategory",$params);
                }
            }
        }
    }


public  function InsertItemCategoryRelationship($merchant_id='', $item_id='', $data=array())
    {
        $this->deleteCategoryRelationship($merchant_id,$item_id);
        if(isset($data['category'])){
            if(is_array($data['category']) && count($data['category'])>=1){
                foreach ($data['category'] as $cat_id) {
                    $params = array(
                      'merchant_id'=>$merchant_id,
                      'item_id'=>$item_id,
                      'cat_id'=>$cat_id,
                    );
                    
                    $i = $this->functions->insertData("mt_item_relationship_category",$params);
                }
            }
        }
    }


    public function deleteCategoryRelationship($merchant_id = '', $item_id = '')
{
    try {
        // Prepare the DELETE statement
        $stmt = $this->db->prepare("
            DELETE FROM mt_item_relationship_category 
            WHERE merchant_id = :merchant_id AND item_id = :item_id
        ");
        
        // Bind the parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
        $stmt->bindParam(':item_id', $item_id, PDO::PARAM_STR);
        
        // Execute the query
        $stmt->execute();
    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
    }
}






public function prepareCheckSKUexist($data = '', $item_id = '', $size = '')
{
    if (is_array($data) && count($data) >= 1) {
        foreach ($data as $key => $sku) {
            if ($this->checkSKUexist($sku, $item_id, isset($size[$key]) ? $size[$key] : '')) {
                throw new Exception("Item with SKU: [sku] already exists " . $sku);
            }
        }
    } else {
        if ($this->checkSKUexist($data, $item_id)) {
            throw new Exception("Item with SKU: [sku] already exists " . $data);
        }
    }
}

    
   public function checkSKUexist($sku = '', $item_id = '', $size_id = 0)
{
    $resp = '';

    if ($item_id > 0) {
        // Check if item_size_id exists for the given item_id and size_id
        $stmt = $this->db->prepare("
            SELECT item_size_id 
            FROM mt_item_relationship_size 
            WHERE item_id = :item_id AND size_id = :size_id 
            LIMIT 1
        ");
        $stmt->execute([
            ':item_id' => $item_id,
            ':size_id' => $size_id,
        ]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            // Check if SKU exists and is not associated with the current item_size_id
            $stmt = $this->db->prepare("
                SELECT sku 
                FROM mt_item_relationship_size 
                WHERE sku = :sku AND item_size_id <> :item_size_id 
                LIMIT 1
            ");
            $stmt->execute([
                ':sku'          => $sku,
                ':item_size_id' => $res['item_size_id'],
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        }
    } else {
        // Check if SKU exists globally
        $stmt = $this->db->prepare("
            SELECT sku 
            FROM mt_item_relationship_size 
            WHERE sku = :sku 
            LIMIT 1
        ");
        $stmt->execute([
            ':sku' => $sku,
        ]);
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    }

    return $resp ? true : false;
}



public  function InsertItemSize($merchant_id='',$item_id='',$data=array(),$is_new=false)
    {   

        $this->StocksWrapper = new StocksWrapper();

        if(isset($data['size'])){
            $params=array();
            if(is_array($data['size']) && count($data['size'])>=1){
                foreach ($data['size'] as $size_key=>$size_id) {
                    $key_use = $size_key;
                    
                    $available_use = $size_key;
                    if(!$is_new){
                        $available_use = $size_id;
                    }
                    
                
                    $params=array(
                      'merchant_id'=>(integer)$merchant_id,
                      'item_token'=>$this->functions->generateFoodSizeToken(),
                      'item_id'=>(integer)$item_id,
                      'size_id'=>(integer)$size_id,
                      'price'=>isset($data['price'][$key_use])?(float)$data['price'][$key_use]:0,
                      'cost_price'=>isset($data['cost'][$key_use])?(float)$data['cost'][$key_use]:0,
                      'sku'=>isset($data['sku'][$key_use])?$data['sku'][$key_use]:0,
                      'available'=>isset($data['available'][$available_use])?(float)$data['available'][$available_use]:0,
                      'created_at'=>$this->functions->dateNow(),
                      'low_stock'=>isset($data['low_stock'][$key_use])?(float)$data['low_stock'][$key_use]:0,
                    );      
                    
                    $in_stock = isset($data['in_stock'][$size_key])?(float)$data['in_stock'][$size_key]:0;                  
                                
                    if($size_id>0 && $params['price']>0){
                         $item_size_id = isset($data['item_size_id'][$size_key])?(integer)$data['item_size_id'][$size_key]:0;
                        if($item_size_id>0){
                            unset($params['item_token']);
                            unset($params['created_at']);
                            $params['updated_at']=$this->functions->dateNow();
                            

                            $up = $this->functions->updateData('mt_item_relationship_size', $params, 'item_size_id', $item_size_id);


                        } else {
                          
                           $i = $this->functions->insertData("mt_item_relationship_size",$params);
                        }
                        $this->StocksWrapper->updateStocksEditItem($params['sku'],$params['cost_price'],$in_stock,$merchant_id,$_SESSION['username']);

                        $this->insertSKU();
                    }                   
                }
            }
        } else {        
            $item_size_id = isset($data['item_size_id'])?(integer)$data['item_size_id']:'';         
            $params=array(
              'merchant_id'=>$merchant_id,
              'item_token'=>$this->functions->generateFoodSizeToken(),
              'item_id'=>$item_id,            
              'price'=>isset($data['single_price'])?(float)$data['single_price']:0,
              'cost_price'=>isset($data['cost_price'])?(float)$data['cost_price']:0,
              'sku'=>isset($data['sku'])?$data['sku']:'',
              'available'=>isset($data['available'])?(integer)$data['available']:0,
              'created_at'=>$this->functions->dateNow(),           
              'low_stock'=>isset($data['low_stock'])?(float)$data['low_stock']:0,
              'size_id'=>0
            );                                  
            
            $in_stock = isset($data['in_stock'])?(float)$data['in_stock']:0;            
                        
            if($item_size_id>0){                
                unset($params['item_token']);
                unset($params['created_at']);
                $params['updated_at']=$this->functions->dateNow();


               

                $up = $this->functions->updateData('mt_item_relationship_size', $params, 'item_size_id', $item_size_id);


                 
                // DELETE OLD SIZE 
                $stmt_del = "
                DELETE FROM mt_item_relationship_size
                WHERE
                item_id = $item_id
                AND 
                size_id > 0
                ";
                $this->db->query($stmt_del);
                       
            } else {
                
                $i = $this->functions->insertData("mt_item_relationship_size",$params); 
            }
            $this->StocksWrapper->updateStocksEditItem($params['sku'], $params['cost_price'], $in_stock, $merchant_id,$_SESSION['username'] );
            $this->insertSKU();
        }
    }   



   public function insertSKU($item_id = 1)
{
    try {
        // Prepare the SQL query with a placeholder for the item ID
        $stmt = $this->db->prepare("INSERT INTO mt_item_sku (item_id) VALUES (:item_id)");
        
        // Bind the item ID to the placeholder
        $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        
        // Execute the query
        $stmt->execute();
        
        // Optional: return the number of affected rows or the last insert ID
        return $this->db->lastInsertId();
    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
    }
}
 




  













  
  
  
}
/*END CLASS*/