<?php
class ApiController extends Controller
{
	public $code=2;
	public $msg;
	public $details='';
	public $data;	
	public $merchant_id;
	public $device_uiid;
	public $merchant_token;
	
	public function __construct()
	{




			
		$this->functions = new Functions();

		
        $this->MerchantWrapper = new MerchantWrapper();
        $this->OrderWrapper = new OrderWrapper();
        $this->MapsWrapperTemp = new MapsWrapperTemp();
        $this->MerchantUserWrapper = new MerchantUserWrapper();
        $this->FoodItemWrapper = new FoodItemWrapper();
        $this->ItemClass = new ItemClass();
        $this->BookingWrapper = new BookingWrapper();
        $this->ReportsWrapper_merchantapp = new ReportsWrapper_merchantapp();
        
        
        $this->PointsProgram = new PointsProgram();
        $this->InventoryWrapper = new InventoryWrapper();
        $this->Bluetooth = new Bluetooth();
        
        
        
        $this->default_currency = $this->functions->getCurrencyCode();

		$model = Model::getInstance();
        
        $this->db = $model->getDb();

        $this->data=$_POST;
		$this->getPOSTData();
										
		$lang='en';	

		$website_timezone=$this->functions->getOptionAdmin("website_timezone");   
        date_default_timezone_set($website_timezone);


        $api_key = isset($_REQUEST['api_key'])?trim($_REQUEST['api_key']):'';        
        $api_has_key = trim($this->functions->getOptionAdmin('merchantappv2_api_hash_key'));

      

       $mc_currency = $this->functions->getCurrencyCode();
       $this->functions::$number_format['currency_symbol'] = '';

       $this->item_utility = true;
                
        if($api_has_key!=$api_key){
        	$this->msg = "invalid api hash key";
        	$this->output();
        	return false;
        }	

     



	}

	public function output()
{
    // Allow cross-origin access
    header('Access-Control-Allow-Origin: *');
    header('Content-type: application/javascript;charset=utf-8');
    
    // Prepare the response array
    $resp = array(
        'code' => $this->code,
        'msg' => $this->msg,
        'details' => $this->details,
        'get' => $_GET,
        'post' => $_POST
    );
    
    // Check if 'callback' exists in GET request, else set it to an empty string
    if (!isset($_GET['callback'])) {
        $_GET['callback'] = '';
    }
    
    // If jsonp is requested, wrap the response in the callback function
    if (isset($_GET['jsonp']) && $_GET['jsonp'] == true) {
        echo $_GET['callback'] . '(' . json_encode($resp) . ')';
    } else {
        // Otherwise, just return the JSON response
        echo json_encode($resp);
    }

    // End the script execution (optional, depending on your use case)
    exit();
}
	
	
    public function Index(){

    
		echo "API IS WORKING";
	}	

	
	
	
	public function getGETData()
	{
		$this->device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        $this->merchant_token = isset($this->data['merchant_token'])?trim($this->data['merchant_token']):'';
	}

	public function getPOSTData()
	{
		$this->device_uiid = isset($_POST['device_uiid'])?$_POST['device_uiid']:'';
        $this->merchant_token = isset($_POST['merchant_token'])?trim($_POST['merchant_token']):'';
	}


	public function checkToken()
	{
		$this->data['user_token'] = isset($this->data['user_token'])?$this->data['user_token']:'';
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			return false;
		}			
		$client_id = $res['client_id'];	
		return $client_id;
		
	}



	public function appSettings()
	{

		$set_language = $this->functions->getOptionAdmin('set_language');		
		$data = array();
		$data['dashboard_menu'] = $this->MerchantWrapper->dashboardMenu();
		$data['services'] = $this->functions->Services();	
		$data['transaction_type_list'] = array(
		  'delivery'=>"Delivery",
		  'pickup'=>"Pickup",
		  'dinein'=>"Dinein"
		);
		$data['two_flavor_options'] = $this->MerchantWrapper->twoFlavorOptions();
		$data['distance_unit'] = $this->functions->distanceOption();
		$data['tip_list'] = $this->MerchantWrapper->tipList();		
		$data['status_list']=(array)$this->functions->statusList();
		$data['voucher_type']=$this->MerchantWrapper->voucherType();
		$data['time_list_ready']=$this->MerchantWrapper->timeListReady();
		$data['reason_decline']=$this->MerchantWrapper->reasonDeclineList();
		$data['order_status_list']=$this->OrderWrapper->orderStatusList(0,true);		
		$data['options'] = $this->MerchantWrapper->getOptionsSettings();		
		$data['map_provider'] = $this->functions->getMapProvider();
		$data['default_map_location'] = array(
		  'lat'=>1,
		  'lng'=>1
		);	

		$data['timezone_list'] = $this->functions->timezoneList();	
		$data['set_language']= !empty($set_language)?$set_language:'en';
		$data['month_list']=$this->functions->ccExpirationMonth();
		$data['year_list']=$this->functions->ccExpirationYear();

		$data['bluetooth'] = array(
		  'interface_type'=>$this->Bluetooth->interfaceList(),
		  'pape_width'=>$this->Bluetooth->paperWidthList(),
		  'char_set'=>$this->Bluetooth->characterCodeList()
		);
		
		
		$data['location_message']=$this->MerchantWrapper->AcessFineLocationMessage();
		$data['multi_translation']=$this->functions->multipleField();		
		if($data['multi_translation']){
			$multi_lang = $this->functions->getLanguageList(false);
			$data['multi_lang']=$multi_lang;
		}		
		
					
		return $data;
	}


	public function getsettings()
	{		
		$this->code = 1;
		$this->msg = ("OK");


				
		$data =$this->appSettings();	


		
				
		try {

			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);	

			$resp['is_commission'] = $this->functions->isMerchantCommission( (integer)$resp['merchant_id'] );
			
			/*Custom code 11 starts */
			$resp['is_auto_print'] = $this->functions->getOption('auto_print',$resp['merchant_id']);
			$resp['is_auto_customprint_after_accept'] = $this->functions->getOption('is_auto_customprint_after_accept',$resp['merchant_id']);
			/*Custom code 11 ends */
			
			$this->code = 1; $this->msg = "OK";
			
			if( strlen($resp['pin'])>2 ){			   
			   $data['next_action']="enter_pin";	
			} else $data['next_action']="already_login";
					
			$data['merchant_info'] = $resp;			
						
			
			$device_resp = $this->MerchantUserWrapper->GetDeviceInformation($this->device_uiid);
			//$device_resp['topic_new_order'] = str_replace("/topics/","",CHANNEL_TOPIC).$resp['merchant_id'];
			//$device_resp['topic_alert'] = str_replace("/topics/","",CHANNEL_TOPIC_ALERT).$resp['merchant_id'];
			
			$device_resp['topic_new_order'] ='new_order_'.$resp['merchant_id'];
            $device_resp['topic_alert'] ='merchant_alert_'.$resp['merchant_id']; 
			
			$data['device_info']=$device_resp;	
			$close_store = 	$this->functions->getOption('merchant_close_store',$resp['merchant_id']);
			$close_store = $close_store=="yes"?1:0;
			$data['options']['merchant_close_store']=$close_store;
						
			$this->details = $data;			
											
		} catch (Exception $e) {			
			$data['next_action']="show_login";
			$this->details = $data;	
		}	
									
		$this->output();
	}

	public function reget_getsettings()
	{	
		$data = $this->appSettings();
		
		$this->code = 1; $this->msg = "OK";
		$data['next_action']="reget_getsettings";	
		$this->details = $data;				
		$this->output();
	}
	
	public function registerDevice()
	{
		$data = array();
		try {
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);				
			$params = array(
			 'id'=>$resp['id'],
			 'merchant_id'=>$resp['merchant_id'],
			 'user_type'=>$resp['user_type'],
			 'device_uiid'=>$this->device_uiid,
			 'device_id'=>isset($this->data['device_id'])?trim($this->data['device_id']):'',
			 'device_platform'=>isset($this->data['device_platform'])?trim($this->data['device_platform']):'',
			 'code_version'=>isset($this->data['code_version'])?trim($this->data['code_version']):'',
			 'status'=>"active",
			 'date_created'=>$this->functions->dateNow(),
			 'date_modified'=>$this->functions->dateNow(),
			 'last_login'=>$this->functions->dateNow(),
			 'ip_address'=>$_SERVER['REMOTE_ADDR']
			);		
			$device_resp = $this->MerchantUserWrapper->RegisteredDevice($this->device_uiid,$params);
		} catch (Exception $e) {			
			//
		}		
		$this->code = 1; $this->msg = "OK";	
		$this->details = array(
		  'next_action'=>"silent"
		);
		$this->output();
	}




	    public function appLogin()
    {       
        $username = isset($this->data['username'])?trim($this->data['username']):'';
        $password = isset($this->data['password'])?trim($this->data['password']):'';
        
        
        
        
        try {
            
            $resp = $this->MerchantUserWrapper->login($username,$password);
            $this->code = 1; $this->msg = "OK";
            $data = array();
            $data['merchant_info'] = $resp;         
            $data['next_action']="show_homepage";           
            
            $params = array(
             'id'=>$resp['id'],
             'merchant_id'=>$resp['merchant_id'],
             'user_type'=>$resp['user_type'],
             'device_uiid'=>$this->device_uiid,
             'device_id'=>isset($this->data['device_id'])?trim($this->data['device_id']):'',
             'device_platform'=>isset($this->data['device_platform'])?trim($this->data['device_platform']):'',
             'code_version'=>isset($this->data['code_version'])?trim($this->data['code_version']):'',
             'status'=>"active",
             'date_created'=>$this->functions->dateNow(),
             'date_modified'=>$this->functions->dateNow(),
             'last_login'=>$this->functions->dateNow(),
             'ip_address'=>$_SERVER['REMOTE_ADDR']
            );          
            $device_resp = $this->MerchantUserWrapper->RegisteredDevice($this->device_uiid,$params);
            $device_resp['topic_new_order'] ='new_order_'.$resp['merchant_id'];
            $device_resp['topic_alert'] ='merchant_alert_'.$resp['merchant_id'];
            $data['device_info']=$device_resp;
            
            $close_store =  $this->functions->getOption('merchant_close_store',$resp['merchant_id']);
            $close_store = $close_store=="yes"?1:0;
            $data['merchant_info']['merchant_close_store']=$close_store;

            $this->details = $data;         
            
        } catch (Exception $e) {
            $this->msg = ($e->getMessage());
        }               
        $this->output();
    }   
    
    public function forgotPassword()
    {       
        try {
            $email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
            $resp = $this->MerchantUserWrapper->getUserByEmail($email_address);            
            if($resp['status']!="active"){
                $this->msg = ("Your account is no longer active");
                $this->output();
            }
                
            $code = $this->functions->generateRandomKey(3);
            $merchant_id = $resp['merchant_id'];
            
            
            $lang="en";     
            $tpl  = $this->functions->getNotificationTemplate('merchant_forgot_password',$lang,'email',false);
            
            $this->MerchantUserWrapper->udapteLostPasswordCode($resp['user_type'],$resp['merchant_id'],$resp['id'],$code);
            
            $to = $resp['email_address'];
            
            $email_content = isset($tpl['email_content'])?$tpl['email_content']:'';
            $email_subject = isset($tpl['email_subject'])?$tpl['email_subject']:''; 
            
            $data = array(
              'code'=>$code,
              'restaurant_name'=>isset($resp['restaurant_name'])?$resp['restaurant_name']:'',
              'sitename'=>$this->functions->getOptionAdmin('website_title'),
              'siteurl'=>$this->functions->websiteUrl()
            );
            
            $email_subject = $this->functions->replaceTags($email_subject,$data);            
            $email_content = $this->functions->replaceTags($email_content,$data);            
            
            $this->functions->sendEmail($to,'',$email_subject, $email_content );
            
            $this->code =1; $this->msg = ("We have sent verification code in your email.");
            $this->details = array(
               'next_action'=>"show_forgot_change_pass",
               'email_address'=>$to
            );          
            
        } catch (Exception $e) {
            $this->msg = ($e->getMessage());
        }               
        $this->output();
    }


    public function ChangeForgotPassword()
	{		
		if(trim($this->data['new_password'])!= trim($this->data['confirm_password']) ){
			$this->msg = ("Confirm password does not match");
			$this->output();
		}
		
		$code = isset($this->data['code'])?$this->data['code']:'';
		$email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
		$new_password = isset($this->data['new_password'])?trim($this->data['new_password']):'';		
		$next_action = isset($this->data['next_action'])?trim($this->data['next_action']):'back_to_login';
		try {			
			$resp = $this->MerchantUserWrapper->getUserByEmailCode($email_address,$code);					
			if($resp['lost_password_code']==$code){
				$params = array(
				  'password'=>md5($new_password),
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);
				
				$this->MerchantUserWrapper->changePassword($resp['id'],$resp['user_type'],$params,$resp['password']);
		    
			    $this->code = 1;
			    $this->msg = ("Change password succesful");
			    $this->details = array(
			      'next_action'=>$next_action
			    );
		    
			} else $this->msg = ("Invalid verification code");
		} catch (Exception $e) {
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function getMerchantinformation()
	{
		try {
			$token = $this->MerchantUserWrapper->validateToken($this->merchant_token);
			$merchant_id = (integer)$token['merchant_id'];
			$info = $this->MerchantWrapper->getMerchantInformation($merchant_id);
			$this->code = 1; $this->msg = "ok";
			
			$cuisine = !empty($info['cuisine'])?json_decode($info['cuisine'],true):'';
			$info['cuisine']=$cuisine;
			
			$info['merchant_information'] = $this->functions->getOption('merchant_information',$merchant_id);			
			
			$this->details = array(
			  'next_action'=>"set_merchant_info",
			  'data'=>$info
			);			
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
		}				
		$this->output();
	}
		
	public function getCuisineList()
	{				
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        
		if ($resp = $this->FoodItemWrapper->getAllCuisine($page,$page_limit)){			
			
			$data = array();
			foreach ($resp as $val) {
				$data[] = array(
				  'id'=>$val['cuisine_id'],
				  'name'=>$val['cuisine_name']
				);
			}
								
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else $this->msg = ("No results");
		}
		$this->output();
	}


	public function updateMerchantInfo()
	{
		try {
			$token = $this->MerchantUserWrapper->validateToken($this->merchant_token);
			$merchant_id = (integer)$token['merchant_id'];					
			$params = array(
			  'restaurant_slug'=>isset($this->data['restaurant_slug'])?$this->data['restaurant_slug']:'',
			  'restaurant_name'=>isset($this->data['restaurant_name'])?$this->data['restaurant_name']:'',
			  'restaurant_phone'=>isset($this->data['restaurant_phone'])?$this->data['restaurant_phone']:'',
			  'contact_name'=>isset($this->data['contact_name'])?$this->data['contact_name']:'',
			  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
			  'contact_email'=>isset($this->data['contact_email'])?$this->data['contact_email']:'',
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'post_code'=>isset($this->data['post_code'])?$this->data['post_code']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'service'=>isset($this->data['service'])?$this->data['service']:'',
			  'cuisine'=>isset($this->data['cuisine'])?json_encode($this->data['cuisine']):'',
			  'is_ready'=>isset($this->data['is_ready'])?2:1,
			  'latitude'=>isset($this->data['latitude'])?$this->data['latitude']:'',
			  'lontitude'=>isset($this->data['lontitude'])?$this->data['lontitude']:'',
			);
			if (!empty($this->data['restaurant_slug'])){
				$params['restaurant_slug']=$this->functions->verifyMerchantSlug($this->functions->seo_friendly_url($this->data['restaurant_slug']),
				  $merchant_id
				);
			} else {	
			    $params['restaurant_slug']=$this->functions->createSlug($this->data['restaurant_name']);
			}
			$params['date_modified'] = $this->functions->dateNow();
			$params['ip_address'] = $_SERVER['REMOTE_ADDR'];
								
			$this->MerchantWrapper->udapteMerchantInfo($params,$merchant_id);
			$this->code = 1;
			$this->msg = ("Successful");
			
			$this->functions->updateOption('merchant_latitude',
				isset($this->data['latitude'])?$this->data['latitude']:''
				,$merchant_id);
				
			$this->functions->updateOption('merchant_longtitude',
				isset($this->data['lontitude'])?$this->data['lontitude']:''
				,$merchant_id);	
				
			$this->functions->updateOption('merchant_information',
				isset($this->data['merchant_information'])?$this->data['merchant_information']:''
				,$merchant_id);		
			
			try {				
				$cuisine = isset($this->data['cuisine'])?$this->data['cuisine']:'';
				$this->MerchantWrapper->insertCuisine($merchant_id, (array) $cuisine );
			} catch (Exception $e) {
				//
			}
					
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
		}				
		$this->output();
	}


	public function getMerchantSettings()
	{
		$data = array();		
		
		try {
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
			$merchant_id = (integer)$resp['merchant_id'];			
			$settings = $this->MerchantWrapper->getMerchantSettings($merchant_id, $this->MerchantWrapper->merchantSettingsOption() );
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>"set_form_options",
			  'data'=>$settings,
			  'site_url'=>Config::$baseUrl
			);							
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
		}				
		$this->output();
	}
	
	public function updateMerchantSettings()
	{		
		try {
			
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
			$merchant_id = (integer)$resp['merchant_id'];			
			
			$options = $this->MerchantWrapper->merchantSettingsOption();
			foreach ($options as $val) {				
				$this->functions->updateOption($val,
				isset($this->data[$val])?$this->data[$val]:''
				,$merchant_id);
			}
						
			$merchant_photo = isset($this->data['merchant_photo'])?$this->data['merchant_photo']:'';
			$params = array(
			   'delivery_charges'=>is_numeric($this->data['merchant_delivery_charges'])?$this->data['merchant_delivery_charges']:0,
	    	  'minimum_order'=>is_numeric($this->data['merchant_minimum_order'])?$this->data['merchant_minimum_order']:0,
	    	  'delivery_minimum_order'=>is_numeric($this->data['merchant_minimum_order'])?$this->data['merchant_minimum_order']:0,
	    	  'delivery_maximum_order'=>is_numeric($this->data['merchant_maximum_order'])?$this->data['merchant_maximum_order']:0,
	    	  'pickup_minimum_order'=>is_numeric($this->data['merchant_minimum_order_pickup'])?$this->data['merchant_minimum_order_pickup']:0,
	    	  'pickup_maximum_order'=>is_numeric($this->data['merchant_maximum_order_pickup'])?$this->data['merchant_maximum_order_pickup']:0,	    	  
	    	  'delivery_estimation'=>isset($this->data['merchant_delivery_estimation'])?$this->data['merchant_delivery_estimation']:'',	    	  
	    	  'distance_unit'=>isset($this->data['merchant_distance_type'])?$this->data['merchant_distance_type']:'',
	    	  'delivery_distance_covered'=>isset($this->data['merchant_delivery_miles'])?(float)$this->data['merchant_delivery_miles']:0,
	    	  'close_store'=>isset($this->data['merchant_close_store'])?1:0
			);
						
			if(!empty($merchant_photo)){
				$params['logo']=$merchant_photo;
			}
			
			

			$up=$this->functions->updateData('mt_merchant' , $params ,'merchant_id',$merchant_id);
			
			$this->code = 1;
			$this->msg = ("Settings saved");
			$this->details = array(
			  'next_action'=>'set_close_store',
			  'close_store'=>$params['close_store']
			);						
			
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
		}				
		$this->output();
	}


	public function getCategoryList()
	{	
	    //$merchant_id = 3;	
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllCategory($merchant_id,$page,$page_limit,$search_string)){						
			
			$data = array();$x=0;
			foreach ($resp as $val) {
				$add_even='add';
				if($x % 2){
					$add_even='odd';
				}								
				$data[] = array(
				  'id'=>$val['cat_id'],
				  'name'=>stripslashes($val['category_name']),
				  'description'=>stripslashes($val['category_description']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage($val['photo']),
				  'status'=>($val['status']),
				  'date_created'=>$this->OrderWrapper->prettyDateTime($val['date_created'])
				);
				$x++;
			}
						
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function validateToken()
	{
		try {
            $token = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
		    $merchant_id = (integer)$token['merchant_id'];			
		    return $merchant_id;
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
			$this->output();
		}		
	}


	public function CategoryDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$cat_id = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
					
			$this->ItemClass->deleteCategory( (integer)$merchant_id, (integer)$cat_id );
					
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function CategoryGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("category","cat_id=:cat_id",array(
			 ':cat_id'=>$id
			));
						
			$data = array(
			  'cat_id'=>$resp['cat_id'],
			  'category_name'=>stripslashes($resp['category_name']),
			  'category_description'=>stripslashes($resp['category_description']),
			  'photo'=>$resp['photo'],
			  'thumbnail'=>$this->FoodItemWrapper->getImage($resp['photo']),
			  'status'=>$resp['status'],
			  'category_name_trans'=>isset($resp['category_name_trans'])?json_decode($resp['category_name_trans'],true):array(),
			  'category_description_trans'=>isset($resp['category_description_trans'])?json_decode($resp['category_description_trans'],true):array(),
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"category_form.html",
			  'data'=>$data
			);			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}



	public function AddCategory()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		$params = array(
		   'merchant_id'=>$merchant_id,
		  'category_name'=>isset($this->data['category_name'])?$this->data['category_name']:'',
		  'category_description'=>isset($this->data['category_description'])?$this->data['category_description']:'',
		  'status'=>isset($this->data['status'])?$this->data['status']:'',
		  'photo'=>isset($this->data['photo'])?$this->data['photo']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);
		if(isset($this->data['category_name_trans'])){
			$params['category_name_trans'] = json_encode($this->data['category_name_trans']);
		}
		if(isset($this->data['category_description_trans'])){
			$params['category_description_trans'] = json_encode($this->data['category_description_trans']);
		}		
		try {
								
			$this->FoodItemWrapper->insertCategory($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			
			
			
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function getAddonList()
	{
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllAddon($merchant_id,$page,$page_limit,$search_string)){						
			
			$data = array();$x=0;
			foreach ($resp as $val) {
				$add_even='add';
				if($x % 2){
					$add_even='odd';
				}				
				$data[] = array(
				  'id'=>$val['subcat_id'],
				  'name'=>stripslashes($val['subcategory_name']),
				  'description'=>stripslashes($val['subcategory_description']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  'date_created'=>$this->OrderWrapper->prettyDateTime($val['date_created'])
				);				
				$x++;
			}
								
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}



	public function AddAddon()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;			
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'subcategory_name'=>isset($this->data['subcategory_name'])?$this->data['subcategory_name']:'',
		  'subcategory_description'=>isset($this->data['subcategory_description'])?$this->data['subcategory_description']:'',
		  'status'=>isset($this->data['status'])?$this->data['status']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);		
		if(isset($this->data['subcategory_name_trans'])){
			$params['subcategory_name_trans'] = json_encode($this->data['subcategory_name_trans']);
		}
		if(isset($this->data['subcategory_description_trans'])){
			$params['subcategory_description_trans'] = json_encode($this->data['subcategory_description_trans']);
		}				
		try {
			
			$this->FoodItemWrapper->insertAddonCategory($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
						
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function AddonDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
						
			
			$this->ItemClass->deleteAddonCategory( $merchant_id, $id2);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function AddonGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("subcategory","subcat_id=:subcat_id",array(
			 ':subcat_id'=>$id
			));
						
			$data = array(
			  'subcat_id'=>$resp['subcat_id'],
			  'subcategory_name'=>stripslashes($resp['subcategory_name']),
			  'subcategory_description'=>stripslashes($resp['subcategory_description']),
			  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
			  'status'=>$resp['status'],
			  'subcategory_name_trans'=>isset($resp['subcategory_name_trans'])?json_decode($resp['subcategory_name_trans'],true):array(),
			  'subcategory_description_trans'=>isset($resp['subcategory_description_trans'])?json_decode($resp['subcategory_description_trans'],true):array(),
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"addon_form.html",
			  'data'=>$data
			);			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function getAddonItemList()
	{
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllAddonItem($merchant_id,$page,$page_limit,$search_string)){						
			
			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['sub_item_id'],
				  'name'=>stripslashes($val['sub_item_name']),
				  'description'=>stripslashes($val['item_description']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage($val['photo']),
				  'price'=>$this->functions->prettyPrice($val['price'])
				);				
				$x++;
			}
										
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function AddonCategoryList()
	{				
		$merchant_id = $this->validateToken();
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        
		if ($resp = $this->FoodItemWrapper->getAllAddon($merchant_id,$page,$page_limit)){		
			
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['subcat_id'],
				  'name'=>$val['subcategory_name']
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else $this->msg = ("No results");
		}
		$this->output();
	}
	
	public function AddAddonItem()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;			
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'sub_item_name'=>isset($this->data['sub_item_name'])?$this->data['sub_item_name']:'',
		  'item_description'=>isset($this->data['item_description'])?$this->data['item_description']:'',
		  'price'=>isset($this->data['price'])?(float)$this->data['price']:0,
		  'category'=>isset($this->data['category'])? json_encode($this->data['category']) :'',
		  'status'=>isset($this->data['status'])?$this->data['status']:'',
		  'photo'=>isset($this->data['photo'])?$this->data['photo']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);			
		
        if(isset($this->data['sub_item_name_trans'])){
			$params['sub_item_name_trans'] = json_encode($this->data['sub_item_name_trans']);
		}
		if(isset($this->data['item_description_trans'])){
			$params['item_description_trans'] = json_encode($this->data['item_description_trans']);
		}		
		
		if(empty($params['category'])){
			$this->msg = ("Category is required");
			$this->output();
		}
		
		try {
									
			$this->FoodItemWrapper->insertAddonItem($merchant_id,$params,
			json_decode($params['category'],true)
			,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
			if(isset($this->data['sub_item_name_trans'])){
				$this->data['sub_item_name_trans']['default'] = isset($this->data['sub_item_name'])?$this->data['sub_item_name']:'';
				$this->data['item_description_trans']['default'] = isset($this->data['item_description'])?$this->data['item_description']:'';
			}	              
						 
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}



	public function AddonItemDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
						
							
		    $this->ItemClass->deleteAddonItem( $merchant_id, $id2);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
    public function AddonItemGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("subcategory_item","sub_item_id=:sub_item_id",array(
			 ':sub_item_id'=>$id
			));					
			$data = array(
			  'sub_item_id'=>$resp['sub_item_id'],
			  'sub_item_name'=>stripslashes($resp['sub_item_name']),
			  'item_description'=>stripslashes($resp['item_description']),
			  'price'=>$this->functions->normalPrettyPrice($resp['price']),
			  'thumbnail'=>$this->FoodItemWrapper->getImage($resp['photo']),
			  'photo'=>$resp['photo'],			  
			  'category'=>!empty($resp['category'])?json_decode($resp['category'],true):'',
			  'status'=>$resp['status'],
			  'sub_item_name_trans'=>isset($resp['sub_item_name_trans'])?json_decode($resp['sub_item_name_trans'],true):array(),
			  'item_description_trans'=>isset($resp['item_description_trans'])?json_decode($resp['item_description_trans'],true):array(),
			);					
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"addon_item_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	
	
    public function IngredientsList()
	{		
		$merchant_id = $this->validateToken();
		
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllingredients($merchant_id,$page,$page_limit,$search_string)){			
			
			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['ingredients_id'],
				  'name'=>stripslashes($val['ingredients_name']),
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
												
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function AddIngredients()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'ingredients_name'=>isset($this->data['ingredients_name'])?$this->data['ingredients_name']:'',		  
		  'status'=>isset($this->data['status'])?$this->data['status']:'',		  
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);	
				
		if(isset($this->data['ingredients_name_trans'])){
			$params['ingredients_name_trans'] = json_encode($this->data['ingredients_name_trans']);
		}	
		try {
						
			$this->FoodItemWrapper->insertIngredients($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function IngredientsGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("ingredients","ingredients_id=:ingredients_id",array(
			 ':ingredients_id'=>$id
			));
						
			$data = array(
			  'ingredients_id'=>$resp['ingredients_id'],
			  'ingredients_name'=>stripslashes($resp['ingredients_name']),			  
			  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
			  'status'=>$resp['status'],
			  'ingredients_name_trans'=>isset($resp['ingredients_name_trans'])?json_decode($resp['ingredients_name_trans'],true):array(),
			);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"ingredients_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function IngredientsDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
						
			
		    $this->ItemClass->deleteIngredients( $merchant_id,  $id2 );
						
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
    public function CookingList()
	{		
		$merchant_id = $this->validateToken();
			
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllCooking($merchant_id,$page,$page_limit,$search_string)){			
			
			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['cook_id'],
				  'name'=>stripslashes($val['cooking_name']),
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
												
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}	


	public function Addcooking()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'cooking_name'=>isset($this->data['cooking_name'])?$this->data['cooking_name']:'',		  
		  'status'=>isset($this->data['status'])?$this->data['status']:'',		  
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);	

		
        if(isset($this->data['cooking_name_trans'])){
			$params['cooking_name_trans'] = json_encode($this->data['cooking_name_trans']);
		}
			
		try {
						
			$this->FoodItemWrapper->insertCookingRef($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function CookingDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
						
			
			$this->ItemClass->deleteCookingRef( $merchant_id, $id2);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
		
	public function CookingGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("cooking_ref","cook_id=:cook_id",array(
			 ':cook_id'=>$id
			));
						
			$data = array(
			  'cook_id'=>$resp['cook_id'],
			  'cooking_name'=>stripslashes($resp['cooking_name']),			  
			  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
			  'status'=>$resp['status'],
			  'cooking_name_trans'=>isset($resp['cooking_name_trans'])?json_decode($resp['cooking_name_trans'],true):array(),
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"cooking_form.html",
			  'data'=>$data
			);			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}

	 public function ItemList()
	{		
		$merchant_id = $this->validateToken();
		//$merchant_id = 3;
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllitem($merchant_id,$page,$page_limit,$search_string)){			
						
			$data = array();$x=0; 
			foreach ($resp as $val) {				
				
				$prices=array();
				if ( $price_list = json_decode($val['price'],true) ){
					foreach ($price_list as $size_id=>$price) {
						if($size_id>0){							
							try {
								$size_name = $this->FoodItemWrapper->getData("size",'size_id=:size_id 
								AND merchant_id=:merchant_id',array(
								 ':size_id'=>$size_id,
								 ':merchant_id'=>$merchant_id
								));
								
                                
								$prices[]= $size_name['size_name']." ".$this->functions->prettyPrice($price);
                               

							} catch (Exception $e) {
							   $prices[]=$this->functions->prettyPrice($price);	
							}														
						} else $prices[]=$this->functions->prettyPrice($price);
					}
				}

				
								
				$item_status = 'available';
				if($val['not_available']==2){
					$item_status = 'disabled';
				}			
				
				if(isset($val['count_out_of_stock'])){
					if($val['count_out_of_stock']>=1){
						$item_status = 'out_of_stock';
					}				
				}
				
				
				$data[] = array(
				  'id'=>$val['item_id'],
				  'name'=>stripslashes($val['item_name']),
				  'description'=>stripslashes($val['item_description']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage($val['photo']),
				  'prices'=>$prices,
				  'item_status'=>$item_status
				);				
				$x++;
			}
					
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}		
		$this->output();
	}	


	public function AddItem()
	{
		
		$merchant_id = $this->validateToken();
		
		if (!$this->functions->validateMerchantCanPost($merchant_id) ){
    		if (isset($this->data['id']) && is_numeric($this->data['id'])){				
    		} else {	
    		   $this->msg="Sorry but you reach the limit of adding food item. Please upgrade your membership";
    		   $this->output();
    		}
    	}	    
		
		$price=array();
    	if (isset($this->data['price']) && count($this->data['price'])>=1){
    		foreach ($this->data['price'] as $key=>$val) {
    			if (!empty($val)){
    			   $price[$this->data['size'][$key]]=$val;
    			}
    		}	    		
    	}	  

    	$item_id = isset($this->data['id'])?(integer)$this->data['id']:0;
    	
		$params = array(
		    'merchant_id'=>(integer)$merchant_id,
		    'item_name'=>isset($this->data['item_name'])?$this->data['item_name']:'',
		    'item_description'=>isset($this->data['item_description'])?$this->data['item_description']:'',
		    'not_available'=>isset($this->data['not_available'])?(integer)$this->data['not_available']:1,
		    'status'=>isset($this->data['status'])?$this->data['status']:'',
		    'category'=>isset($this->data['category'])?json_encode($this->data['category']):"",
		    'price'=>isset($price)?json_encode($price):'',
		    'cooking_ref'=>isset($this->data['cooking_ref'])?json_encode($this->data['cooking_ref']):"",
		    'discount'=>isset($this->data['discount'])?$this->data['discount']:"",
		    'photo'=>isset($this->data['photo'])?$this->data['photo']:"",
		    'ingredients'=>isset($this->data['ingredients'])?json_encode($this->data['ingredients']):"",
		    'spicydish'=>isset($this->data['spicydish'])?(integer)$this->data['spicydish']:1,
		    'two_flavors'=>isset($this->data['two_flavors'])?$this->data['two_flavors']:'0',				   
		    'dish'=>isset($this->data['dish'])?json_encode($this->data['dish']):'',
		    'non_taxable'=>isset($this->data['non_taxable'])?(integer)$this->data['non_taxable']:1,		    		    
		    'packaging_fee'=>isset($this->data['packaging_fee'])?(float)$this->data['packaging_fee']:0,
		    'packaging_incremental'=>isset($this->data['packaging_incremental'])?(integer)$this->data['packaging_incremental']:0,
		    'date_created'=>$this->functions->dateNow(),
		    'date_modified'=>$this->functions->dateNow(),
		    'ip_address'=>$_SERVER['REMOTE_ADDR'],
		    'multi_option'=>isset($this->data['multi_option'])?json_encode($this->data['multi_option']):"",
			'multi_option_value'=>isset($this->data['multi_option_value'])?json_encode($this->data['multi_option_value']):"",
			'require_addon'=>isset($this->data['require_addon'])?json_encode($this->data['require_addon']):"",
			'addon_item'=>isset($this->data['sub_item_id'])?json_encode($this->data['sub_item_id']):"",
			'two_flavors_position'=>isset($this->data['two_flavors_position'])?json_encode($this->data['two_flavors_position']):"",
		);		
		
		
        if(isset($this->data['item_name_trans'])){
			$params['item_name_trans'] = json_encode($this->data['item_name_trans']);
		}
		if(isset($this->data['item_description_trans'])){
			$params['item_description_trans'] = json_encode($this->data['item_description_trans']);
		}		
				
		
	    if(empty($params['category'])){
			$this->msg = ("Category is required");
			$this->output();
		}
		
		try {			
						
			$resp = $this->FoodItemWrapper->insertItem($merchant_id,$params,$item_id);		
			$this->code = 1;
			$this->msg = $item_id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
			/*ITEM DATA AND RELATIONSHIP*/
			
			$new_item_id = (integer) $item_id>0?$item_id:$this->FoodItemWrapper->getLastInsertedId();
			
			 
			
			 $this->ItemClass->insertItemRelationship(
                (integer)$merchant_id,
                (integer) $new_item_id,
                isset($this->data['category'])?(array)$this->data['category']:''
            );
			
            $this->ItemClass->insertItemRelationshipSubcategory(
                (integer)$merchant_id,
                (integer) $new_item_id,
                isset($this->data['sub_item_id'])?(array)$this->data['sub_item_id']:''
            );
                        
           $this->ItemClass->insertItemRelatinship(
              (integer)$merchant_id,
              (integer) $new_item_id,
              array(
               'size'=>isset($this->data['size'])?(array)$this->data['size']:'',
               'price'=>isset($this->data['price'])?(array)$this->data['price']:''
              )		              
            );
            
            $this->ItemClass->insertMeta( 
               (integer)$merchant_id,
              (integer)$new_item_id,'cooking_ref',
              isset($this->data['cooking_ref'])?(array)$this->data['cooking_ref']:''
            );
                        
            $this->ItemClass->insertMeta( 
              (integer)$merchant_id,
              (integer)$new_item_id,'ingredients',
              isset($this->data['ingredients'])?(array)$this->data['ingredients']:''
            );
            
            $this->ItemClass->insertMeta( 
              (integer)$merchant_id,
              (integer)$new_item_id,'dish',
              isset($this->data['dish'])?(array)$this->data['dish']:''
            );
	
			/*TRANSLATION*/			
			if(isset($this->data['item_name_trans'])){
				$this->data['item_name_trans']['default'] = isset($this->data['item_name'])?$this->data['item_name']:'';
				$this->data['item_description_trans']['default'] = isset($this->data['item_description'])?$this->data['item_description']:'';
			}	                
						
			
			
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	



	public function ItemGetByID()
	{	
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(integer)$this->data['id']:0; $size_list = array();
		
		
		$size_list[] = array(
		 'name'=>"",
		 'value'=>0
		);
		if( $resp = $this->FoodItemWrapper->getSizes($merchant_id)){
			foreach ($resp as $val) {				
				$size_list[] = array(
				  'name'=>$val['size_name'],
				  'value'=>$val['size_id'],
				);
			}
		} 
		
		if($resp = $this->FoodItemWrapper->getItem($merchant_id,$id)){						
			$data = array(
			  'item_id'=>$resp['item_id'],
			  'item_name'=>stripslashes($resp['item_name']),			  			  
			  'item_description'=>stripslashes($resp['item_description']),	
			  'not_available'=>$resp['not_available'],
			  'status'=>stripslashes($resp['status']),			  
			  'category'=>!empty($resp['category'])?json_decode($resp['category'],true):'',
			  'price'=>!empty($resp['price'])?json_decode($resp['price'],true):'',
			  'cooking_ref'=>!empty($resp['cooking_ref'])?json_decode($resp['cooking_ref'],true):'',
			  'discount'=>$resp['discount'],			  
			  'photo'=>$resp['photo'],
			  'thumbnail'=>$this->FoodItemWrapper->getImage($resp['photo']),
			  'ingredients'=>!empty($resp['ingredients'])?json_decode($resp['ingredients'],true):'',
			  'spicydish'=>!empty($resp['spicydish'])?json_decode($resp['spicydish'],true):'',
			  'two_flavors'=>$resp['two_flavors'],
			  'two_flavors_position'=>$resp['two_flavors_position'],
			  'require_addon'=>!empty($resp['require_addon'])?json_decode($resp['require_addon'],true):'',
			  'dish'=>!empty($resp['dish'])?json_decode($resp['dish'],true):'',
			  'non_taxable'=>$resp['non_taxable'],
			  'gallery_photo'=>!empty($resp['gallery_photo'])?json_decode($resp['gallery_photo'],true):'',
			  'packaging_fee'=>$resp['packaging_fee']>0?$this->functions->normalPrettyPrice($resp['packaging_fee']):'',
			  'packaging_incremental'=>$resp['packaging_incremental'],
			  'addon_item'=>!empty($resp['addon_item'])?json_decode($resp['addon_item'],true):'',
			  'item_name_trans'=>isset($resp['item_name_trans'])?json_decode($resp['item_name_trans'],true):array(),
			  'item_description_trans'=>isset($resp['item_description_trans'])?json_decode($resp['item_description_trans'],true):array(),		  
			);							
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"item_form.html",
			  'data'=>$data,
			  'size'=>$size_list
			);						
		} else $this->msg = ("Record not found");
		$this->output();
	}
	
	public function ItemDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;		
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
			
			
		    $this->FoodItemWrapper->deleteItem($merchant_id,$id);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function CategoryList()
	{				
		$merchant_id = $this->validateToken();
		
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $field  = isset($this->data['field'])?trim($this->data['field']):'';        
        
		if ($resp = $this->FoodItemWrapper->getListCategory($merchant_id,$page,$page_limit)){					
			
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['cat_id'],
				  'name'=>stripslashes($val['category_name'])
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'field'=>$field
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->msg = ("No results");
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'clear_list',				  
				);
			}		
		}
		$this->output();
	}
	
	public function CookingRefList()
	{				
		$merchant_id = $this->validateToken();
		$search_string='';
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $field  = isset($this->data['field'])?trim($this->data['field']):'';  
        
		if ($resp = $this->FoodItemWrapper->getAllCooking($merchant_id,$page,$page_limit,
		$search_string,'a.cooking_name','ASC', false)){		
			
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['cook_id'],
				  'name'=>stripslashes($val['cooking_name'])
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'field'=>$field
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->msg = ("No results");
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'clear_list',				  
				);
			}		
		}
		$this->output();
	}

	public function IngredList()
	{				
		$merchant_id = $this->validateToken();
		$search_string='';
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $field  = isset($this->data['field'])?trim($this->data['field']):'';  
        
		if ($resp = $this->FoodItemWrapper->getAllingredients($merchant_id,$page,$page_limit,$search_string,
		'a.ingredients_name','ASC',false
		)){		
			
			
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['ingredients_id'],
				  'name'=>stripslashes($val['ingredients_name'])
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'field'=>$field
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->msg = ("No results");
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'clear_list',				  
				);
			}		
		}
		$this->output();
	}
	
	
	public function DishList()
	{				
		$merchant_id = $this->validateToken();
		$search_string='';
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $field  = isset($this->data['field'])?trim($this->data['field']):'';  
        
		if ($resp = $this->FoodItemWrapper->getAllDish($merchant_id,$page,$page_limit,$search_string)){		
			
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['dish_id'],
				  'name'=>stripslashes($val['dish_name'])
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'field'=>$field
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->msg = ("No results");
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'clear_list',				  
				);
			}		
		}
		$this->output();
	}	


   public function SizeList()
	{	
		
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllSize($merchant_id,$page,$page_limit,$search_string)){						
			
			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['size_id'],
				  'name'=>stripslashes($val['size_name']),
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
												
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function SizeGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("size","size_id=:size_id",array(
			 ':size_id'=>$id
			));
						
			$data = array(
			  'size_id'=>$resp['size_id'],
			  'size_name'=>stripslashes($resp['size_name']),			  
			  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
			  'status'=>$resp['status'],
			  'size_name_trans'=>isset($resp['size_name_trans'])?json_decode($resp['size_name_trans'],true):array(),
			);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"size_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function AddSize()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'size_name'=>isset($this->data['size_name'])?$this->data['size_name']:'',		  
		  'status'=>isset($this->data['status'])?$this->data['status']:'',		  
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);				
		
		if(isset($this->data['size_name_trans'])){
			$params['size_name_trans'] = json_encode($this->data['size_name_trans']);
		}	
		
		try {
						
			$this->FoodItemWrapper->insertSize($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function SizeDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		$id2 = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {
						
			
			$this->ItemClass->deleteSize($merchant_id,$id2);			
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
		
	public function getSizeList()
	{
		$merchant_id = $this->validateToken();
		//$merchant_id = 3;
		$data[] = array(
		 'name'=>"",
		 'value'=>0
		);
		if( $resp = $this->FoodItemWrapper->getSizes($merchant_id)){
			foreach ($resp as $val) {				
				$data[] = array(
				  'name'=>$val['size_name'],
				  'value'=>$val['size_id'],
				);
			}
		} 
						
		$this->code = 1; $this->msg = "OK";
		$this->details = array(
	       'next_action'=>'show_add_item_form',
	       'size'=>$data
	    );
		
		$this->output();
	}	


	public function ShippingList()
{		
    $merchant_id = $this->validateToken();
    $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);	
    $page_limit = $this->MerchantWrapper->paginateLimit();

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $page_limit;
    } else {
        $page = 0;
    }

    $refresh = isset($this->data['refresh']) ? (int)$this->data['refresh'] : 0;
    $search_string = isset($this->data['s']) ? trim($this->data['s']) : '';

    if (!empty($search_string)) {
        $refresh = 1;
    }

    if ($resp = $this->FoodItemWrapper->getAllShipping($merchant_id, $page, $page_limit, $search_string)) {
        $data = array();
        foreach ($resp as $val) {
            $data[] = array(
                'id' => $val['id'],
                'name' => $this->functions->prettyPrice($val['distance_price']),
                'description' => "Distance " . 
                    $this->functions->normalPrettyPrice($val['distance_from']) . 
                    " to " . 
                    $this->functions->normalPrettyPrice($val['distance_to']) . 
                    " " . 
                    $this->MapsWrapperTemp->prettyUnit($val['shipping_units']),
                'thumbnail' => $this->FoodItemWrapper->getImage('', 'distance.png'),
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'set_list_column',
            'refresh' => $refresh,
            'data' => $data,
            'shipping_enabled' => $shipping_enabled
        );
    } else {
        if (isset($this->data['page'])) {
            $this->code = 1;
            $this->details = array(
                'next_action' => 'end_of_list',
                'refresh' => $refresh,
            );
        } else {
            $this->code = 1;
            $this->msg = "No results";
            $this->details = array(
                'next_action' => 'clear_list',
                'shipping_enabled' => $shipping_enabled,
                'is_search' => !empty($search_string) ? true : false
            );
        }
    }

    $this->output();
}

public function AddShipping()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'distance_from'=>isset($this->data['distance_from'])?(float)$this->data['distance_from']:0,		  
		  'distance_to'=>isset($this->data['distance_to'])?(float)$this->data['distance_to']:0,		  
		  'distance_price'=>isset($this->data['distance_price'])?(float)$this->data['distance_price']:0,		  
		  'shipping_units'=>isset($this->data['shipping_units'])?$this->data['shipping_units']:0,		  
		);			
		try {
						
			$this->FoodItemWrapper->insertShipping($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function ShippingDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
						
			$this->FoodItemWrapper->deleteShipping($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}

	public function ShippingGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("shipping_rate","id=:id",array(
			 ':id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['id'],
			  'distance_from'=>$resp['distance_from'],			  
			  'distance_to'=>$resp['distance_to'],
			  'shipping_units'=>$resp['shipping_units'],
			  'distance_price'=>$this->functions->normalPrettyPrice($resp['distance_price'])
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"shipping_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	
	
	public function enabled_shipping()
	{
		$merchant_id = $this->validateToken();		
		$shipping_enabled = isset($this->data['shipping_enabled'])?(integer)$this->data['shipping_enabled']:0;		

		$this->functions->updateOption("shipping_enabled",$shipping_enabled,$merchant_id);	
		
		$this->code = 1;
		$this->msg = "Settings saved";
		$this->output();
	}
	
	public function enabled_min_table()
	{
		$merchant_id = $this->validateToken();		
		$enabled_min_table = isset($this->data['min_tables_enabled'])?(integer)$this->data['min_tables_enabled']:0;		
		
		$this->functions->updateOption("min_tables_enabled",$enabled_min_table,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Settings saved");
		$this->output();
	}
	
	public function enabled_category_sked()
	{
		$merchant_id = $this->validateToken();		
		$enabled = isset($this->data['enabled_category_sked'])?(integer)$this->data['enabled_category_sked']:0;				

		$this->functions->updateOption("enabled_category_sked",$enabled,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Settings saved");
		$this->output();
	}	

	public function enabled_category_sked_time()
	{
		$merchant_id = $this->validateToken();		
		$enabled = isset($this->data['enabled_category_sked_time'])?(integer)$this->data['enabled_category_sked_time']:0;				

		$this->functions->updateOption("enabled_category_sked_time",$enabled,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Settings saved");
		$this->output();
	}
	
   public function OffersList()
{		
	//$merchant_id = $this->validateToken();
	$merchant_id = 3;
				
	$page_limit = $this->MerchantWrapper->paginateLimit();
	
	if (isset($this->data['page'])){
    	$page = $this->data['page'] * $page_limit;
    } else {
        $page = 0;  
    }
    
    $refresh = isset($this->data['refresh']) ? (int)$this->data['refresh'] : 0;
    $search_string = isset($this->data['s']) ? trim($this->data['s']) : '';
    
    if (!empty($search_string)) {
    	$refresh = 1;
    }

	if ($resp = $this->FoodItemWrapper->getAllOffers($merchant_id, $page, $page_limit, $search_string)) {			
		
		$data = array();
		foreach ($resp as $val) {		
			$list = '';
			if ($applicable_to = json_decode($val['applicable_to'], true)) {
				foreach ($applicable_to as $applicable_val) {
					$list .= $applicable_val . ", ";
				}
				$list = rtrim($list, ', '); // safer trimming
			}
					
			$data[] = array(
				'id' => $val['offers_id'],
				'name' => $this->functions->normalPrettyPrice($val['offer_percentage']) . "%",
				'description' => $list,
				'thumbnail' => $this->FoodItemWrapper->getImage($val['photo'] ?? ''), // use actual image if available
				'status' => $val['status'],
				'date_created' => "Valid from " . $this->functions->prettyDate($val['valid_from']) .
								  " to " . $this->OrderWrapper->prettyDateTime($val['date_created'])
			);				
		}
														
		$this->code = 1;
		$this->msg = "OK";			
		$this->details = array(
			'next_action' => 'set_list_column',
			'refresh' => $refresh,
			'data' => $data
		);						
	} else {
		if (isset($this->data['page'])) {
			$this->code = 1;
			$this->details = array(
				'next_action' => 'end_of_list',
				'refresh' => $refresh
			);
		} else {
			$this->code = 1;
			$this->msg = "No results";
			$this->details = array(
				'next_action' => 'clear_list',
				'is_search' => !empty($search_string)
			);
		}
	}
	$this->output();
}
	
public function TransactionList()
	{
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		
		$data = array();
		$data[] = array(
		  'id'=>'delivery',
		  'name'=>'delivery'
		);
		$data[] = array(
		  'id'=>'pickup',
		  'name'=>'pickup'
		);
		$data[] = array(
		  'id'=>'dinein',
		  'name'=>'dinein'
		);
				
		$this->code = 1;
		$this->msg = "OK";			
		$this->details = array(
		 'next_action'=>'display_selected',
		 'refresh'=>$refresh,
		 'data'=>$data
		);			
		$this->output();
	}
	
	public function DateList()
	{
		$page_limit=1;
		$data = array();
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		
		$next_action = 'display_single_selected';
		$multiple = isset($this->data['multiple'])?(integer)$this->data['multiple']:0;		
		if($multiple>0){
			$next_action = 'display_selected';
		}	
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $start_count = 0; $end_count = 60;
        
        $field  = isset($this->data['field'])?trim($this->data['field']):'';        
        $field_prev = array('start_date','end_date');    
        if(in_array($field,$field_prev)){
        	$start_count = -60;
        	$end_count = 0;
        }               
        	
		for ($i = $start_count ; $i <= $end_count; $i++) {				
			$key=date("Y-m-d",strtotime("+$i day"));
			$pretty_date = $this->functions->prettyDate(date("D F d Y",strtotime("+$i day")));
			if($multiple>0){
			  $data[] = array(
				  'id'=>$key,
				  'value'=>$key,
				  'name'=>$pretty_date
			  );
			} else {
				$data[] = array(
				  'id'=>'date',
				  'value'=>$key,
				  'name'=>$pretty_date
				);
			}
		}
		
		if($page<=0){
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>$next_action,
			 'refresh'=>$refresh,
			 'data'=>$data
			);					
		} else {
			$this->code = 1;
			$this->details = array(
			  'next_action'=>'end_of_list',
			  'refresh'=>$refresh
			);
		}				
		$this->output();
	}


	public function AddOffers()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,	
		  'offer_percentage'=>isset($this->data['offer_percentage'])?(float)$this->data['offer_percentage']:0,
		  'offer_price'=>isset($this->data['offer_price'])?(float)$this->data['offer_price']:0,
		  'valid_from'=>isset($this->data['valid_from'])?$this->data['valid_from']:null,
		  'valid_to'=>isset($this->data['valid_to'])?$this->data['valid_to']:null,
		  'status'=>isset($this->data['status'])?$this->data['status']:'pending',
		  'applicable_to'=>isset($this->data['applicable_to'])?json_encode($this->data['applicable_to']):'',
		  'date_created'=>$this->functions->dateNow(),
		  'date_modified'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);			
		try {

			if($id>0){
			   unset($params['date_created']);
			}
			
			$this->FoodItemWrapper->insertOffers($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function OffersDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
						
			$this->FoodItemWrapper->deleteOffers($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function OffersGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("offers","offers_id=:offers_id",array(
			 ':offers_id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['offers_id'],
			  'offer_percentage'=>$this->functions->normalPrettyPrice($resp['offer_percentage']),			  
			  'offer_price'=>$this->functions->normalPrettyPrice($resp['offer_price']),
			  'valid_from'=>$resp['valid_from'],
			  'valid_to'=>$resp['valid_to'],
			  'status'=>$resp['status'],
			  'applicable_to'=>(array)json_decode($resp['applicable_to'],true)
			);
			
						
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"offers_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function VoucherList()
	{		
		$merchant_id = $this->validateToken();
		
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllVouchers($merchant_id,$page,$page_limit,$search_string)){			
						
			$data = array();$x=0;
			foreach ($resp as $val) {		
				
				
				$voucher_name = $val['voucher_name']." ".$this->functions->normalPrettyPrice($val['amount'])."%";
				if($val['voucher_type']=="fixed amount"){
					$voucher_name = $val['voucher_name'];
				}			
									
				$data[] = array(
				  'id'=>$val['voucher_id'],
				  'name'=>$voucher_name,
				  'description'=>($val['voucher_type']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  
				  'date_created'=>"Expiration ".$this->functions->prettyDate($val['expiration'])


				);				
				$x++;
			}
			
														
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}	


	public function VoucherGetByID()
	{		
		$merchant_id = $this->validateToken();
		
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;



		try {
						
			$resp = $this->FoodItemWrapper->getData("voucher_new","voucher_id=:voucher_id",array(
			 ':voucher_id'=>$id
			));
								
			$data = array(
			  'id'=>$resp['voucher_id'],
			  'voucher_name'=>$resp['voucher_name'],
			  'voucher_type'=>$resp['voucher_type'],
			  'amount'=>$this->functions->normalPrettyPrice($resp['amount']),
			  'expiration'=>$resp['expiration'],
			  'used_once'=>$resp['used_once'],
			  'status'=>$resp['status'],
			  'min_order'=>isset($resp['min_order'])?$this->functions->normalPrettyPrice($resp['min_order']):'',			  
			  'monday'=>isset($resp['monday'])? (integer) $resp['monday']:'',
			  'tuesday'=>isset($resp['tuesday'])? (integer) $resp['tuesday']:'',
			  'wednesday'=>isset($resp['wednesday'])? (integer) $resp['wednesday']:'',
			  'thursday'=>isset($resp['thursday'])? (integer) $resp['thursday']:'',
			  'friday'=>isset($resp['friday'])? (integer) $resp['friday']:'',
			  'saturday'=>isset($resp['saturday'])? (integer) $resp['saturday']:'',
			  'sunday'=>isset($resp['sunday'])? (integer) $resp['sunday']:'',
			);			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"voucher_form.html",
			  'data'=>$data
			);			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	


	public function AddVoucher()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;			
		$days = $this->MerchantWrapper->dayList(); 		
		$params = array(
		  'merchant_id'=>(integer)$merchant_id,	
		  'voucher_name'=>isset($this->data['voucher_name'])?$this->data['voucher_name']:'',
		  'voucher_type'=>isset($this->data['voucher_type'])?$this->data['voucher_type']:'',
		  'amount'=>isset($this->data['amount'])?(float)$this->data['amount']:0,
		  'expiration'=>isset($this->data['expiration'])?$this->data['expiration']:'',
		  'used_once'=>isset($this->data['used_once'])?(integer)$this->data['used_once']:0,		  
		  'status'=>isset($this->data['status'])?$this->data['status']:'pending',
		  'date_created'=>$this->functions->dateNow(),
		  'date_modified'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR'],
		  'min_order'=>isset($this->data['min_order'])?(float)$this->data['min_order']:0		  
		);		
		
		$days_found = false;
		foreach ($days as $day=>$dayname) {
			$params[$day] = isset($this->data[$day])?(integer)$this->data[$day]:0;
			if(isset($this->data[$day])){
				$days_found=true;
			}	
		}
		
		if(!$days_found){
			$this->msg = ("Please select days available");
			$this->output();
		}	
		
			
		try {
			
			if($id>0){
			   unset($params['date_created']);
			}		
				
			$this->FoodItemWrapper->insertVoucher($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	
	
	
	
public function VoucherDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
						
			$this->FoodItemWrapper->deleteVoucher($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
		
	public function MintableList()
	{		
		$merchant_id = $this->validateToken();
		//$merchant_id = 3;
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllMinTable($merchant_id,$page,$page_limit,$search_string)){			
						
			$data = array();$x=0;
			foreach ($resp as $val) {		
									
				$data[] = array(
				  'id'=>$val['id'],	
				  'name' =>$this->functions->prettyPrice($val['min_order']),
				  

				  'description'=>$this->functions->normalPrettyPrice($val['distance_from'])." to ".$this->functions->normalPrettyPrice($val['distance_to'])." ".$this->MapsWrapperTemp->prettyUnit($val['shipping_units']),

				  'thumbnail'=>$this->FoodItemWrapper->getImage('','distance.png'),
				);				
				$x++;
			}
														
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'min_tables_enabled'=>$this->functions->getOption('min_tables_enabled',$merchant_id)
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = translate("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'min_tables_enabled'=>$this->functions->getOption('min_tables_enabled',$merchant_id),
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}	


	public function AddMintable()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>(integer)$merchant_id,	
		  'distance_from'=>isset($this->data['distance_from'])?(float)$this->data['distance_from']:0,
		  'distance_to'=>isset($this->data['distance_to'])?(float)$this->data['distance_to']:0,
		  'shipping_units'=>isset($this->data['shipping_units'])?$this->data['shipping_units']:'',		  
		  'min_order'=>isset($this->data['min_order'])?(float)$this->data['min_order']:'',
		);		
		
		try {
						
			$this->FoodItemWrapper->insertMintable($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	

	public function MintableDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
						
			$this->FoodItemWrapper->deleteMintable($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
		
	public function MintableGetByID()
	{		
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("minimum_table","id=:id",array(
			 ':id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['id'],
			  'distance_from'=>$this->functions->normalPrettyPrice($resp['distance_from']),
			  'distance_to'=>$this->functions->normalPrettyPrice($resp['distance_to']),
			  'shipping_units'=>$resp['shipping_units'],
			  'min_order'=>$this->functions->normalPrettyPrice($resp['min_order']),			  			  
			);			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"mintable_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	
		
	public function SchedulerList()
	{		
		$merchant_id = $this->validateToken();

		$enabled_category_sked = $this->functions->getOption('enabled_category_sked',$merchant_id);
		$enabled_category_sked_time = $this->functions->getOption('enabled_category_sked_time',$merchant_id);
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->getAllSchedulerList($merchant_id,$page,$page_limit,$search_string)){			
						
			$data = array();$x=0;
			foreach ($resp as $val) {											
				$data[] = array(
				  'id'=>$val['cat_id'],				  
				  'name'=>$val['category_name'],
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'schedule'=>array(
				      'monday'=>$val['monday'],
					  'tuesday'=>$val['tuesday'],
					  'wednesday'=>$val['wednesday'],
					  'thursday'=>$val['thursday'],
					  'friday'=>$val['friday'],
					  'saturday'=>$val['saturday'],
					  'sunday'=>$val['sunday'],
				  )
				);				
				$x++;
			}

			//dump($data);
								
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data,
			 'enabled_category_sked'=>$enabled_category_sked,
			 'enabled_category_sked_time'=>$enabled_category_sked_time
			);									
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'enabled_category_sked'=>$enabled_category_sked,
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function SchedulerGetByID()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("category","cat_id=:cat_id",array(
			 ':cat_id'=>$id
			));
			
					
			$data = array(
			  'cat_id'=>$resp['cat_id'],
			  'category_name'=>$resp['category_name'],			  
			  'monday'=>$resp['monday'],
			  'tuesday'=>$resp['tuesday'],
			  'wednesday'=>$resp['wednesday'],
			  'thursday'=>$resp['thursday'],
			  'friday'=>$resp['friday'],
			  'saturday'=>$resp['saturday'],
			  'sunday'=>$resp['sunday'],
			  'monday_start'=>isset($resp['monday_start'])?$resp['monday_start']:'',
			  'monday_end'=>isset($resp['monday_end'])?$resp['monday_end']:'',
			  'tuesday_start'=>isset($resp['tuesday_start'])?$resp['tuesday_start']:'',
			  'tuesday_end'=>isset($resp['tuesday_end'])?$resp['tuesday_end']:'',
			  'wednesday_start'=>isset($resp['wednesday_start'])?$resp['wednesday_start']:'',
			  'wednesday_end'=>isset($resp['wednesday_end'])?$resp['wednesday_end']:'',
			  'thursday_start'=>isset($resp['thursday_start'])?$resp['thursday_start']:'',
			  'thursday_end'=>isset($resp['thursday_end'])?$resp['thursday_end']:'',
			  'friday_start'=>isset($resp['friday_start'])?$resp['friday_start']:'',
			  'friday_end'=>isset($resp['friday_end'])?$resp['friday_end']:'',
			  'saturday_start'=>isset($resp['saturday_start'])?$resp['saturday_start']:'',
			  'saturday_end'=>isset($resp['saturday_end'])?$resp['saturday_end']:'',
			  'sunday_start'=>isset($resp['sunday_start'])?$resp['sunday_start']:'',
			  'sunday_end'=>isset($resp['sunday_end'])?$resp['sunday_end']:'',
			);
						
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"scheduler_form.html",
			  'data'=>$data
			);			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function AddScheduler()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;			
		
		$days = $this->MerchantWrapper->dayList(); $params = array();
		foreach ($days as $day=>$dayname) {
			$params[$day] = isset($this->data[$day])?(integer)$this->data[$day]:0;
			$params[$day."_start"] = isset($this->data[$day."_start"])?trim($this->data[$day."_start"]):'';
			$params[$day."_end"] = isset($this->data[$day."_end"])?trim($this->data[$day."_end"]):'';
		}
		
		$params['date_modified']=$this->functions->dateNow();
		$params['ip_address']=$_SERVER['REMOTE_ADDR'];
		
		try {
											
			$this->FoodItemWrapper->insertCategoryScheduler($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function getPaymentList()
	{		
		try {
            $token = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
            $user_access = json_decode($token['user_access'],true);
		    $merchant_id = (integer)$token['merchant_id'];	
		    
		    if(is_array($user_access) && count((array)$user_access)>=1){
		    	$user_access = array_map('strtolower', $user_access);
		    } else $user_access = false;
		    		    
		    
		    $list = $this->functions->PaymentOptionList(); $available = array();
		    $list_payment_enabled=$this->functions->getMerchantListOfPaymentGateway();		
		    		   
		    $master = $this->MerchantWrapper->getMerchantSettings($merchant_id,array(
		     'merchant_switch_master_cod','merchant_switch_master_ocr','merchant_switch_master_pyr',
		     'merchant_switch_master_paypal_v2','merchant_switch_master_stp','merchant_switch_master_mercadopago',
		     'merchant_switch_master_ide','merchant_switch_master_payu','merchant_switch_master_pys',
		     'merchant_switch_master_bcy','merchant_switch_master_epy','merchant_switch_master_atz',
		     'merchant_switch_master_obd','merchant_switch_master_btr','merchant_switch_master_rzr',
		     'merchant_switch_master_vog'
		    ));
		    		    
		    $new_master = array();
		    if(is_array($master) && count($master)>=1){
		    	foreach ($master as $val_master) {
		    		if($val_master['option_value']!=1){
		    			$new_master[] = str_replace("merchant_switch_master_","",$val_master['option_name']);
		    		}
		    	}
		    	
		    	if(is_array($new_master) && count($new_master)>=1){
		    		$new_list_payment_enabled =  array();
			    	foreach ($new_master as $new_master_val) {
			    		if(in_array($new_master_val,(array)$list_payment_enabled)){
			    			$new_list_payment_enabled[] = $new_master_val;
			    		}
			    	}
			    	$list_payment_enabled = $new_list_payment_enabled;
		    	}
		    	
		    }
		    		    
		        
		    foreach ($list as $key=>$val) {
		    	if(in_array($key,$list_payment_enabled)){		 		    		
		    		$available[$key]=array(
		    		  'code'=>$key,
		    		  'name'=>$val,
		    		  'icon'=>$this->FoodItemWrapper->getImage('',"payment/$key.png")
		    		);
		    		if($key=="obd"){
		    			$available['obd_receive']=array(
			    		  'code'=>"obd_receive",
			    		  'name'=>("Receive Bank Deposit"),
			    		  'icon'=>$this->FoodItemWrapper->getImage('',"payment/$key.png")
			    		);
		    		}
		    	}
            }		   
            
            if($this->functions->isMerchantPaymentToUseAdmin($merchant_id)){                  	
            	if(array_key_exists('pyr',$available)){            		            		
            		$available=array();
            		$available["pyr"]=array(
		    		  'code'=>"pyr",
		    		  'name'=>("Pay On Delivery"),
		    		  'icon'=>$this->FoodItemWrapper->getImage('',"payment/pyr.png")
		    		);		    		
            	} else $available=array();
            } 
            
            $new_available = $available;
            if(is_array($user_access) && count($user_access)>=1){            	
            	$new_available = array();
            	foreach ($available as $val) {
            		if(in_array($val['code'],(array)$user_access)){            			
            			$new_available[] = $val;
            		}
            	}
            }

                               
            $this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_payment_list',
			  'data'=>$new_available
			);		    	   
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}	



	public function getPaymentInfo()
	{
		$merchant_id = $this->validateToken();
		//$merchant_id = 3;
		$settings = array();
		$name = ''; $list = $this->functions->PaymentOptionList();
		$payment_code = isset($this->data['code'])?$this->data['code']:'';
				
		$name = array_key_exists($payment_code,(array)$list)?$list[$payment_code]:'';
				
		switch ($payment_code) {
			case "cod":
				$settings = array(
				  'merchant_disabled_cod'=>$this->functions->getOption('merchant_disabled_cod',$merchant_id),
				  'cod_change_required_merchant'=>$this->functions->getOption('cod_change_required_merchant',$merchant_id),
				);				
				break;
				
			case "ocr":
				$settings = array(
				  'merchant_disabled_ccr'=>$this->functions->getOption('merchant_disabled_ccr',$merchant_id),				  
				);				
				break;
				
			case "pyr":	
                $card_list = array();			
			    $list_check=$this->functions->getOption('payment_provider',$merchant_id);
			    $list = $this->functions->getPaymentProviderListActive();
			    if(is_array($list) && count($list)>=1){
			    	foreach ($list as $val) {
			    		$card_list[]= array(
			    		  'id'=>$val['id'],
			    		  'payment_name'=>$val['payment_name'],
			    		  'payment_logo'=>$this->FoodItemWrapper->getImage($val['payment_logo']),
			    		);
			    	}
			    }
			    $settings = array(
				  'merchant_payondeliver_enabled'=>$this->functions->getOption('merchant_payondeliver_enabled',$merchant_id),	
				  'card_list'=>$card_list,
				  'card_selected'=>json_decode($list_check,true)
				);				
			    break;
		
			case "stp":    
			   $settings = array(
				  'stripe_enabled'=>$this->functions->getOption('stripe_enabled',$merchant_id),
				  'stripe_mode'=>$this->functions->getOption('stripe_mode',$merchant_id),
				  'merchant_stripe_card_fee'=>$this->functions->getOption('merchant_stripe_card_fee',$merchant_id),
				  'sanbox_stripe_secret_key'=>$this->functions->getOption('sanbox_stripe_secret_key',$merchant_id),
				  'sandbox_stripe_pub_key'=>$this->functions->getOption('sandbox_stripe_pub_key',$merchant_id),
				  'merchant_sandbox_stripe_webhooks'=>$this->functions->getOption('merchant_sandbox_stripe_webhooks',$merchant_id),
				  
				  'live_stripe_secret_key'=>$this->functions->getOption('live_stripe_secret_key',$merchant_id),
				  'live_stripe_pub_key'=>$this->functions->getOption('live_stripe_pub_key',$merchant_id),
				  'merchant_live_stripe_webhooks'=>$this->functions->getOption('merchant_live_stripe_webhooks',$merchant_id),
				);				
			   break;
			   
			case "payu":   
			   $settings = array(
				  'merchant_payu_enabled'=>$this->functions->getOption('merchant_payu_enabled',$merchant_id),	
				  'merchant_payu_mode'=>$this->functions->getOption('merchant_payu_mode',$merchant_id),
				  'merchant_payu_key'=>$this->functions->getOption('merchant_payu_key',$merchant_id),
				  'merchant_payu_salt'=>$this->functions->getOption('merchant_payu_salt',$merchant_id),
				);				
			    break;
			  
			case "obd":
    $settings = array(
        'merchant_bankdeposit_enabled' => $this->functions->getOption('merchant_bankdeposit_enabled', $merchant_id),
        'merchant_deposit_subject' => $this->functions->getOption('merchant_deposit_subject', $merchant_id),
        'merchant_deposit_instructions' => $this->functions->getOption('merchant_deposit_instructions', $merchant_id),
    );
    break;

case "paypal_v2":
    $settings = array(
        'merchant_paypal_v2_enabled' => $this->functions->getOption('merchant_paypal_v2_enabled', $merchant_id),
        'merchant_paypal_v2_mode' =>$this->functions->getOption('merchant_paypal_v2_mode', $merchant_id),
        'merchant_paypal_v2_card_fee' => $this->functions->getOption('merchant_paypal_v2_card_fee', $merchant_id),
        'merchant_paypal_v2_client_id' => $this->functions->getOption('merchant_paypal_v2_client_id', $merchant_id),
        'merchant_paypal_v2_secret' => $this->functions->getOption('merchant_paypal_v2_secret', $merchant_id),
    );
    break;

case "mercadopago":
    $settings = array(
        'merchant_mercadopago_v2_enabled' => $this->functions->getOption('merchant_mercadopago_v2_enabled', $merchant_id),
        'merchant_mercadopago_v2_mode' => $this->functions->getOption('merchant_mercadopago_v2_mode', $merchant_id),
        'merchant_mercadopago_v2_card_fee' => $this->functions->getOption('merchant_mercadopago_v2_card_fee', $merchant_id),
        'merchant_mercadopago_v2_client_id' => $this->functions->getOption('merchant_mercadopago_v2_client_id', $merchant_id),
        'merchant_mercadopago_v2_client_secret' => $this->functions->getOption('merchant_mercadopago_v2_client_secret', $merchant_id),
    );
    break;

				
			
		       
		    case "vog":
		    	$settings = array(
				  'merchant_vog_enabled'=>$this->functions->getOption('merchant_vog_enabled',$merchant_id),	
				  'merchant_vog_merchant_id'=>$this->functions->getOption('merchant_vog_merchant_id',$merchant_id),				  
				);				 
		    	break; 
		    	
		    case "obd_receive":
		    	$this->code = 1; $this->msg = "OK";
		    	$this->details = array(
				  'next_action'=>'obd_receive_list',				  
				);		
				$this->output();
		    	break;   
		       
			default:
				$this->msg = ("Payment settings not available");
				$this->output();
				break;
		}
				
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		  'next_action'=>'fill_payment_info',
		  'code'=>$payment_code,
		  'name'=>$name,
		  'data'=>$settings
		);				
		$this->output();
	}

	public function SavePaymentSettings()
    {
        $merchant_id = $this->validateToken(); $settings = array();     
        $payment_code = isset($this->data['payment_code'])?$this->data['payment_code']:'';
        
        //dump($this->data);
        
        switch ($payment_code) {
            case "cod":
                $this->functions->updateOption("merchant_disabled_cod",
                 isset($this->data['merchant_disabled_cod'])?$this->data['merchant_disabled_cod']:'',
                 $merchant_id);             
                 
                 $this->functions->updateOption("cod_change_required_merchant",
                 isset($this->data['cod_change_required_merchant'])?$this->data['cod_change_required_merchant']:'',
                 $merchant_id);             
                break;
                
            case "ocr":
                  $this->functions->updateOption("merchant_disabled_ccr",
                  isset($this->data['merchant_disabled_ccr'])?$this->data['merchant_disabled_ccr']:'',
                  $merchant_id);                
                break;
                
            case "pyr": 
                  $this->functions->updateOption("merchant_payondeliver_enabled",
                  isset($this->data['merchant_payondeliver_enabled'])?$this->data['merchant_payondeliver_enabled']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("payment_provider",
                  isset($this->data['payment_provider'])?json_encode($this->data['payment_provider']):''
                  ,$merchant_id);           
                break;
                
            case "stp":    
                  $this->functions->updateOption("stripe_enabled",
                  isset($this->data['stripe_enabled'])?$this->data['stripe_enabled']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("stripe_mode",
                  isset($this->data['stripe_mode'])?$this->data['stripe_mode']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("merchant_stripe_card_fee",
                  isset($this->data['merchant_stripe_card_fee'])?$this->data['merchant_stripe_card_fee']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("sanbox_stripe_secret_key",
                  isset($this->data['sanbox_stripe_secret_key'])?$this->data['sanbox_stripe_secret_key']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("sandbox_stripe_pub_key",
                  isset($this->data['sandbox_stripe_pub_key'])?$this->data['sandbox_stripe_pub_key']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("merchant_sandbox_stripe_webhooks",
                  isset($this->data['merchant_sandbox_stripe_webhooks'])?$this->data['merchant_sandbox_stripe_webhooks']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("live_stripe_secret_key",
                  isset($this->data['live_stripe_secret_key'])?$this->data['live_stripe_secret_key']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("live_stripe_pub_key",
                  isset($this->data['live_stripe_pub_key'])?$this->data['live_stripe_pub_key']:'',
                  $merchant_id);    
                  
                  $this->functions->updateOption("merchant_live_stripe_webhooks",
                  isset($this->data['merchant_live_stripe_webhooks'])?$this->data['merchant_live_stripe_webhooks']:'',
                  $merchant_id);    
                break;
        
            case "payu":
                 $this->functions->updateOption("merchant_payu_enabled",
                  isset($this->data['merchant_payu_enabled'])?$this->data['merchant_payu_enabled']:'',
                  $merchant_id);     
                  
                  $this->functions->updateOption("merchant_payu_mode",
                  isset($this->data['merchant_payu_mode'])?$this->data['merchant_payu_mode']:'',
                  $merchant_id);     
                  
                  $this->functions->updateOption("merchant_payu_key",
                  isset($this->data['merchant_payu_key'])?$this->data['merchant_payu_key']:'',
                  $merchant_id);     
                  
                  $this->functions->updateOption("merchant_payu_salt",
                  isset($this->data['merchant_payu_salt'])?$this->data['merchant_payu_salt']:'',
                  $merchant_id);     
                break;
                    
            case "obd": 
                $this->functions->updateOption("merchant_bankdeposit_enabled",
                  isset($this->data['merchant_bankdeposit_enabled'])?$this->data['merchant_bankdeposit_enabled']:'',
                $merchant_id);   
                
                $this->functions->updateOption("merchant_deposit_subject",
                  isset($this->data['merchant_deposit_subject'])?$this->data['merchant_deposit_subject']:'',
                $merchant_id);   
                
                $this->functions->updateOption("merchant_deposit_instructions",
                  isset($this->data['merchant_deposit_instructions'])?$this->data['merchant_deposit_instructions']:'',
                $merchant_id);   
                break;  
                
            case "paypal_v2":               
                $this->functions->updateOption("merchant_paypal_v2_enabled",
                  isset($this->data['merchant_paypal_v2_enabled'])?$this->data['merchant_paypal_v2_enabled']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_paypal_v2_mode",
                  isset($this->data['merchant_paypal_v2_mode'])?$this->data['merchant_paypal_v2_mode']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_paypal_v2_card_fee",
                  isset($this->data['merchant_paypal_v2_card_fee'])?$this->data['merchant_paypal_v2_card_fee']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_paypal_v2_client_id",
                  isset($this->data['merchant_paypal_v2_client_id'])?$this->data['merchant_paypal_v2_client_id']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_paypal_v2_secret",
                  isset($this->data['merchant_paypal_v2_secret'])?$this->data['merchant_paypal_v2_secret']:'',
                $merchant_id);   
                break;
                    
                
            case "mercadopago":
                $this->functions->updateOption("merchant_mercadopago_v2_enabled",
                  isset($this->data['merchant_mercadopago_v2_enabled'])?$this->data['merchant_mercadopago_v2_enabled']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_mercadopago_v2_mode",
                  isset($this->data['merchant_mercadopago_v2_mode'])?$this->data['merchant_mercadopago_v2_mode']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_mercadopago_v2_card_fee",
                  isset($this->data['merchant_mercadopago_v2_card_fee'])?$this->data['merchant_mercadopago_v2_card_fee']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_mercadopago_v2_client_id",
                  isset($this->data['merchant_mercadopago_v2_client_id'])?$this->data['merchant_mercadopago_v2_client_id']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_mercadopago_v2_client_secret",
                  isset($this->data['merchant_mercadopago_v2_client_secret'])?$this->data['merchant_mercadopago_v2_client_secret']:'',
                $merchant_id);   
                break;
                    
            case "atz":
                $this->functions->updateOption("merchant_enabled_autho",
                  isset($this->data['merchant_enabled_autho'])?$this->data['merchant_enabled_autho']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_mode_autho",
                  isset($this->data['merchant_mode_autho'])?$this->data['merchant_mode_autho']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_autho_api_id",
                  isset($this->data['merchant_autho_api_id'])?$this->data['merchant_autho_api_id']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_autho_key",
                  isset($this->data['merchant_autho_key'])?$this->data['merchant_autho_key']:'',
                $merchant_id);   
                break;
                    
            case "btr": 
               $this->functions->updateOption("merchant_btr_enabled",
                  isset($this->data['merchant_btr_enabled'])?$this->data['merchant_btr_enabled']:'',
                $merchant_id);   
                $this->functions->updateOption("merchant_btr_mode",
                  isset($this->data['merchant_btr_mode'])?$this->data['merchant_btr_mode']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_sanbox_brain_mtid",
                  isset($this->data['mt_sanbox_brain_mtid'])?$this->data['mt_sanbox_brain_mtid']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_sanbox_brain_publickey",
                  isset($this->data['mt_sanbox_brain_publickey'])?$this->data['mt_sanbox_brain_publickey']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_sanbox_brain_privateckey",
                  isset($this->data['mt_sanbox_brain_privateckey'])?$this->data['mt_sanbox_brain_privateckey']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_live_brain_mtid",
                  isset($this->data['mt_live_brain_mtid'])?$this->data['mt_live_brain_mtid']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_live_brain_publickey",
                  isset($this->data['mt_live_brain_publickey'])?$this->data['mt_live_brain_publickey']:'',
                $merchant_id);   
                $this->functions->updateOption("mt_live_brain_privateckey",
                  isset($this->data['mt_live_brain_privateckey'])?$this->data['mt_live_brain_privateckey']:'',
                $merchant_id);   
              break;
              
            case "rzr": 
               $this->functions->updateOption("merchant_rzr_enabled",
                  isset($this->data['merchant_rzr_enabled'])?$this->data['merchant_rzr_enabled']:'',
               $merchant_id);    
               
               $this->functions->updateOption("merchant_rzr_mode",
                  isset($this->data['merchant_rzr_mode'])?$this->data['merchant_rzr_mode']:'',
               $merchant_id);    
               
               $this->functions->updateOption("merchant_razor_key_id_sanbox",
                  isset($this->data['merchant_razor_key_id_sanbox'])?$this->data['merchant_razor_key_id_sanbox']:'',
               $merchant_id);    
               
               $this->functions->updateOption("merchant_razor_secret_key_sanbox",
                  isset($this->data['merchant_razor_secret_key_sanbox'])?$this->data['merchant_razor_secret_key_sanbox']:'',
               $merchant_id);    
               
               $this->functions->updateOption("merchant_razor_key_id_live",
                  isset($this->data['merchant_razor_key_id_live'])?$this->data['merchant_razor_key_id_live']:'',
               $merchant_id);    
               
               $this->functions->updateOption("merchant_razor_secret_key_live",
                  isset($this->data['merchant_razor_secret_key_live'])?$this->data['merchant_razor_secret_key_live']:'',
               $merchant_id);    
              break;  
                
            case "vog":
                $this->functions->updateOption("merchant_vog_enabled",
                  isset($this->data['merchant_vog_enabled'])?$this->data['merchant_vog_enabled']:'',
               $merchant_id);    
               $this->functions->updateOption("merchant_vog_merchant_id",
                  isset($this->data['merchant_vog_merchant_id'])?$this->data['merchant_vog_merchant_id']:'',
               $merchant_id);    
                break;  
                
            default:
                $this->msg = translate("Payment settings not available");
                $this->output();
                break;
        }
        
        $this->code = 1;
        $this->msg = ("Setting saved");
        $this->details = array();       
        $this->output();
    }



 public function ReceiveBankList()
{
    $merchant_id = $this->validateToken();

    $page_limit = $this->MerchantWrapper->paginateLimit();

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $page_limit;
    } else {
        $page = 0;
    }

    $refresh = isset($this->data['refresh']) ? (int)$this->data['refresh'] : 0;
    $search_string = isset($this->data['s']) ? trim($this->data['s']) : '';
    if (!empty($search_string)) {
        $refresh = 1;
    }

    if ($resp = $this->MerchantWrapper->getAllBankDeposit($merchant_id, $page, $page_limit, $search_string)) {
        $data = array();
        foreach ($resp as $val) {
            $data[] = array(
                'id' => $val['id'],
                'name' => stripslashes($val['customer_name']),
                'description' => "Branch code:" . stripslashes($val['branch_code']),
                'thumbnail' => $this->FoodItemWrapper->getImage($val['scanphoto']),
                'status' => $val['status'],
                'date_created' => "Date:" . $this->functions->prettyDate($val['date_of_deposit']) .
                                  " Time " . $this->functions->prettyTime($val['time_of_deposit']) .
                                  " Amount:" . $this->functions->prettyPrice($val['amount'])
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'set_list_column',
            'refresh' => $refresh,
            'data' => $data
        );
    } else {
        if (isset($this->data['page'])) {
            $this->code = 1;
            $this->details = array(
                'next_action' => 'end_of_list',
                'refresh' => $refresh
            );
        } else {
            $this->code = 1;
            $this->msg = "No results";
            $this->details = array(
                'next_action' => 'clear_list'
            );
        }
    }

    $this->output();
}

	
	public function ReceiveBankID()
	{
		$this->msg = ("Edit function is not available");
		$this->output();
	}
	
	public function ReceiveBankDelete()
	{
		$this->msg = ("Delete function is not available");
		$this->output();
	}

	public function SaveSocialSettings()
    {
        $merchant_id = $this->validateToken();
        
        $this->functions->updateOption("facebook_page",
        isset($this->data['facebook_page'])?$this->data['facebook_page']:'',
        $merchant_id);   
        
        $this->functions->updateOption("twitter_page",
        isset($this->data['twitter_page'])?$this->data['twitter_page']:'',
        $merchant_id);   
        
        $this->functions->updateOption("google_page",
        isset($this->data['google_page'])?$this->data['google_page']:'',
        $merchant_id);   
        
        $this->code = 1;
        $this->msg = ("Settings saved");
        $this->output();
    }

    public function getSocialSettings()
{
    $merchant_id = $this->validateToken();

   

    $settings[]=array(
      'option_name'=>"facebook_page",
      'option_value'=>$this->functions->getOption('facebook_page', $merchant_id)
    );
    $settings[]=array(
      'option_name'=>"twitter_page",
      'option_value'=>$this->functions->getOption('twitter_page', $merchant_id)
    );
    $settings[]=array(
      'option_name'=>"google_page",
      'option_value'=>$this->functions->getOption('google_page', $merchant_id)
    );
    $this->code = 1;
    $this->msg = "OK";
    $this->details = array(
      'next_action'=>"set_form_options",
      'data'=>$settings
    );
    $this->output();
}

public function getAlertNotification()
{
    $merchant_id = $this->validateToken();      
    $settings[]=array(
      'option_name'=>"merchant_notify_email",
      'option_value'=>$this->functions->getOption('merchant_notify_email', $merchant_id)
    );
    $settings[]=array(
      'option_name'=>"merchant_cancel_order_email",
      'option_value'=>$this->functions->getOption('merchant_cancel_order_email', $merchant_id)
    );
    $settings[]=array(
      'option_name'=>"merchant_cancel_order_phone",
      'option_value'=>$this->functions->getOption('merchant_cancel_order_phone', $merchant_id)
    );
    
    $settings[]=array(
      'option_name'=>"merchant_invoice_email",
      'option_value'=>$this->functions->getOption('merchant_invoice_email', $merchant_id)
    );
    
    $this->code = 1;
    $this->msg = "OK";
    $this->details = array(
      'next_action'=>"set_form_options",
      'data'=>$settings
    );
    $this->output();
}

public function order_list()
	{
       

         
		 $merchant_id = $this->validateToken();  

       
         
            
            
				
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		$date_now = date('Ymd');
		
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $page_id  = isset($this->data['page_id'])?$this->data['page_id']:'';
        $new  = isset($this->data['new'])?$this->data['new']:false;
        $order_type  = isset($this->data['order_type'])?$this->data['order_type']:'';
        
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
                                
        $task_remarks = ''; $task_status=''; $task_color = 'orange';

        //$order_type='incoming';
       // $new=false;
        $data=array(
        'new'=>$new,
        'order_type'=>$order_type,
        'merchant_id'=>$merchant_id,
        'page_limit'=>$page_limit,
        'page'=>$page,
        'search_string'=>$search_string,
        );



    
                      
		if ($resp = $this->OrderWrapper->getAllOrder($new,$order_type,$merchant_id,$page,$page_limit,$search_string)){	

						
			$stmt = "SELECT FOUND_ROWS() as total_row";
			$total = 0;

			$query = $this->db->query($stmt);
			if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
			    $total = $res['total_row'];
			}
					
										
			$data = array();$x=0;
			foreach ($resp as $val) {	
		
				

				
				/*MC*/
				$used_currency = isset($val['used_currency'])?$val['used_currency']: $this->default_currency;				
						
						
				$pre_order = 0; $pre_order_msg='';
				$delivery_date=$val['delivery_date'];
				$delivery_date=date("Ymd",strtotime($delivery_date));				
				$datediff = $this->functions->dateDifference($delivery_date,$date_now);
				
				
				if($delivery_date>$date_now){					
					$pre_order = 1;
					$dtime = date("g:ia",strtotime($val['delivery_time']));
					

					$pre_order_msg = "This is advance order on ".$this->functions->prettyDate($val['delivery_date']);


				}
								
				$delivery_time = $this->functions->prettyTime($val['delivery_time']);
				if($val['delivery_asap']==1){					
					$delivery_time = ("Deliver ASAP");
				}			
								
				$duration='';
				
				
			
				
				
							
				if($val['request_from']=='pos'){
					
					$order_number=$val['merchant_id'].'-'.$val['order_number'];
					
				$orders=("Order No.#").$val['merchant_id'].'-'.$val['order_number']; 
				}else if($val['request_from']=='webappv2'){
					
					$order_number=$val['merchant_id'].'-'.$val['order_number'];
					
				$orders=("Order No.#").$val['merchant_id'].'-'.$val['order_number']; 
				}else{

					

					$orders="Order No. #".$val['order_id'];
					
				}
				
				
				

							
								
				$data[] = array(
				  'order_id'=>$val['order_id'],
				  'order_no'=>$orders,
				  'total_items'=>$val['total_items'],
				  

				  'items'=>"Items for ".stripslashes($val['customer_name']),

				  'delivery_date'=>$val['delivery_date'],
				  'date_created'=>$val['date_created'],
				  'total_order_amount'=>$this->functions->formatNumber($val['total_order_amount']),
				  'status'=>($val['status']),
				  'status_raw'=>$val['status_raw'],
				  'request_from'=>$val['request_from'],
				  
				  'order_number'=>$order_number,
				  
				  'trans_type'=>($val['trans_type']),
				  'trans_type_raw'=>$val['trans_type_raw'],
				  'estimated_time'=>$val['estimated_time'],
				  'estimated_date_time'=>date("Y-m-d H:i:s",strtotime($val['estimated_date_time'])),
				  'date_created_raw'=>date("Y-m-d H:i:s",strtotime($val['date_created'])),
				  'date_created_now'=>date("Y-m-d H:i:s"),
				  'date_modified'=>date("Y-m-d H:i:s",strtotime($val['date_modified'])),
				  'timezone'=>date_default_timezone_get(),
				  'pre_order'=>$pre_order,
				  'pre_order_msg'=>$pre_order_msg,
				  'request_cancel'=>$val['request_cancel'],
				  'delivery_time'=>$delivery_time,
				  'assigned_driver'=>isset($val['assigned_driver'])?(integer)$val['assigned_driver']:0,
				  'duration'=>$duration,
				  'driver_id'=>'',
				  'driver_name'=>'',
				  'driver_photo'=>'',
				  'task_status'=>$task_status,
				  'task_color'=>$task_color,
				  'task_remarks'=>$task_remarks
				);	




				
				$x++;
			}		
													
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_order_list',
			 'refresh'=>$refresh,
			 'total'=>$total,
			 'data'=>$data,
			 'page_id'=>$page_id
			);							
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list_no_order',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}						
		$this->output();
	}


	public function AcceptOrder()
	{		
		$merchant_id = $this->validateToken();
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		$order_id  = isset($this->data['order_id'])?(integer)$this->data['order_id']:0;
		$time = isset($this->data['reason'])?(integer)$this->data['reason']:0;
		
		if($time<=0){
		   $this->msg = ("Time estimation is required");
		   $this->output();	
		}	
		
		if(!$order = $this->OrderWrapper->validateOrder($merchant_id,$order_id)){
			$this->msg = ("Order not found");
		    $this->output();	
		}		
				
		if($order_id>0){
			
			/*check if merchant can change the status*/
			if(!$this->OrderWrapper->canChangeOrderStatus($order)){
				$this->msg=("Sorry but you cannot change the order status anymore. Order is lock by the website admin");
				$this->details = array(
				  'next_action'=>"close_all_dialog_order",
				  'order_id'=>$order_id
				);
				$this->output();	
			}	
			
			$status = $this->OrderWrapper->getActionStatus('accept');
			
			if($this->OrderWrapper->validateChangeStatus($order_id,$status)){
			   

			   $this->msg = "This order already change to ".$status;


			   $this->output();
			}		
														  	  	    	  	  
			try {
							
				$accepted_based_time = (integer)$this->functions->getOptionAdmin('accepted_based_time');
				$accepted_based_time = $accepted_based_time>0?$accepted_based_time:1;
									
				$date_now = date('Y-m-d'); $datetime_now = date("Y-m-d g:i:s a");
				$delivery_date=date("Y-m-d",strtotime($order['delivery_date']));
				if(!empty($order['delivery_time'])){					
				   $delivery_time=date("H:i:s",strtotime($order['delivery_time']));				   
				} else {
					$delivery_time=date("H:i:s");
				}			

				$is_late = false;
				$date_created = "$delivery_date $delivery_time";
				$time_diff=$this->functions->dateDifference($date_created,$datetime_now);
				if(is_array($time_diff) && count($time_diff)>=1){
					if($time_diff['days']>0){
						$is_late = true;
					}				
					if($time_diff['hours']>0){
						$is_late = true;
					}				
					if($time_diff['minutes']>0){
						$is_late = true;
					}				
				}			
				
				if($is_late){
					$delivery_date = date('Y-m-d'); $delivery_time=date("H:i:s");
				}			
								
				if($accepted_based_time==2){					
					$date_now = date('Ymd');					
				    $delivery_date2=date("Ymd",strtotime($order['delivery_date']));				    
				    if($delivery_date2>$date_now){
				    	//
				    } else {
				    	$delivery_date = date('Y-m-d'); $delivery_time=date("H:i:s");
				    }
				}										
										
				$estimated_date_time = date("Y-m-d H:i:s",strtotime($delivery_date." ".$delivery_time));
				$estimateddatetime = date('h:ia', strtotime("+$time minutes", strtotime($estimated_date_time)));
					
				$params = array(
				  'estimated_time'=>$time,
				  'estimated_date_time'=>date('Y-m-d H:i:s', strtotime("+$time minutes", strtotime($estimated_date_time))),
				);
									
				

		  	    $up=$this->functions->updateData('mt_order_delivery_address' , $params ,'order_id',$order_id);

		  	   
		  	   
		  	   $estimated_words = "estimated food ready in ".$time." mins";		

		  	   $remarks = $estimated_words;		  	   	  	  
		  	   
		  	   /*CHECK IF DATE IS FUTURE ORDER*/
		  	   $chk_delivery_date = new DateTime($delivery_date);
		  	   $current_date = new DateTime();
		  	   
		  	   if ($chk_delivery_date > $current_date) {
		  	    	$estimated_words = "Order accepted and will be ready on time";
		  	    	$remarks = $estimated_words; 	  	  
		  	   }
		  	    		  	   
		  	   
		  	   /*CHECK IF ORDER IS ADVANCE ORDER*/		  	   
		  	   $time_diff=$this->functions->dateDifference($datetime_now,$date_created);
		  	   if(is_array($time_diff) && count($time_diff)>=1){
		  	   	  if($time_diff['hours']>0){
					 $estimated_words = "order will be ready in ".$estimateddatetime;
					

					  $remarks = $estimated_words;

				  }							  
				  if($time_diff['minutes']>30){
					 $estimated_words = "order will be ready in ".$estimateddatetime;
					 $remarks = $estimated_words;
				  }							  
		  	   }
		  	   		  	   		  	  		  	   		  	   	  	        	  	   		  	   		  
		  	   $params = array(
				  'order_id'=>$order_id,
				  'status'=>$status,
				  'remarks'=>$remarks,
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR'],
				  'remarks2'=>$estimated_words,
				  'remarks_args'=>json_encode(
				  array( 
				   'minute'=>$time,
				   'estimated_time'=>$estimateddatetime
				   )),				  
			   );	
			   
	           $params2 = array(
				  'status'=>$status,
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);	
				  	    
	  	       $this->OrderWrapper->updateOrderHistory($order_id,$merchant_id,$params,$params2);
	  	       $this->code = 1;
		  	   $this->msg = "OK";
		  	   $this->details = array(
		  	      'next_action'=>"pop_dialog_order",
		  	      'order_id'=>$order_id,
		  	      'action_taken'=>'accepted'
		  	   );
		  	   
		  	   /*SEND NOTIFICATION*/
		  	  		  	   	   
			  	   $this->functions->notifyCustomerOrderStatusChange(
					  $order_id,
					  $status,
					  $remarks
				   );
		  	  		  	  
		  	  
		  	  
		  	  
            		   
			
			/*UPDATE POINTS BASED ON ORDER STATUS*/
			    						    					
				
			   $this->PointsProgram->updateOrderBasedOnStatus($status,$order_id);
				
				
			   $this->PointsProgram->udapteReviews($order_id,$status);
											
			
			
			/*INVENTORY ADDON*/				
			
			if ($this->functions->inventoryEnabled($merchant_id)){
				try {							  
				   $this->InventoryWrapper->insertInventorySale($order_id,strtolower($status));	
				} catch (Exception $e) {										    
				  // echo $e->getMessage();		    					    	  
				}		    					    	
			}
			
		  	    
	  	    } catch (Exception $e) {
				$this->msg = ($e->getMessage());
			}	  	    	  	    
		} else $this->msg = ("Invalid order id");			
		$this->output();
	}

	public function OrderOptions()
	{
		$merchant_id = $this->validateToken();		
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		$order_id  = isset($this->data['order_id'])?(integer)$this->data['order_id']:0;
		$cancel_action = isset($this->data['cancel_action'])?$this->data['cancel_action']:'';
		$reason = isset($this->data['reason'])?$this->data['reason']:'';
		$notes = isset($this->data['notes'])?$this->data['notes']:'';
						
		$status = $this->OrderWrapper->getActionStatus($cancel_action);
		
		$remarks = ''; $remarks2 = ''; $remarks_args=array();		
		
		if(!$order = $this->OrderWrapper->validateOrder($merchant_id,$order_id)){
			$this->msg = ("Order not found");
		    $this->output();	
		}
				


		/*check if merchant can change the status*/
		if(!$this->OrderWrapper->canChangeOrderStatus($order)){
			$this->msg=("Sorry but you cannot change the order status anymore. Order is lock by the website admin");
			$this->details = array(
			  'next_action'=>"close_all_dialog_order",
			  'order_id'=>$order_id
			);
			$this->output();	
		}	
				
		switch ($cancel_action) {
			case "cancel_order":
			case "decline":  				
				if(empty($reason)){
				   $this->msg = ("Reason is required");
		 		   $this->output();
				}				
				if(!empty($notes) || !empty($reason)){					
					
					$remarks = !empty($notes)?$reason." additional comments: ".$notes:$reason;
					$remarks_args = array(
					  'reason'=>$reason,
		   	    	  'comment'=>$notes
					);

					

				}						
				break;
		
			case "delay_order":
				if(empty($reason)){
				   $this->msg = ("Additional time is required");
		 		   $this->output();
				}								
				$remarks = $reason." minutes delayed";
				$remarks_args = array(
				   'min'=>$reason
				);
				
				if(!empty($notes)){
		   	    	
		   	    	$remarks = $reason."minutes delayed, additional comments: ".$notes;
		   	    	$remarks_args = array(
					   'min'=>$reason,
					   'comment'=>$notes
					);

				

				}						
				break;
				
			case "manual_change_status":
												    		
			    if(empty($reason)){
				   $this->msg = ("Order status is required");
		 		   $this->output();
				}
			   $status = $reason;			
			   if(!empty($notes)){
					$remarks = "additional comments: ".$notes;
					$remarks_args = array(					  
		   	    	  'comment'=>$notes
					);
				}	
			   break;
			   
			case "food_is_done":				
				if(!empty($notes)){					
					$remarks = "additional comments: ".$notes;
					$remarks_args = array(
					  'reason'=>$reason,
		   	    	  'comment'=>$notes
					);
				}						
			   break;	 
			   
			case "approved_cancel_order":   			   
			   if(!empty($notes)){					
					$remarks = "additional comments: ".$notes;
					$remarks_args = array(
					  'reason'=>$reason,
		   	    	  'comment'=>$notes
					);
				}		
			break;	 
			
			case "decline_cancel_order":
				if(empty($reason)){
				   $this->msg = ("Reason is required");
		 		   $this->output();
				}
				if(!empty($notes)){					
					$remarks = $reason.", additional comments:".$notes;
					$remarks_args = array(
					  'reason'=>$reason,
		   	    	  'comment'=>$notes
					);
				}		
			break;	
			   						   
			default:
				break;
		}
		
		try {
						
			
			/*HISTORY*/						
			$remarks2 = $remarks;
			$params = array(
			  'order_id'=>$order_id,
			  'status'=>$status,
			  'remarks'=>$remarks,
			  'remarks2'=>$remarks2,
			  'remarks_args'=>json_encode($remarks_args),
			  'notes'=>$notes,			  
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']			  
			);	
			
			$reason = $params['remarks'];
			
			/*ORDER*/
			$params2 = array(
			  'status'=>$status,
			  'date_modified'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			);
					
			if($cancel_action=="approved_cancel_order"){
				$params2['request_cancel']=2;
				$params2['request_cancel_status']='approved';			
			} else if ($cancel_action=="decline_cancel_order") {				
				$params2['request_cancel']=2;
				$params2['request_cancel_status']='decline';
				unset($params2['status']);				
				$params['status']='decline';
			}


						
							
			$this->OrderWrapper->updateOrderHistory($order_id,$merchant_id,$params,$params2);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>"pop_dialog_order",
			  'order_id'=>$order_id
			);

			
			
			
			switch ($cancel_action) {
								
				case "delay_order":							    
				    //$this->OrderWrapper->updateEstimationTime($order_id,(float)$reason);	
				    //$this->OrderWrapper->updateTaskDeliveryDate($order_id,(float)$reason);							    				   
					break;
					
				case "decline":
					//$this->OrderWrapper->updateTaskStatus($order_id,"declined");
					break;
					
				case "cancel_order":	
				    //$this->OrderWrapper->updateTaskStatus($order_id,"cancelled");
				    break;
				    
				case "food_is_done":   
				    break;
												
				default:
					break;
			}
						
            /*SEND NOTIFICATION*/
		    		  	   	   
		  	   $this->functions->notifyCustomerOrderStatusChange(
				  $order_id,
				  $status,
				  $reason
			   );
	  	    	
	  	    
	  	    /*SEND PUSH TO DRIVER*/
	  	    
	  	    
	  	    	   
			
			/*UPDATE POINTS BASED ON ORDER STATUS*/
				    						    					
				
			   $this->PointsProgram->updateOrderBasedOnStatus($status,$order_id);
				
				
			   $this->PointsProgram->udapteReviews($order_id,$status);
										
			
			
			/*INVENTORY ADDON*/				
			
			if ($this->functions->inventoryEnabled($merchant_id)){
				try {							  
				   $this->InventoryWrapper->insertInventorySale($order_id,strtolower($status));	
				} catch (Exception $e) {										    
				  // echo $e->getMessage();		    					    	  
				}		    					    	
			}
			
			
		} catch (Exception $e) {
			$this->msg = ($e->getMessage());
		}
		$this->output();
	}


	public function OrderDetails()
	{				
		try {
			
			$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;			
			$merchant_id = $this->validateToken();
			
			$this->MerchantWrapper->setMerchantTimezone($merchant_id);
			
		    $order_id  = isset($this->data['order_id'])?(integer)$this->data['order_id']:0;		
		    
			$resp = $this->OrderWrapper->prepareReceipt($order_id);

			
            
           
			
						
			
			$resp['timezone'] = date_default_timezone_get();

			
			$history = array();
			if($res = $this->OrderWrapper->getOrderHistory($order_id)){
			   foreach ($res as $val) {
			   	  $remarks = $val['remarks'];
			   	  if(!empty($val['remarks2']) && !empty($val['remarks_args']) ){
		           	   $remarks_args = json_decode($val['remarks_args'],true);
		           	   if(is_array($remarks_args) && count($remarks_args)>=1){
		           	   	  $new_arrgs = array();
		           	   	  foreach ($remarks_args as $remarks_args_key=>$remarks_args_val) {
		           	   	  	$new_arrgs[$remarks_args_key]= $remarks_args_val;
		           	   	  }		           	   	  
		           	      //$remarks = Yii::t("driver",$val['remarks2'],$new_arrgs);
		           	      $remarks = $val['remarks2']." ".$new_arrgs; 
		           	   }
		           }
			      $history[]=array(
			         'date_created'=>$this->OrderWrapper->prettyDateTime($val['date_created']),
			         'status'=>($val['status']),
			         'remarks'=>!empty($remarks)?$remarks:''
			      );		
			   }				  
			}
			
				

	  	    $this->functions->updateData('mt_order' , array(
			  'merchantapp_viewed'=>1,
			  'viewed'=>1
			) ,'order_id',$order_id);
	  	    	  	    									
			$this->code = 1; $this->msg = "OK";
			$this->details = array(
			 'next_action'=>"display_order_details",
			 'refresh'=>$refresh,
			 'data'=>$resp,
			 'history'=>$history,			 
			);																			
		} catch (Exception $e) {
		    $this->msg = ($e->getMessage());
		}		
		$this->output();
	}
	
	public function refresh_order(){
		$order_ids = '';
		$merchant_id = $this->validateToken();		
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		if(empty($this->data['order_id'])){		   			
			//
		} else {			
			$id = isset($this->data['order_id'])?explode(",",$this->data['order_id']):'';	
			if(is_array($id) && count($id)>=1){
				foreach ($id as $val_id) {
					 $order_ids .= "'" . addslashes($val_id) . "',";
				}
				$order_ids = substr($order_ids,0,-1);
			} 
		}
		
		$need_refresh = false;
				
		if($resp = $this->OrderWrapper->getNewestOrder($order_ids, $merchant_id )){			
		   $this->msg = 1;
		   $need_refresh = true;
		} else {			
			if(!empty($order_ids)){
				if ( $this->OrderWrapper->reheckNewestOrder($order_ids, $merchant_id)){
					$need_refresh = true;
				}			
			}		
		}						
				
		if($need_refresh){
		   $this->code = 1;		   
		   $this->details = array(
		     'next_action'=>"refresh_oder",
		     'datenow'=>date('c')
		   );
		} else {
		   $this->details = array(
		     'next_action'=>"silent",
		     'datenow'=>date('c')
		   );
		}	
		$this->output();
	}


	public function refresh_cancel_order(){
		$order_ids = '';
		$merchant_id = $this->validateToken();		
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		if(empty($this->data['order_id'])){		   			
			//
		} else {			
			$id = isset($this->data['order_id'])?explode(",",$this->data['order_id']):'';	
			if(is_array($id) && count($id)>=1){
				foreach ($id as $val_id) {
					
					 $order_ids .= "'" . addslashes($val_id) . "',";
				}
				$order_ids = substr($order_ids,0,-1);
			} 
		}
		
		$need_refresh = false;
						
		if($resp = $this->OrderWrapper->getNewestCancel($order_ids,$merchant_id)){
		   $this->msg = 1;
		   $need_refresh = true;
		}		
				
		if($need_refresh){
		   $this->code = 1;		  
		   $this->msg = ("There are new cancel order request");
		   $this->details = array(
		     'next_action'=>"new_cancel_order",
		     'datenow'=>date('c')
		   );
		} else {
		   $this->details = array(
		     'next_action'=>"clear_new_cancel_badge",
		     'datenow'=>date('c')
		   );
		}	
		$this->output();
	}
	
	public function getProfile()
	{		
		try {
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
			$data = array(
			  'username'=>stripslashes($resp['username']),
			  'email_address'=>stripslashes($resp['email_address']),
			  'mobile_number'=>stripslashes($resp['contact_number']),
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
		     'next_action'=>"fill_profile",
		     'data'=>$data
		   );
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}

	public function saveProfile()
	{		
		try {
		    $resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);
		    $id = $resp['id'];
		    $user_type = $resp['user_type'];
		    if($resp['user_type']=="merchant"){
		    	$params = array(
		    	  'username'=>$this->data['username'],
				  'contact_phone'=>$this->data['mobile_number'],
				  'contact_email'=>$this->data['email_address'],
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);
		    } else {
		    	$params = array(
		    	  'username'=>$this->data['username'],
				  'contact_number'=>$this->data['mobile_number'],
				  'contact_email'=>$this->data['email_address'],
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);
		    }	

		    	
		    $this->MerchantUserWrapper->updateProfile($id,$user_type,$params);
		   
		    $this->code = 1;
		    $this->msg = ("Profile saved");
		    $this->details = array();
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}


	   public function OrderDetails_auto1()
	{				
		try {
			$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;			
			$merchant_id = $this->validateToken();
			$this->MerchantWrapper->setMerchantTimezone($merchant_id);
			$order_id  = isset($this->data['order_id'])?(integer)$this->data['order_id']:0;		
		    $resp = $this->OrderWrapper->prepareReceipt_auto($order_id);
			$resp['timezone'] = date_default_timezone_get();
			
			

			$this->functions->updateData('mt_order', array(
                'merchantapp_viewed'=>1,
                'viewed'=>1,
                 'auto_print'=>1
            ), 'order_id', $order_id);


	  	    $this->code = 1; $this->msg = "OK";
			$this->details = array('next_action'=>"display_order_details_auto",'refresh'=>$refresh,'data'=>$resp);}
			catch (Exception $e) {$this->msg = translate($e->getMessage());}		
			$this->output();
	}




	public function OrderDetails_auto()
	{
		$merchant_id = $this->validateToken();			
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		$date_now = date('Ymd');
		$page_limit = $this->MerchantWrapper->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $page_id  = isset($this->data['page_id'])?$this->data['page_id']:'';
        $new  = isset($this->data['new'])?$this->data['new']:false;
        $order_type  = isset($this->data['order_type'])?$this->data['order_type']:'';
        
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
                                
        $task_remarks = ''; $task_status=''; $task_color = 'orange';
        //$driver_task = Yii::app()->db->schema->getTable("{{driver_task}}");
         $is_auto_print=0;  
		$is_auto_print = 	$this->functions->getOption('auto_print',$merchant_id);
        if($is_auto_print=='1'){
           
		$resp1 = $this->OrderWrapper->getAllOrder_print($new,$order_type,$merchant_id,$page,$page_limit,$search_string);
		$resp['data2']=[];
		if(isset($resp1)){
		foreach ($resp1 as $val) {
			$order_id=$val['order_id'];
			$data = $this->OrderWrapper->prepareReceipt_auto($order_id);
            
            /*$this->msg=$data;
			$this->output();*/

			$resp['data2'][] = ($data);
		
				
		}
		$this->code = 1; $this->msg = "OK";
		$this->details = array('next_action'=>"display_order_details_auto",'refresh'=>$refresh,'data1'=>$resp);	
		$this->output();
		
		}else{
			
		$this->code = 1; $this->msg = "OK";
		$this->details = array('next_action'=>"display_order_details_auto",'refresh'=>$refresh,'data1'=>'');	
		$this->output();
			
		}
		
		}else{
		$this->code = 1; $this->msg = "";
		$this->details = array('next_action'=>"display_order_details_auto",'refresh'=>$refresh,'data1'=>'');	
		$this->output();
		}
		
		
	}






	
	public function changePassword()
	{
		
		if(trim($this->data['new_password'])!= trim($this->data['repeat_password']) ){
			$this->msg = ("Confirm password does not match");
			$this->output();
		}
		
		try {
		    $resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);
		    $id = $resp['id'];
		    $user_type = $resp['user_type'];		    
		    $params = array(
		      'password'=>md5( trim($this->data['new_password']) ),
		      'date_modified'=>$this->functions->dateNow(),
		      'ip_address'=>$_SERVER['REMOTE_ADDR']
		    );
		    		    
		    $this->MerchantUserWrapper->changePassword($id,$user_type,$params, md5($this->data['old_password']) );
		    
		    $this->code = 1;
		    $this->msg = ("Change password succesful");
		    $this->details = array(
		      'next_action'=>"pop_form2"
		    );
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function setPin()
	{
		
		if(trim($this->data['pin'])!= trim($this->data['confirm_pin']) ){
			$this->msg = ("Confirm pin does not match");
			$this->output();
		}
		
		if (strlen($this->data['pin'])!=4){
			$this->msg = ("Invalid pin please enter 4 digit");
			$this->output();
		}	
				
		if ($this->data['pin']==0000){		
			$this->msg = ("Invalid pin 0000 is not allowed");
			$this->output();
		}	
		
		try {
		    $resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);
		    $id = $resp['id'];
		    $user_type = $resp['user_type'];		
		        
		    $params = array(
		      'pin'=>trim($this->data['pin']),
		      'date_modified'=>$this->functions->dateNow(),
		      'ip_address'=>$_SERVER['REMOTE_ADDR']
		    );
		    
		   $this->MerchantUserWrapper->changePin($id,$user_type,$params);
		    
		    $this->code = 1;
		    $this->msg = ("Change pin succesful");
		    $this->details = array(
		      'next_action'=>"pop_form2"
		    );
		    
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}


	public function removePin()
	{
		try {
		    $resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);
		    $id = $resp['id'];
		    $user_type = $resp['user_type'];		
		        
		    $params = array(
		      'pin'=>0,
		      'date_modified'=>$this->functions->dateNow(),
		      'ip_address'=>$_SERVER['REMOTE_ADDR']
		    );
		    		    
		    $this->MerchantUserWrapper->changePin($id,$user_type,$params);
		    
		    $this->code = 1;
		    $this->msg = ("PIN succesfully removed");
		    $this->details = array(
		      'next_action'=>"pop_form2"
		    );
		    
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function getPIN()
	{
		try {
						
			$resp = $this->MerchantUserWrapper->getPin($this->merchant_token);			
			$with_pin = 0;
			if(strlen($resp['pin'])>2){
			   $with_pin = 1;
			}						
			$data = array(			
			  'pin'=>str_split($resp['pin']),
			  'with_pin'=>$with_pin
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
		      'next_action'=>$with_pin==1?"remove_pin":'show_pin',
		      'data'=>$data
		    );		    
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function getLanguageList()
	{
		$data = array();
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		$merchantapp_language = $this->functions->getOptionAdmin('merchantapp_language');
		$language = !empty($merchantapp_language)?json_decode($merchantapp_language,true):'';
		
		

		$icon_url = Config::$baseUrl."/assets_merchantapp/vendor/flag-icon/flags/1x1";
		
		if(is_array($language) && count($language)>=1){			
			foreach ($language['label'] as $key=>$val) {
				$flag =  strtolower($language['flag'][$key]) .".svg";
				$data[] = array(
				  'value'=>$key,
				  'label'=>($val),				  
				  'sub_label'=>$language['sub_label'][$key],	
				  'image'=>$icon_url."/$flag"
				);
			}			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>"set_language",
			  'refresh'=>$refresh,
			  'data'=>$data
			);
		} else {
		    $this->code = 1;
			$this->msg = ("There are no available language");
			$this->details = array(
			  'next_action'=>'clear_list_language',
			);
		}			
		$this->output();
	}
	
	public function GetAlertSettings()
	{
		try {
		   $merchant_id = $this->validateToken();
		   $resp = $this->MerchantUserWrapper->GetDeviceInformation($this->device_uiid);
		   $this->code =1;
		   $this->msg = "OK";
		   $this->details = array(
		     'next_action'=>"set_alert_settings",
		     'data'=>$resp
		   );		   
		} catch (Exception $e) {			
		   $this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function saveAlertOrder()
	{		
		try {
		   $push_enabled = isset($this->data['push_enabled'])?(integer)$this->data['push_enabled']:0;		
		   $params = array(
		     'push_enabled'=>$push_enabled,
		     'date_modified'=>$this->functions->dateNow(),
		     'ip_address'=>$_SERVER['REMOTE_ADDR']
		   );
		   $this->MerchantUserWrapper->UpdateDevice($this->device_uiid,$params);
		   $this->code = 1;
		   $this->msg = ("Setting saved");
		} catch (Exception $e) {			
		   $this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function saveSubsribe()
	{
		try {		   
		   $subscribe_topic = isset($this->data['push_alert'])?(integer)$this->data['push_alert']:0;		
		   $params = array(
		     'subscribe_topic'=>$subscribe_topic,
		     'date_modified'=>$this->functions->dateNow(),
		     'ip_address'=>$_SERVER['REMOTE_ADDR']
		   );		   
		   //dump($params);
		   $this->MerchantUserWrapper->UpdateDevice($this->device_uiid,$params);
		   $this->code = 1;
		   $this->msg = ("Setting saved");
		} catch (Exception $e) {			
		   $this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function logoutApp()
	{
		try {	
			$this->MerchantUserWrapper->UpdateDeviceStatus($this->device_uiid,'inactive');					
		} catch (Exception $e) {			
			//			
		}	
		
		$this->code = 1;
		$this->msg = "ok";
		$this->details = array(
		  'next_action'=>'silent',
		);
		$this->output();
	}
	
	public function ValidatePin()
	{				
		$pin = isset($this->data['pin'])?(string)$this->data['pin']:0;						
		try {	
			$this->MerchantUserWrapper->validatePin($this->merchant_token,$pin);		
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);				
			$this->code = 1; $this->msg = "OK";
			
			$data['next_action']="show_homepage";
			$data['merchant_info'] = $resp;					
			$this->details = $data;			
			
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}

	public function forgotPin()
	{			
		try {
			$email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
			$resp = $this->MerchantUserWrapper->getUserByEmail($email_address);					
			$code = $this->MerchantUserWrapper->generatePin($resp['id'],$resp['merchant_id']);			
			$merchant_id = $resp['merchant_id'];
						
			$lang="en";
			$tpl  = $this->functions->getNotificationTemplate('merchant_change_pin',$lang);
			
			$this->MerchantUserWrapper->changePin($resp['id'],$resp['user_type'],array(
			  'pin'=>$code,
		      'date_modified'=>$this->functions->dateNow(),
		      'ip_address'=>$_SERVER['REMOTE_ADDR']
			));			
			
			$to = $resp['email_address'];
			
			$email_content = $tpl['email_content'];
			$email_subject = $tpl['email_subject'];	
			
			$data = array(
			  'code'=>$code,
			  'sitename'=>$this->functions->getOptionAdmin('website_title'),
		      'siteurl'=>$this->functions->websiteUrl()
			);
			
			$email_subject = $this->functions->replaceTags($email_subject,$data);			
			$email_content = $this->functions->replaceTags($email_content,$data);	
			
			$this->functions->sendEmail($to,'',$email_subject,$email_content);
						
			$this->code =1; $this->msg = ("We have sent new pin code in your email.");
			$this->details = array(
			   'next_action'=>"back_to_pin",			   
			);			
			
		} catch (Exception $e) {
			$this->msg = ($e->getMessage());
		}			
		$this->output();
	}




	public function booking_list()
{
	$merchant_id = $this->validateToken();	
	
		
	$this->MerchantWrapper->setMerchantTimezone($merchant_id);
	
	$date_now = date('Y-m-d');
	
	$page_limit = $this->MerchantWrapper->paginateLimit();
	
	if (isset($this->data['page'])){
		$page = $this->data['page'] * $page_limit;
	} else {
		$page = 0;
	}

	$refresh  = isset($this->data['refresh']) ? (integer)$this->data['refresh'] : 0;
	$page_id  = isset($this->data['page_id']) ? $this->data['page_id'] : '';        
	$booking_type  = isset($this->data['booking_type']) ? $this->data['booking_type'] : '';
	
	$search_string  = isset($this->data['s']) ? trim($this->data['s']) : '';
	if (!empty($search_string)) {
		$refresh = 1;
	}
			
	if ($resp = $this->BookingWrapper->getAllBooking($booking_type, $merchant_id, $page, $page_limit, $search_string)) {
		
		// Replaced Yii query with native PDO
		$stmt = "SELECT FOUND_ROWS() as total_row"; 
		$total = 0;
		if ($res = $this->db->query($stmt)) {
			$row = $res->fetch(PDO::FETCH_ASSOC);
			if ($row) {
				$total = $row['total_row'];
			}
		}					

		$data = array();
		foreach ($resp as $val) {
			
			$stats = $val['status'];
			if ($stats == "request_cancel_booking") {
				$stats = "request to cancel";
			} elseif ($stats == "cancel_booking_approved") {
				$stats = "cancellation approved";
			}
			
			$val['date_created'] = $val['date_created'];
			$val['status'] = $stats;
			$val['timezone'] = date_default_timezone_get(); // Replaced Yii timeZone
			$data[] = $val;
		}
		
		$this->code = 1;
		$this->msg = "OK";			
		$this->details = array(
			'next_action' => 'set_booking_list',
			'refresh'     => $refresh,
			'total'       => $total,
			'data'        => $data,
			'page_id'     => $page_id
		);			
	} else {
		if (isset($this->data['page'])) {
			$this->code = 1;
			$this->details = array(
				'next_action' => 'end_of_list',
				'refresh'     => $refresh,
				'page_id'     => $page_id
			);
		} else {
			$this->code = 1;
			$this->msg = ("No results");
			$this->details = array(
				'next_action' => 'clear_list_no_booking',
				'refresh'     => $refresh,
				'page_id'     => $page_id,
				'is_search'   => !empty($search_string) ? true : false
			);
		}
	}						
	$this->output();
}



public function BookingOptions()
	{		
		$booking_id  = isset($this->data['booking_id'])?(integer)$this->data['booking_id']:0;
		$cancel_action = isset($this->data['cancel_action'])?$this->data['cancel_action']:'';
		$notes = isset($this->data['notes'])?$this->data['notes']:'';
		$reason = isset($this->data['reason'])?$this->data['reason']:'';
		$params = array(); $remarks='';

		$bookingId=$booking_id;
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
      $stmt->execute([$bookingId]);
      $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);	
					
		switch ($cancel_action) {
			case "accept":
			case "cancel_booking_approved":	
			
			     $stats = 'approved';
			     if($cancel_action=="cancel_booking_approved"){
			     	$stats='cancel_booking_approved'; 
			     }			  
				$params = array(
				  'status'=>$stats,
				  'remarks'=>$notes,
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);				
				$remarks = $notes;	

           

               if($params['status']=="approved"&&$booking_from_db['status']!="approved"){
                     $utc_times=$booking_from_db['utc_times'];
					 
					  $booking_id_google=$booking_from_db['booking_id_google'];
					 
					
					 				 

                    $this->functions->google_trigger($booking_from_db,'CONFIRMED');




                   }else{
                    
                   


                    $this->msg = $this->functions->translation("default",'Booking already approved.'); 
                    $this->output();  

                   }







				break;
				
			case "decline":	
			case "denied":  			
			   if(empty($notes) && empty($reason)){
			   	   $this->msg = ("Reason is required");
		 		   $this->output();
			   }				
			    $remarks = $notes;
		   	    if(!empty($notes)){
		   	    	

		   	    	$remarks =$reason.", additional comments: ".$notes;

		   	    }			   			   	
				$params = array(
				  'status'=>'cancel_booking_approved',
				  'remarks'=>$remarks,
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);	

               
                 if($params['status']=="cancel_booking_approved"&&$booking_from_db['status']!="cancel_booking_approved"){
                     $utc_times=$booking_from_db['utc_times'];
					 $booking_id_google=$booking_from_db['booking_id_google'];
					 $merchant_id=$booking_from_db['merchant_id'];
					 $slots_info_data=$this->functions->getslotsbyUTC_alols($utc_times,$merchant_id);
	   
					   if(isset($slots_info_data) && !empty($slots_info_data)){
						   foreach($slots_info_data as $slots_info){
						     $used_slots=$slots_info['used_slots']-1;
				       $available_slots=$slots_info['no_of_slots']-$used_slots;
					   
				       $slot_id=$slots_info['id'];
				        $params_update1=array(
				            'used_slots'=>$used_slots,
				            'available_slots'=>$available_slots,
				          );  


							 $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
						   }
						   
						   
					   }
	   
					 
					 
					 
					 
					 
					 
					 
					 
					 
					if($booking_from_db['status']=="pending"){
                    $this->functions->google_trigger($booking_from_db,"DECLINED_BY_MERCHANT");
					}else{
						$this->functions->google_trigger($booking_from_db,"CANCELED");
						
					}



                   }else{
                    

                    $this->msg = $this->functions->translation("default",'Booking already cancelled.'); 
                    $this->output();
                   }



			   break;			   						
		}
		
		if(is_array($params) && count($params)>=1){
			try {	

			  

				$this->BookingWrapper->updateBooking($booking_id,$params,$remarks);	
				
				
				
				$this->code = 1; $this->msg = "OK";
				$this->details = array(					  
				  'next_action'=>"pop_dialog_booking"
				);
			} catch (Exception $e) {
				$this->msg = ($e->getMessage());
			}	
		} else $this->msg = ("Undefined parameter");
		
		$this->output();
	}
	
	public function BookingDetails()
	{		
		try {

			$history = array();
			$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;			
		    $booking_id  = isset($this->data['booking_id'])?(integer)$this->data['booking_id']:0;
		
			$resp = $this->BookingWrapper->getBookingDetails($booking_id);
			
			

			$resp['number_guest'] = $resp['number_guest']." guest";

			$resp['status'] = ($resp['status']);
			$resp['date_booking'] = $this->functions->prettyDate($resp['date_booking']);
			$resp['booking_time'] =$this->functions->prettyTime($resp['booking_time']);
			$resp['date_created'] = $this->OrderWrapper->prettyDateTime($resp['date_created']);
			
			$history=array();
			$resph = $this->BookingWrapper->getHistory($booking_id);
			if($resph){
				
				foreach ($resph as $val) {
					$val['status'] = ($val['status']);
					$val['date_created'] = $this->functions->prettyDate($val['date_created']);
					$history[]=$val;
				}
			}		
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			 'next_action'=>"display_booking_details",
			 'refresh'=>$refresh,
			 'data'=>$resp,
			 'history'=>$history,			 
			);		
			
						
		} catch (Exception $e) {
			$this->code = 1;
			$this->details = array(
			 'next_action'=>"clear_booking_details",			 
			);		
			$this->msg = ($e->getMessage());
		}	
		$this->output();
	}
	
	public function refresh_booking()
	{
		$booking_ids = '';
		$merchant_id = $this->validateToken();		
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		if(empty($this->data['booking_id'])){		   			
			//
		} else {			
			$id = isset($this->data['booking_id'])?explode(",",$this->data['booking_id']):'';	
			if(is_array($id) && count($id)>=1){
				foreach ($id as $val_id) {
					

					$booking_ids .= "'" . addslashes($val_id) . "',";
				}
				$booking_ids = substr($booking_ids,0,-1);
			} 
		}
		
		$need_refresh = false;
				
		if($resp = $this->BookingWrapper->getNewestBooking($booking_ids)){
		   $this->msg = 1;
		   $need_refresh = true;
		}						
				
		if($need_refresh){
		   $this->code = 1;		   
		   $this->details = array(
		     'next_action'=>"refresh_booking",
		     'datenow'=>date('c')
		   );
		} else {
		   $this->details = array(
		     'next_action'=>"silent",
		     'datenow'=>date('c')
		   );
		}	
		$this->output();
	}


	public function refresh_cancel_booking()
	{
		$booking_ids = '';
		$merchant_id = $this->validateToken();		
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		
		if(empty($this->data['booking_id'])){		   			
			//
		} else {			
			$id = isset($this->data['booking_id'])?explode(",",$this->data['booking_id']):'';	
			if(is_array($id) && count($id)>=1){
				foreach ($id as $val_id) {
					
					$booking_ids .= "'" . addslashes($val_id) . "',";
				}
				$booking_ids = substr($booking_ids,0,-1);
			} 
		}
		
		$need_refresh = false;
				
		if($resp = $this->BookingWrapper->getNewestCancel($booking_ids)){
		   $this->msg = 1;
		   $need_refresh = true;
		}						
				
		if($need_refresh){
		   $this->code = 1;		   
		   $this->details = array(
		     'next_action'=>"refresh_booking",
		     'datenow'=>date('c')
		   );
		} else {
		   $this->details = array(
		     'next_action'=>"silent",
		     'datenow'=>date('c')
		   );
		}	
		$this->output();
	}
	
	public function notificationList()
	{

		$merchant_id = $this->validateToken();

		
		
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $page_id  = isset($this->data['page_id'])?$this->data['page_id']:'';        
		$list_type = isset($this->data['list_type'])?$this->data['list_type']:'';		
		
		$search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
                              
		if ($resp = $this->MerchantWrapper->getViewNotification($list_type,$this->device_uiid,$merchant_id,
		    $page,$page_limit,$search_string)){
		    				
			$data = array();
			foreach ($resp as $val) {	        		  		        	
        		$val['date_created']=$this->OrderWrapper->prettyDateTime($val['date_created']);
        		$data[]=$val;
			}					
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_notification_list',
			 'refresh'=>$refresh,			 
			 'data'=>$data,
			 'page_id'=>$page_id
			);						
		 } else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list_no_push',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}	
		$this->output();			
	}
	
	public function PushMarkRead()
	{
		$merchant_id = $this->validateToken();
		
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $page_id  = isset($this->data['page_id'])?$this->data['page_id']:'';   
        $id  = isset($this->data['id'])?(integer)$this->data['id']:''; 
        $record_type  = isset($this->data['record_type'])?$this->data['record_type']:''; 
        $row_id = $id;
        $search_string='';     
        
        
        try {
        	
        	if($id<=0){
	        	$this->MerchantWrapper->MarkReadNotification($merchant_id,$this->device_uiid);	        
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(				  
				  'next_action'=>'refresh_push_list',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false,
				  'row_id'=>$row_id
				);
        	} else {
        		$this->MerchantWrapper->MarkReadNotificationByID($record_type,$this->device_uiid,$id);
        		$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  //'next_action'=>'refresh_push_list',				  				  
				  'next_action'=>'mark_push_list',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false,
				  'row_id'=>$row_id
				);
        	}
		} catch (Exception $e) {
			$this->msg = ($e->getMessage());
		}				
		$this->output();		
	}
	
	public function PushRemoveAll()
	{
		$merchant_id = $this->validateToken();
		
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $page_id  = isset($this->data['page_id'])?$this->data['page_id']:'';   
        $id  = isset($this->data['id'])?(integer)$this->data['id']:'';   
        $record_type  = isset($this->data['record_type'])?$this->data['record_type']:''; 
        $row_id = $id;
        $search_string='';     
        
        
		try {
        	
			if($id<=0){
	        	$this->MerchantWrapper->PushRemoveAll($merchant_id,$this->device_uiid);
	        	
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'next_action'=>'clear_list_no_push',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false,
				  'row_id'=>$row_id
				);
			} else {
				$this->MerchantWrapper->PushRemoveByID($record_type,$this->device_uiid,$id);
        		$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'next_action'=>'remove_push_list',
				  'refresh'=>$refresh,
				  'page_id'=>$page_id,
				  'is_search'=>!empty($search_string)?true:false,
				  'row_id'=>$row_id
				);
			}
		} catch (Exception $e) {
			$this->msg = ($e->getMessage());
		}				
		$this->output();		
	}
	
	public function SaveAlertSettings()
	{		
		$merchant_id = $this->validateToken();
		$this->functions->updateOption("merchant_notify_email",
         isset($this->data['merchant_notify_email'])?$this->data['merchant_notify_email']:'',
         $merchant_id);		
         
        $this->functions->updateOption("merchant_cancel_order_email",
         isset($this->data['merchant_cancel_order_email'])?$this->data['merchant_cancel_order_email']:'',
         $merchant_id);		 
         
        $this->functions->updateOption("merchant_cancel_order_phone",
         isset($this->data['merchant_cancel_order_phone'])?$this->data['merchant_cancel_order_phone']:'',
         $merchant_id);		  
         
         $this->functions->updateOption("merchant_invoice_email",
         isset($this->data['merchant_invoice_email'])?$this->data['merchant_invoice_email']:'',
         $merchant_id);		  
         
        $this->code = 1;
		$this->msg = ("Settings saved");
			 
		$this->output();		
	}
	
	public function GalleryList()
	{
		
		$merchant_id = $this->validateToken();
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		$enabled =  $this->functions->getOption('gallery_disabled',$merchant_id);
		$enabled = $enabled=="yes"?0:1;
		
		$page_limit=10;
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
		
        if($page>=1){
    		$this->code = 1;
			$this->details = array(
			  'next_action'=>'end_of_list',
			  'refresh'=>$refresh,
			  'enabled_gallery'=>$enabled,
			);
			$this->output();	
        }
        
		$merchant_gallery = $this->functions->getOption('merchant_gallery',$merchant_id);
		if ($json = json_decode($merchant_gallery,true)){			
			$data = array(); $x=0;
			foreach ($json as $val) {
				$data[] = array(
				  'id'=>$x,
				 
				  'name'=>"Image ".$x+1,
				  'description'=>$val,
				  'thumbnail'=>$this->FoodItemWrapper->getImage($val),
				);			
				$x++;
			}
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'enabled_gallery'=>$enabled,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'enabled_gallery'=>$enabled,
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'enabled_gallery'=>$enabled,
				);
			}
		}
		$this->output();
	}

	public function enabled_gallery()
	{
		$merchant_id = $this->validateToken();		
		$enabled = isset($this->data['enabled_gallery'])?(integer)$this->data['enabled_gallery']:0;
		if($enabled<=0){
			$enabled="yes";
		} else $enabled='';
				
		
		$this->functions->updateOption("gallery_disabled",$enabled,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Settings saved");
		$this->output();
	}
	
	public function banner_enabled()
	{
		$merchant_id = $this->validateToken();		
		$enabled = isset($this->data['banner_enabled'])?(integer)$this->data['banner_enabled']:0;
		
		$this->functions->updateOption("banner_enabled",$enabled,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Settings saved");
		$this->output();
	}
	
	public function GetGallery()
	{
		$this->code = 1;
		$this->msg = ("Edit not available");
		$this->output();
	}
	
	public function DeleteGallery()
	{
		$merchant_id = $this->validateToken();				
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {

			$merchant_gallery = $this->functions->getOption('merchant_gallery',$merchant_id);
			if ($json = json_decode($merchant_gallery,true)){
				$data = array();
				foreach ($json as $key=>$val) {					
					if($key<>$id){
						$data[]=$val;
					} else {
						$this->functions->deleteUploadedFile($val);
					}
				}
				$this->functions->updateOption("merchant_gallery",
				json_encode($data)
				,$merchant_id);	
			}
			
				
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function BannerList()
	{
		$merchant_id = $this->validateToken();
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		$enabled =  $this->functions->getOption('banner_enabled',$merchant_id);
		$enabled = $enabled=="yes"?0:1;
		
		$page_limit=10;
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
		
        if($page>=1){
    		$this->code = 1;
			$this->details = array(
			  'next_action'=>'end_of_list',
			  'refresh'=>$refresh,
			  'banner_enabled'=>$enabled,
			);
			$this->output();	
        }
        
		$merchant_gallery = $this->functions->getOption('merchant_banner',$merchant_id);
		if ($json = json_decode($merchant_gallery,true)){			
			$data = array(); $x=0;
			foreach ($json as $val) {
				$data[] = array(
				  'id'=>$x,
				  

				  'name'=>"Image ".$x+1,

				  'description'=>$val,
				  'thumbnail'=>$this->FoodItemWrapper->getImage($val),
				);			
				$x++;
			}
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'banner_enabled'=>$enabled,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'banner_enabled'=>$enabled,
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'banner_enabled'=>$enabled,
				);
			}
		}
		$this->output();
	}


	public function DeleteBanner()
	{
		$merchant_id = $this->validateToken();				
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;
		try {

			$merchant_gallery = $this->functions->getOption('merchant_banner',$merchant_id);
			if ($json = json_decode($merchant_gallery,true)){
				$data = array();
				foreach ($json as $key=>$val) {					
					if($key<>$id){
						$data[]=$val;
					} else {
						$this->functions->deleteUploadedFile($val);
					}
				}
				$this->functions->updateOption("merchant_banner",
				json_encode($data)
				,$merchant_id);	
			}
			
				
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function UploadFile()
	{				                		
		$merchant_id = $this->validateToken();		
		$profile_photo = '';
		$path_to_upload= $this->functions->uploadPath();
		$file_url = ''; $new_image_name='';
		
		$next_action = isset($this->data['next_action'])?$this->data['next_action']:'';
		$upload_type = isset($this->data['upload_type'])?$this->data['upload_type']:'';
		$upload_option_name = isset($this->data['upload_option_name'])?$this->data['upload_option_name']:'';
				
		if(isset($_FILES['file'])){				
		   header('Access-Control-Allow-Origin: *');		

		   $path_parts = pathinfo($_FILES["file"]["name"]);
		   $extension =  isset($path_parts['extension'])? strtolower($path_parts['extension']) : "jpg";
		   
		   $valid_extensions = $this->functions->validImageExtension();
		   if(!in_array($extension,$valid_extensions)){
		   	  $this->msg = ("Invalid file extension");
		   	  $this->output();
		   }		
		      	
	       $new_image_name = urldecode($_FILES["file"]["name"]).".$extension";		       
	       $new_image_name=str_replace(array('?',':'),'',$new_image_name);	        
	       $time=time();
	       $new_image_name =  "$time-$new_image_name"; 
	       
	       $upload_res = @move_uploaded_file($_FILES["file"]["tmp_name"], "$path_to_upload/".$new_image_name);
		   if($upload_res){
		   	
		   	    if($upload_type==2){
			   	    $current_image = $this->functions->getOption($upload_option_name,$merchant_id);
			   	    $current_image = !empty($current_image)?json_decode($current_image,true):false;		   	
			   	    $image = array($new_image_name);
			   	    
			   	    if($current_image!=false){
			   	    	$image = array_merge($image,$current_image);
			   	    }		   
			   	    
			   	    $this->functions->updateOption( $upload_option_name ,
					  json_encode($image)
					,$merchant_id);
		   	    } else {
		   	    	//Yii::app()->functions->updateOption("merchant_gallery",$new_image_name,$merchant_id);
		   	    }		 
		   	    		   	    
		
		   	    $this->code=1;
				$this->msg= ("Upload successful");
				$file_url = $this->FoodItemWrapper->getImage($new_image_name);
								
		   } else $this->msg = ("Cannot upload file");		    
		} else $this->msg = ("Image is missing");						   
		echo '{ "code":"'.$this->code.'", "next_action":"'.$next_action.'", "msg":"'.$this->msg.'", "filename":"'.$new_image_name.'", "file_url":"'.$file_url.'" }';
		die();
	}


	public function geTimeOpening()
	{
		$merchant_id = $this->validateToken(); $data = array();
		$merchant_holiday = $this->functions->getOption('merchant_holiday',$merchant_id);
		
		if ( $res = $this->MerchantWrapper->getTimeOpening($merchant_id)){
			foreach ($res as $val) {				
				$data[] = array(
				  'id'=>$val['day'],
				  'status'=>$val['status']=="open"?1:0,
				  'start_time'=>$val['start_time'],
				  'end_time'=>$val['end_time'],
				  'start_time_pm'=>$val['start_time_pm'],
				  'end_time_pm'=>$val['end_time_pm'],
				  'custom_text'=>$val['custom_text']
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			  'next_action'=>"fill_opening_hours",
			  'data'=>$data,
			  'merchant_preorder'=>$this->functions->getOption('merchant_preorder',$merchant_id),
			  'merchant_close_msg'=>$this->functions->getOption('merchant_close_msg',$merchant_id),
			  'merchant_close_msg_holiday'=>$this->functions->getOption('merchant_close_msg_holiday',$merchant_id),
			  'merchant_holiday'=>!empty($merchant_holiday)?(array)json_decode($merchant_holiday,true):array()
			);									
		} else {
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			  'next_action'=>"fill_opening_hours",
			  'data'=>array(),
			  'merchant_preorder'=>$this->functions->getOption('merchant_preorder',$merchant_id),
			  'merchant_close_msg'=>$this->functions->getOption('merchant_close_msg',$merchant_id),
			  'merchant_close_msg_holiday'=>$this->functions->getOption('merchant_close_msg_holiday',$merchant_id),
			  'merchant_holiday'=>!empty($merchant_holiday)?(array)json_decode($merchant_holiday,true):array()
			);			
		}	
		$this->output();
	}

	public function ReviewList()
	{
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->MerchantWrapper->getAllReview($merchant_id,$page,$page_limit,$search_string)){			
			
			$data = array();$x=0;
			foreach ($resp as $val) {			
				$description = $val['review'];	
				if($val['total_comments']>0){
					

					$description.= "<br/>"."comments ".$val['total_comments'];
				}
				$data[] = array(
				  'id'=>$val['id'],
				  'name'=>stripslashes($val['customer_name']),
				  'description'=>$description,
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>($val['status']),
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
											
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}
	
	public function ReviewGetByID()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		
		$merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');
		if($merchant_can_edit_reviews=="yes"){
			$this->msg = ("Sorry but you don't have permission to modify this review");
			$this->output();
		}
		
		try {
								
			$resp = $this->FoodItemWrapper->getData("review","id=:id",array(
			 ':id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['id'],
			  'review'=>$resp['review'],			  
			  'status'=>$resp['status']
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"review_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function AddReview()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(		  
		  'review'=>isset($this->data['review'])?$this->data['review']:'',		  
		  'status'=>isset($this->data['status'])?$this->data['status']:'',		  
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);		
		try {
						
			$this->MerchantWrapper->addReview($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}

	public function ReviewDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		
		$merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');
		if($merchant_can_edit_reviews=="yes"){
			$this->msg = ("Sorry but you don't have permission to modify this review");
			$this->output();
		}
		
		try {
						
			$this->MerchantWrapper->deleteReview($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function orders_status_list()
	{
		$merchant_id = $this->validateToken();
		
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->FoodItemWrapper->merchantStatusList($merchant_id,$page,$page_limit,$search_string)){			
			

			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['stats_id'],
				  'name'=>stripslashes($val['description']),
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage(''),
				  'status'=>' ',
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
												
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}
	
	public function OrderStatusGet()
	{
		$merchant_id = $this->validateToken();
		
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("order_status","stats_id=:stats_id",array(
			 ':stats_id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['stats_id'],
			  'description'=>$resp['description'],			  
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"order_status_form.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function AddOrderStatus()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'description'=>isset($this->data['description'])?$this->data['description']:'',		  		  
		  'date_created'=>$this->functions->dateNow(),
		  'date_modified'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);			
		try {
			
			if($id>0){
			  unset($params['date_created']);
			}
						
			$this->FoodItemWrapper->inserrOrderStatus($merchant_id,$params,$id);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function DeleteOrderStatus()
	{
	    $merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
								
			$this->FoodItemWrapper->deleteOrderStatus($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function getOrderStatusList()
	{
		$merchant_id = $this->validateToken();	

		if ($resp = $this->OrderWrapper->orderStatusList($merchant_id)){
			array_unshift($resp , array(
			  'value'=>"",
			  'label'=>("Please select")
			));			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_status_list',
			  'selected'=>$this->functions->getOption('default_order_status',$merchant_id),
			  'data'=>$resp
			);
		} else $this->msg = ("No results");
		$this->output();
	}
	
	public function SavedOrderStatusSettings()
	{
		$merchant_id = $this->validateToken();
		
		$this->functions->updateOption('default_order_status',
		isset($this->data['default_order_status'])?$this->data['default_order_status']:''
		,$merchant_id);				
		
		$this->code = 1;
		$this->msg = ("Setting saved");
		$this->details = array();		
		$this->output();
	}
	
	public function ListAddon()
	{		
		$merchant_id = $this->validateToken();
		
		if ($resp = $this->FoodItemWrapper->getAddonCategory($merchant_id)){						
			$data = $this->FoodItemWrapper->dropdownFormat($resp,'subcat_id','subcategory_name',true);			
			$this->code = 1; $this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_addon_list',			  
			  'data'=>$data
			);					
		} else {
			$this->msg = ("No results");			
			$this->details = array(
			  'next_action'=>'silent'			
			);					
		}	
		$this->output();
	}


	public function GetAddonDetails()
	{		
		$merchant_id = $this->validateToken();
		$addon_id  = isset($this->data['addon_id'])?(integer)$this->data['addon_id']:0;	
		$item_id = isset($this->data['item_id'])?(integer)$this->data['item_id']:0;	
				
		if ( !$this->FoodItemWrapper->getAddonItemView($merchant_id,$addon_id)){
			$this->FoodItemWrapper->migrateDataAddon($merchant_id,$addon_id);			
		}
		
		if ( $resp = $this->FoodItemWrapper->getAddonItemView($merchant_id,$addon_id)){
			 $category_name = $resp[0]['subcategory_name'];
			 $category_id = $resp[0]['subcat_id'];
			 $data = array();
			 foreach ($resp as $val) {			 	
			 	

			 	$val['name_with_price'] = $val['sub_item_name']." ".$this->functions->prettyPrice($val['price']);


			 	$data[]=$val;
			 }
			$this->code = 1; $this->msg = "OK";
			
			$selected_data = array(); 
			if($item_id>0){				
				$data2 = $this->FoodItemWrapper->getItem($merchant_id,$item_id);		

				
				$addon_item = !empty($data2['addon_item'])?json_decode($data2['addon_item'],true):'';
				$multi_option = !empty($data2['multi_option'])?json_decode($data2['multi_option'],true):'';
				$multi_option_value = !empty($data2['multi_option_value'])?json_decode($data2['multi_option_value'],true):'';
				$require_addon = !empty($data2['require_addon'])?json_decode($data2['require_addon'],true):'';
				$two_flavors_position = !empty($data2['two_flavors_position'])?json_decode($data2['two_flavors_position'],true):'';
							
				$selected_data['addon_item'] = isset($addon_item[$addon_id])?$addon_item[$addon_id]:'';	
				$selected_data['multi_option'] = isset($multi_option[$addon_id])?$multi_option[$addon_id]:'';	
				$selected_data['multi_option_value'] = isset($multi_option_value[$addon_id])?$multi_option_value[$addon_id]:'';								
				$selected_data['require_addon'] = isset($require_addon[$addon_id])?$require_addon[$addon_id]:'';	
				$selected_data['two_flavors'] = $data2['two_flavors']==2?1:0;
				$selected_data['two_flavors_position'] = isset($two_flavors_position[$addon_id])?$two_flavors_position[$addon_id]:'';	
				
			}	
						
			$this->details = array(
			  'next_action'=>'addon_details',			  
			  'category_name'=>$category_name,
			  'category_id'=>$category_id,
			  'data'=>$data,
			  'selected_data'=>$selected_data
			);			
			//dump($this->details);
		} else $this->msg = ("No results");	
		$this->output();
	}

	public function sales_report()
	{
		$merchant_id = $this->validateToken();
		
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        
        $start_date  = isset($this->data['start_date'])?trim($this->data['start_date']):'';
        $end_date  = isset($this->data['end_date'])?trim($this->data['end_date']):'';
        $order_status  = isset($this->data['order_status'])?$this->data['order_status']:'';
        $pull_hook  = isset($this->data['pull_hook'])?$this->data['pull_hook']:'';
        
        if(!empty($search_string)){
        	$refresh=1;
        }


            
                        
      /*  $data1=$this->ReportsWrapper_merchantapp->salesReport($merchant_id,$page,$page_limit,$search_string,
        $start_date,$end_date,$order_status);

        $this->msg=$data1;
        $this->output();*/

        if ($resp = $this->ReportsWrapper_merchantapp->salesReport($merchant_id,$page,$page_limit,$search_string,
        $start_date,$end_date,$order_status)){
        


        	$data = array();
        	
        	foreach ($resp as $val) {
        		        		
        		/*MC*/
				$used_currency = isset($val['used_currency'])?$val['used_currency']: $this->default_currency;				
						
        		
        		$val['status']=($val['status']);
        		
        		$val['payment_type'] = $this->functions->prettyPaymentType('payment_order',$val['payment_type_raw'],
        		$val['order_id'],$val['trans_type_raw']);
        		
        		$val['trans_type']=($val['trans_type']);
        		

        		$val['order_number']= "Order No. #".$val['order_id'];


        		$val['total_amount'] = $this->functions->formatNumber($val['total_amount']);
        		$val['date_created'] = $this->OrderWrapper->prettyDateTime($val['date_created']);
        		$data[]=$val;
        	}
        	        	
        	$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_report',
			 'report_type'=>'sales_report',
			 'refresh'=>$refresh,
			 'pull_hook'=>$pull_hook,
			 'data'=>$data
			);			
        } else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'pull_hook'=>$pull_hook,
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
        		
		$this->output();
	}
	
	public function OrderStatusList()
	{
		$merchant_id = $this->validateToken();
		
		
		$page_limit = 15;
						
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        
		if ($resp = $this->OrderWrapper->orderStatusListPaginate($merchant_id,$page,$page_limit)){					
			$data = array();
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['value'],
				  'name'=>$val['label']
				);
			}
			
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else $this->msg = ("No results");
		}
		$this->output();
	}

	public function sales_summary_report()
	{
		
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        
        $start_date  = isset($this->data['start_date'])?trim($this->data['start_date']):'';
        $end_date  = isset($this->data['end_date'])?trim($this->data['end_date']):'';
        $order_status  = isset($this->data['order_status'])?$this->data['order_status']:'';
        $pull_hook  = isset($this->data['pull_hook'])?$this->data['pull_hook']:'';
        
        if(!empty($search_string)){
        	$refresh=1;
        }

        
        if ($resp = $this->ReportsWrapper_merchantapp->salesSummaryReport($merchant_id,$page,$page_limit,$search_string,
        $start_date,$end_date,$order_status)){
        	
        	$data = array();
        	
        	foreach ($resp as $val) {        		
        		$total_amount = (float)$val['total_qty']*(float)$val['price_raw'];
        		$val['price'] = $this->functions->formatNumber($val['price_raw']);
        		$val['total_amount'] = $this->functions->formatNumber($total_amount);
        		$data[]=$val;
        	}
        	        	
        	$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_report',
			 'report_type'=>'sales_summary_report',
			 'refresh'=>$refresh,
			 'pull_hook'=>$pull_hook,
			 'data'=>$data
			);					
			
			//dump($this->details);		
			
        } else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh,
				  'pull_hook'=>$pull_hook,
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
        		
		$this->output();
	}
	
	public function booking_report()
	{
		
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        
        $start_date  = isset($this->data['start_date'])?trim($this->data['start_date']):'';
        $end_date  = isset($this->data['end_date'])?trim($this->data['end_date']):'';
        $order_status  = isset($this->data['order_status'])?$this->data['order_status']:'';
        
        if(!empty($search_string)){
        	$refresh=1;
        }
                
        
        if ($resp = $this->ReportsWrapper_merchantapp->bookingSummary($merchant_id,$page,$page_limit,$search_string,
        $start_date,$end_date,$order_status)){
        	        
        	$data = array();
        	        	
        	foreach ($resp as $val) {        		
        		

        		$val['total_approved'] = "Total approved :".$val['total_approved']+0;


        		

        		$val['total_denied'] = "Total denied :".$val['total_denied']+0;

        		

        		$val['total_pending'] = "Total pending :".$val['total_pending']+0;

        		$data[]=$val;
        	}
        	        	
        	$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_report',
			 'report_type'=>'booking_report',
			 'refresh'=>$refresh,
			 'data'=>$data
			);								
        } else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
        		
		$this->output();
	}


	public function getSMSAlertSettings()
	{
		$merchant_id = $this->validateToken();	
			
		$settings[]=array(
		  'option_name'=>"sms_notify_number",
		  'option_value'=>$this->functions->getOption('sms_notify_number',$merchant_id)
		);
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		  'next_action'=>"set_form_options",
		  'data'=>$settings
		);
		$this->output();
	}
	
	public function SaveSMSAlertSettings()
	{
		
		$merchant_id = $this->validateToken(); $settings = array();		

		$this->functions->updateOption('sms_notify_number',
				isset($this->data['sms_notify_number'])?$this->data['sms_notify_number']:''
				,$merchant_id);	
		
		$this->code = 1;
		$this->msg = ("Setting saved");
		$this->details = array();		
		$this->output();
	}

	public function GetReviewByID()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		
		
		try {
								
			$resp = $this->FoodItemWrapper->getData("review","id=:id",array(
			 ':id'=>$id
			));
						
			$data = array(
			  'id'=>$resp['id'],
			  'review'=>$resp['review'],			  
			  'status'=>$resp['status']
			);
						
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"review_form_reply.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}	
		$this->output();	
	}
	
	public function AddReviewReply()
{
    $merchant_id = $this->validateToken();
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;
    $reply = isset($this->data['reply']) ? $this->data['reply'] : '';

    if (empty($reply)) {
        $this->msg = ("Comments is required");
        $this->output();
    }

    $stmt = "
        SELECT a.id, a.merchant_id, b.restaurant_name
        FROM mt_review a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE a.id = :id
        LIMIT 1
    ";
    
    $query = $this->db->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    
    if ($query->execute() && ($res = $query->fetch(PDO::FETCH_ASSOC))) {
        $res['restaurant_name'] = $res['restaurant_name']; // Preserved as-is

        $params = array(  
            'parent_id' => $id,
            'review' => $reply,
            'date_created' => $this->functions->dateNow()
        );

        try {
            $this->MerchantWrapper->addReview($merchant_id, $params, '');
            $this->code = 1;
            $this->msg = $id > 0 ? ("Succesfully updated") : ("Successful");
            $this->details = array(
                'next_action' => 'pop_form'
            );
        } catch (Exception $e) {
            $this->msg = $e->getMessage();
        }
    } else {
        $this->msg = ("Record not found");
    }

    $this->output();
}


public function AddBroadcast()
	{
		$merchant_id = $this->validateToken();
				
		$id = '';
		$params = array(
		  'push_title'=>isset($this->data['push_title'])?$this->data['push_title']:'',
		  'push_message'=>isset($this->data['push_message'])?$this->data['push_message']:'',
		  'device_platform'=>"/topics/merchant_subscription_$merchant_id",
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR'],
		  'merchant_id'=>$merchant_id,
		  'fcm_version'=>1
		);
		
		if(empty($params['push_message'])){
			$this->msg = ("Message is required");
			$this->output();
		}	
				
		try {

			$this->MerchantWrapper->verifyLastBroadcast($merchant_id);
						
			$this->MerchantWrapper->addBroadcast($merchant_id,$params,'');
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
	
		$this->output();
	}
	
	public function PushBroadcastList()
	{
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->MerchantWrapper->PushBroadcastList($merchant_id,$page,$page_limit,$search_string)){			
						
			$data = array();$x=0;
			foreach ($resp as $val) {				
				$data[] = array(
				  'id'=>$val['broadcast_id'],
				  'name'=>stripslashes($val['push_title']),
				  'description'=>stripslashes($val['push_message']),
				  'thumbnail'=>$this->FoodItemWrapper->getImage('','chatting.png'),
				  'status'=>($val['status']),
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created'])
				);				
				$x++;
			}
												
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);			
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = ("No results");
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function refresh_ready_order()
	{

		

		$order_ids = '';
		
		//$merchant_id=3;
		$merchant_id = $this->validateToken();	
         // echo $merchant_id;die();
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
				
		if(empty($this->data['order_id'])){		   			
			//
		} else {			
			$id = isset($this->data['order_id'])?explode(",",$this->data['order_id']):'';	
			if(is_array($id) && count($id)>=1){
				foreach ($id as $val_id) {
					

					$order_ids .= "'" . addslashes($val_id) . "',";

				}
				$order_ids = substr($order_ids,0,-1);
			} 
		}


				
		$need_refresh = false;



		
		if($resp = $this->OrderWrapper->getUpdatedReadyOrder($order_ids, $merchant_id )){



		  $this->msg = 1;
		  $need_refresh = true;		  
		}
					
		if($need_refresh){
		   $this->code = 1;		   
		   $this->details = array(
		     'next_action'=>"refresh_ready_tab",
		     'datenow'=>date('c')
		   );
		} else {
		   $this->details = array(
		     'next_action'=>"silent",
		     'datenow'=>date('c')
		   );
		}			
		$this->output();
	}


	public function printerList()
	{
		$merchant_id = $this->validateToken();
				
		$page_limit = $this->MerchantWrapper->paginateLimit();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $search_string  = isset($this->data['s'])?trim($this->data['s']):'';
        if(!empty($search_string)){
        	$refresh=1;
        }
               					        
		if ($resp = $this->Bluetooth->getPrinterList($merchant_id,$this->device_uiid,$page,$page_limit,$search_string)){						
			$data = array();$x=0;
			foreach ($resp as $val) {				
				
				$item_status='';
				if($val['auto_print']==1){
					$item_status='available';
				}
				if($val['auto_print_after_accepted']==1){
					$item_status='out_of_stock';
				}			
				
				$data[] = array(
				  'id'=>$val['id'],
				  'name'=>$val['printer_name'],
				  'description'=>'',
				  'thumbnail'=>$this->FoodItemWrapper->getImage('','printer.png'),
				  'status'=>'',
				  'date_created'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
				  'item_status'=>$item_status
				);				
				$x++;
			}
														
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'set_list_column',
			 'refresh'=>$refresh,
			 'data'=>$data
			);						
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else {
				$this->code = 1;
				$this->msg = "No results";
				$this->details = array(
				  'next_action'=>'clear_list',
				  'is_search'=>!empty($search_string)?true:false
				);
			}
		}
		$this->output();
	}


	public function AddPrinter()
	{
	    $merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;					
		$params = array(
		  'merchant_id'=>$merchant_id,
		  'device_uiid'=>$this->device_uiid,
		  'printer_name'=>isset($this->data['printer_name'])?$this->data['printer_name']:'',
		  'bluetooth_printer_name'=>isset($this->data['bluetooth_printer_name'])?$this->data['bluetooth_printer_name']:'',
		  'interface_type'=>isset($this->data['interface_type'])?$this->data['interface_type']:'',
		  'mac_address'=>isset($this->data['mac_address'])?$this->data['mac_address']:'',
		  'data1'=>isset($this->data['data1'])?$this->data['data1']:'',
		  'data2'=>isset($this->data['data2'])?$this->data['data2']:'',
		  'paper_width'=>isset($this->data['paper_width'])?$this->data['paper_width']:'',
		  'auto_print'=>isset($this->data['auto_print'])?$this->data['auto_print']:'',
		  'auto_print_after_accepted'=>isset($this->data['auto_print_after_accepted'])?$this->data['auto_print_after_accepted']:'',
		  'char_set'=>isset($this->data['char_set'])?$this->data['char_set']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR']
		);		
		
		if(empty($params['printer_name'])){
			$this->msg = ("Printe name is required");
			$this->output();
		}
		
		if(empty($params['mac_address'])){
			$this->msg = ("Please select printer");
			$this->output();
		}
				
		try {
									
			$this->Bluetooth->insertPrinter($merchant_id,$params,$id,$this->device_uiid);
			$this->code = 1;
			$this->msg = $id>0?("Succesfully updated"):("Successful");
			$this->details = array(
			  'next_action'=>'pop_form'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}

	public function printerGet()
	{
		$merchant_id = $this->validateToken();
		$id = isset($this->data['id'])?(integer)$this->data['id']:0;		
		try {
						
			$resp = $this->FoodItemWrapper->getData("printer_list_new","id=:id",array(
			 ':id'=>$id
			));
			
						
			$data = array(
			  'id'=>$resp['id'],
			  'printer_name'=>$resp['printer_name'],
			  'bluetooth_printer_name'=>$resp['bluetooth_printer_name'],
			  'interface_type'=>$resp['interface_type'],
			  'mac_address'=>$resp['mac_address'],
			  'paper_width'=>$resp['paper_width'],
			  'auto_print'=>$resp['auto_print'],
			  'auto_print_after_accepted'=>$resp['auto_print_after_accepted'],
			  'data1'=>$resp['data1'],
			  'data2'=>$resp['data2'],
			  'char_set'=>$resp['char_set']
			);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'fill_form',
			  'form_id'=>"printer_add.html",
			  'data'=>$data
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}
	
	public function printerDelete()
	{
		$merchant_id = $this->validateToken();		
		$id = isset($this->data['id'])?(array)$this->data['id']:0;
		try {
						
			$this->Bluetooth->deletePrinter($merchant_id,$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>'list_reload'			  
			);
			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		$this->output();
	}


	public function getPrinterOptions()
	{
		$merchant_id = $this->validateToken(); $data = array();
		$order_id = isset($this->data['order_id'])?(integer)$this->data['order_id']:'';		
		
		$enabled_printer_fp_wifi = $this->functions->getOptionAdmin('print_enabled_printer_fp_wifi');
		
		if($enabled_printer_fp_wifi==1){
			$data[0] = array(
			  'name'=> "FP-80WC 80mm WIFI printer",
			  'id'=>-1,
			  'order_id'=>$order_id
			);
		}
		if ( $res = $this->Bluetooth->getPrinterList($merchant_id,$this->device_uiid,0,100)){
			foreach ($res as $val) {				
				$data[] = array(
				  'name'=>$val['printer_name'],
				  'id'=>$val['id'],
				  'order_id'=>$order_id
				);
            }		            
		} 
		
		$data[-1] = array(
		  'name'=> "Add new printer",
		  'id'=>-2,
		  'order_id'=>$order_id
		);
		
		$this->code = 1; $this->msg = "OK";
		$this->details = array(
		  'next_action'=>'show_printer_list_options',
		  'data'=>$data
		);
		$this->output();
	}

	public function PrintOrder()
	{		
		$merchant_id = $this->validateToken(); $data = array();
		$order_id = isset($this->data['order_id'])?(integer)$this->data['order_id']:'';
		$printer_id = isset($this->data['printer_id'])?(integer)$this->data['printer_id']:'';
		
		$prefix="print_"; 
				
		try {
			
			$printer_data = $this->Bluetooth->getPrinter($printer_id);
			$order_details = $this->OrderWrapper->prepareReceipt($order_id,false);						
			$print_opts = $this->Bluetooth->getPrinterOptions($merchant_id);
			$print_opts_data = $this->Bluetooth->printerOptionsData();
			
			if($order_details){
				foreach ($order_details['order_data'] as $key=>$val) {					
					$pre = $prefix."".$key;						
					if(!array_key_exists($pre,(array)$print_opts)){
						if(in_array($pre,(array)$print_opts_data)){
						   //$order_details['order_data'][$key]='';
						   unset($order_details['order_data'][$key]);
						}
					}				
				}				
			}		
									
			$footer = array();
			if(isset($print_opts['print_footer'])){
				$print_footer = explode("\r\n",$print_opts['print_footer']);
				if(is_array($print_footer)){
					$footer = $print_footer;
				}
			}		
			
			$now  = date("c");
			$data = array(
			  'printer_custom_data'=> array(
			    'printed_date'=> array_key_exists($prefix."printed_date",$print_opts)? $this->functions->prettyDate($now)." ".$this->functions->prettyTime($now) :'',
			    'site_url'=> array_key_exists($prefix."site_url",$print_opts)?$this->functions->prettyUrl($_SERVER['HTTP_HOST']):'',
			    'footer'=>array_key_exists($prefix."footer",$print_opts)?$footer:''
			  ) ,
			  'printer_data'=>$printer_data,
			  'order_details'=>$order_details
			);
			
			/*INSERT LOGS*/
			$auto_print = isset($this->data['auto_print'])?$this->data['auto_print']:'';
			if($auto_print==1){

				


				$this->functions->insertData("mt_printer_auto_print", array(
				  'merchant_id'=>$merchant_id,
				  'device_uiid'=>$this->device_uiid,
				  'order_id'=>$order_id,
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				));

			}
		    			
			$this->code = 1; $this->msg = "OK";			
			$this->details = array(
			  'next_action'=>'print_order',		
			  'data'=>$data
			);
		    			
		} catch (Exception $e) {			
			$this->msg = ($e->getMessage());			
		}		
		
		$this->output();
	}


	public function AutoPrint()
{
    $merchant_id = $this->validateToken(); 		
    $order_id = isset($this->data['order_id']) ? (int)$this->data['order_id'] : '';

    $stmt = "
        SELECT a.id as printer_id,

        (
            SELECT order_id
            FROM mt_order 
            WHERE order_id = :order_id
            AND order_id NOT IN (
                SELECT order_id FROM mt_printer_auto_print
                WHERE order_id = :order_id_2
                AND device_uiid = :device_uiid
            ) 
        ) as order_id

        FROM mt_printer_list_new a
        WHERE
        a.merchant_id = :merchant_id
        AND device_uiid = :device_uiid_2
        AND a.auto_print = 1
        ORDER BY a.date_created DESC
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':order_id' => $order_id,
        ':order_id_2' => $order_id,
        ':device_uiid' => $this->device_uiid,
        ':merchant_id' => $merchant_id,
        ':device_uiid_2' => $this->device_uiid
    ]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res && $res['printer_id'] > 0 && $res['order_id'] > 0) {
        $this->code = 1; 
        $this->msg = "ok";
        $this->details = [
            'next_action' => "auto_print_receipt",
            'data' => $res
        ];
        $this->output();
    } 

    $this->msg = "no results";
    $this->details = [
        'next_action' => "silent"
    ];			
    $this->output();
}


public function getPrinterAutoAccepted()
{
    $merchant_id = $this->validateToken(); 		
    $order_id = isset($this->data['order_id']) ? (int)$this->data['order_id'] : '';

    $stmt = "
        SELECT id as printer_id 
        FROM mt_printer_list_new
        WHERE
        merchant_id = :merchant_id
        AND auto_print_after_accepted = '1'
        AND device_uiid = :device_uiid
        ORDER BY date_created DESC
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':merchant_id' => $merchant_id,
        ':device_uiid' => $this->device_uiid
    ]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        $res['order_id'] = $order_id;
        $this->code = 1; 
        $this->msg = "ok";
        $this->details = [
            'next_action' => "auto_print_receipt",
            'data' => $res
        ];
        $this->output();
    }

    $this->msg = "no results";
    $this->details = [
        'next_action' => "silent"
    ];
    $this->output();
}




	

	
	
	



	public function updateCloseStore()
	{
		$merchant_id = $this->validateToken(); 
		$value = isset($this->data['value'])?$this->data['value']:'';		
		$close_store = isset($this->data['value'])?(integer)$this->data['value']:0;
		$value = $value==1?"yes":'';
		
		$this->functions->updateOption('merchant_close_store',$value,$merchant_id);
		
		$params = array(
		  'close_store'=>$close_store,
		  'date_modified'=>$this->functions->dateNow(),
	      'ip_address'=>$_SERVER['REMOTE_ADDR']
		);	


       

  	    $this->functions->updateData('mt_merchant' , $params,'merchant_id',$merchant_id);


				
		$this->code = 1;
		$this->msg = $value=="yes"?("Your store is now close"):("Your store is now open");
		$this->output();
	}


	public function getBookingSettings()
	{
		$data = array();		
		
		try {
			$resp = $this->MerchantUserWrapper->validateToken($this->merchant_token);			
			$merchant_id = (integer)$resp['merchant_id'];			
			$settings = $this->MerchantWrapper->getMerchantSettings($merchant_id, array(
			  'merchant_table_booking','accept_booking_sameday','fully_booked_msg',
			  'merchant_booking_alert','merchant_booking_receiver'
			) );
			
			$max_booked = $this->functions->getOption('max_booked',$merchant_id);
			if(!empty($max_booked)){
				if($max_booked = json_decode($max_booked,true)){			       
			       foreach ($max_booked as $key=>$val) {
			       		$settings[]=array(
						  'option_name'=>"max_booked_$key",
						  'option_value'=>$val
						);
			       	}	
				}			
			}		
						
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'next_action'=>"set_form_options",
			  'data'=>(array)$settings			  
			);										
		} catch (Exception $e) {
			$this->code = 3;
			$this->msg = ($e->getMessage());
		}				
		$this->output();
	}
	
	public function SavedBookingSettings()
	{	
		$merchant_id = $this->validateToken();
		
		$this->functions->updateOption("max_booked",
        isset($this->data['max_booked'])?json_encode($this->data['max_booked']):'',
        $merchant_id);	 
        
		$this->functions->updateOption("merchant_table_booking",
        isset($this->data['merchant_table_booking'])?trim($this->data['merchant_table_booking']):'',
        $merchant_id);	 
        
        $this->functions->updateOption("accept_booking_sameday",
        isset($this->data['accept_booking_sameday'])?trim($this->data['accept_booking_sameday']):'',
        $merchant_id);	 
        
        $this->functions->updateOption("fully_booked_msg",
        isset($this->data['fully_booked_msg'])?trim($this->data['fully_booked_msg']):'',
        $merchant_id);	 
        
        $this->functions->updateOption("merchant_booking_alert",
        isset($this->data['merchant_booking_alert'])?trim($this->data['merchant_booking_alert']):'',
        $merchant_id);	 
        
        $this->functions->updateOption("merchant_booking_receiver",
        isset($this->data['merchant_booking_receiver'])?trim($this->data['merchant_booking_receiver']):'',
        $merchant_id);	 
        
        
		
		$this->code = 1;
		$this->msg = ("Setting saved");
		$this->details = array();		
		$this->output();
	}


	public function quickAcceptOrder()
	{		
		$merchant_id = $this->validateToken();
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		$order_id  = isset($this->data['order_id'])?(integer)$this->data['order_id']:0;
		$pre_order  = isset($this->data['pre_order'])?(integer)$this->data['pre_order']:0;
		
		if(!$order = $this->OrderWrapper->validateOrder($merchant_id,$order_id)){
			$this->msg = ("Order not found");
		    $this->output();	
		}	
		if($order_id>0){
			
			/*check if merchant can change the status*/
			if(!$this->OrderWrapper->canChangeOrderStatus($order)){
				$this->msg=("Sorry but you cannot change the order status anymore. Order is lock by the website admin");
				$this->details = array(
				  'next_action'=>"close_all_dialog_order",
				  'order_id'=>$order_id
				);
				$this->output();	
			}	
			
			try {
				
				$status = $this->OrderWrapper->getActionStatus('accept');
								
				if($this->OrderWrapper->validateChangeStatus($order_id,$status)){
				  

				   $this->msg = "This order already change to ".$status;

				   $this->output();
				}				
				
				$remarks=''; $remarks2=''; $remarks_args = array();
				
				if($pre_order==1){
					$remarks = "your order will be ready on-time";
					$remarks2 =  $remarks;
					$remarks_args = array(
					  '[none]'=>'none' 	    	  
					);
					
					$time = isset($this->data['mins'])?(integer)$this->data['mins']:15;
					
					$delivery_date = $order['delivery_date'];
					$delivery_time = !empty($order['delivery_time'])?$order['delivery_time']:date("H:i:s");
										
					$estimated_date_time = date("Y-m-d H:i:s",strtotime($delivery_date." ".$delivery_time));
					
					$params_estimation = array(
						'estimated_time'=>$time,
						'estimated_date_time'=>date('Y-m-d H:i:s', strtotime("+$time minutes", strtotime($estimated_date_time))),
					);
					
					

					 $this->functions->updateData('mt_order_delivery_address' , $params_estimation,'order_id',$order_id);


				}			
				
				$params = array(
				  'order_id'=>$order_id,
				  'status'=>$status,
				  'remarks'=>$remarks,
				  'remarks2'=>$remarks2,
				  'remarks_args'=>json_encode($remarks_args),
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']				  
			   );	
			   
			   $params2 = array(
				  'status'=>$status,
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
			   );		
			   
			   $this->OrderWrapper->updateOrderHistory($order_id,$merchant_id,$params,$params2);
	  	       $this->code = 1;
		  	   $this->msg = "OK";
		  	   $this->details = array(
		  	      'next_action'=>"pop_dialog_order",
		  	      'order_id'=>$order_id,
		  	      'action_taken'=>'accepted'
		  	   );
		  	   
		  	   /*SEND NOTIFICATION*/
		  	 		  	   	   
			  	  $this->functions->notifyCustomerOrderStatusChange(
					  $order_id,
					  $status,
					  $remarks
				   );
		  	  	 
		  	  
		  	 	 	  
			  
			  /*UPDATE POINTS BASED ON ORDER STATUS*/
					    						    					
					
				   $this->PointsProgram->updateOrderBasedOnStatus($status,$order_id);
					
					
				   $this->PointsProgram->udapteReviews($order_id,$status);
											
				
				
				/*INVENTORY ADDON*/	

			   		
				
				if ($this->functions->inventoryEnabled($merchant_id)){
					try {							  
					    $this->InventoryWrapper->insertInventorySale($order_id,strtolower($status));	
					} catch (Exception $e) {										    
					  // echo $e->getMessage();		    					    	  
					}		    					    	
				}
				 
				
			} catch (Exception $e) {
				$this->msg = ($e->getMessage());
			}	 
			
		} else $this->msg = ("Invalid order id");			
		$this->output();
	}


	


	public function updateItemAvailable()
{		
    $merchant_id = $this->validateToken();

    $item_id = isset($this->data['item_id']) ? (int)$this->data['item_id'] : 0;
    $available = isset($this->data['available']) ? (int)$this->data['available'] : 0;

    if ($item_id > 0) {
        $params = array(
            'not_available' => (int)$available,
            'date_modified' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        );

        // Build SET part dynamically
        $set_parts = [];
        foreach ($params as $key => $value) {
            $set_parts[] = "$key = :$key";
        }
        $set_clause = implode(', ', $set_parts);

        // Final SQL
        $sql = "UPDATE mt_item SET $set_clause WHERE item_id = :item_id AND merchant_id = :merchant_id";

        // Prepare and bind
        $stmt = $this->db->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        $stmt->bindValue(":item_id", $item_id, PDO::PARAM_INT);
        $stmt->bindValue(":merchant_id", $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $this->code = 1;
        $this->msg = "Succesfully updated";
        $this->details = array(
            'next_action' => "refresh"
        );

    } else {
        $this->msg = "Invalid item id";
    }

    $this->output();
}

	
	public function TimeList()
{
    $merchant_id = $this->validateToken();

    $page_limit = $this->MerchantWrapper->paginateLimit();

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $page_limit;
    } else {
        $page = 0;
    }

    $refresh = isset($this->data['refresh']) ? (int)$this->data['refresh'] : 0;
    $search_string = isset($this->data['s']) ? trim($this->data['s']) : '';
    if (!empty($search_string)) {
        $refresh = 1;
    }

    $and = '';
    if (!empty($search_string)) {
        $like = addslashes($search_string) . '%';
        $and .= "
            AND (
                transaction_type LIKE '$like' 
                OR days LIKE '$like' 
                OR order_status LIKE '$like' 
            )
        ";
    }

    $stmt = "
        SELECT id, group_id, transaction_type, start_time, end_time, number_order_allowed, order_status,
        GROUP_CONCAT(days) as days
        FROM mt_order_time_management
        WHERE merchant_id = :merchant_id
        $and
        GROUP BY group_id
        ORDER BY id DESC
        LIMIT $page, $page_limit
    ";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    if ($resp = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        $x = 0;

        foreach ($resp as $val) {
            $order_status_inline = '';
            $order_status = !empty($val['order_status']) ? json_decode($val['order_status'], true) : array();
            if (is_array($order_status) && count($order_status) >= 1) {
                foreach ($order_status as $order_status_val) {
                    $order_status_inline .= $order_status_val . ",\n";
                }
                $order_status_inline = substr($order_status_inline, 0, -2);
            }

            $days_inline = '';
            $days = !empty($val['days']) ? explode(",", $val['days']) : array();
            if (is_array($days) && count($days) >= 1) {
                foreach ($days as $days_val) {
                    $days_inline .= $days_val . ",\n";
                }
                $days_inline = substr($days_inline, 0, -2);
            }

            $data[] = array(
                'id' => $val['group_id'],
                'name' => $val['transaction_type'],
                'description' => $days_inline,
                'thumbnail' => $this->FoodItemWrapper->getImage(''),
                'status' => $order_status_inline,
                'date_created' => ''
            );
            $x++;
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'set_list_column',
            'refresh' => $refresh,
            'data' => $data
        );
    } else {
        if (isset($this->data['page'])) {
            $this->code = 1;
            $this->details = array(
                'next_action' => 'end_of_list',
                'refresh' => $refresh
            );
        } else {
            $this->code = 1;
            $this->msg = "No results";
            $this->details = array(
                'next_action' => 'clear_list',
                'is_search' => !empty($search_string) ? true : false
            );
        }
    }

    $this->output();
}


public function getDaysList()
	{		
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		 
		
			$days = $this->functions->dayList();
			$data = array();
			foreach ($days as $key=>$day) {
				$data[] = array(
				  'id'=>$key,
				  'name'=>$day
				);
			}		
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data
			);		
		
		$this->output();
	}
	
	public function getStatusList()
	{		
		$merchant_id = $this->validateToken();	
					
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
		$page_limit = 15;
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
                 		
        $resp = $this->OrderWrapper->orderStatusList($merchant_id);
		if ($resp && $page<=0){			
			$data = array();
			foreach ($resp as $key=>$val) {							
				$data[] = array(
				  'id'=>$val['value'],
				  'name'=>($val['label'])
				);
			}		
			$this->code = 1;
			$this->msg = "OK";			
			$this->details = array(
			 'next_action'=>'display_selected',
			 'refresh'=>$refresh,
			 'data'=>$data
			);		
		} else {
			if(isset($this->data['page'])){
				$this->code = 1;
				$this->details = array(
				  'next_action'=>'end_of_list',
				  'refresh'=>$refresh
				);
			} else $this->msg = "No results";		   
		}	
				
		
		$this->output();
	}


	public function AddTime()
{
    $merchant_id = $this->validateToken();
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;

    $group_id = 1;
    $stmt = "SELECT MAX(id) as max FROM mt_order_time_management";
    $query = $this->db->query($stmt);
    $max = $query->fetchColumn();
    $group_id = ($max + 1);

    $edit_group_id = $id;
    if ($edit_group_id > 0) {
        $group_id = $edit_group_id;
    }

    if (is_array($this->data['days']) && count($this->data['days']) >= 1) {

        if ($edit_group_id > 0) {
            $this->db->query("
                DELETE FROM mt_order_time_management
                WHERE group_id = {$edit_group_id} AND merchant_id = {$merchant_id}
            ");
        }

        foreach ($this->data['days'] as $day) {
            $params = array(
                'group_id' => $group_id,
                'merchant_id' => (int)$merchant_id,
                'transaction_type' => isset($this->data['transaction_type']) ? $this->data['transaction_type'] : '',
                'days' => $day,
                'start_time' => isset($this->data['start_time']) ? $this->data['start_time'] : '',
                'end_time' => isset($this->data['end_time']) ? $this->data['end_time'] : '',
                'number_order_allowed' => isset($this->data['number_order_allowed']) ? (int)$this->data['number_order_allowed'] : '',
                'order_status' => isset($this->data['order_status']) ? json_encode($this->data['order_status'], true) : '',
            );
            $this->functions->insertData("mt_order_time_management", $params);
        }

        $this->code = 1;
        $this->msg = $id > 0 ? "Succesfully updated" : "Successful";
        $this->details = array(
            'next_action' => 'pop_form'
        );

    } else {
        $this->msg = "Invalid days";
    }

    $this->output();
}


public function TimeDelete()
{
    $merchant_id = $this->validateToken();		
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;

    try {
        $stmt = "
            DELETE FROM mt_order_time_management
            WHERE group_id = $id
            AND merchant_id = $merchant_id
        ";
        $this->db->query($stmt);

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'list_reload'
        );

    } catch (Exception $e) {
        $this->msg = $e->getMessage();
    }

    $this->output();
}


public function TimeGetByID()
{
    $merchant_id = $this->validateToken();		
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;	

    $stmt = "
        SELECT id, group_id, transaction_type, start_time, end_time, number_order_allowed,
        order_status,
        GROUP_CONCAT(days) as days
        FROM mt_order_time_management
        WHERE merchant_id = $merchant_id
        AND group_id = $id
        GROUP BY group_id
    ";

    $query = $this->db->query($stmt);
    if ($data = $query->fetch(PDO::FETCH_ASSOC)) {
        $data['order_status'] = json_decode($data['order_status'], true);
        $data['days'] = explode(",", $data['days']);

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'fill_form',
            'form_id' => "time_form.html",
            'data' => $data
        );
    } else {
        $this->msg = "Record not found";
    }

    $this->output();	
}

public function InvoiceList()
{
    $and = '';
    $merchant_id = $this->validateToken();				
    $refresh = isset($this->data['refresh']) ? (int)$this->data['refresh'] : 0;
    $page_limit = 15;

    $search_string = isset($this->data['s']) ? trim($this->data['s']) : '';
    if (!empty($search_string)) {
        $refresh = 1;
        $and = " AND 
        ( 
        invoice_number = $search_string
        OR
        payment_status LIKE '%$search_string%'
        )";
    }

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $page_limit;
    } else {
        $page = 0;
    }

    $stmt = "
        SELECT invoice_number, merchant_name, invoice_terms, date_from, date_to,
        pdf_filename, payment_status
        FROM mt_invoice
        WHERE merchant_id = $merchant_id
        $and
        ORDER BY invoice_number DESC
        LIMIT $page, $page_limit
    ";

    $query = $this->db->query($stmt);
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp && $page <= 0) {
        $data = array();
        foreach ($resp as $val) {
            $data[] = array(
                'id' => $val['invoice_number'],
                'name' => "Invoice #" . $val['invoice_number'] . " Terms " . $this->functions->prettyInvoiceTerms($val['invoice_terms']),
                'description' => "Period " . $this->functions->prettyDate($val['date_from']) . "-" . $this->functions->prettyDate($val['date_to']),
                'thumbnail' => $this->FoodItemWrapper->getImage(''),
                'status' => $val['payment_status'],
                'date_created' => ""
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'set_list_column',
            'refresh' => $refresh,
            'data' => $data
        );
    } else {
        if (isset($this->data['page'])) {
            $this->code = 1;
            $this->details = array(
                'next_action' => 'end_of_list',
                'refresh' => $refresh
            );
        } else {
            $this->code = 1;
            $this->msg = "No results";
            $this->details = array(
                'next_action' => 'clear_list',
                'is_search' => !empty($search_string) ? true : false
            );
        }
    }

    $this->output();
}


public function InvoiceGetByID()
{
    $merchant_id = $this->validateToken();		
    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;

    $stmt = "
        SELECT pdf_filename, viewed
        FROM mt_invoice
        WHERE merchant_id = $merchant_id
        AND invoice_number = $id
    ";

    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        $link = $this->functions->websiteUrl() . "/upload/invoice/" . $res['pdf_filename'];

        if ($res['viewed'] != 1) {
            $this->functions->updateData('mt_invoice', array(
                'viewed' => 1
            ), 'invoice_number', $id);
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'next_action' => 'webview',
            'link' => $link
        );
    } else {
        $this->msg = "PDF not found";
    }

    $this->output();
}



	
	public function print_update()
	{
		$merchant_id = $this->validateToken();			
		$this->MerchantWrapper->setMerchantTimezone($merchant_id);
		$date_now = date('Ymd');
		$refresh  = isset($this->data['refresh'])?(integer)$this->data['refresh']:0;
        $order_id  = isset($this->data['order_id'])?$this->data['order_id']:'';
        
			

		$this->functions->updateData('mt_order', array(
                'auto_print'=>1
            ), 'order_id', $order_id);

		$this->code = 1; $this->msg = "OK";
		$this->details = array('next_action'=>"display_order_details_auto_2",'refresh'=>$refresh);	
		$this->output();
	}	

	
	
		/* Custom code 11 ends */
		
		
	public function StoreHours()
{
	$merchant_id = $this->validateToken();

	$days = $this->functions->getDays();	

	if (isset($this->data['stores_open_day'])) {
		foreach ($days as $day_key => $day) {

			$params_days = array(
				'merchant_id'    => $merchant_id,
				'day'            => $day_key,
				'status'         => in_array($day_key, (array)$this->data['stores_open_day']) ? "open" : "close",
				'start_time'     => isset($this->data['stores_open_starts'][$day_key]) ? $this->data['stores_open_starts'][$day_key] : '',
				'end_time'       => isset($this->data['stores_open_ends'][$day_key]) ? $this->data['stores_open_ends'][$day_key] : '',
				'start_time_pm'  => isset($this->data['stores_open_pm_start'][$day_key]) ? $this->data['stores_open_pm_start'][$day_key] : '',
				'end_time_pm'    => isset($this->data['stores_open_pm_ends'][$day_key]) ? $this->data['stores_open_pm_ends'][$day_key] : '',
				'custom_text'    => isset($this->data['stores_open_custom_text'][$day_key]) ? $this->data['stores_open_custom_text'][$day_key] : '',
			);

			// Prepare the SET clause
			$set_clause = '';
			foreach ($params_days as $key => $val) {
				$set_clause .= "$key=" . $this->db->quote($val) . ", ";
			}
			$set_clause = rtrim($set_clause, ", ");

			// Run the update
			$sql = "
				UPDATE mt_opening_hours 
				SET $set_clause
				WHERE day = " . $this->db->quote($day_key) . " 
				AND merchant_id = " . $this->db->quote($merchant_id) . "
			";
			$this->db->exec($sql);
		}
	}

	$this->functions->updateOption("stores_open_day",
		isset($this->data['stores_open_day']) ? json_encode($this->data['stores_open_day']) : '',
		$merchant_id);

	$this->functions->updateOption("stores_open_starts",
		isset($this->data['stores_open_starts']) ? json_encode($this->data['stores_open_starts']) : '',
		$merchant_id);

	$this->functions->updateOption("stores_open_ends",
		isset($this->data['stores_open_ends']) ? json_encode($this->data['stores_open_ends']) : '',
		$merchant_id);

	$this->functions->updateOption("stores_open_custom_text",
		isset($this->data['stores_open_custom_text']) ? json_encode($this->data['stores_open_custom_text']) : '',
		$merchant_id);

	$this->functions->updateOption("stores_open_pm_start",
		isset($this->data['stores_open_pm_start']) ? json_encode($this->data['stores_open_pm_start']) : '',
		$merchant_id);

	$this->functions->updateOption("stores_open_pm_ends",
		isset($this->data['stores_open_pm_ends']) ? json_encode($this->data['stores_open_pm_ends']) : '',
		$merchant_id);

	$this->functions->updateOption("merchant_preorder",
		isset($this->data['merchant_preorder']) ? trim($this->data['merchant_preorder']) : '',
		$merchant_id);

	$this->functions->updateOption("merchant_close_msg",
		isset($this->data['merchant_close_msg']) ? trim($this->data['merchant_close_msg']) : '',
		$merchant_id);

	$this->functions->updateOption("merchant_close_msg_holiday",
		isset($this->data['merchant_close_msg_holiday']) ? trim($this->data['merchant_close_msg_holiday']) : '',
		$merchant_id);

	if (is_array($this->data['merchant_holiday']) && count($this->data['merchant_holiday']) >= 1) {
		$this->functions->updateOption("merchant_holiday",
			isset($this->data['merchant_holiday']) ? json_encode($this->data['merchant_holiday']) : '',
			$merchant_id);
	} else {
		$this->functions->updateOption("merchant_holiday", '', $merchant_id);
	}

	$this->code = 1;
	$this->msg = "Setting saved";
	$this->details = array();
	$this->output();
}








	

	
				

	


		





	







    
	




	
	













	






	

	










	






	
	



   











	
	
	
}
/*end class*/