<?php
class Bluetooth
{

    public function __construct() {
         $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions
       
        $this->FoodItemWrapper = new FoodItemWrapper();
        

    }


public  function interfaceList()
    {
        return array(
            'bluetooth'=>"bluetooth",
            
         );
    }
    
    public  function paperWidthList()
    {
         return array(
            '58'=>"58 mm",
            '80'=>"80 mm",
          );
    }
    
    public  function characterCodeList()
    {
        return array(
          'CHARCODE_PC437'=>"USA Standard Europe",
          'CHARCODE_JIS'=>"Japanese Katakana",
          'CHARCODE_PC850'=>"Multilingual",
          'CHARCODE_PC860'=>"Portuguese",
          'CHARCODE_PC863'=>"Canadian-French",
          'CHARCODE_PC865'=>"Nordic",
          'CHARCODE_WEU'=>"Simplified Kanji, Hirakana",
          'CHARCODE_GREEK'=>"Simplified Kanji",
          'CHARCODE_HEBREW'=>"Simplified Kanji",
          'CHARCODE_PC1252'=>"Western European Windows Code Set",
          'CHARCODE_PC866'=>"Cirillic",
          'CHARCODE_PC852'=>"Latin 2",
          'CHARCODE_PC858'=>"Euro",
          'CHARCODE_THAI42'=>"Thai character code 42",
          'CHARCODE_THAI11'=>"Thai character code 11",
          'CHARCODE_THAI13'=>"Thai character code 13",
          'CHARCODE_THAI14'=>"Thai character code 14",
          'CHARCODE_THAI16'=>"Thai character code 16",
          'CHARCODE_THAI17'=>"Thai character code 17",
          'CHARCODE_THAI18'=>"Thai character code 18"
        );
    }

    public function getPrinterList($merchant_id = 0, $device_uiid = '', $start = 0, $total_rows = 10, $search_string = '', $field_sort = 'a.id', $sort = 'DESC', $all = true)
{
    $and = '';
    $params = [];

    if (!empty($search_string)) {
        $and = " AND printer_name LIKE :search_string ";
        $params[':search_string'] = "%$search_string%";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*
        FROM mt_printer_list_new a
        WHERE merchant_id = :merchant_id
        AND device_uiid = :device_uiid
        $and
        ORDER BY $field_sort $sort
        LIMIT $start, $total_rows
    ";

    $params[':merchant_id'] = (int)$merchant_id;
    $params[':device_uiid'] = $device_uiid;

    $query = $this->db->prepare($stmt);

    if ($query->execute($params)) {
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    return false;
}


public function insertPrinter($merchant_id = '', $params = array(), $id = '', $device_uiid = '')
{
    if ($id > 0) {
        $stmt = "
            SELECT mac_address 
            FROM mt_printer_list_new 
            WHERE merchant_id = :merchant_id 
            AND mac_address = :mac_address 
            AND device_uiid = :device_uiid 
            AND id <> :id 
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([
            ':merchant_id' => $merchant_id,
            ':mac_address' => $params['mac_address'],
            ':device_uiid' => $device_uiid,
            ':id' => $id,
        ]);

        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            $up = $this->functions->updateData("mt_printer_list_new", $params, 'id', $id);
            if ($up) {
                return true;
            } else {
                throw new Exception("Failed cannot update records");
            }
        } else {
            throw new Exception("Name already exist");
        }
    } else {
        $stmt = "
            SELECT mac_address 
            FROM mt_printer_list_new 
            WHERE merchant_id = :merchant_id 
            AND mac_address = :mac_address 
            AND device_uiid = :device_uiid 
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([
            ':merchant_id' => $merchant_id,
            ':mac_address' => $params['mac_address'],
            ':device_uiid' => $device_uiid,
        ]);

        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            if ($this->functions->insertData("mt_printer_list_new", $params)) {
                return true;
            } else {
                throw new Exception("Failed cannot insert records");
            }
        } else {
            throw new Exception("printer Mac address already exist");
        }
    }

    throw new Exception("an error has occurred");
}


public function deletePrinter($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion");
    }

    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $params = array_merge([$merchant_id], $ids);

    $stmt = "
        DELETE FROM mt_printer_list_new
        WHERE merchant_id = ?
        AND id IN ($placeholders)
    ";

    $query = $this->db->prepare($stmt);
    $resp = $query->execute($params);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}

    
    public  function getPrinter($printer_id='')
    {
          $printer_data = array();
          $resp = $this->FoodItemWrapper->getData("printer_list_new","id=:id",array(
             ':id'=>$printer_id
            ));
          $printer_data['printer_name']=$resp['printer_name'];
          $printer_data['mac_address']=$resp['mac_address'];
          $printer_data['data1']=$resp['data1'];
          $printer_data['data2']=$resp['data2'];
          $printer_data['paper_width']=$resp['paper_width'];
          $printer_data['auto_print']=$resp['auto_print'];
          $printer_data['char_set']=$resp['char_set'];
          return $printer_data;
    }


    public  function printerOptionsData()
    {
        $prefix="print_"; 
        return array(
          $prefix.'merchant_name', $prefix.'merchant_address', $prefix.'merchant_contact_phone', $prefix.'printed_date',
          $prefix.'customer_name', $prefix.'trans_type', $prefix.'payment_type', $prefix.'order_id',
          $prefix.'date_created', $prefix.'delivery_date', $prefix.'delivery_time', $prefix.'delivery_address',
          $prefix.'delivery_instruction', $prefix.'location_name', $prefix.'contact_phone', $prefix.'order_change',
          $prefix.'site_url', $prefix.'footer'
        );
    }
    
    public function getPrinterOptions($merchant_id = '')
{
    $data = array();
    
    $options_name = $this->printerOptionsData();
    
    $que = '';
    if (is_array($options_name) && count($options_name) >= 1) {
        foreach ($options_name as $key => $val) {
            $que .= "'" . $val . "',";
        }
        $que = substr($que, 0, -1);
    }

    $stmt = "
        SELECT option_name, option_value
        FROM mt_option     
        WHERE option_name IN ($que)
        AND merchant_id = 0
    ";

    $query = $this->db->prepare($stmt);
    if ($query->execute()) {
        $resp = $query->fetchAll(PDO::FETCH_ASSOC);
        foreach ($resp as $val) {
            switch ($val['option_name']) {
                case "print_footer":
                    if (!empty($val['option_value'])) {
                        $data[$val['option_name']] = trim($val['option_value']);
                    }
                    break;

                default:
                    if ($val['option_value'] == 1) {
                        $data[$val['option_name']] = trim($val['option_value']);
                    }
                    break;
            }
        }
    }

    return $data;
}





  



    










    
      
}
/*END CLASS*/