<?php
class ApiController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{




			
		$this->functions = new Functions();
		$this->mobileWrapper = new mobileWrapper();
        $this->itemWrapper = new itemWrapper();
        $this->MapsWrapperTemp = new MapsWrapperTemp();
        $this->LocationWrapper = new LocationWrapper();
        $this->PointsProgram=new PointsProgram();
        
        $this->InventoryWrapper = new InventoryWrapper();

        $this->Validator = new Validator();

        $this->CheckoutWrapperTemp = new CheckoutWrapperTemp();

		$model = Model::getInstance();
        
        $this->db = $model->getDb();

        $this->data=$_GET;
		$this->getGETData();
										
		$lang='en';	

		$website_timezone=$this->functions->getOptionAdmin("website_timezone");   
        date_default_timezone_set($website_timezone);


        $api_key = isset($_REQUEST['api_key'])?trim($_REQUEST['api_key']):'';        
        $api_has_key = trim($this->functions->getOptionAdmin('mobileapp2_api_has_key'));

       if($api_key==""){
       	$api_key=trim($this->functions->getOptionAdmin('mobileapp2_api_has_key'));
       }

      
                
        if($api_has_key!=$api_key){
        	$this->msg = "invalid api hash key";
        	$this->output();
        	return false;
        }	

     



	}

	public function output()
{
    // Allow cross-origin access
    header('Access-Control-Allow-Origin: *');
    header('Content-type: application/javascript;charset=utf-8');
    
    // Prepare the response array
    $resp = array(
        'code' => $this->code,
        'msg' => $this->msg,
        'details' => $this->details,
        'get' => $_GET,
        'post' => $_POST
    );
    
    // Check if 'callback' exists in GET request, else set it to an empty string
    if (!isset($_GET['callback'])) {
        $_GET['callback'] = '';
    }
    
    // If jsonp is requested, wrap the response in the callback function
    if (isset($_GET['jsonp']) && $_GET['jsonp'] == true) {
        echo $_GET['callback'] . '(' . json_encode($resp) . ')';
    } else {
        // Otherwise, just return the JSON response
        echo json_encode($resp);
    }

    // End the script execution (optional, depending on your use case)
    exit();
}
	
	
    public function Index(){
		echo "API IS WORKING";
	}	

	
	
	
	public function getGETData()
	{
		$this->device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        $this->merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
	}

	public function getPOSTData()
	{
		$this->device_uiid = isset($_POST['device_uiid'])?$_POST['device_uiid']:'';
        $this->merchant_id = isset($_POST['merchant_id'])?$_POST['merchant_id']:'';
	}


	public function checkToken()
	{
		$this->data['user_token'] = isset($this->data['user_token'])?$this->data['user_token']:'';
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			return false;
		}			
		$client_id = $res['client_id'];	
		return $client_id;
		
	}


	public function getSettings()
  {     
    $this->code = 1;
    $this->msg = "OK";
    
    $settings=array();    
    
    $mobile_prefix = $this->functions->getOptionAdmin('mobileapp2_prefix'); 
    if(empty($mobile_prefix)){
      $mobile_countrycode = $this->functions->mobilecountry_code();   
      $admin_country_set=$this->functions->getOptionAdmin('admin_country_set');
      if(!empty($admin_country_set)){
        if(array_key_exists($admin_country_set,$mobile_countrycode)){
           $mobile_prefix = "+". $mobile_countrycode[$admin_country_set]['code'];
        } 
      } 
    } else $mobile_prefix = "+$mobile_prefix";
            
    $startup_options = $this->functions->getOptionAdmin('mobileapp2_startup');    
    
      $settings['startup']=array(
        'options'=>empty($startup_options)?1:$startup_options,        
        'select_language'=>$this->functions->getOptionAdmin('mobile2_enabled_select_language'),
        'banner'=>$this->mobileWrapper->getStartupBanner(),
        'startup_auto_scroll'=>$this->functions->getOptionAdmin('mobileapp2_startup_auto_scroll'),
        'startup_interval'=>$this->functions->getOptionAdmin('mobileapp2_startup_interval'),
      );
    
    
    $location_rep = $this->mobileWrapper->searchMode();
    $settings['search_mode']=$location_rep['search_mode'];
    $settings['location_mode'] = $location_rep['location_mode'];
    $settings['mobile_prefix']=$mobile_prefix;
    $settings['cart_theme']=$this->functions->getOptionAdmin('mobileapp2_cart_theme');
    $settings['future_order_confirm']=$this->functions->getOptionAdmin('mobileapp2_future_order_confirm');
    $settings['mobile_turnoff_prefix']=$this->functions->getOptionAdmin('mobileapp2_turnoff_prefix');
    $settings['menu_type']= $this->mobileWrapper->getMenuType();    
    $settings['enabled_dish']=$this->functions->getOptionAdmin('mobile2_enabled_dish');
    $settings['disabled_image_menu1']=$this->functions->getOptionAdmin('mobile2_disabled_image_menu1');
    $settings['mobileapp2_select_map']=$this->functions->getOptionAdmin('mobileapp2_select_map');
    $settings['mobileapp2_language']=$this->functions->getOptionAdmin('mobileapp2_language');
    $settings['mobile2_enabled_fblogin']=$this->functions->getOptionAdmin('mobile2_enabled_fblogin');
    $settings['mobile2_enabled_googlogin']=$this->functions->getOptionAdmin('mobile2_enabled_googlogin');
    $settings['mobile2_analytics_enabled']=$this->functions->getOptionAdmin('mobile2_analytics_enabled');
    $settings['mobile2_analytics_id']=$this->functions->getOptionAdmin('mobile2_analytics_id');
    $settings['mobile2_location_accuracy']=$this->functions->getOptionAdmin('mobileapp2_location_accuracy');
    if(empty($settings['mobile2_location_accuracy'])){
      $settings['mobile2_location_accuracy']='REQUEST_PRIORITY_BALANCED_POWER_ACCURACY';
    } 
    
    $settings['age_restriction'] = $this->functions->getOptionAdmin('age_restriction');
    $settings['age_restriction_content'] = $this->functions->getOptionAdmin('age_restriction_content');
    
    $mobileapp2_reg_email = $this->functions->getOptionAdmin('mobileapp2_reg_email');
    $mobileapp2_reg_phone = $this->functions->getOptionAdmin('mobileapp2_reg_phone');
    
    if(empty($mobileapp2_reg_email) && empty($mobileapp2_reg_phone)){
      $mobileapp2_reg_email=1;$mobileapp2_reg_phone=1;
    } 
    
    $settings['registration'] = array(
      'email'=>$mobileapp2_reg_email,
      'phone'=>$mobileapp2_reg_phone
    );
    
    $settings['tracking_theme'] = $this->functions->getOptionAdmin('mobileapp2_tracking_theme');
    if(empty($settings['tracking_theme'])){
      $settings['tracking_theme']=1;
    } 
    $settings['tracking_interval'] = $this->functions->getOptionAdmin('mobileapp2_tracking_interval');
    if($settings['tracking_interval']<=0 && empty($settings['tracking_interval'])){
      $settings['tracking_interval']=7000;
    } 
    
    $settings['home']=array(
      'mobile2_home_offer'=>$this->functions->getOptionAdmin('mobile2_home_offer'),
      'mobile2_home_featured'=>$this->functions->getOptionAdmin('mobile2_home_featured'),
      'mobile2_home_cuisine'=>$this->functions->getOptionAdmin('mobile2_home_cuisine'),
      'mobile2_home_all_restaurant'=>$this->functions->getOptionAdmin('mobile2_home_all_restaurant'),
      'mobile2_home_favorite_restaurant'=>$this->functions->getOptionAdmin('mobile2_home_favorite_restaurant'),
      'mobile2_home_banner'=>$this->functions->getOptionAdmin('mobile2_home_banner'),
      'mobile2_home_banner_full'=>$this->functions->getOptionAdmin('mobile2_home_banner_full'),
      'mobile2_home_food_discount'=>$this->functions->getOptionAdmin('mobile2_home_food_discount'),
      'mobile2_home_banner_auto_scroll'=>$this->functions->getOptionAdmin('mobile2_home_banner_auto_scroll'),
      'mobile2_home_categories'=>$this->functions->getOptionAdmin('mobile2_home_categories')
    );
    
    $code_version = isset($this->data['code_version'])?$this->data['code_version']:'';
    if($settings['home']['mobile2_home_banner']==1){
      if($code_version>=1.5){       
        $settings['home_banner'] = $this->mobileWrapper->getHomeBannerNew();
      } else $settings['home_banner'] = $this->mobileWrapper->getHomeBanner();
    } else $settings['home_banner'] = array();
    
    if($settings['home']['mobile2_home_categories']==1){
      $settings['home_categories'] = $this->mobileWrapper->getHomeBannerNew('home_category');
    }
    
    
    $settings['mobile2_disabled_default_image'] = $this->functions->getOptionAdmin('mobile2_disabled_default_image');
    
    $device_platform = isset($this->data['device_platform'])?$this->data['device_platform']:'';
   

    $settings['map_provider'] = $this->functions->getMapProvider_mobileapp($device_platform);

    $settings['map_country']  = $this->functions->getCountryCode();   
    
    $settings['map_auto_identity_location']  = $this->functions->getOptionAdmin('map_auto_identity_location');
    
    $settings['default_map_location']  = array(
      'lat'=>$this->functions->getOptionAdmin('mobile2_default_lat'),
      'lng'=>$this->functions->getOptionAdmin('mobile2_default_lng')
    );
            
    $settings['website_hide_foodprice'] = $this->functions->getOptionAdmin('website_hide_foodprice');
    $settings['enabled_map_selection_delivery'] = $this->functions->getOptionAdmin('enabled_map_selection_delivery');   
    $settings['merchant_two_flavor_option'] = $this->functions->getOptionAdmin('merchant_two_flavor_option');
    $settings['images']=array(
       'image1'=>$this->mobileWrapper->getImage('mobile-default-logo.png'),
       'image2'=>$this->mobileWrapper->getImage('resto_banner.jpg','resto_banner.jpg'),
       'image3'=>$this->mobileWrapper->getImage('default_bg.jpg','default_bg.jpg'),
    );  


    $settings['icons']=array(
      'marker1'=>Config::$baseUrl."/assets_mobileapp/images/icon_28.png",
      'marker2'=>Config::$baseUrl."/assets_mobileapp/images/marker_green.png",
      'marker3'=>Config::$baseUrl."/assets_mobileapp/images/marker_orange.png",
      'bicycle'=>Config::$baseUrl."/assets_mobileapp/images/bicycle.png",
      'bike'=>Config::$baseUrl."/assets_mobileapp/images/bike.png",
      'car'=>Config::$baseUrl."/assets_mobileapp/images/car.png",
      'scooter'=>Config::$baseUrl."/assets_mobileapp/images/scooter.png",
      'truck'=>Config::$baseUrl."/assets_mobileapp/images/truck.png",
      'walk'=>Config::$baseUrl."/assets_mobileapp/images/walk.png",
    );  
    $settings['marker_icon']=array(
       $settings['icons']['marker1'],
       $settings['icons']['marker2'],
       $settings['icons']['marker3'],
       Config::$baseUrl."/assets_mobileapp/images/marker1.png",
       Config::$baseUrl."/assets_mobileapp/images/marker2.png",
       Config::$baseUrl."/assets_mobileapp/images/marker3.png",
       Config::$baseUrl."/assets_mobileapp/images/marker4.png",
    );
    $settings['list_type'] = $this->mobileWrapper->getListType();
    
    $settings['addon']['driver']=false;
    
        
    $settings['addon']['points']=false;
    
        
    if($settings['mobileapp2_language']=="0"){      
       $settings['mobileapp2_language']='en';
    }
    
    $settings['cod_change_required']=$this->functions->getOptionAdmin('cod_change_required');
      $settings['disabled_website_ordering']=$this->functions->getOptionAdmin('disabled_website_ordering');
      $settings['mapbox_access_token']=$this->functions->getOptionAdmin('mapbox_access_token');
      $settings['mapbox_default_zoom']=$this->functions->getOptionAdmin('mapbox_default_zoom');
      $settings['disabled_cc_management']=$this->functions->getOptionAdmin('disabled_cc_management');
      $settings['merchant_tbl_book_disabled']=$this->functions->getOptionAdmin('merchant_tbl_book_disabled');
    
    $settings['currency_symbol'] = $this->functions->getCurrencyCode();
    $settings['currency_position']=$this->functions->getOptionAdmin('admin_currency_position');
      $settings['currency_decimal_place']=$this->functions->getOptionAdmin('admin_decimal_place');
      $settings['currency_space']=$this->functions->getOptionAdmin('admin_add_space_between_price');
      $settings['currency_use_separators']=$this->functions->getOptionAdmin('admin_use_separators');
      $settings['currency_decimal_separator']=$this->functions->getOptionAdmin('admin_decimal_separator');
      $settings['currency_thousand_separator']=$this->functions->getOptionAdmin('admin_thousand_separator');
            
    if(empty($settings['currency_position'])){
      $settings['currency_position']='left';
    }
    if(empty($settings['currency_decimal_place'])){
      $settings['currency_decimal_place']=2;
    }
    if(empty($settings['currency_decimal_separator'])){
      $settings['currency_decimal_separator']=".";
    }
    if($settings['currency_use_separators']=="yes"){
      if($settings['currency_thousand_separator']==""){
        $settings['currency_thousand_separator']=",";
      }   
    } 
    
    $reg_field_1 = $this->functions->getOptionAdmin('client_custom_field_name1');
    $reg_field_2 = $this->functions->getOptionAdmin('client_custom_field_name2');
    
    $settings['reg_custom']=0;
    
    if(!empty($reg_field_1) || !empty($reg_field_2)){
      $fields=array();
      if(!empty($reg_field_1)){
        $fields['custom_field1']=$reg_field_1;
      }
      if(!empty($reg_field_2)){
        $fields['custom_field2']=$reg_field_2;
      }
      $settings['reg_custom_fields']=$fields;
      $settings['reg_custom']=1;
    }
    
    $valid_token = 2; $client_info = array();
    if(isset($this->data['user_token'])){
      if($client_info = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){              
         if (!$this->mobileWrapper->checkBlockAccount($client_info['email_address'],$client_info['contact_phone'])){
             $valid_token = 1;             
         }    
      }
    }
            
    $settings['valid_token']=$valid_token;
    
    if ($device_info = $this->mobileWrapper->getDeviceByUIID( $this->device_uiid )){
      $settings['subscribe_topic']= $device_info['subscribe_topic'];
    } else $settings['subscribe_topic'] = 1;
    
        
    $sortby = array(
      'restaurant'=>$this->mobileWrapper->sortRestaurantList( $location_rep['search_mode'] ),
      'cusine'=>$this->mobileWrapper->sortCuisineList(),
      'food_promo'=>$this->mobileWrapper->foodPromoSort(),
    );
    $settings['sort']=$sortby;

    $filters = array(
      'delivery_fee'=>array(
        'delivery_fee'=>"Free Delivery"
      ),
      'promos'=>array(
        'offer'=>"Offers",
        'voucher'=>"Vouchers",
      ),
      'services'=>$this->mobileWrapper->servicesList(),     
      'dishes_list'=>$this->itemWrapper->dishesList(),    
      'cuisine'=>$this->functions->Cuisine(false),      
      'minimum_order'=>$this->functions->minimumDeliveryFee()
    );
    $settings['filters']=$filters;
    
    
    $settings['custom_pages'] = $this->mobileWrapper->getTitlePages();
    $settings['custom_pages_location'] = $this->functions->getOptionAdmin('mobileapp2_custom_pages_position');
    
    $settings['order_tabs'] = array(
      'all'=>("All"),
      'processing'=>"Processing",
      'completed'=>"Completed",
      'cancelled'=>"Cancelled",
    );
    
    $settings['booking_tabs'] = array(
      'all'=>"All",
      'pending'=>"Pending",
      'approved'=>"Approved",
      'denied'=>"Denied",
    );
        
    $app_dict = array();

    

    $dict_cuisine = $this->mobileWrapper->cuisineListDict( $filters['cuisine'] );
    $dict_pages = array();  
    $dict = array_merge((array)$app_dict,(array)$dict_cuisine, (array)$dict_pages );    
    $settings['dict'] = $dict;    
    
    $website_terms_customer = $this->functions->getOptionAdmin('website_terms_customer');
    $settings['signup_settings'] = array(
      'enabled_terms_condition'=> $website_terms_customer=="yes"?1:0,
      'terms_url'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('website_terms_customer_url'))
    );
    
    $settings['enabled_addon_desc'] = $this->functions->getOptionAdmin('mobile2_enabled_addon_desc');
    $settings['geocomplete_default_country'] = $this->functions->getOptionAdmin('google_default_country');
    
    
    $contact_content_default = "We are always happy to hear from our clients and visitors, you may contact us anytime";
    $contact_content = $this->functions->getOptionAdmin('contact_content');
    
    $contact_field = $this->functions->getOptionAdmin('contact_field');
    if(!empty($contact_field)){
      $contact_field = json_decode($contact_field,true);
    } else {
      $contact_field = array('name','email');
    } 
            
    $settings['contact_us'] = array(
      'contact_content'=>!empty($contact_content)?nl2br($contact_content):$contact_content_default,
      'contact_field'=>$contact_field,
      'enabled_contact'=>$this->functions->getOptionAdmin('mobileapp2_enabled_contact')
    );
    
    $settings['remove_contact'] = $this->functions->getOptionAdmin('mobileapp2_remove_contact');
    
    $lang_rtl = $this->functions->getOptionAdmin('lang_rtl');   
    $settings['lang_rtl'] = !empty($lang_rtl)?json_decode($lang_rtl,true):array();
    
    $settings['customer_forgot_password_sms'] = $this->functions->getOptionAdmin('customer_forgot_password_sms');
    $settings['enabled_operating_hours'] = $this->functions->getOptionAdmin('enabled_operating_hours');
    
    $settings['cart_with_qty'] = $this->functions->getOptionAdmin('mobile2_cart_with_qty');
    $settings['social_share_food'] = $this->functions->getOptionAdmin('mobile2_food_share');
    $settings['home_all_as_list'] = $this->functions->getOptionAdmin('mobile2_home_all_as_list');
    
    $mobile2_home_use_view_all = $this->functions->getOptionAdmin('mobile2_home_use_view_all');
    $settings['home_view_all'] = array(
      'type'=>$mobile2_home_use_view_all==1?"words":'icon',
      'label'=>"VIEW ALL"
    );
    
    $settings['app_rating'] = array(
      'enabled'=>$this->functions->getOptionAdmin('mobileapp2_enabled_app_rating'),
      'email'=>$this->functions->getOptionAdmin('mobileapp2_feedback_email'),
      'ios_id'=>$this->functions->getOptionAdmin('mobileapp2_app_rating_ios_id'),
      'android_id'=>$this->functions->getOptionAdmin('mobileapp2_app_rating_android_id'),
    );
    
    $this->details=array(
      'valid_token'=>$valid_token,
      'settings'=>$settings
    );        
              
    $this->output();
  }


	public function getMobileCodeList()
	{
		$mobile_countrycode = $this->functions->MobileCountryCode();
		$data = array();
		
		foreach ($mobile_countrycode as $key=>$val) {						
			$val['name']=ucwords(strtolower($val['name']));
			$val['country_code']=$key;
			$data[]=$val;			
		}
				
		$this->code=1;
		$this->msg="OK";
		$this->details = array(				  
		  'data'=>$data
		);
		$this->output();
	}



	public function createAccount()
	{


		$this->data = $_POST;		
		
		
		if ($this->data['password']!=$this->data['cpassword']){			
			$this->Validator->setmsg("Confirm password does not match");
		}
		
		$mobileapp2_reg_email = $this->functions->getOptionAdmin('mobileapp2_reg_email');
		$mobileapp2_reg_phone = $this->functions->getOptionAdmin('mobileapp2_reg_phone');
		
		if(empty($mobileapp2_reg_email) && empty($mobileapp2_reg_phone)){
			$mobileapp2_reg_email=1;$mobileapp2_reg_phone=1;
		}			
		
		/*check if email address is blocked*/
		if($mobileapp2_reg_email==1){

	    	if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
	    		
	    		$this->Validator->setmsg("Sorry but your email address is blocked by website admin");

	    	}
            
            //$test=$this->functions->isClientExist($this->data['email_address']);
	    	



	    	if ($this->functions->isClientExist_with_merchant($this->data['email_address'],0)){			
			    
              
			    $this->Validator->setmsg("Sorry but your email address already exist in our records");
		    }
		}
    	
		if($mobileapp2_reg_phone==1){
	    	if ( $this->functions->mobileBlockedCheck($this->data['contact_phone'])){
				

				$this->Validator->setmsg("Sorry but your mobile number is blocked by website admin");		
			}
			
			if ( $this->functions->CheckCustomerMobile_with_merchant($this->data['contact_phone'],0)){
	        	//$this->Validator->msg[]  = $this->functions->translation("default","Sorry but your mobile number is already exist in our records");     

	        	$this->Validator->setmsg("Sorry but your mobile number is already exist in our records");	   	
	        }	
		}

		/*$this->details = array(
    			  //'form_next_step'=>isset($this->data['form_next_step'])?$this->data['form_next_step']:'',
    			  'test'=>$this->Validator->getmsg(),
    			  'email'=>$this->Validator->validate(),
    			  
    			);
	    	$this->output();*/

			
		
		if($this->Validator->validate()){
					
			$params=array(
    		  'first_name'=>($this->data['first_name']),
    		  'last_name'=>($this->data['last_name']),    		  
    		  'password'=>md5($this->data['password']),
    		  'date_created'=>$this->functions->dateNow(),
    		  'last_login'=>$this->functions->dateNow(),
    		  'ip_address'=>$_SERVER['REMOTE_ADDR'], 
    		  'merchant_id'=>0,   		  
    		  'social_strategy'=>'mobileapp2'
    		);    	
    		
    		if($mobileapp2_reg_email==1){
    			$params['email_address'] = (trim($this->data['email_address']));
    		}
    		if($mobileapp2_reg_phone==1){
    			$params['contact_phone'] = trim($this->data['contact_phone']);
    		}
    		
    		if (isset($this->data['custom_field1'])){
	    		$params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
	    	}
	    	if (isset($this->data['custom_field2'])){
	    		$params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
	    	}
	    	
	    	//$this->data['next_step']='map_select_location';
	    		    	
    		/** send verification code */
            $verification=$this->functions->getOptionAdmin('website_enabled_mobile_verification');            
	    	if ( $verification=="yes" && $mobileapp2_reg_phone==1){
	    		$code=$this->functions->generateRandomKey(5);		    		
	    		$this->functions->sendCustomerSMSVerification($params['contact_phone'],$code);
	    		$params['mobile_verification_code']=$code;
	    		$params['status']='pending';
	    		$this->data['next_step'] = 'verification_mobile';
	    	}	    	
	    	
	    	/*send email verification added on version 3*/
	    	$email_code=$this->functions->generateRandomKey(5);
	    	$email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');
	    	if ($email_verification==2 && $mobileapp2_reg_email==1){
	    		$params['email_verification_code']=$email_code;
	    		$params['status']='pending';
	    		$this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
	    		$this->data['next_step'] = 'verification_email';
	    	}
	    	
	    	$token = $this->mobileWrapper->generateUniqueToken(15,$this->data['device_uiid']);
	    	$params['token']=$token;
	    		    	
	    	
	    	$last_insert_id = $this->functions->insertData('mt_client', $params);
            if ($last_insert_id!== false){     		
	    		$customer_id =$last_insert_id;	    		
	    		$this->code=1;
	    		$this->msg = $this->functions->translation("default","Registration successful");
	    		
	    		if ( $verification=="yes" && $mobileapp2_reg_phone==1){	    				
    				$this->msg=$this->functions->translation("default","We have sent verification code to your mobile number");
    				
    				$this->data['client_id'] = $customer_id;
				    $this->mobileWrapper->registeredDevice($this->data,'pending');
				    
    			} elseif ( $email_verification ==2 && $mobileapp2_reg_email==1 ){ 
    				$this->msg = $this->functions->translation("default","We have sent verification code to your email address");
    				
    				$this->data['client_id'] = $customer_id;
				    $this->mobileWrapper->registeredDevice($this->data,'pending');
    			} else {    				
    				/*sent welcome email*/	
    				$this->functions->sendCustomerWelcomeEmail($params);
    				
    				$this->data['client_id'] = $customer_id;
				    $this->mobileWrapper->registeredDevice($this->data);
    			}	   
    			
    			$this->details = array(
    			  //'form_next_step'=>isset($this->data['form_next_step'])?$this->data['form_next_step']:'',
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'customer_token'=>$token,    			  
    			  'contact_phone'=>isset($params['contact_phone'])?$params['contact_phone']:'',
    			  'email_address'=>isset($params['email_address'])?$params['email_address']:'',
    			);
	    		
    			/*POINTS PROGRAM*/	    			
	    	    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
	    		    PointsProgram::signupReward($customer_id);
	    	    }*/	    

	    	     $this->PointsProgram->signupReward($customer_id);	    	    	    
	    	    
	    	} else $this->msg = $this->functions->translation("default","Something went wrong during processing your request. Please try again later");
	    	
		} else $this->msg = $this->mobileWrapper->parseValidatorError($this->Validator->getError());
		
		$this->output();
	}


	public function resendCode()
	{	
		$verification_type = isset($this->data['verification_type'])?$this->data['verification_type']:'';
		$customer_token = isset($this->data['customer_token'])?$this->data['customer_token']:'';
				
		if(!empty($customer_token)){
			if ($res = $this->mobileWrapper->getCustomerByToken($customer_token,false)){
				$client_id = $res['client_id'];
				
				switch ($verification_type) {
					case "verification_email":
						
						$email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
						if(!empty($email_address)){					
							
							$ok_to_send = true;
							
							$date_now = date('Y-m-d g:i:s a');
							$verify_code_requested = date("Y-m-d g:i:s a",strtotime($res['verify_code_requested']));
							$time_diff=$this->functions->dateDifference($verify_code_requested,$date_now);
							//dump($time_diff);
							
							if(is_array($time_diff) && count($time_diff)>=1){
								if($time_diff['days']<=0){
									if($time_diff['hours']<=0){
										if($time_diff['minutes']<=1){
											$ok_to_send=false;
										}
									}
								}
							}
		
							if($ok_to_send){
								$this->functions->sendEmailVerificationCode($email_address,$res['email_verification_code'],$res);					
								$this->code = 1;
								$this->msg = $this->functions->translation("default","code was sent to your email");
								
								
								

								$this->functions->updateData("mt_client", array(
								  'verify_code_requested'=>$this->functions->dateNow()
								), 'client_id', $client_id);


								
							} else {
								$this->msg = $this->functions->translation("default","you are requesting too soon please wait a minute then try again");
								$this->details = $time_diff;
							}					
							
						} else $this->msg = $this->functions->translation("default","invalid email address");
						
						break;
				
					case "verification_mobile":	
					    $contact_phone = isset($this->data['contact_phone'])?$this->data['contact_phone']:'';					    
					    $code = isset($res['mobile_verification_code'])?$res['mobile_verification_code']:'';					    
					    
					    if(!empty($contact_phone)) {
					    	
					    	$ok_to_send = true;
							
							$date_now = date('Y-m-d g:i:s a');
							$verify_code_requested = date("Y-m-d g:i:s a",strtotime($res['verify_code_requested']));
							$time_diff=$this->functions->dateDifference($verify_code_requested,$date_now);
							//dump($time_diff);
							
							if(is_array($time_diff) && count($time_diff)>=1){
								if($time_diff['days']<=0){
									if($time_diff['hours']<=0){
										if($time_diff['minutes']<=1){
											$ok_to_send=false;
										}
									}
								}
							}
							
							if($ok_to_send){
							    $this->functions->sendCustomerSMSVerification($contact_phone,$code);
							    $this->msg = $this->functions->translation("default","code was sent to your mobile");			
							    $this->code = 1;	
							    
							    
								

								$this->functions->updateData("mt_client", array(
								  'verify_code_requested'=>$this->functions->dateNow()
								), 'client_id', $client_id);




									    
							} else {
								$this->msg = $this->functions->translation("default","you are requesting too soon please wait a minute then try again");
								$this->details = $time_diff;
							}
						    
					    } else $this->msg = $this->functions->translation("default","invalid mobile number");
					    break;
					  
					default:
						$this->msg = $this->functions->translation("default","invalid verification type");
						break;
				}				
			} else $this->msg = $this->functions->translation("default","customer not found");
		} else $this->msg = $this->functions->translation("default","invalid customer token");
		$this->output();
	}



	public function verifyCode()
	{
				
		$verification_type = isset($this->data['verification_type'])?$this->data['verification_type']:'';
		$customer_token = isset($this->data['customer_token'])?$this->data['customer_token']:'';
		$code_input = isset($this->data['code'])?$this->data['code']:'';
		
		$this->details = array();
		
		if(!empty($customer_token)){
			if ($res = $this->mobileWrapper->getCustomerByToken($customer_token,false)){				
				$client_id = $res['client_id'];				
				switch ($verification_type) {
					case "verification_email":
						$code = $res['email_verification_code'];
						if ( trim($code)==trim($code_input) ){
							$this->code = 1;
							$this->msg = $this->functions->translation("default","verification ok");							
						} else $this->msg = $this->functions->translation("default","invalid code");
						break;
						
					case "verification_mobile":
						$code = $res['mobile_verification_code'];
						if ( trim($code)==trim($code_input) ){
							$this->code = 1;
							$this->msg = $this->functions->translation("default","verification ok");
						} else $this->msg = $this->functions->translation("default","invalid code");
						break;	
				}
				
				if($this->code==1){
				   $params = array();
				   $token = $res['token']; 
				   if(empty($token)){
				   	  $token = $this->mobileWrapper->generateUniqueToken(15,$client_id);		
				   	  $params['token'] = $token;
				   }				   
				   $this->details['token'] = $token;

				   $params['status']='active';
				   $params['date_modified'] = $this->functions->dateNow();
				   

				   $this->functions->updateData("mt_client", $params,'client_id', $client_id);
				   
				   /*REGISTERED DEVICE*/
				   $this->data['client_id'] = $client_id;
				   $this->mobileWrapper->registeredDevice($this->data);
				   
				}
								
			} else $this->msg = $this->functions->translation("default","customer not found");
		} else $this->msg = $this->functions->translation("default","invalid customer token");
		
		//$this->details['form_next_step'] = isset($this->data['form_next_step'])?$this->data['form_next_step']:'';
		$this->details['next_step'] = isset($this->data['next_step'])?$this->data['next_step']:'';
		
		$this->output();
	}



	public function searchMerchant()
	{		
				
		$this->db->query("SET SQL_BIG_SELECTS=1");
		
		$search_resp = $this->mobileWrapper->searchMode();
		$search_mode = $search_resp['search_mode'];
		$location_mode = $search_resp['location_mode'];		
		
		
		$provider = array(); $provider_mode='';		
	    $provider = $this->mobileWrapper->getMapProvider(); 			
	    $this->MapsWrapperTemp->init($provider);		   
	    $provider_mode = isset($provider['mode'])?$provider['mode']:'driving';		
		
		$home_search_unit_type='';
		
		$search_type = isset($this->data['search_type'])?$this->data['search_type']:'';
		$page_limit = $this->mobileWrapper->paginateLimit();
		$enabled_distance = 1;		
		
		
		$cuisine_name='';
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
                
		$stmt = ''; $and=''; $where='';
		
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
		$lng = isset($this->data['lng'])?$this->data['lng']:'';
		
		
		$home_search_unit_type=$this->functions->getOptionAdmin('home_search_unit_type');
		$home_all_as_list = $this->functions->getOptionAdmin('mobile2_home_all_as_list');
		
		$multipleField = $this->functions->multipleField();	
				
		$distance_exp=3959;
		if ($home_search_unit_type=="km"){
			$distance_exp=6371;
		}	
		
		$lat=!empty($lat)?$lat:0;
		$lng=!empty($lng)?$lng:0;
		
		$a = "
		a.merchant_id,
		a.restaurant_name,				
		a.cuisine,
		a.logo,
		a.latitude,
		a.lontitude,
		a.is_sponsored,
		a.delivery_charges,
		a.service,
		a.status,
		a.is_ready,
		a.minimum_order,
		a.minimum_order as minimum_order_raw,
		a.is_featured,
		a.delivery_distance_covered,
		a.distance_unit,
		a.delivery_estimation,
		concat( a.street,' ', a.city, ' ', a.state, ' ',a.post_code )  as address,	
		a.close_store,	
		";
		
		$query_distance="
		( $distance_exp * acos( cos( radians($lat) ) * cos( radians( latitude ) ) 
				* cos( radians( lontitude ) - radians($lng) ) 
				+ sin( radians($lat) ) * sin( radians( latitude ) ) ) ) 
				AS distance		
		";



				
		$sort_asc_desc = isset($this->data['sort_asc_desc'])?$this->data['sort_asc_desc']:'ASC';		
        $sort_asc_desc = $this->mobileWrapper->validateSort($sort_asc_desc);
				
        $opening_hours = true;
       
        
        $view_cuisine_merchant = true;
        
        $sort_by = isset($this->data['sort_by'])?$this->data['sort_by']:'';		
		$sortby_selected = "Distance";			
        
        if(!$opening_hours){
        	$sort = "ORDER BY is_sponsored DESC, distance $sort_asc_desc";	
        } else $sort = "ORDER BY close_store ASC, merchant_open_status+0 DESC, is_sponsored DESC, distance $sort_asc_desc";				

              	
		if($search_mode=="location"){
			$sort = "ORDER BY close_store ASC,merchant_open_status+0 DESC,is_sponsored DESC, restaurant_name $sort_asc_desc";		
		}			
									
		if(!empty($sort_by)){			
			$sort_resp = $this->mobileWrapper->validateSortRestoList($sort_by);			
			$sort_by = $sort_resp['key'];
			$sortby_selected = $sort_resp['name'];
			if($sort_by=="merchant_open_status"){
				$sort_by="close_store ASC,merchant_open_status+0";
			}
			$sort = "ORDER BY ".stripslashes($sort_by)." $sort_asc_desc";								
		} 		
				
		/*FILTER*/
		$filter = '';
		if(isset($this->data['filter_delivery_fee'])){
			if($this->data['filter_delivery_fee']>=1){
			   $filter.=" AND a.delivery_charges <= 0 ";			   
			   if($search_mode=="address"){  			  
				   $filter.=" AND a.merchant_id NOT IN (
				       select f.merchant_id from mt_shipping_rate f
				       where f.merchant_id = a.merchant_id      	
				       and distance_from<= distance and distance_to>=distance
				       and  f.merchant_id  = (
				          select merchant_id from mt_option
				          where merchant_id = f.merchant_id and option_name='shipping_enabled' 
				          and option_value='2'
				       )		       
				   )";			   
			   } else {			   	   
			   	   $location_filter = $this->LocationWrapper->getLocationFilter($location_mode);			   	   
			   	   $and_filter = '';	
			   	   if(is_array($location_filter) && count($location_filter)>=1){
			   	   	  foreach ($location_filter as $location_filter_val) {			   	   	  	 
			   	   	  	 $xf = isset($this->data[$location_filter_val])?$this->data[$location_filter_val]:'';
			   	   	  	 $and_filter.=" AND $location_filter_val =".($xf)." ";
			   	   	  }			   	   	  
			   	   }			   
			   	   $filter.="
			   	     AND a.merchant_id  IN (
			   	       select f.merchant_id from mt_view_location_rate f
			   	       where f.merchant_id = a.merchant_id and f.fee<=0
			   	       $and_filter
			   	     )
			   	   ";			   	   
			   }			
			}
		}	
		if(isset($this->data['filter_services'])){
			if(is_array($this->data['filter_services']) && count($this->data['filter_services'])>=1){
				$filter_services_stmt='';
				foreach ($this->data['filter_services'] as $filter_services) {					
					switch ($filter_services) {
						case "delivery":							
						    $filter_services_stmt .= " service='1' OR service='2' OR service='4' OR service='5' OR";
							break;
							
					    case "pickup":
					    	$filter_services_stmt .= " service='1' OR service='3' OR service='4' OR service='6' OR";
					   	   break;
					   	   
						case "dinein":
							$filter_services_stmt .= " service='4' OR service='5' OR service='6' OR service='7' OR";
					   	   break;							
					}
				}
				$filter_services_stmt= substr($filter_services_stmt,0,-3);				
				$filter.=" AND ($filter_services_stmt) ";
			}
		}
		
		if(isset($this->data['filter_cuisine'])){
			if(is_array($this->data['filter_cuisine']) && count($this->data['filter_cuisine'])>=1){
				$filter_cuisine_stmt='';
				foreach ($this->data['filter_cuisine'] as $filter_cuisine) {
					$filter_cuisine_stmt.=" cuisine  LIKE ".("%$filter_cuisine%")." OR";
				}
				$filter_cuisine_stmt= substr($filter_cuisine_stmt,0,-3);				
				$filter.=" AND ($filter_cuisine_stmt)";
			}
		}
		
		if(isset($this->data['filter_minimum'])){
			if($this->data['filter_minimum']>=1){
				$filter .= " AND CAST(minimum_order as SIGNED) <= " . ($this->data['filter_minimum']) . " ";

			}
		}
		
		/*FILTER PROMOS*/
		if(isset($this->data['filter_promos'])){			
			if(!empty($this->data['filter_promos']) && $search_type!="special_Offers" ){
				if($this->data['filter_promos']=="offer"){					
					$filter.=" AND a.merchant_id IN (
					   SELECT merchant_id FROM
						mt_offers
						WHERE
						status in ('publish','published')
						AND
						now() >= valid_from and now() <= valid_to
						AND merchant_id = a.merchant_id							
					)";
				}			
			}		
					
			if($this->data['filter_promos']=="voucher"){
			   $filter.=" AND a.merchant_id IN (
					   SELECT merchant_id FROM
						mt_voucher_new
						WHERE
						status in ('publish','published')
						AND
						now() <= expiration
						AND merchant_id = a.merchant_id								
					)";
			}		
		}	
		
		$and.=$filter;
		/*END FILTER*/
				
		
		$and.="  AND a.status='active'  AND a.is_ready ='2' ";
		
		$open_query='';
		if($opening_hours){
			$time_now = date("H:i");
			$open_day = strtolower(date("l"));
			$open_query .= "
    ,(
        SELECT COUNT(*) FROM mt_opening_hours
        WHERE merchant_id = a.merchant_id
        AND day = '$open_day'
        AND status = 'open'
        AND (
            CAST('$time_now' AS TIME) 
            BETWEEN CAST(start_time AS TIME) AND CAST(end_time AS TIME)
            OR
            CAST('$time_now' AS TIME) 
            BETWEEN CAST(start_time_pm AS TIME) AND CAST(end_time_pm AS TIME)
        )
    ) AS merchant_open_status
";

		}
				
		$state_id=''; $city_id =''; $area_id=''; 
		$sub_query_filter=''; $and_location=''; $and_location_fee='';
		
		$state_id = isset($this->data['state_id'])?$this->data['state_id']:-1;
		$city_id = isset($this->data['city_id'])?$this->data['city_id']:-1;
	    $area_id = isset($this->data['area_id'])?$this->data['area_id']:-1;
	    $postal_code = isset($this->data['postal_code'])?$this->data['postal_code']:-1;	    
	    $current_page = isset($this->data['current_page'])?$this->data['current_page']:'';	  
	    
	    $where = "HAVING distance < a.delivery_distance_covered";
									    
	    if($search_mode!="location"){
	    	// SEARCH BY ADDRESS
			switch ($search_type) {
				case "byLatLong":				
				    if(isset($this->data['map_page'])){
				       if($this->data['map_page']==1){
				       	  $page_limit=1000;
				       }			    
				    }					    		
					$stmt="
					SELECT SQL_CALC_FOUND_ROWS 		
					$a						
					$query_distance
					$open_query
					FROM mt_view_merchant a 
					$where		
					$and
				 	$sort
					LIMIT $page,$page_limit
					";													
					break;
					
				case "featuredMerchant":				
					$stmt="
				    SELECT SQL_CALC_FOUND_ROWS 
					$a				
					$query_distance
					$open_query
					FROM mt_view_merchant a
					$where
					AND is_featured='2'				
					$and
					$sort
					LIMIT $page,$page_limit
				   ";			   			      
				   break;
			
				case "allMerchant":  
							  			  			  
				  $stmt="
				    SELECT SQL_CALC_FOUND_ROWS 
					$a				
					$query_distance
				    $open_query
					FROM mt_view_merchant a
					$where				
					$and
					$sort
					LIMIT $page,$page_limit
				   ";			  			  			 
				   break;
	
				case "special_Offers":
																   
				   $stmt="
				    SELECT SQL_CALC_FOUND_ROWS 
					$a				
	                $query_distance		
	                $open_query			
					FROM mt_view_merchant a
					$where				
					AND 
					(				
					   merchant_id IN (
						    SELECT merchant_id FROM
							mt_offers
							WHERE
							status in ('publish','published')
							AND
							now() >= valid_from and now() <= valid_to
							AND merchant_id = a.merchant_id					
						)					
						OR					
						merchant_id IN (
						    SELECT merchant_id FROM
							mt_voucher_new
							WHERE
							status in ('publish','published')													
							AND merchant_id = a.merchant_id			
							AND now() <= expiration
						)									
					)
					$and			    
					$sort
					LIMIT $page,$page_limit
				   ";				   
				   break;
				   
				case "byCuisine":   
				    $cuisine_id = isset($this->data['cuisine_id'])?$this->data['cuisine_id']:'-1'; 
				    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    $a					
    $query_distance			
    $open_query					
    FROM mt_view_merchant a
    $where									
    AND a.cuisine LIKE '%" . $cuisine_id . "%' 
    $and
    $sort
    LIMIT $page, $page_limit
";		    
				break;
				
				case "favorites":
							
					$client_id ='';
					if($res_customer = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
						$client_id = $res_customer['client_id'];		
					}
					
					$and .= "
    AND a.merchant_id IN (
        SELECT merchant_id FROM mt_favorites 
        WHERE merchant_id = a.merchant_id
        AND client_id = $client_id
    )
";
		
						
					$stmt="
				    SELECT SQL_CALC_FOUND_ROWS 
					$a				
					$query_distance
					$open_query
					FROM mt_view_merchant a
					$where						
					$and
					$sort
					LIMIT $page,$page_limit
				   ";							
					break;
					
				case "ByTag":				
				    try {
				    	$banner_id = isset($this->data['banner_id'])?$this->data['banner_id']:0;
				    	$resp_banner = $this->mobileWrapper->getBannerByID($banner_id);
				    	$tag_id = !empty($resp_banner['tag_id'])?json_decode($resp_banner['tag_id'],true):'';
				    	if(is_array($tag_id) && count($tag_id)>=1){
				    		//
				    	} else $tag_id = array(-1);
				    	
				    	$and.=" AND a.merchant_id IN (
			    		  select merchant_id from mt_option
			    		  where merchant_id = a.merchant_id
			    		  and option_name='tags' 
			    		  and option_value IN (".implode(",",$tag_id).")
			    		)";		    
				    } catch (Exception $e) {
				    	//echo $e->getMessage();				    	
				    }
					$stmt="
				    SELECT SQL_CALC_FOUND_ROWS 
					$a				
					$query_distance
					$open_query
					FROM mt_view_merchant a
					$where						
					$and					
					$sort
					LIMIT $page,$page_limit
				    ";								
					break;
				
				default:			
					break;
			}	
	    } else {
	    	// SEARCH BY LOCATION QUERY	    	
	    	
            $and_location.= $this->LocationWrapper->queryLocation((integer)$location_mode,array(
			  'state_id'=>$state_id,
			  'city_id'=>$city_id,
			  'area_id'=>$area_id,
			  'postal_code'=>$postal_code,
			));
			
			switch ( (integer) $location_mode) {
				case 1:
					$and_location_fee = "
    AND city_id = $city_id
    AND area_id = $area_id
";
 					
				break;
				
				case 2:
					$and_location_fee ="
					  and state_id=$state_id
					  and city_id=$city_id
					";
					break;
				case 3:					
				    $and_location_fee ="
					  and city_id=$city_id
					  and postal_code=$postal_code
					";
				    break;
				break;
			}
									
			if($search_type == "featuredMerchant"){
				$and.="AND is_featured='2'";
				
			} elseif ( $search_type == "special_Offers"){
				$and.=" 
				AND 
				(				
				   merchant_id IN (
					    SELECT merchant_id FROM
						mt_offers
						WHERE
						status in ('publish','published')
						AND
						now() >= valid_from and now() <= valid_to
						AND merchant_id = a.merchant_id					
					)					
					OR					
					merchant_id IN (
					    SELECT merchant_id FROM
						mt_voucher_new
						WHERE
						status in ('publish','published')													
						AND merchant_id = a.merchant_id			
						AND now() <= expiration
					)									
				)
				";
			} elseif ( $search_type == "favorites"){
				
				$client_id ='';
				$user_token = isset($this->data['user_token'])?$this->data['user_token']:'';
				if($res_customer = $this->mobileWrapper->getCustomerByToken($user_token)){
					$client_id = $res_customer['client_id'];
				} else $client_id=-1;			
				$and.="
				AND a.merchant_id IN (
				   select merchant_id from mt_favorites 
				   where
				   merchant_id = a.merchant_id
				   and
				   client_id=$client_id
				)
				";		
			} elseif ( $search_type == "byCuisine"){
				$cuisine_id = isset($this->data['cuisine_id'])?$this->data['cuisine_id']:'-1'; 
				
				
					$and .= "
    AND a.merchant_id IN (
        SELECT merchant_id FROM mt_cuisine_merchant
        WHERE merchant_id = a.merchant_id
        AND cuisine_id IN ($cuisine_id)
    )
";

				
			} elseif ( $search_type == "ByTag") {
				 try {
			    	$banner_id = isset($this->data['banner_id'])?$this->data['banner_id']:0;
			    	$resp_banner = $this->mobileWrapper->getBannerByID($banner_id);
			    	$tag_id = !empty($resp_banner['tag_id'])?json_decode($resp_banner['tag_id'],true):'';
			    	if(is_array($tag_id) && count($tag_id)>=1){				    		
			    	} else {
			    		$tag_id = array(-1);
			    	}	
			    	
			    	$and.=" AND a.merchant_id IN (
		    		  select merchant_id from mt_option
		    		  where merchant_id = a.merchant_id
		    		  and option_name='tags' 
		    		  and option_value IN (".implode(",",$tag_id).")
		    		)";
			    			    
			    } catch (Exception $e) {
			    	//echo $e->getMessage();
			    }				 
			}
	    		    		   	    
	    	$stmt="
			  SELECT SQL_CALC_FOUND_ROWS a.*,
			  $a	          
	          (
	           select fee
	           from mt_view_location_rate
	           where merchant_id = a.merchant_id
	           $and_location_fee
	           limit 0,1
	          ) as location_fee
	          $open_query
	          
	          FROM mt_view_merchant a
			  WHERE 1			   
			  $and_location	          
	          $and
			  $sort
	          LIMIT $page,$page_limit
			";					    	
	    }	
		
		$page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';
		$paginate_total = 0;
		
		$search_options = $this->mobileWrapper->getDataSearchOptions();		
		
		if(isset($_GET['debug'])){
			//dump($stmt);
		}	
			
		if(!empty($stmt)){
			if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

					
				//dump($res);die();
				
				$total_records=0;
				$stmtc = "SELECT FOUND_ROWS() as total_records";  
if ($resp = $this->db->query($stmtc)->fetch(PDO::FETCH_ASSOC)) {  
    $total_records = $resp['total_records'];  
}
		
		 		
				$this->code = 1;				
							
				switch ($search_type) {
					case "allMerchant":
					case "byCuisine":
						

						$this->msg = $this->functions->translation("default",$total_records." Restaurant Found");

						break;
						
					case "featuredMerchant":	
					  

					   $this->msg = $this->functions->translation("default",$total_records." Featured Restaurant");

					break;
					
					case "special_Offers":	
					  

					   $this->msg = $this->functions->translation("default",$total_records." Special Offers");

					break;
				
					case "favorites":
						
						$this->msg = $this->functions->translation("default",$total_records." Favorites");					
						break;
					
					default:
						
						$this->msg = $this->functions->translation("default",$total_records." Nearby Restaurant");	

						break;
				}
								
				$paginate_total = ceil( $total_records / $page_limit );
				
				$data = array();
				
				$res = $res;
								
				foreach ($res as $val) {
					$merchant_id = $val['merchant_id'];					
					$distance = 0;
					$unit = isset($val['distance_unit'])?$val['distance_unit']:'';
					$unit2 = $this->mobileWrapper->standardUnit($unit);

					$pretty_unit = $this->MapsWrapperTemp->prettyUnit($unit);
										
					if(in_array('open_tag',(array)$search_options)){
						$status = $this->mobileWrapper->merchantStatus($merchant_id);
						$val['open_status_raw']=$status;
						$val['open_status']=($status);
					}
					$val['background_url'] = $this->mobileWrapper->getMerchantBackground($merchant_id);
					$val['logo']=$this->mobileWrapper->getImage($val['logo']);
										
					if(in_array('cuisine',(array)$search_options) && $view_cuisine_merchant ){						   
					   $val['cuisine'] = $this->mobileWrapper->displayCuisine($merchant_id,$multipleField);
					} else unset($val['cuisine']);
					
					if(in_array('review',(array)$search_options)){
						$ratings = $this->functions->getRatings($merchant_id);
						

						$ratings['review_count'] =$this->functions->translation("default",$ratings['votes']." reviews");

						$val['rating']=$ratings;
					}
					
					if($val['is_sponsored']==2){
						$val['sponsored'] =  "Sponsored";
					}
					
					if(in_array('delivery_estimation',(array)$search_options)){
						if(!empty($val['delivery_estimation'])){
							

						    $val['delivery_estimation'] =  "Delivery Est: ".$val['delivery_estimation'];

						}
					} else $val['delivery_estimation']='';
					
					if($search_mode=="address"){
						if(in_array('delivery_distance',(array)$search_options)){
							if($val['delivery_distance_covered']>0){
								

								$val['delivery_distance'] =  "Delivery Distance: ".$val['delivery_distance_covered']." $pretty_unit";

							}						
						}
					}
					
					
					if(in_array('offers',(array)$search_options)){
						$offers=array();
						
							if ($offer=$this->mobileWrapper->getOffersByMerchantNew($merchant_id)){
								foreach ($offer as $offer_val) {
									$offers[]=$offer_val;
								}			    				
							}			    		
							
						$free_delivery_above=$this->functions->getOption('free_delivery_above_price',$merchant_id);
						if($free_delivery_above>0.001){
						   

						   $free_above = "Free Delivery On Orders Over ".$free_delivery_above;

						   

						   $offers[] = array(
							 'raw'=>"Free ".$this->functions->prettyPrice($free_delivery_above),
							 'full'=>$free_above
						   );

						}			    	
						$val['offers']=$offers;	    	
					}
					
					if(in_array('voucher',(array)$search_options)){
						$vouchers = array();
						
							if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){
								foreach ($voucher as $voucher_val) {
									if ( $voucher_val['voucher_type']=="fixed amount"){
										$v_amount=$this->functions->prettyPrice($voucher_val['amount']);
									} else $v_amount=number_format( ($voucher_val['amount']/100)*100 )."%";
									
									

									$vouchers[] =$v_amount." off | Use coupon ".$voucher_val['voucher_name'];

								}			    				
								$val['vouchers']=$vouchers;	 
							}
						
					}
					
					if(in_array('services',(array)$search_options)){
						$services_list = array();
						if($services = $this->mobileWrapper->getMerchantServicesList($val['service'])){
							foreach ($services as $services_val) {
								$services_list[]=$services_val;
							}
							$val['services']=$services_list;
						}			    	
					}

					
					if(in_array('payment_option',(array)$search_options)){
						$paymet_method_list=array();
						if($paymet_method = $this->functions->getMerchantPaymentListNew($merchant_id)){			    			
							if(array_key_exists('cod',$paymet_method)){
								$paymet_method_list[]=$this->mobileWrapper->getImage("icon-cod.png","icon-cod.png");
							}			
							if(array_key_exists('obd',$paymet_method)){
								$paymet_method_list[]=$this->mobileWrapper->getImage("icon-obd.png","icon-obd.png");
							}			    		
							if(array_key_exists('ocr',$paymet_method)){
								$paymet_method_list[]=$this->mobileWrapper->getImage("icon-ocr.png","icon-ocr.png");
							}						    			
							$val['paymet_method_icon']=$paymet_method_list;
						}			    	
					}					

					if(!in_array('address',(array)$search_options)){
						$val['address']='';
					}
						
										
					if($search_type=="allMerchant" && $current_page=="tabbar" && $home_all_as_list==1){				   
											
						if(in_array('minimum_order',(array)$search_options)){
						  

						  $val['minimum_order'] ="Minimum Order: ".$this->functions->prettyPrice($val['minimum_order_raw']);

					    }
						  
					} else {
					
					if($current_page!="tabbar"):					
					if($search_mode=="address"){	
						/*GET DISTANCE*/													
						try {							
							$params = array(
							  'merchant_id'=>$merchant_id,
							  'provider'=>$provider,
							  'from_lat'=>$val['latitude'],
							  'from_lng'=>$val['lontitude'],
							  'to_lat'=>$lat,
							  'to_lng'=>$lng,
							  'delivery_charges'=>$val['delivery_charges'],
							  'unit'=>$unit,
							  'delivery_distance_covered'=>$val['delivery_distance_covered'],
							  'order_subtotal'=>0,
							  'minimum_order'=>$val['minimum_order_raw']
							);			
																										
							$resp_distance = $this->CheckoutWrapperTemp->getDeliveryDetails($params);							
															
							$distance = $resp_distance['distance'];			
											
							if(in_array('distace',(array)$search_options)){
								

					 			$val['distance_plot'] = "Distance :".$resp_distance['pretty_distance'];


							}
							
				 			if(in_array('minimum_order',(array)$search_options)){
					 			$val['minimum_order_raw']=$resp_distance['min_order'];

					 			

								$val['minimum_order'] = "Minimum Order:".$resp_distance['min_order'];

				 			} else {
				 			    unset($val['minimum_order']);
                                unset($val['minimum_order_raw']);
				 			}							
							
				 			if(in_array('delivery_fee',(array)$search_options)){
								if($resp_distance['delivery_fee']>0){
									

				                	$val['delivery_fee'] = "Delivery Fee: ".$this->functions->prettyPrice($resp_distance['delivery_fee']);

								}			
				 			}				
				 			
						} catch (Exception $e) {			 							
 							

 							$val['distance_plot'] = "Distance :".$e->getMessage();

 						}						
					} else {
						  //dump("SEARCH BY LOCATIONx");		
						  if(in_array('minimum_order',(array)$search_options)){
							  	

							   $val['minimum_order'] ="Minimum Order: ".$this->functions->prettyPrice($val['minimum_order_raw']) ;

						  }
						  if(in_array('delivery_fee',(array)$search_options)){
							 

			                  $val['delivery_fee'] ="Delivery Fee:".$this->functions->prettyPrice($val['location_fee']) ;

						  }
					}				
					endif; 
					/* END IF TABBAR*/
					
					} /* END IF CONDITION OF HOME ALL LIST*/
										
					$data[]=$val;
				}
				
				//die();
								 			 	
				$this->details = array(				  
				  'search_type'=>$search_type,
				  'total_records'=>$total_records,		
				  'sortby_selected'=>$sortby_selected,
				  'page_action'=>$page_action,
				  'paginate_total'=>$paginate_total,
				  'map_page'=>isset($this->data['map_page'])?$this->data['map_page']:'',
				  'refresh_home'=>isset($this->data['refresh_home'])?$this->data['refresh_home']:'',
				  'list'=>$data,
				);
			} else {
				if($search_type=="byLatLong"){
					$this->msg = "0 restaurant found";
				} else $this->msg = "No results";
				
				$this->details = array(
				  'search_type'=>$search_type,
				  'sortby_selected'=>$sortby_selected,
				  'page_action'=>$page_action,
				  'paginate_total'=>$paginate_total,
				  'refresh_home'=>isset($this->data['refresh_home'])?$this->data['refresh_home']:''
				);
			}
		} else {
		     $this->msg = "invalid query";
		     $this->details = array(
				 'search_type'=>$search_type,
				 'sortby_selected'=>$sortby_selected,
				 'page_action'=>$page_action,
				 'paginate_total'=>$paginate_total,
				 'refresh_home'=>isset($this->data['refresh_home'])?$this->data['refresh_home']:''
			);
		}
		$this->output();
	}


	public function customerLogin()
	{		
		$this->details = array();
		$user_mobile = isset($this->data['user_mobile'])?trim($this->data['user_mobile']):'';
		$password = isset($this->data['password'])?trim($this->data['password']):'';
		if(!empty($user_mobile) && !empty($password)){
							
    	    $res=array();

    	    if ($res = $this->mobileWrapper->loginByEmail($user_mobile,$password,0)){    	    	    	    	
    	    } else {
    	    	$res = $this->mobileWrapper->loginByMobile($user_mobile,$password,0);    	    	    	    	
    	    }
    	    
    	    if(is_array($res) && count($res)>=1){
    	    	
    	    	if ( $this->functions->emailBlockedCheck($res['email_address'])){
	    		   $this->msg = "sorry but your email address is blocked by website admin";
	    		   $this->output();
	    	    }	


	    	    
	    	    if ( $this->functions->mobileBlockedCheck($res['contact_phone'])){
	    		   $this->msg = "Sorry but your mobile number is blocked by website admin";
	    		   $this->output();
	    	    }	  

    	    		    	    
    	    	$client_info = array(
    	    	  'token'=>$res['token'],
    	    	  'first_name'=>$res['first_name'],
    	    	  'last_name'=>$res['last_name'],
    	    	  'email_address'=>$res['email_address'],
    	    	  'status'=>$res['status'],
    	    	  'avatar'=>$res['avatar'],
    	    	  'contact_phone'=>$res['contact_phone']
    	    	);
    	    	
    	    	switch ($res['status']) {
    	    		case "active":
    	    			$this->code = 1;
    	    			$this->msg = "OK";
    	    			$this->details['client_info']=$client_info;
    	    			
    	    			/*REGISTERED DEVICE*/
						if(is_array($res) && count((array)$res)>=1){
							$this->data['client_id'] = $res['client_id'];							
						}	

						$this->mobileWrapper->registeredDevice($this->data);

    	    			break;
    	    	
    	    		case "pending":    	    			
    	    			$this->msg = "Your account is not active";    
    	    				    			    	    		    	    			
    	    			if (strlen($res['mobile_verification_code'])>=2){
    	    				$this->details['next_step'] = 'verification_mobile';
    	    		    } elseif (strlen($res['email_verification_code'])>=2 ){	 	    	
    	    		    	$this->details['next_step'] = 'verification_email';
    	    		    }
    	    			
				    	if(isset($this->details['next_step'])){
				    		$this->details['contact_phone']=$res['contact_phone'];
				    		$this->details['customer_token']=$res['token'];
				    		$this->details['email_address']=$res['email_address'];
				    	}
				    					    					    					    
    	    		    break;
    	    		    
    	    		default:
    	    			

    	    			$this->msg = "login failed. your account status is ".$res['status'];

    	    			break;
    	    	}
    	    } else $this->msg = "login failed. either username or password is incorrect";
    	    
		} else $this->msg = "either username or password is empty";
		$this->output();
	}		


	public function cuisineList_bkedup()
{		
    $search_resp = $this->mobileWrapper->searchMode();
    $search_mode = $search_resp['search_mode'];
    $location_mode = $search_resp['location_mode'];		

    $page_limit = $this->mobileWrapper->paginateLimit();
    $page = isset($this->data['page']) ? $this->data['page'] * $page_limit : 0;  

    $sort_by = isset($this->data['sort_by']) ? $this->data['sort_by'] : 'ASC';		
    $sort_by = $this->mobileWrapper->validateSort($sort_by);

    $sort_fields = isset($this->data['sort_fields']) ? $this->data['sort_fields'] : 'sequence';
    $sort_resp = $this->mobileWrapper->prettySortCuisine($sort_fields);
    $sortby_selected = $sort_resp['name'];
    $sort_fields = $sort_resp['key'];    

    $lat = isset($this->data['lat']) ? $this->data['lat'] : '';
    $lng = isset($this->data['lng']) ? $this->data['lng'] : '';	

    $unit = $this->functions->getOptionAdmin('home_search_unit_type');
    $distance_exp = ($unit == "km") ? 6371 : 3959;

    $query_distance = "
        ( $distance_exp * acos( cos( radians(:lat) ) * cos( radians( latitude ) ) 
            * cos( radians( lontitude ) - radians(:lng) ) 
            + sin( radians(:lat) ) * sin( radians( latitude ) ) ) ) 
        AS distance";

    $and = '';		
    $cuisine_name = '';
    if (isset($this->data['cuisine_name'])) {
        $cuisine_name = trim($this->data['cuisine_name']);
        $and .= " AND cuisine_name LIKE :cuisine_name";
    }

    $lists = array();
    $total_records = 0;
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.cuisine_id, a.cuisine_name, a.featured_image, a.cuisine_name_trans
        FROM mt_cuisine a                    
        WHERE a.status = 'publish' 
        $and
        ORDER BY $sort_fields $sort_by		
        LIMIT :page , :page_limit
    ";  

    try {
        $query = $this->db->prepare($stmt);
        if (!empty($cuisine_name)) {
            $query->bindValue(':cuisine_name', "%$cuisine_name%", PDO::PARAM_STR);
        }
        $query->bindValue(':page', (int) $page, PDO::PARAM_INT);
        $query->bindValue(':page_limit', (int) $page_limit, PDO::PARAM_INT);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $query_total = $this->db->query("SELECT FOUND_ROWS() as total_records");
            $total_records = $query_total->fetch(PDO::FETCH_ASSOC)['total_records'];

            foreach ($res as $val) {
                if ($search_mode == "location") {        			
                    $total = $this->mobileWrapper->getTotalCuisineByLocation(
                        $val['cuisine_id'],
                        $location_mode,
                        [
                            'state_id' => isset($this->data['state_id']) ? $this->data['state_id'] : -1,
                            'city_id' => isset($this->data['city_id']) ? $this->data['city_id'] : -1,
                            'area_id' => isset($this->data['area_id']) ? $this->data['area_id'] : -1,
                            'postal_code' => isset($this->data['postal_code']) ? $this->data['postal_code'] : -1,
                        ]
                    );
                } else {
                    $total = $this->mobileWrapper->getTotalCuisine($val['cuisine_id'], $query_distance);
                }

                $cuisine_json = !empty($val['cuisine_name_trans']) 
                    ? json_decode($val['cuisine_name_trans'], true) 
                    : '';

                $cuisine_name_trans = $this->functions->qTranslate($val['cuisine_name'], 'cuisine_name', $cuisine_json);
                $cuisine_name_trans = $this->mobileWrapper->highlight_word($cuisine_name_trans, $cuisine_name);

                $lists[] = [
                    'id' => $val['cuisine_id'],
                    'name' => $cuisine_name_trans,
                    'featured_image' => $this->mobileWrapper->getImage($val['featured_image'], 'default_cuisine.png'),
                    'total_merchant' => $total . " restaurant"
                ];
            }

            $this->msg = "$total_records cuisine found";
            $paginate_total = ceil($total_records / $page_limit);
            $this->code = 1; 
            $this->details = [
                'total' => $total_records,
                'sortby_selected' => $sortby_selected,
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'list' => $lists
            ];
        } else {
            $this->code = 1; 
            $this->msg = "No results";
            $this->details = [
                'total' => $total_records,
                'sortby_selected' => $sortby_selected,
                'page_action' => $page_action,
                'paginate_total' => 0,
                'list' => ''
            ];
        }
    } catch (PDOException $e) {
        $this->code = 0;
        $this->msg = "Database error: " . $e->getMessage();
    }

    $this->output();   
}


	public function cuisineList()
{        
    $search_resp = $this->mobileWrapper->searchMode();
    $search_mode = $search_resp['search_mode'];
    $location_mode = $search_resp['location_mode'];        
    
    $page_limit = $this->mobileWrapper->paginateLimit();
    $page = isset($this->data['page']) ? $this->data['page'] * $page_limit : 0;
    
    $sort_by = isset($this->data['sort_by']) ? $this->data['sort_by'] : 'ASC';
    $sort_by = $this->mobileWrapper->validateSort($sort_by);
    
    $sort_fields = isset($this->data['sort_fields']) ? $this->data['sort_fields'] : 'sequence';
    $sort_resp = $this->mobileWrapper->prettySortCuisine($sort_fields);
    $sortby_selected = $sort_resp['name'];
    $sort_fields = $sort_resp['key'];    
    
    $lat = isset($this->data['lat']) ? $this->data['lat'] : '';
    $lng = isset($this->data['lng']) ? $this->data['lng'] : '';    
    
    $unit = $this->functions->getOptionAdmin('home_search_unit_type');
    $distance_exp = ($unit == "km") ? 6371 : 3959;
    
    $query_distance = "
    ( $distance_exp * acos( cos( radians($lat) ) * cos( radians( latitude ) ) 
        * cos( radians( lontitude ) - radians($lng) ) 
        + sin( radians($lat) ) * sin( radians( latitude ) ) ) )";

    
    $and = '';        
    $cuisine_name = '';
    if (isset($this->data['cuisine_name'])) {
        $cuisine_name = trim($this->data['cuisine_name']);
        $and .= " AND cuisine_name LIKE '%$cuisine_name%'";
    }
    
    $lists = array();
    $total_records = 0;
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.cuisine_id, a.cuisine_name, a.featured_image, a.cuisine_name_trans
    FROM mt_cuisine a                    
    WHERE a.status = 'publish' 
    $and
    ORDER BY $sort_fields $sort_by        
    LIMIT $page, $page_limit
    ";    

    $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = $this->db->query("SELECT FOUND_ROWS() AS total_records")->fetch(PDO::FETCH_ASSOC)['total_records'];
        
        foreach ($res as $val) {
            if ($search_mode == "location") {                    
                $total = $this->mobileWrapper->getTotalCuisineByLocation($val['cuisine_id'], $location_mode, array(
                    'state_id' => isset($this->data['state_id']) ? $this->data['state_id'] : -1,
                    'city_id' => isset($this->data['city_id']) ? $this->data['city_id'] : -1,
                    'area_id' => isset($this->data['area_id']) ? $this->data['area_id'] : -1,
                    'postal_code' => isset($this->data['postal_code']) ? $this->data['postal_code'] : -1,
                ));                    
            } else {
                $total = $this->mobileWrapper->getTotalCuisine($val['cuisine_id'], $query_distance);
            }
            
            $cuisine_json = !empty($val['cuisine_name_trans']) ? json_decode($val['cuisine_name_trans'], true) : '';
            $cuisine_name_trans = $this->functions->qTranslate($val['cuisine_name'], 'cuisine_name', $cuisine_json);
            $cuisine_name_trans = $this->mobileWrapper->highlight_word($cuisine_name_trans, $cuisine_name);
            
            $lists[] = array(
                'id' => $val['cuisine_id'],
                'name' => $cuisine_name_trans,
                'featured_image' => $this->mobileWrapper->getImage($val['featured_image'], 'default_cuisine.png'),
                'total_merchant' => $total . " restaurant"
            );
        }
        
        $this->msg = $total_records . " found";
        $paginate_total = ceil($total_records / $page_limit);
        
        $this->code = 1; 
        $this->details = array(
            'total' => $total_records,
            'sortby_selected' => $sortby_selected,
            'page_action' => $page_action,
            'paginate_total' => $paginate_total,
            'list' => $lists
        );
    } else {
        $this->code = 1; 
        $this->msg = "No results";
        $this->details = array(
            'total' => $total_records,
            'sortby_selected' => $sortby_selected,
            'page_action' => $page_action,
            'paginate_total' => 0,
            'list' => ''
        );
    }     
    $this->output();
}




public function searchByMerchantName()
{
    $search_resp = $this->mobileWrapper->searchMode();
    $search_mode = $search_resp['search_mode'];
    $location_mode = $search_resp['location_mode'];

    $merchant_name = isset($this->data['merchant_name']) ? $this->data['merchant_name'] : '';
    if (!empty($merchant_name)) {

        if ($search_mode == "location") {
            $state_id = isset($this->data['state_id']) ? (integer)$this->data['state_id'] : 0;
            $city_id = isset($this->data['city_id']) ? (integer)$this->data['city_id'] : 0;
            $area_id = isset($this->data['area_id']) ? (integer)$this->data['area_id'] : 0;
            $postal_code = isset($this->data['postal_code']) ? (integer)$this->data['postal_code'] : 0;

            $and_location = '';
            $and_location .= $this->LocationWrapper->queryLocation((integer)$location_mode, [
                'state_id' => $state_id,
                'city_id' => $city_id,
                'area_id' => $area_id,
                'postal_code' => $postal_code,
            ]);

            $stmt = "
            SELECT 
                merchant_id,
                restaurant_name,
                cuisine, logo,
                CONCAT(street, ' ', city, ' ', state) AS address,
                country_code,
                delivery_distance_covered,
                status, is_ready                
            FROM mt_merchant a            
            WHERE restaurant_name LIKE :merchant_name
            AND status = 'active'
            AND is_ready = '2'
            $and_location
            LIMIT 0,10
            ";

            $params = [':merchant_name' => "%$merchant_name%"];
        } else {
            $lat = isset($this->data['lat']) ? $this->data['lat'] : '';
            $lng = isset($this->data['lng']) ? $this->data['lng'] : '';

            $home_search_unit_type = $this->functions->getOptionAdmin('home_search_unit_type');
            $distance_exp = ($home_search_unit_type == "km") ? 6371 : 3959;

            $query_distance = "
            ( $distance_exp * ACOS( COS( RADIANS(:lat) ) * COS( RADIANS( latitude ) ) 
                * COS( RADIANS( lontitude  ) - RADIANS(:lng) ) 
                + SIN( RADIANS(:lat) ) * SIN( RADIANS( latitude ) ) ) ) 
                AS distance
            ";

            $stmt = "
            SELECT 
                merchant_id,
                restaurant_name,
                cuisine, logo,
                CONCAT(street, ' ', city, ' ', state) AS address,
                country_code,
                delivery_distance_covered,
                status, is_ready,
                $query_distance
            FROM mt_merchant            
            HAVING distance < delivery_distance_covered
            AND restaurant_name LIKE :merchant_name
            AND status = 'active'
            AND is_ready = '2'
            LIMIT 0,10
            ";

            $params = [
                ':lat' => $lat,
                ':lng' => $lng,
                ':merchant_name' => "%$merchant_name%"
            ];
        }

        $query = $this->db->prepare($stmt);
        $query->execute($params);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $data = [];
            foreach ($res as $val) {
                $merchant_id = $val['merchant_id'];

                $val['restaurant_name'] = $this->mobileWrapper->highlight_word($this->functions->clearString($val['restaurant_name']), $merchant_name);
                $val['cuisine'] = $this->functions->displayCuisine($val['cuisine']);
                $val['rating'] = $this->functions->getRatings($merchant_id);
                $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                $val['address'] = $val['address'] . " " . $this->functions->countryCodeToFull($val['country_code']);
                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = ['list' => $data];
        } else {
            $this->msg = "No results";
        }
    } else {
        $this->msg = "Merchant name is empty";
    }
    $this->output();
}

public function searchByCuisine()
	{
		$this->cuisineList();
	}


		public function getRestaurantInfo()
	{
		
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';		
		$client_id = $this->checkToken();
		
		$this->setMerchantTimezone();
		
		if($merchant_id>0){
			
			$show_delivery_fee = false;
			$options = $this->mobileWrapper->getDataSearchOptions();						
			if(in_array('delivery_fee',$options)){
				$show_delivery_fee = false;
			}		
			
			$lat = isset($this->data['lat'])?$this->data['lat']:'';
			$lng = isset($this->data['lng'])?$this->data['lng']:'';	
			
			if ($res = $this->functions->getMerchantInfo_mobileapp($merchant_id)){
										
				$this->code = 1;
				$this->msg="ok";
				
				$data['merchant_id']=$res['merchant_id'];
				$data['restaurant_name']=$this->functions->clearString($res['restaurant_name']);
				$data['complete_address']=$this->functions->clearString($res['complete_address']);
				
				$data['latitude']=$res['latitude'];
				$data['lontitude']=$res['lontitude'];
				
				$data['cuisine']=$this->functions->displayCuisine($res['cuisine']);
				$data['logo']=$this->mobileWrapper->getImage($res['logo']);
				$data['background_url'] = $this->mobileWrapper->getMerchantBackground($merchant_id);
				
                $status = $this->mobileWrapper->merchantStatus($merchant_id);
                
                $data['close_message']='';
		 		if($status=="close"){		 			
		 			$date_close= $this->functions->prettyDate(date('c'))." ".$this->functions->prettyTime(date('c'));
		 			

		 			$data['close_message']="Sorry but we are closed on ".$date_close." Please check merchant opening hours.";



		 		}
                
		 		$data['status_raw']=$status;
		 		$data['status']=($status);	
		 				 		
		 		
		 		$data['gallery']=2;
		 		$enabled_menu_carousel = $this->functions->getOptionAdmin('mobile2_enabled_menu_carousel');		 		
		 		$banner_enabled = $this->functions->getOption('banner_enabled',$merchant_id);		 		
		 		if($enabled_menu_carousel==1 && $banner_enabled==1){		 			
		 		    $data['gallery']=$this->mobileWrapper->getMerchantBanner($merchant_id);
		 		    
		 		}		 		
		 						
				$ratings=$this->functions->getRatings($merchant_id); 	
				$data['rating']=$ratings;				
				

	 			$ratings['review_count'] =$ratings['votes']." reviews"; 

	 			$data['rating']=$ratings;
	 				 			
	 			$data['added_as_favorite'] = $this->mobileWrapper->getFavorites($client_id, $merchant_id);
	 							
				if($offers=$this->mobileWrapper->getOffersByMerchantNew($merchant_id)){
	 				$data['offers']=$offers;
	 			}
	 			
		    	if($res['is_sponsored']==2){
		    		$data['sponsored'] =  "Sponsored";
		    	}
		    			    	
		    	//dump($ratings);
		    	$data['tab_menu_enabled']=1;
		    	$data['tab_menu']=$this->mobileWrapper->getRestoTabMenu($merchant_id , $ratings);		
		    	
		    	

		    	$data['share_options']=array(
		    	  'message'=>"Find this restaurant on ".$this->functions->getOptionAdmin('website_title')."|".$res['restaurant_name'],
		    	  'url'=>$this->functions->websiteUrl()."/store/menu/slug/".$res['restaurant_slug'],
		    	  'subject'=>$res['restaurant_name'],
		    	  'files'=>''
		    	);

		    	
		    	
		    	$data['delivery_fee'] = '';
				if($show_delivery_fee){
					try {						
						$provider = $this->mobileWrapper->getMapProvider();											
						$params_fee =  array(
						  'merchant_id'=>$res['merchant_id'],
						  'provider'=>$provider,
						  'from_lat'=>isset($res['latitude'])?$res['latitude']:0,
						  'from_lng'=>isset($res['lontitude'])?$res['lontitude']:0,
						  'to_lat'=>$lat,
						  'to_lng'=>$lng,
						  'delivery_charges'=>isset($res['delivery_charges'])?$res['delivery_charges']:0,
						  'unit'=>isset($res['distance_unit'])?$res['distance_unit']:'',
						  'delivery_distance_covered'=>isset($res['delivery_distance_covered'])?$res['delivery_distance_covered']:'',
						  'order_subtotal'=>0,
						  'minimum_order'=>isset($res['minimum_order'])?$res['minimum_order']:0
						);						
						$resp_fee = $this->CheckoutWrapperTemp->getDeliveryDetails($params_fee);
						

						$data['delivery_fee'] ="Delivery charges: ".$this->functions->prettyPrice($resp_fee['delivery_fee']);


									
					} catch (Exception $e) {							
			        }    							        
				}			
								
		    	$settings = array();		    		    	
				
				$this->details = array(
				 'data'=>$data,				 
				);
			} else $this->msg = "merchant id not found";
		} else $this->msg = "invalid merchant id";
		$this->output();
	}


	public function getMerchantMenu()
	{		
		$page_limit = $this->mobileWrapper->paginateLimit();
		
		$this->setMerchantTimezone();
		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';
        
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
		
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        $cart_data = array();
        
        $mobile2_cart_with_qty = $this->functions->getOptionAdmin('mobile2_cart_with_qty');        
        if($mobile2_cart_with_qty==1){
	        if($cartdata=$this->mobileWrapper->getCart($device_uiid)){
	        	$cart_data = json_decode($cartdata['cart'],true);
	        }
        }
                
		if($merchant_id>0){
					
			if($menu = $this->itemWrapper->getMenu($merchant_id, $page, $page_limit , $cart_data)){								
				$this->code = 1;
				$this->msg = "OK";
				$menu['item_id']=isset($this->data['item_id'])?$this->data['item_id']:'';
				$menu['cat_id']=isset($this->data['cat_id'])?$this->data['cat_id']:'';
				$menu['page_action']=$page_action;
				$this->details = $menu;
				
				$food_viewing_private = $this->functions->getOption('food_viewing_private',$merchant_id);
				if($food_viewing_private==2){
					$this->code = 2;
					$this->msg = "This restaurant has not published their menu yet";
					$this->details = array();
				}
				
			} else $this->msg = "This restaurant has not published their menu yet";
			
		} else $this->msg = "invalid merchant id";
		$this->output();
	}


	public function getItemByCategory()
	{		
		$enabled_trans=$this->functions->getOptionAdmin('enabled_multiple_translation');
		
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
		
		$cat_id = isset($this->data['cat_id'])?$this->data['cat_id']:'';
		$page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
		
		
		
		$category = $this->itemWrapper->getCategoryByID($cat_id);
		if($enabled_trans==2){
		   $category_name['category_name_trans']=!empty($category['category_name_trans'])?json_decode($category['category_name_trans'],true):'';
           $category['category_name'] = $this->functions->qTranslate($category['category_name'],'category_name',$category_name);
		}

		$page_limit = $this->mobileWrapper->paginateLimit();		
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
		
        
        
        $filter_dishes=array();
        if(isset($this->data['filter_dishes'])){
        	$filter_dishes = $this->data['filter_dishes'];
        }	
        
        $device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        $cart_data = array();
        
        $mobile2_cart_with_qty = $this->functions->getOptionAdmin('mobile2_cart_with_qty');        
        if($mobile2_cart_with_qty==1){
	        if($cartdata=$this->mobileWrapper->getCart($device_uiid)){
	        	$cart_data = json_decode($cartdata['cart'],true);
	        }
        }
                
        if($merchant_id>0 && $cat_id>0 ){        	
			if($res = $this->itemWrapper->getItemByCategory($merchant_id,$cat_id,true,$page,$page_limit,$filter_dishes,$cart_data)){
								
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				 'page_action'=>$page_action,
				 'paginate_total'=>$res['paginate_total'],
				 'category'=>$category,
				 'category_list'=>$this->itemWrapper->getMerchantCategory($merchant_id),
				 'data'=>$res['data']
				);
			} else {
				$this->msg = "no item found on this category";
				$this->details = array(
				 'page_action'=>0,
				 'category'=>$category,		
				 'category_list'=>$this->itemWrapper->getMerchantCategory($merchant_id),	 
				);
			}
        } else $this->msg = "invalid merchant id or category id";
		$this->output();
	}

	public function searchFoodItem()
	{
		$item_name = isset($this->data['item_name'])?$this->data['item_name']:'';
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
				
		if($res = $this->itemWrapper->searchItemByName($merchant_id,$item_name)){
			$data = array();
			foreach ($res as $val) {
				$category = json_decode($val['category'],true);
				if(is_array($category) && count($category)>=1){
					$val['cat_id'] = $category[0];
				}
				$val['item_name'] = $this->mobileWrapper->highlight_word($val['item_name'],$item_name);
				$val['photo']=$this->mobileWrapper->getImage($val['photo']);
				$val['item_description']=strip_tags($val['item_description']);				
				$data[]=$val;
			}
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			 'data'=>$data
			);
		} else $this->msg = "No results";
		$this->output();
	}


	public function itemDetails()
	{		
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';		
		$item_id = isset($this->data['item_id'])?$this->data['item_id']:'';		
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';		
		
		if($merchant_id<0 || empty($merchant_id)){
			$this->msg = "invalid merchant id";
			$this->output();
		}
		if($item_id<0 || empty($item_id)){
			$this->msg = "invalid item id";
			$this->output();
		}
		
		$ordering_disabled=false; $ordering_msg='';
		$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
		if($disabled_website_ordering=="yes"){
			$ordering_msg = "Ordering is disabled by admin";
			$ordering_disabled=true;			
		}
		$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$merchant_id);
		if($merchant_disabled_ordering=="yes"){
			$ordering_msg = "Ordering is disabled by merchant";
			$ordering_disabled=true;
		}
		$merchant_close_store = $this->functions->getOption('merchant_close_store',$merchant_id);
		if($merchant_close_store=="yes"){
			$ordering_msg = "Merchant is now close and not accepting any orders";
			$ordering_disabled=true;
		}
		
		 $cart_data=array();		
		$trans=$this->functions->getOptionAdmin('enabled_multiple_translation'); 
				
		
		$restaurant_slug = '';
		$mobile2_food_share = $this->functions->getOptionAdmin('mobile2_food_share');
		if($mobile2_food_share==1){
			if ($merchant_info = $this->functions->getMerchantInfo_mobileapp($merchant_id)){
				$restaurant_slug = $merchant_info['restaurant_slug'];
			}		
		}
		
		if ($res=$this->functions->getItemById($this->data['item_id'])){
			
			
			
			$res = $res[0];
			unset($res['cooking_ref_trans']);			
			$res['cooking_ref'] = $this->itemWrapper->translateCookingRef($res['cooking_ref']);			
			$res['ingredients'] = $this->itemWrapper->translateIngredients($res['ingredients']);			
			
			/*TRANSLATE ADDON*/
			if($trans==2){
				$new_addon = array();
				if(is_array($res['addon_item']) && count($res['addon_item'])>=1){
					foreach ($res['addon_item'] as $add_val) {							
						$add_val['subcat_name']=$this->functions->qTranslate($add_val['subcat_name'],'subcat_name',$add_val);
																				
						if(is_array($add_val['sub_item']) && count($add_val['sub_item'])>=1){
							$new_sub_item = array();
							foreach ($add_val['sub_item'] as $sub_item_val) {
								$sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'],'sub_item_name',$sub_item_val);
								$sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'],'item_description',$sub_item_val);									
								$new_sub_item[]=$sub_item_val;
							}
							$add_val['sub_item']=$new_sub_item;
						}													
													
						$new_addon[]=$add_val;
					}
					
					$res['addon_item']=$new_addon;
				}				
			}								
			/*END TRANSLATE ADDON*/
			
			if($res['not_available']==2){				
			   $ordering_msg = "Sorry but this item is not available";
			   $ordering_disabled=true;
			}
			
			$res['item_name']=$this->functions->qTranslate($res['item_name'],'item_name',$res);        	
			$res['item_description']=$this->functions->qTranslate($res['item_description'],'item_description',$res);
			
			
			$res['item_name'] = ($res['item_name']);
			$res['item_description'] = ($res['item_description']);
			$res['item_name_trans'] = ($res['item_name_trans']);
			$res['item_description_trans'] = ($res['item_description_trans']);

			if($res['item_description']==""){
				$res['item_description']="Upload description here";
			}

			
			$res['photo'] = $this->mobileWrapper->getImage($res['photo'],'default_cuisine.png');
			
			/*GET DISH*/
			$icon_dish= array();
			if(!empty($res['dish'])){				
				if (1==1){	   
			       $icon_dish = $this->functions->getDishIcon($res['dish']);
				} else $icon_dish='';
			} else $icon_dish='';
			
			$res['dish_list'] = $icon_dish;
			
			/*GALLERY*/
			$res['gallery']=array();
			if(!empty($res['gallery_photo'])){
				$new_gallery_photo=array();
				$gallery_photo = json_decode($res['gallery_photo'],true);
				if(is_array($gallery_photo) && count((array)$gallery_photo)>=1){
					foreach ($gallery_photo as $gallery_photo_val) {
						$new_gallery_photo[]= $this->mobileWrapper->getImage($gallery_photo_val);
					}
					$res['gallery']=$new_gallery_photo;					
				}			
			}
			
			
			/*CHECK IF MULTIPLE PRICE*/
			$res['multiple_price'] = false;
			if(is_array($res['prices']) && count($res['prices'])>=2){	
				$new_price = array();
				foreach ($res['prices'] as $prices) {
					$prices['size']=$this->functions->qTranslate($prices['size'],'size',$prices); 					
					$new_price[]=$prices;
				}
				$res['prices']=$new_price;					
				$res['multiple_price'] = true;
			} else {
				/*FIXED FOR SINGLE PRICE WITH ONLY 1 SIZE*/	
				if(isset($res['prices'][0])){
					if( $res['prices'][0]['size_id']>0 ){
						$res['multiple_price'] = true;
					}					
				}		
			}		
			
			$row = isset($this->data['row'])?$this->data['row']:'';
			if(is_numeric($row)){				
				if($resp=$this->mobileWrapper->getCart($device_uiid)){
					$cart=json_decode($resp['cart'],true);
					if(array_key_exists($row,(array)$cart)){
						$cart[$row]['row']=$row;
						$cart_data = isset($cart[$row])?$cart[$row]:'';
					}
				}
			} else $cart_data='';
			
			
			/*inventory*/
			$inventory_live = $this->functions->getOption('inventory_live',$merchant_id);

			if($inventory_live==1){
		     $inventory_enabled  = true;
		    }else{
		    	$inventory_enabled  = false;
		    }

		   
            //+++waseem custom code
		    if(!isset($res['prices'][0]['size'])){
		    	$res['prices'][0]['size']="";
		    	$dsp_amnt=$res['prices'][0]['price'];
		    	$res['prices'][0]['size_id']=0;
		    	$res['prices'][0]['formatted_price']=$this->functions->prettyFormat( (float) $dsp_amnt);
		    }
           //---waseem custom code
			
			/*SHARE OPTIONS*/
			$res['share_options'] = array(
			  'message'=>$res['item_name'],
			  'subject'=>$res['item_name'],
			  'url'=>$this->functions->websiteUrl()."/store/menu/slug/$restaurant_slug"
			);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'inventory_enabled'=>$inventory_enabled==true?1:0,
			  'cat_id'=>isset($this->data['cat_id'])?$this->data['cat_id']:'',
			  'data'=>$res,
			  'cart_data'=>$cart_data,		
			  'ordering_disabled'=>$ordering_disabled,
			  'ordering_msg'=>$ordering_msg
			);			
			
		} else $this->msg = "Invalid item id";
		
		$this->output();
	}




	public function addToCart($is_direct=false)
	{	
		$code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:1.5;

		$this->StocksWrapper = new StocksWrapper();
		
		if($code_version<=1.4){				
			$this->getGETData();
		    $this->data = $_GET;
		} else {
			$this->getPOSTData();
			$this->data = $_POST;
		}
		
		$data = $_POST;		
		$cart_with_qty = true;
		
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
		$item_id = isset($data['item_id'])?$data['item_id']:'';		
			
		$qty = isset($data['qty'])?(integer)$data['qty']:0;			
				
		if($is_direct==TRUE && $qty<=0 && $cart_with_qty==TRUE){			
			if ( $res = $this->mobileWrapper->getCart($device_uiid)){
				if($current_cart = json_decode($res['cart'],true)){
					$item_id = isset($data['item_id'])?(integer)$data['item_id']:0;											
					if(is_array($current_cart) && count($current_cart)>=1){						
						
						$key='';
						foreach ($current_cart as $key_cart=>$val_cart) {							
							if($val_cart['item_id']==$item_id){
								$key=$key_cart;
								break 1;
							}
						}
												
						if(isset($current_cart[$key])){
							unset($current_cart[$key]);
													
							

							 $params = array(
				                'cart'=>json_encode($current_cart),
							  'cart_count'=>count($current_cart),
				            );


							$this->functions->updateData("mt_mobile2_cart", $params, 'cart_id', $res['cart_id']);


																					
						}
														
					}				
				}
				$this->code = 1;
		        $this->msg="Cart updated";
			}			
			$this->output();
		}
		
		if($qty>0){
			// silent			
			if (strpos($qty,'.') !== false) {
			   $this->msg = "invalid quantity";
			   $this->output();
			}	
		} else {
		  	$this->msg = "invalid quantity";
			$this->output();
		}
					
		if($device_uiid<0 || empty($device_uiid)){
			$this->msg = "invalid device uiid";
			$this->output();
		}
		
		if($merchant_id<0 || empty($merchant_id)){			
			$this->msg = "invalid merchant id";
			$this->output();
		}
		if($merchant_id=="undefined"){
			$this->msg = "invalid merchant id";
			$this->output();
		}		
		
		if(!is_numeric($item_id)){
			$this->msg = "Invalid item id";
			$this->output();
		}
		if(!$item_details = $this->functions->getFoodItem($item_id)){
			$this->msg = "Item details not found";
			$this->output();
		}
		$data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
		$data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
		
		//dump($item_details);
		
		if(!isset($data['price'])){
			$this->msg ="Please select price";
			$this->output();
		}
		
		
		$refresh = 0;
		$debug = false;	
				
		if ( $res = $this->mobileWrapper->getCart($device_uiid)){			
			 $current_cart = json_decode($res['cart'],true);
			 
			 $row = isset($data['row'])?$data['row']:'';
			 if(is_numeric($row)){					 	    
				$current_cart[$row]= $data;	
				$refresh = 1;		
			 } else {
			 	
			 						
					/*CHECK IF THE ITEM IS ALREADY IN THE CART */					
					$item_found = true; $found_key = -1;
					
					if(is_array($current_cart) && count($current_cart)>=1){
						foreach ($current_cart as $current_cart_key => $current_cart_val) {
							/*dump($current_cart_key);
							dump($current_cart_val);*/
										
							$item_found = true;
													
							if ($current_cart_val['item_id']!=$data['item_id']){
								$item_found = false;
							}
							if ($current_cart_val['price']!=$data['price']){
								$item_found = false;
							}
							
							/*COOKING REF*/
							if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
								if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
									$item_found = false;
								}
							} else {								
								if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
								} else $item_found = false;								
							}
							
							/*INGREDIENTS*/
							if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
								$ingredients = json_encode($data['ingredients']);
								$ingredients2 = json_encode($current_cart_val['ingredients']);								
								if($ingredients!=$ingredients2){
									$item_found = false;
								} 
							} else {
								if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
								} else $item_found = false;								
							}
							
							/*ADDON*/
							if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
								$sub_item = json_encode($data['sub_item']);
								$sub_item2 = json_encode($current_cart_val['sub_item']);
								if($sub_item!=$sub_item2){
									$item_found = false;
								} 
							} else {
								if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
								} else $item_found = false;								
							}
							
							if($item_found==TRUE){								
							   $found_key = $current_cart_key;
						    } 
						    
						} /*END LOOP*/
						
						if($found_key>=0){
													
							if($is_direct){						
								$current_cart[$found_key]['qty']  = $data['qty'];
							} else $current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
						} else {							
							array_push($current_cart,$data);
						}
						
					} else {						
						array_push($current_cart,$data);
					}					
				}
				
				
				
				/*inventory*/				
				if($this->functions->inventoryEnabled($merchant_id)){
				  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
				  $current_item_price = isset($data['price'])?$data['price']:'';		
				  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
				  $inv_qty = 0;				  
				  foreach ($current_cart as $val) {
				  	  if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
				  	  	 $inv_qty+=$val['qty'];
				  	  }
				  }				 				  				  
				  try {
				  	 $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
				  } catch (Exception $e) {
		            $this->msg = $e->getMessage();
		            $this->output();
		          }					  
				}
				
							
				$cart_count = count($current_cart);


				


				$this->functions->updateData("mt_mobile2_cart",array(
				  'merchant_id'=>$merchant_id,
				  'device_uiid'=>$device_uiid,				  
				  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
				  'cart'=>json_encode($current_cart),
				  'cart_count'=>(integer)$cart_count,
				  'date_modified'=>$this->functions->dateNow(),
				),'cart_id', $res['cart_id']);

								
		} else {			
								
			/*inventory*/
			if($this->functions->inventoryEnabled($merchant_id)){
				try {
				  	 $this->StocksWrapper->verifyStocks(
				  	  isset($data['qty'])?(integer)$data['qty']:0,
				  	  $merchant_id,
				  	  isset($data['item_id'])?(integer)$data['item_id']:0,
				  	  isset($data['with_size'])?(integer)$data['with_size']:0,
				  	  isset($data['price'])?$data['price']:''
				  	 );
				} catch (Exception $e) {
		            $this->msg = $e->getMessage();
		            $this->output();
		        }			
			}			
		 
			$cart_count=1;			
		   	


		    $this->functions->insertData("mt_mobile2_cart",array(
			 'merchant_id'=>$merchant_id,
		     'device_uiid'=>$device_uiid,		     
		     'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
		     'cart'=>json_encode(array($data)),
		     'cart_count'=>(integer)$cart_count,
		     'date_modified'=>$this->functions->dateNow(),
		    ));


		    		   			
		}
		
		$this->code = 1;
		$this->msg="Added to cart";
		if($refresh==1){
			$this->msg="Cart updated";
		}			
		$this->details=array(
		 'merchant_id'=>$merchant_id,
		 'cart_count'=>$cart_count,
		 'refresh'=>$refresh
		);
			
		$this->output();
	}


	public function getCartCount()
	{
		$this->data = $_POST;
		$data = $_POST;
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
		$merchant_id = isset($data['merchant_id'])?$data['merchant_id']:'';		
		$basket_total=0;$item_total=0; 
		$transaction_type = isset($data['transaction_type'])?$data['transaction_type']:'';		
		
		if($res=$this->mobileWrapper->getCart($device_uiid)){			
			if ( $res['merchant_id']!=$merchant_id){
				$this->mobileWrapper->clearCart($device_uiid);				
			} else {
				$cart=json_decode($res['cart'],true);		
				
				if(empty($transaction_type)){
					$services = $this->functions->DeliveryOptions($merchant_id);		
					if(is_array($services) && count($services)>=1){
						foreach ($services as $services_key=>$services_val) {				
							$transaction_type = $services_key;
							break;				
						}
					}	
				}
				
				$params = array(
				  'delivery_type'=>$transaction_type,
				  'merchant_id'=>$merchant_id,
				  'card_fee'=>0
				);
										
				

				$displayOrderHTML=$this->functions->displayOrderHTML( $params,$cart);

				$code = $displayOrderHTML['code'];		
				if($code==1){
				    $details =$displayOrderHTML['raw']; 
				    
				    //dump($details);
				    if(is_array($cart) && count($cart)>=1){
						foreach ($cart as $val) {					
							$item_total+=$val['qty'];
						}
					}			    
				    					
					$basket_total = $details['total']['subtotal'];
					if($item_total>1){
						
						$basket_msg =$item_total." items" ;
					} else {
						

						$basket_msg =$item_total." item" ;
				    }
				    			    
				    $basket_total = $this->functions->prettyPrice($basket_total);			    
					$this->code=1;
					$this->msg = "OK";				
					$this->details = array(
					  'count'=>$item_total,
					  'basket_count'=>$basket_msg,
					  'basket_total'=>$basket_total
					);			
					$this->output();
				}
			}
		} 
		
		$this->msg="0 found";
		$this->details = array(
		  'count'=>0,
		  'basket_count'=>"0 items",		  
		  'basket_total'=>$this->functions->prettyPrice(0.00001)
		);				
		$this->output();
	}


	public function loadCart()
	{				
		
		$this->details = array();

		$this->StocksWrapper = new StocksWrapper();
		
		if(!is_numeric($this->merchant_id) || $this->merchant_id<=0){
			$this->msg = "invalid merchant id";
			$this->code = 5;
						
			$this->mobileWrapper->clearCart($this->device_uiid);
			$this->output();
		}
		
		$is_location = $this->functions->isSearchByLocation();
		
		if (!$merchant_info_raw = $this->functions->getMerchantById($this->merchant_id)){
			$merchant_info_raw = ($merchant_info_raw);
			$this->msg = "Merchant not found";
			$this->code = 5;
		}
		
		$merchant_lat = isset($merchant_info_raw['latitude'])?$merchant_info_raw['latitude']:0;
		$merchant_lng = isset($merchant_info_raw['lontitude'])?$merchant_info_raw['lontitude']:0;				
		$merchant_unit = isset($merchant_info_raw['distance_unit'])?$merchant_info_raw['distance_unit']:'';	
		
		$customer_lat = isset($this->data['lat'])?$this->data['lat']:0;
		$customer_lng = isset($this->data['lng'])?$this->data['lng']:0;				
		
		/*CHECK IF ORDERING IS DISABLED*/
		$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
		if($disabled_website_ordering=="yes"){
			$this->msg = "Ordering is disabled by admin";
			$this->code = 4;
			
			$this->mobileWrapper->clearCart($this->device_uiid);
			$this->output();
		}
		$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
		if($merchant_disabled_ordering=="yes"){
			$this->msg = "Ordering is disabled by merchant";
			$this->code = 4;
			
			$this->mobileWrapper->clearCart($this->device_uiid);
			$this->output();
		}
				
		$merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
		if($merchant_close_store=="yes"){
			$this->msg = "Merchant is now close and not accepting any orders";
			$this->code = 4;
			
			$this->mobileWrapper->clearCart($this->device_uiid);
			$this->output();
		}
		
		$this->setMerchantTimezone();
		
		$transaction_type=''; $first_available_services='';
		$services = $this->functions->DeliveryOptions($this->merchant_id);
		
		if(is_array($services) && count($services)>=1){
			foreach ($services as $services_key=>$services_val) {				
				$transaction_type = $services_key;
				$first_available_services = $services_key;
				break;				
			}
		}
		
		if(isset($this->data['transaction_type'])){
			if(!empty($this->data['transaction_type'])){
				$transaction_type=$this->data['transaction_type'];
				if(!array_key_exists($transaction_type,(array)$services)){
					$transaction_type = $first_available_services;
					$this->data['transaction_type'] = $first_available_services;
				}			
			}
		} else {
			$this->data['transaction_type']=$transaction_type;
		}	
		
		
		$token = isset($this->data['user_token'])?$this->data['user_token']:'';		
		$client_info = $this->mobileWrapper->getCustomerByToken($token);
							
		/*GET CART*/
		$res=$this->mobileWrapper->getCart($this->device_uiid);
				
		$search_resp = $this->mobileWrapper->searchMode();
		$search_mode = $search_resp['search_mode'];
		$location_mode = $search_resp['location_mode'];			

		$code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:1.5;
		
		
		/*UPDATE DISTANCE*/				
		if($res):
		if(!$is_location && $res['delivery_lat']!=$customer_lat && $code_version>1.4 ){
			
			$provider = array(); $provider_mode='';			
			
		    $provider = $this->mobileWrapper->getMapProvider(); 			
		    $this->MapsWrapperTemp->init($provider);		   
		    $provider_mode = isset($provider['mode'])?$provider['mode']:'driving';			
		    
			try {			
				
				$new_merchant_unit = $this->CheckoutWrapperTemp->unit($merchant_unit);				
				$resp_distance = $this->MapsWrapperTemp->getDistance(
				 $merchant_lat,$merchant_lng,$customer_lat,$customer_lng,$new_merchant_unit,$provider_mode
				);

							
				$res['distance']=$resp_distance['distance'];
				$res['distance_unit']=$resp_distance['unit'];
				
				$res['street']='';
				$res['city']='';
				$res['state']='';
				$res['zipcode']='';
				
				


				$params = array(
	              'distance'=>$resp_distance['distance'],
				 'distance_unit'=>$resp_distance['unit'],
				 'delivery_lat'=>$customer_lat,
				 'delivery_long'=>$customer_lng,
				 'street'=>'',
				 'city'=>'',
				 'state'=>'',
				 'zipcode'=>''
				            );


				$this->functions->updateData("mt_mobile2_cart", $params, 'cart_id', $res['cart_id']);



				
			} catch (Exception $e) {
	   	  	    //echo $e->getMessage();
	   	  	 }
		} 
		endif;
		/*END UPDATE DISTANCE*/		

		
		/*CHECK TIPS DEFAULT*/
		if($res):
		$merchant_tip_default = $this->functions->getOption('merchant_tip_default',$this->merchant_id);
		if($merchant_tip_default>0 && $res['tips']<=0 && $res['remove_tip']<=0 ){			
			$res['tips'] = $merchant_tip_default;
			
			

	  	    $params = array(
	             'tips'=>$merchant_tip_default
				            );


			$this->functions->updateData("mt_mobile2_cart", $params, 'cart_id', $res['cart_id']);


		}			
		endif;
				
		if($res){
			$cart=json_decode($res['cart'],true);
			
			$data = array(
			  'delivery_type'=>$transaction_type,
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>0
			);
			
			if($res['tips']>0.0001){
				$data['cart_tip_percentage']=$res['tips'];
				$data['tip_enabled']=2;
				$data['tip_percent']=$res['tips'];
			}		
			
			$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
			if(is_array($voucher_details) && count($voucher_details)>=1){
				$data['voucher_name']=$voucher_details['voucher_name'];
				$data['voucher_amount']=$voucher_details['amount'];
				$data['voucher_type']=$voucher_details['voucher_type'];
			}
			
			if($res['points_apply']>0.0001){
				$data['points_apply']=$res['points_apply'];
			}
			if($res['points_amount']>0.0001){
				$data['points_amount']=$res['points_amount'];
			}
			
			unset($_SESSION['shipping_fee']);
			if($res['delivery_fee']>0.0001){
				$data['delivery_charge']=$res['delivery_fee'];
			} else $data['delivery_charge']=0;
			
			$cart_details = $res;
			unset($cart_details['cart']);		
			unset($cart_details['device_uiid']);
			unset($cart_details['cart_id']);			
			unset($_SESSION['pts_redeem_amt']);
						
			
			$found_unavailable_item = false;
			
			/*inventory*/
			if($this->functions->inventoryEnabled($this->merchant_id)){
				$new_cart = array();
			    if(is_array($cart) && count($cart)>=1){
			    	foreach ($cart as $keys_cart=>$cartval) {
			    		try {			    		   
			    		   $this->StocksWrapper->verifyStocks(
			    		      isset($cartval['qty'])?(integer)$cartval['qty']:0,
			    		      $this->merchant_id,
			    		      isset($cartval['item_id'])?(integer)$cartval['item_id']:0,
			    		      isset($cartval['with_size'])?(integer)$cartval['with_size']:0,
			    		      isset($cartval['price'])?$cartval['price']:0
			    		   );
			    		   $new_cart[$keys_cart]=$cartval;
			    		} catch (Exception $e) {
			    			$found_unavailable_item = true;
				   	  	    //echo $e->getMessage();
				   	  	 }
			    	}
			    	$cart = $new_cart;
			    }			
			} else {								
				/*VALIDATE IF ITEM IS STILL AVAILABLE*/
				$new_cart = array(); 
			    if(is_array($cart) && count($cart)>=1){
			    	foreach ($cart as $keys_cart=>$cartval) {
			    		try {			    		   
			    		   $this->itemWrapper->verifyItemAvailable( isset($cartval['item_id'])?(integer)$cartval['item_id']:0 );
			    		   $new_cart[$keys_cart]=$cartval;
			    		} catch (Exception $e) {
			    			$found_unavailable_item = true;
				   	  	    //echo $e->getMessage();
				   	  	 }
			    	}
			    	$cart = $new_cart;			    				    	
			    }			
			}		
						
			/*UPDATE CART IF THERE IS ITEM NOT AVAILABLE*/
			if($found_unavailable_item==true){
			$this->functions->updateData("mt_mobile2_cart",array('cart'=>json_encode($cart)), 'cart_id', (integer)$res['cart_id']);
	    	}			    
	    											
			
			/*RE VALIDATE POINTS ADDON*/
			if($res['points_amount']>0){								
				if($this->mobileWrapper->revalidatePoints( (array) $cart,$this->merchant_id)){
					$data['points_apply']=0; $data['points_amount']=0;
					$cart_details['points_apply']=0;
										
			       


			  	    $this->functions->updateData("mt_mobile2_cart",array(
			         'points_apply'=>0,
			          'points_amount'=>0
			        ), 'cart_id', (integer)$res['cart_id']);



				}							
			}
			
			$multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation'); 	
			
			

			$displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );

			$code = $displayOrderHTML['code'];
			$msg  = $displayOrderHTML['msg'];
			
			if ($code==1){
				$this->code = 1;
			    $details = $displayOrderHTML['raw'];
			    
			    /*dump($details);
			    die();*/
			    			    
			    /*TRANSLATE*/
			   if($multiple_translation==2){
				   if(is_array($details['item']) && count($details['item'])>=1){
				   	  $new_item = array();
				   	  foreach ($details['item'] as $key=> $details_item_val) {				   	  	
				   	  	 $details_item_val['item_name'] = $this->functions->qTranslate($details_item_val['item_name'],'item_name',$details_item_val['item_name_trans']);
				   	  	 
				   	  	 if(isset($details_item_val['new_sub_item'])){						   	  	 	 
					   	  	 if(is_array($details_item_val['new_sub_item']) && count( (array) $details_item_val['new_sub_item'])>=1){					   	  	 	
					   	  	 	$newest_new_sub_item_val=array();
					   	  	 	foreach ($details_item_val['new_sub_item'] as $new_sub_item_key=>$new_sub_item_val) {		
					   	  	 		$new_sub_item_key = $this->functions->qTranslate($new_sub_item_key,'subcategory_name',$new_sub_item_val[0]['subcategory_name_trans']);				   	  	 						   	  	 		
					   	  	 		$newest_new_sub_item_val[$new_sub_item_key]=$new_sub_item_val;
					   	  	 	}							   	  	 	
					   	  	 	$details_item_val['new_sub_item']=$newest_new_sub_item_val;
					   	  	 }				   	  
				   	  	 }
				   	  	 
				   	  	 $new_item[$key]=$details_item_val;
				   	  }		
				   	  $details['item']=$new_item;
				   }			
			   }
			   /*END TRANSLATE*/
			   
			    /*EURO TAX*/
			   $is_apply_tax = 2;
			   if($this->functions->isApplyTax($this->merchant_id)){
			   	   $new_total = $this->functions->computeWithTax($details, $this->merchant_id);
			   	   $details['total']=$new_total;			
			   	   $is_apply_tax=1;   	   
			   }
			   
			   $has_addressbook = 0;
			   $client_id='';
			   			   
    	       if($client_info){
    		       $client_id = $client_info['client_id'];
    		       if($search_mode=="location"){
    		       	   if($this->LocationWrapper->hasAddress($client_id)){
    		       	   	  $has_addressbook = 1;
    		       	   }
    		       } else {
	    		       if ($this->mobileWrapper->getAddressBookByClient($client_id)){
	    		       	  $has_addressbook = 1;
					   }
    		       }
    	       }    
			   
    	       $defaul_delivery_date = date("Y-m-d");
    	       $date_list = $this->functions->getDateList($this->merchant_id);
    	       foreach ($date_list as $date_list_key => $date_list_val) {    	       	  
    	       	  $defaul_delivery_date = $date_list_key;
    	       	  break;
    	       }
    	           	       
    	       $subtotal = $details['total']['subtotal'];
    	       $cart_error=array();
    	       
    	       $merchant_minimum_order=0;
    	       
    	        /*CHECKING MAX AND MIN AMOUNT*/    	        
    	       if($transaction_type=="delivery"){    	       	  

    	       	  $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$this->merchant_id);     	
    	       	  $min_tables_enabled = $this->functions->getOption('min_tables_enabled',$this->merchant_id);
    	       	      	       	  
    	       	  if($min_tables_enabled==1 && !empty($res['distance'])){    	       	  	  
    	       	  	  $merchant_minimum_order = $this->CheckoutWrapperTemp->getMinimumOrderTable(
    	       	  	  $this->merchant_id,$res['distance'],$res['distance_unit'],$merchant_minimum_order
    	       	  	  );
    	       	  }    	       
    	       	      	       	      	       	  
    	       	  if($merchant_minimum_order>0){
    	       	  	 if($merchant_minimum_order>$subtotal){
    	       	  	 	

    	       	  	 	$cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of".$this->functions->prettyPrice($merchant_minimum_order);

    	       	  	 }    	       	  
    	       	  }      
    	       	  
    	       	  
    	       	  $merchant_maximum_order = $this->functions->getOption('merchant_maximum_order',$this->merchant_id);
    	       	  if($merchant_maximum_order>0.001){
    	       	  	 if($subtotal>$merchant_maximum_order) {
    	       	  	 	

    	       	  	 	$cart_error[] ="Sorry, your order has exceeded the maximum ".$transaction_type." amount of".$this->functions->prettyPrice($merchant_maximum_order);  

    	       	  	 }    	       	  
    	       	  }    	       	     
    	       } elseif ( $transaction_type=="pickup"){
    	       	  $minimum_order = $this->functions->getOption('merchant_minimum_order_pickup',$this->merchant_id); 
    	       	  if($minimum_order>0.001){
    	       	  	 if($minimum_order>$subtotal){
    	       	  	 	

    	       	  	 	$cart_error[] ="Sorry, your order does not meet the minimum".$transaction_type." amount of".$this->functions->prettyPrice($minimum_order);  


    	       	  	 }    	       	  
    	       	  }    	         	       	  
    	       	  $maximum_order = $this->functions->getOption('merchant_maximum_order_pickup',$this->merchant_id);
    	       	  if($maximum_order>0.001){
    	       	  	 if($subtotal>$maximum_order) {

    	       	  	 	

    	       	  	 	$cart_error[] ="Sorry, your order has exceeded the maximum".$transaction_type." amount of".$this->functions->prettyPrice($maximum_order);


    	       	  	 }    	       	  
    	       	  }	       	
    	       } elseif ( $transaction_type=="dinein"){
    	       	  $minimum_order = $this->functions->getOption('merchant_minimum_order_dinein',$this->merchant_id); 
    	       	  if($minimum_order>0.001){
    	       	  	 if($minimum_order>$subtotal){
    	       	  	 	

    	       	  	 	$cart_error[] ="Sorry, your order does not meet the minimum".$transaction_type." amount of".$this->functions->prettyPrice($minimum_order);

    	       	  	 }    	       	  
    	       	  }      	       	  
    	       	  $maximum_order = $this->functions->getOption('merchant_maximum_order_dinein',$this->merchant_id);
    	       	  if($maximum_order>0.001){
    	       	  	 if($subtotal>$maximum_order) {

    	       	  	 	

    	       	  	 	$cart_error[] ="Sorry, your order has exceeded the maximum".$transaction_type." amount of".$this->functions->prettyPrice($maximum_order);

    	       	  	 }    	       	  
    	       	  }	       	
    	       }    	       
    	       /*CHECKING MAX AND MIN AMOUNT*/	
    	       
    	       
    	        /*CHECK IF HAS POINTS ADDON*/
    	       $available_points=0; $available_points_label = '';
    	       $points_enabled = '';   $pts_disabled_redeem=''; 


    	          $this->PointsProgram=new PointsProgram();
    	       	    	       	
    	       	  $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    	       	  if($points_enabled=="1"){
    	       	   	  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
    	       	   	  	  $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
    	       	   	  	  if($mt_disabled_pts==2){
    	       	   	  	  	 $points_enabled='';
    	       	   	  	  }	    	       	   	  
    	       	   	  }
    	       	  }
    	       	  
    	       	  $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
    	       	  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
    	       	  	  $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$this->merchant_id);
    	       	  	  if($mt_pts_disabled_redeem>0){
    	       	  	  	  $pts_disabled_redeem=$mt_pts_disabled_redeem;
    	       	  	  }    	       	  
    	       	  }
    	       	   
    	       	  /*GET EARNING POINTS FOR THIS ORDER*/
    	       	  $subtotal = $details['total']['subtotal'];    	       	  
    	       	  if ($earn_pts = $this->mobileWrapper->getCartEarningPoints($cart,$subtotal,$this->merchant_id)){    	       	  	 
    	       	  	 

		          	    $this->functions->updateData("mt_mobile2_cart",array(
						  'points_earn'=>(float)$earn_pts['points_earn'],
    	       	  	      'date_modified'=>$this->functions->dateNow()
						), 'cart_id', (integer)$res['cart_id']);	
    	       	  	 
    	       	  }    	    
    	       	         	       	     	       	    	       
    	       	  if($client_id>0){    	       	  	    	       	      	       	   	  
    	       	   	  if($points_enabled=="1"){
	    	       	   	  $available_points = $this->mobileWrapper->getTotalEarnPoints( $client_id , $this->merchant_id);
	    	       	   	 

	    	       	   	   $available_points_label = "Your available points ".$available_points;


    	       	   	  }
    	       	   }    	       
    	         
    	       
    	       $merchant_info = array();
    	       if($merchant_info_raw){
    	       	   $merchant_info['restaurant_name']=$this->functions->clearString($merchant_info_raw['restaurant_name']);
    	       	   $merchant_info['rating'] = $merchant_info_raw['ratings']>0?$merchant_info_raw['ratings']:0;
    	       	   $merchant_info['background_url'] = $this->mobileWrapper->getMerchantBackground($this->merchant_id);
    	       }
    	       
    	       $subtotal = isset($details['total']['subtotal'])?$details['total']['subtotal']:0; 



          	    $this->functions->updateData("mt_mobile2_cart",array(
				  'cart_subtotal'=>(float)$subtotal,
       	  	      'date_modified'=>$this->functions->dateNow()
				), 'cart_id', (integer)$res['cart_id']);		

               //+++waseem custom code for tip correction
    	       if($details['total']['tips']!=""){
    	       	$amount_tipss=$details['total']['tips'];
                $decoded_tip = html_entity_decode($amount_tipss);
                $clean_tip = preg_replace('/[^0-9.]/', '', $decoded_tip);
                $details['total']['tips']= $clean_tip;

    	       }
                //---waseem custom code for tip correction

    	        $this->details = array(
    	         'merchant'=>$merchant_info,
			     'is_apply_tax'=>$is_apply_tax,
			     'checkout_stats'=>$this->functions->isMerchantcanCheckout($this->merchant_id),
			     'has_addressbook'=>$has_addressbook,
			     'services'=>$services,
			     'transaction_type'=>$transaction_type,
			     'default_delivery_date'=>$defaul_delivery_date,
			     //'default_delivery_date_pretty'=>date("D F d, Y"),
			     'default_delivery_date_pretty'=>$this->functions->prettyDate($defaul_delivery_date),
			     'required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),	
			     'opt_contact_delivery'=>$this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id),
			     'tip_list'=>$this->mobileWrapper->tipList(),			     
			     'data'=>$details,
			     'cart_details'=>$cart_details,
			     'cart_error'=>$cart_error,
			     'points_enabled'=>$points_enabled,			     
			     'points_earn'=>isset($earn_pts['points_earn'])?$earn_pts['points_earn']:'',
			     'pts_label_earn'=>isset($earn_pts['pts_label_earn'])?$earn_pts['pts_label_earn']:'',
			     'available_points'=>$available_points,
			     'available_points_label'=>$available_points_label,
			     'pts_disabled_redeem'=>$pts_disabled_redeem
			   );
    	       
			} else {
				$this->mobileWrapper->clearCart($this->device_uiid);
				$this->msg = $msg;
			}			
		} else $this->msg = "Cart is empty";
		
		$this->details['merchant_settings'] = $this->mobileWrapper->merchantAppSettings($this->merchant_id);		
		
		$onetime_payment = $this->functions->getOptionAdmin('mobileapp2_onetime_payment');    	   
	    $payment_list = (array) $this->functions->getMerchantPaymentListNew($this->merchant_id);	   
	    if($onetime_payment!=1){
	   	   $payment_list = array();
	    }  
	    $this->details['payment_list_count'] = count($payment_list);
	    $this->details['payment_list'] = $payment_list;		      	
								
		$this->output();
	}

	public function setMerchantTimezone(){
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
		if($merchant_id>0){			
			$mt_timezone=$this->functions->getOption("merchant_timezone",$merchant_id);			
	    	if (!empty($mt_timezone)){
	    		date_default_timezone_set($mt_timezone);
	    	}    	
		}
	}

	public function getFirstCart()
	{		
		
		$token = isset($this->data['user_token'])?$this->data['user_token']:'';
		if($client_info = $this->mobileWrapper->getCustomerByToken($token)){			
			$this->data['client_id'] = $client_info['client_id'];			
            $this->mobileWrapper->registeredDevice($this->data);
		}
		
		if($res = $this->mobileWrapper->getCart($this->device_uiid)){			
			$cart=json_decode($res['cart'],true);
			$count=0;			
			if(is_array($cart) && count($cart)>=1){
				foreach ($cart as $val) {					
					$count+=$val['qty'];
				}
			}						
			if($count>0){
				$this->code=1;
			    $this->msg = "OK";
				$this->details = array(
				  'merchant_id'=>$res['merchant_id'],
				  'count'=>$count
				);
			} else $this->msg = "No results";
		} else $this->msg ="No results";
		$this->output();
	}

	public function removeCartItem()
	{
		
		$row = isset($this->data['row'])?$this->data['row']:0;		
		if($res=$this->mobileWrapper->getCart($this->device_uiid)){
			$cart=json_decode($res['cart'],true);			
			if(array_key_exists($row,(array)$cart)){		
												
				$item_id  = isset($cart[$row]['item_id'])?(integer)$cart[$row]['item_id']:0;				
				$category_id  = isset($cart[$row]['category_id'])?(integer)$cart[$row]['category_id']:0;
				$cart_id  = isset($res['cart_id'])?$res['cart_id']:0;				
										
				unset($cart[$row]);				
										
				

		  	    $this->functions->updateData("mt_mobile2_cart",array(
				  'cart'=>json_encode($cart),
				  'cart_count'=> (integer) count($cart),
				), 'cart_id',$cart_id);



		  	    		  	   
				$this->code = 1;
				$this->msg="OK"; 
				$this->details='';
			} else $this->msg = "Cannot find cart row";
		} else $this->msg = "Cart is empty";
		$this->output();
	}
	
	public function clearCart()
	{		
		$this->mobileWrapper->clearCart($this->device_uiid); 
		$this->code = 1;
		$this->msg = "OK";
		$this->output();
	}

	public function servicesList()
	{		
		$services = $this->functions->DeliveryOptions($this->merchant_id);
		if(is_array($services) && count($services)>=1){
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$services
			);
		} else $this->msg = "Services not available";
		$this->output();
	}
	
	public function deliveryDateList()
	{		
		$this->setMerchantTimezone();			
		$dates = $this->functions->getDateList($this->merchant_id);
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		 'data'=>$dates
		);
		$this->output();
	}


	public function deliveryTimeList()
	{
		$this->setMerchantTimezone();	
		$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';		
		$times = $this->functions->getTimeList($this->merchant_id,$delivery_date);
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		  'data'=>$times
		);
		$this->output();
	}
	
	public function getAddressBookDropDown()
	{
		$this->getAddressBookList();
	}
	
	public function getAddressBookList()
	{		
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];						
		if($client_id>0){			
			if ( $res = $this->mobileWrapper->getAddressBookByClient($client_id)){
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'data'=>$res
				);
			} else $this->msg = "No results";
		} else $this->msg ="No results";
		$this->output();
	}

	public function setDeliveryAddress()
	{						
				
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
	    $lng = isset($this->data['lng'])?$this->data['lng']:'';
	    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
	    
	    
	    if($merchant_id<=0){
	    	$this->msg = "invalid merchant id";
    		$this->output();
	    }	
	    
	    if(!$cart=$this->mobileWrapper->getCart($this->device_uiid)){
	    	$this->msg ="Cart is empty";    	
    		$this->output();
	    }
	    
	    $country_name = $this->functions->countryCodeToFull(isset($this->data['country_code'])?$this->data['country_code']:'');		
		if(!empty($country_name)){
			$this->data['country']=$country_name;
		}
	
		$complete_address = $this->data['street']." ".$this->data['city']." ".$this->data['state']." ".$this->data['zipcode'];
		$complete_address.=" $country_name";
		
		try {
			
			$min_fees=0;			
			$cart_subtotal = isset($cart['cart_subtotal'])?(float)$cart['cart_subtotal']:0;			
			$resp = $this->CheckoutWrapperTemp->verifyLocation($merchant_id,$lat,$lng,$cart_subtotal);	
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'complete_address'=>$complete_address,			  
			  'min_delivery_order'=>$min_fees,
			  'lat'=>$lat,
			  'lng'=>$lng,
			  'formatted_address'=>$complete_address,
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
			  'country'=>$country_name
			);
						
			$params = array(
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
			  'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
			  'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
			  'delivery_lat'=>$lat,
			  'delivery_long'=>$lng,
			  'save_address'=>isset($this->data['save_address'])?(integer)$this->data['save_address']:0,
			  'delivery_fee'=>(float)$resp['delivery_fee'],
			  'min_delivery_order'=>(float)$resp['min_order'],
			  'distance'=>$resp['distance'],
			  'distance_unit'=>$resp['unit'],
			);			
										
			

      	   $this->functions->updateData("mt_mobile2_cart",$params,'cart_id',$cart['cart_id']);		
      	   
      	   /*SAVE ADDRESS*/
      	   $customer_token = isset($this->data['user_token'])?$this->data['user_token']:'';      	   
      	   if( !empty($customer_token) && $params['save_address']==1 && !empty($params['street']) ){
      	   	   if ($customer_data = $this->mobileWrapper->getCustomerByToken($customer_token,false)){
      	   	   	    $client_id = $customer_data['client_id'];
      	   	   	    if (!$resp_book =  $this->mobileWrapper->getBookAddress($client_id,$params['street'],$params['city'],$params['state'])){
      	   	   	    	
      	   	   	    	$client_id = (integer)$client_id;

		          	   $this->functions->updateData("mt_address_book",array(
						  'as_default'=>1,
    	       	  	      'date_modified'=>$this->functions->dateNow()
						),'client_id',$client_id);	

      	   	   	    	
      	   	   	    	$params_address_book = array(
						  'client_id'=>$client_id,
						  'street'=>isset($this->data['street'])?$this->data['street']:'',
						  'city'=>isset($this->data['city'])?$this->data['city']:'',
						  'state'=>isset($this->data['state'])?$this->data['state']:'',
						  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
						  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
						  'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
						  'as_default'=>2,
						  'date_created'=>$this->functions->dateNow(),
						  'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
						  'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
						  'ip_address'=>$_SERVER['REMOTE_ADDR']
						);								
						
                        $this->functions->insertData("mt_address_book",$params_address_book);

      	   	   	    }      	   	   	   
      	   	   }
      	   }		
			
		} catch (Exception $e) {
		   $this->msg = $e->getMessage();					    
        }		        
        
		$this->output();
	}

		public function loadPaymentList()
	{
		
		/*CHECK IF ORDERING IS DISABLED*/
		$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
		if($disabled_website_ordering=="yes"){
			$this->msg ="Ordering is disabled by admin";
			$this->output();
		}
		$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
		if($merchant_disabled_ordering=="yes"){
			$this->msg = "Ordering is disabled by merchant";
			$this->output();
		}
		
		$merchant_opt_contact_delivery= $this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id);
		$opt_contact_delivery = isset($this->data['opt_contact_delivery'])?$this->data['opt_contact_delivery']:'';
					
		if ( $res = $this->functions->getMerchantPaymentListNew($this->merchant_id)){	

		     		
			 $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
			 $this->code = 1;
			 $this->msg = "OK";		
			 $list = array();
			 
			 if(isset($res['mcd'])){
			    unset($res['mcd']);
			 }
			 if(isset($res['pyp'])){
			    unset($res['pyp']);
			 }
			 			 
			 /*REMOVE OFFLINE PAYMENT OPTION CONTACT DELIVERY*/
			 if($merchant_opt_contact_delivery==1 && $transaction_type=="delivery" && $opt_contact_delivery==1){
			 	if(isset($res['cod'])){unset($res['cod']);}
			 	if(isset($res['pyr'])){unset($res['pyr']);}
			 	if(isset($res['obd'])){unset($res['obd']);}
			 	if(isset($res['ocr'])){unset($res['ocr']);}
			 }				 
			 
			 foreach ($res as $key => $val) {
			 	switch ($key) {
			 		case "cod":
			 			$val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 			break;
			 			
			 	
			 		case "pyr":
			 			$val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 			break;
			 						 	
			 		case "paypal_v2":



			 		   if ( !$resp = $this->functions->getCredentials_paypal($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  

			 		   	   	   $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);

			 		   	   } else $val = $val;
			 		   } else $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);

                        $val=$this->functions->frontend_payment_translations($key,$resp['card_fee'],$transaction_type);
                       //$val = "Paypal V2 card fee ".$resp['card_fee'].'%';
			 		   break;	   
			 		  
			 		case "stp":				 		
			 		   if ( $resp = $this->functions->getCredentials_stripe($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  $cardfee = ($resp['card_fee']);
			 		   	   	  if(isset($resp['card_percentage'])){
			 		   	   	  	 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
			 		   	   	  	 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
			 		   	   	  }	

			 		   	   	  
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
			 		   	   	  //$val = "Stripe card fee ".$cardfee;

			 		   	   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   break;  

			 		case "windcave":				 		
			 		   if ( $resp = $this->functions->getCredentials_windcave($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  $cardfee = ($resp['card_fee']);
			 		   	   	  if(isset($resp['card_percentage'])){
			 		   	   	  	 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
			 		   	   	  	 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
			 		   	   	  }	

			 		   	   	  
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
			 		   	   	  //$val = "Windcave card fee ".$cardfee;

			 		   	   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   break;  


			    case "poli":
                $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
               
                break;  
			 		   
			 		    
			 		   			 	   			 		 
			 			
			 		default:
			 			$val = $val;
			 			break;
			 	}			 	
			 	$list[] = array(
		 		  'payment_code'=>$key,
		 		  'payment_name'=>$val
		 		);
			 }
			 $this->details = array(
			   'data'=>$list
			 );
		} else $this->msg = "No payment option available";
		$this->output();
	}	





	public function payNow()
	{
		
		/*VALIDATE OPERATIONAL HOURS*/
		$today = strtolower(date("l"));
		$time_now = date("G:i");		
		if ( !$this->mobileWrapper->isOperationalHours($today,$time_now)){
			$this->msg = "Sorry but we are now close, you can place your order tomorrow during operational hours.";
			$this->output();
		}		
				
		$this->setMerchantTimezone();
				
		
		$lang_code="en";
		
		$search_resp = $this->mobileWrapper->searchMode();
		$search_mode = $search_resp['search_mode'];
		$location_mode = $search_resp['location_mode'];		
		
		$token = isset($this->data['user_token'])?$this->data['user_token']:'';
		if(!$client_info = $this->mobileWrapper->getCustomerByToken($token)){
			$this->msg = "Invalid token, please relogin again";
    		$this->output();
		}
				
		if (!$merchant_info = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
			$this->msg = "invalid merchant id";
    		$this->output();
		}
		
		$client_id = (integer) $client_info['client_id'];    	
		$customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
		$customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
		$customer_email = isset($client_info['email_address'])?$client_info['email_address']:'';
				
    	$email_address = $client_info['email_address'];
    	
    	if ( $this->functions->emailBlockedCheck($email_address)){
    		$this->msg = "Sorry but your email address is blocked by website admin"; 
    		$this->output();
    	}   
    	
    	/*CHECK CUSTOMER CAN ORDER*/
    	try {	    	    		    	
	    	$this->CheckoutWrapperTemp->verifyCanPlaceOrder($client_id);	    	    	
	    } catch (Exception $e) {
			 $this->msg = $e->getMessage();
			 $this->output();
		}
		
    	
    	$transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
    	$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
    	$delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
    	$payment_provider = isset($this->data['payment_provider'])?$this->data['payment_provider']:'';
    	
    	if(empty($delivery_date)){
    		$this->msg = "Delivery date is required";
    		$this->output();
    	}
    	
    	if(empty($payment_provider)){
    		$this->msg = "Payment provider is empty. please go back and try again";
    		$this->output();
    	}
    	
    	$full_delivery = "$delivery_date $delivery_time";    	
    	$delivery_day = strtolower(date("D",strtotime($full_delivery)));
    	
    	$delivery_time_formated = '';
    	if(!empty($delivery_time)){
    		$delivery_time_formated=date('h:i A',strtotime($delivery_time));
    	} else $delivery_time_formated = date('h:i A');
    	
    	if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
    		$date_close=date("F,d l Y h:ia",strtotime($full_delivery));
    		$this->msg = "Sorry but we are closed on ".$date_close." Please check merchant opening hours.";
    		$this->output();
    	}    	 
    	    	
    	/*CHECK IF DATE IS HOLIDAY*/
    	if ( $res_holiday =  $this->functions->getMerchantHoliday($this->merchant_id)){
    		if (in_array($delivery_date,$res_holiday)){
    		   
    		    $this->msg="were close on ".$this->functions->prettyDate($delivery_date);
			   	
			   	$close_msg=$this->functions->getOption('merchant_close_msg_holiday',$this->merchant_id);
			   	if(!empty($close_msg)){
	   	  	 	  

	   	  	 	  $this->msg =$close_msg." ".$this->functions->prettyDate($delivery_date);

	   	  	    }	
    			$this->output();	
    		}
    	}
    	    	
    	/*CHECK DELIVERY TIME PAST*/
    	if(!empty($delivery_date) && !empty($delivery_time)){
    		$time_1=date('Y-m-d g:i:s a');
    		$time_2="$delivery_date $delivery_time";
    		$time_2=date("Y-m-d g:i:s a",strtotime($time_2));
    		$time_diff=$this->functions->dateDifference($time_2,$time_1);    		    		
    		if (is_array($time_diff) && count($time_diff)>=1){
    			if ( $time_diff['hours']>0){	       	  	     	
	       	  	     $this->msg= $this->mobileWrapper->timePastByTransaction($transaction_type);
	       	  	     $this->output(); 	  	     	
       	  	     }	       	  	
       	  	     if ( $time_diff['minutes']>0){	       	  	     	
	       	  	     $this->msg= $this->mobileWrapper->timePastByTransaction($transaction_type);
	       	  	     $this->output();  	  	     	
       	  	     }	       	  	
    		}
    	}        	    	
    	   	
    	if($res=$this->mobileWrapper->getCart($this->device_uiid)){
    		$cart=json_decode($res['cart'],true);
    		$card_fee = 0; $card_percentage=0;

    
    		
    		//echo $card_fee;die();
    		
    		$data = array(
			  'delivery_type'=>$transaction_type,
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>$card_fee,
			);
			if($card_percentage>0){
			   $data['card_percentage']=$card_percentage;
			}    
			
			$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
			if(is_array($voucher_details) && count($voucher_details)>=1){
				$data['voucher_name']=$voucher_details['voucher_name'];
				$data['voucher_amount']=$voucher_details['amount'];
				$data['voucher_type']=$voucher_details['voucher_type'];
			}
			
			if($res['tips']>0.0001){
				$data['cart_tip_percentage']=$res['tips'];
				$data['tip_enabled']=2;
				$data['tip_percent']=$res['tips'];
			}		
			
			/*POINTS*/
			if($res['points_amount']>0.0001){
				$data['points_amount']=$res['points_amount'];
			}								
			//dump($data);die();
			
			/*DELIVERY FEE*/
			unset($_SESSION['shipping_fee']);
			if($res['delivery_fee']>0.0001){
				$data['delivery_charge']=$res['delivery_fee'];
			}
			
			

		    $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );

			$code = $displayOrderHTML['code'];
			$msg  = $displayOrderHTML['msg'];

		    if ($code==1){
		    	
		    	$raw = $displayOrderHTML['raw'];
		    	//dump($raw['total']['card_fee']);
		    	
		        /*EURO TAX*/
			    $is_apply_tax = 0;
			    if($this->functions->isApplyTax($this->merchant_id)){
			   	   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
			   	   $raw['total']=$new_total;			
			   	   $is_apply_tax=1;   	   
			    }
			    /*EURO TAX*/		
			    
			    $donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
				if(empty($donot_apply_tax_delivery)){
					$donot_apply_tax_delivery=1;
				}
				
						/*CARD FEE*/
    		
				
				
				
				if($card_percentage>0){
					$card_fee = (float) $raw['total']['card_fee'];
				}
				
				
				switch ($payment_provider) {
    			
    				
    			case "paypal_v2":	
    			    if($credentials = $this->functions->getCredentials_paypal($this->merchant_id)){
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                              //$card_fee=$credentials['card_fee'];
                              $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                          }
                       }
                    }  
    			   break;
    			   
    			case "stp":	
    			    if($credentials = $this->functions->getCredentials_stripe($this->merchant_id)){
    			        //print_r($credentials);die();
    			        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                            
                          }
                       }
                    }  
    			   break;  


    			   case "windcave":	
    			    if($credentials = $this->functions->getCredentials_windcave($this->merchant_id)){
    			        //print_r($credentials);die();
    			        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                            
                          }
                       }
                    }  
    			   break;    

    			   
    			       		        			      
    			default:
    				break;
    		}
				
				
				$params = array(
				  'merchant_id'=>$this->merchant_id,				  
				  'client_id'=>$client_id,
				  'json_details'=>$res['cart'],
				  'trans_type'=>$transaction_type,
				  'payment_type'=>$this->data['payment_provider'],
				  'sub_total'=>$raw['total']['subtotal'],
				  'tax'=>$raw['total']['tax'],
				  'taxable_total'=>$raw['total']['taxable_total'],
				  'total_w_tax'=>isset($raw['total']['total'])?($raw['total']['total']+$card_fee):0,
				  'delivery_charge'=>isset($raw['total']['delivery_charges'])?$raw['total']['delivery_charges']:0,
				  'delivery_date'=>$delivery_date,
				  'delivery_time'=>$delivery_time,
				  'delivery_asap'=>isset($this->data['delivery_asap'])?$this->data['delivery_asap']:'',
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR'],
				  'delivery_instruction'=>isset($res['delivery_instruction'])?$res['delivery_instruction']:'',
				  'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',
				  'order_change'=>isset($this->data['order_change'])?$this->data['order_change']:0,
				  'payment_provider_name'=>'',
				  'card_fee'=>$card_fee,
				  'packaging'=>$raw['total']['merchant_packaging_charge'],
				  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
				  'order_id_token'=>$this->functions->generateOrderToken(),
				  'request_from'=>"mobileapp2",
				  'apply_food_tax'=>$is_apply_tax,				  
				);
				
				
				

				$order_id_token = $params['order_id_token'];
				
				/*TIPS*/
				if(isset($raw['total']['tips'])){
					if($raw['total']['tips']>0.0001){
						$params['cart_tip_percentage']= $raw['total']['cart_tip_percentage'];
						$params['cart_tip_value']= $raw['total']['tips'];
					}				
				}	
				
				switch ($transaction_type) {
					case "dinein":
						$params['dinein_number_of_guest'] = isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
						$params['dinein_special_instruction'] = isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
						
						$params['dinein_table_number'] = isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:'';
												
						$contact_phone = isset($this->data['contact_phone'])?$this->data['contact_phone']:'';
						if(!empty($contact_phone)){
						     $this->functions->updateData("mt_client",array(
							 'contact_phone'=>$contact_phone
							),'client_id', (integer)$client_id);
						}										
						break;
						
					case "pickup":
						$pickup_contact = isset($this->data['pickup_contact'])?$this->data['pickup_contact']:'';
						if(!empty($pickup_contact)){
							$this->functions->updateData("mt_client",array(
							 'contact_phone'=>$pickup_contact
							),'client_id', (integer)$client_id);
						}						
						break;
						
					case "delivery":
						$delivery_asap = '';
						if(isset($this->data['delivery_asap'])){
							$delivery_asap = $this->data['delivery_asap']=="true"?1:'';
							$params['delivery_asap'] = $delivery_asap;
						}
						break;
				
					default:
						break;
				}
					
				
				/*DEFAULT ORDER STATUS*/				
				$default_order_status=$this->functions->getOption('default_order_status',$this->merchant_id);										
				switch ($payment_provider) {								
					case "cod":
					case "obd":
						$params['status'] =!empty($default_order_status)?$default_order_status:'pending';
						break;
					case "ccr":
					case "ocr":
						 $params['cc_id'] = isset($this->data['cc_id'])?$this->data['cc_id']:'';	
						 $params['status']= !empty($default_order_status)?$default_order_status:'pending';
						 break;
								
					case "pyr":	 		 
					     $params['payment_provider_name'] = isset($this->data['selected_card'])?$this->data['selected_card']:'';	
						 $params['status']= !empty($default_order_status)?$default_order_status:'pending';
						 break;
						 
					default:			
					    $params['status']=$this->functions->initialStatus();
						break;
				}
				
				/*PROMO*/	    				
				//dump($raw);
				if (isset($raw['total']['discounted_amount'])){
    				if ($raw['total']['discounted_amount']>=0.0001){	    					
    				    $params['discounted_amount']=$raw['total']['discounted_amount'];
    				    $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
    				}
				}
				
				/*VOUCHER*/
				if(!empty($res['voucher_details'])){
					$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
					if(is_array($voucher_details) && count($voucher_details)>=1){
						$params['voucher_amount']=$voucher_details['amount'];
			         	$params['voucher_code']=$voucher_details['voucher_name'];
			         	$params['voucher_type']=$voucher_details['voucher_type'];
					}
				}
				
				/*POINTS*/
				if($res['points_amount']>0.0001){
					$params['points_discount']=$res['points_amount'];
				}	
				
				/*SET COMMISSION*/
				if ( $this->functions->isMerchantCommission($this->merchant_id)){
					$admin_commision_ontop=$this->functions->getOptionAdmin('admin_commision_ontop');
					if ( $com=$this->functions->getMerchantCommission($this->merchant_id)){
	            		$params['percent_commision']=$com;			            		
	            		//$params['total_commission']=($com/100)*$params['total_w_tax'];

	            		$params['total_commission']=($com/100)*($params['total_w_tax']-$card_fee);

	            		//$params['merchant_earnings']=$params['total_w_tax']-$params['total_commission'];
	            		$params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
	            		if ( $admin_commision_ontop==1){
	            			$params['total_commission']=($com/100)*$params['sub_total'];
	            			$params['commision_ontop']=$admin_commision_ontop;			            		
	            			$params['merchant_earnings']=$params['sub_total']-$params['total_commission'];
	            		}
	            	}	
	            	
	            	/** check if merchant commission is fixed  */
			        $merchant_com_details=$this->functions->getMerchantCommissionDetails($this->merchant_id);	
			        if ( $merchant_com_details['commision_type']=="fixed"){
	            		$params['percent_commision']=$merchant_com_details['percent_commision'];
	            		$params['total_commission']=$merchant_com_details['percent_commision'];
	            		$params['merchant_earnings']=$params['total_w_tax']-$merchant_com_details['percent_commision'];
	            		$params['commision_type']='fixed';
	            		
	            		if ( $admin_commision_ontop==1){			            		
	            		    $params['merchant_earnings']=$params['sub_total']-$merchant_com_details['percent_commision'];
	            		}
	            	} 
				}
				/*END COMMISSION*/
				
				if(!is_numeric($params['cc_id'])){
					unset($params['cc_id']);
				}
				if(!is_numeric($params['order_change'])){
					unset($params['order_change']);
				}
				
				/*BEGIN INSERT ORDER*/				
				if(!is_numeric($params['sub_total'])){
					$params['sub_total']=0;
				}			
				if(!is_numeric($params['tax'])){
					$params['tax']=0;
				}			
				if(!is_numeric($params['taxable_total'])){
					$params['taxable_total']=0;
				}			
				if(!is_numeric($params['total_w_tax'])){
					$params['total_w_tax']=0;
				}
				
				if(isset($params['order_change'])){
					if(!is_numeric($params['order_change'])){
						$params['order_change']=0;
					}			
				}
				if(!is_numeric($params['card_fee'])){
					$params['card_fee']=0;
				}			
				if(!is_numeric($params['packaging'])){
					$params['packaging']=0;
				}			
				if(!is_numeric($params['donot_apply_tax_delivery'])){
					unset($params['donot_apply_tax_delivery']);
				}			
				if(!is_numeric($params['apply_food_tax'])){
					unset($params['apply_food_tax']);
				}			
				
				if(isset($params['percent_commision'])){
					if(!is_numeric($params['percent_commision'])){
						$params['percent_commision']=0;
					}			
				}
				
				if(isset($params['total_commission'])){
					if(!is_numeric($params['total_commission'])){
						$params['total_commission']=0;
					}			
				}
				
				if(isset($params['merchant_earnings'])){
					if(!is_numeric($params['merchant_earnings'])){
						$params['merchant_earnings']=0;
					}			
				}		
				
				$last_insert_id = $this->functions->insertData('mt_order', $params);
                if ($last_insert_id!== false){			
					$order_id=$last_insert_id;
										
					$params_history=array(
    				  'order_id'=>$order_id,
    				  'status'=>$this->functions->initialStatus(),    	
    				  'remarks'=>'',
    				  'date_created'=>$this->functions->dateNow(),
    				  'ip_address'=>$_SERVER['REMOTE_ADDR']
    				);    				
    				
					$this->functions->insertData('mt_order_history', $params_history);
					$next_step = "receipt";
					
					/*SAVE ITEM */					
					foreach ($raw['item'] as $val) {								
						$params_order_details=array(
						  'order_id'=>isset($order_id)?$order_id:'',
						  'client_id'=>$client_id,
						  'item_id'=>isset($val['item_id'])?$val['item_id']:'',
						  'item_name'=>isset($val['item_name'])?$val['item_name']:'',
						  'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
						  'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
						  'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
						  'size'=>isset($val['size_words'])?$val['size_words']:'',
						  'qty'=>isset($val['qty'])?$val['qty']:'',		    					  
						  'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
						  'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
						  'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
						  'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
						);
						/*inventory*/
						$new_fields=array('size_id'=>"size_id");
                        if ( $this->functions->checkTableFields('order_details',$new_fields)){
                        	$params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
                        	$params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
                        }												
						
						$this->functions->insertData('mt_order_details', $params_order_details);						
						/*inventory*/
    					if ($this->functions->checkIfTableExist('order_details_addon')){
	    					if(isset($val['sub_item'])){
		    					if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
		    						foreach ($val['sub_item'] as $sub_item_data) {


		    							

		    							$this->functions->insertData('mt_order_details_addon', array(
		    							  'order_id'=>(integer)$order_id,
		    							  'subcat_id'=>(integer)$sub_item_data['subcat_id'],
		    							  'sub_item_id'=>(integer)$sub_item_data['sub_item_id'],
		    							  'addon_price'=>(float)$sub_item_data['addon_price'],
		    							  'addon_qty'=>(float)$sub_item_data['addon_qty'],
		    							));





		    						}
		    					}		    				
	    					}
    					}
    					
					}
					
					$params_address = array();
					
					/*SAVE DELIVERY ADDRESS*/
					if ($transaction_type=="delivery"){						
						$params_address=array(	    				  
	    				  'street'=>isset($res['street'])?$res['street']:'',
	    				  'city'=>isset($res['city'])?$res['city']:'',
	    				  'state'=>isset($res['state'])?$res['state']:'',
	    				  'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
	    				  'location_name'=>isset($res['location_name'])?$res['location_name']:'',
	    				  'contact_phone'=>isset($res['contact_phone'])?$res['contact_phone']:'',
	    				  'country'=>isset($res['country_code'])?$res['country_code']:'',
	    				  'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
	    				  'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
	    				  'opt_contact_delivery'=>isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0
	    				);		    					    				
					} elseif ( $transaction_type=="pickup"){
						$params_address = array(						  
	    				  'contact_phone'=>isset($this->data['pickup_contact'])?$this->data['pickup_contact']:''	    				  
						);
					} elseif ( $transaction_type=="dinein"){
						$params_address = array(						  
	    				  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
	    				  'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
	    				  'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
	    				  'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
						);
					}
										
	    		    $params_address['order_id'] = (integer)$order_id;
	    		    $params_address['client_id'] = (integer)$client_id;
					$params_address['first_name'] = $customer_first_name;
					$params_address['last_name'] = $customer_last_name;
					$params_address['contact_email'] = $customer_email;
					$params_address['date_created'] = $this->functions->dateNow();
					$params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
					 					
					
					$this->functions->insertData('mt_order_delivery_address', $params_address);
					
					/*SAVE ADDRESS*/			
					if(isset($res['save_address'])){									
					if($res['save_address']==1){  	
						if($search_mode=="location"){							
							if( !$this->LocationWrapper->isAddressBookExist(
							   $client_id,
							   isset($res['street'])?$res['street']:'',
							   $res['state_id'],
							   $res['city_id'],
							   $res['area_id']
							)){
								$params_address_book=array(
								  'client_id'=>$client_id,
								  'street'=>$res['street'],
								  'location_name'=>$res['location_name'],
								  'state_id'=>$res['state_id'],
								  'city_id'=>$res['city_id'],
								  'area_id'=>$res['area_id'],
								  'date_created'=>$this->functions->dateNow(),
							      'latitude'=>$res['delivery_lat'],
								  'longitude'=>$res['delivery_long'],
								  'ip_address'=>$_SERVER['REMOTE_ADDR']
								);																
								
								$this->functions->insertData('mt_address_book_location', $params_address_book);
							}							
						} else {
							if (!$this->mobileWrapper->getBookAddress($client_id,$res['street'],$res['city'],$res['state'])){
								$params_address_book = array(
								  'client_id'=>$client_id,
								  'street'=>$res['street'],
								  'city'=>$res['city'],
								  'state'=>$res['state'],
								  'zipcode'=>$res['zipcode'],
								  'location_name'=>$res['location_name'],
								  'country_code'=>$this->functions->getOptionAdmin('admin_country_set'),
								  'as_default'=>1,
								  'date_created'=>$this->functions->dateNow(),
								  'latitude'=>$res['delivery_lat'],
								  'longitude'=>$res['delivery_long'],
								  'ip_address'=>$_SERVER['REMOTE_ADDR']
								);															
								
								$this->functions->insertData('mt_address_book', $params_address_book);
							} //else echo 'd1';
						}
					} //else echo 'd2';
					} //else echo 'd3';
										
					$this->code = 1;
				    $this->msg = "Your order has been placed. Reference #".$order_id;
					
					$provider_credentials=array();
					$redirect_url='';
					
					/*SAVE POINTS*/
					switch ($payment_provider) {
						/*case "cod":
						case "ccr":
					    case "ocr":				
					    case "pyr":
					    case "obd":
					    break;*/
					    
					    default:					    	
					    	$this->mobileWrapper->savePoints(
					    	  $this->device_uiid,
					    	  $client_id,
					    	  $this->merchant_id,
					    	  $order_id,
					    	  'initial_order'
					    	);
					    	break;
					}
					
					
					/*PAYMENT DATA*/
					switch ($payment_provider) {
						case "cod":
						case "ccr":
					    case "ocr":				
					    case "pyr":	 

					    $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);  
                        if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                        $params_update_order=array( 
                      
                       
                        'order_number'=>$order_number, 
                      
                        );    

                    
                      $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id);  

					    					          					          					         
					          $this->mobileWrapper->sendNotification($order_id);	
					          $this->mobileWrapper->clearCartByCustomerID($client_id);
					          $this->mobileWrapper->executeAddons($order_id);
					          
							  break;	
							  
					    
					    	  
					    
					    	
					    case "paypal_v2":	
					       $next_step='init_webview';
					       

					       $redirect_url = $this->functions->websiteUrl()."/mobileappv2/paypal?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;
					       
					    case "stp":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/mobileappv2/stripe?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;  

					       case "poli":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/mobileappv2/poli?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;


					       case "windcave":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/mobileappv2/windcave?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;    
					       
					    
					       
					         
					       					       					    			    					    
					         
					    
					    
						default:						
						    $next_step = "init_".$payment_provider;
							break;
					}
					
				    $client_info = array( 
				      'first_name'=>$client_info['first_name'],
				      'last_name'=>$client_info['last_name'],
				      'email_address'=>$client_info['email_address'],
				      'contact_phone'=>$client_info['contact_phone'],				      
				    );
				    
				    /*$payment_description = Yii::t("mobile2","Payment to merchant [merchant_name]",array(
				      '[merchant_name]'=>clearString($merchant_info['restaurant_name'])
				    ));*/
				    
				    

					$payment_description = "Payment to merchant ".$this->functions->clearString($merchant_info['restaurant_name'])." Order ID#".$order_id;
				    
				    $total = number_format($params['total_w_tax'],2,'.','');
				    
				    $this->details=array(
				      'order_id'=>$order_id,
				      'total_amount'=>$params['total_w_tax'],
				      'total_amount_by_100'=>$total*100,
				      'total_amount_formatted'=>$total,
				      'card_fee'=>(float)$params['card_fee'],
				      'sub_less_card_fee'=>(float)$params['total_w_tax']-(float)$params['card_fee'],
				      'payment_provider'=>$payment_provider,
				      'next_step'=>$next_step,
				      'currency_code'=>$this->functions->getCurrencyCode(),
				      'payment_description'=>$payment_description,
				      'merchant_name'=>$this->functions->clearString($merchant_info['restaurant_name']),
				      'provider_credentials'=>$provider_credentials,
				      'redirect_url'=>$redirect_url,
				      'client_info'=>$client_info
				    );
				    
				} else $this->msg = "Something went wrong cannot insert records. please try again later";
		    	
		    } else $this->msg = $msg;
    		   		
    	} else $this->msg = "Cart is empty";    	
    	
		$this->output();
	}


	public function verifyCustomerToken()
	{		
		$user_token = isset($this->data['user_token'])?$this->data['user_token']:'';
		$action = isset($this->data['action'])?$this->data['action']:'';
		if($res = $this->mobileWrapper->getCustomerByToken($user_token)){		
										
			$email_address = $res['email_address'];
			$contact_phone = $res['contact_phone'];
					
			if ($this->mobileWrapper->checkBlockAccount($email_address,$contact_phone)){
				$this->msg = "account blocked";
				$this->details=array(
				  'action'=>$action,
				  'social_strategy'=>$res['social_strategy']
				);			
				$this->output();
			}
						
			$this->data['client_id'] = $res['client_id'];			
			$this->mobileWrapper->registeredDevice($this->data);	
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details=array(
			  'action'=>$action,
			  'social_strategy'=>$res['social_strategy']
			);			
		} else {
		    $this->msg = "invalid token";	
		    $this->details=array(
			  'action'=>$action,			  
			);			
		}
		$this->output();
	}


	public function GetAddressFromCart()
	{	
		$country_list = $this->functions->CountryList();
		$default_country_code = $this->functions->getOptionAdmin('admin_country_set');
		
		$customer_phone = '';
		if($client = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$customer_phone=$client['contact_phone'];
		}
			
		if($resp=$this->mobileWrapper->getCart($this->device_uiid)){			
			$this->code = 1;
			$this->msg = "OK";
			
			$lat = isset($this->data['lat'])?$this->data['lat']:'';
			$lng = isset($this->data['lng'])?$this->data['lng']:'';
			
			if(empty($resp['street']) && empty($resp['city']) && !empty($lat) && !empty($lng) ){
				if ( $res_location = $this->mobileWrapper->getRecentLocation($this->device_uiid,$lat,$lng)){					
				    $resp['street'] = $res_location['street'];
				    $resp['city'] = $res_location['city'];
				    $resp['state'] = $res_location['state'];
				    $resp['zipcode'] = $res_location['zipcode'];
				    $resp['location_name'] = $res_location['location_name'];
				    $resp['delivery_lat'] = $res_location['latitude'];
				    $resp['delivery_long'] = $res_location['longitude'];
				}
			}	
			
			if(empty($resp['contact_phone'])){
				if(!empty($customer_phone)){
				   	$resp['contact_phone']=$customer_phone;
				}
			}	
						
			$this->details = array(
			  'street'=>$resp['street'],
			  'city'=>$resp['city'],
			  'state'=>$resp['state'],
			  'zipcode'=>$resp['zipcode'],
			  'delivery_instruction'=>$resp['delivery_instruction'],
			  'location_name'=>$resp['location_name'],
			  'contact_phone'=>$resp['contact_phone'],
			  'country_code'=>!empty($resp['country_code'])?$resp['country_code']:$default_country_code,
			  'delivery_lat'=>$resp['delivery_lat'],
			  'delivery_long'=>$resp['delivery_long'],
			  'save_address'=>$resp['save_address'],
			  'customer_phone'=>$customer_phone,
			  'country_list'=>$country_list
			);
			
		} else {
			$this->msg = "cart not available";
			$this->details = array(
			  'customer_phone'=>$customer_phone,
			  'country_code'=>!empty($resp['country_code'])?$resp['country_code']:$default_country_code,
			  'country_list'=>$country_list
			);
		}
		$this->output();
	}

	public function setAddressBook()
	{
		$addressbook_id = isset($this->data['addressbook_id'])?$this->data['addressbook_id']:'';		
		if($addressbook_id>0){
			if ( $res = $this->functions->getAddressBookByID($addressbook_id)){								
				
				if(empty($res['latitude']) && empty($res['latitude'])){
					$this->msg = "This address book has no latitude and longitude. update your address book under your account.";
					$this->output();
				}
				
				$this->data['country']= $res['country_code'];
				$this->data['country_code']= $res['country_code'];
				$this->data['street']= $res['street'];
				$this->data['city']= $res['city'];
				$this->data['state']= $res['state'];
				$this->data['zipcode']= $res['zipcode'];
				$this->data['save_address']= '';
				$this->data['location_name']= $res['location_name'];				
				$this->data['lat']= $res['latitude'];
				$this->data['lng']= $res['longitude'];

				$this->setDeliveryAddress();
				
			} else $this->msg = "Address not available. please try again later";
		} else $this->msg = "Invalid address book id";
		$this->output();
	}


	public function OrderList()
{		
    if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }			
    $client_id = $res['client_id'];		
    
    $pagelimit = $this->mobileWrapper->paginateLimit();		
    $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

    $paginate_total=0; 
    $limit="LIMIT $page, $pagelimit"; 
    
    $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');		
    $website_review_type = $this->functions->getOptionAdmin('website_review_type');
    $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status');	
    $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

    if($website_review_type == 1){
        $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
    }	
    
    $date_now = date('Y-m-d g:i:s a');	 
    
    $tab = isset($this->data['tab']) ? $this->data['tab'] : '';	



    $and = $this->mobileWrapper->getOrderTabsStatus($tab);
    
     

//AND a.status IN ('paid', 'pending')
   
    
    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.order_id,
    a.client_id,
    a.merchant_id,
    a.trans_type,
    a.payment_type,
    a.date_created,
    a.date_created as date_created_raw,
    a.total_w_tax,
    a.status,
    a.status as status_raw,		
    a.request_cancel,
    a.order_locked,
    a.request_cancel_status,
    b.restaurant_name as merchant_name,
    b.logo,
    (
        SELECT rating FROM mt_review
        WHERE order_id = a.order_id
        AND status = 'publish'		
        LIMIT 1
    ) as rating
    FROM mt_order a
    LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
    WHERE a.client_id = :client_id
    AND a.status NOT IN ('initial_order')
    $and 
    ORDER BY a.order_id DESC
    $limit
    ";
  


    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->execute();
    
    if($res = $query->fetchAll(PDO::FETCH_ASSOC)){
        $total_records = 0;			
        
        $countQuery = $this->db->query("SELECT FOUND_ROWS() as total_records");
        if($resp = $countQuery->fetch(PDO::FETCH_ASSOC)){	
            $total_records = $resp['total_records'];
        }					

        $paginate_total = ceil($total_records / $pagelimit);
        
        $data = array();
        foreach ($res as $val) {		
            $val['merchant_name'] = $this->functions->clearString($val['merchant_name']);
            $val['status'] = $val['status'];

            $val['transaction'] = $val['trans_type'] . " " . $val['order_id'];

            $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
            $val['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);

            $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);

            $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
            
            $add_review = false;		
            if($this->mobileWrapper->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)){
                $add_review = true;
            }				

            if($add_review){		
                if ($val['client_id'] == $client_id){		    		
                    $date_diff = $this->functions->dateDifference(
                        date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                        $date_now
                    );
                    if(is_array($date_diff) && count($date_diff) >= 1){
                        if ($date_diff['days'] >= 5){
                            $add_review = false;
                        }
                    }	    	
                } else {
                    $add_review = false;
                }
            }
            
            if($website_review_type == 1){
                if($val['rating'] > 0){
                    if($merchant_can_edit_reviews == "yes"){
                        $add_review = false;
                    }
                }				
            }

            $val['add_review'] = $add_review;

            $show_cancel = false;
            $cancel_status = '';
            if($this->functions->canCancelOrderNew($val['request_cancel'], $val['date_created_raw'], $val['status_raw'], $val['order_locked'], $val['request_cancel_status'], $cancel_order_enabled)){
                if($val['request_cancel'] == 1){
                    $cancel_status = "Pending for review";
                } else {
                    $show_cancel = true;
                }									
            }	

            if ($val['request_cancel_status'] != 'pending'){					
                $cancel_status = "Request cancel " . $val['request_cancel_status'];
            }		

            $val['add_cancel'] = $show_cancel;
            $val['cancel_status'] = $cancel_status;

            $val['add_track'] = true;
            
            $data[] = $val;
        }
        
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array( 
            'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
            'paginate_total' => $paginate_total,
            'data' => $data
        );
        
    } else {
        $msg1 = "Your order list is empty";
        $msg2 = "Make your first order";

        switch ($tab) {
            case "processing":		
                $msg1 = "There is no processing order";			        
                break;
        
            case "completed":			
                $msg1 = "There is no completed order";	
                break;
                
            case "cancelled":				
                $msg1 = "There is no cancelled order";	
                break;
                        
            default:
                break;
        }
        
        $this->code = 6;
        $this->msg = $msg1;
        $this->details = array(
            'element' => ".order_loader",
            'element_list' => "#order_list_item",
            'message' => $msg2
        );
    }
    
    $this->output();
}

public function checkRunTrackHistory_bkedup()
	{
		$run_track = true;
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:'';
		if($order_id>0){
			if($res = mobileWrapper::getDriverTask($order_id)){
				
				switch ($res['status']) {
					case "successful":
					case "failed":
					case "cancelled":
					case "declined":	
					    $run_track = false;
						break;
					default:
						break;
				}
				
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'run_track'=>$run_track
				);
			} else $this->msg = "invalid order id not found";
		} else $this->msg = "invalid order id";
		$this->output();
	}

	public function checkRunTrackHistory()
	{
		$run_track = true;

		$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'run_track'=>$run_track
				);
		$this->output();

		
	}





public function BookingList()
{				
    if (!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])) {
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }			
    
    $client_id = $res['client_id'];		
    
    $pagelimit = $this->mobileWrapper->paginateLimit();		
    $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0; 

    $paginate_total = 0; 
    $limit = "LIMIT $page, $pagelimit"; 
    
    $and = '';
    $tab = isset($this->data['tab']) ? $this->data['tab'] : '';		        
    switch ($tab) {        	
        case "all":
            break;
        default:
            $and = " AND a.status = :tab ";
            break;
    }
    
    $booking_cancel_days = $this->functions->getOptionAdmin('booking_cancel_days');
    $booking_cancel_hours = $this->functions->getOptionAdmin('booking_cancel_hours');
    $booking_cancel_minutes = $this->functions->getOptionAdmin('booking_cancel_minutes');
                 
    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.booking_id,
    a.merchant_id,
    a.number_guest,
    a.status,
    a.status as status_raw,
    a.date_created,
    a.date_created as date_created_raw,
    a.request_cancel,
    b.restaurant_name as merchant_name,
    b.logo
    FROM mt_bookingtable a
    LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
    WHERE a.client_id = :client_id
    $and
    ORDER BY a.booking_id DESC
    $limit
    ";					
    
    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        if (!empty($tab) && $tab !== "all") {
            $query->bindParam(':tab', $tab, PDO::PARAM_STR);
        }
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        
        if ($res) {
            $total_records = 0;
            $queryTotal = $this->db->query("SELECT FOUND_ROWS() as total_records");
            if ($resp = $queryTotal->fetch(PDO::FETCH_ASSOC)) {
                $total_records = $resp['total_records'];
            }
            $paginate_total = ceil($total_records / $pagelimit);
            
            $data = array();
            foreach ($res as $val) {		
                $val['status'] = $val['status'];
                
                if ($val['status_raw'] == "request_cancel_booking") {
                    $val['status'] = "Request cancel";
                } elseif ($val['status_raw'] == "cancel_booking_approved") {
                    $val['status'] = "Cancel approved";
                }			
                
                $val['number_guest'] = "No. of guest " . $val['number_guest'];
                $val['booking_ref'] = "Booking ID# " . $val['booking_id'];
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                
                $ratings = $this->functions->getRatings($val['merchant_id']);
                $ratings['review_count'] = $ratings['votes'] . " reviews";
                $val['rating'] = $ratings;

                $val['can_cancel'] = 0;
                $can_cancel = $this->mobileWrapper->canCancel($val['date_created_raw'], $booking_cancel_days, $booking_cancel_hours, $booking_cancel_minutes);
                if ($can_cancel) {
                    if ($val['request_cancel'] <= 0) {
                        $val['can_cancel'] = ($val['status_raw'] == 'pending') ? 'cancel_booking' : 'cancel_booking_request_sent';
                    }
                } else {
                    if ($val['request_cancel'] > 0) {
                        $val['can_cancel'] = 'cancel_booking_request_sent';
                    }
                }	 			 			
                
                $data[] = $val;
            }
            
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array( 
                'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                'paginate_total' => $paginate_total,
                'data' => $data
            );
            
        } else {
            $msg1 = "Your booking list is empty";
            $msg2 = "Make your first booking";
            if ($tab == "pending") {
                $msg1 = "You have no pending booking";
            } elseif ($tab == "approved") {
                $msg1 = "You have no approved booking";
            } elseif ($tab == "denied") {
                $msg1 = "You have no denied booking";
            }
            
            $this->code = 6;
            $this->msg = $msg1;
            $this->details = array(
                'element' => ".booking_loader",
                'element_list' => "#booking_history_item",
                'message' => $msg2
            );
        }
        
    } catch (PDOException $e) {
        $this->code = 6;
        $this->msg = "Database error: " . $e->getMessage();
    }
    
    $this->output();
}


public function FavoriteList()
{						
	if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
		$this->code = 3;
		$this->msg = "token not found";
		$this->output();
	}			
	$client_id = $res['client_id'];		

	$pagelimit = $this->mobileWrapper->paginateLimit();		
	if (isset($this->data['page'])){
		$page = $this->data['page'] * $pagelimit;
	} else  $page = 0; 

	$paginate_total = 0; 
	$limit = "LIMIT $page, $pagelimit"; 

	$stmt = "
	SELECT SQL_CALC_FOUND_ROWS 
	a.id,
	a.merchant_id,
	a.client_id,
	a.date_created,
	b.restaurant_name as merchant_name,
	b.logo
	
	FROM
	mt_favorites a
	LEFT JOIN mt_merchant b
	ON a.merchant_id = b.merchant_id
	
	WHERE a.client_id = :client_id
	
	ORDER BY a.id DESC
	$limit
	";					
	
	$query = $this->db->prepare($stmt);
	$query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
	$query->execute();
	$res = $query->fetchAll(PDO::FETCH_ASSOC);
	
	if ($res) {
		$total_records = 0;
		$stmtc = "SELECT FOUND_ROWS() as total_records";
		$queryc = $this->db->prepare($stmtc);
		$queryc->execute();
		$resp = $queryc->fetch(PDO::FETCH_ASSOC);
		
		if ($resp) {
			$total_records = $resp['total_records'];
		}					
		$paginate_total = ceil($total_records / $pagelimit);
		
		$data = array();
		foreach ($res as $val) {										
			$date_added = $this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']);

			$val['date_added'] = "Added ".$date_added;
			$val['logo'] = $this->mobileWrapper->getImage($val['logo']);
			
			$ratings = $this->functions->getRatings($val['merchant_id']);
			$ratings['review_count'] = $ratings['votes']." reviews";
			$val['rating'] = $ratings;
			
			$val['background_url'] = $this->mobileWrapper->getMerchantBackground($val['merchant_id'], 'resto_banner.jpg');
			$val['merchant_name'] = $this->functions->clearString($val['merchant_name']);
			
			$data[] = $val;
		}
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array( 
			'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
			'paginate_total' => $paginate_total,
			'data' => $data
		);
		
	} else {				
		$this->code = 6;
		$this->msg = "Your favorite list is empty";
							
		$this->details = array(
			'element' => ".favorite_loader",
			'element_list' => "#favorite_list_item",
			'message' => "Add your favorite restaurant"
		);
	}
	
	$this->output();
}


 public function CrediCartList()
{				
	if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
		$this->code = 3;
		$this->msg = "token not found";
		$this->output();
	}			
	$client_id = $res['client_id'];		

	$pagelimit = $this->mobileWrapper->paginateLimit();		
	if (isset($this->data['page'])){
		$page = $this->data['page'] * $pagelimit;
	} else {
		$page = 0;
	}

	$paginate_total = 0; 
	$limit = "LIMIT $page, $pagelimit"; 
	
	$stmt = "
	SELECT SQL_CALC_FOUND_ROWS 
	a.cc_id as id,
	a.card_name,
	a.credit_card_number,
	a.date_created		
	FROM mt_client_cc a
	WHERE a.client_id = :client_id
	ORDER BY a.cc_id DESC
	$limit
	";					
	
	$query = $this->db->prepare($stmt);
	$query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
	$query->execute();
	$res = $query->fetchAll(PDO::FETCH_ASSOC);
	
	if ($res) {
		$total_records = 0;
		$stmtc = "SELECT FOUND_ROWS() as total_records";
		$queryc = $this->db->prepare($stmtc);
		$queryc->execute();
		$resp = $queryc->fetch(PDO::FETCH_ASSOC);
		
		if ($resp) {
			$total_records = $resp['total_records'];
		}					
		$paginate_total = ceil($total_records / $pagelimit);
		
		$data = array();
		foreach ($res as $val) {	
			$date_added = $this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']);
			$val['date_added'] = "Added ".$date_added;	
			$val['date_created'] = $date_added;
			$data[] = $val;
		}
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array( 
			'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
			'paginate_total' => $paginate_total,
			'data' => $data
		);
		
	} else {						
		$this->code = 6;
		$this->msg = "Your credit card list is empty";
							
		$this->details = array(
			'element' => ".creditcard_loader",
			'element_list' => "#creditcard_list_item",
			'message' => "Add your first credit card"
		);
	}

	$this->output();
}


public function AddressBookList()
{				
	if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
		$this->code = 3;
		$this->msg = "token not found";
		$this->output();
	}			
	$client_id = $res['client_id'];		

	$search_resp = $this->mobileWrapper->searchMode();
	$search_mode = $search_resp['search_mode'];

	$pagelimit = $this->mobileWrapper->paginateLimit();		
	if (isset($this->data['page'])){
		$page = $this->data['page'] * $pagelimit;
	} else {
		$page = 0;
	}

	$paginate_total = 0; 
	$limit = "LIMIT $page, $pagelimit"; 
	
	if ($search_mode == "location") {
		$stmt = "
		SELECT SQL_CALC_FOUND_ROWS 
		a.id,
		a.as_default,			
		a.date_created,
		concat(a.street,' ',d.name,' ',c.name,' ',b.name) as address			
		FROM mt_address_book_location a

		LEFT JOIN mt_location_states b ON a.state_id = b.state_id
		LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
		LEFT JOIN mt_location_area d ON a.area_id = d.area_id
		    
		WHERE a.client_id = :client_id
		AND a.street <> ''
		ORDER BY a.id DESC
		$limit
		";
	} else {
		$stmt = "
		SELECT SQL_CALC_FOUND_ROWS 
		a.id,
		a.as_default,
		concat(a.street, ' ', a.city, ' ', a.state, ' ', a.zipcode) as address,
		a.date_created		
		FROM mt_address_book a
		WHERE a.client_id = :client_id
		AND a.street <> ''
		ORDER BY a.id DESC
		$limit
		";
	}

	$query = $this->db->prepare($stmt);
	$query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
	$query->execute();
	$res = $query->fetchAll(PDO::FETCH_ASSOC);

	if ($res) {
		$total_records = 0;
		$stmtc = "SELECT FOUND_ROWS() as total_records";
		$queryc = $this->db->prepare($stmtc);
		$queryc->execute();
		$resp = $queryc->fetch(PDO::FETCH_ASSOC);

		if ($resp) {
			$total_records = $resp['total_records'];
		}
		$paginate_total = ceil($total_records / $pagelimit);

		$data = array();
		foreach ($res as $val) {			
			$date_added = $this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']);
			$val['date_added'] = "Added ".$date_added;
			$val['date_created'] = $date_added;

			if ($search_mode == "location" && $val['as_default'] == 1) {
				$val['as_default'] = 2;
			}

			$data[] = $val;
		}

		$this->code = 1;
		$this->msg = "OK";
		$this->details = array( 
			'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
			'paginate_total' => $paginate_total,
			'data' => $data
		);
		
	} else {						
		$this->code = 6;
		$this->msg = "Your address book list is empty";
							
		$this->details = array(
			'element' => ".addressbook_loader",
			'element_list' => "#addressbook_list_item",
			'message' => "Add your first address"
		);
	}

	$this->output();
}

public function getlanguageList()
	{
		$data = array();
		if ($lang_list=$this->functions->getLanguageList(false) ){	
			$enabled_lang=$this->functions->getEnabledLanguage();
			foreach ($lang_list as $val) {
				if (in_array($val,(array)$enabled_lang)){
					$data[$val]=$val;
				}			
			}
			$this->code=1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'lang'=>"en",
			  'data'=>$data
			);
		} else {			
			$this->code = 6;
			$this->msg = "No available language";
								
			$this->details = array(
			   'element'=>".language_list_loader",
        	   'element_list'=>"#language_list_item",
        	   'message'=>"language not available"
			);
		}
		$this->output();
	}


	public function getOrderDetails()
{ 
    $data = array();
    $order_id = isset($this->data['order_id']) ? $this->data['order_id'] : 0;

    if ($order_id > 0) {
        if ($res = $this->mobileWrapper->orderDetails($order_id)) {
            
            $res['review_as'] = '';
            if ($client_info = $this->functions->getClientInfo($res['client_id'])) {
                $res['review_as'] = "Review as " . $client_info['first_name'];
            }  

            $this->code = 1;
            $this->msg = "ok";

            $res['logo'] = $this->mobileWrapper->getImage($res['logo']);
            $res['transaction'] = $res['trans_type'] . " #" . $res['order_id'];
            $res['payment_type'] = $this->functions->prettyPaymentTypeTrans($res['trans_type'], $res['payment_type']);
            $res['merchant_name'] = $this->functions->clearString($res['merchant_name']);

            $this->details = [
                'data' => $res
            ];
        } else {
            $this->msg = "order not found";  
        }
    } else {
        $this->msg = "invalid order id";  
    }
    $this->output();
}

public function addReview()
	{
		$this->data = $_POST;	
		
		$order_id =  isset($this->data['order_id'])?$this->data['order_id']:'';    	
		
		if(!is_numeric($this->data['rating'])){
			$this->msg = "Please select rating";
			$this->output();
		}
		if(!is_numeric($order_id)){
			$this->msg = "invalid order id";
			$this->output();
		}
		
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}
		
		$website_review_type = $this->functions->getOptionAdmin('website_review_type');				
		$order_info=$this->functions->getOrderInfo($order_id);
				
		$client_id = $res['client_id'];
		
		if($order_info){
			if ($website_review_type==2){														
					$order_id = $order_info['order_id'];
					$params = array(
					  'merchant_id'=>$order_info['merchant_id'],
					  'client_id'=>$client_id,
					  'review'=>$this->data['review'],
					  'rating'=>$this->data['rating'],
					  'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
					  'date_created'=>$this->functions->dateNow(),
					  'ip_address'=>$_SERVER['REMOTE_ADDR'],
					  'order_id'=>$order_id,  
					);
					
					   $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
				    
				    
				    //dump($params);
				    
				    if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){

				    	$last_insert_id = $this->functions->insertData('mt_review', $params);
                        if ($last_insert_id!== false){ 
				    	
				    		$review_id=$last_insert_id;

				    		
				    		
								
							$this->PointsProgram->addReviewsPerOrder($order_id,
							$client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
											
								
							
							$this->code = 1;
					        $this->msg = "Your review has been published.";
					        $this->details = array();
									
				    	} else $this->msg = "ERROR. cannot insert data.";
				    } else {
				    	$id = $res_review['id'];
				    	unset($params['date_created']);
				    	$params['date_modified'] = $this->functions->dateNow();
				    	$this->functions->updateData("mt_review",$params,'id', $id);
				    	$this->code = 1;
					    $this->msg = "Your review has been published.";
					    $this->details = array();
				    }
						    			
			} else {
				// review merchant
				$order_id = $order_info['order_id'];
				$params = array(
				  'merchant_id'=>$order_info['merchant_id'],
				  'client_id'=>$client_id,
				  'review'=>$this->data['review'],
				  'rating'=>$this->data['rating'],
				  'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR'],
				  'order_id'=>$order_id,  
				);
				$actual_purchase = $this->functions->getOptionAdmin('website_reviews_actual_purchase');				
				if($actual_purchase=="yes"){
					
					if (!$this->functions->checkIfUserCanRateMerchant($client_id,$order_info['merchant_id'])){
						$this->msg="Reviews are only accepted from actual purchases!";
					}
					if (!$this->functions->canReviewBasedOnOrder($client_id,$order_info['merchant_id'])){
		    		   $this->msg="Sorry but you can make one review per order";
		    	       return ;
		    	    }	  		   
				}
				
				if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){
					$last_insert_id = $this->functions->insertData('mt_review', $params);
                    if ($last_insert_id!== false){
			    	
			    		$review_id=$last_insert_id;
			    		
			    		
							
					$this->PointsProgram->addReviewsPerOrder($order_id,
					$client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
										
						
						
						$this->code = 1;
				        $this->msg = "Your review has been published.";
				        $this->details = array();
								
			    	} else $this->msg = "ERROR. cannot insert data.";
			    } else {
			    	$id = $res_review['id'];
			    	unset($params['date_created']);
			    	$params['date_modified'] =$this->functions->dateNow();
			    	
			    	$this->functions->updateData("mt_review",$params,'id', $id);
			    	$this->code = 1;
				    $this->msg = "Your review has been published.";
				    $this->details = array();
			    }
							
			}
		} else $this->msg = "order id not found";
		
		$this->output();
	}

	public function CancelOrder()
	{
		$this->getPOSTData();
		$this->data = $_POST;		
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];		
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
		
		if($order_id>0){
			if ($res = $this->functions->getOrderInfo($order_id)){
				if($res['client_id']== $client_id){
					
					/*CHECK IF CAN CANCEL*/								
					$cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');					
					$status = trim($res['status']);				
					if(!$this->functions->canCancelOrderNew($res['request_cancel'],$res['date_created'],$res['status'],$res['order_locked'],$res['request_cancel_status'],$cancel_order_enabled)){
					    $this->msg ="You cannot cancel this order at the moment. status has been change already to ".$status;

					   $this->output();
					}
					
					
					
					$params = array(
    				  'request_cancel'=>1,
    				  'cancel_reason'=>($this->data['cancel_reason']),
    				  'date_modified'=>$this->functions->dateNow(),
    				  'ip_address'=>$_SERVER['REMOTE_ADDR']
    				);
    				    				
    				

			  	    $up =$this->functions->updateData("mt_order",$params,'order_id',(integer)$order_id);

    				if($up){
    					$this->functions->notifyCancelOrder($res);
    					$this->code = 1;
		    			$this->msg ="Your request has been sent to merchant";
		    			$this->details;
		    			
		    			/*logs*/
		    			$params_logs=array(
		    			  'order_id'=>$order_id,
		    			  'status'=>"cancel order request",
		    			  'date_created'=>$this->functions->dateNow(),
		    			  'ip_address'=>$_SERVER['REMOTE_ADDR']
		    			);		    			
		    			
		    			$this->functions->insertData('mt_order_history', $params_logs);
		    			
    				} else $this->msg = "ERROR: cannot update records.";
    				
				} else $this->msg = "Sorry but this order does not belong to you";
			} else $this->msg ="Order id not found";
		} else $this->msg = "invalid order id";
		
		$this->output();
	}



	public function getOrderHistory()
	{
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];	
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
		
		
		$page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';
		
		if($order_id>0){
			if ($res = $this->mobileWrapper->orderHistory($order_id)){
				$data =array();
				foreach ($res as $val) {
		   	   	  
		   	   	  $remarks = $this->functions->clearString($val['remarks']);
		   	   	  if(!empty($val['remarks2'])){
		   	   	  	  $args=json_decode($val['remarks_args'],true);  
		   	   	  	  if(is_array($args) && count( (array) $args)>=1){
						 foreach ($args as $args_key=>$args_val) {
							$args[$args_key]=$args_val;
						 }						 
						 $new_remarks=$val['remarks2'];
						 $remarks=$new_remarks;	
					  }
		   	   	  }

		   	   	  if($remarks==null){
		   	   	  	$remarks='';
		   	   	  }
		   	   	  
		   	      $data[]=array(
		   	        'date'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
		   	        'status_raw'=>$val['status'],
		   	        'status'=>$val['status'],
		   	        'remarks'=>$remarks
		   	      );


		   	   }
		   	   
		   	   $order_info = $this->mobileWrapper->orderDetails($order_id);		   	   
		   	   $order_info['merchant_name'] = $this->functions->clearString($order_info['merchant_name']);
		   	   $order_info['logo'] = $order_info['logo']=$this->mobileWrapper->getImage($order_info['logo']);
		   	   $order_info['transaction'] =$order_info['trans_type']." #".$order_info['order_id'];

		   	   $order_info['payment_type'] = $this->functions->prettyPaymentTypeTrans($order_info['trans_type'],$order_info['payment_type']);
		   	   
		   	   $this->code = 1;
		   	   $this->msg = "OK";
		   	   $this->details = array(
		   	     'order_id'=>$order_id,
		   	     'show_track'=>"",
		   	     'page_action'=>$page_action,
		   	     'order_info'=>$order_info,
		   	     'data'=>$data,		   	    
		   	   );
			} else {				
				$this->code = 6;
				$this->msg = "No results";
									
				$this->details = array(
				   'element'=>".track_history_loader",
	        	   'element_list'=>"#track_history_item",
	        	   'message'=>"Order history is empty"
				);
			}		
		} else {			
			$this->code = 6;
			$this->msg = "invalid order id";
								
			$this->details = array(
			   'element'=>".track_history_loader",
        	   'element_list'=>"#track_history_item",
        	   'message'=>"Order history is empty"
			);				
		}
		$this->output();
	}


	public function searchOrder()
{
    if ($client_id = $this->checkToken()) {
        $data = array();
        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';

        if (!empty($search_str)) {
            $stmt = "
                SELECT 
                    a.order_id,
                    a.client_id,
                    a.trans_type,
                    a.trans_type as trans_type_raw,
                    a.payment_type,
                    a.payment_type as payment_type_raw,
                    a.total_w_tax,
                    b.restaurant_name,
                    b.logo
                FROM mt_order a
                LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
                WHERE a.client_id = :client_id
                AND (
                    a.order_id LIKE :search_str
                    OR b.restaurant_name LIKE :search_str
                    OR a.trans_type LIKE :search_str
                    OR a.payment_type LIKE :search_str
                )
                LIMIT 20
            ";

            $search_param = "%$search_str%";
            $query = $this->db->prepare($stmt);
            $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $query->bindParam(':search_str', $search_param, PDO::PARAM_STR);
            $query->execute();

            if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
                foreach ($res as &$val) {
                    $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);
                    $val['restaurant_name'] = $this->mobileWrapper->highlight_word($val['restaurant_name'], $search_str);
                    $val['transaction'] = $val['trans_type'] . " #" . $val['order_id'];
                    $val['payment_type'] = $this->mobileWrapper->highlight_word($val['payment_type'], $search_str);
                    $val['transaction'] = $this->mobileWrapper->highlight_word($val['transaction'], $search_str);
                    $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = ['list' => $res];
            } else {
                $this->msg = "No results";
            }
        } else {
            $this->msg = "Invalid search string";
        }
    }
    $this->output();
}


public function ViewOrder()
	{
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];	
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
		
		if($order_id>0){
						
			if ( $data = $this->mobileWrapper->getReceiptByID($order_id)){
				
				
				$json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;				
				
				if ( $json_details !=false){
					
					   $displayOrderHTML=$this->functions->displayOrderHTML(array(
				       'merchant_id'=>$data['merchant_id'],
				       'order_id'=>$data['order_id'],
				       'delivery_type'=>$data['trans_type'],
				       'delivery_charge'=>$data['delivery_charge'],
				       'packaging'=>$data['packaging'],
				       'cart_tip_value'=>$data['cart_tip_value'],
					   'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
					   'card_fee'=>$data['card_fee'],
					   'donot_apply_tax_delivery'=>$data['donot_apply_tax_delivery'],
					   'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
					   'voucher_amount'=>$data['voucher_amount'],
					   'voucher_type'=>$data['voucher_type']
				     ),$json_details,true,$data['order_id']);
				     
				    $data2=$displayOrderHTML;
				      
				     $merchant_info=$this->functions->getMerchant( $data['merchant_id'] );
			         $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
			         " ".$merchant_info['post_code'];
			
					 if (isset($data['contact_phone1'])){
						if (!empty($data['contact_phone1'])){
							$data['contact_phone']=$data['contact_phone1'];
						}
					 }				
					 if (isset($data['location_name1'])){
						if (!empty($data['location_name1'])){
							$data['location_name']=$data['location_name1'];
						}
					}
					
					$new_data = array();					
					$new_data[] = $this->mobileWrapper->receiptFormater("Customer Name", $this->functions->clearString($data['full_name']) );
					$new_data[] = $this->mobileWrapper->receiptFormater("Merchant Name", $this->functions->clearString($data['merchant_name']) );					
					if (isset($data['abn']) && !empty($data['abn'])){						
						$new_data[] =$this->mobileWrapper->receiptFormater("ABN",$data['abn']);					
					}
					$new_data[] = $this->mobileWrapper->receiptFormater("Telephone",$data['merchant_contact_phone']);
					$new_data[] = $this->mobileWrapper->receiptFormater("Address",$full_merchant_address);
										
					$merchant_tax_number=$this->functions->getOption('merchant_tax_number',$this->merchant_id);
					
			        if(!empty($merchant_tax_number)){
			           $new_data[] = $this->mobileWrapper->receiptFormater("Tax number",$merchant_tax_number);
			        }
			        
			        $new_data[] =$this->mobileWrapper->receiptFormater("TRN Type", $data['trans_type'] );
			        $new_data[] = $this->mobileWrapper->receiptFormater("Payment Type",
			          $this->functions->prettyPaymentType('payment_order',$data['payment_type'],$data['order_id'],$data['trans_type'])
			        );

			        $new_data[] = $this->mobileWrapper->receiptFormater("Payment Type",$this->functions->payment_translations($data['trans_type'],$data['payment_type'],$data['is_sop']))
			        ;


			        
			        if ( $data['payment_provider_name']){			       	   
			       	   $new_data[] = $this->mobileWrapper->receiptFormater("Card#",$data['payment_provider_name']);
			        }
			        
			        if ( $data['payment_type'] =="pyp"){
			       	  $paypal_info=$this->functions->getPaypalOrderPayment($data['order_id']);	
			          			       	  
			          $new_data[] = $this->mobileWrapper->receiptFormater("Paypal Transaction ID",
			            isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
			          );
			        }
			        			        
			        $new_data[] = $this->mobileWrapper->receiptFormater("Reference #", $this->functions->formatOrderNumber($data['order_id']));
			        			        			        
			        if ( !empty($data['payment_reference'])){			       	  
			       	   $new_data[] = $this->mobileWrapper->receiptFormater("Payment Ref",$data['payment_reference']);
			        }
			        if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){			           
			           $new_data[] = $this->mobileWrapper->receiptFormater("Card #",
			             $this->functions->maskCardnumber($data['credit_card_number'])
			           );
			        }
			        
			        
			        
			        $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));			        
			        $new_data[] = $this->mobileWrapper->receiptFormater("TRN Date",
			          $this->functions->translateDate($trn_date)
			        );

			        switch ($data['trans_type']) {
        	         	case "delivery":
        	         		
        	         		if (isset($data['delivery_date'])){
				           	   $date = $this->functions->prettyDate($data['delivery_date']);
					           $date=$this->functions->translateDate($date);				               
				               $new_data[] = $this->mobileWrapper->receiptFormater("Delivery Date",$date);
				            }
				            
				            if (isset($data['delivery_time'])){
				       	  	  if ( !empty($data['delivery_time'])){				       	  	  	  
				       	  	  	  $new_data[] = $this->mobileWrapper->receiptFormater("Delivery Time",
				       	  	  	    $this->functions->timeFormat($data['delivery_time'],true)
				       	  	  	  );
				       	  	  }
				       	    }
				       	    
				       	    if (isset($data['delivery_asap'])){
				       	   	   if ( !empty($data['delivery_asap'])){				       	   	   	   
				       	   	   	   $new_data[] = $this->mobileWrapper->receiptFormater("Deliver ASAP", $data['delivery_asap']==1?"Yes":'' );
				       	   	   }
				       	    } 
				       	    
				       	    if (!empty($data['client_full_address'])){
					         	$delivery_address=$data['client_full_address'];
					        } else $delivery_address=$data['full_address'];				       	    
					        
				       	    $new_data[] = $this->mobileWrapper->receiptFormater("Deliver to",$delivery_address);
				       	    
				       	    if (!empty($data['delivery_instruction'])){					       	   
					       	    $new_data[] = $this->mobileWrapper->receiptFormater("Delivery Instruction",$data['delivery_instruction']);
					       	}
					       	
					       	if (!empty($data['location_name1'])){
					           $data['location_name']=$data['location_name1'];
					        }					       	
					       	$new_data[] = $this->mobileWrapper->receiptFormater("Location Name",$data['location_name']);
					       						       	 
					       	if ( !empty($data['contact_phone1'])){
					          $data['contact_phone']=$data['contact_phone1'];
					        }				       	    
				       	    $new_data[] = $this->mobileWrapper->receiptFormater("Contact Number",$data['contact_phone']);
        	         		
				       	    if ($data['order_change']>=0.0001){	       	   	               
	       	   	               $new_data[] = $this->mobileWrapper->receiptFormater("Change", $this->functions->prettyPrice($data['order_change']) );
	       	                }
	       	                
	       	                if($data['opt_contact_delivery']==1){
	       	                	$new_data[] = $this->mobileWrapper->receiptFormater("Delivery options", "Leave order at the door or gate" );
	       	                }
				       	    	       	                
        	         		break;
        	         
        	         	case "pickup":
        	         		        	         		
        	         		$new_data[] = $this->mobileWrapper->receiptFormater("Contact Number", $data['contact_phone'] );
        	         		if (isset($data['delivery_date'])){	       	  	                
	       	  	                $new_data[] = $this->mobileWrapper->receiptFormater("Pickup Date", $data['delivery_date'] );
	       	                }
	       	                
	       	                if (isset($data['delivery_time'])){
				       	  	   if ( !empty($data['delivery_time'])){				       	  	  	  
				       	  	  	  $new_data[] = $this->mobileWrapper->receiptFormater("Pickup Time", $data['delivery_time'] );
				       	  	   }
					       	}
					       	
					       	if ($data['order_change']>=0.0001){	       	   	               
	       	   	               $new_data[] = $this->mobileWrapper->receiptFormater("Change", $this->functions->prettyPrice($data['order_change']) );
	       	                }
        	         		
        	         	    break;        	         	
        	         	    
        	         	case "dinein":
        	         		
        	         		$new_data[] =$this->mobileWrapper->receiptFormater("Contact Number", $data['contact_phone'] );
        	         		if (isset($data['delivery_date'])){	       	  	                
	       	  	                $new_data[] = $this->mobileWrapper->receiptFormater("Dine in Date", $data['delivery_date'] );
	       	                }
	       	                
	       	                if (isset($data['delivery_time'])){
				       	  	   if ( !empty($data['delivery_time'])){				       	  	  	  
				       	  	  	  $new_data[] = $this->mobileWrapper->receiptFormater("Dine in Time", $data['delivery_time'] );
				       	  	   }
					       	}
					       	
					       	if ($data['order_change']>=0.0001){	       	   	               
	       	   	               $new_data[] = $this->mobileWrapper->receiptFormater("Change",$this->functions->prettyPrice($data['order_change']) );
	       	                }
	       	                
	       	                $new_data[] = $this->mobileWrapper->receiptFormater("Number of guest", $data['dinein_number_of_guest'] );
	       	                $new_data[] = $this->mobileWrapper->receiptFormater("Table number", $data['dinein_table_number'] );
	       	                $new_data[] = $this->mobileWrapper->receiptFormater("Special instructions", $data['dinein_special_instruction'] );	       	                
        	         		
        	         	    break;     
        	         }	                 	         
					        	      
        	        
        	        $new_total_html='';
        	        
        	        /*if($data['apply_food_tax']==1){          	        	
        	        	$file = Yii::getPathOfAlias('webroot')."/protected/modules/".APP_FOLDER."/views/api/cart.php";        	        	
        	        	$new_total_html=$this->renderFile($file,array(
			    		   'data'=>$data
			    		),true);
        	        } */  

        	        //+++testing code

        	      if ($data['apply_food_tax'] == 1) {
    ob_start(); // Start output buffering

    if (is_array($data) && count($data) >= 1) {
        $average = 0.001;
        echo '<table class="receipt_total">';
        

        if (isset($data['delivery_charge']) && $data['delivery_charge'] > $average) {
            echo $this->functions->tableRow_euro(("Delivery Fee"), $this->functions::formatNumber($data['delivery_charge']));
        }

        if (isset($data['card_fee']) && $data['card_fee'] > $average) {
            echo $this->functions->tableRow_euro(("Card Fee"), $this->functions::formatNumber($data['card_fee']));
        }

        if (isset($data['packaging']) && $data['packaging'] > $average) {
            echo $this->functions->tableRow_euro(("Packaging"), $this->functions::formatNumber($data['packaging']));
        }

        if (isset($data['cart_tip_value']) && $data['cart_tip_value'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Tip") . " " . number_format($data['cart_tip_percentage'], 0) . "%",
                $this->functions::formatNumber($data['cart_tip_value'])
            );
        }

        if (isset($data['discounted_amount']) && $data['discounted_amount'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Discount") . " " . number_format($data['discount_percentage'], 0) . "%",
                "(" . $this->functions::formatNumber($data['discounted_amount']) . ")"
            );
        }

        if (isset($data['points_discount']) && $data['points_discount'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Points Discount"),
                "(" . $this->functions::formatNumber($data['points_discount']) . ")"
            );
        }

        if (isset($data['voucher_amount']) && $data['voucher_amount'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Less Voucher"),
                "(" . $this->functions::formatNumber($data['voucher_amount']) . ")"
            );
        }

        if (isset($data['sub_total']) && $data['sub_total'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Sub Total"),
                $this->functions::formatNumber($data['sub_total'])
            );
        }

        if (isset($data['taxable_total']) && $data['taxable_total'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Tax") . " " . ($data['tax'] * 100) . "%",
                $this->functions::formatNumber($data['taxable_total'])
            );
        }

        if (isset($data['total_w_tax']) && $data['total_w_tax'] > $average) {
            echo $this->functions->tableRow_euro(
                ("Total"),
                $this->functions::formatNumber($data['total_w_tax'])
            );
        }

        echo '</table>';
    }

    $new_total_html = ob_get_clean(); // Capture the full HTML output
}


        	        //---testing code



        	                	        
					$this->code = 1;
					$this->msg = "OK";
					$this->details = array(
					  'apply_food_tax'=>$data['apply_food_tax'],
					  'data'=>$new_data,
					  'html'=>$data2['html'],
					  'new_total_html'=>$new_total_html
					);
				     
				} else $this->msg = "Order not available to view. please try again later";				
			} else $this->msg = "Order not available to view. please try again later";
		} else $this->msg = "invalid order id";
		$this->output();
	}

    public function ReOrder()
	{
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];	
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
		
		/*inventory*/
		$merchant_id = 0;
		
		if($order_id>0){			
			if ($res = $this->mobileWrapper->ReOrderGetInfo($order_id)){				
				
				
				if($res['merchant_status']!="active"){
					$this->msg = "Merchant is no longer active";
					$this->output();
				}			
				if($res['is_ready']!=2){
					$this->msg = "Merchant is not published";
					$this->output();
				}			
				
				/*inventory*/
				$merchant_id = (integer) $res['merchant_id'];
				
				/*VALIDATE IF ITEM IS AVAILABLE*/
				$cart_count=0;
				$json_details = json_decode($res['json_details'],true);
				$re_order_items = array();							
					
				if(is_array($json_details) && count($json_details)>=1){
				   foreach ($json_details as $item) {				   	   				   	   
				   	
				   	   $newest_price = 0; $newest_discount=0;
				   	   $current_discount = 0; $current_item_price = 0;
				   	
				   	   if ($item_res = $this->functions->getFoodItem($item['item_id'])){
				   	   	   if($item_res['not_available']==2){
				   	   	   	  // do nothing			   	   	   	  
				   	   	   } else {				   	   	   
				   	   	   	  //dump($item_res);				   	   	   	  
				   	   	   	  $current_discount = isset($item['discount'])?$item['discount']:0;
				   	   	   	  $item_price = explode("|",$item['price']);
				   	   	   	  				   	   	   	  
				   	   	   	  if( count($item_price) <=1){				   	   	   	  	
				   	   	   	  			  
				   	   	   	  	$newest_discount = $item_res['discount'];
				   	   	   	  	$current_item_price = $item_price[0];
				   	   	   	  	$current_item = json_decode($item_res['price'],true);
				   	   	   	  	if(is_array($current_item) && count($current_item)>=1){
				   	   	   	  		//$newest_price = $current_item[0];
				   	   	   	  		foreach ($current_item as $new_price) {
				   	   	   	  			$newest_price = $new_price;
				   	   	   	  		}
				   	   	   	  	}								   	   	   	  					   	   	   	  				   	   	   	  
				   	   	   	  	if($current_item_price!=$newest_price){
				   	   	   	  		$item['price'] = $newest_price;
				   	   	   	  	}				   	   	   	  
				   	   	   	  	if($current_discount!=$newest_discount){
				   	   	   	  		$item['discount'] = $newest_discount;
				   	   	   	  	}				   	   	   	  
				   	   	   	  } else {				   	  					   	   	   	  			   	   	   	  
				   	   	   	  	$newest_discount = $item_res['discount'];				   	   	   	  	 	   	  	
				   	   	   	  	$current_size_id = isset($item_price[2])?$item_price[2]:0;
				   	   	   	  	$current_item_price = isset($item_price[0])?$item_price[0]:0;
				   	   	   	  	$newest_price_list = json_decode($item_res['price'],true);				   	   	   	  	
				   	   	   	  	if(array_key_exists($current_size_id,(array)$newest_price_list)){
				   	   	   	  		$newest_price = $newest_price_list[$current_size_id];				   	   	   	  						   	   	   	  	
				   	   	   	  	    if($current_item_price!=$newest_price){
				   	   	   	  	    	$item['price'] = $newest_price."|".$item_price[1]."|".$item_price[2];
				   	   	   	  	    }			
				   	   	   	  	    
				   	   	   	  	    if($current_discount!=$newest_discount){
				   	   	   	  		   $item['discount'] = $newest_discount;
				   	   	   	  	    }				   	   	   	  
				   	   	   	  		   	   	   	  	
				   	   	   	  	} else {
				   	   	   	  		// price does not exist
				   	   	   	  	}	   	   	   	  				   	   	   	  					   	   	   	  	
				   	   	   	  } 	   				   	   	   	  
				   	   	   	  				   	   	   	  
				   	   	   	  $re_order_items[] = $item;
				   	   	   	  $cart_count++;
				   	   	   }
				   	   }				   
				   }
				}	
				
				/*dump($re_order_items);
				die();*/
				
				if($cart_count<=0){
					$this->msg = "There is no item to re-order";
					$this->output();
				}		

							
				/*inventory*/				
				if($this->functions->inventoryEnabled($merchant_id)){
					try {						
						$this->StocksWrapper->verifyStocksReOrder($order_id,$merchant_id);
					} catch (Exception $e) {
						$this->msg = $e->getMessage();
		                $this->output();
					}
				}				
				
				$params = array(		
				  'merchant_id'=>$res['merchant_id'],
				  'cart'=>json_encode($re_order_items),
				  'device_uiid'=>$this->device_uiid,
				  'cart_count'=>$cart_count,
				  'date_modified'=>$this->functions->dateNow()
				);								 
				           
				if($resp=$this->mobileWrapper->getCart($this->device_uiid)){

				

		          	 $up =$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$this->device_uiid);


					if($up){
						$this->code = 1;
						$this->msg = "OK";					
						$this->details = array(
						  'merchant_id'=>$res['merchant_id']
						);
					} else $this->msg = "Order not available to re-order. please try again later";
				} else {					
					
					if($this->functions->insertData("mt_mobile2_cart",$params)){	
						$this->code = 1;
						$this->msg = "OK";
						$this->details = array(
						  'merchant_id'=>$res['merchant_id']
						);
					} else $this->msg = "Order not available to re-order. please try again later";
				}				
								
				$trans_type = isset($res['trans_type'])?$res['trans_type']:'';		
				$services = $this->mobileWrapper->getMerchantServices( isset($res['service'])?$res['service']:'' );
				
				if(!array_key_exists($trans_type,(array)$services)){
					if(is_array($services) && count($services)>=1){
						foreach ($services as $key=>$val) {
							$trans_type = $key;							
							break;
						}
					}			
				}
				
				$this->details['trans_type']=$trans_type;
				
			} else $this->msg = "Order not available to re-order. please try again later";
		} else $this->msg ="invalid order id";	
		
		$this->output();
	}


	public function RemoveFavorites()
	{
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			$this->output();
		}			
		$client_id = $res['client_id'];	
		
		$id= isset($this->data['id'])?$this->data['id']:0;
		if($id>0){
			$this->mobileWrapper->removeFavorite($id, $client_id);
			$this->code = 1;
			$this->msg = "Successfully remove from your favorites";
		} else $this->msg = "invalid id";
		
		$this->output();
	}
	
public function searchFavorites()
{
    if (!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])) {
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }

    $client_id = $res['client_id'];
    $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';

    if (!empty($search_str)) {
        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
                a.id,
                a.merchant_id,
                a.client_id,
                a.date_created,
                b.restaurant_name as merchant_name,
                b.logo
            FROM mt_favorites a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.client_id = :client_id
            AND b.restaurant_name LIKE :search_str
            ORDER BY a.id DESC
        ";

        $search_param = "%$search_str%";
        $query = $this->db->prepare($stmt);
        $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $query->bindParam(':search_str', $search_param, PDO::PARAM_STR);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            $data = array();
            foreach ($res as &$val) {
                $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['date_added'] = "Added " . $date_added;
                $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                $val['merchant_name'] = $this->mobileWrapper->highlight_word($val['merchant_name'], $search_str);
                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = ['data' => $data];
        } else {
            $this->msg = "No results";
        }
    } else {
        $this->msg = "Invalid search string";
    }

    $this->output();
}

public function DeleteAddressBook()
	{
		if ($client_id = $this->checkToken()){
			$id = isset($this->data['id'])?$this->data['id']:'';

			$search_resp = $this->mobileWrapper->searchMode();
		    $search_mode = $search_resp['search_mode'];
				
			if($id>0){
				$is_location = false;
				if($search_mode=="location"){
					$is_location = true;
				}
				$this->mobileWrapper->DeleteAddressBook($id,$client_id, $is_location);
				$this->code = 1; $this->msg = "Address has been deleted";	
			} else $this->msg = "invalid id";		
		} 
		$this->output();
	}		
	
	public function getCountryList()
	{
		$country_list = $this->functions->CountryList();
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		  'country_list'=>$country_list,
		  'country_code'=>$this->functions->getOptionAdmin('admin_country_set')
		);
		$this->output();
	}


	public function saveAddressBook()
	{
		$this->data = $_POST;		
		if ($client_id = $this->checkToken()){
			$params = array(
			  'client_id'=>$client_id,
			  'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
			  'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
			  'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
			  'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
			);					
			
			if(empty($params['latitude'])){
				$this->msg = "please select your location on the map";
				$this->output();
			}		
			if(empty($params['longitude'])){
				$this->msg = "please select your location on the map";
				$this->output();
			}		
			
			if(!is_numeric($params['as_default'])){
			    //unset($params['as_default']);
			    $params['as_default']=1;
		    }			
			
					
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>0){
				 unset($params['date_created']);
				 $params['date_modified']=$this->functions->dateNow();
				 
				 if ($params['as_default']==2){
					$this->mobileWrapper->UpdateAllAddressBookDefault($client_id);
				 }				 				 
				 $this->functions->updateData("mt_address_book", $params ,'id',$id);
				 $this->code = 1; $this->msg = "Successfully updated";
			} else {				
				
				if ($params['as_default']==2){
					$this->mobileWrapper->UpdateAllAddressBookDefault($client_id);
				}
								
				if ( $this->functions->insertData("mt_address_book",$params)){
					$this->code = 1; $this->msg = "Successfully added";
				} else $this->msg = "failed cannot insert records";
			}		
		}
		$this->output();
	}
	
	public function getAddressBookByID()
	{
		if ($client_id = $this->checkToken()){
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>=1){
				if ($res=$this->functions->getAddressBookByID($id)){
				unset($res['date_created']);
				unset($res['date_modified']);
				unset($res['ip_address']);
				
				$country_list =$this->functions->CountryList();
				$res['country_list'] = $country_list;
							
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'data'=>$res
				);
			} else $this->msg = "Record not found. please try again later";
			} else $this->msg = "Invalid id";
		}
		$this->output();
	}
	
	public function GetProfile()
	{
		$data=array();
		if ($client_id = $this->checkToken()){
			if($res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
				$data['avatar'] = $this->mobileWrapper->getImage($res['avatar'],'avatar.png');
				$data['first_name']=$res['first_name'];
				$data['last_name']=$res['last_name'];
				$data['full_name']=$res['first_name']." ".$res['last_name'];
				$data['email_address']=$res['email_address'];
				$data['contact_phone']=$res['contact_phone'];
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'data'=>$data
				);
			} else $this->msg = "Profile not found";
		}
		$this->output();
	}


	public function UpdateProfile()
	{
		$this->data = $_POST;		
		if ($client_id = $this->checkToken()){
			$params = array(
			  'first_name'=> isset($this->data['first_name'])?$this->data['first_name']:'',
			  'last_name'=> isset($this->data['last_name'])?$this->data['last_name']:'',
			  'contact_phone'=> isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
			  'date_modified'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			);
			
			
			if ($this->functions->CheckCustomerMobile($params['contact_phone'],$client_id)){
				$this->msg = "Sorry but your mobile number is already exist in our records";
				$this->output();
			}			
			
			
	  	    $up=$this->functions->updateData("mt_client", $params ,'client_id',$client_id);
	  	    
			if ($up){
				$this->code = 1;
				$this->msg = "profile successfully updated";
			} else $this->msg = "ERROR: cannot update records.";
		}
		$this->output();
	}
	
	public function ChangePassword()
	{
		$this->data = $_POST;		
		if ($client_id = $this->checkToken()){
			if($res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){				
				$current_password = md5($this->data['current_password']);			
				
				$new_password = isset($this->data['new_password'])?$this->data['new_password']:'';
				$cnew_password = isset($this->data['cnew_password'])?$this->data['cnew_password']:'';
				
				if ($new_password!=$cnew_password){
					$this->msg = "Confirm password does not match";
					$this->output();
				}						
				if ($current_password!=$res['password']){
					$this->msg = "current password is invalid";
					$this->output();
				}		
				if(md5($new_password)==$res['password']){
					$this->msg ="new password cannot be same as your old password";
					$this->output();
				}			
				
				$params = array(
				  'password'=>trim(md5($new_password)),
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);
				
				
				if ($this->functions->updateData("mt_client",$params,'client_id', $client_id) ){
				  $this->code = 1;
				  $this->msg = "password successfully updated";
			   } else $this->msg = "ERROR: cannot update records.";
				
			} else $this->msg = "Profile not found";
		}
		$this->output();
	}


public function UploadProfile()
{
    $this->data = $_POST;
    $profile_photo = '';
    $path_to_upload = $this->functions->uploadPath();

    if ($client_id = $this->checkToken()) {
        if (isset($_FILES['file'])) {

            header('Access-Control-Allow-Origin: *');
            $new_image_name = urldecode($_FILES["file"]["name"]) . ".jpg";
            $new_image_name = str_replace(array('?', ':'), '', $new_image_name);

            $upload_res = @move_uploaded_file($_FILES["file"]["tmp_name"], "$path_to_upload/" . $new_image_name);

            if ($upload_res) {

                $params = [
                    'avatar' => $new_image_name,
                    'date_modified' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                ];

                if ($this->functions->updateData("mt_client", $params, 'client_id', $client_id)) {
                    $this->code = 1;
                    $this->msg = "Upload successful";
                    $this->details = $new_image_name;
                    $profile_photo = $this->mobileWrapper->getImage($new_image_name, 'avatar.png');
                } else {
                    $this->msg = "ERROR: cannot update records.";
                }
            } else {
                $this->msg = "Cannot upload file";
            }
        } else {
            $this->msg = "Image is missing";
        }
    }

    echo "$this->code|$this->msg|$profile_photo";
    exit();
}


public function GetMerchantAbout()
	{
		$data = array();
		$merchant_id = $this->merchant_id;
		if ($merchant_id>0){
			if ($res = $this->functions->getMerchantInfo_mobileapp($merchant_id)){				
				$data['merchant_id']=$res['merchant_id'];
				$data['restaurant_name']=$this->functions->clearString($res['restaurant_name']);
				$data['complete_address']=$this->functions->clearString($res['complete_address']);				
				$data['restaurant_phone']= $res['restaurant_phone'];
				$data['contact_phone']= $res['contact_phone'];
				$data['latitude']=$res['latitude'];
				$data['lontitude']=$res['lontitude'];
				
				$data['cuisine']=$this->functions->displayCuisine($res['cuisine']);		
				$ratings=$this->functions->getRatings($merchant_id); 	
				$data['rating']=$ratings;	

				$data['review_count'] = $ratings['votes']." reviews";
								
				$data['opening'] = array();
				if ( $opening=$this->functions->getMerchantOpeningHours($merchant_id)){
					foreach ($opening as $val){
						$new_hours[]=array(
						  'day'=> ucwords(($val['day'])) ,
						  'hours'=>$val['hours'],
						  'open_text'=>($val['open_text']),
						);
					}
					$data['opening']=$new_hours;
				} 
				
				$data['payment'] = array(); 
				$payment_list_new = array();
				if($payment = $this->functions->getMerchantPaymentListNew($merchant_id)){					 
					 foreach ($payment as $payment_list_key=>$payment_list_val) {		

					 	$provider_list = array();
					 	if($payment_list_key=="pyr"){
					 		if($provider=$this->functions->getPaymentProviderMerchant($merchant_id)){
					 			foreach ($provider as $provider_val) {
					 				$provider_val['payment_logo'] = $this->functions->websiteUrl()."/upload/".$provider_val['payment_logo'];
					 				$provider_list[] = $provider_val;
					 			}
					 		}					 	
					 	}			
					 						 	
				   		$payment_list_new[] = array(
				   		  'label'=>($payment_list_val),
				   		  'provider_list'=>$provider_list
				   		);
				   	}	
				   	$data['payment']=$payment_list_new;
				}
												
				$data['information'] = nl2br($this->functions->clearString($this->functions->getOption('merchant_information',$merchant_id)));
				$data['website'] =  $this->functions->getOption('merchant_extenal',$merchant_id);
				if(!empty($data['website'])){
					$data['website'] = $this->functions->prettyUrl($data['website']);
				}			
				
				$services_list='';
				$services = $this->functions->DeliveryOptions($merchant_id);
				foreach ($services as $val) {					
					$services_list.= ($val).",";
				}
				$services_list = substr($services_list,0,-1);
				$data['services']=$services_list;
				
				$data['background_url'] = $this->mobileWrapper->getMerchantBackground($merchant_id);
				
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'data'=>$data
				);
				
			} else $this->msg = "merchant id not found";
		} else $this->msg = "invalid merchant id";
		$this->output();
	}

	public function ReviewList()
{
    $website_title = $this->functions->getOptionAdmin('website_title');
    
    $pagelimit = $this->mobileWrapper->paginateLimit();        
    $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

    $paginate_total = 0; 
    $limit = "LIMIT :page, :pagelimit";
    
    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
        a.id,
        a.merchant_id,
        a.client_id,
        a.review,
        a.rating,
        a.as_anonymous,
        a.date_created,
        CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
        b.avatar
    FROM mt_review a
    LEFT JOIN mt_client b ON a.client_id = b.client_id
    WHERE a.status = 'publish' 
    AND a.merchant_id = :merchant_id
    ORDER BY a.id DESC
    $limit
    ";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
    $query->bindValue(':page', (int) $page, PDO::PARAM_INT);
    $query->bindValue(':pagelimit', (int) $pagelimit, PDO::PARAM_INT);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();
        $resp = $queryc->fetch(PDO::FETCH_ASSOC);
        $total_records = $resp ? $resp['total_records'] : 0;

        $paginate_total = ceil($total_records / $pagelimit);

        $data = [];
        foreach ($res as $val) {
            if ($val['as_anonymous'] == 1) {
                $val['customer_name'] = "By " . $website_title . " Customer";
                $val['avatar'] = $this->mobileWrapper->getImage('x.png', 'avatar.png');
            } else {
                $val['avatar'] = $this->mobileWrapper->getImage($val['avatar'], 'avatar.png');
                $val['customer_name'] = "By " . $val['customer_name'];
            }

            $pretyy_date = $this->functions->translateDate($val['date_created']);
            $val['date_posted'] = $pretyy_date;
            $val['reply'] = $this->mobileWrapper->getReviewReplied($val['id'], $val['merchant_id']);

            $data[] = $val;
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = [
            'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
            'paginate_total' => $paginate_total,
            'element' => ".reviews_loader",
            'element_list' => "#reviews_list_item",
            'data' => $data
        ];
    } else {
        $this->code = 6;
        $this->msg = "No available review";
        $this->details = [
            'element' => ".reviews_loader",
            'element_list' => "#reviews_list_item",
            'message' => "Be the first one to leave a review, order now!"
        ];
    }

    $this->output();
}


public function GetMerchantDateList()
	{		
		$customer = array();
		if(isset($this->data['user_token'])){
			if($res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
				$customer['name'] = $res['first_name']." ".$res['last_name'];
				$customer['email_address']=$res['email_address'];
				$customer['contact_phone']=$res['contact_phone'];
			}		
		}
		if ($res = $this->functions->getDateList($this->merchant_id)){
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			   'customer'=>array($customer),
			  'data'=>$res
			);
		} else $this->msg = "No results";
		$this->output();
	}
	
	public function GetMerchantTimeList()
	{
		$date = isset($this->data['date'])?$this->data['date']:date("Y-m-d");					
		if ($res = $this->functions->getTimeList($this->merchant_id,$date)){
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$res
			);
		} else $this->msg = "No results";
		$this->output();
	}


	public function SaveBooking()
	{
		$this->data = $_POST;
		$merchant_id = isset($this->data['book_merchant_id'])?$this->data['book_merchant_id']:'';
		
		if($merchant_id<=0){
		   $this->msg = "invalid merchant id";
		   $this->output();
		}	
			
		if ( isset($this->data['booking_time'])){
       	  if(!empty($this->data['booking_time'])){
       	  	 $time_1=date('Y-m-d g:i:s a');
       	  	 $time_2=$this->data['date_booking']." ".$this->data['booking_time'];       	  	 
       	  	 $time_2=date("Y-m-d g:i:s a",strtotime($time_2));	     	       	  	 
       	  	 $time_diff=$this->functions->dateDifference($time_2,$time_1);	       	  		       	  	        	  	        	  	 
       	  	 if (is_array($time_diff) && count($time_diff)>=1){
       	  	     if ( $time_diff['hours']>0){	       	  	     	
	       	  	     $this->msg="Sorry but you have selected time that already past";
	       	  	     $this->output(); 	  	     	
       	  	     }	       	  	
       	  	     if ( $time_diff['minutes']>0){	       	  	     	
	       	  	     $this->msg="Sorry but you have selected time that already past";
	       	  	     $this->output();  	  	     	
       	  	     }	       	  	
       	  	 }	       	  
       	  }	       
       }		   
       
        $full_booking_time=$this->data['date_booking']." ".$this->data['booking_time'];
	    $full_booking_day=strtolower(date("D",strtotime($full_booking_time)));			
	    $booking_time=date('h:i A',strtotime($full_booking_time));	  
	    
	     if ( !$this->functions->isMerchantOpenTimes($merchant_id,$full_booking_day,$booking_time)){			
			

			$this->msg = "Sorry but we are closed on ".date("F,d Y h:ia",strtotime($full_booking_time))." Please check merchant opening hours";



		    $this->output();  	 
		}		
				
		$now=isset($this->data['date_booking'])?$this->data['date_booking']:'';			
		$merchant_close_msg_holiday='';
	    $is_holiday=false;
	    if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)){
      	    if (in_array($now,(array)$m_holiday)){
      	   	    $is_holiday=true;
      	    }
	    }
	    if ( $is_holiday==true){
	    	$merchant_close_msg_holiday=!empty($merchant_close_msg_holiday)?$merchant_close_msg_holiday:("Sorry but we are on holiday on")." ".date("F d Y",strtotime($now));
	    	$this->msg=$merchant_close_msg_holiday;
	    	$this->output();  
	    }		  
	    
	    $fully_booked_msg=$this->functions->getOption("fully_booked_msg",$merchant_id);
		if (!$this->functions->bookedAvailable($merchant_id)){
		   if (!empty($fully_booked_msg)){
		    		$this->msg=$fully_booked_msg;
		   } else $this->msg="Sorry we are fully booked for that day";			 	
		   $this->output();  
		}  
		
		$params=array(
		  'merchant_id'=>$merchant_id,
		  'number_guest'=>isset($this->data['number_guest'])?$this->data['number_guest']:'',
		  'date_booking'=>isset($this->data['date_booking'])?$this->data['date_booking']:'',
		  'booking_time'=>isset($this->data['booking_time'])?$this->data['booking_time']:'',
		  'booking_name'=>isset($this->data['booking_name'])?$this->data['booking_name']:'',
		  'email'=>isset($this->data['email'])?$this->data['email']:'',
		  'mobile'=>isset($this->data['mobile'])?$this->data['mobile']:'',
		  'booking_notes'=>isset($this->data['booking_notes'])?$this->data['booking_notes']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR'],		  
		);
		if ($client_id = $this->checkToken()){
			$params['client_id']= $client_id;
		}

		$last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
        if ($last_insert_id!== false){		
			$booking_id=$last_insert_id;
			$this->code=1;			
			
			

			$this->msg = "Your booking has been placed. Reference # ".$booking_id;
			
			$this->details = $booking_id;
			
			$merchant_name = '';
			if ($merchant_info = $this->functions->getMerchantInfo_mobileapp($merchant_id)){
				$merchant_name = $merchant_info['restaurant_name'];
			}
			
			/*SEND NOTIFICATIONS*/		
			$new_data = $params;	
			$new_data['restaurant_name']=$merchant_name;
		    $new_data['booking_id']=$booking_id;			    
		    
		    $this->functions->notifyBooking($new_data);
		    
		    
		    /*POINTS PROGRAM*/		    		
    		
    	   $this->PointsProgram->rewardsBookTable($booking_id , isset($params['client_id'])?$params['client_id']:'' , $merchant_id );
    		
			    
		} else $this->msg = "Something went wrong during processing your request. Please try again later";
				
		$this->output();
	}

	public function GetGallery()
	{		
		$data = array();
		if($this->merchant_id>0){
		    $gallery=$this->mobileWrapper->getMerchantGallery($this->merchant_id);		    
		    if(is_array($gallery) && count($gallery)>=1){
		    	$data['gallery']=$gallery;
			    $this->code = 1;
			    $this->msg = "OK";
			    $this->details = array(
			       'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			       'data'=>$data
			    );
		    } else {
		    	$this->code = 6;		    	
		    	$this->msg = "No images found";							
				$this->details = array(
				   'element'=>".gallery_loader",
	        	   'element_list'=>"#list_cuisine",
	        	   'message'=>"gallery not available"
				);
		    }		
		} else {			
			$this->code = 6;		    	
	    	$this->msg = "invalid merchant id";
			$this->details = array(
			   'element'=>".gallery_loader",
        	   'element_list'=>"#list_cuisine",
        	   'message'=>"gallery not available"
			);
		}	
		$this->output();
	}


	public function GetMerchantInformation()
	{		
		$data = array();
		if($this->merchant_id>0){
			$data['information'] = nl2br($this->functions->clearString($this->functions->getOption('merchant_information',$this->merchant_id)));
			$this->code = 1;
			$this->msg = "OK";
			
			$data['background_url'] = $this->mobileWrapper->getMerchantBackground($this->merchant_id);
			
			$this->details = array( 
			 'data'=>$data
			);
		} else {
			$this->code = 6;		    	
	    	$this->msg = "invalid merchant id";
			$this->details = array(
			   'element'=>".information_loader",
        	   'element_list'=>"#test",
        	   'message'=>"information not available"
			);
		}	
		$this->output();
	}

	public function GetMerchantPromo()
	{
		$data = array();
		if($this->merchant_id>0){
			$merchant_id =  $this->merchant_id;
			$promo = array();
    		$promo['enabled']=1;
    		
    		
	    		if($offer=$this->functions->getOffersByMerchantNew($merchant_id)){
		    	   $promo['offer']=$offer;
		    	   $promo['enabled']=2;
		    	}		    	
    		
	    	
    					
		    	if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){		    	    		
		    		$promo['enabled']=2;	    		
		    		foreach ($voucher as $val) {
		    			if ( $val['voucher_type']=="fixed amount"){
				      	  $amount=$this->functions->prettyPrice($val['amount']);
				        } else $amount=number_format( ($val['amount']/100)*100 )."%";
				        				        
				        
				         $promo['voucher'][] =$amount." off | Use coupon ".$val['voucher_name'];
		    		}	    		 	    		
		    	}
    		
	    	
	    	$free_delivery_above_price=$this->functions->getOption('free_delivery_above_price',$merchant_id);
	    	if ($free_delivery_above_price>0){
	    	    $promo['free_delivery'][0]="Free Delivery On Orders Over"." ". $this->functions->prettyPrice($free_delivery_above_price);
	    		$promo['enabled']=2;
	    	}
	    		    
	    	if($promo['enabled']==1){
	    		$this->code = 6;
	    		$this->msg = "No available promos";
	    		$this->details = array(
				   'element'=>".promos_loader",
	        	   'element_list'=>"#promo_list_item",
	        	   'message'=>"no promo available for this merchant"
				);
	    	} else {
	    		$this->code = 1;
	    	    $this->msg = "OK";
	    	    $this->details = array(
		    	  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
		    	  'data'=>$promo
		    	);
	    	}    		    		    	    	
	    	
		} else {
			$this->code = 6;		    	
	    	$this->msg = "invalid merchant id";
			$this->details = array(
			   'element'=>".promos_loader",
        	   'element_list'=>"#promo_list_item",
        	   'message'=>"no promo available"
			);
		}	
		$this->output();
	}




	public function GetPointSummary()
	{
		
		
		$data = array();
		if ($client_id = $this->checkToken()){
			
			$total_available_pts = $this->PointsProgram->getTotalEarnPoints($client_id);		
	    	$total_expiring_pts = $this->PointsProgram->getExpiringPoints($client_id);
	    	$total_expenses = $this->mobileWrapper->pointsTotalExpenses($client_id);
	    	$total_earn_by_merchant = $this->mobileWrapper->pointsEarnByMerchant($client_id);
	    	
	    	$data[]=array(
	    	  'label'=>"Income Points",
	    	  'value'=>$total_available_pts>0?$total_available_pts:0,
	    	  'point_type'=>'income_points'
	    	);
	    	
	    	$data[]=array(
	    	  'label'=>"Expenses Points",
	    	  'value'=>$total_expenses>0?$total_expenses:0,
	    	  'point_type'=>'expenses_points'
	    	);
	    	
	    	$data[]=array(
	    	  'label'=>"Expired Points",
	    	  'value'=>$total_expiring_pts>0?$total_expiring_pts:0,
	    	  'point_type'=>'expired_points'
	    	);
	    	
	    	$data[]=array(
	    	  'label'=>"Points By Merchant",
	    	  'value'=>$total_earn_by_merchant,
	    	  'point_type'=>'points_merchant'
	    	);
	    	
	    	$this->code = 1;
	    	$this->msg="OK";
	    	$this->details=array(
	    	  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
	    	  'data'=>$data
	    	);
		}
		$this->output();
	}


	public function GetPointDetails()
{
    $pagelimit = $this->mobileWrapper->paginateLimit();
    $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
    
    $paginate_total = 0;
    $page_title = '';
    $stmt = '';
    $limit = "LIMIT :page, :pagelimit";

    if ($client_id = $this->checkToken()) {
        $point_type = isset($this->data['point_type']) ? $this->data['point_type'] : '';
        
        switch ($point_type) {
            case "income_points":
                $page_title = "Income Points";
                $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                a.trans_type,
                a.order_id,
                a.date_created,
                a.total_points_earn
                FROM mt_points_earn a
                WHERE status='active' AND client_id = :client_id
                ORDER BY id DESC
                $limit";
                break;

            case "expenses_points":
                $page_title = "Expenses Points";
                $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                a.points_type,
                a.trans_type,
                a.order_id,
                a.total_points,
                a.date_created
                FROM mt_points_expenses a
                WHERE status='active' AND client_id = :client_id
                ORDER BY id DESC
                $limit";
                break;

            case "expired_points":
                $page_title = "Expired Points";
                $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                a.points_type,
                a.trans_type,
                a.order_id,
                a.date_created,
                a.total_points_earn
                FROM mt_points_earn a
                WHERE status='expired' AND client_id = :client_id
                ORDER BY id DESC
                $limit";
                break;

            case "points_merchant":
                $page_title = "Points By Merchant";
                $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                a.merchant_id,
                b.restaurant_name,
                b.restaurant_slug
                FROM mt_points_earn a
                LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
                WHERE a.merchant_id <> 0 AND client_id = :client_id
                GROUP BY a.merchant_id
                ORDER BY b.restaurant_name ASC
                $limit";
                break;
        }

        $data = [];
        $query = $this->db->prepare($stmt);
        $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
        $query->bindValue(':page', (int)$page, PDO::PARAM_INT);
        $query->bindValue(':pagelimit', (int)$pagelimit, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                switch ($point_type) {
                    case "income_points":
                        $label = $this->PointsProgram->PointsDefinition('earn', $val['trans_type'], $val['order_id']);
                        $data[] = [
                            'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                            'label' => $label,
                            'points' => $val['total_points_earn']
                        ];
                        break;

                    case "expenses_points":
                        $label = $this->PointsProgram->PointsDefinition($val['points_type'], $val['trans_type'], $val['order_id'], $val['total_points']);
                        $data[] = [
                            'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                            'label' => $label,
                            'points' => $val['total_points']
                        ];
                        break;

                    case "expired_points":
                        $label = $this->PointsProgram->PointsDefinition($val['points_type'], $val['trans_type'], $val['order_id'], $val['total_points_earn']);
                        $data[] = [
                            'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                            'label' => $label,
                            'points' => $val['total_points_earn']
                        ];
                        break;

                    case "points_merchant":
                        $points = $this->mobileWrapper->getTotalEarnPoints($client_id, $val['merchant_id'], 1);
                        $data[] = [
                            'date' => $this->functions->clearString($val['restaurant_name']),
                            'label' => "Merchant Name",
                            'points' => $points > 0 ? $points : 0
                        ];
                        break;
                }
            }

            $this->code = 1;
            $this->msg = "ok";
            $this->details = [
                'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                'page_title' => $page_title,
                'data' => $data
            ];
        } else {
            $this->code = 6;
            $this->msg = "No results";
            $this->details = [
                'element' => ".points_details_loader",
                'element_list' => "#points_details_item",
                'message' => 'points details not found'
            ];
        }
    }

    $this->output();
}


public function searchFoodCategory()
	{
		$item_name = isset($this->data['item_name'])?$this->data['item_name']:'';
		if($this->merchant_id>0){
			if(!empty($item_name)){
				if($res = $this->itemWrapper->searchByCategoryByName($this->merchant_id,$item_name)){
				   $data = array();
				   foreach ($res as $val) {				   	 
				   	 $val['category_name'] = $this->mobileWrapper->highlight_word($val['category_name'],$item_name);
				     $val['photo']=$this->mobileWrapper->getImage($val['photo']);
				   	 $val['category_description']=strip_tags($val['category_description']);				
				   	 $val['category_description'] = $this->mobileWrapper->highlight_word($val['category_description'],$item_name);
				     $data[]=$val;				   	
				   }
				   
				   $this->code = 1;
				   $this->msg = "OK";
				   $this->details = array(
					 'data'=>$data
					);
				} else $this->msg = "No results";
			} else $this->msg = "invalid search string";
		} else $this->msg ="invalid merchant id";
		$this->output();
	}

	public function GetRecentLocation()
{
    if (!empty($this->device_uiid)) {
        
        $page_limit = $this->mobileWrapper->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $page_limit : 0;

        $paginate_total = 0;
        $limit = "LIMIT :page, :page_limit";

        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*
        FROM mt_mobile2_recent_location a
        WHERE 
        device_uiid = :device_uiid
        ORDER BY a.id DESC
        $limit
        ";

        try {
            $query = $this->db->prepare($stmt);
            $query->bindValue(':device_uiid', $this->device_uiid, PDO::PARAM_STR);
            $query->bindValue(':page', (int)$page, PDO::PARAM_INT);
            $query->bindValue(':page_limit', (int)$page_limit, PDO::PARAM_INT);
            $query->execute();

            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                $total_records = 0;
                $stmtc = "SELECT FOUND_ROWS() as total_records";
                $queryc = $this->db->prepare($stmtc);
                $queryc->execute();
                $resp = $queryc->fetch(PDO::FETCH_ASSOC);
                
                if ($resp) {
                    $total_records = $resp['total_records'];
                }

                $paginate_total = ceil($total_records / $page_limit);

                foreach ($res as &$val) {
                    $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = [
                    'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                    'paginate_total' => $paginate_total,
                    'data' => $res
                ];
            } else {
                $this->msg = "No results";
            }
        } catch (Exception $e) {
            $this->msg = "Database error: " . $e->getMessage();
        }
    } else {
        $this->msg = "Invalid device UIID";
    }

    $this->output();
}


public function SetLocation()
	{
		$this->getPOSTData();
		$this->data = $_POST;
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
		$lng = isset($this->data['lng'])?$this->data['lng']:'';
		$recent_search_address = isset($this->data['recent_search_address'])?$this->data['recent_search_address']:'';
		
		if(empty($recent_search_address)){
			$this->msg = "invalid location";
			$this->output();
		}	
		
		if(!empty($lat) && !empty($lng)){
			
			$params = array(
			  'device_uiid'=>$this->device_uiid,
			  'search_address'=>$recent_search_address,
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'country'=>isset($this->data['country'])?$this->data['country']:'',
			  'latitude'=>$lat,
			  'longitude'=>$lng,
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			);				
			
			if(!$res_recent = $this->mobileWrapper->getRecentLocation($this->device_uiid,$lat,$lng)){					
				
				$this->functions->insertData("mt_mobile2_recent_location",$params);
			} else {
				$id = (integer)$res_recent['id'];

				

				$this->functions->updateData("mt_mobile2_recent_location", $params, 'id', $id);

			}
			
			
			$data = array(
			  'recent_search_address'=>$recent_search_address,
			  'formatted_address'=>$recent_search_address,
			  'lat'=>$lat,
			  'lng'=>$lng,
			  'street'=>$params['street'],
			  'city'=>$params['city'],
			  'state'=>$params['state'],
			  'zipcode'=>$params['zipcode'],
			  'country'=>$params['country'],			  
			);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$data
			);
			
		} else $this->msg = "invalid location";
		$this->output();
	}



	public function AddFavorite()
	{		
		if ($client_id = $this->checkToken()){
			if($this->merchant_id>0){
				$res = $this->functions->addToFavorites($client_id,$this->merchant_id);
				$this->code = 1;
				if($res==1){
				   $this->msg="successfully added to your favorite list";
				} else $this->msg= "successfully remove to your favorite list";					
				$this->details = array(
				  'added'=>$res==true?true:false,
				  'id'=>$this->merchant_id
				);
			} else $this->msg = "invalid merchant id";
		} else $this->msg ="You need to login to add this restaurant to your favorites";
		$this->output();
	}



	public function searchMerchantFood()
{
    $search_resp = $this->mobileWrapper->searchMode();
    $search_mode = $search_resp['search_mode'];
    $location_mode = $search_resp['location_mode'];

    $search_string = isset($this->data['search_string']) ? $this->data['search_string'] : '';
    
    if (!empty($search_string)) {                
        $stmt = "
        SELECT 
        a.merchant_id,
        a.merchant_id as id,
        a.restaurant_name as title,
        a.cuisine as sub_title,
        a.logo as logo,
        'restaurant',
        a.service as category,
        a.merchant_id as mmtid
        FROM mt_merchant a
        WHERE restaurant_name LIKE :search_string
        AND a.status = 'active' AND a.is_ready='2'

        UNION ALL
        SELECT 
        b.merchant_id,
        b.item_id as id,
        b.item_name as title,
        b.item_description as sub_title,
        b.photo as logo,                    
        'food',
        b.category as category,
        c.merchant_id as mmtid
        FROM mt_item b                        
        LEFT JOIN mt_merchant c
        ON b.merchant_id = c.merchant_id
        WHERE 
        b.item_name LIKE :search_string
        AND b.status ='publish'
        AND c.status='active'
        AND c.is_ready='2'

        UNION ALL
        SELECT 
        c.cuisine_id as merchant_id,
        c.cuisine_id,
        c.cuisine_name as title,
        c.cuisine_name as sub_title,
        c.featured_image as logo,
        'cuisine',
        c.cuisine_name as category,
        c.cuisine_id as mmtid
        FROM mt_cuisine c
        WHERE c.cuisine_name LIKE :search_string
        AND c.status = 'publish'
        LIMIT 0,10
        ";

        try {
            $query = $this->db->prepare($stmt);
            $search_param = "%$search_string%";
            $query->bindValue(':search_string', $search_param, PDO::PARAM_STR);
            $query->execute();
            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                $data = array();
                foreach ($res as &$val) {
                    $val['title'] = $this->functions->clearString($val['title']);
                    $val['title'] = $this->mobileWrapper->highlight_word($val['title'], $search_string);
                    $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                    
                    if ($val['restaurant'] == "restaurant") {
                        $val['sub_title'] = $this->functions->displayCuisine($val['sub_title']);
                    } elseif ($val['restaurant'] == "cuisine") {
                        if ($search_mode == "location") {            
                            $total = $this->mobileWrapper->getTotalCuisineByLocation($val['id'], $location_mode, array(
                                'state_id' => isset($this->data['state_id']) ? $this->data['state_id'] : -1,
                                'city_id' => isset($this->data['city_id']) ? $this->data['city_id'] : -1,
                                'area_id' => isset($this->data['area_id']) ? $this->data['area_id'] : -1,
                                'postal_code' => isset($this->data['postal_code']) ? $this->data['postal_code'] : -1,
                            ));
                        } else {
                            $total = $this->mobileWrapper->getTotalCuisine($val['id'], $query_distance);
                        }
                        $val['sub_title'] = $total . " restaurant";
                    } else {
                        $category = json_decode($val['category'], true);
                        if (is_array($category) && count((array)$category) >= 1) {
                            $val['category'] = $category[0];
                        } else {
                            $val['category'] = '';
                        }
                    }                
                    $val['delivery_fee'] = '';                                    
                    $data[] = $val;
                }
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array('data' => $data);

                if (strlen($search_string) >= 6) {
                    $params = array(
                        'device_uiid' => $this->device_uiid,
                        'search_string' => $search_string,
                        'date_created' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR']
                    );
                    if (!$this->mobileWrapper->getRecentSearchs($this->device_uiid, $search_string)) {
                        $this->functions->insertData("mt_mobile2_recent_location", $params);
                    }            
                }
            } else {
                $this->msg = "No results";    
            }
        } catch (Exception $e) {
            $this->msg = "Database error: " . $e->getMessage();
        }
    } else {
        $this->msg = "Invalid search string";
    }

    $this->output();
}

public function GetRecentSearch()
{		
    if (!empty($this->device_uiid)) {			
        
        $page_limit = $this->mobileWrapper->paginateLimit();		
        $page = isset($this->data['page']) ? $this->data['page'] * $page_limit : 0;
        
        $paginate_total = 0; 
        $limit = "LIMIT :page, :page_limit"; 
        
        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.device_uiid,
        a.search_string
        FROM mt_mobile2_recent_search a
        WHERE 
        device_uiid = :device_uiid	        
        ORDER BY a.id DESC
        $limit
        "; 
        
        try {
            $query = $this->db->prepare($stmt);
            $query->bindValue(':device_uiid', $this->device_uiid, PDO::PARAM_STR);
            $query->bindValue(':page', (int) $page, PDO::PARAM_INT);
            $query->bindValue(':page_limit', (int) $page_limit, PDO::PARAM_INT);
            $query->execute();
            
            $res = $query->fetchAll(PDO::FETCH_ASSOC);
            
            if ($res) {
                // Get total records for pagination
                $stmtc = "SELECT FOUND_ROWS() as total_records";
                $queryc = $this->db->query($stmtc);
                $resp = $queryc->fetch(PDO::FETCH_ASSOC);
                $total_records = $resp['total_records'] ?? 0;
                
                $paginate_total = ceil($total_records / $page_limit);
                
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array( 
                    'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                    'paginate_total' => $paginate_total,
                    'data' => $res
                );
                
            } else {
                $this->msg = "No results";
            }
            
        } catch (PDOException $e) {
            $this->msg = "Database error: " . $e->getMessage();
        }
        
    } else {
        $this->msg = "Invalid device uiid";
    }
    
    $this->output();
}

public function sendOrderSMSCode()
	{
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			return false;
		}				
		$client_id = $res['client_id'];	
		$contact_phone = $res['contact_phone'];
		
		if(empty($contact_phone)){
			$this->msg ="We cannot send sms code to your phone number cause its empty. please fixed by putting mobile number into your profile";
			$this->output();
		}
				
		$sms_balance=$this->functions->getMerchantSMSCredit($this->merchant_id);
		if ( $sms_balance>=1){
			 $code=$this->functions->generateSMSOrderCode($contact_phone);


			

			  $sms_msg= "Your order sms code is ".$code;	


			if ( $resp=$this->functions->sendSMS($contact_phone,$sms_msg)){
				if ($resp['msg']=="process"){
					
					$sms_order_session = $this->functions->generateCode(50);
					
					$this->code=1;
				    

				    $this->msg= "Your order sms code has been sent to ".$contact_phone;
				    
				    $this->details = array(
				      'sms_order_session'=>$sms_order_session
				    );			
				    
				    $contact_phone = str_replace("+","",$contact_phone);
				    $params=array(
			    	  'mobile'=>trim($contact_phone),
			    	  'code'=>$code,
			    	  'session'=>$sms_order_session,
			    	  'date_created'=>$this->functions->dateNow(),
			    	  'ip_address'=>$_SERVER['REMOTE_ADDR']
			    	);
			    	
			    	$this->functions->insertData("mt_order_sms",$params);
			    	
			    	$params=array(
		        	  'merchant_id'=>$this->merchant_id,
		        	  'broadcast_id'=>"999999999",			        	  
		        	  'contact_phone'=>$contact_phone,
		        	  'sms_message'=>$sms_msg,
		        	  'status'=>$resp['msg'],
		        	  'gateway_response'=>$resp['raw'],
		        	  'date_created'=>$this->functions->dateNow(),
		        	  'date_executed'=>$this->functions->dateNow(),
		        	  'ip_address'=>$_SERVER['REMOTE_ADDR'],
		        	  'gateway'=>$resp['sms_provider']
		        	);	  	
		        	if(!is_numeric($params['merchant_id'])){
		        		unset($params['merchant_id']);
		        	}		        	
		        	$this->functions->insertData("mt_sms_broadcast_details",$params);	
					
				} else $this->msg="Sorry but we cannot send sms code this time";
			} else $this->msg="Sorry but we cannot send sms code this time. please try again later";
		} else $this->msg="Sorry but this merchant does not have enought sms credit to send sms";		
		
		$this->output();
	}



	public function verifyOrderSMScode()
	{
		$this->getPOSTData();
		$this->data = $_POST;		
		$sms_order_session = isset($this->data['sms_order_session'])?$this->data['sms_order_session']:'';
		$order_sms_code = isset($this->data['sms_order_session'])?$this->data['order_sms_code']:'';
		
		if($resp = $this->mobileWrapper->validateOrderSMSCode($sms_order_session,$order_sms_code)){
			$this->code = 1;
			$this->msg = "ok";
			$this->details = $resp['id'];
		} else $this->msg = "Invalid SMS code";
		
		$this->output();
	}
	
	public function applyRedeemPoints()
	{
		$points = isset($this->data['points'])?$this->data['points']:0;
		
		if (!is_numeric($this->merchant_id)){
			$this->msg = "Invalid merchant id";
			$this->output();
		}
				
		if($points>0.0001){		
		} else {
			$this->msg = "Invalid redeem points";
			$this->output();
		}
				
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$this->code = 3;
			$this->msg = "token not found";
			return false;
		}				
		$client_id = $res['client_id'];	
		
		$pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
		if($pts_disabled_redeem==1){
			$this->msg = "Redeeming points is disabled";
			$this->output();
		}
		
		/*CHECK POINTS BALANCE*/

		$available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
		
		if($available_points<=0){
			$this->msg = "Sorry but your points is not enough";
			$this->output();
		}	
		
		if($points>$available_points){
			$this->msg = "Sorry but your points is not enough";
			$this->output();
		}
		
		$data = array(
		  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
		  'merchant_id'=>$this->merchant_id,
		  'card_fee'=>0
		);			
		if ( $cart = $this->mobileWrapper->getCartContent($this->device_uiid,$data)){
			$is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();
			
			/*CHECK IF HAS ALREADY DISCOUNT*/			
			$pts_enabled_offers_discount = $this->functions->getOptionAdmin('pts_enabled_offers_discount');
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_offers_discount = $this->functions->getOption('mt_pts_enabled_offers_discount',$this->merchant_id);
				if($mt_pts_enabled_offers_discount>0){					
					$pts_enabled_offers_discount = $mt_pts_enabled_offers_discount;
				}			
			}
			
			if($pts_enabled_offers_discount!=1){
				$discounted_amount = isset($cart['total']['discounted_amount'])?$cart['total']['discounted_amount']:0;			
				if($discounted_amount>0.0001){
					$this->msg = "Sorry you cannot apply voucher, exising discount is alread applied in your cart";
					$this->output();
				}					
			}
			/*END CHECK IF HAS ALREADY DISCOUNT*/
			
			
			/*CHECK IF HAS ALREADY VOUCHER*/				
			$pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_add_voucher= $this->functions->getOption('mt_pts_enabled_add_voucher',$this->merchant_id);
				if($mt_pts_enabled_add_voucher>0){
					$pts_enabled_add_voucher=$mt_pts_enabled_add_voucher;
				}			
			}
			
			if($pts_enabled_add_voucher!=1){
				$less_voucher = $cart['total']['less_voucher'];			
				if($less_voucher>0.0001){
				   $this->msg = "Sorry but you cannot redeem points if you have already voucher applied on your cart";
				   $this->output();
				}					
			}
			/*END CHECK IF HAS ALREADY VOUCHER*/	
			
			$redeeming_point = $this->functions->getOptionAdmin('pts_redeeming_point');
			$redeeming_point_value = $this->functions->getOptionAdmin('pts_redeeming_point_value');
			
			if(!$is_disabled_merchant_settings){
				$mt_pts_redeeming_point = $this->functions->getOption('mt_pts_redeeming_point',$this->merchant_id);
				$mt_pts_redeeming_point_value = $this->functions->getOption('mt_pts_redeeming_point_value',$this->merchant_id);
				
				if($mt_pts_redeeming_point>0){
					$redeeming_point=$mt_pts_redeeming_point;
				}
				if($mt_pts_redeeming_point_value>0){
					$redeeming_point_value=$mt_pts_redeeming_point_value;
				}
			}	
			
			/*CHECK ABOVE ORDER*/
			$subtotal = isset($cart['total']['subtotal'])?$cart['total']['subtotal']:0;
			
			$points_apply_order_amt = $this->functions->getOptionAdmin('points_apply_order_amt');
			if(!$is_disabled_merchant_settings){
				$mt_points_apply_order_amt = $this->functions->getOption('mt_points_apply_order_amt',$this->merchant_id);
				if($mt_points_apply_order_amt>0){
					$points_apply_order_amt=$mt_points_apply_order_amt;
				}			
			}
			
			if($points_apply_order_amt>0.0001){
				if($points_apply_order_amt>$subtotal){
					
					$this->msg ="Sorry but you can only redeem points on orders over ".$this->functions->prettyPrice($points_apply_order_amt);
					$this->output();
				}			
			}								
			/*END CHECK ABOVE ORDER*/
			
			/*CHECK MINIMUM POINTS CAN BE USED*/
			$points_minimum = $this->functions->getOptionAdmin('points_minimum');
			if(!$is_disabled_merchant_settings){
				$mt_points_minimum = $this->functions->getOption('mt_points_minimum',$this->merchant_id);
				if($mt_points_minimum>0){
					$points_minimum=$mt_points_minimum;
				}			
			}						
			if($points_minimum>0.0001){
				if($points_minimum>$points){
					
					$this->msg = "Sorry but Minimum redeem points can be used is ".$points_minimum;
					$this->output();
				}			
			}								
			/*END CHECK MINIMUM POINTS CAN BE USED*/
			
			
			/*CHECK MAXIMUM POINTS CAN BE USED*/
			$points_max = $this->functions->getOptionAdmin('points_max');
			if(!$is_disabled_merchant_settings){
				$mt_points_max = $this->functions->getOption('mt_points_max',$this->merchant_id);
				if($mt_points_max>0.0001){
					$points_max=$mt_points_max;
				}			
			}
			
			if($points_max>0.0001){
				if($points_max<$points){
				   	
				   	$this->msg = "Sorry but Maximum redeem points can be used is ".$points_max;
					$this->output();
				}		
			}
			/*END CHECK MAXIMUM POINTS CAN BE USED*/
			
			$temp_redeem=intval($this->data['points']/$redeeming_point);
			$points_amount=$temp_redeem*$redeeming_point_value;
			
			/*CHECK IF SUB TOTAL WILL BE IN NEGATIVE*/			
			$new_balance = $subtotal-$points_amount;
			if($new_balance<=0){
				$this->msg = "Sorry you cannot redeem points which the Sub Total will become negative when after applying the points";
				$this->output();
			}			
			
			
			$params = array(
			  'points_apply'=>$this->data['points'],
			  'points_amount'=>$points_amount
			);
			$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$this->device_uiid);
					
			$this->code = 1;
			$this->msg ="Succesful";
			$this->details = array(
			  'points_apply'=>$this->data['points'],
			  'points_amount'=>$points_amount,
			  'pretty_points_amount'=>$this->functions->prettyPrice($points_amount)
			);
			
		} else $this->msg = "Cart is empty";
			
		$this->output();
	}


	public function removePoints()
	{
		
    	$params = array(
    	  'date_modified'=>$this->functions->dateNow(),
    	  'points_apply'=>0,
    	  'points_amount'=>0
    	);
    	$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$this->device_uiid);	
    
    	$this->code = 1;
		$this->msg="OK";
		$this->details='';
    	
		$this->output();
	}
	
	public function applyVoucher()
	{		
		if(!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){			
			$this->msg = "You need to login to apply voucher";
			$this->output();
		}			
		$client_id = $res['client_id'];		
		
		if (!is_numeric($this->merchant_id)){
			$this->msg = "Invalid merchant id";
			$this->output();
		}
		
		$data = array(
		  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
		  'merchant_id'=>$this->merchant_id,
		  'card_fee'=>0
		);
		
		if ( $cart = $this->mobileWrapper->getCartContent($this->device_uiid,$data)){			
			if ( $cart['total']['discounted_amount']>=0.0001){
				$this->msg = "Sorry you cannot apply voucher, exising discount is alread applied in your cart";
				$this->output();
			}
		}	
		
		/*CHECK IF HAS POINTS APPLIED*/		
		
			$pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');						
			$is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher',$this->merchant_id);
				if($mt_pts_enabled_add_voucher>0){
					$pts_enabled_add_voucher=$mt_pts_enabled_add_voucher;
				}		
			}						
			if($pts_enabled_add_voucher!=1){
				$pts_redeem_amt_orig = isset($cart['total']['pts_redeem_amt_orig'])?$cart['total']['pts_redeem_amt_orig']:0;
				if($pts_redeem_amt_orig>0.0001){
					$this->msg = "Sorry but you cannot apply voucher when you have already redeem a points";
					$this->output();
				}			
			}
		
		/*END CHECK IF HAS POINTS APPLIED*/
		
		$voucher_name = isset($this->data['voucher_name'])?$this->data['voucher_name']:'';
		if(empty($voucher_name)){
			$this->msg = "Voucher is required";
			$this->output();
		}	
				
		//if ( $res=Yii::app()->functions->getVoucherCodeNew($voucher_name,$this->merchant_id) ){
		if ( $res=$this->mobileWrapper->getVoucherMerchant($client_id,$voucher_name,$this->merchant_id) ){
			$voucher_type='merchant';
		} else {
			$voucher_type='admin';
			//$res=Yii::app()->functions->getVoucherCodeAdmin($voucher_name);
			$res=$this->mobileWrapper->getVoucherAdmin($client_id,$voucher_name);
		}


				
		if($res){
			
			/*CHECK IF ALREADY USE*/
			if ( $res['found']<=0){					
			} else {
				$this->msg = "Sorry but you have already use this voucher code";
				$this->output();
			}
			
			if ( !empty($res['expiration'])){						
				$expiration=$res['expiration'];
				$now=date('Y-m-d');						
				$date_diff=date_diff(date_create($now),date_create($expiration));						
				if (is_object($date_diff)){
					if ( $date_diff->invert==1){
						if ( $date_diff->d>0){
							$this->msg= "Voucher code has expired";
							$this->output();
						}
					}
				}
			}
			
			/*check if voucher code can be used only once*/
			if ( $res['used_once']==2){
				if ( $res['number_used']>0){
					$this->msg= "Sorry this voucher code has already been used";
					$this->output();
				}
			}
			if($voucher_type=="admin"){
				if (!empty($res['joining_merchant'])){							
					$joining_merchant=json_decode($res['joining_merchant']);							
					if (in_array($this->merchant_id,(array)$joining_merchant)){								
					} else {
						$this->msg= "Sorry this voucher code cannot be used on this merchant";
						$this->output();
					}
				} 				
			}	
			
			
			/*CHECK SUBTOTAL WILL BECOME LESS THAN ZERO*/
			if($resp=$this->mobileWrapper->getCart($this->device_uiid)){
				$cart=json_decode($resp['cart'],true);
				$data = array(
				  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'delivery',
				  'merchant_id'=>$this->merchant_id,
				  'card_fee'=>0
				);
				$displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
				if($displayOrderHTML['code']==1){
					$raw = $displayOrderHTML['raw']['total'];
					$subtotal = isset($raw['subtotal'])?$raw['subtotal']:0;						
											
					if ($res['voucher_type']=="percentage"){
					    $less_voucher = $subtotal*($res['amount']/100);
					    $subtotal_after_voucher = $subtotal  - $less_voucher;
					} else $subtotal_after_voucher = $subtotal- $res['amount'];
					
					if($subtotal_after_voucher<=0){
						$this->msg = "Sorry you cannot Voucher which the Sub Total will become negative when after applying the voucher";
						$this->output();
					}
				}					
			}	
			
			$params = array(
			  'voucher_id'=>$res['voucher_id'],
			  'voucher_owner'=>$res['voucher_owner'],
			  'voucher_name'=>$res['voucher_name'],
			  'amount'=>$res['amount'],
			  'voucher_type'=>$res['voucher_type'],
			);

			$this->functions->updateData("mt_mobile2_cart",array(
			  'voucher_details'=>json_encode($params)
			),'device_uiid', $this->device_uiid);

			
			

			

			$this->code = 1;
			$this->msg="OK";
			$this->details='';		
	
		} else $this->msg = "Invalid voucher code";
		
		$this->output();
	}


	public function removeVoucher()
	{
		$this->mobileWrapper->removeVoucher($this->device_uiid);
		$this->code = 1;
		$this->msg="OK";
		$this->details='';
		$this->output();
	}
	
	public function applyTips()
	{
		
		if (!is_numeric($this->merchant_id)){
			$this->msg = "Invalid merchant id";
			$this->output();
		}
		
		$tips = isset($this->data['tips'])?$this->data['tips']:0;
		if ($tips>0.0001){
			$data = array(
			  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>0
			);
			if ( $cart = $this->mobileWrapper->getCartContent($this->device_uiid,$data)){			
				$params = array(
				  'tips'=>(float)$tips,
				  'date_modified'=>$this->functions->dateNow()
				);
								
				

		  	    $this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$this->device_uiid);



						
				$this->code = 1;
				$this->msg = "OK";
			} else $this->msg = "cart not available";
		} else $this->msg = "Invalid tip";
		$this->output();
	}
	
	public function removeTip()
	{
		$this->mobileWrapper->removeTip($this->device_uiid);
		$this->code = 1;
		$this->msg="OK";
		$this->details='';		
		$this->output();
	}
	
	public function PayOnDeliveryCardList()
	{
		if (!is_numeric($this->merchant_id)){
			$this->msg = "Invalid merchant id";
			$this->output();
		}
		if ($client_id = $this->checkToken()){
			if($res=$this->functions->getPaymentProviderMerchant($this->merchant_id)){				
				$data = array();
				foreach ($res as $val) {
					$val['payment_logo'] = $this->mobileWrapper->getImage($val['payment_logo']);
					$data[] = $val;
				}
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
				  'list'=>$data
				);			
			} else {
				
				$this->code = 6;
				$this->msg = "No results";
									
				$this->details = array(
				   'element'=>".payondelivery_loader",
	        	   'element_list'=>"#payondelivery_list_item",
	        	   'message'=>"No Available Cards"
				);
				
			}
		}
		$this->output();
	}


	public function savePushSettings()
	{
		if(!empty($this->device_uiid)){
			$enabled_push = isset($this->data['enabled_push'])?$this->data['enabled_push']:'';			
			$params = array(
			  'push_enabled'=>(integer)$enabled_push,
			  'date_modified'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			);	

			

	  	     $this->functions->updateData("mt_mobile2_device_reg",$params,'device_uiid',$this->device_uiid);

			$this->code=1;
			$this->msg = "Setting saved";
			$this->details = array();
		} else $this->msg = "invalid device uiid";
		$this->output();
	}
	
	public function getPushSettings()
	{
		if(!empty($this->device_uiid)){
			if ($res = $this->mobileWrapper->getDeviceByUIID( $this->device_uiid )){				
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'push_enabled'=>$res['push_enabled'],
				  'subscribe_topic'=>isset($res['subscribe_topic'])?(integer)$res['subscribe_topic']:0
				);
			} else $this->msg = "device uiid not found";
		} else $this->msg = "invalid device uiid";
		$this->output();
	}


	public function reRegisterDevice()
	{
		if ($client_id = $this->checkToken()){
			$this->data['client_id'] = $client_id;
		}		
		$this->data['device_id'] = isset($this->data['new_device_id'])?$this->data['new_device_id']:'';
		$this->mobileWrapper->registeredDevice($this->data);	
		$this->code = 1;	
		$this->msg = "ok";
		$this->output();
	}
	
	public function logout()
	{
		if ($client_id = $this->checkToken()){
			$this->data['client_id'] = $client_id;
		}		
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';		
		$this->mobileWrapper->clearCart($device_uiid);
		$this->mobileWrapper->registeredDevice($this->data,'inactive');
		$this->code=1;
		$this->msg = "ok";
		$this->output();
	}
	
	public function registerUsingFb()
	{
		$this->data['social_strategy']='fb_mobile';
		$this->socialLogin();
		$this->output();
	}
	
	public function googleLogin()
	{
		$this->data['social_strategy']='google_mobile';
		$this->socialLogin();
		$this->output();
	}
	
	public function socialLogin()
	{
		
		$err_msg=array();
		$email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
		
		
		if ( $this->functions->emailBlockedCheck($email_address)){
    		$this->Validator->msg[] = "Sorry but your email address is blocked by website admin";    		
    	}	 
    	
    	if(empty($email_address)){
    	  $this->Validator->msg[] = "invalid email address";    		
    	}	
    	
    	$this->Validator->email(array(
    'email_address' => "Invalid email address"
), $this->data);

    	
    	if($this->Validator->validate()){    		
    	   if($res = $this->functions->isClientExist($email_address)){
    	   	  // UPDATE
    	   	  $client_id = $res['client_id'];
    	   	  $token = $res['token'];
    	   	  
    	   	  if(empty($token)){
    	   	  	 $token = $this->mobileWrapper->generateUniqueToken(15,$this->data['device_uiid']);    	   	  	 
    	   	  }    	       	   	  
    	   	  $params=array(
    	   	    'first_name'=>$res['first_name'],
    	   	    'last_name'=>$res['last_name'],
    	   	    'email_address'=>$res['email_address'],
    	   	  );    	   	
    	   	  if($res['status']=="pending"){
    	   	  	 $verification=$this->functions->getOptionAdmin('website_enabled_mobile_verification'); 
    	   	     $email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');    	   	     
    	   	     $email_code = $res['email_verification_code'];
    	   	     if($verification=="yes" || $email_verification==2){
    	   	     	$params['email_verification_code']=$email_code;		    		
		    		$this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
		    		$this->data['next_step'] = 'verification_email';
    	   	     }    	   	
    	   	     if($verification=="yes" || $email_verification==2){
    	   	     	$this->msg = "We have sent verification code to your email address";    	   	     	
    	   	     }   	   	      	   	         	   	     
    	   	  }   	       	   
    	   	  
    	   	  $this->data['client_id'] = $client_id;
    	   	  $this->mobileWrapper->registeredDevice($this->data);
    	   	  
    	   	  $this->functions->updateData("mt_client",array(
    	   	  	  'token'=>$token,
    	   	  	  'social_strategy'=>$this->data['social_strategy'],
    	   	  	  'social_id'=>$this->data['social_id'],
				  'last_login'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				),'client_id',$client_id);
    	   	  
    	   	  $this->code=1;
    	   	  $this->msg = "Registration successful";
    	   	  
    	   	  $this->details = array(    			  
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'customer_token'=>$token,    			  
    			  'contact_phone'=>$res['contact_phone'],
    			  'email_address'=>$params['email_address'],
    			);
    	   	       	   	
    	   } else {    	   	
    	   	  /*INSET*/
    	   	  
    	   	  $params = array(
    	   	    'first_name'=>($this->data['first_name']),
    	   	    'last_name'=>($this->data['last_name']),
    	   	    'email_address'=>($email_address),
    	   	    'password'=>md5($this->data['social_id']),
    	   	    'last_login'=>$this->functions->dateNow(),
    	   	    'ip_address'=>$_SERVER['REMOTE_ADDR'],
    	   	    'social_strategy'=>$this->data['social_strategy'],
    	   	    'social_id'=>$this->data['social_id']
    	   	  );
    	   	  
    	   	  $verification=$this->functions->getOptionAdmin('website_enabled_mobile_verification'); 
    	   	  $email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');
    	   	  
    	   	  $email_code=$this->functions->generateRandomKey(5);
    	   	  if($verification=="yes" || $email_verification==2){
    	   	  	 $params['email_verification_code']=$email_code;
	    		 $params['status']='pending';
	    		 $this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
	    		 $this->data['next_step'] = 'verification_email';
    	   	  }    	   
    	   	  
    	   	  $token = $this->mobileWrapper->generateUniqueToken(15,$this->data['device_uiid']);
	    	  $params['token']=$token;
	    	  
	    	  $last_insert_id = $this->functions->insertData('mt_client', $params);
              if ($last_insert_id!== false){    	 
	    	  
	    	  	 $customer_id =$last_insert_id;
	    	  	 $this->code=1;
	    		 $this->msg = "Registration successful";
	    		
	    		 if($verification=="yes" || $email_verification==2){	    		 	
	    		 	$this->msg = "We have sent verification code to your email address";    				
    				$this->data['client_id'] = $customer_id;
				    $this->mobileWrapper->registeredDevice($this->data,'pending');				    
	    		 } else {
	    		 	/*sent welcome email*/	
    				$this->functions->sendCustomerWelcomeEmail($params);
    				    				
    				$this->data['client_id'] = $customer_id;
				    $this->mobileWrapper->registeredDevice($this->data);
	    		 }	    	  
	    		 
	    		 $this->details = array(    			  
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'customer_token'=>$token,    			  
    			  'contact_phone'=>'',
    			  'email_address'=>$params['email_address'],
    			);
	    		
    			/*POINTS PROGRAM*/	    			
	    	   
	    		    $this->PointsProgram->signupReward($customer_id);
	    	    	    	
	    	      	    	    	    
	    	    //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl(APP_FOLDER."/cron/getfbavatar"));
	    		 
	    	  } else $this->msg = "Something went wrong during processing your request. Please try again later";	    	  	    	  
    	   }    	
    	} else $this->msg = mobileWrapper::parseValidatorError($this->Validator->getError());
		
		$this->output();
	}

	public function retrievePassword()
	{
		$user_mobile = isset($this->data['user_mobile'])?$this->data['user_mobile']:'';
		
		$res=array();
	    if ($res = $this->mobileWrapper->getAccountByEmail($user_mobile)){    	    	
	    } else {
	    	$res = $this->mobileWrapper->getAccountByPhone($user_mobile);
	    }
	    	    
	    if(is_array($res) && count($res)>=1){
	    	
	    	$token = $this->mobileWrapper->generateUniqueToken(15,$this->data['device_uiid']);
	    	
	    	$res['lost_password_token'] = $token;
	    	
	    	$client_id = $res['client_id'];
	    	
	    	$this->functions->updateData("mt_client",array(
								  'lost_password_token'=>$token,
								  'date_modified'=>$this->functions->dateNow(),
								  'ip_address'=>$_SERVER['REMOTE_ADDR']
								),'client_id',$client_id);
	    	
	    	$email_address = $res['email_address'];
	    	$this->mobileWrapper->SendForgotPassword($email_address,$res);
	    	
	    	
	    	
	     	$this->code = 1;
	     	$this->msg = "We sent your forgot password link, Please follow that link. Thank You.";
	     	$this->details = array();
	    } else $this->msg = "sorry the email or phone you have entered does not exist in our records";
		
		$this->output();
	}
	
	public function mapboxgeocode()
	{
		$this->geocode();
	}
	
	public function geocode()
	{
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
		$lng = isset($this->data['lng'])?$this->data['lng']:'';
		
		if(!empty($lat) && !empty($lng) ){						
			if ($res=$this->functions->latToAdress($lat,$lng)){
				$this->code = 1;
				$this->msg = "OK";
				$this->details = $res;
			} else $this->msg="location not available";
		} else $this->msg = "invalid latitude or longitude";
		
		$this->output();
	}
	
	public function clearRecentLocation()
	{		
		if( $this->mobileWrapper->clearRecentLocation($this->device_uiid)){
			$this->code = 1; $this->msg = 'OK';
			$this->details = array();
		} else $this->msg = "failed deleting recent location";
		$this->output();
	}
	
	public function GetPage()
	{
		$lang="en";
		$page_id = isset($this->data['page_id'])?$this->data['page_id']:'';
		if ($res = $this->mobileWrapper->getPageByID($page_id)){				
			
			$data['title']=$res['title'];
			$data['content']=$res['content'];			
			
			if(isset($res["title_$lang"])){
			   if(!empty($res["title_$lang"])){			   	  
			   	   $data['title']=$res["title_$lang"];
			   }			
			}
	
			if(isset($res["content_$lang"])){
			   if(!empty($res["content_$lang"])){			   	  
			   	   $data['content']=$res["content_$lang"];
			   }			
			}
			
			if($res['use_html']==0){
			   $data['content']=nl2br(strip_tags($data['content']));
			} else {
			   $data['content']=trim($data['content']);
			}		
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$data
			);
			
		} else $this->msg = "page not found";
		$this->output();
	}




	public function clearRecentSearches()
	{
		if( $this->mobileWrapper->clearRecentSearches($this->device_uiid)){
			$this->code = 1; $this->msg = 'OK';
			$this->details = array();
		} else $this->msg = "failed deleting recent searches";
		$this->output();
	}
	
	public function getOrderDetailsCancel()
	{
		$this->getOrderDetails();
	}

	public function GetNotifications()
{
    if (!$res = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])) {
        $this->code = 3;
        $this->msg = "token not found";
        $this->output();
    }

    $client_id = $res['client_id'];

    $pagelimit = $this->mobileWrapper->paginateLimit();
    $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;

    $paginate_total = 0;
    $limit = "LIMIT :page, :pagelimit";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.id,
        a.push_title,
        a.push_message,
        a.date_created        
        FROM mt_mobile2_push_logs a
        WHERE a.device_uiid = :device_uiid
        AND is_read != '1'
        ORDER BY a.id DESC
        $limit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindValue(':device_uiid', $this->device_uiid, PDO::PARAM_STR);
        $query->bindValue(':page', (int) $page, PDO::PARAM_INT);
        $query->bindValue(':pagelimit', (int) $pagelimit, PDO::PARAM_INT);
        $query->execute();

        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            // Get total records
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $query = $this->db->query($stmtc);
            $total_records = $query->fetch(PDO::FETCH_ASSOC)['total_records'];

            $paginate_total = ceil($total_records / $pagelimit);
            $data = [];

            foreach ($res as $val) {
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = [
                'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                'paginate_total' => $paginate_total,
                'data' => $data
            ];
        } else {
            $this->code = 6;
            $this->msg = "Your notifications list is empty";

            $this->details = [
                'element' => ".notifications_loader",
                'element_list' => "#notifications_list_item",
                'message' => "You don't have any notifications yet"
            ];
        }
    } catch (PDOException $e) {
        $this->code = 500;
        $this->msg = "Database error: " . $e->getMessage();
    }

    $this->output();
}

public function ReadNotification()
	{
		if ($client_id = $this->checkToken()){
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>0){
				$params = array(
				  'is_read'=>1,
				  'date_modified'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);
				
				$this->functions->updateData("mt_mobile2_push_logs",$params,'id',$id);
				$this->msg = 'ok';
				$this->code = 1;
				$this->details = array();
			} else $this->msg ="invalid id";
		}
		$this->output();
	}

	public function markAllNotifications()
{
    if ($client_id = $this->checkToken()) {
        $stmt = "
            UPDATE mt_mobile2_push_logs
            SET is_read = '1'
            WHERE client_id = :client_id
            AND is_read != '1'
        ";

        try {
            $query = $this->db->prepare($stmt);
            $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
            $query->execute();

            $this->msg = 'ok';
            $this->code = 1;
            $this->details = [];
        } catch (PDOException $e) {
            $this->code = 500;
            $this->msg = "Database error: " . $e->getMessage();
        }
    }

    $this->output();
}

	
public function searchBooking()
{
    if ($client_id = $this->checkToken()) {
        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';

        if (!empty($search_str)) {
            $stmt = "
                SELECT 
                    a.booking_id,
                    a.client_id,
                    a.merchant_id,
                    a.date_booking,
                    a.booking_time,
                    a.number_guest,
                    b.restaurant_name,
                    b.logo
                FROM mt_bookingtable a
                LEFT JOIN mt_merchant b
                ON a.merchant_id = b.merchant_id
                WHERE a.client_id = :client_id
                AND (
                    a.booking_id LIKE :search_str
                    OR b.restaurant_name LIKE :search_str_like
                )
                LIMIT 20
            ";

            try {
                $query = $this->db->prepare($stmt);
                $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
                $query->bindValue(':search_str', "%$search_str%", PDO::PARAM_STR);
                $query->bindValue(':search_str_like', "%$search_str%", PDO::PARAM_STR);
                $query->execute();

                if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
                    $data = [];
                    foreach ($res as $val) {
                        $val['date_booking_format'] = $this->functions->prettyDate($val['date_booking']) . " " . $this->functions->prettyTime($val['booking_time']);
                        $val['restaurant_name'] = $this->functions->clearString($val['restaurant_name']);
                        $val['logo'] = $this->mobileWrapper->getImage($val['logo']);
                        $val['booking_ref'] = "Booking ID# " . $val['booking_id'];
                        $val['number_guest'] = "No. of guest " . $val['number_guest'];

                        $val['restaurant_name'] = $this->mobileWrapper->highlight_word($val['restaurant_name'], $search_str);
                        $val['booking_ref'] = $this->mobileWrapper->highlight_word($val['booking_ref'], $search_str);

                        $data[] = $val;
                    }

                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = ['list' => $data];
                } else {
                    $this->msg = "No results";
                }
            } catch (PDOException $e) {
                $this->msg = "Database error: " . $e->getMessage();
            }
        } else {
            $this->msg = "Invalid search string";
        }
    }

    $this->output();
}

	public function GetBookingDetails()
{
    if ($client_id = $this->checkToken()) {            
        $booking_id = isset($this->data['booking_id']) ? $this->data['booking_id'] : '';

        if (!empty($booking_id) && $res = $this->mobileWrapper->GetBookingDetails($booking_id, $client_id)) {
            $this->code = 1;
            $this->msg = "ok";
            $data = [];

            $data[] = ['label' => "Booking ID", 'value' => $res['booking_id']];
            $data[] = ['label' => "Number Of Guests", 'value' => $res['number_guest']];
            $data[] = ['label' => "Date Of Booking", 'value' => $this->functions->prettyDate($res['date_booking'])];
            $data[] = ['label' => "Time", 'value' => $this->functions->prettyTime($res['booking_time'])];
            $data[] = ['label' => "Name", 'value' => $res['booking_name']];
            $data[] = ['label' => "Email", 'value' => $res['email']];
            $data[] = ['label' => "Mobile", 'value' => $res['mobile']];
            $data[] = ['label' => "Your Instructions", 'value' => isset($res['booking_notes']) ? $res['booking_notes'] : ''];

            $this->details = [
                'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                'data' => $data
            ];
        } else {
            $this->code = 6;
            $this->msg = "Booking not found";

            $this->details = [
                'page_action' => isset($this->data['page_action']) ? $this->data['page_action'] : '',
                'element' => ".booking_details_loader",
                'element_list' => "#booking_details_list",
                'message' => "Sorry but we cannot find what you are looking for"
            ];
        }
    }
    $this->output();
}

public function getlanguageList2()
	{
		$data = array();
		if ($lang_list=$this->functions->getLanguageList(false) ){	
			$enabled_lang=$this->functions->getEnabledLanguage();
			foreach ($lang_list as $val) {
				if (in_array($val,(array)$enabled_lang)){
					$data[$val]=($val);
				}			
			}
			$this->code=1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'lang'=>"en",
			  'data'=>$data
			);
		} else {			
			$this->code = 6;
			$this->msg = "No available language";
								
			$this->details = array(
			   'element'=>".language2_list_loader",
        	   'element_list'=>"#language2_list_item",
        	   'message'=>"language not available"
			);
		}
		$this->output();
	}


	public function getOrderHistory2()
	{
		$this->getOrderHistory();
	}


	public function CityList()
	{				      
		$page_limit =$this->mobileWrapper->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
        $state_id = isset($this->data['state_id'])?$this->data['state_id']:'';
        
        $search_resp = $this->mobileWrapper->searchMode();		
		$location_mode = $search_resp['location_mode'];
		if($location_mode==2){
			if((integer)$state_id<=0){
				$this->msg = "No results";
				$this->output();
			}		
		}	
		
		if($res = $this->LocationWrapper->GetLocationCity($page,$page_limit, $search_string, $state_id) ){
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else $this->msg = "No results";
		$this->output();
	}


	public function AreaList()
	{
		$page_limit = $this->mobileWrapper->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
        $city_id = isset($this->data['city_id'])?$this->data['city_id']:'';
                
        if($res = $this->LocationWrapper->GetAreaList($city_id,$page,$page_limit, $search_string) ){
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else $this->msg ="No results";
		$this->output();
	}
	
	public function StateList()
	{				      
		$page_limit = $this->mobileWrapper->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
		
		if($res = $this->LocationWrapper->GetStateList($page,$page_limit, $search_string) ){			
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else $this->msg = "No results";
		$this->output();
	}

	public function saveAddressBookLocation()
	{
		$this->data = $_POST;				
				
		if ($client_id = $this->checkToken()){
			$params = array(
			  'client_id'=>$client_id,
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
			  'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
			  'state_id'=>isset($this->data['state_id'])?$this->data['state_id']:'',
			  'city_id'=>isset($this->data['city_id'])?$this->data['city_id']:'',
			  'area_id'=>isset($this->data['area_id'])?$this->data['area_id']:'',
			  'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
			);					
			
			if($country_id = $this->LocationWrapper->getCountryID($params['state_id'])){
				$params['country_id']=$country_id;
			}		
						
			if(empty($params['latitude'])){
				$this->msg = "please select your location on the map";
				$this->output();
			}		
			if(empty($params['longitude'])){
				$this->msg = "please select your location on the map";
				$this->output();
			}		
			
			if(!is_numeric($params['as_default'])){			    
			    $params['as_default']=0;
		    }			
			
					
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>0){
				 unset($params['date_created']);
				 $params['date_modified']=$this->functions->dateNow();
				 
				 if($this->LocationWrapper->isAddressBookExist($client_id,
				 $params['street'],$params['state_id'],
				 $params['city_id'],$params['area_id'],$id
				 )){
				   $this->msg = "Address already exist";
				   $this->output();
				 }
				 
				 if ($params['as_default']==1){
					$this->mobileWrapper->UpdateAllAddressBookDefaultLocation($client_id);
				 }							 
				 $this->functions->updateData("mt_address_book_location", $params ,'id',$id);
				 $this->code = 1; $this->msg = "Successfully updated";
			} else {				
				
				if($this->LocationWrapper->isAddressBookExist($client_id,
				$params['street'],$params['state_id'],
				$params['city_id'],$params['area_id']
				)){
				   $this->msg = "Address already exist";
				   $this->output();
				}
								
				if ($params['as_default']==1){
					$this->mobileWrapper->UpdateAllAddressBookDefaultLocation($client_id);
				}
								
				if ( $this->functions->insertData("mt_address_book_location",$params)){
					$this->code = 1; $this->msg = "Successfully added";
				} else $this->msg = "failed cannot insert records";
			}		
		}
		$this->output();
	}

	public function getAddressBookLocationByID()
	{
		if ($client_id = $this->checkToken()){
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>=1){
				if ($res=$this->LocationWrapper->getAddressBookByID($id,$client_id)){
				unset($res['date_created']);
				unset($res['date_modified']);
				unset($res['ip_address']);
											
				
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'data'=>$res
				);
			} else $this->msg = "Record not found. please try again later";
			} else $this->msg = "Invalid id";
		}
		$this->output();
	}
	
	public function GetAddressFromCartLocation()
	{
		$customer_phone = '';
		if($client = $this->mobileWrapper->getCustomerByToken($this->data['user_token'])){
			$customer_phone=$client['contact_phone'];
		}
		if($resp=$this->mobileWrapper->getCart($this->device_uiid)){
			$this->code = 1;
			$this->msg = "OK";
			
			if(empty($resp['contact_phone'])){
				if(!empty($customer_phone)){
				   	$resp['contact_phone']=$customer_phone;
				}
			}	
						
			$this->details = array(
			  'street'=>$resp['street'],
			  'state_name'=>$resp['state'],
			  'city_name'=>$resp['city'],			  
			  'area_name'=>$resp['zipcode'],
			  'delivery_instruction'=>$resp['delivery_instruction'],
			  'location_name'=>$resp['location_name'],
			  'contact_phone'=>$resp['contact_phone'],			  
			  'lat'=>$resp['delivery_lat'],
			  'lng'=>$resp['delivery_long'],
			  'save_address'=>$resp['save_address'],
			  'customer_phone'=>$customer_phone,
			  'state_id'=>$resp['state_id'],
			  'city_id'=>$resp['city_id'],
			  'area_id'=>$resp['area_id'],
			);
			
		} else {
			$this->msg = "cart not available";
			$this->details = array(
			  'customer_phone'=>$customer_phone			  
			);
		}	
		$this->output();
	}


	public function setAddressBookLocation()
	{		
		if ($client_id = $this->checkToken()){
			$addressbook_id = isset($this->data['addressbook_id'])?$this->data['addressbook_id']:'';		
			if($addressbook_id>0){
				if($res = $this->LocationWrapper->getAddressBookByID($addressbook_id,$client_id)){					
					$new_data = array(
					  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
					  'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
					  'street'=>$res['street'],
					  'state_name'=>$res['state_name'],
					  'city_name'=>$res['city_name'],
					  'area_name'=>$res['area_name'],
					  'location_name'=>$res['location_name'],
					  'lat'=>$res['lat'],
					  'lng'=>$res['lng'],
					  'state_id'=>$res['state_id'],
					  'city_id'=>$res['city_id'],
					  'area_id'=>$res['area_id'],
					  'save_address'=>0,
					);
					$this->data = $new_data;
					$this->setDeliveryLocation();
					$this->output();
				} else $this->msg = "invalid address book not found";
			} else $this->msg = "invalid address book id";
		}		
		$this->output();
	}
	
	public function setDeliveryLocation()
	{		
			
		
		$params=array();
		$params['street'] = isset($this->data['street'])?$this->data['street']:'';
		$params['state'] = isset($this->data['state_name'])?$this->data['state_name']:'';
		$params['city']= isset($this->data['city_name'])?$this->data['city_name']:'';
		$params['zipcode']= isset($this->data['area_name'])?$this->data['area_name']:'';
		$params['location_name']= isset($this->data['location_name'])?$this->data['location_name']:'';
		$params['contact_phone']= isset($this->data['contact_phone'])?$this->data['contact_phone']:'';
		$params['delivery_instruction']= isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'';
		$params['save_address']= isset($this->data['save_address'])?$this->data['save_address']:0;
		$params['delivery_lat']= isset($this->data['lat'])?$this->data['lat']:'';
		$params['delivery_long']= isset($this->data['lng'])?$this->data['lng']:'';
		$params['state_id']= isset($this->data['state_id'])?$this->data['state_id']:'';
		$params['city_id']= isset($this->data['city_id'])?$this->data['city_id']:'';
		$params['area_id']= isset($this->data['area_id'])?$this->data['area_id']:'';
		
		$delivery_fee = $this->functions->getOption('merchant_delivery_charges',$this->merchant_id);
		
		$resp_delivery = $this->LocationWrapper->getDeliveryFee(
		 $this->merchant_id,
		 $delivery_fee,
		 $params['state_id'],
		 $params['city_id'],
		 $params['area_id']
		);
				
		if($resp_delivery){
		  $params['delivery_fee']=$resp_delivery;
		} else {
		   $this->msg ="Sorry this merchant does not deliver to your location";
		   $this->output();
		}	
				
		$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$this->device_uiid);
		
		if($params['save_address']==1){
			if ($client_id = $this->checkToken()){
				if (!$this->LocationWrapper->isAddressBookExist($client_id,$params['street'],$params['state_id'],$params['city_id'],$params['area_id'])){
					$this->mobileWrapper->UpdateAllAddressBookDefaultLocation($client_id);
					$address = array(
					  'client_id'=>$client_id,
					  'street'=>$params['street'],
					  'location_name'=>$params['location_name'],
					  'country_id'=>$this->LocationWrapper->getCountryID($params['state_id']),
					  'state_id'=>$params['state_id'],
					  'city_id'=>$params['city_id'],
					  'area_id'=>$params['area_id'],
					  'latitude'=>$params['delivery_lat'],
					  'longitude'=>$params['delivery_long'],
					  'as_default'=>1,
					  'date_created'=>$this->functions->dateNow(),
					  'ip_address'=>$_SERVER['REMOTE_ADDR']
					);
					$this->functions->insertData("mt_address_book_location",$address);
				}		
			}
		}	
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(		  
		);
		$this->output();
	}	


	public function getAddressLocationBookDropDown()
	{
		if ($client_id = $this->checkToken()){
			if ($res=$this->LocationWrapper->getAddressBook($client_id)){
				foreach ($res as $val) {
					$val['as_default'] = $val['as_default']==1?2:0;
					$data[]=$val;
				}
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				 'data'=>$data
				);
			} else $this->msg = "No results";
		}
		$this->output();
	}
	
	public function PostalCodeList()
	{
		$page_limit = $this->mobileWrapper->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
		
		if($res = $this->LocationWrapper->GetPostalCodeList($page,$page_limit, $search_string) ){			
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else $this->msg = "No results";
		$this->output();
	}

	public function recheckLocation()
	{
		$new_lat = isset($this->data['new_lat'])?$this->data['new_lat']:'';
		$new_lng = isset($this->data['new_lng'])?$this->data['new_lng']:'';
		
		$old_lat = isset($this->data['old_lat'])?$this->data['old_lat']:'';
		$old_lng = isset($this->data['old_lng'])?$this->data['old_lng']:'';
		
		$this->msg="OK";
		
		$distance_type_raw="M";
		$distance=$this->functions->getDistanceBetweenPlot($new_lat,$new_lng,$old_lat,$old_lng,"M");  
		if($distance){			
			if(!empty($this->functions->getdistance_type_result())){
             	$distance_type_raw=$this->functions->getdistance_type_result();
            }
            if($distance_type_raw=="ft" || $distance_type_raw=="meter" || $distance_type_raw=="mt"){
            	// do nothing
            } else {
	            if($distance>5){
	              	$this->code = 1;	              	
	              	$this->msg = "Your address is too far from your current location";
	              	$this->details = array(
	              	 'distance'=>$distance
	              	);
	            }		
            }
		} else $this->msg = "distance not available";
		$this->output();
	}

	public function getActiveMerchantCategory()
	{
		$this->getGETData();
		if($this->merchant_id>0){
			if($res = $this->itemWrapper->getMerchantCategory($this->merchant_id)){
				$this->code =1;
				$this->msg = "ok";
				$this->details = array(
				 'data'=>$res
				);
				
				$food_viewing_private = $this->functions->getOption('food_viewing_private',$this->merchant_id);
				if($food_viewing_private==2){
					$this->code = 2;
					$this->msg = "This restaurant has not published their menu yet";
					$this->details = array();
				}
				
			} else $this->msg = "no results";
		} else $this->msg = "invalid merchant id";
		$this->output();
	}
		
	public function preCheckout()
	{
		$this->setMerchantTimezone();
		
		$date_now = date("Y-m-d");
		$merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
		$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
    	$delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
    	    	    	    	
    	if($merchant_id>0){
    	   $resp = $this->mobileWrapper->preCheckout($merchant_id,$date_now,$delivery_date,$delivery_time);    	   
    	   $this->code = $resp['code'];
    	   $this->msg = $resp['message'];
    	   $this->details = array(
    	    'future_order'=>$resp['future_order'],
    	    'future_order_confirm'=>$this->functions->getOptionAdmin('mobileapp2_future_order_confirm'),
    	    'future_order_message'=>"This order is for another day. Continue?"
    	   );
    	} else $this->msg = "invalid merchant id";
    	
		$this->output();
	}


	public function ContactSubmit()
	{
		$this->data = $_POST;				
		
		
		$req=array(
    	  'name'=>"Name is required",    	  
    	  'email'=>"Email is required",
    	  'contact_phone'=>"Mobile number is required"    	  
    	);
		
    	if($this->Validator->validate()){
    		$lang="en";
	    	$to=$this->functions->getOptionAdmin('contact_email_receiver');
	    	$from='';
	    	
	    	$contact_us=$this->functions->getOptionAdmin('contact_us_email');
    		if ( $contact_us==""){	    			
    		    $this->msg="Contact form template is not enabled in template settings";
    			$this->output();
    		}	    
    		
    		$subject=$this->functions->getOptionAdmin('contact_us_tpl_subject_'.$lang);
    		$tpl=$this->functions->getOptionAdmin('contact_us_tpl_content_'.$lang);
    		
    		if(!empty($tpl)){	    				    				    		
    			$tpl=$this->functions->smarty('name',
    			isset($this->data['name'])?$this->data['name']:'',$tpl);
    			
    			$tpl=$this->functions->smarty('email',
    			isset($this->data['email'])?$this->data['email']:'',$tpl);
    			
    			$tpl=$this->functions->smarty('country',
    			isset($this->data['country'])?$this->data['country']:'',$tpl);
    			
    			$tpl=$this->functions->smarty('message',
    			isset($this->data['message'])?$this->data['message']:'',$tpl);
    			
    			$tpl=$this->functions->smarty('phone',
    			isset($this->data['contact_phone'])?$this->data['contact_phone']:'',$tpl);
    			
    			$tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
    			$tpl=$this->functions->smarty('siteurl',$this->functions->websiteUrl(),$tpl);
    		} 	    	
    		
    		if (empty($to)){
				
				$this->msg="ERROR: no email to send.";
				$this->output();
			}	    	
			if(empty($subject)){
				$this->msg="Subject is empty";
				$this->output();
			}	    	
			if(empty($tpl)){
				$this->msg="Template is empty";
				$this->output();
			}	    	
												
			if ( $this->functions->sendEmail($to,$from,$subject,$tpl) ){
				$this->code=1;    		
    		    $this->msg="Your message was sent successfully. Thanks.";
			} else $this->msg="ERROR: Cannot sent email.";	
    	
    	} else $this->msg = $this->mobileWrapper->parseValidatorError($this->Validator->getError());
    			
		$this->output();
	}

	public function foodPromo()
{
    $page_limit = $this->mobileWrapper->paginateLimit();

    $search_resp = $this->mobileWrapper->searchMode();
    $search_mode = $search_resp['search_mode'];
    $location_mode = $search_resp['location_mode'];

    $page = isset($this->data['page']) ? $this->data['page'] * $page_limit : 0;

    $sort_by = isset($this->data['sort_by']) ? $this->data['sort_by'] : 'DESC';
    $sort_fields = isset($this->data['sort_fields']) ? $this->data['sort_fields'] : 'discount';

    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $default_image = 'resto_banner.jpg';
    $disabled_default_image = false;

    $item_name = '';
    $and = '';
    if (isset($this->data['item_name'])) {
        $item_name = trim($this->data['item_name']);
        $and .= " AND a.item_name LIKE :item_name";
    }

    if ($search_mode == "location") {
        $state_id = isset($this->data['state_id']) ? $this->data['state_id'] : -1;
        $city_id = isset($this->data['city_id']) ? $this->data['city_id'] : -1;
        $area_id = isset($this->data['area_id']) ? $this->data['area_id'] : -1;
        $postal_code = isset($this->data['postal_code']) ? $this->data['postal_code'] : -1;

        $and .= $this->LocationWrapper->queryLocation((int)$location_mode, [
            'state_id' => $state_id,
            'city_id' => $city_id,
            'area_id' => $area_id,
            'postal_code' => $postal_code,
        ]);
    } else {
        $lat = isset($this->data['lat']) ? $this->data['lat'] : 0;
        $lng = isset($this->data['lng']) ? $this->data['lng'] : 0;

        $home_search_unit_type = $this->functions->getOptionAdmin('home_search_unit_type');
        $distance_exp = ($home_search_unit_type == "km") ? 6371 : 3959;

        $query_distance = "
        ( $distance_exp * acos( cos( radians(:lat) ) * cos( radians( latitude ) ) 
                * cos( radians( lontitude ) - radians(:lng) ) 
                + sin( radians(:lat) ) * sin( radians( latitude ) ) ) ) 
                AS distance
        ";

        $and .= "
        AND merchant_id IN (
           SELECT merchant_id 
           FROM mt_merchant
           WHERE delivery_distance_covered > (
              SELECT 
              $query_distance FROM mt_merchant
              WHERE merchant_id = a.merchant_id
              AND status IN ('active')
           )
        )";
    }

    $stmt = $this->db->prepare("
    SELECT 
    SQL_CALC_FOUND_ROWS 
    a.merchant_id, a.item_id, a.item_name, a.item_name_trans, a.photo, a.price, a.discount,
    a.item_description, a.item_description_trans, a.category
    FROM mt_item a
    WHERE discount > 0
    AND status IN ('publish')
    $and
    ORDER BY $sort_fields $sort_by
    LIMIT :page, :page_limit
    ");

    // Bind parameters
    if (!empty($item_name)) {
        $stmt->bindValue(':item_name', "%$item_name%", PDO::PARAM_STR);
    }
    if ($search_mode !== "location") {
        $stmt->bindValue(':lat', $lat, PDO::PARAM_STR);
        $stmt->bindValue(':lng', $lng, PDO::PARAM_STR);
    }
    $stmt->bindValue(':page', (int)$page, PDO::PARAM_INT);
    $stmt->bindValue(':page_limit', (int)$page_limit, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Get total records count
        $stmtc = $this->db->query("SELECT FOUND_ROWS() as total_records");
        $total_records = ($stmtc) ? $stmtc->fetch(PDO::FETCH_ASSOC)['total_records'] : 0;

        $data = [];
        foreach ($res as $val) {
            $this->itemWrapper->getSize($val['merchant_id']);

            $prices = [];
            $prices2 = [];

            if ($decoded_prices = json_decode($val['price'], true)) {
                foreach ($decoded_prices as $size_id => $priceval) {
                    $original_price = $priceval;
                    $discounted_price = ($val['discount'] >= 0.001) ? $priceval - $val['discount'] : $priceval;

                    if (array_key_exists($size_id, (array)$this->itemWrapper->getsizes())) {
                        $sizes_get = $this->itemWrapper->getsizes();
                        $prices[] = $sizes_get[$size_id] . "&nbsp;" . $this->functions->prettyPrice($discounted_price);
                        $prices2[] = [
                            'original_price' => $sizes_get[$size_id] . "&nbsp;" . $this->functions->prettyPrice($original_price),
                            'discount' => $val['discount'],
                            'discounted_price_pretty' => $sizes_get[$size_id] . "&nbsp;" . $this->functions->prettyPrice($discounted_price),
                        ];
                    } else {
                        $prices[] = $this->functions->prettyPrice($discounted_price);
                        $prices2[] = [
                            'original_price' => $this->functions->prettyPrice($original_price),
                            'discount' => $val['discount'],
                            'discounted_price_pretty' => $this->functions->prettyPrice($discounted_price),
                        ];
                    }
                }
            }

            $val['photo'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);

            if ($decoded_category = json_decode($val['category'], true)) {
                $val['category_id'] = $decoded_category[0] ?? '';
            } else {
                $val['category_id'] = '';
            }

            if (!empty($item_name)) {
                $val['item_name'] = $this->mobileWrapper->highlight_word($val['item_name'], $item_name);
            }

            $val['prices'] = $prices;
            $val['prices2'] = $prices2;
            $data[] = $val;
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = [
            'page_action' => $page_action,
            'total' => $total_records . " promo found",
            'sortby_default' => "discount",
            'list' => $data,
        ];
    } else {
        $this->msg = "No results";
        $this->details = [
            'page_action' => $page_action,
            'total' => "0 promo found",
        ];
    }

    $this->output();
}

public function searchFoodPromo()
	{
		$this->foodPromo();
	}


	public function getStocks()
	{
		
        		        
		/*function translate($words='', $params=array())
		{
			return Yii::t("inventory",$words,$params);
		}*/

		$this->StocksWrapper = new StocksWrapper();
     
		$this->data = $_POST;
		   
        $value = isset($this->data['price'])?$this->data['price']:'';
		$item_id = isset($this->data['item_id'])? (integer) $this->data['item_id']:'';
		$with_size = isset($this->data['with_size'])? (integer) $this->data['with_size']:'';
		$merchant_id = isset($this->data['merchant_id'])? (integer) $this->data['merchant_id']:0 ;


		if($merchant_id>0 && $item_id>0 ){
			try {
				
				$allow_negative_stock = $this->InventoryWrapper->allowNegativeStock($merchant_id);
				
				$size_id = 0;
								
				if($with_size>0){
					$value = explode("|",$value);
					if(is_array($value) && count($value)>=1){
						$size_id = isset($value[2])?(integer)$value[2]:0;
					}
				}


				
				$resp = $this->StocksWrapper->getAvailableStocks($merchant_id,$item_id,$size_id);

				
				
				$this->code = 1; $this->msg = "OK";
				$this->details = array(
				  'next_action'=>"display_stocks",
				  'available_stocks'=>$resp['available_stocks'],
				  'message'=>$resp['message'],
				  'allow_negative_stock'=>$allow_negative_stock
				);			
						
			} catch (Exception $e) {
			   $this->details = array('next_action'=>"item_not_available");
		       $this->msg =($e->getMessage());
		    }
		} else {
			 $this->details = array('next_action'=>"item_info_not_available");
			 $this->msg = ("invalid merchant id or size id");
		}
		$this->output();
	}

	public function AddTip()
	{
		$this->getGETData();		
		$tip_amount = isset($this->data['tip_amount'])?(float)$this->data['tip_amount']:0;		
		if($resp=$this->mobileWrapper->getCart($this->device_uiid)){
			$subtotal = (float)$resp['cart_subtotal'];			
			$percentage = ($tip_amount/$subtotal)*100;
			$percentage = number_format($percentage/100,4);	


			

	  	    $this->functions->updateData("mt_mobile2_cart",array(
			  'tips'=>$percentage
			),'device_uiid',$this->device_uiid);


	  	    $this->code = 1;
	  	    $this->msg = "OK";
	  	    $this->details = array();			
		} else $this->msg = "cart not available";
		$this->output();
	}


public function cancelBooking()
{
    $this->getGETData();
    $booking_id = isset($this->data['booking_id']) ? (int) $this->data['booking_id'] : 0;
    
    if ($client_id = $this->checkToken()) {
        if ($booking_id > 0) {
            $pattern = 'booking_id,restaurant_name,number_guest,date_booking,time,booking_name,email,mobile,instruction,status,merchant_remarks,sitename,siteurl';
            $pattern = explode(",", $pattern);
            $lang = "en";
            
            $stmt = $this->db->prepare("SELECT * FROM mt_bookingtable WHERE booking_id = ?");
            $stmt->execute([$booking_id]);
            $res = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($res) {
                if ($res['request_cancel'] >= 1) {
                    $this->msg = "You have already requested to cancel this booking";
                    $this->output();
                }

                $res['sitename'] = $this->functions->getOptionAdmin('website_title');
                $res['siteurl'] = $this->functions->websiteUrl();

                $merchant_id = $res['merchant_id'];

                $merchant_email = $this->functions->getOption('merchant_notify_email', $merchant_id);
                $sender = $this->functions->getOptionAdmin('global_admin_sender_email');
                $email_provider = $this->functions->getOptionAdmin('email_provider');

                /* SEND EMAIL TO MERCHANT */
                if (!empty($merchant_email)) {
                    $email = $this->functions->getOptionAdmin('booking_request_cancel_email');
                    $subject = $this->functions->getOptionAdmin('booking_request_cancel_tpl_subject_' . $lang);
                    $content = $this->functions->getOptionAdmin('booking_request_cancel_tpl_content_' . $lang);
                    
                    foreach ($pattern as $val) {
                        $content = $this->functions->smarty($val, isset($res[$val]) ? $res[$val] : '', $content);
                        $subject = $this->functions->smarty($val, isset($res[$val]) ? $res[$val] : '', $subject);
                    }

                    $merchant_email = explode(",", $merchant_email);

                    if ($email == 1 && is_array($merchant_email) && count($merchant_email) >= 1) {
                        foreach ($merchant_email as $_mail) {
                            $params = array(
                                'email_address' => $_mail,
                                'sender' => $sender,
                                'subject' => $subject,
                                'content' => $content,
                                'date_created' => $this->functions->dateNow(),
                                'ip_address' => $_SERVER['REMOTE_ADDR'],
                                'email_provider' => $email_provider,
                            );
                            $this->functions->insertData("mt_email_logs", $params);
                        }
                    }
                }

                /* SMS */
                $balance = $this->functions->getMerchantSMSCredit($merchant_id);
                $phone = $this->functions->getOption('merchant_cancel_order_phone', $merchant_id);
                $sms_enabled = $this->functions->getOptionAdmin('booking_request_cancel_sms');

                if (!empty($phone) && $balance > 0 && $sms_enabled == 1) {
                    $sms_content = $this->functions->getOptionAdmin('booking_request_cancel_sms_content_' . $lang);
                    foreach ($pattern as $val) {
                        $sms_content = $this->functions->smarty($val, isset($res[$val]) ? $res[$val] : '', $sms_content);
                    }
                    $params = array(
                        'merchant_id' => $merchant_id,
                        'contact_phone' => $phone,
                        'sms_message' => $sms_content,
                        'date_created' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR']
                    );
                    $this->functions->insertData("mt_sms_broadcast_details", $params);
                }

                /* PUSH NOTIFICATION */
                $push_enabled = $this->functions->getOptionAdmin('booking_request_cancel_sms');
                $push_title = $this->functions->getOptionAdmin('booking_request_cancel_push_title_' . $lang);
                $push_message = $this->functions->getOptionAdmin('booking_request_cancel_push_content_' . $lang);

                $stmt = $this->db->prepare("
                    SELECT * FROM mt_mobile_device_merchant 
                    WHERE merchant_id = ? AND enabled_push = 1 AND status = 'active'
                    LIMIT 1
                ");
                $stmt->execute([$merchant_id]);
                $merchant_resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

                if ($merchant_resp && $push_enabled == 1) {
                    foreach ($pattern as $val) {
                        $push_title = $this->functions->smarty($val, isset($res[$val]) ? $res[$val] : '', $push_title);
                        $push_message = $this->functions->smarty($val, isset($res[$val]) ? $res[$val] : '', $push_message);
                    }

                    foreach ($merchant_resp as $merchant_device_id) {
                        $params_merchant = array(
                            'merchant_id' => (int) $merchant_id,
                            'user_type' => $merchant_device_id['user_type'],
                            'merchant_user_id' => (int) $merchant_device_id['merchant_user_id'],
                            'device_platform' => $merchant_device_id['device_platform'],
                            'device_id' => $merchant_device_id['device_id'],
                            'push_title' => $push_title,
                            'push_message' => $push_message,
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'booking_id' => (int) $booking_id
                        );
                        $this->functions->insertData("mt_mobile_merchant_pushlogs", $params_merchant);
                    }
                }

                /* UPDATE BOOKING STATUS */
                $this->functions->updateData("mt_bookingtable", array(
                    'request_cancel' => 1,
                    'status' => 'request_cancel_booking'
                ), 'booking_id', $booking_id);

                $this->code = 1;
                $this->msg = "Your request has been sent to merchant";
            } else {
                $this->msg = "Booking ID not found";
            }
        } else {
            $this->msg = "Invalid booking ID";
        }
    }
    $this->output();
}


public function retrievePasswordBySMS()
	{
		$lang = "en";
		
		$phone_number = isset($this->data['user_mobile'])?$this->data['user_mobile']:'';
		if(empty($phone_number)){
			$this->msg = "Phone number is required";
			$this->output();
		}
		if(strlen($phone_number)<=4){
			$this->msg = "Invalid phone number";
			$this->output();
		}
		
		try {
		
		   $code = $this->functions->generateRandomKey(5);
		   $res = $this->functions->getCustomerByPhone( str_replace("+","",$phone_number) );
		   $token=md5(date('c').$res['client_id']);  													 
		   
		   $this->functions->updateCustomerProfile($res['client_id'],array(
			 'mobile_verification_code'=>$code,
			 'mobile_verification_date'=>$this->functions->dateNow(),
			 'lost_password_token'=>$token,
			 'ip_address'=>$_SERVER['REMOTE_ADDR']
		   ));
		   
		   $resp = $this->functions->getNotificationTemplate('customer_forgot_password',$lang,'sms');
		   $data = array(
			  'firstname'=>$res['first_name'],
			  'lastname'=>$res['last_name'],
			  'code'=>$code,							  
			);		
			$sms_content = $resp['sms_content'];
			$sms_content = $this->functions->replaceTags($sms_content,$data);			
			$sms = $this->functions->sendSMS($phone_number,$sms_content);
			if($sms['msg']=="process"){
				$this->code=1; $this->msg="We have sent verification code in your phone number";
				$this->details = array(							   	  				  
				  'forgot_password_token'=>$token
				);
			} else $this->msg = "Failed sending sms ".$sms['msg'];



			
		} catch (Exception $e) {
		   $this->msg = $e->getMessage();
		}	
		$this->output();
	}
	
	public function changePasswordBySMS()
	{		
		$token = isset($this->data['forgot_password_token'])?trim($this->data['forgot_password_token']):'';
    	$sms_code = isset($this->data['sms_code'])?trim($this->data['sms_code']):'';
    	if($res = $this->functions->getLostPassToken($token)){    		
    		if($res['mobile_verification_code']==$sms_code){ 
    			$new_password = isset($this->data['new_password'])?$this->data['new_password']:'';
    			$confirm_new_password = isset($this->data['confirm_new_password'])?$this->data['confirm_new_password']:'';
    			if(!empty($new_password) && $new_password==$confirm_new_password){
    				
    				  

    				  $this->functions->updateData("mt_client",  array(
			    		   'password'=>md5($new_password),
			    		   'ip_address'=>$_SERVER['REMOTE_ADDR'],
			    		   'date_modified'=>$this->functions->dateNow()
			    		 ), 'booking_id', $booking_id);

			      	   
	    			   $this->code = 1; 
	    			   $this->msg = "You have successfully change your password";
	    			   
    				
    			} else $this->msg = "Password is not valid";
    		} else $this->msg = "Invalid verification code";	
    	} else $this->msg = "Invalid token";
    	$this->output();
	}


	public function saveSubsribe()
	{
		if(!empty($this->device_uiid)){
			$subscribe_topic = isset($this->data['subscribe_topic'])?$this->data['subscribe_topic']:0;			
			$params = array(
			  'subscribe_topic'=>(integer)$subscribe_topic,
			  'date_modified'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			);			
			
			

	  	    $this->functions->updateData("mt_mobile2_device_reg", $params, 'device_uiid', $this->device_uiid);

			
			$this->code=1;
			$this->msg = "Setting saved";
			$this->details = array(
			  'subscribe_topic'=>$params['subscribe_topic']
			);
		} else $this->msg ="invalid device uiid";
		$this->output();
	}
			
	public function getOperational()
	{
		$today = strtolower(date("l"));
		$time_now = date("G:i");		
		if ( $this->mobileWrapper->isOperationalHours($today,$time_now)){
			$this->code = 1; $this->msg = "operational"; $this->details = array();
		} else {
			$this->msg = "no operational";
		}	
		$this->output();
	}


		public function directAddCart()
	{				
		$item_id = isset($_POST['item_id'])?(integer)$_POST['item_id']:0;
		$row_id = isset($_POST['row_id'])?(integer)$_POST['row_id']:'';
		$qty = isset($_POST['qty'])?(float)$_POST['qty']:0;		
				
		if ($res = $this->itemWrapper->getItem($item_id)){
			
			/*CHECK IF ITEM IS AVAILABLE*/
			if($res['not_available']==2){
			   $this->msg = "Sorry but this item is not available";	
			   $this->output();
			}		
			
			$_POST['merchant_id'] = isset($res['merchant_id'])?(integer)$res['merchant_id']:'';
			$_POST['with_size']=0;
			
			if(!isset($_POST['category_id'])) {
				$category = !empty($res['category'])?json_decode($res['category'],true):'';
				if(is_array($category) && count($category)>=1){				
					$_POST['category_id'] = $category[0];
				}					
			}
			
			$price = !empty($res['price'])?json_decode($res['price'],true):'';
						
			if(is_array($price) && count($price)>=1){								
				foreach ($price as $key=>$val) {
					$val = (float) $val;
					$size = $this->itemWrapper->getSizeByID($key);
					if($key>0 && $size){
						$_POST['with_size'] = 1;					
						$_POST['price'] = "$val|".$size['size_name']."|$key";
					} else $_POST['price'] = $val;					
				}				
			}			
		}			
				
		
		if ( strlen($row_id)>0){					
		   $device_uiid = isset($_POST['device_uiid'])?$_POST['device_uiid']:'';				   
		   if($cart_data=$this->mobileWrapper->getCart($device_uiid)){
		   	  $merchant_id = $cart_data['merchant_id'];
		   	  $cart_count = 0;
		   	  if($cart = json_decode($cart_data['cart'],true)){		   	  	 		   	  	
		   	  	 if(isset($cart[$row_id])){		   	  	 	
		   	  	 	if($qty<=0){
		   	  	 		unset($cart[$row_id]);
		   	  	 	} else $cart[$row_id]['qty'] = $qty;
		   	  	 	
		   	  	 	$cart_count = count($cart);	

		   	  	    	

					$this->functions->updateData("mt_mobile2_cart",  array(
					  'cart'=>json_encode($cart),
					  'cart_count'=>count($cart),
					), 'cart_id', $cart_data['cart_id']);


		   	  	 }
		   	  }		   
		   }
		   
		    $this->code = 1; 
			$this->msg="Cart updated";
			$this->details=array(
			 'merchant_id'=>$merchant_id,
			 'cart_count'=>$cart_count,
			 'refresh'=>1
			);	   
		   $this->output();
		}
		
		$this->addToCart(true);
	}
	
	public function GetCartItem()
	{
		$this->data = $_POST;
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';		
        $cart_id = 0;
        if($cart_data=$this->mobileWrapper->getCart($device_uiid)){
        	if( $cart =json_decode($cart_data['cart'],true) ){
        		$data = array();
        		foreach ($cart as $val) {
        			$data[] = array(
        			  'category_id'=>$val['category_id'],
        			  'item_id'=>$val['item_id'],
        			  'qty'=>$val['qty'],
        			);
        		}
        		$this->code = 1; $this->msg = "OK";
        		$this->details = array(
        		  'data'=>$data
        		);
        	} else $this->msg = "No results";        
        } else $this->msg = "No results";        
		$this->output();
	}



	
	













	






	

	










	






	
	



   











	
	
	
}
/*end class*/