<?php
class ReviewWrapper
{

	   public function __construct() {
       
        //$model = new Model();
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       $this->functions = new Functions(); // Create an instance of Functions

        


    }


    public  function addReview($order_id='', $rating=0, $review='', $as_anonymous=0)
  {
    $order_id = (integer)$order_id;
    if($order_id<=0){
      throw new Exception( 'invalid order id');
    }
    
    $website_review_type = $this->functions->getOptionAdmin('website_review_type');

    if($order_info = $this->functions->getOrderInfo($order_id)){
      $client_id = $order_info['client_id'];
      $order_id = $order_info['order_id'];
      
      $params = array(
        'merchant_id'=>$order_info['merchant_id'],
        'client_id'=>$client_id,
        'review'=>$review,
        'rating'=>$rating,
        'as_anonymous'=>$as_anonymous,
        'date_created'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR'],
        'order_id'=>$order_id,  
      );
        
      if ($website_review_type==2){
        
           $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
          
      }
                
        if ($website_review_type!=2){
          $actual_purchase = $this->functions->getOptionAdmin('website_reviews_actual_purchase');
        if($actual_purchase=="yes"){
         
          if (!$this->functions->checkIfUserCanRateMerchant($client_id,$order_info['merchant_id'])){          
             throw new Exception( 'Reviews are only accepted from actual purchases!');
          }
          if (!$this->functions->canReviewBasedOnOrder($client_id,$order_info['merchant_id'])){              
                throw new Exception( 'Sorry but you can make one review per order');                 
              }          
        }
        }
      
        if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){

          $last_insert_id = $this->functions->insertData('mt_review', $params);
          if ($last_insert_id!== false){ 
            $review_id=$last_insert_id;
            
           
          
          } else throw new Exception( 'ERROR. cannot insert data.');
        } else {
          $id = $res_review['id'];
          unset($params['date_created']);
          $params['date_modified'] = $this->functions->dateNow(); 

          

          $this->functions->updateData("mt_review",$params,'id',(integer)$id);

          
        }
        
        return true;
          
    } else throw new Exception( 'order details not found');
  }







    











	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/