<?php




class AjaxController extends Controller {


    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $this->PointsProgram = new PointsProgram();

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
    //}
      //echo $_REQUEST['url'];die();

     /*if (!$this->functions->isAdminLogin() && $_REQUEST['url']!='admin/login'){           
       
    $bases=Config::$baseUrl;
    header("Location: ".$bases."/admin/login");
exit();
    
        }*/



   //echo date('Y-m-d H:i:s');die();

        $this->data=$_POST; 
        if(isset($_GET['method'])){
            if($_GET['method']=="get"){
               $this->data=$_GET;
            }
        }

    }



    private function jsonResponse()
{
    // Create an array for the response
    $resp = array(
        'code' => $this->code,
        'msg' => $this->msg,
        'details' => $this->details
    );

    // Encode the response as JSON
    echo json_encode($resp);

    // End the script execution
    exit;
}




  public function SaveSettings()
    {       
        if(!$this->functions->isAdminLogin() ){
             exit();
        }
        
        
        $this->functions->updateOptionAdmin('points_enabled',
        isset($this->data['points_enabled'])?$this->data['points_enabled']:'' );
        
        $this->functions->updateOptionAdmin('pts_earning_points',
        isset($this->data['pts_earning_points'])?$this->data['pts_earning_points']:'' );
        
        $this->functions->updateOptionAdmin('pts_earning_points_value',
        isset($this->data['pts_earning_points_value'])?$this->data['pts_earning_points_value']:'' );
        
        $this->functions->updateOptionAdmin('pts_redeeming_point',
        isset($this->data['pts_redeeming_point'])?$this->data['pts_redeeming_point']:'' );
        
        $this->functions->updateOptionAdmin('pts_redeeming_point_value',
        isset($this->data['pts_redeeming_point_value'])?$this->data['pts_redeeming_point_value']:'' );
        
        $this->functions->updateOptionAdmin('pts_expiry',
        isset($this->data['pts_expiry'])?$this->data['pts_expiry']:'' );
        
        $this->functions->updateOptionAdmin('pts_account_signup',
        isset($this->data['pts_account_signup'])?$this->data['pts_account_signup']:'' );
        
        $this->functions->updateOptionAdmin('pts_merchant_reivew',
        isset($this->data['pts_merchant_reivew'])?$this->data['pts_merchant_reivew']:'' );
        
        $this->functions->updateOptionAdmin('pts_maximum_points',
        isset($this->data['pts_maximum_points'])?$this->data['pts_maximum_points']:'' );
        
        $this->functions->updateOptionAdmin('pts_first_order',
        isset($this->data['pts_first_order'])?$this->data['pts_first_order']:'' );
            
        $this->functions->updateOptionAdmin('points_apply_order_amt',
        isset($this->data['points_apply_order_amt'])?$this->data['points_apply_order_amt']:'' );
        
        $this->functions->updateOptionAdmin('points_minimum',
        isset($this->data['points_minimum'])?$this->data['points_minimum']:'' );
        
        $this->functions->updateOptionAdmin('points_max',
        isset($this->data['points_max'])?$this->data['points_max']:'' );
        
        $this->functions->updateOptionAdmin('pts_label',
        isset($this->data['pts_label'])?$this->data['pts_label']:'' );
                
        $this->functions->updateOptionAdmin('pts_payment_option',
        isset($this->data['pts_payment_option'])?json_encode($this->data['pts_payment_option']):'' );
                
        $this->functions->updateOptionAdmin('pts_label_input',
        isset($this->data['pts_label_input'])?$this->data['pts_label_input']:'' );
        
        $this->functions->updateOptionAdmin('pts_label_earn',
        isset($this->data['pts_label_earn'])?$this->data['pts_label_earn']:'' );
        
        $this->functions->updateOptionAdmin('pts_disabled_redeem',
        isset($this->data['pts_disabled_redeem'])?$this->data['pts_disabled_redeem']:'' );
        
        $this->functions->updateOptionAdmin('pts_redeem_balance_zero',
        isset($this->data['pts_redeem_balance_zero'])?$this->data['pts_redeem_balance_zero']:'' );
        
        $this->functions->updateOptionAdmin('pts_earn_points_status',
        isset($this->data['pts_earn_points_status'])?json_encode($this->data['pts_earn_points_status']):'' );
        
        $this->functions->updateOptionAdmin('pts_redeem_condition',
        isset($this->data['pts_redeem_condition'])?$this->data['pts_redeem_condition']:'' );
        
        $this->functions->updateOptionAdmin('points_based_earn',
        isset($this->data['points_based_earn'])?$this->data['points_based_earn']:'' );
        
        $this->functions->updateOptionAdmin('pts_earn_above_amount',
        isset($this->data['pts_earn_above_amount'])?$this->data['pts_earn_above_amount']:'' );
        
        $this->functions->updateOptionAdmin('pts_redeem_above_amount',
        isset($this->data['pts_redeem_above_amount'])?$this->data['pts_redeem_above_amount']:'' );
        
        $this->functions->updateOptionAdmin('points_disabled_merchant_settings',
        isset($this->data['points_disabled_merchant_settings'])?$this->data['points_disabled_merchant_settings']:'' );
        
        $this->functions->updateOptionAdmin('pts_book_table',
        isset($this->data['pts_book_table'])?$this->data['pts_book_table']:'' );
        
        $this->functions->updateOptionAdmin('pts_enabled_add_voucher',
        isset($this->data['pts_enabled_add_voucher'])?$this->data['pts_enabled_add_voucher']:'' );
        
        $this->functions->updateOptionAdmin('pts_enabled_offers_discount',
        isset($this->data['pts_enabled_offers_discount'])?$this->data['pts_enabled_offers_discount']:'' );
        
        $this->functions->updateOptionAdmin("earn_points_review_status",
            isset($this->data['earn_points_review_status'])?json_encode($this->data['earn_points_review_status']):1);
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Setting saved");
        $this->jsonResponse();
    }


public function userRewardPointsList()
{
    if (!$this->functions->isAdminLogin()) {
        exit();
    }

    $aColumns = array(
        'client_id',
        'first_name',
        'email_address',
        'first_name',
        'last_name',
        'client_id'
    );

    $t = $this->functions->AjaxData($aColumns);
    if (isset($_GET['debug'])) {
        //dump($t);
    }
if (is_array($t) && count($t)>=1){
    // Check if $t contains valid SQL parts
    $sWhere = isset($t['sWhere']) && !empty($t['sWhere']) ? $t['sWhere'] : '';
    $sOrder = isset($t['sOrder']) && !empty($t['sOrder']) ? $t['sOrder'] : '';
    $sLimit = isset($t['sLimit']) && !empty($t['sLimit']) ? $t['sLimit'] : '';
}
    // Build the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        client_id,
        CONCAT(first_name, ' ', last_name) as customer_name,
        email_address       
        FROM mt_client
        WHERE status = 'active'
    ";

    // Only add $sWhere if it's not empty
    if (!empty($sWhere)) {
        $stmt .= " $sWhere";
    }

    // Add $sOrder and $sLimit if they're set
    if (!empty($sOrder)) {
        $stmt .= " $sOrder";
    }

    if (!empty($sLimit)) {
        $stmt .= " $sLimit";
    }

    if (isset($_GET['debug'])) {
        echo($stmt);
    }

    // Prepare and execute the main query
    try {
        $pdoStatement = $this->db->prepare($stmt);
        $pdoStatement->execute();
        $res = $pdoStatement->fetchAll(PDO::FETCH_ASSOC);
        if(empty($res)){
            $this->otableNodata();
        }

        if ($res) {
            $iTotalRecords = 0;

            // Prepare and execute the count query
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $pdoStatementCount = $this->db->prepare($stmtc);
            $pdoStatementCount->execute();
            $resc = $pdoStatementCount->fetch(PDO::FETCH_ASSOC);

            if ($resc) {
                $iTotalRecords = $resc['total_records'];
            }

            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($res as $val) {
                $link1 = Config::$baseUrl . "/pointsprogram/index/viewlog/client_id/".$val['client_id'];
                $link2 = Config::$baseUrl . "/pointsprogram/index/editpoints/client_id/" . $val['client_id'];

                $view = '<a href="' . $link1 . '">' . $this->functions->translation("default", "View log") . '</a>';
                $edit = '<a href="' . $link2 . '">' . $this->functions->translation("default", "Edit Total Points") . '</a>';

                $feed_data['aaData'][] = array(
                    $val['client_id'],
                    $val['customer_name'],
                    $val['email_address'],
                    $this->functions->getTotalEarnPoints($val['client_id']),
                    $view,
                    $edit
                );
            }

            if (isset($_GET['debug'])) {
                dump($feed_data);
            }
            $this->otableOutput($feed_data);
        }
    } catch (PDOException $e) {
        // Handle SQL errors
        error_log($e->getMessage());
        $this->otableNodata();
    }
}


public function IncomePoints()
{
    if (!$this->functions->isClientLogin()) {  
        exit();
    }

    $client_id = $this->functions->getClientId();
    
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_earn
        WHERE status = :status AND client_id = :client_id
        ORDER BY id DESC
        LIMIT 1000
    ");
    
    $stmt->execute([
        ':status' => 'active',
        ':client_id' => $client_id
    ]);

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition('earn', $val['trans_type'], $val['order_id']);
            $feed_data['aaData'][] = [
                $this->functions->displayDate($val['date_created']),
                $label,
                "<span>+" . $val['total_points_earn'] . "</span>"
            ];
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}

public function ExpensesPoints()
{
    if (!$this->functions->isClientLogin()) {  
        exit();
    }

    $client_id = $this->functions->getClientId();
    
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_expenses
        WHERE status = :status AND client_id = :client_id
        ORDER BY id DESC
        LIMIT 1000
    ");
    
    $stmt->execute([
        ':status' => 'active',
        ':client_id' => $client_id
    ]);

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {                
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points']
            );
            
            $feed_data['aaData'][] = [
                $this->functions->displayDate($val['date_created']),
                $label,
                "<span>-" . $val['total_points'] . "</span>"
            ];
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function ExpiredPoints()
{
    if (!$this->functions->isClientLogin()) {  
        exit();
    }

    $pts_expiry = $this->functions->getOptionAdmin('pts_expiry');
    if ($pts_expiry == 3) {
        $this->otableNodata();
        exit();
    }

    $client_id = $this->functions->getClientId();
    
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_earn
        WHERE status = :status AND client_id = :client_id
        ORDER BY id DESC
        LIMIT 1000
    ");
    
    $stmt->execute([
        ':status' => 'expired',
        ':client_id' => $client_id
    ]);

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points_earn']
            );

            $feed_data['aaData'][] = [
                $this->functions->displayDate($val['date_created']),
                $label,
                "<span>+" . $val['total_points_earn'] . "</span>"
            ];
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function pointsbymerchant()
{       
    if (!$this->functions->isClientLogin()) {  
        exit();
    }
    
    $client_id = $this->functions->getClientId();      
    
    $stmt = $this->db->prepare("
        SELECT 
            a.merchant_id,
            b.restaurant_name,
            b.restaurant_slug
        FROM mt_points_earn a      
        LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id     
        WHERE a.merchant_id <> 0
        AND a.client_id = :client_id
        GROUP BY a.merchant_id      
        ORDER BY b.restaurant_name ASC
    ");
    
    $stmt->execute([
        ':client_id' => $client_id
    ]);

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {                
            $url = Config::$baseUrl . "/store/menu/slug/" . $val['restaurant_slug'];
            $link = "<a href=\"$url\" target=\"_blank\">" . $this->functions->clearString($val['restaurant_name']) . "</a>";
            
            $feed_data['aaData'][] = [
                $link,
                "<span>" . $this->PointsProgram->getTotalEarnPoints($client_id, $val['merchant_id'], 1) . "</span>"
            ];                              
        }
        $this->otableOutput($feed_data);    
    } else {
        $this->otableNodata();
    }
}



public function UserViewLogs()
{
    if (!$this->functions->isAdminLogin()) {
        exit();
    }

    $this->data = $_GET;

    $aColumns = array(
        'a.date_created',
        'b.first_name',
        'a.order_id',
        'a.total_points_earn',
        'a.total_points_earn'
    );

    $t = $this->functions->ajaxDataTables($aColumns);
    if (isset($_GET['debug'])) {
        dump($t);
    }

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // IMPORTANT: convert WHERE to AND (to avoid double WHERE)
    if (!empty($sWhere)) {
        $sWhere = str_replace('WHERE', 'AND', $sWhere);
    }

    $sql = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.*,        
            CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
            b.email_address     
        FROM
            mt_points_trans a
        LEFT JOIN
            mt_client b ON a.client_id = b.client_id
        WHERE 
            a.client_id = :client_id
            AND a.status = 'active'
            $sWhere
            $sOrder
            $sLimit
    ";

    if (isset($_GET['debug'])) {
        dump($sql);
    }

    $stmt = $this->db->prepare($sql);
    $stmt->bindValue(':client_id', (int)$this->data['client_id'], PDO::PARAM_INT);

    if ($stmt->execute()) {

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($res)) {
            $this->otableNodata();
            return;
        }

        // Total records
        $iTotalRecords = 0;
        $resc = $this->db->query("SELECT FOUND_ROWS() AS total_records");
        if ($resc) {
            $row = $resc->fetch(PDO::FETCH_ASSOC);
            $iTotalRecords = (int)$row['total_records'];
        }

        $feed_data = array();
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {

            $date_created = $this->functions->prettyDate($val['date_created'], true);
            $date_created = $this->functions->translateDate($date_created);

            $earn = '';
            $redeem = '';

            $transaction = $this->functions->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points_earn']
            );

            if ($val['points_type'] === "earn") {
                $earn = $val['total_points_earn'];
            } else {
                $redeem = $val['total_points_earn'];
            }

            $feed_data['aaData'][] = array(
                $date_created,
                $val['customer_name'],
                $transaction,
                $earn,
                $redeem
            );
        }

        if (isset($_GET['debug'])) {
            dump($feed_data);
        }

        $this->otableOutput($feed_data);
        return;
    }

    $this->otableNodata();
}







public function UserViewLogs_bkup()
{
    if (!$this->functions->isAdminLogin()) {
        exit();
    }

    $this->data = $_GET;

   

    $aColumns = array(
        'a.date_created',
        'first_name',
        'order_id',
        'total_points_earn',
        'total_points_earn'
    );

    $t = $this->functions->ajaxDataTables($aColumns);
    if (isset($_GET['debug'])) {
        dump($t);
    }

    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Prepare the SQL statement using PDO
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.*,        
            concat(b.first_name, ' ', b.last_name) as customer_name,
            b.email_address     
        FROM
            mt_points_trans a
        LEFT JOIN
            mt_client b ON a.client_id = b.client_id
        WHERE 
            a.client_id = :client_id
            AND a.status = 'active'
            $sWhere
            $sOrder
            $sLimit
    ";

    if (isset($_GET['debug'])) {
        dump($stmt);
    }

   

    // Use a prepared statement to execute the query
    $stmt = $this->db->prepare($stmt);
    $stmt->bindValue(':client_id', $this->data['client_id'], PDO::PARAM_INT);
    
    if ($res1=$stmt->execute()) {
        
     
        //print_r($res1);die();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);


       if (empty($res)) {
            $this->otableNodata();
        } else {
            
        }
        
        $iTotalRecords = 0;
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $resc = $this->db->query($stmtc);
        
        if ($resc) {
            $iTotalRecords = $resc->fetch(PDO::FETCH_ASSOC)['total_records'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created'], true);
            $date_created = $this->functions->translateDate($date_created);

            $earn = '';
            $redeem = '';
            $transaction = '';

            $transaction = $this->functions->PointsDefinition($val['points_type'], $val['trans_type'],
                $val['order_id'], $val['total_points_earn']);

            if ($val['points_type'] == "earn") {
                $earn = $val['total_points_earn'];
            } else {
                $redeem = $val['total_points_earn'];
            }

            $feed_data['aaData'][] = array(
                $date_created,
                $val['customer_name'],
                $transaction,
                $earn,
                $redeem
            );
        }
        if (isset($_GET['debug'])) {
            dump($feed_data);
        }
        $this->otableOutput($feed_data);
    }
    $this->otableNodata();
}


public function SavePoints()
    {       
        if(!$this->functions->isAdminLogin() ){
             exit();
        }
         
         
        if (isset($this->data['client_id'])){
            $user_points=$this->functions->getTotalEarnPoints($this->data['client_id']);           
            $adjustment=$this->data['user_points']-$user_points;            
            if ($adjustment>0){
                $params=array(
                  'client_id'=>$this->data['client_id'],
                  'total_points_earn'=>$adjustment,
                  'trans_type'=>"adjustment",
                  'status'=>'active',
                  'date_created'=>$this->functions->dateNow()
                );
                
                $this->functions->insertData('mt_points_earn', $params);
                $this->code=1;
                $this->msg=$this->functions->translation("default","points has been adjusted");
            } else {
                $params=array(
                  'client_id'=>$this->data['client_id'],
                  'total_points'=>$adjustment*-1,
                  'trans_type'=>"adjustment",
                  'status'=>'active',
                  'date_created'=>$this->functions->dateNow()
                );
                
                $this->functions->insertData('mt_points_expenses', $params);
                $this->code=1;
                $this->msg=$this->functions->translation("default","points has been adjusted");
            }
        } else $this->msg=$this->functions->translation("default","Missing client id");
        $this->jsonResponse();
    }




    public function applyRedeemPoints()
    {
        /*dump($this->data);
        die();*/



        $mt_pts_enabled_add_voucher = '';
        $mt_pts_enabled_offers_discount = '';       
        
        $is_merchant_setting_disabled  = $this->PointsProgram->isMerchantSettingsDisabled();   
        
        $pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');       
        $pts_enabled_offers_discount = $this->functions->getOptionAdmin('pts_enabled_offers_discount');
        
        
        /*check if voucher already applied*/
        if($pts_enabled_add_voucher!=1){
            if(!$is_merchant_setting_disabled){             
                $mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher',$this->data['merchant_id']);               
            }
            
            if (empty($mt_pts_enabled_add_voucher)){
                if (isset($_SESSION['voucher_code'])  && is_array($_SESSION['voucher_code']) ){
                    

                    $this->msg="Sorry but you cannot redeem points if you have already voucher applied on your cart"; 

                    $this->jsonResponse();
                    exit();
                }       
            }
        }
        
        if($pts_enabled_offers_discount!=1){            
            if(!$is_merchant_setting_disabled){
                $mt_pts_enabled_offers_discount = $this->functions->getOption('mt_pts_enabled_offers_discount',$this->data['merchant_id']);
            }           
            if (empty($mt_pts_enabled_offers_discount)){
                if (isset($_SESSION['promo_discount'])){
                    if ($_SESSION['promo_discount']==1){
                        

                        $this->msg="Sorry you cannot apply voucher, exising discount is alread applied in your cart";

                        $this->jsonResponse();
                        exit();
                    }   
                }
            }
        }
        
        if ( $this->data['redeem_points']<1){
            $this->msg="Redeem points must be greater than zero"; 
            $this->jsonResponse();
            exit();
        }
        if ( $this->data['subtotal_order']<1){
            $this->msg="Subtotal is missing"; 
            $this->jsonResponse();
            exit();
        }
        
        $merchant_id=isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
             
        $balance_points=$this->PointsProgram->getTotalEarnPoints(
          $this->functions->getClientId(),isset($this->data['merchant_id'])?$this->data['merchant_id']:''
        );  
                   
        
        if ( $balance_points<$this->data['redeem_points']){
            $this->msg="Sorry but your points is not enough"; 
            $this->jsonResponse();
            exit();
        }
        
        
        $points_apply_order_amt=$this->functions->getOptionAdmin('points_apply_order_amt');
        
        $disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();
                
        if(!$disabled_merchant_settings){
            $mt_points_apply_order_amt=$this->functions->getOption('mt_points_apply_order_amt',$this->data['merchant_id']);
            if(!empty($mt_points_apply_order_amt)){
                $points_apply_order_amt = $mt_points_apply_order_amt;
            }
        }
        
        if ($points_apply_order_amt>0){
            if ( $points_apply_order_amt>$this->data['subtotal_order'] ){
               $this->msg = "Sorry but you can only redeem points on orders over " . 
               $this->functions->normalPrettyPrice($points_apply_order_amt);

                $this->jsonResponse();
                exit();
            }
        }
                    
        $points_minimum=$this->functions->getOptionAdmin('points_minimum');    
                
        if(!$disabled_merchant_settings){
            $mt_points_minimum = $this->functions->getOption('mt_points_minimum',$merchant_id);
            if(!empty($mt_points_minimum)){
                $points_minimum = $mt_points_minimum;
            }
        }
            
        if ($points_minimum>0){
            if ( $points_minimum>$this->data['redeem_points']){
                $this->msg="Sorry but Minimum redeem points can be used is"." ".$points_minimum;  
                $this->jsonResponse();
                exit();
            }
        }
        
        $points_max=$this->functions->getOptionAdmin('points_max');
        if(!$disabled_merchant_settings){
            $mt_points_max = $this->functions->getOption('mt_points_max',$merchant_id);
            if(!empty($mt_points_max)){
                $points_max = $mt_points_max;
            }
        }       
        
        if ( $points_max>0){
            if ( $points_max<$this->data['redeem_points']){
                $this->msg="Sorry but Maximum redeem points can be used is"." ".$points_max;  
                $this->jsonResponse();
               exit();
            }
        }
        
        /*convert the redeem points to amount value*/
        $pts_redeeming_point=$this->functions->getOptionAdmin('pts_redeeming_point');
        $pts_redeeming_point_value=$this->functions->getOptionAdmin('pts_redeeming_point_value');
                
        if(!$disabled_merchant_settings){
            $mt_pts_redeeming_point = $this->functions->getOption('mt_pts_redeeming_point',$merchant_id);
            $mt_pts_redeeming_point_value= $this->functions->getOption('mt_pts_redeeming_point_value',$merchant_id);
            if($mt_pts_redeeming_point>0){
                $pts_redeeming_point = $mt_pts_redeeming_point;
            }
            if($mt_pts_redeeming_point_value>0){
                $pts_redeeming_point_value = $mt_pts_redeeming_point_value;
            }
        }
        
        if ($pts_redeeming_point<0.01){         
            unset($_SESSION['pts_redeem_amt']);
            unset($_SESSION['pts_redeem_points']);
            $this->msg="Error Redeeming Point less than zero on the backend settings";    
            $this->jsonResponse();
            exit();
        } 
        
        if ($pts_redeeming_point_value<0.01){
            unset($_SESSION['pts_redeem_amt']);
            unset($_SESSION['pts_redeem_points']);
            $this->msg="Error Redeeming Point value is less than zero on the backend settings";   
            $this->jsonResponse();
            exit();
        }
        
        //$amt=($this->data['redeem_points']/$pts_redeeming_point)*$pts_redeeming_point_value;
        $temp_redeem=intval($this->data['redeem_points']/$pts_redeeming_point);
        $amt=$temp_redeem*$pts_redeeming_point_value;
        $amt=$this->functions->normalPrettyPrice($amt);
        
        
        if ( $this->data['subtotal_order']<$amt){
            //$this->msg=PointsProgram::t("Sorry you cannot redeem points which is greater than your sub order total"); 
            $this->msg="Sorry you cannot redeem points which the Sub Total will become negative when after applying the points";  
            $this->jsonResponse();
            exit();
        }               
        
        $this->code=1;
        $this->msg="OK";
        $this->details=array(
          'pts_points' => $this->data['redeem_points'] . " Points",

          'pts_amount'=> "-".$this->PointsProgram->price($amt)
        );
        $_SESSION['pts_redeem_amt']=$amt;
        $_SESSION['pts_redeem_points']=$this->data['redeem_points'];
                
        $this->jsonResponse();
    }

    public function RemoveRedeemPoints()
    {
        unset($_SESSION['pts_redeem_amt']);
        unset($_SESSION['pts_redeem_points']);
        $this->code=1; $this->msg="OK";
        $this->jsonResponse();
    }







 public function PointsViewLogs()
{
    if (!$this->functions->isAdminLogin()) {
        exit();
    }

    $this->data = $_GET;
    $aColumns = array(
        'a.date_created',
        'first_name',
        'order_id',
        'total_points_earn',
        'total_points_earn'
    );

    $t = $this->functions->ajaxDataTables($aColumns);
    if (isset($_GET['debug'])) {
        dump($t);
    }

    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.*,        
    CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
    b.email_address     
    FROM
    mt_points_trans a
    LEFT JOIN mt_client b
    ON a.client_id = b.client_id
    WHERE a.status = 'active'
    $sWhere
    $sOrder
    $sLimit
    ";

    if (isset($_GET['debug'])) {
        dump($stmt);
    }

    try {
        // Execute main query
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Check if we have results
        if ($res) {
            // Get total records
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->prepare($stmtc);
            $queryc->execute();
            $resc = $queryc->fetch(PDO::FETCH_ASSOC);
            $iTotalRecords = $resc['total_records'];

            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($res as $val) {
                $date_created = $this->functions->prettyDate($val['date_created'], true);
                $date_created = $this->functions->translateDate($date_created);

                $earn = '';
                $redeem = '';
                $transaction = '';

                $transaction = $this->functions->PointsDefinition(
                    $val['points_type'],
                    $val['trans_type'],
                    $val['order_id'],
                    $val['total_points_earn']
                );

                if ($val['points_type'] == "earn") {
                    $earn = $val['total_points_earn'];
                } else {
                    $redeem = $val['total_points_earn'];
                }

                $feed_data['aaData'][] = array(
                    $date_created,
                    $val['customer_name'],
                    $transaction,
                    $earn,
                    $redeem
                );
            }

            if (isset($_GET['debug'])) {
                dump($feed_data);
            }

            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (PDOException $e) {
        // Handle exception, if necessary
        error_log($e->getMessage());
        $this->otableNodata(); // Return no data if error occurs
    }
}






    public function otableOutput($feed_data='')
        {
          echo json_encode($feed_data);
          die();
        }
        public function otableNodata()
        {
            if (isset($_GET['sEcho'])){
                $feed_data['sEcho']=$_GET['sEcho'];
            } else $feed_data['sEcho']=1;      
                 
            $feed_data['iTotalRecords']=0;
            $feed_data['iTotalDisplayRecords']=0;
            $feed_data['aaData']=array();       
            echo json_encode($feed_data);
            die();
        }






}
