<?php
class AjaxController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		
        
        
        $this->DatatablesWrapper = new DatatablesWrapper();
        $this->SingleAppClass = new SingleAppClass();
        

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}


    public function merchantList()
{
    $cols = array(
        'merchant_id','restaurant_name','single_app_keys','status','merchant_id'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = " AND status IN ('active')";

    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    if (!empty($search_fields)) {
        $and .= " AND (
            restaurant_name LIKE :search_name OR
            merchant_id = :search_id
        )";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS a.*
    FROM mt_merchant a
    WHERE 1             
    $and
    $order
    $limit
    ";

    $params = [];
    if (!empty($search_fields)) {
        $params[':search_name'] = "$search_fields%";
        $params[':search_id'] = (int)$search_fields;
    }

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = 0;

        $foundRows = $this->db->query("SELECT FOUND_ROWS() as total_records");
        if ($resc = $foundRows->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $settings = Config::$baseUrl . "/singlemerchant/index/merchant_settings/merchant_id/" . $val['merchant_id'];
            $action = '<a class="btn btn-raised btn-info" href="' . $settings . '">' . ("settings") . '</a>';
            $feed_data['aaData'][] = array(
                $val['merchant_id'],
                $val['restaurant_name'],
                $val['single_app_keys'],
                $this->SingleAppClass->prettyBadge($val['status']),
                $action
            );
        }

        if (isset($_GET['debug'])) {
            dump($feed_data);
        }

        $this->otableOutput($feed_data);
    }

    $this->otableNodata();
}


public function validate_lang()
    {       
        header("Content-type:application/javascript");
        echo '
        $.extend( $.validator.messages, {
            required: "'. ("This field is required.") . '" ,
            remote:  "'. ("Please correct this field to continue") . '" ,
            email: "'. ("Please enter a valid email address") . '" ,
            url: "'. ("Please enter a valid website address") . '" ,
            date: "'. ("Please enter a valid date") . '" ,
            dateISO: "'. ("Please enter a valid date (ISO)") . '" ,
            number: "'. ("Please enter a valid number") . '" ,
            digits: "'. ("Please enter numbers only") . '" ,
            creditcard: "'. ("Please enter a valid credit card number") . '" ,
            equalTo: "'. ("Please enter the same value") . '" ,
            extension: "'. ("Please enter a file with an approved extension") . '" ,
            maxlength: $.validator.format( "'. ("Maximum number of characters is {0}") . '"  ),
            minlength: $.validator.format( "'. ("The minimum number of characters is {0}") . '"  ),
            rangelength: $.validator.format( "'. ("The number of characters must be between {0} and {1}") . '"  ),
            range: $.validator.format( "'. ("Please enter a value between {0} and {1}") . '"   ),
            max: $.validator.format( "'. ("Please enter less than or equal to {0}") . '"  ),
            min: $.validator.format(  "'. ("Please enter more than or equal to {0}") . '"  )
        } ); '; 
    }



    public function getNotification()
    {       
      $this->code = 2;      
            $this->msg = "No new notification";
            $this->details = null;
            $this->jsonResponse();
    }

    public function generateKeys()
    {
        $single_app_keys  = $this->SingleAppClass->generateMerchantKeys();
        $this->code = 1;
        $this->msg = "OK";
        $this->details= $single_app_keys;
        $this->jsonResponse();      
    }


   public function errorDetails()
{
    $this->data = $_GET;
    $stmt = '';
    $id = isset($this->data['details_id']) ? (int)$this->data['details_id'] : '';
    $current_page = isset($this->data['current_page']) ? $this->data['current_page'] : '';

    if ($id > 0) {
        switch ($current_page) {
            case "push_logs":
                $stmt = "
                    SELECT json_response as fcm_response
                    FROM mt_singleapp_mobile_push_logs
                    WHERE id = :id
                    LIMIT 1
                ";
                break;

            case "push_broadcast":
                $stmt = "
                    SELECT fcm_response
                    FROM mt_singleapp_broadcast
                    WHERE broadcast_id = :id
                    LIMIT 1
                ";
                break;

            default:
                break;
        }

        if (!empty($stmt)) {
            $query = $this->db->prepare($stmt);
            $query->bindValue(':id', $id, PDO::PARAM_INT);
            $query->execute();
            if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
                $this->code = 1;
                $this->msg = !empty($res['fcm_response']) ? $res['fcm_response'] : "None";
            } else {
                $this->msg = "Record not found";
            }
        } else {
            $this->msg = "Invalid table";
        }
    } else {
        $this->msg = "Invalid details id";
    }

    $this->jsonResponse();
}



    public function save_socialsettings()
  {
    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
      if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
      
      $this->code = 1;    
      $this->msg = ("Successful");           
      
    $this->functions->updateOption("singleapp_enabled_fblogin",
      isset($this->data['singleapp_enabled_fblogin'])?$this->data['singleapp_enabled_fblogin']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_enabled_google",
      isset($this->data['singleapp_enabled_google'])?$this->data['singleapp_enabled_google']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_fb_save_pic",
      isset($this->data['singleapp_fb_save_pic'])?$this->data['singleapp_fb_save_pic']:''
      ,$merchant_id);
      
    $this->jsonResponse();
  }



    public function savesettings()
    {       
        $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
        
        $single_app_keys = isset($this->data['single_app_keys'])?$this->data['single_app_keys']:'';
        if(empty($single_app_keys)){
            $this->msg = "Merchant keys is required";
            $this->jsonResponse();
        }       
        $params = array(
          'single_app_keys'=>trim($this->data['single_app_keys']),
          'date_modified'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );      
        if($merchant_id>0){
            
            if ($this->functions->updateData("mt_merchant",$params,'merchant_id',$merchant_id)){
                $this->code = 1;
                $this->msg = ("Successful");
            } else $this->msg = ("Failed cannot update. please try again later");
        } else $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
    }


    public function save_sandroidsettings()
  { 
    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
      if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
      
      $this->code = 1;    
      $this->msg = ("Successful");  
      
      $this->functions->updateOption("singleapp_enabled_pushpic",
      isset($this->data['singleapp_enabled_pushpic'])?$this->data['singleapp_enabled_pushpic']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_push_icon",
      isset($this->data['singleapp_push_icon'])?$this->data['singleapp_push_icon']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_push_picture",
      isset($this->data['singleapp_push_picture'])?$this->data['singleapp_push_picture']:''
      ,$merchant_id);
      
    $this->jsonResponse();
  }

    public function actionsave_fcm()
  {
    
    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';   
      if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
      
      $this->code = 1;    
      $this->msg = ("Successful");  
            
    $this->functions->updateOption("singleapp_android_push_key",
      isset($this->data['singleapp_android_push_key'])?$this->data['singleapp_android_push_key']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_fcm_provider",
      isset($this->data['singleapp_fcm_provider'])?$this->data['singleapp_fcm_provider']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_services_account_json",
      isset($this->data['singleapp_services_account_json'])?$this->data['singleapp_services_account_json']:''
      ,$merchant_id);
      
    $this->jsonResponse();
  }


    public function sendpush()
  {
    
    if(empty($this->data['push_title'])){
      $this->msg ="Push title is required";
      $this->jsonResponse();
    }
    if(empty($this->data['push_message'])){
      $this->msg ="Push message is required";
      $this->jsonResponse();
    }
          
      $id = isset($this->data['id'])?(integer)$this->data['id']:0;      
      if($id>0){
        if ($data = $this->SingleAppClass->getDeviceByID($id)){                    
          $params = array(
            'client_id'=>$data['client_id'],
            'client_name'=>$data['first_name']." ".$data['last_name'],
            'device_platform'=>$data['device_platform'],
            'device_id'=>$data['device_id'],
            'push_title'=>$this->data['push_title'],
            'push_message'=>$this->data['push_message'],
            'push_type'=>"campaign",
            'date_created'=>$this->functions->dateNow(),
            'ip_address'=>$_SERVER['REMOTE_ADDR'],
            'registration_type'=>$this->SingleAppClass->registrationType(),  
            'merchant_id'=>$data['merchant_id']
          );                
          if($this->functions->insertData("mt_singleapp_mobile_push_logs",$params)){  
            $this->code = 1;
            $this->msg = ("Request has been sent");       
            //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("singlemerchant/cron/processpush"));           
          } else $this->msg = ("failed cannot insert records. please try again later");
        } else $this->msg = ("customer id not found");
      } else $this->msg = ("Invalid customer id");
      $this->jsonResponse();
  }


public function pageList()
{
    $cols = array(
        'page_id', 'title',
        'content', 'sequence',
        'date_created', 'page_id'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $merchant_id = isset($this->data['merchant_id']) ? $this->data['merchant_id'] : 0;
    if ($merchant_id <= 0) {
        $this->otableNodata();
    }

    // SQL Query for selecting data
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* 
             FROM mt_singleapp_pages a 
             WHERE merchant_id = :merchant_id 
             $order 
             $limit";
    
    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute and fetch results
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        // Fetch total records
        $total_records = 0;
        $countQuery = $this->db->query("SELECT FOUND_ROWS() AS total_records");
        $countResult = $countQuery->fetch(PDO::FETCH_ASSOC);
        if ($countResult) {
            $total_records = $countResult['total_records'];
        }

        // Prepare feed data
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        // Process each result row
        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created'], true);
            $date_created = $this->functions->translateDate($date_created);

            $page_id = $val['page_id'];
            $action = '<a href="javascript:;" class="edit_page btn btn-info" data-page_id="' . $page_id . '"><i class="fas fa-edit" aria-hidden="true"></i></a>';
            $action .= '<a href="javascript:;" class="delete_page btn btn-danger" data-page_id="' . $page_id . '"><i class="fas fa-trash" aria-hidden="true"></i></a>';

            $status = $this->SingleAppClass->prettyBadge($val['status']);

            $val['content'] = stripslashes(strip_tags($val['content']));
            $use_html = '';
            $content = "<p class=\"concat-text\">" . $val['content'] . "..." . "</p>";
            if ($val['use_html'] == 2) {
                $use_html = '<i class="fa fa-check"></i>';
            }

            $feed_data['aaData'][] = array(
                $val['page_id'],
                stripslashes($val['title']),
                $content,
                $val['icon'],
                $use_html,
                $val['sequence'],
                $status . '<br/>' . $date_created,
                $action
            );
        }

        $this->otableOutput($feed_data);
    }
    $this->otableNodata();
}







  public function save_page()
    {     
      $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
    
    if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
      
      
      $params = array(
        'merchant_id'=>$merchant_id,
        'title'=>isset($this->data['title'])?$this->data['title']:'',
        'content'=>isset($this->data['content'])?$this->data['content']:'',
        'use_html'=>isset($this->data['use_html'])?$this->data['use_html']:0,
        'icon'=>isset($this->data['icon'])?$this->data['icon']:'',
        'sequence'=>isset($this->data['sequence'])?$this->data['sequence']:'0',
        'status'=>isset($this->data['status'])?$this->data['status']:'',
        'date_created'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR']
      );
      
      if($params['sequence']<=0){       
        if($max_count = $this->SingleAppClass->getMaxPage($merchant_id)){          
          $params['sequence']=$max_count;
        }         
      }
           
      
      if($this->functions->multipleField()){           
        if ( $fields=$this->functions->getLanguageList(false)){
          foreach ($fields as $lang) {            
            $params["title_$lang"] = isset($this->data["title_$lang"])?$this->data["title_$lang"]:'';
            $params["content_$lang"] = isset($this->data["content_$lang"])?$this->data["content_$lang"]:'';
          }
        }       
      }
              

      $page_id = isset($this->data['page_id'])?$this->data['page_id']:'';
      if($page_id>0){       
        unset($params['date_created']);
        $params['date_modified']=$this->functions->dateNow();        
        if($this->functions->updateData("mt_singleapp_pages",$params,'page_id',$page_id)){
          $this->code = 1;
          $this->msg = ("Page Succesfully updated");          
        } else $this->msg = ("Failed cannot update records");
      } else {

        if (!$this->SingleAppClass->getPageByTitle($merchant_id,$params['title'])){

          $this->functions->insertData("mt_singleapp_pages",$params);
          $this->code = 1;
          $this->msg = ("Page Succesfully added");
        } else $this->msg = ("Page title already exist");
      }
      
      $this->jsonResponse();
    }  


    public function get_page()
    {     
      $page_id = isset($this->data['page_id'])?$this->data['page_id']:'';    
      if($page_id>=1){
        if ($res=$this->SingleAppClass->getPageByID($page_id)){   
          
          $lang=array();
         
                
          $this->code = 1;
          $this->msg = "ok";
          $this->details = array(
           'lang'=>$lang,
           'data'=>$res
          );
                    
        } else $this->msg = ("Records not found");
      } else $this->msg = ("Invalid page id");
      $this->jsonResponse();
    }

   public function deletePages()
{
    $this->data = $_GET;
    $page_id = isset($this->data['page_id']) ? (int)$this->data['page_id'] : 0;

    if ($page_id > 0) {
        $stmt = $this->db->prepare("DELETE FROM mt_singleapp_pages WHERE page_id = :page_id");
        $stmt->bindParam(':page_id', $page_id, PDO::PARAM_INT);
        $stmt->execute();

        $this->code = 1;
        $this->msg = "OK";
        $this->details = '';
    } else {
        $this->msg = "invalid page id";
    }

    $this->jsonResponse();
}


public function save_contactus()
    {
      
       $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
    
    if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
    
    $this->code = 1;    
      $this->msg = ("Setting saved");

        $this->functions->updateOption("singleapp_contact_email",
      isset($this->data['singleapp_contact_email'])?$this->data['singleapp_contact_email']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_contact_tpl",
      isset($this->data['singleapp_contact_tpl'])?$this->data['singleapp_contact_tpl']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_contact_subject",
      isset($this->data['singleapp_contact_subject'])?$this->data['singleapp_contact_subject']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_contactus_fields",
      isset($this->data['singleapp_contactus_fields'])?json_encode($this->data['singleapp_contactus_fields']):''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_contactus_enabled",
      isset($this->data['singleapp_contactus_enabled'])?$this->data['singleapp_contactus_enabled']:''
      ,$merchant_id);
            
      $this->jsonResponse();
    }


  public function registeredDeviceList()
{
    $cols = array(
        'client_id', 'first_name', 'device_uiid', 'device_platform',
        'device_id', 'push_enabled', 'date_created', 'client_id'
    );

    // Format the request for Datatables (handling order and limit)
    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    // Default conditions for the query
    $and = " AND a.status IN ('active')";
    $and .= " AND a.device_id !='' ";

    // Handle search fields if available
    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    if (!empty($search_fields)) {
        $search = "%$search_fields%";
        $and .= " AND (
            b.first_name LIKE :search OR
            b.last_name LIKE :search OR
            a.device_platform LIKE :search OR
            a.device_uiid LIKE :search OR
            a.device_id LIKE :search
        )";
    }

    // Main query to fetch device data
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*,
        b.first_name,
        b.last_name,
        b.last_login
        FROM mt_singleapp_device_reg a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE 1
        $and
        $order
        $limit";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);

    // Bind search value if necessary
    if (!empty($search_fields)) {
        $query->bindValue(':search', $search, PDO::PARAM_STR);
    }

    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Fetch the total number of records
        $countStmt = $this->db->query("SELECT FOUND_ROWS() as total_records");
        $resc = $countStmt->fetch(PDO::FETCH_ASSOC);
        $total_records = isset($resc['total_records']) ? $resc['total_records'] : 0;

        // Prepare the response data
        $feed_data = [
            'draw' => $this->data['draw'],
            'recordsTotal' => $total_records,
            'recordsFiltered' => $total_records,
            'aaData' => []
        ];

        // Loop through the results and prepare them for output
        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
            $last_login = $this->functions->prettyDate($val['last_login']) . " " . $this->functions->prettyTime($val['date_created']);

            $link = Config::$baseUrl . "/singlemerchant/index/send_push/id/" . $val['client_id'];        

            $enabled_push = $val['push_enabled'] == 1 ? "Yes" : "No";
            $subscribe_topic = $val['subscribe_topic'] == 1 ? "Yes" : "No";

            // Build the actions HTML
            $actions = '<a href="javascript:;" data-id="' . $val['id'] . '" class="send_push">Send push</a>';

            // Build the device ID display
            $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . $val['device_id'] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\">";
            $info .= '<div class="concat-text">' . $val['device_id'] . "</div>";
            $info .= "</a>";

            // Populate the feed data array
            $feed_data['aaData'][] = array(
                $val['client_id'],
                $val['first_name'] . " " . $val['last_name'],
                strtolower($val['device_platform']),
                "<p class=\"concat-text\">" . $val['device_uiid'] . "</p>",
                $info,
                $this->SingleAppClass->prettyBadge($enabled_push),
                $this->SingleAppClass->prettyBadge($subscribe_topic),
                $date_created,
                $last_login,
                $actions
            );
        }

        // Output the data in the format expected by the front-end
        $this->otableOutput($feed_data);
        return;
    }

    // If no data found, call the no data output function
    $this->otableNodata();
}


public function pushBroadcast()
{
    $cols = array(
        'broadcast_id', 'push_title', 'push_message', 'restaurant_name',
        'device_platform', 'date_created', 'date_modified'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);     
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = " AND fcm_version = 1 ";

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*,
                    IFNULL(b.restaurant_name, '') as restaurant_name
            FROM mt_singleapp_broadcast a
            LEFT JOIN mt_merchant b ON a.merchant_list = b.merchant_id
            WHERE 1       
            $and
            $order
            $limit";

    $query = $this->db->prepare($stmt);
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Check if there are any records returned
        if (empty($res)) {
            $this->otableNodata();  
            return;
        }

        $countStmt = $this->db->query("SELECT FOUND_ROWS() as total_records");
        $resc = $countStmt->fetch(PDO::FETCH_ASSOC);
        $total_records = isset($resc['total_records']) ? $resc['total_records'] : 0;

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {

            $details_link = Config::$baseUrl . "/singlemerchant/index/broadcast_details/id/" . $val['broadcast_id'];

            $action = '<a href="' . $details_link . '">' . ("View details") . '</a>';

            $date_modified = $this->functions->prettyDate($val['date_modified']) . " " . $this->functions->prettyTime($val['date_modified']);     

            $t = $this->SingleAppClass->prettyBadge($val['status']);                 
            $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['broadcast_id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\" >
                   <i class=\"pl-2 fas fa-question-circle\"></i></a> ";

            $t .= "<div></div>";
            $t .= $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

            $feed_data['aaData'][] = array(         
                $val['broadcast_id'],
                $val['push_title'],
                $val['push_message'],    
                $val['restaurant_name'],      
                ($val['device_platform']),
                $t,
                $date_modified
            );
        }

        if (isset($_GET['debug'])) {
            // Add any debug logic here if needed
        }

        $this->otableOutput($feed_data);  
        return;
    }

    $this->otableNodata();  
}

public function merchant_list()
{
    $this->data = $_GET;
    $data = array();
    $and = '';

    if (isset($this->data['search'])) {
        if (strlen($this->data['search']) > 0) {
            $and = " AND restaurant_name LIKE :search ";
        }
    }

    $stmt = "
        SELECT merchant_id as id, restaurant_name as text
        FROM mt_merchant
        WHERE status IN ('active')
        AND single_app_keys <> ''
        $and
        ORDER BY restaurant_name ASC
        LIMIT 0, 20
    ";

    $query = $this->db->prepare($stmt);

    // Bind the search parameter if it exists
    if (strlen($this->data['search']) > 0) {
        $query->bindValue(':search', $this->data['search'] . '%', PDO::PARAM_STR);
    }

    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Assign the results to data
        $data = $res;
    }

    $result = array(
        'results' => $data
    );

    header('Content-type: application/json');
    echo json_encode($result);
}


public function save_broadcast()
    {           
      
      $merchant_id = isset($this->data['merchant_list'])?(integer)$this->data['merchant_list']:0;
      if($merchant_id<0){
        $this->msg = ("Merchant is required");
        $this->jsonResponse();
      }
      
      $params = array(
         'push_title'=>isset($this->data['push_title'])?$this->data['push_title']:'',
         'push_message'=>isset($this->data['push_message'])?$this->data['push_message']:'',
         'device_platform'=>"",
         'date_created'=>$this->functions->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR'],
         'fcm_version'=>isset($this->data['fcm_version'])?$this->data['fcm_version']:'',
         'merchant_list'=>$merchant_id
      );      
            
      if($this->functions->insertData("mt_singleapp_broadcast",$params)){ 
        $this->code = 1;
        $this->msg = "Successful";                        
                        
      } else $this->msg = ("Failed cannot insert records");
      $this->jsonResponse();
    }





    public function pushLogs()
{
    $cols = array(
        'id', 'push_type', 'client_name', 'device_platform',
        'device_id',
        'push_title', 'push_message', 'date_created', 'date_process'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);     
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = " AND registration_type ='fcm' ";    

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*
    FROM mt_singleapp_mobile_push_logs a
    WHERE 1       
    $and
    $order
    $limit
    ";

    $query = $this->db->prepare($stmt);
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if (empty($res)) {
            $this->otableNodata();  
            return;
        }

        $total_records = 0;                 
        $countStmt = $this->db->query("SELECT FOUND_ROWS() as total_records");
        if ($resc = $countStmt->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }     

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $t = $this->SingleAppClass->prettyBadge($val['status']);                       
            $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\" >
            <i class=\"pl-2 fas fa-question-circle\"></i></a> ";                      
            $t .= "<div></div>";

            $t .= $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

            $date_process = $this->functions->prettyDate($val['date_process']) . " " . $this->functions->prettyTime($val['date_process']);

            $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . $val['device_id'] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\" >";
            $info .= '<div class="concat-text">' . $val['device_id'] . "</div>";
            $info .= "</a>";        

            $feed_data['aaData'][] = array(
                $val['id'],
                ($val['push_type']),
                $val['client_name'],
                (strtolower($val['device_platform'])),
                $info,
                ($val['push_title']),
                ($val['push_message']),
                $t, 
                $date_process       
            );
        }     
        $this->otableOutput($feed_data);  
        return;
    }

    $this->otableNodata();  
}


public function order_trigger()
{
    $this->data = $_POST;
    $feed_data = array();

    $cols = array(
        'trigger_id','trigger_type',
        'order_id','order_status','remarks','date_created'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM
    mt_singleapp_order_trigger a
    WHERE 1
    $where
    $order
    $limit";

    $query = $this->db->prepare($stmt);
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        $total_records = 0;
        $countQuery = $this->db->query("SELECT FOUND_ROWS() as total_records");
        $resc = $countQuery->fetch(PDO::FETCH_ASSOC);
        if ($resc) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = array();
        foreach ($res as $val) {
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 5) {
                        $t = $this->SingleAppClass->prettyBadge($val['status']);
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        $cols_data[] = $t;
                    } elseif ($key_cols == 1) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 3) {
                        $cols_data[] = ($val[$cols_val]);
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}








	
	
	 


    public function datable_localize()
    {
        header('Content-type: application/json');
        $data = array(
          'decimal'=>'',
          'emptyTable'=> 'No data available in table',
          'info'=> "Showing _START_ to _END_ of _TOTAL_ entries",
          'infoEmpty'=> "Showing 0 to 0 of 0 entries",
          'infoFiltered'=>"filtered from _MAX_ total entries",
          'infoPostFix'=>'',
          'thousands'=>',',
          'lengthMenu'=> "Show _MENU_ entries",
          'loadingRecords'=>('Loading...'),
          'processing'=>("Processing..."),
          'search'=>("Search:"),
          'zeroRecords'=>("No matching records found"),
          'paginate' =>array(
            'first'=>("First"),
            'last'=>("Last"),
            'next'=>("Next"),
            'previous'=>("Previous")
          ),
          'aria'=>array(
            'sortAscending'=>(": activate to sort column ascending"),
            'sortDescending'=>(": activate to sort column descending")
          )
        );      
        echo json_encode($data);
    }  


    public function save_appsettings()
  {
    
        $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
    
    if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
    
    $this->code = 1;    
      $this->msg = ("Successful");

        $this->functions->updateOption("singleapp_default_image",
      isset($this->data['singleapp_default_image'])?$this->data['singleapp_default_image']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_location_accuracy",
      isset($this->data['singleapp_location_accuracy'])?$this->data['singleapp_location_accuracy']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_default_lang",
      isset($this->data['singleapp_default_lang'])?$this->data['singleapp_default_lang']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_help_url",
      isset($this->data['singleapp_help_url'])?$this->data['singleapp_help_url']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_terms_url",
      isset($this->data['singleapp_terms_url'])?$this->data['singleapp_terms_url']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_privacy_url",
      isset($this->data['singleapp_privacy_url'])?$this->data['singleapp_privacy_url']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_time_format",
      isset($this->data['singleapp_time_format'])?$this->data['singleapp_time_format']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_time_interval",
      isset($this->data['singleapp_time_interval'])?$this->data['singleapp_time_interval']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_reg_email",
      isset($this->data['singleapp_reg_email'])?$this->data['singleapp_reg_email']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_reg_phone",
      isset($this->data['singleapp_reg_phone'])?$this->data['singleapp_reg_phone']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_reg_verification_enabled",
      isset($this->data['singleapp_reg_verification_enabled'])?$this->data['singleapp_reg_verification_enabled']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_remove_phone_prefix",
      isset($this->data['singleapp_remove_phone_prefix'])?$this->data['singleapp_remove_phone_prefix']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_menu_type",
      isset($this->data['singleapp_menu_type'])?$this->data['singleapp_menu_type']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_disabled_default_menu",
      isset($this->data['singleapp_disabled_default_menu'])?$this->data['singleapp_disabled_default_menu']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_tracking_theme",
      isset($this->data['singleapp_tracking_theme'])?$this->data['singleapp_tracking_theme']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_tracking_interval",
      isset($this->data['singleapp_tracking_interval'])?$this->data['singleapp_tracking_interval']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_distance_results",
      isset($this->data['singleapp_distance_results'])?$this->data['singleapp_distance_results']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_order_processing",
      isset($this->data['singleapp_order_processing'])?json_encode($this->data['singleapp_order_processing']):''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_order_completed",
      isset($this->data['singleapp_order_completed'])?json_encode($this->data['singleapp_order_completed']):''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_order_cancelled",
      isset($this->data['singleapp_order_cancelled'])?json_encode($this->data['singleapp_order_cancelled']):''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_prefix",
      isset($this->data['singleapp_prefix'])?$this->data['singleapp_prefix']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_location_accuracy",
      isset($this->data['singleapp_location_accuracy'])?$this->data['singleapp_location_accuracy']:''
      ,$merchant_id);
                  
      $this->functions->updateOption("singleapp_cart_theme",
      isset($this->data['singleapp_cart_theme'])?$this->data['singleapp_cart_theme']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_cart_auto_address",
      isset($this->data['singleapp_cart_auto_address'])?$this->data['singleapp_cart_auto_address']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_floating_category",
      isset($this->data['singleapp_floating_category'])?$this->data['singleapp_floating_category']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_custom_pages_position",
      isset($this->data['singleapp_custom_pages_position'])?$this->data['singleapp_custom_pages_position']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_rtl",
      isset($this->data['singleapp_rtl'])?$this->data['singleapp_rtl']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_enabled_addon_desc",
      isset($this->data['singleapp_enabled_addon_desc'])?$this->data['singleapp_enabled_addon_desc']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_confirm_future_order",
      isset($this->data['singleapp_confirm_future_order'])?$this->data['singleapp_confirm_future_order']:''
      ,$merchant_id);
      
    $this->jsonResponse();
  }


   public function uploadFile()
    {
        

        require_once(__DIR__ . '/../../../vendor/SimpleUploader.php');


        if ( !$this->functions->isAdminLogin()){
            $this->msg = "Session has expired";
            $this->jsonResponse();
        }
        
        

        $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg=$this->functions->translation("default","Cannot create upload folder. Please create the upload folder manually on your rood directory with 777 permission.");
                return ;
           }        
      }
        
    $htaccess =$this->functions->htaccessForUpload();
    $htfile=$path_to_upload.'.htaccess';        
      if (!file_exists($htfile)){
        $myfile = fopen($htfile, "w") or die("Unable to open file!".$htfile);    
            fwrite($myfile, $htaccess);        
            fclose($myfile);
      }

$path_to_upload = __DIR__ . '/../../../upload/';


        
        $valid_extensions = $this->functions->validImageExtension();        
        $Upload = new FileUpload('uploadfile');
        $ext = $Upload->getExtension();
        $time=time();
        $filename = $Upload->getFileNameWithoutExt();       
        $new_filename =  "$time-$filename.$ext";
        $Upload->newFileName = $new_filename;
        $Upload->sizeLimit = $this->functions->imageLimitSize();
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions); 

        if (!$result) {
             $this->msg=$Upload->getErrorMsg();

        } else {
            
             $fields = ''; $remove_class='remove_picture';
             if($_GET['id']=="multi_upload"){
                $remove_class='multi_remove_picture';
                $fields = '<input type="hidden" name="'.$_GET['field_name'].'[]" value="'.$new_filename.'" > ';
             }
            
             $class_name = "preview_".$_GET['id'];
             $html_preview='             
             <div class="card '.$class_name.'" style="width: 10rem;">
                <img class="img-thumbnail" src="'.$this->functions->websiteUrl()."/upload/$new_filename".'" >
                
                <div class="card-body">
                  <a href="javascript:;" data-id="'.$_GET['id'].'" 
                  data-fieldname="'.$_GET['field_name'].'" 
                  class="card-link '.$remove_class.'">'.("Remove Image").'</a>
                </div>
                
                '.$fields.'
                
             </div>          
             <div class="height10"></div>
             ';
                         
             
             $this->code = 1;
             $this->msg="OK";
             $this->details=array(
               'file_name'=>$new_filename,
               'file_url'=>$this->functions->websiteUrl()."/upload/$new_filename",
               'html_preview'=>$html_preview
             );
        }
        $this->jsonResponse();
    }



    public function uploadFile2()
    {
      require_once(__DIR__ . '/../../../vendor/SimpleUploader.php');


        if ( !$this->functions->isAdminLogin()){
            $this->msg = "Session has expired";
            $this->jsonResponse();
        }

        $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg=$this->functions->translation("default","Cannot create upload folder. Please create the upload folder manually on your rood directory with 777 permission.");
                return ;
           }        
      }
    
    

    $htaccess =$this->functions->htaccessForUpload();
    $htfile=$path_to_upload.'.htaccess';        
      if (!file_exists($htfile)){
        $myfile = fopen($htfile, "w") or die("Unable to open file!".$htfile);    
            fwrite($myfile, $htaccess);        
            fclose($myfile);
      }

   $path_to_upload = __DIR__ . '/../../../upload/';

    
    $valid_extensions = array('json');
    $Upload = new FileUpload('uploadfile');
    $ext = $Upload->getExtension();
    $time=time();
        $filename = $Upload->getFileNameWithoutExt();         
        $new_filename =  "$filename.$ext";
        $Upload->newFileName = $new_filename;
        $Upload->sizeLimit = $this->functions->imageLimitSize();
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions); 
      if (!$result) {
         $this->msg=$Upload->getErrorMsg();
      } else {              
        
         $field_name = isset($_GET['field_name'])?$_GET['field_name']:'file_name';
        $input = '<input type="hidden" name="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" id="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" value="' . htmlspecialchars($new_filename, ENT_QUOTES, 'UTF-8') . '">';


        

         $input.= "File ".$new_filename;
           
         $this->code = 1;
         $this->msg="OK";
         $this->details=array(
           'file_name'=>$new_filename,
           'field_name'=>$field_name,
           'input'=>$input
         );
      }
      $this->jsonResponse();
    }  




      public function Upload()
  {

    require_once(__DIR__ . '/../../../vendor/Uploader.php');
    
    


      $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg="Error has occured cannot create upload directory";
                $this->jsonResponse();
           }        
      }

      $path_to_upload = __DIR__ . '/../../../upload/';
      $valid_extensions = $this->functions->validImageExtension();

      
        $Upload = new FileUpload('uploadfile');
        $ext = $Upload->getExtension(); 
        $Upload->newFileName = $Upload->getFileName()."_".time().".".$ext;
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions);                
        if (!$result) {                     
            $this->msg=$Upload->getErrorMsg();            
        } else {          
          $this->code=1;
          $this->msg=("upload done");                        
            $this->details=array(     
        'file_url'=>Config::$baseUrl."/upload/".$Upload->newFileName,
        'file_name'=>$Upload->newFileName
      );
        }
        $this->jsonResponse();
  } 


    public function save_fcm()
  {
    
    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';   
      if($merchant_id<=0){
        $this->msg = ("Invalid merchant id");
        $this->jsonResponse();
      }
      
      $this->code = 1;    
      $this->msg = ("Successful");  
            
    $this->functions->updateOption("singleapp_android_push_key",
      isset($this->data['singleapp_android_push_key'])?$this->data['singleapp_android_push_key']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_fcm_provider",
      isset($this->data['singleapp_fcm_provider'])?$this->data['singleapp_fcm_provider']:''
      ,$merchant_id);
      
      $this->functions->updateOption("singleapp_services_account_json",
      isset($this->data['singleapp_services_account_json'])?$this->data['singleapp_services_account_json']:''
      ,$merchant_id);
      
    $this->jsonResponse();
  }



     public function savesettings_startup()
    {
         $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
        
        if($merchant_id<=0){
            $this->msg = ("Invalid merchant id");
            $this->jsonResponse();
        }
        
        $this->code = 1;        
        $this->msg = ("Successful");

        $this->functions->updateOption("singleapp_enabled_select_language",
        isset($this->data['singleapp_enabled_select_language'])?$this->data['singleapp_enabled_select_language']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_startup",
        isset($this->data['singleapp_startup'])?$this->data['singleapp_startup']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_startup_banner",
        isset($this->data['singleapp_startup_banner'])?json_encode($this->data['singleapp_startup_banner']):''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_startup_auto_scroll",
        isset($this->data['singleapp_startup_auto_scroll'])?$this->data['singleapp_startup_auto_scroll']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_startup_interval",
        isset($this->data['singleapp_startup_interval'])?$this->data['singleapp_startup_interval']:''
        ,$merchant_id);
        
        $this->jsonResponse();
    }



      public function save_banner()
  {
    $merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
    if($merchant_id>0){
            
      $this->functions->updateOption("singleapp_banner",
        isset($this->data['banner'])?json_encode($this->data['banner']):''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_enabled_banner",
          isset($this->data['singleapp_enabled_banner'])?$this->data['singleapp_enabled_banner']:''
          ,$merchant_id);
          
          $this->functions->updateOption("singleapp_homebanner_interval",
          isset($this->data['singleapp_homebanner_interval'])?$this->data['singleapp_homebanner_interval']:''
          ,$merchant_id);
          
          $this->functions->updateOption("singleapp_homebanner_auto_scroll",
          isset($this->data['singleapp_homebanner_auto_scroll'])?$this->data['singleapp_homebanner_auto_scroll']:''
          ,$merchant_id);
        
        $this->code = 1;    
          $this->msg = ("Successful");   
      
    } else $this->msg = ("invalid merchant id");
    $this->jsonResponse();
  }




  


 
  













	
	



   











	
	
	
}
/*end class*/