<?php
class ApiController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{




			
		$this->functions = new Functions();
		$this->SingleAppClass = new SingleAppClass();
		
		$this->InventoryWrapper=new InventoryWrapper();
		$this->StocksWrapper=new StocksWrapper();
		$this->itemWrapper=new itemWrapper();
        $this->LocationWrapper=new LocationWrapper();
        $this->CheckoutWrapperTemp=new CheckoutWrapperTemp();

        $this->PointsProgram=new PointsProgram();

        
        $this->MapsWrapperTemp=new MapsWrapperTemp();

        $this->Validator = new Validator();


		$model = Model::getInstance();
        
        $this->db = $model->getDb();

        $this->data=$_GET;
		$this->getGETData();


		if(isset($_GET['post'])){
			$this->data=$_POST;		
			$this->getPOSTData();
		}	

		$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
$current_url .= "://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

if (strpos($current_url, 'addToCart') !== false) {
    $this->data = $_POST;
    $this->getPOSTData();
    
} else {
    
}

if (strpos($current_url, 'getStocks') !== false) {
    $this->data = $_POST;
    $this->getPOSTData();
    
} else {
    
}

										
		$lang='en';	

		$website_timezone=$this->functions->getOptionAdmin("website_timezone");   
        date_default_timezone_set($website_timezone);


        //print_r($this->data);die();

       $merchant_keys = isset($this->data['merchant_keys'])?trim($this->data['merchant_keys']):'';	

       $merchant_keys_orig = isset($this->data['MerchantKeysorg'])?trim($this->data['MerchantKeysorg']):'';	


		if(empty($merchant_keys)){
			$this->code = 10;	
			$this->msg = "Invalid merchant keys";
			$this->output();
			return false;
		}

		if(empty($merchant_keys_orig)){
			$merchant_keys_orig=$merchant_keys;
		}



		if(!$resp=$this->SingleAppClass->validateKeys($merchant_keys)){
			$this->code = 10;		
			$this->msg = "Invalid merchant keys";
			$this->output();
			return false;
		}

		if($resp['status']!="active"){
			$this->code = 11;		
			$this->msg = ("Failed merchant is no longer active");
			$this->output();
			return false;
		}

		$merchant_resp=$this->SingleAppClass->validateKeys($merchant_keys_orig);
        

        $this->merchant_id_orig=$merchant_resp['merchant_id'];
			
		$this->merchant_id = $resp['merchant_id'];

		$this->paginate_limit=10;


       $disabled_single_app_modules = $this->functions->getOption('disabled_single_app_modules',$this->merchant_id);
		if($disabled_single_app_modules==1){
			$this->code = 11;		
			$this->msg = "Failed merchant module is disabled";
			$this->output();
			return false;
		}
		
		$this->merchant_name = isset($resp['restaurant_name'])?$resp['restaurant_name']:'';
		$this->device_id = isset($this->data['device_id'])?$this->data['device_id']:'';
		return true;
                
        	

     



	}

	public function output()
{
    // Allow cross-origin access
    header('Access-Control-Allow-Origin: *');
    header('Content-type: application/javascript;charset=utf-8');
    
    // Prepare the response array
    $resp = array(
        'code' => $this->code,
        'msg' => $this->msg,
        'details' => $this->details,
        'get' => $_GET,
        'post' => $_POST
    );
    
    // Check if 'callback' exists in GET request, else set it to an empty string
    if (!isset($_GET['callback'])) {
        $_GET['callback'] = '';
    }
    
    // If jsonp is requested, wrap the response in the callback function
    if (isset($_GET['jsonp']) && $_GET['jsonp'] == true) {
        echo $_GET['callback'] . '(' . json_encode($resp) . ')';
    } else {
        // Otherwise, just return the JSON response
        echo json_encode($resp);
    }

    // End the script execution (optional, depending on your use case)
    exit();
}
	
	
    public function Index(){
		echo "API IS WORKING";
	}	

	
	
	
	public function getGETData()
	{
		$this->device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
        $this->merchant_id = isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
	}

	public function getPOSTData()
	{
		$this->device_uiid = isset($_POST['device_uiid'])?$_POST['device_uiid']:'';
        $this->merchant_id = isset($_POST['merchant_id'])?$_POST['merchant_id']:'';
	}


	

	public function checkToken()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = "token not found";
			return false;
		}			
		$client_id = $res['client_id'];	
		return $client_id;
		
	}


	public function setMerchantTimezone(){
		$merchant_id = isset($this->merchant_id)?$this->merchant_id:'';
		if($merchant_id>0){			
			$mt_timezone=$this->functions->getOption("merchant_timezone",$this->merchant_id);			
	    	if (!empty($mt_timezone)){
	    		date_default_timezone_set($mt_timezone);
	    	}    	
		}
	}


	public function loadCategory()
	{
		$this->setMerchantTimezone();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $this->paginate_limit;
        } else  $page = 0;  

      /* $resp= $this->SingleAppClass->getCategory($this->merchant_id, $page , $this->paginate_limit);
      $this->code = 1; $this->msg = $resp;
      $this->output();*/
        
		if ($resp = $this->SingleAppClass->getCategory($this->merchant_id, $page , $this->paginate_limit)){
			$this->code = 1; $this->msg = 'OK';  
			$this->details = array('data'=>$resp);
		} else {
			$this->code = 6;
			$this->msg = ("end of records");
			$this->details = array(
			  'title'=>("No Category found"),
			  'sub_title'=>("This restaurant has not published their menu yet")
			);	
		}	
		$this->output();
	}



	public function loadItemByCategory()
{

	if (isset($this->data['page'])){
    	$page = $this->data['page'] * $this->paginate_limit;
    } else  $page = 0;  


    
    $new_data = array();
    
    $trans = $this->functions->getOptionAdmin('enabled_multiple_translation'); 
    
    $category_id = isset($this->data['cat_id']) ? $this->data['cat_id'] : '';
    $and = '';
    
    $food_option_not_available = $this->functions->getOption('food_option_not_available', $this->merchant_id);
    if($food_option_not_available == 1){
    	$and = "AND not_available !='2' ";
    }	

    $stmt = "SELECT 
        item_id,
        item_name,
        item_description,
        price,
        discount,
        dish,
        photo,
        item_name_trans,
        item_description_trans 
        
        FROM
		mt_item
		WHERE
		category LIKE :category
		AND
		status IN ('publish','published')				
		AND merchant_id = :merchant_id		
		$and		
		ORDER BY sequence ASC
		LIMIT $page, $this->paginate_limit
	";

    if($this->SingleAppClass->inventoryEnabled($this->merchant_id)){
    	if($this->InventoryWrapper->hideItemOutStocks($this->merchant_id)){
    		$stmt = "SELECT 
		        item_id,
		        item_name,
		        item_description,
		        price,
		        discount,
		        dish,
		        photo,
		        item_name_trans,
		        item_description_trans 
		        
		        FROM
				mt_item a
				WHERE
				category LIKE :category
				AND
				status IN ('publish','published')	
				AND merchant_id = :merchant_id	
				AND item_id IN (
					  SELECT item_id FROM mt_view_item_stocks_status
					  WHERE available = '1'
					  AND track_stock = '1'
					  AND stock_status NOT IN ('Out of stocks')		
					  AND item_id = a.item_id				  
				)													
				ORDER BY sequence ASC
				LIMIT $page, $this->paginate_limit
			";
    	} else {
    		if($food_option_not_available == 1){
    			$stmt = "SELECT 
			        item_id,
			        item_name,
			        item_description,
			        price,
			        discount,
			        dish,
			        photo,
			        item_name_trans,
			        item_description_trans 
			        
			        FROM
					mt_item a
					WHERE
					category LIKE :category
					AND
					status IN ('publish','published')	
					AND merchant_id = :merchant_id	
					AND item_id IN (
						  SELECT item_id FROM mt_view_item_stocks_status
						  WHERE available = '1'							  
						  AND item_id = a.item_id				  
					)													
					ORDER BY sequence ASC
					LIMIT $page, $this->paginate_limit
				";
    		}
    	}
    }

    $query = $this->db->prepare($stmt);
    $category_param = '%"'.$category_id.'"%';
    $query->bindParam(':category', $category_param, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
    
    if ($query->execute()) {
    	$res = $query->fetchAll(PDO::FETCH_ASSOC);

    	foreach ($res as $val) {        	

    		if ($trans == 2) {
        		$item_name_trans = json_decode($val['item_name_trans'], true);
        		$val['item_name_trans'] = $item_name_trans;
        		$val['item_name'] = $this->functions->qTranslate($val['item_name'], 'item_name', $val); 
        		
        		$item_description_trans = json_decode($val['item_description_trans'], true);
        		$val['item_description_trans'] = $item_description_trans;
        		$val['item_description'] = $this->functions->qTranslate($val['item_description'], 'item_description', $val); 
    		}
    			
    		$val['item_name'] = ($val['item_name']);
    		$val['item_description'] = ($val['item_description']);
    		
    		if (!empty($val['photo'])) {
    		  $val['photo_url'] = $this->SingleAppClass->getImage($val['photo']);
    		} else {
    		  $val['photo_url'] = $this->SingleAppClass->getImage($this->functions->getOption('singleapp_default_image', $this->merchant_id), 'default_cuisine.png');
    		}
    		
    		$val['prices'] = $this->SingleAppClass->getPrices($val['price'], $val['discount']);
			unset($val['price']);
							
    		$icon_dish = array();
			if (!empty($val['dish'])) {					   
		       $icon_dish = $this->functions->getDishIcon($val['dish']);
			} else {
				$icon_dish = '';
			}
			
			$val['icon_dish'] = $icon_dish;
								 		
    		$new_data[] = $val;
    	}

    	$this->code = 1; 
    	$this->msg = "OK";
    	$this->details = array(
    	  'cat_id' => $category_id,
    	  'data' => $new_data
    	);
    } else {
    	$this->msg = "No item found in this category";
    	$this->code = 6;
    	$this->details = array(
		  'title' => "No item found",
		  'sub_title' => "No item found in this category"
		);	
    }	

    $this->output();
}



	public function loadItemDetails()
	{		
		
		/*CHECK IF ORDERING IS DISABLED*/
		$ordering_disabled=false; $ordering_msg='';
		$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
		if($disabled_website_ordering=="yes"){
			$ordering_msg = ("Ordering is disabled by admin");
			$ordering_disabled=true;			
		}
		$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
		if($merchant_disabled_ordering=="yes"){
			$ordering_msg = ("Ordering is disabled by merchant");
			$ordering_disabled=true;
		}
		$merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
		if($merchant_close_store=="yes"){
			$ordering_msg = ("Merchant is now close and not accepting any orders");
			$ordering_disabled=true;
		}
		
		 $cart_data=array();
		$item_id = isset($this->data['item_id'])?$this->data['item_id']:'';
		
		$trans=$this->functions->getOptionAdmin('enabled_multiple_translation'); 
		
		if(is_numeric($item_id)){
			if ($res=$this->functions->getItemById($this->data['item_id'])){
				$res = $res[0];	
								
				/*TRANSLATE ADDON*/
				if($trans==2){
					$new_addon = array();
					if(is_array($res['addon_item']) && count($res['addon_item'])>=1){
						foreach ($res['addon_item'] as $add_val) {							
							$add_val['subcat_name']=$this->functions->qTranslate($add_val['subcat_name'],'subcat_name',$add_val);
																					
							if(is_array($add_val['sub_item']) && count($add_val['sub_item'])>=1){
								$new_sub_item = array();
								foreach ($add_val['sub_item'] as $sub_item_val) {
									$sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'],'sub_item_name',$sub_item_val);
									$sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'],'item_description',$sub_item_val);									
									$new_sub_item[]=$sub_item_val;
								}
								$add_val['sub_item']=$new_sub_item;
							}													
														
							$new_addon[]=$add_val;
						}
						
						$res['addon_item']=$new_addon;
					}				
				}								
				/*END TRANSLATE ADDON*/
				
				/*$food_option_not_available = getOption($this->merchant_id,'food_option_not_available');		
				if($food_option_not_available==2){*/
					if($res['not_available']==2){				
					   $ordering_msg = ("Sorry but this item is not available");
					   $ordering_disabled=true;
					}
				//}	
				
				$res['item_name']=$this->functions->qTranslate($res['item_name'],'item_name',$res);        	
				$res['item_description']=$this->functions->qTranslate($res['item_description'],'item_description',$res);
				
				
				$res['item_name'] = ($res['item_name']);
				$res['item_description'] =($res['item_description']);
				$res['item_name_trans'] = ($res['item_name_trans']);
				$res['item_description_trans'] = ($res['item_description_trans']);
				
				if(!empty($res['photo'])){
				    $res['photo'] = $this->SingleAppClass->getImage($res['photo']);
				} else $res['photo'] = $this->SingleAppClass->getImage($this->functions->getOption('singleapp_default_image',$this->merchant_id),'default_cuisine.png');
				
				/*GET DISH*/
				$icon_dish= array();
				if(!empty($res['dish'])){				
						   
				       $icon_dish = $this->functions->getDishIcon($res['dish']);
					
				} else $icon_dish='';
				
				$res['dish_list'] = $icon_dish;
								
				/*GALLERY*/
				$res['gallery']=array();
				if(!empty($res['gallery_photo'])){
					$new_gallery_photo=array();
					$gallery_photo = json_decode($res['gallery_photo'],true);
					if(is_array($gallery_photo) && count((array)$gallery_photo)>=1){
						foreach ($gallery_photo as $gallery_photo_val) {
							$new_gallery_photo[]= $this->SingleAppClass->getImage($gallery_photo_val);
						}
						$res['gallery']=$new_gallery_photo;					
					}			
				}
				
				/*CHECK IF MULTIPLE PRICE*/
				$res['multiple_price'] = false;
				if(is_array($res['prices']) && count($res['prices'])>=2){	
					$new_price = array();
					foreach ($res['prices'] as $prices) {
						$prices['size']=$this->functions->qTranslate($prices['size'],'size',$prices); 					
						$new_price[]=$prices;
					}
					$res['prices']=$new_price;					
					$res['multiple_price'] = true;
				} else {				
					/*FIXED FOR SINGLE PRICE WITH ONLY 1 SIZE*/	
					if(isset($res['prices'][0])){
						if( $res['prices'][0]['size_id']>0 ){
							$res['multiple_price'] = true;
						}					
					}									
				}			
				
				$row = isset($this->data['row'])?$this->data['row']:'';
				if(is_numeric($row)){				
					if($resp=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
						$cart=json_decode($resp['cart'],true);
						if(array_key_exists($row,(array)$cart)){
							$cart[$row]['row']=$row;
							$cart_data = isset($cart[$row])?$cart[$row]:'';
						}
					}
				} else $cart_data='';
				
				// GET FAVORITE
				$is_favorite = false;
				if ($client_id = $this->checkToken()){
					if($this->SingleAppClass->isItemFavorite($client_id,$item_id)){
						$is_favorite = true;
					}
				}
				
				$inventory_enabled = $this->SingleAppClass->inventoryEnabled($this->merchant_id);
                

                //+++waseem custom code
		    if(!isset($res['prices'][0]['size'])){
		    	$res['prices'][0]['size']="";
		    	$dsp_amnt=$res['prices'][0]['price'];
		    	$res['prices'][0]['size_id']=0;
		    	$res['prices'][0]['formatted_price']=$this->functions->prettyFormat( (float) $dsp_amnt);
		    }
           //---waseem custom code


											
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'inventory_enabled'=>$inventory_enabled==true?1:0,
				  'cat_id'=>isset($this->data['cat_id'])?$this->data['cat_id']:'',
				  'data'=>$res,
				  'cart_data'=>$cart_data,		
				  'ordering_disabled'=>$ordering_disabled,
				  'ordering_msg'=>$ordering_msg,
				  'is_favorite'=>$is_favorite
				);
				
			} else {
				$this->msg=("Item details not found");
				$this->code = 6;
				$this->details = array(
				  'title'=>("Item details not found"),
				  'sub_title'=>("Sorry but we cannot find what your looking for")
				);	
			}		
		} else {
			$this->msg = ("Invalid item id");
			$this->code = 6;
			$this->details = array(
			  'title'=>("Invalid item id"),
			  'sub_title'=>("Sorry but we cannot find what your looking for")
			);	
		}	
		$this->output();		
	}


public function loadItemDetails_pro()
{		
	$ordering_disabled = false;
	$ordering_msg = '';

	$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
	if ($disabled_website_ordering == "yes") {
		$ordering_msg = "Ordering is disabled by admin";
		$ordering_disabled = true;
	}

	$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering', $this->merchant_id);
	if ($merchant_disabled_ordering == "yes") {
		$ordering_msg = "Ordering is disabled by merchant";
		$ordering_disabled = true;
	}

	$merchant_close_store = $this->functions->getOption('merchant_close_store', $this->merchant_id);
	if ($merchant_close_store == "yes") {
		$ordering_msg = "Merchant is now close and not accepting any orders";
		$ordering_disabled = true;
	}

	$cart_data = array();
	$item_id = isset($this->data['item_id']) ? $this->data['item_id'] : '';
	$trans = $this->functions->getOptionAdmin('enabled_multiple_translation'); 

	if (is_numeric($item_id)) {
		$stmt = $this->db->prepare("
			SELECT * FROM view_item WHERE item_id = :item_id LIMIT 1
		");
		$stmt->execute([':item_id' => $item_id]);
		$res = $stmt->fetch(PDO::FETCH_ASSOC);

		if ($res) {
			// Fetch addons
			$res['addon_item'] = $this->functions->getAddonList($item_id, $this->merchant_id);

			if ($trans == 2) {
				$new_addon = array();
				if (is_array($res['addon_item']) && count($res['addon_item']) >= 1) {
					foreach ($res['addon_item'] as $add_val) {							
						$add_val['subcat_name'] = $this->functions->qTranslate($add_val['subcat_name'], 'subcat_name', $add_val);
						if (is_array($add_val['sub_item']) && count($add_val['sub_item']) >= 1) {
							$new_sub_item = array();
							foreach ($add_val['sub_item'] as $sub_item_val) {
								$sub_item_val['sub_item_name'] = $this->functions->qTranslate($sub_item_val['sub_item_name'], 'sub_item_name', $sub_item_val);
								$sub_item_val['item_description'] = $this->functions->qTranslate($sub_item_val['item_description'], 'item_description', $sub_item_val);
								$new_sub_item[] = $sub_item_val;
							}
							$add_val['sub_item'] = $new_sub_item;
						}
						$new_addon[] = $add_val;
					}
					$res['addon_item'] = $new_addon;
				}
			}

			if ($res['not_available'] == 2) {
				$ordering_msg = "Sorry but this item is not available";
				$ordering_disabled = true;
			}

			$res['item_name'] = $this->functions->qTranslate($res['item_name'], 'item_name', $res);        	
			$res['item_description'] = $this->functions->qTranslate($res['item_description'], 'item_description', $res);

			$res['item_name_trans'] = ($res['item_name_trans']);
			$res['item_description_trans'] = ($res['item_description_trans']);

			if (!empty($res['photo'])) {
				$res['photo'] = $this->SingleAppClass->getImage($res['photo']);
			} else {
				$res['photo'] = $this->SingleAppClass->getImage($this->functions->getOption('singleapp_default_image', $this->merchant_id), 'default_cuisine.png');
			}

			// DISH ICONS
			$icon_dish = array();
			if (!empty($res['dish'])) {
				$icon_dish = $this->functions->getDishIcon($res['dish']);
			} else {
				$icon_dish = '';
			}
			$res['dish_list'] = $icon_dish;

			// GALLERY
			$res['gallery'] = array();
			if (!empty($res['gallery_photo'])) {
				$new_gallery_photo = array();
				$gallery_photo = json_decode($res['gallery_photo'], true);
				if (is_array($gallery_photo) && count((array)$gallery_photo) >= 1) {
					foreach ($gallery_photo as $gallery_photo_val) {
						$new_gallery_photo[] = $this->SingleAppClass->getImage($gallery_photo_val);
					}
					$res['gallery'] = $new_gallery_photo;
				}
			}

			// PRICES
			$res['prices'] = $this->functions->getItemPrices($item_id);
			$res['multiple_price'] = false;
			if (is_array($res['prices']) && count($res['prices']) >= 2) {
				$new_price = array();
				foreach ($res['prices'] as $prices) {
					$prices['size'] = $this->functions->qTranslate($prices['size'], 'size', $prices);
					$new_price[] = $prices;
				}
				$res['prices'] = $new_price;
				$res['multiple_price'] = true;
			} else {
				if (isset($res['prices'][0])) {
					if ($res['prices'][0]['size_id'] > 0) {
						$res['multiple_price'] = true;
					}
				}
			}

			$row = isset($this->data['row']) ? $this->data['row'] : '';
			if (is_numeric($row)) {
				if ($resp = $this->SingleAppClass->getCart($this->device_uiid, $this->merchant_id)) {
					$cart = json_decode($resp['cart'], true);
					if (array_key_exists($row, (array)$cart)) {
						$cart[$row]['row'] = $row;
						$cart_data = isset($cart[$row]) ? $cart[$row] : '';
					}
				}
			} else {
				$cart_data = '';
			}

			$is_favorite = false;
			if ($client_id = $this->checkToken()) {
				if ($this->SingleAppClass->isItemFavorite($client_id, $item_id)) {
					$is_favorite = true;
				}
			}

			$inventory_enabled = $this->SingleAppClass->inventoryEnabled($this->merchant_id);

			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
				'inventory_enabled' => $inventory_enabled == true ? 1 : 0,
				'cat_id' => isset($this->data['cat_id']) ? $this->data['cat_id'] : '',
				'data' => $res,
				'cart_data' => $cart_data,
				'ordering_disabled' => $ordering_disabled,
				'ordering_msg' => $ordering_msg,
				'is_favorite' => $is_favorite
			);
		} else {
			$this->msg = "Item details not found";
			$this->code = 6;
			$this->details = array(
				'title' => "Item details not found",
				'sub_title' => "Sorry but we cannot find what you're looking for"
			);
		}
	} else {
		$this->msg = "Invalid item id";
		$this->code = 6;
		$this->details = array(
			'title' => "Invalid item id",
			'sub_title' => "Sorry but we cannot find what you're looking for"
		);
	}

	$this->output();		
}


public function addToCart()
	{				
		
		$code_version = isset($_REQUEST['code_version'])?(float)$_REQUEST['code_version']:2.3;		
		if($code_version<2.2){
			$this->getGETData();
		    $this->data = $_GET;
		} else {
			$this->getPOSTData();
			$this->data = $_POST;
		}	
			
		$data = $_POST;	

		//+++waseem custom code
		$merchant_keys = isset($this->data['merchant_keys'])?trim($this->data['merchant_keys']):'';	
		$resp_merchant=$this->SingleAppClass->validateKeys($merchant_keys);
		$this->merchant_id = $resp_merchant['merchant_id'];
		//---waseem custom code


		
		$cart_count = 0;
		$data['merchant_id'] = $this->merchant_id;
		$device_id = $this->device_uiid;
		$item_id = isset($data['item_id'])?$data['item_id']:'';		
		
		if(!is_numeric($item_id)){
			$this->msg = ("Invalid item id");
			$this->output();
		}
		
		
		$qty = isset($data['qty'])?$data['qty']:'';		
		
		if($qty>0){			
			if (strpos($qty,'.') !== false) {
			   $this->msg =("invalid quantity");
			   $this->output();
			}	
		} else {
		  	$this->msg = ("invalid quantity");
			$this->output();
		}
		
		if(!$item_details = $this->functions->getFoodItem($item_id)){
			$this->msg = ("Item details not found");
			$this->output();
		}


      

		if($item_details['merchant_id']!=$this->merchant_id){
			$this->msg = ("Item does not belong to merchant");
			$this->output();
		}		
		$data['discount'] = isset($item_details['discount'])?$item_details['discount']:0;
		$data['non_taxable'] = isset($item_details['non_taxable'])?$item_details['non_taxable']:0;
		/*dump($data);
		die();*/
		
		if(!isset($data['price'])){
			$this->msg = ("Please select price");
			$this->output();
		}
				
		$refresh = 0;
		
		if(!empty($device_id)){			
			
			
			$debug = false;	
			
			if ( $res = $this->SingleAppClass->getCart($device_id,$this->merchant_id)){
				$current_cart = json_decode($res['cart'],true);
								
				$row = isset($data['row'])?$data['row']:'';
				if(is_numeric($row)){								
					$current_cart[$row]= $data;	
					$refresh = 1;		
				} else {					
					
					
					/*CHECK IF THE ITEM IS ALREADY IN THE CART */					
					$item_found = true; $found_key = -1;
					
					if(is_array($current_cart) && count($current_cart)>=1){
						foreach ($current_cart as $current_cart_key => $current_cart_val) {
							/*dump($current_cart_key);
							dump($current_cart_val);*/
										
							$item_found = true;
													
							if ($current_cart_val['item_id']!=$data['item_id']){
								$item_found = false;
							}
							if ($current_cart_val['price']!=$data['price']){
								$item_found = false;
							}
							
							/*COOKING REF*/
							if(array_key_exists('cooking_ref',$data) && array_key_exists('cooking_ref',$current_cart_val)){
								if ( $data['cooking_ref']!=$current_cart_val['cooking_ref']){
									$item_found = false;
								}
							} else {								
								if(!array_key_exists('cooking_ref',$data) && !array_key_exists('cooking_ref',$current_cart_val)){
								} else $item_found = false;								
							}
							
							/*INGREDIENTS*/
							if(array_key_exists('ingredients',$data) && array_key_exists('ingredients',$current_cart_val)){
								$ingredients = json_encode($data['ingredients']);
								$ingredients2 = json_encode($current_cart_val['ingredients']);								
								if($ingredients!=$ingredients2){
									$item_found = false;
								} 
							} else {
								if(!array_key_exists('ingredients',$data) && !array_key_exists('ingredients',$current_cart_val)){
								} else $item_found = false;								
							}
							
							/*ADDON*/
							if(array_key_exists('sub_item',$data) && array_key_exists('sub_item',$current_cart_val)){
								$sub_item = json_encode($data['sub_item']);
								$sub_item2 = json_encode($current_cart_val['sub_item']);
								if($sub_item!=$sub_item2){
									$item_found = false;
								} 
							} else {
								if(!array_key_exists('sub_item',$data) && !array_key_exists('sub_item',$current_cart_val)){
								} else $item_found = false;								
							}
							
							if($item_found==TRUE){								
							   $found_key = $current_cart_key;
						    } 
						    
						} /*END LOOP*/
						
						if($found_key>=0){
												
							$current_cart[$found_key]['qty']  = $current_cart[$found_key]['qty']+$data['qty'];
						} else {
							array_push($current_cart,$data);
						}
						
					} else {									
						array_push($current_cart,$data);
					}					
				}
				
				
				
				/*inventory*/				
				$merchant_id = $this->merchant_id;
				if($this->SingleAppClass->inventoryEnabled($merchant_id)){
				  $current_item_id = isset($data['item_id'])?(integer)$data['item_id']:'';
				  $current_item_price = isset($data['price'])?$data['price']:'';		
				  $current_item_size = isset($data['with_size'])?(integer)$data['with_size']:0;
				  $inv_qty = 0;				  
				  foreach ($current_cart as $val) {
				  	  if($current_item_id==$val['item_id'] && trim($current_item_price) == trim($val['price']) ){
				  	  	 $inv_qty+=$val['qty'];
				  	  }
				  }				 				  				  
				  try {
				  	 $this->StocksWrapper->verifyStocks($inv_qty,$merchant_id,$current_item_id,$current_item_size,$current_item_price);
				  } catch (Exception $e) {
		            $this->msg = $e->getMessage();
		            $this->output();
		          }					  
				}
				
				
				$cart_count = count($current_cart);
				$this->functions->updateData("mt_singleapp_cart",array(
				  'device_id'=>$device_id,
				  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'android',
				  'cart'=>json_encode($current_cart),
				  'cart_count'=>$cart_count,
				  'date_modified'=>$this->functions->dateNow(),
				),'cart_id', $res['cart_id']);
			} else {			
					
				$cart_count=1;
				$this->functions->insertData("mt_singleapp_cart",array(
			     'device_id'=>$device_id,
			     'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
			     'cart'=>json_encode(array($data)),
			     'cart_count'=>$cart_count,
			     'date_modified'=>$this->functions->dateNow(),
			     'merchant_id'=>$this->merchant_id
			    ));
			}		
			
			
			$this->code = 1;
			$this->msg=("Added to cart");
			if($refresh==1){
				$this->msg=("Cart updated");
			}			
			$this->details=array(
			 'cart_count'=>$cart_count,
			 'refresh'=>$refresh
			);
				
		} else $this->msg = ("Device id is empty. please restart the application and try again");
		$this->output();
	}


	public function getCartCount()
	{		
		$basket_total=0;$item_total=0; 
		
		$token = isset($this->data['token'])?$this->data['token']:'';
		if($client_info = $this->SingleAppClass->getCustomerByToken($token)){						
			$this->data['client_id'] = $client_info['client_id'];						
			$this->data['merchant_id'] = $this->merchant_id;
            $this->SingleAppClass->registeredDevice($this->data);
		}
		
		if($res=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
			$cart=json_decode($res['cart'],true);			
			
			$params = array(
			  'delivery_type'=>'delivery',
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>0
			);
			
			$displayOrderHTML=$this->functions->displayOrderHTML( $params,$cart );
			$code = $displayOrderHTML['code'];		
			if($code==1){
				$details = $displayOrderHTML['raw'];
				if(is_array($cart) && count($cart)>=1){
					foreach ($cart as $val) {					
						$item_total+=$val['qty'];
					}
				}			    
				$basket_total = $details['total']['subtotal'];
				$basket_total = $this->functions->prettyPrice($basket_total);
				$this->code=1;
				$this->msg = "OK";				
				$this->details = array(
				  'count'=>$item_total,
				  'basket_count'=>$item_total." items",
				  'basket_total'=>$basket_total
				);		





				
	
			/*promo_code*/
			$promo_cart = array();
				$getthepromolist_id=0;
				$counts=1;$rester=0;
				if(is_array($cart) && count($cart)>=1){
			    	foreach ($cart as $key2 =>$promoval){
						$rows=$promoval['row']=$key2;
						$counts++;
			    		if($promoval['promo_id']>0){
							//$rows=$promoval['row'];
							$getthepromolist_id=$promoval['promo_id'];
							$promo_cart[]=$promoval['item_id'];
							$this->details['promo_items_pro'] =$promoval;	
							$this->details['promo_items_pro']['ids'] =$getthepromolist_id;	
							$this->details['promo_items_pro']['rows'] =$rows;	
				
							$rester = $this->itemWrapper->getItemByCategory_promo_checks($this->merchant_id,$details['total']['total'],$getthepromolist_id);
							
						
							
							$this->details['promo_items_pro']['rows1'] =$rester;
							
							if($rester=='0' && $getthepromolist_id>0){
									if($res1=$this->SingleAppClass->getCart($this->device_uiid)){
										$cart1=json_decode($res1['cart'],true);		
										$this->details['promo_items_pro']['carts'] =$cart1;
										
											
										if(array_key_exists($rows,(array)$cart1)){
											unset($cart1[$rows]);				
											$this->functions->updateData("mt_singleapp_cart",array(				  
											  'cart'=>json_encode($cart1),
											  'cart_count'=>count($cart1),
											),'cart_id', $res1['cart_id']);
											
											//$this->actionloadCart();
											}
									}	
							}
							
							
						}
									    		
			    	}
			    	
			    }
				
				  
			
if($getthepromolist_id>0){$this->details['promo_items'] = $this->itemWrapper->getItemByCategory_promo_byid($this->merchant_id,$getthepromolist_id,$promo_cart);}else{$this->details['promo_items'] = $this->itemWrapper->getItemByCategory_promotions($this->merchant_id,$details['total']['total']);}
			
			
			
			/*promo data */
			  $home_slider1 = $this->details['promo_items']['data'];

			  $home_slider1 = isset($this->details['promo_items']['data']) && is_array($this->details['promo_items']['data'])
    ? $this->details['promo_items']['data']
    : [];



			   
			   $terss=$slider_count=count($home_slider1);
			   $terss=$terss-1;
                                                // print_r($home_slider1);
                                                $divsss = '';
if(count($home_slider1) > 0 ){
                                                foreach ($home_slider1 as $data1) {

                                                    // echo $data1['item_name'];
                                                    // echo $data1['item_name'];
													 $divsss .='<div class="item-list" >';
												$divsss .='<span class="test" style="width:88%;float: left;padding: 7px;">PROMOTION ITEMS(You can select Upto '.$home_slider1[0]['totals'].' Items)</span><ons-icon onclick="showSlider()" style="font-size:27px"  class="remove   ons-icon zmdi zmdi-close" icon="md-close" modifier="material"></ons-icon>';	 
													 
													 
													 
       $divsss .='<img src="' . $data1['photo'] . '" /><h4 style="width:100%;text-align:left;margin-left: 10px;" class="prod-title">' . $data1['item_name'] . '</h4><p style="width:100%;text-align:left;margin-left:10px;" class="prod-price"><strike>' . $data1['prices'][0] . '</strike>  <b style="color:red">Free</b></p>';
	    
	   if($data1['item_already']==1){
				 $divsss .= "<a class='dsktop menu-item'>";
				$divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange" style="background:#37963b">Already Added</button></a></div>';
			}else if ($home_slider1[$terss]['item_added_total']>=$data1['totals']){
				
				$divsss .= "<a class='dsktop menu-item' >";
				 $divsss .= '<button class="full_width add_to_cart button button--material button--quiet_orange" data-dismiss="modal" style="background:#ff0000">Limit Reached</button></a></div>';
			
			
												}else {
				
				 $divsss .= "<a class='dsktop menu-item' onclick=\"itemDetails_pro(".$data1['item_id'].",0,'',".$data1['promo_ids'].")\">";
       $divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange">ADD TO CART</button></a></div>';

			}
	  
                                          				       
                                                }
												
													
												
}else{$divsss='0';}
			
			
			
			$this->details['promo_items_data']=$divsss;
			
			$this->details['promo_items_data_count']=$slider_count;
				
				$this->output();
			}								
		} 
		
		$this->msg=("0 found");
		$this->details = array(
		  'basket_count'=>("0 item"),
		  'basket_total'=>"0.00"
		);				
		$this->output();
	}




	public function loadCart()
	{						
		$this->setMerchantTimezone();		
		
		/*CHECK IF ORDERING IS DISABLED*/
		$disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');		
		if($disabled_website_ordering=="yes"){
			$this->msg = ("Ordering is disabled by admin");
			$this->code = 4;
			$this->output();
		}
		$merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
		if($merchant_disabled_ordering=="yes"){
			$this->msg = ("Ordering is disabled by merchant");
			$this->code = 4;
			$this->output();
		}
				
		$merchant_close_store = $this->functions->getOption('merchant_close_store',$this->merchant_id);
		if($merchant_close_store=="yes"){
			$this->msg = ("Merchant is now close and not accepting any orders");
			$this->code = 4;
			$this->output();
		}
		
		
		$search_resp = $this->SingleAppClass->searchMode();		
		$search_mode = $search_resp['search_mode'];	
		$location_mode = $search_resp['location_mode'];	
				
				
		$transaction_type='';
		$services = $this->functions->DeliveryOptions($this->merchant_id);
		
		if(is_array($services) && count($services)>=1){
			foreach ($services as $services_key=>$services_val) {				
				$transaction_type = $services_key;
				break;				
			}
		}
		
		if(isset($this->data['transaction_type'])){
			if(!empty($this->data['transaction_type'])){
				$transaction_type=$this->data['transaction_type'];
			}
		} else {
			$this->data['transaction_type'] = $transaction_type;
		}	
		
		/*GET CART*/
		$res=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id);
		if($res && !empty($res)){}else{
			$this->code = 2;
			$this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
		$this->output();}
		/*CHECK TIPS DEFAULT*/
		if($res && $transaction_type=="delivery"){
			$merchant_tip_default = $this->functions->getOption('merchant_tip_default',$this->merchant_id);		
			if($merchant_tip_default>0 && $res['tips']<=0 && $res['remove_tip']<=0 ){			
				$res['tips'] = $merchant_tip_default;
				
				

		  	    $this->functions->updateData("mt_singleapp_cart",array(				  
											  'tips'=>$merchant_tip_default
											),'cart_id', $res['cart_id']);

			}					
					  
		} else if ( $res ) {
			if($res['tips']>0){
				


		  	     $this->functions->updateData("mt_singleapp_cart",array(				  
											  'tips'=>0
											),'cart_id', $res['cart_id']);



			}		
			$res['tips'] = 0;
		}else{
			$this->msg = ("Cart is empty");$this->details['promo_items_data']=0;
		$this->output();
		}	

				
		if($res){
			$cart=json_decode($res['cart'],true);					
					
			$data = array(
			  'delivery_type'=>$transaction_type,
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>0
			);
			//dump($data);
			if($res['tips']>0.0001){
				$data['cart_tip_percentage']=$res['tips'];
				$data['tip_enabled']=2;
				$data['tip_percent']=$res['tips'];
			}		
			
			$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
			if(is_array($voucher_details) && count($voucher_details)>=1){
				$data['voucher_name']=$voucher_details['voucher_name'];
				$data['voucher_amount']=$voucher_details['amount'];
				$data['voucher_type']=$voucher_details['voucher_type'];
			}
			
			if($res['points_apply']>0.0001){
				$data['points_apply']=$res['points_apply'];
			}
			if($res['points_amount']>0.0001){
				$data['points_amount']=$res['points_amount'];
			}
			
			unset($_SESSION['shipping_fee']);
			if($res['delivery_fee']>0.0001){
				$data['delivery_charge']=$res['delivery_fee'];
			}
			
			$cart_details = $res;
			unset($cart_details['cart']);		
			unset($cart_details['device_id']);
			unset($cart_details['cart_id']);
			unset($cart_details['cart_id']);									
			unset($_SESSION['pts_redeem_amt']);
			
			/*inventory*/
			if($this->SingleAppClass->inventoryEnabled($this->merchant_id)){
				$new_cart = array();				
			    if(is_array($cart) && count($cart)>=1){
			    	foreach ($cart as $cartval) {			    		
			    		try {					    		  
			    		   $this->StocksWrapper->verifyStocks(
			    		      isset($cartval['qty'])?(integer)$cartval['qty']:0,
			    		      $this->merchant_id,
			    		      isset($cartval['item_id'])?(integer)$cartval['item_id']:0,
			    		      isset($cartval['with_size'])?(integer)$cartval['with_size']:0,
			    		      isset($cartval['price'])?$cartval['price']:0
			    		   );
			    		   $new_cart[]=$cartval;
			    		} catch (Exception $e) {
				   	  	    //echo $e->getMessage();
				   	  	 }
			    	}
			    	$cart = $new_cart;
			    }			
			}
			
			$multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation'); 	
			
			$displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
			$code = $displayOrderHTML['code'];
			$msg  = $displayOrderHTML['msg'];
			if ($code==1){
			   $this->code = 1;
			   $details = $displayOrderHTML['raw'];
			   
			   
			   /*TRANSLATE*/
			   if($multiple_translation==2){
				   if(is_array($details['item']) && count($details['item'])>=1){
				   	  $new_item = array();
				   	  foreach ($details['item'] as $key=> $details_item_val) {				   	  	
				   	  	 $details_item_val['item_name'] = $this->functions->qTranslate($details_item_val['item_name'],'item_name',$details_item_val['item_name_trans']);
				   	  	 
				   	  	 if(isset($details_item_val['new_sub_item'])){
				   	  	 if(is_array($details_item_val['new_sub_item']) && count($details_item_val['new_sub_item'])>1){				   	  	 	
				   	  	 	$newest_new_sub_item_val=array();
				   	  	 	foreach ($details_item_val['new_sub_item'] as $new_sub_item_key=>$new_sub_item_val) {		
				   	  	 		$new_sub_item_key = $this->functions->qTranslate($new_sub_item_key,'subcategory_name',$new_sub_item_val[0]['subcategory_name_trans']);				   	  	 						   	  	 		
				   	  	 		$newest_new_sub_item_val[$new_sub_item_key]=$new_sub_item_val;
				   	  	 	}		
				   	  	 	$details_item_val['new_sub_item']=$newest_new_sub_item_val;
				   	  	 }				   	  
				   	  	 }
				   	  	 
				   	  	 $new_item[$key]=$details_item_val;
				   	  }		
				   	  $details['item']=$new_item;
				   }			
			   }
			   /*END TRANSLATE*/
			   
			   //dump($details);

			   
			   
			   /*EURO TAX*/
			   $is_apply_tax = 2;
			   if($this->functions->isApplyTax($this->merchant_id)){
			   	   $new_total = $this->functions->computeWithTax($details, $this->merchant_id);
			   	   $details['total']=$new_total;			
			   	   $is_apply_tax=1;   	   
			   }
			   /*EURO TAX*/
			   
			   //dump($details);
			   
			   $has_addressbook = 0;
			   $client_id='';
			   
			   $token = isset($this->data['token'])?$this->data['token']:'';
    	       if($client_info = $this->SingleAppClass->getCustomerByToken($token)){
    		       $client_id = $client_info['client_id'];
    		       if($search_mode=="location"){
    		       	   if($this->LocationWrapper->hasAddress($client_id)){
    		       	   	  $has_addressbook = 1; 
    		       	   }    		       
    		       } else {
	    		       if ($this->SingleAppClass->getAddressBookByClient($client_id)){
					   	  $has_addressbook = 1; 
					   }
    		       }
    	       }    

    	       $defaul_delivery_date = date("Y-m-d");
    	       $date_list = $this->SingleAppClass->deliveryDateList($this->merchant_id);
    	       foreach ($date_list as $date_list_key => $date_list_val) {    	       	  
    	       	  $defaul_delivery_date = $date_list_key;
    	       	  break;
    	       }
    	       
    	       $subtotal = $details['total']['subtotal'];
    	       $cart_error=array();

    	       /*CHECKING MAX AND MIN AMOUNT*/
    	       if($transaction_type=="delivery"){
    	       	    	       	 
    	       	  $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$this->merchant_id);     	
    	       	  $min_tables_enabled = $this->functions->getOption('min_tables_enabled',$this->merchant_id);
    	       	      	       	      	       	      	      	       	  
    	       	  if($min_tables_enabled==1 && !empty($res['distance'])){    	       	  	  
    	       	  	  $merchant_minimum_order = $this->CheckoutWrapperTemp->getMinimumOrderTable(
    	       	  	  $this->merchant_id,$res['distance'],$res['distance_unit'],$merchant_minimum_order
    	       	  	  );
    	       	  }    	       
    	       	     	       	     	
    	       	  if($merchant_minimum_order>0){
    	       	  	 if($merchant_minimum_order>$subtotal){
    	       	  	 	

    	       	  	 	$cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of".$this->functions->prettyPrice($merchant_minimum_order);

    	       	  	 }    	       	  
    	       	  }      
    	       	  
    	       	  $merchant_maximum_order = $this->functions->getOption('merchant_maximum_order',$this->merchant_id);
    	       	  if($merchant_maximum_order>0.001){
    	       	  	 if($subtotal>$merchant_maximum_order) {
    	       	  	 	

    	       	  	 	$cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of".$this->functions->prettyPrice($merchant_maximum_order);

    	       	  	 }    	       	  
    	       	  }    	       	     
    	       } elseif ( $transaction_type=="pickup"){
    	       	  $minimum_order = $this->functions->getOption('merchant_minimum_order_pickup',$this->merchant_id); 
    	       	  if($minimum_order>0.001){
    	       	  	 if($minimum_order>$subtotal){

    	       	  	 	

    	       	  	 	$cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of".$this->functions->prettyPrice($minimum_order);

    	       	  	 }    	       	  
    	       	  }    	         	       	  
    	       	  $maximum_order = $this->functions->getOption('merchant_maximum_order_pickup',$this->merchant_id);
    	       	  if($maximum_order>0.001){
    	       	  	 if($subtotal>$maximum_order) {
    	       	  	 	
                       

                       $cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of".$this->functions->prettyPrice($maximum_order);



    	       	  	 }    	       	  
    	       	  }	       	
    	       } elseif ( $transaction_type=="dinein"){
    	       	  $minimum_order = $this->functions->getOption('merchant_minimum_order_dinein',$this->merchant_id); 
    	       	  if($minimum_order>0.001){
    	       	  	 if($minimum_order>$subtotal){
    	       	  	 	


    	       	  	 	$cart_error[] = "Sorry, your order does not meet the minimum ".$transaction_type." amount of".$this->functions->prettyPrice($minimum_order);


    	       	  	 }    	       	  
    	       	  }      	       	  
    	       	  $maximum_order = $this->functions->getOption('merchant_maximum_order_dinein',$this->merchant_id);
    	       	  if($maximum_order>0.001){
    	       	  	 if($subtotal>$maximum_order) {
    	       	  	 	


    	       	  	 	$cart_error[] = "Sorry, your order has exceeded the maximum ".$transaction_type." amount of".$this->functions->prettyPrice($maximum_order);


    	       	  	 }    	       	  
    	       	  }	       	
    	       }    	       
    	       /*CHECKING MAX AND MIN AMOUNT*/	
    	           	           	      
    	       /*CHECK IF HAS POINTS ADDON*/
    	       $available_points=0; $available_points_label = '';
    	       $points_enabled = '';   $pts_disabled_redeem=''; 	       
    	       if (1==1){
    	       	           	
    	       	  $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    	       	  if($points_enabled=="1"){
    	       	   	  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
    	       	   	  	  $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
    	       	   	  	  if($mt_disabled_pts==2){
    	       	   	  	  	 $points_enabled='';
    	       	   	  	  }	    	       	   	  
    	       	   	  }
    	       	  }
    	       	  
    	       	  $pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
    	       	  if(!$this->PointsProgram->isMerchantSettingsDisabled()){
    	       	  	  $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$this->merchant_id);
    	       	  	  if($mt_pts_disabled_redeem>0){
    	       	  	  	  $pts_disabled_redeem=$mt_pts_disabled_redeem;
    	       	  	  }    	       	  
    	       	  }
    	       	   
    	       	  /*GET EARNING POINTS FOR THIS ORDER*/
    	       	  $subtotal = $details['total']['subtotal'];    	       	  
    	       	  if ($earn_pts = $this->SingleAppClass->getCartEarningPoints($cart,$subtotal,$this->merchant_id)){      	       	  	 
    	       	  	

    	       	  	 $this->functions->updateData("mt_singleapp_cart",array(				  
											  'points_earn'=>$earn_pts['points_earn'],
    	       	  	                          'date_modified'=>$this->functions->dateNow()
											),'device_id', $this->device_uiid);



    	       	  }    	    
    	       	         	       	     	       	    	       
    	       	  if($client_id>0){    	       	  	    	       	      	       	   	  
    	       	   	  if($points_enabled=="1"){
	    	       	   	  $available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
	    	       	   	  

	    	       	   	   $available_points_label ="Your available points ".$available_points;
    	       	   	  }
    	       	   }    	       
    	       }    	
    	       
    	       $checkout_stats = $this->functions->isMerchantcanCheckout($this->merchant_id);
    	       if($checkout_stats['code']==2){
    	       	  $cart_error[] = $checkout_stats['msg'];
    	       }			
    	       
    	       $subtotal = isset($details['total']['subtotal'])?$details['total']['subtotal']:0;        	       
    	      

          	   $this->functions->updateData("mt_singleapp_cart",array(				  
											   'cart_subtotal'=>(float)$subtotal,
       	  	                                   'date_modified'=>$this->functions->dateNow()
											),'cart_id', $res['cart_id']);	

          	    //+++waseem custom code for tip correction
    	       if($details['total']['tips']!=""){
    	       	$amount_tipss=$details['total']['tips'];
                $decoded_tip = html_entity_decode($amount_tipss);
                $clean_tip = preg_replace('/[^0-9.]/', '', $decoded_tip);
                $details['total']['tips']= $clean_tip;

    	       }
                //---waseem custom code for tip correction
    	       
			   $this->details = array(
			     'is_apply_tax'=>$is_apply_tax,
			     'checkout_stats'=>$checkout_stats,
			     'has_addressbook'=>$has_addressbook,
			     'services'=>$services,
			     'transaction_type'=>$transaction_type,
			     'default_delivery_date'=>$defaul_delivery_date,
			     //'default_delivery_date_pretty'=>date("D F d, Y"),
			     'default_delivery_date_pretty'=>$this->functions->prettyDate($defaul_delivery_date),
			     'required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),	
			     'tip_list'=>$this->SingleAppClass->tipList(),
			     'data'=>$details,
			     'cart_details'=>$cart_details,
			     'cart_error'=>$cart_error,
			     'points_enabled'=>$points_enabled,			     
			     'points_earn'=>isset($earn_pts['points_earn'])?$earn_pts['points_earn']:'',
			     'pts_label_earn'=>isset($earn_pts['pts_label_earn'])?$earn_pts['pts_label_earn']:'',
			     'available_points'=>$available_points,
			     'available_points_label'=>$available_points_label,
			     'pts_disabled_redeem'=>$pts_disabled_redeem,
			     'opt_contact_delivery'=>$this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id),
			   );
			
			
			
			
			
				
	
			/*promo_code*/
			$promo_cart = array();
				$getthepromolist_id=0;
				$counts=1;$rester=0;
				if(is_array($cart) && count($cart)>=1){
			    	foreach ($cart as $key2 =>$promoval){
						$rows=$promoval['row']=$key2;
						$counts++;
			    		if($promoval['promo_id']>0){
							//$rows=$promoval['row'];
							$getthepromolist_id=$promoval['promo_id'];
							$promo_cart[]=$promoval['item_id'];
							$this->details['promo_items_pro'] =$promoval;	
							$this->details['promo_items_pro']['ids'] =$getthepromolist_id;	
							$this->details['promo_items_pro']['rows'] =$rows;	
				
							$rester = $this->itemWrapper->getItemByCategory_promo_checks($this->merchant_id,$details['total']['total'],$getthepromolist_id);
							
							$this->details['promo_items_pro']['rows1'] =$rester;
							
							if($rester=='0' && $getthepromolist_id>0){ 
									if($res1=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
										$cart1=json_decode($res1['cart'],true);	
	
									$this->details['promo_items_pro']['carts'] =$cart1;
											
										if(array_key_exists($rows,(array)$cart1)){
												
											unset($cart1[$rows]);		
											$this->functions->updateData("mt_singleapp_cart",array(				  
											  'cart'=>json_encode($cart1),
											  'cart_count'=>count($cart1),
											),'cart_id',$res1['cart_id']);
											
											
											$this->loadCart();
											}
									}	
							}
							
							
						}
									    		
			    	}
			    	
			    }
				
				  
			
if($getthepromolist_id>0){$this->details['promo_items'] = $this->itemWrapper->getItemByCategory_promo_byid($this->merchant_id,$getthepromolist_id,$promo_cart);}else{$this->details['promo_items'] = $this->itemWrapper->getItemByCategory_promotions($this->merchant_id,$details['total']['total']);}
			
			
			
			/*promo data */
			  $home_slider1 = $this->details['promo_items']['data'];

			   $home_slider1 = isset($this->details['promo_items']['data']) && is_array($this->details['promo_items']['data'])
    ? $this->details['promo_items']['data']
    : [];
			   
			   $terss=$slider_count=count($home_slider1);
			   $terss=$terss-1;
                                                // print_r($home_slider1);
                                                $divsss = '';
if(count($home_slider1)>0){
                                                foreach ($home_slider1 as $data1) {

                                                    // echo $data1['item_name'];
                                                    // echo $data1['item_name'];
													 $divsss .='<div class="item-list" >';
													 $divsss .='<span class="test" style="width:88%;float: left;padding: 7px;text-align:left;">PROMOTION ITEMS(You can select Upto '.$home_slider1[0]['totals'].' Items)</span><ons-icon onclick="showSlider()" style="font-size:27px"  class="remove ons-icon zmdi zmdi-close" icon="md-close" modifier="material"></ons-icon>';	 
       $divsss .='<img src="' . $data1['photo'] . '" /><h4 style="width:100%;text-align:left;margin-left: 10px;" class="prod-title">' . $data1['item_name'] . '</h4><p style="width:100%;text-align:left;margin-left:10px;"  class="prod-price"><strike>' . $data1['prices'][0] . '</strike>  <b style="color:red">Free</b></p>';
	      
	   if($data1['item_already']==1){
				 $divsss .= "<a class='dsktop menu-item'>";
				$divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange" style="background:#37963b">Already Added</button></a></div>';
			}else if ($home_slider1[$terss]['item_added_total']>=$data1['totals']){
				
				$divsss .= "<a class='dsktop menu-item' >";
				 $divsss .= '<button class="full_width add_to_cart button button--material button--quiet_orange" data-dismiss="modal" style="background:#ff0000">Limit Reached</button></a></div>';
			
			
												}else {
				
				 $divsss .= "<a class='dsktop menu-item' onclick=\"itemDetails_pro(".$data1['item_id'].",0,'',".$data1['promo_ids'].")\">";
       $divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange">ADD TO CART</button></a></div>';

			}
	  
                                    
                                                }
												
					
												
												
}else{$divsss='0';}
			
			
			
			$this->details['promo_items_data']=$divsss;
			$this->details['promo_items_data_count']=$slider_count;
			
			
			
			
			
			
			
			
			
			
			} else {
				$this->SingleAppClass->clearCart($this->device_uiid);
				$this->msg = $msg;
			}	
			
				
			
		} else {$this->msg =("Cart is empty");$this->details['promo_items_data']=0;}
		$this->output();
	}


	public function removeCartItem()
	{		
		$row = isset($this->data['row'])?$this->data['row']:0;		
		if($res=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
			$cart=json_decode($res['cart'],true);			
			if(array_key_exists($row,(array)$cart)){
				unset($cart[$row]);
							
				$this->functions->updateData("mt_singleapp_cart",array(
				  'device_id'=>$this->device_uiid,
				  'cart'=>json_encode($cart),
				  'cart_count'=>count($cart),
				),'cart_id', $res['cart_id']);
				
				$this->code = 1;
				$this->msg="OK"; 
				$this->details='';
			} else $this->msg = ("Cannot find cart row");
		} else $this->msg = ("Cart is empty");
		$this->output();
	}
	
	public function applyVoucher()
	{		

		if (!$client_id = $this->checkToken()){
			$this->msg = ("You must login to apply voucher");
			$this->output();
		}
				
		$data = array(
		  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
		  'merchant_id'=>$this->merchant_id,
		  'card_fee'=>0
		);
		if ( $cart = $this->SingleAppClass->getCartContent($this->device_uiid,$data)){			
			if ( $cart['total']['discounted_amount']>=0.0001){
				$this->msg = ("Sorry you cannot apply voucher, exising discount is alread applied in your cart");
				$this->output();
			}
		}			
		
		/*CHECK IF HAS POINTS APPLIED*/		
		
			$pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');						
			$is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_add_voucher = $this->functions->getOption('mt_pts_enabled_add_voucher',$this->merchant_id);
				if($mt_pts_enabled_add_voucher>0){
					$pts_enabled_add_voucher=$mt_pts_enabled_add_voucher;
				}		
			}						
			if($pts_enabled_add_voucher!=1){
				$pts_redeem_amt_orig = isset($cart['total']['pts_redeem_amt_orig'])?$cart['total']['pts_redeem_amt_orig']:0;
				if($pts_redeem_amt_orig>0.0001){
					$this->msg = ("Sorry but you cannot apply voucher when you have already redeem a points");
					$this->output();
				}			
			}
		
		/*END CHECK IF HAS POINTS APPLIED*/
		
		$voucher_name = isset($this->data['voucher_name'])?$this->data['voucher_name']:'';
		if(!empty($voucher_name)){						
			if ( $res=$this->SingleAppClass->getVoucherMerchant($client_id, $voucher_name,$this->merchant_id) ){
				$voucher_type='merchant';
			} else {
				$voucher_type='admin';
				$res=$this->SingleAppClass->getVoucherMerchant($client_id,$voucher_name);
			}
			if($res){
				
				if ( !empty($res['expiration'])){						
					$expiration=$res['expiration'];
					$now=date('Y-m-d');						
					$date_diff=date_diff(date_create($now),date_create($expiration));						
					if (is_object($date_diff)){
						if ( $date_diff->invert==1){
							if ( $date_diff->d>0){
								$this->msg= ("Voucher code has expired");
								$this->output();
							}
						}
					}
				}
				
				/*check if voucher code can be used only once*/
				if ( $res['used_once']==2){
					if ( $res['number_used']>0){
						$this->msg= ("Sorry this voucher code has already been used");
						$this->output();
					}
				}
				
				if($voucher_type=="admin"){
					if (!empty($res['joining_merchant'])){							
						$joining_merchant=json_decode($res['joining_merchant']);							
						if (in_array($this->merchant_id,(array)$joining_merchant)){								
						} else {
							$this->msg= ("Sorry this voucher code cannot be used on this merchant");
							$this->output();
						}
					} 				
				}						
				
				
				/*CHECK SUBTOTAL WILL BECOME LESS THAN ZERO*/
				if($resp=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
					$cart=json_decode($resp['cart'],true);
					$data = array(
					  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'delivery',
					  'merchant_id'=>$this->merchant_id,
					  'card_fee'=>0
					);
				$displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
					if($displayOrderHTML['code']==1){
						$raw =$displayOrderHTML['raw']['total'];
						$subtotal = isset($raw['subtotal'])?$raw['subtotal']:0;						
												
						if ($res['voucher_type']=="percentage"){
						    $less_voucher = $subtotal*($res['amount']/100);
						    $subtotal_after_voucher = $subtotal  - $less_voucher;
						} else $subtotal_after_voucher = $subtotal- $res['amount'];
						
						if($subtotal_after_voucher<=0){
							
							$this->msg = ("Sorry you cannot Voucher which the Sub Total will become negative when after applying the voucher");
							$this->output();
						}
					}					
				}
				
				/*CHECK IF ALREADY USE*/
				if ( $res['found']<=0){					
				} else {
					$this->msg = ("Sorry but you have already use this voucher code");
					$this->output();
				}
						
				$params = array(
				  'voucher_id'=>$res['voucher_id'],
				  'voucher_owner'=>$res['voucher_owner'],
				  'voucher_name'=>$res['voucher_name'],
				  'amount'=>$res['amount'],
				  'voucher_type'=>$res['voucher_type'],
				);
								
				
				$this->functions->updateData("mt_singleapp_cart",array(
				  'voucher_details'=>json_encode($params)
				),'device_id', $this->device_uiid);
				$this->code = 1;
				$this->msg="OK";
				$this->details='';
						
			} else $this->msg = ("Invalid voucher code");
		} else $this->msg = ("Voucher is required");
		$this->output();
	}


	public function removeVoucher()
	{
		$this->SingleAppClass->removeVoucher($this->device_uiid);
		$this->code = 1;
		$this->msg="OK";
		$this->details='';
		$this->output();
	}
	
	public function servicesList()
	{
		$services = $this->functions->DeliveryOptions($this->merchant_id);
		if(is_array($services) && count($services)>=1){
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$services
			);
		} else $this->msg = ("Services not available");
		$this->output();
	}
	
	public function deliveryDateList()
	{		
		$this->setMerchantTimezone();			
		$dates = $this->functions->getDateList($this->merchant_id);
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		 'data'=>$dates
		);
		$this->output();
		$this->output();
	}
	
	public function deliveryTimeList()
	{			
		$this->setMerchantTimezone();			
		$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';		
		$times = $this->functions->getTimeList($this->merchant_id,$delivery_date);
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(
		  'data'=>$times
		);		
		$this->output();
	}


	public function customerRegister()
{
    $reg_email = $this->functions->getOption('singleapp_reg_email', $this->merchant_id);
    $reg_mobile = $this->functions->getOption('singleapp_reg_phone', $this->merchant_id);
    $merchant_id = $this->merchant_id;

    if (empty($reg_email) && empty($reg_mobile)) {
        $reg_email = 1;
        $reg_mobile = 1;
    }

    if ($this->data['password'] != $this->data['cpassword']) {
        $this->Validator->setmsg("Confirm password does not match");
    }

    if ($reg_email == 1) {
        if ($this->functions->emailBlockedCheck($this->data['email_address'])) {
            $this->Validator->setmsg("Sorry but your email address is blocked by website admin");
        }
    }

    if ($reg_mobile == 1) {
        if ($this->functions->mobileBlockedCheck($this->data['contact_phone'])) {
            $this->Validator->setmsg("Sorry but your mobile number is blocked by website admin");
        }

        if ($res = $this->functions->CheckCustomerMobile_with_merchant_singleapp($this->data['contact_phone'], $merchant_id)) {
            $this->Validator->setmsg("Sorry but your mobile number is already exist in our records");
        }
    }

    if ($reg_email == 1) {
        if ($resp = $this->functions->isClientExist_singleapp($this->data['email_address'], $merchant_id)) {
            $this->Validator->setmsg("Sorry but your email address already exist in our records");
        }
    }

    if ($this->Validator->validate()) {
        $params = array(
            'first_name' => $this->data['first_name'],
            'last_name' => $this->data['last_name'],
            'password' => md5($this->data['password']),
            'date_created' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'single_app_merchant_id' => $merchant_id,
            'merchant_id' => $merchant_id,
            'social_strategy' => "SingleMerchant",
        );

        // ✅ Branch logic (specific to current merchant)
        $stmt = "SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?)) LIMIT 1";
        $pdoStmt = $this->db->prepare($stmt);
        $pdoStmt->execute([$merchant_id]);
        $branchRow = $pdoStmt->fetch(PDO::FETCH_ASSOC);

        if ($branchRow && !empty($branchRow['merchant_id'])) {
            $branchMerchants = json_decode($branchRow['merchant_id'], true);
            if (is_array($branchMerchants)) {
                $params['branch'] = json_encode(array_values(array_map('intval', $branchMerchants)));
            } else {
                $params['branch'] = json_encode([ (int) $merchant_id ]);
            }
        } else {
            $params['branch'] = json_encode([ (int) $merchant_id ]);
        }

        if ($reg_email == 1) {
            $params['email_address'] = $this->data['email_address'];
        }
        if ($reg_mobile == 1) {
            $params['contact_phone'] = trim($this->data['contact_phone']);
        }

        if (isset($this->data['custom_field1'])) {
            $params['custom_field1'] = !empty($this->data['custom_field1']) ? $this->data['custom_field1'] : '';
        }
        if (isset($this->data['custom_field2'])) {
            $params['custom_field2'] = !empty($this->data['custom_field2']) ? $this->data['custom_field2'] : '';
        }

        $primary_next_step = isset($this->data['next_step']) ? $this->data['next_step'] : '';

        $enabled_verification_mobile = $this->functions->getOptionAdmin('website_enabled_mobile_verification');
        if ($enabled_verification_mobile == "yes" && $reg_mobile == 1) {
            $code = $this->functions->generateRandomKey(5);
            $this->functions->sendCustomerSMSVerification($params['contact_phone'], $code);
            $params['mobile_verification_code'] = $code;
            $params['status'] = 'pending';
            $this->data['next_step'] = 'verification_mobile';
        }

        $enabled_verification_email = $this->functions->getOptionAdmin('theme_enabled_email_verification');
        if ($enabled_verification_email == 2 && $reg_email == 1) {
            $email_code = $this->functions->generateRandomKey(5);
            $params['email_verification_code'] = $email_code;
            $params['status'] = 'pending';
            $this->functions->sendEmailVerificationCode($params['email_address'], $email_code, $params);
            $this->data['next_step'] = 'verification_email';
        }

        if ($reg_email == 1) {
            $token = $this->SingleAppClass->generateUniqueToken(15, $params['email_address']);
        } else {
            $token = $this->SingleAppClass->generateUniqueToken(15, $params['contact_phone']);
        }

        $params['token'] = $token;

        $last_insert_id = $this->functions->insertData('mt_client', $params);
        if ($last_insert_id !== false) {
            $customer_id = $last_insert_id;

            $this->data['client_id'] = $customer_id;
            $this->data['merchant_id'] = $merchant_id;
            $this->SingleAppClass->registeredDevice($this->data);

            $this->code = 1;
            $this->msg = ("Registration successful");

            if ($enabled_verification_email == 2 || $enabled_verification_mobile == "yes") {
                if ($this->data['next_step'] == "verification_mobile") {
                    $this->msg = ("We have sent verification code to your mobile number");
                } else {
                    $this->msg = ("We have sent verification code to your email address");
                }
            } else {
                $this->functions->sendCustomerWelcomeEmail($params);
            }

            $this->details = array(
                'next_step' => isset($this->data['next_step']) ? $this->data['next_step'] : '',
                'token' => $token,
                'primary_next_step' => $primary_next_step,
                'contact_phone' => isset($params['contact_phone']) ? $params['contact_phone'] : ''
            );

            // Points program
            $this->PointsProgram->signupReward($customer_id);
        } else {
            $this->msg = ("Something went wrong during processing your request. Please try again later");
        }
    } else {
        $this->msg = $this->SingleAppClass->parseValidatorError($this->Validator->getError());
    }

    $this->output();
}



	
	public function customerRegister_bkedup()
	{
		
		
		$reg_email = $this->functions->getOption('singleapp_reg_email',$this->merchant_id);
		$reg_mobile = $this->functions->getOption('singleapp_reg_phone',$this->merchant_id);
		$merchant_id=$this->merchant_id;
		
				
		if(empty($reg_email) && empty($reg_mobile)){
			$reg_email = 1;
			$reg_mobile = 1;
		}			
				
		if ($this->data['password']!=$this->data['cpassword']){			
			$this->Validator->setmsg("Confirm password does not match");
		}
		
		/*check if email address is blocked*/
		if($reg_email==1){
	    	if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
	    		$this->Validator->setmsg("Sorry but your email address is blocked by website admin");    		
	    	}	    
		}
    	
		if($reg_mobile==1){
	    	if ( $this->functions->mobileBlockedCheck($this->data['contact_phone'])){


				 $this->Validator->setmsg("Sorry but your mobile number is blocked by website admin");	

			}
			
			if ($res= $this->functions->CheckCustomerMobile_with_merchant($this->data['contact_phone'],$this->merchant_id)){
				
	        	$this->Validator->setmsg("Sorry but your mobile number is already exist in our records");        	
	        }	
		}
		
		if($reg_email==1){
			if ( $resp = $this->functions->isClientExist_with_merchant($this->data['email_address'],$this->merchant_id) ){			
				$this->Validator->setmsg("Sorry but your email address already exist in our records");
			}
		}
				
		if($this->Validator->validate()){								
			$params=array(
    		  'first_name'=>$this->data['first_name'],
    		  'last_name'=>$this->data['last_name'],    		  
    		  'password'=>md5($this->data['password']),
    		  'date_created'=>$this->functions->dateNow(),
    		  'ip_address'=>$_SERVER['REMOTE_ADDR'],    		      		  
    		  'single_app_merchant_id'=>$this->merchant_id, 
    		  'merchant_id'=>$this->merchant_id,
    		  'social_strategy'=>"SingleMerchant",   		  
    		);    


    		//+++was code for branches
$stmt = "SELECT merchant_id FROM mt_branches";
$pdoStmt = $this->db->prepare($stmt);
$pdoStmt->execute();
$branchRows = $pdoStmt->fetchAll(PDO::FETCH_ASSOC);

// Step 2: Collect and flatten all merchant_ids
$branchMerchants = [];

foreach ($branchRows as $row) {
    $ids = json_decode($row['merchant_id'], true);
    if (is_array($ids)) {
        foreach ($ids as $id) {
            $branchMerchants[] = (int) $id;
        }
    }
}

// Step 3: Remove duplicates and add to params
$branchMerchants = array_unique($branchMerchants);
$params['branch'] = json_encode(array_values($branchMerchants));


//---was code for branches



    		
    		if($reg_email==1){
    			$params['email_address'] = $this->data['email_address'];
    		}	
    		if($reg_mobile==1){
    			$params['contact_phone'] = trim($this->data['contact_phone']);
    		}	
    			
    		/** update 2.3*/
	    	if (isset($this->data['custom_field1'])){
	    		$params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
	    	}
	    	if (isset($this->data['custom_field2'])){
	    		$params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
	    	}
	    	
	    	$primary_next_step = isset($this->data['next_step'])?$this->data['next_step']:'';
	    		    		    		    	
	    	/** send verification code */
            $enabled_verification_mobile = $this->functions->getOptionAdmin('website_enabled_mobile_verification');            
	    	if ( $enabled_verification_mobile=="yes" && $reg_mobile==1){
	    		$code=$this->functions->generateRandomKey(5);		    		
	    		$this->functions->sendCustomerSMSVerification($params['contact_phone'],$code);
	    		$params['mobile_verification_code']=$code;
	    		$params['status']='pending';
	    		$this->data['next_step'] = 'verification_mobile';
	    	}	    	  
	    	
	    	/*send email verification added on version 3*/	  	 
	    	   	
	    	$enabled_verification_email = $this->functions->getOptionAdmin('theme_enabled_email_verification');
	    	if ($enabled_verification_email==2 && $reg_email==1){
	    		$email_code=$this->functions->generateRandomKey(5);
	    		$params['email_verification_code']=$email_code;
	    		$params['status']='pending';
	    		$this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
	    		$this->data['next_step'] = 'verification_email';
	    	}
	    	
	    	if($reg_email==1){
	    		$token = $this->SingleAppClass->generateUniqueToken(15,$params['email_address']);
	    	} else $token = $this->SingleAppClass->generateUniqueToken(15,$params['contact_phone']);
	    	
	    	$params['token']=$token;	

	    	$last_insert_id = $this->functions->insertData('mt_client', $params);
            if ($last_insert_id!== false){    		    		    	
	    	    			    		    	    		
    			$customer_id =$last_insert_id;	  
    			
    			$this->data['client_id'] = $customer_id;
    			$this->data['merchant_id'] = $this->merchant_id;
    			$this->SingleAppClass->registeredDevice($this->data);
    			  		
	    		$this->code=1;
	    		$this->msg = ("Registration successful");
	    		
	    		if ( $enabled_verification_email==2 || $enabled_verification_mobile=="yes"){	
	    			if($this->data['next_step']=="verification_mobile"){
    				   $this->msg=("We have sent verification code to your mobile number");
	    			} else $this->msg=("We have sent verification code to your email address");    			
    			} else {    				
    				/*sent welcome email*/	
    				$this->functions->sendCustomerWelcomeEmail($params);
    			}	    	
    			
    			$this->details = array(
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'token'=>$token,
    			  'primary_next_step'=>$primary_next_step,
    			  'contact_phone'=>isset($params['contact_phone'])?$params['contact_phone']:''
    			);    			
    			
                /*POINTS PROGRAM*/	    			
	    	   
	    		    $this->PointsProgram->signupReward($customer_id);
	    	    
    				    		
    		} else $this->msg = ("Something went wrong during processing your request. Please try again later");
			
		} else $this->msg = $this->SingleAppClass->parseValidatorError($this->Validator->getError());
		
		$this->output();
	}



	public function setDeliveryAddress()
    {       
        $lat = isset($this->data['lat'])?$this->data['lat']:'';
        $lng = isset($this->data['lng'])?$this->data['lng']:'';
        
        $merchant_id = $this->merchant_id;
        if($merchant_id<=0){
            $this->msg = ("invalid merchant id");
            $this->output();
        }   
        
        if(!$cart=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
            $this->msg = ("Cart is empty");     
            $this->output();
        }
        
        $country_name = $this->functions->countryCodeToFull(isset($this->data['country_code'])?$this->data['country_code']:'');        
        if(!empty($country_name)){
            $this->data['country']=$country_name;
        }
        
        $complete_address = $this->data['street']." ".$this->data['city']." ".$this->data['state']." ".$this->data['zipcode'];
        $complete_address.=" $country_name";
        
        try {
            
            $min_fees=0;            
            $cart_subtotal = isset($cart['cart_subtotal'])?(float)$cart['cart_subtotal']:0;                     
            $resp = $this->CheckoutWrapperTemp->verifyLocation($merchant_id,$lat,$lng,$cart_subtotal); 
            
            $this->code = 1;
            $this->msg = "OK";
            
            $this->details = array(
              'complete_address'=>$complete_address,              
              'min_delivery_order'=>$min_fees,
              'lat'=>$lat,
              'lng'=>$lng,
              'formatted_address'=>$complete_address,
              'street'=>isset($this->data['street'])?$this->data['street']:'',
              'city'=>isset($this->data['city'])?$this->data['city']:'',
              'state'=>isset($this->data['state'])?$this->data['state']:'',
              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
              'country'=>$country_name
            );
            
            $params = array(
              'street'=>isset($this->data['street'])?$this->data['street']:'',
              'city'=>isset($this->data['city'])?$this->data['city']:'',
              'state'=>isset($this->data['state'])?$this->data['state']:'',
              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
              'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
              'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
              'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
              'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
              'delivery_lat'=>$lat,
              'delivery_long'=>$lng,
              'save_address'=>isset($this->data['save_address'])?(integer)$this->data['save_address']:0,
              'delivery_fee'=>(float)$resp['delivery_fee'],
              'min_delivery_order'=>(float)$resp['min_order'],
              'distance'=>$resp['distance'],
              'distance_unit'=>$resp['unit'],
            );    


            

           $this->functions->updateData("mt_singleapp_cart",$params,'cart_id', $cart['cart_id']);
				$this->code = 1;
				$this->msg="OK";
				$this->details='';   
                                               
           $token = isset($this->data['token'])?$this->data['token']:'';
           if($res_client = $this->SingleAppClass->getCustomerByToken($token)){
            
                $client_id = $res_client['client_id'];  
                
                if(isset($this->data['save_address'])){
                  if($this->data['save_address']==1){
                     if(!empty($this->data['street']) && !empty($this->data['city'])){                      
                        if (!$this->SingleAppClass->getBookAddressByClientID($client_id,$this->data['street'],$this->data['city'],
                        $this->data['state'])){                         
                            $this->db->query("UPDATE mt_address_book SET as_default = '1'");

                            $params_address_book = array(
                              'client_id'=>$client_id,
                              'street'=>isset($this->data['street'])?$this->data['street']:'',
                              'city'=>isset($this->data['city'])?$this->data['city']:'',
                              'state'=>isset($this->data['state'])?$this->data['state']:'',
                              'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
                              'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
                              'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
                              'as_default'=>2,
                              'date_created'=>$this->functions->dateNow(),
                              'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
                              'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
                              'ip_address'=>$_SERVER['REMOTE_ADDR']
                            );                                                  
                           $this->functions->insertData("mt_address_book",$params_address_book);
                        }
                     }            
                  }         
                }       
            }

            /*SAVE LOCATION*/                   
            $params_recent = array(
              'device_uiid'=>$this->device_uiid,
              'search_address'=>isset($this->data['search_address2'])?trim($this->data['search_address2']):'',
              'street'=>isset($this->data['street'])?trim($this->data['street']):'',
              'city'=>isset($this->data['city'])?trim($this->data['city']):'',
              'state'=>isset($this->data['state'])?trim($this->data['state']):'',
              'country'=>isset($this->data['country'])?trim($this->data['country']):'',
              'location_name'=>isset($this->data['location_name'])?trim($this->data['location_name']):'',
              'zipcode'=>isset($this->data['zipcode'])?trim($this->data['zipcode']):'',
              'latitude'=>$lat,
              'longitude'=>$lng,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],              
            );                          
            if(!empty($params_recent['search_address'])){
                if($res = $this->SingleAppClass->getRecentLocationByID($this->device_uiid,$lat, $lng)){                    
                    $id = $res['id'];                   
                    

                    $this->functions->updateData("mt_singleapp_recent_location",$params,'id', $id);

                } else {                                    
                    

                    $this->functions->insertData("mt_singleapp_recent_location",$params_recent);
                }       
            }
            
        } catch (Exception $e) {
           $this->msg = $e->getMessage();                       
        }
                
        $this->output();
    }
    
    public function setAddressBook()
    {       
        $merchant_id = $this->merchant_id;
        if($merchant_id<=0){
            $this->msg = ("invalid merchant id");
            $this->output();
        }       
        
        if(!$cart=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
            $this->msg = ("Cart is empty");     
            $this->output();
        } 
            
        $min_fees = 0;
        $addressbook_id  = isset($this->data['addressbook_id'])?(integer)$this->data['addressbook_id']:0;
        if($addressbook_id>0){
            if ( $res = $this->functions->getAddressBookByID($addressbook_id)){                
                try {
                    $lat = isset($res['latitude'])?$res['latitude']:0;
                    $lng = isset($res['longitude'])?$res['longitude']:0;                    
                    $cart_subtotal = isset($cart['cart_subtotal'])?(float)$cart['cart_subtotal']:0;                     
                    $resp = $this->CheckoutWrapperTemp->verifyLocation($merchant_id,$lat,$lng,$cart_subtotal); 
                    
                    $country_code = isset($res['country_code'])?$res['country_code']:'';
                    $country_name = $this->functions->countryCodeToFull($country_code);        
                    
                    $complete_address = $res['street']." ".$res['city']." ".$res['state']." ".$res['zipcode'];
                    $complete_address.=" $country_name";
                    
                    $min_fees = (float)$resp['min_order'];
                    $params = array(
                      'street'=>isset($res['street'])?$res['street']:'',
                      'city'=>isset($res['city'])?$res['city']:'',
                      'state'=>isset($res['state'])?$res['state']:'',
                      'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
                      'country_code'=>isset($res['country_code'])?$res['country_code']:'',
                      'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
                      'location_name'=>isset($res['location_name'])?$res['location_name']:'',
                      'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',                   
                      'delivery_lat'=>$lat,
                      'delivery_long'=>$lng,
                      'save_address'=>isset($this->data['save_address'])?(integer)$this->data['save_address']:0,
                      'delivery_fee'=>(float)$resp['delivery_fee'],
                      'min_delivery_order'=>(float)$resp['min_order'],
                      'distance'=>$resp['distance'],
                      'distance_unit'=>$resp['unit'],
                    );      
                                        
                     


                    $this->functions->updateData("mt_singleapp_cart",$params,'cart_id', $cart['cart_id']);


                   
                   $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                      'complete_address'=>$complete_address,
                      'save_address'=>'',
                      'min_delivery_order'=>$min_fees
                    );
            
                } catch (Exception $e) {
                    $this->msg = $e->getMessage();                      
                }                               
            } else $this->msg = ("Address not available. please try again later");
        } else $this->msg = ("Invalid id"); 
        
        $this->output();
    }
    
    public function verifyCustomerToken()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!empty($token)){          
             if($res=$this->SingleAppClass->getCustomerByToken($token)){
                $data = array(
                  'contact_phone'=>$res['contact_phone'],
                  'email_address'=>$res['email_address'],
                );
                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                  'data'=>$data
                );
             } else {
                $this->code = 3;
                $this->msg = ("token not found");               
             }
        } else $this->msg = ("token empty");
        $this->output();
    }
    
    public function loadPaymentList()
    {
        
        /*CHECK IF ORDERING IS DISABLED*/
        $disabled_website_ordering = $this->functions->getOptionAdmin('disabled_website_ordering');       
        if($disabled_website_ordering=="yes"){
            $this->msg = ("Ordering is disabled by admin");
            $this->output();
        }
        $merchant_disabled_ordering = $this->functions->getOption('merchant_disabled_ordering',$this->merchant_id);
        if($merchant_disabled_ordering=="yes"){
            $this->msg = ("Ordering is disabled by merchant");
            $this->output();
        }
            
        $merchant_opt_contact_delivery= $this->functions->getOption('merchant_opt_contact_delivery',$this->merchant_id);
        $opt_contact_delivery = isset($this->data['opt_contact_delivery'])?$this->data['opt_contact_delivery']:'';
        
        if ( $res = $this->functions->getMerchantPaymentListNew($this->merchant_id)){
             $transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
             $this->code = 1;
             $this->msg = "OK";     
             $list = array();
             
             if(isset($res['mcd'])){
                unset($res['mcd']);
             }
             if(isset($res['pyp'])){
                unset($res['pyp']);
             }
             
             /*REMOVE OFFLINE PAYMENT OPTION CONTACT DELIVERY*/
             if($merchant_opt_contact_delivery==1 && $transaction_type=="delivery" && $opt_contact_delivery==1){
                if(isset($res['cod'])){unset($res['cod']);}
                if(isset($res['pyr'])){unset($res['pyr']);}
                if(isset($res['obd'])){unset($res['obd']);}
                if(isset($res['ocr'])){unset($res['ocr']);}
             }      
             
             foreach ($res as $key => $val) {
                switch ($key) {
                    case "cod":
                        $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
                        break;
                
                    case "pyr":
                        $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
                        break;
                                        
                    case "paypal_v2":



			 		   if ( !$resp = $this->functions->getCredentials_paypal($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  

			 		   	   	   $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);

			 		   	   } else $val = $val;
			 		   } else $val = "Paypal V2 card fee ".$this->functions->prettyPrice($resp['card_fee']);


                      $val=$this->functions->frontend_payment_translations($key,$resp['card_fee'],$transaction_type);
			 		   break;     
                      
                    case "stp":				 		
			 		   if ( $resp = $this->functions->getCredentials_stripe($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  $cardfee = ($resp['card_fee']);
			 		   	   	  if(isset($resp['card_percentage'])){
			 		   	   	  	 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
			 		   	   	  	 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
			 		   	   	  }	

			 		   	   	  
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
			 		   	   	  //$val = "Stripe card fee ".$cardfee;

			 		   	   } else  $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   } else  $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   break; 


			 		   case "windcave":				 		
			 		   if ( $resp = $this->functions->getCredentials_windcave($this->merchant_id)){
			 		   	   if ($resp['card_fee']>0.0001){
			 		   	   	  $cardfee = ($resp['card_fee']);
			 		   	   	  if(isset($resp['card_percentage'])){
			 		   	   	  	 $cardfee = $this->functions->prettyPriceNoCurrency($resp['card_percentage']);
			 		   	   	  	 $cardfee.= "+".$this->functions->prettyPriceNoCurrency($resp['card_fee']);
			 		   	   	  }	

			 		   	   	  
                              $val=$this->functions->frontend_payment_translations($key,$cardfee,$transaction_type);
			 		   	   	  //$val = "Windcave card fee ".$cardfee;

			 		   	   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   } else $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
			 		   break;   

			 		    case "poli":
                $val=$this->functions->frontend_payment_translations($key,0,$transaction_type);
               
                break;    
                       
                   
                                        
                    default:
                        $val = ($val);
                        break;
                }               
                $list[] = array(
                  'payment_code'=>$key,
                  'payment_name'=>$val
                );
             }
             $this->details = array(
               'data'=>$list
             );
        } else $this->msg = ("No payment option available");
        $this->output();
    }



    public function payNow()
	{
		
		
		$this->setMerchantTimezone();
		
		if (!$this->functions->validateSellLimit($this->merchant_id) ){
        	$this->msg =("This merchant has reach the maximum sells per month");
        	$this->output();
        }
    	
    	$token = isset($this->data['token'])?$this->data['token']:'';
    	if(!$client_info = $this->SingleAppClass->getCustomerByToken($token)){
    		$this->msg = ("Invalid token, please relogin again");
    		$this->output();
    	}    	
    	
    	$customer_first_name=''; $customer_last_name =''; $customer_email='';    	
    	
    	$client_id = $client_info['client_id'];    	
    	$email_address = trim($client_info['email_address']);
    	$customer_email = trim($client_info['email_address']);
    	$customer_first_name = isset($client_info['first_name'])?$client_info['first_name']:'';
    	$customer_last_name = isset($client_info['last_name'])?$client_info['last_name']:'';
    	
    	if ( $this->functions->emailBlockedCheck($email_address)){
    		$this->msg = "Sorry but your email address is blocked by website admin"; 
    		$this->output();
    	}    	
    	
    	/*CHECK CUSTOMER CAN ORDER*/
    	try {	    	    		    	
	    	$this->CheckoutWrapperTemp->verifyCanPlaceOrder($client_id);	    	    	
	    } catch (Exception $e) {
			 $this->msg = $e->getMessage();
			 $this->output();
		}
    	
    	$transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
    	$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
    	$delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
    	$payment_provider = isset($this->data['payment_provider'])?$this->data['payment_provider']:'';
    	
    	if(empty($delivery_date)){
    		$this->msg = ("Delivery date is required");
    		$this->output();
    	}
    	
    	if(empty($payment_provider)){
    		$this->msg = ("Payment provider is empty. please go back and try again");
    		$this->output();
    	}
	    
    	$full_delivery = "$delivery_date $delivery_time";    	
    	$delivery_day = strtolower(date("D",strtotime($full_delivery)));
    	    
    	$delivery_time_formated = '';
    	if(!empty($delivery_time)){
    		$delivery_time_formated=date('h:i A',strtotime($delivery_time));
    	} else $delivery_time_formated = date('h:i A');
    	    	    	
    	/*CHECK MERCHANT OPENING HOURS*/
    	//dump($delivery_day);dump($delivery_time_formated);    	
    	if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
    		$date_close=date("F,d l Y h:ia",strtotime($full_delivery));
    		

    		$this->msg = "Sorry but we are closed on ".$date_close." Please check merchant opening hours.";

    		$this->output();
    	}    	    	
    	
    	/*CHECK IF DATE IS HOLIDAY*/
    	if ( $res_holiday =  $this->functions->getMerchantHoliday($this->merchant_id)){
    		if (in_array($delivery_date,$res_holiday)){
    		   

    		   $this->msg="were close on ".$this->functions->prettyDate($delivery_date);
			   	
			   	$close_msg=$this->functions->getOption('merchant_close_msg_holiday',$this->merchant_id);
			   	if(!empty($close_msg)){
	   	  	 	  

	   	  	 	  $this->msg =$close_msg." ".$this->functions->prettyDate($delivery_date) ;

	   	  	    }	
    			$this->output();	
    		}
    	}
    	
    	/*CHECK PRE ORDER*/
    	$date_today = date("Y-m-d");    	
    	if($date_today!=$delivery_date){
    		$merchant_preorder = $this->functions->getOption('merchant_preorder',$this->merchant_id);    		
    		if($merchant_preorder!=1){
    			$this->msg = ("Merchant is not accepting pre-order");
	    		$this->output();
    		}    	
    	}	
    	/*END PRE ORDER*/
    	    	
    	$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
    	$delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';
    	
    	/*CHECK DELIVERY TIME PAST*/
    	if(!empty($delivery_date) && !empty($delivery_time)){    		    		    		
    		$time_1=date('Y-m-d g:i:s a');
    		$time_2="$delivery_date $delivery_time";
    		$time_2=date("Y-m-d g:i:s a",strtotime($time_2));
    		$time_diff=$this->functions->dateDifference($time_2,$time_1);       		
    		if (is_array($time_diff) && count($time_diff)>=1){
    			if ( $time_diff['hours']>0){	       	  	     	
	       	  	     $this->msg= $this->SingleAppClass->timePastByTransaction($transaction_type);
	       	  	     $this->output(); 	  	     	
       	  	     }	       	  	
       	  	     if ( $time_diff['minutes']>0){	       	  	     	
	       	  	     $this->msg= $this->SingleAppClass->timePastByTransaction($transaction_type);
	       	  	     $this->output();  	  	     	
       	  	     }	       	  	
    		}
    	}        	    	
    	   
    	    	
    	if($res=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
    		$cart=json_decode($res['cart'],true);			
    		
    		$card_fee = 0; $card_percentage=0;
    		
    		/*Custom code 10 starts */
			
			 $resp=$this->SingleAppClass->getCart($this->device_uiid , $this->merchant_id);
			 $n_total = $resp['cart_subtotal'];
			 			 
			 //	$resp=SingleAppClass::getCart($this->device_uiid , $this->merchant_id);
			 //	$n_total = $resp['cart_subtotal'];
			 	
	       /*Custom code 10 ends */
    		
    		//dump($payment_provider);
    		
    		

    	

    		    		
			$data = array(
			  'delivery_type'=>$transaction_type,
			  'merchant_id'=>$this->merchant_id,
			  'card_fee'=>$card_fee
			);
			if($card_percentage>0){
			   $data['card_percentage']=$card_percentage;
			}    
			
			$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
			if(is_array($voucher_details) && count($voucher_details)>=1){
				$data['voucher_name']=$voucher_details['voucher_name'];
				$data['voucher_amount']=$voucher_details['amount'];
				$data['voucher_type']=$voucher_details['voucher_type'];
			}
			
			if($res['tips']>0.0001){
				$data['cart_tip_percentage']=$res['tips'];
				$data['tip_enabled']=2;
				$data['tip_percent']=$res['tips'];
			}					

			/*POINTS*/
			if($res['points_amount']>0.0001){
				$data['points_amount']=$res['points_amount'];
			}								
			//dump($data);die();
			
			/*DELIVERY FEE*/
			unset($_SESSION['shipping_fee']);
			if($res['delivery_fee']>0.0001){
				$data['delivery_charge']=$res['delivery_fee'];
			}
			
			$displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
			$code = $displayOrderHTML['code'];
		    $msg  = $displayOrderHTML['msg'];
			if ($code==1){
				$raw = $displayOrderHTML['raw'];
				
				/*EURO TAX*/
			   $is_apply_tax = 0;
			   if($this->functions->isApplyTax($this->merchant_id)){
			   	   $new_total = $this->functions->computeWithTax($raw, $this->merchant_id);
			   	   $raw['total']=$new_total;			
			   	   $is_apply_tax=1;   	   
			   }
			   /*EURO TAX*/				
				
				$donot_apply_tax_delivery = $this->functions->getOption('merchant_tax_charges',$this->merchant_id);
				if(empty($donot_apply_tax_delivery)){
					$donot_apply_tax_delivery=1;
				}
				
				if($card_percentage>0){
					$card_fee = (float) $raw['total']['card_fee'];
				}

				


				switch ($payment_provider) {
    			
    				
    			case "paypal_v2":	
    			    if($credentials = $this->functions->getCredentials_paypal($this->merchant_id)){
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                              //$card_fee=$credentials['card_fee'];
                              $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                          }
                       }
                    }  
    			   break;
    			   
    			case "stp":	
    			    if($credentials = $this->functions->getCredentials_stripe($this->merchant_id)){
    			        //print_r($credentials);die();
    			        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                            
                          }
                       }
                    }  
    			   break;  


    			   case "windcave":	
    			    if($credentials = $this->functions->getCredentials_windcave($this->merchant_id)){
    			        //print_r($credentials);die();
    			        
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                //echo "here";die();
                                $card_fee = $raw['total']['total']*$credentials['card_fee']/100;
                            
                          }
                       }
                    }  
    			   break;    

    			   
    			       		        			      
    			default:
    				break;
    		}
				

                


				
				$params = array(
				  'merchant_id'=>$this->merchant_id,				  
				  'client_id'=>$client_id,
				  'json_details'=>$res['cart'],
				  'trans_type'=>$transaction_type,
				  'payment_type'=>$this->data['payment_provider'],
				  'sub_total'=>$raw['total']['subtotal'],
				  'tax'=>$raw['total']['tax'],
				  'taxable_total'=>$raw['total']['taxable_total'],
				  'total_w_tax'=>isset($raw['total']['total'])?($raw['total']['total']+$card_fee):0,
				  'delivery_charge'=>isset($raw['total']['delivery_charges'])?$raw['total']['delivery_charges']:0,
				  'delivery_date'=>$delivery_date,
				  'delivery_time'=>$delivery_time,
				  'delivery_asap'=>isset($this->data['delivery_asap'])?$this->data['delivery_asap']:'',
				  'date_created'=>$this->functions->dateNow(),
				  'ip_address'=>$_SERVER['REMOTE_ADDR'],
				  'delivery_instruction'=>isset($res['delivery_instruction'])?$res['delivery_instruction']:'',
				  'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',
				  'order_change'=>isset($this->data['order_change'])?$this->data['order_change']:0,
				  'payment_provider_name'=>'',
				  'card_fee'=>$card_fee,
				  'packaging'=>$raw['total']['merchant_packaging_charge'],
				  'donot_apply_tax_delivery'=>$donot_apply_tax_delivery,
				  'order_id_token'=>$this->functions->generateOrderToken(),
				  'request_from'=>"SingleMerchant",
				  'apply_food_tax'=>$is_apply_tax,				  
				  //'calculation_method'=>FunctionsV3::getReceiptCalculationMethod()
				);
				
				$order_id_token = $params['order_id_token'];
				
				/*TIPS*/
				if(isset($raw['total']['tips'])){
					if($raw['total']['tips']>0.0001){
						$params['cart_tip_percentage']= $raw['total']['cart_tip_percentage'];
						$params['cart_tip_value']= $raw['total']['tips'];
					}				
				}			
								
				switch ($transaction_type) {
					case "dinein":
						$params['dinein_number_of_guest'] = isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
						$params['dinein_special_instruction'] = isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
						
						$params['dinein_table_number'] = isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:'';
						
						if(isset($this->data['contact_phone'])){
							if(!empty($this->data['contact_phone'])){
								$this->functions->updateData("mt_client",array(
								  'contact_phone'=>$this->data['contact_phone']
								),'client_id',$client_id);
							}
						}						
						break;
						
					case "pickup":	 
					      if(isset($this->data['contact_phone'])){
							if(!empty($this->data['contact_phone'])){
								$this->functions->updateData("mt_client",array(
								  'contact_phone'=>$this->data['contact_phone']
								),'client_id',$client_id);
							}
						  }						
					    break;
						
					case "delivery":
						$delivery_asap = '';
						if(isset($this->data['delivery_asap'])){
							$delivery_asap = $this->data['delivery_asap']=="true"?1:'';
							$params['delivery_asap'] = $delivery_asap;
						}
						break;
				
					default:
						break;
				}
					
				/*DEFAULT ORDER STATUS*/				
				$default_order_status=$this->functions->getOption('default_order_status',$this->merchant_id);										
				switch ($payment_provider) {								
					case "cod":
					case "obd":
						$params['status'] =!empty($default_order_status)?$default_order_status:'pending';
						break;
					case "ccr":
					case "ocr":
						 $params['cc_id'] = isset($this->data['cc_id'])?$this->data['cc_id']:'';	
						 $params['status']= !empty($default_order_status)?$default_order_status:'pending';
						 break;
								
					case "pyr":	 		 
					     $params['payment_provider_name'] = isset($this->data['selected_card'])?$this->data['selected_card']:'';	
						 $params['status']= !empty($default_order_status)?$default_order_status:'pending';
						 break;
						 
					default:			
					    $params['status']=$this->functions->initialStatus();
						break;
				}
							
				/*PROMO*/	    				
				//dump($raw);
				if (isset($raw['total']['discounted_amount'])){
    				if ($raw['total']['discounted_amount']>=0.0001){	    					
    				    $params['discounted_amount']=$raw['total']['discounted_amount'];
    				    $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
    				}
				}
				
				/*VOUCHER*/
				if(!empty($res['voucher_details'])){
					$voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;	
					if(is_array($voucher_details) && count($voucher_details)>=1){
						$params['voucher_amount']=$voucher_details['amount'];
			         	$params['voucher_code']=$voucher_details['voucher_name'];
			         	$params['voucher_type']=$voucher_details['voucher_type'];
					}
				}
				
				/*POINTS*/
				if($res['points_amount']>0.0001){
					$params['points_discount']=$res['points_amount'];
				}			
				
				/*SET COMMISSION*/
				if ( $this->functions->isMerchantCommission($this->merchant_id)){
					$admin_commision_ontop=$this->functions->getOptionAdmin('admin_commision_ontop');
					if ( $com=$this->functions->getMerchantCommission($this->merchant_id)){
	            		$params['percent_commision']=$com;			            		
	            		//$params['total_commission']=($com/100)*$params['total_w_tax'];

	            		$params['total_commission']=($com/100)*($params['total_w_tax']-$card_fee);

	            		//$params['merchant_earnings']=$params['total_w_tax']-$params['total_commission'];
                        $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;

	            		if ( $admin_commision_ontop==1){
	            			$params['total_commission']=($com/100)*$params['sub_total'];
	            			$params['commision_ontop']=$admin_commision_ontop;			            		
	            			$params['merchant_earnings']=$params['sub_total']-$params['total_commission'];
	            		}
	            	}	
	            	
	            	/** check if merchant commission is fixed  */
			        $merchant_com_details=$this->functions->getMerchantCommissionDetails($this->merchant_id);	
			        if ( $merchant_com_details['commision_type']=="fixed"){
	            		$params['percent_commision']=$merchant_com_details['percent_commision'];
	            		$params['total_commission']=$merchant_com_details['percent_commision'];
	            		$params['merchant_earnings']=$params['total_w_tax']-$merchant_com_details['percent_commision'];
	            		$params['commision_type']='fixed';
	            		
	            		if ( $admin_commision_ontop==1){			            		
	            		    $params['merchant_earnings']=$params['sub_total']-$merchant_com_details['percent_commision'];
	            		}
	            	} 
				}
				/*END COMMISSION*/

				if(!is_numeric($params['cc_id'])){
					unset($params['cc_id']);
				}
				if(!is_numeric($params['order_change'])){
					unset($params['order_change']);
				}
												
				/*BEGIN INSERT ORDER*/				
				if(!is_numeric($params['sub_total'])){
					$params['sub_total']=0;
				}			
				if(!is_numeric($params['tax'])){
					$params['tax']=0;
				}			
				if(!is_numeric($params['taxable_total'])){
					$params['taxable_total']=0;
				}			
				if(!is_numeric($params['total_w_tax'])){
					$params['total_w_tax']=0;
				}
				
				if(isset($params['order_change'])){
					if(!is_numeric($params['order_change'])){
						$params['order_change']=0;
					}			
				}
				if(!is_numeric($params['card_fee'])){
					$params['card_fee']=0;
				}			
				if(!is_numeric($params['packaging'])){
					$params['packaging']=0;
				}			
				if(!is_numeric($params['donot_apply_tax_delivery'])){
					unset($params['donot_apply_tax_delivery']);
				}			
				if(!is_numeric($params['apply_food_tax'])){
					unset($params['apply_food_tax']);
				}			
				
				if(isset($params['percent_commision'])){
					if(!is_numeric($params['percent_commision'])){
						$params['percent_commision']=0;
					}			
				}
				
				if(isset($params['total_commission'])){
					if(!is_numeric($params['total_commission'])){
						$params['total_commission']=0;
					}			
				}
				
				if(isset($params['merchant_earnings'])){
					if(!is_numeric($params['merchant_earnings'])){
						$params['merchant_earnings']=0;
					}			
				}				
				
				if($transaction_type=="delivery"){			
				   if($res['distance']>0){
				     

				       $params['distance'] = isset($res['distance']) ? $res['distance'] . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '') : '0' . $this->MapsWrapperTemp->prettyUnit(isset($res['distance_unit']) ? $res['distance_unit'] : '');



				   }
				}
			    $last_insert_id = $this->functions->insertData('mt_order', $params);
                if ($last_insert_id!== false){ 													
					$order_id=$last_insert_id;
					
					$params_history=array(
    				  'order_id'=>$order_id,
    				  'status'=>$this->functions->initialStatus(),    	
    				  'remarks'=>'',
    				  'date_created'=>$this->functions->dateNow(),
    				  'ip_address'=>$_SERVER['REMOTE_ADDR']
    				);	    				
    				
					$this->functions->insertData('mt_order_history', $params_history);

					$next_step = "receipt";
					
					/*SAVE ITEM */					
					foreach ($raw['item'] as $val) {		    					
						$params_order_details=array(
						  'order_id'=>isset($order_id)?$order_id:'',
						  'client_id'=>$client_id,
						  'item_id'=>isset($val['item_id'])?$val['item_id']:'',
						  'item_name'=>isset($val['item_name'])?$val['item_name']:'',
						  'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
						  'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
						  'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
						  'size'=>isset($val['size_words'])?$val['size_words']:'',
						  'qty'=>isset($val['qty'])?$val['qty']:'',		    					  
						  'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
						  'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
						  'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
						  'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1
						);
						/*inventory*/
						$new_fields=array('size_id'=>"size_id");
                        if ( $this->functions->checkTableFields('order_details',$new_fields)){
                        	$params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
                        	$params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
                        }			
						$this->functions->insertData("mt_order_details",$params_order_details);
						
						/*inventory*/
    					if ($this->functions->checkIfTableExist('order_details_addon')){
	    					if(isset($val['sub_item'])){
		    					if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
		    						foreach ($val['sub_item'] as $sub_item_data) {
		    							


		    							$this->functions->insertData("mt_order_details_addon",array(
		    							  'order_id'=>$order_id,
		    							  'subcat_id'=>$sub_item_data['subcat_id'],
		    							  'sub_item_id'=>$sub_item_data['sub_item_id'],
		    							  'addon_price'=>$sub_item_data['addon_price'],
		    							  'addon_qty'=>$sub_item_data['addon_qty'],
		    							));



		    						}
		    					}		    				
	    					}
    					}
						
					}
					
					/*SAVE DELIVERY ADDRESS*/
					$params_address = array();
					
					/*SAVE DELIVERY ADDRESS*/
					if ($transaction_type=="delivery"){						
						$params_address=array(	    				  
	    				  'street'=>isset($res['street'])?$res['street']:'',
	    				  'city'=>isset($res['city'])?$res['city']:'',
	    				  'state'=>isset($res['state'])?$res['state']:'',
	    				  'zipcode'=>isset($res['zipcode'])?$res['zipcode']:'',
	    				  'location_name'=>isset($res['location_name'])?$res['location_name']:'',
	    				  'contact_phone'=>isset($res['contact_phone'])?$res['contact_phone']:'',
	    				  'country'=>isset($res['country_code'])?$res['country_code']:'',
	    				  'google_lat'=>isset($res['delivery_lat'])?$res['delivery_lat']:'',
	    				  'google_lng'=>isset($res['delivery_long'])?$res['delivery_long']:'',
	    				  'opt_contact_delivery'=>isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0
	    				);		    					    				
					} elseif ( $transaction_type=="pickup"){
						$params_address = array(						  
	    				  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:''	    				  
						);
					} elseif ( $transaction_type=="dinein"){
						$params_address = array(						  
	    				  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
	    				  'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
	    				  'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
	    				  'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
						);
					}
					
					$params_address['order_id'] = (integer)$order_id;
	    		    $params_address['client_id'] = (integer)$client_id;
					$params_address['first_name'] = $customer_first_name;
					$params_address['last_name'] = $customer_last_name;
					$params_address['contact_email'] = $customer_email;
					$params_address['date_created'] = $this->functions->dateNow();
					$params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
										
					

					$this->functions->insertData("mt_order_delivery_address",$params_address);


					
					/*SAVE ADDRESS*/										
					if(isset($this->data['save_address'])){			
						if (!$this->SingleAppClass->getBookAddress($res['street'],$res['city'],$res['state'])){							
							$this->db->query("UPDATE mt_address_book SET as_default = '1'");
 
							$params_address_book = array(
							  'client_id'=>$client_id,
							  'street'=>$res['street'],
							  'city'=>$res['city'],
							  'state'=>$res['state'],
							  'zipcode'=>$res['zipcode'],
							  'location_name'=>$res['location_name'],
							  'country_code'=>$this->functions->getOptionAdmin('admin_country_set'),
							  'as_default'=>2,
							  'date_created'=>$this->functions->dateNow()
							);							
							$this->functions->insertData("mt_address_book",$params_address_book);
						} 
					}
					
					$this->code = 1;
				    

				    $this->msg = "Your order has been placed. Reference # ".$order_id;
					
					$provider_credentials=array();
					$redirect_url='';
					
					/*SAVE POINTS*/
					switch ($payment_provider) {
						case "cod":
						case "ccr":
					    case "ocr":				
					    case "pyr":
					    case "obd":
					    break;
					    
					    default:					    	
					    	$this->SingleAppClass->savePoints(
					    	  $this->device_uiid,
					    	  $client_id,
					    	  $this->merchant_id,
					    	  $order_id,
					    	  'initial_order'
					    	);
					    	break;
					}
					
					
					/*PAYMENT DATA*/
					switch ($payment_provider) {
						case "cod":
						case "ccr":
					    case "ocr":				
					    case "pyr":	    					    
					          $this->SingleAppClass->handleAll($order_id,$this->merchant_id,
					          $client_id,$this->device_uiid,$params['status']);	

					          $get_id_orders = $this->functions->checkalreadyorder($this->merchant_id);  
                        if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                        $params_update_order=array( 
                      
                       
                        'order_number'=>$order_number, 
                      
                        );    

                    
                      $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id);  
					          
					          
					  $this->SingleAppClass->updatePoints($order_id,$params['status']); 

					  //+++inventory code
        if ($this->functions->inventoryEnabled($this->merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code

					          			          
					          
							  break;	
							  
					    
					    	  
					   
					   
					    	
					  


					       case "paypal_v2":	
					       $next_step='init_webview';
					       

					       $redirect_url = $this->functions->websiteUrl()."/singlemerchant/paypal?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;

					   
					       case "stp":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/singlemerchant/stripe?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break; 
					       
					       case "poli":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/singlemerchant/poli?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;


					       case "windcave":	
					       $next_step='init_webview';
					       

					        $redirect_url = $this->functions->websiteUrl()."/singlemerchant/windcave?id=".urlencode($order_id)."&lang=$lang_code";

					       $redirect_url.= "&device_uiid=".urlencode($this->device_uiid);
					       break;    
					  
					       
					          			    
						default:						
						    $next_step = "init_".$payment_provider;
							break;
					}
					
				    $client_info = array( 
				      'first_name'=>$client_info['first_name'],
				      'last_name'=>$client_info['last_name'],
				      'email_address'=>$client_info['email_address'],
				      'contact_phone'=>$client_info['contact_phone'],				      
				    );
				    
				    

				   $payment_description = "Payment to merchant " . $this->functions->clearString($this->merchant_name);

				    
				    $total = number_format($params['total_w_tax'],2,'.','');
				    
				    $this->details=array(
				      'order_id'=>$order_id,
				      'total_amount'=>$params['total_w_tax'],
				      'total_amount_by_100'=>$total*100,
				      'total_amount_formatted'=>$total,
				      'payment_provider'=>$payment_provider,
				      'next_step'=>$next_step,
				      'currency_code'=>$this->functions->getCurrencyCode(),
				      'payment_description'=>$payment_description,
				      'merchant_name'=>$this->functions->clearString($this->merchant_name),
				      'provider_credentials'=>$provider_credentials,
				      'redirect_url'=>$redirect_url,
				      'client_info'=>$client_info
				    );
				    
				} else $this->msg = ("Something went wrong cannot insert records. please try again later");
				
			} else $this->msg = $msg;			
    	} else $this->msg = ("Cart is empty");    	
    	
		$this->output();
	}


	public function GetAddressFromCart()
	{
		if($resp=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
			$this->code = 1;
			$this->msg = "OK";
			
			$country_list =$this->functions->CountryList();
			
			$default_country_code = $this->functions->getOptionAdmin('admin_country_set');
			
			$this->details = array(
			  'street'=>$resp['street'],
			  'city'=>$resp['city'],
			  'state'=>$resp['state'],
			  'zipcode'=>$resp['zipcode'],
			  'delivery_instruction'=>$resp['delivery_instruction'],
			  'location_name'=>$resp['location_name'],
			  'contact_phone'=>$resp['contact_phone'],
			  'country_code'=>!empty($resp['country_code'])?$resp['country_code']:$default_country_code,
			  'delivery_lat'=>$resp['delivery_lat'],
			  'delivery_long'=>$resp['delivery_long'],
			  'country_list'=>$country_list
			);
			
		} else $this->msg = "cart not available";
		$this->output();
	}
	
	public function getUserProfile()
	{		
		$token = isset($this->data['token'])?$this->data['token']:'';
		$device_uiid = isset($this->data['device_uiid'])?$this->data['device_uiid']:'';
		
		if($res = $this->SingleAppClass->getCustomerByTokenAndDevice($token,$device_uiid)){											
			
			$has_pts = '';
			$client_id = (integer) $res['client_id'];			
			$avatar =  $this->SingleAppClass->getAvatar2($res['avatar']);		
			
			if($res['single_app_merchant_id']<=0){

				


		  	    $this->functions->updateData("mt_client",array(
								  'single_app_merchant_id'=>$this->merchant_id,
								  'date_modified'=>$this->functions->dateNow(),
								  'ip_address'=>$_SERVER['REMOTE_ADDR']
								),'client_id',$client_id);



			}		
											
			$data = array(
			   'first_name'=>$res['first_name'],
			   'last_name'=>$res['last_name'],
			   'full_name'=>ucwords($res['first_name']." ".$res['last_name']),
			   'email_address'=>$res['email_address'],
			   'contact_phone'=>$res['contact_phone'],
			   'enabled_push'=>$res['push_enabled']>0?$res['push_enabled']:0,
			   'has_pts'=>$has_pts,
			   'avatar'=>$avatar,
			   'social_strategy'=>$res['social_strategy'],
			   'subscribe_topic'=>$res['subscribe_topic']>0?$res['subscribe_topic']:0
			);
			
			$this->code = 1;
			$this->msg = "ok";
			$this->details = array(
			 'data'=>$data
			);
		} else {
			$this->code = 3;
			$this->msg = ("token not found");
		}
		$this->output();
	}


	public function saveChangePassword()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if ($this->data['password']==$this->data['cpassword']){
			if($res = $this->SingleAppClass->getCustomerByToken($token)){		
				$client_id = $res['client_id'];
				$current_pass = md5($this->data['current_password']);				
				$new_password = md5($this->data['password']);
				if ( $current_pass == $res['password']){					
					if ( $current_pass == $new_password){
					   $this->msg =("New password cannot be the same as old password");
					} else {
					   $params = array(
						  'password'=>md5($this->data['password']),
						  'date_modified'=>$this->functions->dateNow(),
						  'ip_address'=>$_SERVER['REMOTE_ADDR']
						);				
						
						if ( $this->functions->updateData("mt_client",$params,'client_id',$client_id)){
							 $this->code = 1;
							 $this->msg = ("Password updated");
							 $this->details='';
						} else $this->msg = ("Cannot update records, please try again later");	
					}										
				} else $this->msg = ("Current password is not valid");
			} else {
				$this->code = 3;
				$this->msg = ("token not found");
			}
		} else $this->msg = ("Confirm password does not match");
		$this->output();
	}

	public function saveProfile()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($res = $this->SingleAppClass->getCustomerByToken($token)){
            $client_id = $res['client_id'];
            $params = array(
              'first_name'=>$this->data['first_name'],
              'last_name'=>$this->data['last_name'],
              'contact_phone'=>$this->data['contact_phone'],
              'date_modified'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
           
            if ( $this->functions->updateData("mt_client",$params,'client_id',$client_id)){
                 $this->code = 1;
                 $this->msg = ("Profile updated");
                 
                 $avatar = $this->SingleAppClass->getAvatar($client_id);
                 
                 $this->details=array(
                   'full_name'=>ucwords($res['first_name']." ".$res['last_name']),
                   'avatar'=>$avatar
                 );
            } else $this->msg = ("Cannot update records, please try again later");  
        } else {
            $this->code = 3;
            $this->msg = ("token not found");
        }
        $this->output();
    }
    
   public function savePushSettings()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';

    if ($res = $this->SingleAppClass->getCustomerByToken($token)) {
        $client_id = $res['client_id'];

        $push_enabled = isset($this->data['enabled_push']) ? (int)$this->data['enabled_push'] : 0;
        $date_modified = $this->functions->dateNow();
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $device_uiid = $this->device_uiid;

        // Final SQL with direct variables
        $sql = "UPDATE mt_singleapp_device_reg 
                SET push_enabled = '$push_enabled', 
                    date_modified = '$date_modified', 
                    ip_address = '$ip_address' 
                WHERE device_uiid = '$device_uiid' AND client_id = '$client_id'";

        $up = $this->db->query($sql);

        if ($up) {
            $this->code = 1;
            $this->msg = "Push settings updated";
            $this->details = array(
                'enabled_push' => $push_enabled
            );
        } else {
            $this->msg = "Cannot update records, please try again later";
        }
    } else {
        $this->code = 3;
        $this->msg = "token not found";
    }

    $this->output();
}

    
    public function login()
    {
        $username = isset($this->data['username'])?$this->data['username']:'';
        $password = isset($this->data['password'])?$this->data['password']:'';

        if ($res=$this->SingleAppClass->appLogin($username,$password,$this->merchant_id)){                        
            
            if ( $this->functions->emailBlockedCheck($res['email_address'])){
               $this->msg = ("sorry but your email address is blocked by website admin");
               $this->output();
            }               
            
            if ( $this->functions->mobileBlockedCheck($res['contact_phone'])){
               $this->msg = ("Sorry but your mobile number is blocked by website admin");
               $this->output();
            }       
            
            $client_id = $res['client_id'];
            
            $token = $this->SingleAppClass->generateUniqueToken(15,$res['email_address']);
            $params = array(            
              'token'=>$token,
              'last_login'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']           
            );
            
            if(!empty($res['token'])){
                unset($params['token']);
                $token = $res['token'];
            }
                    
              

           $up = $this->functions->updateData("mt_client",$params,'client_id',(integer)$client_id);

            if($up){
                $this->data['client_id'] = $client_id;
                $this->data['merchant_id'] = $this->merchant_id;
                $this->SingleAppClass->registeredDevice($this->data);
                $this->code = 1;
                $this->msg = ("Login successful");
                $this->details = array(
                  'token'=>$token,
                  'mobile_number'=>$res['contact_phone']
                );
            } else $this->msg = ("Something went wrong cannot update records. please try again later");
        } else $this->msg = ("Login failed either username or password is not valid");
        $this->output();
    }



    	public function getAddressBookDropDown()
	{
		$this->getAddressBookList(false , "ORDER BY as_default DESC");
	}
	
	public function getAddressBookList($with_limit = true, $sort_by = 'ORDER BY id DESC')
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    if (!$res = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }

    $client_id = $res['client_id'];

    if ($client_id > 0) {

        $pagelimit = $this->SingleAppClass->paginateLimit();
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0;
        }

        $limit = "LIMIT $page, $pagelimit";
        if (!$with_limit) {
            $limit = '';
        }

        $search_resp = $this->SingleAppClass->searchMode();
        $search_mode = $search_resp['search_mode'];

        if ($search_mode == "location") {
            $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                    a.id,
                    a.as_default,			
                    a.date_created,
                    concat(a.street,' ',d.name,' ',c.name,' ',b.name) as address			
                FROM
                    mt_address_book_location a

                LEFT JOIN mt_location_states b
                    ON a.state_id = b.state_id

                LEFT JOIN mt_location_cities c
                    ON a.city_id = c.city_id

                LEFT JOIN mt_location_area d
                    ON a.area_id = d.area_id

                WHERE a.client_id = $client_id
                    AND a.street <> ''
                ORDER BY a.id DESC
                $limit
            ";
        } else {
            $stmt = "
                SELECT      	       
                    concat(street,' ',city,' ',state,' ',zipcode) as address,
                    id,
                    location_name,
                    country_code,
                    as_default,
                    latitude,
                    longitude,
                    date_created
                FROM
                    mt_address_book
                WHERE
                    client_id = $client_id
                $sort_by 
                $limit
            ";
        }

        $query = $this->db->query($stmt);
        $res = $query ? $query->fetchAll(PDO::FETCH_ASSOC) : false;

        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['date_added'] = "Added " . $date_added;

                if ($search_mode == "location") {
                    if ($val['as_default'] == 1) {
                        $val['as_default'] = 2;
                    }
                }

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'data' => $data,
                'page_action' => $page_action
            );
            $this->output();
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->details = array(
                    'title' => ("Your address book list is empty"),
                    'sub_title' => ("Add your first address")
                );
            }
        }
    } else {
        $this->msg = ("Invalid token, please relogin again");
        $this->code = 3;
    }

    $this->output();
}


public function saveAddressBook()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = ("token not found");
			$this->output();
		}			
		
		
		
		$this->Validator->required(array(
		  'lat'=>("latitude is required"),
		  'lng'=>("longitude id is required")
		),$this->data);
		
		
		if($this->Validator->validate()){	
			$client_id = $res['client_id'];
			$id = isset($this->data['book_id'])?$this->data['book_id']:'';
			
			$params = array(
			  'client_id'=>$client_id,
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'city'=>isset($this->data['city'])?$this->data['city']:'',
			  'state'=>isset($this->data['state'])?$this->data['state']:'',
			  'zipcode'=>isset($this->data['zipcode'])?$this->data['zipcode']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],
			  'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
			  'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:1,
			  'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
			  'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
			);
								
									
			if($id>=1){
				unset($params['date_created']);
				$params['date_modified']=$this->functions->dateNow();
				if(!$this->SingleAppClass->checkAddressBook($client_id,$params['latitude'],$params['longitude'],$id)){					
					

			  	     $up = $this->functions->updateData("mt_address_book",$params,'id',$id);

					if($up){					
						$this->code = 1;
					    $this->msg = ("Successfully updated");
					} else $this->msg = ("Something went wrong cannot update records. please try again later");
				} else $this->msg = ("Address already exist");
			} else {
				if(!$this->SingleAppClass->checkAddressBook($client_id,$params['latitude'],$params['longitude'])){	

					$last_insert_id = $this->functions->insertData('mt_address_book', $params);
	                if ($last_insert_id!== false){ 				
						$id = $last_insert_id;
						$this->code = 1;
						$this->msg = ("Successfully added");
						$this->details='';
					} else $this->msg = ("Something went wrong cannot insert records. please try again later");
				} else $this->msg = ("Address already exist");
			}		
			
			if ($this->code == 1 && $id > 0) {
    if ($params['as_default'] == 2) {
        $sql = "UPDATE address_book SET as_default='1' 
                WHERE client_id = '$client_id' 
                AND id NOT IN ('$id')";
        $this->db->exec($sql);
    }
}
	
			
			
			/*SAVE LOCATION*/		
			$lat = isset($this->data['lat'])?$this->data['lat']:'';
		    $lng = isset($this->data['lng'])?$this->data['lng']:'';
		
			$country_name = $this->functions->countryCodeToFull(isset($this->data['country_code'])?$this->data['country_code']:'');		
			if(!empty($country_name)){
				$this->data['country']=$country_name;
			}
								
			$params_recent = array(
			  'device_uiid'=>$this->device_uiid,
			  'search_address'=>isset($this->data['search_address2'])?trim($this->data['search_address2']):'',
			  'street'=>isset($this->data['street'])?trim($this->data['street']):'',
			  'city'=>isset($this->data['city'])?trim($this->data['city']):'',
			  'state'=>isset($this->data['state'])?trim($this->data['state']):'',
			  'country'=>isset($this->data['country'])?trim($this->data['country']):'',
			  'location_name'=>isset($this->data['location_name'])?trim($this->data['location_name']):'',
			  'zipcode'=>isset($this->data['zipcode'])?trim($this->data['zipcode']):'',
			  'latitude'=>$lat,
			  'longitude'=>$lng,
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
			);					
			if(!empty($params_recent['search_address'])){

				if($res = $this->SingleAppClass->getRecentLocationByID($this->device_uiid,$lat, $lng)){					
					$id = $res['id'];


					

			  	     $this->functions->updateData("mt_singleapp_recent_location",$params_recent,'id',$id);


				} else {									
					$this->functions->insertData("mt_singleapp_recent_location",$params_recent);
				}	


			}
			
		} else $this->msg  = $this->SingleAppClass->parseValidatorError($this->Validator->getError());
		
		$this->output();
	}


	public function deleteAddressBook()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }

    $client_id = $res['client_id'];
    $id = isset($this->data['id']) ? $this->data['id'] : '';

    if ($id >= 1) {
        $search_resp = $this->SingleAppClass->searchMode();
        $search_mode = $search_resp['search_mode'];

        if ($search_mode == "location") {
            $sql = "DELETE FROM mt_address_book_location WHERE id = '$id' AND client_id = '$client_id'";
            $this->db->exec($sql);
        } else {
            $sql = "DELETE FROM mt_address_book WHERE id = '$id' AND client_id = '$client_id'";
            $this->db->exec($sql);
        }

        $this->code = 1;
        $this->msg = "OK";
    } else {
        $this->msg = ("Invalid id");
    }

    $this->output();
}

	
	public function getAddressBook()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = ("token not found");
			$this->output();
		}			
		$client_id = $res['client_id'];
		$id = isset($this->data['id'])?$this->data['id']:'';
		if($id>=1){
			if ($res=$this->functions->getAddressBookByID($id)){
				unset($res['date_created']);
				unset($res['date_modified']);
				unset($res['ip_address']);
				
				

				$country_list =$this->functions->CountryList();

				$res['country_list'] = $country_list;
				
				$this->code = 1;
				$this->msg = "ok";
				$this->details = $res;
			} else $this->msg = ("Record not found. please try again later");
		} else $this->msg = ("Invalid id");
		$this->output();
	}




public function getOrders()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : ''; 
    $merchant_id = $this->merchant_id;

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass->paginateLimit();       
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $paginate_total = 0; 
        $limit = "LIMIT $page, $pagelimit"; 

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');     
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status'); 
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }   

        $date_now = date('Y-m-d g:i:s a');     
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';                
        $and = $this->SingleAppClass->getOrderTabsStatus($this->merchant_id, $tab);         

        // Check if current merchant is listed in any mt_branches row
        $checkBranch = $this->db->prepare("SELECT COUNT(*) FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?))");
        $checkBranch->execute([$merchant_id]);
        $branchExists = $checkBranch->fetchColumn();

        $orderMerchantCondition = '';
        $params = [$client_id];

        if ($branchExists > 0) {
            // Get all branch merchant_ids
            $stmtBranch = $this->db->prepare("SELECT merchant_id FROM mt_branches");
            $stmtBranch->execute();
            $branchRows = $stmtBranch->fetchAll(PDO::FETCH_ASSOC);

            $merchantIds = [];
            foreach ($branchRows as $row) {
                $ids = json_decode($row['merchant_id'], true);
                if (is_array($ids)) {
                    foreach ($ids as $id) {
                        $merchantIds[] = (int) $id;
                    }
                }
            }

            $merchantIds = array_unique($merchantIds);

            if (empty($merchantIds)) {
                $this->code = 6;
                $this->msg = "No valid branches found.";
                $this->details = [];
                $this->output();
                return;
            }

            $placeholders = implode(',', array_fill(0, count($merchantIds), '?'));
            $orderMerchantCondition = "AND a.merchant_id IN ($placeholders)";
            $params = array_merge([$client_id], $merchantIds);
        } else {
            // Fallback to specific merchant only
            $orderMerchantCondition = "AND a.merchant_id = ?";
            $params[] = $merchant_id;
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.order_id,
            a.client_id,
            a.merchant_id,
            a.trans_type,
            a.payment_type,
            a.date_created,
            a.date_created as date_created_raw,
            a.total_w_tax,
            a.status,
            a.status as status_raw,     
            a.request_cancel,
            a.order_locked,
            a.request_cancel_status,
            b.restaurant_name as merchant_name,
            b.logo,

            (
                SELECT rating FROM mt_review
                WHERE order_id = a.order_id
                AND status='publish'        
                LIMIT 0,1
            ) as rating

            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.client_id = ?
            $orderMerchantCondition
            AND a.status NOT IN ('initial_order')
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $query = $this->db->prepare($stmt);
        $query->execute($params);

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            $data = [];
            foreach ($res as $val) {
                $val['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val['status'] = ($val['status']);
                $val['transaction'] = $val['trans_type'] . " " . $val['order_id'];
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);
                $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);
                $val['payment_type'] = $val['trans_type'] . " " . $val['payment_type'];
                $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                // Review logic
                $add_review = false;        
                if ($this->SingleAppClass->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)) {
                    if ($val['client_id'] == $client_id) {
                        $date_diff = $this->functions->dateDifference(
                            date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                            $date_now
                        );
                        if (is_array($date_diff) && count($date_diff) >= 1) {
                            if ($date_diff['days'] < 5) {
                                $add_review = true;
                            }
                        }
                    }
                }

                if ($website_review_type == 1 && $val['rating'] > 0) {
                    if ($merchant_can_edit_reviews == "yes") {
                        $add_review = false;
                    }
                }

                $val['add_review'] = $add_review;

                // Cancel logic
                $show_cancel = false; 
                $cancel_status = '';
                if ($this->functions->canCancelOrderNew($val['request_cancel'], $val['date_created_raw'], $val['status_raw'], $val['order_locked'], $val['request_cancel_status'], $cancel_order_enabled)) {
                    if ($val['request_cancel'] == 1) {
                        $cancel_status = ("Pending for review");
                    } else {
                        $show_cancel = true;                                   
                    }
                }

                if ($val['request_cancel_status'] != 'pending') {                  
                    $cancel_status = "Request cancel : " . $val['request_cancel_status'];
                }

                $val['add_cancel'] = $show_cancel;
                $val['cancel_status'] = $cancel_status;
                $val['add_track'] = true;
                $val['transaction_type'] = $val['trans_type'];
                $val['placed'] = "Placed on " . $this->functions->prettyDate($val['date_created']);
                $val['total'] = $val['total_w_tax'];

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array( 
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {            
                $msg1 = '';   
                switch ($tab) {
                    case "processing":      
                        $msg1 = ("There is no processing order");                   
                        break;
                    case "completed":           
                        $msg1 = ("There is no completed order");    
                        break;
                    case "cancelled":               
                        $msg1 = ("There is no cancelled order");    
                        break;
                    default:
                        $msg1 = ("Your order list is empty");
                        break;
                }

                $this->code = 6;
                $this->details = array(
                    'title' => $msg1,
                    'sub_title' => ("Make your first order")
                );  
            }
        }      
    } else {
        $this->code = 3;
        $this->details = array(
            'title' => ("Get your first order, sign up now!"),
            'sub_title' => ("Make your first order")
        );  
    }   
    $this->output();
}










		public function getOrders_bkedup()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : ''; 

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass->paginateLimit();       
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0; 
        }

        $paginate_total = 0; 
        $limit = "LIMIT $page, $pagelimit"; 

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');     
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status'); 
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');

        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }   

        $date_now = date('Y-m-d g:i:s a');     
        $and = '';        
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';                
        $and = $this->SingleAppClass->getOrderTabsStatus($this->merchant_id, $tab);         

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.order_id,
            a.client_id,
            a.merchant_id,
            a.trans_type,
            a.payment_type,
            a.date_created,
            a.date_created as date_created_raw,
            a.total_w_tax,
            a.status,
            a.status as status_raw,     
            a.request_cancel,
            a.order_locked,
            a.request_cancel_status,
            b.restaurant_name as merchant_name,
            b.logo,

            (
                SELECT rating FROM mt_review
                WHERE order_id = a.order_id
                AND status='publish'        
                LIMIT 0,1
            ) as rating

            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.client_id = :client_id
            AND a.merchant_id = :merchant_id
            AND a.status NOT IN ('initial_order')
            $and
            ORDER BY a.order_id DESC
            $limit
        ";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
        $query->bindValue(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            $data = array();
            foreach ($res as $val) {
                $val['merchant_name'] = $this->functions->clearString($val['merchant_name']);
                $val['status'] = ($val['status']);
                $val['transaction'] = $val['trans_type'] . " " . $val['order_id'];
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['total_w_tax'] = $this->functions->prettyPrice($val['total_w_tax']);
                $val['payment_type'] = ($this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']));
                $val['payment_type'] = $val['trans_type'] . " " . $val['payment_type'];
                $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                $add_review = false;        
                if ($this->SingleAppClass->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)) {
                    $add_review = true;
                }               

                if ($add_review) {        
                    if ($val['client_id'] == $client_id) {                 
                        $date_diff = $this->functions->dateDifference(
                            date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                            $date_now
                        );
                        if (is_array($date_diff) && count($date_diff) >= 1) {
                            if ($date_diff['days'] >= 5) {
                                $add_review = false;
                            }
                        }           
                    } else {
                        $add_review = false;
                    }
                }

                if ($website_review_type == 1 && $val['rating'] > 0) {
                    if ($merchant_can_edit_reviews == "yes") {
                        $add_review = false;
                    }
                }

                $val['add_review'] = $add_review;

                $show_cancel = false; 
                $cancel_status = '';
                if ($this->functions->canCancelOrderNew($val['request_cancel'], $val['date_created_raw'], $val['status_raw'], $val['order_locked'], $val['request_cancel_status'], $cancel_order_enabled)) {
                    if ($val['request_cancel'] == 1) {
                        $cancel_status = ("Pending for review");
                    } else {
                        $show_cancel = true;                                   
                    }
                }

                if ($val['request_cancel_status'] != 'pending') {                  
                    $cancel_status = "Request cancel : " . $val['request_cancel_status'];
                }

                $val['add_cancel'] = $show_cancel;
                $val['cancel_status'] = $cancel_status;
                $val['add_track'] = true;
                $val['transaction_type'] = ($val['trans_type']);
                $val['placed'] = "Placed on " . $this->functions->prettyDate($val['date_created']);
                $val['total'] = $val['total_w_tax'];

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array( 
                'page_action' => $page_action,
                'paginate_total' => $paginate_total,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {            
                $msg1 = '';   
                switch ($tab) {
                    case "processing":      
                        $msg1 = ("There is no processing order");                   
                        break;
                    case "completed":           
                        $msg1 = ("There is no completed order");    
                        break;
                    case "cancelled":               
                        $msg1 = ("There is no cancelled order");    
                        break;
                    default:
                        $msg1 = ("Your order list is empty");
                        break;
                }

                $this->code = 6;
                $this->details = array(
                    'title' => $msg1,
                    'sub_title' => ("Make your first order")
                );  
            }
        }      
    } else {
        $this->code = 3;
        $this->details = array(
            'title' => ("Get your first order, sign up now!"),
            'sub_title' => ("Make your first order")
        );  
    }   
    $this->output();
}




public function getOrderDetails()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        
        $id = isset($this->data['id'])?$this->data['id']:'';   

        $order_id = $id;
        if($id>=1){
            $_GET['backend']='';


            if ( $data = $this->functions->getReceiptByID($order_id)){
                 
                
                $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
                
                if ( $json_details !=false){
                    
                    $displayOrderHTML= $this->functions->displayOrderHTML(array(
                       'merchant_id'=>$data['merchant_id'],
                       'order_id'=>$data['order_id'],
                       'delivery_type'=>$data['trans_type'],
                       'delivery_charge'=>$data['delivery_charge'],
                       'packaging'=>$data['packaging'],
                       'cart_tip_value'=>$data['cart_tip_value'],
                       'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
                       'card_fee'=>$data['card_fee'],
                       'donot_apply_tax_delivery'=>$data['donot_apply_tax_delivery'],
                       'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
                       'voucher_amount'=>$data['voucher_amount'],
                       'voucher_type'=>$data['voucher_type']
                     ),$json_details,true,$data['order_id']);
                     
                     $data2=$displayOrderHTML;
                      
                     $merchant_info=$this->functions->getMerchant($this->merchant_id);
                     $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
                     " ".$merchant_info['post_code'];
            
                     if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                     }              
                     if (isset($data['location_name1'])){
                        if (!empty($data['location_name1'])){
                            $data['location_name']=$data['location_name1'];
                        }
                    }
                    
                    $new_data = array();                    
                    $new_data[] = $this->SingleAppClass->receiptFormater("Customer Name", $this->functions->clearString($data['full_name']));
                    $new_data[] = $this->SingleAppClass->receiptFormater("Merchant Name", $this->functions->clearString($data['merchant_name']) );                   
                    if (isset($data['abn']) && !empty($data['abn'])){                       
                        $new_data[] = $this->SingleAppClass->receiptFormater("ABN",$data['abn']);                  
                    }
                    $new_data[] = $this->SingleAppClass->receiptFormater("Telephone",$data['merchant_contact_phone']);
                    $new_data[] = $this->SingleAppClass->receiptFormater("Address",$full_merchant_address);
                                        
                    $merchant_tax_number=$this->functions->getOption('merchant_tax_number',$this->merchant_id);
                    if(!empty($merchant_tax_number)){
                       $new_data[] = $this->SingleAppClass->receiptFormater("Tax number",$merchant_tax_number);
                    }
                    
                    $new_data[] = $this->SingleAppClass->receiptFormater("TRN Type", ($data['trans_type']) );
                   /* $new_data[] = $this->SingleAppClass->receiptFormater("Payment Type",$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$data['order_id'],$data['trans_type'])
                    );*/

                    $new_data[] = $this->SingleAppClass->receiptFormater("Payment Type",$this->functions->payment_translations($data['trans_type'],$data['payment_type'],$data['is_sop']))
                    ;
                    
                    if ( $data['payment_provider_name']){                      
                       $new_data[] = $this->SingleAppClass->receiptFormater("Card#",$data['payment_provider_name']);
                    }
                    
                  
                                        
                    $new_data[] = $this->SingleAppClass->receiptFormater("Reference #", $this->functions->formatOrderNumber($data['order_id']));
                    
                    if ( !empty($data['payment_reference'])){                     
                       $new_data[] = $this->SingleAppClass->receiptFormater("Payment Ref",$data['payment_reference']);
                    }
                  
                    
                    $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));                 
                    $new_data[] = $this->SingleAppClass->receiptFormater("TRN Date",
                     $this->functions->translateDate($trn_date)
                    );

                    

                    switch ($data['trans_type']) {
                        case "delivery":
                            
                            if (isset($data['delivery_date'])){
                               $date = $this->functions->prettyDate($data['delivery_date']);
                               $date=$this->functions->translateDate($date);                              
                               $new_data[] = $this->SingleAppClass->receiptFormater("Delivery Date",$date);
                            }
                            
                            if (isset($data['delivery_time'])){
                              if ( !empty($data['delivery_time'])){                               
                                  $new_data[] = $this->SingleAppClass->receiptFormater("Delivery Time",
                                    $this->functions->timeFormat($data['delivery_time'],true)
                                  );
                              }
                            }
                            
                            if (isset($data['delivery_asap'])){
                               if ( !empty($data['delivery_asap'])){                                   
                                   $new_data[] = $this->SingleAppClass->receiptFormater("Deliver ASAP", $data['delivery_asap']==1?("Yes"):'' );
                               }
                            } 
                            
                            if (!empty($data['client_full_address'])){
                                $delivery_address=$data['client_full_address'];
                            } else $delivery_address=$data['full_address'];                         
                            
                            $new_data[] = $this->SingleAppClass->receiptFormater("Deliver to",$delivery_address);
                            
                            if (!empty($data['delivery_instruction'])){                            
                                $new_data[] = $this->SingleAppClass->receiptFormater("Delivery Instruction",$data['delivery_instruction']);
                            }
                            
                            if (!empty($data['location_name1'])){
                               $data['location_name']=$data['location_name1'];
                            }                           
                            $new_data[] = $this->SingleAppClass->receiptFormater("Location Name",$data['location_name']);
                                                         
                            if ( !empty($data['contact_phone1'])){
                              $data['contact_phone']=$data['contact_phone1'];
                            }                           
                            $new_data[] = $this->SingleAppClass->receiptFormater("Contact Number",$data['contact_phone']);
                            
                            if ($data['order_change']>=0.0001){                            
                               $new_data[] = $this->SingleAppClass->receiptFormater("Change", $this->functions->prettyPrice($data['order_change']) );
                            }
                            
                            if($data['opt_contact_delivery']==1){
                                $new_data[] = $this->SingleAppClass->receiptFormater("Delivery options", ("Leave order at the door or gate") );
                            }
                            
                            break;
                     
                        case "pickup":
                                                        
                            $new_data[] = $this->SingleAppClass->receiptFormater("Contact Number", $data['contact_phone'] );
                            if (isset($data['delivery_date'])){                             
                                $new_data[] = $this->SingleAppClass->receiptFormater("Pickup Date", $data['delivery_date'] );
                            }
                            
                            if (isset($data['delivery_time'])){
                               if ( !empty($data['delivery_time'])){                                  
                                  $new_data[] = $this->SingleAppClass->receiptFormater("Pickup Time", $data['delivery_time'] );
                               }
                            }
                            
                            if ($data['order_change']>=0.0001){                            
                               $new_data[] = $this->SingleAppClass->receiptFormater("Change", $this->functions->prettyPrice($data['order_change']) );
                            }
                            
                            break;                      
                            
                        case "dinein":
                            
                            $new_data[] = $this->SingleAppClass->receiptFormater("Contact Number", $data['contact_phone'] );
                            if (isset($data['delivery_date'])){                             
                                $new_data[] = $this->SingleAppClass->receiptFormater("Dine in Date", $data['delivery_date'] );
                            }
                            
                            if (isset($data['delivery_time'])){
                               if ( !empty($data['delivery_time'])){                                  
                                  $new_data[] = $this->SingleAppClass->receiptFormater("Dine in Time", $data['delivery_time'] );
                               }
                            }
                            
                            if ($data['order_change']>=0.0001){                            
                               $new_data[] = $this->SingleAppClass->receiptFormater("Change", $this->functions->prettyPrice($data['order_change']) );
                            }
                            
                            $new_data[] = $this->SingleAppClass->receiptFormater("Number of guest", $data['dinein_number_of_guest'] );
                            $new_data[] = $this->SingleAppClass->receiptFormater("Table number", $data['dinein_table_number'] );
                            $new_data[] = $this->SingleAppClass->receiptFormater("Special instructions", $data['dinein_special_instruction'] );                            
                            
                            break;     
                     }                               
                                      
                    
                    
                    $new_total_html='';
                    
                    /*if($data['apply_food_tax']==1){                         
                        $file = Yii::getPathOfAlias('webroot')."/protected/modules/singlemerchant/views/api/cart.php";                      
                        $new_total_html=$this->renderFile($file,array(
                           'data'=>$data
                        ),true);                                                                
                    }   */      

                    //+++testing code

                   
if ($data['apply_food_tax'] == 1) { 
    ob_start();
    if (is_array($data) && count($data) >= 1):
?>
<table class="receipt_total">
  <?php 
  $average = 0.001;

  if (isset($data['delivery_charge']) && $data['delivery_charge'] > $average) {
      echo $this->functions->tableRow_euro(("Delivery Fee"), $this->functions::formatNumber($data['delivery_charge']));
  }

  if (isset($data['card_fee']) && $data['card_fee'] > $average) {
      echo $this->functions->tableRow_euro(("Card Fee"), $this->functions::formatNumber($data['card_fee']));
  }

  if (isset($data['packaging']) && $data['packaging'] > $average) {
      echo $this->functions->tableRow_euro(("Packaging"), $this->functions::formatNumber($data['packaging']));
  }

  if (isset($data['cart_tip_value']) && $data['cart_tip_value'] > $average) {
      echo $this->functions->tableRow_euro(("Tip") . " " . number_format($data['cart_tip_percentage'], 0) . "%", $this->functions::formatNumber($data['cart_tip_value']));
  }

  if (isset($data['discounted_amount']) && $data['discounted_amount'] > $average) {
      echo $this->functions->tableRow_euro(("Discount") . " " . number_format($data['discount_percentage'], 0) . "%", "(" . $this->functions::formatNumber($data['discounted_amount']) . ")");
  }

  if (isset($data['points_discount']) && $data['points_discount'] > $average) {
      echo $this->functions->tableRow_euro(("Points Discount"), "(" . $this->functions::formatNumber($data['points_discount']) . ")");
  }

  if (isset($data['voucher_amount']) && $data['voucher_amount'] > $average) {
      echo $this->functions->tableRow_euro(("Less Voucher"), "(" . $this->functions::formatNumber($data['voucher_amount']) . ")");
  }

  if (isset($data['sub_total']) && $data['sub_total'] > $average) {
      echo $this->functions->tableRow_euro(("Sub Total"), $this->functions::formatNumber($data['sub_total']));
  }

  if (isset($data['taxable_total']) && $data['taxable_total'] > $average) {
      echo $this->functions->tableRow_euro(("Tax") . " " . ($data['tax'] * 100) . "%", $this->functions::formatNumber($data['taxable_total']));
  }

  if (isset($data['total_w_tax']) && $data['total_w_tax'] > $average) {
      echo $this->functions->tableRow_euro(("Total"), $this->functions::formatNumber($data['total_w_tax']));
  }
  ?>
</table>
<?php 
    endif;
    $new_total_html = ob_get_clean();
}
// ---testing code

                  
                          
                                        
                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                      'apply_food_tax'=>$data['apply_food_tax'],
                      'data'=>$new_data,
                      'html'=>$data2['html'],
                      'new_total_html'=>$new_total_html
                    );
                     
                } else $this->msg = ("Order not available to view. please try again later");                
            } else $this->msg = ("Order not available to view. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


    public function reOrder()
    {
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        
        $id = isset($this->data['id'])?$this->data['id']:'';    
        $order_id = $id;
        if($id>=1){
            if ($res = $this->SingleAppClass->ReOrderGetInfo($order_id)){  
                
                
                if($res['merchant_status']!="active"){
                    $this->msg = ("Merchant is no longer active");
                    $this->output();
                }           
                if($res['is_ready']!=2){
                    $this->msg = ("Merchant is not published");
                    $this->output();
                }           
                                                                
                /*VALIDATE IF ITEM IS AVAILABLE*/
                $cart_count=0;
                $json_details = json_decode($res['json_details'],true);
                $re_order_items = array();                          
                    
                if(is_array($json_details) && count($json_details)>=1){
                   foreach ($json_details as $item) {                                          
                    
                       $newest_price = 0; $newest_discount=0;
                       $current_discount = 0; $current_item_price = 0;
                    
                       if ($item_res = $this->functions->getFoodItem($item['item_id'])){
                           if($item_res['not_available']==2){
                              // do nothing                       
                           } else {                        
                              //dump($item_res);                              
                              $current_discount = isset($item['discount'])?$item['discount']:0;
                              $item_price = explode("|",$item['price']);
                                                          
                              if( count($item_price) <=1){                              
                                          
                                $newest_discount = $item_res['discount'];
                                $current_item_price = $item_price[0];
                                $current_item = json_decode($item_res['price'],true);
                                if(is_array($current_item) && count($current_item)>=1){
                                    //$newest_price = $current_item[0];
                                    foreach ($current_item as $new_price) {
                                        $newest_price = $new_price;
                                    }
                                }                                                                                                         
                                if($current_item_price!=$newest_price){
                                    $item['price'] = $newest_price;
                                }                             
                                if($current_discount!=$newest_discount){
                                    $item['discount'] = $newest_discount;
                                }                             
                              } else {                                                                            
                                $newest_discount = $item_res['discount'];                                           
                                $current_size_id = isset($item_price[2])?$item_price[2]:0;
                                $current_item_price = isset($item_price[0])?$item_price[0]:0;
                                $newest_price_list = json_decode($item_res['price'],true);                              
                                if(array_key_exists($current_size_id,(array)$newest_price_list)){
                                    $newest_price = $newest_price_list[$current_size_id];                                                                   
                                    if($current_item_price!=$newest_price){
                                        $item['price'] = $newest_price."|".$item_price[1]."|".$item_price[2];
                                    }           
                                    
                                    if($current_discount!=$newest_discount){
                                       $item['discount'] = $newest_discount;
                                    }                             
                                                    
                                } else {
                                    // price does not exist
                                }                                                                               
                              }                                   
                                                          
                              $re_order_items[] = $item;
                              $cart_count++;
                           }
                       }                   
                   }
                }   
                
                
                /*dump($re_order_items);
                die();*/
                            
                if($cart_count<=0){
                    $this->msg = ("There is no item to re-order");
                    $this->output();
                }       
                                
                /*inventory*/               
                $merchant_id = $this->merchant_id;
                if($this->SingleAppClass->inventoryEnabled($merchant_id)){
                    try {                       
                        $this->StocksWrapper->verifyStocksReOrder($id,$merchant_id);
                    } catch (Exception $e) {
                        $this->msg = $e->getMessage();
                        $this->output();
                    }
                }       
                
                $params = array(                  
                  'cart'=>json_encode($re_order_items),
                  'date_modified'=>$this->functions->dateNow(),
                  'device_id'=>$this->device_uiid,
                  'merchant_id'=>$this->merchant_id
                );
                
                 
                
                if($this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
                    if ( $this->functions->updateData("mt_singleapp_cart",$params,'device_id',$this->device_uiid)){
                        $this->code = 1;
                        $this->msg = "OK";
                    } else $this->msg = ("Order not available to re-order. please try again later");
                } else {
                    if ($this->functions->insertData("mt_singleapp_cart",$params)){
                        $this->code = 1;
                        $this->msg = "OK";
                    } else $this->msg = ("Order not available to re-order. please try again later");
                }
                
                $trans_type = $res['trans_type'];               
                $services = $this->SingleAppClass->getMerchantServices($res['service']);
                
                if(!array_key_exists($trans_type,(array)$services)){
                    if(is_array($services) && count($services)>=1){
                        foreach ($services as $key=>$val) {
                            $trans_type = $key;                         
                            break;
                        }
                    }           
                }
                
                $this->details = $trans_type;
                
            } else $this->msg = ("Order not available to re-order. please try again later");
        } else $this->msg = ("Invalid id");
        $this->output();
    }


    public function loadReviews()
{
    $client_id = '';  
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if ($res = $this->SingleAppClass->getCustomerByToken($token)) {		
        $client_id = $res['client_id'];
    }					

    $date_now = date('Y-m-d g:i:s a');

    $data = array();
    $reply = array();

    if (isset($this->data['limit'])) {
        $this->paginate_limit = $this->data['limit'];
    }

    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $this->paginate_limit;
    } else {
        $page = 0;  
    }

    $stmt = "SELECT a.*,
        (
        SELECT first_name
        FROM mt_client
        WHERE client_id = a.client_id
        ) AS client_name
        FROM mt_review a
        WHERE merchant_id = :merchant_id
        AND status = 'publish'
        ORDER BY id DESC
        LIMIT $page, {$this->paginate_limit}";

    $params = [
        ':merchant_id' => $this->merchant_id
    ];

    $website_review_type = $this->functions->getOptionAdmin('website_review_type');
    $review = false;
    if ($website_review_type == 1) {
        if ($remaining_review = $this->functions->getRemainingReview($client_id, $this->merchant_id)) {
            $review = true;
        }
    }

    $stmt_prepare = $this->db->prepare($stmt);
    foreach ($params as $key => $val) {
        $stmt_prepare->bindValue($key, $val);
    }

    if ($stmt_prepare->execute()) {
        $res = $stmt_prepare->fetchAll(PDO::FETCH_ASSOC);

        foreach ($res as $val) {
            $reply = array();
            $can_edit = true;

            $date_diff = $this->functions->dateDifference(
                date('Y-m-d g:i:s a', strtotime($val['date_created'])),
                $date_now
            );
            if (is_array($date_diff) && count($date_diff) >= 1) {
                if ($date_diff['days'] >= 10) {
                    $can_edit = false;
                }
            }

            $pretyy_date = $this->functions->translateDate($val['date_created']);

            if ($replies = $this->functions->reviewReplyList($val['id'], 'publish')) {
                foreach ($replies as $val_reply) {
                    $pretyy_date_reply = $this->functions->translateDate($val_reply['date_created']);

                    $reply[] = array(
                        'reply_from' => stripslashes($val_reply['reply_from']) . " reply",
                        'review' => ($val_reply['review']),
                        'date' => $pretyy_date_reply
                    );
                }
            }

            if ($can_edit) {
                if ($val['client_id'] != $client_id) {
                    $can_edit = false;
                }
            }

            $data[] = array(
                'id' => $val['id'],
                'review' => nl2br(($val['review'])),
                'rating' => $val['rating'],
                'client_name' => $val['client_name'],
                'avatar' => $this->SingleAppClass->getAvatar($val['client_id']),
                'can_edit' => $can_edit,
                'date' => $pretyy_date,
                'reply' => $reply
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'review' => $review,
            'data' => $data
        );

    } else {
        $this->details = array(
            'review' => $review
        );
        $this->msg = ("no results");
    }

    $this->output();
}


public function getReview()
	{
		$id = isset($this->data['id'])?$this->data['id']:'';
		if ($id>0){
			if ( $res=$this->functions->getReviewsById2($id,$this->merchant_id)){				
				$data = array(
				  'id'=>$res['id'],
				  'review'=>$res['review'],
				  'rating'=>$res['rating'],				  
				);
				$this->code = 1;
				$this->msg = "OK";
				$this->details = array(
				  'data'=>$data
				);
			} else $this->msg = ("Review is not available to view. please try again later");
		} else $this->msg = ("Invalid id");
		$this->output();
	}
	
	public function updateReview()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = ("token not found");
			$this->output();
		}			
		$client_id = $res['client_id'];		
		
		$id = isset($this->data['review_id'])?$this->data['review_id']:'';
		if ($id>0){
			
			
			 
			$params = array(
			 'review'=>($this->data['review']),
			 'date_modified'=>$this->functions->dateNow(),			 			 
			);
			
			if ($this->functions->updateData("mt_review",$params,'id',$id)){
				$this->code = 1;
				$this->msg  = "OK";
				$this->details = '';
			} else $this->msg = ("Cannot update records, please try again later");
		} else $this->msg = ("Invalid id");
		$this->output();
	}

public function deleteReview()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }			

    $client_id = $res['client_id'];		
    $id = isset($this->data['id']) ? $this->data['id'] : '';

    if ($id > 0) {
        $stmt = "DELETE FROM mt_review WHERE id = :id AND client_id = :client_id";
        $stmt_prepare = $this->db->prepare($stmt);
        $stmt_prepare->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt_prepare->bindValue(':client_id', $client_id, PDO::PARAM_INT);
        $stmt_prepare->execute();

        $this->code = 1;
        $this->msg = "OK";
    } else {
        $this->msg = ("Invalid id");
    }

    $this->output();
}

	
	public function getUserInfo()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!empty($token)){
			if($res = $this->SingleAppClass->getCustomerByToken($token)){			
				$data = array(
				  'name'=>$res['first_name']." ".$res['last_name'],
				  'email_address'=>$res['email_address'],
				  'contact_phone'=>$res['contact_phone']
				);
				$this->code = 1;
				$this->msg = "OK";	
				$this->details = array(
				   'data'=>$data
				);
			} else $this->msg = "Not login";
		} else $this->msg = "Not login";
		$this->output();
	}


	public function saveBooking()
	{
		 if ( isset($this->data['booking_time'])){
       	  if(!empty($this->data['booking_time'])){
       	  	 $time_1=date('Y-m-d g:i:s a');
       	  	 $time_2=$this->data['date_booking']." ".$this->data['booking_time'];       	  	 
       	  	 $time_2=date("Y-m-d g:i:s a",strtotime($time_2));	     	       	  	 
       	  	 $time_diff=$this->functions->dateDifference($time_2,$time_1);	       	  		       	  	        	  	        	  	 
       	  	 if (is_array($time_diff) && count($time_diff)>=1){
       	  	     if ( $time_diff['hours']>0){	       	  	     	
	       	  	     $this->msg=("Sorry but you have selected time that already past");
	       	  	     $this->output(); 	  	     	
       	  	     }	       	  	
       	  	     if ( $time_diff['minutes']>0){	       	  	     	
	       	  	     $this->msg=("Sorry but you have selected time that already past");
	       	  	     $this->output();  	  	     	
       	  	     }	       	  	
       	  	 }	       	  
       	  }	       
       }		     
       
       $merchant_id = $this->merchant_id;
       
       $full_booking_time=$this->data['date_booking']." ".$this->data['booking_time'];
	   $full_booking_day=strtolower(date("D",strtotime($full_booking_time)));			
	   $booking_time=date('h:i A',strtotime($full_booking_time));	
	   	   
	   if ( !$this->functions->isMerchantOpenTimes($merchant_id,$full_booking_day,$booking_time)){			
			

			$this->msg = "Sorry but we are closed on ".date("F,d Y h:ia",strtotime($full_booking_time))." Please check merchant opening hours";


		    $this->output();  	 
		}		   
		
		$now=isset($this->data['date_booking'])?$this->data['date_booking']:'';			
		$merchant_close_msg_holiday='';
	    $is_holiday=false;
	    if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)){
      	    if (in_array($now,(array)$m_holiday)){
      	   	    $is_holiday=true;
      	    }
	    }
	    if ( $is_holiday==true){
	    	$merchant_close_msg_holiday=!empty($merchant_close_msg_holiday)?$merchant_close_msg_holiday:("Sorry but we are on holiday on")." ".date("F d Y",strtotime($now));
	    	$this->msg=$merchant_close_msg_holiday;
	    	$this->output();  
	    }		  
	    
	    $fully_booked_msg=$this->functions->getOption("fully_booked_msg",$merchant_id);
		if (!$this->functions->bookedAvailable($merchant_id)){
		   if (!empty($fully_booked_msg)){
		    		$this->msg=($fully_booked_msg);
		   } else $this->msg=("Sorry we are fully booked for that day");			 	
		   $this->output();  
		}  
		
		$params=array(
		  'merchant_id'=>$this->merchant_id,
		  'number_guest'=>isset($this->data['number_guest'])?$this->data['number_guest']:'',
		  'date_booking'=>isset($this->data['date_booking'])?$this->data['date_booking']:'',
		  'booking_time'=>isset($this->data['booking_time'])?$this->data['booking_time']:'',
		  'booking_name'=>isset($this->data['booking_name'])?$this->data['booking_name']:'',
		  'email'=>isset($this->data['email'])?$this->data['email']:'',
		  'mobile'=>isset($this->data['mobile'])?$this->data['mobile']:'',
		  'booking_notes'=>isset($this->data['booking_notes'])?$this->data['booking_notes']:'',
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR'],		  
		);
		
		$token = isset($this->data['token'])?$this->data['token']:'';
		if($res = $this->SingleAppClass->getCustomerByToken($token)){
		   $params['client_id']= $res['client_id'];
		}			
		
		$last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
	    if ($last_insert_id!== false){ 							
			$booking_id=$last_insert_id;
			$this->code=1;			
			
			
			$this->msg = "Your booking has been placed. Reference # ".$booking_id;
			
			$this->details = $booking_id;
			
			/*SEND NOTIFICATIONS*/		
			$new_data = $params;	
			$new_data['restaurant_name']=$this->merchant_name;
		    $new_data['booking_id']=$booking_id;		    
		    $this->functions->notifyBooking($new_data);
		    
		    /*POINTS PROGRAM*/		    		
    		
    		   $this->PointsProgram->rewardsBookTable($booking_id , isset($params['client_id'])?$params['client_id']:'' , $merchant_id );
    		
			    
		} else $this->msg = ("Something went wrong during processing your request. Please try again later");
	   
	    $this->output();
	}


	public function getMerchantInfo()
	{
		if ( $res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){	
			$ratings=$this->functions->getRatings($this->merchant_id);   	
			$rating_text = '';
			if(is_array($ratings) && count($ratings)>=1){
				
				$rating_text =$ratings['votes']. "Reviews";
			}
			
			$merchant_photo_bg=$this->functions->getOption('merchant_photo_bg',$this->merchant_id);
			if ( empty($merchant_photo_bg)){
				$merchant_photo_bg='';
			} 			
						
			$data = array(  
			  'merchant_name'=>$this->functions->clearString($res['restaurant_name']),
			  'contact_phone'=>$res['contact_phone'],
			  'address'=>$this->functions->clearString($res['complete_address']),
			  'cuisine'=>$this->functions->displayCuisine($res['cuisine']),
			  'free_delivery'=>$this->functions->getFreeDeliveryTag($this->merchant_id),
			  'ratings'=>$ratings,
			  'rating_text'=>$rating_text,
			  'background_image'=>$merchant_photo_bg,
			  'latitude'=>$res['latitude'],
			  'lontitude'=>$res['lontitude'],
			);
			
			$new_hours = array();
			if ( $hours=$this->functions->getMerchantOpeningHours($this->merchant_id)){
				foreach ($hours as $val){
					$new_hours[]=array(
					  'day'=>($val['day']),
					  'hours'=>$val['hours'],
					  'open_text'=>($val['open_text']),
					);
				}
			} else $new_hours ='';
			
			$data['opening_hours'] = $new_hours;

			$payment_list_new=array();
			$payment_list = $this->functions->getMerchantPaymentListNew($this->merchant_id);		
			if(is_array($payment_list) && count($payment_list)>=1){
			   foreach ($payment_list as $payment_list_key=>$payment_list_val) {
			   		$payment_list_new[$payment_list_key] = ($payment_list_val);
			   	}	
			}		
			$data['payment_list'] = $payment_list_new;
			
			$data['information'] = $this->functions->getOption('merchant_information',$this->merchant_id);
			$data['information'] = $this->functions->clearString($data['information']);
			
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$data
			);
		} else {
			$this->msg = ("Merchant information not available. please try again later");
			$this->details = array(
			  'title'=>("Information not found"),
			  'sub_title'=>("Merchant information is not available")
			);	
		}	
		$this->output();
	}


	public function getMerchantPhoto()
	{
		$list = array();
		$gallery=$this->functions->getOption("merchant_gallery",$this->merchant_id);
        $gallery=!empty($gallery)?json_decode($gallery):false;
        if(is_array($gallery) && count($gallery)>=1){
        	foreach ($gallery as $val) {
        		$list[] = $this->SingleAppClass->getImage($val);
        	}        
        	$this->code = 1;
        	$this->msg ="OK";
        	$this->details=array('data'=>$list);
        } else $this->msg = ("Photos not available");        
		$this->output();
	}


	public function loadPromo()
    {
         $merchant_id = $this->merchant_id;
        if($merchant_id>0){
            $promo = array();
            $promo['enabled']=1;
                        
          
                if($offer=$this->functions->getOffersByMerchantNew($merchant_id)){
                   $promo['offer']=$offer;
                   $promo['enabled']=2;
                }               
            
            
                     
                if ( $voucher=$this->functions->merchantActiveVoucher($merchant_id)){                            
                    $promo['enabled']=2;                
                    foreach ($voucher as $val) {
                        if ( $val['voucher_type']=="fixed amount"){
                          $amount=$this->functions->prettyPrice($val['amount']);
                        } else $amount=number_format( ($val['amount']/100)*100 )." %";
                        
                        $promo['voucher'][] = $val['voucher_name']." - ".$amount." ".("Discount");
                    }                               
                }
            
            
            $free_delivery_above_price=$this->functions->getOption('free_delivery_above_price',$merchant_id);
            if ($free_delivery_above_price>0){
                $promo['free_delivery']=("Free Delivery On Orders Over")." ". $this->functions->prettyPrice($free_delivery_above_price);
                $promo['enabled']=2;
            }
                      
            $this->code = 1;
            $this->msg = "OK";
            if($promo['enabled']==1){
                $this->msg = ("No available promos for this merchant");             
            }                           
            $this->details = array(
              'data'=>$promo,
              'title'=>("No available promo"),
               'sub_title'=>("We don't have promo at this time")
            );
            
        } else $this->msg = ("Invalid merchant id");        
        $this->output();
    }
    
    public function loadBooking_bkedup()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $data = array();

    if ($client_id = $this->checkToken()) {

        $pagelimit = $this->SingleAppClass->paginateLimit();
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0;
        }
        $limit = "LIMIT $page,$pagelimit";

        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';
        switch ($tab) {
            case "all":
                break;
            default:
                $and = " AND a.status = :status ";
                break;
        }

        $booking_cancel_days = $this->functions->getOptionAdmin('booking_cancel_days');
        $booking_cancel_hours = $this->functions->getOptionAdmin('booking_cancel_hours');
        $booking_cancel_minutes = $this->functions->getOptionAdmin('booking_cancel_minutes');

        $stmt = "
        SELECT
            a.booking_id,
            a.merchant_id,
            a.number_guest,
            a.status,
            a.status as status_raw,
            a.date_created,
            a.date_created as date_created_raw,
            a.request_cancel,
            b.restaurant_name as merchant_name,
            b.logo
        FROM
            mt_bookingtable a
        LEFT JOIN mt_merchant b
            ON a.merchant_id = b.merchant_id
        WHERE 
            a.client_id = :client_id
            AND a.merchant_id = :merchant_id
            $and
        ORDER BY a.booking_id DESC
        $limit
        ";

        $params = [
            ':client_id' => $client_id,
            ':merchant_id' => $this->merchant_id
        ];

        if (!empty($and)) {
            $params[':status'] = $tab;
        }

        $query = $this->db->prepare($stmt);
        $query->execute($params);

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {

            foreach ($res as $val) {

                $val['merchant_name'] = $val['merchant_name'];
                $val['status'] = ($val['status']);

                $val['number_guest'] = "No. of guest " . $val['number_guest'];

                $val['booking_ref'] = "Booking ID# " . $val['booking_id'];

                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                $ratings = $this->functions->getRatings($val['merchant_id']);
                $ratings['review_count'] = $ratings['votes'] . " reviews";

                $val['rating'] = $ratings;

                $val['can_cancel'] = 0;
                $can_cancel = $this->SingleAppClass->canCancel($val['date_created_raw'], $booking_cancel_days, $booking_cancel_hours, $booking_cancel_minutes);
                if ($can_cancel) {
                    if ($val['request_cancel'] <= 0) {
                        if ($val['status_raw'] == 'pending') {
                            $val['can_cancel'] = 'cancel_booking';
                        } else {
                            $val['can_cancel'] = 'cancel_booking_request_sent';
                        }
                    }
                } else {
                    if ($val['request_cancel'] > 0) {
                        $val['can_cancel'] = 'cancel_booking_request_sent';
                    }
                }

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->msg = ("Your Booking is empty");
                $this->details = array(
                    'title' => ("Your Booking is empty"),
                    'sub_title' => ("Make your first booking")
                );
            }
        }
    }
    $this->output();
}


public function loadBooking()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    $data = array();

    if ($client_id = $this->checkToken()) {

        $pagelimit = $this->SingleAppClass->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $limit = "LIMIT $page,$pagelimit";

        $and = '';
        $tab = isset($this->data['tab']) ? $this->data['tab'] : '';

        // If a specific tab (status) is selected, add to query
        if (!empty($tab) && $tab != 'all') {
            $and = " AND a.status = ?";
        }

        $booking_cancel_days = $this->functions->getOptionAdmin('booking_cancel_days');
        $booking_cancel_hours = $this->functions->getOptionAdmin('booking_cancel_hours');
        $booking_cancel_minutes = $this->functions->getOptionAdmin('booking_cancel_minutes');

        // --- Branch Logic ---
        $params = [$client_id]; // Start with client ID
        $merchantFilter = '';

        $checkBranch = $this->db->prepare("SELECT COUNT(*) FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?))");
        $checkBranch->execute([$this->merchant_id]);
        $branchExists = $checkBranch->fetchColumn();

        if ($branchExists > 0) {
            $stmtBranch = $this->db->prepare("SELECT merchant_id FROM mt_branches");
            $stmtBranch->execute();
            $branchRows = $stmtBranch->fetchAll(PDO::FETCH_ASSOC);

            $merchantIds = [];
            foreach ($branchRows as $row) {
                $ids = json_decode($row['merchant_id'], true);
                if (is_array($ids)) {
                    foreach ($ids as $id) {
                        $merchantIds[] = (int)$id;
                    }
                }
            }

            $merchantIds = array_unique($merchantIds);

            if (empty($merchantIds)) {
                $this->code = 6;
                $this->msg = "No valid branches found.";
                $this->details = [];
                $this->output();
                return;
            }

            $placeholders = implode(',', array_fill(0, count($merchantIds), '?'));
            $merchantFilter = " AND a.merchant_id IN ($placeholders)";
            $params = array_merge($params, $merchantIds);
        } else {
            $merchantFilter = " AND a.merchant_id = ?";
            $params[] = $this->merchant_id;
        }

        // Add tab (status) to the end of params if needed
        if (!empty($and)) {
            $params[] = $tab;
        }

        $stmt = "
            SELECT
                a.booking_id,
                a.merchant_id,
                a.number_guest,
                a.status,
                a.status as status_raw,
                a.date_created,
                a.date_created as date_created_raw,
                a.request_cancel,
                b.restaurant_name as merchant_name,
                b.logo
            FROM
                mt_bookingtable a
            LEFT JOIN mt_merchant b
                ON a.merchant_id = b.merchant_id
            WHERE 
                a.client_id = ?
                $merchantFilter
                $and
            ORDER BY a.booking_id DESC
            $limit
        ";

        $query = $this->db->prepare($stmt);
        $query->execute($params); // Only positional values in same order

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                $val['merchant_name'] = $val['merchant_name'];
                $val['status'] = $val['status'];
                $val['number_guest'] = "No. of guest " . $val['number_guest'];
                $val['booking_ref'] = "Booking ID# " . $val['booking_id'];
                $val['date_created'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                $ratings = $this->functions->getRatings($val['merchant_id']);
                $ratings['review_count'] = $ratings['votes'] . " reviews";
                $val['rating'] = $ratings;

                $val['can_cancel'] = 0;
                $can_cancel = $this->SingleAppClass->canCancel(
                    $val['date_created_raw'],
                    $booking_cancel_days,
                    $booking_cancel_hours,
                    $booking_cancel_minutes
                );

                if ($can_cancel) {
                    if ($val['request_cancel'] <= 0) {
                        $val['can_cancel'] = $val['status_raw'] == 'pending' ? 'cancel_booking' : 'cancel_booking_request_sent';
                    }
                } else {
                    if ($val['request_cancel'] > 0) {
                        $val['can_cancel'] = 'cancel_booking_request_sent';
                    }
                }

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->msg = ("Your Booking is empty");
                $this->details = array(
                    'title' => ("Your Booking is empty"),
                    'sub_title' => ("Make your first booking")
                );
            }
        }
    }

    $this->output();
}




	public function getPaypal()
	{		
		$total=0;
		
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:'';
		
		if($order_id>0){
			if($res=$this->functions->getOrderInfo($order_id)){				
				$total = $res['total_w_tax'];
			}
		} else {
		   $this->msg = ("Invalid order id");
		   $this->output();	
		}	
		
		if($total<=0){
		  $this->msg = ("Invalid amount");
		  $this->output();	
		}
				
		if ( $res = $this->SingleAppClass->getPaypalCredentials($this->merchant_id)){		
						
			if( strtolower($res['mode'])=="live"){
				$res['mode']='production';
			}		
				
			$res['total']= number_format($total,2,'.','');
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'order_id'=>$order_id,
			  'currency'=>$this->functions->getCurrencyCode(),
			  
			  'total_to_pay'=>"Total amount to pay".$this->functions->prettyPrice($total),

			  'data'=>$res
			);
		} else $this->msg = ("Credentials not available");
		$this->output();
	}


	public function selectCreditCards()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = ("token not found");
			$this->output();
		}			
		$client_id = $res['client_id'];		
		
		if ( $res = $this->SingleAppClass->getCreditCards($client_id)){
			 $data =array();
			 foreach ($res as $val) {
			 	$data[]= array(
			 	  'id'=>$val['cc_id'],
			 	  'card'=>$this->functions->maskCardnumber($val['credit_card_number'])
			 	);
			 }			
			 $this->code = 1;
			 $this->msg = "OK";
			 $this->details = array(
			   'data'=>$data
			 );
		} else $this->msg =  ("No results");
		$this->output();
	}
	
	public function getStripe()
	{
		if ( $res = $this->SingleAppClass->getStripeCredentials($this->merchant_id)){
			$this->code = 1;
			$this->msg = 'OK';
			$this->details = array(
			  'credentials'=>$res
			);
		} else $this->msg = ("Credentials not available");
		$this->output();
	}

	public function getPayondeliverycards()
	{
			
		$token = isset($this->data['token'])?$this->data['token']:'';
		if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
			$this->code = 3;
			$this->msg = ("token not found");
			$this->output();
		}			
		$client_id = $res['client_id'];	
		
		if($res=$this->functions->getPaymentProviderMerchant($this->merchant_id)){
			$data = array();
			foreach ($res as $val) {
				$val['payment_logo'] = $this->SingleAppClass->getImage($val['payment_logo']);
				$data[] = $val;
			}
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>$data
			);
		} else $this->msg = ("No results");
		
		$this->output();
	}


	public function mapInfo()
	{
		if ($res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
			$latitude = $res['latitude'];
			$lontitude  = $res['lontitude'];
			$address = $this->functions->clearString($res['complete_address']);
			$merchant_name = $this->functions->clearString($res['restaurant_name']);
			$this->code = 1;
			$this->msg = "OK";
			$this->details = array(
			  'data'=>array(			    
			    'info_window'=>"<h5>$merchant_name</h5><p>$address</p>",
			    'latitude'=>$latitude,
			    'lontitude'=>$lontitude,			    
			  )
			);
		} else $this->msg = ("Merchant information not available. please try again later");
		$this->output();
	}
	
	public function fbRegister()
	{			
	    		
		
		$this->Validator->required(array(
		  'email_address'=>"email address is required",
		  'fb_id'=>"facebook id is required"
		),$this->data);
		
		
		/*check if email address is blocked*/
    	if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
    		
    		$this->Validator->setmsg("Sorry but your email address is blocked by website admin");    		
    	}	    
    	
    	    			
		if($this->Validator->validate()){						
			
						
			$params=array(
    		  'first_name'=>($this->data['first_name']),
    		  'last_name'=>($this->data['last_name']),
    		  'email_address'=>($this->data['email_address']),
    		  'password'=>md5($this->data['fb_id']),
    		  'date_created'=> $this->functions->dateNow(),
    		  'ip_address'=>$_SERVER['REMOTE_ADDR'],    		  
    		  'device_id'=>isset($this->data['device_id'])?$this->data['device_id']:'',
    		  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
    		  'social_strategy'=>'fb_mobile',
    		  'single_app_merchant_id'=>$this->merchant_id,
    		  'enabled_push'=>1,
    		  'single_app_device_uiid'=>$this->device_uiid,
    		);
    		
    		$save_pic =  $this->functions->getOption('singleapp_fb_save_pic',$this->merchant_id);
    		$save_avatar_exist = false;
    		
    		$save_avatar_exist=true;
    			
    		
    		if( $res =  $this->functions->isClientExist($params['email_address']) ){
    			
    			if($save_pic==1 && $save_avatar_exist==true){
    				if (empty($res['avatar'])){
	    				$params['social_id'] = $this->data['fb_id'];
    				}
    			}
    			
    			$token = $res['token'];
    			if(empty($token)){
    				$token = $this->SingleAppClass->generateUniqueToken(15,$params['fb_id']);	    
    				$params['token'] = $token;
    			}    		
    			
    			unset($params['date_created']);
    			$params['last_login']=$this->functions->dateNow();
    			    			
    			$this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);			
    			
    			$this->code=1;
	    		$this->msg = ("Registration successful");
	    		
	    		$this->details = array(
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'token'=>$token
    			);
    			
    			
    			
    		} else {
    			// insert 
    			
    			if($save_pic==1 && $save_avatar_exist==true){    				
    				$params['social_id'] = $this->data['fb_id'];
    			}
    			
    			$token = $this->SingleAppClass->generateUniqueToken(15,$params['email_address']);
	    	    $params['token']=$token;

	    	    $last_insert_id = $this->functions->insertData('mt_client', $params);
	            if ($last_insert_id!== false){ 

    				$customer_id =$last_insert_id;	    		
	    		    $this->code=1;
	    		    $this->msg = ("Registration successful");
	    		    
	    		    $this->details = array(
	    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
	    			  'token'=>$token
	    			);
	    				    			
	                /*POINTS PROGRAM*/	    			
		    	    
		    		    $this->PointsProgram->signupReward($customer_id);
		    	    
		    	    		    	    
	                //FunctionsV3::fastRequest( websiteUrl()."/singlemerchant/cron/getfbavatar" );
	    			
    			} else $this->msg = ("Something went wrong during processing your request. Please try again later");
    		}
		
		} else $this->msg = $this->SingleAppClass->parseValidatorError($this->Validator->getError());
		$this->output();
	}


	public function verificationMobile()
	{
		$code = isset($this->data['code'])?trim($this->data['code']):'';
		if(!empty($code)){
			$token = isset($this->data['token'])?$this->data['token']:'';
			if(empty($token)){
				$this->msg = ("Token is empty");
				$this->output();
			}					
			if($res = $this->SingleAppClass->getCustomerByToken($token,false)){				
				$client_id = $res['client_id'];
				if ( $res['mobile_verification_code']==$code){
									
					$this->code=1;
				    $this->msg=("Successful");
				    $this->details = array(
				      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
				      'token'=>$token
				    );
				    $params=array( 
					  'status'=>"active",
					  'mobile_verification_date'=>$this->functions->dateNow()
					);
					
					$this->functions->updateData("mt_client",$params,'client_id',$client_id);
					
					/*sent welcome email*/	    			
		    		$this->functions->sendCustomerWelcomeEmail($res);
				    
				} else $this->msg = ("Verification code is invalid");
			} else $this->msg =("Records not found");
		} else $this->msg = ("Invalid code");
		$this->output();
	}
	
	public function verificationEmail()
	{
		$code = isset($this->data['code'])?trim($this->data['code']):'';
		if(!empty($code)){
			$token = isset($this->data['token'])?$this->data['token']:'';
			if(empty($token)){
				$this->msg = ("Token is empty");
				$this->output();
			}		
			if($res = $this->SingleAppClass->getCustomerByToken($token,false)){				
				$client_id = $res['client_id'];				
				if ( $res['email_verification_code']==$code){
									
					$this->code=1;
				    $this->msg=("Successful");
				    $this->details = array(
				      'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
				      'token'=>$token
				    );
				    $params=array( 
					  'status'=>"active",
					  'last_login'=>$this->functions->dateNow()
					);
					
					$this->functions->updateData("mt_client",$params,'client_id',$client_id);
					
					/*sent welcome email*/	    			
		    		$this->functions->sendCustomerWelcomeEmail($res);
				    
				} else $this->msg = ("Verification code is invalid");
			} else $this->msg = ("Records not found");
		} else $this->msg =("Invalid code");		
		$this->output();
	}


	public function getAppSettings()
    {
        $this->code = 1;
        $this->msg = "OK";  

		$plats_form=isset($this->data['device_platform']) ? strtolower($this->data['device_platform']) : 'android';

        $lang = 'en';
            
        $mobile_prefix  = $this->functions->getOption('singleapp_prefix',$this->merchant_id);
        if(!empty($mobile_prefix)){
            $mobile_prefix = "+$mobile_prefix";
        } else $mobile_prefix="+1";
                
        $singleapp_default_lang = $this->functions->getOption('singleapp_default_lang',$this->merchant_id);       
        if(!empty($singleapp_default_lang)){
            $lang=$singleapp_default_lang;
        }
        
        $has_pts = '';
        
            $points_enabled = $this->functions->getOptionAdmin('points_enabled');
            if($points_enabled==1){
               $has_pts=1;
            }
            
            if($has_pts==1){                    
                $points_disabled_merchant_settings  = $this->functions->getOptionAdmin('points_disabled_merchant_settings');
                if(empty($points_disabled_merchant_settings)){
                    $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$this->merchant_id);
                    if($mt_disabled_pts==2){
                        $has_pts='';
                    }                   
                }           
            }


        
                
        $settings = array(                
          'terms_customer'=>$this->functions->getOptionAdmin('website_terms_customer'),
          'terms_customer_url'=>$this->functions->prettyUrl($this->functions->getOptionAdmin('website_terms_customer_url')),
          'currency_set'=>$this->functions->getOptionAdmin('admin_currency_set'),
          'currency_symbol'=>$this->functions->getCurrencyCode(),
          'currency_position'=>$this->functions->getOptionAdmin('admin_currency_position'),
          'currency_decimal_place'=>$this->functions->getOptionAdmin('admin_decimal_place'),
          'currency_space'=>$this->functions->getOptionAdmin('admin_add_space_between_price'),
          'currency_use_separators'=>$this->functions->getOptionAdmin('admin_use_separators'),
          'currency_decimal_separator'=>$this->functions->getOptionAdmin('admin_decimal_separator'),
          'currency_thousand_separator'=>$this->functions->getOptionAdmin('admin_thousand_separator'),
          'booking_disabled'=>$this->functions->getOptionAdmin('merchant_tbl_book_disabled'),
          'cod_change_required'=>$this->functions->getOptionAdmin('cod_change_required'),
          'disabled_website_ordering'=>$this->functions->getOptionAdmin('disabled_website_ordering'),
          'website_hide_foodprice'=>$this->functions->getOptionAdmin('website_hide_foodprice'),
          'enabled_map_selection_delivery'=>$this->functions->getOptionAdmin('enabled_map_selection_delivery'),
          'map_icon_pin'=>$this->functions->websiteUrl()."/assets_singleapp/images/icon_28.png",
          'mobile_prefix'=>$mobile_prefix,
          'lang'=>$singleapp_default_lang,
          
          'order_verification'=>$this->functions->getOption('order_verification',$this->merchant_id),
          'gallery_disabled'=>$this->functions->getOption('gallery_disabled',$this->merchant_id),
          'merchant_enabled_voucher'=>$this->functions->getOption('merchant_enabled_voucher',$this->merchant_id),
          'merchant_required_delivery_time'=>$this->functions->getOption('merchant_required_delivery_time',$this->merchant_id),
          'merchant_enabled_tip'=>$this->functions->getOption('merchant_enabled_tip',$this->merchant_id),
          'merchant_tip_default'=>$this->functions->getOption('merchant_tip_default',$this->merchant_id),
          'singleapp_location_accuracy'=>$this->functions->getOption('singleapp_location_accuracy',$this->merchant_id),
          'singleapp_enabled_fblogin'=>$this->functions->getOption('singleapp_enabled_fblogin',$this->merchant_id),
          
          'singleapp_help_url'=>$this->functions->getOption('singleapp_help_url',$this->merchant_id),
          'singleapp_terms_url'=>$this->functions->getOption('singleapp_terms_url',$this->merchant_id),
          'singleapp_privacy_url'=>$this->functions->getOption('singleapp_privacy_url',$this->merchant_id),
          
          'merchant_two_flavor_option'=>$this->functions->getOption('merchant_two_flavor_option',$this->merchant_id),

          'branch_list' => (function() {
    $branch_ids = json_decode($this->functions->getOptionAdmin("branchmangement"));
    $branch_list = [];

    if (is_array($branch_ids) && !empty($branch_ids)) {
        $placeholders = implode(',', array_fill(0, count($branch_ids), '?'));

        $stmt = $this->db->prepare("
            SELECT merchant_id, restaurant_name, single_app_keys
            FROM mt_merchant 
            WHERE merchant_id IN ($placeholders)
        ");
        $stmt->execute($branch_ids);
        $branch_list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    return $branch_list;
})(),

 
          'singleapp_enabled_banner'=>$this->functions->getOption('singleapp_enabled_banner',$this->merchant_id),
          'map_provider'=>$this->functions->getMapProvider_merchant_platform($this->merchant_id,$plats_form),
          'map_country'=>$this->functions->getCountryCode(),
          'geocomplete_default_country'=>$this->functions->getOptionAdmin('google_default_country'),
          'mapbox_access_token'=>$this->functions->getOptionAdmin('mapbox_access_token'),
          'mapbox_default_zoom'=>$this->functions->getOptionAdmin('mapbox_default_zoom'),
          'singleapp_enabled_google'=>$this->functions->getOption('singleapp_enabled_google',$this->merchant_id),
          'has_pts'=>$has_pts,
          'disabled_cc_management'=>$this->functions->getOptionAdmin('disabled_cc_management')
        );      
        
        if($settings['booking_disabled']!=2){
           if($this->functions->getOption('merchant_table_booking',$this->merchant_id)=="yes"){
              $settings['booking_disabled']=2;
           }        
        }   
        
        $settings['default_map_location']  = array(
          'lat'=>$this->functions->getOption('singleapp_default_lat',$this->merchant_id),
          'lng'=>$this->functions->getOption('singleapp_default_lng',$this->merchant_id)
        );
        
        
        $settings['default_map_location']  = array(
          'lat'=>$this->functions->getOption('merchant_latitude',$this->merchant_id),
          'lng'=>$this->functions->getOption('merchant_longtitude',$this->merchant_id)
        );
        
        
        $settings['icons']=array(
          'marker1'=>$this->functions->websiteUrl()."/assets_singleapp/images/icon_28.png",
          'marker2'=>$this->functions->websiteUrl()."/assets_singleapp/images/marker_green.png",
          'marker3'=>$this->functions->websiteUrl()."/assets_singleapp/images/marker_orange.png",
          'bicycle'=>$this->functions->websiteUrl()."/assets_singleapp/images/bicycle.png",
          'bike'=>$this->functions->websiteUrl()."/assets_singleapp/images/bike.png",
          'car'=>$this->functions->websiteUrl()."/assets_singleapp/images/car.png",
          'scooter'=>$this->functions->websiteUrl()."/assets_singleapp/images/scooter.png",
          'truck'=>$this->functions->websiteUrl()."/assets_singleapp/images/truck.png",
          'walk'=>$this->functions->websiteUrl()."/assets_singleapp/images/walk.png",
        );  
        $settings['marker_icon']=array(
           $settings['icons']['marker1'],
           $settings['icons']['marker2'],
           $settings['icons']['marker3'],
           $this->functions->websiteUrl()."/assets_singleapp/images/marker1.png",
           $this->functions->websiteUrl()."/assets_singleapp/images/marker2.png",
           $this->functions->websiteUrl()."/assets_singleapp/images/marker3.png",
           $this->functions->websiteUrl()."/assets_singleapp/images/marker4.png",
        );
        
        if($settings['singleapp_enabled_banner']==1){       
            if($banner = $this->SingleAppClass->getBannerLink($this->merchant_id)){
                $settings['singleapp_banner']=$banner;      
                
                $homebanner_interval = $this->functions->getOption('singleapp_homebanner_interval',$this->merchant_id);
                $homebanner_auto_scroll = $this->functions->getOption('singleapp_homebanner_auto_scroll',$this->merchant_id);
                $settings['homebanner_interval']=$homebanner_interval>0?$homebanner_interval:3000;
                $settings['homebanner_auto_scroll']=$homebanner_auto_scroll>0?$homebanner_auto_scroll:0;
                        
            } else $settings['singleapp_enabled_banner']=0;                             
        }   
        
        if(empty($settings['currency_set'])){
            $settings['currency_set']='USD';
        }
        if(empty($settings['currency_position'])){
            $settings['currency_position']='left';
        }
        if(empty($settings['currency_decimal_place'])){
            $settings['currency_position']=2;
        }
        if(empty($settings['currency_decimal_separator'])){
            $settings['currency_decimal_separator']=".";
        }
        if($settings['currency_use_separators']=="yes"){
            if($settings['currency_thousand_separator']==""){
                $settings['currency_thousand_separator']=",";
            }       
        }   
        if($settings['order_verification']==2){
            $mechant_sms_enabled = $this->functions->getOptionAdmin('mechant_sms_enabled');
            if($mechant_sms_enabled=="yes"){
                $settings['order_verification']='';
            }       
            $sms_balance=$this->functions->getMerchantSMSCredit($this->merchant_id);
             if ( $sms_balance<=0){
                $settings['order_verification']='';
             }      
        }               
        
        $reg_email = $this->functions->getOption('singleapp_reg_email',$this->merchant_id); 
        $reg_mobile = $this->functions->getOption('singleapp_reg_phone',$this->merchant_id);
        
        if(empty($reg_email) && empty($reg_mobile)){
            $reg_email = 1;
            $reg_mobile = 1;
        }
        
        $settings['registration']=array(
          'email'=>$reg_email,
          'mobile'=>$reg_mobile,
          'custom_field1'=>$this->functions->getOptionAdmin('client_custom_field_name1'),
          'custom_field2'=>$this->functions->getOptionAdmin('client_custom_field_name2'),
        );
        
        $valid_token = false;
        $token = isset($this->data['token'])?$this->data['token']:'';
        if($this->SingleAppClass->getCustomerByToken($token)){
            $valid_token = true;
        }
                
        $settings['valid_token'] = $valid_token;            
        $settings['remove_phone_prefix'] = $this->functions->getOption('singleapp_remove_phone_prefix',$this->merchant_id);
        
        $location_rep = $this->SingleAppClass->searchMode();
        $settings['search_mode']=$location_rep['search_mode'];
        $settings['location_mode'] = $location_rep['location_mode'];
        
        
        $singleapp_startup = $this->functions->getOption('singleapp_startup',$this->merchant_id);     
        $singleapp_startup_auto_scroll = $this->functions->getOption('singleapp_startup_auto_scroll',$this->merchant_id);
        $singleapp_startup_interval = $this->functions->getOption('singleapp_startup_interval',$this->merchant_id);
        
        $settings['home']=array(
          'startup_language'=>$this->functions->getOption('singleapp_enabled_select_language',$this->merchant_id),
          'startup_banner'=>!empty($singleapp_startup)?$singleapp_startup:1,
          'startup_banner_auto'=>$singleapp_startup_auto_scroll==1?true:false,
          'startup_banner_interval'=>$singleapp_startup_interval>0?$singleapp_startup_interval:3000,      
        );                      
        $settings['startup_banner_images'] = (array)$this->SingleAppClass->getStartUpBanner($this->merchant_id);
                
        $settings['custom_pages'] = $this->SingleAppClass->getTitlePages($this->merchant_id);
        
        $singleapp_rtl = $this->functions->getOption('singleapp_rtl',$this->merchant_id);
        $settings['is_rtl'] = $singleapp_rtl>0?$singleapp_rtl:0;
        
        $custom_pages_position = $this->functions->getOption('singleapp_custom_pages_position',$this->merchant_id);
        $settings['custom_pages_position'] = $custom_pages_position>0?$custom_pages_position:1;
        
        $cart_theme = $this->functions->getOption('singleapp_cart_theme',$this->merchant_id);     
        $settings['cart_settings']=array(
          'theme'=>$cart_theme>0?$cart_theme:1,
          'auto_address'=>$this->functions->getOption('singleapp_cart_auto_address',$this->merchant_id),
          'floating_category'=>$this->functions->getOption('singleapp_floating_category',$this->merchant_id)
        );
                            
        $settings['banner'] = array(
          'banner1'=>$this->SingleAppClass->getImage('resto_banner.jpg','resto_banner.jpg')
        );
        
        $settings['tracking_interval_timeout'] = $this->functions->getOption('singleapp_tracking_interval',$this->merchant_id,);
        
        if ($merchant_res = $this->functions->getMerchantInfo_mobileapp($this->merchant_id)){
            $info_address = $this->functions->clearString($merchant_res['complete_address']);
            $info_merchant_name = $this->functions->clearString($merchant_res['restaurant_name']);
            $settings['merchant_details'] = array(
              'lat'=>trim($merchant_res['latitude']),
              'lng'=>trim($merchant_res['lontitude']),
              'info_window'=>"<h5>$info_merchant_name</h5><p>$info_address</p>",
            );
        }
        
        $menu_type = $this->functions->getOption('singleapp_menu_type',$this->merchant_id);
        $settings['menu_type'] = $menu_type>0?$menu_type:1;
                
        $settings['disabled_default_image'] = $this->functions->getOption('singleapp_disabled_default_menu',$this->merchant_id);
                    
        $dict = "";
        $settings['dict'] = $dict;
        
        $settings['booking_tabs'] = $this->SingleAppClass->BookingTabs();
        $settings['order_tabs'] = $this->SingleAppClass->OrderTabs();
        $settings['contact_us']= $this->SingleAppClass->ContactUsData($this->merchant_id);
        $settings['contact_us_enabled']= $this->functions->getOption('singleapp_contactus_enabled',$this->merchant_id);
        
        $settings['enabled_addon_desc']= $this->functions->getOption('singleapp_enabled_addon_desc',$this->merchant_id);
        $settings['confirm_future_order']= $this->functions->getOption('singleapp_confirm_future_order',$this->merchant_id);
                
        $settings['customer_forgot_password_sms'] = $this->functions->getOptionAdmin('customer_forgot_password_sms');
        
        if ($device_info = $this->SingleAppClass->getDeviceByUIID( $this->device_uiid )){
            $settings['subscribe_topic']= $device_info['subscribe_topic'];
        } else $settings['subscribe_topic'] = 1;
        
        $settings['topics'] = "singleapp_broadcast".$this->merchant_id;

        $stmt = "SELECT COUNT(*) 
         FROM mt_branches 
         WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?))";
		$pdoStmt = $this->db->prepare($stmt);
		$pdoStmt->execute([$this->merchant_id]);
		$branchExists = $pdoStmt->fetchColumn();

        $settings['branch_set'] = $branchExists > 0 ? 1 : 0;
        $settings['merchant_name'] = $this->merchant_name;



        
        $this->details = $settings;
        $this->output();
    }



 



	public function SendOrderSMSCode()
    {
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        $customer_number = isset($this->data['customer_number'])?$this->data['customer_number']:'';
        
        if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        $contact_phone = trim($res['contact_phone']);
                
        if(!empty($customer_number)){
            $contact_phone = trim($customer_number);
            $this->functions->updateData("mt_client",array(
              'contact_phone'=>$customer_number
            ),'client_id',$client_id);
        }   
                
        if(empty($contact_phone)){
            $this->msg = ("We cannot send sms code to your phone number cause its empty. please fixed by putting mobile number into your profile");
            $this->output();
        }   
        
        $sms_balance=$this->functions->getMerchantSMSCredit($this->merchant_id);   
        if ( $sms_balance>=1){
            $code=$this->functions->generateSMSOrderCode($contact_phone);
                

            $sms_msg= "Your order sms code is ".$code;      
                        
            if($last = $this->SingleAppClass->getLastOrderSMS($contact_phone)){                
                $date_now=date('Y-m-d g:i:s a');
                $date_created = date("Y-m-d g:i:s a",strtotime($last['date_created']));
                $date_diff=$this->functions->dateDifference($date_created,$date_now);              
                
                $order_sms_code_waiting = (integer) $this->functions->getOption('order_sms_code_waiting',$this->merchant_id);
                if($order_sms_code_waiting<=0){
                    $order_sms_code_waiting = 5;
                }           
                                        
                $continue = true;   $waiting_time = '';                                 
                if(is_array($date_diff) && count($date_diff)>=1){               
                    if($order_sms_code_waiting>$date_diff['minutes']){                              
                        $waiting_time = $date_diff['minutes'];
                        $continue=false;
                    }   
                    if($continue==false){
                        if($date_diff['days']>0){
                            $continue=true;
                        }                   
                        if($date_diff['hours']>0){
                            $continue=true;
                        }                   
                    }               
                }                       
                
                if(!$continue){
                    $waiting_time = (integer)$order_sms_code_waiting - (integer)$waiting_time;
                    

                     $this->msg = "Your requesting too soon please wait after ".$waiting_time." minutes" ;


                    $this->output();
                }                                           
            }
            
            if ( $resp=$this->functions->sendSMS($contact_phone,$sms_msg)){    
                             
                $resp['msg']="process";
                $resp['raw']=mktime();
                
                 if ($resp['msg']=="process"){                   
                    
                    $sms_order_session = $this->functions->generateCode(50);
                    
                    $this->code=1;
                    

                     $this->msg= "Your order sms code has been sent to ".$contact_phone;
                    
                    $this->details = array(
                      'sms_order_session'=>$sms_order_session
                    );                                      
                    
                    $contact_phone = str_replace("+","",$contact_phone);
                    $params=array(
                      'mobile'=>trim($contact_phone),
                      'code'=>$code,
                      'session'=>$sms_order_session,
                      'date_created'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']
                    );                  
                    $this->functions->insertData("mt_order_sms",$params);
                    
                    $params=array(
                      'merchant_id'=>$this->merchant_id,
                      'broadcast_id'=>"999999999",                        
                      'contact_phone'=>$contact_phone,
                      'sms_message'=>$sms_msg,
                      'status'=>$resp['msg'],
                      'gateway_response'=>$resp['raw'],
                      'date_created'=>$this->functions->dateNow(),
                      'date_executed'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'gateway'=>$resp['sms_provider']
                    );                        
                   $this->functions->insertData("mt_sms_broadcast_details",$params);   
                    
                 } else $this->msg=("Sorry but we cannot send sms code this time")." ".$resp['msg'];
            } else $this->msg=("Sorry but we cannot send sms code this time. please try again later");
        } else $this->msg=("Sorry but this merchant does not have enought sms credit to send sms");     
        $this->output();
    }


    public function verifyOrderSMSCODE()
    {
        $order_sms_session = isset($this->data['order_sms_session'])?$this->data['order_sms_session']:'';   
        $sms_code = isset($this->data['sms_code'])?$this->data['sms_code']:'';  
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass->getCustomerByToken($token,false)){
            $this->code = 3;
            $this->msg = ("token not found");
            $this->output();
        }           
        $client_id = $res['client_id'];     
        $contact_phone = $res['contact_phone'];
        
        if(!empty($order_sms_session)){
            if ($res = $this->functions->validateOrderSMSCode($contact_phone,$sms_code,$order_sms_session)){
                $this->code = 1;
                $this->msg = "OK";
                $this->details='';
            } else  $this->msg = ("Invalid sms code");
        } else $this->msg = ("sms session is empty");
        
        $this->output();
    }
    
    public function applyTips()
    {
        if (!is_numeric($this->merchant_id)){
            $this->msg = ("Invalid merchant id");
            $this->output();
        }
        
        $tips = isset($this->data['tips'])?$this->data['tips']:0;
        if ($tips>0){
            
            $data = array(
              'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
              'merchant_id'=>$this->merchant_id,
              'card_fee'=>0
            );
            if ( $cart = $this->SingleAppClass->getCartContent($this->device_uiid,$data)){         
                $params = array(
                  'tips'=>$tips,
                  'date_modified'=>$this->functions->dateNow()
                );
                
                $this->functions->updateData("mt_singleapp_cart",$params,'device_id',$this->device_uiid);
                $this->code = 1;
                $this->details = "";
                $this->msg = "OK";
            } else $this->msg = ("cart not available");
                        
        } else $this->msg = ("Invalid tip");
        $this->output();
    }
    
    public function removeTip()
    {
        $this->SingleAppClass->removeTip($this->device_uiid);
        $this->code = 1;
        $this->msg="OK";
        $this->details='';      
        $this->output();
    }
    
    public function getOrderHistory()
    {
        if ($client_id = $this->checkToken()){          
            $order_id = isset($this->data['id'])?$this->data['id']:0;
            $page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';        
            if($order_id>0){
                if ($res = $this->SingleAppClass->orderHistory($order_id)){
                    $data =array();
                     
                    
                    foreach ($res as $val) {
                  
                      $remarks = ($this->functions->clearString($val['remarks']));
                      if(!empty($val['remarks2'])){
                          $args=json_decode($val['remarks_args'],true);  
                          if(is_array($args) && count( (array) $args)>=1){
                             foreach ($args as $args_key=>$args_val) {
                                $args[$args_key]=($args_val);
                             }                       
                             $new_remarks=$val['remarks2'];
                             
                             $remarks=$new_remarks." ".$args;  
                          }
                      }

                      if($remarks==null){
		   	   	  	$remarks='';
		   	   	  }
                      
                      $data[]=array(
                        'date'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
                        'status_raw'=>$val['status'],
                        'status'=>($val['status']),
                        'remarks'=>$remarks
                      );
                   }
                   
                   $order_info = $this->SingleAppClass->orderDetails($order_id);              
                   $order_info['merchant_name'] = $this->functions->clearString($order_info['merchant_name']);
                   $order_info['logo'] = $order_info['logo']=$this->SingleAppClass->getImage($order_info['logo']);


                   

                   $order_info['transaction'] =$order_info['trans_type']." ".$order_info['order_id'];  


                   $order_info['payment_type'] = ($this->functions->prettyPaymentTypeTrans($order_info['trans_type'],$order_info['payment_type']));
                   
                   $this->code = 1;
                   $this->msg="OK";
                   $this->details = array(
                     'order_id'=>$order_id,
                     'show_track'=>"",
                     'page_action'=>$page_action,
                     'order_info'=>$order_info,
                     'data'=>$data,             
                   );               
                } else {
                    $this->code = 6;        
                    $this->msg = ("No results");                            
                    $this->details = array(
                      'title'=>("No results"),
                      'sub_title'=>("Order history is empty")
                    );  
                }       
            } else {                
                $this->code = 6;        
                $this->msg = ("invalid order id");                          
                $this->details = array(
                  'title'=>("Invalid order id"),
                  'sub_title'=>("Order history is empty")
                );  
            }
        }
        $this->output();
    }


   public function getCreditCards()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if ($res = $this->SingleAppClass->getCustomerByToken($token)) {
        $client_id = $res['client_id'];

        $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

        $pagelimit = $this->SingleAppClass->paginateLimit();
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0;
        }

        $paginate_total = 0;
        $limit = "LIMIT $page,$pagelimit";

        $stmt = "
            SELECT 
                cc_id,
                credit_card_number,
                date_created
            FROM mt_client_cc
            WHERE
                client_id = :client_id
            ORDER BY cc_id DESC
            $limit
        ";

        try {
            $query = $this->db->prepare($stmt);
            $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $query->execute();

            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                $data = array();
                foreach ($res as $val) {
                    $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                    $date_added = "Added " . $date_added;

                    $data[] = array(
                        'id' => $val['cc_id'],
                        'card' => $this->functions->maskCardnumber($val['credit_card_number']),
                        'date_added' => $date_added
                    );
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                    'page_action' => $page_action,
                    'data' => $data
                );
                $this->output();
            } else {
                if ($page_action == "infinite_scroll") {
                    $this->code = 2;
                    $this->msg = ("end of records");
                } else {
                    $this->code = 6;
                    $this->details = array(
                        'title' => ("Your credit card list is empty"),
                        'sub_title' => ("Add your first credit card")
                    );
                }
            }
        } catch (PDOException $e) {
            $this->code = 0;
            $this->msg = "Database error: " . $e->getMessage();
        }
    } else {
        $this->code = 3;
        $this->msg = ("token not found");
    }

    $this->output();
}



    public function ReGetOrderHistory()
	{
		if ($client_id = $this->checkToken()){		
			$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
			if($order_id>0){
				if ($res = $this->SingleAppClass->orderHistory($order_id)){
					$data =array();
						
					foreach ($res as $val) {				  
					  $remarks = ($this->functions->clearString($val['remarks']));
					  if(!empty($val['remarks2'])){
						  $args=json_decode($val['remarks_args'],true);  
						  if(is_array($args) && count( (array) $args)>=1){
							 foreach ($args as $args_key=>$args_val) {
								$args[$args_key]=($args_val);
							 }						 
							 $new_remarks=$val['remarks2'];
							 
							 $remarks=$new_remarks." ".$args;
						  }
					  }
					  
					  $data[]=array(
						'date'=>$this->functions->prettyDate($val['date_created'])." ".$this->functions->prettyTime($val['date_created']),
						'status_raw'=>$val['status'],
						'status'=>($val['status']),
						'remarks'=>$remarks
					  );
				   }
				   $this->code=1;
				   $this->details = array(					 
					 'show_track'=>"",					 
					 'data_count'=>count($data),
					 'data'=>$data,		   	    
				   );		
				} else $this->msg = ("No results");
			} else {
				$this->code = 6;
				$this->msg = ("invalid order id");
			}		
		}
		$this->output();
	}
	

	public function getlanguageList()
	{
		$data = array();
		if ($lang_list=$this->functions->getLanguageList(false) ){	
			$enabled_lang=$this->functions->getEnabledLanguage();
			foreach ($lang_list as $val) {
				if (in_array($val,(array)$enabled_lang)){
					$data[$val]=($val);
				}			
			}			
			$this->code=1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
			  'lang'=>"en",
			  'data'=>$data
			);
		} else {			
			$this->code = 6;
			$this->msg = ("No available language");							
			$this->details = array(
			  'title'=>("No available language"),
			  'sub_title'=>("language not available")
			);									
		}
		$this->output();
	}

	public function getbranchList()
{
    $data = [];

    $merchant_id = $this->merchant_id;

    // Only get rows where merchant_id JSON contains the current merchant_id
    $stmt = "SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?))";
    $pdoStmt = $this->db->prepare($stmt);
    $pdoStmt->execute([$merchant_id]);
    $branchRows = $pdoStmt->fetchAll(PDO::FETCH_ASSOC);

    $merchantIds = [];

    // Collect all merchant_ids from matching branch rows
    foreach ($branchRows as $row) {
        $ids = json_decode($row['merchant_id'], true);
        if (is_array($ids)) {
            foreach ($ids as $id) {
                $merchantIds[] = (int) $id;
            }
        }
    }

    $merchantIds = array_unique($merchantIds);

    if (!empty($merchantIds)) {
        $placeholders = implode(',', array_fill(0, count($merchantIds), '?'));
        $sql = "SELECT merchant_id AS id, restaurant_name, single_app_keys 
                FROM mt_merchant 
                WHERE merchant_id IN ($placeholders)";

        $pdoStmt = $this->db->prepare($sql);
        $pdoStmt->execute($merchantIds);
        $data = $pdoStmt->fetchAll(PDO::FETCH_ASSOC);
    }

    if (!empty($data)) {
        $this->code = 1;
        $this->msg = "OK";
        $this->details = $data;
    } else {
        $this->code = 6;
        $this->msg = "No branches found";
        $this->details = [];
    }

    $this->output();
}






	public function getMobileCodeList()
	{
		$mobile_countrycode = $this->functions->mobilecountry_code();
		$data = array();
		
		foreach ($mobile_countrycode as $key=>$val) {						
			$val['name']=ucwords(strtolower($val['name']));
			$val['country_code']=$key;
			$data[]=$val;			
		}
				
		$this->code=1;
		$this->msg="OK";
		$this->details = array(				  
		  'data'=>$data
		);
		$this->output();
	}



	public function loadNotification()
{
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $this->paginate_limit;
    } else {
        $page = 0;
    }

    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $client_id = '';

    if (!$res = $this->SingleAppClass->getCustomerByToken($token)) {
        // do nothing
    } else {
        $client_id = $res['client_id'];
    }

    $where = "WHERE is_read='0'";
    $and = '';

    if ($client_id > 0) {
        $and = " AND client_id = :client_id";
    } else {
        $and = " AND device_id = :device_id";
    }

    $limit = $this->paginate_limit;
    $offset = $page;

    $stmt = "
        SELECT 
        push_title,
        push_message,
        date_created
        FROM mt_singleapp_mobile_push_logs
        $where
        $and
        ORDER BY id DESC
        LIMIT :offset, :limit
    ";

    $data = array();

    try {
        $query = $this->db->prepare($stmt);

        if ($client_id > 0) {
            $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
        } else {
            $query->bindValue(':device_id', $this->device_id, PDO::PARAM_STR);
        }

        $query->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
        $query->bindValue(':limit', (int)$limit, PDO::PARAM_INT);

        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $date_created = $this->functions->prettyDate($val['date_created']);
                $date_created = $this->functions->translateDate($date_created);
                $data[] = array(
                    'push_title' => $this->functions->clearString($val['push_title']),
                    'push_message' => $this->functions->clearString($val['push_message']),
                    'date_created' => $date_created
                );
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'data' => $data
            );
        } else {
            $this->msg = ("No results");
        }

    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
    }

    $this->output();
}

public function requestForgotPass()
    {   

        $merchant_id=$this->merchant_id;    
        $user_email = isset($this->data['user_email'])?$this->data['user_email']:'';
        if(empty($user_email)){
            $user_email = isset($this->data['user_mobile'])?$this->data['user_mobile']:'';
        }   
        if(!empty($user_email)){
            if ( $res=$this->functions->isClientExist_singleapp($user_email,$merchant_id) ){
                $token=md5(date('c'));
                $params=array('lost_password_token'=>$token);       
                
                if ($this->functions->updateData("mt_client",$params,'client_id',$res['client_id'])){
                    
                    $this->code=1;                      
                    $this->msg= ("We sent your forgot password link, Please follow that link. Thank You.");
                    
                    $to=$res['email_address'];
                    
                    //send email                                            
                    $enabled=$this->functions->getOptionAdmin('customer_forgot_password_email');
                    if($enabled){
                        $lang="en"; 
                        $subject=$this->functions->getOptionAdmin("customer_forgot_password_tpl_subject_$lang");
                        if(!empty($subject)){
                            $subject=$this->functions->smarty('firstname',
                            isset($res['first_name'])?$res['first_name']:'',$subject);
                            
                            $subject=$this->functions->smarty('lastname',
                            isset($res['last_name'])?$res['last_name']:'',$subject);
                        }
                                                    
                        $tpl=$this->functions->getOptionAdmin("customer_forgot_password_tpl_content_$lang") ;
                        if (!empty($tpl)){                              
                            $tpl=$this->functions->smarty('firstname',
                            isset($res['first_name'])?$res['first_name']:'',$tpl);
                            
                            $tpl=$this->functions->smarty('lastname',
                            isset($res['last_name'])?$res['last_name']:'',$tpl);


                            
                            $tpl=$this->functions->smarty('change_pass_link',
                            Config::$baseUrl."/store/forgotpassword/token/".$token
                            ,$tpl);
                            
                            $tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
                            $tpl=$this->functions->smarty('siteurl',$this->functions->websiteUrl(),$tpl);
                        }
                        if (!empty($subject) && !empty($tpl)){
                            $this->functions->sendEmail($to,'',$subject, $tpl );
                        }                       
                    }       

                    
                } else $this->msg = ("Cannot update records, please try again later");
            } else $this->msg = ("Sorry but we cannot find your information");
        } else $this->msg = ("Invalid username or email address");
        $this->output();
    }


public function mapboxgeocode()
	{
		$this->geoCode();
	}
	
	public function geoCode()
	{
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
		$lng = isset($this->data['lng'])?$this->data['lng']:'';
		
		if(!empty($lat) && !empty($lng)){
			try {			 
								
			  
			      $res = $this->functions->latToAdress($lat,$lng);	
			  	
			  
			  $this->code = 1;
			  $this->msg  = "OK";	
			  $this->details = $res;
		    } catch (Exception $e) {
		      $this->msg =  ($e->getMessage());
		    }			
		} else $this->msg = ("Lat and long is required");
		$this->output();
	}




	public function updateDeviceID()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$res = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->code = 3;
        $this->msg = ("token not found");
        $this->output();
    }

    $client_id = $res['client_id'];
    $old_device_id = isset($this->data['old_device_id']) ? $this->data['old_device_id'] : '';
    $device_id = isset($this->data['device_id']) ? $this->data['device_id'] : '';

    if (!empty($device_id)) {
        $this->code = 1;
        $this->msg = 'Token updated';

        $params = array(
            'device_id' => trim($device_id),
            'device_platform' => isset($this->data['device_platform']) ? strtolower($this->data['device_platform']) : 'android',
            'date_modified' => $this->functions->dateNow(),
            'single_app_merchant_id' => $this->merchant_id,
        );

        // Keep this as-is (per your instruction)
        $this->functions->updateData("mt_client", $params, 'client_id', $client_id);

        /*CHECK IF OLD DEVICE IS THE SAME AS NEW*/
        if (!empty($old_device_id)) {
            if ($old_device_id != $device_id) {
                $stmt = "
                    UPDATE mt_singleapp_cart 
                    SET 
                        device_id = '" . addslashes($device_id) . "',
                        device_platform = '" . addslashes($params['device_platform']) . "',
                        date_modified = '" . addslashes($params['date_modified']) . "'
                    WHERE 
                        device_id = '" . addslashes($old_device_id) . "'
                ";

                try {
                    $this->db->exec($stmt);
                } catch (PDOException $e) {
                    $this->msg = "Database error: " . $e->getMessage();
                    $this->output();
                }
            }
        }

    } else {
        $this->msg = ("device id is empty");
    }

    $this->output();
}



public function applyRedeemPoints()
	{
		
		$points = isset($this->data['points'])?$this->data['points']:0;
		
		if($points>0.0001){		
		} else {
			$this->msg = ("Invalid redeem points");
			$this->output();
		}
				
		$token = isset($this->data['token'])?$this->data['token']:'';
    	if(!$client_info = $this->SingleAppClass->getCustomerByToken($token)){
    		$this->msg = ("Invalid token, please relogin again");
    		$this->output();
    	}    	
    	
    	$client_id = $client_info['client_id'];
    	
		$pts_disabled_redeem = $this->functions->getOptionAdmin('pts_disabled_redeem');
		if($pts_disabled_redeem==1){
			$this->msg = ("Redeeming points is disabled");
			$this->output();
		}	
		
		/*CHECK POINTS BALANCE*/
		$available_points = $this->PointsProgram->getTotalEarnPoints( $client_id , $this->merchant_id);
		if($available_points<=0){
			$this->msg = ("Sorry but your points is not enough");
			$this->output();
		}	
		
		if($points>$available_points){
			$this->msg = ("Sorry but your points is not enough");
			$this->output();
		}
		
	    $data = array(
		  'delivery_type'=>isset($this->data['transaction_type'])?$this->data['transaction_type']:'',
		  'merchant_id'=>$this->merchant_id,
		  'card_fee'=>0
		);					
		if ( $cart = $this->SingleAppClass->getCartContent($this->device_uiid,$data)){		
			
			$is_disabled_merchant_settings = $this->PointsProgram->isMerchantSettingsDisabled();
			
			/*CHECK IF HAS ALREADY DISCOUNT*/			
			$pts_enabled_offers_discount = $this->functions->getOptionAdmin('pts_enabled_offers_discount');
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_offers_discount = $this->functions->getOption('mt_pts_enabled_offers_discount',$this->merchant_id);
				if($mt_pts_enabled_offers_discount>0){					
					$pts_enabled_offers_discount = $mt_pts_enabled_offers_discount;
				}			
			}
			
			if($pts_enabled_offers_discount!=1){
				$discounted_amount = isset($cart['total']['discounted_amount'])?$cart['total']['discounted_amount']:0;			
				if($discounted_amount>0.0001){
					$this->msg = ("Sorry you cannot apply voucher, exising discount is alread applied in your cart");


					$this->output();
				}					
			}
			/*END CHECK IF HAS ALREADY DISCOUNT*/
			
			/*CHECK IF HAS ALREADY VOUCHER*/				
			$pts_enabled_add_voucher = $this->functions->getOptionAdmin('pts_enabled_add_voucher');
			if(!$is_disabled_merchant_settings){
				$mt_pts_enabled_add_voucher= $this->functions->getOption('mt_pts_enabled_add_voucher',$this->merchant_id);
				if($mt_pts_enabled_add_voucher>0){
					$pts_enabled_add_voucher=$mt_pts_enabled_add_voucher;
				}			
			}
			
			if($pts_enabled_add_voucher!=1){
				$less_voucher = $cart['total']['less_voucher'];			
				if($less_voucher>0.0001){
				   $this->msg =("Sorry but you cannot redeem points if you have already voucher applied on your cart");
				   $this->output();
				}					
			}
			/*END CHECK IF HAS ALREADY VOUCHER*/	
						
			$redeeming_point = $this->functions->getOptionAdmin('pts_redeeming_point');
			$redeeming_point_value = $this->functions->getOptionAdmin('pts_redeeming_point_value');
			
			if(!$is_disabled_merchant_settings){
				$mt_pts_redeeming_point = $this->functions->getOption('mt_pts_redeeming_point',$this->merchant_id);
				$mt_pts_redeeming_point_value = $this->functions->getOption('mt_pts_redeeming_point_value',$this->merchant_id);
				
				if($mt_pts_redeeming_point>0){
					$redeeming_point=$mt_pts_redeeming_point;
				}
				if($mt_pts_redeeming_point_value>0){
					$redeeming_point_value=$mt_pts_redeeming_point_value;
				}
			}	
			
			/*CHECK ABOVE ORDER*/
			$subtotal = isset($cart['total']['subtotal'])?$cart['total']['subtotal']:0;
			
			$points_apply_order_amt = $this->functions->getOptionAdmin('points_apply_order_amt');
			if(!$is_disabled_merchant_settings){
				$mt_points_apply_order_amt = $this->functions->getOption('mt_points_apply_order_amt',$this->merchant_id);
				if($mt_points_apply_order_amt>0){
					$points_apply_order_amt=$mt_points_apply_order_amt;
				}			
			}
			
			if($points_apply_order_amt>0.0001){
				if($points_apply_order_amt>$subtotal){
					

					$this->msg = "Sorry but you can only redeem points on orders over ".$this->functions->prettyPrice($points_apply_order_amt);


					$this->output();
				}			
			}								
			/*END CHECK ABOVE ORDER*/
			
			/*CHECK MINIMUM POINTS CAN BE USED*/
			$points_minimum = $this->functions->getOptionAdmin('points_minimum');
			if(!$is_disabled_merchant_settings){
				$mt_points_minimum = $this->functions->getOption('mt_points_minimum',$this->merchant_id);
				if($mt_points_minimum>0){
					$points_minimum=$mt_points_minimum;
				}			
			}						
			if($points_minimum>0.0001){
				if($points_minimum>$points){
					
					$this->msg = "Sorry but Minimum redeem points can be used is ".$points_minimum;
					$this->output();
				}			
			}								
			/*END CHECK MINIMUM POINTS CAN BE USED*/
			
			
			/*CHECK MAXIMUM POINTS CAN BE USED*/
			$points_max = $this->functions->getOptionAdmin('points_max');
			if(!$is_disabled_merchant_settings){
				$mt_points_max = $this->functions->getOption('mt_points_max',$this->merchant_id);
				if($mt_points_max>0.0001){
					$points_max=$mt_points_max;
				}			
			}
			
			if($points_max>0.0001){
				if($points_max<$points){
				   	
				   	$this->msg = "Sorry but Maximum redeem points can be used is ".$points_max;
					$this->output();
				}		
			}
			/*END CHECK MAXIMUM POINTS CAN BE USED*/
			
						
			$temp_redeem=intval($this->data['points']/$redeeming_point);
			$points_amount=$temp_redeem*$redeeming_point_value;
			
			/*CHECK IF SUB TOTAL WILL BE IN NEGATIVE*/			
			$new_balance = $subtotal-$points_amount;
			if($new_balance<=0){
				$this->msg = ("Sorry you cannot redeem points which the Sub Total will become negative when after applying the points");
				$this->output();
			}			

			
			$params = array(
			  'points_apply'=>$this->data['points'],
			  'points_amount'=>$points_amount
			);
			$this->functions->updateData("mt_singleapp_cart",$params,'device_id',$this->device_uiid);
					
			$this->code = 1;
			$this->msg = "Succesful";
			$this->details = array(
			  'points_apply'=>$this->data['points'],
			  'points_amount'=>$points_amount,
			  'pretty_points_amount'=>$this->functions->prettyPrice($points_amount)
			);
			
		} else $this->msg = ("Cart is empty");		
		$this->output();
	}


	public function removePoints()
    {
        
        $params = array(
          'date_modified'=>$this->functions->dateNow(),
          'points_apply'=>0,
          'points_amount'=>0
        );
        $this->functions->updateData("mt_singleapp_cart",$params,'device_id',$this->device_uiid);    
        
        $this->code = 1;
        $this->msg="OK";
        $this->details='';
        
        $this->output();
    }
    
    public function pointsSummary()
    {       
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$client_info = $this->SingleAppClass->getCustomerByToken($token)){
            $this->msg = "Invalid token, please relogin again";
            $this->output();
        }       
        
        $client_id = $client_info['client_id'];
        
        $total_available_pts = $this->PointsProgram->getTotalEarnPoints($client_id);       
        $total_expiring_pts = $this->PointsProgram->getExpiringPoints($client_id);
        $total_expenses = $this->SingleAppClass->pointsTotalExpenses($client_id);
        $total_earn_by_merchant = $this->SingleAppClass->pointsEarnByMerchant($client_id);
        
        $data = array();
        
        $data[]=array(
          'label'=>("Income Points"),
          'value'=>$total_available_pts>0?$total_available_pts:0,
          'point_type'=>'income_points'
        );
        
        $data[]=array(
          'label'=>("Expenses Points"),
          'value'=>$total_expenses>0?$total_expenses:0,
          'point_type'=>'expenses_points'
        );
        
        $data[]=array(
          'label'=>("Expired Points"),
          'value'=>$total_expiring_pts>0?$total_expiring_pts:0,
          'point_type'=>'expired_points'
        );
        
        $data[]=array(
          'label'=>("Points By Merchant"),
          'value'=>$total_earn_by_merchant,
          'point_type'=>'points_merchant'
        );
        
        $this->code = 1;
        $this->msg="OK";
        $this->details=array(
          'page_action'=>isset($this->data['page_action'])?$this->data['page_action']:'',
          'data'=>$data
        );
        
        $this->output();
    }
    
public function pointsGetEarn()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_earn
        WHERE
        status = 'active'
        AND
        client_id = " . intval($client_id) . "
        ORDER BY id DESC
        LIMIT 0,1000
    ";

    try {
        $results = $this->db->query($stmt);
        $res = $results->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->output();
    }

    if ($res) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition('earn', $val['trans_type'], $val['order_id']);
            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points_earn']
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}


public function pointsExpenses()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_expenses
        WHERE
        status = 'active'
        AND
        client_id = " . intval($client_id) . "
        ORDER BY id DESC
        LIMIT 0,1000
    ";

    try {
        $results = $this->db->query($stmt);
        $res = $results->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->output();
    }

    if ($res) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points']
            );

            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points']
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}




public function pointsExpired()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT * FROM
        mt_points_earn
        WHERE
        status='expired'
        AND
        client_id = " . intval($client_id) . "
        ORDER BY id DESC
        LIMIT 0,1000
    ";

    try {
        $results = $this->db->query($stmt);
        $res = $results->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->output();
    }

    if ($res) {
        $data = array();
        foreach ($res as $val) {
            $label = $this->PointsProgram->PointsDefinition(
                $val['points_type'],
                $val['trans_type'],
                $val['order_id'],
                $val['total_points_earn']
            );

            $data[] = array(
                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                'label' => $label,
                'points' => $val['total_points_earn']
            );
        }

        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}




public function pointsEarnByMerchant()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    if (!$client_info = $this->SingleAppClass->getCustomerByToken($token)) {
        $this->msg = ("Invalid token, please relogin again");
        $this->output();
    }

    $client_id = $client_info['client_id'];

    $stmt = "
        SELECT 
        a.merchant_id,
        b.restaurant_name,
        b.restaurant_slug
        FROM mt_points_earn a		
        LEFT JOIN mt_merchant b
        ON
        a.merchant_id = b.merchant_id		
        WHERE
        a.merchant_id <> 0
        AND
        client_id = " . intval($client_id) . "
        GROUP BY a.merchant_id		
        ORDER BY b.restaurant_name ASC
    ";

    try {
        $results = $this->db->query($stmt);
        $res = $results->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->output();
    }

    if ($res) {
        $data = array();
        foreach ($res as $val) {
            $points = $this->SingleAppClass->getTotalEarnPoints($client_id, $val['merchant_id']);
            $data[] = array(
                'date' => $val['restaurant_name'],
                'label' => ("Merchant Name"),
                'points' => $points > 0 ? $points : 0
            );
        }
        $this->code = 1;
        $this->msg = "OK";
        $this->details = array(
            'data' => $data
        );
    } else {
        $this->msg = "No results";
    }

    $this->output();
}


public function getCountryList()
	{		
		$country_list = $this->functions->CountryList();
		$this->code = 1;
		$this->msg="OK";
		$this->details  = array(
		  'counry_code'=>$this->functions->getOptionAdmin('admin_country_set'),
		  'list'=>$country_list,
		);
		$this->output();
	}
	
	public function clearCart()
	{				
		$this->SingleAppClass->clearCart($this->device_uiid); 
		$this->code = 1;
		$this->msg = "OK";
		$this->output();
	}
	
	public function setDeliveryLocation()
	{
		if($resp=$this->SingleAppClass->getCart($this->device_uiid,$this->merchant_id)){
			$id = $resp['cart_id'];
			$params = array(
			  'delivery_lat'=>trim($this->data['selected_lat']),
			  'delivery_long'=>trim($this->data['selected_lng']),
			);
			
			$this->functions->updateData("mt_singleapp_cart",$params,'cart_id',$id);
			$this->code = 1;
			$this->msg = "OK";
			$this->details=array();
		} else $this->msg = ("Cart is empty");
		$this->output();
	}


public function searchByCategory()
{               
    try {
        $this->db->exec("SET SQL_BIG_SELECTS=1");
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->output();
    }

    $search_str = isset($this->data['category_name']) ? trim($this->data['category_name']) : '';       
    $merchant_id = $this->merchant_id;

    if ($merchant_id > 0) {
        $stmt = "
            SELECT merchant_id, cat_id, category_name, photo, category_name_trans
            FROM mt_category
            WHERE category_name LIKE '%$search_str%'
            AND merchant_id = " . intval($merchant_id) . "
            LIMIT 0,10
        ";

        try {
            $results = $this->db->query($stmt);
            $res = $results->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            $this->msg = "Database error: " . $e->getMessage();
            $this->output();
        }

        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $category_id = $val['cat_id'];

                $stmt2 = "
                    SELECT count(*) as total
                    FROM mt_item
                    WHERE merchant_id = " . intval($merchant_id) . "
                    AND category LIKE '%\"$category_id\"%'
                    AND status IN ('publish','published')
                ";

                try {
                    $results2 = $this->db->query($stmt2);
                    $resp = $results2->fetch(PDO::FETCH_ASSOC);
                    $total_found = $resp ? $resp['total'] : 0;
                } catch (PDOException $e) {
                    $total_found = 0;
                }

                $json = json_decode($val['category_name_trans'], true);                  

                $category_name_trans = $this->functions->qTranslate($val['category_name'], 'category_name', array(
                    'category_name_trans' => $json
                ));

                $category_name_orig = $category_name_trans;

                $category_name = $this->SingleAppClass->highlight_word($category_name_trans, $search_str);

                $val['category_name'] = $category_name;
                $val['category_name_orig'] = $category_name_orig;
                $val['photo_url'] = $this->SingleAppClass->getImage($val['photo']);

                $val['item_found'] = $total_found . " item";
                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'list' => $data
            );
        } else {
            $this->msg = "no results";
        }
    } else {
        $this->msg = "invalid merchant id";
    }

    $this->output();
}


public function searchByItem()
{	
	try {
		$search_str = isset($this->data['item_name']) ? trim($this->data['item_name']) : '';		
		$merchant_id = $this->merchant_id;		
		$category_id = isset($this->data['category_id']) ? $this->data['category_id'] : '';

		if (!empty($search_str) && !empty($merchant_id)) {
			if ($merchant_id > 0) {
				$stmt = "
					SELECT
					item_id, merchant_id, item_name, item_description, photo,
					item_name_trans, item_description_trans,
					price, discount
					FROM mt_item
					WHERE
					merchant_id = " . intval($merchant_id) . "
					AND item_name LIKE '%$search_str%'
					AND category LIKE '%\"$category_id\"%'
					LIMIT 0,10
				";

				$results = $this->db->query($stmt);
				$res = $results ? $results->fetchAll(PDO::FETCH_ASSOC) : false;

				if ($res) {
					$data = array();
					foreach ($res as $val) {
						$json = json_decode($val['item_name_trans'], true);						
						$item_name_trans = $this->functions->qTranslate($val['item_name'], 'item_name', array(
							'item_name_trans' => $json
						));												
						$item_name = $this->SingleAppClass->highlight_word($item_name_trans, $search_str);
						
						$json = json_decode($val['item_description_trans'], true);						
						$item_description = $this->functions->qTranslate($val['item_description'], 'item_description', array(
							'item_description_trans' => $json
						));
						
						$val['prices'] = $this->SingleAppClass->getPrices($val['price'], $val['discount']);												
						$val['photo_url'] = $this->SingleAppClass->getImage($val['photo']);					
						$val['item_name'] = $item_name;
						$val['item_description'] = $item_description;
						$val['category_id'] = $category_id;
						$data[] = $val;
					}
					
					$this->code = 1;
					$this->msg = "OK";
					$this->details = array(
						'list' => $data
					);
				} else {
					$this->msg = "no results";
				}
			} else {
				$this->msg = "invalid merchant id";
			}
		} else {
			$this->msg = "no results";
		}
	} catch (PDOException $e) {
		$this->msg = "Database error: " . $e->getMessage();
	}
	
	$this->output();
}


public function CancelOrder()
	{
		$token = isset($this->data['token'])?$this->data['token']:'';		
		if($res = $this->SingleAppClass->getCustomerByToken($token)){
			$client_id = $res['client_id'];
			$order_id = isset($this->data['order_id'])?$this->data['order_id']:'';
			if($order_id>0){
				if ($res = $this->functions->getOrderInfo($order_id)){
					if($res['client_id']== $client_id){
						$params = array(
	    				  'request_cancel'=>1,
	    				  'date_modified'=>$this->functions->dateNow(),
	    				  'ip_address'=>$_SERVER['REMOTE_ADDR']
	    				);
	    				
	    				if ( $this->functions->updateData("mt_order",$params,'order_id',$order_id)){ 
	    					$this->functions->notifyCancelOrder($res);
	    					$this->code = 1;
			    			$this->msg = ("Your request has been sent to merchant");
			    			$this->details;
			    			
			    			/*logs*/
			    			$params_logs=array(
			    			  'order_id'=>$order_id,
			    			  'status'=>"cancel order request",
			    			  'date_created'=>$this->functions->dateNow(),
			    			  'ip_address'=>$_SERVER['REMOTE_ADDR']
			    			);
			    			$this->functions->insertData("mt_order_history",$params_logs);
			    			
	    				} else $this->msg = ("ERROR: cannot update records.");
					}else $this->msg = ("Sorry but this order does not belong to you");
				} else $this->msg = ("Order id not found");
			} else $this->msg = ("invalid order id");
		} else {
			$this->code = 3;
			$this->msg = ("token not found");
		}
		$this->output();
	}


	public function LoginGoogle()
	{
			
		
		$this->Validator->required(array(
		  'email'=>("email address is required"),
		  'userid'=>("google user id is required")
		),$this->data);
		
		/*check if email address is blocked*/
    	if ( $this->functions->emailBlockedCheck($this->data['email'])){
    		

    		$this->Validator->setmsg("Sorry but your email address is blocked by website admin");    		
    	}	 
    	
    	foreach ($this->data as $key => $val) {
    		if($val=="null" || $val==null ){
    			$this->data[$key]='';
    		} else $this->data[$key]=$val;
    	}
    	    	
    	if($this->Validator->validate()){
    				
    		$params=array(
    		  'first_name'=>($this->data['fullname']),
    		  'last_name'=>($this->data['lastname']),
    		  'email_address'=>($this->data['email']),
    		  'password'=>md5($this->data['userid']),
    		  'date_created'=>$this->functions->dateNow(),
    		  'ip_address'=>$_SERVER['REMOTE_ADDR'],    		  
    		  'device_id'=>isset($this->data['device_id'])?$this->data['device_id']:'',
    		  'device_platform'=>isset($this->data['device_platform'])?strtolower($this->data['device_platform']):'',
    		  'social_strategy'=>'google_mobile',
    		  'single_app_merchant_id'=>$this->merchant_id,
    		  'enabled_push'=>1,
    		  'single_app_device_uiid'=>$this->device_uiid
    		);
    		
    		if( $res = $this->functions->isClientExist($params['email_address']) ){
    			$token = $res['token'];
    			if(empty($token)){
    				$token = $this->SingleAppClass->generateUniqueToken(15,$params['userid']);
    				$params['token'] = $token;
    			}    		
    			
    			unset($params['date_created']);
    			$params['last_login']=$this->functions->dateNow();
    			
    			$this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);			
    			
    			$this->code=1;
	    		$this->msg = ("Registration successful");
	    		
	    		$this->details = array(
    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
    			  'token'=>$token
    			);
    		} else {
    			$token = $this->SingleAppClass->generateUniqueToken(15,$params['email_address']);
    			$params['token']=$token;

    			$last_insert_id = $this->functions->insertData('mt_client', $params);
	            if ($last_insert_id!== false){
    				$customer_id =$last_insert_id;	    		
	    		    $this->code=1;
	    		    $this->msg = ("Registration successful");
    				
	    		    $this->details = array(
	    			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
	    			  'token'=>$token
	    			);
	    			
	    			/*POINTS PROGRAM*/	    			
		    	    
		    		    $this->PointsProgram->signupReward($customer_id);
		    	    
		    	    
    			} else $this->msg = ("Something went wrong during processing your request. Please try again later");
    		}    	
    	
    	} else $this->msg = $this->SingleAppClass->parseValidatorError($this->Validator->getError());
    	
		$this->output();
	}


public function UploadProfile()
{    	
	$profile_photo = '';
	$path_to_upload = $this->functions->uploadPath();

	$token = isset($this->data['token']) ? $this->data['token'] : '';
	if ($res = $this->SingleAppClass->getCustomerByToken($token)) {
		$client_id = $res['client_id'];

		if (isset($_FILES['file'])) {
			
			header('Access-Control-Allow-Origin: *');
		
			$new_image_name = urldecode($_FILES["file"]["name"]) . ".jpg";	
			$new_image_name = str_replace(array('?', ':'), '', $new_image_name);
			
			$upload_res = @move_uploaded_file($_FILES["file"]["tmp_name"], "$path_to_upload/" . $new_image_name);

			if ($upload_res) {
				$params = array(
					'avatar' => $new_image_name,
					'date_modified' => $this->functions->dateNow(),
					'ip_address' => $_SERVER['REMOTE_ADDR']
				);
				
				if ($this->functions->updateData("mt_client", $params, 'client_id', $client_id)) {
					$this->code = 1;
					$this->msg = "Upload successful";
					$this->details = $new_image_name;
					$profile_photo = $this->SingleAppClass->getImage($new_image_name);
				} else {
					$this->msg = "Cannot update records";
				}
			} else {
				$this->msg = "Cannot upload file";
			}
		} else {
			$this->msg = "Image is missing";
		}
	} else {
		$this->code = 3;
		$this->msg = "token not found";
	}

	echo "$this->code|$this->msg|$profile_photo";
	exit;
}


public function getPages()
    {       
        $data=array();
        $enabled_multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');
        $lang = $this->data['lang']?$this->data['lang']:'';         
        if ($res = $this->SingleAppClass->getPages($this->merchant_id)){
            foreach ($res as $val) {                                
                if ($enabled_multiple_translation==2 && !empty($lang)){                         
                    $title = $val['title'];
                    $field_title="lang_title_$lang";                    
                    if(array_key_exists($field_title,$val)){
                        if(!empty($val[$field_title])){
                           $title=$val[$field_title]; 
                        }
                    } 
                    $data[]= array(
                      'page_id'=>$val['page_id'],
                      'merchant_id'=>$val['merchant_id'],
                      'title'=>$title,  
                      'icon'=>$val['icon'],
                    );
                } else {
                    $data[]= array(
                      'page_id'=>$val['page_id'],
                      'merchant_id'=>$val['merchant_id'],
                      'title'=>$val['title'],                     
                      'icon'=>$val['icon'],
                    );
                }           
            }
            $this->code = 1;
            $this->msg = "ok";
            $this->details = array(
              'data'=>$data
            );
        } else $this->msg = "no results";
        $this->output();
    }
    
    public function getPagesByID()
    {
       $data=array();
       $enabled_multiple_translation = $this->functions->getOptionAdmin('enabled_multiple_translation');
       $lang = $this->data['lang']?$this->data['lang']:'';          
        
       $page_id = isset($this->data['page_id'])?$this->data['page_id']:0;
       $merchant_id = $this->merchant_id;
       if($page_id>0){
          if ( $val = $this->SingleAppClass->getPagesByID($page_id)){
              $content = '';
                                             
              if($val['use_html']==1){
                 $content=nl2br(strip_tags($val['content']));
              } else $content=trim($val['content']);
              
              if ($enabled_multiple_translation==2 && !empty($lang)){
                $title = $val['title'];
                $field_title="title_$lang";   
                $field_content="content_$lang"; 
                                        
                if(array_key_exists($field_title,$val)){
                    if(!empty($val[$field_title])){
                       $title=$val[$field_title]; 
                    }
                } 
                
                if(array_key_exists($field_content,$val)){
                    if(!empty($val[$field_content])){
                       $content=$val[$field_content]; 
                       
                       if($val['use_html']==1){
                          $content=nl2br(strip_tags($content));
                       } else $content=trim($content);
                    }
                } 
                
                $data = array(
                  'page_id'=>$val['page_id'],
                  'merchant_id'=>$val['merchant_id'],
                  'title'=>$title,  
                  'content'=>$content,  
                  'icon'=>$val['icon'],
                );
              } else {
                $data = array(
                  'page_id'=>$val['page_id'],
                  'merchant_id'=>$val['merchant_id'],
                  'title'=>$val['title'],                     
                  'content'=>$content,  
                  'icon'=>$val['icon'],
                );
              }           
              
              $this->code = 1;
              $this->msg = "ok";
              $this->details = array(
                  'data'=>$data
              );
            
          } else {
            $this->code = 6; 
            $this->msg = ("Page not found");
            $this->details = array(
              'title'=>("Page not found"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
          }       
       } else {
           $this->code = 6; 
           $this->msg = ("Invalid page id");
           $this->details = array(
              'title'=>("Invalid page id"),
              'sub_title'=>("Sorry but we cannot find what your looking for")
            );  
       }
       $this->output();
    }


    public function clearNotification()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';
    $id = isset($this->data['id']) ? $this->data['id'] : '';
    $client_id = '';

    if ($res = $this->SingleAppClass->getCustomerByToken($token)) {
        $client_id = $res['client_id'];
    }

    $and = '';
    if ($id > 0) {
        $and .= " AND id = :id ";
    }

    try {
        if ($client_id > 0) {
            $stmt = "UPDATE mt_singleapp_mobile_push_logs 
                     SET is_read = '1' 
                     WHERE client_id = :client_id $and";
            $params = [
                ':client_id' => $client_id
            ];
        } else {
            $stmt = "UPDATE mt_singleapp_mobile_push_logs 
                     SET is_read = '1' 
                     WHERE device_id = :device_id $and";
            $params = [
                ':device_id' => $this->device_id
            ];
        }

        if ($id > 0) {
            $params[':id'] = $id;
        }

        $query = $this->db->prepare($stmt);
        $query->execute($params);

        $this->code = 1;
        $this->msg = "OK";
        $this->details = '';
    } catch (Exception $e) {
        $this->msg = $e->getMessage();
    }

    $this->output();
}


 public function addReview()
    {       
        
        
        $token = isset($this->data['token'])?$this->data['token']:'';
        if(!$res = $this->SingleAppClass->getCustomerByToken($token)){
            $this->msg = ("Sorry but you need to login to write a review.");
            $this->output();
        }
        
        $client_id = $res['client_id'];             
        $order_id =  isset($this->data['review_order_id'])?$this->data['review_order_id']:'';       
        
        //if($order_id>0){          
            $website_review_type = $this->functions->getOptionAdmin('website_review_type');
            if ($website_review_type==2){       
                if($order_id>0){            
                    if ( $order_info=$this->functions->getOrder($order_id)){
                        $params = array(
                          'merchant_id'=>$order_info['merchant_id'],
                          'client_id'=>$client_id,
                          'review'=>$this->data['review'],
                          'rating'=>$this->data['rating'],
                          'date_created'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'order_id'=>$order_id,                  
                        );
                        
                       
                           $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
                                        
                        
                        if(!$this->functions->getReviewByOrder($client_id,$order_id)){

                        	$last_insert_id = $this->functions->insertData('mt_review', $params);
	                        if ($last_insert_id!== false){
                                $review_id=$last_insert_id;
                                
                               
                                    
	                            $this->PointsProgram->addReviewsPerOrder($order_id,
	                            $client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
                                             
                                  
                                
                                $this->code = 1;
                                $this->msg = ("Your review has been published.");
                                $this->details = array(
                                  'tab'=>2
                                );
                                
                            } else $this->msg = ("ERROR. cannot insert data.");
                       } else $this->msg = ("You have already have add review to this order");
                        
                    } else $this->msg = ("Order id not found");
                } else $this->msg = ("Invalid order id");
            } else {
                                
                
                
                if ( $this->functions->getOptionAdmin('website_reviews_actual_purchase')=="yes"){                  
                    if (!$this->functions->checkIfUserCanRateMerchant($client_id,$this->merchant_id)){
                        $this->msg= ("Reviews are only accepted from actual purchases!");
                        $this->output();
                    }
                    if (!$this->functions->canReviewBasedOnOrder($client_id,$this->merchant_id)){
                       $this->msg= ("Sorry but you can make one review per order");
                       $this->output();
                    }    
                }
                                
                $params = array(
                  'merchant_id'=>$this->merchant_id,
                  'client_id'=>$client_id,
                  'review'=>$this->data['review'],
                  'rating'=>$this->data['rating'],
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'order_id'=>$order_id,                  
                );          
                
                if ( $ref_orderid=$this->functions->reviewByLastOrderRef($client_id,$this->merchant_id)){
                    $params['order_id']=$ref_orderid;
                }           
                $last_insert_id = $this->functions->insertData('mt_review', $params);
	            if ($last_insert_id!== false){
                
                    $review_id  = $last_insert_id;
                    $this->code = 1;
                    $this->msg = ("Your review has been published.");
                    $this->details = array(
                      'tab'=>1
                    );
                    
                    /*POINTS PROGRAM*/                  
                   
                       $this->PointsProgram->reviewsReward($client_id , $review_id  , $this->merchant_id );
                    
                    
                } else $this->msg = ("ERROR: cannot insert records.");
            }
        //} else $this->msg = $this->t("Invalid order id");
        $this->output();
    }

     public function getAllCategory()
    {
    	if ( $resp = $this->SingleAppClass->getCategory($this->merchant_id, 0 ,0, true)){
			$this->code = 1; $this->msg = 'OK';  
			$this->details = array('data'=>$resp);
		} else $this->msg = ("This restaurant has not published their menu yet");
    	$this->output();
    }   



 public function PointsDetails()
{
    $limit = ''; $stmt = ''; $page_title = '';

    if ($client_id = $this->checkToken()) {
        $point_type = isset($this->data['point_type']) ? $this->data['point_type'] : '';
        $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

        $pagelimit = $this->SingleAppClass->paginateLimit();
        $page = isset($this->data['page']) ? $this->data['page'] * $pagelimit : 0;
        $limit = "LIMIT $page, $pagelimit";

        switch ($point_type) {
            case "income_points":
                $page_title = "Income Points";
                $stmt = "
                    SELECT SQL_CALC_FOUND_ROWS 
                    a.trans_type,
                    a.order_id,
                    a.date_created,
                    a.total_points_earn
                    FROM mt_points_earn a
                    WHERE status = 'active'
                    AND client_id = :client_id
                    ORDER BY id DESC
                    $limit
                ";
                break;

            case "expenses_points":
                $page_title = "Expenses Points";
                $stmt = "
                    SELECT SQL_CALC_FOUND_ROWS 
                    a.points_type,
                    a.trans_type,
                    a.order_id,
                    a.total_points,
                    a.date_created
                    FROM mt_points_expenses a
                    WHERE status = 'active'
                    AND client_id = :client_id
                    ORDER BY id DESC
                    $limit
                ";
                break;

            case "expired_points":
                $page_title = "Expired Points";
                $stmt = "
                    SELECT SQL_CALC_FOUND_ROWS 
                    a.points_type,
                    a.trans_type,
                    a.order_id,
                    a.date_created,
                    a.total_points_earn
                    FROM mt_points_earn a
                    WHERE status = 'expired'
                    AND client_id = :client_id
                    ORDER BY id DESC
                    $limit
                ";
                break;

            case "points_merchant":
                $page_title = "Points By Merchant";
                $stmt = "
                    SELECT SQL_CALC_FOUND_ROWS 
                    a.merchant_id,
                    b.restaurant_name,
                    b.restaurant_slug
                    FROM mt_points_earn a
                    LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
                    WHERE a.merchant_id <> 0
                    AND client_id = :client_id
                    GROUP BY a.merchant_id
                    ORDER BY b.restaurant_name ASC
                    $limit
                ";
                break;
        }

        $data = array();

        try {
            $query = $this->db->prepare($stmt);
            $query->execute([':client_id' => $client_id]);
            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                foreach ($res as $val) {
                    switch ($point_type) {
                        case "income_points":
                            $label = $this->PointsProgram->PointsDefinition('earn', $val['trans_type'], $val['order_id']);
                            $data[] = array(
                                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                                'label' => $label,
                                'points' => $val['total_points_earn']
                            );
                            break;

                        case "expenses_points":
                            $label = $this->PointsProgram->PointsDefinition(
                                $val['points_type'],
                                $val['trans_type'],
                                $val['order_id'],
                                $val['total_points']
                            );
                            $data[] = array(
                                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                                'label' => $label,
                                'points' => $val['total_points']
                            );
                            break;

                        case "expired_points":
                            $label = $this->PointsProgram->PointsDefinition(
                                $val['points_type'],
                                $val['trans_type'],
                                $val['order_id'],
                                $val['total_points_earn']
                            );
                            $data[] = array(
                                'date' => $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']),
                                'label' => $label,
                                'points' => $val['total_points_earn']
                            );
                            break;

                        case "points_merchant":
                            $points = $this->SingleAppClass->getTotalEarnPoints($client_id, $val['merchant_id']);
                            $data[] = array(
                                'date' => $this->functions->clearString($val['restaurant_name']),
                                'label' => "Merchant Name",
                                'points' => $points > 0 ? $points : 0
                            );
                            break;

                        default:
                            break;
                    }
                }

                $this->code = 1;
                $this->msg = "ok";
                $this->details = array(
                    'page_action' => $page_action,
                    'page_title' => $page_title,
                    'data' => $data
                );
            } else {
                if ($page_action == "infinite_scroll") {
                    $this->code = 2;
                    $this->msg = "end of records";
                } else {
                    $this->code = 6;
                    $this->details = array(
                        'title' => $page_title . " is empty",
                        'sub_title' => "Make your first order to earn points"
                    );
                }
            }
        } catch (Exception $e) {
            $this->msg = $e->getMessage();
        }
    }

    $this->output();
}


public function FavoritesList()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    if ($client_id = $this->checkToken()) {
        
        $pagelimit = $this->SingleAppClass->paginateLimit();		
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0; 
        }

        $paginate_total = 0; 
        $limit = "LIMIT $page,$pagelimit"; 

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.id,
            a.merchant_id,
            a.client_id,
            a.date_created,
            b.restaurant_name as merchant_name,
            b.logo
            FROM
            mt_favorites a
            LEFT JOIN mt_merchant b
            ON
            a.merchant_id = b.merchant_id
            WHERE a.client_id = :client_id
            ORDER BY a.id DESC
            $limit
        ";

        $data = array();
        
        try {
            $query = $this->db->prepare($stmt);
            $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $query->execute();
            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                $stmtc = "SELECT FOUND_ROWS() as total_records";
                $queryc = $this->db->prepare($stmtc);
                $queryc->execute();
                $resp = $queryc->fetch(PDO::FETCH_ASSOC);
                
                $total_records = isset($resp['total_records']) ? (int)$resp['total_records'] : 0;
                $paginate_total = ceil($total_records / $pagelimit);

                foreach ($res as $val) {
                    $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                    $val['date_added'] = $date_added . " Added";

                    $val['logo'] = $this->SingleAppClass->getImage($val['logo']);
                    $ratings = $this->functions->getRatings($val['merchant_id']);
                    $ratings['review_count'] = $ratings['votes'] . " reviews";
                    $val['rating'] = $ratings;

                    $val['background_url'] = $this->SingleAppClass->getMerchantBackground($val['merchant_id'], 'resto_banner.jpg');

                    $data[] = $val;
                }

                $this->code = 1;
                $this->msg = "OK";
                $this->details = array(
                    'page_action' => $page_action,
                    'paginate_total' => $paginate_total,
                    'data' => $data
                );

            } else {
                if ($page_action == "infinite_scroll") {
                    $this->code = 2;
                    $this->msg = ("end of records");
                } else {
                    $this->code = 6;
                    $this->details = array(
                        'title' => ("Your Favorites is empty"),
                        'sub_title' => ("Add your own favorite restaurant")
                    );
                }
            }
        } catch (PDOException $e) {
            $this->code = 500;
            $this->msg = "Database error: " . $e->getMessage();
        }
    }
    $this->output();
}


public function GetOrderInfo()
	{
		$data = array();
		$order_id = isset($this->data['order_id'])?$this->data['order_id']:0;
		if($order_id>0){
		   if ($res = $this->SingleAppClass->orderDetails($order_id)){
		   	  
		   	  $res['review_as']='';
		   	  if($clien_info =  $this->functions->getClientInfo($res['client_id'])){
		   	  	

				 $res['review_as'] = "Review as ".$clien_info['first_name'];
		   	  }		   
		   	  $this->code = 1;
		   	  $this->msg = "ok";
		   	  
		   	  $res['logo'] = $res['logo']=$this->SingleAppClass->getImage($res['logo']);
		   	  
		   	 

		   	  $res['transaction'] = $res['trans_type']." ".$res['order_id'];
		   	  
		   	  $res['payment_type'] = ($this->functions->prettyPaymentTypeTrans($res['trans_type'],$res['payment_type']));
		   	  $res['merchant_name'] = $this->functions->clearString($res['merchant_name']);
		   	  
		   	  $this->details = array(
		   	    'data'=>$res
		   	  );
		   } else $this->msg = ("order not found");		
		} else $this->msg = ("invalid order id");		
		$this->output();
	}


	public function GetOrderInfoCancel()
	{
		$this->GetOrderInfo();
	}



	public function addReviewNew()
	{		
		
		$order_id =  isset($this->data['order_id'])?$this->data['order_id']:''; 
		$rating =  isset($this->data['rating'])?$this->data['rating']:''; 
		
		if(!is_numeric($rating)){
			$this->msg =("Please select rating");
			$this->output();
		}
		if(!is_numeric($order_id)){
			$this->msg = ("invalid order id");
			$this->output();
		}
		
		if ($client_id = $this->checkToken()){
			$website_review_type = $this->functions->getOptionAdmin('website_review_type');				
		    if($order_info=$this->functions->getOrderInfo($order_id)){
		    	if ($website_review_type==2){														
					$order_id = $order_info['order_id'];
					$params = array(
					  'merchant_id'=>$order_info['merchant_id'],
					  'client_id'=>$client_id,
					  'review'=>$this->data['review'],
					  'rating'=>$this->data['rating'],
					  'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
					  'date_created'=>$this->functions->dateNow(),
					  'ip_address'=>$_SERVER['REMOTE_ADDR'],
					  'order_id'=>$order_id,  
					);
					
				   $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
				    
				    				    
				    if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){

				    	$last_insert_id = $this->functions->insertData('mt_review', $params);
	                    if ($last_insert_id!== false){
				    		$review_id=$last_insert_id;
				    		
				    		
								
						$this->PointsProgram->addReviewsPerOrder($order_id,
									$client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
										
							
							
							$this->code = 1;
					        $this->msg = ("Your review has been published.");
					        $this->details = array();
									
				    	} else $this->msg = ("ERROR. cannot insert data.");
				    } else {				    	
				    	$id = $res_review['id'];
				    	unset($params['date_created']);
				    	$params['date_modified'] = $this->functions->dateNow();
				    	$this->functions->updateData("mt_review",$params,'id', $id);
				    	$this->code = 1;
					    $this->msg = ("Your review has been published.");
					    $this->details = array();
				    }
						    			
				} else {
					// review merchant
					$order_id = $order_info['order_id'];
					$params = array(
					  'merchant_id'=>$order_info['merchant_id'],
					  'client_id'=>$client_id,
					  'review'=>$this->data['review'],
					  'rating'=>$this->data['rating'],
					  'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0,
					  'date_created'=>$this->functions->dateNow(),
					  'ip_address'=>$_SERVER['REMOTE_ADDR'],
					  'order_id'=>$order_id,  
					);
					$actual_purchase = $this->functions->getOptionAdmin('website_reviews_actual_purchase');				
					if($actual_purchase=="yes"){
						
						if (!$this->functions->checkIfUserCanRateMerchant($client_id,$order_info['merchant_id'])){
							$this->msg=("Reviews are only accepted from actual purchases!");
						}
						if (!$this->functions->canReviewBasedOnOrder($client_id,$order_info['merchant_id'])){
			    		   $this->msg=("Sorry but you can make one review per order");
			    	       return ;
			    	    }	  		   
					}
					
					if(!$res_review = $this->functions->getReviewByOrder($client_id,$order_id)){
						$last_insert_id = $this->functions->insertData('mt_review', $params);
	                    if ($last_insert_id!== false){
				    		$review_id=$last_insert_id;
				    		
				    		
								
						$this->PointsProgram->addReviewsPerOrder($order_id,
						$client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
										
							
							
							$this->code = 1;
	
					        $this->msg = ("Your review has been published.");
					        $this->details = array();
									
				    	} else $this->msg = ("ERROR. cannot insert data.");
				    } else {
				    	$id = $res_review['id'];
				    	unset($params['date_created']);
				    	$params['date_modified'] = $this->functions->dateNow();
				    	$this->functions->updateData("mt_review",$params,'id', $id);
				    	$this->code = 1;
					    $this->msg = ("Your review has been published.");
					    $this->details = array();
				    }
								
				}
		    } else $this->msg = ("order id not found");		
		}
		$this->output();
	}


	public function ReviewList()
{
    $website_title = $this->functions->getOptionAdmin('website_title');
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $pagelimit = $this->SingleAppClass->paginateLimit();
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $pagelimit;
    } else {
        $page = 0;
    }

    $paginate_total = 0;
    $limit = "LIMIT $page,$pagelimit";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.id,
        a.merchant_id,
        a.client_id,
        a.review,
        a.rating,
        a.as_anonymous,
        a.date_created,
        CONCAT(b.first_name,' ',b.last_name) as customer_name,
        b.avatar

        FROM mt_review a
        LEFT JOIN mt_client b
        ON a.client_id = b.client_id

        WHERE a.status = 'publish'
        AND a.merchant_id = :merchant_id

        ORDER BY a.id DESC
        $limit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $data = array();
            foreach ($res as $val) {
                if ($val['as_anonymous'] == 1) {
                    $val['customer_name'] = "By " . $website_title . " Customer";
                    $val['avatar'] = $this->SingleAppClass->getImage('x.png', 'avatar.png');
                } else {
                    $val['avatar'] = $this->SingleAppClass->getImage($val['avatar'], 'avatar.png');
                    $val['customer_name'] = "By " . $val['customer_name'];
                }

                $pretyy_date = $val['date_created'];
                $pretyy_date = $this->functions->translateDate($pretyy_date);
                $val['date_posted'] = $pretyy_date;

                $val['reply'] = $this->SingleAppClass->getReviewReplied($val['id'], $val['merchant_id']);

                $data[] = $val;
            }

            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->msg = ("No available review");
                $this->details = array(
                    'title' => ("No available review"),
                    'sub_title' => ("be the first one to leave review order now!")
                );
            }
        }
    } catch (PDOException $e) {
        $this->code = 500;
        $this->msg = "Database error: " . $e->getMessage();
    }

    $this->output();
}



 public function GetNotification()
{       
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';
    
    $pagelimit = $this->SingleAppClass->paginateLimit();      
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $pagelimit;
    } else {
        $page = 0;
    }

    $paginate_total = 0; 
    $limit = "LIMIT $page, $pagelimit";   
    
    $where = "WHERE is_read = :is_read";
    $params = [':is_read' => 0];
    $and = '';
    
    if (!$client_id = $this->checkToken()) {
        $client_id = 0;
    }

    if ($client_id > 0) {
        $and = " AND client_id = :client_id";
        $params[':client_id'] = $client_id;
    } else {
        $and = " AND device_id = :device_id";
        $params[':device_id'] = $this->device_id;
    }

    $stmt = "
        SELECT 
            id,
            push_title,
            push_message,
            date_created
        FROM mt_singleapp_mobile_push_logs
        $where
        $and
        ORDER BY id DESC
        $limit
    ";

    $query = $this->db->prepare($stmt);
    foreach ($params as $key => $val) {
        $query->bindValue($key, $val);
    }

    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $data = array();
            foreach ($res as $val) {
                $date_created = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);                
                $data[] = array(
                    'id' => $val['id'],
                    'push_title' => $this->functions->clearString($val['push_title']),
                    'push_message' => $this->functions->clearString($val['push_message']),
                    'date_created' => $date_created
                );
            }
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->details = array(
                    'title' => ("Notifications is empty"),
                    'sub_title' => ("You don't have any notifications")
                );  
            }
        }
    }

    $this->output();
}
   
    
    public function GetGallery()
    {
        $page_action =  isset($this->data['page_action'])?$this->data['page_action']:'';
        $list = array();
        $gallery=$this->functions->getOption("merchant_gallery",$this->merchant_id);
        $gallery=!empty($gallery)?json_decode($gallery):false;
        //$gallery=false;
        if(is_array($gallery) && count($gallery)>=1){
            foreach ($gallery as $val) {
                $list[] = $this->SingleAppClass->getImage($val);
            }        
            $this->code = 1;
            $this->msg ="OK";
            $this->details=array(
              'page_action'=>$page_action,
              'data'=>$list
            );
        } else {            
            if($page_action=="infinite_scroll"){
                $this->code = 2;
                $this->msg = ("Photos not available"); 
            } else {
                $this->code = 6;
                $this->details = array(
                  'title'=>("No photos found"),
                  'sub_title'=>("There are no photo available")
                );  
            }
        }       
        $this->output();
    } 


 public function searchOrder()
{
    if ($client_id = $this->checkToken()) {

        $cancel_order_enabled = $this->functions->getOptionAdmin('cancel_order_enabled');     
        $website_review_type = $this->functions->getOptionAdmin('website_review_type');
        $review_baseon_status = $this->functions->getOptionAdmin('review_baseon_status'); 
        $merchant_can_edit_reviews = $this->functions->getOptionAdmin('merchant_can_edit_reviews');
        if ($website_review_type == 1) {
            $review_baseon_status = $this->functions->getOptionAdmin('review_merchant_can_add_review_status');
        }

        $date_now = date('Y-m-d g:i:s a');     
        $data = array();

        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';
        if (!empty($search_str)) {

            $stmt = "
                SELECT 
                    a.order_id,
                    a.client_id,
                    a.trans_type,
                    a.trans_type as trans_type_raw,
                    a.payment_type,
                    a.payment_type as payment_type_raw,
                    a.total_w_tax,
                    a.status,
                    a.status as status_raw,     
                    a.date_created,
                    a.date_created as date_created_raw,
                    a.request_cancel,
                    a.order_locked,
                    a.request_cancel_status,
                    b.restaurant_name,
                    b.logo
                FROM mt_order a            
                LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
                WHERE a.client_id = :client_id
                AND a.merchant_id = :merchant_id
                AND a.status NOT IN ('initial_order')
                AND (
                    a.order_id LIKE :search1
                    OR b.restaurant_name LIKE :search2
                    OR a.trans_type LIKE :search3
                    OR a.payment_type LIKE :search4
                )
                LIMIT 0, 20
            ";

            $query = $this->db->prepare($stmt);
            $like_str = "%$search_str%";
            $query->bindValue(':client_id', $client_id, PDO::PARAM_INT);
            $query->bindValue(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
            $query->bindValue(':search1', "%$search_str%");
            $query->bindValue(':search2', $like_str);
            $query->bindValue(':search3', $like_str);
            $query->bindValue(':search4', $like_str);

            if ($query->execute()) {
                $res = $query->fetchAll(PDO::FETCH_ASSOC);
                if ($res) {
                    foreach ($res as $val) {

                        $val['restaurant_name'] = $this->functions->clearString($val['restaurant_name']);
                        $val['payment_type'] = $this->functions->prettyPaymentTypeTrans($val['trans_type'], $val['payment_type']);
                        $val['restaurant_name'] = $this->SingleAppClass->highlight_word($val['restaurant_name'], $search_str);

                        $val['transaction'] = $val['trans_type'] . " " . $val['order_id'];

                        $val['payment_type'] = $this->SingleAppClass->highlight_word($val['payment_type'], $search_str);
                        $val['restaurant_name'] = $this->SingleAppClass->highlight_word($val['restaurant_name'], $search_str);
                        $val['transaction'] = $this->SingleAppClass->highlight_word($val['transaction'], $search_str);

                        $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                        $add_review = false;
                        if ($this->SingleAppClass->canReviewOrder($val['status_raw'], $website_review_type, $review_baseon_status)) {
                            $add_review = true;
                        }

                        if ($add_review) {
                            if ($val['client_id'] == $client_id) {
                                $date_diff = $this->functions->dateDifference(
                                    date('Y-m-d g:i:s a', strtotime($val['date_created_raw'])),
                                    $date_now
                                );
                                if (is_array($date_diff) && count($date_diff) >= 1) {
                                    if ($date_diff['days'] >= 5) {
                                        $add_review = false;
                                    }
                                }
                            } else {
                                $add_review = false;
                            }
                        }

                        if ($website_review_type == 1) {
                            if (!empty($val['rating']) && $val['rating'] > 0) {
                                if ($merchant_can_edit_reviews == "yes") {
                                    $add_review = false;
                                }
                            }
                        }

                        $val['add_review'] = $add_review;

                        $show_cancel = false;
                        $cancel_status = '';
                        if ($this->functions->canCancelOrderNew(
                            $val['request_cancel'],
                            $val['date_created'],
                            $val['status_raw'],
                            $val['order_locked'],
                            $val['request_cancel_status'],
                            $cancel_order_enabled
                        )) {
                            if ($val['request_cancel'] == 1) {
                                $cancel_status = ("Pending for review");
                            } else {
                                $show_cancel = true;
                            }
                        }

                        if ($val['request_cancel_status'] != 'pending') {
                            $cancel_status = "Request cancel :" . $val['request_cancel_status'];
                        }

                        $val['add_cancel'] = $show_cancel;
                        $val['cancel_status'] = $cancel_status;

                        $val['add_track'] = true;

                        $data[] = $val;
                    }

                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                        'data' => $data
                    );
                } else {
                    $this->msg = ("No results");
                }
            }
        } else {
            $this->msg = ("invalid search string");
        }
    }
    $this->output();
}



public function searchBooking()
{
    if ($client_id = $this->checkToken()) {
        $search_str = isset($this->data['search_str']) ? $this->data['search_str'] : '';
        if (!empty($search_str)) {

            $stmt = "
                SELECT                 
                a.booking_id,
                a.client_id,
                a.merchant_id,
                a.date_booking,
                a.booking_time,
                a.number_guest,
                b.restaurant_name,
                b.logo
                FROM mt_bookingtable a
                LEFT JOIN mt_merchant b
                ON a.merchant_id = b.merchant_id
                WHERE a.client_id = :client_id
                AND a.merchant_id = :merchant_id
                AND (
                    a.booking_id LIKE :search_id
                    OR b.restaurant_name LIKE :search_restaurant
                )
                LIMIT 0,20
            ";

            $search_param = "%$search_str%";
            $stmt_exec = $this->db->prepare($stmt);
            $stmt_exec->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $stmt_exec->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
            $stmt_exec->bindParam(':search_id', $search_param);
            $stmt_exec->bindParam(':search_restaurant', $search_param);

            if ($stmt_exec->execute()) {
                $res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC);
                if ($res) {
                    foreach ($res as $val) {
                        $val['date_booking_format'] = $this->functions->prettyDate($val['date_booking']) . " " . $this->functions->prettyTime($val['booking_time']);
                        $val['restaurant_name'] = $this->functions->clearString($val['restaurant_name']);
                        $val['logo'] = $this->SingleAppClass->getImage($val['logo']);

                        $val['booking_ref'] = "Booking ID# " . $val['booking_id'];
                        $val['number_guest'] = "No. of guest " . $val['number_guest'];

                        $val['restaurant_name'] = $this->SingleAppClass->highlight_word($val['restaurant_name'], $search_str);
                        $val['booking_ref'] = $this->SingleAppClass->highlight_word($val['booking_ref'], $search_str);

                        $data[] = $val;
                    }
                    $this->code = 1;
                    $this->msg = "OK";
                    $this->details = array(
                        'data' => $data
                    );
                } else {
                    $this->msg = ("No results");
                }
            } else {
                $this->msg = ("Database error");
            }
        } else {
            $this->msg = ("invalid search string");
        }
    }
    $this->output();
}



   public function GetBookingDetails()
    {
        $page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
        
        if ($client_id = $this->checkToken()){          
            $booking_id = isset($this->data['booking_id'])?$this->data['booking_id']:'';
            if($res = $this->SingleAppClass->GetBookingDetails($booking_id,$client_id)){
                $this->code = 1;
                $this->msg = "ok";
                $data = array();
                
                $data[]=array(
                  'label'=>("Booking ID"),
                  'value'=>$res['booking_id'],
                );
                $data[]=array(
                  'label'=>("Number of guest"),
                  'value'=>$res['number_guest'],
                );
                $data[]=array(
                  'label'=>("Date Of Booking"),
                  'value'=>$this->functions->prettyDate($res['date_booking']),
                );
                $data[]=array(
                  'label'=>("Time"),
                  'value'=>$this->functions->prettyTime($res['booking_time']),
                );
                $data[]=array(
                  'label'=>("Name"),
                  'value'=>$res['booking_name']
                );
                $data[]=array(
                  'label'=>("Email"),
                  'value'=>$res['email']
                );
                $data[]=array(
                  'label'=>("Mobile"),
                  'value'=>$res['mobile']
                );
                $data[]=array(
                  'label'=>("Your Inructions"),
                  'value'=>$res['booking_notes']
                );
                
                $this->details = array(
                  'page_action'=>$page_action,
                  'data'=>$data
                );
            } else {
                $this->code = 6;
                $this->msg = ("Booking not found");
                $this->details = array(
                  'title'=>("Booking not found"),
                  'sub_title'=>("booking details not available")
                );                                                      
            }
        }
        $this->output();
    } 


    public function logout()
	{
		if ($client_id = $this->checkToken()){
			
			$this->functions->updateData("mt_client",array(
			  'enabled_push'=>0
			),'client_id', $client_id);
		}
		$this->code = 1;
		$this->msg = "OK";
		$this->output();
	} 



	public function saveLocationAddress()
	{
		$lat = isset($this->data['lat'])?$this->data['lat']:'';
		$lng = isset($this->data['lng'])?$this->data['lng']:'';
		
		if(!empty($lat) && !empty($lng)){
			
			$params = array(
			  'device_uiid'=>$this->device_uiid,
			  'search_address'=>isset($this->data['search_address'])?trim($this->data['search_address']):'',
			  'street'=>isset($this->data['street'])?trim($this->data['street']):'',
			  'city'=>isset($this->data['city'])?trim($this->data['city']):'',
			  'state'=>isset($this->data['state'])?trim($this->data['state']):'',
			  'country'=>isset($this->data['country'])?trim($this->data['country']):'',
			  'latitude'=>$lat,
			  'longitude'=>$lng,
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
			);
			if($res = $this->SingleAppClass->getRecentLocationByID($this->device_uiid,$lat, $lng)){				
				$id = $res['id'];
				$this->functions->updateData("mt_singleapp_recent_location",$params,'id',$id);
			} else {				
				$this->functions->insertData("mt_singleapp_recent_location",$params);
			}		
			
			$this->code =1; $this->msg = "OK";
			
			
		} else $this->msg = ("Invalid location");
		
		$this->output();
	}
	
	public function GetRecentLocation()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';

    $pagelimit = $this->SingleAppClass->paginateLimit();		
    if (isset($this->data['page'])) {
        $page = $this->data['page'] * $pagelimit;
    } else {
        $page = 0;
    }

    $paginate_total = 0; 
    $limit = "LIMIT $page, $pagelimit"; 

    $search_resp = $this->SingleAppClass->searchMode();
    $search_mode = $search_resp['search_mode'];	

    $and = "AND search_mode='address'";
    if ($search_mode == "location") {
        $and = "AND search_mode='location'";
    }

    $data = array();
    $stmt = "
        SELECT *
        FROM mt_singleapp_recent_location
        WHERE device_uiid = :device_uiid
        $and
        ORDER BY id DESC
        $limit
    ";

    $stmt_exec = $this->db->prepare($stmt);
    $stmt_exec->bindParam(':device_uiid', $this->device_uiid, PDO::PARAM_STR);

    if ($stmt_exec->execute()) {
        $res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            foreach ($res as $val) {
                unset($val['ip_address']);
                $val['date_added'] = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                $data[] = $val;
            }
            $this->code = 1;
            $this->msg = "OK";
            $this->details = array(
                'page_action' => $page_action,
                'data' => $data
            );
        } else {
            if ($page_action == "infinite_scroll") {
                $this->code = 2;
                $this->msg = ("end of records");
            } else {
                $this->code = 6;
                $this->details = array(
                    'title' => ("No recent location"),
                    'sub_title' => ("list is empty")
                );
            }
        }
    } else {
        $this->msg = ("Database error");
    }

    $this->output();
}


public function ClearLocation()
    {
        if(!empty($this->device_uiid)){
            $this->code = 1;
            $this->msg = "OK";
            $this->SingleAppClass->clearRecentLocation($this->device_uiid);
        } else $this->msg = ("Invalid device uiid");
        $this->output();
    }
    
    public function AddFavorite()
    {
        $item_id = isset($this->data['item_id'])?$this->data['item_id']:'';
        $category_id = isset($this->data['category_id'])?$this->data['category_id']:'';
        if ($client_id = $this->checkToken()){
            $this->SingleAppClass->addItemFavorite($client_id, $item_id, $category_id);
            $this->code = 1;
            $this->msg =("Item added to your favorites");
        }
        $this->output();
    }
    
    public function RemoveFavorite()
    {
        $item_id = isset($this->data['item_id'])?$this->data['item_id']:'';
        if ($client_id = $this->checkToken()){
            $this->SingleAppClass->removeItemFavorite($client_id, $item_id);
            $this->code = 1;
            $this->msg ="OK";
        }
        $this->output();
    }
    
    public function RemoveFavoriteByID()
    {
        $id = isset($this->data['id'])?$this->data['id']:'';
        if ($client_id = $this->checkToken()){
            $this->SingleAppClass->removeItemFavoriteByID($client_id, $id);
            $this->code = 1;
            $this->msg ="OK";
        }
        $this->output();
    }


     public function ItemFavoritesList()
{
    $page_action = isset($this->data['page_action']) ? $this->data['page_action'] : '';     

    if ($client_id = $this->checkToken()) {
        $pagelimit = $this->SingleAppClass->paginateLimit();       
        if (isset($this->data['page'])) {
            $page = $this->data['page'] * $pagelimit;
        } else {
            $page = 0;
        }
        $limit = "LIMIT $page,$pagelimit"; 
        
        $stmt = "
            SELECT
                a.id,
                a.item_id,
                a.date_created,
                b.item_name,
                b.photo
            FROM mt_favorite_item a
            LEFT JOIN mt_item b ON a.item_id = b.item_id
            WHERE a.client_id = :client_id
            ORDER BY a.id DESC
            $limit
        ";

        $stmt_exec = $this->db->prepare($stmt);
        $stmt_exec->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        if ($stmt_exec->execute()) {
            $res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                $data = array();
                foreach ($res as $val) {
                    $date_added = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
                    $val['date_added'] = "Added " . $date_added;
                    $val['photo'] = $this->SingleAppClass->getImage($val['photo']);
                    $val['item_name'] = $this->functions->clearString($val['item_name']);
                    $data[] = $val;
                }
                $this->code = 1;
                $this->msg = "OK";                              
                $this->details = array(               
                    'data' => $data,
                    'page_action' => $page_action
                );
            } else {
                if ($page_action == "infinite_scroll") {
                    $this->code = 2;
                    $this->msg = ("end of records");
                } else {
                    $this->code = 6;
                    $this->details = array(
                        'title' => ("Your favorites is empty"),
                        'sub_title' => ("Add your first food item")
                    );      
                }
            }
        } else {
            $this->msg = ("Database error");
        }
    }

    $this->output();
}


    public function resendVerificationCode()
    {
       
        $verification_type = isset($this->data['verification_type'])?$this->data['verification_type']:'';
        $signup_token = isset($this->data['signup_token'])?$this->data['signup_token']:'';
        $date_now=date('Y-m-d g:i:s a');     
        
        $params=array(
         'verify_code_requested'=>$this->functions->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
                    
        if($resp = $this->SingleAppClass->getCustomerByToken($signup_token,false)){    
            
            $verify_code_requested = $resp['verify_code_requested'];            
            
            $date_diff=$this->functions->dateDifference(
                            date('Y-m-d g:i:s a',strtotime($verify_code_requested))
                            ,$date_now);
                            
                            
            $waiting_code = 5;
            
            $continue = true;   $waiting_time = '';                                 
            if(is_array($date_diff) && count($date_diff)>=1){               
                if($waiting_code>$date_diff['minutes']){    
                    $waiting_time = $date_diff['minutes'];
                    $continue=false;
                }       
                if($continue==false){
                    if($date_diff['days']>0){
                        $continue=true;
                    }                   
                    if($date_diff['hours']>0){
                        $continue=true;
                    }                   
                }       
            }       
            
            if(!$continue){
                $waiting_time = (integer)$waiting_code - (integer)$waiting_time;
               

                 $this->msg = "Your requesting too soon please wait after ".$waiting_time." minutes";

                $this->output();
            }                                           
            
            switch ($verification_type) {
                case "email":
                    $code = trim($resp['email_verification_code']);
                    $this->functions->sendEmailVerificationCode($resp['email_address'],$code,$resp);
                    $this->code = 1;
                    $this->msg = ("We have sent verification code to your email address");                    
                    $this->functions->updateData("mt_client",$params,'client_id',$resp['client_id']);
                    break;
                    
                case "sms": 
                    $code = trim($resp['mobile_verification_code']);
                    $this->functions->sendCustomerSMSVerification($resp['contact_phone'],$code);
                    $this->code = 1;
                    $this->msg = ("We have sent verification code to your mobile number");                    
                    $this->functions->updateData("mt_client",$params,'client_id',$resp['client_id']);
                    break; 
            
                default:
                    $this->msg = ("Invalid verification type");
                    break;
            }
        } else $this->msg = ("Token not found");
        $this->output();
    }


    public function StateList()
	{				      
		$page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
		$page_limit = $this->SingleAppClass->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
		
		if($res = $this->LocationWrapper->GetStateList($page,$page_limit, $search_string) ){			
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>$page_action,
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else {
			if($page_action=="infinite_scroll"){
				$this->code = 2;
				$this->msg = ("end of records");
			} else {
				$this->code = 6;
				$this->details = array(
				  'title'=>("Search results 0 found"),
				  'sub_title'=>("we cannot find what your looking for")
				);	
			}
		};
		$this->output();
	}
	
	public function CityList()
	{				      
		$page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
		
		$page_limit = $this->SingleAppClass->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
        $state_id = isset($this->data['state_id'])?$this->data['state_id']:'';
        
        $search_resp = $this->SingleAppClass->searchMode();

		$location_mode = $search_resp['location_mode'];
		if($location_mode==2){
			if((integer)$state_id<=0){
				$this->code = 6;
				$this->details = array(
				  'title'=>("No results"),
				  'sub_title'=>("we cannot find what your looking for")
				);	
				$this->output();
			}		
		}	
		
		if($res = $this->LocationWrapper->GetLocationCity($page,$page_limit, $search_string, $state_id) ){
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>$page_action,
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else {
			if($page_action=="infinite_scroll"){
				$this->code = 2;
				$this->msg = ("end of records");
			} else {
				$this->code = 6;
				$this->details = array(
				  'title'=>("No results"),
				  'sub_title'=>("we cannot find what your looking for")
				);	
			}
		}	
		$this->output();
	}
	
	public function AreaList()
	{
		$page_action = isset($this->data['page_action'])?$this->data['page_action']:'';
		
		$page_limit = $this->SingleAppClass->paginateLimit();
		if (isset($this->data['page'])){
        	$page = $this->data['page'] * $page_limit;
        } else  $page = 0;  
        
        $search_string = isset($this->data['search_str'])?$this->data['search_str']:'';
        $city_id = isset($this->data['city_id'])?$this->data['city_id']:'';
                
        if($res = $this->LocationWrapper->GetAreaList($city_id,$page,$page_limit, $search_string) ){
			$this->code =1;
			$this->msg = "OK";
			$this->details = array(
			  'page_action'=>$page_action,
			  'paginate_total'=>$res['paginate_total'],
			  'data'=>$res['list'],
			);
		} else {
			if($page_action=="infinite_scroll"){
				$this->code = 2;
				$this->msg = ("end of records");
			} else {
				$this->code = 6;
				$this->details = array(
				  'title'=>("No results"),
				  'sub_title'=>("we cannot find what your looking for")
				);	
			}
		}	
		$this->output();
	}



	public function SaveAddresBookLocation()
	{
		if ($client_id = $this->checkToken()){
			
			$params = array(
			  'client_id'=>$client_id,
			  'street'=>isset($this->data['street'])?$this->data['street']:'',
			  'latitude'=>isset($this->data['lat'])?$this->data['lat']:'',
			  'longitude'=>isset($this->data['lng'])?$this->data['lng']:'',
			  'state_id'=>isset($this->data['state_id'])?$this->data['state_id']:'',
			  'city_id'=>isset($this->data['city_id'])?$this->data['city_id']:'',
			  'area_id'=>isset($this->data['area_id'])?$this->data['area_id']:'',
			  'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:'',
			  'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
			  'country_id'=>isset($this->data['country_id'])?$this->data['country_id']:'',
			  'date_created'=>$this->functions->dateNow(),
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
			);					
			
			if(empty($params['latitude'])){
				$this->msg = ("please select your location on the map");
				$this->output();
			}		
			if(empty($params['longitude'])){
				$this->msg = ("please select your location on the map");
				$this->output();
			}		
			
			if(!is_numeric($params['as_default'])){			    
			    $params['as_default']=0;
		    }			
		    
		   
		    $id = isset($this->data['book_location_id'])?$this->data['book_location_id']:'';
		    
		    if($id>0){
				 unset($params['date_created']);
				 $params['date_modified']=$this->functions->dateNow();
				 
				 if($this->LocationWrapper->isAddressBookExist($client_id,$params['state_id'],
				 $params['city_id'],$params['area_id'],$id
				 )){
				   $this->msg = ("Address already exist");
				   $this->output();
				 }
				 
				 if ($params['as_default']==1){
					$this->LocationWrapper->UpdateAllAddressBookDefaultLocation($client_id);
				 }							 
				 $this->functions->updateData("mt_address_book_location", $params ,'id',$id);
				 $this->code = 1; $this->msg = ("Successfully updated");
			} else {				
				
				if($this->LocationWrapper->isAddressBookExist($client_id,$params['state_id'],
				$params['city_id'],$params['area_id']
				)){
				   $this->msg = ("Address already exist");
				   $this->output();
				}
								
				if ($params['as_default']==1){
					$this->LocationWrapper->UpdateAllAddressBookDefaultLocation($client_id);
				}
								
				if ( $this->functions->insertData("mt_address_book_location",$params)){
					$this->code = 1; $this->msg = ("Successfully added");
				} else $this->msg = ("failed cannot insert records. please try again later");
			}		
		}
		$this->output();
	}
	
	public function getAddressBookLocationByID()
	{
		if ($client_id = $this->checkToken()){
			$id = isset($this->data['id'])?$this->data['id']:'';
			if($id>=1){
				if ($res=$this->LocationWrapper->getAddressBookByID($id,$client_id)){
				unset($res['date_created']);
				unset($res['date_modified']);
				unset($res['ip_address']);
											
				
				$this->code = 1;
				$this->msg = "ok";
				$this->details = array(
				  'data'=>$res
				);
			} else $this->msg = ("Record not found. please try again later");
			} else $this->msg =("Invalid id");
		}
		$this->output();
	}


	public function setAddressBookLocation()
	{
			if ($client_id = $this->checkToken()){
			$addressbook_id = isset($this->data['addressbook_id'])?$this->data['addressbook_id']:'';		
			if($addressbook_id>0){
				if($res = $this->LocationWrapper->getAddressBookByID($addressbook_id,$client_id)){					
					$new_data = array(
					  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
					  'delivery_instruction'=>isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'',
					  'street'=>$res['street'],
					  'state_name'=>$res['state_name'],
					  'city_name'=>$res['city_name'],
					  'area_name'=>$res['area_name'],
					  'location_name'=>$res['location_name'],
					  'lat'=>$res['lat'],
					  'lng'=>$res['lng'],
					  'state_id'=>$res['state_id'],
					  'city_id'=>$res['city_id'],
					  'area_id'=>$res['area_id'],
					  'save_address'=>0,
					);									
					$this->data = $new_data;
					$this->setDeliveryLocationFee();
					$this->output();
				} else $this->msg = ("invalid address book not found");
			} else $this->msg = ("invalid address book id");
		}		
		$this->output();
	}
	
	public function setDeliveryLocationFee()
	{
		
		$params=array();
		$params['street'] = isset($this->data['street'])?$this->data['street']:'';
		$params['state'] = isset($this->data['state_name'])?$this->data['state_name']:'';
		$params['city']= isset($this->data['city_name'])?$this->data['city_name']:'';
		$params['zipcode']= isset($this->data['area_name'])?$this->data['area_name']:'';
		$params['location_name']= isset($this->data['location_name'])?$this->data['location_name']:'';
		$params['contact_phone']= isset($this->data['contact_phone'])?$this->data['contact_phone']:'';
		$params['delivery_instruction']= isset($this->data['delivery_instruction'])?$this->data['delivery_instruction']:'';
		$params['save_address']= isset($this->data['save_address'])?$this->data['save_address']:0;
		$params['delivery_lat']= isset($this->data['lat'])?$this->data['lat']:'';
		$params['delivery_long']= isset($this->data['lng'])?$this->data['lng']:'';
		$params['state_id']= isset($this->data['state_id'])?$this->data['state_id']:'';
		$params['city_id']= isset($this->data['city_id'])?$this->data['city_id']:'';
		$params['area_id']= isset($this->data['area_id'])?$this->data['area_id']:'';
		
		$delivery_fee = $this->functions->getOption('merchant_delivery_charges',$this->merchant_id);
		
		
		$resp_delivery = $this->LocationWrapper->getDeliveryFee(
		 $this->merchant_id,
		 $delivery_fee,
		 $params['state_id'],
		 $params['city_id'],
		 $params['area_id']
		);		
		
		if($resp_delivery){
		  $params['delivery_fee']=$resp_delivery;
		} else {
		   $this->msg = ("Sorry this merchant does not deliver to your location");
		   $this->output();
		}	
				
		$this->functions->updateData("mt_singleapp_cart",$params,'device_id',$this->device_uiid);
		
		if($params['save_address']==1){
			if ($client_id = $this->checkToken()){
				if (!$this->LocationWrapper->isAddressBookExist($client_id,$params['state_id'],$params['city_id'],$params['area_id'])){
					$this->LocationWrapper->UpdateAllAddressBookDefaultLocation($client_id);
					$address = array(
					  'client_id'=>$client_id,
					  'street'=>$params['street'],
					  'location_name'=>$params['location_name'],
					  'country_id'=>$this->LocationWrapper->getCountryID($params['state_id']),
					  'state_id'=>$params['state_id'],
					  'city_id'=>$params['city_id'],
					  'area_id'=>$params['area_id'],
					  'latitude'=>$params['delivery_lat'],
					  'longitude'=>$params['delivery_long'],
					  'as_default'=>1,
					  'date_created'=>$this->functions->dateNow(),
					  'ip_address'=>$_SERVER['REMOTE_ADDR']
					);					
					$this->functions->insertData("mt_address_book_location",$address);
				}		
			}
		}	
		
		$search_resp = $this->SingleAppClass->searchMode();
		$search_mode = $search_resp['search_mode'];	

		$lat=$params['delivery_lat'];
		$lng=$params['delivery_long'];
		
	    /*SAVE LOCATION*/		
		$params_location = array(
		  'search_mode'=>$search_mode,
		  'device_uiid'=>$this->device_uiid,
		  'search_address'=>isset($this->data['search_address2'])?trim($this->data['search_address2']):'',
		  'street'=>$params['street'],
		  'city'=>$params['city'],
		  'state'=>$params['state'],
		  'country'=>isset($this->data['country_name'])?$this->data['country_name']:'',
		  'location_name'=>$params['location_name'],
		  'zipcode'=>$params['zipcode'],
		  'state_id'=>$this->data['state_id']?$this->data['state_id']:'',
		  'city_id'=>$this->data['city_id']?$this->data['city_id']:'',
		  'area_id'=>$this->data['area_id']?$this->data['area_id']:'',
		  'country_id'=>isset($this->data['country_id'])?$this->data['country_id']:'',
		  'latitude'=>$params['delivery_lat'],
		  'longitude'=>$params['delivery_long'],
		  'date_created'=>$this->functions->dateNow(),
		  'ip_address'=>$_SERVER['REMOTE_ADDR'],			  
		);			
		if(!empty($params_location['search_address'])){			
			if($res = $this->SingleAppClass->getRecentLocationByID($this->device_uiid,$lat,$lng,$search_mode)){
				$id = $res['id'];
				$this->functions->updateData("mt_singleapp_recent_location",$params_location,'id',$id);
			} else {				
				$this->functions->insertData("mt_singleapp_recent_location",$params_location);
			}		
		}
		
		
		$this->code = 1;
		$this->msg = "OK";
		$this->details = array(		  
		);
		
		$this->output();
	}


	public function SocialLogin()
	{
		 
		$email_address = isset($this->data['email_address'])?$this->data['email_address']:'';
		
		
		if ( $this->functions->emailBlockedCheck($email_address)){
    		  
    		$this->Validator->setmsg("Sorry but your email address is blocked by website admin");   		
    	}	 
    	
    	if(empty($email_address)){
    	     
    	  $this->Validator->setmsg("invalid email address");    		
    	}	
    	
    	$this->Validator->email(array(
		  'email_address'=>("Invalid email address")
		),$this->data);
    	
    	$token='';
    	$verification=$this->functions->getOptionAdmin('website_enabled_mobile_verification'); 
    	$email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');
    	
    	if($this->Validator->validate()){ 
    		
    		 
    		 $params = array(
    	   	    'first_name'=>($this->data['first_name']),
    	   	    'last_name'=>($this->data['last_name']),
    	   	    'email_address'=>($email_address),
    	   	    'password'=>md5($this->data['userid']),
    	   	    'last_login'=>$this->functions->dateNow(),
    	   	    'ip_address'=>$_SERVER['REMOTE_ADDR'],
    	   	    'social_strategy'=>isset($this->data['social_strategy'])?$this->data['social_strategy']:'',
    	   	    'social_id'=>isset($this->data['userid'])?$this->data['userid']:'',    	   	    
			    'single_app_merchant_id'=>$this->merchant_id,			    
    	   	 );
    		
    		if($res = $this->functions->isClientExist($email_address)){
    		   /*UPDATE*/
    		   $client_id = $res['client_id'];
    	   	   $token = $res['token'];
    	   	   
    	   	   $this->data['client_id'] = $client_id;
    	   	   $this->data['merchant_id'] = $this->merchant_id;
               $this->SingleAppClass->registeredDevice($this->data);
    	   	       	   	       	   	       	   	    	
    	   	   if(empty($token)){
    	   	  	 $token = $this->SingleAppClass->generateUniqueToken(15,$this->data['device_uiid']);    	   	  	 
    	   	  	 $params['token']=$token;
    	   	   }    	 
    	   	   if($res['status']=="pending"){
    	   	   	  $email_code=$this->functions->generateRandomKey(5);
    	   	   	  if($verification=="yes" || $email_verification==2){
    	   	   	  	 $params['email_verification_code']=$email_code;		    		
		    		 $this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
		    		 $this->data['next_step'] = 'verification_email';
		    		 $this->msg = ("We have sent verification code to your email address");    	   	     	
    	   	   	  }    	   	   	  
    	   	   } else $this->msg = ("Registration successful");
    	   	       	   	    
    	   	   unset($params['enabled_push']);
    	   	   unset($params['password']);
    	   	   
    	   	   $this->code = 1;
    	   	   $this->functions->updateData("mt_client",$params,'client_id',$client_id);
    	   	   
    		} else {
    		  /*INSERT*/    	   	      	   	    	   	  
    	   	  $email_code=$this->functions->generateRandomKey(5);
    	   	  if($verification=="yes" || $email_verification==2){
    	   	  	 $params['email_verification_code']=$email_code;
	    		 $params['status']='pending';	    		 
	    		$this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
	    		 $this->data['next_step'] = 'verification_email';
    	   	  }    	   
    	   	  
    	   	  $token = $this->SingleAppClass->generateUniqueToken(15,$this->data['device_uiid']);
	    	  $params['token']=$token;

	    	  $last_insert_id = $this->functions->insertData('mt_client', $params);
	          if ($last_insert_id!== false){
	    	 
	    	  	   $customer_id =$last_insert_id;
	    	  	   
	    	  	   $this->data['client_id'] = $customer_id;
	    	  	   $this->data['merchant_id'] = $this->merchant_id;
                   $this->SingleAppClass->registeredDevice($this->data);
	    	  	   
	    	  	   $this->code=1;
	    		   $this->msg = ("Registration successful");
	    		   
	    		   if($verification=="yes" || $email_verification==2){
	    		   	  $this->msg = ("We have sent verification code to your email address");    				
    				  $this->data['client_id'] = $customer_id;				          				  
	    		   } else {
	    		   	  /*sent welcome email*/	
	    		   	  $this->functions->sendCustomerWelcomeEmail($params);
	    		   	  $this->data['client_id'] = $customer_id;				      
	    		   }	    	  
	    		   
	    		   /*POINTS PROGRAM*/	    			
		    	   
		    		  $this->PointsProgram->signupReward($customer_id);
		    	   	    		    	      	    	    	    	    	  
	    		   
	    	  } else $this->msg = ("Something went wrong during processing your request. Please try again later");	    	    	     	
    		}
    		    		
    		
    		
    		$this->details = array(    			  
			  'next_step'=>isset($this->data['next_step'])?$this->data['next_step']:'',
			  'token'=>$token,    			  
			  'contact_phone'=>'',
			  'email_address'=>$email_address,
			);
    		
    	} else $this->msg = $this->SingleAppClass->parseValidatorError($this->Validator->getError());	
		$this->output();
	}
	
	public function ContactUs()
	{		




		$lang='en';		
		 
		$to=$this->functions->getOption('singleapp_contact_email',$this->merchant_id);
		if(empty($to)){
		    $this->msg = ("To email is empty under merchant contact us tab");
		    $this->output();
			return ;
		}	    	
				
		$subject=$this->functions->getOption('singleapp_contact_subject',$this->merchant_id);
		if(empty($subject)){
		    $this->msg = ("Subject email is empty under merchant contact us tab");
		    $this->output();
			return ;
		}	    	
				
        $tpl=$this->functions->getOption('singleapp_contact_tpl',$this->merchant_id);
        if(empty($tpl)){
		    $this->msg = ("Template is empty under merchant contact us tab");
		    $this->output();
			return ;
		}	    	
		
        if(!empty($tpl)){
        	foreach ($this->data as $key=>$val) {
        		if($key=="contact_phone"){
        			$key='phone';
        		}        	
        		$tpl=$this->functions->smarty($key,$val,$tpl);
        		$subject=$this->functions->smarty($key,$val,$subject);
        	}          	
        }                      
             	
        if($this->functions->sendEmail($to,'',$subject,$tpl)){
        	$this->code=1;    		
	        $this->msg= ("Your message was sent successfully. Thanks.");
        } else $this->msg = ("Failed sending email");
        
		$this->output();
	}



	public function getpromosslider(){
			
		
		//echo $this->merchant_id;
		//die();
		$promos = $this->itemWrapper->getItemByCategory_promotions($this->merchant_id,'150');
	
		
	
		       $home_slider1 = $promos['data'];
			   
			   $terss=count($home_slider1);
			   $terss=$terss-1;
                                                // print_r($home_slider1);
                                                $divsss = '';
if(count($home_slider1) > 0 ){
                                                foreach ($home_slider1 as $data1) {

                                                    // echo $data1['item_name'];
                                                    // echo $data1['item_name'];
													 $divsss .='<div class="item-list">';
													 $divsss .='<span class="test" style="width:88%;float: left;padding: 7px;text-align:left">PROMOTION ITEMS(You can select Upto '.$home_slider1[0]['totals'].' Items)</span><ons-icon onclick="showSlider()" style="font-size:27px"  class="remove ons-icon zmdi zmdi-close" icon="md-close" modifier="material"></ons-icon>';	 
       $divsss .='<img src="' . $data1['photo'] . '" /><h3 class="prod-title">' . $data1['item_name'] . '</h3><p class="prod-price"><strike>' . $data1['prices'][0] . '</strike>  <b style="color:red">Free</b></p>';
	   
	   if($data1['item_already']==1){
				 $divsss .= "<a class='dsktop menu-item'>";
				$divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange" style="background:#37963b">Already Added</button></a></div>';
			}else if ($home_slider1[$terss]['item_added_total']>=$data1['totals']){
				
				$divsss .= "<a class='dsktop menu-item' >";
				 $divsss .= '<button class="full_width add_to_cart button button--material button--quiet_orange" data-dismiss="modal" style="background:#ff0000">Limit Reached</button></a></div>';
			
			
												}else {
				
				 $divsss .= "<a class='dsktop menu-item' onclick=\"itemDetails_pro(".$data1['item_id'].",0,'',".$data1['promo_ids'].")\">";
       $divsss .='<button class="full_width add_to_cart button button--material button--quiet_orange">ADD TO CART</button></a></div>';

			}
	  
                                                   
                                                }
												    $this->msg='found';
												$this->details=$divsss;
												$this->code=1;
}else{
	                           $this->msg='not found';
												$this->details='';
												$this->code=0;
}
	
	$this->output();
	}



	public function preCheckout()
	{
		$this->setMerchantTimezone();
				
		if (!$this->functions->validateSellLimit($this->merchant_id) ){
        	$this->msg =("This merchant has reach the maximum sells per month");
        	$this->output();
        }
		
		$transaction_type = isset($this->data['transaction_type'])?$this->data['transaction_type']:'';
    	$delivery_date = isset($this->data['delivery_date'])?$this->data['delivery_date']:'';
    	$delivery_time = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';    	
		
		$error=''; 
		$checkout_stats = $this->functions->isMerchantcanCheckout($this->merchant_id);		
		if($checkout_stats['code']==1){
			
	    	if(empty($delivery_date)){
	    		$this->msg = ("Delivery date is required");
	    		$this->output();
	    	}
	    		    	
	    	$full_delivery = "$delivery_date $delivery_time";
    	    $delivery_day = strtolower(date("D",strtotime($full_delivery)));
    	        	    
    	    $delivery_time_formated = '';
	    	if(!empty($delivery_time)){
	    		$delivery_time_formated=date('h:i A',strtotime($delivery_time));
	    	} else $delivery_time_formated = date('h:i A');
	    	
	    	
	    	if ( !$this->functions->isMerchantOpenTimes($this->merchant_id,$delivery_day,$delivery_time_formated)){
	    		
	    		if(empty($delivery_time)){
	    			$delivery_time = date('h:i A');
	    			$full_delivery = "$delivery_date $delivery_time";
	    		}	    	
	    		
	    		$date_close=date("F,d l Y h:ia",strtotime($full_delivery));
	    		

	    		$this->msg = "Sorry but we are closed on ".$date_close." Please check merchant opening hours.";

	    		$this->output();
	    	}    	    	
    	
	    	/*CHECK IF DATE IS HOLIDAY*/
	    	if ( $res_holiday =  $this->functions->getMerchantHoliday($this->merchant_id)){
	    		if (in_array($delivery_date,$res_holiday)){
	    		  

	    		   $this->msg="were close on ".$this->functions->prettyDate($delivery_date);
				   	
				   	$close_msg=$this->functions->getOption('merchant_close_msg_holiday',$this->merchant_id);
				   	if(!empty($close_msg)){
		   	  	 	 

		   	  	 	  $this->msg =$close_msg." ".$this->functions->prettyDate($delivery_date) ;

		   	  	    }	
	    			$this->output();	
	    		}
	    	}
	    	
	    	$date_now = date("Y-m-d");	    			
			$merchant_preorder= $this->functions->getOption("merchant_preorder",$this->merchant_id);	    	
			if($merchant_preorder==1){    			   		
				if($date_now!=$delivery_date){
				   $checkout_stats['is_pre_order']=1;
				   if(empty($delivery_time)){    			   	   	    			   	  
					   $this->msg = ("For furure order delivery time is required");
				       $this->output();
				   }
				}	    		
			} else {
				if($date_now!=$delivery_date){
					$this->msg = ("Merchant is not accepting pre-order");
				    $this->output();
				}
			}	    	   
	    			
		} else $error = $checkout_stats['msg'];
		
		if(empty($error)){
			$this->code = 1;
			$this->msg = "OK";
			$details = array();
			$details['is_pre_order'] = $checkout_stats['is_pre_order'];
			if($checkout_stats['is_pre_order']==1){
				$details['message'] = ("This order is for another day. Continue?");
			} else $details['message'] = '';
			
			$this->details = $details;
		} else $this->msg = $error;	
		
		$this->output();
	}


	public function getStocks()
	{
			        		        
     
		$this->data = $_POST;		
		   
        $value = isset($this->data['price'])?$this->data['price']:'';
		$item_id = isset($this->data['item_id'])? (integer) $this->data['item_id']:'';
		$with_size = isset($this->data['with_size'])? (integer) $this->data['with_size']:'';
		$merchant_id = $this->merchant_id;
		
		        									
		if($merchant_id>0 && $item_id>0 ){
			try {
				
				$allow_negative_stock = $this->InventoryWrapper->allowNegativeStock($merchant_id);
				
				$size_id = 0;
								
				if($with_size>0){
					$value = explode("|",$value);
					if(is_array($value) && count($value)>=1){
						$size_id = isset($value[2])?(integer)$value[2]:0;
					}
				}		

				$resp = $this->StocksWrapper->getAvailableStocks($merchant_id,$item_id,$size_id);
				
				$this->code = 1; $this->msg = "OK";
				$this->details = array(
				  'next_action'=>"display_stocks",
				  'available_stocks'=>$resp['available_stocks'],
				  'message'=>$resp['message'],
				  'allow_negative_stock'=>$allow_negative_stock
				);			
						
			} catch (Exception $e) {
			   $this->details = array('next_action'=>"item_not_available");
		       
		       $this->msg =$e->getMessage() ;
		    }
		} else {
			 $this->details = array('next_action'=>"item_info_not_available");
			 $this->msg = "invalid merchant id or size id";
		}
		$this->output();
	}	


	public function AddTip()
	{		
		$tip_amount = isset($this->data['tip_amount'])?(float)$this->data['tip_amount']:0;		
		if($resp=$this->SingleAppClass::getCart($this->device_uiid , $this->merchant_id)){
			$cart_id = $resp['cart_id'];
			$subtotal = (float)$resp['cart_subtotal'];			
			$percentage = ($tip_amount/$subtotal)*100;
			$percentage = number_format($percentage/100,4);			
			

	  	    $this->functions->updateData("mt_singleapp_cart",array(
			  'tips'=>$percentage
			),'cart_id', $cart_id);


	  	    $this->code = 1;
	  	    $this->msg = "OK";
	  	    $this->details = array();			
		} else $this->msg = ("cart not available");
		$this->output();
	}
	
	public function retrievePasswordBySMS()
	{
		$lang = "en";
		
		$phone_number = isset($this->data['user_mobile'])?$this->data['user_mobile']:'';
		if(empty($phone_number)){
			$this->msg = ("Phone number is required");
			$this->output();
		}
		if(strlen($phone_number)<=4){
			$this->msg = ("Invalid phone number");
			$this->output();
		}
		
		try {
		
		   $code = $this->functions->generateRandomKey(5);
		   $res = $this->functions->getCustomerByPhone( str_replace("+","",$phone_number) );
		   $token=md5(date('c').$res['client_id']);  													 
		   
		  $this->functions->updateCustomerProfile($res['client_id'],array(
			 'mobile_verification_code'=>$code,
			 'mobile_verification_date'=>$this->functions->dateNow(),
			 'lost_password_token'=>$token,
			 'ip_address'=>$_SERVER['REMOTE_ADDR']
		   ));
		   
		   $resp = $this->functions->getNotificationTemplate('customer_forgot_password',$lang,'sms');
		   $data = array(
			  'firstname'=>$res['first_name'],
			  'lastname'=>$res['last_name'],
			  'code'=>$code,							  
			);		
			$sms_content = $resp['sms_content'];
			$sms_content = $this->functions->replaceTags($sms_content,$data);			
			$sms = $this->functions->sendSMS($phone_number,$sms_content);
			if($sms['msg']=="process"){
				$this->code=1; $this->msg=("We have sent verification code in your phone number");
				$this->details = array(							   	  				  
				  'forgot_password_token'=>$token
				);
			} else $this->msg = "Failed sending sms ".$sms['msg'];

			
		} catch (Exception $e) {
		   $this->msg = $e->getMessage();
		}	
		$this->output();
	}


	public function changePasswordBySMS()
	{		
		$token = isset($this->data['forgot_password_token'])?trim($this->data['forgot_password_token']):'';
    	$sms_code = isset($this->data['sms_code'])?trim($this->data['sms_code']):'';
    	if($res = $this->functions->getLostPassToken($token)){    		
    		if($res['mobile_verification_code']==$sms_code){ 
    			$new_password = isset($this->data['new_password'])?$this->data['new_password']:'';
    			$confirm_new_password = isset($this->data['confirm_new_password'])?$this->data['confirm_new_password']:'';
    			if(!empty($new_password) && $new_password==$confirm_new_password){
    				
    				


			      	   $this->functions->updateData("mt_client",array(
						  'password'=>md5($new_password),
			    		   'ip_address'=>$_SERVER['REMOTE_ADDR'],
			    		   'date_modified'=>$this->functions->dateNow()
						),'client_id', $res['client_id']); 			
			      	   
	    			   $this->code = 1; 
	    			   $this->msg = ("You have successfully change your password");
	    			   
    				
    			} else $this->msg = ("Password is not valid");
    		} else $this->msg = ("Invalid verification code");	
    	} else $this->msg = ("Invalid token");
    	$this->output();
	}		
	
	public function cancelBooking()
	{		
		$booking_id = isset($this->data['booking_id'])?(integer)$this->data['booking_id']:0;
		
		if ($client_id = $this->checkToken()){
			if($booking_id>0){
				$pattern = 'booking_id,restaurant_name,number_guest,date_booking,time,booking_name,email,mobile,instruction,status,merchant_remarks,sitename,siteurl';
    	        $pattern = explode(",",$pattern);    	        
    	        $lang = "en";
    	        if ($res = $this->functions->getBookingByIDWithDetails($booking_id)){
    	        	if($res['request_cancel']>=1){
		    			$this->msg = ("You have already request to cancel this booking");
		    		    $this->output();
		    		}
		    		
		    		$res['sitename'] =$this->functions->getOptionAdmin('website_title');
    		        $res['siteurl'] = $this->functions->websiteUrl();
    		        
    		        
    		        $merchant_id = $res['merchant_id'];
    		        $merchant_email = $this->functions->getOption('merchant_notify_email',$merchant_id);
    		        $sender = $this->functions->getOptionAdmin('global_admin_sender_email');
    		        $email_provider  = $this->functions->getOptionAdmin('email_provider');
    		        
    		        /*SEND EMAIL TO MERCHANT*/
    		        if(!empty($merchant_email)){    		        
    		        	$email = $this->functions->getOptionAdmin('booking_request_cancel_email');    		
			    		$subject = $this->functions->getOptionAdmin('booking_request_cancel_tpl_subject_'.$lang);
			    		$content = $this->functions->getOptionAdmin('booking_request_cancel_tpl_content_'.$lang);
			    		foreach ($pattern as $val) {    			
			    			$content = $this->functions->smarty($val, isset($res[$val])?$res[$val]:'' ,$content);
			    			$subject = $this->functions->smarty($val, isset($res[$val])?$res[$val]:'' ,$subject);
			    		}
			    		$merchant_email = explode(",",$merchant_email);			    		
    		        	
			    		if($email==1 && is_array($merchant_email) && count($merchant_email)>=1){
			    			foreach ($merchant_email as $_mail) {
			    				$params = array(
			    				  'email_address'=>$_mail,
			    				  'sender'=>$sender,
			    				  'subject'=>$subject,
			    				  'content'=>$content,
			    				  'date_created'=>$this->functions->dateNow(),
			    				  'ip_address'=>$_SERVER['REMOTE_ADDR'],
			    				  'email_provider'=>$email_provider,	    				  
			    				);
			    				$this->functions->insertData("mt_email_logs",$params);

			    			}
			    		}
    		        }
    		        
    		        /*SMS*/	
    		        $balance=$this->functions->getMerchantSMSCredit($merchant_id);	
    		        $phone = $this->functions->getOption('merchant_cancel_order_phone',$merchant_id);	    		    		        
    		        $sms_enabled = $this->functions->getOptionAdmin('booking_request_cancel_sms');
    		        
		    		if(!empty($phone) && $balance>0 && $sms_enabled==1){	    		    			
		    		    $sms_content = $this->functions->getOptionAdmin('booking_request_cancel_sms_content_'.$lang);
		    		    foreach ($pattern as $val) {    			
		    			   $sms_content =$this->functions->smarty($val, isset($res[$val])?$res[$val]:'' ,$sms_content);	    			   
		    		    }
		    		    $params = array(
		    		      'merchant_id'=>$merchant_id,
		    		      'contact_phone'=>$phone,
		    		      'sms_message'=>$sms_content,
		    		      'date_created'=>$this->functions->dateNow(),
		    		      'ip_address'=>$_SERVER['REMOTE_ADDR']
		    		    );
		    		    $this->functions->insertData("mt_sms_broadcast_details",$params);    		    
		    		}
		    		
		    		/*PUSH*/	    		
		    	
		    			
		    			$push_enabled=$this->functions->getOptionAdmin('booking_request_cancel_sms');
		    			$push_title=$this->functions->getOptionAdmin('booking_request_cancel_push_title_'.$lang);
		    			$push_message=$this->functions->getOptionAdmin('booking_request_cancel_push_content_'.$lang);
		    			
									    			$stmt = "
							    SELECT *
							    FROM mt_mobile_device_merchant
							    WHERE merchant_id = :merchant_id
							    AND enabled_push = :enabled_push
							    AND status = :status
							    LIMIT 1
							";

							$stmt_exec = $this->db->prepare($stmt);
							$stmt_exec->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
							$stmt_exec->bindValue(':enabled_push', 1, PDO::PARAM_INT);
							$stmt_exec->bindValue(':status', 'active', PDO::PARAM_STR);
							$stmt_exec->execute();

							$resp = $stmt_exec->fetchAll(PDO::FETCH_ASSOC);

							if ($resp && $push_enabled == 1) {
				        	
				        	foreach ($pattern as $val) {    			
    			               $push_title = $this->functions->smarty($val, isset($res[$val])?$res[$val]:'' ,$push_title);
    			               $push_message = $this->functions->smarty($val, isset($res[$val])?$res[$val]:'' ,$push_message);
    		                }
    		                    		        
				        	foreach ($merchant_resp as $merchant_device_id) {
				        		$params_merchant = array(
				        		  'merchant_id'=>(integer)$merchant_id,
				        		  'user_type'=>$merchant_device_id['user_type'],
				        		  'merchant_user_id'=>(integer)$merchant_device_id['merchant_user_id'],
				        		  'device_platform'=>$merchant_device_id['device_platform'],
				        		  'device_id'=>$merchant_device_id['device_id'],
				        		  'push_title'=>$push_title,
				        		  'push_message'=>$push_message,
				        		  'date_created'=>$this->functions->dateNow(),
				        		  'ip_address'=>$_SERVER['REMOTE_ADDR'],
				        		  'booking_id'=>(integer)$booking_id
				        		);
				        		$this->functions->insertData("mt_mobile_merchant_pushlogs",$params_merchant);
				        	}
				        }
		    		
		    		
		    		


		    		$this->functions->updateData("mt_bookingtable",array(
						  'request_cancel'=>1,
		    		      'status'=>'request_cancel_booking'
						),'booking_id', $booking_id); 	
    		        
    		        $this->code = 1;
    		        $this->msg = ("Your request has been sent to merchant");
		    		
    	        } else $this->msg = ("Booking id not found");    	        
			} else $this->msg = ("Invalid booking id");
		}		
		$this->output();
	}	



public function saveSubsribe()
{
    $token = isset($this->data['token']) ? $this->data['token'] : '';

    if ($res = $this->SingleAppClass->getCustomerByToken($token)) {
        $client_id = $res['client_id'];

        $subscribe_topic = isset($this->data['subscribe_topic']) ? (int)$this->data['subscribe_topic'] : 0;
        $date_modified = $this->functions->dateNow();
        $ip_address = $_SERVER['REMOTE_ADDR'];

        $stmt = "
            UPDATE mt_singleapp_device_reg
            SET subscribe_topic = :subscribe_topic,
                date_modified = :date_modified,
                ip_address = :ip_address
            WHERE device_uiid = :device_uiid AND client_id = :client_id
        ";

        $update = $this->db->prepare($stmt);
        $update->bindParam(':subscribe_topic', $subscribe_topic, PDO::PARAM_INT);
        $update->bindParam(':date_modified', $date_modified);
        $update->bindParam(':ip_address', $ip_address);
        $update->bindParam(':device_uiid', $this->device_uiid);
        $update->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        if ($update->execute()) {
            $this->code = 1;
            $this->msg = ("Push settings updated");
            $this->details = array(
                'subscribe_topic' => $subscribe_topic
            );
        } else {
            $this->msg = ("Cannot update records, please try again later");
        }

    } else {
        $this->code = 3;
        $this->msg = ("token not found");
    }

    $this->output();
}
	


















	


}
/*end class*/