<?php
class LocationWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->SingleAppClass = new SingleAppClass();
        
        //$this->CronWrapper = new CronWrapper();
        

    }


    public  function GetCountryDefault()
    {
        $country_id=$this->functions->getOptionAdmin('location_default_country');     
        if(empty($country_id)){
            if($res=$this->functions->getCountryByCode()){               
                $country_id=$res['country_id'];
            }
        }
        return $country_id;
    }

    public function GetSateDefault($country_id="")
    {
         if(!empty($country_id)){
            $state_ids='';
            if ($res=$this->functions->locationStateList($country_id)){
                foreach ($res as $val) {
                    $state_ids.="'$val[state_id]',";
                }
                $state_ids=substr($state_ids,0,-1);
            }
            return $state_ids;
        }
        return false;
    } 


 public function GetStateList($page = 0, $page_limit = 10, $search_string = '')
{
    $country_id = $this->GetCountryDefault();
    $and = '';
    $params = [':country_id' => $country_id];

    if (!empty($search_string)) {
        $and .= " AND a.name LIKE :search_string ";
        $params[':search_string'] = "%$search_string%";
    }

    if ($country_id > 0) {
        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS
            a.state_id,
            a.name as state,
            a.name as state_raw,
            a.country_id,
            b.country_name
            FROM mt_location_states a
            
            LEFT JOIN mt_location_countries b
            ON a.country_id = b.country_id
            
            WHERE a.country_id = :country_id
            $and
            ORDER BY a.sequence, a.name ASC
            LIMIT $page, $page_limit
        ";

        $query = $this->db->prepare($stmt);
        $query->execute($params);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            // Get total records
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->query($stmtc);
            $resp = $queryc->fetch(PDO::FETCH_ASSOC);
            $total_records = $resp ? $resp['total_records'] : 0;
            $paginate_total = ceil($total_records / $page_limit);

            $data = [];
            foreach ($res as $val) {
                $val['state'] = $this->SingleAppClass->highlight_word($this->functions->clearString($val['state_raw']), $search_string);
                $data[] = $val;
            }

            return [
                'paginate_total' => $paginate_total,
                'list' => $data
            ];
        }
    }
    return false;
}



 public function GetLocationCity($page = 0, $page_limit = 10, $search_string = '', $state_id = 0)
{
    $data = [];

    if ($state_id <= 0) {
        $country_id = $this->GetCountryDefault();
        if ($country_id > 0) {
            $state_id = $this->GetSateDefault($country_id);
        }
    }

    $and = "";
    $params = [];

    if (!empty($state_id)) {
        $and .= " AND a.state_id IN ($state_id) ";
    }

    if (!empty($search_string)) {
        $and .= " AND a.name LIKE :search_string ";
        $params[':search_string'] = "%$search_string%";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.city_id,
        a.name,
        a.postal_code,
        a.state_id,         
        b.name as state_name,
        c.country_id, 
        c.country_name
        FROM mt_location_cities a
        
        LEFT JOIN mt_location_states b
        ON a.state_id = b.state_id
        
        LEFT JOIN mt_location_countries c
        ON b.country_id = c.country_id
        
        WHERE 1
        $and
        ORDER BY a.sequence, a.name ASC
        LIMIT $page, $page_limit
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        // Get total records
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->query($stmtc);
        $resp = $queryc->fetch(PDO::FETCH_ASSOC);
        $total_records = $resp ? $resp['total_records'] : 0;
        $paginate_total = ceil($total_records / $page_limit);

        foreach ($res as $val) {
            $val['name'] = $this->functions->clearString($val['name']);
            $val['state_name'] = $this->functions->clearString($val['state_name']);
            $val['city_name'] = $this->SingleAppClass->highlight_word($this->functions->clearString($val['name']), $search_string);
            $data[] = $val;
        }

        return [
            'paginate_total' => $paginate_total,
            'list' => $data
        ];
    }

    return false;
}


public function GetAreaList($city_id = '', $page = 0, $page_limit = 10, $search_string = '')
{
    if ($city_id <= 0 || empty($city_id) || !is_numeric($city_id)) {
        return false;
    }

    $data = [];
    $and = '';
    $params = [];

    if (!empty($search_string)) {
        $and .= " AND a.name LIKE :search_string ";
        $params[':search_string'] = "%$search_string%";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*, 
        b.name as city_name
        FROM mt_location_area a
        LEFT JOIN mt_location_cities b
        ON a.city_id = b.city_id
        WHERE 1
        AND a.city_id = :city_id
        $and
        ORDER BY a.sequence, a.name ASC
        LIMIT :page, :page_limit
    ";

    $params[':city_id'] = $city_id;
    $params[':page'] = $page;
    $params[':page_limit'] = $page_limit;

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        // Get total records
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->query($stmtc);
        $resp = $queryc->fetch(PDO::FETCH_ASSOC);
        $total_records = $resp ? $resp['total_records'] : 0;
        $paginate_total = ceil($total_records / $page_limit);

        foreach ($res as $val) {
            $val['name'] = $this->functions->clearString($val['name']);
            $val['city_name'] = $this->functions->clearString($val['city_name']);
            $val['area_name'] = $this->SingleAppClass->highlight_word($this->functions->clearString($val['name']), $search_string);
            $data[] = $val;
        }

        return [
            'paginate_total' => $paginate_total,
            'list' => $data
        ];
    }

    return false;
}


public function getCountryID($state_id = '', $all = false)
{
    if ($state_id <= 0) {
        return false;
    }

    $params = [':state_id' => $state_id];
    $stmt = "
        SELECT * FROM mt_location_states
        WHERE state_id = :state_id
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        if ($all) {
            return $res;
        } else {
            return $res[0]['country_id'];
        }
    }

    return false;
}

public function isAddressBookExist($client_id='',$state_id='', $city_id='', $area_id='',$id=0)
{
    if ($client_id <= 0) {
        return false;
    }

    $params = [
        ':client_id' => $client_id,
        ':state_id' => $state_id,
        ':city_id' => $city_id,
        ':area_id' => $area_id
       
    ];

    $and = '';
    if ($id > 0) {
        $and = " AND id <> :id ";
        $params[':id'] = $id;
    }

    $stmt = "
        SELECT * FROM mt_address_book_location
        WHERE client_id = :client_id
        AND state_id = :state_id
        AND city_id = :city_id
        AND area_id = :area_id
        
        $and
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public function getAddressBookByID($id = '', $client_id = '')
{
    if ($id <= 0 || !is_numeric($id)) {
        return false;
    }
    if ($client_id <= 0 || !is_numeric($client_id)) {
        return false;
    }

    $stmt = "
        SELECT 
        a.id,
        a.street,
        a.country_id,
        a.location_name,        
        a.state_id,
        a.city_id,
        a.area_id,
        a.as_default,
        a.latitude as lat,  
        a.longitude as lng,
        d.name as area_name,
        c.name as city_name,
        b.name as state_name
        FROM mt_address_book_location a

        LEFT JOIN mt_location_states b ON a.state_id = b.state_id
        LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
        LEFT JOIN mt_location_area d ON a.area_id = d.area_id
            
        WHERE a.client_id = :client_id
        AND a.id = :id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':client_id' => $client_id,
        ':id' => $id
    ]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    return $res ?: false;
}


public function hasAddress($client_id = '')
{
    if ($client_id > 0) {
        $stmt = "
            SELECT * FROM mt_address_book_location
            WHERE client_id = :client_id
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([':client_id' => $client_id]);

        $res = $query->fetch(PDO::FETCH_ASSOC);

        return $res ?: false;
    }
    return false;
}

public function customerDefaultAddress($client_id = '')
{
    if ($client_id > 0) {
        $stmt = "
            SELECT 
                a.id,
                a.street,
                a.country_id,
                a.location_name,        
                a.state_id,
                a.city_id,
                a.area_id,
                a.as_default,
                a.latitude as lat,  
                a.longitude as lng,
                d.name as area_name,
                c.name as city_name,
                b.name as state_name,
                e.contact_phone
            FROM mt_address_book_location a
    
            LEFT JOIN mt_location_states b ON a.state_id = b.state_id
            LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
            LEFT JOIN mt_location_area d ON a.area_id = d.area_id
            LEFT JOIN mt_client e ON a.client_id = e.client_id
                
            WHERE a.client_id = :client_id  
            AND a.as_default = '1'              
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([':client_id' => $client_id]);

        $res = $query->fetch(PDO::FETCH_ASSOC);

        return $res ?: false;
    }
    return false;
}



   public function getDeliveryFee($merchant_id = '', $fee = 0, $state_id = '', $city_id = '', $area_id = '')
{
    if ($merchant_id <= 0) {
        return false;
    }

    $stmt = "
        SELECT a.fee
        FROM mt_view_location_rate a
        WHERE
        a.merchant_id = :merchant_id
        AND a.state_id = :state_id
        AND a.city_id = :city_id
        AND a.area_id = :area_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':merchant_id' => $merchant_id,
        ':state_id' => $state_id,
        ':city_id' => $city_id,
        ':area_id' => $area_id
    ]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res && $res['fee'] > 0.0001) {
        return $res['fee'];
    }
    
    return $fee;
}


public function getAddressBook($client_id = '')
{
    if ($client_id > 0) {
        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.id,
            a.as_default,
            a.date_created,
            CONCAT(a.street, ' ', d.name, ' ', c.name, ' ', b.name) AS address            
            FROM mt_address_book_location a
    
            LEFT JOIN mt_location_states b ON a.state_id = b.state_id
            LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
            LEFT JOIN mt_location_area d ON a.area_id = d.area_id
                
            WHERE a.client_id = :client_id
            AND a.street <> ''            
            
            ORDER BY a.id DESC
        ";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':client_id', (int) $client_id, PDO::PARAM_INT);
        $query->execute();

        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        return $res ?: false;
    }
    return false;
}



public  function autoSetDeliveryFee($location_mode='', $client_id='', $cart_id='', $data=array())
    {       
        if($location_mode>0){
           switch ($location_mode) {
            case 1:
            case 2:
            case 3:
                $merchant_id = isset($data['merchant_id'])?$data['merchant_id']:'';
                $delivery_fee = $this->functions->getOption('merchant_delivery_charges',$merchant_id);
                
                if($resp = $this->customerDefaultAddress($client_id)){                                                   
                   $resp_delivery = $this->getDeliveryFee(
                     $merchant_id,
                     $delivery_fee,
                     isset($resp['state_id'])?$resp['state_id']:'',
                     isset($resp['city_id'])?$resp['city_id']:'',
                     isset($resp['area_id'])?$resp['area_id']:''
                    );
                    if($resp_delivery){                     
                        $params = array(
                          'state_id'=>$resp['state_id'],
                          'city_id'=>$resp['city_id'],
                          'area_id'=>$resp['area_id'],
                          'street'=>$resp['street'],
                          'city'=>$resp['city_name'],
                          'state'=>$resp['state_name'],
                          'zipcode'=>$resp['area_name'],
                          'delivery_fee'=>$resp_delivery,
                          'delivery_lat'=>$resp['lat'],
                          'delivery_long'=>$resp['lng'],
                          'contact_phone'=>$resp['contact_phone']
                        );                      
                        
                        

                        $this->functions->updateData("mt_singleapp_cart",$params,'cart_id',$cart_id);

                       
                        return $params;
                    }
                }
                break;
           
            default:
                break;
           }           
        }
        return false;
    }   


public function GetPostalCodeList($page = 0, $page_limit = 10, $search_string = '')
{
    $country_id = $this->GetCountryDefault();
    
    if ($country_id > 0) {
        $and = '';
        $params = [':country_id' => $country_id, ':limit' => (int)$page_limit, ':offset' => (int)$page];

        if (!empty($search_string)) {
            $and .= " AND a.postal_code LIKE :search_string ";
            $params[':search_string'] = "%$search_string%";
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS
            a.city_id,          
            a.name as city_name,
            a.postal_code,
            a.postal_code as postal_code_raw,
            a.state_id,
            b.name as state_name,
            b.country_id
            FROM mt_location_cities a
            LEFT JOIN mt_location_states b ON a.state_id = b.state_id
            WHERE b.country_id = :country_id
            AND a.postal_code != ''
            $and
            GROUP BY a.postal_code
            LIMIT :offset, :limit
        ";

        if (isset($_GET['debug'])) {
            dump($stmt);
        }

        $query = $this->db->prepare($stmt);

        foreach ($params as $key => $value) {
            $query->bindValue($key, $value, is_int($value) ? PDO::PARAM_INT : PDO::PARAM_STR);
        }

        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->prepare($stmtc);
            $queryc->execute();
            $total_records = $queryc->fetch(PDO::FETCH_ASSOC)['total_records'] ?? 0;
            
            $paginate_total = ceil($total_records / $page_limit);
            
            foreach ($res as &$val) {                                                         
                $val['postal_code'] = $this->SingleAppClass->highlight_word($this->functions->clearString($val['postal_code_raw']), $search_string);
            }
            
            return [
                'paginate_total' => $paginate_total,
                'list' => $res
            ];
        }
    }
    
    return false;
}



    public  function getLocationFilter($location_mode=0)
    {
        $fields = array();
        switch ($location_mode) {
            case 1:         
               $fields = array('city_id','area_id');
                break;
        
            case 2:             
                $fields = array('state_id','city_id');
                break;
                
            case 3:             
               $fields = array('city_id','postal_code'); 
                break;
                        
            default:
                break;
        }
        return $fields;
    }

    public function UpdateAllAddressBookDefaultLocation($client_id = '')
{
    $stmt = "
        UPDATE mt_address_book_location
        SET as_default = '0'
        WHERE client_id = :client_id
    ";
    
    $query = $this->db->prepare($stmt);
    $query->execute([':client_id' => $client_id]);

    return true;
}





















  




	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/