<?php
class SingleAppClass
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->PointsProgram = new PointsProgram();
        $this->InventoryWrapper = new InventoryWrapper();
        
        //$this->CronWrapper = new CronWrapper();
        

    }

	public  function moduleBaseUrl()
    {
        return Config::$baseUrl."/app/modules/singlemerchant";
    }
    
    public  function moduleName()
    {
        return 'singlemerchant';
    }
    
    public  function getMerchantId()
    {
        return $this->functions->getMerchantID();  
    }
    
    public  function registrationType()
    {
        return 'fcm';
    }


    public function validateKeys($keys = '')
{
    if (empty($keys)) {
        return false;
    }

    try {
        $stmt = $this->db->prepare("
            SELECT 
                merchant_id,
                single_app_keys,
                restaurant_name,
                status
            FROM
                mt_merchant
            WHERE
                single_app_keys = :keys
            LIMIT 1
        ");

        $stmt->execute([':keys' => $keys]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ?: false;

    } catch (PDOException $e) {
        // Log error or handle as needed
        return false;
    }
}

public function getCategory($merchant_id = '', $page = 0, $limit = 0, $all = false)
{
    if (empty($merchant_id)) {
        return false;
    }

    $and = '';
    $todays_day = date("l");
    $todays_day = !empty($todays_day) ? strtolower($todays_day) : '';

    $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id);
    if ($enabled_category_sked == 1) {
        $and .= " AND `$todays_day` = '1' ";
    }

    if ($all) {
        $stmt = "
            SELECT 
                cat_id,
                category_name,
                category_description,
                photo,
                dish,
                category_name_trans,
                category_description_trans
            FROM
                mt_category
            WHERE 
                merchant_id = :merchant_id
                AND status IN ('publish','published')
                $and
            ORDER BY sequence ASC
        ";
    } else {
        $stmt = "
            SELECT 
                cat_id,
                category_name,
                category_description,
                photo,
                dish,
                category_name_trans,
                category_description_trans
            FROM
                mt_category
            WHERE 
                merchant_id = :merchant_id
                AND status IN ('publish','published')
                $and
            ORDER BY sequence ASC
            LIMIT $page, $limit
        ";
    }

    $trans = $this->functions->getOptionAdmin('enabled_multiple_translation');
    $new_data = [];

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $merchant_id);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $val['category_name'] = stripslashes($val['category_name']);

                if (!empty($val['photo'])) {
                    $val['photo_url'] = $this->getImage($val['photo']);
                } else {
                    $val['photo_url'] = $this->getImage($this->functions->getOption('singleapp_default_image', $merchant_id), 'default_cuisine.png');
                }

                $val['category_description'] = ($val['category_description']);
                $val['dish_list'] = $this->getDishPics(isset($val['dish']) ? $val['dish'] : '');

                if ($all) {
                    unset($val['photo']);
                    unset($val['dish']);
                    unset($val['category_description']);
                    unset($val['category_name_trans']);
                    unset($val['category_description_trans']);
                    unset($val['photo_url']);
                    unset($val['dish_list']);

                    $item_count = $this->getItemCountByCategory($val['cat_id']);
                    $val['item_count'] = $item_count . " item";
                }

                $new_data[] = $val;
            }

            return $new_data;
        }
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }

    return false;
}


public  function getImage($image='', $default="default-logo.png")
    {   
        $url='';            
        $path_to_upload=Config::$baseUrl."/upload/";                
        
        if (!empty($image)){ 

           
                                        
                $default=$image;  

                             
                $url = Config::$baseUrl."/upload/$default";


            
        } else $url=Config::$baseUrl."/assets_singleapp/images/$default";
        return $url;
    }
    
    public  function getImage2($image='')
    {   
        $url='';            
        $path_to_upload=Config::$baseUrl."/upload/";               
        
        if (!empty($image)){            
            if (file_exists($path_to_upload."/$image"||1==1)){                                                        
                $url = Config::$baseUrl."/upload/$image";
            }
        } 
        return $url;
    }  


    public  function getAvatar($client_id='')
    {
        
        if($client_id>0){
            if ( $res= $this->functions->getClientInfo($client_id) ){
                $file=$res['avatar'];
            } else $file='avatar.jpg';
        } else $file='avatar.jpg';
        
        if (empty($file)){
            $file='avatar.jpg';
        }
                    
        $path=Config::$baseUrl."/upload/$file";
        
        if ( file_exists($path)||1==1 ){                              
            return Config::$baseUrl."/upload/$file";
        } else return $this->functions->websiteUrl()."/assets/images/avatar.jpg";     
    }
    
    public  function getAvatar2($file='')
    {                       
        if (empty($file)){
            $file='avatar.jpg';
        }
                    
        $path=Config::$baseUrl."/upload/$file";
        
        if ( file_exists($path)||1==1 ){                              
            return Config::$baseUrl."/upload/$file";
        } else return $this->functions->websiteUrl()."/assets/images/avatar.jpg";     
    }  


    public  function getGallerPicURL($filename='')
    {
        $path=Config::$baseUrl."/upload/$filename";  
        if(file_exists($path)||1==1){
            return Config::$baseUrl."/upload/$filename";
        } 
        return false;
    }
    
    public  function getDishPics($list='')
    {
        $dish_list = array();
        $dish = json_decode($list,true);
        if(is_array($dish) && count($dish)>=1){
            foreach ($dish as $dish_id) {
                if($dish_info = $this->functions->GetDish($dish_id)){                              
                    if ($icon_link = $this->getGallerPicURL($dish_info['photo'])){
                        $dish_list[]=$icon_link;
                    }                           
                }                       
            }
            
        } else $dish_list='';
        return $dish_list;
    }


    public  function getPrices($price='',$discount=0)
    {               
        $new_price = array();
        $price = !empty($price)? json_decode($price,true) : false;
        if(is_array($price) && count($price)>=1){
            foreach ($price as $size_id =>  $presyo) {
                //dump($size_id."=>".$presyo);
                $size_name = '';
                if ($resp = $this->functions->getSize($size_id)){          
                                                
                    $size_name_trans = json_decode($resp['size_name_trans'],true);
                    $resp['size_name_trans']=$size_name_trans;                  
                    $resp['size_name']=$this->functions->qTranslate($resp['size_name'],'size_name',$resp);            
                    
                    $size_name = $resp['size_name'];
                }
                
                $formatted_price='';
                if(!empty($size_name)){
                    //$formatted_price = "$size_name ".FunctionsV3::prettyPrice($presyo);
                    $formatted_price = $this->functions->prettyPrice($presyo);
                } else $formatted_price = $this->functions->prettyPrice($presyo);
                
                $discount_price = 0;
                if($discount>0.0001){
                    $discount_price = $presyo-$discount;
                }
                
                $new_price []  = array(
                  'price'=>$presyo,
                  'formatted_price'=>$formatted_price,
                  'discount'=>$discount,
                  'discount_price'=>$discount_price,
                  'formatted_discount_price'=>$this->functions->prettyPrice($discount_price),
                  'size'=>$size_name,
                  'size_id'=>$size_id,
                  'size_trans'=>'',
                );
            }
            return $new_price;
        }
        return false;
    }
    
   public function getCart($device_id = '', $merchant_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    $merchant_id = (int) $merchant_id;

    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_singleapp_cart
            WHERE device_id = :device_id
            AND merchant_id = :merchant_id
            LIMIT 1
        ");
        $stmt->execute([
            ':device_id' => $device_id,
            ':merchant_id' => $merchant_id
        ]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        return $res ?: false;
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }
}


public  function removeVoucher($device_id='')
    {
        if(empty($device_id)){
            return false;
        }
        
        
        $params = array(
          'date_modified'=>$this->functions->dateNow(),
          'voucher_details'=>''
        );
        $this->functions->updateData("mt_singleapp_cart",$params,'device_id',$device_id);
    }
    
    public  function removeTip($device_id='')
    {       
        if(empty($device_id)){
            return false;
        }               
        $params = array(
          'date_modified'=>$this->functions->dateNow(),        
          'tips'=>0,
          'remove_tip'=>1
        );      
       

        $up =$this->functions->updateData("mt_singleapp_cart",$params,'device_id',$device_id);


    }



     public  function createTimeRange($start, $end, $interval = '30 mins', $format = '12') {
        $startTime = strtotime($start); 
        $endTime   = strtotime($end);
        $returnTimeFormat = ($format == '12')?'g:i:s A':'G:i:s';
    
        $current   = time(); 
        $addTime   = strtotime('+'.$interval, $current); 
        $diff      = $addTime - $current;
    
        $times = array();       
        while ($startTime < $endTime) { 
            $times[] = date($returnTimeFormat, $startTime); 
            $startTime += $diff; 
        } 
        $times[] = date($returnTimeFormat, $startTime); 
        return $times; 
    }
    
    public  function parseValidatorError($error='')
    {
        $error_string='';
        if (is_array($error) && count($error)>=1){
            foreach ($error as $val) {
                $error_string.="$val\n";
            }
        }
        return $error_string;       
    }       
    
    public  function generateUniqueToken($length,$unique_text=''){    
        $key = '';
        $keys = array_merge(range(0, 9), range('a', 'z'));  
        for ($i = 0; $i < $length; $i++) {
            $key .= $keys[array_rand($keys)];
        }   
        return $key.md5($unique_text);
    }   


   public function getCustomerByToken($token = '', $is_active = true)
{
    if (empty($token)) {
        return false;
    }

    $and = "";
    if ($is_active) {
        $and = " AND status IN ('active')";
    }

    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_client
            WHERE token = :token
            $and
            LIMIT 1
        ");
        $stmt->bindParam(':token', $token);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        return $res ?: false;
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }
}
       
    
  public function getCustomerByTokenAndDevice($token = '', $device_uiid = '', $is_active = true)
{
    if (empty($token)) {
        return false;
    }

    $and = "";
    if ($is_active) {
        $and = " AND a.status IN ('active')";
    }

    try {
        $stmt = $this->db->prepare("
            SELECT 
                a.client_id,
                a.first_name,
                a.last_name,
                CONCAT(a.first_name, ' ', a.last_name) AS full_name,
                a.email_address,
                a.contact_phone,
                a.social_strategy,
                a.avatar,
                a.single_app_merchant_id,
                
                b.device_uiid,
                b.device_id,
                b.device_platform,
                b.push_enabled,
                b.subscribe_topic       
            FROM mt_client a
            LEFT JOIN mt_singleapp_device_reg b
                ON a.client_id = b.client_id
            WHERE a.token = :token
            $and
            LIMIT 1
        ");
        $stmt->bindParam(':token', $token);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        return $res ?: false;
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }
}
          
    
    public function clearCart($device_id = '')
{
    if (empty($device_id)) {
        return false;
    }

    try {
        $stmt = $this->db->prepare("
            DELETE FROM mt_singleapp_cart
            WHERE device_id = :device_id
        ");
        $stmt->bindParam(':device_id', $device_id);
        $stmt->execute();
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }
}


    public  function getCartContent($device_id='',$data=array())
    {
        if(empty($device_id)){
            return false;
        }
        
        $merchant_id = isset($data['merchant_id'])? (integer) $data['merchant_id']:0;
        
        if($res=$this->getCart($device_id , $merchant_id)){
            $cart=json_decode($res['cart'],true);
            
            if($res['tips']>0.0001){
                $data['cart_tip_percentage']=$res['tips'];
                $data['tip_enabled']=2;
                $data['tip_percent']=$res['tips'];
            }
            
            $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false; 
            if(is_array($voucher_details) && count($voucher_details)>=1){
                $data['voucher_name']=$voucher_details['voucher_name'];
                $data['voucher_amount']=$voucher_details['amount'];
                $data['voucher_type']=$voucher_details['voucher_type'];
            }
            
            if($res['points_apply']>0.0001){
                $data['points_apply']=$res['points_apply'];
            }
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }
            
            /*DELIVERY FEE*/
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
                                
            $cart_details = $res;
            unset($cart_details['cart']);       
            unset($cart_details['device_id']);
            unset($cart_details['cart_id']);            
            
            $displayOrderHTML=$this->functions->displayOrderHTML( $data,$cart );
            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $details = $displayOrderHTML['raw'];
                return $details;
            }
        }
        return false;
    }


   public function appLogin_bkedup($username = '', $password = '',$merchant_id)
{
    if (empty($username)) {
        return false;
    }
    if (empty($password)) {
        return false;
    }
    if (empty($merchant_id)) {
        return false;
    }

    try {
        // Attempt login via email
        $stmt = $this->db->prepare("
            SELECT 
                client_id,
                first_name,
                last_name,
                email_address,
                token,
                contact_phone
            FROM mt_client
            WHERE email_address = :username
            AND password = :password
            AND merchant_id = :merchant_id
            AND status IN ('active')
            LIMIT 1
        ");
        $hashed_password = md5($password);
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':merchant_id', $merchant_id);
        $stmt->bindParam(':password', $hashed_password);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        } else {
            // Attempt login via phone
            $likePhone = "%" . $username;
            $stmt = $this->db->prepare("
                SELECT 
                    client_id,
                    first_name,
                    last_name,
                    email_address,
                    token,
                    contact_phone
                FROM mt_client
                WHERE contact_phone LIKE :phone
                AND password = :password
                AND merchant_id = :merchant_id
                AND status IN ('active')
                LIMIT 1
            ");
            $stmt->bindParam(':phone', $likePhone);
            $stmt->bindParam(':merchant_id', $merchant_id);
            $stmt->bindParam(':password', $hashed_password);
            $stmt->execute();
            $res = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                return $res;
            }
        }
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }

    return false;
}

public function appLogin_bkedupx($username = '', $password = '', $merchant_id = null)
{
    if (empty($username)) {
        return false;
    }
    if (empty($password)) {
        return false;
    }

    try {
        // Attempt login via email
        $stmt = $this->db->prepare("
            SELECT 
                client_id,
                first_name,
                last_name,
                email_address,
                token,
                contact_phone
            FROM mt_client
            WHERE email_address = :username
            AND password = :password
            AND social_strategy = 'SingleMerchant'
            AND status IN ('active')
            LIMIT 1
        ");
        $hashed_password = md5($password);
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':password', $hashed_password);
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        } else {
            // Attempt login via phone
            $likePhone = "%" . $username;
            $stmt = $this->db->prepare("
                SELECT 
                    client_id,
                    first_name,
                    last_name,
                    email_address,
                    token,
                    contact_phone
                FROM mt_client
                WHERE contact_phone LIKE :phone
                AND password = :password
                AND social_strategy = 'SingleMerchant'
                AND status IN ('active')
                LIMIT 1
            ");
            $stmt->bindParam(':phone', $likePhone);
            $stmt->bindParam(':password', $hashed_password);
            $stmt->execute();
            $res = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                return $res;
            }
        }
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }

    return false;
}

public function appLogin($username = '', $password = '', $merchant_id = null)
{
    if (empty($username) || empty($password) || empty($merchant_id)) {
        return false;
    }

    try {
        // Step 1: Check if this merchant is part of a branch set
        $branchMerchants = [];
        $stmtBranch = $this->db->prepare("SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?)) LIMIT 1");
        $stmtBranch->execute([$merchant_id]);
        $branchRow = $stmtBranch->fetch(PDO::FETCH_ASSOC);

        if ($branchRow && !empty($branchRow['merchant_id'])) {
            $branchMerchants = json_decode($branchRow['merchant_id'], true);
        } else {
            $branchMerchants = [ (int)$merchant_id ];
        }

        // Step 2: Prepare SQL safe values
        $hashed_password = md5($password);
        $safeEmail = $this->db->quote($username);
        $safePass = $this->db->quote($hashed_password);
        $likePhone = $this->db->quote("%" . $username);

        // Step 3: Build branch condition using JSON_CONTAINS
        $jsonBranchConditions = [];
        foreach ($branchMerchants as $id) {
    $jsonBranchConditions[] = "JSON_CONTAINS(branch, '$id')";
}
        $branchCondition = implode(' OR ', $jsonBranchConditions);

        // Step 4: Attempt login via email
       /* $sql = "
            SELECT 
                client_id,
                first_name,
                last_name,
                email_address,
                token,
                contact_phone
            FROM mt_client
            WHERE email_address = $safeEmail
            AND password = $safePass
            AND social_strategy = 'SingleMerchant'
            AND status = 'active'
            AND ($branchCondition)
            LIMIT 1
        ";*/

         $sql = "
            SELECT 
                client_id,
                first_name,
                last_name,
                email_address,
                token,
                contact_phone
            FROM mt_client
            WHERE email_address = $safeEmail
            AND password = $safePass
            
            AND status = 'active'
            AND ($branchCondition)
            LIMIT 1
        ";


        $stmt = $this->db->query($sql);

        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }

        // Step 5: Attempt login via phone
        $sql = "
            SELECT 
                client_id,
                first_name,
                last_name,
                email_address,
                token,
                contact_phone
            FROM mt_client
            WHERE contact_phone LIKE $likePhone
            AND password = $safePass
            AND social_strategy = 'SingleMerchant'
            AND status = 'active'
            AND ($branchCondition)
            LIMIT 1
        ";
        $stmt = $this->db->query($sql);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Optional: Log $e->getMessage()
        return false;
    }

    return false;
}













public function getCreditCards($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    try {
        $stmt = $this->db->prepare("
            SELECT 
                cc_id,
                credit_card_number,
                date_created
            FROM mt_client_cc
            WHERE client_id = :client_id
            ORDER BY cc_id DESC
        ");
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (isset($_GET['debug'])) {
            // dump($stmt); // Preserved as comment
        }

        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }

    return false;
}

    
   public function getAddressBookByClient($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $data = array();

    try {
        $stmt = $this->db->prepare("
            SELECT              
                concat(street,' ',city,' ',state,' ',zipcode) as address,
                id,
                location_name,
                country_code,
                as_default,
                latitude,
                longitude,
                date_created
            FROM mt_address_book
            WHERE client_id = :client_id
            ORDER BY street ASC
        ");
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $date_added = $this->functions->prettyDate($val['date_created']) . " " .
                              $this->functions->prettyTime($val['date_created']);

                $val['date_added'] = "Added " . $date_added;
                $data[] = $val;
            }
            return $data;
        }
    } catch (PDOException $e) {
        // Optional: log error
        return false;
    }

    return false;
}


 public  function getMerchantLogo($merchant_id='')
    {       
        if ( !$logo = $this->functions->getOption('merchant_photo',$merchant_id) ){           
            $logo = $this->functions->getOptionAdmin('mobile_default_image_not_available');
            if (empty($logo)){
               $logo="default-logo.png";
            }
        }       
        $path_to_upload=Config::$baseUrl."/upload/";         
        if (file_exists($path_to_upload."/$logo")||1==1){
            return Config::$baseUrl."/upload/$logo";
        } 
        return Config::$baseUrl."/assets_singleapp/images/$logo";                
    } 


    public  function receiptFormater($label='', $val='')
    {
        return array(
          'label'=>($label),
          'value'=>$val
        );
    }
    
    public  function getOpeningHours($merchant_id='')
    {
        if(empty($merchant_id)){
            return false;
        }
        
        $stores_open_day=$this->functions->getOption("stores_open_day",$merchant_id);
        $stores_open_starts=$this->functions->getOption("stores_open_starts",$merchant_id);
        $stores_open_ends=$this->functions->getOption("stores_open_ends",$merchant_id);
        $stores_open_custom_text=$this->functions->getOption("stores_open_custom_text",$merchant_id);
        
        $stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;
        $stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
        $stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
        $stores_open_custom_text=!empty($stores_open_custom_text)?(array)json_decode($stores_open_custom_text):false;
        
        
        $stores_open_pm_start=$this->functions->getOption("stores_open_pm_start",$merchant_id);
        $stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;
        
        $stores_open_pm_ends=$this->functions->getOption("stores_open_pm_ends",$merchant_id);
        $stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;       
                                                
        $open_starts='';
        $open_ends='';
        $open_text='';
        $data=array();
                
        if (is_array($stores_open_day) && count($stores_open_day)>=1){
            foreach ($stores_open_day as $val_open) {   
                if (array_key_exists($val_open,(array)$stores_open_starts)){
                    $open_starts=$this->functions->timeFormat($stores_open_starts[$val_open],true);
                }                           
                if (array_key_exists($val_open,(array)$stores_open_ends)){
                    $open_ends=$this->functions->timeFormat($stores_open_ends[$val_open],true);
                }                           
                if (array_key_exists($val_open,(array)$stores_open_custom_text)){
                    $open_text=$stores_open_custom_text[$val_open];
                }                   
                
                $pm_starts=''; $pm_ends=''; $pm_opens='';
                if (array_key_exists($val_open,(array)$stores_open_pm_start)){
                    $pm_starts=$this->functions->timeFormat($stores_open_pm_start[$val_open],true);
                }                                           
                if (array_key_exists($val_open,(array)$stores_open_pm_ends)){
                    $pm_ends=$this->functions->timeFormat($stores_open_pm_ends[$val_open],true);
                }                                               
                
                $full_time='';
                if (!empty($open_starts) && !empty($open_ends)){                    
                    $full_time=$open_starts."-".$open_ends;
                }           
                if (!empty($pm_starts) && !empty($pm_ends)){
                    if ( !empty($full_time)){
                        $full_time.="x";
                    }               
                    $full_time.="$pm_starts-$pm_ends";
                }                                               
                                
                $data[$val_open]=array(
                  'day'=>$val_open,
                  'hours'=>$full_time                 
                );
                
                $open_starts='';
                $open_ends='';
                $open_text='';
            }
            return $data;
        }           
        return false;       
    }   
    
public function getBookAddress($street = '', $city = '', $state = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_address_book
            WHERE street = :street
            AND city = :city
            AND state = :state
            LIMIT 0,1
        ");
        $stmt->bindParam(':street', $street, PDO::PARAM_STR);
        $stmt->bindParam(':city', $city, PDO::PARAM_STR);
        $stmt->bindParam(':state', $state, PDO::PARAM_STR);
        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Optionally log error
        return false;
    }

    return false;
}


public  function getPaypalCredentials($merchant_id='')
    {
        if(empty($merchant_id)){
            return false;
        }
        
        if ( $this->functions->isMerchantPaymentToUseAdmin($merchant_id)){
           $paypal_mobile_enabled=$this->functions->getOptionAdmin('adm_paypal_mobile_enabled');
           $paypal_fee=$this->functions->getOptionAdmin("admin_paypal_fee");         
           $paypal_mobile_mode=$this->functions->getOptionAdmin('adm_paypal_mobile_mode');
           $paypal_client_id=$this->functions->getOptionAdmin('adm_paypal_mobile_clientid');
        } else {
           $paypal_mobile_enabled=$this->functions->getOption('mt_paypal_mobile_enabled',$merchant_id);
           $paypal_fee=$this->functions->getOption('merchant_paypal_fee',$merchant_id);          
           $paypal_mobile_mode=$this->functions->getOption('mt_paypal_mobile_mode',$merchant_id);
           $paypal_client_id=$this->functions->getOption('mt_paypal_mobile_clientid',$merchant_id);
        }       
        if ($paypal_mobile_enabled=="yes"){
            return  array(
              'enabled'=>$paypal_mobile_enabled,
              'fee'=>$paypal_fee,
              'mode'=>strtolower($paypal_mobile_mode),
              'client_id'=>$paypal_client_id
            );
        }
        return false;
    }
    
    public  function getStripeCredentials($merchant_id='')
    {
        if(empty($merchant_id)){
            return false;
        }
        
        $enabled = false; $mode = ''; $secret_key=''; $publish_key='';
        if ( $this->functions->isMerchantPaymentToUseAdmin($merchant_id)){
            
            $enabled = $this->functions->getOptionAdmin('admin_stripe_enabled');
            if($enabled=="yes"){
                $enabled=true;
            }
            $mode = strtolower($this->functions->getOptionAdmin('admin_stripe_mode'));
            if($mode=="sandbox"){
               $secret_key = $this->functions->getOptionAdmin('admin_sanbox_stripe_secret_key');
               $publish_key = $this->functions->getOptionAdmin('admin_sandbox_stripe_pub_key');
            } else if ($mode=="live") {                     
               $secret_key = $this->functions->getOptionAdmin('admin_live_stripe_secret_key');
               $publish_key = $this->functions->getOptionAdmin('admin_live_stripe_pub_key');
            }       
        } else {
            $enabled = $this->functions->getOption('stripe_enabled',$merchant_id);
            if($enabled=="yes"){
                $enabled=true;
            }
            $mode = strtolower($this->functions->getOption('stripe_mode',$merchant_id));
            if($mode=="sandbox"){
               $secret_key = $this->functions->getOption('sanbox_stripe_secret_key',$merchant_id);
               $publish_key = $this->functions->getOption('sandbox_stripe_pub_key',$merchant_id);
            } else if ($mode=="live") {                     
               $secret_key =  $this->functions->getOption('live_stripe_secret_key',$merchant_id);
               $publish_key =  $this->functions->getOption('live_stripe_pub_key',$merchant_id);
            }       
        }
        
        if ($enabled && !empty($secret_key) && !empty($publish_key)){
            return array(
              'mode'=>$mode,
              'secret_key'=>$secret_key,
              'publish_key'=>$publish_key
            );
        }
        return false;
    }


    public  function getOrderDetails($order_id='')
    {
        if(empty($order_id)){
            return false;
        }
        
        $_GET['backend']=''; 
        if ($res = $this->functions->getOrder2($order_id) ){
            return $res;
        }
        return false;
    }
        
    public  function deliveryDateList($merchant_id='')
    {       
        $dates=array();
        $day=$this->functions->getOption("stores_open_day",$merchant_id);
        $day_open=!empty($day)?json_decode($day,true):false;
            
        if(is_array($day_open) && count($day_open)>=1){
            
            for ($i = 0; $i <= 30; $i++) {              
                $key=date("Y-m-d",strtotime("+$i day"));
                $key_day = strtolower(date("l",strtotime($key)));
                if(in_array($key_day,(array)$day_open)){
                    $dates[$key] = $this->functions->prettyDate($key);
                }
            }
        } else {
            for ($i = 0; $i <= 30; $i++) {              
                $key=date("Y-m-d",strtotime("+$i day"));
                $dates[$key] = date("D F d Y",strtotime("+$i day"));
            }
        }
        return $dates;
    }
    
    public  function tipList()
    {
        return array(
               '0.1'=>"10%",
               '0.15'=>"15%",
               '0.2'=>"20%",
               '0.25'=>"25%"           
            );  
    } 


   public function generateMerchantKeys()
{
    $single_app_keys = md5($this->functions->generateCode(50));

    try {
        $stmt = $this->db->prepare("
            SELECT single_app_keys
            FROM mt_merchant
            WHERE single_app_keys = :key
            LIMIT 0,1
        ");
        $stmt->bindParam(':key', $single_app_keys, PDO::PARAM_STR);
        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return self::generateMerchantKeys();
        }
    } catch (PDOException $e) {
        // Optionally handle or log the error
        return false;
    }

    return $single_app_keys;
}

    public  function handleAll($order_id='', $merchant_id='', 
    $client_id='',$device_id='', $order_status='')
    {
        $this->sendNotifications($order_id);
        
        /*POINTS ADDON*/
                
            if($res=$this->getCart($device_id , $merchant_id)){
                $points_earn = $res['points_earn'];
                $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);
                
                if ($res['points_apply']>=0.0001){
                    $this->PointsProgram->saveExpensesPoints(
                      $res['points_apply'],
                      $res['points_amount'],
                      $client_id,
                      $merchant_id,
                      $order_id,
                      ''
                    );
                }
            }
        
        
        /*SEND FAX*/
        $this->functions->sendFax($merchant_id,$order_id);
        
     
        
         /*inventory*/      
         if($this->inventoryEnabled($merchant_id)){
            try {                                         
               $this->InventoryWrapper->insertInventorySale($order_id,$order_status);  
            } catch (Exception $e) {                                            
              // echo $e->getMessage();                       
            }                                        
         }
        
        /*CLEAR CART*/
        $this->clearCart($device_id); 
    }     



    public  function sendNotifications($order_id='')
    {
        $_GET['backend']=true; $print=array();
        if ( $data=$this->functions->getOrder2($order_id)){
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            if ( $json_details !=false){
               $displayOrderHTML= $this->functions->displayOrderHTML(array(
                  'order_id'=>$order_id,
                  'merchant_id'=>$data['merchant_id'],
                  'delivery_type'=>$data['trans_type'],
                  'delivery_charge'=>$data['delivery_charge'],
                  'packaging'=>$data['packaging'],
                  'cart_tip_value'=>$data['cart_tip_value'],
                  'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
                  'card_fee'=>$data['card_fee'],
                  'tax'=>$data['tax'],
                  'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
                  'voucher_amount'=>$data['voucher_amount'],
                  'voucher_type'=>$data['voucher_type']
                  ),$json_details,true);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>"ABN",
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>"Telephone",'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];

            $print[]=array('label'=>"Address",'value'=>$full_merchant_address);
            
            $print[]=array('label'=>"TRN Type",'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>"Payment Type",
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>"Card#",'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>"Paypal Transaction ID",
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>"Reference #",
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>"Payment Ref",
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>"Card #",
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>"TRN Date",
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>"Delivery Date",
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>"Delivery Time",
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?("Yes"):'';
                        $print[]=array(
                         'label'=>"Deliver ASAP",
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>"Deliver to",
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>"Delivery Instruction",
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>"Location Name",
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>"Contact Number",
                      'value'=>$data['contact_phone']
                    );
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>"Change",
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            $to=isset($data['email_address'])?$data['email_address']:'';
            
            /*CHECK IF EURO TAX*/
            if($data['apply_food_tax']==1){             
                $new_total = $this->functions->computeWithTax($displayOrderHTML['raw'], $merchant_id);
                $displayOrderHTML['raw']['total']=$new_total;                                                                          
                $receipt=$this->functions->salesReceiptTax($print,$displayOrderHTML['raw']);
                
                /* custom code starts */
                $receipt1=$this->functions->salesReceiptM($full_merchant_address,$data,$print,$displayOrderHTML['raw']);
                /* custom code ends */          
                
            } else {$receipt=$this->functions->salesReceipt($print,$displayOrderHTML['raw']);
            
            /* custom code starts */
            $receipt1=$this->functions->salesReceiptM($full_merchant_address,$data,$print,$displayOrderHTML['raw']);
            /* custom code ends */
            }
            
            $this->functions->notifyCustomer($data,'',$receipt, $to);
            //FunctionsV3::notifyMerchant($data,Yii::app()->functions->additional_details,$receipt);
            
            /* Custom code starts */
           $this->functions->notifyMerchant2($data,'',$receipt,$receipt1);   
            /* Custom code ends */     
            
            $this->functions->notifyAdmin($data,'',$receipt);
                        
           // FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processemail"));
            //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processsms"));     
                       
            /*PRINTER ADDON*/
       
                  
        }
    }   

    public  function latToAdress($lat='' , $lng='')
    {
        $lat_lng="$lat,$lng";
        $protocol = isset($_SERVER["https"]) ? 'https' : 'http';
        if ($protocol=="http"){
            $api="http://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
        } else $api="https://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
        
        /*check if has provide api key*/
        $key=$this->functions->getOptionAdmin('google_geo_api_key');       
        if ( !empty($key)){
            $api="https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($lat_lng)."&key=".urlencode($key);
        }   
        

        $google_use_curl = $this->functions->getOptionAdmin('google_use_curl');       
                
        if($google_use_curl==2){
            $json=$this->functions->Curl($api,'');
        } else $json=@file_get_contents($api);
        
        if (isset($_GET['debug'])){
            //dump($api);         
        }
        
        $address_out=array();
            
        if (!empty($json)){         
            
            $results = json_decode($json,true);                 
            if(array_key_exists('error_message',(array)$results)){
                 throw new Exception( $results['status']);
            }
                        
            $parts = array(
              'address'=>array('street_number','route'),              
              'city'=>array('locality','political','sublocality','administrative_area_level_2','administrative_area_level_1'),
              'state'=>array('administrative_area_level_1'),
              'zip'=>array('postal_code'),
              'country'=>array('country'),
            );          
            if (!empty($results['results'][0]['address_components'])) {
              $ac = $results['results'][0]['address_components'];             
              foreach($parts as $need=>$types) {
                foreach($ac as &$a) {                                     
                      if (in_array($a['types'][0],$types)){
                          if (in_array($a['types'][0],$types)){
                              if($need=="address"){
                                  if(isset($address_out[$need])) {
                                     $address_out[$need] .= " ".$a['long_name'];
                                  } else $address_out[$need]= $a['long_name'];
                              } else $address_out[$need] = $a['long_name'];                           
                          }
                      } elseif (empty($address_out[$need])) $address_out[$need] = '';   
                }
              }
              
              if(!empty($results['results'][0]['formatted_address'])){
                 $address_out['formatted_address']=$results['results'][0]['formatted_address'];
              }           
              return $address_out;
            }               
        }           
        return false;
    }  


    public  function getCartEarningPoints($cart=array(), $sub_total=0 , $mtid='')
    {
        /*CHECK IF ADMIN ENABLED THE POINTS SYSTEM*/
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return false;
        }
        
        /*CHECK IF MERCHANT HAS DISABLED POINTS SYSTEM*/
        if(isset($cart[0])){
            if(isset($cart[0]['merchant_id'])){             
                $mt_disabled_pts=$this->functions->getOption('mt_disabled_pts',$mtid);
                if($mt_disabled_pts==2){
                    return false;
                }
            }       
        }
        
        $points=0;

        if (is_array($cart) && count($cart)>=1){
            $earning_type =  $this->PointsProgram->getBasedEarnings($mtid);
            
            if($earning_type==1){
                foreach ($cart as $val) {
                    $temp_price=explode("|",$val['price']);                                                     
                    if($val['discount']>=0.01){
                        $set_price = ($temp_price[0]-$val['discount'])*$val['qty'];
                    } else $set_price = (float)$temp_price[0]*$val['qty'];              
                                    
                    $points+= $this->PointsProgram->getPointsByItem($val['item_id'],$set_price , $mtid);
                }
            } else {                                
                $points+=$this->PointsProgram->getTotalEarningPoints($sub_total,$mtid);                
            }
            
            /*CHECK IF SUBTOTAL ORDER IS ABOVE */
            $pts_earn_above_amount=$this->functions->getOptionAdmin('pts_earn_above_amount');
            
            if(!$this->PointsProgram->isMerchantSettingsDisabled()){
                $mt_pts_earn_above_amount=$this->functions->getOption('mt_pts_earn_above_amount',$mtid);
                if($mt_pts_earn_above_amount>0){
                    $pts_earn_above_amount = $mt_pts_earn_above_amount;
                }
            }
            
            if(is_numeric($pts_earn_above_amount)){
                if($pts_earn_above_amount>$sub_total){
                    $points=0;
                }
            }
                        
            if ($points>0){
                $pts_label_earn=$this->functions->getOptionAdmin('pts_label_earn');
                if(empty($pts_label_earn)){
                    $pts_label_earn = "This order earned {points}";
                }               
                return array(
                  'points_earn'=>$points,
                  
                  'pts_label_earn'=>$pts_label_earn." ".$points
                );
            }
        }
        return false;
    }   
    
public function pointsTotalExpenses($client_id = '')
{
    if (empty($client_id)) {
        return 0;
    }

    $stmt = "
        SELECT SUM(total_points) as total
        FROM mt_points_expenses
        WHERE status = 'active'
        AND client_id = :client_id
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res['total'] ?? 0;
    }

    return 0;
}


public function getTotalEarnPoints($client_id = '', $merchant_id = '')
{
    if (empty($client_id)) {
        return 0;
    }

    $and = " AND (merchant_id = :merchant_id OR trans_type = 'adjustment') ";

    $stmt = "
        SELECT 
            SUM(total_points_earn) as total_earn,
            (
                SELECT SUM(total_points)
                FROM mt_points_expenses
                WHERE status IN ('active', 'adjustment')
                AND client_id = :client_id
                $and
            ) as total_points_expenses
        FROM mt_points_earn
        WHERE status IN ('active', 'adjustment')
        AND client_id = :client_id
        $and
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return ($res['total_earn'] ?? 0) - ($res['total_points_expenses'] ?? 0);
    }

    return 0;
}

    
    public  function checkDeliveryAddress($merchant_id='',$data='')
    {
        if($merchant_info=$this->functions->getMerchantById($merchant_id)){
           $distance_type=$this->functions->getMerchantDistanceType($merchant_id); 
           
           $complete_address=$data['street']." ".$data['city']." ".$data['state']." ".$data['zipcode'];
           if(isset($data['country'])){
                $complete_address.=" ".$data['country'];
           } 
           
           $lat=0; $lng=0;
           
           if ( isset($data['address_book_id'])){
              if ($address_book=$this->functions->getAddressBookByID($data['address_book_id'])){
                $complete_address=$address_book['street'];          
                $complete_address.=" ".$address_book['city'];
                $complete_address.=" ".$address_book['state'];
                $complete_address.=" ".$address_book['zipcode'];
              }
           }
           
           //dump($complete_address);
           
           if (isset($data['map_address_toogle'])){             
                if ($data['map_address_toogle']==2){
                    $lat=$data['map_address_lat'];
                    $lng=$data['map_address_lng'];
                } else {
                    if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                       $lat=$lat_res['lat'];
                       $lng=$lat_res['long'];
                    }
                }
            } else {                
                if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                   $lat=$lat_res['lat'];
                   $lng=$lat_res['long'];
                }
            }
            
            $distance=$this->functions->getDistanceBetweenPlot(
                $lat,
                $lng,
                $merchant_info['latitude'],$merchant_info['lontitude'],$distance_type
            );  
            
            $distance_type_raw = $distance_type=="M"?"miles":"kilometers";      
            $merchant_delivery_distance=$this->functions->getOption('merchant_delivery_miles',$merchant_id); 
            
           /* if(!empty(FunctionsV3::$distance_type_result)){
                $distance_type_raw=FunctionsV3::$distance_type_result;
            }*/
                        
            //dump($distance);dump($distance_type_raw);
            
            if (is_numeric($merchant_delivery_distance)){
                if ( $distance>$merchant_delivery_distance){
                    if($distance_type_raw=="ft" || $distance_type_raw=="meter" || $distance_type_raw=="mt"){
                       return true;
                    } else {
                        

                        $error = "Sorry but this merchant delivers only with in ".$merchant_delivery_distance." ".$distance_type_raw." your current distance is ".$distance." ".$distance_type_raw;

                        throw new Exception( $error );
                    }                   
                } else {                    
                    $delivery_fee=$this->functions->getMerchantDeliveryFee(
                                  $merchant_id,
                                  $merchant_info['delivery_charges'],
                                  $distance,
                                  $distance_type_raw);
                    if($delivery_fee){
                        return array(
                          'delivery_fee'=>$delivery_fee,
                          'distance'=>$distance,
                          'distance_unit'=>$distance_type_raw
                        );
                    }
                    return true;
                }
            } else {
                // OK DO NOT CHECK DISTAMCE                 
                $delivery_fee=$this->functions->getMerchantDeliveryFee(
                              $merchant_id,
                              $merchant_info['delivery_charges'],
                              $distance,
                              $distance_type_raw);
                if($delivery_fee){
                    return array(
                      'delivery_fee'=>$delivery_fee,
                      'distance'=>$distance,
                      'distance_unit'=>$distance_type_raw
                    );
                }
                return true;
            }          
        } else {
             throw new Exception( "Merchant not found" );
        }
    }


    public  function clearCartParamaters($device_id='')
    {
        if($resp=$this->getCart($device_id)){         
           $cart_id = $resp['cart_id'];
           $params=array(
              'voucher_details'=>'',
              'street'=>'',
              'city'=>'',
              'state'=>'',
              'zipcode'=>'',
              'delivery_instruction'=>'',
              'location_name'=>'',
              'contact_phone'=>'',
              'tips'=>0,
              'points_earn'=>0,
              'points_apply'=>0,
              'points_amount'=>0,
              'country_code'=>'',
              'delivery_fee'=>0,
              'min_delivery_order'=>0,
              'date_modified'=>$this->functions->dateNow(),
              'distance'=>'',
              'distance_unit'=>'',
              'delivery_lat'=>'',
              'delivery_long'=>'',
              'state_id'=>0,
              'city_id'=>0,
              'area_id'=>0,
           );
           
           $this->functions->updateData("mt_singleapp_cart",$params,'cart_id',$cart_id);
        }
    }
    
    public  function getBannerLink($merchant_id='')
    {
        $banner = $this->functions->getOption('singleapp_banner',$merchant_id);
        if(!empty($banner)){
            $banner = json_decode($banner,true);
            if(is_array($banner) && count($banner)>=1){
                $new_banner=array();
                foreach ($banner as $val) {
                    $new_banner[]=$this->functions->websiteUrl()."/upload/$val";
                }
                return $new_banner;
            }
        }
        return false;
    }


    public  function highlight_word( $content, $word ) {
        $replace = '<span class="highlight">' . $word . '</span>'; // create replacement
        $content = str_ireplace( $word, $replace, $content ); // replace content    
        return $content; // return highlighted data
    }
    
    public  function savePoints($device_id='',$client_id='',$merchant_id='', $order_id='',$order_status='')
    {
        /*POINTS ADDON*/
                
            if($res=$this->getCart($device_id , $merchant_id )){
                $points_earn = $res['points_earn'];
                $this->PointsProgram->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);             
                
                if ($res['points_apply']>=0.0001){
                    $this->PointsProgram->saveExpensesPoints(
                      $res['points_apply'],
                      $res['points_amount'],
                      $client_id,
                      $merchant_id,
                      $order_id,
                      ''
                    );
                }
            }
        
    }   
    
    public  function updatePoints($order_id='', $order_status='')
    {
        
            
                $this->PointsProgram->updateOrderBasedOnStatus($order_status,$order_id);
            
        
    }


  public function orderHistory($order_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_order_history
        WHERE order_id = :order_id
        ORDER BY id DESC
    ");
    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            return $result;
        }
    }

    return false;
}

public  function platFormList()
    {
        return array(
            'android'=>("android"),
            'ios'=>('ios'),
            'all'=>("all platform")
        );
    }
    
public function getPagesByID($page_id = '', $fields = '*')
{
    $stmt = $this->db->prepare("
        SELECT $fields
        FROM mt_singleapp_pages
        WHERE page_id = :page_id
        AND status IN ('publish')
        LIMIT 0,1
    ");
    $stmt->bindParam(':page_id', $page_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $res = $res[0];
            return $res;
        }
    }

    return false;
}

public function getPages($merchant_id = '')
{
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_singleapp_pages
        WHERE merchant_id = :merchant_id
        AND status IN ('publish')
        ORDER BY sequence ASC
    ");
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}
       
    
    public  function canReviewOrder($order_status='',$website_review_type='', $review_baseon_status='')
    {           
        /*if($website_review_type==2){                  
            if(!empty($review_baseon_status)){
               $review_baseon_status = json_decode($review_baseon_status,true);
               if (is_array($review_baseon_status) && count($review_baseon_status)>=1){
                  if (in_array($order_status,$review_baseon_status)){
                      return true;
                  }
               }
            } else return true;
        }
        return false;*/
        
        if(!empty($review_baseon_status)){
           $review_baseon_status = json_decode($review_baseon_status,true);
           if (is_array($review_baseon_status) && count($review_baseon_status)>=1){
              if (in_array($order_status,$review_baseon_status)){
                  return true;
              }
           }
        } else return true;
    }


  public function getItemCountByCategory($category_id = '')
{
    $stmt = "
        SELECT COUNT(*) AS total
        FROM mt_item
        WHERE category LIKE :category
    ";
    
    $query = $this->db->prepare($stmt);
    $likeCategory = '%"'.$category_id.'"%';
    $query->bindParam(':category', $likeCategory);
    $query->execute();
    
    $res = $query->fetch(PDO::FETCH_ASSOC);
    if ($res) {
        return $res['total'];
    }
    return 0;
}

public function checkAddressBook($client_id = '', $lat = '', $lng = '', $id = '')
{
    $and = '';
    if ($id > 0) {
        $and .= " AND id <> :id";
    }

    $stmt = "
        SELECT * FROM mt_address_book
        WHERE client_id = :client_id
        AND latitude = :lat
        AND longitude = :lng
        $and
        LIMIT 0,1
    ";
    
    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id);
    $query->bindParam(':lat', $lat);
    $query->bindParam(':lng', $lng);
    
    if ($id > 0) {
        $query->bindParam(':id', $id);
    }

    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        return $res;
    }
    return false;
}

    
    public  function getDistanceResultsType($merchant_id='')
    {
        $distance_results_type = $this->functions->getOption('singleapp_distance_results',$merchant_id);
        if(empty($distance_results_type)){
            return 1;
        }
        if(!is_numeric($distance_results_type)){
            return 1;
        }
        return $distance_results_type;
    }
    
    public  function checkDeliveryAddresNew( $merchant_id='', $lat='', $lng='' )
    {
        if(!is_numeric($merchant_id)){
            throw new Exception( ("invalid merchant id") );
        }
        if(!is_numeric($lat)){
            throw new Exception( ("invalid latitude") );
        }
        if(!is_numeric($lng)){
            throw new Exception( ("invalid longtitude") );
        }
        
        $distance=0;
        $distance_results_type = $this->getDistanceResultsType($merchant_id);    
        
        if($merchant_info=$this->functions->getMerchantById($merchant_id)){
           $distance_type=$this->functions->getMerchantDistanceType($merchant_id); 
           $merchant_lat = $merchant_info['latitude'];
           $merchant_lng = $merchant_info['lontitude'];
                                   
           if($distance_results_type==1){
              $distance = $this->getLocalDistance($distance_type,$lat,$lng,$merchant_lat,$merchant_lng);           
           } else {        
               $distance=$this->functions->getDistanceBetweenPlot(
                    $lat,
                    $lng,
                    $merchant_lat,$merchant_lng,$distance_type
               );      
           }       
           
           if(isset($_GET['debug'])){
              //dump("distance=>$distance");
           }
                   
           $distance_type_raw = $distance_type=="M"?"miles":"kilometers";       
           $merchant_delivery_distance=$this->functions->getOption('merchant_delivery_miles',$merchant_id);   
           
           /*if(!empty(FunctionsV3::$distance_type_result)){
              $distance_type_raw=FunctionsV3::$distance_type_result;
           }*/
           
           /*dump("distance=>$distance");
           dump("merchant_delivery_distance=>$merchant_delivery_distance");
           dump("distance_type_raw=>$distance_type_raw");*/
           
           if (is_numeric($merchant_delivery_distance)){
               if ( $distance>$merchant_delivery_distance){
                   if($distance_type_raw=="ft" || $distance_type_raw=="meter" || $distance_type_raw=="mt"){
                       return true;
                    } else {
                        
                        $error = "Sorry but this merchant delivers only with in ".$merchant_delivery_distance." ".($distance_type_raw)." your current distance is ".$distance." ".($distance_type_raw);

                        throw new Exception( $error );
                    }       
               } else {                                    
                   /*$delivery_fee=FunctionsV3::getMerchantDeliveryFee(
                                  $merchant_id,
                                  $merchant_info['delivery_charges'],
                                  $distance,
                                  $distance_type_raw);*/
                    $delivery_fee = $this->getShippingRate($merchant_id,
                      $merchant_info['delivery_charges'],
                      $distance,
                      $distance_type_raw
                    );
                                       
                    //dump("delivery_fee=>$delivery_fee");              
                    if($delivery_fee){
                        return array(
                          'delivery_fee'=>$delivery_fee,
                          'distance'=>$distance,
                          'distance_unit'=>$distance_type_raw
                        );
                    }
                    return true;
               }
           } else {
               // OK DO NOT CHECK DISTAMCE 
               $delivery_fee=$this->functions->getMerchantDeliveryFee(
                              $merchant_id,
                              $merchant_info['delivery_charges'],
                              $distance,
                              $distance_type_raw);
                if($delivery_fee){
                    return array(
                      'delivery_fee'=>$delivery_fee,
                      'distance'=>$distance,
                      'distance_unit'=>$distance_type_raw
                    );
                }
                return true;
           }
           
        } else throw new Exception( ("Merchant not found") );
    } 


    public  function getLocalDistance($unit='', $lat1='',$lon1='', $lat2='', $lon2='')
    {                 
          $theta = $lon1 - $lon2;
          $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
         
          $dist = acos($dist);
          $dist = rad2deg($dist);
          $miles = $dist * 60 * 1.1515;
          $unit = strtoupper($unit);
          
          $resp = 0;
          
          if ($unit == "K") {
              $resp = ($miles * 1.609344);
          } else if ($unit == "N") {
              $resp = ($miles * 0.8684);
          } else {
              $resp = $miles;
          }       
          
          if($resp>0){
             $resp = number_format($resp,1,'.','');
          }
          
          return $resp;
    }
    
  public function getBookAddressByClientID($client_id = '', $street = '', $city = '', $state = '')
{
    if (empty($street)) {
        return false;
    }
    if (empty($city)) {
        return false;
    }
    if (empty($state)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_address_book
        WHERE client_id = :client_id
        AND street = :street
        AND city = :city
        AND state = :state
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id);
    $query->bindParam(':street', $street);
    $query->bindParam(':city', $city);
    $query->bindParam(':state', $state);

    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }
    return false;
}
      
    
    public function getVoucherMerchant($client_id = '', $voucher_code = '', $merchant_id = '')
{
    $stmt = "
        SELECT a.*,
        (
            SELECT COUNT(*) FROM mt_order
            WHERE voucher_code = :voucher_code_1
            AND client_id = :client_id
            LIMIT 0,1
        ) as found,

        (
            SELECT COUNT(*) FROM mt_order
            WHERE voucher_code = :voucher_code_2
            LIMIT 0,1
        ) as number_used

        FROM mt_voucher_new a
        WHERE voucher_name = :voucher_code_3
        AND merchant_id = :merchant_id
        AND status IN ('publish','published')
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);

    $query->bindParam(':voucher_code_1', $voucher_code);
    $query->bindParam(':client_id', $client_id);
    $query->bindParam(':voucher_code_2', $voucher_code);
    $query->bindParam(':voucher_code_3', $voucher_code);
    $query->bindParam(':merchant_id', $merchant_id);

    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }
    return false;
}

public function getVoucherAdmin($client_id = '', $voucher_code = '')
{
    $stmt = "
        SELECT a.*,
        (
            SELECT COUNT(*) FROM mt_order
            WHERE voucher_code = :voucher_code_1
            AND client_id = :client_id
            LIMIT 0,1
        ) as found,

        (
            SELECT COUNT(*) FROM mt_order
            WHERE voucher_code = :voucher_code_2
            LIMIT 0,1
        ) as number_used

        FROM mt_voucher_new a
        WHERE voucher_name = :voucher_code_3
        AND voucher_owner = 'admin'
        AND status IN ('publish','published')
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);

    $query->bindParam(':voucher_code_1', $voucher_code);
    $query->bindParam(':client_id', $client_id);
    $query->bindParam(':voucher_code_2', $voucher_code);
    $query->bindParam(':voucher_code_3', $voucher_code);

    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }
    return false;
}
          
    
   public function pointsEarnByMerchant($client_id = '')
{
    $stmt = "
        SELECT SUM(a.total_points_earn) AS total_earn,
        (
            SELECT SUM(total_points)
            FROM mt_points_expenses
            WHERE client_id = :client_id_1
            AND a.status IN ('active','adjustment')
        ) AS total_expenses
        FROM mt_points_earn a
        WHERE client_id = :client_id_2
        AND a.status IN ('active','adjustment')
        AND merchant_id > 0
        GROUP BY merchant_id
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id_1', $client_id);
    $query->bindParam(':client_id_2', $client_id);

    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_earn = 0;
        $total_expenses = 0;
        foreach ($res as $val) {
            $total_earn += floatval($val['total_earn']);
            $total_expenses += floatval($val['total_expenses']);
        }
        $total = $total_earn - $total_expenses;
        return $total;
    }
    return 0;
}


public  function paginateLimit()
    {
        return 10;
    }   
    
    public  function getMerchantBackground($merchant_id='',$set_image='')
    {       
        $image_url = $this->functions->websiteUrl()."/assets_singleapp/images/default_bg.jpg";
        $merchant_photo_bg = $this->functions->getOption('merchant_photo_bg',$merchant_id);        
        if(!empty($merchant_photo_bg)){                     
            if ( file_exists($this->functions->uploadPath()."/$merchant_photo_bg")){
                $image_url = $this->functions->websiteUrl()."/upload/$merchant_photo_bg";
            }
        } else {
            if(!empty($set_image)){
                $image_url = $this->functions->websiteUrl()."/assets_singleapp/images/$set_image";
            }
        }       
        return $this->functions->prettyUrl($image_url);
    }
    
    public  function BookingTabs()
    {    
        $data =array();
        $data[]=array(
          'tab'=>"all",
          'label'=>("All")
        );
        $data[]=array(
          'tab'=>"pending",
          'label'=>("Pending")
        );
        $data[]=array(
          'tab'=>"approved",
          'label'=>("Approved")
        );
        $data[]=array(
          'tab'=>"denied",
          'label'=>("Denied")
        );
        return $data;
    }


    public  function OrderTabs()
    {    
        $data =array();
        $data[]=array(
          'tab'=>"all",
          'label'=>("All")
        );
        $data[]=array(
          'tab'=>"processing",
          'label'=>("Processing")
        );
        $data[]=array(
          'tab'=>"completed",
          'label'=>("Completed")
        );
        $data[]=array(
          'tab'=>"cancelled",
          'label'=>("Cancelled")
        );
        return $data;
    }
    
    public  function getOrderTabsStatus($merchant_id,$tab='')
    {
        $status = ''; $and='';
        switch ($tab) {
            case "processing":                  
                $status=$this->functions->getOption('singleapp_order_processing',$merchant_id);
                break;
        
            case "completed":               
                $status=$this->functions->getOption('singleapp_order_completed',$merchant_id); 
                break;
                
            case "cancelled":               
                $status=$this->functions->getOption('singleapp_order_cancelled',$merchant_id); 
                break;
                        
            default:
                break;
        }   
        
        if(!empty($status)){
            $status = json_decode($status,true);            
            if(is_array($status) && count((array)$status)>=1){
                foreach ($status as $val) {
                      $and .= "'" . addslashes($val) . "',";
                }
                $and = substr($and,0,-1);
                $and = "AND a.status IN ($and)";
            }
        }
        return $and;
    }    
    
   public function orderDetails($order_id = '')
{
    // Prepare SQL statement with placeholders
    $stmt = "
        SELECT 
            a.order_id,
            a.merchant_id,
            a.client_id,
            a.trans_type,
            a.status,
            a.status AS status_raw,
            a.payment_type,
            a.payment_type AS payment_type_raw,
            b.restaurant_name AS merchant_name,
            b.logo,
            c.review,
            c.rating,
            c.as_anonymous
        FROM
            mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        LEFT JOIN mt_review c ON a.order_id = c.order_id
        WHERE a.order_id = :order_id
        LIMIT 0,1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the order_id to the placeholder
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // If there is a result, return the first row, otherwise return false
    if ($res) {
        return $res[0];
    }
    return false;
}

    
  public function getReviewReplied($review_id = '', $merchant_id = '')
{
    // If merchant_id is not provided or invalid, set it to -1
    if ($merchant_id <= 0) {
        $merchant_id = -1;
    }

    $data = array();

    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT 
            a.merchant_id,
            a.review,
            a.parent_id,
            a.reply_from,
            a.date_created,
            (
                SELECT logo 
                FROM mt_merchant
                WHERE merchant_id = :merchant_id
                LIMIT 0,1
            ) AS logo
        FROM
            mt_review a
        WHERE
            a.parent_id = :review_id
        AND
            a.status = 'publish'
        ORDER BY a.id ASC
        LIMIT 0,10
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':review_id', $review_id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            // Get the image URL
            $val['logo'] = $this->getImage($val['logo']);
            
            // Translate the date
            $pretyy_date = $val['date_created'];
            $pretyy_date = $this->functions->translateDate($pretyy_date);
            $val['date_posted'] = $pretyy_date;
            
            // Set customer name
            $val['customer_name'] = "Replied By " . $val['reply_from'];
            
            // Remove unnecessary fields
            unset($val['merchant_id']);
            unset($val['reply_from']);
            unset($val['date_created']);
            
            // Add to data array
            $data[] = $val;
        }
    }

    return $data;
}


public function GetBookingDetails($booking_id = '', $client_id = '')
{
    // Prepare the SQL query with placeholders
    $stmt = "
        SELECT * FROM
        mt_bookingtable
        WHERE
        client_id = :client_id
        AND
        booking_id = :booking_id
        LIMIT 0,1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // Optionally, strip slashes (if needed)
        
        return $res;
    }

    return false;
}

    
    public function getRecentLocationByID($device_uiid = '', $lat = '', $lng = '', $mode = 'address')
{
    // Prepare the SQL query with placeholders
    $stmt = "
        SELECT * FROM
        mt_singleapp_recent_location
        WHERE
        device_uiid = :device_uiid
        AND
        latitude = :latitude
        AND
        longitude = :longitude
        AND
        search_mode = :search_mode
        LIMIT 0,1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
    $query->bindParam(':latitude', $lat, PDO::PARAM_STR);
    $query->bindParam(':longitude', $lng, PDO::PARAM_STR);
    $query->bindParam(':search_mode', $mode, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

    
    public function clearRecentLocation($device_uiid = '')
{
    if (!empty($device_uiid)) {
        // Get the search mode (from the searchMode function)
        $search_resp = $this->searchMode();
        $search_mode = $search_resp['search_mode'];

        // Prepare the DELETE query
        $stmt = "
            DELETE FROM mt_singleapp_recent_location
            WHERE 
            device_uiid = :device_uiid
            AND search_mode = :search_mode
        ";

        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the parameters
        $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
        $query->bindParam(':search_mode', $search_mode, PDO::PARAM_STR);

        // Execute the query
        $query->execute();
    }
}

    
    public function getCustomerByID($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    // Prepare the SELECT query
    $stmt = "
        SELECT * FROM mt_client
        WHERE client_id = :client_id
        LIMIT 0,1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public function isItemFavorite($client_id = '', $item_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    // Prepare the SELECT query
    $stmt = "
        SELECT * FROM mt_favorite_item
        WHERE client_id = :client_id
        AND item_id = :item_id
        LIMIT 0,1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

    
    public  function addItemFavorite($client_id='',$item_id='', $category_id='')
    {
        if(empty($client_id)){
            return false;
        }
        
        
        $params = array(
          'client_id'=>$client_id,
          'item_id'=>$item_id,
          'category_id'=>$category_id,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        if(!$this->isItemFavorite($client_id,$item_id)){
            $this->functions->insertData("mt_favorite_item",$params);
        }
        
    }
    
   public function removeItemFavorite($client_id = '', $item_id = '')
{
    if (empty($client_id) || empty($item_id)) {
        return false;
    }

    // Prepare the DELETE query
    $stmt = "
        DELETE FROM mt_favorite_item
        WHERE client_id = :client_id
        AND item_id = :item_id
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    return true;
}

    
   public function removeItemFavoriteByID($client_id = '', $id = '')
{
    if (empty($client_id) || empty($id)) {
        return false;
    }

    // Prepare the DELETE query
    $stmt = "
        DELETE FROM mt_favorite_item
        WHERE client_id = :client_id
        AND id = :id
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    return true;
}

    
  public function getItemFavorite($client_id = '', $id = '')
{
    if (empty($client_id) || empty($id)) {
        return false;
    }

    // Prepare the SELECT query
    $stmt = "
        SELECT * FROM mt_favorite_item
        WHERE client_id = :client_id
        AND id = :id
        LIMIT 0, 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Check if the result exists
    if ($res) {
        return $res;
    }

    return false;
}

    
    public  function getLangList()
    {
        $lang=array();
        if ($res=$this->functions->getLanguageList(false)){
            foreach ($res as $val) {
                $val=str_replace(" ","_",$val);
                $lang[]=$val;
            }               
        }
        return $lang;
    }



    public function getTitlePages($merchant_id = '')
{
    if (empty($merchant_id)) {
        return false;
    }

    $titles = "page_id, title, icon";

    $stmt = "
        SELECT $titles 
        FROM mt_singleapp_pages
        WHERE status = 'publish'
        AND merchant_id = :merchant_id
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    return !empty($res) ? $res : false;
}

    
    
    public  function searchMode()
    {
        $search_mode = $this->functions->getOptionAdmin('home_search_mode');
        $location_mode = $this->functions->getOptionAdmin('admin_zipcode_searchtype');
        if(empty($search_mode)){
           $search_mode = 'address';    
        } elseif ($search_mode=="postcode"){
            $search_mode='location';
        }
        return array(
          'search_mode'=>$search_mode,
          'location_mode'=>$location_mode,
        );
    }
    
    public  function isLocation()
    {
        $mode = $this->searchMode();
        if($mode=="location"){
            return true;
        }
        return false;
    }

    public function getLastOrderSMS($mobile = '')
{
    if (empty($mobile)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_order_sms
        WHERE mobile = :mobile
        ORDER BY id DESC
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':mobile', $mobile, PDO::PARAM_STR);
    $query->execute();

    $res = $query->fetch(PDO::FETCH_ASSOC);
    return $res ? $res : false;
}

    
    public function clearCartByCustomerID($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $stmt = "
        DELETE FROM mt_singleapp_cart
        WHERE device_id IN (
            SELECT device_uiid FROM mt_singleapp_device_reg
            WHERE client_id = :client_id
        )
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->execute();
}
 
    
    public  function ContactUsData($merchant_id='')
    {               
        $contact_field = $this->functions->getOption('singleapp_contactus_fields',$merchant_id);
        if(!empty($contact_field)){
            $contact_field = json_decode($contact_field,true);
        } else {
            $contact_field = array('name','email');
        }    
        return array(        
         'contact_field'=>$contact_field
        );
    }

    public function prettyBadge($status = '')
{
    $status = strtolower(trim($status));

    if ($status == "pending") {
        return '<span class="badge badge-primary">' . $status . '</span>';
    } elseif ($status == "process") {
        return '<span class="badge badge-success">' . $status . '</span>';
    } elseif (preg_match("/properly set in/i", $status)) {
        return '<span class="badge badge-danger">' . $status . '</span>';
    } elseif (preg_match("/caught/i", $status)) {
        return '<span class="badge badge-danger">' . $status . '</span>';
    } elseif (preg_match("/failed/i", $status)) {
        return '<span class="badge badge-danger">' . $status . '</span>';
    } elseif (preg_match("/no/i", $status)) {
        return '<span class="badge badge-secondary">' . $status . '</span>';
    } else {
        return '<span class="badge badge-success">' . $status . '</span>';
    }
}

    
    public  function locationAccuracyList()
    {
        return array(
          //'REQUEST_PRIORITY_NO_POWER'=>self::t("REQUEST_PRIORITY_NO_POWER"),
          'REQUEST_PRIORITY_LOW_POWER'=>"REQUEST_PRIORITY_LOW_POWER",
          'REQUEST_PRIORITY_BALANCED_POWER_ACCURACY'=>"REQUEST_PRIORITY_BALANCED_POWER_ACCURACY",
          'REQUEST_PRIORITY_HIGH_ACCURACY'=>"REQUEST_PRIORITY_HIGH_ACCURACY",
        );
    }   
    
    public  function MenuType()
    {
        return array(
          1=>"Menu 1",
          2=>"Menu 2 - Classic menu", 
          3=>"Menu 3 - column",          
        );
    }
    
    public  function mobileCodeList()
    {
        $mobile_countrycode =$this->functions->mobilecountry_code();
        $data = array();
        $data[] = "Please select...";
                
        foreach ($mobile_countrycode as $key=>$val) {                       
            

             $data[$val['code']]=$val['name']."+".$val['code'];

        }
        
        return $data;       
    }
    
    public  function trackingTheme()
    {
        return array(
          1 => "Theme 1",
          2 => "Theme 2",
        );
    }

    public function getMaxPage($merchant_id = '')
{
    $stmt = "
        SELECT MAX(sequence) as max 
        FROM mt_singleapp_pages
        WHERE merchant_id = :merchant_id
    ";
    
    $query = $this->db->prepare($stmt);
    $query->execute([':merchant_id' => $merchant_id]);
    
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return ($res['max'] >= 1) ? $res['max'] + 1 : 1;
    }

    return false;
}
 
    
    public function getPageByTitle($merchant_id = '', $title = '')
{
    if (empty($title)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_singleapp_pages
        WHERE title = :title
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':title' => $title,
        ':merchant_id' => $merchant_id
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}
  
    
    public function getPageByID($page_id = '')
{
    if (empty($page_id)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_singleapp_pages
        WHERE page_id = :page_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':page_id' => $page_id]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}
   
    
    public function getMerchantList()
{
    $stmt = "
        SELECT merchant_id, restaurant_name 
        FROM mt_merchant
        WHERE status IN ('active')
        ORDER BY restaurant_name ASC
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $data = [];
        foreach ($res as $val) {
            $data[$val['merchant_id']] = clearString($val['restaurant_name']);
        }
        return $data;
    }

    return false;
}

    
  public function getMerchantNames($merchant_id = array())
{
    $in_merchant_id = '';
    if (is_array($merchant_id) && count($merchant_id) >= 1) {
        foreach ($merchant_id as $id) {
            $in_merchant_id .= "'" . $id . "',";
        }
        $in_merchant_id = substr($in_merchant_id, 0, -1);
    }

    $stmt = "
        SELECT 
        group_concat(restaurant_name SEPARATOR '<br/>') as merchant_name
        FROM mt_merchant
        WHERE
        merchant_id IN ($in_merchant_id)
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $this->functions->clearString($res['merchant_name']);
    }
    return '';
}



public  function getStartUpBanner($merchant_id='')
    {
        $data = array();
        $banner = $this->functions->getOption('singleapp_startup_banner',$merchant_id);   
        $banner = !empty($banner)?json_decode($banner,true):array();
        if(is_array($banner) && count($banner)>=1){
            foreach ($banner as $val) {
                $data[] = $this->getImage($val);
            }
        }
        return $data;
    }
    
public function getAddressBookDefault($client_id = '')
{
    if ($client_id > 0) {
        $stmt = "SELECT a.*, b.contact_phone             
                 FROM mt_address_book a
                 LEFT JOIN mt_client b ON a.client_id = b.client_id
                 WHERE a.client_id = " . ($client_id) . "
                 AND a.as_default = '2'
                 LIMIT 0,1";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res[0];
        }
    }
    return false;
}

    
    public  function getRecentLocation($device_uiid='', $lat='', $lng='')
    {
        if(empty($device_uiid)){
           return false;
        }    
        if(empty($lat)){            
           return false;
        }    
        
             
        return false;
    }    
    
    public  function setAutoAddress($merchant_id='',$client_id='', $current_lat=0, $current_lng=0 , $device_uiid='' )
    {       
        if($merchant_id<=0){
            throw new Exception( ("invalid merchant id") );
        }
                    
        $address_use = array();
        if($client_id>0){
            $address_use = $this->getAddressBookDefault($client_id);           
        } else {                        
            if ($res_recent = $this->getRecentLocation($device_uiid,$current_lat,$current_lng)){               
                if(empty($res_recent['street'])){
                    if($resp_lat_address = $this->functions->latToAdress($current_lat,$current_lng)){
                        $res_recent['street']=$resp_lat_address['address'];
                        $res_recent['city']=$resp_lat_address['city'];
                        $res_recent['state']=$resp_lat_address['state'];
                        $res_recent['zipcode']=$resp_lat_address['zip'];                    
                    }
                }               
                if(!empty($res_recent['street'])){
                    $address_use = $res_recent;
                }
            }
        }       
        
        if(is_array($address_use) && count($address_use)>=1){
            
            if(empty($address_use['latitude'])){
                throw new Exception( ("invalid latitude") );      
            }
            if(empty($address_use['longitude'])){
                throw new Exception( ("invalid longitude") );     
            }
            if(empty($address_use['street'])){
                throw new Exception( ("invalid street") );        
            }           
            
            //dump($address_use);           
            $lat = $address_use['latitude']; $lng = $address_use['longitude'];          
            /*dump($merchant_id);
            dump("lat=>$lat lng=>$lng");*/
            $resp = $this->checkDeliveryAddresNew($merchant_id,$lat, $lng);            
            
            if(is_array($resp) && count((array)$resp)>=1){
                //dump($resp);
                $params = array(
                  'street'=>isset($address_use['street'])?$address_use['street']:'',
                  'city'=>isset($address_use['city'])?$address_use['city']:'',
                  'state'=>isset($address_use['state'])?$address_use['state']:'',
                  'zipcode'=>isset($address_use['zipcode'])?$address_use['zipcode']:'',               
                  'location_name'=>isset($address_use['location_name'])?$address_use['location_name']:'',
                  'contact_phone'=>isset($address_use['contact_phone'])?$address_use['contact_phone']:'',
                  'country_code'=>isset($address_use['country_code'])?$address_use['country_code']:'',
                  'delivery_lat'=>$lat,
                  'delivery_long'=>$lng,                  
                );
                
                $min_fees=0;
                $params['delivery_fee']=0;
                $params['min_delivery_order']=0;
                
                if(isset($resp['delivery_fee'])){
                    $params['delivery_fee']=$resp['delivery_fee'];                                                  
                }
                if($resp['distance']>0.001){
                   /*GET MINIMUM ORDER TABLE*/
                   $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$merchant_id);
                   $min_fees=$this->functions->getMinOrderByTableRates(
                       $merchant_id,
                       $resp['distance'],
                       $resp['distance_unit'],
                       $merchant_minimum_order
                    );                  
                    $params['min_delivery_order'] = $min_fees;
                }
                if(!is_numeric($params['min_delivery_order'])){
                    $params['min_delivery_order']=0;
                }   
                
                $params['distance'] = $resp['distance'];
                $params['distance_unit'] = $resp['distance_unit'];              
                                                                                                
                return $params;
                
            } else throw new Exception( $resp );        
        } else throw new Exception( ("address invalid") );        
    } 

 public function getShippingRate($merchant_id = '', $default_fee = '', $distance = '', $unit = '')
{
    $distance = is_numeric($distance) ? number_format($distance, 3) : 0;
    $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
    $charge = $default_fee;

    if ($shipping_enabled == 2) {
        if ($unit == "ft" || $unit == "mm" || $unit == "mt") {
            // do nothing
        } else {
            switch (strtolower($unit)) {
                case "miles":
                case "mi":
                    $unit = 'mi';
                    break;
                case "kilometers":
                case "km":
                    $unit = 'km';
                    break;
                case "ft":
                    $unit = 'mi';
                    $distance = 1;
                    break;
            }

            $stmt = "
                SELECT * FROM
                mt_shipping_rate
                WHERE
                merchant_id = " . ($merchant_id) . "
                AND 
                shipping_units = " . ($unit) . "  
                AND
                distance_from <= " . ($distance) . " AND distance_to >= " . ($distance) . "
                LIMIT 0,1
            ";

            $query = $this->db->prepare($stmt);
            $query->execute();
            $resp = $query->fetchAll(PDO::FETCH_ASSOC);

            if ($resp) {
                $resp = $resp[0];
            } else {
                $stmt2 = "
                    SELECT * FROM
                    mt_shipping_rate
                    WHERE
                    merchant_id = " . ($merchant_id) . "
                    AND 
                    shipping_units = " . ($unit) . "                                   
                    ORDER BY distance_to DESC
                    LIMIT 0,1
                ";
                $query2 = $this->db->prepare($stmt2);
                $query2->execute();
                $res = $query2->fetchAll(PDO::FETCH_ASSOC);

                if ($res) {
                    $res = $res[0];
                    if ($distance >= $res['distance_to']) {
                        $resp = $res;
                    }
                }
            }

            if (is_array($resp) && count($resp) >= 1) {
                if ($resp['distance_price'] >= 0.0001) {
                    return $resp['distance_price'];
                }
            }
        }
    }

    if ($charge > 0.0001) {
        return $charge;
    }

    return false;
}


public  function settingsMenu()
    {

        $app_folder=Config::$baseUrl."/singlemerchant";

        $menu[] = array(
          'label'=>"API Settings",
          'link'=>$app_folder."/index/merchant_settings",
          'id'=>'merchant_settings'
        );      
        $menu[] = array(
          'label'=>"Application Settings",
          'link'=>$app_folder."/index/settings_application",
          'id'=>'settings_application'
        );      
        $menu[] = array(
          'label'=>"App startup",
          'link'=>$app_folder."/index/settings_startup",
          'id'=>'settings_startup'
        );
        $menu[] = array(
          'label'=>"Home banner",
          'link'=>$app_folder."/index/settings_homebanner",
          'id'=>'settings_homebanner'
        );
        $menu[] = array(
          'label'=>"Social login",
          'link'=>$app_folder."/index/settings_social",
          'id'=>'settings_social'
        );
        $menu[] = array(
          'label'=>"Android Settings",
          'link'=>$app_folder."/index/settings_android",
          'id'=>'settings_android'
        );
        $menu[] = array(
          'label'=>"FCM",
          'link'=>$app_folder."/index/settings_fcm",
          'id'=>'settings_fcm'
        );
        $menu[] = array(
          'label'=>"Pages",
          'link'=>$app_folder."/index/settings_pages",
          'id'=>'settings_pages'
        );
        $menu[] = array(
          'label'=>"Contact us",
          'link'=>$app_folder."/index/settings_contactus",
          'id'=>'settings_contactus'
        );
        return $menu;
    }


 public function registeredDevice($data = array(), $status = 'active')
{
    $client_id = isset($data['client_id']) ? $data['client_id'] : '';
    $device_id = isset($data['device_id']) ? $data['device_id'] : '';
    $device_platform = isset($data['device_platform']) ? $data['device_platform'] : '';
    $device_uiid = isset($data['device_uiid']) ? $data['device_uiid'] : '';
    $code_version = isset($data['code_version']) ? $data['code_version'] : '';      
    $device_platform = strtolower($device_platform);
    $merchant_id = isset($data['merchant_id']) ? $data['merchant_id'] : '';     

    $params = array(
        'merchant_id' => $merchant_id,
        'device_id' => $device_id,
        'device_platform' => $device_platform,
        'device_uiid' => $device_uiid,
        'status' => $status,
        'code_version' => $code_version,
        'date_created' => $this->functions->dateNow(),
        'ip_address' => $_SERVER['REMOTE_ADDR']
    );
    if ($client_id > 0) {
        $params['client_id'] = (integer) $client_id;
    }    

    if (!empty($device_uiid)) {
        $stmt = "
            SELECT * FROM
            mt_singleapp_device_reg
            WHERE 
            device_uiid = :device_uiid           
            LIMIT 0,1           
        ";                  

        $query = $this->db->prepare($stmt);
        $query->execute([':device_uiid' => $device_uiid]);
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            unset($params['date_created']);
            $params['date_modified'] = $this->functions->dateNow();   

            $this->functions->updateData("mt_singleapp_device_reg", $params, 'id', (integer) $res['id']);
        } else {
            $this->functions->insertData("mt_singleapp_device_reg", $params);
        }
    }       
}

    
    public  function getMapProvider()
    {       
        
        return $this->functions->getMapProvider();
    }  


    public  function timePastByTransaction($transaction_type='')
    {
        $error = '';
        switch ($transaction_type)
        {
            case "delivery":
            case "pickup":
            case "dinein":
                
                $error = "Sorry but you have selected ".$transaction_type." time that already past";
                break;
                            
            default:        
                $error = ("Sorry but you have selected time that already past");
                break;  
        }
        
        return $error;
    }   
    
 public function getReceiptByID($order_id = 0, $client_id = 0)
{
    $and = '';
    $order_id = (integer)$order_id;
    $client_id = (integer)$client_id;
    if ($client_id > 0) {
        $and = " AND a.client_id = :client_id ";
    }

    $stmt = "
        SELECT a.*,
        CONCAT(b.first_name, ' ', b.last_name) AS full_name,
        b.location_name,
        CONCAT(b.street, ' ', b.area_name, ' ', b.city, ' ', b.state, ' ', b.zipcode) AS full_address,
        b.contact_phone,
        b.contact_phone AS customer_phone,
        b.opt_contact_delivery,
        b.contact_email AS email_address,
        b.contact_email AS customer_email,
        c.restaurant_name AS merchant_name,
        c.contact_phone AS merchant_contact_phone
        FROM mt_order a
        LEFT JOIN mt_order_delivery_address b ON a.order_id = b.order_id
        LEFT JOIN mt_merchant c ON a.merchant_id = c.merchant_id
        WHERE a.order_id = :order_id
        $and
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':order_id' => $order_id, ':client_id' => $client_id]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // FIXED OLD DATA
        if (empty(trim($res['full_name']))) {
            $stmt2 = "
                SELECT 
                CONCAT(first_name, ' ', last_name) AS full_name,
                contact_phone
                FROM mt_client
                WHERE client_id = :client_id
            ";

            $query2 = $this->db->prepare($stmt2);
            $query2->execute([':client_id' => $res['client_id']]);
            $res2 = $query2->fetch(PDO::FETCH_ASSOC);

            if ($res2) {
                $res['full_name'] = $res2['full_name'];
                $res['contact_phone'] = $res2['contact_phone'];
            }
        }

        return $res;
    }
    return false;
}
      
    
    public function ReOrderGetInfo($order_id = '')
{
    $order_id = (integer)$order_id;

    $stmt = "
        SELECT a.*,
        b.restaurant_name,
        b.status AS merchant_status,
        b.is_ready,
        b.service
        FROM mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE a.order_id = :order_id
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':order_id' => $order_id]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public  function canCancel($date_created='', $days=0, $hours=0, $minutes=0)
    {
        if(!empty($date_created)){
            $date_created = date("Y-m-d g:i:s a",strtotime($date_created));         
            $date_now=date('Y-m-d g:i:s a');            
            $time_diff=$this->functions->dateDifference($date_created,$date_now);          
            if(is_array($time_diff) && count($time_diff)>=1){               
                if($days>$time_diff['days']){                   
                    return true;
                } elseif ( $hours>$time_diff['hours'] ) {
                    return true;                    
                } elseif ( $hours>=$time_diff['hours']){                    
                    if($minutes<$time_diff['minutes']){                     
                        return false;
                    } else return true;
                } elseif ( $minutes>=$time_diff['minutes'] ){                   
                    return true;                    
                }
                                
            } else return true;
        }
        return false;
    }   
    
    public function getDeviceByUIID($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "
        SELECT * FROM mt_singleapp_device_reg 
        WHERE device_uiid = :device_uiid
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':device_uiid' => $device_uiid]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}
   
    
    public function getDeviceByID($id = '')
{
    if (empty($id)) {
        return false;
    }

    $stmt = "
        SELECT a.*, b.first_name, b.last_name
        FROM mt_singleapp_device_reg a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE a.id = :id
        LIMIT 0, 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':id' => $id]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

public function OrderTrigger($order_id = '', $status = '', $remarks = '', $trigger_type = 'order')
{   
    $lang = 'en'; 
    
    if ($order_id > 0) {
        $stmt = "
            SELECT order_id FROM mt_singleapp_order_trigger
            WHERE order_id = :order_id
            AND status = 'pending'
            LIMIT 0, 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([':order_id' => $order_id]);
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if (!$res) {
            $params = array(
                'order_id' => $order_id,
                'order_status' => $status,
                'remarks' => $remarks,
                'language' => $lang,
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'trigger_type' => $trigger_type
            );              
            
            $this->functions->insertData("mt_singleapp_order_trigger", $params);
        }
    }
}
   
    
    public  function consumeUrl($url='')
    {
         $is_get_working = true;
         try {
             $response = @file_get_contents($url);           
             if (isset($http_response_header)) {
                if (!in_array('HTTP/1.1 200 OK',(array)$http_response_header) && !in_array('HTTP/1.0 200 OK',(array)$http_response_header)) {
                    $is_get_working=false;
                }
             }
         } catch (Exception $e) {
            $is_get_working = false;
         }
         
         if(!$is_get_working){
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $result = curl_exec($ch);
            curl_close($ch);
         }
    }


    public  function inventoryEnabled($merchant_id='')
    {       
        if(empty($merchant_id)){
            return false;
        }   
        if(!is_numeric($merchant_id)){
            return false;
        }   
        
        $inv_enabled = false; 
               
                $inventory_live = $this->functions->getOption('inventory_live',$merchant_id);
                if($inventory_live==1){
                    $inv_enabled = true;
                    
                }
            
       
        return $inv_enabled;
    }
    
    public  function getMerchantServices($services_id=0)
    {       
        switch ($services_id) {
            case 2:
                return array(
                   'delivery'=>$this->functions->translation("default","Delivery"),
                );
                break;
            case 3:
                return array(
                    'pickup'=>$this->functions->translation("default","Pickup")          
                );
                break;
                
            case 4: 
               return array(
                   'delivery'=>$this->functions->translation("default","Delivery"),
                   'pickup'=>$this->functions->translation("default","Pickup"),
                   'dinein'=>"Dinein"
                );
               break;
               
            case 5: 
               return array(
                   'delivery'=>$this->functions->translation("default","Delivery"),                       
                   'dinein'=>"Dinein"
                );
               break;
               
            case 6: 
               return array(
                   'pickup'=>$this->functions->translation("default","Pickup"),
                   'dinein'=>"Dinein"
                );
               break;   
              
            case 7: 
               return array(                       
                   'dinein'=>"Dinein"
                );
               break;       
                  
            default:
                return array(
                   'delivery'=>$this->functions->translation("default","Delivery"),
                   'pickup'=>$this->functions->translation("default","Pickup") 
                );
                break;
        }   
    }   
                   

              





    
 



     


 



    








  
























   


 







  


    

  






    


    








 




























	
	
	
	
	
  			
	    
}
/*END CLASS*/