<?php
class WindcaveController extends Controller
{

    public function __construct()
    {
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->mobileWrapper = new mobileWrapper();
    }




public function sendRequest_windcave($url, $method = 'POST', $data = [],$merchant_id) {

        
        $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);  
        if($merchant_type=='1'){
          $paymode=$this->functions->getOption('windcave_mode',$merchant_id);
          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOption('wind_user_id_sandbox', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key_sandbox', $merchant_id);

          }else{
          $apiUsername = $this->functions->getOption('wind_user_id', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key', $merchant_id);
          }


        }else{
          $paymode=$this->functions->getOptionAdmin('windcave_mode');

          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id_sandbox');
          $apiKey = $this->functions->getOptionAdmin('wind_key_sandbox');
          }else{
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id');
          $apiKey = $this->functions->getOptionAdmin('wind_key');
          }
        }

       



        if($paymode=='Sandbox'){
     $url = "https://uat.windcave.com/api/v1/sessions";    
   }else{
      $url = "https://sec.windcave.com/api/v1/sessions";
   }


        

        $auth = base64_encode("{$apiUsername}:{$apiKey}");
        
        $headers = [
            "Authorization: Basic $auth",
            "Content-Type: application/json",
        ];
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        
        $response = curl_exec($ch);



        curl_close($ch);
        
        return json_decode($response, true);
    }

 
 public function testwaseem()
{
    $sessionId= "0000030008195823033bf1217f54ccdc";

    $url = 'https://uat.windcave.com/api/v1/sessions/' . urlencode($sessionId);
    $resp = $this->windcave_request('GET', $url);

    if ($resp['status'] == 200) {
        $data = json_decode($resp['body'], true);
        $txn = $data['transactions'][0] ?? null;
        if ($txn) {
            $approved = $txn['authorised'];
            $code     = $txn['responseCode'] ?? null;
            $text     = $txn['responseText'] ?? null;

            if ($approved) {
                echo "Approved, Txn ID: {$txn['id']}\n";
            } else {
                echo "Declined: Code {$code} ({$text})\n";
            }
        }
    }
}

public function windcave_request($method, $url, $body = null) {
    $username = "TahiTechLtdREST_dev"; // store in env
    $password = "3e716efe4c23640151835aff1bb144d0cf843a71f7d23e47d489f54134c09649";

    $ch = curl_init();
    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($method));
    if ($body !== null) {
        $json = json_encode($body);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        $headers[] = 'Content-Length: ' . strlen($json);
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $resp = curl_exec($ch);

    
    $data = json_decode($resp, true);

    print_r($data);die();

    $info = curl_getinfo($ch);
    $err = curl_error($ch);
    curl_close($ch);

    return ['status' => $info['http_code'], 'body' => $resp, 'error' => $err];
}



    
    public function index()
    {

          
      $order_id=$_GET['id'];



      $order_token=$order_id;
      $data = $this->functions->getOrderInfoByToken_appside($order_token);

      $_SESSION['windcave_redirect_url']=$_GET['redirect_url'];

       $_SESSION['windcave_cancel_url']=$_GET['cancel_url'];

       


      $merchant_id = $data['merchant_id'];

      

      $returnUrl = Config::$baseUrl . "/webappv2/windcave/verify?id=".$order_id;  // The URL for success page
      $notificationUrl = Config::$baseUrl . "/webappv2/windcave/windcave_notification";

      if ($this->functions->isClientLogin()){
        $cancel_url = $this->functions->websiteUrl() . "/webappv2/windcave/cancel";
      }else{
        $cancel_url = $this->functions->websiteUrl() . "/webappv2/windcave/cancel";
      }

      


      $currency = $this->functions->getCurrencyCode();
      $apiEndpoint = "https://uat.windcave.com/api/v1/sessions";
      $error = '';

      if ($data = $this->functions->getOrderInfoByToken_appside($order_token)) {

        $merchant_id=$data['merchant_id'];

         $_SESSION['order_id']= $data['order_id'];
         
         $price=$data['total_w_tax'];

         $credentials = $this->functions->getCredentials_windcave($merchant_id);
          if ($credentials['card_fee'] >= 0.0001) {
         
          $card_fee = $price*$credentials['card_fee']/100;
          $price=$price;
          }



         $price = number_format((float)$price, 2, '.', '');
         $merchantReference="Order#".$order_id;
         

	$redirect_url_cancel=$_SESSION['windcave_cancel_url'];
      $cancelUrl=$redirect_url_cancel; 

        $data = [
    "type" => "purchase",
    "amount" => $price, // This would be dynamic in your case, such as $price
    "currency" => $currency, // You might want to replace this with your dynamic currency code, such as $currency
    "merchantReference" => $merchantReference, // Replace this with a dynamic reference if needed
    "callbackUrls" => [
        "approved" => $returnUrl, // Replace with your actual success URL
        "declined" => $cancelUrl,   // Replace with your actual failure URL
        "cancelled" => $cancelUrl // Replace with your actual cancel URL
    ],
    "notificationUrl" => $notificationUrl // Replace with your actual notification URL
];


        $sessionResponse = $this->sendRequest_windcave($apiEndpoint, 'POST', $data,$merchant_id);

        



         if (isset($sessionResponse['links'][1]['href'])) {
            // Redirect to the card entry view (second step)
           
          $payment_id = $sessionResponse['id'];
           $this->functions->update_payment_id($order_id,$payment_id);

           $formUrl = $sessionResponse['links'][1]['href'];




          header("Location: $formUrl");
    exit();
            /*$data_for_view = [
                    'sessionResponse' => $sessionResponse
                ];


            $this->view('merchant/windcave_buy', $data_for_view, 'layouts/merchant_tpl');*/

        } else {
            // Handle errors if session creation fails

           $error = "Error: " . $sessionResponse['message'];
        }



      }else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
      }

     

      if (!empty($error)) {

        

        

          $redirect_link=Config::$baseUrl . "/webappv2/windcave/error?error=".$error;
            header('Location: ' . $redirect_link);


    }

        
    }




    public function verify()
{

// Logic for processing success response
        // e.g., check status, display success page, etc.
        $transactionId = $_GET['sessionId'] ?? null; // Get the transaction ID from the URL



        $status = $_GET['status'] ?? null; // Get the payment status
        
        
        
         $order_id=isset($_GET['id'])?$_GET['id']:''; 
         //++++duplication chk
         $stmt = $this->db->prepare("SELECT * FROM mt_order WHERE order_id = :order_id");
        $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $stmt->execute();

         $result = $stmt->fetch(PDO::FETCH_ASSOC);

         $merchant_id=$result['merchant_id'];

         if($result['status']=="paid"){
          

          $redirect=$_SESSION['windcave_redirect_url'];
       
         



          echo '<script type="text/javascript">';
          echo 'window.location.href = "' . $redirect . '";';
          echo '</script>';

          exit;
          
         }

        //---duplication chk
         $params_logs=array( 
                    'order_id'=>$order_id,  
                    'payment_type'=>"windcave", 
                    'payment_reference'=>$transactionId, 
                    'raw_response'=>'', 
                    'date_created'=>$this->functions->dateNow(),  
                    'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                  );                          
                    
                     

         $this->functions->insertData('mt_payment_order', $params_logs);


         $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
         if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


         $params_update=array( 
                      'status'=>'paid', 
                      'date_modified'=>$this->functions->dateNow(), 
                      'order_number'=>$order_number, 
                      'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                    );    

                    
         $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);
         $this->mobileWrapper->executeAddons($order_id);
         $this->mobileWrapper->sendNotification($order_id); 
            // Payment successful
           
            

            
                                 
                     

                     
                      
                    

                    $_SESSION['payment_process']=1;

                    
                    $order=$this->functions->getOrder($order_id);
                    $client_id=$order['client_id'];

                    $this->mobileWrapper->clearCartByCustomerID($client_id);
                    $msg="Payment successfull";


                    $redirect_link=Config::$baseUrl . "/webappv2/windcave/success?message=".$msg;
                    header('Location: ' . $redirect_link);



                    exit();

    
}





public function windcave_notification() {
    // Windcave sends standard POST fields, not JSON
    $responseData = $_POST;

    // Save raw response for debugging
    $params = array(
        'response' => json_encode($responseData),
    );
    $this->functions->insertData("mt_response", $params);

    // Windcave usually returns Success = 1 for approved
    if (isset($responseData['Success']) && $responseData['Success'] == '1') {
        $transactionId = $responseData['TxnId'] ?? '';

        // Update your DB
        // $this->db->query("UPDATE orders SET status='paid' WHERE transaction_id=?", [$transactionId]);

        echo json_encode(["status" => "success"]);
        exit;
    } else {
        $errorMessage = $responseData['ResponseText'] 
            ?? $responseData['errorMessage'] 
            ?? "Unknown error";

        error_log("Windcave payment failure: " . $errorMessage);

        echo json_encode(["status" => "failed", "message" => $errorMessage]);
        exit;
    }
}














    public function success()
{

  $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"paid",
                        'remarks'=>"success"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 
    unset($_SESSION['order_id']);


    $redirect_url_w = $_SESSION['windcave_redirect_url'];

    echo '<script type="text/javascript">';
    echo 'window.location.href = "' . $redirect_url_w . '";';
    echo '</script>';
    exit;
}




    public function error()
    {

       $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"not paid",
                        'remarks'=>"error"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 
    unset($_SESSION['order_id']);

        $error = isset($_GET['error'])?$_GET['error']:'';
        if(!empty($error)){
            echo $error;
        } else echo "undefined error";
    }
    
    public function cancel()
    {

      
  $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"not paid",
                        'remarks'=>"cancel"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 
    unset($_SESSION['order_id']);

      $redirect_url_cancel=$_SESSION['windcave_cancel_url'];

      echo '<script type="text/javascript">';
    echo 'window.location.href = "' . $redirect_url_cancel . '";';
    echo '</script>';
    exit;

      
      //$redirect_turl=$this->functions->websiteUrl()."/order-now/order/payment_option";

      //$redirect_turl=$this->functions->websiteUrl()."/order-now/order/payment_option";


      //header("Location: " . $redirect_url_cancel);
      //exit;
        
    }
    
    
    
    
    
}
/*end class*/