<?php
class mobileWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        
        //$this->CronWrapper = new CronWrapper();
        

    }

	public function uploadPath()
	{
		return Config::$baseUrl."/upload";
	}
	
	public  function platFormList()
    {
        return array(
            1=>"android",
            2=>"ios",
            3=>'all platform'
        );
    }


    public  function parseValidatorError($error='')
    {
        $error_string='';
        if (is_array($error) && count($error)>=1){
            foreach ($error as $val) {
                $error_string.="$val\n";
            }
        }
        return $error_string;       
    }       
    
    public  function generateUniqueToken($length,$unique_text=''){    
        $key = '';
        $keys = array_merge(range(0, 9), range('a', 'z'));  
        for ($i = 0; $i < $length; $i++) {
            $key .= $keys[array_rand($keys)];
        }   
        return $key.md5($unique_text);
    }



    public  function getImage($image='', $image_set='', $disabled_default_image=false,$addon_path='')
    {       
        $url='';
        $default="mobile-default-logo.png";
        $path_to_upload=Config::$baseUrl."/upload/$addon_path";  

        //echo"jj".$image;die();

                            
        
        if (empty($image)){
            $image=$this->functions->getOptionAdmin('mobile_default_image_not_available');
        }                   
        
        
        $default_image =Config::$baseUrl."/assets_mobileapp/images/$default";  

        if(!empty($image_set)){
           
            $default_image = Config::$baseUrl."/assets_mobileapp/images/$image_set"; 
        }
        
        if (!empty($image)){            
                                       
                $default=$image;                            
                if(empty($addon_path)){
                  $url = Config::$baseUrl."/upload/$default";
                } else {
                   $url = Config::$baseUrl."/upload/$addon_path/$default";  
                }
            
        } else {            
            if($disabled_default_image){
                $url='';
            } else $url=$default_image;         
        }
        return $url;
    }

     public  function foodPromoSort()
    {
        return array(
          'discount'=>"Discount",
          'item_name'=>"Name",
        );
    }


  public function getTitlePages()
{
    $titles = "page_id, title, icon";

    $stmt = "
        SELECT $titles 
        FROM mt_mobile2_pages
        WHERE status = 'publish'
    ";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Execute the query
        $query->execute();

        // Fetch all results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Return the results if found
        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle exceptions (logging, rethrowing, or returning an error response)
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}


    public function getPageByTitle($title = "")
{
    if (empty($title)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_mobile2_pages
        WHERE title = :title
        LIMIT 1
    ";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the title parameter
        $query->bindParam(':title', $title, PDO::PARAM_STR);

        // Execute the query
        $query->execute();

        // Fetch the single row
        $res = $query->fetch(PDO::FETCH_ASSOC);

        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle exceptions (logging or rethrowing)
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}


public function getPageByID($page_id = "")
{
    if (empty($page_id)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_mobile2_pages
        WHERE page_id = :page_id
        LIMIT 1
    ";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the page_id parameter
        $query->bindParam(':page_id', $page_id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the single row
        $res = $query->fetch(PDO::FETCH_ASSOC);

        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle exceptions (logging or rethrowing)
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}



public function getMaxPage()
{
    $stmt = "
        SELECT MAX(sequence) AS max 
        FROM mt_mobile2_pages
    ";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Execute the query
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        // Check the result and calculate the max value
        if ($res && isset($res['max'])) {
            return ($res['max'] >= 1) ? $res['max'] + 1 : 1;
        }
        return 1; // Default to 1 if no rows are found
    } catch (PDOException $e) {
        // Handle exceptions (logging or rethrowing)
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}


public function deletePage($page_id = '')
{
    if ($page_id >= 1) {
        $stmt = "
            DELETE FROM mt_mobile2_pages
            WHERE page_id = :page_id
        ";

        try {
            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the `page_id` parameter to prevent SQL injection
            $query->bindParam(':page_id', $page_id, PDO::PARAM_INT);

            // Execute the query
            $query->execute();

            return true; // Return true on successful deletion
        } catch (PDOException $e) {
            // Handle exceptions (logging or rethrowing)
            error_log("Database Error: " . $e->getMessage());
            return false;
        }
    }
    return false; // Return false if invalid `page_id`
}



public function prettyBadge($status = '')
{
    $status = strtolower(trim($status));

    if ($status === "pending") {
        return '<span class="badge badge-primary">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    } elseif ($status === "process") {
        return '<span class="badge badge-success">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    } elseif (preg_match("/properly set in/i", $status)) {
        return '<span class="badge badge-danger">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    } elseif (preg_match("/caught/i", $status)) {
        return '<span class="badge badge-danger">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    } elseif (preg_match("/failed/i", $status)) {
        return '<span class="badge badge-danger">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    } else {
        return '<span class="badge badge-success">' . htmlspecialchars($status, ENT_QUOTES, 'UTF-8') . '</span>';
    }
}


public function getDeviceByID($id = '')
{
    if (empty($id)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_mobile2_device_reg_view
        WHERE id = :id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);

    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return $result;
        }
    }

    return false;
}

public function getDeviceByUIID($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "
        SELECT * 
        FROM mt_mobile2_device_reg
        WHERE device_uiid = :device_uiid
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);

    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return $result;
        }
    }

    return false;
}


public function getAllDeviceByClientID($client_id = '', $trigger_id = '')
{
    if (empty($client_id) || empty($trigger_id)) {
        return false;
    }

    $stmt = "
        SELECT 
            a.device_uiid,
            a.device_id,
            a.device_platform
        FROM
            mt_mobile2_device_reg a
        WHERE   
            a.client_id = :client_id
            AND a.push_enabled = '1'
            AND a.status = 'active'
            AND a.client_id NOT IN (
                SELECT client_id
                FROM mt_mobile2_push_logs
                WHERE client_id = a.client_id
                AND device_uiid = a.device_uiid
                AND trigger_id = :trigger_id
            )
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':trigger_id', $trigger_id, PDO::PARAM_INT);

    if ($query->execute()) {
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    return false;
}


public function getCustomerByToken($token = '', $check_active = true)
{
    if (empty($token)) {
        return false;
    }

    $and = '';
    if ($check_active) {
        $and = " AND status = :status";
    }

    $stmt = "
        SELECT * 
        FROM mt_client
        WHERE token = :token
        $and
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':token', $token, PDO::PARAM_STR);

    if ($check_active) {
        $status = 'active';
        $query->bindParam(':status', $status, PDO::PARAM_STR);
    }

    if ($query->execute()) {
        return $query->fetch(PDO::FETCH_ASSOC);
    }

    return false;
}


public function loginByEmail($email = '', $password = '', $merchant_id = '')
{

    if (!empty($email) && !empty($password) && !empty($merchant_id)) {            
        $stmt = "
            SELECT * FROM
            mt_client
            WHERE
            email_address = '$email'
            AND password = '" . md5($password) . "'
            AND merchant_id = '$merchant_id'                     
            LIMIT 1
        ";              
        
        $query = $this->db->query($stmt);

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            if (empty($res['token'])) {
                $token = $this->generateUniqueToken(15, $res['client_id']);
                
                $updateStmt = "
                    UPDATE mt_client
                    SET 
                        token = '$token',
                        social_strategy = 'mobileapp2',
                        last_login = '" . $this->functions->dateNow() . "'
                    WHERE
                        client_id = '{$res['client_id']}'
                ";

                $this->db->query($updateStmt);
            }
            return $res;
        }
    }
    return false;
}


public function loginByEmail_webapp($email = '', $password = '', $merchant_id = '')
{
    if (!empty($email) && !empty($password) && !empty($merchant_id)) {

        try {
            // Step 1: Determine merchant set
            $branchMerchants = [];
            $stmtBranch = $this->db->prepare("SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?)) LIMIT 1");
            $stmtBranch->execute([$merchant_id]);
            $branchRow = $stmtBranch->fetch(PDO::FETCH_ASSOC);

            if ($branchRow && !empty($branchRow['merchant_id'])) {
                $branchMerchants = json_decode($branchRow['merchant_id'], true);
            } else {
                $branchMerchants = [ (int)$merchant_id ];
            }

            // Step 2: Build branch condition
            $jsonBranchConditions = [];
            foreach ($branchMerchants as $id) {
                $jsonBranchConditions[] = "JSON_CONTAINS(branch, '$id')";
            }
            $branchCondition = implode(' OR ', $jsonBranchConditions);

            // Step 3: Prepare safe values
            $hashed_password = md5($password);
            $safeEmail = $this->db->quote($email);
            $safePass = $this->db->quote($hashed_password);

            // Step 4: Query mt_client with updated merchant check
            $sql = "
                SELECT * FROM mt_client
                WHERE email_address = $safeEmail
                AND password = $safePass
                
                AND status = 'active'
                AND ($branchCondition)
                LIMIT 1
            ";

            $stmt = $this->db->query($sql);

            if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
                if (empty($res['token'])) {
                    $token = $this->generateUniqueToken(15, $res['client_id']);
                    $updateStmt = "
                        UPDATE mt_client
                        SET 
                            token = '$token',
                            social_strategy = 'mobileapp2',
                            last_login = '" . $this->functions->dateNow() . "'
                        WHERE
                            client_id = '{$res['client_id']}'
                    ";
                    $this->db->query($updateStmt);
                }
                return $res;
            }

        } catch (PDOException $e) {
            // Optional: log $e->getMessage()
            return false;
        }
    }

    return false;
}









public function loginByEmail_check($email = '',$merchant_id = '')
{
    if (!empty($email) && !empty($merchant_id)) {            
        $stmt = "
            SELECT * FROM
            mt_client
            WHERE
            email_address = '$email'
            AND merchant_id = '$merchant_id'                     
            LIMIT 1
        ";              
        
        $query = $this->db->query($stmt);

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            
            return true;
        }return false;
    }return false;
}


public function loginByMobile_webapp($contact_phone = '', $password = '', $merchant_id = '')
{
    if (!empty($contact_phone) && !empty($password) && !empty($merchant_id)) {
        try {
            // Step 1: Determine the list of merchant_ids related to this branch
            $branchMerchants = [];
            $stmtBranch = $this->db->prepare("SELECT merchant_id FROM mt_branches WHERE JSON_CONTAINS(merchant_id, JSON_QUOTE(?)) LIMIT 1");
            $stmtBranch->execute([$merchant_id]);
            $branchRow = $stmtBranch->fetch(PDO::FETCH_ASSOC);

            if ($branchRow && !empty($branchRow['merchant_id'])) {
                $branchMerchants = json_decode($branchRow['merchant_id'], true);
            } else {
                $branchMerchants = [ (int)$merchant_id ];
            }

            // Step 2: Build the JSON_CONTAINS condition for the mt_client.branch field
            $jsonBranchConditions = [];
            foreach ($branchMerchants as $id) {
                $jsonBranchConditions[] = "JSON_CONTAINS(branch, '$id')";
            }
            $branchCondition = implode(' OR ', $jsonBranchConditions);

            // Step 3: Prepare safe values
            $likePhone = $this->db->quote($contact_phone);
            $hashedPassword = md5($password);
            $safePass = $this->db->quote($hashedPassword);

            // Step 4: Run the login query
            $sql = "
                SELECT * FROM mt_client
                WHERE contact_phone LIKE $likePhone
                AND password = $safePass
                
                AND status = 'active'
                AND ($branchCondition)
                LIMIT 1
            ";

            $query = $this->db->query($sql);

            if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
                // Step 5: Set token if not already set
                if (empty($res['token'])) {
                    $token = $this->generateUniqueToken(15, $res['client_id']);

                    $updateStmt = "
                        UPDATE mt_client
                        SET 
                            token = :token,
                            social_strategy = :social_strategy,
                            last_login = :last_login
                        WHERE
                            client_id = :client_id
                    ";

                    $updateQuery = $this->db->prepare($updateStmt);
                    $socialStrategy = "mobileapp2";
                    $lastLogin = $this->functions->dateNow();

                    $updateQuery->bindParam(':token', $token, PDO::PARAM_STR);
                    $updateQuery->bindParam(':social_strategy', $socialStrategy, PDO::PARAM_STR);
                    $updateQuery->bindParam(':last_login', $lastLogin, PDO::PARAM_STR);
                    $updateQuery->bindParam(':client_id', $res['client_id'], PDO::PARAM_INT);
                    $updateQuery->execute();
                }

                return $res;
            }
        } catch (PDOException $e) {
            // Optional: log $e->getMessage()
            return false;
        }
    }

    return false;
}





public function loginByMobile($contact_phone = '', $password = '',$merchant_id = '')
{
    if (!empty($contact_phone) && !empty($password)) {
        //$contact_phone = str_replace("+", "", $contact_phone);
$likePhone = "$contact_phone"; // You can add '%' if doing partial match
$hashedPassword = md5($password);
$merchant_id = (int)$merchant_id; // Ensure it's an integer to reduce injection risk

$stmt = "
    SELECT * FROM
    mt_client
    WHERE
    contact_phone LIKE '$likePhone'
    AND
    password = '$hashedPassword'
    AND
    merchant_id = $merchant_id
    LIMIT 0,1
";

$query = $this->db->prepare($stmt);

if ($query->execute()) {
            $res = $query->fetch(PDO::FETCH_ASSOC);

           

            if ($res) {
                if (empty($res['token'])) {
                    $token = $this->generateUniqueToken(15, $res['client_id']);

                    $updateStmt = "
                        UPDATE mt_client
                        SET 
                            token = :token,
                            social_strategy = :social_strategy,
                            last_login = :last_login
                        WHERE
                            client_id = :client_id
                    ";

                    $updateQuery = $this->db->prepare($updateStmt);
                    $socialStrategy = "mobileapp2";
                    $lastLogin = $this->functions->dateNow();

                    $updateQuery->bindParam(':token', $token, PDO::PARAM_STR);
                    $updateQuery->bindParam(':social_strategy', $socialStrategy, PDO::PARAM_STR);
                    $updateQuery->bindParam(':last_login', $lastLogin, PDO::PARAM_STR);
                    $updateQuery->bindParam(':client_id', $res['client_id'], PDO::PARAM_INT);
                    $updateQuery->execute();
                }
                return $res;
            }
        }
    }
    return false;
}



public function getAccountByEmail($email_address = '', $merchant_id = '')
{
    if (!empty($email_address) && !empty($merchant_id)) {
        $stmt = "
            SELECT * FROM mt_client
            WHERE email_address = '$email_address'
            AND merchant_id = '$merchant_id'
            LIMIT 1
        ";

        $query = $this->db->query($stmt);

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}



public function getAccountByPhone($contact_phone = '', $merchant_id = '')
{
    if (!empty($contact_phone) && !empty($merchant_id)) {
        $stmt = "
            SELECT * FROM mt_client
            WHERE contact_phone LIKE '$contact_phone'
            AND merchant_id = '$merchant_id'
            LIMIT 1
        ";

        $query = $this->db->query($stmt);

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}



 public function merchantStatus($merchant_id='')
    {
        $is_merchant_open = $this->functions->isMerchantOpen($merchant_id); 
        $merchant_preorder= $this->functions->getOption("merchant_preorder",$merchant_id);
        
        $now=date('Y-m-d');
        $is_holiday=false;
            if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)){  
           if (in_array($now,(array)$m_holiday)){
              $is_merchant_open=false;
           }
        }
        
        if ( $is_merchant_open==true){
            if ( $this->functions->getOption('merchant_close_store',$merchant_id)=="yes"){
                $is_merchant_open=false;    
                $merchant_preorder=false;                           
            }
        }
        
        if ($is_merchant_open){
            $tag = "open";
        } else {
            if ($merchant_preorder){                
                $tag = "pre-order";
            } else {            
                $tag = "close";
            }
        }      
        return $tag;  
    }


    public  function getMerchantBackground($merchant_id='',$set_image='')
    {       
        $image_url = $this->functions->websiteUrl()."/assets_mobileapp/images/default_bg.jpg";
        $merchant_photo_bg = $this->functions->getOption('merchant_photo_bg',$merchant_id);        
        if(!empty($merchant_photo_bg)){                     
           
                $image_url = $this->functions->websiteUrl()."/upload/$merchant_photo_bg";
            
        } else {
            if(!empty($set_image)){
                $image_url = $this->functions->websiteUrl()."/assets_mobileapp/images/$set_image";
            }
        }       
        return $this->functions->prettyUrl($image_url);
    }


    public function getOffersByMerchantNew($merchant_id = '')
{
    $offer_list = array();
    $offer = '';

    if (!empty($merchant_id)) {
        $stmt = "
            SELECT * FROM
            mt_offers
            WHERE
            status IN ('publish', 'published')
            AND now() >= valid_from AND now() <= valid_to
            AND merchant_id = :merchant_id
            ORDER BY valid_from ASC
            LIMIT 0, 50
        ";

        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        if ($query->execute()) {
            $res = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach ($res as $val) {
                $applicable_to_list = '';
                if (isset($val['applicable_to'])) {
                    $applicable_to = json_decode($val['applicable_to'], true);
                    if (is_array($applicable_to) && count($applicable_to) >= 1) {
                        foreach ($applicable_to as $applicable_to_val) {
                            $applicable_to_list .= ($applicable_to_val) . ",";
                        }
                        $applicable_to_list = rtrim($applicable_to_list, ',');
                    }
                }

                $percentage = number_format($val['offer_percentage'], 0);

                if (!empty($applicable_to_list)) {
                    $offer = $percentage . " percent off over amount" . $this->functions->prettyPrice($val['offer_price']) . " if transaction" . $applicable_to_list;
                } else {
                    $offer = $percentage . " percent off over amount" . $this->functions->prettyPrice($val['offer_price']);
                }

                $offer_list[] = array(
                    'raw' => number_format($val['offer_percentage'], 0) . "%" . "OFF",
                    'full' => $offer,
                    'valid_from' => $val['valid_from'],
                    'valid_to' => $val['valid_to'],
                     'offer_image'=>$val['offer_image'],
                );
            }
            return $offer_list;
        }
    }

    return false;
}



public function getTotalCuisine($cuisine_id = '', $query_distance = '')
{
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS      
        a.merchant_id,
        a.status,
        a.is_ready,
        a.delivery_distance_covered,
        ($query_distance) AS distance  -- Wrap the subquery properly
        FROM mt_merchant a
        HAVING distance < a.delivery_distance_covered       
        AND a.status = 'active'
        AND a.is_ready = '2'
        AND a.merchant_id IN (
            SELECT merchant_id
            FROM mt_cuisine_merchant
            WHERE cuisine_id = $cuisine_id
        )
        LIMIT 0,1
    ";



    $query = $this->db->query($stmt);  // Direct execution since variables are inserted directly

    if ($query->fetch(PDO::FETCH_ASSOC)) {
        $countQuery = $this->db->query("SELECT FOUND_ROWS() AS total_records");
        $result = $countQuery->fetch(PDO::FETCH_ASSOC);
        return $result['total_records'] ?? 0;
    }

    return 0;
}



public function getTotalCuisineByLocation($cuisine_id = '', $location_mode = 0, $data = array())
{
    $location_mode = (int) $location_mode;
    $cuisine_id = (int) $cuisine_id;
    $and = "";    

    $state_id = isset($data['state_id']) ? $data['state_id'] : '';
    $city_id = isset($data['city_id']) ? $data['city_id'] : '';
    $area_id = isset($data['area_id']) ? $data['area_id'] : '';
    $postal_code = isset($data['postal_code']) ? $data['postal_code'] : '';

    // Generate location filter query
    $and .= $this->queryLocation((int) $location_mode, array(
        'state_id' => $state_id,
        'city_id' => $city_id,
        'area_id' => $area_id,
        'postal_code' => $postal_code,
    ));

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS      
        a.merchant_id,
        a.status,
        a.is_ready      
        FROM mt_merchant a
        WHERE a.status = 'active'
        AND a.is_ready = '2'
        AND a.merchant_id IN (
            SELECT merchant_id
            FROM mt_cuisine_merchant
            WHERE cuisine_id = :cuisine_id
        )       
        $and
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':cuisine_id', $cuisine_id, PDO::PARAM_INT);
    $query->execute();

    if ($query->rowCount() > 0) {
        $countQuery = $this->db->query("SELECT FOUND_ROWS() AS total_records");
        $result = $countQuery->fetch(PDO::FETCH_ASSOC);
        return $result['total_records'] ?? 0;
    }

    return 0;
}



    public  function queryLocation($location_mode=0,$data=array())
    {
        $query='';
        /*dump($location_mode);
        dump($data);*/
        switch ($location_mode) {
            case 1:
                $query=" AND a.merchant_id IN (
                        select merchant_id 
                        from
                        mt_location_rate
                        where
                        city_id=".($data['city_id'])."
                        and
                        area_id=".($data['area_id'])."
                    ) ";
                break;
        
            case 2:
                $query = "
                AND a.merchant_id IN (
                    select merchant_id 
                    from
                    mt_location_rate
                    where
                    state_id=".($data['state_id'])."
                    and
                    city_id=".($data['city_id'])."                 
                ) 
                ";
                break;
                
            case 3: 
               $query = "
                AND a.merchant_id IN (
                    select merchant_id 
                    from
                    mt_view_location_rate
                    where
                    city_id=".($data['city_id'])."
                    and
                    postal_code=".($data['postal_code'])."                 
                ) 
                ";
                break;
            default:
                break;
        }
        return $query;
    }




    public  function unitPretty($unit='')
    {
        $unit_pretty = $unit;
        switch ($unit) {
            case "mi":
            case "M":
                $unit_pretty = "miles";
                break;
        
            case "km":
            case "K":
                $unit_pretty = "kilometers";
                break;
                                
        }
        return $unit_pretty;
    }


    public function getListType()
    {
        return 1;

    }



    public  function getMenuType()
    {
        return 2;

    }


     public  function paginateLimit()
    {
        return 10;
    }   
    
    public  function getDistanceResultsType()
    {
        return 1;
    }



    public  function locationAccuracyList()
    {
        return array(
          //'REQUEST_PRIORITY_NO_POWER'=>self::t("REQUEST_PRIORITY_NO_POWER"),
          'REQUEST_PRIORITY_LOW_POWER'=>"REQUEST_PRIORITY_LOW_POWER",
          'REQUEST_PRIORITY_BALANCED_POWER_ACCURACY'=>"REQUEST_PRIORITY_BALANCED_POWER_ACCURACY",
          'REQUEST_PRIORITY_HIGH_ACCURACY'=>"REQUEST_PRIORITY_HIGH_ACCURACY",
        );
    }
    
    public  function RestaurantListType()
    {
        return array(
          1=>"List 1 - logo on left content right",
          2=>"List 2 - logo on top content bottom",          
          3=>"List 3 - column", 
        );
    }
    
    public  function MenuType()
    {
        return array(
          1=>"Menu 1 - Show all menu in one page",
          2=>"Menu 2 - Classic menu", 
          3=>"Menu 3 - column",          
        );
    }
    
    public  function servicesList()
    {
        return array(
          'delivery'=>"Delivery",
          'pickup'=>"Pickup",
          'dinein'=>"Dinein",
        );
    }


    public  function highlight_word( $content, $word ) {
        $replace = '<span class="highlight">' . $word . '</span>'; // create replacement
        $content = str_ireplace( $word, $replace, $content ); // replace content    
        return $content; // return highlighted data
    }
    
    public  function sortRestaurantList()
    {       
        $list = array(
          'merchant_open_status'=>"Open",
          'restaurant_name'=>"Restaurant name",
          'ratings'=>"Rating",
          'review_count'=>"Most Reviewed",
          'minimum_order'=>"Minimum order",
          'distance'=>"Distance",
        );
        
        return $list;
    }
    
    public  function validateSortRestoList($key='')
    {
        $list = $this->sortRestaurantList();
        if(array_key_exists($key,$list)){
            return array(
               'key'=>$key,
               'name'=>$list[$key]
            );
        } else {
            return array(
              'key'=>'distance',
               'name'=>"Distance"
            );
        }       
    }
    
    public  function sortCuisineList()
    {
        return array(
          'cuisine_name'=>"Cuisine name",
          'sequence'=>"Sequence", 
        );
    }  


     public  function prettySortCuisine($key='')
    {       
        $list = $this->sortCuisineList();
        if(array_key_exists($key,$list)){
            return array(
               'key'=>$key,
               'name'=>$list[$key]
            );
        } else {
            return array(
              'key'=>'cuisine_name',
               'name'=>"Cuisine name"
            );
        }       
    }
    
    public  function validateSort($sortby='')
    {       
        $sort_list_valid = array('asc','desc','ASC','DESC');
        if(!in_array($sortby,$sort_list_valid)){
            $sortby="ASC";
        }
        return $sortby;
    } 

    
     public  function getMerchantGallery($merchant_id='')
    {       
        $data=array();
        if($merchant_id>0){
            $gallery=$this->functions->getOption("merchant_gallery",$merchant_id);
            $gallery=!empty($gallery)?json_decode($gallery):false;                  
            if(is_array($gallery) && count($gallery)>=1){
                foreach ($gallery as $val) {
                    if ( file_exists($this->functions->uploadPath()."/$val")){                       
                        $data[]=$this->functions->websiteUrl()."/upload/$val";
                    }
                }
                if(is_array($data) && count($data)>=1){
                   return $data;
                }
            }
        }
        return 2;
    }
    
    public  function getMerchantBanner($merchant_id='')
    {       
        $data=array();
        if($merchant_id>0){
            $gallery=$this->functions->getOption("merchant_banner",$merchant_id);
            $gallery=!empty($gallery)?json_decode($gallery):false;                  
            if(is_array($gallery) && count($gallery)>=1){
                foreach ($gallery as $val) {
                    if ( file_exists($this->functions->uploadPath()."/$val")){                       
                        $data[]=$this->functions->websiteUrl()."/upload/$val";
                    }
                }
                if(is_array($data) && count($data)>=1){
                   return $data;
                }
            }
        }
        return 2;
    }



     public  function getRestoTabMenu($merchant_id='', $ratings='')
    {       
        $tab_menu = array();
        $tab_menu['menu']=array(
          'page_name'=>"",
          'label'=>"Menu"
        );      
        $tab_menu['about']=array(
          'page_name'=>"about.html",
          'label'=>"About"
        );

        
         
        
        if(isset($ratings['votes'])){
            $tab_menu['reviews']=array(
              'page_name'=>"reviews.html",
              'label'=>"Total reviews ".$ratings['votes']
            );
        } else {
            $tab_menu['reviews']=array(
              'page_name'=>"reviews.html",
              'label'=>"Reviews"
            );
        }
        $tab_menu['location']=array(
          'page_name'=>"location.html",
          'label'=>"Location"
        );
        $tab_menu['book_table']=array(
          'page_name'=>"book_table.html",
          'label'=>"Book Table"
        );
        $tab_menu['photo_gallery']=array(
          'page_name'=>"photo_gallery.html",
          'label'=>"Gallery"
        );
        $tab_menu['information']=array(
          'page_name'=>"information.html",
          'label'=>"Information"
        );
        $tab_menu['promos']=array(
          'page_name'=>"promos.html",
          'label'=>"Promos"
        );

        /*REMOVE MENU*/     
                
        $merchant_tbl_book_disabled = $this->functions->getOptionAdmin('merchant_tbl_book_disabled');
        if($merchant_tbl_book_disabled=="2"){
            unset($tab_menu['book_table']);
        } else {        
            $merchant_table_booking = $this->functions->getOption('merchant_table_booking',$merchant_id);
            if($merchant_table_booking=="yes"){
                unset($tab_menu['book_table']);
            }
        }
                
        $theme_photos_tab = $this->functions->getOptionAdmin('theme_photos_tab');
        if($theme_photos_tab==2){
            unset($tab_menu['photo_gallery']);
        } else {
            $gallery_disabled = $this->functions->getOption('gallery_disabled',$merchant_id);
            if($gallery_disabled=="yes"){
                unset($tab_menu['photo_gallery']);
            }
        }
        
        $theme_hours_tab = $this->functions->getOptionAdmin('theme_hours_tab');
        if($theme_hours_tab==2){
            unset($tab_menu['about']);
        }
        
        $theme_reviews_tab = $this->functions->getOptionAdmin('theme_reviews_tab');
        if($theme_reviews_tab==2){
            unset($tab_menu['reviews']);
        }
                
        $theme_map_tab = $this->functions->getOptionAdmin('theme_map_tab');
        if($theme_map_tab==2){
            unset($tab_menu['location']);
        }
        
        $theme_info_tab = $this->functions->getOptionAdmin('theme_info_tab');
        if($theme_info_tab==2){
            unset($tab_menu['information']);
        }
        
        $theme_promo_tab = $this->functions->getOptionAdmin('theme_promo_tab');
        if($theme_promo_tab==2){
            unset($tab_menu['promos']);
        }
                    
        return $tab_menu;
    }



   public function getCart($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "SELECT * FROM mt_mobile2_cart WHERE device_uiid = :device_uiid LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
    $query->execute();

    return $query->fetch(PDO::FETCH_ASSOC) ?: false;
}

public function clearCart($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "DELETE FROM mt_mobile2_cart WHERE device_uiid = :device_uiid";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
    return $query->execute();
}


 public function getAddressBookByClient($client_id = '')
{
    if (empty($client_id)) {
        return false;
    }

    $stmt = "SELECT 
                CONCAT(street, ' ', city, ' ', state, ' ', zipcode) AS address,
                id, location_name, country_code, as_default
             FROM mt_address_book
             WHERE client_id = :client_id
             AND street <> ''
             ORDER BY street ASC";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->execute();

    return $query->fetchAll(PDO::FETCH_ASSOC) ?: false;
}



public  function getCartEarningPoints($cart=array(), $sub_total=0 , $mtid='')
    {
        /*CHECK IF ADMIN ENABLED THE POINTS SYSTEM*/
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return false;
        }
        
        /*CHECK IF MERCHANT HAS DISABLED POINTS SYSTEM*/
        if(isset($cart[0])){
            if(isset($cart[0]['merchant_id'])){             
                $mt_disabled_pts=$this->functions->getOption('mt_disabled_pts',$mtid);
                if($mt_disabled_pts==2){
                    return false;
                }
            }       
        }
        
        $points=0;

        if (is_array($cart) && count($cart)>=1){
            $earning_type =  $this->getBasedEarnings($mtid);
            
            if($earning_type==1){
                foreach ($cart as $val) {
                    $temp_price=explode("|",$val['price']);                                                     
                    if($val['discount']>=0.01){
                        $set_price = ($temp_price[0]-$val['discount'])*$val['qty'];
                    } else $set_price = (float)$temp_price[0]*$val['qty'];              
                                    
                    $points+= $this->getPointsByItem($val['item_id'],$set_price , $mtid);
                }
            } else {                                
                $points+=$this->getTotalEarningPoints($sub_total,$mtid);                
            }
            
            /*CHECK IF SUBTOTAL ORDER IS ABOVE */
            $pts_earn_above_amount=$this->functions->getOptionAdmin('pts_earn_above_amount');
            
            if(!$this->isMerchantSettingsDisabled()){
                $mt_pts_earn_above_amount=$this->functions->getOption('mt_pts_earn_above_amount',$mtid);
                if($mt_pts_earn_above_amount>0){
                    $pts_earn_above_amount = $mt_pts_earn_above_amount;
                }
            }
            
            if(is_numeric($pts_earn_above_amount)){
                if($pts_earn_above_amount>$sub_total){
                    $points=0;
                }
            }
                        
            if ($points>0){
                $pts_label_earn=$this->functions->getOptionAdmin('pts_label_earn');
                if(empty($pts_label_earn)){
                    $pts_label_earn = "This order earned {points}";
                }



                return array(
                  'points_earn'=>$points,
                  'pts_label_earn'=>$pts_label_earn.$points
                );
            }
        }
        return false;
    } 


    public  function getBasedEarnings($merchant_id='')
    {
        $points_based_earn = $this->functions->getOptionAdmin('points_based_earn');       
                
        if(empty($points_based_earn)){
            $points_based_earn=1;
        }
        
        /*CHECK MERCHANT SETTINGS*/ 
        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');
        if($points_disabled_merchant_settings!=1){
            $mt_points_based_earn=$this->functions->getOption('mt_points_based_earn',$merchant_id);
            if($mt_points_based_earn>0){
                $points_based_earn=$mt_points_based_earn;
            }
        }
        
        return $points_based_earn;
    }      


   public function getPointsByItem($item_id = '', $set_price = '', $mtid = '', $qty = '')
{
    if (empty($item_id)) {
        return false;
    }

    $stmt = "SELECT points_earned, price, discount, points_disabled 
             FROM mt_item 
             WHERE item_id = :item_id 
             LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($res['points_earned'] > 0) {
            if ($res['points_disabled'] == 2) {
                return 0;
            }
            return ($qty > 0) ? $res['points_earned'] * $qty : $res['points_earned'];
        } else {
            if ($res['points_disabled'] == 2) {
                return 0;
            }

            $pts_earning_points = $this->functions->getOptionAdmin('pts_earning_points');
            $pts_earning_points_value = $this->functions->getOptionAdmin('pts_earning_points_value');
            $points_disabled_merchant_settings = $this->functions->getOptionAdmin('points_disabled_merchant_settings');

            if ($points_disabled_merchant_settings != 1 && !empty($mtid)) {
                $mt_pts_earning_points = $this->functions->getOption('mt_pts_earning_points', $mtid);
                $mt_pts_earning_points_value = $this->functions->getOption('mt_pts_earning_points_value', $mtid);

                if ($mt_pts_earning_points > 0.01) {
                    $pts_earning_points = $mt_pts_earning_points;
                }
                if ($mt_pts_earning_points_value > 0.01) {
                    $pts_earning_points_value = $mt_pts_earning_points_value;
                }
            }

            $final_price = 0;
            if (!empty($res['price'])) {
                $price = json_decode($res['price'], true);
                if (is_array($price) && count($price) >= 1) {
                    $price = reset($price);
                }
                $discount = $res['discount'] > 0 ? $res['discount'] : 0;
            }

            $final_price = (!empty($set_price) && is_numeric($set_price)) ? $set_price : (float)$price - (float)$discount;

            if ($final_price > 0 && $pts_earning_points_value > 0 && $pts_earning_points > 0) {
                $t1 = ($final_price / $pts_earning_points_value) * $pts_earning_points;
                return intval($t1);
            }
        }
    }

    return false;
}


public  function getTotalEarningPoints($amount='', $merchant_id='')
    {
        $pts_earning_points=$this->functions->getOptionAdmin('pts_earning_points');
        $pts_earning_points_value=$this->functions->getOptionAdmin('pts_earning_points_value');
        
        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');
                                
        if($points_disabled_merchant_settings!=1){
            if(!empty($merchant_id)){
                $mt_pts_earning_points=$this->functions->getOption('mt_pts_earning_points',$merchant_id);
                $mt_pts_earning_points_value=$this->functions->getOption('mt_pts_earning_points_value',$merchant_id);                 
                if($mt_pts_earning_points>0.01){                        
                    $pts_earning_points = $mt_pts_earning_points;
                }
                if($mt_pts_earning_points_value>0.01){                      
                    $pts_earning_points_value = $mt_pts_earning_points_value;
                }
            }
        }
            
        if ($amount>0 && $pts_earning_points_value>0 && $pts_earning_points>0){
            $t1=($amount/$pts_earning_points_value)*$pts_earning_points;                    
            //return intval($t1);
            return floatval($t1);
        }
    }


    public  function isMerchantSettingsDisabled()
    {
        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');
        if($points_disabled_merchant_settings==1){
            return true;
        }
        return false;
    }



    public function pointsTotalExpenses($client_id = '')
{
    if (empty($client_id)) {
        return 0;
    }

    $stmt = "SELECT SUM(total_points) as total 
             FROM mt_points_expenses 
             WHERE status = 'active' 
             AND client_id = :client_id";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    return $res ? $res['total'] : 0;
}


public function getTotalEarnPoints($client_id = '', $merchant_id = '', $redeem_condition = '')
{
    $pts_redeem_condition = $this->functions->getOptionAdmin('pts_redeem_condition');

    if (!empty($redeem_condition)) {
        $pts_redeem_condition = $redeem_condition;
    }

    $and = '';
    $params = [':client_id' => $client_id];

    if (!empty($merchant_id)) {
        $params[':merchant_id'] = $merchant_id;

        switch ($pts_redeem_condition) {
            case 1:
                $and = " AND (merchant_id = :merchant_id OR trans_type = 'adjustment') ";
                break;

            case 3:
                $and = " AND (merchant_id = :merchant_id OR trans_type IN ('first_order', 'review', 'signup', 'adjustment', 'booking')) ";
                break;
        }
    }

    $stmt = "
        SELECT 
            SUM(total_points_earn) AS total_earn,
            (
                SELECT SUM(total_points)
                FROM mt_points_expenses
                WHERE status = 'active'
                AND client_id = :client_id
                $and
            ) AS total_points_expenses
        FROM mt_points_earn
        WHERE status = 'active'
        AND client_id = :client_id
        $and
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    return $res ? ($res['total_earn'] - $res['total_points_expenses']) : 0;
}


public function pointsEarnByMerchant($client_id = '')
{
    $stmt = "
        SELECT 
            SUM(a.total_points_earn) AS total_earn,
            (
                SELECT SUM(total_points)
                FROM mt_points_expenses
                WHERE client_id = :client_id
                AND a.status IN ('active', 'adjustment')
            ) AS total_expenses
        FROM mt_points_earn a
        WHERE client_id = :client_id
        AND a.status IN ('active', 'adjustment')
        AND merchant_id > 0
        GROUP BY merchant_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':client_id' => $client_id]);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_earn = 0;
        $total_expenses = 0;
        
        foreach ($res as $val) {
            $total_earn += $val['total_earn'];
            $total_expenses += $val['total_expenses'];
        }
        
        return $total_earn - $total_expenses;
    }

    return 0;
}


public  function tipList()
    {       
        return array(              
               '0.1'=>"10%",
               '0.15'=>"15%",
               '0.2'=>"20%",
               '0.25'=>"25%"           
        );  
    }       
    
    public  function checkDeliveryAddress($merchant_id='',$data='')
    {
        if($merchant_info=$this->functions->getMerchantById($merchant_id)){
           $distance_type=$this->functions->getMerchantDistanceType($merchant_id); 
           
           $complete_address=$data['street']." ".$data['city']." ".$data['state']." ".$data['zipcode'];
           if(isset($data['country'])){
                $complete_address.=" ".$data['country'];
           } 
           
           $lat=0; $lng=0;
           
           if ( isset($data['address_book_id'])){
              if ($address_book=$this->functions->getAddressBookByID($data['address_book_id'])){
                $complete_address=$address_book['street'];          
                $complete_address.=" ".$address_book['city'];
                $complete_address.=" ".$address_book['state'];
                $complete_address.=" ".$address_book['zipcode'];
              }
           }
           
           //dump($complete_address);
           
           if (isset($data['map_address_toogle'])){             
                if ($data['map_address_toogle']==2){
                    $lat=$data['map_address_lat'];
                    $lng=$data['map_address_lng'];
                } else {
                    if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                       $lat=$lat_res['lat'];
                       $lng=$lat_res['long'];
                    }
                }
            } else {                
                if ($lat_res=$this->functions->geodecodeAddress($complete_address)){
                   $lat=$lat_res['lat'];
                   $lng=$lat_res['long'];
                }
            }
            
            $distance=$this->functions->getDistanceBetweenPlot(
                $lat,
                $lng,
                $merchant_info['latitude'],$merchant_info['lontitude'],$distance_type
            );  
            
            $distance_type_raw = $distance_type=="M"?"miles":"kilometers";      
            $merchant_delivery_distance=$this->functions->getOption('merchant_delivery_miles',$merchant_id); 
            
            if(!empty($distance_type_result)){
                $distance_type_raw=$distance_type_result;
            }
                        
            //dump($distance);dump($distance_type_raw);
            
            if (is_numeric($merchant_delivery_distance)){
                if ( $distance>$merchant_delivery_distance){
                    if($distance_type_raw=="ft" || $distance_type_raw=="meter" || $distance_type_raw=="mt"){
                       return true;
                    } else {
                        

                        $error = 'Sorry but this merchant delivers only with in '.$merchant_delivery_distance;
                        

                        throw new Exception( $error );
                    }                   
                } else {                    
                    $delivery_fee=$this->functions->getMerchantDeliveryFee(
                                  $merchant_id,
                                  $merchant_info['delivery_charges'],
                                  $distance,
                                  $distance_type_raw);
                    if($delivery_fee){
                        return array(
                          'delivery_fee'=>$delivery_fee,
                          'distance'=>$distance,
                          'distance_unit'=>$distance_type_raw
                        );
                    }
                    return true;
                }
            } else {
                // OK DO NOT CHECK DISTAMCE                 
                $delivery_fee=$this->functions->getMerchantDeliveryFee(
                              $merchant_id,
                              $merchant_info['delivery_charges'],
                              $distance,
                              $distance_type_raw);
                if($delivery_fee){
                    return array(
                      'delivery_fee'=>$delivery_fee,
                      'distance'=>$distance,
                      'distance_unit'=>$distance_type_raw
                    );
                }
                return true;
            }          
        } else {
             throw new Exception( ("Merchant not found") );
        }
    }


    public  function updatePoints($order_id='', $order_status='')
    {
        
            
                $this->updateOrderBasedOnStatus($order_status,$order_id);
            
        
    }


    public function updateOrderBasedOnStatus($status = '', $order_id = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT id, order_id, merchant_id, client_id, status
        FROM mt_points_earn
        WHERE order_id = :order_id
        LIMIT 1
    ");
    $stmt->execute(['order_id' => $order_id]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($this->validateEarnByStatus($status, $res['merchant_id'])) {
            // SET TO ACTIVE
            $this->functions->updateData("mt_points_earn", ['status' => "active"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'active');
        } else {
            // SET TO INACTIVE
            $this->functions->updateData("mt_points_earn", ['status' => "inactive"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'inactive');
        }
    }

    // UPDATE EXPENSES POINTS
    $this->updatePointsExpenses($order_id, $status);
}



   public function updatePointsExpenses($order_id = '', $status = '')
{
    if (!empty($order_id)) {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_points_expenses
            WHERE order_id = :order_id
        ");
        $stmt->execute(['order_id' => $order_id]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            if (!$this->validateEarnByStatus($status, $res['merchant_id'])) {
                $params = [
                    'status' => 'inactive',
                    'date_modified' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                ];
                $this->functions->updateData("mt_points_expenses", $params, 'id', $res['id']);
            } else {
                if ($res['status'] == "inactive") {
                    $params = [
                        'status' => 'active',
                        'date_modified' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR']
                    ];
                    $this->functions->updateData("mt_points_expenses", $params, 'id', $res['id']);
                }
            }
        }
    }
}




    public function UpdateFirstOrder($client_id = '', $order_id = '', $status = '')
{               
    if (!empty($client_id) && !empty($order_id) && !empty($status)) {
        $sql = "UPDATE mt_points_earn 
                SET status = :status 
                WHERE client_id = :client_id 
                AND order_id = :order_id 
                AND trans_type = 'first_order'";

        $params = [
            ':status' => $status,
            ':client_id' => $client_id,
            ':order_id' => $order_id
        ];

        $this->db->query($sql, $params);
    }       
}
  


    public  function validateEarnByStatus($status='',$merchant_id='')
    {       
        $status_list = $this->functions->getOptionAdmin('pts_earn_points_status');
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_pts_earn_points_status=$this->functions->getOption('mt_pts_earn_points_status',$merchant_id);
            if(!empty($mt_pts_earn_points_status)){
                $status_list=$mt_pts_earn_points_status;
            }
        }
                
        if(!empty($status_list)){
            $status_array=json_decode($status_list,true);
            if(is_array($status_array) && count($status_array)>=1){             
                if(in_array($status,$status_array)){
                    return true;
                }
            }           
        }       
        return false;
    }


 public function getBookAddress($client_id = '', $street = '', $city = '', $state = '')
{
    if (empty($street) || empty($city) || empty($state)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_address_book
        WHERE client_id = :client_id
        AND street = :street
        AND city = :city
        AND state = :state
        LIMIT 1
    ");
    
    $stmt->execute([
        'client_id' => $client_id,
        'street' => $street,
        'city' => $city,
        'state' => $state
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $res ?: false;
}


   public  function savePoints($device_uiid='',$client_id='',$merchant_id='', $order_id='',$order_status='')
    {
        /*POINTS ADDON*/
                 
            if($res=$this->getCart($device_uiid)){
                $points_earn = $res['points_earn'];
                $this->saveEarnPoints($points_earn,$client_id,$merchant_id,$order_id,'',$order_status);             
                
                if ($res['points_apply']>=0.0001){
                    $this->saveExpensesPoints(
                      $res['points_apply'],
                      $res['points_amount'],
                      $client_id,
                      $merchant_id,
                      $order_id,
                      ''
                    );
                }
            }
        
    } 



    public  function saveEarnPoints($total_points_earn='',$client_id='',$merchant_id='',
    $order_id='',$payment_selected='',$order_status='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
        }
                        
        if ($total_points_earn>0){
            
            /*check if the client has reach the maximum points to be earn*/
            $max_points=$this->functions->getOptionAdmin('pts_maximum_points');
            if (is_numeric($max_points)){               
                $points_balance=$this->getTotalEarnPoints($client_id);               
                $total_points_earn2=$total_points_earn+$points_balance;             
                if ($total_points_earn2>$max_points){                   
                    $points_supposed_to_earn=$max_points-$points_balance;                   
                    $total_points_earn=$points_supposed_to_earn;
                }                               
            }
            
            $params=array(
              'client_id'=>$client_id,
              'merchant_id'=>$merchant_id,
              'order_id'=>$order_id,
              'total_points_earn'=>$total_points_earn,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            /*switch ($payment_selected) {
                case "cod":
                case "ocr":
                case "obd":                     
                case "pyr":
                    $params['status']="active";
                    break;
            
                default:
                    break;
            }*/

            /*donnot saved the points if points is below zero*/     
            if ($total_points_earn<=0){
                return false;
            }
            
            $earn_status = $this->validateEarnByStatus($order_status,$merchant_id);
            if($earn_status){
                $params['status']="active";
            }                       
                        
            
            if ( $this->functions->insertData('mt_points_earn',$params)){
                $this->firstOrderRewards($client_id,
                isset($params['status'])?$params['status']:'inactive', $order_id);
                return true;
            }
        }       
        return false;
    }


 public function firstOrderRewards($client_id = '', $status = '', $order_id = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return;
    }

    $pts_first_order = $this->functions->getOptionAdmin('pts_first_order');
    if ($pts_first_order < 1) {
        return false;
    }

    $first_order = false;

    // Check if this is the first order
    $stmt = $this->db->prepare("SELECT COUNT(*) as total FROM mt_order WHERE client_id = :client_id");
    $stmt->execute(['client_id' => $client_id]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res && $res['total'] <= 1) {
        $first_order = true;
    } else {
        $first_order = true; // If no result, assume first order
    }


    if ($first_order) {

        $order_infos=$this->functions->getOrderInfo($order_id);


        $params = [
            'client_id' => $client_id,
            'merchant_id' => $order_infos['merchant_id'],
            'total_points_earn' => $pts_first_order,
            'status' => $status,
            'date_created' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'trans_type' => 'first_order',
            'order_id' => $order_id
        ];

        $this->functions->insertData('mt_points_earn', $params);
    }
}


public  function sendNotification($order_id='')
    {
        $error='';
        
        if(!is_numeric($order_id)){
            throw new Exception( ("invalid order id") );
        }
        
       
        
        try {
            
            $print_resp = $this->prepareReceipt($order_id);
			
		
			
            $print = $print_resp['print'];
            $print_data = $print_resp['data'];
            $print_additional_details = $print_resp['additional_details'];
            $print_raw = $print_resp['raw'];



            $merchant_info=$this->functions->getMerchant(isset($print_data['merchant_id'])?$print_data['merchant_id']:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];




            
            $to=isset($print_data['email_address'])?$print_data['email_address']:'';
            $receipt=$this->functions->salesReceipt($print, $print_resp['raw'] );    
			

            $receipt1=$this->functions->salesReceiptM($full_merchant_address,$print_data,$print,$print_resp['raw']);
			
			
			
                                    
            $this->functions->notifyCustomer($print_data,$print_additional_details,$receipt, $to);
           //$this->functions->notifyMerchant($print_data,$print_additional_details,$receipt);

           $this->functions->notifyMerchant2($print_data,$print_additional_details,$receipt,$receipt1);

             $this->functions->notifyAdmin($print_data,$print_additional_details,$receipt);
            
          
            
            
            $merchant_id = 0;            
            $merchant_id = $print_data['merchant_id'];            
            
           
            
        } catch (Exception $e){
            //$error = $e->getMessage();
        }   
    }


    public  function prepareReceipt($order_id='')
    {
        $_GET['backend']=true; $print = array();        
        if ( $data = $this->functions->getReceiptByID($order_id)){
            
            
            
            $merchant_id=$data['merchant_id'];
            $json_details=!empty($data['json_details'])?json_decode($data['json_details'],true):false;              
            
            $used_currency = isset($data['used_currency'])?$data['used_currency']: $this->functions->getCurrencyCode() ;
            
            
            if ( $json_details !=false){
                $displayOrderHTML=$this->functions->displayOrderHTML(array(
               'order_id'=>$order_id,
               'merchant_id'=>$data['merchant_id'],
               'delivery_type'=>$data['trans_type'],
               'delivery_charge'=>$data['delivery_charge'],
               'packaging'=>$data['packaging'],
               'cart_tip_value'=>$data['cart_tip_value'],
               'cart_tip_percentage'=>$data['cart_tip_percentage']/100,
               'card_fee'=>$data['card_fee'],
               'tax'=>$data['tax'],
               'points_discount'=>isset($data['points_discount'])?$data['points_discount']:'' /*POINTS PROGRAM*/,
               'voucher_amount'=>$data['voucher_amount'],
               'voucher_type'=>$data['voucher_type'],
               
               /* Custom code 13 starts */
               'promo_id'=>$data['promo_id'],
               /* Custom code 13 ends */
               
               'tax_set'=>isset($data['tax'])?$data['tax']:'',
               'service_fee'=>isset($data['service_fee'])?(float)$data['service_fee']:0,
               'service_fee_applytax'=>isset($data['service_fee_applytax'])?(integer)$data['service_fee_applytax']:false,
              ),$json_details,true,$order_id);
            }
            
            $print[]=array( 'label'=> "Customer Name", 'value'=>$data['full_name'] );
            $print[]=array( 'label'=> "Merchant Name", 'value'=>$data['merchant_name']);
            if (isset($data['abn']) && !empty($data['abn'])){
                $print[]=array(
                 'label'=>$this->functions->translation("default","ABN"),
                 'value'=>$data['abn']
                );
            }
            $print[]=array('label'=>$this->functions->translation("default","Telephone"),'value'=>$data['merchant_contact_phone']);
            
            $merchant_info=$this->functions->getMerchant(isset($merchant_id)?$merchant_id:'');
            $full_merchant_address=$merchant_info['street']." ".$merchant_info['city']. " ".$merchant_info['state'].
            " ".$merchant_info['post_code'];
        
            $print[]=array('label'=>$this->functions->translation("default","Address"),'value'=>$full_merchant_address);
            
            $print[]=array('label'=>$this->functions->translation("default","TRN Type"),'value'=>($data['trans_type']));
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Payment Type"),
             'value'=>$this->functions->prettyPaymentType('payment_order',$data['payment_type'],$order_id,$data['trans_type'])
            );         
           
            if ( $data['payment_provider_name']){
                $print[]=array('label'=>$this->functions->translation("default","Card#"),'value'=>strtoupper($data['payment_provider_name']));
            }
            
            if ( $data['payment_type'] =="pyp"){
                $paypal_info=$this->functions->getPaypalOrderPayment($order_id);
                $print[]=array(
                   'label'=>$this->functions->translation("default","Paypal Transaction ID"),
                   'value'=>isset($paypal_info['TRANSACTIONID'])?$paypal_info['TRANSACTIONID']:''
                );
            }
                        
            $print[]=array(
             'label'=>$this->functions->translation("default","Reference #"),
             'value'=>$this->functions->formatOrderNumber($data['order_id'])
            );
            
            
            if($data['request_from']=="pos" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );
            
            
            
            }
            
            
            
            if($data['request_from']=="webappv2" &&  $data['order_number']>0){
            
            $print[]=array(
             'label'=>$this->functions->translation("default","Order Number"),
             'value'=>$data['merchant_id'].'-'.$data['order_number']
            );

            
            }
            
            
            if ( !empty($data['payment_reference'])){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Payment Ref"),
                  'value'=>isset($data['payment_reference'])?$data['payment_reference']:$this->functions->formatOrderNumber($data['order_id'])
                );
            }
            
            if ( $data['payment_type']=="ccr" || $data['payment_type']=="ocr"){
                $print[]=array(
                  'label'=>$this->functions->translation("default","Card #"),
                  'value'=>$this->functions->maskCardnumber($data['credit_card_number'])
                );
            }
            
            $trn_date=date('M d,Y G:i:s',strtotime($data['date_created']));
            $print[]=array(
              'label'=>$this->functions->translation("default","TRN Date"),
              'value'=>$trn_date
            );
                        
            /*dump($data);
            dump($print);
            die();*/
            
            switch ($data['trans_type']) {
                case "delivery":                    
                    $print[]=array(
                     'label'=>$this->functions->translation("default","Delivery Date"),
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$this->functions->translation("default","Delivery Time"),
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if(!empty($data['delivery_asap'])){
                        $delivery_asap=$data['delivery_asap']==1?"Yes":'';
                        $print[]=array(
                         'label'=>$this->functions->translation("default","Deliver ASAP"),
                         'value'=>$delivery_asap
                        );
                    }
                    
                    if (!empty($data['client_full_address'])){                  
                       $delivery_address=$data['client_full_address'];
                    } else $delivery_address=$data['full_address'];     
                                        
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Deliver to"),
                      'value'=>$delivery_address
                    );
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Delivery Instruction"),
                      'value'=>$data['delivery_instruction']
                    );         
                    
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Location Name"),
                      'value'=>$data['location_name']
                    );
               
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                
                    break;
                
                case "pickup":      
                case "dinein":      
                
                    $label_date=("Pickup Date");
                    $label_time=("Pickup Time");
                    if ($data['trans_type']=="dinein"){
                        $label_date=("Dine in Date");
                        $label_time=("Dine in Time");
                    }   
                    
                    if (isset($data['contact_phone1'])){
                        if (!empty($data['contact_phone1'])){
                            $data['contact_phone']=$data['contact_phone1'];
                        }
                    }
                
                    $print[]=array(
                      'label'=>$this->functions->translation("default","Contact Number"),
                      'value'=>$data['contact_phone']
                    );
                    
                //  Custom code 12 starts
                    if($data['car_park_enable']== 1 && isset($data['number_plate']) && !empty($data['number_plate'])){
                        $print[]=array('label'=>"Car Park Delivery",'value'=>"Yes");
                        $print[]=array('label'=>"Number Plate",'value'=>$data['number_plate']); 
                     }
                //  Custom code 12 ends
                    
                    $print[]=array(
                     'label'=>$label_date,
                     'value'=>$this->functions->translateDate($data['delivery_date'])
                    );
                    
                    if(!empty($data['delivery_time'])){
                       $print[]=array(
                         'label'=>$label_time,
                         'value'=>$this->functions->timeFormat($data['delivery_time'],true)
                       );
                    }
                    
                    if ($data['order_change']>=0.1){
                        $print[]=array(
                          'label'=>$this->functions->translation("default","Change"),
                          'value'=>$this->functions->normalPrettyPrice($data['order_change'])
                        );
                    }
                    
                    if ($data['trans_type']=="dinein"){
                        $print[]=array(
                          'label'=>("Number of guest"),
                          'value'=>$data['dinein_number_of_guest']
                        );
                        $print[]=array(
                          'label'=>("Special instructions"),
                          'value'=>$data['dinein_special_instruction']
                        );
                    }
                
                   break;
            
                default:
                    break;
            }
            
            return array(
             'merchant_id'=>$merchant_id,
             'print'=>$print,
             'raw'=>$displayOrderHTML['raw'],
             'data'=>$data,
             'additional_details'=>""
            );
            
        } else throw new Exception( ("order not found"));
    }


    public  function executeAddons($order_id='')
    {
        /*SEND FAX*/
         if(!$order_info=$this->functions->getOrderInfo($order_id)){
            return false;
         } 

         $this->PointsProgram=new PointsProgram();
         $this->InventoryWrapper=new InventoryWrapper();
                  
         $this->functions->sendFax($order_info['merchant_id'],$order_id);
         
         $client_id = isset($order_info['client_id'])?$order_info['client_id']:'';
         
         /*POINTS PROGRAM*/ 
         
                                       
        $this->PointsProgram->updateOrderBasedOnStatus( $order_info['status'] , $order_id);
            
        
        
          
                 
         /*inventory*/      
         if($this->functions->inventoryEnabled($order_info['merchant_id'])){
            try {                                         
               $this->InventoryWrapper->insertInventorySale($order_id,strtolower($order_info['status']));  
            } catch (Exception $e) {                                            
              // echo $e->getMessage();                       
            }                                        
         }
         
    }








    public  function saveExpensesPoints($total_points='',$total_points_amt='',
    $client_id='',$merchant_id='',
    $order_id='',$payment_selected='')
    {
        
        if ($total_points<0.01){
            return false;
        }
        
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        $params=array(
          'client_id'=>$client_id,
          'merchant_id'=>$merchant_id,
          'order_id'=>$order_id,
          'total_points'=>$total_points,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'total_points_amt'=>$total_points_amt
        );
        
        switch ($payment_selected) {
            case "cod":
            case "ocr":
            case "obd":     
            case "pyr":
                //$params['status']="active";
                break;
                        
            default:
                //$params['status']="active";
                break;
        }
                    
       
        if ( $this->functions->insertData('mt_points_expenses',$params)){
            return true;
        }
        
        return false;
    }


     public  function checkDeliveryAddresNew( $merchant_id='', $lat='', $lng='' )
    {
        if(!is_numeric($merchant_id)){
            throw new Exception( ("invalid merchant id") );
        }
        if(!is_numeric($lat)){
            throw new Exception( ("invalid latitude") );
        }
        if(!is_numeric($lng)){
            throw new Exception( ("invalid longtitude") );
        }
        
        $distance=0;
        $distance_results_type = $this->getDistanceResultsType();   
        
        if($merchant_info=$this->functions->getMerchantById($merchant_id)){
           $distance_type=$this->functions->getMerchantDistanceType($merchant_id); 
           $merchant_lat = $merchant_info['latitude'];
           $merchant_lng = $merchant_info['lontitude'];
                           
           if($distance_results_type==1){
              $distance = $this->getLocalDistance($distance_type,$lat,$lng,$merchant_lat,$merchant_lng);           
           } else {        
               $distance=$this->functions->getDistanceBetweenPlot(
                    $lat,
                    $lng,
                    $merchant_lat,$merchant_lng,$distance_type
               );      
           }       
           
           
                   
           $distance_type_raw = $distance_type=="M"?"miles":"kilometers";       
           $merchant_delivery_distance=$this->functions->getOption('merchant_delivery_miles',$merchant_id);   
           
           if(!empty($distance_type_result)){
              $distance_type_raw=$distance_type_result;
           }
           
           /*dump("distance=>$distance");
           dump("merchant_delivery_distance=>$merchant_delivery_distance");*/
           if (is_numeric($merchant_delivery_distance)){
               if ( $distance>$merchant_delivery_distance){
                   if($distance_type_raw=="ft" || $distance_type_raw=="meter" || $distance_type_raw=="mt"){
                       return true;
                    } else {
                        

                        $error = "Sorry but this merchant delivers only with in". $merchant_delivery_distance;

                        throw new Exception( $error );
                    }       
               } else {
                   $delivery_fee=$this->functions->getMerchantDeliveryFee(
                                  $merchant_id,
                                  $merchant_info['delivery_charges'],
                                  $distance,
                                  $distance_type_raw);
                    //if($delivery_fee){
                        return array(
                          'delivery_fee'=>$delivery_fee,
                          'distance'=>$distance,
                          'distance_unit'=>$distance_type_raw
                        );
                    /*}
                    return true;*/
               }
           } else {
               // OK DO NOT CHECK DISTAMCE 
               $delivery_fee=$this->functions->getMerchantDeliveryFee(
                              $merchant_id,
                              $merchant_info['delivery_charges'],
                              $distance,
                              $distance_type_raw);
                //if($delivery_fee){
                    return array(
                      'delivery_fee'=>$delivery_fee,
                      'distance'=>$distance,
                      'distance_unit'=>$distance_type_raw
                    );
                /*}
                return true;*/
           }
           
        } else throw new Exception( ("Merchant not found") );
    }


      public  function getLocalDistance($unit='', $lat1='',$lon1='', $lat2='', $lon2='')
    {         
          if(!is_numeric($lat1)){
             return 0;
          }
          if(!is_numeric($lon1)){
             return false;
          }
          if(!is_numeric($lat2)){
             return 0;
          }
          if(!is_numeric($lon2)){
             return 0;
          }
          $theta = $lon1 - $lon2;
          $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
         
          $dist = acos($dist);
          $dist = rad2deg($dist);
          $miles = $dist * 60 * 1.1515;
          $unit = strtoupper($unit);
          
          $resp = 0;
          
          if ($unit == "K") {
              $resp = ($miles * 1.609344);
          } else if ($unit == "N") {
              $resp = ($miles * 0.8684);
          } else {
              $resp = $miles;
          }       
          
          if($resp>0){
             $resp = number_format($resp,1);
          }
          
          return $resp;
    }


     public  function emptyMessage($title='', $message='', $image=true){
        $html='';
        $html.='<div class="no_order_wrap">';
           $html.='<div class="center"> ';
           if($image){
              $html.='<img src="">';
           }
            $html.='<h4 class="trn">'.($title).'</h4>';
            $html.='<p class="small trn">'.($message).'</p>';
           $html.='</div>';
         $html.='</div>';
         return $html;
    }


    public  function canReviewOrder($order_status='',$website_review_type='', $review_baseon_status='')
    {           
        if(!empty($review_baseon_status)){
           $review_baseon_status = json_decode($review_baseon_status,true);
           if (is_array($review_baseon_status) && count($review_baseon_status)>=1){
              if (in_array($order_status,$review_baseon_status)){
                  return true;
              }
           }
        } else return true;
    } 





public function orderDetails($order_id = '')
{
    if (empty($order_id)) {
        return false;
    }

    $stmt = "
        SELECT 
        a.order_id,
        a.merchant_id,
        a.client_id,
        a.trans_type,
        a.status,
        a.status AS status_raw,
        a.payment_type,
        a.payment_type AS payment_type_raw,
        b.restaurant_name AS merchant_name,
        b.logo,
        c.review,
        c.rating,
        c.as_anonymous
        FROM mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        LEFT JOIN mt_review c ON a.order_id = c.order_id
        WHERE a.order_id = :order_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    }
    
    return false;
}





 public function orderHistory($order_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_order_history
        WHERE order_id = :order_id
        ORDER BY id DESC
    ");

    $stmt->execute(['order_id' => $order_id]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    return $res ?: false;
}



    
    public  function receiptFormater($label='', $val='')
    {
        return array(
          'label'=>$label,
          'value'=>$val
        );
    }


    public function removeFavorite($id = '', $client_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_favorites
        WHERE id = :id
        AND client_id = :client_id
    ");

    $stmt->execute([
        'id' => $id,
        'client_id' => $client_id
    ]);

    return true;
}

    
    public function DeleteAddressBook($id = '', $client_id = '', $is_location = false)
{
    $table = $is_location ? 'mt_address_book_location' : 'mt_address_book';

    $stmt = $this->db->prepare("
        DELETE FROM $table
        WHERE id = :id
        AND client_id = :client_id
    ");

    $stmt->execute([
        'id' => $id,
        'client_id' => $client_id
    ]);

    return true;
}


   public function UpdateAllAddressBookDefault($client_id = '')
{
    $stmt = $this->db->prepare("
        UPDATE mt_address_book
        SET as_default = '1'
        WHERE client_id = :client_id
    ");

    $stmt->execute([
        'client_id' => $client_id
    ]);

    return true;
}

    
    public function UpdateAllAddressBookDefaultLocation($client_id = '')
{
    $stmt = $this->db->prepare("
        UPDATE mt_address_book_location
        SET as_default = '0'
        WHERE client_id = :client_id
    ");

    $stmt->execute([
        'client_id' => $client_id
    ]);

    return true;
}


  public function getRecentLocation($device_uiid = '', $lat = '', $lng = '')
{
    if (empty($device_uiid) || empty($lat) || empty($lng)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_mobile2_recent_location
        WHERE device_uiid = :device_uiid
        AND latitude = :lat
        AND longitude = :lng
        LIMIT 1
    ");

    $stmt->execute([
        'device_uiid' => $device_uiid,
        'lat' => $lat,
        'lng' => $lng
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $res ? $res : false;
}


 public function getFavorites($client_id = '', $merchant_id = '', $return_data = false)
{
    if (!$this->functions->checkIfTableExist('favorites')) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_favorites
        WHERE client_id = :client_id
        AND merchant_id = :merchant_id
        LIMIT 1
    ");

    $stmt->execute([
        'client_id' => $client_id,
        'merchant_id' => $merchant_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($res) {
        return $return_data ? $res : true;
    }
    
    return false;
}


 public function getRecentSearchs($device_uiid = '', $search_string = '')
{
    if (empty($device_uiid) || empty($search_string)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_mobile2_recent_search
        WHERE device_uiid = :device_uiid
        AND search_string = :search_string
        LIMIT 1
    ");

    $stmt->execute([
        'device_uiid' => $device_uiid,
        'search_string' => $search_string
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($res) {
        return $res;
    }
    
    return false;
}


public  function getDataSearchOptions()
    {
        $search_data = $this->functions->getOptionAdmin('mobile2_search_data');
        if(!empty($search_data)){
            $search_data = json_decode($search_data,true);
            if(is_array($search_data) && count((array)$search_data)>=1){
                return $search_data;
            }
        }
        return false;
    }



      public  function getMerchantServicesList($service=0)
    {
        $list = array();
        if(!is_numeric($service)){
            return false;
        }
        switch ($service) {
            case 1:
                $list[]="Delivery";
                $list[]="Pickup";
                break;
            case 2:
                $list[]="Delivery";
                break;
            case 3:
                $list[]="Pickup";
                break;  
            case 4:
                $list[]="Delivery";
                $list[]="Pickup";
                $list[]="Dinein";
                break;  
            case 5:
                $list[]="Delivery";              
                $list[]="Dinein";
                break;      
            case 6:
                $list[]="Pickup";                
                $list[]="Dinein";
                break;          
            case 7:
                $list[]="Dinein";
                break;              
        }
        return $list;
    }



    public  function merchantAppSettings($merchant_id='')
    {
        $settings =  array(
           'order_verification'=>$this->functions->getOption('order_verification',$merchant_id),
           'enabled_voucher'=>$this->functions->getOption('merchant_enabled_voucher',$merchant_id),
           'enabled_tip'=>$this->functions->getOption('merchant_enabled_tip',$merchant_id),
           'tip_default'=>$this->functions->getOption('merchant_tip_default',$merchant_id),
        );
        
        if($settings['order_verification']==2){
            $sms_balance=$this->functions->getMerchantSMSCredit($merchant_id);
            if($sms_balance<=0){
                $settings['order_verification']='';
            }
        }       
        return $settings;
    }
    
    public function validateOrderSMSCode($session = '', $code = '')
{
    if (empty($session) || empty($code)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_order_sms
        WHERE session = :session
        AND code = :code
        LIMIT 1
    ");
    
    $stmt->bindParam(':session', $session, PDO::PARAM_STR);
    $stmt->bindParam(':code', $code, PDO::PARAM_STR);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}



 public  function getCartContent($device_uiid='', $data=array() )
    {
        if(empty($device_uiid)){
            return false;
        }
        
        if($res=$this->getCart($device_uiid)){
           $cart=json_decode($res['cart'],true);
           
           if($res['tips']>0.0001){
              $data['cart_tip_percentage']=$res['tips'];
              $data['tip_enabled']=2;
              $data['tip_percent']=$res['tips'];
           }
            
           $voucher_details = !empty($res['voucher_details'])?json_decode($res['voucher_details'],true):false;  
           if(is_array($voucher_details) && count($voucher_details)>=1){
              $data['voucher_name']=$voucher_details['voucher_name'];
              $data['voucher_amount']=$voucher_details['amount'];
              $data['voucher_type']=$voucher_details['voucher_type'];
           }
           
           if($res['points_apply']>0.0001){
                $data['points_apply']=$res['points_apply'];
            }
            if($res['points_amount']>0.0001){
                $data['points_amount']=$res['points_amount'];
            }
            
            /*DELIVERY FEE*/
            unset($_SESSION['shipping_fee']);
            if($res['delivery_fee']>0.0001){
                $data['delivery_charge']=$res['delivery_fee'];
            }
                                
            $cart_details = $res;
            unset($cart_details['cart']);       
            unset($cart_details['device_id']);
            unset($cart_details['cart_id']);            
            
            
            $displayOrderHTML=$this->functions->displayOrderHTML($data,$cart);

            $code = $displayOrderHTML['code'];
            $msg  = $displayOrderHTML['msg'];
            if ($code==1){
                $details = $displayOrderHTML['raw'];
                return $details;
            }          
        }
        return false;    
    }


    public  function removeVoucher($device_uiid='')
    {
        if(empty($device_uiid)){
            return false;
        }               
        $params = array(
          'date_modified'=>$this->functions->dateNow(),
          'voucher_details'=>''
        );      
       
        $up=$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$device_uiid);

    }
    
    public  function removeTip($device_uiid='')
    {
        if(empty($device_uiid)){
            return false;
        }               
        $params = array(
          'date_modified'=>$this->functions->dateNow(),        
          'tips'=>0,
          'remove_tip'=>1
        );      
        
        $up=$this->functions->updateData("mt_mobile2_cart",$params,'device_uiid',$device_uiid);
    }


   public function registeredDevice_bkup($data = array(), $status = 'active', $update_device = true)
{
    $client_id = isset($data['client_id']) ? $data['client_id'] : '';
    $device_id = isset($data['device_id']) ? $data['device_id'] : '';
    $device_platform = isset($data['device_platform']) ? strtolower($data['device_platform']) : '';
    $device_uiid = isset($data['device_uiid']) ? $data['device_uiid'] : '';
    $code_version = isset($data['code_version']) ? $data['code_version'] : '';

    $params = array(
        'device_id' => $device_id,
        'device_platform' => $device_platform,
        'device_uiid' => $device_uiid,
        'status' => $status,
        'code_version' => $code_version,
        'date_created' => $this->functions->dateNow(),
        'ip_address' => $_SERVER['REMOTE_ADDR']
    );

    if ($client_id > 0) {
        $params['client_id'] = $client_id;
    }

    if (!$update_device) {
        unset($params['device_id']);
    }

    if (!empty($device_uiid)) {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_mobile2_device_reg 
            WHERE device_uiid = :device_uiid 
            LIMIT 1
        ");
        $stmt->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
        $stmt->execute();
        
        if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
            unset($params['date_created']);
            $params['date_modified'] = $this->functions->dateNow();
            $this->functions->updateData("mt_mobile2_device_reg", $params, 'id', (int) $res['id']);
        } else {
            $this->functions->insertData("mt_mobile2_device_reg", $params);
        }
    }
}


public function registeredDevice($data = array(), $status = 'active', $update_device = true)
{
    
}




public  function SendForgotPassword($to='',$res='')
    {
        $enabled=$this->functions->getOptionAdmin('customer_forgot_password_email');
        if($enabled){
            $lang="en"; 
            $subject=$this->functions->getOptionAdmin("customer_forgot_password_tpl_subject_$lang");
            if(!empty($subject)){
                $subject=$this->functions->smarty('firstname',
                isset($res['first_name'])?$res['first_name']:'',$subject);
                
                $subject=$this->functions->smarty('lastname',
                isset($res['last_name'])?$res['last_name']:'',$subject);
            }
                                        
            $tpl=$this->functions->getOptionAdmin("customer_forgot_password_tpl_content_$lang") ;
            if (!empty($tpl)){                              
                $tpl=$this->functions->smarty('firstname',
                isset($res['first_name'])?$res['first_name']:'',$tpl);
                
                $tpl=$this->functions->smarty('lastname',
                isset($res['last_name'])?$res['last_name']:'',$tpl);
                
                $tpl=$this->functions->smarty('change_pass_link',$res['lost_password_token']
                ,$tpl);


                
                $tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
                $tpl=$this->functions->smarty('siteurl',$this->functions->websiteUrl(),$tpl);
            }
            if (!empty($subject) && !empty($tpl)){
                $this->functions->sendEmail($to,'',$subject, $tpl );
            }                       
        }                   
    }    
    
    public  function checkBlockAccount($email_address='', $contact='')
    {
        if ( $this->functions->emailBlockedCheck($email_address)){
            return true;
        }
        if ( $this->functions->mobileBlockedCheck($contact)){
            return true;
        }
        return false;
    }



 public function clearRecentLocation($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = $this->db->prepare("
        DELETE FROM mt_mobile2_recent_location 
        WHERE device_uiid = :device_uiid
    ");
    $stmt->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
    $stmt->execute();

    return true;
}

public function clearRecentSearches($device_uiid = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = $this->db->prepare("
        DELETE FROM mt_mobile2_recent_search 
        WHERE device_uiid = :device_uiid
    ");
    $stmt->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);
    $stmt->execute();

    return true;
}


   public function getDriverTask($order_id = '')
{
    if ($order_id <= 0 || !is_numeric($order_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT a.*, b.transport_type_id     
        FROM mt_driver_task_view a 
        LEFT JOIN mt_driver b ON a.driver_id = b.driver_id
        WHERE order_id = :order_id
        LIMIT 1
    ");
    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

public function getTask($task_id = '')
{
    if ($task_id <= 0 || !is_numeric($task_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_driver_task 
        WHERE task_id = :task_id
        LIMIT 1
    ");
    $stmt->bindParam(':task_id', $task_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}



public function getTaskFullInformation($task_id = '')
{
    if ($task_id <= 0 || !is_numeric($task_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT 
            a.task_id,
            a.order_id,
            a.driver_id,
            a.status,
            a.rating,
            a.rating_comment,       
            a.rating_anonymous,
            CONCAT(b.first_name, ' ', b.last_name) AS driver_name,
            b.email AS driver_email,
            b.phone AS driver_phone,
            b.profile_photo AS driver_photo, 
            c.client_id,
            d.first_name AS customer_firstname,
            c.status AS order_status_raw,
            c.merchant_id,
            c.date_created AS order_date_created,
            c.trans_type,
            c.payment_type,
            
            IFNULL((
                SELECT rating FROM mt_review
                WHERE order_id = a.order_id
                AND status = 'publish'        
                LIMIT 1
            ), 0) AS order_rating,
            
            IFNULL((
                SELECT restaurant_name FROM mt_merchant
                WHERE merchant_id = c.merchant_id       
                LIMIT 1
            ), '') AS merchant_name,
            
            IFNULL((
                SELECT logo FROM mt_merchant
                WHERE merchant_id = c.merchant_id       
                LIMIT 1
            ), '') AS merchant_logo
                
        FROM mt_driver_task a       
        LEFT JOIN mt_driver b ON a.driver_id = b.driver_id       
        LEFT JOIN mt_order c ON a.order_id = c.order_id
        LEFT JOIN mt_client d ON c.client_id = d.client_id
        
        WHERE a.task_id = :task_id
        LIMIT 1
    ");

    $stmt->bindParam(':task_id', $task_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


public function DriverInformation($driver_id = '')
{
    if ($driver_id <= 0 || !is_numeric($driver_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT 
            a.driver_id,
            a.first_name,
            a.last_name,
            CONCAT(a.first_name, ' ', a.last_name) AS full_name,
            a.email,
            a.phone,
            a.transport_type_id,
            a.transport_description,
            a.licence_plate,
            a.color,
            a.status,
            a.location_lat,
            a.location_lng,
            a.device_platform,
            a.last_login,
            a.last_online,
            a.profile_photo,
            a.team_id,
            b.team_name
        FROM mt_driver a
        LEFT JOIN mt_driver_team b ON a.team_id = b.team_id
        WHERE a.driver_id = :driver_id
        LIMIT 1
    ");

    $stmt->bindParam(':driver_id', $driver_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


public function getDriverLocation($driver_id = '')
{
    if ($driver_id <= 0 || !is_numeric($driver_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT driver_id, location_lat, location_lng
        FROM mt_driver
        WHERE driver_id = :driver_id
        LIMIT 1
    ");

    $stmt->bindParam(':driver_id', $driver_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

    
    public function getDriverRatings($driver_id = '')
{
    if ($driver_id <= 0 || !is_numeric($driver_id)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT SUM(rating) AS ratings, COUNT(*) AS count
        FROM mt_driver_task
        WHERE driver_id = :driver_id
        AND status IN ('successful')
    ");

    $stmt->bindParam(':driver_id', $driver_id, PDO::PARAM_INT);
    $stmt->execute();

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res && $res['ratings'] >= 1) {
        return [
            'ratings' => number_format($res['ratings'] / $res['count'], 1),
            'votes' => $res['count']
        ];
    }

    return [
        'ratings' => 0,
        'votes' => 0
    ];
}

public  function taskProgress($status='')
    {
        $base_completion = 25;
        switch (trim(strtolower($status))) {
            case "acknowledged":    
                $completed = $base_completion;
                break;
            case "started":                     
                $completed = $base_completion*2;
                break;  
            case "inprogress":                      
                $completed = $base_completion*3;
                break;
            default:
                $completed=0;  
                break;
        }
        return $completed;
    }



 public function cuusineListTranslation()
{
    $data = [];

    $stmt = $this->db->prepare("
        SELECT cuisine_name, cuisine_name_trans
        FROM mt_cuisine
        WHERE status = 'publish'
        ORDER BY cuisine_name ASC
    ");

    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $json = json_decode($val['cuisine_name_trans'], true);
            $data[$val['cuisine_name']] = $json;
        }
    }

    return $data;
}

    
    public  function cuisineListDict($list=array())
    {
        $data = array();
        if(is_array($list) && count((array)$list)>=1){
            foreach ($list as $val) {
                $json = json_decode($val['cuisine_name_trans'],true);
                $data[$val['cuisine_name']]=$json;
            }
        }
        return $data;
    }
    
   public function OrderTrigger($order_id = '', $status = '', $remarks = '', $trigger_type = 'order')
{
    if (!$this->functions->checkIfTableExist('webappv2_order_trigger')) {
        return false;
    }

    $lang = "en";

    if ($order_id > 0) {
        $stmt = $this->db->prepare("
            SELECT order_id FROM mt_webappv2_order_trigger
            WHERE order_id = :order_id
            AND status = 'pending'
            LIMIT 1
        ");

        $stmt->execute(['order_id' => $order_id]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$res) {
            $params = [
                'order_id' => $order_id,
                'order_status' => $status,
                'remarks' => $remarks,
                'language' => $lang,
                'date_created' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'trigger_type' => $trigger_type
            ];

            $this->functions->insertData("mt_webappv2_order_trigger", $params);
        }
    }
}


public  function timePastByTransaction($transaction_type='')
    {
        $error = '';
        switch ($transaction_type)
        {
            case "delivery":
            case "pickup":
            case "dinein":
               

                $error = "Sorry but you have selected ".$transaction_type. "time that already past";

                break;
                            
            default:        
                $error = "Sorry but you have selected time that already past";
                break;  
        }
        
        return $error;
    }



   public function getReviewReplied($review_id = '', $merchant_id = '')
{
    if ($merchant_id <= 0) {
        $merchant_id = -1;
    }

    $data = [];

    $stmt = $this->db->prepare("
        SELECT 
            a.review,
            a.parent_id,
            a.reply_from,
            a.date_created,
            (
                SELECT logo FROM mt_merchant
                WHERE merchant_id = :merchant_id
                LIMIT 1
            ) AS logo
        FROM mt_review a
        WHERE a.parent_id = :review_id
        AND a.status = 'publish'
        ORDER BY a.id ASC
        LIMIT 10
    ");

    $stmt->execute([
        'merchant_id' => $merchant_id,
        'review_id' => $review_id
    ]);

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $val['logo'] = $this->getImage($val['logo']);
            $val['date_posted'] = $this->functions->translateDate($val['date_created']);
            $val['customer_name'] = "Replied By " . $val['reply_from'];

            unset($val['parent_id'], $val['reply_from'], $val['date_created']);
            $data[] = $val;
        }
    }

    return $data;
}



public function getTaskViewByOrderID($order_id = '')
{
    if (!$this->functions->checkIfTableExist('driver_task')) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_driver_task_view
        WHERE order_id = :order_id
        LIMIT 1
    ");

    $stmt->execute([
        'order_id' => $order_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public  function getOrderTabsStatus($tab='')
    {
        $status = ''; $and='';
        switch ($tab) {
            case "processing":      
                $status=$this->functions->getOptionAdmin('mobileapp2_order_processing');
                break;
        
            case "completed":               
                $status=$this->functions->getOptionAdmin('mobileapp2_order_completed'); 
                break;
                
            case "cancelled":               
                $status=$this->functions->getOptionAdmin('mobileapp2_order_cancelled'); 
                break;
                        
            default:
                break;
        }   
       
        if(!empty($status)){
            $status = json_decode($status,true);            
            if(is_array($status) && count((array)$status)>=1){
                foreach ($status as $val) {
                   $and .= "'" . $val . "',";

                }
                $and = substr($and,0,-1);
                $and = "AND a.status IN ($and)";
            }
        }
        return $and;
    }


   public function GetBookingDetails($booking_id = '', $client_id = '') 
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_bookingtable 
        WHERE client_id = :client_id 
        AND booking_id = :booking_id 
        LIMIT 1
    ");

    $stmt->execute([
        ':client_id' => $client_id,
        ':booking_id' => $booking_id
    ]);

    return $stmt->fetch(PDO::FETCH_ASSOC) ?: false;
}

    
   

    public function mobileCodeList()
{
    $mobile_countrycode = $this->functions->mobilecountry_code();
    $data = array();
    $data[] = "Please select...";

    foreach ($mobile_countrycode as $key => $val) {                       
        $data[$val['code']] = str_replace(
            ['[name]', '[code]'],
            [$val['name'], $val['code']],
            "[name] +[code]"
        );
    }

    return $data;
}




    public  function trackingTheme()
    {
        return array(
          1 => "Theme 1",
          2 => "Theme 2",
        );
    }
    
    public  function cartTheme()
    {
        return array(
          1 => "Theme 1",
          2 => "Theme 2",
        );
    }
    
    public function getHomeBannerByID($banner_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_mobile2_homebanner
        WHERE banner_id = :banner_id
        LIMIT 1
    ");

    $stmt->execute([
        'banner_id' => $banner_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


    public function getHomeBanner()
{
    $data = array();

    $stmt = $this->db->prepare("
        SELECT banner_name FROM mt_mobile2_homebanner
        WHERE status IN ('publish','published')
        ORDER BY sequence, banner_id ASC
    ");

    $stmt->execute();

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $data[] = $this->getImage($val['banner_name']);
        }
        return $data;
    }

    return false;
}



public function getHomeBannerNew()
{
    $data = array();
    $stmt = "
        SELECT banner_id, title, sub_title, banner_name 
        FROM mt_mobile2_homebanner
        WHERE status IN ('publish', 'published')
        ORDER BY sequence, banner_id ASC
    ";

    $query = $this->db->query($stmt);

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $data[] = array(
                'banner_id'  => $val['banner_id'],
                'title'      => $val['title'],
                'sub_title'  => $val['sub_title'],
                'banner'     => $this->getImage($val['banner_name'])
            );
        }
        return $data;
    }
    
    return false;
}


    
    public function getAddressBookDefault($client_id = '')
{
    if ($client_id > 0) {
        $stmt = $this->db->prepare("
            SELECT a.*, b.contact_phone
            FROM mt_address_book a
            LEFT JOIN mt_client b ON a.client_id = b.client_id
            WHERE a.client_id = :client_id
            AND a.as_default = '2'
            LIMIT 1
        ");

        $stmt->execute([
            'client_id' => $client_id
        ]);

        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    }

    return false;
}


public  function updateCartAddress($data=array(), $device_uiid='')
    {               
        if(empty($device_uiid)){
            return false;
        }
        if(!is_array($data)){
            return false;
        }
        
        $params = array(
          'street'=>isset($data['street'])?$data['street']:'',
          'city'=>isset($data['city'])?$data['city']:'',
          'state'=>isset($data['state'])?$data['state']:'',
          'zipcode'=>isset($data['zipcode'])?$data['zipcode']:'',
          'location_name'=>isset($data['location_name'])?$data['location_name']:'',
          'delivery_lat'=>isset($data['latitude'])?$data['latitude']:'',
          'delivery_long'=>isset($data['longitude'])?$data['longitude']:'',
          'contact_phone'=>isset($data['contact_phone'])?$data['contact_phone']:'',
        );              
       

        $this->functions->updateData('mt_mobile2_cart', $params, 'device_uiid', $device_uiid);

        
    }



        public  function setAutoAddress($merchant_id='',$client_id='', $current_lat=0, $current_lng=0 , $device_uiid='' )
    {       
        if($merchant_id<=0){
            throw new Exception( ("invalid merchant id") );
        }
        
        $address_use = array();
        if($client_id>0){
            $address_use = $this->getAddressBookDefault($client_id);            
        } else {            
            if ($res_recent = $this->getRecentLocation($device_uiid,$current_lat,$current_lng)){
                if(empty($res_recent['street'])){
                    if($resp_lat_address = $this->functions->latToAdress($current_lat,$current_lng)){
                        $res_recent['street']=$resp_lat_address['address'];
                        $res_recent['city']=$resp_lat_address['city'];
                        $res_recent['state']=$resp_lat_address['state'];
                        $res_recent['zipcode']=$resp_lat_address['zip'];                    
                    }
                }               
                if(!empty($res_recent['street'])){
                    $address_use = $res_recent;
                }
            }
        }
        
        if(is_array($address_use) && count($address_use)>=1){
            
            if(empty($address_use['latitude'])){
                throw new Exception( ("invalid latitude") );      
            }
            if(empty($address_use['longitude'])){
                throw new Exception( ("invalid longitude") );     
            }
            if(empty($address_use['street'])){
                throw new Exception( ("invalid street") );        
            }
            
            //dump($address_use);
            $lat = $address_use['latitude']; $lng = $address_use['longitude'];          
            $resp = $this->checkDeliveryAddresNew($merchant_id,$lat, $lng);
            
            if(is_array($resp) && count((array)$resp)>=1){
                //dump($resp);
                $params = array(
                  'street'=>isset($address_use['street'])?$address_use['street']:'',
                  'city'=>isset($address_use['city'])?$address_use['city']:'',
                  'state'=>isset($address_use['state'])?$address_use['state']:'',
                  'zipcode'=>isset($address_use['zipcode'])?$address_use['zipcode']:'',               
                  'location_name'=>isset($address_use['location_name'])?$address_use['location_name']:'',
                  'contact_phone'=>isset($address_use['contact_phone'])?$address_use['contact_phone']:'',
                  'country_code'=>isset($address_use['country_code'])?$address_use['country_code']:'',
                  'delivery_lat'=>$lat,
                  'delivery_long'=>$lng,                  
                );
                
                $min_fees=0;
                $params['delivery_fee']=0;
                $params['min_delivery_order']=0;
                
                if(isset($resp['delivery_fee'])){
                    $params['delivery_fee']=$resp['delivery_fee'];                                                  
                }
                if($resp['distance']>0.001){
                   /*GET MINIMUM ORDER TABLE*/
                   $merchant_minimum_order = $this->functions->getOption('merchant_minimum_order',$merchant_id);
                   $min_fees=$this->functions->getMinOrderByTableRates(
                       $merchant_id,
                       $resp['distance'],
                       $resp['distance_unit'],
                       $merchant_minimum_order
                    );                  
                    $params['min_delivery_order'] = $min_fees;
                }
                if(!is_numeric($params['min_delivery_order'])){
                    $params['min_delivery_order']=0;
                }   
                
                $params['distance'] = $resp['distance'];
                $params['distance_unit'] = $resp['distance_unit'];              
                                                                                                
                return $params;
                
            } else throw new Exception( $resp );        
        } else throw new Exception( ("address invalid") );        
    }


    public  function searchMode()
    {
        $search_mode = $this->functions->getOptionAdmin('home_search_mode');
        $location_mode = $this->functions->getOptionAdmin('admin_zipcode_searchtype');
        if(empty($search_mode)){
           $search_mode = 'address';    
        } elseif ($search_mode=="postcode"){
            $search_mode='location';
        }
        return array(
          'search_mode'=>$search_mode,
          'location_mode'=>$location_mode,
        );
    }
    
    public  function isLocation()
    {
        $mode = $this->searchMode();
        if($mode=="location"){
            return true;
        }
        return false;
    }


    public function getVoucherMerchant($client_id = '', $voucher_code = '', $merchant_id = '')
{
    $stmt = $this->db->prepare("
        SELECT a.*, 
        (
            SELECT COUNT(*) 
            FROM mt_order 
            WHERE voucher_code = :voucher_code 
            AND client_id = :client_id
            LIMIT 1
        ) AS found,
        (
            SELECT COUNT(*) 
            FROM mt_order 
            WHERE voucher_code = :voucher_code
            LIMIT 1
        ) AS number_used
        FROM mt_voucher_new a
        WHERE voucher_name = :voucher_code
        AND merchant_id = :merchant_id
        AND status IN ('publish', 'published')
        LIMIT 1
    ");

    $stmt->execute([
        'voucher_code' => $voucher_code,
        'client_id' => $client_id,
        'merchant_id' => $merchant_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}
 
    
   public function getVoucherAdmin($client_id = '', $voucher_code = '')
{
    $stmt = $this->db->prepare("
        SELECT a.*, 
        (
            SELECT COUNT(*) 
            FROM mt_order 
            WHERE voucher_code = :voucher_code 
            AND client_id = :client_id
            LIMIT 1
        ) AS found,
        (
            SELECT COUNT(*) 
            FROM mt_order 
            WHERE voucher_code = :voucher_code
            LIMIT 1
        ) AS number_used
        FROM mt_voucher_new a
        WHERE voucher_name = :voucher_code
        AND voucher_owner = 'admin'
        AND status IN ('publish', 'published')
        LIMIT 1
    ");

    $stmt->execute([
        'voucher_code' => $voucher_code,
        'client_id' => $client_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}



 public  function standardUnit($unit_type='')
    {
        $type='';
        switch ($unit_type) {
            case "mi":
                $type="M";
                break;        
            case "km":  
                $type="K";
                break;
            default:
                $type="M";
                break;
        }
        return $type;
    }
    
    public function clearCartByCustomerID($client_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_mobile2_cart
        WHERE device_uiid IN (
            SELECT device_uiid 
            FROM mt_mobile2_device_reg 
            WHERE client_id = :client_id
        )
    ");

    $stmt->execute([
        'client_id' => $client_id
    ]);
}



public  function preCheckout($merchant_id='',$date_now='', $delivery_date='', $delivery_time="")
    {
        $continue = false; $code = 2; $message='';
        $merchant_close_msg = $this->functions->getOption('merchant_close_msg',$merchant_id);
        $is_merchant_open = $this->functions->isMerchantOpen($merchant_id);
        $merchant_preorder= $this->functions->getOption("merchant_preorder",$merchant_id);
        /*dump("is_merchant_open=>$is_merchant_open");
        dump("merchant_preorder=>$merchant_preorder");*/
        
        if(!$is_merchant_open){
            if($merchant_preorder==1){
                $continue = true;
            } else $message = empty($merchant_close_msg)?"Merchant is close":$merchant_close_msg;
        } else $continue = true;
        
        if($continue){
            if (!$this->functions->validateSellLimit($merchant_id) ){
                $message = "This merchant has reach the maximum sells per month";
                $continue = false;
            }
        }
        
        if($continue){
            if ( $res_holiday =  $this->functions->getMerchantHoliday($merchant_id)){
                if (in_array($delivery_date,$res_holiday)){
                   

                   $message="were close on". $this->functions->prettyDate($delivery_date);
                    
                    $close_msg=$this->functions->getOption('merchant_close_msg_holiday',$merchant_id);
                    if(!empty($close_msg)){
                     

                      $message=$close_msg. $this->functions->prettyDate($delivery_date);

                    }   
                    $continue = false;
                }
            }
        }
        
        $future_order = false;
        
        if($continue){
            if($date_now!=$delivery_date){     
                $future_order = true;           
                if(empty($delivery_time)){
                    $continue = false;          
                    $message = "For furure order delivery time is required";
                }
            }
        }
        
        if($continue){
            $full_delivery = "$delivery_date $delivery_time";       
            $delivery_day = strtolower(date("D",strtotime($full_delivery)));
            
            $delivery_time_formated = '';
            if(!empty($delivery_time)){
                $delivery_time_formated=date('h:i A',strtotime($delivery_time));
            } else $delivery_time_formated = date('h:i A');
            
            if ( !$this->functions->isMerchantOpenTimes($merchant_id,$delivery_day,$delivery_time_formated)){
                
                if(empty($delivery_time)){                          
                    $full_delivery = "$delivery_date $delivery_time_formated";  
                }           
                                
                $date_close=date("F,d l Y h:ia",strtotime($full_delivery));
                

                $message = "Sorry but we are closed ,Please check merchant opening hours.".$date_close;

                $continue = false;
            }                   
        }
        
        if($continue){
            $code = 1;
            $message="OK";
        }
        
        return array(
          'code'=>$code,
          'message'=>$message,
          'future_order'=>$future_order
        );
    }



     public  function getMapProvider()
    {
        $map_provider = $this->functions->getOptionAdmin('map_provider');
        $token = ''; $map_api = '';
        $map_distance_results  = ''; $mode = "driving";
        
        if(empty($map_provider)){
            $map_provider='google.maps';
        }
        
        switch ($map_provider) {
            case "mapbox":
                $token = $this->functions->getOptionAdmin('mapbox_access_token');             
                $map_api = $token;
                $mode = $this->functions->getOptionAdmin('mapbox_method');
                break;

            case "google.maps": 
                $token = $this->functions->getOptionAdmin('google_geo_api_key');
                $map_api = $this->functions->getOptionAdmin('google_maps_api_key');
                $mode = $this->functions->getOptionAdmin('google_distance_method');
            default:
                break;
        }
        
        $map_distance_results = (integer) $this->functions->getOptionAdmin('map_distance_results');
        if($map_distance_results<0){
            $map_distance_results=2;
        }
                
        return array(         
          'provider'=>$map_provider,
          'token'=>$token,
          'map_api'=>$map_api,
          'map_distance_results'=>$map_distance_results,
          'mode'=>$mode
        );
    }   


   public function displayCuisine($merchant_id = '', $multipleField = '')
{
    $cuisine = '';
    $stmt = $this->db->prepare("
        SELECT cuisine_name 
        FROM mt_view_cuisine_merchant
        WHERE merchant_id = :merchant_id
        AND status = 'publish'
        ORDER BY cuisine_name ASC
    ");

    $stmt->execute(['merchant_id' => $merchant_id]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $cuisine .= "{$val['cuisine_name']},";
        }
        $cuisine = rtrim($cuisine, ','); // Remove the trailing comma
    }

    return $cuisine;
}

public function ReOrderGetInfo($order_id = '')
{
    $order_id = (int) $order_id; // Ensure it's an integer
    
    $stmt = $this->db->prepare("
        SELECT a.*, 
               b.restaurant_name, 
               b.status as merchant_status, 
               b.is_ready
        FROM mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE a.order_id = :order_id
        LIMIT 1
    ");

    $stmt->execute(['order_id' => $order_id]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ?: false;
}

    
    public  function canCancel($date_created='', $days=0, $hours=0, $minutes=0)
    {
        if(!empty($date_created)){
            $date_created = date("Y-m-d g:i:s a",strtotime($date_created));         
            $date_now=date('Y-m-d g:i:s a');            
            $time_diff=$this->functions->dateDifference($date_created,$date_now);          
            if(is_array($time_diff) && count($time_diff)>=1){               
                if($days>$time_diff['days']){                   
                    return true;
                } elseif ( $hours>$time_diff['hours'] ) {
                    return true;                    
                } elseif ( $hours>=$time_diff['hours']){                    
                    if($minutes<$time_diff['minutes']){                     
                        return false;
                    } else return true;
                } elseif ( $minutes>=$time_diff['minutes'] ){                   
                    return true;                    
                }
                                
            } else return true;
        }
        return false;
    }


   public function getBannerByID($banner_id = 0)
{
    $stmt = $this->db->prepare("
        SELECT banner_id, title, sub_title, banner_name, tag_id, status
        FROM mt_mobile2_homebanner
        WHERE banner_id = :banner_id AND status = :status
        LIMIT 1
    ");

    $stmt->execute([
        'banner_id' => (int) $banner_id,
        'status' => 'publish'
    ]);

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    throw new Exception("We cannot find your phone number in our records");
}


public function getReceiptByID($order_id = 0, $client_id = 0)
{
    $and = '';
    $order_id = (int)$order_id;
    $client_id = (int)$client_id;

    if ($client_id > 0) {
        $and = " AND a.client_id=" . ($client_id) . "  ";
    }

    $stmt = "
    SELECT a.*,
    concat(b.first_name,'',b.last_name) as full_name,
    b.location_name,
    concat(b.street,' ',b.area_name,' ',b.city,' ',b.state,' ',b.zipcode) as full_address,
    b.contact_phone,
    b.contact_phone as customer_phone,
    b.opt_contact_delivery,
    b.contact_email as email_address,
    b.contact_email as customer_email,
    
    c.restaurant_name as merchant_name,
    c.contact_phone as merchant_contact_phone
    
    FROM mt_order a
    LEFT JOIN mt_order_delivery_address b
    ON a.order_id = b.order_id
    
    LEFT JOIN mt_merchant c
    ON a.merchant_id = c.merchant_id
    
    WHERE a.order_id=" . ($order_id) . "
    $and
    LIMIT 0,1
    ";

    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // FIXED OLD DATA
        if (empty($res['full_name'])) {
            $stmt2 = "
            SELECT 
            concat(first_name,' ',last_name) as full_name,
            contact_phone
            
            FROM mt_client
            WHERE client_id = " . ($res['client_id']) . "
            ";
            $query2 = $this->db->query($stmt2);
            $res2 = $query2->fetch(PDO::FETCH_ASSOC);

            if ($res2) {
                $res['full_name'] = $res2['full_name'];
                $res['contact_phone'] = $res2['contact_phone'];
            }
        }
        return $res;
    }

    return false;
}



public  function settingsMenu()
    {
        $menu = array();
        $menu[] = array(
          'label'=>"API Settings",
          'link'=>Config::$baseUrl."/webappv2/index/settings",
          'id'=>'settings'
        );
        
        
        
       
        
        return $menu;
    }



    


  









    




















   


 







  


    

  






    


    








 




























	
	
	
	
	
  			
	    
}
/*END CLASS*/