<div class="uk-width-1">
  <a href="<?php echo Config::$baseUrl; ?>/admin/BranchList/Do/Add" class="uk-button">
    <i class="fa fa-plus"></i> <?php echo $this->functions->translation("default","Add New")?>
  </a>
  <a href="<?php echo Config::$baseUrl; ?>/admin/BranchList" class="uk-button">
    <i class="fa fa-list"></i> <?php echo $this->functions->translation("default","List")?>
  </a>
</div>

<?php 
if (isset($_GET['id']) && !$data = $this->functions->getBranch($_GET['id'])) {
  echo "<div class=\"uk-alert uk-alert-danger\">" .
       $this->functions->translation("default","Sorry but we cannot find what you're looking for.") .
       "</div>";
  return;
}



?>

<?php
if (isset($_GET['id'])) {
    $saved_branches = json_decode($data['merchant_id'], true);
    if (!is_array($saved_branches)) {
        $saved_branches = [];
    }
} else {
    $saved_branches = [];
}

$merchant_list = $this->functions->getActivemerchantList($saved_branches);



?>

<div class="spacer"></div>
<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="frm-pop" method="post">
  <input type="hidden" name="action" value="saveBranch">
  <input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? (int)$_GET['id'] : ''; ?>">


  <?php if (!isset($_GET['id'])): ?>
    <input type="hidden" name="redirect" id="redirect" value="<?php echo htmlspecialchars(Config::$baseUrl . '/admin/BranchList/Do/Add', ENT_QUOTES, 'UTF-8'); ?>">
<?php endif; ?>


  <div class="uk-form-row">
    <label class="uk-form-label">Title</label>  
    <input type="text" name="branch_name" value="<?php echo isset($data['branch_name']) ? htmlspecialchars($data['branch_name'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
           class="uk-form-width-large" data-validation="required">
  </div>

 <div class="uk-form-row">
    <label class="uk-form-label">Linked Branch</label>  
    <select name="merchant_id[]" multiple class="chosen uk-form-width-large" data-validation="required">
      <?php 
      foreach ($merchant_list as $merchant) {
          $selected = in_array($merchant['merchant_id'], $saved_branches) ? 'selected' : '';
          echo '<option value="' . htmlspecialchars($merchant['merchant_id'], ENT_QUOTES, 'UTF-8') . '" ' . $selected . '>' .
               htmlspecialchars($merchant['restaurant_name'], ENT_QUOTES, 'UTF-8') . '</option>';
      }
      ?>
    </select>
  </div>

  <div class="uk-form-row">
    <label class="uk-form-label"></label>
    <input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
  </div>
</form>
