<?php
$enabled=$this->functions->getOptionAdmin('admin_commission_enabled');
$disabled_membership=$this->functions->getOptionAdmin('admin_disabled_membership');
$admin_commision_ontop=$this->functions->getOptionAdmin('admin_commision_ontop');
?>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="commissionSettings">

<h3><?php echo $this->functions->translation("default","Admin Commission Settings")?></h3>

<h3><?php $this->functions->translation("default","Admin Commission Settings")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Balance include all offline payment")); ?>
  </label>
  <input type="checkbox" name="admin_include_all_offline_payment" value="1" class="icheck"
    <?php echo ($this->functions->getOptionAdmin('admin_include_all_offline_payment') == 1) ? 'checked' : ''; ?>>
</div>

<p class="uk-text-muted">
   <?php echo $this->functions->translation("default","this will include all offline payment in merchant balance and total commission")?>
  </p>




<h3><?php echo $this->functions->translation("default","Merchant Signup Settings")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Enabled Commission")); ?>?
  </label>
  <input type="checkbox" name="admin_commission_enabled" value="yes" class="icheck"
    <?php echo ($enabled == "yes") ? 'checked' : ''; ?>>
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Disabled Membership Signup")); ?>?
  </label>
  <input type="checkbox" name="admin_disabled_membership_signup" value="1" class="icheck"
    <?php echo ($this->functions->getOptionAdmin('admin_disabled_membership_signup') == 1) ? 'checked' : ''; ?>>
</div>



		
<!-- Custom code 1 starts-->	
<div class="uk-form-row">   
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "commission on offline payment")); ?>
  </label>    
  <select name="admin_offline_commision_type" class="uk-form-width-small">
    <option value="percentage" <?php echo ($this->functions->getOptionAdmin('admin_offline_commision_type') == 'percentage') ? 'selected' : ''; ?>>
      <?php echo htmlspecialchars($this->functions->translation("default","Percentage")); ?>
    </option>
    <option value="fixed" <?php echo ($this->functions->getOptionAdmin('admin_offline_commision_type') == 'fixed') ? 'selected' : ''; ?>>
      <?php echo htmlspecialchars($this->functions->translation("default","Fixed")); ?>
    </option>
  </select>
  <input type="text" name="admin_offline_commision_percent"
    value="<?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_offline_commision_percent')); ?>"
    class="uk-form-width-small numeric_only" />
</div>

<div class="uk-form-row">   
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "commission on online payment")); ?>
  </label>    
  <select name="admin_online_commision_type" class="uk-form-width-small">
    <option value="percentage" <?php echo ($this->functions->getOptionAdmin('admin_online_commision_type') == 'percentage') ? 'selected' : ''; ?>>
      <?php echo htmlspecialchars($this->functions->translation("default","Percentage")); ?>
    </option>
    <option value="fixed" <?php echo ($this->functions->getOptionAdmin('admin_online_commision_type') == 'fixed') ? 'selected' : ''; ?>>
      <?php echo htmlspecialchars($this->functions->translation("default","Fixed")); ?>
    </option>
  </select>
  <input type="text" name="admin_online_commision_percent"
    value="<?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_online_commision_percent')); ?>"
    class="uk-form-width-small numeric_only" />
</div>

<!-- Custom code 1 ends-->

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Set commission on")?></label>  
</div>
<ul>
<li style="margin-bottom:10px;">
    <input type="radio" name="admin_commision_ontop" value="1" 
      <?php echo ($admin_commision_ontop == 1) ? 'checked' : ''; ?> 
      class="icheck" />
    &nbsp;&nbsp;<?php echo htmlspecialchars($this->functions->translation("default", "Commission on Sub total order")); ?>
  </li>
  <li>
    <input type="radio" name="admin_commision_ontop" value="2" 
      <?php echo ($admin_commision_ontop == 2) ? 'checked' : ''; ?> 
      class="icheck" />
    &nbsp;&nbsp;<?php echo htmlspecialchars($this->functions->translation("default", "Commission on Total order")); ?>
  </li>
</ul>	


<h3><?php $this->functions->translation("default","Total Commission")?></h3>
<?php  
$order_stats=$this->functions->orderStatusList2(false);
$total_commission_status=$this->functions->getOptionAdmin('total_commission_status');
if (!empty($total_commission_status)){
	$total_commission_status=json_decode($total_commission_status);
} else {
	$total_commission_status=array('paid');
}
?>

<div class="uk-form-row">
  <label class="uk-form-label" style="padding-right:5px;">
    <?php echo htmlspecialchars($this->functions->translation("default", "Compute Total Commission base on the following order status")); ?>
  </label>
  <select name="total_commission_status[]" class="chosen uk-form-width-large" multiple>
    <?php foreach ($order_stats as $key => $value): ?>
      <option value="<?php echo htmlspecialchars($key); ?>" 
        <?php echo in_array($key, $total_commission_status) ? 'selected' : ''; ?>>
        <?php echo htmlspecialchars($value); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>



  
<h3><?php $this->functions->translation("default","Commission+Invoice Payment Information")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Account name")); ?>
  </label>
  <input type="text" name="admin_bank_account_name" 
         value="<?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_bank_account_name')); ?>" 
         class="uk-form-width-large" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Account number")); ?>
  </label>
  <input type="text" name="admin_bank_account_number" 
         value="<?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_bank_account_number')); ?>" 
         class="uk-form-width-large" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Custom Template")); ?>
  </label>
  <textarea name="admin_bank_custom_tpl" 
            class="uk-form-width-large"><?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_bank_custom_tpl')); ?></textarea>
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Deposited Timeframe")); ?>
  </label>
  <input type="text" name="admin_bank_deposited_timeframe" 
         value="<?php echo htmlspecialchars($this->functions->getOptionAdmin('admin_bank_deposited_timeframe')); ?>" 
         placeholder="<?php echo htmlspecialchars(("In days")); ?>" 
         class="numeric_only" />
  <span class="uk-text-muted">
    <?php echo htmlspecialchars($this->functions->translation("default", "after invoice date creation")); ?>
  </span>
</div>



  
<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>