<?php
$query='last15';
if (isset($_GET['query'])){
	$query=$_GET['query'];
}
if (isset($_GET['start_date'])){

	if (!empty($_GET['start_date'])){
		$query='period';
	}
}

$months=$this->functions->getLastTwoMonths();

$order_stats=$this->functions->orderStatusList2(false);    

$total_commission_status=$this->functions->getOptionAdmin('total_commission_status');
if (!empty($total_commission_status)){
	$total_commission_status=json_decode($total_commission_status);
} else {
	$total_commission_status=array('paid');
}
if (isset($_GET['merchant_id'])){	
	$total_commission_status=isset($_GET['stats_id'])?$_GET['stats_id']:'';
}
?>

<div class="uk-width-1">

<a href="<?php echo Config::$baseUrl . '/admin/merchantcommission/query/all'; ?>" class="uk-button selected_transaction_query all">
    <?php echo $this->functions->translation("default","All"); ?>
</a>


<a href="<?php echo Config::$baseUrl . '/admin/merchantcommission/query/last15'; ?>" class="uk-button selected_transaction_query last15">
    <?php echo $this->functions->translation("default","Last 15 days"); ?>
</a>


<a href="<?php echo Config::$baseUrl . '/admin/merchantcommission/query/last30'; ?>" class="uk-button selected_transaction_query last30">
    <?php echo $this->functions->translation("default","Last 30 days"); ?>
</a>


<?php if (is_array($months) && count($months)>=1):?>
<?php foreach ($months as $key=>$months_val):?>
<a  href="<?php echo Config::$baseUrl.'/admin/merchantcommission/query/month/date/'.$key; ?>" class="uk-button selected_transaction_query <?php echo "selected-".$key;?>"><?php echo $this->functions->translateDate($months_val)?></a>
<?php endforeach;?>
<?php endif;?>

</div>

<div style="height:25px;"></div>

<form id="frm_table_list" method="GET" class="report uk-form uk-form-horizontal" >
<input type="hidden" name="start_date" id="start_date" value="<?php echo isset($_GET['start_date']) ? htmlspecialchars($_GET['start_date'], ENT_QUOTES, 'UTF-8') : '' ?>">
<input type="hidden" name="end_date" id="end_date" value="<?php echo isset($_GET['end_date']) ? htmlspecialchars($_GET['end_date'], ENT_QUOTES, 'UTF-8') : '' ?>">


<div style="height:20px;"></div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo htmlspecialchars($this->functions->translation("default","Merchant Name"), ENT_QUOTES, 'UTF-8'); ?></label>
  
  <select name="merchant_id" class="chosen uk-form-width-large">
    
    <?php 
    $merchantList = $this->functions->merchantList2(true);
    foreach ($merchantList as $id => $name): 
      $selected = (isset($_GET['merchant_id']) && $_GET['merchant_id'] == $id) ? ' selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>"<?php echo $selected; ?>>
        <?php echo htmlspecialchars($name, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>


  
<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Start Date"), ENT_QUOTES, 'UTF-8'); ?>
  </label>
  <input type="text" name="start_date1"  id="start_date1"
         value="<?php echo isset($_GET['start_date1']) ? htmlspecialchars($_GET['start_date1'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
         class="uk-form-width-large j_date" 
         data-id="start_date" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "End Date"), ENT_QUOTES, 'UTF-8'); ?>
  </label>
  <input type="text" name="end_date1"  id="end_date1"
         value="<?php echo isset($_GET['end_date1']) ? htmlspecialchars($_GET['end_date1'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
         class="uk-form-width-large j_date" 
         data-id="end_date" />
</div>




<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Status"), ENT_QUOTES, 'UTF-8'); ?>
  </label>
  
  <select name="stats_id[]" class="chosen uk-form-width-large" multiple>
    <?php 
    foreach ($order_stats as $value => $label): 
      $selected = (in_array($value, $total_commission_status)) ? ' selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>"<?php echo $selected; ?>>
        <?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>




<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo htmlspecialchars($this->functions->translation("default", "Payment Type"), ENT_QUOTES, 'UTF-8'); ?>
  </label>
  
  <select name="payment_type" class="uk-form-width-large">
    <option value="1" <?php echo (isset($_GET['payment_type']) && $_GET['payment_type'] == 1) ? 'selected' : ''; ?>>
      All payment type
    </option>
    <option value="2" <?php echo (isset($_GET['payment_type']) && $_GET['payment_type'] == 2) ? 'selected' : ''; ?>>
      All offline payment
    </option>
    <option value="3" <?php echo (isset($_GET['payment_type']) && $_GET['payment_type'] == 3) ? 'selected' : ''; ?>>
      All Online payment
    </option>
  </select>
</div>


<div class="uk-form-row">
  <label class="uk-form-label">&nbsp;</label>
  
  <input type="submit" class="uk-button uk-form-width-medium uk-button-success" value="<?php echo $this->functions->translation("default","Search")?>" >  
  <a href="javascript:;" rel="rptmerchantcommission" class="export_btn uk-button"><?php echo $this->functions->translation("default","Export")?></a>
</div>  

<div style="height:20px;"></div>

<input type="hidden" name="action" id="action" value="merchantCommission">
<input type="hidden" name="tbl" id="tbl" value="mt_merchant">
<input type="hidden" name="clear_tbl"  id="clear_tbl" value="clear_tbl">
<input type="hidden" name="whereid"  id="whereid" value="merchant_id">
<input type="hidden" name="slug" id="slug" value="merchantAdd">

<input type="hidden" name="query" id="query" value="<?php echo htmlspecialchars($query, ENT_QUOTES, 'UTF-8'); ?>" />
<input type="hidden" name="query_date" id="query_date" value="<?php echo isset($_GET['date']) ? htmlspecialchars($_GET['date'], ENT_QUOTES, 'UTF-8') : ''; ?>" />


<table id="table_list" class="uk-table uk-table-hover uk-table-striped uk-table-condensed">
  <caption><?php echo $this->functions->translation("default","Merchant List")?></caption>
   <thead>
        <tr>
            <th width="3%"><?php echo $this->functions->translation("default","ID")?></th>
            <th width="7%"><?php echo $this->functions->translation("default","Merchant Name")?></th>
            <th width="6%"><?php echo $this->functions->translation("default","Total Price")?></th>
            <!--custom code 10 starts -->
            <th width="5%"><?php echo $this->functions->translation("default","Card Fee")?></th> 
            <!--custom code 10 ends -->
            <th width="5%"><?php echo $this->functions->translation("default","Commission")?></th>            
            <th width="5%"></th>            
        </tr>
    </thead>
    <tbody>    
    </tbody>
</table>



<table class="uk-table uk-table-hover uk-table-striped uk-table-condensed">
<thead>
        <tr>            
            <th width="5%"></th>
            <th width="5%"></th>                        
            <th width="5%"><?php echo $this->functions->translation("default","Total Commission Price")?>:</th>            
            <th width="5%"><div class="total_commission"></div></th>  
            <th width="5%"></th>  
        </tr>
    </thead>
    <tbody>    
    </tbody>
</table>
<div class="clear"></div>
</form>