<?php
$merchant_id = $data['merchant_id'];
$default_image = $this->functions->getOption('singleapp_default_image', $merchant_id);
$fast_order_enabled = $this->functions->getOption('fast_order', $merchant_id);
?>

<form id="app-settings-form" method="post">
  <input type="hidden" name="merchant_id" id="merchant_id" value="<?php echo htmlspecialchars($merchant_id); ?>">
  <input type="hidden" name="singleapp_default_image" id="singleapp_default_image" value="<?php echo htmlspecialchars($default_image); ?>" class="singleapp_default_image">

  <p class="between_div"><b><?php echo ("Fast Order") ?></b></p>

  <div class="row">
    <div class="col-md-3">
      <label>
        <input type="checkbox" name="fast_order" value="1" <?php echo $fast_order_enabled == 1 ? 'checked' : ''; ?>>
        Enabled
      </label>
    </div>
  </div>

  <div class="floating_action">
    <button type="submit" class="btn btn-raised btn-info" id="save-api">Save Settings</button>
  </div>
</form>

<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    // Add "active" class to first menu item
    const firstMenuItem = document.querySelector(".menu_nav li:first-child");
    if (firstMenuItem) {
        firstMenuItem.classList.add("active");
    }

    // Handle save-api button click
    document.body.addEventListener("click", function (e) {
        if (e.target && e.target.id === "save-api") {
            e.preventDefault();

            busy(true);
            const saveBtn = document.getElementById("save-api");
            saveBtn.value = "Processing";
            saveBtn.style.pointerEvents = "none";

            const form = saveBtn.closest("form");
            const formData = $(form).serialize(); // Using jQuery

            $.ajax({
                type: "POST",
                url: "/pos/ajax/save_appsettings",
                dataType: "json",
                cache: false,
                data: formData,
                success: function (data) {
                    if (data.code === 1) {
                        nAlert(data.msg, "success");
                    } else {
                        nAlert(data.msg, "warning");
                    }
                },
                complete: function () {
                    busy(false);
                    saveBtn.value = "Save Settings";
                    saveBtn.style.pointerEvents = "auto";
                }
            });
        }
    });
});
</script>
