
<div style="padding:20px;">
<?php if (isset($data['rate_id'])):?>
<h3><?php echo $this->functions->translation("default","Update Rate")?></h3>
<?php else :?>
<h3><?php echo $this->functions->translation("default","Add Rate")?></h3>
<?php endif;?>

<form id="newforms" class="uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
    <input type="hidden" name="action" id="action" value="SaveRate">
    
    <?php if (isset($data['rate_id'])): ?>
        <input type="hidden" name="rate_id" id="rate_id" value="<?php echo htmlspecialchars($data['rate_id'], ENT_QUOTES, 'UTF-8'); ?>">
    <?php endif; ?>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Country"); ?></label>
  <select name="rate_country_id" id="rate_country_id" class="uk-form-width-large rate_country_id" data-validation="required">
    <?php 
    $selectedCountry = isset($data['country_id']) ? $data['country_id'] : $default_country_id;
    foreach ($this->functions->countrysList() as $key => $value): 
      $selected = ($key == $selectedCountry) ? 'selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selected; ?>>
        <?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "State/Region"); ?></label>
  <select name="rate_state_id" id="rate_state_id" class="uk-form-width-large rate_state_id" data-validation="required">
    <?php 
    $selectedState = isset($data['state_id']) ? $data['state_id'] : '';
    foreach ($states as $key => $value): 
      $selected = ($key == $selectedState) ? 'selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selected; ?>>
        <?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "City"); ?></label>
  <select name="rate_city_id" id="rate_city_id" class="uk-form-width-large rate_city_id" data-validation="required">
    <?php 
    $selectedCity = isset($data['city_id']) ? $data['city_id'] : '';
    foreach ((array) $citys as $key => $value): 
      $selected = ($key == $selectedCity) ? 'selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selected; ?>>
        <?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "District/Area/Neighborhood"); ?></label>
  <select name="rate_area_id" id="rate_area_id" class="uk-form-width-large rate_area_id" data-validation="required">
    <?php 
    $selectedArea = isset($data['area_id']) ? $data['area_id'] : '';
    foreach ((array) $areas as $key => $value): 
      $selected = ($key == $selectedArea) ? 'selected' : '';
    ?>
      <option value="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>" <?php echo $selected; ?>>
        <?php echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Fee"); ?></label>
  <input type="text" name="fee" id="fee" class="numeric_only" data-validation="required"
    value="<?php echo isset($data['fee']) ? htmlspecialchars($this->functions->normalPrettyPrice($data['fee']), ENT_QUOTES, 'UTF-8') : ''; ?>">
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Minimum Order"); ?></label>
  <input type="text" name="minimum_order" id="minimum_order" class="numeric_only"
    value="<?php echo isset($data['minimum_order']) ? htmlspecialchars($this->functions->normalPrettyPrice($data['minimum_order']), ENT_QUOTES, 'UTF-8') : ''; ?>">
</div>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Free delivery above sub total"); ?></label>
  <input type="text" name="free_above_subtotal" class="numeric_only"
    value="<?php echo isset($data['free_above_subtotal']) ? htmlspecialchars($this->functions->normalPrettyPrice($data['free_above_subtotal']), ENT_QUOTES, 'UTF-8') : ''; ?>">
</div>


<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
<?php if (isset($data['rate_id'])):?> 
  <a href="javascript:;" class="uk-button uk-button-danger location_delete" data-id="<?php echo $data['rate_id']?>" >
  <?php echo $this->functions->translation("default","Delete")?>
  </a>
<?php endif;?>
</div>

</form>
</div>

<script type="text/javascript">
jQuery(document).ready(function() {	
		
	$('.numeric_only').keyup(function () {     
      this.value = this.value.replace(/[^0-9\.]/g,'');
    });	
    
	$( document ).delegate( ".rate_country_id", "change", function() {				
		loadStateList( $("#rate_country_id").val() );
	});
	
	$( document ).delegate( ".rate_state_id", "change", function() {				
		loadCityListx( $(".rate_state_id").val() );
	});
		
	$( document ).delegate( ".rate_city_id", "change", function() {				
		loadAreaList( $(".rate_city_id").val() );
	});
	
});
$.validate({ 	
	language : jsLanguageValidator,
    form : '#newforms',    
    onError : function() {      
    },
    onSuccess : function() {           
      var params=$("#newforms").serialize();	
      callAjax( $("#action").val(), params , '' ) ;
      return false;
    }  
});
</script>