<?php 
$merchant_id=$this->functions->getMerchantID();
$merchant_notify_email=$this->functions->getOption("merchant_notify_email",$merchant_id);
$enabled_alert_notification=$this->functions->getOption("enabled_alert_notification",$merchant_id);
$enabled_alert_sound=$this->functions->getOption("enabled_alert_sound",$merchant_id);

$merchant_info=$this->functions->getMerchantInfo();
$merchant_info=(array)$merchant_info[0];
?>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="AlertSettings">

<h3><?php echo $this->functions->translation("default","Enabled Alert Settings")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Disabled Email Alert Notification"); ?>?
  </label>
  <input type="checkbox" name="enabled_alert_notification" id="enabled_alert_notification" value="1" 
         class="icheck" <?php echo $enabled_alert_notification == 1 ? 'checked' : ''; ?>>
</div>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Email address"); ?>
  </label>
  <input type="text" name="merchant_notify_email" id="merchant_notify_email" 
         value="<?php echo htmlspecialchars($merchant_notify_email); ?>" 
         class="uk-form-width-large">
  <p style="padding-left: 200px;" class="uk-text-muted">
    <?php echo $this->functions->translation("default", "Email address of the person who will receive if there is new order. Multiple email must be separated by comma."); ?>
  </p>
</div>

  
<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Disabled sounds alert"); ?>?
  </label>
  <input type="checkbox" name="enabled_alert_sound" id="enabled_alert_sound" value="1" 
         class="icheck" <?php echo $enabled_alert_sound == 1 ? 'checked' : ''; ?>>
</div>

<p style="padding-left: 200px;" class="uk-text-muted"><?php echo $this->functions->translation("default","Play alert sounds when there is new order")?></p>


<?php if ($merchant_info['merchant_type']==3):?>
<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Invoice Email address"); ?>
  </label>
  <input type="text" name="merchant_invoice_email" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'merchant_invoice_email',$merchant_id)); ?>" 
         class="uk-form-width-large">
  <p style="padding-left: 200px;" class="uk-text-muted">
    <?php echo $this->functions->translation("default", "Email address that will receive invoice"); ?>
  </p>
</div>

<?php endif;?>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo ("Order cancel request notification"); ?>
  </label>
  <input type="text" name="merchant_cancel_order_email" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'merchant_cancel_order_email',$merchant_id)); ?>" 
         class="uk-form-width-large">
  <p style="padding-left: 200px;" class="uk-text-muted">
    <?php echo ("Email address that will receive order request cancelation"); ?>
  </p>
</div>

<div class="uk-form-row">
  <label class="uk-form-label"></label>
  <input type="text" name="merchant_cancel_order_phone" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'merchant_cancel_order_phone',$merchant_id)); ?>" 
         class="uk-form-width-large">
  <p style="padding-left: 200px;" class="uk-text-muted">
    <?php echo ("Phone number that will receive order request cancelation"); ?>
  </p>
</div>


<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>