<?php
$days=$this->functions->dayList();

?>

<div class="uk-width-1">
<a href="<?php echo Config::$baseUrl; ?>/merchant/CategoryList/Do/Add" class="uk-button"><i class="fa fa-plus"></i> <?php echo $this->functions->translation("default","Add New")?></a>
<a href="<?php echo Config::$baseUrl; ?>/merchant/CategoryList" class="uk-button"><i class="fa fa-list"></i> <?php echo $this->functions->translation("default","List")?></a>
<a href="<?php echo Config::$baseUrl; ?>/merchant/CategoryList/Do/Sort" class="uk-button"><i class="fa fa-sort-alpha-asc"></i> <?php echo $this->functions->translation("default","Sort")?></a>
</div>

<div class="spacer"></div>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="addCategory">
<input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? htmlspecialchars($_GET['id'], ENT_QUOTES, 'UTF-8') : ''; ?>">
<?php if (!isset($_GET['id'])): ?>
<input type="hidden" name="redirect" id="redirect" value="<?php echo htmlspecialchars(Config::$baseUrl . "/merchant/CategoryList/Do/Add", ENT_QUOTES, 'UTF-8'); ?>">
<?php endif; ?>


<?php 
if (isset($_GET['id'])){
	if (!$data=$this->functions->getCategory2($_GET['id'])){
		echo "<div class=\"uk-alert uk-alert-danger\">".
		$this->functions->translation("default","Sorry but we cannot find what your are looking for.")."</div>";
		return ;
	}	
}
?>                                 

<div class="uk-form-row">
<?php if ( 1==2):?>

<ul data-uk-tab="{connect:'#tab-content'}" class="uk-tab uk-active">
   
</ul>

<ul class="uk-switcher" id="tab-content">

  
</ul>

<?php else : // Normal field?>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Food Category Name")?></label>
    <input type="text" name="category_name" 
           value="<?php echo isset($data['category_name']) ? htmlspecialchars($data['category_name']) : "" ?>"
           class="uk-form-width-large"
           data-validation="required">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Description")?></label>
    <input type="text" name="category_description" 
           value="<?php echo isset($data['category_description']) ? htmlspecialchars($data['category_description']) : "" ?>"
           class="uk-form-width-large">
</div>


<?php endif;?>


<div class="uk-form-row"> 
  <label class="uk-form-label"><?php echo ("Featured Image")?></label>
  <a href="javascript:;" id="sau_merchant_upload_file" 
   class="button uk-button" data-progress="sau_merchant_progress" data-preview="image_preview" data-field="photo">
    <?php echo ("Browse")?>
  </a>
</div>
<div class="sau_merchant_progress"></div>

<div class="image_preview">
 <?php
$image = isset($data['photo']) ? $data['photo'] : '';
$image_url = $this->functions->getImage($image);
if (!empty($image_url)) {
    echo '<img src="' . htmlspecialchars($image_url) . '" class="uk-thumbnail" id="logo-small" />';
    echo '<input type="hidden" name="photo" id="photo" value="' . htmlspecialchars($image) . '" />';
    echo '<br/>';
    echo '<a href="javascript:;" class="sau_remove_file" data-preview="image_preview">' . htmlspecialchars(("Remove image")) . '</a>';
}
?>

</div>	

<div style="height:20px;"></div>




<?php
$dish = $this->functions->getDishList();
$dish_selected = isset($data['dish']) ? json_decode($data['dish'], true) : '';
?>

<?php if (is_array($dish) && count($dish) >= 1): ?>
    <div class="uk-form-row">
        <label class="uk-form-label uk-h3"><?php echo $this->functions->translation("default", "Dish"); ?></label>
        <div class="clear"></div>
        <ul class="uk-list uk-list-striped">
            <?php foreach ($dish as $dish_val): ?>
                <li>
                    <input type="checkbox" name="dish[]"
                           <?php echo in_array($dish_val['dish_id'], (array)$dish_selected) ? 'checked' : ''; ?>
                           class="icheck"
                           value="<?php echo htmlspecialchars($dish_val['dish_id']); ?>" />
                    <?php echo htmlspecialchars($dish_val['dish_name']); ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>


  
<h3><?php echo ("Category availability")?></h3>
<p class="small"><?php echo ("Note: the time available should be on same day, eg. 8:00 to 23:00")?></p>

<ul class="uk-list uk-list-striped">
<li>
<table width="80%">
 <tr>
  <td width="33.3%"><?php echo ("Days available")?></td>
  <td width="33.3%"><?php echo ("Start time")?></td>
  <td width="33.3%"><?php echo ("End time")?></td>
</tr>
</table>  
</li>
<?php foreach ($days as $key => $val): ?>
        <li>
            <table width="80%">
                <tr>
                    <td width="33.3%">
                        <input type="checkbox" name="days[<?php echo htmlspecialchars($key); ?>]"
                               <?php echo isset($data[$key]) && $data[$key] ? 'checked' : ''; ?>
                               class="icheck"
                               value="1" />
                        &nbsp;&nbsp;<?php echo htmlspecialchars(ucwords(($val))); ?>
                    </td>
                    <td width="33.3%">
                        <input type="text" name="start_time[<?php echo htmlspecialchars($key); ?>]"
                               value="<?php echo htmlspecialchars(isset($data[$key . "_start"]) ? $data[$key . "_start"] : ''); ?>"
                               class="timepick24format time_mask" />
                    </td>
                    <td width="33.3%">
                        <input type="text" name="end_time[<?php echo htmlspecialchars($key); ?>]"
                               value="<?php echo htmlspecialchars(isset($data[$key . "_end"]) ? $data[$key . "_end"] : ''); ?>"
                               class="timepick24format time_mask" />
                    </td>
                </tr>
            </table>
        </li>
    <?php endforeach; ?>
</ul>

<div class="spacer"></div>


<div class="uk-form-row">
    <label class="uk-form-label">Status</label>
    <select name="status" class="uk-form-width-large" data-validation="required">
        <?php
        $statusList = $this->functions->statusList();
        $selectedStatus = isset($data['status']) ? $data['status'] : '';
        
        foreach ($statusList as $value => $label) {
            $selected = $value === $selectedStatus ? 'selected' : '';
            echo "<option value=\"$value\" $selected>$label</option>";
        }
        ?>
    </select>
</div>


<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>