
<div class="uk-width-1">
<a href="<?php echo Config::$baseUrl; ?>/merchant/offers/Do/Add" class="uk-button"><i class="fa fa-plus"></i> <?php echo $this->functions->translation("default","Add New")?></a>
<a href="<?php echo Config::$baseUrl; ?>/merchant/offers" class="uk-button"><i class="fa fa-list"></i> <?php echo $this->functions->translation("default","List")?></a>
</div>

<div class="spacer"></div>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms" enctype="multipart/form-data">
<input type="hidden" name="action" id="action" value="addOffers">
<input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ""; ?>">
<?php if (!isset($_GET['id'])): ?>
    <input type="hidden" name="redirect" id="redirect" value="<?php echo Config::$baseUrl . '/merchant/offers/Do/Add'; ?>">
<?php endif; ?>


<?php 
if (isset($_GET['id'])){
	if (!$data=$this->functions->getOffers($_GET['id'])){
		echo "<div class=\"uk-alert uk-alert-danger\">".
		$this->functions->translation("default","Sorry but we cannot find what your are looking for.")."</div>";
		return ;
	}	
}
?>                                 

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Offer Percentage")?></label>
  <input type="text" name="offer_percentage" 
         value="<?php echo isset($data['offer_percentage']) ? ($data['offer_percentage']) : ""; ?>" 
         class="numeric_only" 
         data-validation="required" /> %
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Orders Over")?></label>
  <input type="text" name="offer_price" 
         value="<?php echo isset($data['offer_price']) ? $this->functions->standardPrettyFormat($data['offer_price']) : ""; ?>" 
         class="numeric_only" 
         data-validation="required" />
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Valid From")?></label>
  <input type="hidden" name="valid_from"  id="valid_from" 
         value="<?php echo isset($data['valid_from']) ? $data['valid_from'] : ""; ?>" />
  <input type="text" name="valid_from2" id="valid_from2"
         value="<?php echo isset($data['valid_from']) ? $data['valid_from'] : ""; ?>" 
         class="j_date" 
         data-validation="required" 
         data-id="valid_from" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Valid To")?></label>
  <input type="hidden" name="valid_to" id="valid_to"
         value="<?php echo isset($data['valid_to']) ? $data['valid_to'] : ""; ?>" />
  <input type="text" name="valid_to2" id="valid_to2"
         value="<?php echo isset($data['valid_to']) ? $data['valid_to'] : ""; ?>" 
         class="j_date" 
         data-validation="required" 
         data-id="valid_to" />
</div>


<?php 
$applicable_to=array();
if (isset($data['applicable_to'])){
	$applicable_to=json_decode($data['applicable_to'],true);
	//dump($applicable_to);
}
?>
<div class="uk-form-row">
  <label class="uk-form-label"><?php echo ("Applicable to")?></label>
  
  <input type="checkbox" name="applicable_to[]" 
         value="delivery" 
         <?php echo in_array('delivery', (array)$applicable_to) ? 'checked' : ''; ?> />
  &nbsp;<?php echo ("Delivery"); ?>
  
  &nbsp;
  
  <input type="checkbox" name="applicable_to[]" 
         value="pickup" 
         <?php echo in_array('pickup', (array)$applicable_to) ? 'checked' : ''; ?> />
  &nbsp;<?php echo ("Pickup"); ?>
  
  &nbsp;
  
  <input type="checkbox" name="applicable_to[]" 
         value="dinein" 
         <?php echo in_array('dinein', (array)$applicable_to) ? 'checked' : ''; ?> />
  &nbsp;<?php echo ("Dinein"); ?>
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Status")?></label>
  <select name="status" 
          data-validation="required">
    <option value=""><?php echo ("Select Status"); ?></option>
    <?php 
    foreach ((array)$this->functions->statusList() as $key => $value) {
        $selected = (isset($data['status']) && $data['status'] == $key) ? 'selected' : '';
        echo "<option value=\"{$key}\" {$selected}>{$value}</option>";
    }
    ?>
  </select>
</div>

<!--Offer Image-->
<div class="uk-form-row"> 
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Upload Image")?></label>
  <a href="javascript:;" id="single_uploadfile" 
   class="button uk-button" data-progress="single_uploadfile_progress" data-preview="single_uploadfile_preview" data-field="offer_image">
    <?php echo $this->functions->translation("default","Browse")?>
  </a>
</div>
<div class="single_uploadfile_progress"></div>

<div class="single_uploadfile_preview">
    <?php 
    $image = isset($data['offer_image']) ? $data['offer_image'] : '';
    $image_url = $this->functions->getImage($image); 
    if (!empty($image_url)) {
        echo '<img src="' . $image_url . '" class="uk-thumbnail" id="logo-small" />';
        // Hidden input field for offer_image
        echo '<input type="hidden" name="offer_image" id="offer_image" value="' . $image . '">';
        echo '<br />';
        // Remove link
        echo '<a href="javascript:;" class="single_uploadfile_remove" data-preview="single_uploadfile_preview">Remove image</a>';
    }
    ?>
</div>

<div class="spacer"></div>

<!--END Merchant Logo-->

<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>