
<div style="padding:20px;width: 700px;">
<?php if (isset($data['group_id'])):?>
<h3><?php echo ("Update")?></h3>
<?php else :?>
<h3><?php echo ("New")?></h3>
<?php endif;?>

<form id="newforms" class="uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
<input type="hidden" name="action" id="action" value="SaveTimeManagement">

<?php 
$day_selected = isset($data['days']) ? explode(",", $data['days']) : array();

if (isset($data['group_id'])) {
    echo '<input type="hidden" name="edit_group_id" id="edit_group_id" value="' . htmlspecialchars($data['group_id'], ENT_QUOTES) . '">';
}

$order_status = array();
if (isset($data['order_status'])) {
    $order_status = !empty($data['order_status']) ? json_decode($data['order_status'], true) : array();    
}
?>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Transaction Type") ?></label>
    <select name="transaction_type" class="uk-form-width-large" data-validation="required">
        <?php
        foreach ($transaction_list as $key => $value) {
            $selected = (isset($data['transaction_type']) && $data['transaction_type'] == $key) ? 'selected' : '';
            echo '<option value="' . htmlspecialchars($key, ENT_QUOTES) . '" ' . $selected . '>' . htmlspecialchars($value, ENT_QUOTES) . '</option>';
        }
        ?>
    </select>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Days") ?></label>
    <select name="days[]" class="uk-form-width-large chosen" data-validation="required" multiple>
        <?php 
        foreach ($day_list as $key => $value) {
            $selected = (in_array($key, $day_selected)) ? 'selected' : '';
            echo '<option value="' . htmlspecialchars($key, ENT_QUOTES) . '" ' . $selected . '>' . htmlspecialchars($value, ENT_QUOTES) . '</option>';
        }
        ?>
    </select>
</div>


<p class="uk-text-muted"><?php echo $this->functions->translation("default","Note: the time available should be on same day, eg. 8:00 to 23:00")?></p>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Start time") ?></label>


    
    <input type="text" name="start_time" id="start_time" class="timepick24format time_mask" data-validation="required" placeholder="<?php echo ('00:00') ?>" value="<?php echo isset($data['start_time']) ? htmlspecialchars($data['start_time'], ENT_QUOTES) : ''; ?>" />
    <span class="uk-text-muted"><?php echo $this->functions->translation("default", "in 24hours format") ?></span>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "End time") ?></label>
    <input type="text" name="end_time" id="end_time" class="timepick24format time_mask" data-validation="required" placeholder="<?php echo ('00:00') ?>" value="<?php echo isset($data['end_time']) ? htmlspecialchars($data['end_time'], ENT_QUOTES) : ''; ?>" />
    <span class="uk-text-muted"><?php echo $this->functions->translation("default", "in 24hours format") ?></span>
</div>



<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Nos. Order allowed") ?></label>
    <input type="text" name="number_order_allowed" id="number_order_allowed" class="numeric_only" data-validation="required" maxlength="10" value="<?php echo isset($data['number_order_allowed']) ? htmlspecialchars($data['number_order_allowed'], ENT_QUOTES) : ''; ?>" />
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Order status") ?></label>
    <select name="order_status[]" class="uk-form-width-large chosen" multiple>
        <?php foreach ($order_status_list as $status_value => $status_label): ?>
            <option value="<?php echo htmlspecialchars($status_value, ENT_QUOTES); ?>" <?php echo in_array($status_value, $order_status) ? 'selected' : ''; ?>><?php echo htmlspecialchars($status_label, ENT_QUOTES); ?></option>
        <?php endforeach; ?>
    </select>
    <p class="uk-text-muted">
        <?php echo $this->functions->translation("default", "Status that will count the existing order, if empty will use all status") ?>.
    </p>
</div>



<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
<?php if (isset($data['rate_id'])):?> 
  <a href="javascript:;" class="uk-button uk-button-danger location_delete" data-id="<?php echo $data['rate_id']?>" >
  <?php echo $this->functions->translation("default","Delete")?>
  </a>
<?php endif;?>
</div>

</form>
</div>

<script type="text/javascript">
jQuery(document).ready(function() {	
		
	$('.numeric_only').keyup(function () {     
      this.value = this.value.replace(/[^0-9\.]/g,'');
    });	
    	
    $('.time_mask').mask('00:00',{
       	"placeholder":"00:00"
       });
    
     $(".chosen").chosen({
       	  allow_single_deselect:true,       	  
       }); 	
	
});
$.validate({ 	
	language : jsLanguageValidator,
    form : '#newforms',    
    onError : function() {      
    },
    onSuccess : function() {           
      var params=$("#newforms").serialize();	
      callAjax( $("#newforms #action").val(), params , '' ) ;
      return false;
    }  
});
</script>