<?php
$merchant_id=$this->functions->getMerchantID();
$enabled=$this->functions->getOption('stripe_enabled',$merchant_id);
$paymode=$this->functions->getOption('stripe_mode',$merchant_id);
?>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="stripeSettings">


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Enabled Stripe") ?>?
  </label>
  <input type="checkbox" name="stripe_enabled" value="yes" class="icheck"
    <?php echo $enabled == "yes" ? "checked" : ""; ?>>
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Mode") ?>
  </label>
  
  <input type="radio" name="stripe_mode" value="<?php echo $this->functions->translation("default", "Sandbox"); ?>" class="icheck"
    <?php echo $paymode == "Sandbox" ? "checked" : ""; ?>>
  <?php echo $this->functions->translation("default", "Sandbox") ?> 
  
  <input type="radio" name="stripe_mode" value="<?php echo $this->functions->translation("default", "live"); ?>" class="icheck"
    <?php echo $paymode == "live" ? "checked" : ""; ?>>
  <?php echo $this->functions->translation("default", "live") ?> 
</div>



<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Card Fee") ?>
  </label>
  <input type="text" name="merchant_stripe_card_fee" value="<?php echo $this->functions->getOption('merchant_stripe_card_fee', $merchant_id); ?>" class="uk-form-width-large">
</div>


<h3><?php echo $this->functions->translation("default","Sandbox")?></h3>
<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Test Secret key") ?>
  </label>
  <input type="text" name="sanbox_stripe_secret_key" value="<?php echo $this->functions->getOption('sanbox_stripe_secret_key', $merchant_id); ?>" class="uk-form-width-large">
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Test Publishable Key") ?>
  </label>
  <input type="text" name="sandbox_stripe_pub_key" value="<?php echo $this->functions->getOption('sandbox_stripe_pub_key', $merchant_id); ?>" class="uk-form-width-large">
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Webhooks Signing secret") ?>
  </label>
  <input type="text" name="merchant_sandbox_stripe_webhooks" value="<?php echo $this->functions->getOption('merchant_sandbox_stripe_webhooks', $merchant_id); ?>" class="uk-form-width-large">
</div>


<h3><?php echo $this->functions->translation("default","live")?></h3>
<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Live Secret key") ?>
  </label>
  <input type="text" name="live_stripe_secret_key" value="<?php echo $this->functions->getOption('live_stripe_secret_key', $merchant_id); ?>" class="uk-form-width-large">
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Live Publishable Key") ?>
  </label>
  <input type="text" name="live_stripe_pub_key" value="<?php echo $this->functions->getOption('live_stripe_pub_key', $merchant_id); ?>" class="uk-form-width-large">
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Webhooks Signing secret") ?>
  </label>
  <input type="text" name="merchant_live_stripe_webhooks" value="<?php echo $this->functions->getOption('merchant_live_stripe_webhooks', $merchant_id); ?>" class="uk-form-width-large">
</div>


<h3><?php echo $this->functions->translation("default","Webhooks endpoint")?></h3>
<p>
<?php echo $this->functions->translation("default","Your webhook endpoint URL for stripe is [url] and add the event <b>checkout.session.completed</b>",array(
 '[url]'=>"<b>".$this->functions->websiteUrl()."/stripe/webhooks</b>"
))?>
</p>


<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>