<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Delete_account extends MY_Controller
{
public function index()
    {
        if ($this->input->method() === 'post') {
            // Step 1: Get reCAPTCHA response from hidden field
            $recaptcha_token = $this->input->post('recaptcha_response', true);
            $recaptcha_secret = @$this->session->merchantInfo['recaptcha_secret_key'];
    
            // Step 2: Verify with Google
            $verify_response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$recaptcha_secret}&response={$recaptcha_token}");
            $response_data = json_decode($verify_response, true);
    
            // Step 3: Check result
            if (
                empty($response_data['success']) ||
                $response_data['success'] !== true ||
                $response_data['score'] < 0.5 ||  // Adjust score threshold if needed
                $response_data['action'] !== 'delete_account'
            ) {
                $this->session->set_flashdata('error', 'reCAPTCHA verification failed. Please try again.');
                redirect('delete-account');
                return;
            }
    
            // Step 4: Proceed if reCAPTCHA passed
            $data = [
                'name'  => $this->input->post('name', true),
                'email' => $this->input->post('email', true)
            ];
    
            $response = apiCall('DeleteAccountSubmit', [], $data);
    
            if (isset($response['code']) && $response['code'] == 1) {
                $this->session->set_flashdata('success', $response['msg']);
            } else {
                $this->session->set_flashdata('error', $response['msg']);
            }
    
            redirect('delete-account');
        }
    
        renderView($this, 'site/delete-account');
    }
}
