<?php
class ItemClass
{

    public function __construct() {
       
        //$model = new Model();
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions

  
    }


    public  function paginate()
    {
        return 10;
    }
    
    public  function paginateMigrate()
    {
        return 10;
    }
    
   public function getMerchantMenu($merchant_id = '', $todays_day = '')
{
    $and = '';
    $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id);   
    
    if ($enabled_category_sked == 1) {
        $and .= " AND $todays_day = '1' ";
    }    

    $and_category = '';
    $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
    if ($food_option_not_available == 1) {
        $and_category = " AND not_available = 1 ";
    }

    $paginate = $this->paginate();

    $stmt = "
        SELECT 
            cat_id,
            category_name,
            category_description,
            category_name_trans,
            category_description_trans,
            photo,
            dish,

            (
                SELECT COUNT(*) FROM mt_item
                WHERE merchant_id = $merchant_id
                AND status IN ('publish', 'published')
            ) AS total_item,

            (
                SELECT COUNT(*) FROM mt_view_rs_category
                WHERE cat_id = a.cat_id
                $and_category
            ) AS total_item_in_category

        FROM mt_category a
        WHERE 
            merchant_id = $merchant_id
            AND status IN ('publish', 'published')
            $and
        ORDER BY sequence ASC
    ";

    $query = $this->db->prepare($stmt);
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        $data = [];

        foreach ($res as $val) {
            $total_cat_paginate = $val['total_item_in_category'] > 0 
                ? ceil($val['total_item_in_category'] / $paginate) 
                : 0;

            $total_item = $val['total_item'] > 0 
                ? ceil($val['total_item'] / $paginate) 
                : 0;

            $data[] = [
                'category_id' => $val['cat_id'],
                'category_name' => $this->functions->clearString($val['category_name']),
                'category_description' => $this->functions->clearString($val['category_description']),
                'category_name_trans' => !empty($val['category_name_trans']) 
                    ? json_decode($val['category_name_trans'], true) 
                    : '',
                'photo' => $val['photo'],
                'category_description_trans' => !empty($val['category_description_trans']) 
                    ? json_decode($val['category_description_trans'], true) 
                    : '',
                'dish' => $val['dish'],
                'item' => [],
                'total_item_in_category' => $val['total_item_in_category'],
                'total_cat_paginate' => $total_cat_paginate,
                'total_item' => $total_item + 1
            ];
        }

        return $data;
    }

    return false;
}


public  function insertItemRelationship($merchant_id='',$item_id=0, $data=array())
    {
        $this->deleteItemRelationshipCategory($merchant_id,$item_id);
        if(is_array($data) && count($data)>=1){
            foreach ($data as $cat_id) {
                $params = array(
                  'merchant_id'=>(integer)$merchant_id,
                  'item_id'=>(integer)$item_id,
                  'cat_id'=>(integer)$cat_id
                );              
                $this->functions->insertData("mt_item_relationship_category",$params);
            }
        }
    }


    
   public function deleteItemRelationshipCategory($merchant_id = '', $item_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_item_relationship_category 
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ");
    
    $resp = $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$item_id
    ]);
}


public  function insertItemRelationshipSubcategory($merchant_id='',$item_id=0, $data=array())
    {
        $this->deleteItemRelationshipSubcategory($merchant_id,$item_id);
        $this->deleteItemRelationshipSubcategoryItem($merchant_id,$item_id);
        
        if(is_array($data) && count($data)>=1){
            foreach ($data as $subcat_id=>$val) {
                $params = array(
                  'merchant_id'=>(integer)$merchant_id,
                  'item_id'=>(integer)$item_id,
                  'subcat_id'=>(integer)$subcat_id
                );  
                $this->functions->insertData("mt_item_relationship_subcategory",$params);
                
                if(is_array($val) && count($val)>=1){
                    foreach ($val as $sub_item_id) {
                        $params_sub = array(
                          'merchant_id'=>$merchant_id,
                          'item_id'=>$item_id,
                          'subcat_id'=>$subcat_id,
                          'sub_item_id'=>$sub_item_id,
                        );                      
                        $this->functions->insertData("mt_item_relationship_subcategory_item",$params_sub);
                    }
                }               
            }
        }
    }


   public function deleteItemRelationshipSubcategory($merchant_id = '', $item_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_item_relationship_subcategory 
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ");

    $resp = $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$item_id
    ]);
}

    
    public function deleteItemRelationshipSubcategoryItem($merchant_id = '', $item_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_item_relationship_subcategory_item 
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ");

    $resp = $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$item_id
    ]);
}


public  function insertSubcategoryItemRelationship($sub_item_id=0, $data=array())
    {
        $this->deleteSubcategoryItem($sub_item_id);      
        if(is_array($data) && count($data)>=1){
            foreach ($data as $subcat_id) {
                $params = array(
                  'subcat_id'=>(integer)$subcat_id,
                  'sub_item_id'=>(integer)$sub_item_id
                );              
                $this->functions->insertData("mt_subcategory_item_relationships",$params);              
            }
        }
    }

    
    public function deleteSubcategoryItem($sub_item_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_subcategory_item_relationships 
        WHERE sub_item_id = :sub_item_id
    ");

    $resp = $stmt->execute([
        ':sub_item_id' => (int)$sub_item_id
    ]);
}

public  function insertItemRelatinship($merchant_id='',$item_id='',$data=array())
    {                           
        $this->deleteItemRelationship($merchant_id,$item_id);                
        if(is_array($data['size']) && count($data['size'])>=1){
            foreach ($data['size'] as $key=>$size_id) {                     
                $price = isset($data['price'][$key])?$data['price'][$key]:0;
                $token=$this->generateFoodSizeToken();
                $params = array(
                  'merchant_id'=>(integer)$merchant_id,
                  'item_id'=>(integer)$item_id,
                  'size_id'=>(integer)$size_id,
                  'price'=>(float)$price,
                  'created_at'=>$this->functions->dateNow(),
                  'item_token'=>$token
                );                      
                
                $this->functions->insertData("mt_item_relationship_size",$params);              
            }
        } else {
            $token=$this->generateFoodSizeToken();
            $params = array(
              'merchant_id'=>(integer)$merchant_id,
              'item_id'=>(integer)$item_id,
              'size_id'=>(integer)0,
              'price'=>(float)0,
              'created_at'=>$this->functions->dateNow(),
              'item_token'=>$token
            );                  
            $this->functions->insertData("mt_item_relationship_size",$params);

        }
    }


   public function deleteItemRelationship($merchant_id = '', $item_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_item_relationship_size 
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ");

    $resp = $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$item_id
    ]);
}

    
   public function generateFoodToken()
{
    $token = $this->functions->generateCode(20);

    $stmt = $this->db->prepare("
        SELECT item_token 
        FROM mt_item 
        WHERE item_token = :item_token 
        LIMIT 1
    ");
    
    $stmt->execute([
        ':item_token' => $token
    ]);

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        $token = $this->generateFoodToken();
    }

    return $token;
}


public function generateFoodSizeToken()
{
    $token = $this->functions->generateCode(20);

    $stmt = $this->db->prepare("
        SELECT item_token 
        FROM mt_item_relationship_size 
        WHERE item_token = :item_token 
        LIMIT 1
    ");

    $stmt->execute([
        ':item_token' => $token
    ]);

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        $token = $this->generateFoodSizeToken();
    }

    return $token;
}

    
    public function getItemByCategory($merchant_id = '', $cat_id = '', $page = 0, $page_limit = 10)
{
    $and = '';

    $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);     
    if (!empty($food_option_not_available)) {
        if ($food_option_not_available == 1) {
            $and .= " AND not_available != '2'";
        }
    }

    $stmt = "
        SELECT 
            cat_id, category_name, item_id, item_name, price as raw_price, price, size_id, size_name, photo, not_available, discount,
            cooking_ref, ingredients, item_description, category_sequence,
            category_description,
            (
                SELECT count(*) FROM mt_item_relationship_subcategory
                WHERE item_id = a.item_id
            ) as total_addon
        FROM mt_view_item_cat a
        WHERE merchant_id = :merchant_id
        AND status IN ('publish','published')
        AND cat_id = :cat_id
        $and
        GROUP BY item_id, cat_id
        ORDER BY category_sequence, cat_id, item_id ASC
        LIMIT $page, $page_limit
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':merchant_id' => (int)$merchant_id,
        ':cat_id' => (int)$cat_id
    ]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $this->prepareResults($res);
    }

    return false;
}

public  function prepareResults($res=array())
    {
        $data = array();
        foreach ($res as $val) {                
            $single = 2;
            
            if(strlen($val['cooking_ref'])>0){
                $single = 1;
            }
            if(strlen($val['ingredients'])>0){
                $single = 1;
            }
            if($val['total_addon']>0){
                $single = 1;
            }           
            $val['item_name'] = $this->functions->clearString($val['item_name']);
            
            $val['description_dummy'] = false;
            if (strlen($val['item_description'])<59){
                $val['description_dummy'] = true;
            }
            $val['item_description'] = $this->functions->clearString($val['item_description']);
            
            if(isset($val['category_description'])){
               $val['category_description'] = $this->functions->clearString($val['category_description']);
            }
            
            $val['photo'] = $this->functions->getFoodDefaultImage($val['photo'],false);
            if($val['discount']>0){
                $val['discount_price'] = $this->functions->prettyPrice($val['price']-$val['discount']);
            } else $val['discount_price']='';
            
            $val['price'] = $this->functions->prettyPrice($val['price']);                
            $val['single_item'] = $single;
            $data[]=$val;
        }   
        return $data;       
    }


    public function getCategory($category_id = 0)
{
    $stmt = "
        SELECT 
            cat_id, category_name, category_description, photo, status, 
            category_name_trans, category_description_trans
        FROM mt_category
        WHERE cat_id = :category_id
        AND status IN ('publish', 'published')
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':category_id' => (int)$category_id
    ]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}

    
    public function searchByItem($search_string = '', $merchant_id, $page = 0, $page_limit = 10)
{
    $and = '';

    $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
    if (!empty($food_option_not_available)) {
        if ($food_option_not_available == 1) {
            $and .= " AND not_available != '2'";
        }
    }

    $stmt = "
        SELECT 
            cat_id, category_name, item_id, item_name, price as raw_price, price, size_id, size_name,
            photo, not_available, discount, cooking_ref, ingredients, item_description, category_sequence,
            (
                SELECT COUNT(*) FROM mt_item_relationship_subcategory
                WHERE item_id = a.item_id
            ) as total_addon
        FROM mt_view_item_cat a
        WHERE merchant_id = :merchant_id
        AND status IN ('publish', 'published')
        AND item_name LIKE :search_string
        $and
        GROUP BY item_id, cat_id
        ORDER BY category_sequence, cat_id, item_id ASC
        LIMIT $page, $page_limit
    ";

    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    $query->bindValue(':search_string', "%$search_string%", PDO::PARAM_STR);
    $query->execute();

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $this->prepareResults($res);
    }

    return false;
}


public function getData($table = '', $where = '', $where_val = array())
{
    $table = "mt_" . $table;

    // Replace keys in $where with raw values (no binding)
    foreach ($where_val as $key => $val) {
        $where = str_replace($key, is_numeric($val) ? $val : "'$val'", $where);
    }

    $sql = "SELECT * FROM $table WHERE $where LIMIT 1";
    $stmt = $this->db->query($sql);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    } else {
        throw new Exception("Record not found");
    }
}

    
    public function deleteRelationship($id = '', $primary = '', $table = '')
{
    $trans_table = "mt_" . $table;

    // Check if the table exists
    $stmt = $this->db->query("SHOW TABLES LIKE '$trans_table'");
    if ($stmt->rowCount() > 0) {
        // Prepare the DELETE statement
        $sql = "DELETE FROM $trans_table WHERE $primary = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([':id' => $id]);
    }
}

public function deleteCategory($merchant_id = 0, $cat_id = 0)
{
    // Check if the category is referenced in the mt_order_details table
    $stmt = $this->db->query("SELECT cat_id FROM mt_order_details WHERE cat_id = $cat_id");
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($res) {
        throw new Exception("Cannot delete this item as it has a reference in the order table");
    }
    
    // Retrieve the photo associated with the category
    $stmt = $this->db->query("SELECT photo FROM mt_category WHERE cat_id = $cat_id");
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    $photo = $data['photo'] ?? ''; // Handle the case where no photo is found
    
    // Delete category from mt_category
    $sql = "DELETE FROM mt_category WHERE merchant_id = :merchant_id AND cat_id = :cat_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':cat_id' => $cat_id
    ]);
    
    // Check if the category was successfully deleted
    if ($stmt->rowCount() > 0) {
        // Perform the related deletions
        $this->deleteRelationship($cat_id, 'cat_id', 'category_translation');
        $this->deleteRelationship($cat_id, 'cat_id', 'item_relationship_category');
        
        return true;
    }

    // If the category wasn't deleted, throw an exception
    throw new Exception("Failed, cannot delete records");
}


public function deleteSize($merchant_id = 0, $size_id = 0)
{
    // Check if the size is referenced in mt_order_details
    $stmt = $this->db->query("SELECT cat_id FROM mt_order_details WHERE size_id = $size_id");
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($res) {
        throw new Exception("Cannot delete this item it has reference to order table");
    }

    // Delete from mt_size
    $sql = "DELETE FROM mt_size WHERE merchant_id = :merchant_id AND size_id = :size_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':size_id' => (int)$size_id
    ]);

    if ($stmt->rowCount() > 0) {
        // Delete related records
        $this->deleteRelationship($size_id, 'size_id', 'size_translation');
        $this->deleteRelationship($size_id, 'size_id', 'item_relationship_size');
        return true;
    }

    throw new Exception("Failed cannot delete records");
}

    
    public function deleteAddonCategory($merchant_id = 0, $id = 0)
{
    // Delete from mt_subcategory
    $sql = "DELETE FROM mt_subcategory WHERE merchant_id = :merchant_id AND subcat_id = :subcat_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':subcat_id' => (int)$id
    ]);

    if ($stmt->rowCount() > 0) {
        // Delete related records
        $this->deleteRelationship($id, 'subcat_id', 'subcategory_translation');
        $this->deleteRelationship($id, 'subcat_id', 'item_relationship_subcategory');
        return true;
    }

    throw new Exception("Failed cannot delete records");
}


public function deleteAddonItem($merchant_id = 0, $id = 0)
{
    // Get photo
    $photo = '';
    $sql = "SELECT photo FROM mt_subcategory_item WHERE sub_item_id = $id";
    $stmt = $this->db->query($sql);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($data) {
        $photo = $data['photo'];
    }

    // Delete from mt_subcategory_item
    $sql = "DELETE FROM mt_subcategory_item WHERE merchant_id = :merchant_id AND sub_item_id = :sub_item_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':sub_item_id' => (int)$id
    ]);

    if ($stmt->rowCount() > 0) {
        $this->deleteRelationship($id, 'sub_item_id', 'subcategory_item_translation');
        $this->deleteRelationship($id, 'sub_item_id', 'subcategory_item_relationships');
        return true;
    }

    throw new Exception("Failed cannot delete records");
}


public function deleteIngredients($merchant_id = 0, $id = 0)
{
    $sql = "DELETE FROM mt_ingredients WHERE merchant_id = :merchant_id AND ingredients_id = :ingredients_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':ingredients_id' => (int)$id
    ]);

    if ($stmt->rowCount() > 0) {
        $this->deleteRelationship($id, 'ingredients_id', 'ingredients_translation');
        $this->deleteMetaID($merchant_id, 'ingredients', $id);
        return true;
    }

    throw new Exception("Failed cannot delete records");
}

    
    public function deleteCookingRef($merchant_id = 0, $id = 0)
{
    $sql = "DELETE FROM mt_cooking_ref WHERE merchant_id = :merchant_id AND cook_id = :cook_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':cook_id' => (int)$id
    ]);

    if ($stmt->rowCount() > 0) {
        $this->deleteRelationship($id, 'cook_id', 'cooking_ref_translation');
        $this->deleteMetaID($merchant_id, 'cooking_ref', $id);
        return true;
    }

    throw new Exception("Failed cannot delete records");
}


public function deleteFoodItem($merchant_id = 0, $id = 0)
{
    // Check for reference in order table
    $checkSql = "SELECT cat_id FROM mt_order_details WHERE item_id = $id";
    $stmt = $this->db->query($checkSql);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        throw new Exception("Cannot delete this item it has reference to order table");
    }

    // Retrieve photo and gallery_photo
    $photo = '';
    $gallery_photo = [];

    $photoSql = "SELECT photo, gallery_photo FROM mt_item WHERE item_id = $id";
    $stmt = $this->db->query($photoSql);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($data) {
        $photo = $data['photo'];
        $gallery_photo = json_decode($data['gallery_photo'], true);
    }

    // Delete item
    $deleteSql = "DELETE FROM mt_item WHERE merchant_id = :merchant_id AND item_id = :item_id";
    $stmt = $this->db->prepare($deleteSql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$id
    ]);

    if ($stmt->rowCount() > 0) {
        $this->deleteRelationship($id, 'item_id', 'item_translation');
        $this->deleteRelationship($id, 'item_id', 'item_relationship_category');
        $this->deleteRelationship($id, 'item_id', 'item_relationship_subcategory');
        $this->deleteRelationship($id, 'item_id', 'item_relationship_subcategory_item');
        $this->deleteRelationship($id, 'item_id', 'item_relationship_size');
        $this->deleteAllMeta($merchant_id, $id);

        return true;
    }

    throw new Exception("Failed cannot delete records");
}


public function insertMeta($merchant_id = '', $item_id = '', $meta_name = '', $meta_id = array())
{
    $this->deleteMeta($merchant_id, $item_id, $meta_name);

    if (is_array($meta_id) && count($meta_id) >= 1) {
        $stmt = "INSERT INTO mt_item_meta (id, merchant_id, item_id, meta_name, meta_id) VALUES ";
        $values = [];

        foreach ($meta_id as $id) {
            $values[] = "(NULL, :merchant_id, :item_id, :meta_name, :meta_id)";
        }

        $stmt .= implode(', ', $values);
        
        $query = $this->db->prepare($stmt);

        // Bind parameters for each execution
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        $query->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);

        foreach ($meta_id as $index => $id) {
            $query->bindValue(':meta_id', $id, PDO::PARAM_INT);
            if (!$query->execute()) {
                return false; // Exit if any insertion fails
            }
        }

        return true; // Return true if all inserts were successful
    }

    return false; // Return false if no meta_id provided
}





public function deleteMeta($merchant_id = '', $item_id = '', $meta_name = '')
{
    $stmt = "
    DELETE FROM mt_item_meta
    WHERE 
    merchant_id = :merchant_id
    AND item_id = :item_id
    AND meta_name = :meta_name
    ";

    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);

    if ($query->execute()) {
        return true;
    }
    return false;
}


public function deleteAllMeta($merchant_id = '', $item_id = '')
{
    $sql = "DELETE FROM mt_item_meta WHERE merchant_id = :merchant_id AND item_id = :item_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':item_id' => (int)$item_id
    ]);
}

    
    public function deleteMetaID($merchant_id = '', $meta_name = '', $meta_id = '')
{
    $sql = "DELETE FROM mt_item_meta 
            WHERE merchant_id = :merchant_id 
            AND meta_name = :meta_name 
            AND meta_id = :meta_id";
    $stmt = $this->db->prepare($sql);
    $stmt->execute([
        ':merchant_id' => (int)$merchant_id,
        ':meta_id' => (int)$meta_id,
        ':meta_name' => $meta_name
    ]);
}


 public function deleteDishes($dish_id = 0)
{
    // Delete from mt_dishes
    $sql = "DELETE FROM mt_dishes WHERE dish_id = :dish_id";
    $stmt = $this->db->prepare($sql);
    $resp = $stmt->execute([
        ':dish_id' => (int)$dish_id
    ]);

    if ($resp) {
        // Delete related meta
        $sqlMeta = "DELETE FROM mt_item_meta WHERE meta_name = :meta_name AND meta_id = :meta_id";
        $stmtMeta = $this->db->prepare($sqlMeta);
        $stmtMeta->execute([
            ':meta_name' => 'dish',
            ':meta_id' => (int)$dish_id
        ]);

        // Delete from dishes_translation
        $this->deleteRelationship($dish_id, 'dish_id', 'dishes_translation');

        return true;
    }

    throw new Exception("Failed cannot delete records");
}


public function getDishes($dish_id = 0)
{
    $data = [];

    $stmt = "
        SELECT 
            a.dish_id,
            a.dish_name,
            a.photo,
            a.status,
            IFNULL(b.language, 'default') as language,
            IFNULL(b.dish_name, '') as dish_name_trans
        FROM mt_dishes a
        LEFT JOIN mt_dishes_translation b ON a.dish_id = b.dish_id
        WHERE a.dish_id = :dish_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':dish_id' => (int)$dish_id]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        foreach ($res as $val) {
            $data[$val['language']] = [
                'dish_id'   => $val['dish_id'],
                'dish_name' => $val['language'] === "default" ? $val['dish_name'] : $val['dish_name_trans'],
                'photo'     => $val['photo'],
                'status'    => $val['status'],
            ];
        }
        return $data;
    }

    return false;
}

public function getMerchantCategory($merchant_id = 0)
{
    $stmt = "
        SELECT * FROM mt_category
        WHERE merchant_id = :merchant_id
        AND status = 'publish'
        ORDER BY category_name ASC
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':merchant_id' => (int)$merchant_id]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}





    
    

  
 














	
}
/*end class;*/
