<?php


require_once __DIR__ . '/../../vendor/Paypal-SDK/vendor/autoload.php';  

use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\SandboxEnvironment;
use PayPalCheckoutSdk\Core\ProductionEnvironment;
use PayPalCheckoutSdk\Orders\OrdersCreateRequest;
use PayPalCheckoutSdk\Orders\OrdersCaptureRequest;
        
class PaypalWrapper
{
	public  function paymentCode()
	{
		return 'paypal_v2';
	}

	
	
	public  function createOrder($client_id='', $secret='', $mode='sandbox', $params=array())
	{		       
						
		if($mode=="live"){
			$environment = new ProductionEnvironment($client_id, $secret);
		} else $environment = new SandBoxEnvironment($client_id, $secret); 
		
        $client = new PayPalHttpClient($environment);
       $request = new OrdersCreateRequest();
        $request->prefer('return=representation');
        
        $request->body = $params;       
        
       
        try {
        	$response = $client->execute($request);
        	//dump($response);die();

        	$data=array();
        	foreach($response->result->links as $link){        		
        		$data[$link->rel]=$link->href;
        	}
        	return $data;
        } catch (HttpException $ex) {  print_r($ex->getMessage());die();
        	throw new Exception( $ex->getMessage() );
        }
             
	}
	
	public  function captureRequest($client_id='', $secret='', $mode='sandbox',$payment_token='')
	{				
		if($mode=="live"){
			$environment = new ProductionEnvironment($client_id, $secret);
		} else $environment = new SandBoxEnvironment($client_id, $secret); 
		
	    $client = new PayPalHttpClient($environment);
	        
		try {
												
			$request = new OrdersCaptureRequest($payment_token);
			$request->prefer('return=representation');
			
			$response = $client->execute($request);
									
			return array(
			  'status_code'=>$response->statusCode,
			  'status'=>$response->result->status,
			  'id'=>$response->result->id,
			);
			
		} catch (HttpException $ex) {			
			throw new Exception( $ex->statusCode );
		}
	}
		
}/* end class*/