<?php




class MerchantController extends Controller {


    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $this->ItemWrap = new ItemWrap();
        $this->ItemHtmlWrapper = new ItemHtmlWrapper();

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
    //}
      //echo $_REQUEST['url'];die();

      if (
    !$this->functions->isMerchantLogin() &&
    $_REQUEST['url'] != 'merchant/login' &&
    strpos($_REQUEST['url'], 'autologin') === false &&
    strpos($_REQUEST['url'], 'poli') === false
) {
     $bases = Config::$baseUrl;
    header("Location: " . $bases . "/merchant/login");
    exit(); 
}


if ($this->functions->isMerchantLogin()){
      $requested_url=$_SERVER['REQUEST_URI'];
      $url_parts = explode('/', trim($requested_url, '/'));
      
      if (count($url_parts) >= 2) {
      $action_name = $url_parts[1];
      
      if(!$this->functions->validateMerchantControllerAccess($action_name)){ 
        

          $data = ['crumbsTitle' => $this->functions->translation('default',"Page not found"),
           'msg'=>"Sorry but you don't have permission to access this page"
          ];


          
          $this->view('merchant/noaccess', $data, 'layouts/merchant_tpl');
          exit();


        } 
        }    
    }



   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {

      

        if (!$this->functions->isMerchantLogin()){           
         $captchaEnabled=$this->functions->getOptionAdmin('captcha_merchant_login'); 
    $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 

    //captcha_site_key

     $data = [
            'captchaEnabled' => $captchaEnabled,
            'captcha_site_key' => $captcha_site_key,
            
            ];
        $this->view('merchant/login', $data, 'layouts/login_layout');
        }else{
     
           

      $data = ['crumbsTitle' => $this->functions->translation('default',"Dashboard"),'cancel_order_enabled'=>$this->functions->getOptionAdmin('cancel_order_enabled')];

           

            $this->view('merchant/dashboard', $data, 'layouts/merchant_tpl'); 
             
          
             /*$data = ['crumbsTitle' => $this->functions->translation('default',"Dashboard")];
            $this->view('admin/dashboard', $data, 'layouts/admin_tpl');*/
            
            
        }
    }



public function autologin($params = [])
{
    // Get the merchant ID and token from the params
    $id = $params['id'];
    $token = $params['token'];

    // Prepare the SQL statement using placeholders for parameters
    $stmt = "SELECT * FROM mt_merchant WHERE merchant_id = :merchant_id AND password = :token LIMIT 1";

    // Prepare the statement
    $query = $this->db->prepare($stmt);
    
    // Bind parameters
    $query->bindValue(':merchant_id', $id, PDO::PARAM_INT);
    $query->bindValue(':token', $token, PDO::PARAM_STR);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $_SESSION['kr_merchant_user'] = json_encode($res);

        if (empty($res[0]['session_token'])) {
            $session_token = $this->functions->generateRandomKey() . md5($_SERVER['REMOTE_ADDR']);
            $params = [
                'session_token' => $session_token,
            ];

            // Update the session token in the database
            $this->functions->updateData('mt_merchant', $params, 'merchant_id', $res[0]['merchant_id']);
        } else {
            $session_token = $res[0]['session_token'];
        }

        $_SESSION['kr_merchant_user_session'] = $session_token;
        $_SESSION['kr_merchant_user_type'] = 'admin';

        $bases = Config::$baseUrl;
        header("Location: " . $bases . "/merchant");
        exit();
    } else {
        $msg = $this->functions->translation("default", "Login Failed. Either username or password is incorrect");
        echo $msg;
    }
}






    public function reviewreply($params=[])
  { 

    

    $id=$params['id'];
        $record_id=$params['record_id'];

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }

          if(isset($record_id)&&!empty($record_id)){
             $_GET['record_id']=$record_id;
         }


        
    $merchant_id=$this->functions->getMerchantID();
    //$this->crumbsTitle=Yii::t("default","Customer reviews");
    
    if ( $data=$this->functions->getReviewsById2(isset($_GET['id'])?$_GET['id']:'',$merchant_id)){    
      $data2='';
      if(isset($_GET['record_id'])){
         $data2=$this->functions->getReviewsById($_GET['record_id']);
      }
      

      $data = [
            'crumbsTitle' => $this->functions->translation('default', "Customer reviews"),
            'data'=>$data,
      'data2'=>$data2
            ];
           $this->view('merchant/review-reply', $data, 'layouts/merchant_tpl');


    } else{echo "Sorry but we cannot find what you are looking for.";die();}
  }


   


    public function allorder()
    {
        $merchant_id = $this->functions->getMerchantID();
        

         $data = ['crumbsTitle' => $this->functions->translation('default',"All orders"),'merchant_id'=>$merchant_id];
            $this->view('merchant/all-order-list', $data, 'layouts/merchant_tpl'); 


    }

     public function pointofsale()
    {
        $merchant_id = $this->functions->getMerchantID();
        

         $data = ['crumbsTitle' => $this->functions->translation('default',"All orders"),'merchant_id'=>$merchant_id];
            $this->view('merchant/all-order-list-pos', $data, 'layouts/merchant_tpl'); 


    }


    public function SocialSettings()
  {
    

    $data = ['crumbsTitle' => $this->functions->translation('default',"Social Settings")];
            $this->view('merchant/social-settings', $data, 'layouts/merchant_tpl');

  }


   public function bookings_settings()
  {
    

    $data = ['crumbsTitle' => $this->functions->translation('default',"Booking Settings")];
            $this->view('merchant/booking-settings', $data, 'layouts/merchant_tpl');

  }





    public function Statement_merchant($params=[])
  {
    

     $query=$params['query'];

     $start_date=$params['start_date'];
        

         if(isset($query)&&!empty($query)){
             $_GET['query']=$query;

         }

         if(isset($start_date)&&!empty($start_date)){
             $_GET['start_date']=$start_date;
         }

         if( $_GET['query']=="month"){
          $date=$params['date'];
           if(isset($date)&&!empty($date)){
             $_GET['date']=$date;

            }

         }






    $data = ['crumbsTitle' => $this->functions->translation('default',"Statement")];
            $this->view('merchant/statement', $data, 'layouts/merchant_tpl');

  }

  public function Earnings_merchant()
  {
    $merchant_type = $this->functions->getMerchantTypeBySession();
    if($merchant_type==3 || $merchant_type==1){
      
       $data = [
            'message' => $this->functions->translation('default', "Sorry but you don't have access this page."),
            'crumbsTitle' => $this->functions->translation('default',"Earnings")
            ];
      $this->view('merchant/error', $data, 'layouts/merchant_tpl');
      return ;
    }
    
    $merchant_id =$this->functions->getMerchantID();
    $balance_month = $this->functions->getMerchantBalanceThisMonth($merchant_id);  
    $total_sale = $this->functions->getMerchantTotalSales($merchant_id);   
        
    

    $data = [
            'crumbsTitle' => $this->functions->translation('default',"Earnings"),
            'merchant_type'=>$this->functions->getMerchantTypeBySession(),
             'sale_month'=>$balance_month['balance'],
             'sale_month_count'=>$balance_month['count'],
             'sale_total'=>$total_sale['balance'],
             'total_sale_count'=>$total_sale['count']
            ];
      $this->view('merchant/earnings', $data, 'layouts/merchant_tpl');



  }

  public function Withdrawals_merchant()
  {
    $merchant_type = $this->functions->getMerchantTypeBySession();
    if($merchant_type==3 || $merchant_type==1){
      

       $data = [
            'message' => $this->functions->translation('default', "Sorry but you don't have access this page."),
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals")
            ];
      $this->view('merchant/error', $data, 'layouts/merchant_tpl');
      return ;

    }
    
    $wd_enabled_paypal=$this->functions->getOptionAdmin('wd_enabled_paypal');
    $wd_bank_deposit=$this->functions->getOptionAdmin('wd_bank_deposit'); 



    if ( $wd_enabled_paypal==2 || $wd_bank_deposit==2 ){
      $stats=$this->functions->getOptionAdmin('wd_payout_disabled');
        
      if ($stats==2){
        
       
        $data = [
            'message' => $this->functions->translation('default', "Sorry but widthrawal is disabled by the site owner"),
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals")
            ];
      $this->view('merchant/error', $data, 'layouts/merchant_tpl');
     

      } else {
       
        
        $data = [
            
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals")
            ];
      $this->view('merchant/withdrawals', $data, 'layouts/merchant_tpl');



      }
    } else {
      

       $data = [
            'message' => $this->functions->translation('default', "Sorry but withdrawals is not available this time. admin has not yet set any payment method"),
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals")
            ];
      $this->view('merchant/error', $data, 'layouts/merchant_tpl');
      


    }
  }


  public function WithdrawalsHistory($params=[])
  {

    $do=$params['do'];
        

         if(isset($do)&&!empty($do)){
             $_GET['do']=$do;

         }
    

     $data = [
           
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals History")
            ];
      $this->view('merchant/withdrawals-history', $data, 'layouts/merchant_tpl');

  }

  public function WithdrawalStep2($params=[])
  {

    $id=$params['id'];
        

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;

         }
    

    $data = [
           
            'crumbsTitle' => $this->functions->translation('default',"Withdrawals Complete")
            ];
      $this->view('merchant/withdrawals-step2', $data, 'layouts/merchant_tpl');
  }




 




  public function AlertSettings()
  {
    

    $data = ['crumbsTitle' => $this->functions->translation('default',"Alert Settings")];
            $this->view('merchant/alert-settings', $data, 'layouts/merchant_tpl');

  }


   public function poliinit() 
  {
     $package_id=$_GET['package_id'];
     $type=$_GET['type'];
   /* $order=$this->functions->getOrder($_GET['id']);

    if($data['status']=='paid'){

        $redirec_link=Config::$baseUrl."/store";
         header("Location: " . $redirec_link);
       exit();
      }*/

    $data = [
            'package_id'=>$package_id,
            'type'=>$type
            ];

  $this->view('merchant/poli-init', $data, 'layouts/merchant_tpl');

  
  } 




    public function SMSSettings()
	{
    unset($_SESSION['payment_process']);
		$mechant_sms_enabled=$this->functions->getOptionAdmin('mechant_sms_enabled');
		if ( $mechant_sms_enabled=="yes"){
			
			echo "no acces";die();
		} else {		
			
			$ha_sms_credits=$this->functions->hasSMSCredits();	
			$mechant_sms_purchase_disabled=$this->functions->getOptionAdmin('mechant_sms_purchase_disabled');	

			if ( $mechant_sms_purchase_disabled=="yes"){
				$ha_sms_credits=true;
			}
			//if (Yii::app()->functions->hasSMSCredits()){

      unset($_SESSION["executed_gateway"]);

			if ($ha_sms_credits){
			   
            
			   $data = ['crumbsTitle' => $this->functions->translation('default',"SMS Settings")];
            $this->view('merchant/sms-settings', $data, 'layouts/merchant_tpl'); 

            /*$data = ['crumbsTitle' => $this->functions->translation('default',"SMS Purchase Credits")];
            $this->view('merchant/sms-purchase', $data, 'layouts/merchant_tpl'); */

			} else {
			   
           
			  $data = ['crumbsTitle' => $this->functions->translation('default',"SMS Purchase Credits")];
            $this->view('merchant/sms-purchase', $data, 'layouts/merchant_tpl'); 
			}
		}
	}

  public function SmsBroadcast($params=[])
  {

    $do=$params['Do'];
    $bid=$params['bid'];
        

         if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($bid)&&!empty($bid)){
             $_GET['bid']=$bid;
         }

          



    if ($this->functions->hasSMSCredits()){
      if (isset($_GET['Do'])){
        if ($_GET['Do']=="view"){
          

        $data = ['crumbsTitle' => $this->functions->translation('default',"SMS BroadCast Details". " ($_GET[bid])")];
       $this->view('merchant/sms-broadcast-details', $data, 'layouts/merchant_tpl'); 

        } else {

           

       $data = ['crumbsTitle' => $this->functions->translation('default',"Add SMS BroadCast")];
       $this->view('merchant/sms-broadcast', $data, 'layouts/merchant_tpl'); 
        }
      } else {    
        

       $data = ['crumbsTitle' => $this->functions->translation('default',"SMS BroadCast")];
       $this->view('merchant/sms-broadcast-list', $data, 'layouts/merchant_tpl'); 

      }
    } else {
       $data = ['crumbsTitle' => $this->functions->translation('default',"SMS Purchase Credits")];
       $this->view('merchant/sms-purchase', $data, 'layouts/merchant_tpl'); 
    }
  }




	 public function SalesReport()
    {
    	
    	

    	 $data = ['crumbsTitle' => $this->functions->translation('default',"Sales Report")];
         $this->view('merchant/sales-report', $data, 'layouts/merchant_tpl'); 
    }

    public function SmsReceipt($params=[])
  {
    $_SESSION['executed_gateway']=2;
    $id=$params['id'];
    if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
    }

    $data = [
            'crumbsTitle' => $this->functions->translation('default', "Receipt"),
            ];
    $this->view('merchant/sms-receipt', $data, 'layouts/merchant_tpl');

  }




public function User($params=[])
  {
    //$this->crumbsTitle=Yii::t("default","User List");
    $do=$params['Do'];
    if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         $id=$params['id'];
    if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }

    



    if (isset($_GET['Do'])){
      //$this->crumbsTitle=Yii::t("default","User Add/Update");
      
      $menu=$this->functions->merchantMenu();  
      $merchant_info = $this->functions->getMerchantInfo();
      $merchant_access = json_decode($merchant_info[0]->user_access,true);          
            
      $new_items = array();
      if(is_array($menu) && count($menu)>=1){
        foreach ($menu['items'] as $val) {                     
           if(is_array($merchant_access) && count($merchant_access)>=1){
             if (in_array($val['tag'],(array)$merchant_access)){
              $new_items[]=$val;
             }
           } else {
             $new_items[]=$val;
           }
        }
      }
      $menu['items']=$new_items;
      
      


       $data = [
        'crumbsTitle' => $this->functions->translation('default',"User Add/Update"),
         'merchant_access'=>$merchant_access,
          'menu'=>$menu
     ];
         $this->view('merchant/user-add', $data, 'layouts/merchant_tpl'); 



    } else{

      $data = [
        'crumbsTitle' => $this->functions->translation('default',"User List")
     ];
         $this->view('merchant/user-list', $data, 'layouts/merchant_tpl'); 

    }    
  }


  public function User_pos($params=[])
  {
    //$this->crumbsTitle=Yii::t("default","User List");
    $do=$params['Do'];
    if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         $id=$params['id'];
    if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }

    



    if (isset($_GET['Do'])){
      //$this->crumbsTitle=Yii::t("default","User Add/Update");
      
      $menu=$this->functions->merchantMenu();  
      $merchant_info = $this->functions->getMerchantInfo();
      $merchant_access = json_decode($merchant_info[0]->user_access,true);          
            
      $new_items = array();
      if(is_array($menu) && count($menu)>=1){
        foreach ($menu['items'] as $val) {                     
           if(is_array($merchant_access) && count($merchant_access)>=1){
             if (in_array($val['tag'],(array)$merchant_access)){
              $new_items[]=$val;
             }
           } else {
             $new_items[]=$val;
           }
        }
      }
      $menu['items']=$new_items;
      
      


       $data = [
        'crumbsTitle' => $this->functions->translation('default',"User Add/Update"),
         'merchant_access'=>$merchant_access,
          'menu'=>$menu
     ];
         $this->view('merchant/user-addpos', $data, 'layouts/merchant_tpl'); 



    } else{

      $data = [
        'crumbsTitle' => $this->functions->translation('default',"User List")
     ];
         $this->view('merchant/user-list', $data, 'layouts/merchant_tpl'); 

    }    
  }



  public function accesss_to_inventory(){

    $merchant_info = $this->functions->getMerchantInfo();
    $merchant_id = $merchant_info[0]->merchant_id;

   
    $token = substr(bin2hex(random_bytes(5)), 0, 10);

                // Store the token in the session
    $_SESSION['user_logged_in'] = true;
    $_SESSION['token'] = $token;
    $_SESSION['user_token'] = $token;
    
    $_SESSION['username'] = $merchant_info[0]->username;
    $_SESSION['user_email'] =$merchant_info[0]->username;
    $_SESSION['user_type'] = 'merchant';
    $_SESSION['inventory_merchant'] = $merchant_info[0]->merchant_id;

     $updateStmt = $this->db->prepare("
                    UPDATE mt_merchant
                    SET session_token = :session_token
                    WHERE merchant_id = :merchant_id
                ");
                $updateStmt->execute([
                    ':session_token' => $token,
                    ':merchant_id' => $merchant['merchant_id']  // Use the merchant's ID to update the correct record
                ]);

    

  $data = [
        'url' => Config::$baseUrl."/inventory/index"
     ];

     

   $this->view('merchant/inventory', $data, 'layouts/merchant_tpl'); 

  }

   



    public function PromotionsList($params=[])
	{	    
		/*$this->crumbsTitle=Yii::t("default","Promotions");
		if (isset($_GET['Do'])){ 
			if ( $_GET['Do']=="Add"){
				$this->render('pro-add');
			}else $this->render('pro-list');
		} else $this->render('pro-list');
*/

		$do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }




       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
           
    
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Promotions")
            ];
           $this->view('merchant/pro-add', $data, 'layouts/merchant_tpl');


           } else {

           	 $data = [
            'crumbsTitle' => $this->functions->translation('default', "Promotions")
            ];
           $this->view('merchant/pro-list', $data, 'layouts/merchant_tpl');
              
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Promotions")
            ];
           $this->view('merchant/pro-list', $data, 'layouts/merchant_tpl');

        }    





	}


  public function PurchaseSMS()
  {
     

    $data = [
            'crumbsTitle' => $this->functions->translation('default', "SMS Purchase Credits")
            ];
           $this->view('merchant/sms-purchase', $data, 'layouts/merchant_tpl');

  }



	public function Offers($params=[])
	{
       
       

		$do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


			
		if (isset($_GET['Do'])){
			if ( $_GET['Do']=="Add"){
				
              
				$data = [
            'crumbsTitle' => $this->functions->translation('default', "Offers - add")
        
            ];
           $this->view('merchant/offers_add', $data, 'layouts/merchant_tpl');

			} else {//$this->render('category_list');
					        $data = [
		            'crumbsTitle' => $this->functions->translation('default', "category list")
		        
		            ];
		           $this->view('merchant/category_list', $data, 'layouts/merchant_tpl');
		           }
		} else{
			$data = [
            'crumbsTitle' => $this->functions->translation('default', "Offers")
        
            ];
           $this->view('merchant/offers', $data, 'layouts/merchant_tpl');
		} 	




	}

	public function points_settings()
	{		
		if (1==1){
		
			$disabled_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');		
			
			if($disabled_settings==1){
			   

			   echo "Sorry but this page is not available";return;

			} else {
				

				$data = [
            'crumbsTitle' => $this->functions->translation('default', "Loyalty Points Settings"),
            'mtid'=>$this->functions->getMerchantID(),
			'status_list'=>$this->functions->orderStatusList()
            ];
           $this->view('merchant/points-settings', $data, 'layouts/merchant_tpl');

			}
		} else {
			echo "This requires addon";return;
		}
	}


	public function PayOnDelivery()
	{		
				
		if ( $this->functions->hasMerchantAccess("pyr")){
			

			$data = [
            'crumbsTitle' => $this->functions->translation('default', "Pay On Delivery")
        
            ];
           $this->view('merchant/payondelivery', $data, 'layouts/merchant_tpl');

		} else {echo "no access";die();}
	}


	public function Windcave()
	{		
		


			$data = [
            'crumbsTitle' => $this->functions->translation('default', "Windcave Web")
        
            ];
           $this->view('merchant/windcave', $data, 'layouts/merchant_tpl');

		
	}



  public function W_pos()
  {   
    

      $data = [
            'crumbsTitle' => $this->functions->translation('default', "Windcave Pos")
        
            ];
           $this->view('merchant/windcave_pos', $data, 'layouts/merchant_tpl');

    
  }

  public function codsettings()
  {
    
    if ( $this->functions->hasMerchantAccess("cod")){ 


     

      $data = [
            'crumbsTitle' => $this->functions->translation('default', "Windcave Pos"),
            'merchant_id'=>$this->functions->getMerchantID()
        
            ];
      $this->view('merchant/cod-settings', $data, 'layouts/merchant_tpl');



    } else{  
      echo "Sorry but your not allowed to access this page";die(); 
      }
  }


  public function paypal_v2()
  {
    
        
    if ( $this->functions->hasMerchantAccess( "paypal_v2" )){

      
      $data = [
            'crumbsTitle' => $this->functions->translation('default', "Paypal V2 Settings"),
            'mtid'=>$this->functions->getMerchantID()
            ];
      $this->view('merchant/paypal_v2_settings', $data, 'layouts/merchant_tpl');



    } else{  
      echo "Sorry but your not allowed to access this page";die(); 
      }
  }



   public function StripeSettings()
    {     
      
      if ( $this->functions->hasMerchantAccess("stp")){
       

        $data = [
            'crumbsTitle' => $this->functions->translation('default', "Stripe Settings"),
            'merchant_id'=>$this->functions->getMerchantID()
        
            ];
      $this->view('merchant/stripe-settings', $data, 'layouts/merchant_tpl');

      } else{
           echo "Sorry but your not allowed to access this page";die(); 
         }
    }


    public function polipaysetting()
  {


    

    $data = [
            'crumbsTitle' => $this->functions->translation('default', "Poli Setting")
        
            ];
    $this->view('merchant/polipay', $data, 'layouts/merchant_tpl');

  }




	public function PurchaseSmsTransaction()
	{
		


		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Purchase Credit Transactions")
        
            ];
           $this->view('merchant/sms-purchasetrans', $data, 'layouts/merchant_tpl');




	}


	public function SalesSummaryReport()
    {
    	

    	$data = [
            'crumbsTitle' => $this->functions->translation('default', "Sales Summary Report")
        
            ];
           $this->view('merchant/sales-summary-report', $data, 'layouts/merchant_tpl');
    }


   public function BookingReport()
	{
		

		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Booking Summary Report")
        
            ];
           $this->view('merchant/rpt-bookingreport', $data, 'layouts/merchant_tpl');
		
	}


	public function Review($params=[])
	{

		$do=$params['Do'];
    $id=$params['id'];


        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }



		
		if (isset($_GET['Do'])){
			if ( $this->functions->getOptionAdmin('merchant_can_edit_reviews')=="yes"){			
				
				echo "Sorry but you don't have access this page.";die();
			} else {				
				
        
				$data = [
            'crumbsTitle' => $this->functions->translation('default', "Customer reviews Update")
        
            ];
           $this->view('merchant/review-add', $data, 'layouts/merchant_tpl');
         

			}
		} else{
           

			$data = [
            'crumbsTitle' => $this->functions->translation('default', "Customer reviews")
        
            ];
           $this->view('merchant/review-list', $data, 'layouts/merchant_tpl');


		  }			
	}











		public function manage_credit_cards($params=[])
	{
		//$this->crumbsTitle=t("Manage Credit Card");
		
		$disabled_cc_management = $this->functions->getOptionAdmin('disabled_cc_management');		
		if($disabled_cc_management=="yes"){
			echo "no access";
			return ;
		}
				
		$mtid = $this->functions->getMerchantID();	
		
		if ( $this->functions->hasMerchantAccess( "manage_credit_cards" )){					
			

			$do=$params['do'];
        $id=$params['ids'];
        if(isset($do)&&!empty($do)){
             $_GET['do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['ids']=$id;
         }
         $do = isset($_GET['do'])?$_GET['do']:'';
			if($do=="add"){
				$ids = isset($_GET['ids'])?$_GET['ids']:'';
				if ($ids>=1){
					if ($data=$this->functions->getMerchantByMtidCC($ids,$mtid)){
						


						$data = [
            'crumbsTitle' => $this->functions->translation('default', "Manage Credit Card"),
            'mtid'=>$this->functions->getMerchantID(),
			'data'=>$data
            ];
           $this->view('merchant/manage_credit_add', $data, 'layouts/merchant_tpl');



					} else {
						

						echo "Sorry but we cannot find what you are looking for.";
			            return ;

					}
				} else {
				  

				  $data = [
            'crumbsTitle' => $this->functions->translation('default', "Manage Credit Card"),
            'mtid'=>$this->functions->getMerchantID()
            ];
           $this->view('merchant/manage_credit_add', $data, 'layouts/merchant_tpl');


				}				
			} else {
				
                
				$data = [
            'crumbsTitle' => $this->functions->translation('default', "Manage Credit Card"),
            'mtid'=>$this->functions->getMerchantID()
            ];
           $this->view('merchant/manage_credit_cards', $data, 'layouts/merchant_tpl');

			}
		} else {			
			echo "no access";
			return ;
		}
	}



	public function GallerySettings()
	{
		

		 $data = [
            'crumbsTitle' => $this->functions->translation('default', "gallery settings")
        
            ];
           $this->view('merchant/gallery-settings', $data, 'layouts/merchant_tpl');

	}

	public function banner_settings()
	{
		$merchant_id = $this->functions->getMerchantID();
		/*$this->crumbsTitle = t("Banner Settings");
		$this->render('banner-settings',array(
		  'merchant_id'=>$merchant_id,
		  'banner'=>$this->functions->getOption('merchant_banner',$merchant_id),
		  'banner_enabled'=>$this->functions->getOption('banner_enabled',''),		  
		));*/


		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Banner Settings"),
             'banner'=>$this->functions->getOption('merchant_banner',$merchant_id),
		     'banner_enabled'=>$this->functions->getOption('banner_enabled','')
        
            ];
           $this->view('merchant/banner-settings', $data, 'layouts/merchant_tpl');


	}






	public function OrderStatus($params=[])
    {
    
    	$do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }

       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
           
    
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Order Status")
            ];
           $this->view('merchant/order-status-add', $data, 'layouts/merchant_tpl');

           } else {
 
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Order Status")
            ];
           $this->view('merchant/order-status', $data, 'layouts/merchant_tpl');
        }   
    }

    public function Voucher($params=[])
	{
		/*$this->crumbsTitle=Yii::t("default","Voucher List");
		if (isset($_GET['Do'])){
			$this->crumbsTitle=Yii::t("default","Voucher Add/Update");
			$this->render('voucher-add');		
		} else $this->render('voucher-list');*/	



		$do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }

       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
           
    
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Voucher Add/Update")
            ];
           $this->view('merchant/voucher-add', $data, 'layouts/merchant_tpl');

           } else {
 
           }
        } else {
              
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Voucher List")
            ];
           $this->view('merchant/voucher-list', $data, 'layouts/merchant_tpl');
        }   



	}

  public function merchant_customer_list($params=[]){
    $do=$params['Do'];
    $id=$params['id'];
    if(isset($do)&&!empty($do)){
             $_GET['do']=$do;
         }

    if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }
    if (isset($_GET['do'])){  
      
       
        $data = ['crumbsTitle' => $this->functions->translation('default',"Customer List")];
        $this->view('merchant/customer-add', $data, 'layouts/merchant_tpl');

    } else {  
      

      $data = ['crumbsTitle' => $this->functions->translation('default',"Customer List")];
      $this->view('merchant/customer-list', $data, 'layouts/merchant_tpl');


    }
  }








	



    public function CategoryList($params=[])
	{	    
		

		 $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Category")
        
            ];
           $this->view('merchant/category_add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Category Sort")
        
            ];
           $this->view('merchant/category_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Category List"),
             'id'=>$id
            ];
           $this->view('merchant/category_list', $data, 'layouts/merchant_tpl');

        } 

	}


  public function bookings_list_single($params=[])
  { 

    $data = [
            'crumbsTitle' => $this->functions->translation('default', "Add Booking slots")
        
            ];
           $this->view('merchant/booking_add_single', $data, 'layouts/merchant_tpl');

  }



  public function bookings_list($params=[])
  {     
    

     $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"&&$id==""){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Add Booking slots")
        
            ];
           $this->view('merchant/booking_add', $data, 'layouts/merchant_tpl');

           }else{

                  $stmt = $this->db->prepare("
          SELECT * FROM mt_booking_slots 
          WHERE id = :id 
          
          LIMIT 1
      ");

      $stmt->execute([
          ':id' => $id
          
      ]);

$slot_data = $stmt->fetch(PDO::FETCH_ASSOC);

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Edit Booking slot"),
             'id'=>$id,
             'slot_data' => $slot_data
            ];

            $this->view('merchant/booking_edit', $data, 'layouts/merchant_tpl');
           }








        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

           $data = [
            'crumbsTitle' => $this->functions->translation('default', "Booking slots")
        
            ];
           $this->view('merchant/booking_slots', $data, 'layouts/merchant_tpl');

        } 

  }










	public function Size($params=[])
	{
		



		 $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "size add")
        
            ];
           $this->view('merchant/size_add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "size Sort")
        
            ];
           $this->view('merchant/size_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "size List"),
             'id'=>$id
            ];
           $this->view('merchant/size', $data, 'layouts/merchant_tpl');

        } 



	}


	


	public function AddOnCategory($params=[])
	{
				
		 $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Category")
        
            ];
           $this->view('merchant/addon_category_add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Category")
        
            ];
           $this->view('merchant/addon_category_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Category"),
             'id'=>$id
            ];
           $this->view('merchant/addon_category_list', $data, 'layouts/merchant_tpl');

        } 

	}


    public function TableBooking($params=[])
  {

    /*$user_access = (array)$this->functions->getMerchantUserAccess();
    print_r($user_access);die();
    echo $this->functions->hasMerchantAccessToMenu($user_access,"salesReport");
die();*/

    $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }
        
    $tbl_booking=$this->functions->getOption( 'merchant_master_table_boooking',$this->functions->getMerchantID());
    if($tbl_booking==1){

      $data = ['crumbsTitle' => $this->functions->translation('default',"Page not found"),
           'msg'=>"Sorry but you don't have permission to access this page"
          ];

          
          
          $this->view('merchant/noaccess', $data, 'layouts/merchant_tpl');
     
      die();
      
    }
    
    if (isset($_GET['Do'])){
      if ($_GET['Do']=="settings"){
        

          $data = [
            'crumbsTitle' => $this->functions->translation('default', "Table Booking Settings")
        
            ];
           $this->view('merchant/tablebooking-settings', $data, 'layouts/merchant_tpl');


      } else {
         

         $data = [
            'crumbsTitle' => $this->functions->translation('default', "Table Booking")
        
            ];
           $this->view('merchant/tablebooking-add', $data, 'layouts/merchant_tpl');
      }
    } else {
      
      
       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Table Booking")
        
            ];
           $this->view('merchant/tablebooking', $data, 'layouts/merchant_tpl');

    }
  }


  public function singlemerchant_banner()
  {
    
    
    $merchant_id = $this->functions->getMerchantID();
    
    if($merchant_id>0){
      
      
      
      $data = array(
        'merchant_id'=>$merchant_id
      );
      
     

      
                                          
      /*$this->crumbsTitle = t("Single Merchant");
      $this->render('single_merchant_settings',array(
        'merchant_id'=>$merchant_id,
        'action_id'=>$action_id,
        'data'=>$data
      ));*/

       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Single Merchant"),
            'merchant_id'=>$merchant_id,
            'data'=>$data
            ];
           $this->view('merchant/single_merchant_settings_banner', $data, 'layouts/merchant_tpl');



    } else die();
  }



   public function singlemerchant_contact()
  {
    
    
    $merchant_id = $this->functions->getMerchantID();
    
    if($merchant_id>0){
      
      
      
      $data = array(
        'merchant_id'=>$merchant_id
      );
      
     

      
                                          
      /*$this->crumbsTitle = t("Single Merchant");
      $this->render('single_merchant_settings',array(
        'merchant_id'=>$merchant_id,
        'action_id'=>$action_id,
        'data'=>$data
      ));*/

       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Single Merchant"),
            'merchant_id'=>$merchant_id,
            'data'=>$data
            ];
           $this->view('merchant/single_merchant_settings_contact', $data, 'layouts/merchant_tpl');



    } else die();
  }




  public function singlemerchant_pages()
  {
    
    
    $merchant_id = $this->functions->getMerchantID();
    
    if($merchant_id>0){
      
      
      
      $data = array(
        'merchant_id'=>$merchant_id
      );
      
     

      
                                          
      /*$this->crumbsTitle = t("Single Merchant");
      $this->render('single_merchant_settings',array(
        'merchant_id'=>$merchant_id,
        'action_id'=>$action_id,
        'data'=>$data
      ));*/

       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Single Merchant"),
            'merchant_id'=>$merchant_id,
            'data'=>$data
            ];
           $this->view('merchant/single_merchant_settings_pages', $data, 'layouts/merchant_tpl');



    } else die();
  }



  public function single_merchant_settingsadd($params=[])
  {
    


        $page_id=$params['page_id'];
        

         if(isset($page_id)&&!empty($page_id)){
             $_GET['page_id']=$page_id;
         }

         $id=$params['id'];
        

         if(isset($id)&&!empty($id)){
             $_GET['page_id']=$id;
         }
    
    $merchant_id = $this->functions->getMerchantID();
    
    if($merchant_id>0){
      
      
      
      $data = array(
        'merchant_id'=>$merchant_id
      );
      
     

      
                                          
      /*$this->crumbsTitle = t("Single Merchant");
      $this->render('single_merchant_settings',array(
        'merchant_id'=>$merchant_id,
        'action_id'=>$action_id,
        'data'=>$data
      ));*/

       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Single Merchant"),
            'merchant_id'=>$merchant_id,
            'data'=>$data
            ];
           $this->view('merchant/single_merchant_settings_pages_add', $data, 'layouts/merchant_tpl');



    } else die();
  }







  public function singlemerchant_android()
  {
    
    
    $merchant_id = $this->functions->getMerchantID();
    
    if($merchant_id>0){
      
      
      
      $data = array(
        'merchant_id'=>$merchant_id
      );
      
     

      
                                          
      /*$this->crumbsTitle = t("Single Merchant");
      $this->render('single_merchant_settings',array(
        'merchant_id'=>$merchant_id,
        'action_id'=>$action_id,
        'data'=>$data
      ));*/

       $data = [
            'crumbsTitle' => $this->functions->translation('default', "Single Merchant"),
            'merchant_id'=>$merchant_id,
            'data'=>$data
            ];
           $this->view('merchant/single_merchant_settings_android', $data, 'layouts/merchant_tpl');



    } else die();
  }


  public function payment_failed(){

    $data = [
            'message' => $this->functions->translation('default', "Payment failed")
            ];
    $this->view('merchant/error', $data, 'layouts/merchant_tpl');


    


  }



  public function polisuccess() 
      { 
          
        $error='';  $data=$_POST;         
              $transaction_id=$_GET['token']; 

     $merchant_id=$_GET['merchant_id'];
    
    //echo $_SESSION['executed_gateway'];die();
    
          
      if(is_null($token)) { 
      $token = $_GET["token"];  
    } 
      
      
     if(isset($token) && !empty($token)){ 
      
      
      
      
        /*if ( $data1=$this->functions->getOrder($_GET['id'])){ 
          
        } */
        
        
        $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);  
        
        if(1==2){  

          $paymode=$this->functions->getOption('merchant_poli_mode',$merchant_id);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$merchant_id);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$merchant_id);
           $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }
        }else{  
           $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          
          }

     


        } 
        
    $auths=$mer_code.':'.$authkey;  
      
     $auth = base64_encode($auths); 
     $header = array(); 
     $header[] = 'Authorization: Basic '.$auth; 
      
     $ch = curl_init($api_url); 
     
     curl_setopt( $ch, CURLOPT_HTTPHEADER, $header);  
     curl_setopt( $ch, CURLOPT_HEADER, 0);  
     curl_setopt( $ch, CURLOPT_POST, 0);  
     curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 0);  
     curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);  
     $response = curl_exec( $ch );  
     curl_close ($ch);  
      
     $json = json_decode($response, true);  
      
     //print_r($json);  
      
    $transaction_id= $json['TransactionRefNo']; 

    $duplicate_chk=$this->functions->chk_duplicate_transaction_id($transaction_id);
    if($duplicate_chk==1){
       $redirect_url = Config::$baseUrl ."/merchant/smsSettings";

                     
        
                     echo "<script>
                          if (window.top !== window.self) {
                              window.top.location = '" . $redirect_url . "';
                          } else {
                              window.location.href = '" . $redirect_url . "';
                          }
                         </script>";


                         //header("Location: " . $redirect_url);
                         exit();
    }
                
                  
          $last_id=$this->functions->sms_payment_successthings_poli($transaction_id,$_GET['id'],$_GET['type'],$merchant_id);  
                                 
                     $redirect_url = Config::$baseUrl ."/merchant/smsReceipt/id/".$last_id;

                     
                      $_SESSION['executed_gateway']=1;
                     echo "<script>
                          if (window.top !== window.self) {
                              window.top.location = '" . $redirect_url . "';
                          } else {
                              window.location.href = '" . $redirect_url . "';
                          }
                         </script>";


                         //header("Location: " . $redirect_url);
                         exit();

            
     }  
        /*$data='';
        $this->view('store/poli-success', $data, 'layouts/store_tpl');  */
            
          } 


          public function policancel()  
      { 

     
            
        
       
          
        if(is_null($token)) { 
      $token = $_GET["token"];  
    } 
      
      $merchant_id=$_GET['merchant_id'];
      
      
        
        $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);  
        
        if(1==2){

          $paymode=$this->functions->getOption('merchant_poli_mode',$merchant_id);
          if($paymode=='live'){
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code',$merchant_id);
            $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
            $mer_code=$this->functions->getOption('merchant_poli_merchant_id_sandbox',$merchant_id); 
            $authkey=$this->functions->getOption('merchant_auth_poli_code_sandbox',$merchant_id);
            $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }

      
        }else{  
          $paymode=$this->functions->getOptionAdmin('admin_poli_mode');

           if($paymode=='live'){
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code');
          $api_url ="https://poliapi.apac.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          }else{
          $mer_code=$this->functions->getOptionAdmin('admin_poli_merchant_id_sandbox');
          $authkey=$this->functions->getOptionAdmin('admin_auth_poli_code_sandbox');
          $api_url ="https://poliapi.uat3.paywithpoli.com/api/v2/Transaction/GetTransaction?token=".urlencode($token);
          } 
        } 
        
    $auths=$mer_code.':'.$authkey;  
      
     $auth = base64_encode($auths); 
     $header = array(); 
     $header[] = 'Authorization: Basic '.$auth; 
      
     $ch = curl_init($api_url); 
     //See the cURL documentation for more information: http://curl.haxx.se/docs/sslcerts.html  
     //We recommend using this bundle: https://raw.githubusercontent.com/bagder/ca-bundle/master/ca-bundle.crt  
     //curl_setopt( $ch, CURLOPT_CAINFO, "ca-bundle.crt");  
     //curl_setopt( $ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);  
     curl_setopt( $ch, CURLOPT_HTTPHEADER, $header);  
     curl_setopt( $ch, CURLOPT_HEADER, 0);  
     curl_setopt( $ch, CURLOPT_POST, 0);  
     curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 0);  
     curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);  
     $response = curl_exec( $ch );  
     curl_close ($ch);  
      
     $json = json_decode($response, true);  
      
      
         
      
       


        //$this->view('store/poli-cancel', $data, 'layouts/store_tpl'); 

        $redirect_url = Config::$baseUrl ."/merchant/purchasesms";

         echo "<script>
            if (window.top !== window.self) {
                window.top.location = '" . $redirect_url . "';
            } else {
                window.location.href = '" . $redirect_url . "';
            }
        </script>";

          //header("Location: " . $redirect_url);
          exit();
      }


      public function sendRequest_windcave($url, $method = 'POST', $data = []) {

        $paymode=$this->functions->getOptionAdmin('windcave_mode');

        if($paymode=='Sandbox'){
        $apiUsername = $this->functions->getOptionAdmin('wind_user_id_sandbox');
        $apiKey = $this->functions->getOptionAdmin('wind_key_sandbox');
        }else{
        $apiUsername = $this->functions->getOptionAdmin('wind_user_id');
        $apiKey = $this->functions->getOptionAdmin('wind_key');
        }


        

        $auth = base64_encode("{$apiUsername}:{$apiKey}");
        
        $headers = [
            "Authorization: Basic $auth",
            "Content-Type: application/json",
        ];
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($response, true);
    }


  public function windcaveinit(){
      $merchant_id = $this->functions->getMerchantID();
      $package_id=$_GET['package_id'];
      $trans_type = $_GET['type'];

      

      $returnUrl = Config::$baseUrl . "/merchant/windcave_success?id=".$package_id."&type=".$trans_type;  // The URL for success page
      $notificationUrl = Config::$baseUrl . "/merchant/windcave_notification";
      $cancelUrl = Config::$baseUrl . "/merchant/purchasesms";


      $currency = $this->functions->getCurrencyCode();
      $apiEndpoint = "https://uat.windcave.com/api/v1/sessions";
      $error = '';

      if ($data = $this->functions->getSMSPackagesById($package_id)) {
         $price=$data['price'];
        if ( $data['promo_price']>0){
         $price=$data['promo_price'];
         }  

         $windcave_card_fee=$this->functions->getOptionAdmin('admin_windcave_card_fee');
         if ($windcave_card_fee >= 0.0001) {
         
          $card_fee = $price*$windcave_card_fee/100;
          $price=$price+$card_fee;
          }
          
          $merchantReference="Pkg#".$package_id;

         $price = number_format((float)$price, 2, '.', '');

      

        $data = [
    "type" => "purchase",
    "amount" => $price, // This would be dynamic in your case, such as $price
    "currency" => $currency, // You might want to replace this with your dynamic currency code, such as $currency
    "merchantReference" => $merchantReference, // Replace this with a dynamic reference if needed
    "callbackUrls" => [
        "approved" => $returnUrl, // Replace with your actual success URL
        "declined" => $cancelUrl,   // Replace with your actual failure URL
        "cancelled" => $cancelUrl // Replace with your actual cancel URL
    ],
    "notificationUrl" => $notificationUrl // Replace with your actual notification URL
];


        $sessionResponse = $this->sendRequest_windcave($apiEndpoint, 'POST', $data);

        


         if (isset($sessionResponse['links'][1]['href'])) {
            // Redirect to the card entry view (second step)
           $formUrl = $sessionResponse['links'][1]['href'];
          header("Location: $formUrl");
    exit();
            /*$data_for_view = [
                    'sessionResponse' => $sessionResponse
                ];


            $this->view('merchant/windcave_buy', $data_for_view, 'layouts/merchant_tpl');*/

        } else {
            // Handle errors if session creation fails

           $error = "Error: " . $sessionResponse['message'];
        }



      }else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
      }



      if (!empty($error)) {

        

         $data = [
            'message' => $this->functions->translation('default', "Payment failed")
            ];
         $this->view('merchant/error', $data, 'layouts/merchant_tpl');


    }




      }





      

       public function windcave_success() {
        // Logic for processing success response
        // e.g., check status, display success page, etc.
        $transactionId = $_GET['sessionId'] ?? null; // Get the transaction ID from the URL
        $status = $_GET['status'] ?? null; // Get the payment status
        $merchant_id=$this->functions->getMerchantID();
        
        
        
            // Payment successful
           
            

            $last_id=$this->functions->sms_payment_successthings_windcave($transactionId,$_GET['id'],$_GET['type'],$merchant_id);  
                                 
                     

                     
                      
                    $redirec_link=Config::$baseUrl."/merchant/smsReceipt?id=".$last_id;

                    $_SESSION['payment_process']=1;

                    header("Location: " . $redirec_link);
                    exit();




        
    }



      public function windcave_notification() {
    // Windcave will POST the response data to this URL (e.g., transaction status)
    $response = file_get_contents("php://input");  // Get raw POST data

    // Parse the response (assuming JSON format)
    $responseData = json_decode($response, true);

    // Check if the response indicates a successful transaction
    if ($responseData['status'] == 'APPROVED') {
        // Process the success (e.g., update your database, mark the order as paid)
        // Example: Update database to mark the payment as successful
        $transactionId = $responseData['transactionId'];
        // Your database code here to mark the transaction as successful
        // Example: $this->db->query("UPDATE orders SET status = 'paid' WHERE transaction_id = '$transactionId'");

        // Optionally, send a success response back to Windcave
        echo json_encode(["status" => "success"]);
    } else {
        // Handle the failure (e.g., log the error, send notification to admin)
        // Example: Log failure
        $errorMessage = $responseData['errorMessage'] ?? "Unknown error";
        // Log the error for future reference
        error_log("Payment failure: " . $errorMessage);

        echo json_encode(["status" => "failed", "message" => $errorMessage]);
    }
}







       public function stripeInit()
{

    if (!$this->functions->isMerchantLogin()) {
        exit();
    }

   

   if(isset($_SESSION['payment_process'])){
    $redirec_link=Config::$baseUrl."/merchant/smsSettings";

        
        

        header("Location: " . $redirec_link);
   }


    $merchant_id = $this->functions->getMerchantID();
    $package_id=$_GET['package_id'];


    $amount_to_pay = 0;
    $error = '';
    $credentials = '';
    $payment_description = '';
    $merchant_name = '';
    $reference_id = '';
    $client_info = [];
    $trans_type = $_GET['type'];
    $currency_code = $this->functions->getCurrencyCode();

    $back_url = Config::$baseUrl . "/merchant/smsSettings";
    $orig_amount_to_pay = 0;
    $currency_used = '';
    $order_card_fee = 0;
    $exchange_rate_convertion = 0;
    $client_email = '';

    $exchange_rate = $this->functions->getRates();

   
    if ($data = $this->functions->getSMSPackagesById($package_id)) {

    	/*if($data['status']=='paid'){

    		$redirec_link=Config::$baseUrl."/store";
    		 header("Location: " . $redirec_link);
			 exit();
    	}*/

    	$price=$data['price'];
        if ( $data['promo_price']>0){
         $price=$data['promo_price'];
         }  
         

         $stpdata=$this->functions->getCredentials_stripe_purchase_sms($merchant_id);
         
         $card_fee =0;
         if($stpdata['card_fee']>0.0001){
         $card_fee = $price*$stpdata['card_fee']/100;
         }
         
         $price=$price+$card_fee;

        
        $client_id = $merchant_id;
        $order_id = $package_id;
        $reference_id = $package_id;



        //$order_card_fee = isset($data['card_fee']) ? (float)$data['card_fee'] : 0;
        $merchant_info=$this->functions->getMerchantInfo();
        //print_r($merchant_info);die();
        $merchant_name=$merchant_info[0]->contact_name;

        $merchant_name = isset($merchant_name) ? $this->functions->clearString($merchant_name) : '';

        $payment_description = $this->functions->translation(
            "default",
            "Payment deducted to merchant " . $merchant_name . " Package ID# " . $package_id
        );

        $description = $this->functions->translation("default", "Purchase Package ID# " . $package_id);

        $amount_to_pay = $this->functions->normalPrettyPrice($price);
        $orig_amount_to_pay = $this->functions->convertToRaw($price);

        
        $client_email = $merchant_info[0]->inventory_email_notify ?? '';
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
    }

    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }

    if (empty($error)) {
        if ($credentials = $this->functions->getCredentials_stripe_purchase_sms($merchant_id)) {
            try {
                $amount_to_pay = $this->functions->convertToRaw($amount_to_pay) * 100;

                $params = [
                    'customer_email' => trim($client_email),
                    'client_reference_id' => $trans_type . "-" . $reference_id,
                    'payment_method_types' => ['card'],
                    'mode' => "payment",
                    'success_url' => $this->functions->websiteUrl() . "/merchant/stripe_success?reference_id=" . urlencode($reference_id) . "&trans_type=$trans_type",
                    'cancel_url' => $this->functions->websiteUrl() . "/merchant/smsSettings",
                    'line_items' => [
                        [
                            'price_data' => [
                                'currency' => $currency_code,
                                'unit_amount' => $amount_to_pay,
                                'product_data' => [
                                    'name' => $payment_description,
                                    'description' => $description
                                ]
                            ],
                            'quantity' => 1
                        ]
                    ],
                ];

                $resp = $this->functions->createSession_stp($credentials['secret_key'], $params);
                $stripe_session = $resp['id'];
                $payment_intent = $resp['id'];

                $params_update = [
                    'payment_gateway_ref' => $payment_intent
                ];

                //$this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);

                $data = [
                    'publish_key' => $credentials['publish_key'],
                    'stripe_session' => $stripe_session,
                    'reference_id' => $reference_id,
                    'trans_type' => $trans_type,
                    'payment_description' => $payment_description,
                    'fee' => (float)$card_fee,
                    'amount' => (float)$amount_to_pay / 100
                ];

                 




                $this->view('merchant/stripe_buy', $data, 'layouts/merchant_tpl');
            } catch (Exception $e) {
                $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
            }
        } else {
            $error = $this->functions->translation("default", "Invalid payment credentials");
        }
    }

    if (!empty($error)) {

        

         $data = [
            'message' => $this->functions->translation('default', "Payment failed")
            ];
         $this->view('merchant/error', $data, 'layouts/merchant_tpl');


    }
}






public function stripe_success()
  {
    $get = $_GET;$error = '';
    $post = $_POST;
    $back_url = Config::$baseUrl."/merchant/smsSettings";


    $reference_id = isset($get['reference_id'])?$get['reference_id']:'';
    $trans_type = isset($get['trans_type'])?$get['trans_type']:'';  
    
    $merchant_id=$this->functions->getMerchantID();
    

    if(!empty($reference_id)){      
            
      switch ($trans_type) {
       
          
        
          
        case "purchaseSMScredit":

        $last_id=$this->functions->sms_payment_successthings_stripe($get,$reference_id,$trans_type,$merchant_id);  

         
        $redirec_link=Config::$baseUrl."/merchant/smsReceipt?id=".$last_id;

        $_SESSION['payment_process']=1;

        header("Location: " . $redirec_link);
        exit();
          break;
      
        default:

          

          $error = $this->functions->translation("default","invalid transaction type: ".$trans_type);

          break;
      }     
    } else $error = $this->functions->translation("default","Sorry but we cannot find what your are looking for.");
    
    if(!empty($error)){
          $error.='<p style="margin-top:20px;"><a href="'.$back_url.'" />'.$this->functions->translation("default","Go back").'</a></p>';

          $data = [
            'message' => $error
            ];
         $this->view('merchant/error', $data, 'layouts/merchant_tpl');

        }

  } 




    public function paypal_v2init() {


       if(isset($_SESSION['payment_process'])){
    $redirec_link=Config::$baseUrl."/merchant/smsSettings";

        
        

        header("Location: " . $redirec_link);
   }
        // PayPal credentials


    $merchant_id = $this->functions->getMerchantID();
    $package_id=$_GET['package_id'];

      $amount_to_pay = 0; 
    $error = ''; 
    $credentials = '';
    $payment_description = '';
    $merchant_name = ''; 
    $reference_id = ''; 
    $client_info = [];
    $trans_type = $_GET['type'];
    $currency_code = $this->functions->getCurrencyCode();

    $back_url = Config::$baseUrl . "/merchant/smsSettings";

    

    // Fetch order details
    if ($data = $this->functions->getSMSPackagesById($package_id)) {

      $price=$data['price'];
        if ( $data['promo_price']>0){
         $price=$data['promo_price'];
         }  
      $credentials = $this->functions->getCredentials_paypal_purchasesms($merchant_id);
      $card_fee=0;
      if($credentials['card_fee']>0){
      $card_fee=$credentials['card_fee'];
      }

        
        
        $order_id = $package_id;
        $reference_id = $package_id;

        $merchant_info=$this->functions->getMerchantInfo();

        $merchant_name = $merchant_info[0]->contact_name;
        $payment_description = $this->functions->translation(
            "default",
            "Payment deducted to merchant " . $merchant_name . " Package ID# " . $package_id
        );


        $amount_to_pay=$price+$card_fee;
        $amount_to_pay = $this->functions->normalPrettyPrice($amount_to_pay);
    } else {
        $error = $this->functions->translation("default", "Sorry, but we cannot find what you are looking for.");
    }

    // Fallback for currency code
    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }






        if (empty($error)) {

        if ($credentials = $this->functions->getCredentials_paypal_purchasesms($merchant_id)) {

         
                   
        $success_url = $this->functions->websiteUrl() . "/merchant/paypal_success?reference_id=" . urlencode($reference_id) . "&trans_type=$trans_type";
        $cancel_url = $this->functions->websiteUrl() . "/merchant/smsSettings";
 
        $clientId =  $credentials['client_id'];
        $clientSecret = $credentials['secret_key'];
        

        $baseUrl = $credentials['mode'] == 'live' 
        ? 'https://api-m.paypal.com' // Live URL
        : 'https://api-m.sandbox.paypal.com';

        // Step 1: Generate Access Token
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v1/oauth2/token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, "$clientId:$clientSecret");
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
        curl_setopt($ch, CURLOPT_POST, true);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {
            die('Error: Unable to fetch access token');
        }

        $accessToken = json_decode($response)->access_token;

        // Step 2: Create Order
      $orderData = [
    "intent" => "CAPTURE",
    "purchase_units" => [
        [
            "amount" => [
                'currency_code' => $currency_code,
                'value' => $amount_to_pay,
            ]
        ]
    ],
    "application_context" => [
        "return_url" => $success_url,
        "cancel_url" => $cancel_url
    ]
];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v2/checkout/orders");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer $accessToken"
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $order = json_decode($response);

        if (!isset($order->links[1]->href)) {
            die('Error: Unable to create PayPal order');
        }

        $approvalUrl = $order->links[1]->href;
        
        //echo $approvalUrl;die();
        // Pass approval URL to the view

         header("Location: " . $approvalUrl);
         exit();
        
        /*$data = ['approval_url' => $approvalUrl];
        $this->view('store/paypal_iframe', $data,'');*/
         }else {
            $error = $this->functions->translation("default", "Invalid merchant credentials");
          }

        }


         // Handle error
        if (!empty($error)) {

            

            $data = [
            'message' => $this->functions->translation('default', "Payment failed")
            ];
         $this->view('merchant/error', $data, 'layouts/merchant_tpl');


        }



    }




    public function paypal_success()
{
    $get = $_GET;
    $back_url = '';
    $error = '';
    $payment_code = 'paypal_v2';

    $reference_id = isset($get['reference_id']) ? $get['reference_id'] : '';
    $trans_type = isset($get['trans_type']) ? $get['trans_type'] : '';
    $payment_token = isset($get['token']) ? $get['token'] : '';
    $merchant_id=$this->functions->getMerchantID();

    if (!empty($reference_id) && !empty($trans_type)) {
        switch ($trans_type) {
            
            case "purchaseSMScredit":
                $back_url = $this->functions->websiteUrl() . "/merchant/smsSettings";
                
                    if ($credentials = $this->functions->getAdminCredentials_paypalv2()) {
                        try {
                            $resp = $this->capturePayment($credentials, $payment_token);

                            if ($resp['status'] !== 'COMPLETED') {
                                throw new Exception("Payment capture failed: " . json_encode($resp));
                            }

                            $last_id=$this->functions->sms_payment_successthings_paypalv2($resp,$reference_id,$trans_type,$merchant_id);  


                            
                            $redirect_link = Config::$baseUrl . "/merchant/smsReceipt?id=" . $last_id;
                            $_SESSION['payment_process']=1;
                            header("Location: " . $redirect_link);
                            exit;
                        } catch (Exception $e) {
                            $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
                        }
                    } else {
                        $error = $this->functions->translation("default", "Invalid payment credentials");
                    }
                 
                break;

            default:
                $error = $this->functions->translation("default", "Invalid transaction type " . $trans_type);
                break;
        }
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for");
    }

    if (!empty($error)) {
        $error.='<p style="margin-top:20px;"><a href="'.$back_url.'" />'.$this->functions->translation("default","Go back").'</a></p>';

          $data = [
            'message' => $error
            ];
         $this->view('merchant/error', $data, 'layouts/merchant_tpl');
    }
}



private function capturePayment($credentials, $payment_token)
{
    // Set the base URL for PayPal API based on the environment (live or sandbox)
    $base_url = $credentials['mode'] === 'live' 
                ? 'https://api-m.paypal.com' 
                : 'https://api-m.sandbox.paypal.com';

    // Step 1: Get Access Token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/v1/oauth2/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $credentials['client_id'] . ":" . $credentials['secret_key']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and check if the access token was obtained
    $token_data = json_decode($response, true);
    if (!isset($token_data['access_token'])) {
        throw new Exception("Failed to retrieve access token: " . json_encode($token_data));
    }
    $access_token = $token_data['access_token'];

    // Step 2: Capture the Payment using the provided payment token
    $capture_url = $base_url . "/v2/checkout/orders/$payment_token/capture";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $capture_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer $access_token"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and return it
    $capture_data = json_decode($response, true);
    if (isset($capture_data['status']) && $capture_data['status'] === 'COMPLETED') {
        return $capture_data; // Return the successful payment data
    } else {
        throw new Exception("Payment capture failed: " . json_encode($capture_data));
    }
}













  public function order_settings($params=[])
  {
    
      /*  FunctionsV3::registerScript(array(
      "var ajax_merchant_action='deleteTimeManagement';"
    ),'ajax_merchant_action');*/
    
    
    $merchant_id = $this->functions->getMerchantID();
    /*$this->crumbsTitle=t("Order settings");
    $this->render('order_settings',array(
      'merchant_id'=>$merchant_id
    ));*/

     $data = [
            'crumbsTitle' => $this->functions->translation('default', "Order settings"),
             'merchant_id'=>$merchant_id
            ];
           $this->view('merchant/order_settings', $data, 'layouts/merchant_tpl');


  }





  public function FoodItem($params=[])
  {
    
    
    
    /*FunctionsV3::registerScript(array(
      "var ajax_merchant_action='deleteFoodItem';"
    ),'ajax_merchant_action');
        
    if (isset($_GET['Do'])){
      if ( $_GET['Do']=="Add"){
        
        
        $this->render('food-item-add',array(
          'merchant_apply_tax'=>getOption($mtid,'merchant_apply_tax'),
          'merchant_tax'=>$merchant_tax>0?$merchant_tax:0,
          'merchant_apply_tax'=>'',
          'merchant_tax'=>0,
        ));
      } elseif ( $_GET['Do'] =="Sort" ){  
         $this->render('food_item_sort'); 
      } else $this->render('food-item-list');   
    } else $this->render('food-item-list');*/

    $mtid=$this->functions->getMerchantID();
    $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Food Item"),
             'merchant_apply_tax'=>'',
             'merchant_tax'=>0
            ];
           $this->view('merchant/food-item-add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Food Item")
        
            ];
           $this->view('merchant/food_item_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Food Item"),
             'id'=>$id,
             'inventory_enabled'=>$this->functions->inventoryEnabled($mtid)
            ];
           $this->view('merchant/food-item-list', $data, 'layouts/merchant_tpl');

        } 


  }

  public function bulkupload()
  {
   
    $merchant_id=$this->functions->getMerchantID();

 

  $data = [
            
         'merchant_id'=>$merchant_id
            ];

 

  $this->view('merchant/bulkupload', $data, 'layouts/merchant_tpl');
  }


 



  public function Invoice()
	{
		/*$this->crumbsTitle=t("Invoice list");
		$this->render('invoice-list',array(
		  'merchant_id'=>Yii::app()->functions->getMerchantID()
		));*/

		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Invoice list"),
             'merchant_id'=>$this->functions->getMerchantID()
            ];
           $this->view('merchant/invoice-list', $data, 'layouts/merchant_tpl');


	}

	public function ShippingRate()
	{

    $mtid = $this->functions->getMerchantID();
		if ($this->functions->isSearchByLocation()){


    $data = [
            'crumbsTitle' => $this->functions->translation('default', "Delivery charges rates"),
             'mtid'=>$mtid
            ];
    $this->view('merchant/location-delivery-rates', $data, 'layouts/merchant_tpl');



    }else{

		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Delivery charges rates")
        
            ];
           $this->view('merchant/shippingrate', $data, 'layouts/merchant_tpl');
      }		
		
	}

	public function MinTable()
	{
       $mtid=$this->functions->getMerchantID();
		$data = [
            'crumbsTitle' => $this->functions->translation('default', "Minimum Order Table"),
             'mtid'=>$mtid,
             'data'=>$this->functions->getMinOrderTable($mtid)
            ];
           $this->view('merchant/min-table-rates', $data, 'layouts/merchant_tpl');	

	}



  public function CookingRef($params=[])
  {  



   /* $this->crumbsTitle=Yii::t("default","Cooking Reference");
    
    FunctionsV3::registerScript(array(
      "var ajax_merchant_action='deleteCookingRef';"
    ),'ajax_merchant_action');
    
    if (isset($_GET['Do'])){
      if ( $_GET['Do']=="Add"){
        $this->render('cooking-ref-add');     
            } elseif ( $_GET['Do'] =="Sort" ){  
         $this->render('cooking_ref_sort'); 
      } else $this->render('cooking-ref');    
    } else $this->render('cooking-ref');*/



     $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Cooking Reference")
        
            ];
           $this->view('merchant/cooking-ref-add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Cooking Reference")
        
            ];
           $this->view('merchant/cooking_ref_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Cooking Reference"),
             'id'=>$id
            ];
           $this->view('merchant/cooking-ref', $data, 'layouts/merchant_tpl');

        } 



  }





  public function Ingredients($params=[])
  {



    /*$this->crumbsTitle=Yii::t("default","Ingredients");   
    
    FunctionsV3::registerScript(array(
      "var ajax_merchant_action='deleteIngredients';"
    ),'ajax_merchant_action');
    
    if (isset($_GET['Do'])){
      if ($_GET['Do']=="Add"){
        $this->crumbsTitle=Yii::t("default","Ingredients Add");   
        $this->render('ingredients-add');   
      } else {
        $this->crumbsTitle=Yii::t("default","Ingredients Sort");    
        $this->render('ingredients-sort');    
      }   
    } else $this->render('ingredients');*/




    $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Ingredients Add")
        
            ];
           $this->view('merchant/ingredients-add', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Ingredients Sort")
        
            ];
           $this->view('merchant/ingredients-sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  

            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Ingredients"),
             'id'=>$id
            ];
           $this->view('merchant/ingredients', $data, 'layouts/merchant_tpl');

        } 



  }





	public function AddOnItem($params=[])
	{		
		/*$this->crumbsTitle=Yii::t("default","Addon Item");
		$mtid=Yii::app()->functions->getMerchantID();
		
		FunctionsV3::registerScript(array(
		  "var ajax_merchant_action='deleteAddonItem';"
		),'ajax_merchant_action');
		
		if (isset($_GET['Do'])){
			if ( $_GET['Do']=="Add"){
				
				$merchant_tax=getOption($mtid,'merchant_tax');
				if($merchant_tax>0){
				   $merchant_tax=$merchant_tax/100;
				}
				
				$this->render('addon_item_new',array(
				   
				   'merchant_apply_tax'=>'',
				   'merchant_tax'=>0,
				));		
            } elseif ( $_GET['Do'] =="Sort" ){	
			   $this->render('addon_item_sort');	
			} else $this->render('addon_item_list');		
		} else $this->render('addon_item_list');
*/


       


		 $do=$params['Do'];
        $id=$params['id'];
        if(isset($do)&&!empty($do)){
             $_GET['Do']=$do;
         }

         if(isset($id)&&!empty($id)){
             $_GET['id']=$id;
         }


       if (isset($_GET['Do'])){
           if ($_GET['Do']=="Add"){
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Item"),
             'merchant_apply_tax'=>'',
			  'merchant_tax'=>0
            ];
           $this->view('merchant/addon_item_new', $data, 'layouts/merchant_tpl');

           } else {

               $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Item")
        
            ];
           $this->view('merchant/addon_item_sort', $data, 'layouts/merchant_tpl');
           }
        } else {
            //$this->crumbsTitle=Yii::t("default","Cuisine List");
            //$this->render('cuisine-list');  
            
            $data = [
            'crumbsTitle' => $this->functions->translation('default', "Addon Item"),
             'id'=>$id
            ];
           $this->view('merchant/addon_item_list', $data, 'layouts/merchant_tpl');

        } 









	}	








	public function category_sked()
	{
		$mtid = $this->functions->getMerchantID();
		/*$this->crumbsTitle=t("Category Scheduler");
		
		$this->render('category_sked',array(
		 'merchant_id'=>$mtid,		 
		));*/

		 $data = [
            'crumbsTitle' => $this->functions->translation('default', "Category Scheduler"),
             'merchant_id'=>$mtid
            ];
           $this->view('merchant/category_sked', $data, 'layouts/merchant_tpl');
	}






    public function dashboard() {

        if (!$this->functions->isMerchantLogin()){           
        $data = [];
        $this->view('merchant/login', $data, 'layouts/login_layout');
        }else{
     
           

      $data = ['crumbsTitle' => $this->functions->translation('default',"Dashboard"),'cancel_order_enabled'=>$this->functions->getOptionAdmin('cancel_order_enabled')];
            $this->view('merchant/dashboard', $data, 'layouts/merchant_tpl'); 
             
          
             /*$data = ['crumbsTitle' => $this->functions->translation('default',"Dashboard")];
            $this->view('admin/dashboard', $data, 'layouts/admin_tpl');*/
            
            
        }
    }


    public function Login()
	{		
		/*if (isset($_GET['logout'])){			
			unset($_SESSION['kr_merchant_user']);
			unset($_SESSION['kr_merchant_user_session']);
		}		
		$this->layout='login_tpl';
	    $this->render('login');*/



	    $url = isset($_GET['url']) ? $_GET['url'] : '';

    // Split the URL into parts
    $urlParts = explode('/', $url);
    $logout_param=$urlParts[2];
    $logout_param_value=$urlParts[3];
    if(isset($logout_param)){
        if($logout_param_value=='true'){
            unset($_SESSION['kr_merchant_user']);
			unset($_SESSION['kr_merchant_user_session']);

        }
    }
    
    if (!$this->functions->isMerchantLogin()){           
    $captchaEnabled=$this->functions->getOptionAdmin('captcha_merchant_login'); 
    $captcha_site_key=$this->functions->getOptionAdmin('captcha_site_key'); 

    //captcha_site_key

     $data = [
            'captchaEnabled' => $captchaEnabled,
            'captcha_site_key' => $captcha_site_key,
            
            ];
        $this->view('merchant/login', $data, 'layouts/login_layout');
    }else{
        
        $data = ['crumbsTitle' => $this->functions->translation('default',"Dashboard"),'cancel_order_enabled'=>$this->functions->getOptionAdmin('cancel_order_enabled')];
            $this->view('merchant/dashboard', $data, 'layouts/merchant_tpl'); 
        
    }


 






	}


	public function Settings()
	{
		$merchant_id = $this->functions->getMerchantID();
		//echo $this->functions->getOption("merchant_close_msg_holiday", $merchant_id); die();
        
		$data = ['crumbsTitle' => $this->functions->translation('default',"Settings")];
        $this->view('merchant/settings', $data, 'layouts/merchant_tpl');


	}



  public function Merchant($params=[])
  {
    $provider = $this->functions->getMapProvider();    
    $map_api = isset($provider['map_api'])?$provider['map_api']:'';
    $map_provider = isset($provider['provider'])?$provider['provider']:'';   

    $code=$params[0]['code'];

    
    
        if(isset($code)&&!empty($code)){
             $_GET['code']=$code;
         } 
    
    
    /*$cs->registerScript(
      'map_apikey',
      "var map_apikey = '$map_api';",
      CClientScript::POS_HEAD
    );
    $cs->registerScript(
      'map_provider',
      "var map_provider = '$map_provider';",
      CClientScript::POS_HEAD
    );
    
    
    $cs->registerScript(
      'mapbox_default_zoom',
      "var mapbox_default_zoom = '$mapbox_default_zoom';",
      CClientScript::POS_HEAD
    );  */  

    $mapbox_default_zoom = $this->functions->getOptionAdmin('mapbox_default_zoom');
    if(empty($mapbox_default_zoom)){
      $mapbox_default_zoom=20;
    }
    
    switch ($provider['provider']) {
      case "google.maps":  
      $map_type='google';   
        /*$cs->registerScriptFile("https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=".$map_api,CClientScript::POS_HEAD); */
        break;
        
      case "mapbox":  
      $map_type='mapbox';         
        /*$cs->registerScriptFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.js"
            ,CClientScript::POS_END);           
            $cs->registerCssFile(Yii::app()->baseUrl."/assets/vendor/leaflet/leaflet.css"); */                  
        break;            
    }

    $data = [
            'crumbsTitle' => $this->functions->translation('default', "Merchant"),
             'map_provider' =>$map_provider,
             'mapbox_default_zoom' =>$mapbox_default_zoom,
             'map_api' =>$map_api,
             'map_type' =>$map_type,
            'provider'=>isset($provider['provider'])?$provider['provider']:''
            ];
        $this->view('merchant/merchant-info', $data, 'layouts/merchant_tpl');

    
    /*$this->crumbsTitle=Yii::t("default","Merchant");
    $this->render('merchant-info');*/




    






  }
	
	
	





    
    
   
}
