<?php
class V3Controller extends Controller {
     protected $db;
     public $crumbsTitle='';
   public $theme_compression='';
    public $is_rtl=false;
    public $action_name='12';
    public $provider;
     public $map_api;
    public $map_provider;  
    public $mapbox_default_zoom;

    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

         $this->Item_menu=new Item_menu();

  $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
   
      date_default_timezone_set($website_timezone);
   $requested_url=$_SERVER['REQUEST_URI'];
  $url_parts = explode('/', trim($requested_url, '/'));
   if (count($url_parts) >= 2) {
    $action_name = $url_parts[1];
   }
   if($action_name=='')
   {
    $action_name='index';
   }
   $this->action_name=$action_name;
   $this->action_id=$action_name;


   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {
		echo "CONTROLLER INDEX";
        die();
        

        
    }
	 
	
	
public function BatchAvailabilityLookup1()
{
    // ✅ Step 0: Basic Auth check with braces
    if (
        $_SERVER['PHP_AUTH_USER'] !== 'loveeatery' ||
        $_SERVER['PHP_AUTH_PW'] !== '12345678'
    ) {
       // header('WWW-Authenticate: Basic realm="Google RwG"');
        //header('HTTP/1.0 401 Unauthorized');
       // exit('Unauthorized');
    }

    // Step 1: Read JSON input
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    

    // Step 2: Prepare response
    $response = ['availability' => []];

    // Step 3: Loop through lookupSpec
    if (isset($data['lookupSpec']) && is_array($data['lookupSpec'])) {
        foreach ($data['lookupSpec'] as $lookup) {
            $merchantId = $lookup['merchantId'] ?? '';
            $serviceId = $lookup['serviceId'] ?? '';



            $startTime = $lookup['startTimeRange']['startSeconds'] ?? time();
            $endTime = $lookup['startTimeRange']['endSeconds'] ?? ($startTime + 86400); // 24 hours

            // Step 4: Create 3 fake slots
            $slots = [];
            for ($i = 0; $i < 3; $i++) {
                $slotStart = $startTime + ($i * 3600); // every hour
                if ($slotStart > $endTime) break;

                $slots[] = [
                    'startSec' => $slotStart,
                    'durationSec' => 3600,
                    'spotsOpen' => 1,
                    'spotsTotal' => 2
                ];
            }

            // Step 5: Append availability block
            $response['availability'][] = [
                'merchantId' => $merchantId,
                'serviceId' => $serviceId,
                'availability' => $slots
            ];
        }
    }

    // Step 6: Output JSON response
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}

public function BatchAvailabilityLookup0001()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Log raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [INPUT] " . $rawInput . "\n", FILE_APPEND);

    // If empty request body
    if (trim($rawInput) === '') {
        file_put_contents($logFile, date('c') . " [WARNING] EMPTY REQUEST BODY\n", FILE_APPEND);
    }

    // Try to decode JSON (if any)
    $data = json_decode($rawInput, true);

    // Fallback sample response if invalid JSON
    if (json_last_error() !== JSON_ERROR_NONE || !isset($data['lookupSpec'])) {
        $slotStart = time();
        $slotStart = $slotStart - ($slotStart % 1800); // Align to 30-min interval

        echo json_encode([
            'availability' => [
                [
                    'merchantId'   => 'loveeatery_001_pk',
                    'serviceId'    => 'reservation',
                    'availability' => [
                        [
                            'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
                            'duration'   => 'PT1H',
                            'spotsOpen'  => 2,
                            'spotsTotal' => 2
                        ]
                    ]
                ]
            ]
        ], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
        return;
    }

    // Build response based on JSON input
    $response = ['availability' => []];
    foreach ($data['lookupSpec'] as $lookup) {
        $merchantId = $lookup['merchantId'] ?? 'unknown';
        $serviceId  = $lookup['serviceId'] ?? 'unknown';

        $startTime = $lookup['startTimeRange']['startSeconds'] ?? time();
        $endTime   = $lookup['startTimeRange']['endSeconds'] ?? ($startTime + 3600);

        // Align start time to nearest 30-minute interval
        $startTime = $startTime - ($startTime % 1800);

        $slots = [];
        if ($endTime < $startTime) $endTime = $startTime + 3600;

        for ($slotStart = $startTime; $slotStart <= $endTime; $slotStart += 1800) {
            $slots[] = [
                'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
                'duration'   => 'PT1H',
                'spotsOpen'  => 2,
                'spotsTotal' => 2
            ];
        }

        $response['availability'][] = [
            'merchantId'   => $merchantId,
            'serviceId'    => $serviceId,
            'availability' => $slots
        ];
    }

    // Log response
    file_put_contents($logFile, date('c') . " [RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}



public function BatchAvailabilityLookup_8_6()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';
   $requestedSlots = $request['slot_time'] ?? [];

   // echo $requestedSlots;die(); 

   $availableSlots = [];
$merchant_id = 3; // Replace with actual merchant ID
$today = date('Y-m-d');
$currentTime = date('H:i:s'); // Current time in H:i:s

$stmt = $this->db->prepare("
    SELECT slot_starts, slot_ends 
    FROM mt_booking_slots_child 
    WHERE merchant_id = ? 
    AND slot_starts >= ? 
    AND available =1
    ORDER BY slot_starts ASC
");

$stmt->execute([$merchant_id, $currentTime]);
$slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

$count = 0;

foreach ($slots as $slot) {
    $startDateTime = strtotime($today . ' ' . $slot['slot_starts']);
    $endDateTime = strtotime($today . ' ' . $slot['slot_ends']);
    $duration = $endDateTime - $startDateTime;

   
        
            $availableSlots[] = [
                "start_sec" => $startDateTime,
                "duration_sec" => $duration,
                "party_size" => $slot['no_of_slots'],
                "service_id" => "reservation"
            ];
        
        $count++;
       /* if ($count >= 5) {
            break;
        }*/
    
}


//print_r($availableSlots);die();

    // Build the slot_time_availability response
    $slotAvailability = [];
    foreach ($requestedSlots as $slot) {
        $found = false;

        foreach ($availableSlots as $available) {
            if (
                $slot['start_sec'] == $available['start_sec'] &&
                $slot['duration_sec'] == $available['duration_sec'] &&
                ($slot['resource_ids']['party_size'] ?? 0) == $available['party_size'] &&
                strtolower($slot['service_id']) == strtolower($available['service_id'])
            ) {
                $found = true;
                break;
            }
        }

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => (int) $slot['start_sec'],
                'duration_sec' => (int) $slot['duration_sec'],
                'resource_ids' => [
                    'party_size' => (int) ($slot['resource_ids']['party_size'] ?? 0)
                ],
                'service_id' => $slot['service_id']
            ]
        ];
    }

    // Final response
    $response = [
        'slot_time_availability' => $slotAvailability
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

public function BatchAvailabilityLookup_bkup()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';
    $requestedSlots = $request['slot_time'] ?? [];

    // Generate dynamic availability slots
    $availableSlots = [];
    $startTime = 1753462800; // Base start time (Thu, 24 Jul 2025 13:00:00 UTC)
    $duration = 3600;        // Slot duration (1 hour)

    // Create 20 slots with party sizes 1 to 5
    for ($i = 0; $i < 40; $i++) {
        for ($party = 2; $party <=5; $party++) {
            $availableSlots[] = [
                "start_sec" => $startTime + ($i * $duration),
                "duration_sec" => $duration,
                "party_size" => $party,
                "service_id" => "reservation"
            ];
        }
    }

    // Build the slot_time_availability response
    $slotAvailability = [];
    foreach ($requestedSlots as $slot) {
        $found = false;

        foreach ($availableSlots as $available) {
            if (
                $slot['start_sec'] == $available['start_sec'] &&
                $slot['duration_sec'] == $available['duration_sec'] &&
                ($slot['resource_ids']['party_size'] ?? 0) == $available['party_size'] &&
                strtolower($slot['service_id']) == strtolower($available['service_id'])
            ) {
                $found = true;
                break;
            }
        }

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => (int) $slot['start_sec'],
                'duration_sec' => (int) $slot['duration_sec'],
                'resource_ids' => [
                    'party_size' => (int) ($slot['resource_ids']['party_size'] ?? 0)
                ],
                'service_id' => $slot['service_id']
            ]
        ];
    }

    // Final response
    $response = [
        'slot_time_availability' => $slotAvailability
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}








public function BatchAvailabilityLooku3p()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';
    $requestedSlots = $request['slot_time'] ?? [];

    // Static availability slots (replace this with DB fetch in real use)
    $availableSlots = [
        [
            "start_sec" => 1753524000,
            "duration_sec" => 3600,
            "party_size" => 2,
            "service_id" => "reservation"
        ],
        // You can add more slots as needed...
    ];

    // Build the slot_time_availability response
    $slotAvailability = [];

    foreach ($requestedSlots as $slot) {
        $found = false;

        foreach ($availableSlots as $available) {
            if (
                $slot['start_sec'] == $available['start_sec'] &&
                $slot['duration_sec'] == $available['duration_sec'] &&
                ($slot['resource_ids']['party_size'] ?? 0) == $available['party_size'] &&
                strtolower($slot['service_id']) == strtolower($available['service_id'])
            ) {
                $found = true;
                break;
            }
        }

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => (int) $slot['start_sec'],
                'duration_sec' => (int) $slot['duration_sec'],
                'resource_ids' => [
                    'party_size' => (int) ($slot['resource_ids']['party_size'] ?? 0)
                ],
                'service_id' => $slot['service_id']
            ]
        ];
    }

    // Final response
    $response = [
        'slot_time_availability' => $slotAvailability
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

public function BatchAvailabilityLookup21()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Log raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup INPUT] " . $rawInput . "\n", FILE_APPEND);

    $data = json_decode($rawInput, true);

    // Always return slots for 23rd July 2025
    $date = '2025-07-23';
    $startOfDay = strtotime($date . ' 00:00:00 UTC');
    $endOfDay = strtotime($date . ' 23:30:00 UTC');

    $slots = [];
    for ($slotStart = $startOfDay; $slotStart <= $endOfDay; $slotStart += 1800) {
        $slots[] = [
            'startTime'  => gmdate("Y-m-d\TH:i:00\Z", $slotStart),
            'duration'   => 'PT1H',
            'spotsOpen'  => 2,
            'spotsTotal' => 2
        ];
    }

    $response = [
        'availability' => [
            [
                'merchantId'   => 'loveeatery_001_pk',
                'serviceId'    => 'reservation',
                'availability' => $slots
            ]
        ]
    ];

    file_put_contents($logFile, date('c') . " [BatchAvailabilityLookup RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}





public function CreateBooking_29sep()
{
    // Disable error display in output
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);

    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Get raw request input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [CreateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Try to decode JSON
    $request = json_decode($rawInput, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        // If not JSON, try parsing as Protobuf text
        $request = $this->parseProtobufText($rawInput);

        if (empty($request)) {
            http_response_code(400);
            $error = ['error' => 'Invalid JSON or Protobuf text'];
            file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
            echo json_encode($error);
            return;
        }
    }

    

    $service_id=$this->functions->getOptionAdmin('service_id');

    $service_id=$service_id??'reservation';

    // Extract fields
    $slot     = $request['slot'] ?? [];
    $merchantId = $slot['merchant_id'] ?? ($request['merchant_id'] ?? '');
    $serviceId  = strtolower($slot['service_id'] ?? ($request['service_id'] ?? ''));
    $userInfo   = $request['user_information'] ?? [];
    $paymentInfo = $request['payment_information'] ?? ['prepayment_status' => 'PREPAYMENT_NOT_PROVIDED'];

    // Get slot data
    $startSec    = $slot['start_sec'] ?? 0;
    $durationSec = $slot['duration_sec'] ?? 3600;

    // Normalize resources
    $resources = $slot['resources'] ?? ['party_size' => 2];


     $stmt = $this->db->prepare("
    SELECT merchant_id
    FROM mt_option
    WHERE option_name = 'booking_id'
      AND option_value = ?
    LIMIT 1
");
$stmt->execute([$merchantId]);
$merchantOption = $stmt->fetch(PDO::FETCH_ASSOC);
if ($merchantOption) {
    $merchant_id_our_system = $merchantOption['merchant_id'];
} else {
    $merchant_id_our_system = 0; // not found
}



    //$merchant_id_our_system=$this->functions->getOptionAdmin($merchantId);

    

   

    $confirmationMode = $slot['confirmation_mode'] ?? 'CONFIRMATION_MODE_SYNCHRONOUS';

     //$start_sec = ($start_sec;
    
    if($confirmationMode=='CONFIRMATION_MODE_SYNCHRONOUS'){
        $status_book='CONFIRMED';
        $status_site='approved';
    }else{
        $status_book='PENDING_MERCHANT_CONFIRMATION';
        $status_site='pending';
        
    }


   

    // Generate booking ID
    $bookingId = uniqid('booking_');


 //'status'             => 'CONFIRMED',
    // Build response
    $response = [
        'booking' => [
            'booking_id'         => $bookingId,
            'payment_information'=> $paymentInfo,
            'slot'               => [
                'merchant_id'        => $merchantId,
                'service_id'         => $service_id,
                'start_sec'          => $startSec,
                'duration_sec'       => $durationSec,
                'resources'          => $resources,
                'confirmation_mode'  => $confirmationMode
            ],
            'status'             => $status_book,
            'user_information'   => $userInfo
        ]
    ];

      $params=array(
            'booking_id_google'=>$bookingId,
            'merchant_id'=>$merchant_id_our_system,
            'number_guest'=>$slot['resources']['party_size'],
            'date_booking'=>date('Y-m-d', $startSec),
            'booking_time'=>date('H:i:s', $startSec), 
            'booking_name'=>$userInfo['given_name'], 
            'mobile'=>$userInfo['telephone'],
            'email'=>$userInfo['email'], 
            'status'=>$status_site, 
            'utc_times'=>$startSec,  
            'client_id'=>0, 
            'user_id_google'=>$userInfo['user_id'],
            'merchant_id_google'=>$merchantId,
            'google_response'=>json_encode($response)

          );  
       $this->functions->insertData('mt_bookingtable', $params);


    //++++for notification
     $params_notification=array(
            'booking_id'=>$bookingId,
            'merchant_id'=>$merchantId,
            'number_guest'=>$slot['resources']['party_size'],
            'date_booking'=>date('Y-m-d', $startSec),
            'booking_time'=> $this->functions->prettyTime(date('H:i:s', $startSec)), 
            'booking_name'=>$userInfo['given_name'], 
            'mobile'=>$userInfo['telephone'],
            'email'=>$userInfo['email'], 
            
            
            'client_id'=>$userInfo['user_id']
            

          );  

     $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id_our_system);

     $params_notification['restaurant_name']=$mt_info['restaurant_name'];

     

    

    $new_data=$params_notification;
    $this->functions->notifyBooking($new_data);
    //----for notification

    //+++formulti slots increment 
      
       $slots_info_data=$this->functions->getslotsbyUTC_alols($startSec,$merchant_id_our_system);

      

       
       if(isset($slots_info_data) && !empty($slots_info_data)){
           foreach($slots_info_data as $slots_info){
             $used_slots=$slots_info['used_slots']+1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];


        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,
          );  


             $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
           }
           
           
           
           
           
       }
       
     

       


    //---for slots increment

       


    file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}





/**
 * Converts Protobuf text to a PHP array
 */
private function parseProtobufText($input)
{
    // Add quotes around keys
    $input = preg_replace('/([a-zA-Z_][a-zA-Z0-9_]*)\s*{/', '"$1": {', $input);
    $input = preg_replace('/([a-zA-Z_][a-zA-Z0-9_]*)\s*:/', '"$1":', $input);

    // Convert unquoted values like CONFIRMATION_MODE_SYNCHRONOUS to strings
    $input = preg_replace('/:\s*([A-Z_]+)/', ': "$1"', $input);

    // Ensure braces are balanced
    $jsonInput = '{' . trim($input) . '}';

    $parsed = json_decode($jsonInput, true);
    return $parsed ?: [];
}










public function UpdateBooking_x_bywas()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';



    // Get raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [UpdateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Extract booking object
    $booking   = $request['booking'] ?? [];
    $bookingId = $booking['booking_id'] ?? '';
    $status = $booking['status'] ?? '';



    // Validate booking ID
    if (empty($bookingId)) {
        http_response_code(400);
        $error = ['error' => 'bookingId is required.'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Extract updated slot
    $slot = $booking['slot'] ?? [];
    $startSec    = isset($slot['start_sec']) ? (int)$slot['start_sec'] : time() + 1800;
    $durationSec = isset($slot['duration_sec']) ? (int)$slot['duration_sec'] : 3600;

    // Simulate fetching original booking details (from database or cache)
    // For now, hardcoded based on your CreateBooking response

    $stmt = $this->db->prepare("
    SELECT * 
    FROM mt_bookingtable 
    WHERE booking_id_google = ?
");
$stmt->execute([$bookingId]);
$booking_from_db = $stmt->fetchAll(PDO::FETCH_ASSOC);



$party_size=$booking_from_db[0]['number_guest'];
$email=$booking_from_db[0]['email'];
$name=$booking_from_db[0]['booking_name'];
$telephone=$booking_from_db[0]['mobile'];



    $originalBooking = [
        'merchant_id'      => 'loveeatery_001_pk',
        'service_id'       => 'reservation',
        'resources'        => ['party_size' => $party_size],
        'user_information' => [
            'email'        => $email,
            'family_name'  => $name,
            'given_name'   => $name,
            'telephone'    => $telephone,
            'user_id'      => '18229298356804749723'
        ],
        'payment_information' => [
            'prepayment_status' => 'PREPAYMENT_NOT_PROVIDED'
        ]
    ];

    
    if($status=="CANCELED"){
        $response = [
        'booking' => [
            'booking_id' => $bookingId,
            'slot' => [
                'merchant_id'       => $originalBooking['merchant_id'],
                'service_id'        => $originalBooking['service_id'],
                'start_sec'         => $startSec,
                'duration_sec'      => $durationSec,
                'resources'         => $originalBooking['resources'],
                'confirmation_mode' => 'CONFIRMATION_MODE_SYNCHRONOUS'
            ],
            'status'           => 'CANCELLED',
            'user_information' => $originalBooking['user_information'],
            'cancellation'     => [
                'reason' => $cancelReason,
                'cancelled_at_sec' => time()
            ]
        ]
    ];

    // Prepare DB update params (follow existing update pattern)
    $params_update = [
        'status'          => 'cancel_booking_approved',
        
        'google_response' => json_encode($response)
    ];
    }else{

    // Build response
    $response = [
        'booking' => [
            'booking_id'         => $bookingId,
            'payment_information'=> $originalBooking['payment_information'],
            'slot'               => [
                'merchant_id'       => $originalBooking['merchant_id'],
                'service_id'        => $originalBooking['service_id'],
                'start_sec'         => $startSec,
                'duration_sec'      => $durationSec,
                'resources'         => $originalBooking['resources'],
                'confirmation_mode' => 'CONFIRMATION_MODE_SYNCHRONOUS'
            ],
            'status'             => 'CONFIRMED',
            'user_information'   => $originalBooking['user_information']
        ]
    ];


    $params_update=array(
            
            
            
            'date_booking'=>date('Y-m-d', $startSec),
            'booking_time'=>date('H:i:s', $startSec), 
            
            
            'google_response'=>json_encode($response)

          );  
    if(isset($request['resources']['party_size'])){
        $params_update['number_guest']=$request['resources']['party_size'];

    }
}







     $this->functions->updateData("mt_bookingtable",$params_update,'booking_id_google',$bookingId);



    // Log response
    file_put_contents($logFile, date('c') . " [UpdateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    // Return response
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}




public function CreateBooking21()
{
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [CreateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    $merchantId = $request['merchantId'] ?? '';
    $serviceId  = $request['serviceId'] ?? '';
    $slot       = $request['slot'] ?? [];
    $userInfo   = $request['userInformation'] ?? [];

    // Validate slot (only allow 23rd July 2025)
    $startSec   = $slot['startSec'] ?? 0;
    $slotDate   = gmdate('Y-m-d', $startSec);
    if ($slotDate !== '2025-07-23') {
        http_response_code(400);
        $error = ['error' => 'Only bookings for 2025-07-23 are allowed'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    $bookingId = uniqid('booking_');

    $response = [
        "booking" => [
            "bookingId"       => $bookingId,
            "merchantId"      => $merchantId,
            "serviceId"       => $serviceId,
            "slot"            => $slot,
            "userInformation" => $userInfo,
            "status"          => "CONFIRMED"
        ]
    ];

    file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}


public function getAllslotsagainstMerchant() {
    $merchant_id = 3;
    $service_id = 'reservation';
    $merchant_gid = "loveeatery_001_pk"; // This should match your RwG merchant_id
    $confirmation_mode = "CONFIRMATION_MODE_SYNCHRONOUS";

   echo  $currentDateTime = date('Y-m-d H:i:s');
  echo  $currentDateTime='2025-08-15 00:54:55';

    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_booking_slots_child 
        WHERE merchant_id = ? 
        AND available = 1 
        AND CONCAT(date, ' ', slot_starts) >= ?
        ORDER BY date ASC
        limit 80
    ");
    $stmt->execute([$merchant_id, $currentDateTime]);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $final_data = [];

    foreach ($slots as $slot) {
        $start_time = strtotime($slot['date'] . ' ' . $slot['slot_starts']);
        $end_time = strtotime($slot['date'] . ' ' . $slot['slot_ends']);
        $duration_sec = $end_time - $start_time;

        $spots_total = $slot['no_of_slots'];
        $party_size = (int) $slot['person_per_party'];

        $final_data[] = [
            "spots_total" => (int) $spots_total,
            "spots_open" => (int) $spots_total,
            "duration_sec" => $duration_sec,
            "service_id" => $service_id,
            "start_sec" => $start_time,
            "merchant_id" => $merchant_gid,
            "resources" => [ "party_size" => $party_size ],
            "confirmation_mode" => $confirmation_mode
        ];
    }

    header('Content-Type: application/json');
    echo json_encode($final_data, JSON_PRETTY_PRINT);
}




public function BatchAvailabilityLookup_bywaseem()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [ERROR] Invalid JSON: " . json_last_error_msg() . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';
    $merchantId = 3; // force merchant ID (if needed)
    $requestedSlots = $request['slot_time'] ?? [];

    if (empty($merchantId) || empty($requestedSlots)) {
        $error = ['error' => 'Missing merchant_id or slot_time'];
        file_put_contents($logFile, date('c') . " [ERROR] Missing parameters\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $isFullPageLoad = count($requestedSlots) > 3;
    file_put_contents($logFile, date('c') . " [INFO] Request Type: " . ($isFullPageLoad ? "PAGE LOAD" : "SLOT CLICK") . "\n", FILE_APPEND);

    // Convert first requested slot start time to UTC timestamp
    $start_sec = (int)$requestedSlots[0]['start_sec'];
    $utcNow = strtotime(gmdate('Y-m-d H:i:s', $start_sec));

    // Fetch available slots from DB starting from that UTC time
    $stmt = $this->db->prepare("
        SELECT id, utc_times, slot_starts, slot_ends, person_per_party 
        FROM mt_booking_slots_child 
        WHERE merchant_id = ? 
        AND available = 1
        AND utc_times >= ? 
        ORDER BY utc_times ASC
        LIMIT 20
    ");
    $stmt->execute([$merchantId, $utcNow]);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $availableSlots = [];
    foreach ($slots as $slot) {
        $startDateTime = (int)$slot['utc_times']; // already stored as timestamp
        $startTime = strtotime($slot['slot_starts']);
        $endTime = strtotime($slot['slot_ends']);
        $duration = $endTime - $startTime;

        $availableSlots[] = [
            "start_sec" => $startDateTime,
            "duration_sec" => $duration,
            "party_size" => (int)$slot['person_per_party'],
            "service_id" => "reservation"
        ];
    }

    // Response array & tracker for uniqueness
    $slotAvailability = [];
    $addedSlots = [];

    // 1️⃣ Add requested slots first
    foreach ($requestedSlots as $slot) {
        $requestedStart = (int)$slot['start_sec'];
        $requestedDuration = (int)$slot['duration_sec'];
        $requestedPartySize = (int)($slot['resource_ids']['party_size'] ?? 0);
        $requestedServiceId = strtolower($slot['service_id'] ?? '');

        $requestedStartUtc = strtotime(gmdate('Y-m-d H:i:s', $requestedStart));

        $found = false;
        foreach ($availableSlots as $available) {
            if (
                $requestedStartUtc == $available['start_sec'] &&
                $requestedPartySize <= $available['party_size'] &&
                $requestedServiceId === strtolower($available['service_id'])
            ) {
                $found = true;
                break;
            }
        }

        // Unique key for preventing duplicates
        $slotKey = $requestedStart . '|' . $requestedPartySize . '|' . strtolower($slot['service_id']);
        $addedSlots[$slotKey] = true;

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => $requestedStart,
                'duration_sec' => $requestedDuration,
                'resource_ids' => [
                    'party_size' => $requestedPartySize
                ],
                'service_id' => $slot['service_id']
            ]
        ];
    }

    // 2️⃣ Append extra DB slots without duplication
    foreach ($availableSlots as $available) {
        $slotKey = $available['start_sec'] . '|' . $available['party_size'] . '|' . strtolower($available['service_id']);

        if (!isset($addedSlots[$slotKey])) {
            $addedSlots[$slotKey] = true;

            $slotAvailability[] = [
                'available' => true,
                'slot_time' => [
                    'start_sec' => $available['start_sec'],
                    'duration_sec' => $available['duration_sec'],
                    'resource_ids' => [
                        'party_size' => $available['party_size']
                    ],
                    'service_id' => $available['service_id']
                ]
            ];
        }
    }

    $response = ['slot_time_availability' => $slotAvailability];

    file_put_contents($logFile, date('c') . " [RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}


public function sendInventoryUpdate()
{
    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $serviceAccountPath = __DIR__ . '/../../vendor/service-account.json';

    // Set up Google Client
    $client = new Google_Client();
    $client->setAuthConfig($serviceAccountPath);
    $client->addScope('https://www.googleapis.com/auth/mapsbooking');

    // Get access token from service account
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];

    // API variables
    $baseUrl   = "https://partnerdev-mapsbooking.googleapis.com/"; // Sandbox endpoint
    $partnerId = '20003268';

    // Create availability array for 3 days
    $availability = [];
    for ($d = 0; $d < 3; $d++) {
        $date = date("Y-m-d", strtotime("+$d days"));
        for ($hour = 9; $hour < 17; $hour++) {
            $startTime = date("Y-m-d\TH:i:s\Z", strtotime("$date $hour:00:00 UTC"));
            $endTime   = date("Y-m-d\TH:i:s\Z", strtotime("$date " . ($hour + 1) . ":00:00 UTC"));
            $spots = rand(1, 5);

            $availability[] = [
                "serviceId" => "reservation",
                "startTime" => $startTime,
                "endTime" => $endTime,
                "spotsTotal" => $spots,
                "spotsAvailable" => $spots
            ];
        }
    }
     print_r($availability);die();
    // Inventory update payload
    $payload = [
        "name" => "partners/{$partnerId}",
        "availability" => $availability
    ];
 die();
    // Prepare cURL request
    $url = $baseUrl . "v1alpha/inventory:update";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch);
    } else {
        echo "Success:\n";
        echo $result;
    }

    curl_close($ch);
}



public function sendInventoryUpdateFileUpload1()
{
    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $serviceAccountPath = __DIR__ . '/../../vendor/service-account.json';

    // Google Client Auth
    $client = new Google_Client();
    $client->setAuthConfig($serviceAccountPath);
    $client->addScope('https://www.googleapis.com/auth/mapsbooking');



    // Get Access Token
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];

    $partnerId  = '20003268';
    $merchantId = 'loveeatery_001_pk';
    $serviceId  = 'reservation';

    // Generate slots for 3 days
    $availability = [];
    $daysAhead    = 3;
    $slotDuration = 1800; // 30 minutes in seconds

    for ($d = 0; $d < $daysAhead; $d++) {
        $date = strtotime("+$d days 09:00:00 UTC");
        for ($i = 0; $i < 8; $i++) { // 8 slots per day
            $startSec = $date + ($i * $slotDuration);
            $availability[] = [
                "spots_total"       => 3,
                "spots_open"        => 3,
                "duration_sec"      => $slotDuration,
                "service_id"        => $serviceId,
                "start_sec"         => $startSec,
                "merchant_id"       => $merchantId,
                "resources"         => ["party_size" => 2],
                "confirmation_mode" => "CONFIRMATION_MODE_SYNCHRONOUS"
            ];
        }
    }

     print_r($availability);

    die();

    // Build final payload
    $payload = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number"           => 0,
            "total_shards"           => 1,
            "nonce"                  => uniqid(),
            "generation_timestamp"   => time()
        ],
        "service_availability" => [
            [
                "availability" => $availability
            ]
        ]
    ];



    // Send to Google
    $url = "https://partnerdev-mapsbooking.googleapis.com/v1alpha/inventory:upload";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch);
    } else {
        echo "Success:\n";
        echo $result;
    }

    curl_close($ch);
}


public function sendInventoryUpdateFileUpload()
{
    require_once __DIR__ . '/../../vendor/google-client/vendor/autoload.php';
    require_once __DIR__ . '/../../vendor/google-client/googlemanagement.php';

    $serviceAccountPath = __DIR__ . '/../../vendor/service-account.json';

    // Google Client Auth
    $client = new Google_Client();
    $client->setAuthConfig($serviceAccountPath);
    $client->addScope('https://www.googleapis.com/auth/mapsbooking');

    // Get Access Token
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];

    $partnerId  = '20003268';
    //$merchantId = 'loveeatery_001_pk';
    $serviceId  = 'reservation';

    // Tomorrow's date in Y-m-d format
    $tomorrow = date('Y-m-d', strtotime('+1 day'));

    // Fetch slots from database
    $stmt = $this->db->prepare("
        SELECT *
        FROM mt_booking_slots_child
        WHERE date = ?
        ORDER BY id ASC
    ");
    $stmt->execute([$tomorrow]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $availability = [];

    foreach ($rows as $row) {
        /*$startSec   = strtotime($row['date'] . ' ' . $row['start_time'] . ' UTC');
        $endSec     = strtotime($row['date'] . ' ' . $row['end_time'] . ' UTC');
        $duration   = $endSec - $startSec;*/

        $merchantId =$this->functions->getOption("booking_id",$row['merchant_id']);

        $availability[] = [
            "spots_total"       => (int)$row['no_of_slots'],
            "spots_open"        => (int)$row['available_slots'],
            "duration_sec"      => 1800,
            "service_id"        => $serviceId,
            "start_sec"         => $row['utc_times'],
            "merchant_id"       => $merchantId,
            "resources"         => ["party_size" => (int)$row['person_per_party']],
            "confirmation_mode" => "CONFIRMATION_MODE_SYNCHRONOUS"
        ];
    }

    // Debug check
    print_r($availability);
    die();

    // Build final payload
    $payload = [
        "metadata" => [
            "processing_instruction" => "PROCESS_AS_COMPLETE",
            "shard_number"           => 0,
            "total_shards"           => 1,
            "nonce"                  => uniqid(),
            "generation_timestamp"   => time()
        ],
        "service_availability" => [
            [
                "availability" => $availability
            ]
        ]
    ];

    // Send to Google
    $url = "https://partnerdev-mapsbooking.googleapis.com/v1alpha/inventory:upload";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch);
    } else {
        echo "Success:\n";
        echo $result;
    }

    curl_close($ch);
}





	





public function BatchAvailabilityLookup_fff()
{
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [ERROR] Invalid JSON: " . json_last_error_msg() . "\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';

    $stmt = $this->db->prepare("
    SELECT merchant_id
    FROM mt_option
    WHERE option_name = 'booking_id'
      AND option_value = ?
    LIMIT 1
");
$stmt->execute([$merchantId]);
$merchantOption = $stmt->fetch(PDO::FETCH_ASSOC);
if ($merchantOption) {
    $merchantId = $merchantOption['merchant_id'];
} else {
    $merchantId = 0; // not found
}


    
    
    


     //$merchantId =3;
    $requestedSlots = $request['slot_time'] ?? [];

    if (empty($merchantId) || empty($requestedSlots)) {
        $error = ['error' => 'Missing merchant_id or slot_time'];
        file_put_contents($logFile, date('c') . " [ERROR] Missing parameters\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    $isFullPageLoad = count($requestedSlots) > 3;
    file_put_contents($logFile, date('c') . " [INFO] Request Type: " . ($isFullPageLoad ? "PAGE LOAD" : "SLOT CLICK") . "\n", FILE_APPEND);

    // Convert first requested slot start time (UNIX timestamp) to UTC datetime string
    $start_sec = (int)$requestedSlots[0]['start_sec'];
     //$utcNow = gmdate('Y-m-d H:i:s', $start_sec);  // ← used for filtering the query
    //$utcNow=strtotime($utcNow);

     $utcNow=$start_sec;
   
    // Fetch available slots from DB starting from that UTC time
   // AND available_slots > 0
    $stmt = $this->db->prepare("
        SELECT id, utc_times, slot_starts, slot_ends, person_per_party ,available_slots
        FROM mt_booking_slots_child 
        WHERE merchant_id = ? 
        AND available = 1
        
        AND utc_times >= ?
        ORDER BY utc_times ASC
        LIMIT 20
    ");

    $stmt->execute([$merchantId, $utcNow]);
    $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

   //print_r($slots);die();

    $availableSlots = [];
//print_r($slots);
    foreach ($slots as $slot) {
        $startDateTime = $slot['utc_times'];
        $startTime = strtotime($slot['slot_starts']);
        $endTime = strtotime($slot['slot_ends']);
        $duration = $endTime - $startTime;

        $availableSlots[] = [
            "start_sec" => $startDateTime,
            "duration_sec" => $duration,
            "party_size" => (int)$slot['person_per_party'],
            "available_slots" => (int)$slot['available_slots'],
            "service_id" => "reservation"
        ];
    }

    // Match Google's requested slots with available ones
    $slotAvailability = [];

    foreach ($requestedSlots as $slot) {
        $requestedStart = (int)$slot['start_sec'];
            //$utcNow = gmdate('Y-m-d H:i:s', $requestedStart); 
        $utcNow =  $requestedStart; 
    $start_sec_news = (int)$requestedStart;
    //$start_sec_news = gmdate('Y-m-d H:i:s', $start_sec_news);  // ← used for filtering the query
    // $start_sec_news=strtotime($start_sec_news);
        
        
        $requestedDuration = (int)$slot['duration_sec'];
        $requestedPartySize = (int)($slot['resource_ids']['party_size'] ?? 0);
         $requestedServiceId = strtolower($slot['service_id'] ?? '');

        $found = false;

        foreach ($availableSlots as $available) {
        
            if (
                $start_sec_news == $available['start_sec'] &&
                $requestedPartySize <= $available['party_size'] &&

                $available['available_slots']>0 &&

                $requestedServiceId === strtolower($available['service_id'])
            ) {
                $found = true;
                break;
            }
        }

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => $requestedStart,
                'duration_sec' => $requestedDuration,
                'resource_ids' => [
                    'party_size' => $requestedPartySize
                ],
                'service_id' => $slot['service_id']
            ]
        ];
    }

    $response = ['slot_time_availability' => $slotAvailability];

    file_put_contents($logFile, date('c') . " [RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}





//--------v3 functions




public function BatchAvailabilityLookup()
{
    // --- ENFORCE GOOGLE BASIC AUTH (Required) ---
    $this->enforceBasicAuth();
    // -------------------------------------------

    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Read and log incoming request
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [ERROR] Invalid JSON: " . json_last_error_msg() . "\n", FILE_APPEND);

        echo json_encode($error);
        exit;
    }

    $merchantId = $request['merchant_id'] ?? '';

    // Fetch merchant ID internally
    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
          AND option_value = ?
        LIMIT 1
    ");
    $stmt->execute([$merchantId]);
    $merchantOption = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($merchantOption) {
        $merchantId = $merchantOption['merchant_id'];
    } else {
        $merchantId = 0;
    }

    $requestedSlots = $request['slot_time'] ?? [];
    $service_id = $requestedSlots[0]['service_id'] ?? '';
    $duration_sec1 = $requestedSlots[0]['duration_sec'] ?? 1800;

    if (empty($merchantId) || empty($requestedSlots)) {
        $error = ['error' => 'Missing merchant_id or slot_time'];
        file_put_contents($logFile, date('c') . " [ERROR] Missing parameters\n", FILE_APPEND);
        echo json_encode($error);
        exit;
    }

    // Log request type (Page load vs Slot click)
    $isFullPageLoad = count($requestedSlots) > 3;
    file_put_contents($logFile, date('c') . " [INFO] Request Type: " . ($isFullPageLoad ? "PAGE LOAD" : "SLOT CLICK") . "\n", FILE_APPEND);

    // Extract timestamps
    $startSecs = array_column($requestedSlots, 'start_sec');
    $partySize = (int)($requestedSlots[0]['resource_ids']['party_size'] ?? 0);

    $startSecs = array_map('intval', $startSecs);

    if (!empty($startSecs)) {

        $placeholders = implode(',', array_fill(0, count($startSecs), '?'));

        $sql = "
            SELECT available,id, utc_times, slot_starts, slot_ends, person_per_party, available_slots
            FROM mt_booking_slots_child
            WHERE merchant_id = ?
              AND person_per_party = ?
              AND utc_times IN ($placeholders)
            ORDER BY utc_times ASC
        ";

        $stmt = $this->db->prepare($sql);
        $params = array_merge([$merchantId, $partySize], $startSecs);
        $stmt->execute($params);

        $slots = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    $slotAvailability = [];

    foreach ($slots as $slot) {

        $startDateTime = $slot['utc_times'];
        $requestedPartySize = $partySize;

        $found = false;
        if ($slot['available_slots'] > 0 && $slot['available'] == 1) {
            $found = true;
        }

        $slotAvailability[] = [
            'available' => $found,
            'slot_time' => [
                'start_sec' => $startDateTime,
                'duration_sec' => $duration_sec1,
                'resource_ids' => [
                    'party_size' => $requestedPartySize
                ],
                'service_id' => $service_id
            ]
        ];
    }

    $response = ['slot_time_availability' => $slotAvailability];

    file_put_contents($logFile, date('c') . " [RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}




public function UpdateBooking()
{
	
	$this->enforceBasicAuth();  
	
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Get raw input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [UpdateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Decode JSON
    $request = json_decode($rawInput, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        $error = ['error' => 'Invalid JSON'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Extract booking object
    $booking   = $request['booking'] ?? [];
	
			
    $bookingId = $booking['booking_id'] ?? '';
    $status    = strtoupper($booking['status'] ?? '');

    if (empty($bookingId)) {
        http_response_code(400);
        $error = ['error' => 'bookingId is required.'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Fetch booking from DB
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_bookingtable 
        WHERE booking_id_google = ?
    ");
    $stmt->execute([$bookingId]);
    $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);
//print_r($booking_from_db);
    if (!$booking_from_db) {
        http_response_code(404);
        $error = ['error' => 'Booking not found.'];
        file_put_contents($logFile, date('c') . " [UpdateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    // Common variables
    $party_size = (int)$booking_from_db['number_guest'];
    $email      = $booking_from_db['email'];
    $name       = $booking_from_db['booking_name'];
    $telephone  = $booking_from_db['mobile'];
    $merchant_id_google  = $booking_from_db['merchant_id_google'];
	$merchant_id= $booking_from_db['merchant_id'];
    $user_id_google  = $booking_from_db['user_id_google'];
    
   $utc_times=$booking_from_db['utc_times'];


    // -----------------
    // CANCELLATION CASE
    // -----------------
    if ($status === "CANCELLED" || $status === "CANCELED") {
        $cancelReason = $booking['cancellation']['reason'] ?? 'Cancelled by user';
        $cancelTime   = time(); // UTC seconds

        // Google requires "status": "CANCELED" (American spelling)
        $response = [
            'booking' => [
                'booking_id' => $bookingId,
                'status'     => 'CANCELED',
                'cancellation' => [
                    'reason'            => $cancelReason,
                    'cancelled_at_sec'  => $cancelTime
                ]
            ]
        ];

        $params_update = [
            'status'          => 'cancel_booking_approved',
            'google_response' => json_encode($response)
        ];


         //+++for multi slots decreement 
/*
       $slots_info=$this->functions->getslotsbyUTC($utc_times);
       $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];

        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,

          );  


       
       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);

*/

		$slots_info_data=$this->functions->getslotsbyUTC_alols($utc_times,$merchant_id);
	   
	   if(isset($slots_info_data) && !empty($slots_info_data)){
		   foreach($slots_info_data as $slots_info){
		     
			 
			 $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];

        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,

          );  


       
       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
			 
			 
			 
		   }
		   
		   
		   
		   
		   
	   }










    //---for slots decreement




    }
    // -----------------
    // UPDATE BOOKING CASE
    // -----------------
    else {
     
        
		$status='Update Booking';
        
       $status_dsp="has been modified";

        $slot        = $booking['slot'] ?? [];



        $startSec    = isset($slot['start_sec']) ? (int)$slot['start_sec'] : $utc_times;


        $interval= $this->functions->getOption('google_merchant_duration',$merchant_id);
        $durationSec = isset($slot['duration_sec']) ? (int)$slot['duration_sec'] : $interval;
        




         if($utc_times!=$slot['start_sec']){
        
        //+++for slots decreement 
	   
	   $slots_info_data=$this->functions->getslotsbyUTC_alols($utc_times,$merchant_id);
	   
	   if(isset($slots_info_data) && !empty($slots_info_data)){
		   foreach($slots_info_data as $slots_info){
		     
			 
			 $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];

        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,

          );  
      
       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
			 		 
			 
		   }
		   
		   
		   
		   
		   
	   }
	   

    //---for slots decreement

     //+++for slots increment 

       
	   
	   $slots_info_data=$this->functions->getslotsbyUTC_alols($startSec,$merchant_id);
	   
	   if(isset($slots_info_data) && !empty($slots_info_data)){
		   foreach($slots_info_data as $slots_info){
		     
			 
			 $used_slots=$slots_info['used_slots']+1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];

        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,

          );  


       
       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
			 
			 
			 
		   }
		   
		   
		   
		   
		   
	   }

    //---for slots increment



        }





   
 $service_id=$this->functions->getOptionAdmin('service_id');
        $originalBooking = [
            'merchant_id'      => $merchant_id_google,
            'service_id'       => $service_id,
            'resources'        => ['party_size' => $party_size],
            'user_information' => [
                'email'       => $email,
                'family_name' => $name,
                'given_name'  => $name,
                'telephone'   => $telephone,
                'user_id'     => $user_id_google
            ],
            'payment_information' => [
                'prepayment_status' => 'PREPAYMENT_NOT_PROVIDED'
            ]
        ];

        $response = [
            'booking' => [
                'booking_id'         => $bookingId,
                'payment_information'=> $originalBooking['payment_information'],
                'slot'               => [
                    'merchant_id'       => $originalBooking['merchant_id'],
                    'service_id'        => $originalBooking['service_id'],
                    'start_sec'         => $startSec,
                    'duration_sec'      => $durationSec,
                    'resources'         => $originalBooking['resources'],
                    'confirmation_mode' => 'CONFIRMATION_MODE_SYNCHRONOUS'
                ],
                'status'             => 'CONFIRMED',
                'user_information'   => $originalBooking['user_information']
            ]
        ];

       
		
				
		
        $params_update = [
            'date_booking'    => date('Y-m-d', $startSec),
            'booking_time'    => date('H:i:s', $startSec),
			  'utc_times'=>$startSec,  
            'google_response' => json_encode($response)
        ];

         if (isset($booking['slot']['resources']['party_size'])) {
            $params_update['number_guest'] = (int)$booking['slot']['resources']['party_size'];
            
             $response['booking']['slot']['resources']['party_size'] = (int)$booking['slot']['resources']['party_size'];            
        }

    }

  
    //++++for notification
    $params_notification=array(
              'merchant_id'=>$merchant_id_google,
              'number_guest'=>isset($party_size)?$party_size:'',
              'date_booking'=>$booking_from_db['date_booking'],
              'booking_time'=>$this->functions->prettyTime($booking_from_db['booking_time']),
              'booking_name'=>$name,
              'email'=>$email,
              'mobile'=>$telephone,
              'booking_notes'=>'',
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              
              'viewed'=>2,
              'request_cancel'=>0
            );  

    $params_notification['status'] = $status_dsp ?? "is canceled";
	
	$params_notification['booking_id'] = $bookingId;

    $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id);

    $params_notification['restaurant_name']=$mt_info['restaurant_name'];
	
	

    $new_data=$params_notification;
    $this->functions->updateBookingNotify($new_data);
    //----for notification



    $this->functions->updateData("mt_bookingtable", $params_update, 'booking_id_google', $bookingId);

    // Log and return
    file_put_contents($logFile, date('c') . " [UpdateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}


public function CreateBooking()
{
	
	
	   $this->enforceBasicAuth();  // <-- REQUIRED
    // Disable error display in output
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);

    header('Content-Type: application/json; charset=UTF-8');

    $logFile = __DIR__ . '/debug_requests.log';

    // Get raw request input
    $rawInput = file_get_contents('php://input');
    file_put_contents($logFile, date('c') . " [CreateBooking INPUT] " . $rawInput . "\n", FILE_APPEND);

    // Try to decode JSON
    $request = json_decode($rawInput, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        // If not JSON, try parsing as Protobuf text
        $request = $this->parseProtobufText($rawInput);

        if (empty($request)) {
            http_response_code(400);
            $error = ['error' => 'Invalid JSON or Protobuf text'];
            file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
            echo json_encode($error);
            return;
        }
    }

    $service_id=$this->functions->getOptionAdmin('service_id');
    $service_id=$service_id??'reservation';

    // Extract fields
    $slot        = $request['slot'] ?? [];
    $merchantId  = $slot['merchant_id'] ?? ($request['merchant_id'] ?? '');
    $serviceId   = strtolower($slot['service_id'] ?? ($request['service_id'] ?? ''));
    $userInfo    = $request['user_information'] ?? [];
    $paymentInfo = $request['payment_information'] ?? ['prepayment_status' => 'PREPAYMENT_NOT_PROVIDED'];

    // Get slot data
    $startSec    = $slot['start_sec'] ?? 0;
    $durationSec = $slot['duration_sec'] ?? 3600;

    // Normalize resources
    $resources = $slot['resources'] ?? ['party_size' => 2];

    $stmt = $this->db->prepare("
        SELECT merchant_id
        FROM mt_option
        WHERE option_name = 'booking_id'
          AND option_value = ?
        LIMIT 1
    ");
    $stmt->execute([$merchantId]);
    $merchantOption = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($merchantOption) {
        $merchant_id_our_system = $merchantOption['merchant_id'];
    } else {
        $merchant_id_our_system = 0; // not found
    }

    $confirmationMode = $slot['confirmation_mode'] ?? 'CONFIRMATION_MODE_SYNCHRONOUS';

    if($confirmationMode=='CONFIRMATION_MODE_SYNCHRONOUS'){
        $status_book='CONFIRMED';
        $status_site='approved';
    }else{
        $status_book='PENDING_MERCHANT_CONFIRMATION';
        $status_site='pending';
    }

    //--- NEW CODE START ---
    // Check slot availability before booking
    $slots_info_data = $this->functions->getslotsbyUTC_alols($startSec, $merchant_id_our_system);

    if (empty($slots_info_data)) {
        http_response_code(400);
        $error = ['error' => 'No slot configuration found for this time'];
        file_put_contents($logFile, date('c') . " [CreateBooking ERROR] " . json_encode($error) . "\n", FILE_APPEND);
        echo json_encode($error);
        return;
    }

    $slotAvailable = false;
    foreach ($slots_info_data as $slots_info) {
        if ($slots_info['available_slots'] > 0) {
            $slotAvailable = true;
            break;
        }
    }

  

    if (!$slotAvailable) {
 

$response = [
    'booking_failure' => [
        'cause' => 'SLOT_UNAVAILABLE',
        'description' => 'The requested slot is no longer available.'
    ]
];



    file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

    //--- NEW CODE END ---

    // Generate booking ID
    $bookingId = uniqid('booking_');

    // Build response
    $response = [
        'booking' => [
            'booking_id'         => $bookingId,
            'payment_information'=> $paymentInfo,
            'slot'               => [
                'merchant_id'        => $merchantId,
                'service_id'         => $service_id,
                'start_sec'          => $startSec,
                'duration_sec'       => $durationSec,
                'resources'          => $resources,
                'confirmation_mode'  => $confirmationMode
            ],
            'status'             => $status_book,
            'user_information'   => $userInfo
        ]
    ];

    $random_number = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 10);
    $params=array(
        'booking_id_google'=>$bookingId,
        'merchant_id'=>$merchant_id_our_system,
        'number_guest'=>$slot['resources']['party_size'],
        'date_booking'=>date('Y-m-d', $startSec),
        'booking_time'=>date('H:i:s', $startSec), 
        'booking_name'=>$userInfo['given_name'], 
        'mobile'=>$userInfo['telephone'],
        'email'=>$userInfo['email'], 
        'status'=>$status_site, 
        'utc_times'=>$startSec,  
        'token'=>$random_number,
        'client_id'=>0, 
        'user_id_google'=>$userInfo['user_id'],
        'merchant_id_google'=>$merchantId,
        'google_response'=>json_encode($response)
    );  
    $booking_id_our_system=$this->functions->insertData('mt_bookingtable', $params);

    //++++for notification
    $params_notification=array(
        //'booking_id'=>$bookingId,
        'booking_id'=>$booking_id_our_system,
        'booking_id_our_system'=>$booking_id_our_system,
        'merchant_id'=>$merchantId,
        'merchant_id_our_system'=>$merchant_id_our_system,
        'number_guest'=>$slot['resources']['party_size'],
        'date_booking'=>date('Y-m-d', $startSec),
        'booking_time'=> $this->functions->prettyTime(date('H:i:s', $startSec)), 
        'booking_name'=>$userInfo['given_name'], 
        'mobile'=>$userInfo['telephone'],
        'email'=>$userInfo['email'], 
        'client_id'=>$userInfo['user_id']
    );  

    $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id_our_system);
    $params_notification['restaurant_name']=$mt_info['restaurant_name'];

    $new_data=$params_notification;
    $this->functions->notifyBooking($new_data);
    //----for notification

    //+++for multi slots increment 
    $slots_info_data=$this->functions->getslotsbyUTC_alols($startSec,$merchant_id_our_system);

    if(isset($slots_info_data) && !empty($slots_info_data)){
        foreach($slots_info_data as $slots_info){
            $used_slots=$slots_info['used_slots']+1;
            $available_slots=$slots_info['no_of_slots']-$used_slots;

            $slot_id=$slots_info['id'];

            $params_update1=array(
                'used_slots'=>$used_slots,
                'available_slots'=>$available_slots,
            );  

            $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
        }
    }

    file_put_contents($logFile, date('c') . " [CreateBooking RESPONSE] " . json_encode($response) . "\n", FILE_APPEND);

    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}




public function HealthCheck()
{
    // Google REQUIRES Basic Auth here also
    $this->enforceBasicAuth();

    header('Content-Type: application/json; charset=UTF-8');

    // Simple response Google expects
    $response = [
        'status' => 'OK',
        'timestamp' => time()
    ];

    echo json_encode($response);
    exit;
}

private function enforceBasicAuth()
{
    // Google credentials (update here if you change them in Actions Center)
    $validUser = 'loveeatery';
    $validPass = '12345678';

    // If PHP is running under FastCGI or some environments, PHP_AUTH_* may be empty.
    // If so, try to parse Authorization header (helps some hosting setups).
    if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW'])) {
        if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
            if (stripos($_SERVER['HTTP_AUTHORIZATION'], 'basic ') === 0) {
                $decoded = base64_decode(substr($_SERVER['HTTP_AUTHORIZATION'], 6));
                if ($decoded !== false) {
                    list($user, $pass) = array_pad(explode(':', $decoded, 2), 2, null);
                    $_SERVER['PHP_AUTH_USER'] = $user;
                    $_SERVER['PHP_AUTH_PW']   = $pass;
                }
            }
        }
    }

    if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW'])) {
        header('WWW-Authenticate: Basic realm="GoogleBooking"');
        http_response_code(401);
        header('Content-Type: application/json; charset=UTF-8');
        echo json_encode(['error' => 'Authentication required']);
        exit;
    }

    if ($_SERVER['PHP_AUTH_USER'] !== $validUser || $_SERVER['PHP_AUTH_PW'] !== $validPass) {
        http_response_code(401);
        header('Content-Type: application/json; charset=UTF-8');
        echo json_encode(['error' => 'Invalid credentials']);
        exit;
    }

    // If reached here, authentication passed — proceed.
}

   
   
}
