<?php




class ItemController extends Controller {


    protected $functions;

    

    public function __construct() {
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        
        
        
        $this->UserWrapper = new UserWrapper();

        $this->InventoryWrapper = new InventoryWrapper();
        
        $this->ItemWrap = new ItemWrap();

        $this->StocksWrapper = new StocksWrapper();

        $this->ItemHtmlWrapper = new ItemHtmlWrapper();


       $this->ajax_controller='Ajaxitem';

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     

      date_default_timezone_set($website_timezone);

      if(!$this->UserWrapper->validToken()){
            
            

            $url =Config::$baseUrl.'/inventory/login'; // Adjust the base path as needed
            
            header('Location: ' . $url);

            exit();       
        }else{
            //$this->dashboard();
        }


    }

    


   public function List()
	{
   
		

		$data_columns[] = array('data'=>"item_id");
		$data_columns[] = array('data'=>"photo");
		$data_columns[] = array('data'=>"item_name");
		$data_columns[] = array('data'=>"categories_name");
		$data_columns[] = array('data'=>"price");
		$data_columns[] = array('data'=>"cost_price");
		$data_columns[] = array('data'=>"available_stocks");	
		$data_columns[] = array('data'=>"stocks_status");	
		$data_columns = json_encode($data_columns);		



		$ajax_delete = $this->ajax_controller."/delete_item";



		/*InventoryWrapper::registerScript(array(
		 "var data_columns=$data_columns;",		 
		 "var ajax_delete='$ajax_delete';"
		));*/

        
		
		$merchant_id = $_SESSION['inventory_merchant'];
        
       
		
		$category_list =   (array)$this->InventoryWrapper->dropdownFormat(
		   $this->ItemWrap->getCategory((integer)$merchant_id),'cat_id','category_name',
		   array(
		    'all'=>"All category"
		   )
		);

		

		
		
		$stock_list = array(   
		  'all'=>"All items",
		  'low_stock'=>"Low Stock",
		  'out_stock'=>"Out of Stock",
		);				
		
		


		 $data = [
            'add_label'=>"ADD ITEM",
		 'add_link'=>Config::$baseUrl."/item/item_new",
		 'add_bulk_link'=>Config::$baseUrl."/inventory/item/bulkupload",
		 'category_list'=>$category_list,
		 'stock_list'=>$stock_list
            ];
    
          
        
        $this->view('inventory/item_list', $data, 'inventory/layout');


	}


		public function Item_new($params=[])
	{		



		$data = array();
		$merchant_id = $_SESSION['inventory_merchant'];
		$id=$params['id'];
        if(isset($id)){
       $_GET['id']=$id;
       }
		
		
		try {
								
			if(isset($_GET['id'])){
				$row_id = (integer)$_GET['id'];


				$data = $this->ItemWrap->getData("item","merchant_id=:merchant_id AND item_id=:item_id",array(
				 ':merchant_id'=>$merchant_id,
				 ':item_id'=>$row_id
				));		
                

                
								
				
				
				$gallery_photo = !empty($data['gallery_photo'])?json_decode($data['gallery_photo'],true):array();				
				 
				
			}
			
			
			$addon_category = (array)$this->ItemWrap->dropdownFormat($this->ItemWrap->getAddonCategory($merchant_id),'subcat_id','subcategory_name');			
						
			
			$supplier_list = (array)$this->ItemWrap->dropdownFormat($this->StocksWrapper->getSupplier($merchant_id),'supplier_id','supplier_name');	


			$data = [
            'data'=>($data),		
			 'category'=>$this->ItemWrap->getCategory($merchant_id),
			 'cooking'=>$this->ItemWrap->getCookingRef($merchant_id),
			 'ingredients'=>$this->ItemWrap->getIngredients($merchant_id),
			 'dish'=>$this->ItemWrap->getDish(),
			 'sizes'=>(array)$this->ItemWrap->dropdownFormat((array)$this->ItemWrap->getSizes($merchant_id),'size_id','size_name'),
			 'addon_category'=>$addon_category,	
			 'row_id'=>$row_id,
			 'supplier_list'=>$supplier_list
            ];

            

           

			$this->view('inventory/item_add', $data, 'inventory/layout');
			
		
		} catch (Exception $e) {
			

			$back_url = Config::$baseUrl."/inventory/item/list";

		    $error = ($e->getMessage());
		    

		     $data = [
            'message'=>$error,
		     'back_url'=>$back_url
            ];

		   $this->view('inventory/error_item', $data, 'inventory/layout');


		}
	}


	public function bulkupload()
	{	
	$merchant_id = $_SESSION['inventory_merchant'];

	/*$this->render('bulkupload',array(
		 'merchant_id'=>$merchant_id));*/

	$data = [
            
		     'merchant_id'=>$merchant_id
            ];

	$this->view('inventory/bulkupload', $data, 'inventory/layout');



}



   


	
	
	
   
}
