<?php
class ReportsWrapper{


	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        
        

    }
	
	public  function generateDateRange($range1='', $range2='')
	{
		if(empty($range1)){
		   throw new Exception( "Range 1 is invalid" );
		}
		if(empty($range2)){
		   throw new Exception( "Range 2 is invalid" );
		}
		
		$date = array();
		$_range1 = date_create($range1);
		$_range2 = date_create($range2);
		$interval = date_diff($_range1, $_range2);
		$day_diff = $interval->format("%a");			
		for ($x = 0; $x <= $day_diff; $x++) {
			$date[] = date('M d', strtotime($range1 . " +$x day"));
		}
		return $date;
	}
	
	public  function randomColors($index=0)
	{
		 return sprintf("#%06x",rand(0,16777215));		
	}
	
	public  function chartType($type=1)
	{
		switch ($type) {
			case 2:
				return array(
				  'line'=>"Line",
				  'column'=>"Bar",
				  'pie'=>"Pie",
				);
				break;
		
			default:
				return array(
				  'area'=>"Area",
				  'line'=>"Line",
				  'column'=>"Bar",
				);
				break;
		}		
	}
	
	public  function getDefaultStatus($merchant_id='')
	{
		//$status = getOption($merchant_id,'inventory_reports_default_status');
		$status = $this->functions->getOptionAdmin('inventory_reports_default_status');
		if(!empty($status)){
			$status = json_decode($status,true);
		}
		return (array) $status;
	}
	
	public function deleteLowStockLogs($ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion.");
    }

    // Convert the array of IDs into a comma-separated string
    $ids_placeholder = implode(',', array_fill(0, count($ids), '?'));

    // Prepare the SQL query
    $stmt = $this->db->prepare("DELETE FROM mt_inventory_lowstock_notification WHERE id IN ($ids_placeholder)");

    // Execute the query with the IDs as the parameters
    $resp = $stmt->execute($ids);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed to delete records.");
    }
}

	
	public function totalFixedReport($merchant_id = '')
{
    $and = '';
    if ($merchant_id > 0) {
        $and .= " AND b.merchant_id = :merchant_id ";
    }

    $stmt = "
    SELECT count(*) as total,
    a.id, a.order_id, a.item_id, a.item_name,
    b.order_id as orderid, b.json_details
    FROM mt_order_details a
    LEFT JOIN mt_order b
    ON a.order_id = b.order_id
    WHERE a.cat_id = '0'
    AND b.order_id <> 0
    $and
    ";

    $query = $this->db->prepare($stmt);

    // Bind the merchant_id if it's provided
    if ($merchant_id > 0) {
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    }

    $query->execute();
    
    $res = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($res) {
        return $res['total'];
    }

    return 0;
}


public  function format($cols=array(), $data=array())
	{
		
		$resp = array();
		$resp['where']='';
		$resp['order']='';
		$resp['limit']='';
		
		$order=''; $where =''; $limit='';
		
		if(is_array($data) && count($data)>=1){
			
			if(isset($data['order'])){
				if(is_array($data['order']) && count($data['order'])>=1){
					foreach ($data['order'] as $val) {						
						if(array_key_exists($val['column'], (array) $cols)){
							$order = "ORDER BY ". addslashes($cols[ $val['column'] ]) ." ".addslashes($val["dir"]); 
						}
					}
				}
				if(!empty($order)){
					$resp['order']=$order;
				}
			}			
			
			if(isset($data['start']) && isset($data['length'])){
				$limit= "LIMIT ". addslashes($data['start']).",". addslashes($data['length']);
				$resp['limit']=$limit;
			} else $resp['limit']="LIMIT 0,10";
			
						
			$resp['where']='';
					
		}
				
		return $resp;
	}



	
}/* end class*/