<?php
class FoodItemWrapper
{

  public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->MerchantWrapper = new MerchantWrapper();
        
        $this->last_inserted_id=0;
    }

    public  function isMultiLanguage()
    {
      
      return false;
    }


    public  function okToDecode()
  {
    $version=phpversion();    
    if ( $version>5.3){
      return true;
    }
    return false;
  }

  public function getLastInsertedId() {
    return $this->last_inserted_id;
}



    
  public function getMaxSequence($table = '', $merchant_id = '', $field = 'sequence')
{
    $where = '';
    if ($merchant_id > 0) {
        $where = " WHERE merchant_id = :merchant_id";
    }

    $stmt = "SELECT max($field) as max FROM $table $where";

    $cmd = $this->db->prepare($stmt);

    if ($merchant_id > 0) {
        $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    }

    $cmd->execute();

    if ($resp = $cmd->fetch(PDO::FETCH_ASSOC)) {
        return $resp['max'] > 0 ? $resp['max'] + 1 : 1;
    } else {
        return 1;
    }
}


public function getAllCuisine($start = 0, $total_rows = 10)
{
    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.cuisine_id, a.cuisine_name, a.cuisine_name_trans
    FROM mt_cuisine a
    WHERE status IN ('publish', 'published')
    ORDER BY cuisine_name ASC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);
    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

public function getAllCategory($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND category_name LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.cat_id, a.category_name, a.category_description,
    a.category_name_trans, a.category_description_trans, a.photo,
    a.status, a.status as status_raw, a.date_created
    FROM mt_category a    
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY cat_id DESC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public function getAllAddon($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.subcategory_name LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.subcat_id, a.merchant_id, a.subcategory_name, a.subcategory_description,
    a.subcategory_name_trans, a.subcategory_description_trans,
    a.status, a.status as status_raw, a.date_created
    FROM mt_subcategory a   
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY a.subcat_id DESC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

public function getListCategory($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.subcategory_name LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.cat_id, a.category_name, a.category_description,
    a.category_name_trans, a.category_description_trans
    FROM mt_category a    
    WHERE a.merchant_id = :merchant_id
    AND status IN ('publish')
    $and
    ORDER BY a.category_name ASC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public function getAllAddonItem($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.sub_item_name LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.sub_item_id, a.merchant_id, a.sub_item_name, a.item_description,
    a.sub_item_name_trans, a.item_description_trans, a.photo, a.price
    FROM mt_subcategory_item a    
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY a.sub_item_id DESC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

public function getAllingredients($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '', 
$field_sort = 'a.ingredients_id', $sort = 'DESC', $all = true)
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.ingredients_name LIKE :search_string ";
    }

    if (!$all) {
        $and .= " AND a.status IN ('publish')";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.ingredients_id, a.merchant_id, a.ingredients_name, a.ingredients_name_trans,
    a.status, a.date_created
    FROM mt_ingredients a   
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY $field_sort $sort
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public  function getImage($filename='',$default_image='no-food.png')
    {       
        $image_url =Config::$baseUrl."/assets_merchantapp/images/$default_image";  
        

        $upload_path=Config::$baseUrl."/upload/"; 


        if(!empty($filename)){
           
                $image_url = $upload_path."$filename";              
            
        }
        return $image_url;
    }



public function getAllitem($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.item_name LIKE :search_string ";
    }

    $inventory_qry = '';
    if ($this->MerchantWrapper->inventoryEnabled($merchant_id)) {
        $inventory_qry = "
        , (
        SELECT 
        COUNT(*) 
        FROM mt_view_item_stocks_status
        WHERE stock_status = 'Out of stocks'
        AND item_id = a.item_id
        AND track_stock = '1'
        ) AS count_out_of_stock
        ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.item_id, a.item_name, a.item_description, a.status, a.category, a.price,
    a.item_name_trans, a.item_description_trans, a.photo,
    a.status, a.date_created, a.not_available 
    $inventory_qry
    FROM mt_item a    
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY a.item_id DESC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

  
  public function getAllCooking($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '', 
   $field_sort = 'a.cook_id', $sort = 'DESC', $all = true)
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.cooking_name LIKE :search_string ";
    }

    if (!$all) {
        $and .= " AND a.status IN ('publish') ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.cook_id, a.cooking_name, a.cooking_name_trans,
    a.status, a.date_created
    FROM mt_cooking_ref a       
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY $field_sort $sort
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

public function getAllSize($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.size_name LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.size_id, a.merchant_id, a.size_name, a.size_name_trans,
    a.status, a.date_created
    FROM mt_size a        
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY a.size_id DESC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

  
  public function getAllShipping($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.distance_price LIKE :search_string ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
    a.id, a.distance_from, a.distance_to, a.shipping_units, a.distance_price   
    FROM mt_shipping_rate a       
    WHERE a.merchant_id = :merchant_id
    $and
    ORDER BY a.distance_from ASC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $cmd->bindParam(':start', $start, PDO::PARAM_INT);
    $cmd->bindParam(':total_rows', $total_rows, PDO::PARAM_INT);

    if (!empty($search_string)) {
        $search = "%$search_string%";
        $cmd->bindParam(':search_string', $search, PDO::PARAM_STR);
    }

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public function getDish()
{
    $stmt = "SELECT * FROM mt_dishes";

    $cmd = $this->db->prepare($stmt);
    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}

  
  public function getAllDish($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.dish_name LIKE :search_string";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
        a.dish_id, a.dish_name, a.photo, a.status, a.date_created
    FROM
        mt_dishes a
    WHERE
        status IN ('publish')
        $and
    ORDER BY a.dish_name ASC
    LIMIT :start, :total_rows
    ";

    $cmd = $this->db->prepare($stmt);
    
    // Bind parameters
    if (!empty($search_string)) {
        $cmd->bindValue(':search_string', "%$search_string%", PDO::PARAM_STR);
    }
    $cmd->bindValue(':start', (int)$start, PDO::PARAM_INT);
    $cmd->bindValue(':total_rows', (int)$total_rows, PDO::PARAM_INT);

    $cmd->execute();

    if ($resp = $cmd->fetchAll(PDO::FETCH_ASSOC)) {
        return $resp;
    }
    return false;
}


public function getItem($merchant_id = '', $id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_item WHERE merchant_id = :merchant_id AND item_id = :item_id LIMIT 1");
    $stmt->bindParam(':merchant_id', $merchant_id);
    $stmt->bindParam(':item_id', $id);
    $stmt->execute();
    
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        return $resp;
    }
    return false;
}

public function getDishByID($id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_dishes WHERE id = :id LIMIT 1");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        return $resp;
    }
    return false;
}
  
    
    public function insertCategory($merchant_id = '', $params = array(), $cat_id = '')
{
    try {
        if ($cat_id > 0) {
            // Check if category name already exists for another category
            $stmt = $this->db->prepare("
                SELECT category_name 
                FROM mt_category 
                WHERE merchant_id = :merchant_id 
                AND category_name = :category_name 
                AND cat_id <> :cat_id 
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id);
            $stmt->bindParam(':category_name', $params['category_name']);
            $stmt->bindParam(':cat_id', $cat_id);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Update record if category does not exist
                $up = $this->functions->updateData("mt_category", $params, 'cat_id', $cat_id);
                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed cannot update records");
                }
            } else {
                throw new Exception("Category name already exist");
            }
        } else {
            // Check if category name already exists for the merchant
            $stmt = $this->db->prepare("
                SELECT category_name 
                FROM mt_category 
                WHERE merchant_id = :merchant_id 
                AND category_name = :category_name 
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id);
            $stmt->bindParam(':category_name', $params['category_name']);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Insert record if category does not exist
                $last_insert_id = $this->functions->insertData('mt_category', $params);
                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    return true;
                } else {
                    throw new Exception("Failed cannot insert records");
                }
            } else {
                throw new Exception("Category name already exist");
            }
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function deleteCategory($merchant_id = '', $cat_id = array())
{
    try {
        // Check if category has references in another table
        $stmt = $this->db->prepare("
            SELECT id 
            FROM mt_item_relationship_category 
            WHERE cat_id IN (" . implode(",", array_map('intval', (array)$cat_id)) . ")
        ");
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($res) {
            throw new Exception("Cannot delete records, it has reference in another table");
        }

        // Delete from mt_category with conditions
        $placeholders = implode(',', array_fill(0, count($cat_id), '?'));
        $stmt = $this->db->prepare("
            DELETE FROM mt_category 
            WHERE merchant_id = ? 
            AND cat_id IN ($placeholders)
        ");
        
        $params = array_merge([$merchant_id], array_values($cat_id));
        $resp = $stmt->execute($params);

        if ($resp) {
            return true;
        } else {
            throw new Exception("Failed cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}

            
   public function getData($table = '', $where = '', $where_val = array(), $strip = true)
{
    try {
        $table = "mt_" . $table;

        // Prepare the query
        $stmt = $this->db->prepare("
            SELECT * 
            FROM $table 
            WHERE $where 
            LIMIT 1
        ");
        
        // Execute with parameters
        $stmt->execute($where_val);
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            if ($strip) {
                // Add your stripSlashes logic here if needed
                return $resp;
            }
            return $resp;
        } else {
            throw new Exception("Record not found");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function insertAddonCategory($merchant_id = '', $params = array(), $id = '')
{
    try {
        if ($id > 0) {
            // Check if subcategory name already exists (excluding current subcat_id)
            $stmt = $this->db->prepare("
                SELECT subcategory_name 
                FROM mt_subcategory 
                WHERE merchant_id = :merchant_id 
                AND subcategory_name = :subcategory_name 
                AND subcat_id <> :subcat_id 
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':subcategory_name' => $params['subcategory_name'],
                ':subcat_id' => $id
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Update record using existing updateData function
                $up = $this->functions->updateData("mt_subcategory", $params, 'subcat_id', $id);

                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed cannot update records");
                }
            } else {
                throw new Exception("Category name already exist");
            }
        } else {
            // Check if subcategory name already exists
            $stmt = $this->db->prepare("
                SELECT subcategory_name 
                FROM mt_subcategory 
                WHERE merchant_id = :merchant_id 
                AND subcategory_name = :subcategory_name 
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':subcategory_name' => $params['subcategory_name']
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Insert record using existing insertData function
                $last_insert_id = $this->functions->insertData('mt_subcategory', $params);

                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    return true;
                } else {
                    throw new Exception("Failed cannot insert records");
                }
            } else {
                throw new Exception("Category name already exist");
            }
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}

public function deleteAddonCategory($merchant_id = '', $ids = array())
{
    try {
        if (empty($ids)) {
            throw new Exception("No category IDs provided for deletion");
        }

        // Check if subcategory has references in subcategory_item_relationships
        $stmt = $this->db->prepare("
            SELECT id FROM subcategory_item_relationships 
            WHERE subcat_id IN (" . implode(",", array_map('intval', (array)$ids)) . ")
            LIMIT 1
        ");
        $stmt->execute();
        if ($stmt->fetch(PDO::FETCH_ASSOC)) {
            throw new Exception("Cannot delete records it has reference in another table");
        }

        // Check if subcategory has references in order_details_addon
        $stmt = $this->db->prepare("
            SELECT id FROM order_details_addon 
            WHERE subcat_id IN (" . implode(",", array_map('intval', (array)$ids)) . ")
            LIMIT 1
        ");
        $stmt->execute();
        if ($stmt->fetch(PDO::FETCH_ASSOC)) {
            throw new Exception("Cannot delete records it has reference in another table");
        }

        // Delete subcategories
        $stmt = $this->db->prepare("
            DELETE FROM mt_subcategory 
            WHERE merchant_id = :merchant_id 
            AND subcat_id IN (" . implode(",", array_map('intval', (array)$ids)) . ")
        ");
        $stmt->execute([':merchant_id' => $merchant_id]);

        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            throw new Exception("Failed cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


   public function getAddonCategory($merchant_id = '', $status = 'publish')
{
    try {
        $stmt = $this->db->prepare("
            SELECT subcat_id, subcategory_name, subcategory_name_trans, status 
            FROM mt_subcategory 
            WHERE merchant_id = :merchant_id 
            AND status = :status 
            ORDER BY sequence ASC
        ");

        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':status' => $status
        ]);

        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($resp) {
            return $resp;
        }
        return false;
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function deleteSize($merchant_id = '', $ids = array())
{
    try {
        if (empty($ids)) {
            throw new Exception("No size IDs provided for deletion");
        }

        // Check if size has references in item_relationship_size
        $stmt = $this->db->prepare("
            SELECT item_size_id FROM mt_item_relationship_size 
            WHERE size_id IN (" . implode(",", array_map('intval', (array)$ids)) . ")
            LIMIT 1
        ");
        $stmt->execute();
        if ($stmt->fetch(PDO::FETCH_ASSOC)) {
            throw new Exception("Cannot delete records it has reference in another table");
        }

        // Delete sizes
        $stmt = $this->db->prepare("
            DELETE FROM mt_size 
            WHERE merchant_id = :merchant_id 
            AND size_id IN (" . implode(",", array_map('intval', (array)$ids)) . ")
        ");
        $stmt->execute([':merchant_id' => $merchant_id]);

        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            throw new Exception("Failed cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}



public function insertSize($merchant_id = '', $params = array(), $id = '')
{
    try {
        // Check if the size already exists
        if ($id > 0) {
            $stmt = $this->db->prepare("
                SELECT size_name FROM mt_size
                WHERE merchant_id = :merchant_id
                AND size_name = :size_name
                AND size_id <> :size_id
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':size_name' => $params['size_name'],
                ':size_id' => $id
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$resp) {
                // Update the size
                $up = $this->functions->updateData("mt_size", $params, 'size_id', $id);
                
                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed cannot update records");
                }
            } else {
                throw new Exception("Size name already exists");
            }
        } else {
            // Check if the size already exists
            $stmt = $this->db->prepare("
                SELECT size_name FROM mt_size
                WHERE merchant_id = :merchant_id
                AND size_name = :size_name
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':size_name' => $params['size_name']
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$resp) {
                // Insert new size
                $last_insert_id = $this->functions->insertData('mt_size', $params);
                
                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    return true;
                } else {
                    throw new Exception("Failed cannot insert records");
                }
            } else {
                throw new Exception("Size name already exists");
            }
        }
        
        throw new Exception("An error has occurred");
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}
   
    
   public function insertIngredients($merchant_id = '', $params = array(), $id = '')
{
    try {
        if ($id > 0) {
            // Check if the ingredients name already exists (excluding current record)
            $stmt = $this->db->prepare("
                SELECT ingredients_name
                FROM mt_ingredients
                WHERE merchant_id = :merchant_id
                AND ingredients_name = :ingredients_name
                AND ingredients_id <> :ingredients_id
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':ingredients_name' => $params['ingredients_name'],
                ':ingredients_id' => $id
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Update the ingredients record
                $up = $this->functions->updateData("mt_ingredients", $params, 'ingredients_id', $id);
                
                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed cannot update records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        } else {
            // Check if the ingredients name already exists for new record
            $stmt = $this->db->prepare("
                SELECT ingredients_name
                FROM mt_ingredients
                WHERE merchant_id = :merchant_id
                AND ingredients_name = :ingredients_name
                LIMIT 1
            ");
            $stmt->execute([
                ':merchant_id' => $merchant_id,
                ':ingredients_name' => $params['ingredients_name']
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Insert new ingredients record
                $last_insert_id = $this->functions->insertData('mt_ingredients', $params);
                
                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    return true;
                } else {
                    throw new Exception("Failed cannot insert records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        }

        throw new Exception("An error has occurred");
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function deleteIngredients($merchant_id = '', $ids = array())
{
    try {
        // Prepare and execute the delete query using PDO
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $stmt = $this->db->prepare("
            DELETE FROM mt_ingredients
            WHERE merchant_id = :merchant_id
            AND ingredients_id IN ($placeholders)
        ");
        
        // Bind parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        
        // Bind the ingredient IDs
        foreach ($ids as $index => $id) {
            $stmt->bindValue($index + 1, $id, PDO::PARAM_INT);
        }

        // Execute the statement
        $stmt->execute();
        
        // Check if rows were affected
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            throw new Exception("Failed: Cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}



public function insertCookingRef($merchant_id = '', $params = array(), $id = '')
{
    try {
        if ($id > 0) {
            // Check if the cooking name already exists for the given merchant and ID
            $stmt = $this->db->prepare("
                SELECT cooking_name 
                FROM mt_cooking_ref 
                WHERE merchant_id = :merchant_id 
                AND cooking_name = :cooking_name 
                AND cook_id <> :cook_id
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':cooking_name', $params['cooking_name'], PDO::PARAM_STR);
            $stmt->bindParam(':cook_id', $id, PDO::PARAM_INT);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Update the existing cooking reference
                $up = $this->functions->updateData("mt_cooking_ref", $params, 'cook_id', $id);

                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed: Cannot update records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        } else {
            // Check if the cooking name already exists for the given merchant
            $stmt = $this->db->prepare("
                SELECT cooking_name 
                FROM mt_cooking_ref 
                WHERE merchant_id = :merchant_id 
                AND cooking_name = :cooking_name
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':cooking_name', $params['cooking_name'], PDO::PARAM_STR);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Insert the new cooking reference
                $last_insert_id = $this->functions->insertData('mt_cooking_ref', $params);
                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    return true;
                } else {
                    throw new Exception("Failed: Cannot insert records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function deleteCookingRef($merchant_id = '', $ids = array())
{
    try {
        // Build the SQL query for deletion
        $placeholders = rtrim(str_repeat('?,', count($ids)), ',');
        $stmt = $this->db->prepare("
            DELETE FROM mt_cooking_ref
            WHERE merchant_id = :merchant_id
            AND cook_id IN ($placeholders)
        ");
        
        // Bind the merchant_id and the IDs
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        foreach ($ids as $index => $id) {
            $stmt->bindValue($index + 1, $id, PDO::PARAM_INT);
        }
        
        // Execute the query
        $resp = $stmt->execute();
        
        if ($resp) {
            return true;
        } else {
            throw new Exception("Failed: Cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}

    
    public function getCookingRef($merchant_id = '', $status = 'publish')
{
    try {
        // Prepare and execute the SQL query
        $stmt = $this->db->prepare("
            SELECT cook_id, cooking_name, cooking_name_trans, status
            FROM mt_cooking_ref
            WHERE merchant_id = :merchant_id AND status = :status
            ORDER BY sequence ASC
        ");
        
        // Bind the parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':status', $status, PDO::PARAM_STR);
        
        // Execute the query
        $stmt->execute();
        
        // Fetch all results
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if ($resp) {
            return $resp;
        } else {
            return false;
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function insertAddonItem($merchant_id = '', $params = array(), $categories = array(), $id = '')
{
    try {
        if ($id > 0) {
            // Check if the sub_item_name already exists (excluding the current item)
            $stmt = $this->db->prepare("
                SELECT sub_item_name
                FROM mt_subcategory_item
                WHERE merchant_id = :merchant_id AND sub_item_name = :sub_item_name AND sub_item_id <> :sub_item_id
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':sub_item_name', $params['sub_item_name'], PDO::PARAM_STR);
            $stmt->bindParam(':sub_item_id', $id, PDO::PARAM_INT);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // If no duplicate, update the item
                $up = $this->functions->updateData("mt_subcategory_item", $params, 'sub_item_id', $id);
                if ($up) {
                    $this->subitemRelationship($id, $categories);
                    return true;
                } else {
                    throw new Exception("Failed: Cannot update records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        } else {
            // Check if the sub_item_name already exists
            $stmt = $this->db->prepare("
                SELECT sub_item_name
                FROM mt_subcategory_item
                WHERE merchant_id = :merchant_id AND sub_item_name = :sub_item_name
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':sub_item_name', $params['sub_item_name'], PDO::PARAM_STR);
            $stmt->execute();
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // If no duplicate, insert the new item
                $last_insert_id = $this->functions->insertData('mt_subcategory_item', $params);
                if ($last_insert_id !== false) {
                    $this->last_inserted_id = $last_insert_id;
                    $this->subitemRelationship($last_insert_id, $categories);
                    return true;
                } else {
                    throw new Exception("Failed: Cannot insert records");
                }
            } else {
                throw new Exception("Name already exists");
            }
        }
    } catch (Exception $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function subitemRelationship($sub_item_id = '', $categories = '')
{
    try {
        // Check if categories is an array and has at least one element
        if (is_array($categories) && count($categories) >= 1) {
            // Delete existing relationships for the given sub_item_id
            $stmt = $this->db->prepare("DELETE FROM mt_subcategory_item_relationships WHERE sub_item_id = :sub_item_id");
            $stmt->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);
            $stmt->execute();
            
            // Prepare the values for the INSERT statement
            $values = '';
            foreach ($categories as $id) {
                $values .= "($sub_item_id, $id),\n";
            }
            $values = rtrim($values, ",\n"); // Remove trailing comma
            
            // Insert new relationships
            $stmt = $this->db->prepare("
                INSERT INTO mt_subcategory_item_relationships (sub_item_id, subcat_id)
                VALUES $values
            ");
            $stmt->execute();
        }
    } catch (Exception $e) {
        throw new Exception("An error occurred while managing subitem relationships: " . $e->getMessage());
    }
}

public function deleteSubItem($merchant_id = '', $ids = array())
{
    try {
        // Prepare and execute the SELECT statement to check for references in another table
        $stmt = $this->db->prepare("SELECT id FROM mt_order_details_addon WHERE sub_item_id IN (" . implode(",", array_map('intval', $ids)) . ")");
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // If there's a reference, throw an exception
        if ($res) {
            throw new Exception("Cannot delete records, it has reference in another table");
        }

        // Prepare and execute the DELETE from mt_subcategory_item
        $stmt = $this->db->prepare("DELETE FROM mt_subcategory_item WHERE merchant_id = :merchant_id AND sub_item_id IN (" . implode(",", array_map('intval', $ids)) . ")");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        // If delete was successful, proceed to delete relationships
        if ($stmt->rowCount() > 0) {
            // Delete from mt_subcategory_item_relationships
            $stmt = $this->db->prepare("DELETE FROM mt_subcategory_item_relationships WHERE sub_item_id IN (" . implode(",", array_map('intval', $ids)) . ")");
            $stmt->execute();

            return true;
        } else {
            throw new Exception("Failed, cannot delete records");
        }
    } catch (Exception $e) {
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}


public function getAddonCategoryWithItem($merchant_id = '', $subcat_id = '')
{
    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT 
                a.subcat_id, a.sub_item_id,
                b.sub_item_name, b.item_description, b.price, b.photo, b.sequence, b.sub_item_name_trans, b.item_description_trans,
                (
                    SELECT subcategory_name 
                    FROM mt_subcategory 
                    WHERE subcat_id = a.subcat_id
                    LIMIT 1
                ) AS subcategory_name
            FROM mt_subcategory_item_relationships a
            LEFT JOIN mt_subcategory_item b ON a.sub_item_id = b.sub_item_id
            WHERE a.subcat_id = :subcat_id
            AND b.merchant_id = :merchant_id
            ORDER BY b.sequence ASC
            LIMIT 500
        ");

        // Bind parameters to the SQL query
        $stmt->bindParam(':subcat_id', $subcat_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return results if found, else false
        if ($resp) {
            return $resp;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any PDO exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}


public function getCategory($merchant_id = '', $status = 'publish')
{
    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT cat_id, category_name, category_description, status
            FROM mt_category
            WHERE merchant_id = :merchant_id AND status = :status
            ORDER BY sequence ASC
        ");

        // Bind parameters to the SQL query
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':status', $status, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return results if found, else false
        if ($resp) {
            return $resp;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any PDO exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}

    
    public function getIngredients($merchant_id = '', $status = 'publish')
{
    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT ingredients_id, ingredients_name, ingredients_name_trans, status
            FROM mt_ingredients
            WHERE merchant_id = :merchant_id AND status = :status
            ORDER BY sequence ASC
        ");

        // Bind parameters to the SQL query
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':status', $status, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return results if found, else false
        if ($resp) {
            return $resp;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any PDO exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}


public function getSizes($merchant_id = '', $status = 'publish')
{
    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT size_id, size_name, size_name_trans, status
            FROM mt_size
            WHERE merchant_id = :merchant_id AND status = :status
            ORDER BY sequence ASC
        ");

        // Bind parameters to the SQL query
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':status', $status, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return results if found, else false
        if ($resp) {
            return $resp;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any PDO exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}
  
    
    public  function dropdownFormat($data=array(),$value='', $label='',$with_select=false)
    {
        $list = array();
        if($with_select){           
            $list[0]="Please select";
        } else $list['']='';        
        if(is_array($data) && count($data)>=1){
            foreach ($data as $val) {
                if(isset($val[$value]) && isset($val[$label])){
                   $list[ $val[$value] ] = $val[$label];
                }
            }
        }       
        return $list;
    }
    
    public  function twoFlavorSelection()
    {
        return array(
             ''=>"Select options",
             'left'=>"left",
             'right'=>"Right"
           );
    }


   public function generateFoodToken()
{
    try {
        // Generate token
        $token = $this->functions->generateCode(20);

        // Prepare SQL query to check if token already exists
        $stmt = $this->db->prepare("
            SELECT item_token
            FROM mt_item
            WHERE item_token = :item_token
            LIMIT 1
        ");

        // Bind token parameter
        $stmt->bindParam(':item_token', $token, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Check if the token already exists
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        // If token exists, recursively generate a new one
        if ($resp) {
            return $this->generateFoodToken();
        }

        return $token;

    } catch (PDOException $e) {
        // Handle exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}

    
   public function generateFoodSizeToken()
{
    try {
        // Generate token
        $token = $this->functions->generateCode(20);

        // Prepare SQL query to check if token already exists
        $stmt = $this->db->prepare("
            SELECT item_token
            FROM mt_item_relationship_size
            WHERE item_token = :item_token
            LIMIT 1
        ");

        // Bind token parameter
        $stmt->bindParam(':item_token', $token, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Check if the token already exists
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        // If token exists, recursively generate a new one
        if ($resp) {
            return $this->generateFoodSizeToken();
        }

        return $token;

    } catch (PDOException $e) {
        // Handle exceptions
        throw new Exception("An error occurred: " . $e->getMessage());
    }
}



public function insertFood($merchant_id = '', $params = array(), $item_id = '', $raw_data = array())
{
    try {
        // Check if updating an existing item
        if ($item_id > 0) {
            // Prepare the query to check if the item already exists with the same name
            $stmt = $this->db->prepare("
                SELECT item_name
                FROM mt_item
                WHERE merchant_id = :merchant_id
                AND item_name = :item_name
                AND item_id <> :item_id
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':item_name', $params['item_name'], PDO::PARAM_STR);
            $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $stmt->execute();

            // Fetch result
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Check SKU existence if no existing item
                $this->prepareCheckSKUexist(
                    isset($raw_data['sku']) ? $raw_data['sku'] : '',
                    $item_id,
                    isset($raw_data['size']) ? $raw_data['size'] : ''
                );

                // Update the existing item
                $up = $this->functions->updateData("mt_item", $params, 'item_id', $item_id);

                if ($up) {
                    // Insert/update associated data
                    $this->InsertItemSize($merchant_id, $item_id, $raw_data);
                    $this->InsertItemCategoryRelationship($merchant_id, $item_id, $raw_data);
                    $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                    return true;
                } else {
                    throw new Exception("Failed, cannot update records");
                }
            } else {
                throw new Exception("Food name already exists");
            }
        } else {
            // Prepare the query to check if the item already exists for a new item
            $stmt = $this->db->prepare("
                SELECT item_name
                FROM mt_item
                WHERE merchant_id = :merchant_id
                AND item_name = :item_name
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':item_name', $params['item_name'], PDO::PARAM_STR);
            $stmt->execute();

            // Fetch result
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$resp) {
                // Check SKU existence for new item
                $this->prepareCheckSKUexist(
                    isset($raw_data['sku']) ? $raw_data['sku'] : ''
                );

                // Insert the new item into the database
                $last_insert_id = $this->functions->insertData('mt_item', $params);
                if ($last_insert_id !== false) {
                    $last_id = $last_insert_id;

                    // Insert associated data
                    $this->InsertItemSize($merchant_id, $last_id, $raw_data, true);
                    $this->InsertItemCategoryRelationship($merchant_id, $last_id, $raw_data);
                    $this->InsertItemRelationshipSubcategory($merchant_id, 1, $raw_data);

                    return true;
                } else {
                    throw new Exception("Failed, cannot insert records");
                }
            } else {
                throw new Exception("Food name already exists");
            }
        }
    } catch (PDOException $e) {
        // Handle PDO exceptions
        throw new Exception("An error has occurred: " . $e->getMessage());
    } catch (Exception $e) {
        // Handle general exceptions
        throw new Exception($e->getMessage());
    }
}



public function insertItem($merchant_id = '', $params = array(), $item_id = 0)
{
    try {
        if ($item_id > 0) {
            // Prepare the query to check if the item exists
            $stmt = $this->db->prepare("
                SELECT item_name
                FROM mt_item
                WHERE merchant_id = :merchant_id
                AND item_id = :item_id
                LIMIT 1
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $stmt->execute();

            // Fetch result
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($resp) {
                // Call updateData function if the record exists
                $up = $this->functions->updateData("mt_item", $params, 'item_id', $item_id);
                if ($up) {
                    return true;
                } else {
                    throw new Exception("Failed, cannot update records");
                }
            } else {
                throw new Exception("Record not found");
            }
        } else {
            // Call insertData function to insert new record
            $last_insert_id = $this->functions->insertData('mt_item', $params);
            if ($last_insert_id !== false) {
                $last_id = $last_insert_id;
                $this->last_inserted_id = $last_id;
                return $last_id;
            } else {
                throw new Exception("Failed, cannot insert records");
            }
        }
    } catch (PDOException $e) {
        // Handle PDO exceptions
        throw new Exception("An error has occurred: " . $e->getMessage());
    } catch (Exception $e) {
        // Handle general exceptions
        throw new Exception($e->getMessage());
    }
}



public function prepareCheckSKUexist($data = '', $item_id = '', $size = '')
{
    if (is_array($data) && count($data) >= 1) {
        foreach ($data as $key => $sku) {
            if ($this->checkSKUexist($sku, $item_id, isset($size[$key]) ? $size[$key] : '')) {
                throw new Exception("Item with SKU: already exists " . $sku);
            }
        }
    } else {
        if ($this->checkSKUexist($data, $item_id)) {
            throw new Exception("Item with SKU:  already exists " . $data);
        }
    }
}

    
   public function checkSKUexist($sku = '', $item_id = '', $size_id = 0)
{
    $resp = '';

    if ($item_id > 0) {
        // Check if item_size_id exists for the given item_id and size_id
        $stmt = $this->db->prepare("
            SELECT item_size_id 
            FROM mt_item_relationship_size 
            WHERE item_id = :item_id AND size_id = :size_id 
            LIMIT 1
        ");
        $stmt->execute([
            ':item_id' => $item_id,
            ':size_id' => $size_id,
        ]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            // Check if SKU exists and is not associated with the current item_size_id
            $stmt = $this->db->prepare("
                SELECT sku 
                FROM mt_item_relationship_size 
                WHERE sku = :sku AND item_size_id <> :item_size_id 
                LIMIT 1
            ");
            $stmt->execute([
                ':sku'          => $sku,
                ':item_size_id' => $res['item_size_id'],
            ]);
            $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        }
    } else {
        // Check if SKU exists globally
        $stmt = $this->db->prepare("
            SELECT sku 
            FROM mt_item_relationship_size 
            WHERE sku = :sku 
            LIMIT 1
        ");
        $stmt->execute([
            ':sku' => $sku,
        ]);
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    }

    return $resp ? true : false;
}



public function deleteItem($merchant_id = '', $item_ids = array())
{
    try {
        // Check if the item is referenced in the order_details table
        $stmt = $this->db->prepare("
            SELECT id 
            FROM mt_order_details 
            WHERE item_id IN (" . implode(",", array_map('intval', (array) $item_ids)) . ")
        ");
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            throw new Exception("Cannot delete records, it has reference in another table");
        }

        // Prepare delete query for mt_item table
        $placeholders = rtrim(str_repeat('?,', count($item_ids)), ',');
        $stmt = $this->db->prepare("
            DELETE FROM mt_item
            WHERE merchant_id = :merchant_id
            AND item_id IN ($placeholders)
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        foreach ($item_ids as $key => $item_id) {
            $stmt->bindValue($key + 1, $item_id, PDO::PARAM_INT);
        }
        $stmt->execute();

        // If deletion is successful, proceed with further actions
        if ($stmt->rowCount() > 0) {
            $this->removeItemPictureFromDisk($merchant_id, $item_ids);
            $this->deleteInventoryStocks($merchant_id, $item_ids);

            if (is_array($item_ids) && count($item_ids) >= 1) {
                foreach ($item_ids as $item_id) {
                    $this->deleteItemSize($merchant_id, $item_id);
                    $this->deleteCategoryRelationship($merchant_id, $item_id);
                    $this->deleteItemRelationshipSubcategory($merchant_id, $item_id);
                }
            }

            return true;
        } else {
            throw new Exception("Failed, cannot delete records");
        }
    } catch (PDOException $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    } catch (Exception $e) {
        throw new Exception($e->getMessage());
    }
}


public function deleteInventoryStocks($merchant_id = '', $item_ids = array())
{
    try {
        // Prepare the query to get SKUs from mt_item_relationship_size table
        $placeholders = rtrim(str_repeat('?,', count($item_ids)), ',');
        $stmt = $this->db->prepare("
            SELECT sku 
            FROM mt_item_relationship_size 
            WHERE item_id IN ($placeholders) 
            AND merchant_id = :merchant_id
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        foreach ($item_ids as $key => $item_id) {
            $stmt->bindValue($key + 1, $item_id, PDO::PARAM_INT);
        }
        $stmt->execute();

        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($resp) {
            $in = '';
            foreach ($resp as $val) {
                $in .= ($val['sku']) . ",";
            }
            $in = rtrim($in, ',');

            // Prepare the delete query for mt_inventory_stocks
            $stmt = $this->db->prepare("
                DELETE FROM mt_inventory_stocks 
                WHERE merchant_id = :merchant_id 
                AND sku IN ($in)
            ");
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $stmt->execute();
        }

        return true;
    } catch (PDOException $e) {
        throw new Exception("An error has occurred: " . $e->getMessage());
    }
}


public function removeItemPictureFromDisk($merchant_id = '', $item_ids = array())
{
    // Prepare the SQL statement
    $stmt = "SELECT photo FROM mt_item WHERE item_id IN (" . implode(",", array_map('intval', $item_ids)) . ") AND merchant_id = :merchant_id";
    
    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();
    
    // Fetch results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        // Loop through the results and delete the images
        foreach ($resp as $photo) {
            $file_path = $this->functions->uploadPath() . "/" . $photo['photo'];
            if (file_exists($file_path)) {
                @unlink($file_path);
            }
        }
    }
    return false;
}


public function deleteItemSize($merchant_id = '', $item_id = '')
{
    // Prepare SQL statement
    $stmt = "DELETE FROM mt_item_relationship_size WHERE merchant_id = :merchant_id AND item_id = :item_id";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
}

public  function deleteItemSizeByToken($merchant_id = '', $item_token = '')
{
    // Prepare SQL statement
    $stmt = "DELETE FROM mt_item_relationship_size WHERE merchant_id = :merchant_id AND item_token = :item_token";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_token', $item_token, PDO::PARAM_STR);
    $query->execute();

    // Check if the query was successful
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}

public  function deleteItemSizeBySku($merchant_id = '', $sku = '')
{
    // Prepare SQL statement
    $stmt = "DELETE FROM mt_item_relationship_size WHERE merchant_id = :merchant_id AND sku = :sku";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':sku', $sku, PDO::PARAM_STR);
    $query->execute();

    // Check if the query was successful
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}


public  function InsertItemCategoryRelationship($merchant_id='', $item_id='', $data=array())
    {
        $this->deleteCategoryRelationship($merchant_id,$item_id);
        if(isset($data['category'])){
            if(is_array($data['category']) && count($data['category'])>=1){
                foreach ($data['category'] as $cat_id) {
                    $params = array(
                      'merchant_id'=>$merchant_id,
                      'item_id'=>$item_id,
                      'cat_id'=>$cat_id,
                    );
                    $i = $this->functions->insertData('mt_item_relationship_category', $params);

                }
            }
        }
    }
    
   public function deleteCategoryRelationship($merchant_id = '', $item_id = '')
{
    // Prepare SQL statement
    $stmt = "DELETE FROM mt_item_relationship_category WHERE merchant_id = :merchant_id AND item_id = :item_id";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
    
    // Check if the query was successful
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}


public  function InsertItemRelationshipSubcategory($merchant_id='', $item_id='', $data=array())
    {
        $this->deleteItemRelationshipSubcategory($merchant_id,$item_id);
        if(isset($data['sub_item_id'])){
            if(is_array($data['sub_item_id']) && count($data['sub_item_id'])>=1){
                foreach ($data['sub_item_id'] as $subcat_id=>$val) {
                    $params=array(
                      'merchant_id'=>$merchant_id,
                      'item_id'=>$item_id,
                      'subcat_id'=>$subcat_id
                    );
                    $i = $this->functions->insertData('mt_item_relationship_subcategory', $params);

                }
            }
        }
    }
    
    public function deleteItemRelationshipSubcategory($merchant_id = '', $item_id = '')
{
    // Prepare the SQL statement
    $stmt = "DELETE FROM mt_item_relationship_subcategory WHERE merchant_id = :merchant_id AND item_id = :item_id";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
    
    // Check if the query was successful
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}

public function insertSKU($item_id = 1)
{
    try {
        // Prepare the SQL query with a placeholder for the item ID
        $stmt = $this->db->prepare("INSERT INTO mt_item_sku (item_id) VALUES (:item_id)");
        
        // Bind the item ID to the placeholder
        $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        
        // Execute the query
        $stmt->execute();
        
        // Optional: return the number of affected rows or the last insert ID
        return $this->db->lastInsertId();
    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
    }
}

public function autoGenerateSKU()
{
    // Prepare the SQL statement to show the table status for 'mt_item_sku'
    $stmt = "SHOW TABLE STATUS LIKE 'mt_item_sku'";

    // Prepare and execute the query using PDO
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // If the result is found, return the Auto_increment value
    if ($res) {
        return $res['Auto_increment'];
    }

    return false;
}


public function getItemSizePrice($merchant_id = '', $item_id = '')
{
    $stmt = "SELECT * 
             FROM mt_item_relationship_size 
             WHERE merchant_id = :merchant_id 
             AND item_id = :item_id 
             LIMIT 1";
             
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();

    $resp = $query->fetch(PDO::FETCH_ASSOC);
    
    return $resp ? $resp : false;
}

    
    public function getItemSizePrices($merchant_id = '', $item_id = '')
{
    $stmt = "SELECT * 
             FROM mt_item_relationship_size 
             WHERE merchant_id = :merchant_id 
             AND item_id = :item_id 
             ORDER BY item_size_id ASC";
             
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();

    $resp = $query->fetchAll(PDO::FETCH_ASSOC);
    
    return $resp ? $resp : false;
}

    public function getItemBySku($merchant_id='', $sku='')
{
    // Prepare the SQL query
    $stmt = "SELECT * FROM mt_view_item 
             WHERE merchant_id = :merchant_id AND sku = :sku
             LIMIT 1";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindValue(':merchant_id', $merchant_id);
    $query->bindValue(':sku', $sku);

    // Execute the query
    $query->execute();

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    
    return false;
}

public function getItemSizePricesWithStocks($merchant_id='', $item_id='')
{
    // Prepare the SQL query
    $sql = "SELECT * FROM mt_view_item_stocks WHERE merchant_id = :merchant_id AND item_id = :item_id ORDER BY item_size_id ASC";
    
    // Prepare the statement using the db connection
    $stmt = $this->db->prepare($sql);
    
    // Bind the parameters
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch all results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if any results are returned
    if ($resp) {
        return $resp;
    }
    
    return false;
}


public function searchItem($merchant_id = '', $item_name = '', $track_stock = '')
{
    $query = "SELECT merchant_id, item_id, item_name, sku, size_name, item_size_id, cost_price, available_stocks, incoming_balance 
              FROM mt_view_item_stocks";
    $params = [':merchant_id' => $merchant_id];
    
    // Build WHERE clause
    if (!empty($item_name)) {
        $where = "WHERE merchant_id = :merchant_id AND item_name LIKE :item_name";
        $params[':item_name'] = "%$item_name%";
    } else {
        $where = "WHERE merchant_id = :merchant_id";
    }

    // Add track_stock condition if needed
    if ($track_stock == 1) {
        $where .= " AND track_stock = :track_stock";
        $params[':track_stock'] = 1;
    }

    // Combine query and conditions
    $query .= " $where ORDER BY item_name ASC";

    try {
        $stmt = $this->db->prepare($query);
        $stmt->execute($params);
        $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $resp ? $resp : false;
    } catch (PDOException $e) {
        // Handle error (e.g., log it)
        return false;
    }
}


public  function prettyName($item_name='', $size_name='')
    {
        if(!empty($size_name)){
           

             return "item name ".$item_name." size_name ".$size_name;

        }
        return $item_name;
    }


    public  function inlineUpdatePrice($merchant_id=0, $item_id=0,$params1=array(), $params2=array())
    {
         

         

         $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
$whereValues = array(
    ':item_id' => $item_id,
    ':merchant_id' => $merchant_id,
);

$up=$this->functions->updateData_multiple('mt_item', $params1, $whereConditions, $whereValues);


          if($up){
             
             

             $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
$whereValues = [
    ':item_id' => $item_id,
    ':merchant_id' => $merchant_id,
];

$up=$this->functions->updateData_multiple('mt_item_relationship_size', $params2, $whereConditions, $whereValues);



              if($up){
                return true;
              } else throw new Exception( "Failed cannot update records" );
          
          } else throw new Exception( "Failed cannot update records" );
    }

    public function inlineUpdatePriceBySku($merchant_id = '', $sku = '', $new_price = 0)
{
    if ($sku > 0) {
        // Prepare the SELECT query

        $stmt = "
            SELECT 
                a.item_id, 
                a.size_id,
                b.price 
            FROM 
                mt_item_relationship_size a
            LEFT JOIN mt_item b
            ON
                a.item_id = b.item_id
            WHERE
                a.sku = :sku        
            LIMIT 0, 1
        ";

        // Execute the query
        $query = $this->db->prepare($stmt);
        $query->bindValue(':sku', $sku, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            
            $params = [
                'price' => (float)$new_price,
                'updated_at' => $this->functions->dateNow(),
            ];

            $whereConditions = 'sku = :sku AND merchant_id = :merchant_id';
            $whereValues = [
                ':sku' => $sku,
                ':merchant_id' => $merchant_id,
            ];

            // Update the mt_item_relationship_size table
            $up = $this->functions->updateData_multiple('mt_item_relationship_size', $params, $whereConditions, $whereValues);
            
            if ($up) {
                if (is_array($price = json_decode($res['price'], true))) {
                    if (array_key_exists($res['size_id'], (array)$price)) {
                        $price[$res['size_id']] = (float)$new_price;

                        $params2 = [
                            'price' => json_encode($price),
                            'date_modified' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                        ];

                        $whereConditions = 'item_id = :item_id AND merchant_id = :merchant_id';
                        $whereValues = [
                            ':item_id' => $res['item_id'],
                            ':merchant_id' => $merchant_id,
                        ];
                        
                        // Update the mt_item table
                        $up = $this->functions->updateData_multiple('mt_item', $params2, $whereConditions, $whereValues);
                    }
                }
                return true;
            } else {
                throw new Exception("Failed: cannot update records");
            }
        } else {
            throw new Exception("Record not found");
        }
    } else {
        throw new Exception("Invalid SKU number");
    }
}


public function autoFillItem($merchant_id = '', $supplier_id = 0, $type = '')
{
    $and = '';
    if ($type == "lowstock") {         
        $and .= " AND low_stock >= available_stocks";
    }
    
    $stmt = "
        SELECT merchant_id, item_id, item_name, sku, size_name, item_size_id, cost_price, available_stocks, incoming_balance
        FROM mt_view_item_stocks
        WHERE
        merchant_id = :merchant_id
        AND
        supplier_id = :supplier_id
        $and
    ";
    
    try {
        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindValue(':supplier_id', $supplier_id, PDO::PARAM_INT);
        $query->execute();
        
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        } else {
            throw new Exception("No records found");
        }
    } catch (PDOException $e) {
        throw new Exception("Database error: " . $e->getMessage());
    }
}


public  function insertShipping($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){          
         

          $up = $this->functions->updateData("mt_shipping_rate", $params, 'id', $id);

          return true;
        } else {    

            if($this->functions->insertData('mt_shipping_rate', $params) ){
                return true;
            } else throw new Exception( "Failed cannot insert records" );           
        }       
        
        throw new Exception( "an error has occurred" );
    }   

   public function deleteShipping($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion.");
    }

    // Create a placeholder string for the IN clause
    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    $stmt = "DELETE FROM mt_shipping_rate 
             WHERE merchant_id = ? 
             AND id IN ($placeholders)";
    
    $query = $this->db->prepare($stmt);
    
    // Bind merchant_id and IDs
    $params = array_merge([$merchant_id], $ids);
    $resp = $query->execute($params);
    
    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}


  public function getAllOffers($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $search_string = "%$search_string%";
        $and = " AND offer_percentage LIKE '$search_string' ";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            offers_id, merchant_id, offer_percentage, offer_price, 
            valid_from, applicable_to, valid_to, status, date_created
        FROM
            mt_offers
        WHERE 
            merchant_id = " . (int)$merchant_id . "
            $and
        ORDER BY 
            offers_id DESC
        LIMIT " . (int)$start . "," . (int)$total_rows;

    $query = $this->db->query($stmt);
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}



 


    public  function insertOffers($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){    

          

          $up = $this->functions->updateData("mt_offers", $params, 'offers_id', $id);


          if($up){
             return true;
          } else throw new Exception( "Failed cannot update records" );         
        } else { 

            if($this->functions->insertData('mt_offers', $params) ){
                return true;
            } else throw new Exception( "Failed cannot insert records" );           
        }       
        
        throw new Exception( "an error has occurred" );
    }   
    
   public function deleteOffers($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No offer IDs provided for deletion");
    }

    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    $stmt = "
        DELETE FROM mt_offers 
        WHERE merchant_id = ? 
        AND offers_id IN ($placeholders)
    ";

    $query = $this->db->prepare($stmt);

    // Bind parameters
    $params = array_merge([$merchant_id], $ids);
    $resp = $query->execute($params);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed, cannot delete records");
    }
}


 



public function getAllVouchers($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND voucher_name LIKE '%$search_string%' ";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS 
        voucher_id, voucher_owner, merchant_id, joining_merchant,
        voucher_name, voucher_type, amount, expiration, status,
        date_created, used_once
    FROM mt_voucher_new
    WHERE merchant_id = " . ((int)$merchant_id) . "
    AND voucher_owner = 'merchant'
    $and
    ORDER BY voucher_id DESC
    LIMIT $start, $total_rows
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}

   public function insertVoucher($merchant_id = '', $params = array(), $voucher_id = '')
{
    if ($voucher_id > 0) {
        // Check for existing voucher (excluding current one)
        $stmt = "
            SELECT voucher_name
            FROM mt_voucher_new
            WHERE merchant_id = :merchant_id 
            AND voucher_name = :voucher_name 
            AND voucher_owner = :voucher_owner 
            AND voucher_id <> :voucher_id
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([
            ':merchant_id' => $merchant_id,
            ':voucher_name' => $params['voucher_name'],
            ':voucher_owner' => "merchant",
            ':voucher_id' => $voucher_id,
        ]);

        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            // Perform update using existing updateData() function
            $up = $this->functions->updateData("mt_voucher_new", $params, 'voucher_id', $voucher_id);
            if ($up) {
                return true;
            } else {
                throw new Exception("Failed cannot update records");
            }
        } else {
            throw new Exception("Voucher name already exist");
        }
    } else {
        // Check for existing voucher before insertion
        $stmt = "
            SELECT voucher_name
            FROM mt_voucher_new
            WHERE merchant_id = :merchant_id 
            AND voucher_name = :voucher_name 
            AND voucher_owner = :voucher_owner
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->execute([
            ':merchant_id' => $merchant_id,
            ':voucher_name' => $params['voucher_name'],
            ':voucher_owner' => "merchant",
        ]);

        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            // Perform insert using existing insertData() function
            if ($this->functions->insertData('mt_voucher_new', $params)) {
                return true;
            } else {
                throw new Exception("Failed cannot insert records");
            }
        } else {
            throw new Exception("Voucher name already exist");
        }
    }

    throw new Exception("An error has occurred");
}


public function deleteVoucher($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No voucher IDs provided");
    }

    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    $stmt = "
        DELETE FROM mt_voucher_new
        WHERE merchant_id = ? 
        AND voucher_id IN ($placeholders)
    ";

    $query = $this->db->prepare($stmt);
    $params = array_merge([$merchant_id], $ids);
    $resp = $query->execute($params);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}
      
    
 public function getAllMinTable($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {             
        $and = " AND min_order LIKE :search_string ";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        id, merchant_id, distance_from, distance_to, shipping_units, min_order
        FROM mt_minimum_table
        WHERE merchant_id = :merchant_id      
        $and
        ORDER BY distance_from, distance_to ASC
        LIMIT :start, :total_rows
    ";

    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);
    if (!empty($search_string)) {
        $query->bindValue(':search_string', "%$search_string%", PDO::PARAM_STR);
    }
    $query->bindValue(':start', (int)$start, PDO::PARAM_INT);
    $query->bindValue(':total_rows', (int)$total_rows, PDO::PARAM_INT);

    // Execute query
    $query->execute();
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}


public  function insertMintable_xx($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){          
          

          $whereConditions = 'id = :id AND merchant_id = :merchant_id';
                        $whereValues = [
                            ':item_id' => $id,
                            ':merchant_id' => $merchant_id,
                        ];
                        
                        // Update the mt_item table
        $up = $this->functions->updateData_multiple('mt_minimum_table', $params, $whereConditions, $whereValues);

         

          if($up){
             return true;
          } else throw new Exception( "Failed cannot update records" );         
        } else {   

            if($this->functions->insertData('mt_minimum_table', $params)){
                return true;
            } else throw new Exception( "Failed cannot insert records" );           
        }       
        
        throw new Exception( "an error has occurred" );
    } 


  public function insertMintable($merchant_id = '', $params = array(), $id = '')
{
    if ($id > 0) {
        $set = '';
        foreach ($params as $key => $val) {
            $set .= "$key = " . $this->db->quote($val) . ", ";
        }
        $set = rtrim($set, ', ');

        $merchant_id = $this->db->quote($merchant_id);
        $id = (int)$id;

        $stmt = "
            UPDATE mt_minimum_table
            SET $set
            WHERE id = $id AND merchant_id = $merchant_id
        ";

        $query = $this->db->exec($stmt);
        if ($query !== false) {
            return true;
        } else {
            throw new Exception("Failed cannot update records");
        }

    } else {
        if ($this->functions->insertData('mt_minimum_table', $params)) {
            return true;
        } else {
            throw new Exception("Failed cannot insert records");
        }
    }

    throw new Exception("An error has occurred");
}
 

    
   public function deleteMintable($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided to delete");
    }

    // Prepare the SQL query with a placeholder for the IDs
    $placeholders = rtrim(str_repeat('?,', count($ids)), ',');
    $stmt = "
        DELETE FROM mt_minimum_table
        WHERE merchant_id = :merchant_id
        AND id IN ($placeholders)
    ";

    $query = $this->db->prepare($stmt);

    // Bind the merchant_id parameter
    $query->bindValue(':merchant_id', (int)$merchant_id, PDO::PARAM_INT);

    // Bind the ID parameters
    foreach ($ids as $key => $id) {
        $query->bindValue(($key + 1), (int)$id, PDO::PARAM_INT);
    }

    // Execute the query
    $query->execute();

    // Check if rows were affected
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed to delete records or no matching records found");
    }
}



public function getAllSchedulerList($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $search_string_escaped = $this->db->quote("%$search_string%");
        $and = " AND category_name LIKE $search_string_escaped ";
    }

    // Build the SQL query directly with variables
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS
        cat_id, merchant_id, category_name, category_description, category_name_trans,
        category_description_trans, monday, tuesday, wednesday, thursday, friday, saturday, sunday
        FROM mt_category
        WHERE merchant_id = " . (int)$merchant_id . "
        $and
        ORDER BY category_name ASC
        LIMIT " . (int)$start . ", " . (int)$total_rows;

    // Execute the query directly
    $query = $this->db->query($stmt);

    if ($query) {
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }

    return false;
}


public  function insertCategoryScheduler($merchant_id='',$params=array(), $id='')
    {                   
        if($id>0){  

         

          $whereConditions = 'cat_id = :cat_id AND merchant_id = :merchant_id';
                        $whereValues = [
                            ':cat_id' => $id,
                            ':merchant_id' => $merchant_id,
                        ];
                        
                        // Update the mt_item table
        $up = $this->functions->updateData_multiple('mt_category', $params, $whereConditions, $whereValues);


          if($up){
             return true;
          } else throw new Exception( "Failed cannot update records" );         
        } else {   

            if($this->functions->insertData('mt_category', $params)){
                return true;
            } else throw new Exception( "Failed cannot insert records" );           
        }       
        
        throw new Exception( "an error has occurred" );
    }  

  public function merchantStatusList($merchant_id = 0, $start = 0, $total_rows = 10, $search_string = '')
{
    $and = '';
    if (!empty($search_string)) {
        $and = " AND a.description LIKE " . $this->db->quote("%$search_string%");
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.stats_id, a.description, a.date_created       
        FROM
        mt_order_status a              
        WHERE a.merchant_id = " . (int)$merchant_id . "
        $and
        ORDER BY a.stats_id DESC
        LIMIT $start, $total_rows
    ";

    $query = $this->db->query($stmt);
    if ($query) {
        return $query->fetchAll(PDO::FETCH_ASSOC);
    }
    return false;
}


public function inserrOrderStatus($merchant_id = '', $params = array(), $id = '')
{                   
    if ($id > 0) {
        $stmt = $this->db->prepare("
            SELECT description 
            FROM mt_order_status 
            WHERE merchant_id = :merchant_id AND description = :description AND stats_id <> :stats_id 
            LIMIT 1
        ");
        
        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':description' => $params['description'],
            ':stats_id' => $id
        ]);
        
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$resp) {                 
            $up = $this->functions->updateData("mt_order_status", $params, 'stats_id', $id);

            if ($up) {
                return true;
            } else {
                throw new Exception("Failed cannot update records");
            }
        } else {
            throw new Exception("Status name already exist");
        }
    } else {            
        $stmt = $this->db->prepare("
            SELECT description 
            FROM mt_order_status 
            WHERE merchant_id = :merchant_id AND description = :description 
            LIMIT 1
        ");
        
        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':description' => $params['description']
        ]);
        
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$resp) {
            if ($this->functions->insertData('mt_order_status', $params)) {
                return true;
            } else {
                throw new Exception("Failed cannot insert records");
            }
        } else {
            throw new Exception("Status name already exist");
        }
    }       
    
    throw new Exception("An error has occurred");
}


public function deleteOrderStatus($merchant_id = '', $ids = array())
{
    if (empty($ids)) {
        throw new Exception("No IDs provided for deletion");
    }

    // Create placeholders for the IN clause
    $placeholders = rtrim(str_repeat('?,', count($ids)), ',');

    $stmt = $this->db->prepare("
        DELETE FROM mt_order_status 
        WHERE merchant_id = ? 
        AND stats_id IN ($placeholders)
    ");

    $params = array_merge([$merchant_id], $ids);

    $resp = $stmt->execute($params);

    if ($resp) {
        return true;
    } else {
        throw new Exception("Failed cannot delete records");
    }
}
   
    
   public function getAddonItemView($merchant_id = 0, $subcat_id = 0)
{
    $stmt = "
        SELECT * FROM
        mt_subcategory_item_relationships_view
        WHERE
        subcat_id = :subcat_id
        AND merchant_id = :merchant_id
        ORDER BY id DESC
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':subcat_id' => (int)$subcat_id,
        ':merchant_id' => (int)$merchant_id
    ]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public function migrateDataAddon($merchant_id = 0, $subcat_id = 0)
{
    $stmt = "
        SELECT sub_item_id, category
        FROM mt_subcategory_item
        WHERE
        category LIKE :category
        AND merchant_id = :merchant_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':category' => '%"'.$subcat_id.'"%', 
        ':merchant_id' => $merchant_id
    ]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $params = array(
                'subcat_id' => $subcat_id,
                'sub_item_id' => $val['sub_item_id']
            );
            $this->functions->insertData('mt_subcategory_item_relationships', $params);
        }
    }
}


public function getIngredientsByName($name = '', $enabled_trans = false)
{
    $select = ", ingredients_name";

    $stmt = "
        SELECT 
            ingredients_id $select 
        FROM mt_ingredients a
        WHERE ingredients_name = :name
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':name' => $name]);

    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return stripslashes($res['ingredients_name']);
    }
    return false;
}



         

      
              






    


  

  





   

       












 





   
  
      
}
/*END CLASS*/