<?php
class CronController extends Controller
{

	public function __construct()
	{
		$model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        $this->mobileWrapper = new mobileWrapper();

        $website_timezone=$this->functions->getOptionAdmin('website_timezone');
        if (!empty($website_timezone)){
            date_default_timezone_set($website_timezone);
        }

        
	}
	
	public function index()
	{
    echo 'cron is working';

		
	}


    public function ProcessBroadcast()
    {
        
        
      
            
            $service_account = $this->functions->getOptionAdmin('mobileapp2_services_account_json');

            $file = $this->functions->uploadPath()."/$service_account";

             //$serviceAccount = json_decode(file_get_contents($file), true);
			 $serviceAccount = $this->functions->readJsonFile($file);
             $projectId = $serviceAccount['project_id'];
             


            $fcm_response='';
            
           $stmt = "
    SELECT * 
    FROM mt_mobile2_broadcast 
    WHERE status = :status 
    AND fcm_version = :fcm_version
    ORDER BY broadcast_id ASC
    LIMIT 1
";

// Assuming $this->db is the PDO connection object
$query = $this->db->prepare($stmt);
$status = 'pending';  // 'pending' as per your original condition
$fcm_version = 1; 
// Bind parameters
$query->bindParam(':status', $status, PDO::PARAM_STR);
$query->bindParam(':fcm_version', $fcm_version, PDO::PARAM_INT);

// Execute the query
$query->execute();

// Fetch the result
$resp = $query->fetchAll(PDO::FETCH_ASSOC);

                if ($resp) {
                    // Your logic here            
                
                foreach ($resp as $val) {
                    $broadcast_id = $val['broadcast_id'];                   
                    try {   

                      
                       /* $fcm_response = FcmWrapper::ServiceAccount($file,'mobileapp2_fcm_v1')
                        ->setTarget($val['device_platform'])
                        ->setTitle($val['push_title'])
                        ->setBody($val['push_message'])
                        ->setChannel(CHANNEL_ID)
                        ->setSound(CHANNEL_SOUNDNAME)
                        ->setAppleSound(CHANNEL_SOUNDFILE)
                        ->setBadge(1)
                        ->setForeground("true")
                        ->prepare()
                        ->send();   */      


                         $data=[
                            'target'=>'broadcast',
                            'title'=>$val['push_title'],
                            'body'=>$val['push_message'],
                            'channel'=>'mobile2_channel',
                            'sound'=>'beep',
                            'apple_sound'=>'beep.wav',
                            'projectId'=>$projectId
                        ];
                        //print_r($data);die();

                        $fcm_response=$this->functions->sendFCMNotification($data,$serviceAccount,"broadcast");   

                        


                       
                        $resp = 'process';

                    } catch (Exception $e) {
                        $fcm_response = $e->getMessage();                       
                        $resp = 'failed';
                    }
                    
                   


                     $this->functions->updateData("mt_mobile2_broadcast",array(
                     'status'=>$resp,
                     'date_modified'=>$this->functions->dateNow(),
                     'ip_address'=>$_SERVER['REMOTE_ADDR'],
                     'fcm_response'=>$fcm_response
                    ),'broadcast_id',$broadcast_id);



                    
                }
            }
            
        
    }




    public function processpush()
    {       
        
       // define('LOCK_SUFFIX', '.mobileapp2_processpush');
                
        
        
        //dump("running processpush...");
        
        $server_key = $this->functions->getOptionAdmin('mobileapp2_push_server_key');
        $push_icon = $this->functions->getOptionAdmin('android_push_icon');
        
        $pushpic = '';
        $enabled_pushpic = $this->functions->getOptionAdmin('android_enabled_pushpic');
        if($enabled_pushpic==1){           
            $pushpic = $this->functions->getOptionAdmin('android_push_picture');
        }
        
        $process_date = $this->functions->dateNow();
        //$channel_id = CHANNEL_ID;
        
        $mobileapp2_fcm_provider = $this->functions->getOptionAdmin('mobileapp2_fcm_provider');
        $mobileapp2_fcm_provider = $mobileapp2_fcm_provider>0?(integer)$mobileapp2_fcm_provider:1;
        
        $service_account = $this->functions->getOptionAdmin('mobileapp2_services_account_json');
        

        $file = $this->functions->uploadPath()."/$service_account";
         
       
       // $serviceAccount = json_decode(file_get_contents($file), true);
		$serviceAccount = $this->functions->readJsonFile($file);
        $projectId = $serviceAccount['project_id'];
        
        $stmt = "
    SELECT * FROM mt_mobile2_push_logs
    WHERE status = 'pending'
    ORDER BY id ASC
    LIMIT 0, 20
";
$query = $this->db->prepare($stmt);
$query->execute();
if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {

 
            
            foreach ($res as $val) {
                                
                $process_status=''; $json_response='';
                $device_id = $val['device_id'];
                   
                if(2==2):
                
                    try {                   
                       /* $json_response = FcmWrapper::ServiceAccount($file,'mobileapp2_fcm_v1')
                        ->setTarget($val['device_id'])
                        ->setTitle($val['push_title'])
                        ->setBody($val['push_message'])
                        ->setChannel(CHANNEL_ID)
                        ->setSound(CHANNEL_SOUNDNAME)
                        ->setAppleSound(CHANNEL_SOUNDFILE)
                        ->setBadge(1)
                        ->setForeground("true")
                        ->prepare()
                        ->send();                  */     
                        $process_status = 'process';

                        $data=[
                            'target'=>$val['device_id'],
                            'title'=>$val['push_title'],
                            'body'=>$val['push_message'],
                            'channel'=>'mobile2_channel',
                            'sound'=>'beep',
                            'apple_sound'=>'beep.wav',

                            'projectId'=>$projectId
                        ];
                        //print_r($data);die();

                        $json_response=$this->functions->sendFCMNotification($data,$serviceAccount,'push');


                    } catch (Exception $e) {
                        $process_status = 'failed';
                        $json_response = $e->getMessage();                      
                    }               
                                                            
                else :
                
                    switch (strtolower($val['device_platform'])) {
                        case "android":
                            $data = array(
                              'title'=>$val['push_title'],
                              'body'=>$val['push_message'],
                              'vibrate' => 1,           
                              'soundname'=> "CHANNEL_SOUNDNAME",
                              'android_channel_id'=>$channel_id,
                              'content-available'=>1,
                              'count'=>1,                         
                              'badge'=>1,
                              'push_type'=>$val['push_type']
                             );         
                             if(!empty($push_icon)){
                                $data['image'] = $this->mobileWrapper->getImage($push_icon);
                             }           
                             
                             if($enabled_pushpic==1 && !empty($pushpic)){
                                $data['style'] ="picture";
                                $data['picture'] = $this->mobileWrapper->getImage($pushpic);
                             }
                             
                             if(!empty($server_key)){
                                 try {
                                    $json_response = fcmPush::pushAndroid($data,$device_id,$server_key);                            
                                    $process_status='process';
                                 } catch (Exception $e) {
                                    $process_status = "failed";
                                    $json_response = 'Caught exception:'. $e->getMessage();
                                 }
                             } else {
                                $process_status = "failed";
                                $json_response = 'server key is empty';
                             }
                            break;
                            
                        case "ios":
                            try {
                                 $data = array( 
                                  'title' =>$val['push_title'],
                                  'body' => $val['push_message'],
                                  'sound'=>'CHANNEL_SOUNDFILE',
                                  'android_channel_id'=>$channel_id,
                                  'badge'=>1,
                                  'content-available'=>1,
                                  'push_type'=>$val['push_type']
                                );                         
                                $json_response = fcmPush::pushIOS($data,$device_id,$server_key);
                                $process_status='process';                          
                            } catch (Exception $e) {
                                $process_status = "failed";
                                $json_response =  $e->getMessage();
                            }       
                            break;
                            
                        default:
                            $process_status = "failed";
                            $json_response = 'undefined device platform'; 
                            break;      
                    }                   
                endif;
                
                if(!empty($process_status)){
                   $process_status=substr( strip_tags($process_status) ,0,255);
                } else $process_status='failed';    
                
                if(is_array($json_response) && count($json_response)>=1){
                    $json_response = json_encode($json_response);
                } 
                
                $params = array(
                  'status'=>$process_status,
                  'date_process'=>$process_date,
                  'json_response'=>$json_response
                );              
                
              

                $this->functions->updateData("mt_mobile2_push_logs",$params,'id',$val['id']);
                
            } /*end foreach*/
        } 
        
        //cronHelper::unlock();
        
    }


public function triggerorder()
{
    if (1 == 1) :

        $stmt = "
        SELECT
        a.trigger_id,
        a.trigger_type,
        a.order_id,
        a.order_status,
        a.remarks,  
        a.status,
        a.language,
        b.order_id as b_order_id,
        b.client_id,
        b.merchant_id,
        concat(c.first_name,' ',c.last_name) as customer_name,
        d.restaurant_name,
        e.booking_id,
        e.client_id as booking_client_id,
        (
           select concat(first_name,' ',last_name)
           from mt_client
           where client_id = e.client_id
        ) as booking_customer_name

        FROM mt_mobile2_order_trigger a
        left join mt_order b
        ON a.order_id = b.order_id

        left join mt_client c
        ON b.client_id = c.client_id

        left join mt_merchant d
        ON b.merchant_id = d.merchant_id

        left join mt_bookingtable e
        ON a.order_id = e.booking_id

        WHERE 
        a.status='pending'
        ORDER BY trigger_id ASC
        LIMIT 0,10
        ";

        $website_title = $this->functions->getOptionAdmin('website_title');
        $website_url = $this->functions->websiteUrl();
        $error = '';

        $stmt_exec = $this->db->prepare($stmt);
        $stmt_exec->execute();

        if ($res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC)) {
           
            foreach ($res as $val) {

                $trigger_id = $val['trigger_id'];
                $lang = $val['language'];
                $status = $val['order_status'];
                $order_id = $val['order_id'];

                switch ($val['trigger_type']) {

                    case "order":
                        
                        require __DIR__ . '/../../../models/trigger-order.php';

                        break;

                    case "order_request_cancel":

                       require __DIR__ . '/../../../models/trigger-cancel-order.php';

                        
                        break;

                    case "booking":
                        require __DIR__ . '/../../../models/trigger-booking.php';
                       
                        break;

                    default:
                        $error = "invalid trigger type";
                        break;
                }

                $params_update = array(
                    'status' => $error,
                    'date_process' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                );

                $this->functions->updateData("mt_mobile2_order_trigger", $params_update, 'trigger_id', $trigger_id);
                $this->processpush();
            } /*end foreach*/
        } else {
             echo "no record";die();
            // No records to process
        }

    endif;
}

public function getfbavatar()
{
    if (1 == 1):

        $stmt = "
        SELECT client_id, avatar, social_id
        FROM mt_client
        WHERE avatar = ''
        AND social_id != ''
        AND social_strategy = 'fb_mobile'
        LIMIT 0,2
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                $params = array();
                $client_id = $val['client_id'];

                if ($avatar = $this->functions->saveFbAvatarPicture($val['social_id'])) {
                    $params['avatar'] = $avatar;
                } else {
                    $params['avatar'] = "avatar.jpg";
                }

                $params['date_modified'] = $this->functions->dateNow();
                $params['ip_address'] = $_SERVER['REMOTE_ADDR'];

                $this->functions->updateData('mt_client', $params, 'client_id', $client_id);
            }
        } else {
            if (isset($_GET['debug'])) {
                echo 'no records to process';
            }
        }

    endif;
}


public function RemoveInActiveDevice()
{
    $date_now = date('Y-m-d g:i:s a');
    $days_inactive = 30;

    $stmt = "
    SELECT * FROM mt_mobile2_device_reg
    WHERE status = 'active'
    ORDER BY date_created ASC
    LIMIT 0,20
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $time = date("Y-m-d g:i:s a", strtotime($val['date_created']));
            $date_diff = $this->functions->dateDifference($time, $date_now);

            if (is_array($date_diff) && count($date_diff) >= 1) {
                if ($date_diff['days'] >= $days_inactive) {

                    $this->functions->updateData("mt_mobile2_device_reg", array(
                        'status' => 'deactivated',
                        'date_modified' => $this->functions->dateNow()
                    ), 'id', $val['id']);

                }
            }
        }
    }
}
               




	
	
	
	
	
}
/*end class*/