<?php
class PaypalController extends Controller
{

	public function __construct()
	{
		$model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->SingleAppClass = new SingleAppClass();

        $this->InventoryWrapper=new InventoryWrapper();

	}
	
	public function index()
	{

		 $amount_to_pay = 0; 
    $error = ''; 
    $credentials = '';
    $payment_description = '';
    $merchant_name = ''; 
    $reference_id = ''; 
    $client_info = [];
    $trans_type = 'order';
    $currency_code = $this->functions->getCurrencyCode();

    

    $back_url=$this->functions->websiteUrl()."/singlemerchant/paypal/cancel";

    // Fetch the order token
    $order_id_token = isset($_GET['id']) ? $_GET['id'] : '';

    // Fetch order details
    if ($data = $this->functions->getOrderByToken_appside($order_id_token)) {
        $merchant_id = $data['merchant_id'];
        $client_id = $data['client_id'];
        $order_id = $data['order_id'];
        $reference_id = $data['order_id'];
        $order_card_fee = isset($data['card_fee']) ? (float)$data['card_fee'] : 0;

        $merchant_name = $this->functions->clearString($data['merchant_name']);
        $payment_description = $this->functions->translation("default", "Payment to merchant " . $merchant_name . " Order ID# " . $order_id);

        $amount_to_pay = $this->functions->normalPrettyPrice($data['total_w_tax']);
        $amount_to_pay=$amount_to_pay;
    } else {
        $error = $this->functions->translation("default", "Sorry, but we cannot find what you are looking for.");
    }

    // Fallback for currency code
    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }






        if (empty($error)) {

        if ($credentials = $this->functions->getCredentials_paypal($merchant_id)) {

         
                   
        $success_url = $this->functions->websiteUrl() . "/singlemerchant/paypal/verify?reference_id=" . urlencode($reference_id) . "&trans_type=$trans_type";
    
        if ($this->functions->isClientLogin()){
        $cancel_url = $this->functions->websiteUrl()."/singlemerchant/paypal/cancel";
      }else{
        $cancel_url =$this->functions->websiteUrl()."/singlemerchant/paypal/cancel";
      }


 
        $clientId =  $credentials['client_id'];
        $clientSecret = $credentials['secret_key'];
        

        $baseUrl = $credentials['mode'] == 'live' 
        ? 'https://api-m.paypal.com' // Live URL
        : 'https://api-m.sandbox.paypal.com';

        // Step 1: Generate Access Token
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v1/oauth2/token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, "$clientId:$clientSecret");
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
        curl_setopt($ch, CURLOPT_POST, true);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {
            die('Error: Unable to fetch access token');
        }

        $accessToken = json_decode($response)->access_token;

        // Step 2: Create Order
      $orderData = [
    "intent" => "CAPTURE",
    "purchase_units" => [
        [
            "amount" => [
                'currency_code' => $currency_code,
                'value' => $amount_to_pay,
            ]
        ]
    ],
    "application_context" => [
        "return_url" => $success_url,
        "cancel_url" => $cancel_url
    ]
];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v2/checkout/orders");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer $accessToken"
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $order = json_decode($response);
        $this->functions->update_payment_id($order_id,$order->id);

        if (!isset($order->links[1]->href)) {
            
             
            $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/error?error=Unable to create PayPal order";
            header('Location: ' . $redirect_link);
        }

        $approvalUrl = $order->links[1]->href;
        
        //echo $approvalUrl;die();
        // Pass approval URL to the view

         header("Location: " . $approvalUrl);
         exit();
        
        /*$data = ['approval_url' => $approvalUrl];
        $this->view('store/paypal_iframe', $data,'');*/
         }else {
            $error = $this->functions->translation("default", "Invalid merchant credentials");
           
          }

        }


         // Handle error
        if (!empty($error)) {
            $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/error?error=".$error;
            header('Location: ' . $redirect_link);
        }

		
	}


	public function verify()
{
    $get = $_GET;
    $back_url = '';
    $error = '';
    $payment_code = 'paypal_v2';

    $reference_id = isset($get['reference_id']) ? $get['reference_id'] : '';
    $trans_type = isset($get['trans_type']) ? $get['trans_type'] : '';
    $payment_token = isset($get['token']) ? $get['token'] : '';

    if (!empty($reference_id) && !empty($trans_type)) {
        switch ($trans_type) {
            

            case "order":
                
                if ($data = $this->functions->getOrderInfoByToken_appside($reference_id)) {
                    $merchant_id = $data['merchant_id'] ?? '';
                    $order_id = $data['order_id'];
                    $client_id = $data['client_id'];
                    //$redirect_link = Config::$baseUrl . "/store/receipt?id=" . $order_id;
                    $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/success?message=".$msg;

                    if ($credentials = $this->functions->getCredentials_paypal($merchant_id)) {
                        try {
                            $resp = $this->capturePayment($credentials, $payment_token);

                            if ($resp['status'] !== 'COMPLETED') {
                                

                                 $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/error?error=".json_encode($resp);
                                  header('Location: ' . $redirect_link);

                            }

                            if ($data['status'] === "paid") {
                            	 $msg="already paid";
                            	  $this->SingleAppClass->clearCartByCustomerID($client_id);		
                            	 $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/success?message=".$msg;
                                header('Location: ' . $redirect_link . "&note=already paid");
                                exit;
                            } else {
                                $this->functions->updateOrderPayment($order_id, $payment_code, $resp['id'], $resp, $reference_id);
                                 $this->SingleAppClass->sendNotifications($order_id);

                                 $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                               if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}
                               $params_update=array( 
                                  'order_number'=>$order_number,  
                                );    
                                $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);
                                $this->SingleAppClass->updatePoints($order_id,'paid'); 

                                //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code

                                $this->SingleAppClass->clearCartByCustomerID($client_id);
                                $msg="Payment successfull";
                                $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/success?message=".$msg;
                                header('Location: ' . $redirect_link);
                                exit;
                            }
                        } catch (Exception $e) {
                            $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
                        }
                    } else {
                        $error = $this->functions->translation("default", "Invalid payment credentials");
                    }
                } else {
                    $error = $this->functions->translation("default", "Failed getting order information");
                }
                break;

            

            default:
                $error = $this->functions->translation("default", "Invalid transaction type " . $trans_type);
                
                break;
        }
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for");
         
    }

    if (!empty($error)) {
         $redirect_link=Config::$baseUrl . "/singlemerchant/paypal/error?error=".$error;
         header('Location: ' . $redirect_link);
    }
}

private function capturePayment($credentials, $payment_token)
{
    // Set the base URL for PayPal API based on the environment (live or sandbox)
    $base_url = $credentials['mode'] === 'live' 
                ? 'https://api-m.paypal.com' 
                : 'https://api-m.sandbox.paypal.com';

    // Step 1: Get Access Token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $base_url . "/v1/oauth2/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $credentials['client_id'] . ":" . $credentials['secret_key']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and check if the access token was obtained
    $token_data = json_decode($response, true);
    if (!isset($token_data['access_token'])) {
        throw new Exception("Failed to retrieve access token: " . json_encode($token_data));
    }
    $access_token = $token_data['access_token'];

    // Step 2: Capture the Payment using the provided payment token
    $capture_url = $base_url . "/v2/checkout/orders/$payment_token/capture";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $capture_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer $access_token"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response and return it
    $capture_data = json_decode($response, true);
    if (isset($capture_data['status']) && $capture_data['status'] === 'COMPLETED') {
        return $capture_data; // Return the successful payment data
    } else {
        throw new Exception("Payment capture failed: " . json_encode($capture_data));
    }
}



public function success()
	{
		$msg = isset($_GET['message'])?$_GET['message']:'';
		if(!empty($msg)){
			echo $msg;
		} else {
			echo "payment successfull";
		}
	}



	public function error()
	{
		$error = isset($_GET['error'])?$_GET['error']:'';
		if(!empty($error)){
			echo $error;
		} else echo "undefined error";
	}
	
	public function cancel()
	{
		
	}
	
	
	
	
	
}
/*end class*/