<?php
class CheckoutWrapperTemp
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        
        $this->MapsWrapperTemp=new MapsWrapperTemp();
        
        //$this->CronWrapper = new CronWrapper();
        

    }

   public function verifyCanPlaceOrder($client_id = '')
{
    $restrict_order_by_status = $this->functions->getOptionAdmin('restrict_order_by_status');
    
    if (!empty($restrict_order_by_status)) {          
        if ($json = json_decode($restrict_order_by_status, true)) {
            $order_stats = implode(',', array_map('intval', $json)); // Ensure safe integers
            
            if (!empty($order_stats)) {
                $stmt = "SELECT order_id, status 
                        FROM mt_order 
                        WHERE status IN ($order_stats) 
                        ORDER BY order_id DESC 
                        LIMIT 1";

                $query = $this->db->prepare($stmt);
                $query->execute();
                $res = $query->fetch(PDO::FETCH_ASSOC);
                
                if ($res) {
                    throw new Exception(
                        $this->functions->translation("default", "You have previous orders with status " . $res['status'] . " you cannot place another order until your last order is processed")
                    );
                }
            }
        }
    }
    
    return true;
}

public function verifyLocation($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0)
{
	 $logFile1 = __DIR__ . '/../../../../logs/geolocationhits_webappv2.log';
$logDir = dirname($logFile1);
 
if (!is_dir($logDir)) {
    mkdir($logDir, 0777, true);
}

file_put_contents(
    $logFile1,
    date('c') . " Processed address : \n",
    FILE_APPEND
);
	
	
    $stmt = $this->db->prepare("
        SELECT merchant_id, latitude, lontitude, minimum_order 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id 
        LIMIT 1
    ");
    $stmt->execute([':merchant_id' => (int)$merchant_id]);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $provider = $this->functions->getMapProvider();            
        $this->MapsWrapperTemp->init($provider);
        $unit = $this->functions->getMerchantDistanceType($merchant_id); 
        $mode = isset($provider['mode']) ? $provider['mode'] : 'driving';
        $min_order = 0;

        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);   
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);    
        $resp_distance = [];
                    
        if ($merchant_delivery_distance > 0) {
            $resp_distance = $this->MapsWrapperTemp->getDistance(
                $resp['latitude'], 
                $resp['lontitude'], 
                $lat, 
                $lng, 
                $unit, 
                $mode
            );

            $distance = $resp_distance['distance'];
            if ($distance > $merchant_delivery_distance) {                  
                $pretty_distance = $this->functions->translation(
                    "default", 
                    "Distance: " . $merchant_delivery_distance . " " . $this->MapsWrapperTemp->prettyUnit($unit)
                );

                $error = $this->functions->translation(
                    "default",
                    "Sorry but this merchant delivers only within " . $pretty_distance . 
                    ". Your current distance is " . $resp_distance['pretty_distance']
                );

                throw new Exception($error);
            } 
                
            /* MINIMUM ORDER TABLE */
            /*$min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {                                     
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $resp['minimum_order']
                );                  
                if ($min_order > $order_subtotal) {
                    $error = $this->functions->translation(
                        "default", 
                        "Sorry but minimum order is " . 
                        $this->functions->prettyPrice($min_order) . 
                        " for distance " . $resp_distance['pretty_distance']
                    );

                    throw new Exception($error);
                }
            }*/
                
            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {                   
                $delivery_fee = $this->getShippingFee(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $delivery_fee
                );
            }       
        } 
                        
        return array_merge((array)$resp_distance, [
            'delivery_fee' => $delivery_fee,
            'min_order'    => $min_order
        ]);
        
    } else {
        throw new Exception("Merchant not found");
    }
}


public function verifyLocation_was($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0)
{
    $stmt = $this->db->prepare("
        SELECT merchant_id, latitude, lontitude, minimum_order 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id 
        LIMIT 1
    ");
    $stmt->execute([':merchant_id' => (int)$merchant_id]);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $provider = $this->functions->getMapProvider_merchant($merchant_id);            
        $this->MapsWrapperTemp->init($provider);
        $unit = $this->functions->getMerchantDistanceType($merchant_id); 
        $mode = isset($provider['mode']) ? $provider['mode'] : 'driving';
        $min_order = 0;

        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);   
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);    
        $resp_distance = [];
                    
        if ($merchant_delivery_distance > 0) {
            $resp_distance = $this->MapsWrapperTemp->getDistance_webappv2(
                $resp['latitude'], 
                $resp['lontitude'], 
                $lat, 
                $lng, 
                $unit, 
                $mode,
				$provider
            );

            $distance = $resp_distance['distance'];
           /* if ($distance > $merchant_delivery_distance) {                  
                $pretty_distance = $this->functions->translation(
                    "default", 
                    "Distance: " . $merchant_delivery_distance . " " . $this->MapsWrapperTemp->prettyUnit($unit)
                );

                $error = $this->functions->translation(
                    "default",
                    "Sorry but this merchant delivers only within " . $pretty_distance . 
                    ". Your current distance is " . $resp_distance['pretty_distance']
                );

                throw new Exception($error);
            } */
                
            /* MINIMUM ORDER TABLE */
            /*$min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {                                     
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $resp['minimum_order']
                );                  
                if ($min_order > $order_subtotal) {
                    $error = $this->functions->translation(
                        "default", 
                        "Sorry but minimum order is " . 
                        $this->functions->prettyPrice($min_order) . 
                        " for distance " . $resp_distance['pretty_distance']
                    );

                    throw new Exception($error);
                }
            }*/
                
            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {                   
                $delivery_fee = $this->getShippingFee(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $delivery_fee
                );
            }       
        } 
                        
        return array_merge((array)$resp_distance, [
            'delivery_fee' => $delivery_fee,
            'min_order'    => $min_order
        ]);
        
    } else {
        throw new Exception("Merchant not found");
    }
}





public function verifyLocation_addtocart($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0)
{
    $stmt = $this->db->prepare("
        SELECT merchant_id, latitude, lontitude, minimum_order 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id 
        LIMIT 1
    ");
    $stmt->execute([':merchant_id' => (int)$merchant_id]);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $provider = $this->functions->getMapProvider();            
        $this->MapsWrapperTemp->init($provider);
        $unit = $this->functions->getMerchantDistanceType($merchant_id); 
        $mode = isset($provider['mode']) ? $provider['mode'] : 'driving';
        $min_order = 0;

        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);   
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);    
        $resp_distance = [];
                    
        if ($merchant_delivery_distance > 0) {
            $resp_distance = $this->MapsWrapperTemp->getDistance(
                $resp['latitude'], 
                $resp['lontitude'], 
                $lat, 
                $lng, 
                $unit, 
                $mode
            );

            $distance = $resp_distance['distance'];
            if ($distance > $merchant_delivery_distance) {                  
                $pretty_distance = $this->functions->translation(
                    "default", 
                    "Distance: " . $merchant_delivery_distance . " " . $this->MapsWrapperTemp->prettyUnit($unit)
                );

                $error = $this->functions->translation(
                    "default",
                    "Sorry but this merchant delivers only within " . $pretty_distance . 
                    ". Your current distance is " . $resp_distance['pretty_distance']
                );

               
            } 
                
            /* MINIMUM ORDER TABLE */
            $min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {                                     
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $resp['minimum_order']
                );                  
                if ($min_order > $order_subtotal) {
                    $error = $this->functions->translation(
                        "default", 
                        "Sorry but minimum order is " . 
                        $this->functions->prettyPrice($min_order) . 
                        " for distance " . $resp_distance['pretty_distance']
                    );

                    
                }
            }
                
            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {                   
                $delivery_fee = $this->getShippingFee(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $delivery_fee
                );
            }       
        } 
                        
      
        
        if (isset($resp['delivery_fee'], $resp['min_order'])) {
    // Both keys exist
      return array_merge((array)$resp_distance, [
            'delivery_fee' => $delivery_fee,
            'min_order'    => $min_order
        ]);
} else {
    // One of the keys is missing
    
    return true;
}
        
        
        
    } else {
        throw new Exception("Merchant not found");
    }
}


public function verifyLocation_addtocart_was($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0,$distance="")
{
    $stmt = $this->db->prepare("
        SELECT merchant_id, latitude, lontitude, minimum_order 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id 
        LIMIT 1
    ");
    $stmt->execute([':merchant_id' => (int)$merchant_id]);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
                    
        
        $unit = $this->functions->getMerchantDistanceType($merchant_id); 
        
        $min_order = 0;

        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);   
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);    
        $resp_distance = [];
                    
        if ($merchant_delivery_distance > 0) {
            /*$resp_distance = $this->MapsWrapperTemp->getDistance(
                $resp['latitude'], 
                $resp['lontitude'], 
                $lat, 
                $lng, 
                $unit, 
                $mode
            );*/

             $pretty_distance = $this->functions->translation(
                                      "default", 
                                      "Distance " . $distance . " unit " . $this->prettyUnit($unit)
                                     );

            $resp_distance = array(
                                      'distance'=>$distance,
                                      'unit'=>$unit,
                                      'pretty_unit'=>$this->prettyUnit($unit),
                                      'pretty_distance'=>$pretty_distance,
                                      'distance_from_google'=>"",

                                      'meters'=>"",
                                      'duration'=>"",
                                      'duration_in_traffic'=>"",
                                      'provider'=>""
                                    );

            //+++was custom code

                

                // If you need it as JSON string
                $json_response1 = json_encode($resp_distance, JSON_PRETTY_PRINT);
                $params_response = array(
                                         
                                          'response'=>$json_response1
                                        );                              
                                        
                 $this->functions->insertData("mt_response",$params_response);

                //---was custom code




            $distance = $resp_distance['distance'];
            if ($distance > $merchant_delivery_distance) {                  
                $pretty_distance = $this->functions->translation(
                    "default", 
                    "Distance: " . $merchant_delivery_distance . " " . $this->MapsWrapperTemp->prettyUnit($unit)
                );

                $error = $this->functions->translation(
                    "default",
                    "Sorry but this merchant delivers only within " . $pretty_distance . 
                    ". Your current distance is " . $resp_distance['pretty_distance']
                );

               
            } 
                
            /* MINIMUM ORDER TABLE */
            $min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {                                     
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $resp['minimum_order']
                );                  
                if ($min_order > $order_subtotal) {
                    $error = $this->functions->translation(
                        "default", 
                        "Sorry but minimum order is " . 
                        $this->functions->prettyPrice($min_order) . 
                        " for distance " . $resp_distance['pretty_distance']
                    );

                    
                }
            }
                
            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {                   
                $delivery_fee = $this->getShippingFee(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $delivery_fee
                );
            }       
        } 
                        
       return array_merge((array)$resp_distance, [
            'delivery_fee' => $delivery_fee,
            'min_order'    => $min_order
        ]);
        
        if (isset($resp['delivery_fee'], $resp['min_order'])) {
    // Both keys exist
      return array_merge((array)$resp_distance, [
            'delivery_fee' => $delivery_fee,
            'min_order'    => $min_order
        ]);
} else {
    // One of the keys is missing
    
    return true;
}
        
        
        
    } else {
        throw new Exception("Merchant not found");
    }
}



   public  function prettyUnit($unit='')
    {
        switch ($unit) {
            case "M":       
            case "mi":  
                return "miles";
                break;
                
            case "K":           
            case "km":  
                return "km";
                break;  
                
            case "m":           
                return "m";
                break;      
                
            case "ft":          
                return "ft";
                break;          
        
            default:
                return $unit;
                break;
        }
    }




public function verifyLocation_old($merchant_id = 0, $lat = 0, $lng = 0, $order_subtotal = 0)
{
    $stmt = $this->db->prepare("
        SELECT merchant_id, latitude, lontitude, minimum_order 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id 
        LIMIT 1
    ");
    $stmt->execute([':merchant_id' => (int)$merchant_id]);
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $provider = $this->functions->getMapProvider();            
        $this->MapsWrapperTemp->init($provider);
        $unit = $this->functions->getMerchantDistanceType($merchant_id); 
        $mode = isset($provider['mode']) ? $provider['mode'] : 'driving';
        $min_order = 0;

        $merchant_delivery_distance = $this->functions->getOption('merchant_delivery_miles', $merchant_id);   
        $delivery_fee = $this->functions->getOption('merchant_delivery_charges', $merchant_id);    
        $resp_distance = array();
                    
        if ($merchant_delivery_distance > 0) {
            $resp_distance = $this->MapsWrapperTemp->getDistance(
                $resp['latitude'], 
                $resp['lontitude'], 
                $lat, 
                $lng, 
                $unit, 
                $mode
            );

            $distance = $resp_distance['distance'];
            if ($merchant_delivery_distance > 0) {
                if ($distance > $merchant_delivery_distance) {                  
                    $pretty_distance = $this->functions->translation(
                        "default", 
                        "Distance: " . $merchant_delivery_distance . " unit" . $this->MapsWrapperTemp->prettyUnit($unit)
                    );

                    $error = $this->functions->translation(
                        "default",
                        "Sorry but this merchant delivers only within " . $pretty_distance . 
                        ". Your current distance is " . $resp_distance['pretty_distance']
                    );

                    throw new Exception($error);
                } 
            }
                
            /* MINIMUM ORDER TABLE */
            $min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);
            if ($min_tables_enabled == 1) {                                     
                $min_order = $this->getMinimumOrderTable(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $resp['minimum_order']
                );                  
                if ($min_order > $order_subtotal) {
                    $error = $this->functions->translation(
                        "default", 
                        "Sorry but minimum order is " . 
                        $this->functions->prettyPrice($min_order) . 
                        " for distance " . $resp_distance['pretty_distance']
                    );

                    throw new Exception($error);
                }
            }
                
            /* SHIPPING FEE */
            $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
            if ($shipping_enabled == 2) {                   
                $delivery_fee = $this->getShippingFee(
                    $merchant_id, 
                    $resp_distance['distance'], 
                    $resp_distance['unit'], 
                    $delivery_fee
                );
            }       
        } 
                        
        return array_merge((array)$resp_distance, array('delivery_fee' => $delivery_fee, 'min_order' => $min_order));
        
    } else {
        throw new Exception("Merchant not found");
    }
}


public function getDeliveryDetails($data = array())
{                                           
    $merchant_id = $data['merchant_id'];
    $delivery_fee = $data['delivery_charges'];
    $unit = $this->unit($data['unit']);      
    $mode = $data['provider']['mode'];      
    $merchant_delivery_distance = (float)$data['delivery_distance_covered'];        

    $resp_distance = $this->MapsWrapperTemp->getDistance(
        $data['from_lat'], 
        $data['from_lng'], 
        $data['to_lat'], 
        $data['to_lng'], 
        $unit, 
        $mode
    );

    if ($resp_distance) {         
        $distance = $resp_distance['distance'];         

        if ($merchant_delivery_distance > 0) {
            if ($distance > $merchant_delivery_distance) {                  
                $pretty_distance = $this->functions->translation(
                    "default", 
                    "Distance: " . $merchant_delivery_distance . " Unit" . $this->MapsWrapperTemp->prettyUnit($unit)
                );

                $error = $this->functions->translation(
                    "default", 
                    "Sorry but this merchant delivers only within " . $pretty_distance . 
                    ". Your current distance is " . $resp_distance['pretty_distance']
                );

                $resp_distance['distance_error'] = $error;
            } 
        }

        /* MINIMUM ORDER TABLE */
        $resp_distance['min_order'] = 0;
        $min_tables_enabled = $this->functions->getOption('min_tables_enabled', $merchant_id);         
        if ($min_tables_enabled == 1) {                                     
            $min_order = $this->getMinimumOrderTable(
                $merchant_id, 
                $resp_distance['distance'], 
                $resp_distance['unit'], 
                $data['minimum_order']
            ); 
            $resp_distance['min_order'] = $min_order;
        } else {
            $resp_distance['min_order'] = isset($data['minimum_order']) ? $data['minimum_order'] : 0;
        }

        /* SHIPPING FEE */
        $shipping_enabled = $this->functions->getOption('shipping_enabled', $merchant_id);
        if ($shipping_enabled == 2) {                   
            $delivery_fee = $this->getShippingFee(
                $merchant_id, 
                $resp_distance['distance'], 
                $resp_distance['unit'], 
                $delivery_fee
            );
        }       

        return array_merge((array)$resp_distance, array('delivery_fee' => $delivery_fee));
    }

    return array(); // Ensures the function always returns a value
}


public function getShippingFee($merchant_id = '', $distance = 0, $unit = '', $delivery_fee = 0)
{
    $_unit = ($unit == "M") ? "mi" : "km"; 
    $_fee = $delivery_fee;

    $stmt = $this->db->prepare("
        SELECT distance_from, distance_to, distance_price
        FROM mt_shipping_rate
        WHERE merchant_id = :merchant_id AND shipping_units = :shipping_units
        ORDER BY distance_from ASC
    ");
    
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':shipping_units' => $_unit
    ]);

    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        $last_record = [];
        $found = false;

        foreach ($resp as $val) {
            if ($val['distance_from'] <= $distance && $val['distance_to'] >= $distance) {
                $_fee = $val['distance_price'];
                $found = true;
            }
            $last_record = $val;
        }

        if (!$found && isset($last_record['distance_to']) && $distance > $last_record['distance_to']) {
            $_fee = $last_record['distance_price'];
        }
    }

    return $_fee;
}






public  function unit($unit='')
    {       
        $type='';
        $unit=strtolower($unit);        
        switch ($unit) {
            case "mi":
                $type="M";
                break;        
            case "km":  
                $type="K";
                break;
            default:
                $type="M";
                break;
        }
        return $type;
    }


 public function getMinimumOrderTable($merchant_id = '', $distance = 0, $unit = '', $min_fee = 0)
{
    $_unit = $unit == "M" ? "mi" : "km";
    $_fee = $min_fee;

    $stmt = $this->db->prepare("
        SELECT distance_from, distance_to, min_order 
        FROM mt_minimum_table 
        WHERE merchant_id = :merchant_id AND shipping_units = :shipping_units 
        ORDER BY distance_from ASC
    ");
    $stmt->execute([
        ':merchant_id' => $merchant_id,
        ':shipping_units' => $_unit
    ]);
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($resp) {
        $last_record = array();
        $found = false;
        foreach ($resp as $val) {
            if ($val['distance_from'] <= $distance && $val['distance_to'] >= $distance) {
                $_fee = $val['min_order'];
                $found = true;
            }
            $last_record = $val;
        }

        if ($found == false) {
            if ($distance > $last_record['distance_to']) {
                $_fee = $last_record['min_order'];
            }
        }
    }

    return $_fee;
}




  






	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/