<?php
class itemWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->mobileWrapper = new mobileWrapper();
        $this->sizes = array();

        $this->InventoryWrapper=new InventoryWrapper();

        $this->enabled_trans=false;
        
        //$this->CronWrapper = new CronWrapper();
        

    }


public function getMenu($merchant_id = '', $pagenumber = 0, $pagelimit = 10)
{   
    $paginate_total = 0;
    $menu_type = $this->mobileWrapper->getMenuType();
    $default_image = 'resto_banner.jpg';
    $disabled_default_image = false;
    
    if ($merchant_id > 0) {
        $this->sizes = $this->getSize($merchant_id);
        
        $todays_day = strtolower(date("l"));
        $and = '';

        $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id); 
        if ($enabled_category_sked == 1) {
            $and .= " AND $todays_day = '1' ";
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS *
            FROM mt_category
            WHERE merchant_id = $merchant_id
            AND status IN ('publish', 'published')
            AND web_available=2
            $and
            ORDER BY sequence, date_created ASC
            LIMIT $pagenumber, $pagelimit
        ";

        $query = $this->db->query($stmt);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $stmtc = "SELECT FOUND_ROWS() AS total_records";
            $queryc = $this->db->query($stmtc);
            $resp = $queryc->fetch(PDO::FETCH_ASSOC);
            $total_records = $resp['total_records'] ?? 0;

            $paginate_total = ceil($total_records / $pagelimit);
            $data = [];

            foreach ($res as $val) {
                $new_data = [
                    'cat_id' => $val['cat_id'],
                    'category_name' => $val['category_name'],
                    'category_description' => $val['category_description'],
                    'category_pic' => $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image),
                    'item' => []
                ];

                $item_data = $this->getItemByCategory($merchant_id, $val['cat_id'], false);
                $new_data['item'] = is_array($item_data['data']) ? $item_data['data'] : [];

                $data[] = $new_data;
            }

            return [
                'paginate_total' => $paginate_total,
                'list' => $data
            ];
        }
    }
    return false;
}


public function getsizes(){
   return $this->sizes;
}


public function setsizes($sizes){
    $this->sizes=($sizes);
}

public function getCategoryByID($cat_id = '')
{               
    if ($cat_id > 0) {      
        $stmt = "
            SELECT 
                cat_id,
                category_name,
                category_description,
                photo,
                status,
                category_name_trans,
                category_description_trans
            FROM mt_category
            WHERE cat_id = $cat_id
            AND status IN ('publish')
            LIMIT 1
        ";

        $query = $this->db->query($stmt);
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {            
            return $res;
        }           
    }
    return false;
}


public function getItemByCategory($merchant_id = '', $category_id = '', $paginate = false, 
    $pagenumber = 0, $pagelimit = 10, $filter_dishes = array()) 
{       
    $paginate_total = 0; 
    $limit = "LIMIT $pagenumber, $pagelimit";

    if ($merchant_id > 0 && $category_id > 0) {

        if (!$paginate) {
            $limit = '';
        }

        $and = '';

        $default_image = 'resto_banner.jpg';
        $disabled_default_image = false;

        $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
        if ($food_option_not_available == 1) {
            $and = "AND not_available <> '2' ";
        }

        if (!empty($filter_dishes)) {         
            $and .= " AND dish LIKE '%" . $filter_dishes . "%' ";
        }
                    
        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        item_id,
        merchant_id,
        item_name,
        item_description,
        item_name_trans,
        item_description_trans,
        status,
        price,
        photo,
        discount,
        dish
        FROM
        mt_item
        WHERE
        category LIKE '%" . $category_id . "%'
        AND
        status IN ('publish', 'published')
        AND merchant_id = " . $merchant_id . "
        $and
        ORDER BY sequence ASC
        $limit
        ";      

        /* Inventory */               
        if ($this->functions->inventoryEnabled($merchant_id)) {
            $and_inv = '';
            if (!empty($filter_dishes)) {         
                $and_inv .= " AND dish LIKE '%" . $filter_dishes . "%' ";
            }

            if ($this->InventoryWrapper->hideItemOutStocks($merchant_id)) {
                $stmt = "
                SELECT SQL_CALC_FOUND_ROWS 
                item_id,
                merchant_id,
                item_name,
                item_description,
                item_name_trans,
                item_description_trans,
                status,
                price,
                photo,
                discount,
                dish
                FROM
                mt_item a
                WHERE
                category LIKE '%" . $category_id . "%'
                AND
                status IN ('publish', 'published')
                AND merchant_id = " . $merchant_id . "
                $and_inv
                AND item_id IN (
                    SELECT item_id FROM mt_view_item_stocks_status
                    WHERE available = '1'
                    AND track_stock = '1'
                    AND stock_status NOT IN ('Out of stocks')     
                    AND item_id = a.item_id                 
                )       
                ORDER BY sequence ASC
                $limit
                ";          
            } else {                
                if ($food_option_not_available == 1) {
                    $stmt = "
                    SELECT SQL_CALC_FOUND_ROWS 
                    item_id,
                    merchant_id,
                    item_name,
                    item_description,
                    item_name_trans,
                    item_description_trans,
                    status,
                    price,
                    photo,
                    discount,
                    dish
                    FROM
                    mt_item a
                    WHERE
                    category LIKE '%" . $category_id . "%'
                    AND
                    status IN ('publish', 'published')
                    AND merchant_id = " . $merchant_id . "
                    $and_inv
                    AND item_id IN (
                        SELECT item_id FROM mt_view_item_stocks_status
                        WHERE available = '1'                        
                        AND item_id = a.item_id                 
                    )                               
                    ORDER BY sequence ASC
                    $limit
                    ";      
                }
            }           
        }
                
        $query = $this->db->query($stmt);
        if ($query) {
            $res = $query->fetchAll(PDO::FETCH_ASSOC);
            
            $total_records = 0;
            $stmtc = "SELECT FOUND_ROWS() as total_records";          
            $query_count = $this->db->query($stmtc);
            if ($query_count) {
                $resp = $query_count->fetch(PDO::FETCH_ASSOC);
                $total_records = $resp['total_records'];
            }       
            
            $paginate_total = ceil($total_records / $pagelimit);
            
            $data = array();
            foreach ($res as $val) {                
                $price = ''; 
                $prices = array(); 
                $prices2 = array(); 

                if (json_decode($val['price'])) {
                    $price = json_decode($val['price'], true);                   
                    foreach ($price as $size_id => $priceval) {
                        $original_price = $priceval;
                        $discounted_price = 0;
                        
                        if ($val['discount'] >= 0.001) {
                            $priceval = $priceval - $val['discount'];
                            $discounted_price = $priceval;
                        }                   

                        $self_sizes = $this->getsizes();    
                        if (array_key_exists($size_id, (array)$self_sizes)) {
                            $prices[] = $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval);
                            $prices2[] = array(                           
                                'original_price' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval),
                            );
                        } else {                            
                            $prices[] = $this->functions->prettyPrice($priceval);      
                            $prices2[] = array(                           
                                'original_price' => $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $this->functions->prettyPrice($priceval),
                            );
                        }
                    }                   
                } 

                $val['photo'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);                        
                $val['item_description'] = $val['item_description'];              
                
                $val['prices'] = $prices;
                $val['prices2'] = $prices2;
                $val['cat_id'] = $category_id;
                
                $icon_dish = array();
                if (!empty($val['dish'])) {               
                    $icon_dish = $this->functions->getDishIcon($val['dish']);
                } else {
                    $icon_dish = '';
                }
                
                $val['dish_image'] = $icon_dish;
                
                $data[] = $val;
            }
            
            return array(
                'data' => $data,
                'paginate_total' => $paginate_total
            );
        }
    }
    return false;           
}


public function getItemByCategory_promotions($merchant_id = '', $min = '', $paginate = false, 
    $pagenumber = 0, $pagelimit = 10, $filter_dishes = array()) 
{       
    $ands = ' '; 
    $check_expiry = date("Y-m-d");
    $ands = ' AND expiration >= :check_expiry'; 

    $paginate_total = 0; 
    $promo_ids = 0;
    $toals_num = 0;

    $stmt = "SELECT * FROM mt_promotions WHERE min_order <= :min_order AND merchant_id = :merchant_id $ands 
             ORDER BY min_order DESC LIMIT 0,1";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':min_order' => $min,
        ':merchant_id' => $merchant_id,
        ':check_expiry' => $check_expiry
    ]);

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {          
        $promo_ids = $res[0]['id'];
        $items = $res[0]['item_id'];
        $toals_num = $res[0]['totals'];

        $args = json_decode($items, true);
        $items_idss = '0';

        if (is_array($args) && count($args) >= 1) {
            $items_idss = implode(',', $args);
        }

        if ($merchant_id > 0) {
            $and = '';
            $default_image = 'resto_banner.jpg';
            $disabled_default_image = false;

            $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
            if ($food_option_not_available == 1) {
                $and = "AND not_available <> '2' ";
            }

            if (!empty($filter_dishes)) {         
                $and .= " AND dish LIKE :filter_dishes ";
            }

            $stmt = "
            SELECT SQL_CALC_FOUND_ROWS 
            item_id,
            merchant_id,
            item_name,
            item_description,
            item_name_trans,
            item_description_trans,
            status,
            price,
            photo,
            discount,
            dish
            FROM mt_item
            WHERE item_id IN ($items_idss)
            AND status IN ('publish','published')
            AND merchant_id = :merchant_id
            $and
            ORDER BY sequence ASC";

            $query = $this->db->prepare($stmt);
            $params = [':merchant_id' => $merchant_id];
            if (!empty($filter_dishes)) {
                $params[':filter_dishes'] = "%{$filter_dishes}%";
            }
            $query->execute($params);

            if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
                $total_records = 0;
                $stmtc = "SELECT FOUND_ROWS() as total_records";
                $queryc = $this->db->prepare($stmtc);
                $queryc->execute();
                if ($resp = $queryc->fetch(PDO::FETCH_ASSOC)) {
                    $total_records = $resp['total_records'];
                }       
                
                $paginate_total = ceil($total_records / $pagelimit);
                $data = [];

                foreach ($res as $val) {                
                    $price = '';
                    $prices = [];
                    $prices2 = [];

                    if (json_decode($val['price'])) {
                        $price = json_decode($val['price'], true);
                        foreach ($price as $size_id => $priceval) {
                            $original_price = $priceval;
                            $discounted_price = 0;

                            if ($val['discount'] >= 0.001) {
                                $priceval -= $val['discount'];
                                $discounted_price = $priceval;
                            }                   

                            $self_sizes = $this->getsizes();    
                            if (array_key_exists($size_id, (array) $self_sizes)) {
                                $prices[] = $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval);
                                $prices2[] = [
                                    'original_price' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($original_price),
                                    'discount' => $val['discount'],
                                    'discounted_price_pretty' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval),
                                ];
                            } else {                            
                                $prices[] = $this->functions->prettyPrice($priceval);      
                                $prices2[] = [
                                    'original_price' => $this->functions->prettyPrice($original_price),
                                    'discount' => $val['discount'],
                                    'discounted_price_pretty' => $this->functions->prettyPrice($priceval),
                                ];
                            }
                        }                   
                    } 
                    
                    $val['photo'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);                        
                    $val['item_description'] = $val['item_description'];              
                    
                    $val['prices'] = $prices;
                    $val['prices2'] = $prices2;
                    $val['cat_id'] = $category_id;
                    
                    $val['promo_ids'] = $promo_ids;
                    $val['totals'] = $toals_num;
                    $val['item_already'] = 0; 
                    $val['item_added_total'] = 0;
                    
                    $icon_dish = [];
                    if (!empty($val['dish'])) {               
                        $icon_dish = $this->functions->getDishIcon($val['dish']);
                    }

                    $val['dish_image'] = $icon_dish;
                    $data[] = $val;
                }

                return [
                    'data' => $data,
                    'paginate_total' => $paginate_total
                ];
            }
        }
    }
    return false;
}


public function getItemByCategory_promo_checks($merchant_id = '', $min = '', $getthepromolist_id = '') 
{
    $stmt = "SELECT * FROM mt_promotions 
             WHERE id = :getthepromolist_id 
             AND min_order <= :min 
             AND merchant_id = :merchant_id 
             LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':getthepromolist_id' => $getthepromolist_id,
        ':min' => $min,
        ':merchant_id' => $merchant_id
    ]);

    return ($query->fetch(PDO::FETCH_ASSOC)) ? 1 : 0;
}


public function getItemByCategory_promo_byid($merchant_id = '', $min = '', $prpmo_items = array(), $paginate = false, 
    $pagenumber = 0, $pagelimit = 10, $filter_dishes = array()) 
{       
    $paginate_total = 0; 
    $promo_ids = 0;
    $toals_num = 0;

    $stmt = "SELECT * FROM mt_promotions WHERE id = :min AND merchant_id = :merchant_id ORDER BY min_order DESC LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':min' => $min,
        ':merchant_id' => $merchant_id
    ]);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    $args = '';
    $items_idss = '0';

    if ($res) {          
        $promo_ids = $res[0]['id'];
        $items = $res[0]['item_id'];
        $toals_num = $res[0]['totals'];
        $args = json_decode($items, true);
        
        if (is_array($args) && count((array) $args) >= 1) {
            $args11 = '';
            foreach ($args as $args_key => $args_val) {
                $args11 .= $args_val . ',';
            }
            $items_idss = substr_replace($args11, "", -1);
        }
    }
    
    if ($merchant_id > 0) {
        $limit = '';
        $and = '';
        $default_image = 'resto_banner.jpg';
        $disabled_default_image = false;

        $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
        if ($food_option_not_available == 1) {
            $and = "AND not_available <> '2' ";
        }

        if (!empty($filter_dishes)) {         
            $and .= " AND dish LIKE :filter_dishes ";
        }

        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        item_id,
        merchant_id,
        item_name,
        item_description,
        item_name_trans,
        item_description_trans,
        status,
        price,
        photo,
        discount,
        dish
        FROM mt_item
        WHERE item_id IN ($items_idss)
        AND status IN ('publish', 'published')
        AND merchant_id = :merchant_id
        $and
        ORDER BY sequence ASC";

        $query = $this->db->prepare($stmt);
        $params = [':merchant_id' => $merchant_id];

        if (!empty($filter_dishes)) {
            $params[':filter_dishes'] = "%{$filter_dishes}%";
        }

        $query->execute($params);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $query = $this->db->prepare($stmtc);
            $query->execute();
            $resp = $query->fetch(PDO::FETCH_ASSOC);
            $total_records = $resp['total_records'] ?? 0;

            $paginate_total = ceil($total_records / $pagelimit);
            $tem_added = 0;
            $data = [];

            foreach ($res as $val) {                
                $price = ''; 
                $prices = [];
                $prices2 = [];

                if (json_decode($val['price'])) {
                    $price = json_decode($val['price'], true);                   

                    foreach ($price as $size_id => $priceval) {
                        $original_price = $priceval;
                        $discounted_price = 0;

                        if ($val['discount'] >= 0.001) {
                            $priceval = $priceval - $val['discount'];
                            $discounted_price = $priceval;
                        } 

                        $self_sizes = $this->getsizes();

                        if (array_key_exists($size_id, (array) $self_sizes)) {
                            $prices[] = $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval);
                            $prices2[] = [
                                'original_price' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $self_sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval),
                            ];
                        } else {                            
                            $prices[] = $this->functions->prettyPrice($priceval);
                            $prices2[] = [
                                'original_price' => $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $this->functions->prettyPrice($priceval),
                            ];
                        }
                    }                   
                }

                $val['photo'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);                        
                $val['item_description'] = $val['item_description'];              
                
                $val['prices'] = $prices;
                $val['prices2'] = $prices2;
                $val['totals'] = $toals_num;
                $val['promo_ids'] = $promo_ids;

                $val['item_already'] = in_array($val['item_id'], $prpmo_items) ? 1 : 0;
                if ($val['item_already']) $tem_added++;

                $val['item_added_total'] = $tem_added;

                $icon_dish = !empty($val['dish']) ? $this->functions->getDishIcon($val['dish']) : '';
                $val['dish_image'] = $icon_dish;

                $data[] = $val;
            }

            return [
                'data' => $data,
                'paginate_total' => $paginate_total
            ];
        }
    }
    return false;           
}


public function getSize($merchant_id = '') {       
    $stmt = "SELECT 
                size_id,
                size_name,
                size_name_trans
             FROM
                mt_size
             WHERE
                merchant_id = :merchant_id
                AND status IN ('publish')";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {           
            $data[$val['size_id']] = $val['size_name'];
        }
        return $data;
    }
    return false;
}

public function searchItemByName($merchant_id = '', $item_name = '') {   
    if ($merchant_id > 0 && !empty($item_name)) {       
        $stmt = "
            SELECT 
                item_id,
                merchant_id,
                item_name,
                category,
                item_name_trans,
                item_description,
                item_description_trans,
                photo
            FROM mt_item
            WHERE merchant_id = :merchant_id
            AND item_name LIKE :item_name
            AND not_available <> '2'
            ORDER BY item_name ASC
            LIMIT 100
        ";  

        $query = $this->db->prepare($stmt);
        $item_name = "%$item_name%"; // Add wildcard for LIKE
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':item_name', $item_name, PDO::PARAM_STR);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}

public function searchByCategoryByName($merchant_id = '', $category_name = '') {
    if ($merchant_id > 0 && !empty($category_name)) {       
        $todays_day = strtolower(date("l"));                        
        $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id); 
        
        $and = "";
        if ($enabled_category_sked == 1) {
            $and .= " AND $todays_day = '1' ";
        }                   
        
        $stmt = "
            SELECT 
                cat_id,
                merchant_id,
                category_name,
                category_description,
                photo,
                status,
                category_name_trans,
                category_description_trans          
            FROM mt_category
            WHERE merchant_id = :merchant_id
            $and        
            AND (category_name LIKE :category_name OR 
                 category_description LIKE :category_description)           
            ORDER BY category_name ASC
        ";                  

        $query = $this->db->prepare($stmt);
        $category_name = "%$category_name%"; // Add wildcard for LIKE
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':category_name', $category_name, PDO::PARAM_STR);
        $query->bindParam(':category_description', $category_name, PDO::PARAM_STR); // Same value as category_name
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}


public function dishesList() {
    $data = [];
    
    $stmt = "
        SELECT 
            dish_id, dish_name
        FROM mt_dishes
        WHERE status = 'publish'
        ORDER BY dish_id ASC
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();
    
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $data[] = [
                'dish_id'   => $val['dish_id'],
                'dish_name' => $val['dish_name'],
            ];
        }
    }

    return $data;
}

    
    public function getItemCountByCategory($category_id = '') {
    $stmt = "
        SELECT COUNT(*) AS total
        FROM mt_item
        WHERE category LIKE :category_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':category_id' => "%$category_id%"]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res['total'];
    }

    return 0;
}

    
    public  function limitText($p='',$text='', $limit = 100)
    {
        return $text;
        
    }


   








	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/