<?php
$merchant_id=$this->functions->getMerchantID();
$disable_google_reservations=$this->functions->getOption("disable_google_reservations",$merchant_id);
$booking_confirmation_mode=$this->functions->getOption("booking_confirmation_mode",$merchant_id);

//echo $booking_confirmation_mode;die();

?>

<h3><?php echo $this->functions->translation("default","Booking Settings")?></h3>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="bookingSettings">





<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "No of slots") ?>
  </label>  
  <input 
    type="number" 
    name="number_of_slots" 
    id="number_of_slots" 
    value="<?php echo $this->functions->getOption('number_of_slots',$merchant_id) ?>" 
    class="numeric_only" 

    min="1" required>
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Persons/Party") ?>
  </label>  
  <input 
    type="number" 
    name="party_size" 
    id="party_size" 
    value="<?php echo $this->functions->getOption('party_size', $merchant_id) ?>" 
    class="numeric_only"
    min="1" 
    max="10" required
  >
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Choose Duration") ?></label>
    <select name="google_merchant_duration">
        <option value="1800" <?php echo $this->functions->getOption( 'google_merchant_duration',$merchant_id) == 1800 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "30 minutes") ?>
        </option>
        <option value="3600" <?php echo $this->functions->getOption( 'google_merchant_duration',$merchant_id) == 3600 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "60 minutes") ?>
        </option>
    </select>
</div>


<div class="uk-form-row" style="display:none"> 
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Choose Booking Confirmation Mode") ?></label>
    <select name="booking_confirmation_mode">
        <option value="confirmed" <?php echo $this->functions->getOption( 'booking_confirmation_mode',$merchant_id) == "confirmed" ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "Confirmed") ?>
        </option>
        <option value="pending" <?php echo $this->functions->getOption( 'booking_confirmation_mode',$merchant_id) == "pending" ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "Pending") ?>
        </option>
    </select>
</div>


<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>