

<?php
session_start(); // Start the session if not already started

$rates = $_SESSION['exchange_rate'] ?? null;
$yii_session_token = session_id();



?>

<form method="post" class="uk-form uk-form-horizontal" onsubmit="return false;">
    <input type="hidden" name="yii_session_token" id="yii_session_token" value="<?php echo htmlspecialchars($yii_session_token, ENT_QUOTES, 'UTF-8'); ?>">



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Free delivery above Sub Total Order"); ?></label>
  
  <input type="text" name="free_delivery_above_price" 
         value="<?php echo htmlspecialchars($this->functions->getOption("free_delivery_above_price", $mtid), ENT_QUOTES, 'UTF-8'); ?>" 
         class="numeric_only">
  
  <span style="padding-left:8px;"><?php echo isset($rates['base_currency']) ? $rates['base_currency'] : ''; ?></span>
</div>

<div class="spacer"></div>

<button type="button" id="save" class="uk-button uk-form-width-medium uk-button-success">
    <?php echo $this->functions->translation("default",'Save Settings'); ?>
</button>

</form>







<h3><?php echo $this->functions->translation("default","Delivery Rates Table")?></h3>

<a href="javascript:;" class="uk-button uk-button-success add-new-rates">
<i class="fa fa-plus"></i>
<?php echo $this->functions->translation("default","Add new")?>
</a>

<p class="uk-text-muted">
(<?php echo $this->functions->translation("default","drag the list to sort")?>)
</p>

<table id="location_table_rates" class="uk-table uk-table-hover uk-table-striped uk-table-condensed">
<thead>
  <tr>
   <th width="6%"><?php echo $this->functions->translation("default","Country")?></th>   
   <th width="5%"><?php echo $this->functions->translation("default","State/Region")?></th>   
   <th width="5%"><?php echo $this->functions->translation("default","City")?></th>
   <th width="5%"><?php echo $this->functions->translation("default","Distric/Area/neighborhood")?></th>
   <th width="5%"><?php echo $this->functions->translation("default","Postal Code/Zip Code")?></th>
   <th width="5%"><?php echo $this->functions->translation("default","Fee")?></th>
   <th width="5%"><?php echo $this->functions->translation("default","Min. Order")?></th>
   <th width="5%"><?php echo $this->functions->translation("default","Free delivery above sub total")?></th>
  </tr>
</thead>
<tbody class="location_table_rates">
</tbody>
</table>


<script>
document.getElementById('save').addEventListener('click', function() {
    var formData = new FormData();
    formData.append('free_delivery_above_price', document.querySelector('[name="free_delivery_above_price"]').value);
    
    fetch('/ajaxadmin/freeDeliverySettings', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.code == 1) {
            uk_msg(data.msg);
        } else {
            uk_msg(data.msg);
        }
    })
    .catch(error => {
        uk_msg("response failed");
    });
});
</script>