<?php
$kr_search_adrress = $this->functions->getSessionAddress();

$home_search_text= $this->functions->getOptionAdmin('home_search_text');
if (empty($home_search_text)){
	$home_search_text=$this->functions->translation("default","Find restaurants near you");
}

$home_search_subtext=$this->functions->getOptionAdmin('home_search_subtext');
if (empty($home_search_subtext)){
	$home_search_subtext=$this->functions->translation("default","Order Delivery Food Online From Local Restaurants");
}

$home_search_mode=$this->functions->getOptionAdmin('home_search_mode');
$placholder_search=$this->functions->translation("default","Street Address,City,State");
if ( $home_search_mode=="postcode" ){
	$placholder_search=$this->functions->translation("default","Enter your postcode");
}
$placholder_search=$this->functions->translation("default",$placholder_search);
?>

<?php if ( $home_search_mode=="address" || $home_search_mode=="") :?>
<img class="mobile-home-banner" src="<?php echo $this->functions->assetsURL()."/images/banner.jpg"?>">

<div id="parallax-wrap" class="parallax-container parallax-home" 
data-parallax="scroll" data-position="top" data-bleed="10" 
data-image-src="<?php echo $this->functions->assetsURL()."/images/banner.jpg"?>">
<?php 
if ( $enabled_advance_search=="yes"){
	

  require __DIR__ . '/advance_search.php'; 

} else  require __DIR__ . '/single_search.php'; 
?>
</div> <!--parallax-container-->
<?php else :?>

<!--SEARCH USING LOCATION-->
<img class="mobile-home-banner" src="<?php echo $this->functions->assetsURL()."/images/b6.jpg"?>">

<div id="parallax-wrap" class="parallax-container parallax-home" 
data-parallax="scroll" data-position="top" data-bleed="10" 
data-image-src="<?php echo $this->functions->assetsURL()."/images/b6.jpg"?>">

  <?php   
  $location_type=$this->functions->getOptionAdmin("admin_zipcode_searchtype"); 

 
  require __DIR__ . "/location-search-".$location_type.".php"; 
  ?>

</div> <!--parallax-container-->

<?php endif;?>

<?php if ($theme_hide_how_works<>2):?>
<!--HOW IT WORKS SECTIONS-->
<div class="sections section-how-it-works">
<div class="container">
 <h2><?php echo $this->functions->translation("default","How it works")?></h2>
 <p class="center"><?php echo $this->functions->translation("default","Get your favourite food in 4 simple steps")?></p>
 
 <div class="row">
   <div class="col-md-3 col-sm-3 center">
      <div class="steps step1-icon">
        <img src="<?php echo $this->functions->assetsURL()."/images/step1.png"?>">
      </div>
      <h3><?php echo $this->functions->translation("default","Search")?></h3>
      <p><?php echo $this->functions->translation("default","Find all restaurants available near you")?></p>
   </div>
   <div class="col-md-3 col-sm-3 center">
      <div class="steps step2-icon">
         <img src="<?php echo $this->functions->assetsURL()."/images/step2.png"?>">
      </div>
      <h3><?php echo $this->functions->translation("default","Choose")?></h3>
      <p><?php echo $this->functions->translation("default","Browse hundreds of menus to find the food you like")?></p>
   </div>
   <div class="col-md-3 col-sm-3  center">
      <div class="steps step2-icon">
        <img src="<?php echo $this->functions->assetsURL()."/images/step3.png"?>">
      </div>
      <h3><?php echo $this->functions->translation("default","Pay")?></h3>
      <p><?php echo $this->functions->translation("default","It's quick, secure and easy")?></p>
   </div>
   <div class="col-md-3 col-sm-3  center">
     <div class="steps step2-icon">
       <img src="<?php echo $this->functions->assetsURL()."/images/step4.png"?>">
     </div>
      <h3><?php echo $this->functions->translation("default","Enjoy")?></h3>
      <p><?php echo $this->functions->translation("default","Food is prepared & delivered to your door")?></p>
   </div>   
 </div>

 </div> <!--container-->
</div> <!--section-how-it-works-->
<?php endif;?>


<!--FEATURED RESTAURANT SECIONS-->
<?php if ($disabled_featured_merchant==""):?>
<?php if ( $this->functions->getOptionAdmin('disabled_featured_merchant')!="yes"):?>
<?php if ($res=$this->functions->getFeatureMerchant()):?>
<div class="sections section-feature-resto">
  <div class="container">
    <?php $cuisine_list=$this->functions->Cuisine(true);?>

    <h2><?php echo $this->functions->translation("default","Featured Restaurants")?></h2>
  
    <div class="row">
      <?php foreach ($res as $val): ?>
        <?php
          $address = $val['street'] . " " . $val['city'] . " " . $val['state'] . " " . $val['post_code'];
          $ratings = $this->functions->getRatings($val['merchant_id']);
        ?>
    
        <div class="col-lg-3 col-md-4 col-sm-6 col-12 restaurant-item">
          <div class="restaurant-card">
              <!-- Open Badge -->
              <div class="open-badge">
                <?php echo $this->functions->merchantOpenTag($val['merchant_id']); ?>
              </div>
            
              <!-- Restaurant Image -->
              <a href="<?php echo Config::$baseUrl; ?>/menu/<?php echo trim($val['restaurant_slug']); ?>" class="logo-link">
                <img class="restaurant-bg" src="<?php echo $this->functions->getMerchantbg($val['merchant_id'], $val['background']); ?>" alt="Restaurant Logo">
              </a>
            
              <div class="restaurant-details">
                <div class="row justify-content-between align-items-center">
                  <!-- Ratings -->
                  <div class="rating-stars" data-score="<?php echo $ratings['ratings']; ?>"></div>
                
                  <!-- Add to Favorites -->
                  <div class="favorites-btn">
                    <a href="javascript:;" data-id="<?php echo $val['merchant_id']; ?>" class="add_favorites <?php echo "fav_" . $val['merchant_id']; ?>" title="<?php echo $this->functions->translation("default", "add to your favorite restaurant"); ?>">
                      <i class="ion-android-favorite-outline"></i> Add to Favorites
                    </a>
                  </div>
                </div>
                <!-- Restaurant Name -->
                <a href="<?php echo Config::$baseUrl; ?>/menu/<?php echo trim($val['restaurant_slug']); ?>">
                  <h4 class="restaurant-name"><?php echo $this->functions->clearString($val['restaurant_name']); ?></h4>
                </a>
            
                <!-- Cuisine -->
                <p class="restaurant-cuisine"><?php echo $this->functions->displayCuisine($val['cuisine'], $cuisine_list); ?></p>
                
                <!-- Address -->
                <p class="restaurant-address"><?php echo $address; ?></p>
            
                <!-- Services -->
                <?php echo $this->functions->displayServicesList($val['service']); ?>
              </div>
            </div>
        </div> <!-- End of Restaurant Item -->

      <?php endforeach; ?>
    </div> <!-- End of Row -->
  </div> <!-- End of Container -->
</div> <!-- End of Section -->

<?php endif;?>
<?php endif;?>
<?php endif;?>
<!--END FEATURED RESTAURANT SECIONS-->


<?php if ($theme_hide_cuisine<>2):?>
<!--CUISINE SECTIONS-->
<?php if ( $list=$this->functions->getCuisiness() ): ?>
<div class="sections section-cuisine">
  <div class="container">
    <div class="row align-items-center">
      <!-- Left Image Section -->
      <div class="col-md-4">
        <img src="<?php echo $this->functions->assetsURL()."/images/cuisine.png"?>" class="img-cuisine" alt="Cuisine Image">
      </div>

      <!-- Right Content Section -->
      <div class="col-md-8">
        <h2 class="section-title"><?php echo $this->functions->translation("default","Browse by cuisine")?></h2>
        <p class="sub-text"><?php echo $this->functions->translation("default","Choose from your favorite cuisine")?></p>
        
        <div class="row">
          <?php $x = 1; ?>
          <?php foreach ($list as $val): 
            $slug = isset($val['slug']) ? $val['slug'] : '';
          ?>
            <div class="col-md-4 col-sm-6 cuisine-item">
              <a href="<?php echo Config::$baseUrl; ?>/cuisine/<?php echo $slug; ?>" 
                 class="cuisine-link <?php echo ($x % 2) ? "even" : 'odd' ?>">
                <?php 
                  $cuisine_json['cuisine_name_trans'] = !empty($val['cuisine_name_trans']) ? json_decode($val['cuisine_name_trans'], true) : '';     
                  echo $this->functions->qTranslate($val['cuisine_name'], 'cuisine_name', $cuisine_json);
                  if ($val['total'] > 0) {
                    echo "<span class='total-count'>(" . $val['total'] . ")</span>";
                  }
                ?>
              </a>
            </div>   
          <?php $x++; ?>
          <?php endforeach; ?>
        </div> 
      </div>
    </div>
  </div>
</div>

<?php endif;?>
<?php endif;?>


<?php if ($theme_show_app==2):?>
<!--MOBILE APP SECTION-->
<div id="mobile-app-sections" class="container">
<div class="container-medium">
  <div class="row">
     <div class="col-xs-5 into-row border app-image-wrap">
       <img class="app-phone" src="<?php echo $this->functions->assetsURL()."/images/getapp-2.jpg"?>">
     </div> <!--col-->
     <div class="col-xs-7 into-row border">
       <h2><?php echo $this->functions->getOptionAdmin('website_title')." "."in your mobile"?>! </h2>
       <h3 class="green-text"><?php echo $this->functions->translation("default","Get our app, it's the fastest way to order food on the go")?>.</h3>
       
       <div class="row border" id="getapp-wrap">
       <?php if(!empty($theme_app_ios) && $theme_app_ios!="http://"):?>
         <div class="col-xs-4 border">                      
           <a href="<?php echo $theme_app_ios?>" target="_blank">
           <img class="get-app" src="<?php echo $this->functions->assetsURL()."/images/get-app-store.png"?>">
           </a>           
         </div>
         <?php endif;?>
         
         <?php if(!empty($theme_app_android) && $theme_app_android!="http://"):?>
         <div class="col-xs-4 border">
           <a href="<?php echo $theme_app_android?>" target="_blank">
             <img class="get-app" src="<?php echo $this->functions->assetsURL()."/images/get-google-play.png"?>">
           </a>
         </div>
         <?php endif;?>
         
       </div> <!--row-->
       
     </div> <!--col-->
  </div> <!--row-->
  </div> <!--container-medium-->
  
  <div class="mytable border" id="getapp-wrap2">
     <?php if(!empty($theme_app_ios) && $theme_app_ios!="http://"):?>
     <div class="mycol border">
           <a href="<?php echo $theme_app_ios?>" target="_blank">
           <img class="get-app" src="<?php echo $this->functions->assetsURL()."/images/get-app-store.png"?>">
           </a>
     </div> <!--col-->
     <?php endif;?>
     <?php if(!empty($theme_app_android) && $theme_app_android!="http://"):?>
     <div class="mycol border">
          <a href="<?php echo $theme_app_android?>" target="_blank">
             <img class="get-app" src="<?php echo $this->functions->assetsURL()."/images/get-google-play.png"?>">
           </a>
     </div> <!--col-->
     <?php endif;?>
  </div> <!--mytable-->
  
  
</div> <!--container-->
<!--END MOBILE APP SECTION-->
<?php endif;?>


 