<?php
class MerchantUserWrapper
{

    public function __construct() {
         $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
        $this->functions = new Functions(); // Create an instance of Functions
       
   
        

    }

 public function login_x($username = '', $password = '')
{
    $stmt = "
        SELECT  
            a.id, a.merchant_id, a.user_type, a.email_address, a.username, a.password, a.session_token, a.status,  
            a.user_access, a.contact_number, a.pin, b.merchant_print, b.merchant_print_customreceipt_after_accept,  
            b.restaurant_name     
        FROM mt_view_user_master a 
        LEFT JOIN mt_merchant b  
        ON a.merchant_id = b.merchant_id 
        WHERE a.username = :username     
        AND user_type IN ('merchant_user', 'merchant') 
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':username' => $username]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($res['status'] != "active") {
            throw new Exception("Your account is no longer active");
        } elseif ($res['password'] != md5($password)) {
            throw new Exception("Password is incorrect");
        } else {
            $token = $res['session_token'];
            if (empty($token)) {
                $token = $this->generateTokens($res['id']);
                $this->updateUserToken($res['id'], $res['user_type'], $token);
            }

            $logo = $this->functions->getOption('merchant_photo', $res['merchant_id']);
            return [
                'id' => $res['id'],
                'merchant_id' => $res['merchant_id'],
                'merchant_token' => $token,
                'restaurant_name' => $res['restaurant_name'],
                'user_type' => $res['user_type'],
                'user_access' => !empty($res['user_access']) ? $res['user_access'] : '[]',
                'username' => $res['username'],
                'email_address' => $res['email_address'],
                'contact_number' => $res['contact_number'],
                'pin' => $res['pin'],
                /* custom codes 9 Starts */  
                'merchant_print' => $res['merchant_print'],
                'merchant_print_customreceipt_after_accept' => $res['merchant_print_customreceipt_after_accept'],
                /* custom code 9 Ends */
                'merchant_photo' => $this->functions->getImage($logo, 'chef.svg')
            ];
        }
    }
    throw new Exception("Either username or password is invalid");
}


public function login($username = '', $password = '')
{
    $username = trim($username); // Sanitize inputs minimally
    /*$stmt = "
        SELECT  
            a.id, a.merchant_id, a.user_type, a.email_address, a.username, a.password, a.session_token, a.status,  
            a.user_access, a.contact_number, a.pin, b.merchant_print, b.merchant_print_customreceipt_after_accept,  
            b.restaurant_name     
        FROM mt_view_user_master a 
        LEFT JOIN mt_merchant b  
        ON a.merchant_id = b.merchant_id 
        WHERE a.username = '$username'     
        AND user_type IN ('merchant_user', 'merchant') 
        LIMIT 1
    ";*/

    $stmt = "
    SELECT  
        a.id, a.merchant_id, a.user_type, a.email_address, a.username, a.password, a.session_token, a.status,  
        a.user_access, a.contact_number, a.pin, b.merchant_print, b.merchant_print_customreceipt_after_accept,  
        b.restaurant_name     
    FROM mt_view_user_master a 
    LEFT JOIN mt_merchant b  
    ON a.merchant_id = b.merchant_id 
    WHERE a.username = '$username'     
    AND a.user_type  IN ('merchant_user', 'merchant') 
    LIMIT 1
";



    $query = $this->db->query($stmt);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($res['status'] != "active") {
            throw new Exception("Your account is no longer active");
        } elseif ($res['password'] != md5($password)) {
            throw new Exception("Password is incorrect");
        } else {
            $token = $res['session_token'];
            if (empty($token)) {
                $token = $this->generateTokens($res['id']);
                $this->updateUserToken($res['id'], $res['user_type'], $token);
            }

            $logo = $this->functions->getOption('merchant_photo', $res['merchant_id']);
            return [
                'id' => $res['id'],
                'merchant_id' => $res['merchant_id'],
                'merchant_token' => $token,
                'restaurant_name' => $res['restaurant_name'],
                'user_type' => $res['user_type'],
                'user_access' => !empty($res['user_access']) ? $res['user_access'] : '[]',
                'username' => $res['username'],
                'email_address' => $res['email_address'],
                'contact_number' => $res['contact_number'],
                'pin' => $res['pin'],
                'merchant_print' => $res['merchant_print'],
                'merchant_print_customreceipt_after_accept' => $res['merchant_print_customreceipt_after_accept'],
                'merchant_photo' => $this->functions->getImage($logo, 'chef.svg')
            ];
        }
    }
    throw new Exception("Either username or password is invalid");
}




public function generateTokens($id = '')
{
    $token = $this->generateToken($id);
    $stmt = "SELECT session_token FROM mt_view_user_master
             WHERE session_token = :token
             LIMIT 1";
             
    $query = $this->db->prepare($stmt);
    $query->execute([':token' => $token]);
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $this->generateTokens($id);
    }

    return $token;
}

  
  public function generateToken($id = '')
{   
    $agent = md5($id . $_SERVER['HTTP_USER_AGENT']);    
    return sha1(uniqid(mt_rand(), true)) . $agent;
}

  
  public  function updateUserToken($id='', $user_type='', $token='')
  {
    if($user_type=="merchant"){

      

      $params = array(
        'mobile_session_token'=>$token,
        'last_login'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
      $this->functions->updateData("mt_merchant", $params, 'merchant_id', $id);





    } elseif ( $user_type=="merchant_user"){
      


       $params = array(
         'mobile_session_token'=>$token,
        'last_login'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
      $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', $id);
    }   


  }



    public function validateToken($token = '')
{
    $token = trim($token);
    if (empty($token)) {
        throw new Exception("Session token not valid");
    }

    $stmt = " 
    SELECT  
    a.id, a.merchant_id, a.user_type, a.email_address, a.username, a.password, a.session_token, a.status,  
    a.user_access, a.contact_number, a.pin, b.merchant_print, b.merchant_print_customreceipt_after_accept,
    b.restaurant_name,  
    (   
     select option_value from mt_option 
     where merchant_id = a.merchant_id  
     and option_name = 'merchant_timezone'  
     limit 0,1  
    ) as timezone, 
    (   
     select option_value from mt_option  
     where merchant_id = a.merchant_id  
     and option_name = 'merchant_photo' 
     limit 0,1  
    ) as merchant_photo   
    FROM mt_view_user_master a 
    LEFT JOIN mt_merchant b  
    ON a.merchant_id = b.merchant_id 
    WHERE a.session_token = " . $this->db->quote($token) . "
    AND a.status = 'active'  
    
    AND a.user_type  IN ('merchant_user','merchant')
    LIMIT 0,1 
    ";
    //AND user_type IN ('merchant_user','merchant') 

    $query = $this->db->query($stmt);
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        if (!empty($res['timezone'])) {
            date_default_timezone_set($res['timezone']);
        }

        return array(
            'merchant_id' => $res['merchant_id'],
            'id' => $res['id'],
            'merchant_token' => $token,
            'restaurant_name' => $res['restaurant_name'],
            'user_type' => $res['user_type'],
            'user_access' => !empty($res['user_access']) ? $res['user_access'] : '[]',
            'username' => $res['username'],
            'email_address' => $res['email_address'],
            'contact_number' => $res['contact_number'],
            'pin' => $res['pin'],
            'merchant_print' => $res['merchant_print'],
            'merchant_print_customreceipt_after_accept' => $res['merchant_print_customreceipt_after_accept'],
            'merchant_photo' => $this->functions->getImage($res['merchant_photo'], 'chef.svg')
        );
    }

    throw new Exception("Session token not valid");
}



public function validatePin($token = '', $pin = '')
{
    // Prepare the SQL statement with placeholders for the token and pin
    $stmt = "SELECT merchant_id, pin 
             FROM mt_view_user_master 
             WHERE session_token = :token 
             AND pin = :pin
             LIMIT 0, 1";
    
    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameters to the placeholders
    $query->bindParam(':token', $token, PDO::PARAM_STR);
    $query->bindParam(':pin', $pin, PDO::PARAM_STR);
    
    // Execute the query
    if ($query->execute()) {
        // Fetch the result as an associative array
        $res = $query->fetch(PDO::FETCH_ASSOC);
        
        if ($res) {
            return $res;
        }
    }
    
    // If no result is found, throw an exception
    throw new Exception("Invalid PIN");
}

  
 public function getUserByEmail($email_address = '')
{
    if (!empty($email_address)) {
        // Prepare the SQL statement with a placeholder for the email address
        $stmt = "
            SELECT a.id, a.merchant_id, a.user_type, a.email_address, a.lost_password_code, a.pin,
                   a.status, b.restaurant_name
            FROM mt_view_user_master a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            WHERE a.email_address = :email_address
            LIMIT 0, 1
        ";
        
        // Prepare the query
        $query = $this->db->prepare($stmt);
        
        // Bind the email address parameter to the placeholder
        $query->bindParam(':email_address', $email_address, PDO::PARAM_STR);
        
        // Execute the query
        if ($query->execute()) {
            // Fetch the result as an associative array
            $res = $query->fetch(PDO::FETCH_ASSOC);
            
            if ($res) {
                return $res;
            }
        }
    }
    
    // If no result is found, throw an exception
    throw new Exception("Email address not found");
}

  
 public function getUserByEmailCode($email_address = '', $code = '')
{
    if (!empty($email_address) && !empty($code)) {
        // Prepare the SQL statement with placeholders for the email address and code
        $stmt = "
            SELECT id, merchant_id, user_type, email_address, lost_password_code, password
            FROM mt_view_user_master
            WHERE email_address = :email_address
            AND lost_password_code = :code
            LIMIT 0, 1
        ";
        
        // Prepare the query
        $query = $this->db->prepare($stmt);
        
        // Bind the parameters to the placeholders
        $query->bindParam(':email_address', $email_address, PDO::PARAM_STR);
        $query->bindParam(':code', trim($code), PDO::PARAM_STR);
        
        // Execute the query
        if ($query->execute()) {
            // Fetch the result as an associative array
            $res = $query->fetch(PDO::FETCH_ASSOC);
            
            if ($res) {
                return $res;
            }
        }
    }
    
    // If no result is found, throw an exception
    throw new Exception("Email address not found");
}

public  function udapteLostPasswordCode($user_type='', $merchant_id='', $id='', $code='')
  {
    $params = array(
      'lost_password_code'=>$code,
      'date_modified'=>$this->functions->dateNow(),
      'ip_address'=>$_SERVER['REMOTE_ADDR']
    );
    switch ($user_type) {
      case "merchant":
        

            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', $merchant_id);       
            if($up){
              return true;
            } else throw new Exception( "External server error cannot update code" );
        break;
        
      case "merchant_user":
       
        $up = $this->functions->updateData("mt_merchant_user", $params, 'id', $id); 

            if($up){
              return true;
            } else throw new Exception( "External server error cannot update code" );
        break;
    
      default:
        throw new Exception( "Invalid user type" );
        break;
    }
  }


  public function updateProfile($id = '', $user_type = '', $params = array())
{
    switch ($user_type) {
        case "merchant":
            // Prepare the SQL statement for the merchant case
            $stmt = "
                SELECT count(*) as username,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE email_address = :contact_email
                        AND id != :id
                    ) as email,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE contact_number = :contact_phone
                        AND id != :id
                    ) as phone
                FROM mt_view_user_master
                WHERE username = :username
                AND user_type  IN ('merchant_user', 'merchant')
                AND merchant_id != :id
            ";
            
            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameters
            $query->bindParam(':contact_email', $params['contact_email'], PDO::PARAM_STR);
            $query->bindParam(':contact_phone', $params['contact_phone'], PDO::PARAM_STR);
            $query->bindParam(':username', $params['username'], PDO::PARAM_STR);
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                if ($res['username'] > 0) {
                    throw new Exception("Username already exist");
                }
                if ($res['phone'] > 0) {
                    throw new Exception("Mobile number already exist");
                }
                if ($res['email'] > 0) {
                    throw new Exception("Email address already exist");
                }
            }

            // Update the merchant data
            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', (integer)$id);
            return true;

            break;

        case "merchant_user":
            // Prepare the SQL statement for the merchant_user case
            $stmt = "
                SELECT count(*) as username,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE email_address = :contact_email
                        AND id != :id
                    ) as email,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE contact_number = :contact_number
                        AND id != :id
                    ) as phone
                FROM mt_view_user_master
                WHERE username = :username
                AND user_type  IN ('merchant_user', 'merchant')
                AND id != :id
            ";
            
            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameters
            $query->bindParam(':contact_email', $params['contact_email'], PDO::PARAM_STR);
            $query->bindParam(':contact_number', $params['contact_number'], PDO::PARAM_STR);
            $query->bindParam(':username', $params['username'], PDO::PARAM_STR);
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                if ($res['username'] > 0) {
                    throw new Exception("Username already exist");
                }
                if ($res['phone'] > 0) {
                    throw new Exception("Mobile number already exist");
                }
                if ($res['email'] > 0) {
                    throw new Exception("Email address already exist");
                }
            }

            // Update the merchant_user data
            $up = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', (integer)$id);
            return true;

            break;

        default:
            throw new Exception("Invalid user type");
            break;
    }
}



public function updateProfile_xx($id = '', $user_type = '', $params = array())
{
    switch ($user_type) {
        case "merchant":
            // Prepare the SQL statement for the merchant case
            $stmt = "
                SELECT count(*) as username,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE email_address = :contact_email
                        AND id != :id
                    ) as email,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE contact_number = :contact_phone
                        AND id != :id
                    ) as phone
                FROM mt_view_user_master
                WHERE username = :username
                AND user_type IN ('merchant_user', 'merchant')
                AND merchant_id != :id
            ";
            
            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameters
            $query->bindParam(':contact_email', $params['contact_email'], PDO::PARAM_STR);
            $query->bindParam(':contact_phone', $params['contact_phone'], PDO::PARAM_STR);
            $query->bindParam(':username', $params['username'], PDO::PARAM_STR);
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                if ($res['username'] > 0) {
                    throw new Exception("Username already exist");
                }
                if ($res['phone'] > 0) {
                    throw new Exception("Mobile number already exist");
                }
                if ($res['email'] > 0) {
                    throw new Exception("Email address already exist");
                }
            }

            // Update the merchant data
            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', (integer)$id);
            return true;

            break;

        case "merchant_user":
            // Prepare the SQL statement for the merchant_user case
            $stmt = "
                SELECT count(*) as username,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE email_address = :contact_email
                        AND id != :id
                    ) as email,
                    (
                        SELECT count(*)
                        FROM mt_merchant_user
                        WHERE contact_number = :contact_number
                        AND id != :id
                    ) as phone
                FROM mt_view_user_master
                WHERE username = :username
                AND user_type IN ('merchant_user', 'merchant')
                AND id != :id
            ";
            
            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameters
            $query->bindParam(':contact_email', $params['contact_email'], PDO::PARAM_STR);
            $query->bindParam(':contact_number', $params['contact_number'], PDO::PARAM_STR);
            $query->bindParam(':username', $params['username'], PDO::PARAM_STR);
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                if ($res['username'] > 0) {
                    throw new Exception("Username already exist");
                }
                if ($res['phone'] > 0) {
                    throw new Exception("Mobile number already exist");
                }
                if ($res['email'] > 0) {
                    throw new Exception("Email address already exist");
                }
            }

            // Update the merchant_user data
            $up = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', (integer)$id);
            return true;

            break;

        default:
            throw new Exception("Invalid user type");
            break;
    }
}




public function changePassword($id = '', $user_type = '', $params = array(), $old_password = '')
{
    switch ($user_type) {
        case "merchant":
            // Prepare the SQL statement to fetch the current password for the merchant
            $stmt = "
                SELECT password
                FROM mt_merchant
                WHERE merchant_id = :id
                LIMIT 0, 1
            ";

            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameter
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                // Check if the old password matches
                if ($res['password'] != $old_password) {
                    throw new Exception("Old password is invalid");
                }

                // Check if the new password is the same as the old one
                if ($res['password'] == $params['password']) {
                    throw new Exception("New password cannot be the same as old password");
                }
            }

            // Update the merchant's password
            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', (integer)$id);
            return true;

            break;

        case "merchant_user":
            // Prepare the SQL statement to fetch the current password for the merchant user
            $stmt = "
                SELECT password
                FROM mt_view_user_master
                WHERE id = :id
                AND user_type = 'merchant_user'
                LIMIT 0, 1
            ";

            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameter
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                // Check if the old password matches
                if ($res['password'] != $old_password) {
                    throw new Exception("Old password is invalid");
                }

                // Check if the new password is the same as the old one
                if ($res['password'] == $params['password']) {
                    throw new Exception("New password cannot be the same as old password");
                }
            }

            // Update the merchant user's password
            $up = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', (integer)$id);
            return true;

            break;

        default:
            throw new Exception("Invalid user type");
            break;
    }
}


public function changePin($id = '', $user_type = '', $params = array())
{
    switch ($user_type) {
        case "merchant":
            // Prepare the SQL statement to fetch the current pin for the merchant
            $stmt = "
                SELECT pin
                FROM mt_merchant
                WHERE merchant_id = :id
                LIMIT 0, 1
            ";

            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameter
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                // Set pin to empty if it is 0
                $res['pin'] = $res['pin'] == 0 ? '' : $res['pin'];

                // Check if the new pin is the same as the old one
                if ((string)$res['pin'] == (string)$params['pin']) {
                    throw new Exception("New pin cannot be the same as old pin");
                }
            }

            // Update the merchant's pin
            $up = $this->functions->updateData("mt_merchant", $params, 'merchant_id', (integer)$id);
            return true;

            break;

        case "merchant_user":
            // Prepare the SQL statement to fetch the current pin for the merchant user
            $stmt = "
                SELECT pin
                FROM mt_merchant_user
                WHERE merchant_user_id = :id
                LIMIT 0, 1
            ";

            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind the parameter
            $query->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the query
            if ($query->execute()) {
                // Fetch the result as an associative array
                $res = $query->fetch(PDO::FETCH_ASSOC);

                // Set pin to empty if it is 0
                $res['pin'] = $res['pin'] == 0 ? '' : $res['pin'];

                // Check if the new pin is the same as the old one
                if ((string)$res['pin'] == (string)$params['pin']) {
                    throw new Exception("New pin cannot be the same as old pin");
                }
            }

            // Update the merchant user's pin
            $up = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', (integer)$id);
            return true;

            break;

        default:
            throw new Exception("Invalid user type");
            break;
    }
}


public function getPin($token = '')
{
    // Prepare the SQL statement to select the pin
    $stmt = "
        SELECT pin
        FROM mt_view_user_master
        WHERE session_token = :session_token
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameter for session_token
    $query->bindParam(':session_token', $token, PDO::PARAM_STR);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result as an associative array
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        // If the pin is found, return the result
        if ($resp) {
            return $resp;
        }
    }

    // Throw an exception if pin not found
    throw new Exception("Pin not found");
}

  
  public function RegisteredDevice($device_uiid = '', $params = array())
{
    if (empty($device_uiid)) {
        return false;
    }

    // Prepare the SQL statement to check if the device is registered
    $stmt = "
        SELECT device_uiid
        FROM mt_merchantapp_device_reg
        WHERE device_uiid = :device_uiid
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameter for device_uiid
    $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Check if the device is found
    if ($query->rowCount() > 0) {
        unset($params['date_created']);

        // Update the device registration details
        $this->functions->updateData("mt_merchantapp_device_reg", $params, 'device_uiid', $device_uiid);

        // Retrieve updated device information
        $resp = self::GetDeviceInformation($device_uiid);
        return $resp;
    } else {
        unset($params['date_modified']);

        // Insert a new device registration
        $this->functions->insertData('mt_merchantapp_device_reg', $params);

        // Return default values if device is not found
        return array(
            'push_enabled' => 1,
            'subscribe_topic' => 1
        );
    }
}


public  function UpdateDeviceStatus($device_uiid='', $status='active')
  {
    if(empty($device_uiid)){
      return false;
    }
            
      

     $params = array(
                'status'=>$status,
     'date_modified'=>$this->functions->dateNow(),
     'ip_address'=>$_SERVER['REMOTE_ADDR']
            );


    $this->functions->updateData("mt_merchantapp_device_reg", $params, 'device_uiid', $device_uiid);



  }
  
  public  function UpdateDevice($device_uiid='', $params=array())
  {
    if(empty($device_uiid)){
      return false;
    }
            
   

    $up = $this->functions->updateData("mt_merchantapp_device_reg", $params, 'device_uiid', $device_uiid);


        if($up){
          return true;
        }
        throw new Exception( "failed cannot update." ); 
  }


  public function GetDeviceInformation($device_uiid = '')
{
    if (!empty($device_uiid)) {
        // Prepare the SQL statement to fetch device information
        $stmt = "
            SELECT registration_id, merchant_id, push_enabled, subscribe_topic
            FROM mt_merchantapp_device_reg
            WHERE device_uiid = :device_uiid
            LIMIT 1
        ";

        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the parameter for device_uiid
        $query->bindParam(':device_uiid', $device_uiid, PDO::PARAM_STR);

        // Execute the query
        $query->execute();

        // Fetch the result
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        // Check if device information was found
        if ($resp) {
            return $resp;
        }
    }

    // If device information is not found, throw an exception
    throw new Exception("Device information not found");
}

  
public function generatePin($id = '', $merchant_id = '')
{
    $pin = $this->functions->generateRandomKey(3);

    // Prepare the SQL statement to check if the generated pin exists
    $stmt = "
        SELECT pin FROM mt_view_user_master
        WHERE id = :id
        AND merchant_id = :merchant_id
        AND pin = :pin
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':pin', $pin, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Check if the generated pin already exists
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $this->generatePin($id, $merchant_id); // Recursively generate a new pin
    }

    // Return the unique pin
    return $pin;
}

  
 public function getDeviceByID($id = '')
{
    // Prepare the SQL statement to fetch device information by registration ID
    $stmt = "
        SELECT * 
        FROM mt_view_merchantapp_device
        WHERE registration_id = :id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':id', $id, PDO::PARAM_STR); // Assuming $id is a string (change to PDO::PARAM_INT if it's an integer)

    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    // Return false if no result is found
    return false;
}



  



    










    
      
}
/*END CLASS*/